// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/historyservice/v1/request_response.proto

package historyservice

import (
	bytes "bytes"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	v14 "go.temporal.io/api/common/v1"
	v12 "go.temporal.io/api/enums/v1"
	v13 "go.temporal.io/api/failure/v1"
	v19 "go.temporal.io/api/history/v1"
	v18 "go.temporal.io/api/query/v1"
	v15 "go.temporal.io/api/taskqueue/v1"
	v110 "go.temporal.io/api/workflow/v1"
	v1 "go.temporal.io/api/workflowservice/v1"
	v114 "go.temporal.io/server/api/adminservice/v1"
	v16 "go.temporal.io/server/api/enums/v1"
	v17 "go.temporal.io/server/api/history/v1"
	v112 "go.temporal.io/server/api/namespace/v1"
	v111 "go.temporal.io/server/api/persistence/v1"
	v113 "go.temporal.io/server/api/replication/v1"
	v11 "go.temporal.io/server/api/workflow/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type StartWorkflowExecutionRequest struct {
	NamespaceId                     string                            `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	StartRequest                    *v1.StartWorkflowExecutionRequest `protobuf:"bytes,2,opt,name=start_request,json=startRequest,proto3" json:"start_request,omitempty"`
	ParentExecutionInfo             *v11.ParentExecutionInfo          `protobuf:"bytes,3,opt,name=parent_execution_info,json=parentExecutionInfo,proto3" json:"parent_execution_info,omitempty"`
	Attempt                         int32                             `protobuf:"varint,4,opt,name=attempt,proto3" json:"attempt,omitempty"`
	WorkflowExecutionExpirationTime *time.Time                        `protobuf:"bytes,5,opt,name=workflow_execution_expiration_time,json=workflowExecutionExpirationTime,proto3,stdtime" json:"workflow_execution_expiration_time,omitempty"`
	ContinueAsNewInitiator          v12.ContinueAsNewInitiator        `protobuf:"varint,6,opt,name=continue_as_new_initiator,json=continueAsNewInitiator,proto3,enum=temporal.api.enums.v1.ContinueAsNewInitiator" json:"continue_as_new_initiator,omitempty"`
	ContinuedFailure                *v13.Failure                      `protobuf:"bytes,7,opt,name=continued_failure,json=continuedFailure,proto3" json:"continued_failure,omitempty"`
	LastCompletionResult            *v14.Payloads                     `protobuf:"bytes,8,opt,name=last_completion_result,json=lastCompletionResult,proto3" json:"last_completion_result,omitempty"`
	FirstWorkflowTaskBackoff        *time.Duration                    `protobuf:"bytes,9,opt,name=first_workflow_task_backoff,json=firstWorkflowTaskBackoff,proto3,stdduration" json:"first_workflow_task_backoff,omitempty"`
}

func (m *StartWorkflowExecutionRequest) Reset()      { *m = StartWorkflowExecutionRequest{} }
func (*StartWorkflowExecutionRequest) ProtoMessage() {}
func (*StartWorkflowExecutionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{0}
}
func (m *StartWorkflowExecutionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StartWorkflowExecutionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StartWorkflowExecutionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StartWorkflowExecutionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartWorkflowExecutionRequest.Merge(m, src)
}
func (m *StartWorkflowExecutionRequest) XXX_Size() int {
	return m.Size()
}
func (m *StartWorkflowExecutionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartWorkflowExecutionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartWorkflowExecutionRequest proto.InternalMessageInfo

func (m *StartWorkflowExecutionRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *StartWorkflowExecutionRequest) GetStartRequest() *v1.StartWorkflowExecutionRequest {
	if m != nil {
		return m.StartRequest
	}
	return nil
}

func (m *StartWorkflowExecutionRequest) GetParentExecutionInfo() *v11.ParentExecutionInfo {
	if m != nil {
		return m.ParentExecutionInfo
	}
	return nil
}

func (m *StartWorkflowExecutionRequest) GetAttempt() int32 {
	if m != nil {
		return m.Attempt
	}
	return 0
}

func (m *StartWorkflowExecutionRequest) GetWorkflowExecutionExpirationTime() *time.Time {
	if m != nil {
		return m.WorkflowExecutionExpirationTime
	}
	return nil
}

func (m *StartWorkflowExecutionRequest) GetContinueAsNewInitiator() v12.ContinueAsNewInitiator {
	if m != nil {
		return m.ContinueAsNewInitiator
	}
	return v12.CONTINUE_AS_NEW_INITIATOR_UNSPECIFIED
}

func (m *StartWorkflowExecutionRequest) GetContinuedFailure() *v13.Failure {
	if m != nil {
		return m.ContinuedFailure
	}
	return nil
}

func (m *StartWorkflowExecutionRequest) GetLastCompletionResult() *v14.Payloads {
	if m != nil {
		return m.LastCompletionResult
	}
	return nil
}

func (m *StartWorkflowExecutionRequest) GetFirstWorkflowTaskBackoff() *time.Duration {
	if m != nil {
		return m.FirstWorkflowTaskBackoff
	}
	return nil
}

type StartWorkflowExecutionResponse struct {
	RunId string `protobuf:"bytes,1,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
}

func (m *StartWorkflowExecutionResponse) Reset()      { *m = StartWorkflowExecutionResponse{} }
func (*StartWorkflowExecutionResponse) ProtoMessage() {}
func (*StartWorkflowExecutionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{1}
}
func (m *StartWorkflowExecutionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StartWorkflowExecutionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StartWorkflowExecutionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StartWorkflowExecutionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartWorkflowExecutionResponse.Merge(m, src)
}
func (m *StartWorkflowExecutionResponse) XXX_Size() int {
	return m.Size()
}
func (m *StartWorkflowExecutionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StartWorkflowExecutionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StartWorkflowExecutionResponse proto.InternalMessageInfo

func (m *StartWorkflowExecutionResponse) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

type GetMutableStateRequest struct {
	NamespaceId         string                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	Execution           *v14.WorkflowExecution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
	ExpectedNextEventId int64                  `protobuf:"varint,3,opt,name=expected_next_event_id,json=expectedNextEventId,proto3" json:"expected_next_event_id,omitempty"`
	CurrentBranchToken  []byte                 `protobuf:"bytes,4,opt,name=current_branch_token,json=currentBranchToken,proto3" json:"current_branch_token,omitempty"`
}

func (m *GetMutableStateRequest) Reset()      { *m = GetMutableStateRequest{} }
func (*GetMutableStateRequest) ProtoMessage() {}
func (*GetMutableStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{2}
}
func (m *GetMutableStateRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetMutableStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetMutableStateRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetMutableStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMutableStateRequest.Merge(m, src)
}
func (m *GetMutableStateRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetMutableStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMutableStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetMutableStateRequest proto.InternalMessageInfo

func (m *GetMutableStateRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *GetMutableStateRequest) GetExecution() *v14.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

func (m *GetMutableStateRequest) GetExpectedNextEventId() int64 {
	if m != nil {
		return m.ExpectedNextEventId
	}
	return 0
}

func (m *GetMutableStateRequest) GetCurrentBranchToken() []byte {
	if m != nil {
		return m.CurrentBranchToken
	}
	return nil
}

type GetMutableStateResponse struct {
	Execution              *v14.WorkflowExecution `protobuf:"bytes,1,opt,name=execution,proto3" json:"execution,omitempty"`
	WorkflowType           *v14.WorkflowType      `protobuf:"bytes,2,opt,name=workflow_type,json=workflowType,proto3" json:"workflow_type,omitempty"`
	NextEventId            int64                  `protobuf:"varint,3,opt,name=next_event_id,json=nextEventId,proto3" json:"next_event_id,omitempty"`
	PreviousStartedEventId int64                  `protobuf:"varint,4,opt,name=previous_started_event_id,json=previousStartedEventId,proto3" json:"previous_started_event_id,omitempty"`
	LastFirstEventId       int64                  `protobuf:"varint,5,opt,name=last_first_event_id,json=lastFirstEventId,proto3" json:"last_first_event_id,omitempty"`
	TaskQueue              *v15.TaskQueue         `protobuf:"bytes,6,opt,name=task_queue,json=taskQueue,proto3" json:"task_queue,omitempty"`
	StickyTaskQueue        *v15.TaskQueue         `protobuf:"bytes,7,opt,name=sticky_task_queue,json=stickyTaskQueue,proto3" json:"sticky_task_queue,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "to" is used to indicate interval. --)
	StickyTaskQueueScheduleToStartTimeout *time.Duration              `protobuf:"bytes,11,opt,name=sticky_task_queue_schedule_to_start_timeout,json=stickyTaskQueueScheduleToStartTimeout,proto3,stdduration" json:"sticky_task_queue_schedule_to_start_timeout,omitempty"`
	CurrentBranchToken                    []byte                      `protobuf:"bytes,13,opt,name=current_branch_token,json=currentBranchToken,proto3" json:"current_branch_token,omitempty"`
	WorkflowState                         v16.WorkflowExecutionState  `protobuf:"varint,15,opt,name=workflow_state,json=workflowState,proto3,enum=temporal.server.api.enums.v1.WorkflowExecutionState" json:"workflow_state,omitempty"`
	WorkflowStatus                        v12.WorkflowExecutionStatus `protobuf:"varint,16,opt,name=workflow_status,json=workflowStatus,proto3,enum=temporal.api.enums.v1.WorkflowExecutionStatus" json:"workflow_status,omitempty"`
	VersionHistories                      *v17.VersionHistories       `protobuf:"bytes,17,opt,name=version_histories,json=versionHistories,proto3" json:"version_histories,omitempty"`
	IsStickyTaskQueueEnabled              bool                        `protobuf:"varint,18,opt,name=is_sticky_task_queue_enabled,json=isStickyTaskQueueEnabled,proto3" json:"is_sticky_task_queue_enabled,omitempty"`
}

func (m *GetMutableStateResponse) Reset()      { *m = GetMutableStateResponse{} }
func (*GetMutableStateResponse) ProtoMessage() {}
func (*GetMutableStateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{3}
}
func (m *GetMutableStateResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetMutableStateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetMutableStateResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetMutableStateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMutableStateResponse.Merge(m, src)
}
func (m *GetMutableStateResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetMutableStateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMutableStateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetMutableStateResponse proto.InternalMessageInfo

func (m *GetMutableStateResponse) GetExecution() *v14.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

func (m *GetMutableStateResponse) GetWorkflowType() *v14.WorkflowType {
	if m != nil {
		return m.WorkflowType
	}
	return nil
}

func (m *GetMutableStateResponse) GetNextEventId() int64 {
	if m != nil {
		return m.NextEventId
	}
	return 0
}

func (m *GetMutableStateResponse) GetPreviousStartedEventId() int64 {
	if m != nil {
		return m.PreviousStartedEventId
	}
	return 0
}

func (m *GetMutableStateResponse) GetLastFirstEventId() int64 {
	if m != nil {
		return m.LastFirstEventId
	}
	return 0
}

func (m *GetMutableStateResponse) GetTaskQueue() *v15.TaskQueue {
	if m != nil {
		return m.TaskQueue
	}
	return nil
}

func (m *GetMutableStateResponse) GetStickyTaskQueue() *v15.TaskQueue {
	if m != nil {
		return m.StickyTaskQueue
	}
	return nil
}

func (m *GetMutableStateResponse) GetStickyTaskQueueScheduleToStartTimeout() *time.Duration {
	if m != nil {
		return m.StickyTaskQueueScheduleToStartTimeout
	}
	return nil
}

func (m *GetMutableStateResponse) GetCurrentBranchToken() []byte {
	if m != nil {
		return m.CurrentBranchToken
	}
	return nil
}

func (m *GetMutableStateResponse) GetWorkflowState() v16.WorkflowExecutionState {
	if m != nil {
		return m.WorkflowState
	}
	return v16.WORKFLOW_EXECUTION_STATE_UNSPECIFIED
}

func (m *GetMutableStateResponse) GetWorkflowStatus() v12.WorkflowExecutionStatus {
	if m != nil {
		return m.WorkflowStatus
	}
	return v12.WORKFLOW_EXECUTION_STATUS_UNSPECIFIED
}

func (m *GetMutableStateResponse) GetVersionHistories() *v17.VersionHistories {
	if m != nil {
		return m.VersionHistories
	}
	return nil
}

func (m *GetMutableStateResponse) GetIsStickyTaskQueueEnabled() bool {
	if m != nil {
		return m.IsStickyTaskQueueEnabled
	}
	return false
}

type PollMutableStateRequest struct {
	NamespaceId         string                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	Execution           *v14.WorkflowExecution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
	ExpectedNextEventId int64                  `protobuf:"varint,3,opt,name=expected_next_event_id,json=expectedNextEventId,proto3" json:"expected_next_event_id,omitempty"`
	CurrentBranchToken  []byte                 `protobuf:"bytes,4,opt,name=current_branch_token,json=currentBranchToken,proto3" json:"current_branch_token,omitempty"`
}

func (m *PollMutableStateRequest) Reset()      { *m = PollMutableStateRequest{} }
func (*PollMutableStateRequest) ProtoMessage() {}
func (*PollMutableStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{4}
}
func (m *PollMutableStateRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PollMutableStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PollMutableStateRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PollMutableStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PollMutableStateRequest.Merge(m, src)
}
func (m *PollMutableStateRequest) XXX_Size() int {
	return m.Size()
}
func (m *PollMutableStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PollMutableStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PollMutableStateRequest proto.InternalMessageInfo

func (m *PollMutableStateRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *PollMutableStateRequest) GetExecution() *v14.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

func (m *PollMutableStateRequest) GetExpectedNextEventId() int64 {
	if m != nil {
		return m.ExpectedNextEventId
	}
	return 0
}

func (m *PollMutableStateRequest) GetCurrentBranchToken() []byte {
	if m != nil {
		return m.CurrentBranchToken
	}
	return nil
}

type PollMutableStateResponse struct {
	Execution              *v14.WorkflowExecution `protobuf:"bytes,1,opt,name=execution,proto3" json:"execution,omitempty"`
	WorkflowType           *v14.WorkflowType      `protobuf:"bytes,2,opt,name=workflow_type,json=workflowType,proto3" json:"workflow_type,omitempty"`
	NextEventId            int64                  `protobuf:"varint,3,opt,name=next_event_id,json=nextEventId,proto3" json:"next_event_id,omitempty"`
	PreviousStartedEventId int64                  `protobuf:"varint,4,opt,name=previous_started_event_id,json=previousStartedEventId,proto3" json:"previous_started_event_id,omitempty"`
	LastFirstEventId       int64                  `protobuf:"varint,5,opt,name=last_first_event_id,json=lastFirstEventId,proto3" json:"last_first_event_id,omitempty"`
	TaskQueue              *v15.TaskQueue         `protobuf:"bytes,6,opt,name=task_queue,json=taskQueue,proto3" json:"task_queue,omitempty"`
	StickyTaskQueue        *v15.TaskQueue         `protobuf:"bytes,7,opt,name=sticky_task_queue,json=stickyTaskQueue,proto3" json:"sticky_task_queue,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "to" is used to indicate interval. --)
	StickyTaskQueueScheduleToStartTimeout *time.Duration              `protobuf:"bytes,11,opt,name=sticky_task_queue_schedule_to_start_timeout,json=stickyTaskQueueScheduleToStartTimeout,proto3,stdduration" json:"sticky_task_queue_schedule_to_start_timeout,omitempty"`
	CurrentBranchToken                    []byte                      `protobuf:"bytes,12,opt,name=current_branch_token,json=currentBranchToken,proto3" json:"current_branch_token,omitempty"`
	VersionHistories                      *v17.VersionHistories       `protobuf:"bytes,14,opt,name=version_histories,json=versionHistories,proto3" json:"version_histories,omitempty"`
	WorkflowState                         v16.WorkflowExecutionState  `protobuf:"varint,15,opt,name=workflow_state,json=workflowState,proto3,enum=temporal.server.api.enums.v1.WorkflowExecutionState" json:"workflow_state,omitempty"`
	WorkflowStatus                        v12.WorkflowExecutionStatus `protobuf:"varint,16,opt,name=workflow_status,json=workflowStatus,proto3,enum=temporal.api.enums.v1.WorkflowExecutionStatus" json:"workflow_status,omitempty"`
}

func (m *PollMutableStateResponse) Reset()      { *m = PollMutableStateResponse{} }
func (*PollMutableStateResponse) ProtoMessage() {}
func (*PollMutableStateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{5}
}
func (m *PollMutableStateResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PollMutableStateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PollMutableStateResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PollMutableStateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PollMutableStateResponse.Merge(m, src)
}
func (m *PollMutableStateResponse) XXX_Size() int {
	return m.Size()
}
func (m *PollMutableStateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PollMutableStateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PollMutableStateResponse proto.InternalMessageInfo

func (m *PollMutableStateResponse) GetExecution() *v14.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

func (m *PollMutableStateResponse) GetWorkflowType() *v14.WorkflowType {
	if m != nil {
		return m.WorkflowType
	}
	return nil
}

func (m *PollMutableStateResponse) GetNextEventId() int64 {
	if m != nil {
		return m.NextEventId
	}
	return 0
}

func (m *PollMutableStateResponse) GetPreviousStartedEventId() int64 {
	if m != nil {
		return m.PreviousStartedEventId
	}
	return 0
}

func (m *PollMutableStateResponse) GetLastFirstEventId() int64 {
	if m != nil {
		return m.LastFirstEventId
	}
	return 0
}

func (m *PollMutableStateResponse) GetTaskQueue() *v15.TaskQueue {
	if m != nil {
		return m.TaskQueue
	}
	return nil
}

func (m *PollMutableStateResponse) GetStickyTaskQueue() *v15.TaskQueue {
	if m != nil {
		return m.StickyTaskQueue
	}
	return nil
}

func (m *PollMutableStateResponse) GetStickyTaskQueueScheduleToStartTimeout() *time.Duration {
	if m != nil {
		return m.StickyTaskQueueScheduleToStartTimeout
	}
	return nil
}

func (m *PollMutableStateResponse) GetCurrentBranchToken() []byte {
	if m != nil {
		return m.CurrentBranchToken
	}
	return nil
}

func (m *PollMutableStateResponse) GetVersionHistories() *v17.VersionHistories {
	if m != nil {
		return m.VersionHistories
	}
	return nil
}

func (m *PollMutableStateResponse) GetWorkflowState() v16.WorkflowExecutionState {
	if m != nil {
		return m.WorkflowState
	}
	return v16.WORKFLOW_EXECUTION_STATE_UNSPECIFIED
}

func (m *PollMutableStateResponse) GetWorkflowStatus() v12.WorkflowExecutionStatus {
	if m != nil {
		return m.WorkflowStatus
	}
	return v12.WORKFLOW_EXECUTION_STATUS_UNSPECIFIED
}

type ResetStickyTaskQueueRequest struct {
	NamespaceId string                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	Execution   *v14.WorkflowExecution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
}

func (m *ResetStickyTaskQueueRequest) Reset()      { *m = ResetStickyTaskQueueRequest{} }
func (*ResetStickyTaskQueueRequest) ProtoMessage() {}
func (*ResetStickyTaskQueueRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{6}
}
func (m *ResetStickyTaskQueueRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResetStickyTaskQueueRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResetStickyTaskQueueRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResetStickyTaskQueueRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResetStickyTaskQueueRequest.Merge(m, src)
}
func (m *ResetStickyTaskQueueRequest) XXX_Size() int {
	return m.Size()
}
func (m *ResetStickyTaskQueueRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResetStickyTaskQueueRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResetStickyTaskQueueRequest proto.InternalMessageInfo

func (m *ResetStickyTaskQueueRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *ResetStickyTaskQueueRequest) GetExecution() *v14.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

type ResetStickyTaskQueueResponse struct {
}

func (m *ResetStickyTaskQueueResponse) Reset()      { *m = ResetStickyTaskQueueResponse{} }
func (*ResetStickyTaskQueueResponse) ProtoMessage() {}
func (*ResetStickyTaskQueueResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{7}
}
func (m *ResetStickyTaskQueueResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResetStickyTaskQueueResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResetStickyTaskQueueResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResetStickyTaskQueueResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResetStickyTaskQueueResponse.Merge(m, src)
}
func (m *ResetStickyTaskQueueResponse) XXX_Size() int {
	return m.Size()
}
func (m *ResetStickyTaskQueueResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ResetStickyTaskQueueResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ResetStickyTaskQueueResponse proto.InternalMessageInfo

type RecordWorkflowTaskStartedRequest struct {
	NamespaceId       string                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowExecution *v14.WorkflowExecution `protobuf:"bytes,2,opt,name=workflow_execution,json=workflowExecution,proto3" json:"workflow_execution,omitempty"`
	ScheduleId        int64                  `protobuf:"varint,3,opt,name=schedule_id,json=scheduleId,proto3" json:"schedule_id,omitempty"`
	TaskId            int64                  `protobuf:"varint,4,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Unique id of each poll request. Used to ensure at most once delivery of tasks.
	RequestId   string                           `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	PollRequest *v1.PollWorkflowTaskQueueRequest `protobuf:"bytes,6,opt,name=poll_request,json=pollRequest,proto3" json:"poll_request,omitempty"`
}

func (m *RecordWorkflowTaskStartedRequest) Reset()      { *m = RecordWorkflowTaskStartedRequest{} }
func (*RecordWorkflowTaskStartedRequest) ProtoMessage() {}
func (*RecordWorkflowTaskStartedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{8}
}
func (m *RecordWorkflowTaskStartedRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RecordWorkflowTaskStartedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RecordWorkflowTaskStartedRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RecordWorkflowTaskStartedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecordWorkflowTaskStartedRequest.Merge(m, src)
}
func (m *RecordWorkflowTaskStartedRequest) XXX_Size() int {
	return m.Size()
}
func (m *RecordWorkflowTaskStartedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RecordWorkflowTaskStartedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RecordWorkflowTaskStartedRequest proto.InternalMessageInfo

func (m *RecordWorkflowTaskStartedRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *RecordWorkflowTaskStartedRequest) GetWorkflowExecution() *v14.WorkflowExecution {
	if m != nil {
		return m.WorkflowExecution
	}
	return nil
}

func (m *RecordWorkflowTaskStartedRequest) GetScheduleId() int64 {
	if m != nil {
		return m.ScheduleId
	}
	return 0
}

func (m *RecordWorkflowTaskStartedRequest) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *RecordWorkflowTaskStartedRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *RecordWorkflowTaskStartedRequest) GetPollRequest() *v1.PollWorkflowTaskQueueRequest {
	if m != nil {
		return m.PollRequest
	}
	return nil
}

type RecordWorkflowTaskStartedResponse struct {
	WorkflowType               *v14.WorkflowType              `protobuf:"bytes,1,opt,name=workflow_type,json=workflowType,proto3" json:"workflow_type,omitempty"`
	PreviousStartedEventId     int64                          `protobuf:"varint,2,opt,name=previous_started_event_id,json=previousStartedEventId,proto3" json:"previous_started_event_id,omitempty"`
	ScheduledEventId           int64                          `protobuf:"varint,3,opt,name=scheduled_event_id,json=scheduledEventId,proto3" json:"scheduled_event_id,omitempty"`
	StartedEventId             int64                          `protobuf:"varint,4,opt,name=started_event_id,json=startedEventId,proto3" json:"started_event_id,omitempty"`
	NextEventId                int64                          `protobuf:"varint,5,opt,name=next_event_id,json=nextEventId,proto3" json:"next_event_id,omitempty"`
	Attempt                    int32                          `protobuf:"varint,6,opt,name=attempt,proto3" json:"attempt,omitempty"`
	StickyExecutionEnabled     bool                           `protobuf:"varint,7,opt,name=sticky_execution_enabled,json=stickyExecutionEnabled,proto3" json:"sticky_execution_enabled,omitempty"`
	WorkflowTaskInfo           *v17.TransientWorkflowTaskInfo `protobuf:"bytes,8,opt,name=workflow_task_info,json=workflowTaskInfo,proto3" json:"workflow_task_info,omitempty"`
	WorkflowExecutionTaskQueue *v15.TaskQueue                 `protobuf:"bytes,9,opt,name=workflow_execution_task_queue,json=workflowExecutionTaskQueue,proto3" json:"workflow_execution_task_queue,omitempty"`
	BranchToken                []byte                         `protobuf:"bytes,11,opt,name=branch_token,json=branchToken,proto3" json:"branch_token,omitempty"`
	ScheduledTime              *time.Time                     `protobuf:"bytes,12,opt,name=scheduled_time,json=scheduledTime,proto3,stdtime" json:"scheduled_time,omitempty"`
	StartedTime                *time.Time                     `protobuf:"bytes,13,opt,name=started_time,json=startedTime,proto3,stdtime" json:"started_time,omitempty"`
	Queries                    map[string]*v18.WorkflowQuery  `protobuf:"bytes,14,rep,name=queries,proto3" json:"queries,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *RecordWorkflowTaskStartedResponse) Reset()      { *m = RecordWorkflowTaskStartedResponse{} }
func (*RecordWorkflowTaskStartedResponse) ProtoMessage() {}
func (*RecordWorkflowTaskStartedResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{9}
}
func (m *RecordWorkflowTaskStartedResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RecordWorkflowTaskStartedResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RecordWorkflowTaskStartedResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RecordWorkflowTaskStartedResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecordWorkflowTaskStartedResponse.Merge(m, src)
}
func (m *RecordWorkflowTaskStartedResponse) XXX_Size() int {
	return m.Size()
}
func (m *RecordWorkflowTaskStartedResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RecordWorkflowTaskStartedResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RecordWorkflowTaskStartedResponse proto.InternalMessageInfo

func (m *RecordWorkflowTaskStartedResponse) GetWorkflowType() *v14.WorkflowType {
	if m != nil {
		return m.WorkflowType
	}
	return nil
}

func (m *RecordWorkflowTaskStartedResponse) GetPreviousStartedEventId() int64 {
	if m != nil {
		return m.PreviousStartedEventId
	}
	return 0
}

func (m *RecordWorkflowTaskStartedResponse) GetScheduledEventId() int64 {
	if m != nil {
		return m.ScheduledEventId
	}
	return 0
}

func (m *RecordWorkflowTaskStartedResponse) GetStartedEventId() int64 {
	if m != nil {
		return m.StartedEventId
	}
	return 0
}

func (m *RecordWorkflowTaskStartedResponse) GetNextEventId() int64 {
	if m != nil {
		return m.NextEventId
	}
	return 0
}

func (m *RecordWorkflowTaskStartedResponse) GetAttempt() int32 {
	if m != nil {
		return m.Attempt
	}
	return 0
}

func (m *RecordWorkflowTaskStartedResponse) GetStickyExecutionEnabled() bool {
	if m != nil {
		return m.StickyExecutionEnabled
	}
	return false
}

func (m *RecordWorkflowTaskStartedResponse) GetWorkflowTaskInfo() *v17.TransientWorkflowTaskInfo {
	if m != nil {
		return m.WorkflowTaskInfo
	}
	return nil
}

func (m *RecordWorkflowTaskStartedResponse) GetWorkflowExecutionTaskQueue() *v15.TaskQueue {
	if m != nil {
		return m.WorkflowExecutionTaskQueue
	}
	return nil
}

func (m *RecordWorkflowTaskStartedResponse) GetBranchToken() []byte {
	if m != nil {
		return m.BranchToken
	}
	return nil
}

func (m *RecordWorkflowTaskStartedResponse) GetScheduledTime() *time.Time {
	if m != nil {
		return m.ScheduledTime
	}
	return nil
}

func (m *RecordWorkflowTaskStartedResponse) GetStartedTime() *time.Time {
	if m != nil {
		return m.StartedTime
	}
	return nil
}

func (m *RecordWorkflowTaskStartedResponse) GetQueries() map[string]*v18.WorkflowQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

type RecordActivityTaskStartedRequest struct {
	NamespaceId       string                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowExecution *v14.WorkflowExecution `protobuf:"bytes,2,opt,name=workflow_execution,json=workflowExecution,proto3" json:"workflow_execution,omitempty"`
	ScheduleId        int64                  `protobuf:"varint,3,opt,name=schedule_id,json=scheduleId,proto3" json:"schedule_id,omitempty"`
	TaskId            int64                  `protobuf:"varint,4,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Unique id of each poll request. Used to ensure at most once delivery of tasks.
	RequestId   string                           `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	PollRequest *v1.PollActivityTaskQueueRequest `protobuf:"bytes,6,opt,name=poll_request,json=pollRequest,proto3" json:"poll_request,omitempty"`
}

func (m *RecordActivityTaskStartedRequest) Reset()      { *m = RecordActivityTaskStartedRequest{} }
func (*RecordActivityTaskStartedRequest) ProtoMessage() {}
func (*RecordActivityTaskStartedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{10}
}
func (m *RecordActivityTaskStartedRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RecordActivityTaskStartedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RecordActivityTaskStartedRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RecordActivityTaskStartedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecordActivityTaskStartedRequest.Merge(m, src)
}
func (m *RecordActivityTaskStartedRequest) XXX_Size() int {
	return m.Size()
}
func (m *RecordActivityTaskStartedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RecordActivityTaskStartedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RecordActivityTaskStartedRequest proto.InternalMessageInfo

func (m *RecordActivityTaskStartedRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *RecordActivityTaskStartedRequest) GetWorkflowExecution() *v14.WorkflowExecution {
	if m != nil {
		return m.WorkflowExecution
	}
	return nil
}

func (m *RecordActivityTaskStartedRequest) GetScheduleId() int64 {
	if m != nil {
		return m.ScheduleId
	}
	return 0
}

func (m *RecordActivityTaskStartedRequest) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *RecordActivityTaskStartedRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *RecordActivityTaskStartedRequest) GetPollRequest() *v1.PollActivityTaskQueueRequest {
	if m != nil {
		return m.PollRequest
	}
	return nil
}

type RecordActivityTaskStartedResponse struct {
	ScheduledEvent              *v19.HistoryEvent `protobuf:"bytes,1,opt,name=scheduled_event,json=scheduledEvent,proto3" json:"scheduled_event,omitempty"`
	StartedTime                 *time.Time        `protobuf:"bytes,2,opt,name=started_time,json=startedTime,proto3,stdtime" json:"started_time,omitempty"`
	Attempt                     int32             `protobuf:"varint,3,opt,name=attempt,proto3" json:"attempt,omitempty"`
	CurrentAttemptScheduledTime *time.Time        `protobuf:"bytes,4,opt,name=current_attempt_scheduled_time,json=currentAttemptScheduledTime,proto3,stdtime" json:"current_attempt_scheduled_time,omitempty"`
	HeartbeatDetails            *v14.Payloads     `protobuf:"bytes,5,opt,name=heartbeat_details,json=heartbeatDetails,proto3" json:"heartbeat_details,omitempty"`
	WorkflowType                *v14.WorkflowType `protobuf:"bytes,6,opt,name=workflow_type,json=workflowType,proto3" json:"workflow_type,omitempty"`
	WorkflowNamespace           string            `protobuf:"bytes,7,opt,name=workflow_namespace,json=workflowNamespace,proto3" json:"workflow_namespace,omitempty"`
}

func (m *RecordActivityTaskStartedResponse) Reset()      { *m = RecordActivityTaskStartedResponse{} }
func (*RecordActivityTaskStartedResponse) ProtoMessage() {}
func (*RecordActivityTaskStartedResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{11}
}
func (m *RecordActivityTaskStartedResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RecordActivityTaskStartedResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RecordActivityTaskStartedResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RecordActivityTaskStartedResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecordActivityTaskStartedResponse.Merge(m, src)
}
func (m *RecordActivityTaskStartedResponse) XXX_Size() int {
	return m.Size()
}
func (m *RecordActivityTaskStartedResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RecordActivityTaskStartedResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RecordActivityTaskStartedResponse proto.InternalMessageInfo

func (m *RecordActivityTaskStartedResponse) GetScheduledEvent() *v19.HistoryEvent {
	if m != nil {
		return m.ScheduledEvent
	}
	return nil
}

func (m *RecordActivityTaskStartedResponse) GetStartedTime() *time.Time {
	if m != nil {
		return m.StartedTime
	}
	return nil
}

func (m *RecordActivityTaskStartedResponse) GetAttempt() int32 {
	if m != nil {
		return m.Attempt
	}
	return 0
}

func (m *RecordActivityTaskStartedResponse) GetCurrentAttemptScheduledTime() *time.Time {
	if m != nil {
		return m.CurrentAttemptScheduledTime
	}
	return nil
}

func (m *RecordActivityTaskStartedResponse) GetHeartbeatDetails() *v14.Payloads {
	if m != nil {
		return m.HeartbeatDetails
	}
	return nil
}

func (m *RecordActivityTaskStartedResponse) GetWorkflowType() *v14.WorkflowType {
	if m != nil {
		return m.WorkflowType
	}
	return nil
}

func (m *RecordActivityTaskStartedResponse) GetWorkflowNamespace() string {
	if m != nil {
		return m.WorkflowNamespace
	}
	return ""
}

type RespondWorkflowTaskCompletedRequest struct {
	NamespaceId     string                                  `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	CompleteRequest *v1.RespondWorkflowTaskCompletedRequest `protobuf:"bytes,2,opt,name=complete_request,json=completeRequest,proto3" json:"complete_request,omitempty"`
}

func (m *RespondWorkflowTaskCompletedRequest) Reset()      { *m = RespondWorkflowTaskCompletedRequest{} }
func (*RespondWorkflowTaskCompletedRequest) ProtoMessage() {}
func (*RespondWorkflowTaskCompletedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{12}
}
func (m *RespondWorkflowTaskCompletedRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RespondWorkflowTaskCompletedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RespondWorkflowTaskCompletedRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RespondWorkflowTaskCompletedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RespondWorkflowTaskCompletedRequest.Merge(m, src)
}
func (m *RespondWorkflowTaskCompletedRequest) XXX_Size() int {
	return m.Size()
}
func (m *RespondWorkflowTaskCompletedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RespondWorkflowTaskCompletedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RespondWorkflowTaskCompletedRequest proto.InternalMessageInfo

func (m *RespondWorkflowTaskCompletedRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *RespondWorkflowTaskCompletedRequest) GetCompleteRequest() *v1.RespondWorkflowTaskCompletedRequest {
	if m != nil {
		return m.CompleteRequest
	}
	return nil
}

type RespondWorkflowTaskCompletedResponse struct {
	StartedResponse *RecordWorkflowTaskStartedResponse `protobuf:"bytes,1,opt,name=started_response,json=startedResponse,proto3" json:"started_response,omitempty"`
}

func (m *RespondWorkflowTaskCompletedResponse) Reset()      { *m = RespondWorkflowTaskCompletedResponse{} }
func (*RespondWorkflowTaskCompletedResponse) ProtoMessage() {}
func (*RespondWorkflowTaskCompletedResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{13}
}
func (m *RespondWorkflowTaskCompletedResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RespondWorkflowTaskCompletedResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RespondWorkflowTaskCompletedResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RespondWorkflowTaskCompletedResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RespondWorkflowTaskCompletedResponse.Merge(m, src)
}
func (m *RespondWorkflowTaskCompletedResponse) XXX_Size() int {
	return m.Size()
}
func (m *RespondWorkflowTaskCompletedResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RespondWorkflowTaskCompletedResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RespondWorkflowTaskCompletedResponse proto.InternalMessageInfo

func (m *RespondWorkflowTaskCompletedResponse) GetStartedResponse() *RecordWorkflowTaskStartedResponse {
	if m != nil {
		return m.StartedResponse
	}
	return nil
}

type RespondWorkflowTaskFailedRequest struct {
	NamespaceId   string                               `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	FailedRequest *v1.RespondWorkflowTaskFailedRequest `protobuf:"bytes,2,opt,name=failed_request,json=failedRequest,proto3" json:"failed_request,omitempty"`
}

func (m *RespondWorkflowTaskFailedRequest) Reset()      { *m = RespondWorkflowTaskFailedRequest{} }
func (*RespondWorkflowTaskFailedRequest) ProtoMessage() {}
func (*RespondWorkflowTaskFailedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{14}
}
func (m *RespondWorkflowTaskFailedRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RespondWorkflowTaskFailedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RespondWorkflowTaskFailedRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RespondWorkflowTaskFailedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RespondWorkflowTaskFailedRequest.Merge(m, src)
}
func (m *RespondWorkflowTaskFailedRequest) XXX_Size() int {
	return m.Size()
}
func (m *RespondWorkflowTaskFailedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RespondWorkflowTaskFailedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RespondWorkflowTaskFailedRequest proto.InternalMessageInfo

func (m *RespondWorkflowTaskFailedRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *RespondWorkflowTaskFailedRequest) GetFailedRequest() *v1.RespondWorkflowTaskFailedRequest {
	if m != nil {
		return m.FailedRequest
	}
	return nil
}

type RespondWorkflowTaskFailedResponse struct {
}

func (m *RespondWorkflowTaskFailedResponse) Reset()      { *m = RespondWorkflowTaskFailedResponse{} }
func (*RespondWorkflowTaskFailedResponse) ProtoMessage() {}
func (*RespondWorkflowTaskFailedResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{15}
}
func (m *RespondWorkflowTaskFailedResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RespondWorkflowTaskFailedResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RespondWorkflowTaskFailedResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RespondWorkflowTaskFailedResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RespondWorkflowTaskFailedResponse.Merge(m, src)
}
func (m *RespondWorkflowTaskFailedResponse) XXX_Size() int {
	return m.Size()
}
func (m *RespondWorkflowTaskFailedResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RespondWorkflowTaskFailedResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RespondWorkflowTaskFailedResponse proto.InternalMessageInfo

type RecordActivityTaskHeartbeatRequest struct {
	NamespaceId      string                                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	HeartbeatRequest *v1.RecordActivityTaskHeartbeatRequest `protobuf:"bytes,2,opt,name=heartbeat_request,json=heartbeatRequest,proto3" json:"heartbeat_request,omitempty"`
}

func (m *RecordActivityTaskHeartbeatRequest) Reset()      { *m = RecordActivityTaskHeartbeatRequest{} }
func (*RecordActivityTaskHeartbeatRequest) ProtoMessage() {}
func (*RecordActivityTaskHeartbeatRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{16}
}
func (m *RecordActivityTaskHeartbeatRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RecordActivityTaskHeartbeatRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RecordActivityTaskHeartbeatRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RecordActivityTaskHeartbeatRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecordActivityTaskHeartbeatRequest.Merge(m, src)
}
func (m *RecordActivityTaskHeartbeatRequest) XXX_Size() int {
	return m.Size()
}
func (m *RecordActivityTaskHeartbeatRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RecordActivityTaskHeartbeatRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RecordActivityTaskHeartbeatRequest proto.InternalMessageInfo

func (m *RecordActivityTaskHeartbeatRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *RecordActivityTaskHeartbeatRequest) GetHeartbeatRequest() *v1.RecordActivityTaskHeartbeatRequest {
	if m != nil {
		return m.HeartbeatRequest
	}
	return nil
}

type RecordActivityTaskHeartbeatResponse struct {
	CancelRequested bool `protobuf:"varint,1,opt,name=cancel_requested,json=cancelRequested,proto3" json:"cancel_requested,omitempty"`
}

func (m *RecordActivityTaskHeartbeatResponse) Reset()      { *m = RecordActivityTaskHeartbeatResponse{} }
func (*RecordActivityTaskHeartbeatResponse) ProtoMessage() {}
func (*RecordActivityTaskHeartbeatResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{17}
}
func (m *RecordActivityTaskHeartbeatResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RecordActivityTaskHeartbeatResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RecordActivityTaskHeartbeatResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RecordActivityTaskHeartbeatResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecordActivityTaskHeartbeatResponse.Merge(m, src)
}
func (m *RecordActivityTaskHeartbeatResponse) XXX_Size() int {
	return m.Size()
}
func (m *RecordActivityTaskHeartbeatResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RecordActivityTaskHeartbeatResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RecordActivityTaskHeartbeatResponse proto.InternalMessageInfo

func (m *RecordActivityTaskHeartbeatResponse) GetCancelRequested() bool {
	if m != nil {
		return m.CancelRequested
	}
	return false
}

type RespondActivityTaskCompletedRequest struct {
	NamespaceId     string                                  `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	CompleteRequest *v1.RespondActivityTaskCompletedRequest `protobuf:"bytes,2,opt,name=complete_request,json=completeRequest,proto3" json:"complete_request,omitempty"`
}

func (m *RespondActivityTaskCompletedRequest) Reset()      { *m = RespondActivityTaskCompletedRequest{} }
func (*RespondActivityTaskCompletedRequest) ProtoMessage() {}
func (*RespondActivityTaskCompletedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{18}
}
func (m *RespondActivityTaskCompletedRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RespondActivityTaskCompletedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RespondActivityTaskCompletedRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RespondActivityTaskCompletedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RespondActivityTaskCompletedRequest.Merge(m, src)
}
func (m *RespondActivityTaskCompletedRequest) XXX_Size() int {
	return m.Size()
}
func (m *RespondActivityTaskCompletedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RespondActivityTaskCompletedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RespondActivityTaskCompletedRequest proto.InternalMessageInfo

func (m *RespondActivityTaskCompletedRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *RespondActivityTaskCompletedRequest) GetCompleteRequest() *v1.RespondActivityTaskCompletedRequest {
	if m != nil {
		return m.CompleteRequest
	}
	return nil
}

type RespondActivityTaskCompletedResponse struct {
}

func (m *RespondActivityTaskCompletedResponse) Reset()      { *m = RespondActivityTaskCompletedResponse{} }
func (*RespondActivityTaskCompletedResponse) ProtoMessage() {}
func (*RespondActivityTaskCompletedResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{19}
}
func (m *RespondActivityTaskCompletedResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RespondActivityTaskCompletedResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RespondActivityTaskCompletedResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RespondActivityTaskCompletedResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RespondActivityTaskCompletedResponse.Merge(m, src)
}
func (m *RespondActivityTaskCompletedResponse) XXX_Size() int {
	return m.Size()
}
func (m *RespondActivityTaskCompletedResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RespondActivityTaskCompletedResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RespondActivityTaskCompletedResponse proto.InternalMessageInfo

type RespondActivityTaskFailedRequest struct {
	NamespaceId   string                               `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	FailedRequest *v1.RespondActivityTaskFailedRequest `protobuf:"bytes,2,opt,name=failed_request,json=failedRequest,proto3" json:"failed_request,omitempty"`
}

func (m *RespondActivityTaskFailedRequest) Reset()      { *m = RespondActivityTaskFailedRequest{} }
func (*RespondActivityTaskFailedRequest) ProtoMessage() {}
func (*RespondActivityTaskFailedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{20}
}
func (m *RespondActivityTaskFailedRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RespondActivityTaskFailedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RespondActivityTaskFailedRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RespondActivityTaskFailedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RespondActivityTaskFailedRequest.Merge(m, src)
}
func (m *RespondActivityTaskFailedRequest) XXX_Size() int {
	return m.Size()
}
func (m *RespondActivityTaskFailedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RespondActivityTaskFailedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RespondActivityTaskFailedRequest proto.InternalMessageInfo

func (m *RespondActivityTaskFailedRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *RespondActivityTaskFailedRequest) GetFailedRequest() *v1.RespondActivityTaskFailedRequest {
	if m != nil {
		return m.FailedRequest
	}
	return nil
}

type RespondActivityTaskFailedResponse struct {
}

func (m *RespondActivityTaskFailedResponse) Reset()      { *m = RespondActivityTaskFailedResponse{} }
func (*RespondActivityTaskFailedResponse) ProtoMessage() {}
func (*RespondActivityTaskFailedResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{21}
}
func (m *RespondActivityTaskFailedResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RespondActivityTaskFailedResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RespondActivityTaskFailedResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RespondActivityTaskFailedResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RespondActivityTaskFailedResponse.Merge(m, src)
}
func (m *RespondActivityTaskFailedResponse) XXX_Size() int {
	return m.Size()
}
func (m *RespondActivityTaskFailedResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RespondActivityTaskFailedResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RespondActivityTaskFailedResponse proto.InternalMessageInfo

type RespondActivityTaskCanceledRequest struct {
	NamespaceId   string                                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	CancelRequest *v1.RespondActivityTaskCanceledRequest `protobuf:"bytes,2,opt,name=cancel_request,json=cancelRequest,proto3" json:"cancel_request,omitempty"`
}

func (m *RespondActivityTaskCanceledRequest) Reset()      { *m = RespondActivityTaskCanceledRequest{} }
func (*RespondActivityTaskCanceledRequest) ProtoMessage() {}
func (*RespondActivityTaskCanceledRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{22}
}
func (m *RespondActivityTaskCanceledRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RespondActivityTaskCanceledRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RespondActivityTaskCanceledRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RespondActivityTaskCanceledRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RespondActivityTaskCanceledRequest.Merge(m, src)
}
func (m *RespondActivityTaskCanceledRequest) XXX_Size() int {
	return m.Size()
}
func (m *RespondActivityTaskCanceledRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RespondActivityTaskCanceledRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RespondActivityTaskCanceledRequest proto.InternalMessageInfo

func (m *RespondActivityTaskCanceledRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *RespondActivityTaskCanceledRequest) GetCancelRequest() *v1.RespondActivityTaskCanceledRequest {
	if m != nil {
		return m.CancelRequest
	}
	return nil
}

type RespondActivityTaskCanceledResponse struct {
}

func (m *RespondActivityTaskCanceledResponse) Reset()      { *m = RespondActivityTaskCanceledResponse{} }
func (*RespondActivityTaskCanceledResponse) ProtoMessage() {}
func (*RespondActivityTaskCanceledResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{23}
}
func (m *RespondActivityTaskCanceledResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RespondActivityTaskCanceledResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RespondActivityTaskCanceledResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RespondActivityTaskCanceledResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RespondActivityTaskCanceledResponse.Merge(m, src)
}
func (m *RespondActivityTaskCanceledResponse) XXX_Size() int {
	return m.Size()
}
func (m *RespondActivityTaskCanceledResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RespondActivityTaskCanceledResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RespondActivityTaskCanceledResponse proto.InternalMessageInfo

type SignalWorkflowExecutionRequest struct {
	NamespaceId               string                             `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	SignalRequest             *v1.SignalWorkflowExecutionRequest `protobuf:"bytes,2,opt,name=signal_request,json=signalRequest,proto3" json:"signal_request,omitempty"`
	ExternalWorkflowExecution *v14.WorkflowExecution             `protobuf:"bytes,3,opt,name=external_workflow_execution,json=externalWorkflowExecution,proto3" json:"external_workflow_execution,omitempty"`
	ChildWorkflowOnly         bool                               `protobuf:"varint,4,opt,name=child_workflow_only,json=childWorkflowOnly,proto3" json:"child_workflow_only,omitempty"`
}

func (m *SignalWorkflowExecutionRequest) Reset()      { *m = SignalWorkflowExecutionRequest{} }
func (*SignalWorkflowExecutionRequest) ProtoMessage() {}
func (*SignalWorkflowExecutionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{24}
}
func (m *SignalWorkflowExecutionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SignalWorkflowExecutionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SignalWorkflowExecutionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SignalWorkflowExecutionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SignalWorkflowExecutionRequest.Merge(m, src)
}
func (m *SignalWorkflowExecutionRequest) XXX_Size() int {
	return m.Size()
}
func (m *SignalWorkflowExecutionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SignalWorkflowExecutionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SignalWorkflowExecutionRequest proto.InternalMessageInfo

func (m *SignalWorkflowExecutionRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *SignalWorkflowExecutionRequest) GetSignalRequest() *v1.SignalWorkflowExecutionRequest {
	if m != nil {
		return m.SignalRequest
	}
	return nil
}

func (m *SignalWorkflowExecutionRequest) GetExternalWorkflowExecution() *v14.WorkflowExecution {
	if m != nil {
		return m.ExternalWorkflowExecution
	}
	return nil
}

func (m *SignalWorkflowExecutionRequest) GetChildWorkflowOnly() bool {
	if m != nil {
		return m.ChildWorkflowOnly
	}
	return false
}

type SignalWorkflowExecutionResponse struct {
}

func (m *SignalWorkflowExecutionResponse) Reset()      { *m = SignalWorkflowExecutionResponse{} }
func (*SignalWorkflowExecutionResponse) ProtoMessage() {}
func (*SignalWorkflowExecutionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{25}
}
func (m *SignalWorkflowExecutionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SignalWorkflowExecutionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SignalWorkflowExecutionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SignalWorkflowExecutionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SignalWorkflowExecutionResponse.Merge(m, src)
}
func (m *SignalWorkflowExecutionResponse) XXX_Size() int {
	return m.Size()
}
func (m *SignalWorkflowExecutionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SignalWorkflowExecutionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SignalWorkflowExecutionResponse proto.InternalMessageInfo

type SignalWithStartWorkflowExecutionRequest struct {
	NamespaceId string `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "with" is needed here. --)
	SignalWithStartRequest *v1.SignalWithStartWorkflowExecutionRequest `protobuf:"bytes,2,opt,name=signal_with_start_request,json=signalWithStartRequest,proto3" json:"signal_with_start_request,omitempty"`
}

func (m *SignalWithStartWorkflowExecutionRequest) Reset() {
	*m = SignalWithStartWorkflowExecutionRequest{}
}
func (*SignalWithStartWorkflowExecutionRequest) ProtoMessage() {}
func (*SignalWithStartWorkflowExecutionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{26}
}
func (m *SignalWithStartWorkflowExecutionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SignalWithStartWorkflowExecutionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SignalWithStartWorkflowExecutionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SignalWithStartWorkflowExecutionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SignalWithStartWorkflowExecutionRequest.Merge(m, src)
}
func (m *SignalWithStartWorkflowExecutionRequest) XXX_Size() int {
	return m.Size()
}
func (m *SignalWithStartWorkflowExecutionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SignalWithStartWorkflowExecutionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SignalWithStartWorkflowExecutionRequest proto.InternalMessageInfo

func (m *SignalWithStartWorkflowExecutionRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *SignalWithStartWorkflowExecutionRequest) GetSignalWithStartRequest() *v1.SignalWithStartWorkflowExecutionRequest {
	if m != nil {
		return m.SignalWithStartRequest
	}
	return nil
}

type SignalWithStartWorkflowExecutionResponse struct {
	RunId string `protobuf:"bytes,1,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
}

func (m *SignalWithStartWorkflowExecutionResponse) Reset() {
	*m = SignalWithStartWorkflowExecutionResponse{}
}
func (*SignalWithStartWorkflowExecutionResponse) ProtoMessage() {}
func (*SignalWithStartWorkflowExecutionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{27}
}
func (m *SignalWithStartWorkflowExecutionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SignalWithStartWorkflowExecutionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SignalWithStartWorkflowExecutionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SignalWithStartWorkflowExecutionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SignalWithStartWorkflowExecutionResponse.Merge(m, src)
}
func (m *SignalWithStartWorkflowExecutionResponse) XXX_Size() int {
	return m.Size()
}
func (m *SignalWithStartWorkflowExecutionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SignalWithStartWorkflowExecutionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SignalWithStartWorkflowExecutionResponse proto.InternalMessageInfo

func (m *SignalWithStartWorkflowExecutionResponse) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

type RemoveSignalMutableStateRequest struct {
	NamespaceId       string                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowExecution *v14.WorkflowExecution `protobuf:"bytes,2,opt,name=workflow_execution,json=workflowExecution,proto3" json:"workflow_execution,omitempty"`
	RequestId         string                 `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (m *RemoveSignalMutableStateRequest) Reset()      { *m = RemoveSignalMutableStateRequest{} }
func (*RemoveSignalMutableStateRequest) ProtoMessage() {}
func (*RemoveSignalMutableStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{28}
}
func (m *RemoveSignalMutableStateRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveSignalMutableStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveSignalMutableStateRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveSignalMutableStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveSignalMutableStateRequest.Merge(m, src)
}
func (m *RemoveSignalMutableStateRequest) XXX_Size() int {
	return m.Size()
}
func (m *RemoveSignalMutableStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveSignalMutableStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveSignalMutableStateRequest proto.InternalMessageInfo

func (m *RemoveSignalMutableStateRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *RemoveSignalMutableStateRequest) GetWorkflowExecution() *v14.WorkflowExecution {
	if m != nil {
		return m.WorkflowExecution
	}
	return nil
}

func (m *RemoveSignalMutableStateRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

type RemoveSignalMutableStateResponse struct {
}

func (m *RemoveSignalMutableStateResponse) Reset()      { *m = RemoveSignalMutableStateResponse{} }
func (*RemoveSignalMutableStateResponse) ProtoMessage() {}
func (*RemoveSignalMutableStateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{29}
}
func (m *RemoveSignalMutableStateResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveSignalMutableStateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveSignalMutableStateResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveSignalMutableStateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveSignalMutableStateResponse.Merge(m, src)
}
func (m *RemoveSignalMutableStateResponse) XXX_Size() int {
	return m.Size()
}
func (m *RemoveSignalMutableStateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveSignalMutableStateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveSignalMutableStateResponse proto.InternalMessageInfo

type TerminateWorkflowExecutionRequest struct {
	NamespaceId      string                                `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	TerminateRequest *v1.TerminateWorkflowExecutionRequest `protobuf:"bytes,2,opt,name=terminate_request,json=terminateRequest,proto3" json:"terminate_request,omitempty"`
}

func (m *TerminateWorkflowExecutionRequest) Reset()      { *m = TerminateWorkflowExecutionRequest{} }
func (*TerminateWorkflowExecutionRequest) ProtoMessage() {}
func (*TerminateWorkflowExecutionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{30}
}
func (m *TerminateWorkflowExecutionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TerminateWorkflowExecutionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TerminateWorkflowExecutionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TerminateWorkflowExecutionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TerminateWorkflowExecutionRequest.Merge(m, src)
}
func (m *TerminateWorkflowExecutionRequest) XXX_Size() int {
	return m.Size()
}
func (m *TerminateWorkflowExecutionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TerminateWorkflowExecutionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TerminateWorkflowExecutionRequest proto.InternalMessageInfo

func (m *TerminateWorkflowExecutionRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *TerminateWorkflowExecutionRequest) GetTerminateRequest() *v1.TerminateWorkflowExecutionRequest {
	if m != nil {
		return m.TerminateRequest
	}
	return nil
}

type TerminateWorkflowExecutionResponse struct {
}

func (m *TerminateWorkflowExecutionResponse) Reset()      { *m = TerminateWorkflowExecutionResponse{} }
func (*TerminateWorkflowExecutionResponse) ProtoMessage() {}
func (*TerminateWorkflowExecutionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{31}
}
func (m *TerminateWorkflowExecutionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TerminateWorkflowExecutionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TerminateWorkflowExecutionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TerminateWorkflowExecutionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TerminateWorkflowExecutionResponse.Merge(m, src)
}
func (m *TerminateWorkflowExecutionResponse) XXX_Size() int {
	return m.Size()
}
func (m *TerminateWorkflowExecutionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TerminateWorkflowExecutionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TerminateWorkflowExecutionResponse proto.InternalMessageInfo

type ResetWorkflowExecutionRequest struct {
	NamespaceId  string                            `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	ResetRequest *v1.ResetWorkflowExecutionRequest `protobuf:"bytes,2,opt,name=reset_request,json=resetRequest,proto3" json:"reset_request,omitempty"`
}

func (m *ResetWorkflowExecutionRequest) Reset()      { *m = ResetWorkflowExecutionRequest{} }
func (*ResetWorkflowExecutionRequest) ProtoMessage() {}
func (*ResetWorkflowExecutionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{32}
}
func (m *ResetWorkflowExecutionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResetWorkflowExecutionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResetWorkflowExecutionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResetWorkflowExecutionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResetWorkflowExecutionRequest.Merge(m, src)
}
func (m *ResetWorkflowExecutionRequest) XXX_Size() int {
	return m.Size()
}
func (m *ResetWorkflowExecutionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResetWorkflowExecutionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResetWorkflowExecutionRequest proto.InternalMessageInfo

func (m *ResetWorkflowExecutionRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *ResetWorkflowExecutionRequest) GetResetRequest() *v1.ResetWorkflowExecutionRequest {
	if m != nil {
		return m.ResetRequest
	}
	return nil
}

type ResetWorkflowExecutionResponse struct {
	RunId string `protobuf:"bytes,1,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
}

func (m *ResetWorkflowExecutionResponse) Reset()      { *m = ResetWorkflowExecutionResponse{} }
func (*ResetWorkflowExecutionResponse) ProtoMessage() {}
func (*ResetWorkflowExecutionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{33}
}
func (m *ResetWorkflowExecutionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResetWorkflowExecutionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResetWorkflowExecutionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResetWorkflowExecutionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResetWorkflowExecutionResponse.Merge(m, src)
}
func (m *ResetWorkflowExecutionResponse) XXX_Size() int {
	return m.Size()
}
func (m *ResetWorkflowExecutionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ResetWorkflowExecutionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ResetWorkflowExecutionResponse proto.InternalMessageInfo

func (m *ResetWorkflowExecutionResponse) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

type RequestCancelWorkflowExecutionRequest struct {
	NamespaceId               string                                    `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	CancelRequest             *v1.RequestCancelWorkflowExecutionRequest `protobuf:"bytes,2,opt,name=cancel_request,json=cancelRequest,proto3" json:"cancel_request,omitempty"`
	ExternalInitiatedEventId  int64                                     `protobuf:"varint,3,opt,name=external_initiated_event_id,json=externalInitiatedEventId,proto3" json:"external_initiated_event_id,omitempty"`
	ExternalWorkflowExecution *v14.WorkflowExecution                    `protobuf:"bytes,4,opt,name=external_workflow_execution,json=externalWorkflowExecution,proto3" json:"external_workflow_execution,omitempty"`
	ChildWorkflowOnly         bool                                      `protobuf:"varint,5,opt,name=child_workflow_only,json=childWorkflowOnly,proto3" json:"child_workflow_only,omitempty"`
}

func (m *RequestCancelWorkflowExecutionRequest) Reset()      { *m = RequestCancelWorkflowExecutionRequest{} }
func (*RequestCancelWorkflowExecutionRequest) ProtoMessage() {}
func (*RequestCancelWorkflowExecutionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{34}
}
func (m *RequestCancelWorkflowExecutionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RequestCancelWorkflowExecutionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RequestCancelWorkflowExecutionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RequestCancelWorkflowExecutionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestCancelWorkflowExecutionRequest.Merge(m, src)
}
func (m *RequestCancelWorkflowExecutionRequest) XXX_Size() int {
	return m.Size()
}
func (m *RequestCancelWorkflowExecutionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestCancelWorkflowExecutionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RequestCancelWorkflowExecutionRequest proto.InternalMessageInfo

func (m *RequestCancelWorkflowExecutionRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *RequestCancelWorkflowExecutionRequest) GetCancelRequest() *v1.RequestCancelWorkflowExecutionRequest {
	if m != nil {
		return m.CancelRequest
	}
	return nil
}

func (m *RequestCancelWorkflowExecutionRequest) GetExternalInitiatedEventId() int64 {
	if m != nil {
		return m.ExternalInitiatedEventId
	}
	return 0
}

func (m *RequestCancelWorkflowExecutionRequest) GetExternalWorkflowExecution() *v14.WorkflowExecution {
	if m != nil {
		return m.ExternalWorkflowExecution
	}
	return nil
}

func (m *RequestCancelWorkflowExecutionRequest) GetChildWorkflowOnly() bool {
	if m != nil {
		return m.ChildWorkflowOnly
	}
	return false
}

type RequestCancelWorkflowExecutionResponse struct {
}

func (m *RequestCancelWorkflowExecutionResponse) Reset() {
	*m = RequestCancelWorkflowExecutionResponse{}
}
func (*RequestCancelWorkflowExecutionResponse) ProtoMessage() {}
func (*RequestCancelWorkflowExecutionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{35}
}
func (m *RequestCancelWorkflowExecutionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RequestCancelWorkflowExecutionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RequestCancelWorkflowExecutionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RequestCancelWorkflowExecutionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestCancelWorkflowExecutionResponse.Merge(m, src)
}
func (m *RequestCancelWorkflowExecutionResponse) XXX_Size() int {
	return m.Size()
}
func (m *RequestCancelWorkflowExecutionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestCancelWorkflowExecutionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RequestCancelWorkflowExecutionResponse proto.InternalMessageInfo

type ScheduleWorkflowTaskRequest struct {
	NamespaceId         string                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowExecution   *v14.WorkflowExecution `protobuf:"bytes,2,opt,name=workflow_execution,json=workflowExecution,proto3" json:"workflow_execution,omitempty"`
	IsFirstWorkflowTask bool                   `protobuf:"varint,3,opt,name=is_first_workflow_task,json=isFirstWorkflowTask,proto3" json:"is_first_workflow_task,omitempty"`
}

func (m *ScheduleWorkflowTaskRequest) Reset()      { *m = ScheduleWorkflowTaskRequest{} }
func (*ScheduleWorkflowTaskRequest) ProtoMessage() {}
func (*ScheduleWorkflowTaskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{36}
}
func (m *ScheduleWorkflowTaskRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScheduleWorkflowTaskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScheduleWorkflowTaskRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScheduleWorkflowTaskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScheduleWorkflowTaskRequest.Merge(m, src)
}
func (m *ScheduleWorkflowTaskRequest) XXX_Size() int {
	return m.Size()
}
func (m *ScheduleWorkflowTaskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ScheduleWorkflowTaskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ScheduleWorkflowTaskRequest proto.InternalMessageInfo

func (m *ScheduleWorkflowTaskRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *ScheduleWorkflowTaskRequest) GetWorkflowExecution() *v14.WorkflowExecution {
	if m != nil {
		return m.WorkflowExecution
	}
	return nil
}

func (m *ScheduleWorkflowTaskRequest) GetIsFirstWorkflowTask() bool {
	if m != nil {
		return m.IsFirstWorkflowTask
	}
	return false
}

type ScheduleWorkflowTaskResponse struct {
}

func (m *ScheduleWorkflowTaskResponse) Reset()      { *m = ScheduleWorkflowTaskResponse{} }
func (*ScheduleWorkflowTaskResponse) ProtoMessage() {}
func (*ScheduleWorkflowTaskResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{37}
}
func (m *ScheduleWorkflowTaskResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScheduleWorkflowTaskResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScheduleWorkflowTaskResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScheduleWorkflowTaskResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScheduleWorkflowTaskResponse.Merge(m, src)
}
func (m *ScheduleWorkflowTaskResponse) XXX_Size() int {
	return m.Size()
}
func (m *ScheduleWorkflowTaskResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ScheduleWorkflowTaskResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ScheduleWorkflowTaskResponse proto.InternalMessageInfo

//*
// RecordChildExecutionCompletedRequest is used for reporting the completion of child execution to parent workflow
// execution which started it.  When a child execution is completed it creates this request and calls the
// RecordChildExecutionCompleted API with the workflowExecution of parent.  It also sets the completedExecution of the
// child as it could potentially be different than the ChildExecutionStartedEvent of parent in the situation when
// child creates multiple runs through ContinueAsNew before finally completing.
type RecordChildExecutionCompletedRequest struct {
	NamespaceId        string                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowExecution  *v14.WorkflowExecution `protobuf:"bytes,2,opt,name=workflow_execution,json=workflowExecution,proto3" json:"workflow_execution,omitempty"`
	InitiatedId        int64                  `protobuf:"varint,3,opt,name=initiated_id,json=initiatedId,proto3" json:"initiated_id,omitempty"`
	CompletedExecution *v14.WorkflowExecution `protobuf:"bytes,4,opt,name=completed_execution,json=completedExecution,proto3" json:"completed_execution,omitempty"`
	CompletionEvent    *v19.HistoryEvent      `protobuf:"bytes,5,opt,name=completion_event,json=completionEvent,proto3" json:"completion_event,omitempty"`
}

func (m *RecordChildExecutionCompletedRequest) Reset()      { *m = RecordChildExecutionCompletedRequest{} }
func (*RecordChildExecutionCompletedRequest) ProtoMessage() {}
func (*RecordChildExecutionCompletedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{38}
}
func (m *RecordChildExecutionCompletedRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RecordChildExecutionCompletedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RecordChildExecutionCompletedRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RecordChildExecutionCompletedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecordChildExecutionCompletedRequest.Merge(m, src)
}
func (m *RecordChildExecutionCompletedRequest) XXX_Size() int {
	return m.Size()
}
func (m *RecordChildExecutionCompletedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RecordChildExecutionCompletedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RecordChildExecutionCompletedRequest proto.InternalMessageInfo

func (m *RecordChildExecutionCompletedRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *RecordChildExecutionCompletedRequest) GetWorkflowExecution() *v14.WorkflowExecution {
	if m != nil {
		return m.WorkflowExecution
	}
	return nil
}

func (m *RecordChildExecutionCompletedRequest) GetInitiatedId() int64 {
	if m != nil {
		return m.InitiatedId
	}
	return 0
}

func (m *RecordChildExecutionCompletedRequest) GetCompletedExecution() *v14.WorkflowExecution {
	if m != nil {
		return m.CompletedExecution
	}
	return nil
}

func (m *RecordChildExecutionCompletedRequest) GetCompletionEvent() *v19.HistoryEvent {
	if m != nil {
		return m.CompletionEvent
	}
	return nil
}

type RecordChildExecutionCompletedResponse struct {
}

func (m *RecordChildExecutionCompletedResponse) Reset()      { *m = RecordChildExecutionCompletedResponse{} }
func (*RecordChildExecutionCompletedResponse) ProtoMessage() {}
func (*RecordChildExecutionCompletedResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{39}
}
func (m *RecordChildExecutionCompletedResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RecordChildExecutionCompletedResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RecordChildExecutionCompletedResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RecordChildExecutionCompletedResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecordChildExecutionCompletedResponse.Merge(m, src)
}
func (m *RecordChildExecutionCompletedResponse) XXX_Size() int {
	return m.Size()
}
func (m *RecordChildExecutionCompletedResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RecordChildExecutionCompletedResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RecordChildExecutionCompletedResponse proto.InternalMessageInfo

type DescribeWorkflowExecutionRequest struct {
	NamespaceId string                               `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	Request     *v1.DescribeWorkflowExecutionRequest `protobuf:"bytes,2,opt,name=request,proto3" json:"request,omitempty"`
}

func (m *DescribeWorkflowExecutionRequest) Reset()      { *m = DescribeWorkflowExecutionRequest{} }
func (*DescribeWorkflowExecutionRequest) ProtoMessage() {}
func (*DescribeWorkflowExecutionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{40}
}
func (m *DescribeWorkflowExecutionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeWorkflowExecutionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeWorkflowExecutionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeWorkflowExecutionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeWorkflowExecutionRequest.Merge(m, src)
}
func (m *DescribeWorkflowExecutionRequest) XXX_Size() int {
	return m.Size()
}
func (m *DescribeWorkflowExecutionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeWorkflowExecutionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeWorkflowExecutionRequest proto.InternalMessageInfo

func (m *DescribeWorkflowExecutionRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *DescribeWorkflowExecutionRequest) GetRequest() *v1.DescribeWorkflowExecutionRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

type DescribeWorkflowExecutionResponse struct {
	ExecutionConfig       *v110.WorkflowExecutionConfig     `protobuf:"bytes,1,opt,name=execution_config,json=executionConfig,proto3" json:"execution_config,omitempty"`
	WorkflowExecutionInfo *v110.WorkflowExecutionInfo       `protobuf:"bytes,2,opt,name=workflow_execution_info,json=workflowExecutionInfo,proto3" json:"workflow_execution_info,omitempty"`
	PendingActivities     []*v110.PendingActivityInfo       `protobuf:"bytes,3,rep,name=pending_activities,json=pendingActivities,proto3" json:"pending_activities,omitempty"`
	PendingChildren       []*v110.PendingChildExecutionInfo `protobuf:"bytes,4,rep,name=pending_children,json=pendingChildren,proto3" json:"pending_children,omitempty"`
}

func (m *DescribeWorkflowExecutionResponse) Reset()      { *m = DescribeWorkflowExecutionResponse{} }
func (*DescribeWorkflowExecutionResponse) ProtoMessage() {}
func (*DescribeWorkflowExecutionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{41}
}
func (m *DescribeWorkflowExecutionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeWorkflowExecutionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeWorkflowExecutionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeWorkflowExecutionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeWorkflowExecutionResponse.Merge(m, src)
}
func (m *DescribeWorkflowExecutionResponse) XXX_Size() int {
	return m.Size()
}
func (m *DescribeWorkflowExecutionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeWorkflowExecutionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeWorkflowExecutionResponse proto.InternalMessageInfo

func (m *DescribeWorkflowExecutionResponse) GetExecutionConfig() *v110.WorkflowExecutionConfig {
	if m != nil {
		return m.ExecutionConfig
	}
	return nil
}

func (m *DescribeWorkflowExecutionResponse) GetWorkflowExecutionInfo() *v110.WorkflowExecutionInfo {
	if m != nil {
		return m.WorkflowExecutionInfo
	}
	return nil
}

func (m *DescribeWorkflowExecutionResponse) GetPendingActivities() []*v110.PendingActivityInfo {
	if m != nil {
		return m.PendingActivities
	}
	return nil
}

func (m *DescribeWorkflowExecutionResponse) GetPendingChildren() []*v110.PendingChildExecutionInfo {
	if m != nil {
		return m.PendingChildren
	}
	return nil
}

type ReplicateEventsV2Request struct {
	NamespaceId         string                    `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowExecution   *v14.WorkflowExecution    `protobuf:"bytes,2,opt,name=workflow_execution,json=workflowExecution,proto3" json:"workflow_execution,omitempty"`
	VersionHistoryItems []*v17.VersionHistoryItem `protobuf:"bytes,3,rep,name=version_history_items,json=versionHistoryItems,proto3" json:"version_history_items,omitempty"`
	Events              *v14.DataBlob             `protobuf:"bytes,4,opt,name=events,proto3" json:"events,omitempty"`
	// New run events does not need version history since there is no prior events.
	NewRunEvents *v14.DataBlob `protobuf:"bytes,5,opt,name=new_run_events,json=newRunEvents,proto3" json:"new_run_events,omitempty"`
}

func (m *ReplicateEventsV2Request) Reset()      { *m = ReplicateEventsV2Request{} }
func (*ReplicateEventsV2Request) ProtoMessage() {}
func (*ReplicateEventsV2Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{42}
}
func (m *ReplicateEventsV2Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicateEventsV2Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicateEventsV2Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicateEventsV2Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicateEventsV2Request.Merge(m, src)
}
func (m *ReplicateEventsV2Request) XXX_Size() int {
	return m.Size()
}
func (m *ReplicateEventsV2Request) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicateEventsV2Request.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicateEventsV2Request proto.InternalMessageInfo

func (m *ReplicateEventsV2Request) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *ReplicateEventsV2Request) GetWorkflowExecution() *v14.WorkflowExecution {
	if m != nil {
		return m.WorkflowExecution
	}
	return nil
}

func (m *ReplicateEventsV2Request) GetVersionHistoryItems() []*v17.VersionHistoryItem {
	if m != nil {
		return m.VersionHistoryItems
	}
	return nil
}

func (m *ReplicateEventsV2Request) GetEvents() *v14.DataBlob {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *ReplicateEventsV2Request) GetNewRunEvents() *v14.DataBlob {
	if m != nil {
		return m.NewRunEvents
	}
	return nil
}

type ReplicateEventsV2Response struct {
}

func (m *ReplicateEventsV2Response) Reset()      { *m = ReplicateEventsV2Response{} }
func (*ReplicateEventsV2Response) ProtoMessage() {}
func (*ReplicateEventsV2Response) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{43}
}
func (m *ReplicateEventsV2Response) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicateEventsV2Response) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicateEventsV2Response.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicateEventsV2Response) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicateEventsV2Response.Merge(m, src)
}
func (m *ReplicateEventsV2Response) XXX_Size() int {
	return m.Size()
}
func (m *ReplicateEventsV2Response) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicateEventsV2Response.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicateEventsV2Response proto.InternalMessageInfo

type SyncShardStatusRequest struct {
	SourceCluster string     `protobuf:"bytes,1,opt,name=source_cluster,json=sourceCluster,proto3" json:"source_cluster,omitempty"`
	ShardId       int32      `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	StatusTime    *time.Time `protobuf:"bytes,3,opt,name=status_time,json=statusTime,proto3,stdtime" json:"status_time,omitempty"`
}

func (m *SyncShardStatusRequest) Reset()      { *m = SyncShardStatusRequest{} }
func (*SyncShardStatusRequest) ProtoMessage() {}
func (*SyncShardStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{44}
}
func (m *SyncShardStatusRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SyncShardStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SyncShardStatusRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SyncShardStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SyncShardStatusRequest.Merge(m, src)
}
func (m *SyncShardStatusRequest) XXX_Size() int {
	return m.Size()
}
func (m *SyncShardStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SyncShardStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SyncShardStatusRequest proto.InternalMessageInfo

func (m *SyncShardStatusRequest) GetSourceCluster() string {
	if m != nil {
		return m.SourceCluster
	}
	return ""
}

func (m *SyncShardStatusRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *SyncShardStatusRequest) GetStatusTime() *time.Time {
	if m != nil {
		return m.StatusTime
	}
	return nil
}

type SyncShardStatusResponse struct {
}

func (m *SyncShardStatusResponse) Reset()      { *m = SyncShardStatusResponse{} }
func (*SyncShardStatusResponse) ProtoMessage() {}
func (*SyncShardStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{45}
}
func (m *SyncShardStatusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SyncShardStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SyncShardStatusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SyncShardStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SyncShardStatusResponse.Merge(m, src)
}
func (m *SyncShardStatusResponse) XXX_Size() int {
	return m.Size()
}
func (m *SyncShardStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SyncShardStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SyncShardStatusResponse proto.InternalMessageInfo

type SyncActivityRequest struct {
	NamespaceId        string              `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId         string              `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId              string              `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	Version            int64               `protobuf:"varint,4,opt,name=version,proto3" json:"version,omitempty"`
	ScheduledId        int64               `protobuf:"varint,5,opt,name=scheduled_id,json=scheduledId,proto3" json:"scheduled_id,omitempty"`
	ScheduledTime      *time.Time          `protobuf:"bytes,6,opt,name=scheduled_time,json=scheduledTime,proto3,stdtime" json:"scheduled_time,omitempty"`
	StartedId          int64               `protobuf:"varint,7,opt,name=started_id,json=startedId,proto3" json:"started_id,omitempty"`
	StartedTime        *time.Time          `protobuf:"bytes,8,opt,name=started_time,json=startedTime,proto3,stdtime" json:"started_time,omitempty"`
	LastHeartbeatTime  *time.Time          `protobuf:"bytes,9,opt,name=last_heartbeat_time,json=lastHeartbeatTime,proto3,stdtime" json:"last_heartbeat_time,omitempty"`
	Details            *v14.Payloads       `protobuf:"bytes,10,opt,name=details,proto3" json:"details,omitempty"`
	Attempt            int32               `protobuf:"varint,11,opt,name=attempt,proto3" json:"attempt,omitempty"`
	LastFailure        *v13.Failure        `protobuf:"bytes,12,opt,name=last_failure,json=lastFailure,proto3" json:"last_failure,omitempty"`
	LastWorkerIdentity string              `protobuf:"bytes,13,opt,name=last_worker_identity,json=lastWorkerIdentity,proto3" json:"last_worker_identity,omitempty"`
	VersionHistory     *v17.VersionHistory `protobuf:"bytes,14,opt,name=version_history,json=versionHistory,proto3" json:"version_history,omitempty"`
}

func (m *SyncActivityRequest) Reset()      { *m = SyncActivityRequest{} }
func (*SyncActivityRequest) ProtoMessage() {}
func (*SyncActivityRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{46}
}
func (m *SyncActivityRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SyncActivityRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SyncActivityRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SyncActivityRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SyncActivityRequest.Merge(m, src)
}
func (m *SyncActivityRequest) XXX_Size() int {
	return m.Size()
}
func (m *SyncActivityRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SyncActivityRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SyncActivityRequest proto.InternalMessageInfo

func (m *SyncActivityRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *SyncActivityRequest) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *SyncActivityRequest) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *SyncActivityRequest) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *SyncActivityRequest) GetScheduledId() int64 {
	if m != nil {
		return m.ScheduledId
	}
	return 0
}

func (m *SyncActivityRequest) GetScheduledTime() *time.Time {
	if m != nil {
		return m.ScheduledTime
	}
	return nil
}

func (m *SyncActivityRequest) GetStartedId() int64 {
	if m != nil {
		return m.StartedId
	}
	return 0
}

func (m *SyncActivityRequest) GetStartedTime() *time.Time {
	if m != nil {
		return m.StartedTime
	}
	return nil
}

func (m *SyncActivityRequest) GetLastHeartbeatTime() *time.Time {
	if m != nil {
		return m.LastHeartbeatTime
	}
	return nil
}

func (m *SyncActivityRequest) GetDetails() *v14.Payloads {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *SyncActivityRequest) GetAttempt() int32 {
	if m != nil {
		return m.Attempt
	}
	return 0
}

func (m *SyncActivityRequest) GetLastFailure() *v13.Failure {
	if m != nil {
		return m.LastFailure
	}
	return nil
}

func (m *SyncActivityRequest) GetLastWorkerIdentity() string {
	if m != nil {
		return m.LastWorkerIdentity
	}
	return ""
}

func (m *SyncActivityRequest) GetVersionHistory() *v17.VersionHistory {
	if m != nil {
		return m.VersionHistory
	}
	return nil
}

type SyncActivityResponse struct {
}

func (m *SyncActivityResponse) Reset()      { *m = SyncActivityResponse{} }
func (*SyncActivityResponse) ProtoMessage() {}
func (*SyncActivityResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{47}
}
func (m *SyncActivityResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SyncActivityResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SyncActivityResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SyncActivityResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SyncActivityResponse.Merge(m, src)
}
func (m *SyncActivityResponse) XXX_Size() int {
	return m.Size()
}
func (m *SyncActivityResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SyncActivityResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SyncActivityResponse proto.InternalMessageInfo

type DescribeMutableStateRequest struct {
	NamespaceId string                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	Execution   *v14.WorkflowExecution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
}

func (m *DescribeMutableStateRequest) Reset()      { *m = DescribeMutableStateRequest{} }
func (*DescribeMutableStateRequest) ProtoMessage() {}
func (*DescribeMutableStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{48}
}
func (m *DescribeMutableStateRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeMutableStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeMutableStateRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeMutableStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeMutableStateRequest.Merge(m, src)
}
func (m *DescribeMutableStateRequest) XXX_Size() int {
	return m.Size()
}
func (m *DescribeMutableStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeMutableStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeMutableStateRequest proto.InternalMessageInfo

func (m *DescribeMutableStateRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *DescribeMutableStateRequest) GetExecution() *v14.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

type DescribeMutableStateResponse struct {
	CacheMutableState    *v111.WorkflowMutableState `protobuf:"bytes,1,opt,name=cache_mutable_state,json=cacheMutableState,proto3" json:"cache_mutable_state,omitempty"`
	DatabaseMutableState *v111.WorkflowMutableState `protobuf:"bytes,2,opt,name=database_mutable_state,json=databaseMutableState,proto3" json:"database_mutable_state,omitempty"`
}

func (m *DescribeMutableStateResponse) Reset()      { *m = DescribeMutableStateResponse{} }
func (*DescribeMutableStateResponse) ProtoMessage() {}
func (*DescribeMutableStateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{49}
}
func (m *DescribeMutableStateResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeMutableStateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeMutableStateResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeMutableStateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeMutableStateResponse.Merge(m, src)
}
func (m *DescribeMutableStateResponse) XXX_Size() int {
	return m.Size()
}
func (m *DescribeMutableStateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeMutableStateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeMutableStateResponse proto.InternalMessageInfo

func (m *DescribeMutableStateResponse) GetCacheMutableState() *v111.WorkflowMutableState {
	if m != nil {
		return m.CacheMutableState
	}
	return nil
}

func (m *DescribeMutableStateResponse) GetDatabaseMutableState() *v111.WorkflowMutableState {
	if m != nil {
		return m.DatabaseMutableState
	}
	return nil
}

// At least one of the parameters needs to be provided.
type DescribeHistoryHostRequest struct {
	//ip:port
	HostAddress       string                 `protobuf:"bytes,1,opt,name=host_address,json=hostAddress,proto3" json:"host_address,omitempty"`
	ShardId           int32                  `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	NamespaceId       string                 `protobuf:"bytes,3,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowExecution *v14.WorkflowExecution `protobuf:"bytes,4,opt,name=workflow_execution,json=workflowExecution,proto3" json:"workflow_execution,omitempty"`
}

func (m *DescribeHistoryHostRequest) Reset()      { *m = DescribeHistoryHostRequest{} }
func (*DescribeHistoryHostRequest) ProtoMessage() {}
func (*DescribeHistoryHostRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{50}
}
func (m *DescribeHistoryHostRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeHistoryHostRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeHistoryHostRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeHistoryHostRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeHistoryHostRequest.Merge(m, src)
}
func (m *DescribeHistoryHostRequest) XXX_Size() int {
	return m.Size()
}
func (m *DescribeHistoryHostRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeHistoryHostRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeHistoryHostRequest proto.InternalMessageInfo

func (m *DescribeHistoryHostRequest) GetHostAddress() string {
	if m != nil {
		return m.HostAddress
	}
	return ""
}

func (m *DescribeHistoryHostRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *DescribeHistoryHostRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *DescribeHistoryHostRequest) GetWorkflowExecution() *v14.WorkflowExecution {
	if m != nil {
		return m.WorkflowExecution
	}
	return nil
}

type DescribeHistoryHostResponse struct {
	ShardsNumber          int32                    `protobuf:"varint,1,opt,name=shards_number,json=shardsNumber,proto3" json:"shards_number,omitempty"`
	ShardIds              []int32                  `protobuf:"varint,2,rep,packed,name=shard_ids,json=shardIds,proto3" json:"shard_ids,omitempty"`
	NamespaceCache        *v112.NamespaceCacheInfo `protobuf:"bytes,3,opt,name=namespace_cache,json=namespaceCache,proto3" json:"namespace_cache,omitempty"`
	ShardControllerStatus string                   `protobuf:"bytes,4,opt,name=shard_controller_status,json=shardControllerStatus,proto3" json:"shard_controller_status,omitempty"`
	Address               string                   `protobuf:"bytes,5,opt,name=address,proto3" json:"address,omitempty"`
}

func (m *DescribeHistoryHostResponse) Reset()      { *m = DescribeHistoryHostResponse{} }
func (*DescribeHistoryHostResponse) ProtoMessage() {}
func (*DescribeHistoryHostResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{51}
}
func (m *DescribeHistoryHostResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeHistoryHostResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeHistoryHostResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeHistoryHostResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeHistoryHostResponse.Merge(m, src)
}
func (m *DescribeHistoryHostResponse) XXX_Size() int {
	return m.Size()
}
func (m *DescribeHistoryHostResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeHistoryHostResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeHistoryHostResponse proto.InternalMessageInfo

func (m *DescribeHistoryHostResponse) GetShardsNumber() int32 {
	if m != nil {
		return m.ShardsNumber
	}
	return 0
}

func (m *DescribeHistoryHostResponse) GetShardIds() []int32 {
	if m != nil {
		return m.ShardIds
	}
	return nil
}

func (m *DescribeHistoryHostResponse) GetNamespaceCache() *v112.NamespaceCacheInfo {
	if m != nil {
		return m.NamespaceCache
	}
	return nil
}

func (m *DescribeHistoryHostResponse) GetShardControllerStatus() string {
	if m != nil {
		return m.ShardControllerStatus
	}
	return ""
}

func (m *DescribeHistoryHostResponse) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

type CloseShardRequest struct {
	ShardId int32 `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
}

func (m *CloseShardRequest) Reset()      { *m = CloseShardRequest{} }
func (*CloseShardRequest) ProtoMessage() {}
func (*CloseShardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{52}
}
func (m *CloseShardRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CloseShardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CloseShardRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CloseShardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloseShardRequest.Merge(m, src)
}
func (m *CloseShardRequest) XXX_Size() int {
	return m.Size()
}
func (m *CloseShardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CloseShardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CloseShardRequest proto.InternalMessageInfo

func (m *CloseShardRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

type CloseShardResponse struct {
}

func (m *CloseShardResponse) Reset()      { *m = CloseShardResponse{} }
func (*CloseShardResponse) ProtoMessage() {}
func (*CloseShardResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{53}
}
func (m *CloseShardResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CloseShardResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CloseShardResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CloseShardResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloseShardResponse.Merge(m, src)
}
func (m *CloseShardResponse) XXX_Size() int {
	return m.Size()
}
func (m *CloseShardResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CloseShardResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CloseShardResponse proto.InternalMessageInfo

type RemoveTaskRequest struct {
	ShardId        int32            `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	Category       v16.TaskCategory `protobuf:"varint,2,opt,name=category,proto3,enum=temporal.server.api.enums.v1.TaskCategory" json:"category,omitempty"`
	TaskId         int64            `protobuf:"varint,3,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	VisibilityTime *time.Time       `protobuf:"bytes,4,opt,name=visibility_time,json=visibilityTime,proto3,stdtime" json:"visibility_time,omitempty"`
}

func (m *RemoveTaskRequest) Reset()      { *m = RemoveTaskRequest{} }
func (*RemoveTaskRequest) ProtoMessage() {}
func (*RemoveTaskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{54}
}
func (m *RemoveTaskRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveTaskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveTaskRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveTaskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveTaskRequest.Merge(m, src)
}
func (m *RemoveTaskRequest) XXX_Size() int {
	return m.Size()
}
func (m *RemoveTaskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveTaskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveTaskRequest proto.InternalMessageInfo

func (m *RemoveTaskRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *RemoveTaskRequest) GetCategory() v16.TaskCategory {
	if m != nil {
		return m.Category
	}
	return v16.TASK_CATEGORY_UNSPECIFIED
}

func (m *RemoveTaskRequest) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *RemoveTaskRequest) GetVisibilityTime() *time.Time {
	if m != nil {
		return m.VisibilityTime
	}
	return nil
}

type RemoveTaskResponse struct {
}

func (m *RemoveTaskResponse) Reset()      { *m = RemoveTaskResponse{} }
func (*RemoveTaskResponse) ProtoMessage() {}
func (*RemoveTaskResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{55}
}
func (m *RemoveTaskResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveTaskResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveTaskResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveTaskResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveTaskResponse.Merge(m, src)
}
func (m *RemoveTaskResponse) XXX_Size() int {
	return m.Size()
}
func (m *RemoveTaskResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveTaskResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveTaskResponse proto.InternalMessageInfo

type GetReplicationMessagesRequest struct {
	Tokens      []*v113.ReplicationToken `protobuf:"bytes,1,rep,name=tokens,proto3" json:"tokens,omitempty"`
	ClusterName string                   `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
}

func (m *GetReplicationMessagesRequest) Reset()      { *m = GetReplicationMessagesRequest{} }
func (*GetReplicationMessagesRequest) ProtoMessage() {}
func (*GetReplicationMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{56}
}
func (m *GetReplicationMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetReplicationMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetReplicationMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetReplicationMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReplicationMessagesRequest.Merge(m, src)
}
func (m *GetReplicationMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetReplicationMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReplicationMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetReplicationMessagesRequest proto.InternalMessageInfo

func (m *GetReplicationMessagesRequest) GetTokens() []*v113.ReplicationToken {
	if m != nil {
		return m.Tokens
	}
	return nil
}

func (m *GetReplicationMessagesRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

type GetReplicationMessagesResponse struct {
	ShardMessages map[int32]*v113.ReplicationMessages `protobuf:"bytes,1,rep,name=shard_messages,json=shardMessages,proto3" json:"shard_messages,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *GetReplicationMessagesResponse) Reset()      { *m = GetReplicationMessagesResponse{} }
func (*GetReplicationMessagesResponse) ProtoMessage() {}
func (*GetReplicationMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{57}
}
func (m *GetReplicationMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetReplicationMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetReplicationMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetReplicationMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReplicationMessagesResponse.Merge(m, src)
}
func (m *GetReplicationMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetReplicationMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReplicationMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetReplicationMessagesResponse proto.InternalMessageInfo

func (m *GetReplicationMessagesResponse) GetShardMessages() map[int32]*v113.ReplicationMessages {
	if m != nil {
		return m.ShardMessages
	}
	return nil
}

type GetDLQReplicationMessagesRequest struct {
	TaskInfos []*v113.ReplicationTaskInfo `protobuf:"bytes,1,rep,name=task_infos,json=taskInfos,proto3" json:"task_infos,omitempty"`
}

func (m *GetDLQReplicationMessagesRequest) Reset()      { *m = GetDLQReplicationMessagesRequest{} }
func (*GetDLQReplicationMessagesRequest) ProtoMessage() {}
func (*GetDLQReplicationMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{58}
}
func (m *GetDLQReplicationMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDLQReplicationMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDLQReplicationMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDLQReplicationMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDLQReplicationMessagesRequest.Merge(m, src)
}
func (m *GetDLQReplicationMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetDLQReplicationMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDLQReplicationMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDLQReplicationMessagesRequest proto.InternalMessageInfo

func (m *GetDLQReplicationMessagesRequest) GetTaskInfos() []*v113.ReplicationTaskInfo {
	if m != nil {
		return m.TaskInfos
	}
	return nil
}

type GetDLQReplicationMessagesResponse struct {
	ReplicationTasks []*v113.ReplicationTask `protobuf:"bytes,1,rep,name=replication_tasks,json=replicationTasks,proto3" json:"replication_tasks,omitempty"`
}

func (m *GetDLQReplicationMessagesResponse) Reset()      { *m = GetDLQReplicationMessagesResponse{} }
func (*GetDLQReplicationMessagesResponse) ProtoMessage() {}
func (*GetDLQReplicationMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{59}
}
func (m *GetDLQReplicationMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDLQReplicationMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDLQReplicationMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDLQReplicationMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDLQReplicationMessagesResponse.Merge(m, src)
}
func (m *GetDLQReplicationMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetDLQReplicationMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDLQReplicationMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDLQReplicationMessagesResponse proto.InternalMessageInfo

func (m *GetDLQReplicationMessagesResponse) GetReplicationTasks() []*v113.ReplicationTask {
	if m != nil {
		return m.ReplicationTasks
	}
	return nil
}

type QueryWorkflowRequest struct {
	NamespaceId string                   `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	Request     *v1.QueryWorkflowRequest `protobuf:"bytes,2,opt,name=request,proto3" json:"request,omitempty"`
}

func (m *QueryWorkflowRequest) Reset()      { *m = QueryWorkflowRequest{} }
func (*QueryWorkflowRequest) ProtoMessage() {}
func (*QueryWorkflowRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{60}
}
func (m *QueryWorkflowRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryWorkflowRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryWorkflowRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryWorkflowRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryWorkflowRequest.Merge(m, src)
}
func (m *QueryWorkflowRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryWorkflowRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryWorkflowRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryWorkflowRequest proto.InternalMessageInfo

func (m *QueryWorkflowRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *QueryWorkflowRequest) GetRequest() *v1.QueryWorkflowRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

type QueryWorkflowResponse struct {
	Response *v1.QueryWorkflowResponse `protobuf:"bytes,1,opt,name=response,proto3" json:"response,omitempty"`
}

func (m *QueryWorkflowResponse) Reset()      { *m = QueryWorkflowResponse{} }
func (*QueryWorkflowResponse) ProtoMessage() {}
func (*QueryWorkflowResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{61}
}
func (m *QueryWorkflowResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryWorkflowResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryWorkflowResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryWorkflowResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryWorkflowResponse.Merge(m, src)
}
func (m *QueryWorkflowResponse) XXX_Size() int {
	return m.Size()
}
func (m *QueryWorkflowResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryWorkflowResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryWorkflowResponse proto.InternalMessageInfo

func (m *QueryWorkflowResponse) GetResponse() *v1.QueryWorkflowResponse {
	if m != nil {
		return m.Response
	}
	return nil
}

type ReapplyEventsRequest struct {
	NamespaceId string                     `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	Request     *v114.ReapplyEventsRequest `protobuf:"bytes,2,opt,name=request,proto3" json:"request,omitempty"`
}

func (m *ReapplyEventsRequest) Reset()      { *m = ReapplyEventsRequest{} }
func (*ReapplyEventsRequest) ProtoMessage() {}
func (*ReapplyEventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{62}
}
func (m *ReapplyEventsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReapplyEventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReapplyEventsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReapplyEventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReapplyEventsRequest.Merge(m, src)
}
func (m *ReapplyEventsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ReapplyEventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReapplyEventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReapplyEventsRequest proto.InternalMessageInfo

func (m *ReapplyEventsRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *ReapplyEventsRequest) GetRequest() *v114.ReapplyEventsRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

type ReapplyEventsResponse struct {
}

func (m *ReapplyEventsResponse) Reset()      { *m = ReapplyEventsResponse{} }
func (*ReapplyEventsResponse) ProtoMessage() {}
func (*ReapplyEventsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{63}
}
func (m *ReapplyEventsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReapplyEventsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReapplyEventsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReapplyEventsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReapplyEventsResponse.Merge(m, src)
}
func (m *ReapplyEventsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ReapplyEventsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReapplyEventsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReapplyEventsResponse proto.InternalMessageInfo

type GetDLQMessagesRequest struct {
	Type                  v16.DeadLetterQueueType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.DeadLetterQueueType" json:"type,omitempty"`
	ShardId               int32                   `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	SourceCluster         string                  `protobuf:"bytes,3,opt,name=source_cluster,json=sourceCluster,proto3" json:"source_cluster,omitempty"`
	InclusiveEndMessageId int64                   `protobuf:"varint,4,opt,name=inclusive_end_message_id,json=inclusiveEndMessageId,proto3" json:"inclusive_end_message_id,omitempty"`
	MaximumPageSize       int32                   `protobuf:"varint,5,opt,name=maximum_page_size,json=maximumPageSize,proto3" json:"maximum_page_size,omitempty"`
	NextPageToken         []byte                  `protobuf:"bytes,6,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *GetDLQMessagesRequest) Reset()      { *m = GetDLQMessagesRequest{} }
func (*GetDLQMessagesRequest) ProtoMessage() {}
func (*GetDLQMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{64}
}
func (m *GetDLQMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDLQMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDLQMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDLQMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDLQMessagesRequest.Merge(m, src)
}
func (m *GetDLQMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetDLQMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDLQMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDLQMessagesRequest proto.InternalMessageInfo

func (m *GetDLQMessagesRequest) GetType() v16.DeadLetterQueueType {
	if m != nil {
		return m.Type
	}
	return v16.DEAD_LETTER_QUEUE_TYPE_UNSPECIFIED
}

func (m *GetDLQMessagesRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *GetDLQMessagesRequest) GetSourceCluster() string {
	if m != nil {
		return m.SourceCluster
	}
	return ""
}

func (m *GetDLQMessagesRequest) GetInclusiveEndMessageId() int64 {
	if m != nil {
		return m.InclusiveEndMessageId
	}
	return 0
}

func (m *GetDLQMessagesRequest) GetMaximumPageSize() int32 {
	if m != nil {
		return m.MaximumPageSize
	}
	return 0
}

func (m *GetDLQMessagesRequest) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type GetDLQMessagesResponse struct {
	Type             v16.DeadLetterQueueType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.DeadLetterQueueType" json:"type,omitempty"`
	ReplicationTasks []*v113.ReplicationTask `protobuf:"bytes,2,rep,name=replication_tasks,json=replicationTasks,proto3" json:"replication_tasks,omitempty"`
	NextPageToken    []byte                  `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *GetDLQMessagesResponse) Reset()      { *m = GetDLQMessagesResponse{} }
func (*GetDLQMessagesResponse) ProtoMessage() {}
func (*GetDLQMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{65}
}
func (m *GetDLQMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDLQMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDLQMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDLQMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDLQMessagesResponse.Merge(m, src)
}
func (m *GetDLQMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetDLQMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDLQMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDLQMessagesResponse proto.InternalMessageInfo

func (m *GetDLQMessagesResponse) GetType() v16.DeadLetterQueueType {
	if m != nil {
		return m.Type
	}
	return v16.DEAD_LETTER_QUEUE_TYPE_UNSPECIFIED
}

func (m *GetDLQMessagesResponse) GetReplicationTasks() []*v113.ReplicationTask {
	if m != nil {
		return m.ReplicationTasks
	}
	return nil
}

func (m *GetDLQMessagesResponse) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type PurgeDLQMessagesRequest struct {
	Type                  v16.DeadLetterQueueType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.DeadLetterQueueType" json:"type,omitempty"`
	ShardId               int32                   `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	SourceCluster         string                  `protobuf:"bytes,3,opt,name=source_cluster,json=sourceCluster,proto3" json:"source_cluster,omitempty"`
	InclusiveEndMessageId int64                   `protobuf:"varint,4,opt,name=inclusive_end_message_id,json=inclusiveEndMessageId,proto3" json:"inclusive_end_message_id,omitempty"`
}

func (m *PurgeDLQMessagesRequest) Reset()      { *m = PurgeDLQMessagesRequest{} }
func (*PurgeDLQMessagesRequest) ProtoMessage() {}
func (*PurgeDLQMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{66}
}
func (m *PurgeDLQMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PurgeDLQMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PurgeDLQMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PurgeDLQMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeDLQMessagesRequest.Merge(m, src)
}
func (m *PurgeDLQMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *PurgeDLQMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeDLQMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeDLQMessagesRequest proto.InternalMessageInfo

func (m *PurgeDLQMessagesRequest) GetType() v16.DeadLetterQueueType {
	if m != nil {
		return m.Type
	}
	return v16.DEAD_LETTER_QUEUE_TYPE_UNSPECIFIED
}

func (m *PurgeDLQMessagesRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *PurgeDLQMessagesRequest) GetSourceCluster() string {
	if m != nil {
		return m.SourceCluster
	}
	return ""
}

func (m *PurgeDLQMessagesRequest) GetInclusiveEndMessageId() int64 {
	if m != nil {
		return m.InclusiveEndMessageId
	}
	return 0
}

type PurgeDLQMessagesResponse struct {
}

func (m *PurgeDLQMessagesResponse) Reset()      { *m = PurgeDLQMessagesResponse{} }
func (*PurgeDLQMessagesResponse) ProtoMessage() {}
func (*PurgeDLQMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{67}
}
func (m *PurgeDLQMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PurgeDLQMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PurgeDLQMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PurgeDLQMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeDLQMessagesResponse.Merge(m, src)
}
func (m *PurgeDLQMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *PurgeDLQMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeDLQMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeDLQMessagesResponse proto.InternalMessageInfo

type MergeDLQMessagesRequest struct {
	Type                  v16.DeadLetterQueueType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.DeadLetterQueueType" json:"type,omitempty"`
	ShardId               int32                   `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	SourceCluster         string                  `protobuf:"bytes,3,opt,name=source_cluster,json=sourceCluster,proto3" json:"source_cluster,omitempty"`
	InclusiveEndMessageId int64                   `protobuf:"varint,4,opt,name=inclusive_end_message_id,json=inclusiveEndMessageId,proto3" json:"inclusive_end_message_id,omitempty"`
	MaximumPageSize       int32                   `protobuf:"varint,5,opt,name=maximum_page_size,json=maximumPageSize,proto3" json:"maximum_page_size,omitempty"`
	NextPageToken         []byte                  `protobuf:"bytes,6,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *MergeDLQMessagesRequest) Reset()      { *m = MergeDLQMessagesRequest{} }
func (*MergeDLQMessagesRequest) ProtoMessage() {}
func (*MergeDLQMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{68}
}
func (m *MergeDLQMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MergeDLQMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MergeDLQMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MergeDLQMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeDLQMessagesRequest.Merge(m, src)
}
func (m *MergeDLQMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *MergeDLQMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeDLQMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MergeDLQMessagesRequest proto.InternalMessageInfo

func (m *MergeDLQMessagesRequest) GetType() v16.DeadLetterQueueType {
	if m != nil {
		return m.Type
	}
	return v16.DEAD_LETTER_QUEUE_TYPE_UNSPECIFIED
}

func (m *MergeDLQMessagesRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *MergeDLQMessagesRequest) GetSourceCluster() string {
	if m != nil {
		return m.SourceCluster
	}
	return ""
}

func (m *MergeDLQMessagesRequest) GetInclusiveEndMessageId() int64 {
	if m != nil {
		return m.InclusiveEndMessageId
	}
	return 0
}

func (m *MergeDLQMessagesRequest) GetMaximumPageSize() int32 {
	if m != nil {
		return m.MaximumPageSize
	}
	return 0
}

func (m *MergeDLQMessagesRequest) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type MergeDLQMessagesResponse struct {
	NextPageToken []byte `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *MergeDLQMessagesResponse) Reset()      { *m = MergeDLQMessagesResponse{} }
func (*MergeDLQMessagesResponse) ProtoMessage() {}
func (*MergeDLQMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{69}
}
func (m *MergeDLQMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MergeDLQMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MergeDLQMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MergeDLQMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeDLQMessagesResponse.Merge(m, src)
}
func (m *MergeDLQMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *MergeDLQMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeDLQMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MergeDLQMessagesResponse proto.InternalMessageInfo

func (m *MergeDLQMessagesResponse) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type RefreshWorkflowTasksRequest struct {
	NamespaceId string                            `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	Request     *v114.RefreshWorkflowTasksRequest `protobuf:"bytes,2,opt,name=request,proto3" json:"request,omitempty"`
}

func (m *RefreshWorkflowTasksRequest) Reset()      { *m = RefreshWorkflowTasksRequest{} }
func (*RefreshWorkflowTasksRequest) ProtoMessage() {}
func (*RefreshWorkflowTasksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{70}
}
func (m *RefreshWorkflowTasksRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RefreshWorkflowTasksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RefreshWorkflowTasksRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RefreshWorkflowTasksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshWorkflowTasksRequest.Merge(m, src)
}
func (m *RefreshWorkflowTasksRequest) XXX_Size() int {
	return m.Size()
}
func (m *RefreshWorkflowTasksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshWorkflowTasksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshWorkflowTasksRequest proto.InternalMessageInfo

func (m *RefreshWorkflowTasksRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *RefreshWorkflowTasksRequest) GetRequest() *v114.RefreshWorkflowTasksRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

type RefreshWorkflowTasksResponse struct {
}

func (m *RefreshWorkflowTasksResponse) Reset()      { *m = RefreshWorkflowTasksResponse{} }
func (*RefreshWorkflowTasksResponse) ProtoMessage() {}
func (*RefreshWorkflowTasksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8c78c1d460a3711, []int{71}
}
func (m *RefreshWorkflowTasksResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RefreshWorkflowTasksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RefreshWorkflowTasksResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RefreshWorkflowTasksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshWorkflowTasksResponse.Merge(m, src)
}
func (m *RefreshWorkflowTasksResponse) XXX_Size() int {
	return m.Size()
}
func (m *RefreshWorkflowTasksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshWorkflowTasksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshWorkflowTasksResponse proto.InternalMessageInfo

func init() {
	proto.RegisterType((*StartWorkflowExecutionRequest)(nil), "temporal.server.api.historyservice.v1.StartWorkflowExecutionRequest")
	proto.RegisterType((*StartWorkflowExecutionResponse)(nil), "temporal.server.api.historyservice.v1.StartWorkflowExecutionResponse")
	proto.RegisterType((*GetMutableStateRequest)(nil), "temporal.server.api.historyservice.v1.GetMutableStateRequest")
	proto.RegisterType((*GetMutableStateResponse)(nil), "temporal.server.api.historyservice.v1.GetMutableStateResponse")
	proto.RegisterType((*PollMutableStateRequest)(nil), "temporal.server.api.historyservice.v1.PollMutableStateRequest")
	proto.RegisterType((*PollMutableStateResponse)(nil), "temporal.server.api.historyservice.v1.PollMutableStateResponse")
	proto.RegisterType((*ResetStickyTaskQueueRequest)(nil), "temporal.server.api.historyservice.v1.ResetStickyTaskQueueRequest")
	proto.RegisterType((*ResetStickyTaskQueueResponse)(nil), "temporal.server.api.historyservice.v1.ResetStickyTaskQueueResponse")
	proto.RegisterType((*RecordWorkflowTaskStartedRequest)(nil), "temporal.server.api.historyservice.v1.RecordWorkflowTaskStartedRequest")
	proto.RegisterType((*RecordWorkflowTaskStartedResponse)(nil), "temporal.server.api.historyservice.v1.RecordWorkflowTaskStartedResponse")
	proto.RegisterMapType((map[string]*v18.WorkflowQuery)(nil), "temporal.server.api.historyservice.v1.RecordWorkflowTaskStartedResponse.QueriesEntry")
	proto.RegisterType((*RecordActivityTaskStartedRequest)(nil), "temporal.server.api.historyservice.v1.RecordActivityTaskStartedRequest")
	proto.RegisterType((*RecordActivityTaskStartedResponse)(nil), "temporal.server.api.historyservice.v1.RecordActivityTaskStartedResponse")
	proto.RegisterType((*RespondWorkflowTaskCompletedRequest)(nil), "temporal.server.api.historyservice.v1.RespondWorkflowTaskCompletedRequest")
	proto.RegisterType((*RespondWorkflowTaskCompletedResponse)(nil), "temporal.server.api.historyservice.v1.RespondWorkflowTaskCompletedResponse")
	proto.RegisterType((*RespondWorkflowTaskFailedRequest)(nil), "temporal.server.api.historyservice.v1.RespondWorkflowTaskFailedRequest")
	proto.RegisterType((*RespondWorkflowTaskFailedResponse)(nil), "temporal.server.api.historyservice.v1.RespondWorkflowTaskFailedResponse")
	proto.RegisterType((*RecordActivityTaskHeartbeatRequest)(nil), "temporal.server.api.historyservice.v1.RecordActivityTaskHeartbeatRequest")
	proto.RegisterType((*RecordActivityTaskHeartbeatResponse)(nil), "temporal.server.api.historyservice.v1.RecordActivityTaskHeartbeatResponse")
	proto.RegisterType((*RespondActivityTaskCompletedRequest)(nil), "temporal.server.api.historyservice.v1.RespondActivityTaskCompletedRequest")
	proto.RegisterType((*RespondActivityTaskCompletedResponse)(nil), "temporal.server.api.historyservice.v1.RespondActivityTaskCompletedResponse")
	proto.RegisterType((*RespondActivityTaskFailedRequest)(nil), "temporal.server.api.historyservice.v1.RespondActivityTaskFailedRequest")
	proto.RegisterType((*RespondActivityTaskFailedResponse)(nil), "temporal.server.api.historyservice.v1.RespondActivityTaskFailedResponse")
	proto.RegisterType((*RespondActivityTaskCanceledRequest)(nil), "temporal.server.api.historyservice.v1.RespondActivityTaskCanceledRequest")
	proto.RegisterType((*RespondActivityTaskCanceledResponse)(nil), "temporal.server.api.historyservice.v1.RespondActivityTaskCanceledResponse")
	proto.RegisterType((*SignalWorkflowExecutionRequest)(nil), "temporal.server.api.historyservice.v1.SignalWorkflowExecutionRequest")
	proto.RegisterType((*SignalWorkflowExecutionResponse)(nil), "temporal.server.api.historyservice.v1.SignalWorkflowExecutionResponse")
	proto.RegisterType((*SignalWithStartWorkflowExecutionRequest)(nil), "temporal.server.api.historyservice.v1.SignalWithStartWorkflowExecutionRequest")
	proto.RegisterType((*SignalWithStartWorkflowExecutionResponse)(nil), "temporal.server.api.historyservice.v1.SignalWithStartWorkflowExecutionResponse")
	proto.RegisterType((*RemoveSignalMutableStateRequest)(nil), "temporal.server.api.historyservice.v1.RemoveSignalMutableStateRequest")
	proto.RegisterType((*RemoveSignalMutableStateResponse)(nil), "temporal.server.api.historyservice.v1.RemoveSignalMutableStateResponse")
	proto.RegisterType((*TerminateWorkflowExecutionRequest)(nil), "temporal.server.api.historyservice.v1.TerminateWorkflowExecutionRequest")
	proto.RegisterType((*TerminateWorkflowExecutionResponse)(nil), "temporal.server.api.historyservice.v1.TerminateWorkflowExecutionResponse")
	proto.RegisterType((*ResetWorkflowExecutionRequest)(nil), "temporal.server.api.historyservice.v1.ResetWorkflowExecutionRequest")
	proto.RegisterType((*ResetWorkflowExecutionResponse)(nil), "temporal.server.api.historyservice.v1.ResetWorkflowExecutionResponse")
	proto.RegisterType((*RequestCancelWorkflowExecutionRequest)(nil), "temporal.server.api.historyservice.v1.RequestCancelWorkflowExecutionRequest")
	proto.RegisterType((*RequestCancelWorkflowExecutionResponse)(nil), "temporal.server.api.historyservice.v1.RequestCancelWorkflowExecutionResponse")
	proto.RegisterType((*ScheduleWorkflowTaskRequest)(nil), "temporal.server.api.historyservice.v1.ScheduleWorkflowTaskRequest")
	proto.RegisterType((*ScheduleWorkflowTaskResponse)(nil), "temporal.server.api.historyservice.v1.ScheduleWorkflowTaskResponse")
	proto.RegisterType((*RecordChildExecutionCompletedRequest)(nil), "temporal.server.api.historyservice.v1.RecordChildExecutionCompletedRequest")
	proto.RegisterType((*RecordChildExecutionCompletedResponse)(nil), "temporal.server.api.historyservice.v1.RecordChildExecutionCompletedResponse")
	proto.RegisterType((*DescribeWorkflowExecutionRequest)(nil), "temporal.server.api.historyservice.v1.DescribeWorkflowExecutionRequest")
	proto.RegisterType((*DescribeWorkflowExecutionResponse)(nil), "temporal.server.api.historyservice.v1.DescribeWorkflowExecutionResponse")
	proto.RegisterType((*ReplicateEventsV2Request)(nil), "temporal.server.api.historyservice.v1.ReplicateEventsV2Request")
	proto.RegisterType((*ReplicateEventsV2Response)(nil), "temporal.server.api.historyservice.v1.ReplicateEventsV2Response")
	proto.RegisterType((*SyncShardStatusRequest)(nil), "temporal.server.api.historyservice.v1.SyncShardStatusRequest")
	proto.RegisterType((*SyncShardStatusResponse)(nil), "temporal.server.api.historyservice.v1.SyncShardStatusResponse")
	proto.RegisterType((*SyncActivityRequest)(nil), "temporal.server.api.historyservice.v1.SyncActivityRequest")
	proto.RegisterType((*SyncActivityResponse)(nil), "temporal.server.api.historyservice.v1.SyncActivityResponse")
	proto.RegisterType((*DescribeMutableStateRequest)(nil), "temporal.server.api.historyservice.v1.DescribeMutableStateRequest")
	proto.RegisterType((*DescribeMutableStateResponse)(nil), "temporal.server.api.historyservice.v1.DescribeMutableStateResponse")
	proto.RegisterType((*DescribeHistoryHostRequest)(nil), "temporal.server.api.historyservice.v1.DescribeHistoryHostRequest")
	proto.RegisterType((*DescribeHistoryHostResponse)(nil), "temporal.server.api.historyservice.v1.DescribeHistoryHostResponse")
	proto.RegisterType((*CloseShardRequest)(nil), "temporal.server.api.historyservice.v1.CloseShardRequest")
	proto.RegisterType((*CloseShardResponse)(nil), "temporal.server.api.historyservice.v1.CloseShardResponse")
	proto.RegisterType((*RemoveTaskRequest)(nil), "temporal.server.api.historyservice.v1.RemoveTaskRequest")
	proto.RegisterType((*RemoveTaskResponse)(nil), "temporal.server.api.historyservice.v1.RemoveTaskResponse")
	proto.RegisterType((*GetReplicationMessagesRequest)(nil), "temporal.server.api.historyservice.v1.GetReplicationMessagesRequest")
	proto.RegisterType((*GetReplicationMessagesResponse)(nil), "temporal.server.api.historyservice.v1.GetReplicationMessagesResponse")
	proto.RegisterMapType((map[int32]*v113.ReplicationMessages)(nil), "temporal.server.api.historyservice.v1.GetReplicationMessagesResponse.ShardMessagesEntry")
	proto.RegisterType((*GetDLQReplicationMessagesRequest)(nil), "temporal.server.api.historyservice.v1.GetDLQReplicationMessagesRequest")
	proto.RegisterType((*GetDLQReplicationMessagesResponse)(nil), "temporal.server.api.historyservice.v1.GetDLQReplicationMessagesResponse")
	proto.RegisterType((*QueryWorkflowRequest)(nil), "temporal.server.api.historyservice.v1.QueryWorkflowRequest")
	proto.RegisterType((*QueryWorkflowResponse)(nil), "temporal.server.api.historyservice.v1.QueryWorkflowResponse")
	proto.RegisterType((*ReapplyEventsRequest)(nil), "temporal.server.api.historyservice.v1.ReapplyEventsRequest")
	proto.RegisterType((*ReapplyEventsResponse)(nil), "temporal.server.api.historyservice.v1.ReapplyEventsResponse")
	proto.RegisterType((*GetDLQMessagesRequest)(nil), "temporal.server.api.historyservice.v1.GetDLQMessagesRequest")
	proto.RegisterType((*GetDLQMessagesResponse)(nil), "temporal.server.api.historyservice.v1.GetDLQMessagesResponse")
	proto.RegisterType((*PurgeDLQMessagesRequest)(nil), "temporal.server.api.historyservice.v1.PurgeDLQMessagesRequest")
	proto.RegisterType((*PurgeDLQMessagesResponse)(nil), "temporal.server.api.historyservice.v1.PurgeDLQMessagesResponse")
	proto.RegisterType((*MergeDLQMessagesRequest)(nil), "temporal.server.api.historyservice.v1.MergeDLQMessagesRequest")
	proto.RegisterType((*MergeDLQMessagesResponse)(nil), "temporal.server.api.historyservice.v1.MergeDLQMessagesResponse")
	proto.RegisterType((*RefreshWorkflowTasksRequest)(nil), "temporal.server.api.historyservice.v1.RefreshWorkflowTasksRequest")
	proto.RegisterType((*RefreshWorkflowTasksResponse)(nil), "temporal.server.api.historyservice.v1.RefreshWorkflowTasksResponse")
}

func init() {
	proto.RegisterFile("temporal/server/api/historyservice/v1/request_response.proto", fileDescriptor_b8c78c1d460a3711)
}

var fileDescriptor_b8c78c1d460a3711 = []byte{
	// 3673 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x5b, 0x49, 0x70, 0x1b, 0xc7,
	0xd5, 0xd6, 0x10, 0x5c, 0xc0, 0x07, 0x10, 0x04, 0x87, 0x1b, 0x48, 0x4a, 0x10, 0x39, 0xda, 0xe8,
	0x45, 0xa0, 0x96, 0xff, 0xb7, 0x64, 0xfd, 0xbf, 0xed, 0x5f, 0xa4, 0x36, 0xa8, 0x2c, 0x99, 0x1e,
	0xf2, 0x97, 0x5c, 0xde, 0xc6, 0x43, 0x4c, 0x93, 0x98, 0x9f, 0xc0, 0x0c, 0x34, 0x3d, 0x00, 0x05,
	0xff, 0x87, 0x6c, 0x95, 0x83, 0x93, 0xaa, 0x94, 0xaa, 0x72, 0x49, 0x55, 0x9c, 0x4b, 0x2e, 0xf1,
	0x25, 0xe5, 0x43, 0x0e, 0x29, 0x1f, 0x72, 0x4d, 0xe5, 0x16, 0x57, 0xaa, 0x52, 0x71, 0x25, 0x87,
	0xc4, 0xf2, 0x25, 0xa9, 0xe4, 0xe0, 0x83, 0x0f, 0x39, 0xa6, 0x7a, 0x1b, 0xcc, 0x86, 0x8d, 0x94,
	0x62, 0xc7, 0xf1, 0x0d, 0xd3, 0xfd, 0xde, 0xeb, 0x7e, 0xaf, 0xdf, 0xfb, 0xba, 0xfb, 0xf5, 0x03,
	0xfc, 0xb7, 0x8b, 0xaa, 0x35, 0xdb, 0xd1, 0x2b, 0x2b, 0x18, 0x39, 0x0d, 0xe4, 0xac, 0xe8, 0x35,
	0x73, 0xa5, 0x6c, 0x62, 0xd7, 0x76, 0x9a, 0xa4, 0xc5, 0x2c, 0xa1, 0x95, 0xc6, 0xd9, 0x15, 0x07,
	0xdd, 0xab, 0x23, 0xec, 0x6a, 0x0e, 0xc2, 0x35, 0xdb, 0xc2, 0xa8, 0x50, 0x73, 0x6c, 0xd7, 0x96,
	0x4f, 0x08, 0xee, 0x02, 0xe3, 0x2e, 0xe8, 0x35, 0xb3, 0x10, 0xe4, 0x2e, 0x34, 0xce, 0xce, 0xe7,
	0x77, 0x6c, 0x7b, 0xa7, 0x82, 0x56, 0x28, 0xd3, 0x56, 0x7d, 0x7b, 0xc5, 0xa8, 0x3b, 0xba, 0x6b,
	0xda, 0x16, 0x13, 0x33, 0x7f, 0x34, 0xdc, 0xef, 0x9a, 0x55, 0x84, 0x5d, 0xbd, 0x5a, 0xe3, 0x04,
	0x4b, 0x06, 0xaa, 0x21, 0xcb, 0x40, 0x56, 0xc9, 0x44, 0x78, 0x65, 0xc7, 0xde, 0xb1, 0x69, 0x3b,
	0xfd, 0xc5, 0x49, 0x8e, 0x7b, 0x8a, 0x10, 0x0d, 0x4a, 0x76, 0xb5, 0x6a, 0x5b, 0x64, 0xe6, 0x55,
	0x84, 0xb1, 0xbe, 0xc3, 0x27, 0x3c, 0x7f, 0x22, 0x40, 0xc5, 0x67, 0x1a, 0x25, 0x3b, 0x15, 0x20,
	0x73, 0x75, 0xbc, 0x7b, 0xaf, 0x8e, 0xea, 0x28, 0x4a, 0x18, 0x1c, 0x15, 0x59, 0xf5, 0x2a, 0x26,
	0x44, 0x7b, 0xb6, 0xb3, 0xbb, 0x5d, 0xb1, 0xf7, 0x38, 0xd5, 0xc9, 0x00, 0x95, 0xe8, 0x8c, 0x4a,
	0x3b, 0x16, 0xa0, 0xbb, 0x57, 0x47, 0x71, 0x73, 0x0b, 0xaa, 0xb0, 0xad, 0x9b, 0x95, 0xba, 0x13,
	0x33, 0xb3, 0xa7, 0x3b, 0x2c, 0x6c, 0x94, 0xfa, 0x89, 0x38, 0x6a, 0x4f, 0x1d, 0x66, 0x4d, 0x4e,
	0xfa, 0x54, 0x47, 0xd2, 0x90, 0xe6, 0xa7, 0x3a, 0x12, 0x13, 0xc3, 0x72, 0xc2, 0xd3, 0x71, 0x84,
	0xed, 0x2d, 0x55, 0x88, 0x23, 0xb7, 0xf4, 0x2a, 0xc2, 0x35, 0xbd, 0x14, 0x63, 0x8d, 0x33, 0x71,
	0xf4, 0x0e, 0xaa, 0x55, 0xcc, 0x12, 0x75, 0xc4, 0x28, 0xc7, 0x0b, 0x71, 0x1c, 0x35, 0xe4, 0x60,
	0x13, 0xbb, 0xc8, 0x62, 0x63, 0x88, 0xf9, 0x69, 0xd5, 0xba, 0xab, 0x6f, 0x55, 0x90, 0x86, 0x5d,
	0xdd, 0x15, 0x02, 0x9e, 0x89, 0x5d, 0xf4, 0xae, 0x31, 0x35, 0x7f, 0x29, 0x6e, 0x60, 0xdd, 0xa8,
	0x9a, 0x56, 0x57, 0x5e, 0xe5, 0xbb, 0xc3, 0x70, 0x64, 0xc3, 0xd5, 0x1d, 0xf7, 0x2e, 0x1f, 0xee,
	0xea, 0x7d, 0x54, 0xaa, 0x13, 0x05, 0x55, 0xc6, 0x20, 0x2f, 0x41, 0xda, 0x33, 0x93, 0x66, 0x1a,
	0x39, 0x69, 0x51, 0x5a, 0x1e, 0x55, 0x53, 0x5e, 0x5b, 0xd1, 0x90, 0x4b, 0x30, 0x86, 0x89, 0x0c,
	0x8d, 0x0f, 0x92, 0x1b, 0x58, 0x94, 0x96, 0x53, 0xe7, 0x9e, 0xf7, 0x6c, 0x4e, 0xa3, 0x3c, 0xa4,
	0x50, 0xa1, 0x71, 0xb6, 0xd0, 0x71, 0x64, 0x35, 0x4d, 0x85, 0x8a, 0x79, 0x94, 0x61, 0xba, 0xa6,
	0x3b, 0xc8, 0x72, 0x35, 0x24, 0x08, 0x35, 0xd3, 0xda, 0xb6, 0x73, 0x09, 0x3a, 0xd8, 0x7f, 0x14,
	0xe2, 0x90, 0xc5, 0x73, 0xae, 0xc6, 0xd9, 0xc2, 0x3a, 0xe5, 0xf6, 0x46, 0x29, 0x5a, 0xdb, 0xb6,
	0x3a, 0x59, 0x8b, 0x36, 0xca, 0x39, 0x18, 0xd1, 0x5d, 0x22, 0xcd, 0xcd, 0x0d, 0x2e, 0x4a, 0xcb,
	0x43, 0xaa, 0xf8, 0x94, 0xab, 0xa0, 0x78, 0x2b, 0xd8, 0x9a, 0x05, 0xba, 0x5f, 0x33, 0x19, 0x3a,
	0x69, 0x04, 0x86, 0x72, 0x43, 0x74, 0x42, 0xf3, 0x05, 0x86, 0x51, 0x05, 0x81, 0x51, 0x85, 0x4d,
	0x81, 0x51, 0xab, 0x83, 0x0f, 0xfe, 0x78, 0x54, 0x52, 0x8f, 0xee, 0x85, 0x35, 0xbf, 0xea, 0x49,
	0x22, 0xb4, 0x72, 0x19, 0xe6, 0x4a, 0xb6, 0xe5, 0x9a, 0x56, 0x1d, 0x69, 0x3a, 0xd6, 0x2c, 0xb4,
	0xa7, 0x99, 0x96, 0xe9, 0x9a, 0xba, 0x6b, 0x3b, 0xb9, 0xe1, 0x45, 0x69, 0x39, 0x73, 0xee, 0x74,
	0xd0, 0xc6, 0x34, 0x50, 0x88, 0xb2, 0x6b, 0x9c, 0xef, 0x32, 0xbe, 0x8d, 0xf6, 0x8a, 0x82, 0x49,
	0x9d, 0x29, 0xc5, 0xb6, 0xcb, 0xb7, 0x60, 0x42, 0xf4, 0x18, 0x1a, 0x47, 0x88, 0xdc, 0x08, 0xd5,
	0x63, 0x31, 0x38, 0x02, 0xef, 0x24, 0x63, 0x5c, 0x63, 0x3f, 0xd5, 0xac, 0xc7, 0xca, 0x5b, 0xe4,
	0x3b, 0x30, 0x53, 0xd1, 0xb1, 0xab, 0x95, 0xec, 0x6a, 0xad, 0x82, 0xa8, 0x65, 0x1c, 0x84, 0xeb,
	0x15, 0x37, 0x97, 0x8c, 0x93, 0xc9, 0xd1, 0x82, 0xae, 0x51, 0xb3, 0x62, 0xeb, 0x06, 0x56, 0xa7,
	0x08, 0xff, 0x9a, 0xc7, 0xae, 0x52, 0x6e, 0xf9, 0x4d, 0x58, 0xd8, 0x36, 0x1d, 0xec, 0x6a, 0xde,
	0x2a, 0x10, 0x40, 0xd0, 0xb6, 0xf4, 0xd2, 0xae, 0xbd, 0xbd, 0x9d, 0x1b, 0xa5, 0xc2, 0xe7, 0x22,
	0x86, 0xbf, 0xc2, 0x37, 0x8f, 0xd5, 0xc1, 0x1f, 0x10, 0xbb, 0xe7, 0xa8, 0x0c, 0xe1, 0x76, 0x9b,
	0x3a, 0xde, 0x5d, 0x65, 0x02, 0x94, 0x0b, 0x90, 0x6f, 0xe7, 0x92, 0x2c, 0x6a, 0xe4, 0x69, 0x18,
	0x76, 0xea, 0x56, 0x2b, 0x0e, 0x86, 0x9c, 0xba, 0x55, 0x34, 0x94, 0xbf, 0x4a, 0x30, 0x73, 0x1d,
	0xb9, 0xb7, 0x58, 0x54, 0x6f, 0x90, 0xa0, 0xee, 0x23, 0x7e, 0xae, 0xc3, 0xa8, 0xe7, 0x4d, 0x3c,
	0x76, 0x9e, 0x68, 0x67, 0xa1, 0xe8, 0xd4, 0x5a, 0xbc, 0xf2, 0x79, 0x98, 0x41, 0xf7, 0x6b, 0xa8,
	0xe4, 0x22, 0x43, 0xb3, 0xd0, 0x7d, 0x57, 0x43, 0x0d, 0x12, 0x30, 0xa6, 0x41, 0x83, 0x24, 0xa1,
	0x4e, 0x8a, 0xde, 0xdb, 0xe8, 0xbe, 0x7b, 0x95, 0xf4, 0x15, 0x0d, 0xf9, 0x0c, 0x4c, 0x95, 0xea,
	0x0e, 0x8d, 0xac, 0x2d, 0x47, 0xb7, 0x4a, 0x65, 0xcd, 0xb5, 0x77, 0x91, 0x45, 0x7d, 0x3f, 0xad,
	0xca, 0xbc, 0x6f, 0x95, 0x76, 0x6d, 0x92, 0x1e, 0xe5, 0xb3, 0x11, 0x98, 0x8d, 0x68, 0xcb, 0x0d,
	0x14, 0xd0, 0x45, 0x3a, 0x80, 0x2e, 0x45, 0x18, 0x6b, 0xad, 0x72, 0xb3, 0x86, 0xb8, 0x61, 0x8e,
	0x77, 0x13, 0xb6, 0xd9, 0xac, 0x21, 0x35, 0xbd, 0xe7, 0xfb, 0x92, 0x15, 0x18, 0x8b, 0xb3, 0x46,
	0xca, 0xf2, 0x59, 0xe1, 0x59, 0x98, 0xab, 0x39, 0xa8, 0x61, 0xda, 0x75, 0xac, 0x51, 0xdc, 0x41,
	0x46, 0x8b, 0x7e, 0x90, 0xd2, 0xcf, 0x08, 0x82, 0x0d, 0xd6, 0x2f, 0x58, 0x4f, 0xc3, 0x24, 0xf5,
	0x76, 0xe6, 0x9a, 0x1e, 0xd3, 0x10, 0x65, 0xca, 0x92, 0xae, 0x6b, 0xa4, 0x47, 0x90, 0xaf, 0x01,
	0x50, 0xaf, 0xa5, 0x07, 0x04, 0x1a, 0xc6, 0x11, 0xad, 0xbc, 0xf3, 0x03, 0x51, 0x8c, 0x38, 0xe8,
	0xcb, 0xe4, 0x43, 0x1d, 0x75, 0xc5, 0x4f, 0x79, 0x1d, 0x26, 0xb0, 0x6b, 0x96, 0x76, 0x9b, 0x9a,
	0x4f, 0xd6, 0x48, 0x1f, 0xb2, 0xc6, 0x19, 0xbb, 0xd7, 0x20, 0xff, 0x3f, 0x3c, 0x15, 0x91, 0xa8,
	0xe1, 0x52, 0x19, 0x19, 0xf5, 0x0a, 0xd2, 0x5c, 0x9b, 0x59, 0x85, 0x22, 0x9c, 0x5d, 0x77, 0x73,
	0xa9, 0xde, 0x62, 0xed, 0x44, 0x68, 0x98, 0x0d, 0x2e, 0x70, 0xd3, 0xa6, 0x46, 0xdc, 0x64, 0xd2,
	0xda, 0xfa, 0xe0, 0x58, 0x3b, 0x1f, 0x94, 0x5f, 0x83, 0x8c, 0xe7, 0x1e, 0x74, 0x13, 0xcd, 0x8d,
	0x53, 0x40, 0x8c, 0xdf, 0x07, 0x3c, 0x5c, 0x8c, 0xb8, 0x1c, 0xf3, 0x5e, 0xcf, 0xd5, 0xe8, 0xa7,
	0x7c, 0x17, 0xc6, 0x03, 0xc2, 0xeb, 0x38, 0x97, 0xa5, 0xd2, 0x0b, 0x6d, 0xe0, 0x36, 0x56, 0x6c,
	0x1d, 0xab, 0x19, 0xbf, 0xdc, 0x3a, 0x96, 0xdf, 0x80, 0x89, 0x06, 0x39, 0x11, 0xd8, 0x96, 0xc6,
	0x4e, 0x56, 0x26, 0xc2, 0xb9, 0x09, 0x6a, 0xca, 0x33, 0x85, 0x0e, 0x47, 0x63, 0x32, 0xc6, 0x1d,
	0xc6, 0x78, 0x43, 0xf0, 0xa9, 0xd9, 0x46, 0xa8, 0x45, 0x7e, 0x1e, 0x0e, 0x9b, 0xc4, 0x7d, 0xc3,
	0xcb, 0x88, 0x2c, 0x12, 0xa8, 0x46, 0x4e, 0x5e, 0x94, 0x96, 0x93, 0x6a, 0xce, 0xc4, 0x1b, 0xc1,
	0x55, 0xb9, 0xca, 0xfa, 0x6f, 0x0e, 0x26, 0x93, 0xd9, 0xd1, 0x9b, 0x83, 0xc9, 0xd1, 0x2c, 0xdc,
	0x1c, 0x4c, 0x42, 0x36, 0x75, 0x73, 0x30, 0x99, 0xce, 0x8e, 0xdd, 0x1c, 0x4c, 0x66, 0xb2, 0xe3,
	0xca, 0xdf, 0x24, 0x98, 0x5d, 0xb7, 0x2b, 0x95, 0x7f, 0x13, 0x94, 0x7b, 0x7f, 0x04, 0x72, 0x51,
	0x75, 0xbf, 0x82, 0xb9, 0xaf, 0x60, 0xee, 0x91, 0xc3, 0x5c, 0xba, 0x2d, 0xcc, 0xc5, 0x02, 0x46,
	0xe6, 0x91, 0x01, 0xc6, 0xbf, 0x24, 0x8a, 0xc6, 0xc2, 0xd4, 0x58, 0x36, 0xa3, 0xbc, 0x23, 0xc1,
	0x82, 0x8a, 0x30, 0x72, 0x43, 0xf0, 0xf6, 0x39, 0x80, 0x94, 0x92, 0x87, 0xc3, 0xf1, 0x53, 0x61,
	0x00, 0xa2, 0xfc, 0x7e, 0x00, 0x16, 0x55, 0x54, 0xb2, 0x1d, 0xc3, 0x7f, 0x10, 0xe5, 0x21, 0xd7,
	0xc7, 0x84, 0x5f, 0x01, 0x39, 0x7a, 0x25, 0xe9, 0x7f, 0xe6, 0x13, 0x91, 0xbb, 0x88, 0x7c, 0x14,
	0x52, 0x5e, 0x5c, 0x78, 0x60, 0x02, 0xa2, 0xa9, 0x68, 0xc8, 0xb3, 0x30, 0x42, 0x63, 0xc8, 0x43,
	0x8e, 0x61, 0xf2, 0x59, 0x34, 0xe4, 0x23, 0x00, 0xe2, 0xba, 0xc9, 0x01, 0x62, 0x54, 0x1d, 0xe5,
	0x2d, 0x45, 0x43, 0x7e, 0x0b, 0xd2, 0x35, 0xbb, 0x52, 0xf1, 0x6e, 0x8b, 0x0c, 0x1b, 0x9e, 0xeb,
	0x7a, 0x5b, 0x24, 0x60, 0xec, 0x37, 0x96, 0x7f, 0x6d, 0xd5, 0x14, 0x11, 0xc9, 0x3f, 0x94, 0xdf,
	0x8e, 0xc0, 0x52, 0x07, 0xe3, 0x72, 0x0c, 0x8f, 0x40, 0xaf, 0xb4, 0x6f, 0xe8, 0xed, 0x08, 0xab,
	0x03, 0x1d, 0x61, 0xf5, 0x69, 0x90, 0x85, 0x4d, 0x8d, 0x30, 0x74, 0x67, 0xbd, 0x1e, 0x41, 0xbd,
	0x0c, 0xd9, 0x36, 0xb0, 0x9d, 0xc1, 0x41, 0xb9, 0x91, 0xdd, 0x60, 0x28, 0xba, 0x1b, 0xf8, 0x6e,
	0xba, 0xc3, 0xc1, 0x9b, 0xee, 0x45, 0xc8, 0x71, 0x98, 0xf4, 0xdd, 0x73, 0xf9, 0x29, 0x62, 0x84,
	0x9e, 0x22, 0x66, 0x58, 0x7f, 0xeb, 0xee, 0xca, 0x7a, 0xe5, 0x1d, 0x9f, 0x43, 0x32, 0xf7, 0x20,
	0x97, 0x74, 0x76, 0xef, 0x7b, 0xb6, 0x1b, 0x64, 0x6d, 0x3a, 0xba, 0x85, 0x4d, 0x64, 0x05, 0x6e,
	0x67, 0xf4, 0xa6, 0x9e, 0xdd, 0x0b, 0xb5, 0xc8, 0x3b, 0x70, 0x24, 0xe6, 0x32, 0xee, 0xdb, 0x27,
	0x46, 0xfb, 0xd8, 0x27, 0xe6, 0x23, 0xfe, 0xdf, 0xda, 0x32, 0x96, 0x20, 0x1d, 0x40, 0xeb, 0x14,
	0x45, 0xeb, 0xd4, 0x96, 0x0f, 0xa6, 0xaf, 0x43, 0xa6, 0xb5, 0x88, 0x34, 0x09, 0x90, 0xee, 0x31,
	0x09, 0x30, 0xe6, 0xf1, 0xd1, 0x2b, 0xff, 0x1a, 0xa4, 0xc5, 0xfa, 0x52, 0x31, 0x63, 0x3d, 0x8a,
	0x49, 0x71, 0x2e, 0x2a, 0xc4, 0x86, 0x91, 0x7b, 0x75, 0xc4, 0xb7, 0x8a, 0xc4, 0x72, 0xea, 0xdc,
	0xff, 0x16, 0x7a, 0x4a, 0xbb, 0x16, 0xba, 0xc6, 0x4c, 0xe1, 0x65, 0x26, 0xf7, 0xaa, 0xe5, 0x3a,
	0x4d, 0x55, 0x8c, 0x32, 0xff, 0x16, 0xa4, 0xfd, 0x1d, 0x72, 0x16, 0x12, 0xbb, 0xa8, 0xc9, 0xe1,
	0x8a, 0xfc, 0x94, 0x2f, 0xc1, 0x50, 0x43, 0xaf, 0xd4, 0xdb, 0x1c, 0x6f, 0x68, 0xe2, 0xd2, 0x1f,
	0x62, 0x44, 0x5a, 0x53, 0x65, 0x2c, 0x97, 0x06, 0x2e, 0x4a, 0x0c, 0xe6, 0x7d, 0xa0, 0x79, 0xb9,
	0xe4, 0x9a, 0x0d, 0xd3, 0x6d, 0x7e, 0x05, 0x9a, 0x3d, 0x80, 0xa6, 0xdf, 0x58, 0xed, 0x41, 0xf3,
	0x9b, 0x83, 0x02, 0x34, 0x63, 0x8d, 0xcb, 0x41, 0xf3, 0x36, 0x8c, 0x87, 0xe0, 0x8a, 0xc3, 0xe6,
	0x89, 0xe0, 0x54, 0x7c, 0x41, 0xcd, 0x8e, 0x1b, 0x4d, 0x0a, 0x3a, 0x6a, 0x26, 0x08, 0x69, 0x11,
	0x87, 0x1f, 0xd8, 0x8f, 0xc3, 0xfb, 0x70, 0x2c, 0x11, 0xc4, 0x31, 0x04, 0x79, 0x71, 0xe2, 0xe2,
	0x4d, 0x5a, 0x28, 0x50, 0x07, 0x7b, 0x1c, 0x70, 0x81, 0xcb, 0xb9, 0xcc, 0xc4, 0x6c, 0x04, 0xc2,
	0xf6, 0x16, 0x4c, 0x94, 0x91, 0xee, 0xb8, 0x5b, 0x48, 0x77, 0x35, 0x03, 0xb9, 0xba, 0x59, 0xc1,
	0x3c, 0x0f, 0xd8, 0x3d, 0xd7, 0x95, 0xf5, 0x58, 0xaf, 0x30, 0xce, 0xe8, 0xce, 0x34, 0xbc, 0xef,
	0x9d, 0xe9, 0xb4, 0xcf, 0xd5, 0xbd, 0x10, 0xa0, 0x10, 0x3e, 0xda, 0xf2, 0xdf, 0xdb, 0xa2, 0x43,
	0xf9, 0x40, 0x82, 0x63, 0x6c, 0xad, 0x03, 0x30, 0xc0, 0x33, 0x71, 0x7d, 0x05, 0x99, 0x0d, 0x59,
	0x9e, 0xff, 0x43, 0xa1, 0xc4, 0xf0, 0x95, 0xae, 0x5e, 0xdb, 0xc3, 0x14, 0xd4, 0x71, 0x21, 0x5d,
	0x38, 0xf0, 0x0f, 0x25, 0x38, 0xde, 0x99, 0x91, 0xfb, 0x30, 0x6e, 0x6d, 0xa2, 0x22, 0x1d, 0xce,
	0x9d, 0xf8, 0xc6, 0xa3, 0x02, 0x4a, 0x72, 0xf1, 0x08, 0x34, 0x28, 0xef, 0x4b, 0x04, 0xbb, 0x22,
	0xb3, 0xbb, 0xa6, 0x9b, 0x95, 0xbe, 0xcc, 0x5a, 0x86, 0xcc, 0x36, 0xe5, 0x09, 0x19, 0xf5, 0xf2,
	0x7e, 0x8c, 0x1a, 0x18, 0x5d, 0x1d, 0xdb, 0xf6, 0x7f, 0x2a, 0xc7, 0x08, 0x1e, 0xb4, 0x65, 0xe1,
	0x6a, 0x7d, 0x20, 0x81, 0x12, 0x45, 0x8d, 0x1b, 0xc2, 0xa3, 0xfb, 0x50, 0xac, 0xe6, 0x8f, 0xa1,
	0xa0, 0x6e, 0x6b, 0x3d, 0xe8, 0xd6, 0x6d, 0x0a, 0xbe, 0x30, 0x13, 0x0a, 0xae, 0x13, 0x5f, 0xef,
	0xc0, 0xc7, 0xdd, 0xe5, 0x09, 0xc8, 0x96, 0x74, 0xab, 0x84, 0x3c, 0xf0, 0x45, 0x6c, 0xfe, 0x49,
	0x75, 0x9c, 0xb5, 0xab, 0xa2, 0xd9, 0x1f, 0x3e, 0x7e, 0x99, 0x9f, 0x53, 0xf8, 0x74, 0x9a, 0x42,
	0x34, 0x7c, 0x4e, 0x7a, 0xd1, 0xd3, 0x86, 0x2f, 0xea, 0xc8, 0x7e, 0xc2, 0x7f, 0xbe, 0x23, 0xb7,
	0x1d, 0xbd, 0xbd, 0x23, 0xc7, 0xb1, 0x70, 0xb5, 0x7e, 0x46, 0x1d, 0x39, 0xaa, 0x3f, 0x5d, 0xe1,
	0xbe, 0x14, 0xfb, 0x3f, 0xc8, 0x04, 0xfd, 0xa5, 0x0f, 0x2f, 0xee, 0x36, 0xbe, 0x3a, 0x16, 0x70,
	0x39, 0xe5, 0x44, 0xbc, 0xbf, 0x79, 0x4c, 0x5c, 0xb9, 0x5f, 0x0e, 0x40, 0x7e, 0xc3, 0xdc, 0xb1,
	0xf4, 0xca, 0x41, 0xde, 0xf9, 0xb6, 0x21, 0x83, 0xa9, 0x90, 0x90, 0x62, 0x2f, 0x74, 0x7f, 0xe8,
	0xeb, 0x38, 0xb6, 0x3a, 0xc6, 0xc4, 0x8a, 0xa9, 0x98, 0xb0, 0x80, 0xee, 0xbb, 0xc8, 0x21, 0x23,
	0xc5, 0x9c, 0xd3, 0x12, 0xfd, 0x9e, 0xd3, 0xe6, 0x84, 0xb4, 0x48, 0x97, 0x5c, 0x80, 0xc9, 0x52,
	0xd9, 0xac, 0x18, 0xad, 0x71, 0x6c, 0xab, 0xd2, 0xa4, 0x87, 0x82, 0xa4, 0x3a, 0x41, 0xbb, 0x04,
	0xd3, 0x4b, 0x56, 0xa5, 0xa9, 0x2c, 0xc1, 0xd1, 0xb6, 0xba, 0x70, 0x5b, 0xff, 0x46, 0x82, 0x53,
	0x9c, 0xc6, 0x74, 0xcb, 0x07, 0x7e, 0x5c, 0xfd, 0x96, 0x04, 0x73, 0xdc, 0xea, 0x7b, 0xa6, 0x5b,
	0xd6, 0xe2, 0x5e, 0x5a, 0x6f, 0xf4, 0xba, 0x00, 0xdd, 0x26, 0xa4, 0xce, 0xe0, 0x20, 0xa1, 0xf0,
	0xb3, 0xcb, 0xb0, 0xdc, 0x5d, 0x44, 0xe7, 0x37, 0xb2, 0x5f, 0x48, 0x70, 0x54, 0x45, 0x55, 0xbb,
	0x81, 0x98, 0xa4, 0x7d, 0xa6, 0x91, 0x1f, 0xdf, 0xd9, 0x3d, 0x78, 0x02, 0x4f, 0x84, 0x4e, 0xe0,
	0x8a, 0x42, 0x60, 0xaf, 0xdd, 0xf4, 0xf9, 0xda, 0xff, 0x5c, 0x82, 0xa5, 0x4d, 0xe4, 0x54, 0x4d,
	0x4b, 0x77, 0xd1, 0x41, 0x56, 0xdd, 0x86, 0x09, 0x57, 0xc8, 0x09, 0x2d, 0xf6, 0x6a, 0xd7, 0xc5,
	0xee, 0x3a, 0x03, 0x35, 0xeb, 0x09, 0x17, 0x0b, 0x7c, 0x1c, 0x94, 0x4e, 0x6c, 0x5c, 0xbf, 0x9f,
	0x48, 0x70, 0x84, 0xa6, 0xb5, 0x0e, 0x58, 0x2e, 0xe0, 0x10, 0x19, 0x7d, 0x97, 0x0b, 0x74, 0x1c,
	0x59, 0x4d, 0x53, 0xa1, 0x42, 0x9f, 0x0b, 0x90, 0x6f, 0x47, 0xde, 0xd9, 0x4d, 0xbf, 0x9f, 0x80,
	0x13, 0x5c, 0x08, 0x83, 0xd1, 0x83, 0xa8, 0x5a, 0x6d, 0xb3, 0x15, 0x5c, 0xeb, 0x41, 0xd7, 0x1e,
	0xa6, 0x10, 0xda, 0x0d, 0xe4, 0xe7, 0x7c, 0xc0, 0xc9, 0x2b, 0x05, 0xa2, 0x49, 0xa5, 0x9c, 0x20,
	0x29, 0x0a, 0x0a, 0x91, 0x0e, 0xea, 0x82, 0xbb, 0x83, 0x8f, 0x1f, 0x77, 0x87, 0xda, 0xe1, 0xee,
	0x32, 0x9c, 0xec, 0x66, 0x11, 0xee, 0xa2, 0xbf, 0x96, 0x60, 0x41, 0x5c, 0xce, 0xfc, 0xe7, 0xd6,
	0x2f, 0x04, 0xc4, 0x9c, 0x87, 0x19, 0x13, 0x6b, 0x31, 0x35, 0x0c, 0x74, 0x6d, 0x92, 0xea, 0xa4,
	0x89, 0xaf, 0x85, 0x8b, 0x13, 0x94, 0x3c, 0x1c, 0x8e, 0x57, 0x88, 0x6b, 0xfc, 0xd9, 0x00, 0x39,
	0xb9, 0x91, 0x73, 0xec, 0x1a, 0xb1, 0x9b, 0x37, 0xda, 0x7e, 0x4e, 0x9d, 0x8f, 0x4f, 0xf5, 0x25,
	0x48, 0xb7, 0x5c, 0xb2, 0xf5, 0x38, 0xe5, 0xb5, 0x15, 0x0d, 0xf9, 0x55, 0x98, 0x14, 0x87, 0x52,
	0xe3, 0x20, 0x7e, 0x27, 0x7b, 0x52, 0x5a, 0xc3, 0xaf, 0x7b, 0xc7, 0x69, 0x9a, 0xca, 0xa4, 0x89,
	0x8b, 0xa1, 0x7e, 0x12, 0x17, 0xe3, 0x2d, 0x76, 0xda, 0xa0, 0x9c, 0x22, 0x38, 0xd1, 0xd1, 0xea,
	0x7c, 0x7d, 0x7e, 0x2c, 0xc1, 0xe2, 0x15, 0x84, 0x4b, 0x8e, 0xb9, 0x75, 0xa0, 0x3d, 0xe1, 0x35,
	0x18, 0xe9, 0xf7, 0xa4, 0xdc, 0x6d, 0x58, 0x55, 0x48, 0x54, 0xde, 0x4b, 0xc0, 0x52, 0x07, 0x6a,
	0x8e, 0x99, 0xaf, 0x43, 0xb6, 0x95, 0x6a, 0x2d, 0xd9, 0xd6, 0xb6, 0xb9, 0xc3, 0x6f, 0xce, 0x67,
	0xe3, 0xe7, 0x12, 0xbb, 0x40, 0x6b, 0x94, 0x51, 0x1d, 0x47, 0xc1, 0x06, 0x79, 0x07, 0x66, 0x63,
	0x32, 0xba, 0x34, 0x7f, 0xcc, 0x14, 0x5e, 0xe9, 0x63, 0x10, 0x9a, 0x35, 0x9e, 0xde, 0x8b, 0x6b,
	0x96, 0x5f, 0x07, 0xb9, 0x86, 0x2c, 0xc3, 0xb4, 0x76, 0x34, 0x9d, 0x1d, 0x9b, 0x4d, 0x84, 0x73,
	0x09, 0x9a, 0x2b, 0x3d, 0xdd, 0x7e, 0x8c, 0x75, 0xc6, 0x23, 0x4e, 0xda, 0x74, 0x84, 0x89, 0x5a,
	0xa0, 0xd1, 0x44, 0x58, 0x7e, 0x13, 0xb2, 0x42, 0x3a, 0x05, 0x32, 0x87, 0x3e, 0x33, 0x13, 0xd9,
	0xe7, 0xbb, 0xca, 0x0e, 0xfa, 0x12, 0x1d, 0x61, 0xbc, 0xe6, 0xeb, 0x72, 0x90, 0xa5, 0x7c, 0x23,
	0x01, 0x39, 0x95, 0x57, 0x22, 0x22, 0xea, 0x8b, 0xf8, 0xce, 0xb9, 0x2f, 0x44, 0x8c, 0x6f, 0xc3,
	0x74, 0xf0, 0xb5, 0xb2, 0xa9, 0x99, 0x2e, 0xaa, 0x0a, 0xd3, 0x9e, 0xeb, 0xeb, 0xc5, 0xb2, 0x59,
	0x74, 0x51, 0x55, 0x9d, 0x6c, 0x44, 0xda, 0xb0, 0x7c, 0x11, 0x86, 0x69, 0x04, 0x63, 0x8e, 0x0d,
	0x6d, 0x73, 0x6c, 0x57, 0x74, 0x57, 0x5f, 0xad, 0xd8, 0x5b, 0x2a, 0xa7, 0x97, 0xaf, 0x41, 0xc6,
	0x42, 0x7b, 0x1a, 0xd9, 0xf8, 0xb9, 0x84, 0xa1, 0x1e, 0x25, 0xa4, 0x2d, 0xb4, 0xa7, 0xd6, 0x59,
	0xec, 0x63, 0x65, 0x01, 0xe6, 0x62, 0x96, 0x80, 0x07, 0xfc, 0x8f, 0x24, 0x98, 0xd9, 0x68, 0x5a,
	0xa5, 0x8d, 0xb2, 0xee, 0x18, 0xfc, 0x0d, 0x93, 0x2f, 0xcf, 0x09, 0xc8, 0x60, 0xbb, 0xee, 0x94,
	0x90, 0x56, 0xaa, 0xd4, 0xb1, 0x8b, 0x1c, 0xbe, 0x40, 0x63, 0xac, 0x75, 0x8d, 0x35, 0xca, 0x73,
	0x90, 0xc4, 0x84, 0x59, 0x3c, 0x1f, 0x0d, 0xa9, 0x23, 0xf4, 0xbb, 0x68, 0xc8, 0x97, 0x21, 0xc5,
	0x1e, 0x53, 0x59, 0xfa, 0x32, 0xd1, 0x63, 0xfa, 0x12, 0x18, 0x13, 0x69, 0x56, 0xe6, 0x60, 0x36,
	0x32, 0x3d, 0x71, 0x79, 0x19, 0x82, 0x49, 0xd2, 0x27, 0x7c, 0xbc, 0x0f, 0xb7, 0x3a, 0x0a, 0x29,
	0xcf, 0xad, 0xf8, 0xb4, 0x47, 0x55, 0x10, 0x4d, 0x45, 0xc3, 0x77, 0xe0, 0x4a, 0xf8, 0x0e, 0x5c,
	0x72, 0x0e, 0x46, 0xf8, 0x1a, 0xf3, 0x8c, 0xb8, 0xf8, 0x24, 0x83, 0xb6, 0x92, 0xb5, 0xad, 0x17,
	0x2c, 0xaf, 0x8d, 0xbe, 0xd7, 0x86, 0x1f, 0x5e, 0x86, 0xf7, 0xf7, 0xf0, 0x72, 0x04, 0x40, 0xe4,
	0x04, 0x4d, 0xf6, 0xc4, 0x95, 0x50, 0x47, 0x79, 0x0b, 0xad, 0x66, 0x08, 0xa6, 0xa9, 0x93, 0xfb,
	0x49, 0x53, 0xaf, 0xf3, 0x0a, 0x8a, 0x56, 0x9a, 0x8b, 0xca, 0x1a, 0xed, 0x51, 0xd6, 0x04, 0x61,
	0xf6, 0xd2, 0x53, 0x54, 0xe2, 0x25, 0x18, 0x11, 0xd9, 0x66, 0xe8, 0x31, 0xdb, 0x2c, 0x18, 0xfc,
	0x49, 0xf3, 0x54, 0x30, 0x69, 0xbe, 0x06, 0x69, 0x56, 0xe9, 0xc1, 0x0b, 0x41, 0xd3, 0x3d, 0x16,
	0x82, 0xa6, 0x68, 0x11, 0x08, 0xaf, 0x01, 0x3d, 0x03, 0xb4, 0x86, 0x93, 0x1e, 0x73, 0x90, 0xa3,
	0x99, 0x06, 0xb2, 0x5c, 0xd3, 0x6d, 0xd2, 0x17, 0xad, 0x51, 0x55, 0x26, 0x7d, 0x77, 0x69, 0x57,
	0x91, 0xf7, 0xc8, 0x77, 0x61, 0x3c, 0x84, 0x1e, 0xbc, 0xd2, 0xa1, 0xd0, 0x1f, 0x6e, 0xa8, 0x99,
	0x20, 0x66, 0x28, 0x33, 0x30, 0x15, 0xf4, 0x69, 0xee, 0xec, 0xef, 0x48, 0xb0, 0x20, 0xf6, 0xbc,
	0xcf, 0xb9, 0xa8, 0x49, 0xf9, 0xbb, 0x04, 0x87, 0xe3, 0xe7, 0xc2, 0xb7, 0xde, 0x32, 0x4c, 0x96,
	0xf4, 0x52, 0x19, 0x05, 0x4b, 0xc7, 0xf9, 0xee, 0x7b, 0x31, 0xd6, 0x42, 0xbe, 0xe2, 0x73, 0xff,
	0xf8, 0x01, 0xf1, 0x13, 0x54, 0xa8, 0xbf, 0x49, 0xb6, 0x60, 0xc6, 0xd0, 0x5d, 0x7d, 0x4b, 0xc7,
	0xe1, 0xc1, 0x06, 0x0e, 0x38, 0xd8, 0x94, 0x90, 0xeb, 0x6f, 0x55, 0x7e, 0x27, 0xc1, 0xbc, 0x50,
	0x9d, 0x2f, 0xd9, 0x0d, 0x1b, 0xfb, 0x53, 0xc7, 0x65, 0x1b, 0xbb, 0x9a, 0x6e, 0x18, 0x0e, 0xc2,
	0x58, 0xac, 0x02, 0x69, 0xbb, 0xcc, 0x9a, 0x3a, 0xc1, 0x65, 0x78, 0x0d, 0x13, 0xbd, 0xee, 0x87,
	0x83, 0x07, 0xdf, 0x0f, 0x95, 0x07, 0x03, 0x2d, 0x07, 0x0b, 0x68, 0xc6, 0xd7, 0xf4, 0x18, 0x8c,
	0xd1, 0x79, 0x62, 0xcd, 0xaa, 0x57, 0xb7, 0xf8, 0x66, 0x30, 0xa4, 0xa6, 0x59, 0xe3, 0x6d, 0xda,
	0x26, 0x2f, 0xc0, 0xa8, 0x50, 0x0e, 0xe7, 0x06, 0x16, 0x13, 0xcb, 0x43, 0x6a, 0x92, 0x6b, 0x87,
	0xe5, 0x37, 0x60, 0xbc, 0xa5, 0x1e, 0x5d, 0xca, 0x8e, 0xf5, 0xf0, 0x1e, 0x2d, 0x51, 0xc1, 0x7b,
	0xf5, 0x59, 0x23, 0x7c, 0xf4, 0xac, 0x91, 0xb1, 0x02, 0x6d, 0xf2, 0x33, 0x30, 0xcb, 0xc6, 0x2e,
	0xd9, 0x96, 0xeb, 0xd8, 0x95, 0x0a, 0x72, 0x44, 0x29, 0xcf, 0x20, 0x35, 0xe4, 0x34, 0xed, 0x5e,
	0xf3, 0x7a, 0x79, 0x9d, 0x23, 0xc1, 0x16, 0xbe, 0x5c, 0xec, 0x25, 0x53, 0x7c, 0x2a, 0x05, 0x98,
	0x58, 0xab, 0xd8, 0x18, 0xd1, 0xcd, 0x47, 0x2c, 0xb1, 0x7f, 0xfd, 0xa4, 0xc0, 0xfa, 0x29, 0x53,
	0x20, 0xfb, 0xe9, 0x45, 0xf5, 0x8c, 0x04, 0x13, 0x2c, 0x19, 0xe3, 0xbf, 0xda, 0xb5, 0x17, 0x23,
	0x5f, 0x83, 0x24, 0xd9, 0xaa, 0x77, 0x08, 0xa8, 0x0c, 0xd0, 0x22, 0xa4, 0x27, 0x3b, 0x97, 0x38,
	0xb1, 0x34, 0x2a, 0xe3, 0x50, 0x3d, 0x5e, 0xff, 0xf3, 0x6d, 0x22, 0xf0, 0x7c, 0x5b, 0x84, 0xf1,
	0x86, 0x89, 0xcd, 0x2d, 0xb3, 0x62, 0xba, 0xcd, 0xfe, 0x5e, 0x16, 0x33, 0x2d, 0x46, 0xba, 0x3d,
	0x4f, 0x81, 0xec, 0xd7, 0x8d, 0xab, 0xfc, 0x40, 0x82, 0x23, 0xd7, 0x91, 0xab, 0xb6, 0xfe, 0x82,
	0x72, 0x8b, 0xfd, 0xfd, 0xc4, 0x3b, 0x5b, 0xbc, 0x08, 0xc3, 0xb4, 0x40, 0x81, 0x84, 0x48, 0xa2,
	0xad, 0x0b, 0xf8, 0xfe, 0xc3, 0xc2, 0xf2, 0x0c, 0xde, 0x27, 0x2d, 0x65, 0x50, 0xb9, 0x0c, 0x12,
	0x38, 0xfc, 0x88, 0x42, 0xdf, 0x0d, 0xf9, 0x7e, 0x9e, 0xe2, 0x6d, 0xc4, 0x77, 0x94, 0x77, 0x07,
	0x20, 0xdf, 0x6e, 0x4a, 0xdc, 0xc3, 0xbf, 0x06, 0x19, 0xb6, 0x24, 0xfc, 0xbf, 0x32, 0x62, 0x6e,
	0xaf, 0xf4, 0xf8, 0xd0, 0xd6, 0x59, 0x7c, 0x81, 0x7a, 0x85, 0x68, 0x65, 0x45, 0x09, 0x2c, 0xa2,
	0x44, 0xdb, 0x7c, 0x13, 0xe4, 0x28, 0x91, 0xbf, 0x40, 0x61, 0x88, 0x15, 0x28, 0xdc, 0x0a, 0x16,
	0x28, 0x5c, 0xe8, 0xd3, 0x76, 0xde, 0xcc, 0x5a, 0x35, 0x0b, 0xca, 0xdb, 0xb0, 0x78, 0x1d, 0xb9,
	0x57, 0x5e, 0x7c, 0xb9, 0xc3, 0x9a, 0xdd, 0xe1, 0x55, 0x92, 0xe4, 0x92, 0x23, 0x6c, 0xd3, 0xef,
	0xd8, 0x5e, 0x8d, 0x0c, 0x2d, 0x9c, 0x24, 0xbf, 0xb0, 0xf2, 0x6d, 0x09, 0x96, 0x3a, 0x0c, 0xce,
	0x57, 0xe7, 0x2d, 0x98, 0xf0, 0x89, 0xa5, 0x89, 0x08, 0x31, 0x89, 0xf3, 0xfb, 0x98, 0x84, 0x9a,
	0x75, 0x82, 0x0d, 0x58, 0xf9, 0x8e, 0x04, 0x53, 0xb4, 0x98, 0x43, 0xe0, 0x65, 0x1f, 0x7b, 0xeb,
	0x4b, 0xe1, 0xfb, 0xee, 0x7f, 0x76, 0xbd, 0xef, 0xc6, 0x0d, 0xd5, 0xba, 0xe3, 0xee, 0xc2, 0x74,
	0x88, 0x80, 0xdb, 0x41, 0x85, 0x64, 0xe8, 0x21, 0xf8, 0x99, 0x7e, 0x87, 0xe2, 0xcf, 0xbe, 0x9e,
	0x1c, 0xe5, 0x7b, 0x12, 0x4c, 0xa9, 0x48, 0xaf, 0xd5, 0x2a, 0x2c, 0x81, 0x80, 0xfb, 0xd0, 0x7c,
	0x23, 0xac, 0x79, 0x7c, 0xe1, 0x94, 0xff, 0x3f, 0x5e, 0x6c, 0x39, 0xa2, 0xc3, 0xb5, 0xb4, 0x9f,
	0x85, 0xe9, 0x10, 0x01, 0x9f, 0xe9, 0x4f, 0x07, 0x60, 0x9a, 0xf9, 0x4a, 0xd8, 0x3b, 0xaf, 0xc2,
	0xa0, 0x57, 0x18, 0x97, 0xf1, 0x5f, 0xf1, 0xe3, 0x10, 0xf3, 0x0a, 0xd2, 0x8d, 0x17, 0x91, 0xeb,
	0x22, 0x87, 0xd6, 0x98, 0xd0, 0x5a, 0x04, 0xca, 0xde, 0x69, 0x7b, 0x8e, 0xde, 0x87, 0x12, 0x71,
	0xf7, 0xa1, 0x0b, 0x90, 0x33, 0x2d, 0x42, 0x61, 0x36, 0x90, 0x86, 0x2c, 0x0f, 0x4e, 0x5a, 0x65,
	0x34, 0xd3, 0x5e, 0xff, 0x55, 0x4b, 0x04, 0x7b, 0xd1, 0x90, 0x9f, 0x84, 0x89, 0xaa, 0x7e, 0xdf,
	0xac, 0xd6, 0xab, 0x5a, 0x8d, 0xd0, 0x63, 0xf3, 0x6d, 0xf6, 0x07, 0xad, 0x21, 0x75, 0x9c, 0x77,
	0xac, 0xeb, 0x3b, 0x68, 0xc3, 0x7c, 0x1b, 0xc9, 0x27, 0x61, 0x9c, 0x56, 0xcc, 0x51, 0x42, 0x56,
	0xea, 0x35, 0x4c, 0x4b, 0xbd, 0x68, 0x21, 0x1d, 0x21, 0x63, 0x85, 0xe1, 0x7f, 0x61, 0x7f, 0xf6,
	0x09, 0xd8, 0x8b, 0x3b, 0xd2, 0x23, 0x32, 0x58, 0x6c, 0x5c, 0x0e, 0x3c, 0xc2, 0xb8, 0x8c, 0xd3,
	0x35, 0x11, 0xa7, 0xeb, 0x1f, 0x24, 0x98, 0x5d, 0xaf, 0x3b, 0x3b, 0xe8, 0xcb, 0xe8, 0x1d, 0xca,
	0x3c, 0xe4, 0xa2, 0xca, 0x89, 0x67, 0xee, 0x01, 0x98, 0xbd, 0x85, 0xbe, 0xa4, 0x9a, 0x3f, 0x96,
	0xb8, 0x58, 0x85, 0x5c, 0xd4, 0x60, 0x3c, 0x30, 0x62, 0x64, 0x48, 0x71, 0x32, 0xde, 0xa5, 0x25,
	0xdc, 0xdb, 0x0e, 0xc2, 0x65, 0x7f, 0xae, 0xbb, 0x1f, 0xf0, 0x7c, 0x35, 0x0c, 0x9e, 0xff, 0xd3,
	0x23, 0x78, 0xb6, 0x1d, 0xb5, 0x85, 0xa1, 0xb4, 0xaa, 0x3b, 0x8e, 0x8e, 0xa9, 0xb9, 0x5a, 0xfb,
	0xf0, 0xe3, 0xfc, 0xa1, 0x8f, 0x3e, 0xce, 0x1f, 0xfa, 0xf4, 0xe3, 0xbc, 0xf4, 0xf5, 0x87, 0x79,
	0xe9, 0xbd, 0x87, 0x79, 0xe9, 0x57, 0x0f, 0xf3, 0xd2, 0x87, 0x0f, 0xf3, 0xd2, 0x9f, 0x1e, 0xe6,
	0xa5, 0x3f, 0x3f, 0xcc, 0x1f, 0xfa, 0xf4, 0x61, 0x5e, 0x7a, 0xf0, 0x49, 0xfe, 0xd0, 0x87, 0x9f,
	0xe4, 0x0f, 0x7d, 0xf4, 0x49, 0xfe, 0xd0, 0xab, 0x97, 0x76, 0xec, 0xd6, 0x14, 0x4d, 0xbb, 0xe3,
	0x1f, 0xeb, 0xff, 0x2b, 0xd8, 0xb2, 0x35, 0x4c, 0x8f, 0x95, 0xe7, 0xff, 0x11, 0x00, 0x00, 0xff,
	0xff, 0x36, 0x72, 0xdc, 0x41, 0x97, 0x3f, 0x00, 0x00,
}

func (this *StartWorkflowExecutionRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*StartWorkflowExecutionRequest)
	if !ok {
		that2, ok := that.(StartWorkflowExecutionRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.StartRequest.Equal(that1.StartRequest) {
		return false
	}
	if !this.ParentExecutionInfo.Equal(that1.ParentExecutionInfo) {
		return false
	}
	if this.Attempt != that1.Attempt {
		return false
	}
	if that1.WorkflowExecutionExpirationTime == nil {
		if this.WorkflowExecutionExpirationTime != nil {
			return false
		}
	} else if !this.WorkflowExecutionExpirationTime.Equal(*that1.WorkflowExecutionExpirationTime) {
		return false
	}
	if this.ContinueAsNewInitiator != that1.ContinueAsNewInitiator {
		return false
	}
	if !this.ContinuedFailure.Equal(that1.ContinuedFailure) {
		return false
	}
	if !this.LastCompletionResult.Equal(that1.LastCompletionResult) {
		return false
	}
	if this.FirstWorkflowTaskBackoff != nil && that1.FirstWorkflowTaskBackoff != nil {
		if *this.FirstWorkflowTaskBackoff != *that1.FirstWorkflowTaskBackoff {
			return false
		}
	} else if this.FirstWorkflowTaskBackoff != nil {
		return false
	} else if that1.FirstWorkflowTaskBackoff != nil {
		return false
	}
	return true
}
func (this *StartWorkflowExecutionResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*StartWorkflowExecutionResponse)
	if !ok {
		that2, ok := that.(StartWorkflowExecutionResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	return true
}
func (this *GetMutableStateRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetMutableStateRequest)
	if !ok {
		that2, ok := that.(GetMutableStateRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	if this.ExpectedNextEventId != that1.ExpectedNextEventId {
		return false
	}
	if !bytes.Equal(this.CurrentBranchToken, that1.CurrentBranchToken) {
		return false
	}
	return true
}
func (this *GetMutableStateResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetMutableStateResponse)
	if !ok {
		that2, ok := that.(GetMutableStateResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	if !this.WorkflowType.Equal(that1.WorkflowType) {
		return false
	}
	if this.NextEventId != that1.NextEventId {
		return false
	}
	if this.PreviousStartedEventId != that1.PreviousStartedEventId {
		return false
	}
	if this.LastFirstEventId != that1.LastFirstEventId {
		return false
	}
	if !this.TaskQueue.Equal(that1.TaskQueue) {
		return false
	}
	if !this.StickyTaskQueue.Equal(that1.StickyTaskQueue) {
		return false
	}
	if this.StickyTaskQueueScheduleToStartTimeout != nil && that1.StickyTaskQueueScheduleToStartTimeout != nil {
		if *this.StickyTaskQueueScheduleToStartTimeout != *that1.StickyTaskQueueScheduleToStartTimeout {
			return false
		}
	} else if this.StickyTaskQueueScheduleToStartTimeout != nil {
		return false
	} else if that1.StickyTaskQueueScheduleToStartTimeout != nil {
		return false
	}
	if !bytes.Equal(this.CurrentBranchToken, that1.CurrentBranchToken) {
		return false
	}
	if this.WorkflowState != that1.WorkflowState {
		return false
	}
	if this.WorkflowStatus != that1.WorkflowStatus {
		return false
	}
	if !this.VersionHistories.Equal(that1.VersionHistories) {
		return false
	}
	if this.IsStickyTaskQueueEnabled != that1.IsStickyTaskQueueEnabled {
		return false
	}
	return true
}
func (this *PollMutableStateRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PollMutableStateRequest)
	if !ok {
		that2, ok := that.(PollMutableStateRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	if this.ExpectedNextEventId != that1.ExpectedNextEventId {
		return false
	}
	if !bytes.Equal(this.CurrentBranchToken, that1.CurrentBranchToken) {
		return false
	}
	return true
}
func (this *PollMutableStateResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PollMutableStateResponse)
	if !ok {
		that2, ok := that.(PollMutableStateResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	if !this.WorkflowType.Equal(that1.WorkflowType) {
		return false
	}
	if this.NextEventId != that1.NextEventId {
		return false
	}
	if this.PreviousStartedEventId != that1.PreviousStartedEventId {
		return false
	}
	if this.LastFirstEventId != that1.LastFirstEventId {
		return false
	}
	if !this.TaskQueue.Equal(that1.TaskQueue) {
		return false
	}
	if !this.StickyTaskQueue.Equal(that1.StickyTaskQueue) {
		return false
	}
	if this.StickyTaskQueueScheduleToStartTimeout != nil && that1.StickyTaskQueueScheduleToStartTimeout != nil {
		if *this.StickyTaskQueueScheduleToStartTimeout != *that1.StickyTaskQueueScheduleToStartTimeout {
			return false
		}
	} else if this.StickyTaskQueueScheduleToStartTimeout != nil {
		return false
	} else if that1.StickyTaskQueueScheduleToStartTimeout != nil {
		return false
	}
	if !bytes.Equal(this.CurrentBranchToken, that1.CurrentBranchToken) {
		return false
	}
	if !this.VersionHistories.Equal(that1.VersionHistories) {
		return false
	}
	if this.WorkflowState != that1.WorkflowState {
		return false
	}
	if this.WorkflowStatus != that1.WorkflowStatus {
		return false
	}
	return true
}
func (this *ResetStickyTaskQueueRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResetStickyTaskQueueRequest)
	if !ok {
		that2, ok := that.(ResetStickyTaskQueueRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	return true
}
func (this *ResetStickyTaskQueueResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResetStickyTaskQueueResponse)
	if !ok {
		that2, ok := that.(ResetStickyTaskQueueResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *RecordWorkflowTaskStartedRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RecordWorkflowTaskStartedRequest)
	if !ok {
		that2, ok := that.(RecordWorkflowTaskStartedRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.WorkflowExecution.Equal(that1.WorkflowExecution) {
		return false
	}
	if this.ScheduleId != that1.ScheduleId {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if this.RequestId != that1.RequestId {
		return false
	}
	if !this.PollRequest.Equal(that1.PollRequest) {
		return false
	}
	return true
}
func (this *RecordWorkflowTaskStartedResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RecordWorkflowTaskStartedResponse)
	if !ok {
		that2, ok := that.(RecordWorkflowTaskStartedResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.WorkflowType.Equal(that1.WorkflowType) {
		return false
	}
	if this.PreviousStartedEventId != that1.PreviousStartedEventId {
		return false
	}
	if this.ScheduledEventId != that1.ScheduledEventId {
		return false
	}
	if this.StartedEventId != that1.StartedEventId {
		return false
	}
	if this.NextEventId != that1.NextEventId {
		return false
	}
	if this.Attempt != that1.Attempt {
		return false
	}
	if this.StickyExecutionEnabled != that1.StickyExecutionEnabled {
		return false
	}
	if !this.WorkflowTaskInfo.Equal(that1.WorkflowTaskInfo) {
		return false
	}
	if !this.WorkflowExecutionTaskQueue.Equal(that1.WorkflowExecutionTaskQueue) {
		return false
	}
	if !bytes.Equal(this.BranchToken, that1.BranchToken) {
		return false
	}
	if that1.ScheduledTime == nil {
		if this.ScheduledTime != nil {
			return false
		}
	} else if !this.ScheduledTime.Equal(*that1.ScheduledTime) {
		return false
	}
	if that1.StartedTime == nil {
		if this.StartedTime != nil {
			return false
		}
	} else if !this.StartedTime.Equal(*that1.StartedTime) {
		return false
	}
	if len(this.Queries) != len(that1.Queries) {
		return false
	}
	for i := range this.Queries {
		if !this.Queries[i].Equal(that1.Queries[i]) {
			return false
		}
	}
	return true
}
func (this *RecordActivityTaskStartedRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RecordActivityTaskStartedRequest)
	if !ok {
		that2, ok := that.(RecordActivityTaskStartedRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.WorkflowExecution.Equal(that1.WorkflowExecution) {
		return false
	}
	if this.ScheduleId != that1.ScheduleId {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if this.RequestId != that1.RequestId {
		return false
	}
	if !this.PollRequest.Equal(that1.PollRequest) {
		return false
	}
	return true
}
func (this *RecordActivityTaskStartedResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RecordActivityTaskStartedResponse)
	if !ok {
		that2, ok := that.(RecordActivityTaskStartedResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ScheduledEvent.Equal(that1.ScheduledEvent) {
		return false
	}
	if that1.StartedTime == nil {
		if this.StartedTime != nil {
			return false
		}
	} else if !this.StartedTime.Equal(*that1.StartedTime) {
		return false
	}
	if this.Attempt != that1.Attempt {
		return false
	}
	if that1.CurrentAttemptScheduledTime == nil {
		if this.CurrentAttemptScheduledTime != nil {
			return false
		}
	} else if !this.CurrentAttemptScheduledTime.Equal(*that1.CurrentAttemptScheduledTime) {
		return false
	}
	if !this.HeartbeatDetails.Equal(that1.HeartbeatDetails) {
		return false
	}
	if !this.WorkflowType.Equal(that1.WorkflowType) {
		return false
	}
	if this.WorkflowNamespace != that1.WorkflowNamespace {
		return false
	}
	return true
}
func (this *RespondWorkflowTaskCompletedRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RespondWorkflowTaskCompletedRequest)
	if !ok {
		that2, ok := that.(RespondWorkflowTaskCompletedRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.CompleteRequest.Equal(that1.CompleteRequest) {
		return false
	}
	return true
}
func (this *RespondWorkflowTaskCompletedResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RespondWorkflowTaskCompletedResponse)
	if !ok {
		that2, ok := that.(RespondWorkflowTaskCompletedResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.StartedResponse.Equal(that1.StartedResponse) {
		return false
	}
	return true
}
func (this *RespondWorkflowTaskFailedRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RespondWorkflowTaskFailedRequest)
	if !ok {
		that2, ok := that.(RespondWorkflowTaskFailedRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.FailedRequest.Equal(that1.FailedRequest) {
		return false
	}
	return true
}
func (this *RespondWorkflowTaskFailedResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RespondWorkflowTaskFailedResponse)
	if !ok {
		that2, ok := that.(RespondWorkflowTaskFailedResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *RecordActivityTaskHeartbeatRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RecordActivityTaskHeartbeatRequest)
	if !ok {
		that2, ok := that.(RecordActivityTaskHeartbeatRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.HeartbeatRequest.Equal(that1.HeartbeatRequest) {
		return false
	}
	return true
}
func (this *RecordActivityTaskHeartbeatResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RecordActivityTaskHeartbeatResponse)
	if !ok {
		that2, ok := that.(RecordActivityTaskHeartbeatResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.CancelRequested != that1.CancelRequested {
		return false
	}
	return true
}
func (this *RespondActivityTaskCompletedRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RespondActivityTaskCompletedRequest)
	if !ok {
		that2, ok := that.(RespondActivityTaskCompletedRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.CompleteRequest.Equal(that1.CompleteRequest) {
		return false
	}
	return true
}
func (this *RespondActivityTaskCompletedResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RespondActivityTaskCompletedResponse)
	if !ok {
		that2, ok := that.(RespondActivityTaskCompletedResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *RespondActivityTaskFailedRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RespondActivityTaskFailedRequest)
	if !ok {
		that2, ok := that.(RespondActivityTaskFailedRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.FailedRequest.Equal(that1.FailedRequest) {
		return false
	}
	return true
}
func (this *RespondActivityTaskFailedResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RespondActivityTaskFailedResponse)
	if !ok {
		that2, ok := that.(RespondActivityTaskFailedResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *RespondActivityTaskCanceledRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RespondActivityTaskCanceledRequest)
	if !ok {
		that2, ok := that.(RespondActivityTaskCanceledRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.CancelRequest.Equal(that1.CancelRequest) {
		return false
	}
	return true
}
func (this *RespondActivityTaskCanceledResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RespondActivityTaskCanceledResponse)
	if !ok {
		that2, ok := that.(RespondActivityTaskCanceledResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *SignalWorkflowExecutionRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SignalWorkflowExecutionRequest)
	if !ok {
		that2, ok := that.(SignalWorkflowExecutionRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.SignalRequest.Equal(that1.SignalRequest) {
		return false
	}
	if !this.ExternalWorkflowExecution.Equal(that1.ExternalWorkflowExecution) {
		return false
	}
	if this.ChildWorkflowOnly != that1.ChildWorkflowOnly {
		return false
	}
	return true
}
func (this *SignalWorkflowExecutionResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SignalWorkflowExecutionResponse)
	if !ok {
		that2, ok := that.(SignalWorkflowExecutionResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *SignalWithStartWorkflowExecutionRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SignalWithStartWorkflowExecutionRequest)
	if !ok {
		that2, ok := that.(SignalWithStartWorkflowExecutionRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.SignalWithStartRequest.Equal(that1.SignalWithStartRequest) {
		return false
	}
	return true
}
func (this *SignalWithStartWorkflowExecutionResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SignalWithStartWorkflowExecutionResponse)
	if !ok {
		that2, ok := that.(SignalWithStartWorkflowExecutionResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	return true
}
func (this *RemoveSignalMutableStateRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RemoveSignalMutableStateRequest)
	if !ok {
		that2, ok := that.(RemoveSignalMutableStateRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.WorkflowExecution.Equal(that1.WorkflowExecution) {
		return false
	}
	if this.RequestId != that1.RequestId {
		return false
	}
	return true
}
func (this *RemoveSignalMutableStateResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RemoveSignalMutableStateResponse)
	if !ok {
		that2, ok := that.(RemoveSignalMutableStateResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *TerminateWorkflowExecutionRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TerminateWorkflowExecutionRequest)
	if !ok {
		that2, ok := that.(TerminateWorkflowExecutionRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.TerminateRequest.Equal(that1.TerminateRequest) {
		return false
	}
	return true
}
func (this *TerminateWorkflowExecutionResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TerminateWorkflowExecutionResponse)
	if !ok {
		that2, ok := that.(TerminateWorkflowExecutionResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *ResetWorkflowExecutionRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResetWorkflowExecutionRequest)
	if !ok {
		that2, ok := that.(ResetWorkflowExecutionRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.ResetRequest.Equal(that1.ResetRequest) {
		return false
	}
	return true
}
func (this *ResetWorkflowExecutionResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResetWorkflowExecutionResponse)
	if !ok {
		that2, ok := that.(ResetWorkflowExecutionResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	return true
}
func (this *RequestCancelWorkflowExecutionRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RequestCancelWorkflowExecutionRequest)
	if !ok {
		that2, ok := that.(RequestCancelWorkflowExecutionRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.CancelRequest.Equal(that1.CancelRequest) {
		return false
	}
	if this.ExternalInitiatedEventId != that1.ExternalInitiatedEventId {
		return false
	}
	if !this.ExternalWorkflowExecution.Equal(that1.ExternalWorkflowExecution) {
		return false
	}
	if this.ChildWorkflowOnly != that1.ChildWorkflowOnly {
		return false
	}
	return true
}
func (this *RequestCancelWorkflowExecutionResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RequestCancelWorkflowExecutionResponse)
	if !ok {
		that2, ok := that.(RequestCancelWorkflowExecutionResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *ScheduleWorkflowTaskRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScheduleWorkflowTaskRequest)
	if !ok {
		that2, ok := that.(ScheduleWorkflowTaskRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.WorkflowExecution.Equal(that1.WorkflowExecution) {
		return false
	}
	if this.IsFirstWorkflowTask != that1.IsFirstWorkflowTask {
		return false
	}
	return true
}
func (this *ScheduleWorkflowTaskResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScheduleWorkflowTaskResponse)
	if !ok {
		that2, ok := that.(ScheduleWorkflowTaskResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *RecordChildExecutionCompletedRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RecordChildExecutionCompletedRequest)
	if !ok {
		that2, ok := that.(RecordChildExecutionCompletedRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.WorkflowExecution.Equal(that1.WorkflowExecution) {
		return false
	}
	if this.InitiatedId != that1.InitiatedId {
		return false
	}
	if !this.CompletedExecution.Equal(that1.CompletedExecution) {
		return false
	}
	if !this.CompletionEvent.Equal(that1.CompletionEvent) {
		return false
	}
	return true
}
func (this *RecordChildExecutionCompletedResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RecordChildExecutionCompletedResponse)
	if !ok {
		that2, ok := that.(RecordChildExecutionCompletedResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *DescribeWorkflowExecutionRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeWorkflowExecutionRequest)
	if !ok {
		that2, ok := that.(DescribeWorkflowExecutionRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.Request.Equal(that1.Request) {
		return false
	}
	return true
}
func (this *DescribeWorkflowExecutionResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeWorkflowExecutionResponse)
	if !ok {
		that2, ok := that.(DescribeWorkflowExecutionResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ExecutionConfig.Equal(that1.ExecutionConfig) {
		return false
	}
	if !this.WorkflowExecutionInfo.Equal(that1.WorkflowExecutionInfo) {
		return false
	}
	if len(this.PendingActivities) != len(that1.PendingActivities) {
		return false
	}
	for i := range this.PendingActivities {
		if !this.PendingActivities[i].Equal(that1.PendingActivities[i]) {
			return false
		}
	}
	if len(this.PendingChildren) != len(that1.PendingChildren) {
		return false
	}
	for i := range this.PendingChildren {
		if !this.PendingChildren[i].Equal(that1.PendingChildren[i]) {
			return false
		}
	}
	return true
}
func (this *ReplicateEventsV2Request) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicateEventsV2Request)
	if !ok {
		that2, ok := that.(ReplicateEventsV2Request)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.WorkflowExecution.Equal(that1.WorkflowExecution) {
		return false
	}
	if len(this.VersionHistoryItems) != len(that1.VersionHistoryItems) {
		return false
	}
	for i := range this.VersionHistoryItems {
		if !this.VersionHistoryItems[i].Equal(that1.VersionHistoryItems[i]) {
			return false
		}
	}
	if !this.Events.Equal(that1.Events) {
		return false
	}
	if !this.NewRunEvents.Equal(that1.NewRunEvents) {
		return false
	}
	return true
}
func (this *ReplicateEventsV2Response) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicateEventsV2Response)
	if !ok {
		that2, ok := that.(ReplicateEventsV2Response)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *SyncShardStatusRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SyncShardStatusRequest)
	if !ok {
		that2, ok := that.(SyncShardStatusRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.SourceCluster != that1.SourceCluster {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if that1.StatusTime == nil {
		if this.StatusTime != nil {
			return false
		}
	} else if !this.StatusTime.Equal(*that1.StatusTime) {
		return false
	}
	return true
}
func (this *SyncShardStatusResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SyncShardStatusResponse)
	if !ok {
		that2, ok := that.(SyncShardStatusResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *SyncActivityRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SyncActivityRequest)
	if !ok {
		that2, ok := that.(SyncActivityRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.ScheduledId != that1.ScheduledId {
		return false
	}
	if that1.ScheduledTime == nil {
		if this.ScheduledTime != nil {
			return false
		}
	} else if !this.ScheduledTime.Equal(*that1.ScheduledTime) {
		return false
	}
	if this.StartedId != that1.StartedId {
		return false
	}
	if that1.StartedTime == nil {
		if this.StartedTime != nil {
			return false
		}
	} else if !this.StartedTime.Equal(*that1.StartedTime) {
		return false
	}
	if that1.LastHeartbeatTime == nil {
		if this.LastHeartbeatTime != nil {
			return false
		}
	} else if !this.LastHeartbeatTime.Equal(*that1.LastHeartbeatTime) {
		return false
	}
	if !this.Details.Equal(that1.Details) {
		return false
	}
	if this.Attempt != that1.Attempt {
		return false
	}
	if !this.LastFailure.Equal(that1.LastFailure) {
		return false
	}
	if this.LastWorkerIdentity != that1.LastWorkerIdentity {
		return false
	}
	if !this.VersionHistory.Equal(that1.VersionHistory) {
		return false
	}
	return true
}
func (this *SyncActivityResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SyncActivityResponse)
	if !ok {
		that2, ok := that.(SyncActivityResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *DescribeMutableStateRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeMutableStateRequest)
	if !ok {
		that2, ok := that.(DescribeMutableStateRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	return true
}
func (this *DescribeMutableStateResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeMutableStateResponse)
	if !ok {
		that2, ok := that.(DescribeMutableStateResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.CacheMutableState.Equal(that1.CacheMutableState) {
		return false
	}
	if !this.DatabaseMutableState.Equal(that1.DatabaseMutableState) {
		return false
	}
	return true
}
func (this *DescribeHistoryHostRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeHistoryHostRequest)
	if !ok {
		that2, ok := that.(DescribeHistoryHostRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.HostAddress != that1.HostAddress {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.WorkflowExecution.Equal(that1.WorkflowExecution) {
		return false
	}
	return true
}
func (this *DescribeHistoryHostResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeHistoryHostResponse)
	if !ok {
		that2, ok := that.(DescribeHistoryHostResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardsNumber != that1.ShardsNumber {
		return false
	}
	if len(this.ShardIds) != len(that1.ShardIds) {
		return false
	}
	for i := range this.ShardIds {
		if this.ShardIds[i] != that1.ShardIds[i] {
			return false
		}
	}
	if !this.NamespaceCache.Equal(that1.NamespaceCache) {
		return false
	}
	if this.ShardControllerStatus != that1.ShardControllerStatus {
		return false
	}
	if this.Address != that1.Address {
		return false
	}
	return true
}
func (this *CloseShardRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CloseShardRequest)
	if !ok {
		that2, ok := that.(CloseShardRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	return true
}
func (this *CloseShardResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CloseShardResponse)
	if !ok {
		that2, ok := that.(CloseShardResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *RemoveTaskRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RemoveTaskRequest)
	if !ok {
		that2, ok := that.(RemoveTaskRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.Category != that1.Category {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if that1.VisibilityTime == nil {
		if this.VisibilityTime != nil {
			return false
		}
	} else if !this.VisibilityTime.Equal(*that1.VisibilityTime) {
		return false
	}
	return true
}
func (this *RemoveTaskResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RemoveTaskResponse)
	if !ok {
		that2, ok := that.(RemoveTaskResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *GetReplicationMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetReplicationMessagesRequest)
	if !ok {
		that2, ok := that.(GetReplicationMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Tokens) != len(that1.Tokens) {
		return false
	}
	for i := range this.Tokens {
		if !this.Tokens[i].Equal(that1.Tokens[i]) {
			return false
		}
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	return true
}
func (this *GetReplicationMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetReplicationMessagesResponse)
	if !ok {
		that2, ok := that.(GetReplicationMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ShardMessages) != len(that1.ShardMessages) {
		return false
	}
	for i := range this.ShardMessages {
		if !this.ShardMessages[i].Equal(that1.ShardMessages[i]) {
			return false
		}
	}
	return true
}
func (this *GetDLQReplicationMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetDLQReplicationMessagesRequest)
	if !ok {
		that2, ok := that.(GetDLQReplicationMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.TaskInfos) != len(that1.TaskInfos) {
		return false
	}
	for i := range this.TaskInfos {
		if !this.TaskInfos[i].Equal(that1.TaskInfos[i]) {
			return false
		}
	}
	return true
}
func (this *GetDLQReplicationMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetDLQReplicationMessagesResponse)
	if !ok {
		that2, ok := that.(GetDLQReplicationMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ReplicationTasks) != len(that1.ReplicationTasks) {
		return false
	}
	for i := range this.ReplicationTasks {
		if !this.ReplicationTasks[i].Equal(that1.ReplicationTasks[i]) {
			return false
		}
	}
	return true
}
func (this *QueryWorkflowRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryWorkflowRequest)
	if !ok {
		that2, ok := that.(QueryWorkflowRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.Request.Equal(that1.Request) {
		return false
	}
	return true
}
func (this *QueryWorkflowResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryWorkflowResponse)
	if !ok {
		that2, ok := that.(QueryWorkflowResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Response.Equal(that1.Response) {
		return false
	}
	return true
}
func (this *ReapplyEventsRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReapplyEventsRequest)
	if !ok {
		that2, ok := that.(ReapplyEventsRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.Request.Equal(that1.Request) {
		return false
	}
	return true
}
func (this *ReapplyEventsResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReapplyEventsResponse)
	if !ok {
		that2, ok := that.(ReapplyEventsResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *GetDLQMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetDLQMessagesRequest)
	if !ok {
		that2, ok := that.(GetDLQMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.SourceCluster != that1.SourceCluster {
		return false
	}
	if this.InclusiveEndMessageId != that1.InclusiveEndMessageId {
		return false
	}
	if this.MaximumPageSize != that1.MaximumPageSize {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *GetDLQMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetDLQMessagesResponse)
	if !ok {
		that2, ok := that.(GetDLQMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if len(this.ReplicationTasks) != len(that1.ReplicationTasks) {
		return false
	}
	for i := range this.ReplicationTasks {
		if !this.ReplicationTasks[i].Equal(that1.ReplicationTasks[i]) {
			return false
		}
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *PurgeDLQMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PurgeDLQMessagesRequest)
	if !ok {
		that2, ok := that.(PurgeDLQMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.SourceCluster != that1.SourceCluster {
		return false
	}
	if this.InclusiveEndMessageId != that1.InclusiveEndMessageId {
		return false
	}
	return true
}
func (this *PurgeDLQMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PurgeDLQMessagesResponse)
	if !ok {
		that2, ok := that.(PurgeDLQMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *MergeDLQMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MergeDLQMessagesRequest)
	if !ok {
		that2, ok := that.(MergeDLQMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.SourceCluster != that1.SourceCluster {
		return false
	}
	if this.InclusiveEndMessageId != that1.InclusiveEndMessageId {
		return false
	}
	if this.MaximumPageSize != that1.MaximumPageSize {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *MergeDLQMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MergeDLQMessagesResponse)
	if !ok {
		that2, ok := that.(MergeDLQMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *RefreshWorkflowTasksRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RefreshWorkflowTasksRequest)
	if !ok {
		that2, ok := that.(RefreshWorkflowTasksRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.Request.Equal(that1.Request) {
		return false
	}
	return true
}
func (this *RefreshWorkflowTasksResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RefreshWorkflowTasksResponse)
	if !ok {
		that2, ok := that.(RefreshWorkflowTasksResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *StartWorkflowExecutionRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&historyservice.StartWorkflowExecutionRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.StartRequest != nil {
		s = append(s, "StartRequest: "+fmt.Sprintf("%#v", this.StartRequest)+",\n")
	}
	if this.ParentExecutionInfo != nil {
		s = append(s, "ParentExecutionInfo: "+fmt.Sprintf("%#v", this.ParentExecutionInfo)+",\n")
	}
	s = append(s, "Attempt: "+fmt.Sprintf("%#v", this.Attempt)+",\n")
	s = append(s, "WorkflowExecutionExpirationTime: "+fmt.Sprintf("%#v", this.WorkflowExecutionExpirationTime)+",\n")
	s = append(s, "ContinueAsNewInitiator: "+fmt.Sprintf("%#v", this.ContinueAsNewInitiator)+",\n")
	if this.ContinuedFailure != nil {
		s = append(s, "ContinuedFailure: "+fmt.Sprintf("%#v", this.ContinuedFailure)+",\n")
	}
	if this.LastCompletionResult != nil {
		s = append(s, "LastCompletionResult: "+fmt.Sprintf("%#v", this.LastCompletionResult)+",\n")
	}
	s = append(s, "FirstWorkflowTaskBackoff: "+fmt.Sprintf("%#v", this.FirstWorkflowTaskBackoff)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *StartWorkflowExecutionResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&historyservice.StartWorkflowExecutionResponse{")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetMutableStateRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&historyservice.GetMutableStateRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	s = append(s, "ExpectedNextEventId: "+fmt.Sprintf("%#v", this.ExpectedNextEventId)+",\n")
	s = append(s, "CurrentBranchToken: "+fmt.Sprintf("%#v", this.CurrentBranchToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetMutableStateResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 17)
	s = append(s, "&historyservice.GetMutableStateResponse{")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	if this.WorkflowType != nil {
		s = append(s, "WorkflowType: "+fmt.Sprintf("%#v", this.WorkflowType)+",\n")
	}
	s = append(s, "NextEventId: "+fmt.Sprintf("%#v", this.NextEventId)+",\n")
	s = append(s, "PreviousStartedEventId: "+fmt.Sprintf("%#v", this.PreviousStartedEventId)+",\n")
	s = append(s, "LastFirstEventId: "+fmt.Sprintf("%#v", this.LastFirstEventId)+",\n")
	if this.TaskQueue != nil {
		s = append(s, "TaskQueue: "+fmt.Sprintf("%#v", this.TaskQueue)+",\n")
	}
	if this.StickyTaskQueue != nil {
		s = append(s, "StickyTaskQueue: "+fmt.Sprintf("%#v", this.StickyTaskQueue)+",\n")
	}
	s = append(s, "StickyTaskQueueScheduleToStartTimeout: "+fmt.Sprintf("%#v", this.StickyTaskQueueScheduleToStartTimeout)+",\n")
	s = append(s, "CurrentBranchToken: "+fmt.Sprintf("%#v", this.CurrentBranchToken)+",\n")
	s = append(s, "WorkflowState: "+fmt.Sprintf("%#v", this.WorkflowState)+",\n")
	s = append(s, "WorkflowStatus: "+fmt.Sprintf("%#v", this.WorkflowStatus)+",\n")
	if this.VersionHistories != nil {
		s = append(s, "VersionHistories: "+fmt.Sprintf("%#v", this.VersionHistories)+",\n")
	}
	s = append(s, "IsStickyTaskQueueEnabled: "+fmt.Sprintf("%#v", this.IsStickyTaskQueueEnabled)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PollMutableStateRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&historyservice.PollMutableStateRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	s = append(s, "ExpectedNextEventId: "+fmt.Sprintf("%#v", this.ExpectedNextEventId)+",\n")
	s = append(s, "CurrentBranchToken: "+fmt.Sprintf("%#v", this.CurrentBranchToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PollMutableStateResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 16)
	s = append(s, "&historyservice.PollMutableStateResponse{")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	if this.WorkflowType != nil {
		s = append(s, "WorkflowType: "+fmt.Sprintf("%#v", this.WorkflowType)+",\n")
	}
	s = append(s, "NextEventId: "+fmt.Sprintf("%#v", this.NextEventId)+",\n")
	s = append(s, "PreviousStartedEventId: "+fmt.Sprintf("%#v", this.PreviousStartedEventId)+",\n")
	s = append(s, "LastFirstEventId: "+fmt.Sprintf("%#v", this.LastFirstEventId)+",\n")
	if this.TaskQueue != nil {
		s = append(s, "TaskQueue: "+fmt.Sprintf("%#v", this.TaskQueue)+",\n")
	}
	if this.StickyTaskQueue != nil {
		s = append(s, "StickyTaskQueue: "+fmt.Sprintf("%#v", this.StickyTaskQueue)+",\n")
	}
	s = append(s, "StickyTaskQueueScheduleToStartTimeout: "+fmt.Sprintf("%#v", this.StickyTaskQueueScheduleToStartTimeout)+",\n")
	s = append(s, "CurrentBranchToken: "+fmt.Sprintf("%#v", this.CurrentBranchToken)+",\n")
	if this.VersionHistories != nil {
		s = append(s, "VersionHistories: "+fmt.Sprintf("%#v", this.VersionHistories)+",\n")
	}
	s = append(s, "WorkflowState: "+fmt.Sprintf("%#v", this.WorkflowState)+",\n")
	s = append(s, "WorkflowStatus: "+fmt.Sprintf("%#v", this.WorkflowStatus)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResetStickyTaskQueueRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.ResetStickyTaskQueueRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResetStickyTaskQueueResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.ResetStickyTaskQueueResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RecordWorkflowTaskStartedRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&historyservice.RecordWorkflowTaskStartedRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.WorkflowExecution != nil {
		s = append(s, "WorkflowExecution: "+fmt.Sprintf("%#v", this.WorkflowExecution)+",\n")
	}
	s = append(s, "ScheduleId: "+fmt.Sprintf("%#v", this.ScheduleId)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "RequestId: "+fmt.Sprintf("%#v", this.RequestId)+",\n")
	if this.PollRequest != nil {
		s = append(s, "PollRequest: "+fmt.Sprintf("%#v", this.PollRequest)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RecordWorkflowTaskStartedResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 17)
	s = append(s, "&historyservice.RecordWorkflowTaskStartedResponse{")
	if this.WorkflowType != nil {
		s = append(s, "WorkflowType: "+fmt.Sprintf("%#v", this.WorkflowType)+",\n")
	}
	s = append(s, "PreviousStartedEventId: "+fmt.Sprintf("%#v", this.PreviousStartedEventId)+",\n")
	s = append(s, "ScheduledEventId: "+fmt.Sprintf("%#v", this.ScheduledEventId)+",\n")
	s = append(s, "StartedEventId: "+fmt.Sprintf("%#v", this.StartedEventId)+",\n")
	s = append(s, "NextEventId: "+fmt.Sprintf("%#v", this.NextEventId)+",\n")
	s = append(s, "Attempt: "+fmt.Sprintf("%#v", this.Attempt)+",\n")
	s = append(s, "StickyExecutionEnabled: "+fmt.Sprintf("%#v", this.StickyExecutionEnabled)+",\n")
	if this.WorkflowTaskInfo != nil {
		s = append(s, "WorkflowTaskInfo: "+fmt.Sprintf("%#v", this.WorkflowTaskInfo)+",\n")
	}
	if this.WorkflowExecutionTaskQueue != nil {
		s = append(s, "WorkflowExecutionTaskQueue: "+fmt.Sprintf("%#v", this.WorkflowExecutionTaskQueue)+",\n")
	}
	s = append(s, "BranchToken: "+fmt.Sprintf("%#v", this.BranchToken)+",\n")
	s = append(s, "ScheduledTime: "+fmt.Sprintf("%#v", this.ScheduledTime)+",\n")
	s = append(s, "StartedTime: "+fmt.Sprintf("%#v", this.StartedTime)+",\n")
	keysForQueries := make([]string, 0, len(this.Queries))
	for k, _ := range this.Queries {
		keysForQueries = append(keysForQueries, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForQueries)
	mapStringForQueries := "map[string]*v18.WorkflowQuery{"
	for _, k := range keysForQueries {
		mapStringForQueries += fmt.Sprintf("%#v: %#v,", k, this.Queries[k])
	}
	mapStringForQueries += "}"
	if this.Queries != nil {
		s = append(s, "Queries: "+mapStringForQueries+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RecordActivityTaskStartedRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&historyservice.RecordActivityTaskStartedRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.WorkflowExecution != nil {
		s = append(s, "WorkflowExecution: "+fmt.Sprintf("%#v", this.WorkflowExecution)+",\n")
	}
	s = append(s, "ScheduleId: "+fmt.Sprintf("%#v", this.ScheduleId)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "RequestId: "+fmt.Sprintf("%#v", this.RequestId)+",\n")
	if this.PollRequest != nil {
		s = append(s, "PollRequest: "+fmt.Sprintf("%#v", this.PollRequest)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RecordActivityTaskStartedResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&historyservice.RecordActivityTaskStartedResponse{")
	if this.ScheduledEvent != nil {
		s = append(s, "ScheduledEvent: "+fmt.Sprintf("%#v", this.ScheduledEvent)+",\n")
	}
	s = append(s, "StartedTime: "+fmt.Sprintf("%#v", this.StartedTime)+",\n")
	s = append(s, "Attempt: "+fmt.Sprintf("%#v", this.Attempt)+",\n")
	s = append(s, "CurrentAttemptScheduledTime: "+fmt.Sprintf("%#v", this.CurrentAttemptScheduledTime)+",\n")
	if this.HeartbeatDetails != nil {
		s = append(s, "HeartbeatDetails: "+fmt.Sprintf("%#v", this.HeartbeatDetails)+",\n")
	}
	if this.WorkflowType != nil {
		s = append(s, "WorkflowType: "+fmt.Sprintf("%#v", this.WorkflowType)+",\n")
	}
	s = append(s, "WorkflowNamespace: "+fmt.Sprintf("%#v", this.WorkflowNamespace)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RespondWorkflowTaskCompletedRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.RespondWorkflowTaskCompletedRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.CompleteRequest != nil {
		s = append(s, "CompleteRequest: "+fmt.Sprintf("%#v", this.CompleteRequest)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RespondWorkflowTaskCompletedResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&historyservice.RespondWorkflowTaskCompletedResponse{")
	if this.StartedResponse != nil {
		s = append(s, "StartedResponse: "+fmt.Sprintf("%#v", this.StartedResponse)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RespondWorkflowTaskFailedRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.RespondWorkflowTaskFailedRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.FailedRequest != nil {
		s = append(s, "FailedRequest: "+fmt.Sprintf("%#v", this.FailedRequest)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RespondWorkflowTaskFailedResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.RespondWorkflowTaskFailedResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RecordActivityTaskHeartbeatRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.RecordActivityTaskHeartbeatRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.HeartbeatRequest != nil {
		s = append(s, "HeartbeatRequest: "+fmt.Sprintf("%#v", this.HeartbeatRequest)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RecordActivityTaskHeartbeatResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&historyservice.RecordActivityTaskHeartbeatResponse{")
	s = append(s, "CancelRequested: "+fmt.Sprintf("%#v", this.CancelRequested)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RespondActivityTaskCompletedRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.RespondActivityTaskCompletedRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.CompleteRequest != nil {
		s = append(s, "CompleteRequest: "+fmt.Sprintf("%#v", this.CompleteRequest)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RespondActivityTaskCompletedResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.RespondActivityTaskCompletedResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RespondActivityTaskFailedRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.RespondActivityTaskFailedRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.FailedRequest != nil {
		s = append(s, "FailedRequest: "+fmt.Sprintf("%#v", this.FailedRequest)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RespondActivityTaskFailedResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.RespondActivityTaskFailedResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RespondActivityTaskCanceledRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.RespondActivityTaskCanceledRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.CancelRequest != nil {
		s = append(s, "CancelRequest: "+fmt.Sprintf("%#v", this.CancelRequest)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RespondActivityTaskCanceledResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.RespondActivityTaskCanceledResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SignalWorkflowExecutionRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&historyservice.SignalWorkflowExecutionRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.SignalRequest != nil {
		s = append(s, "SignalRequest: "+fmt.Sprintf("%#v", this.SignalRequest)+",\n")
	}
	if this.ExternalWorkflowExecution != nil {
		s = append(s, "ExternalWorkflowExecution: "+fmt.Sprintf("%#v", this.ExternalWorkflowExecution)+",\n")
	}
	s = append(s, "ChildWorkflowOnly: "+fmt.Sprintf("%#v", this.ChildWorkflowOnly)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SignalWorkflowExecutionResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.SignalWorkflowExecutionResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SignalWithStartWorkflowExecutionRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.SignalWithStartWorkflowExecutionRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.SignalWithStartRequest != nil {
		s = append(s, "SignalWithStartRequest: "+fmt.Sprintf("%#v", this.SignalWithStartRequest)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SignalWithStartWorkflowExecutionResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&historyservice.SignalWithStartWorkflowExecutionResponse{")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveSignalMutableStateRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&historyservice.RemoveSignalMutableStateRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.WorkflowExecution != nil {
		s = append(s, "WorkflowExecution: "+fmt.Sprintf("%#v", this.WorkflowExecution)+",\n")
	}
	s = append(s, "RequestId: "+fmt.Sprintf("%#v", this.RequestId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveSignalMutableStateResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.RemoveSignalMutableStateResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TerminateWorkflowExecutionRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.TerminateWorkflowExecutionRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.TerminateRequest != nil {
		s = append(s, "TerminateRequest: "+fmt.Sprintf("%#v", this.TerminateRequest)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TerminateWorkflowExecutionResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.TerminateWorkflowExecutionResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResetWorkflowExecutionRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.ResetWorkflowExecutionRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.ResetRequest != nil {
		s = append(s, "ResetRequest: "+fmt.Sprintf("%#v", this.ResetRequest)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResetWorkflowExecutionResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&historyservice.ResetWorkflowExecutionResponse{")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RequestCancelWorkflowExecutionRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&historyservice.RequestCancelWorkflowExecutionRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.CancelRequest != nil {
		s = append(s, "CancelRequest: "+fmt.Sprintf("%#v", this.CancelRequest)+",\n")
	}
	s = append(s, "ExternalInitiatedEventId: "+fmt.Sprintf("%#v", this.ExternalInitiatedEventId)+",\n")
	if this.ExternalWorkflowExecution != nil {
		s = append(s, "ExternalWorkflowExecution: "+fmt.Sprintf("%#v", this.ExternalWorkflowExecution)+",\n")
	}
	s = append(s, "ChildWorkflowOnly: "+fmt.Sprintf("%#v", this.ChildWorkflowOnly)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RequestCancelWorkflowExecutionResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.RequestCancelWorkflowExecutionResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ScheduleWorkflowTaskRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&historyservice.ScheduleWorkflowTaskRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.WorkflowExecution != nil {
		s = append(s, "WorkflowExecution: "+fmt.Sprintf("%#v", this.WorkflowExecution)+",\n")
	}
	s = append(s, "IsFirstWorkflowTask: "+fmt.Sprintf("%#v", this.IsFirstWorkflowTask)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ScheduleWorkflowTaskResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.ScheduleWorkflowTaskResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RecordChildExecutionCompletedRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&historyservice.RecordChildExecutionCompletedRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.WorkflowExecution != nil {
		s = append(s, "WorkflowExecution: "+fmt.Sprintf("%#v", this.WorkflowExecution)+",\n")
	}
	s = append(s, "InitiatedId: "+fmt.Sprintf("%#v", this.InitiatedId)+",\n")
	if this.CompletedExecution != nil {
		s = append(s, "CompletedExecution: "+fmt.Sprintf("%#v", this.CompletedExecution)+",\n")
	}
	if this.CompletionEvent != nil {
		s = append(s, "CompletionEvent: "+fmt.Sprintf("%#v", this.CompletionEvent)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RecordChildExecutionCompletedResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.RecordChildExecutionCompletedResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeWorkflowExecutionRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.DescribeWorkflowExecutionRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.Request != nil {
		s = append(s, "Request: "+fmt.Sprintf("%#v", this.Request)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeWorkflowExecutionResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&historyservice.DescribeWorkflowExecutionResponse{")
	if this.ExecutionConfig != nil {
		s = append(s, "ExecutionConfig: "+fmt.Sprintf("%#v", this.ExecutionConfig)+",\n")
	}
	if this.WorkflowExecutionInfo != nil {
		s = append(s, "WorkflowExecutionInfo: "+fmt.Sprintf("%#v", this.WorkflowExecutionInfo)+",\n")
	}
	if this.PendingActivities != nil {
		s = append(s, "PendingActivities: "+fmt.Sprintf("%#v", this.PendingActivities)+",\n")
	}
	if this.PendingChildren != nil {
		s = append(s, "PendingChildren: "+fmt.Sprintf("%#v", this.PendingChildren)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReplicateEventsV2Request) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&historyservice.ReplicateEventsV2Request{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.WorkflowExecution != nil {
		s = append(s, "WorkflowExecution: "+fmt.Sprintf("%#v", this.WorkflowExecution)+",\n")
	}
	if this.VersionHistoryItems != nil {
		s = append(s, "VersionHistoryItems: "+fmt.Sprintf("%#v", this.VersionHistoryItems)+",\n")
	}
	if this.Events != nil {
		s = append(s, "Events: "+fmt.Sprintf("%#v", this.Events)+",\n")
	}
	if this.NewRunEvents != nil {
		s = append(s, "NewRunEvents: "+fmt.Sprintf("%#v", this.NewRunEvents)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReplicateEventsV2Response) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.ReplicateEventsV2Response{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SyncShardStatusRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&historyservice.SyncShardStatusRequest{")
	s = append(s, "SourceCluster: "+fmt.Sprintf("%#v", this.SourceCluster)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "StatusTime: "+fmt.Sprintf("%#v", this.StatusTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SyncShardStatusResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.SyncShardStatusResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SyncActivityRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 18)
	s = append(s, "&historyservice.SyncActivityRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "ScheduledId: "+fmt.Sprintf("%#v", this.ScheduledId)+",\n")
	s = append(s, "ScheduledTime: "+fmt.Sprintf("%#v", this.ScheduledTime)+",\n")
	s = append(s, "StartedId: "+fmt.Sprintf("%#v", this.StartedId)+",\n")
	s = append(s, "StartedTime: "+fmt.Sprintf("%#v", this.StartedTime)+",\n")
	s = append(s, "LastHeartbeatTime: "+fmt.Sprintf("%#v", this.LastHeartbeatTime)+",\n")
	if this.Details != nil {
		s = append(s, "Details: "+fmt.Sprintf("%#v", this.Details)+",\n")
	}
	s = append(s, "Attempt: "+fmt.Sprintf("%#v", this.Attempt)+",\n")
	if this.LastFailure != nil {
		s = append(s, "LastFailure: "+fmt.Sprintf("%#v", this.LastFailure)+",\n")
	}
	s = append(s, "LastWorkerIdentity: "+fmt.Sprintf("%#v", this.LastWorkerIdentity)+",\n")
	if this.VersionHistory != nil {
		s = append(s, "VersionHistory: "+fmt.Sprintf("%#v", this.VersionHistory)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SyncActivityResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.SyncActivityResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeMutableStateRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.DescribeMutableStateRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeMutableStateResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.DescribeMutableStateResponse{")
	if this.CacheMutableState != nil {
		s = append(s, "CacheMutableState: "+fmt.Sprintf("%#v", this.CacheMutableState)+",\n")
	}
	if this.DatabaseMutableState != nil {
		s = append(s, "DatabaseMutableState: "+fmt.Sprintf("%#v", this.DatabaseMutableState)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeHistoryHostRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&historyservice.DescribeHistoryHostRequest{")
	s = append(s, "HostAddress: "+fmt.Sprintf("%#v", this.HostAddress)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.WorkflowExecution != nil {
		s = append(s, "WorkflowExecution: "+fmt.Sprintf("%#v", this.WorkflowExecution)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeHistoryHostResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&historyservice.DescribeHistoryHostResponse{")
	s = append(s, "ShardsNumber: "+fmt.Sprintf("%#v", this.ShardsNumber)+",\n")
	s = append(s, "ShardIds: "+fmt.Sprintf("%#v", this.ShardIds)+",\n")
	if this.NamespaceCache != nil {
		s = append(s, "NamespaceCache: "+fmt.Sprintf("%#v", this.NamespaceCache)+",\n")
	}
	s = append(s, "ShardControllerStatus: "+fmt.Sprintf("%#v", this.ShardControllerStatus)+",\n")
	s = append(s, "Address: "+fmt.Sprintf("%#v", this.Address)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CloseShardRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&historyservice.CloseShardRequest{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CloseShardResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.CloseShardResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveTaskRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&historyservice.RemoveTaskRequest{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "Category: "+fmt.Sprintf("%#v", this.Category)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "VisibilityTime: "+fmt.Sprintf("%#v", this.VisibilityTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveTaskResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.RemoveTaskResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetReplicationMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.GetReplicationMessagesRequest{")
	if this.Tokens != nil {
		s = append(s, "Tokens: "+fmt.Sprintf("%#v", this.Tokens)+",\n")
	}
	s = append(s, "ClusterName: "+fmt.Sprintf("%#v", this.ClusterName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetReplicationMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&historyservice.GetReplicationMessagesResponse{")
	keysForShardMessages := make([]int32, 0, len(this.ShardMessages))
	for k, _ := range this.ShardMessages {
		keysForShardMessages = append(keysForShardMessages, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForShardMessages)
	mapStringForShardMessages := "map[int32]*v113.ReplicationMessages{"
	for _, k := range keysForShardMessages {
		mapStringForShardMessages += fmt.Sprintf("%#v: %#v,", k, this.ShardMessages[k])
	}
	mapStringForShardMessages += "}"
	if this.ShardMessages != nil {
		s = append(s, "ShardMessages: "+mapStringForShardMessages+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetDLQReplicationMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&historyservice.GetDLQReplicationMessagesRequest{")
	if this.TaskInfos != nil {
		s = append(s, "TaskInfos: "+fmt.Sprintf("%#v", this.TaskInfos)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetDLQReplicationMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&historyservice.GetDLQReplicationMessagesResponse{")
	if this.ReplicationTasks != nil {
		s = append(s, "ReplicationTasks: "+fmt.Sprintf("%#v", this.ReplicationTasks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QueryWorkflowRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.QueryWorkflowRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.Request != nil {
		s = append(s, "Request: "+fmt.Sprintf("%#v", this.Request)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QueryWorkflowResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&historyservice.QueryWorkflowResponse{")
	if this.Response != nil {
		s = append(s, "Response: "+fmt.Sprintf("%#v", this.Response)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReapplyEventsRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.ReapplyEventsRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.Request != nil {
		s = append(s, "Request: "+fmt.Sprintf("%#v", this.Request)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReapplyEventsResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.ReapplyEventsResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetDLQMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&historyservice.GetDLQMessagesRequest{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "SourceCluster: "+fmt.Sprintf("%#v", this.SourceCluster)+",\n")
	s = append(s, "InclusiveEndMessageId: "+fmt.Sprintf("%#v", this.InclusiveEndMessageId)+",\n")
	s = append(s, "MaximumPageSize: "+fmt.Sprintf("%#v", this.MaximumPageSize)+",\n")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetDLQMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&historyservice.GetDLQMessagesResponse{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.ReplicationTasks != nil {
		s = append(s, "ReplicationTasks: "+fmt.Sprintf("%#v", this.ReplicationTasks)+",\n")
	}
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PurgeDLQMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&historyservice.PurgeDLQMessagesRequest{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "SourceCluster: "+fmt.Sprintf("%#v", this.SourceCluster)+",\n")
	s = append(s, "InclusiveEndMessageId: "+fmt.Sprintf("%#v", this.InclusiveEndMessageId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PurgeDLQMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.PurgeDLQMessagesResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MergeDLQMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&historyservice.MergeDLQMessagesRequest{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "SourceCluster: "+fmt.Sprintf("%#v", this.SourceCluster)+",\n")
	s = append(s, "InclusiveEndMessageId: "+fmt.Sprintf("%#v", this.InclusiveEndMessageId)+",\n")
	s = append(s, "MaximumPageSize: "+fmt.Sprintf("%#v", this.MaximumPageSize)+",\n")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MergeDLQMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&historyservice.MergeDLQMessagesResponse{")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RefreshWorkflowTasksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&historyservice.RefreshWorkflowTasksRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.Request != nil {
		s = append(s, "Request: "+fmt.Sprintf("%#v", this.Request)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RefreshWorkflowTasksResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&historyservice.RefreshWorkflowTasksResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringRequestResponse(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *StartWorkflowExecutionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StartWorkflowExecutionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StartWorkflowExecutionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.FirstWorkflowTaskBackoff != nil {
		n1, err1 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.FirstWorkflowTaskBackoff, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.FirstWorkflowTaskBackoff):])
		if err1 != nil {
			return 0, err1
		}
		i -= n1
		i = encodeVarintRequestResponse(dAtA, i, uint64(n1))
		i--
		dAtA[i] = 0x4a
	}
	if m.LastCompletionResult != nil {
		{
			size, err := m.LastCompletionResult.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.ContinuedFailure != nil {
		{
			size, err := m.ContinuedFailure.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.ContinueAsNewInitiator != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ContinueAsNewInitiator))
		i--
		dAtA[i] = 0x30
	}
	if m.WorkflowExecutionExpirationTime != nil {
		n4, err4 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.WorkflowExecutionExpirationTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowExecutionExpirationTime):])
		if err4 != nil {
			return 0, err4
		}
		i -= n4
		i = encodeVarintRequestResponse(dAtA, i, uint64(n4))
		i--
		dAtA[i] = 0x2a
	}
	if m.Attempt != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Attempt))
		i--
		dAtA[i] = 0x20
	}
	if m.ParentExecutionInfo != nil {
		{
			size, err := m.ParentExecutionInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.StartRequest != nil {
		{
			size, err := m.StartRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StartWorkflowExecutionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StartWorkflowExecutionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StartWorkflowExecutionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetMutableStateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetMutableStateRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetMutableStateRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.CurrentBranchToken) > 0 {
		i -= len(m.CurrentBranchToken)
		copy(dAtA[i:], m.CurrentBranchToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.CurrentBranchToken)))
		i--
		dAtA[i] = 0x22
	}
	if m.ExpectedNextEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ExpectedNextEventId))
		i--
		dAtA[i] = 0x18
	}
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetMutableStateResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetMutableStateResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetMutableStateResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.IsStickyTaskQueueEnabled {
		i--
		if m.IsStickyTaskQueueEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x90
	}
	if m.VersionHistories != nil {
		{
			size, err := m.VersionHistories.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if m.WorkflowStatus != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.WorkflowStatus))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.WorkflowState != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.WorkflowState))
		i--
		dAtA[i] = 0x78
	}
	if len(m.CurrentBranchToken) > 0 {
		i -= len(m.CurrentBranchToken)
		copy(dAtA[i:], m.CurrentBranchToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.CurrentBranchToken)))
		i--
		dAtA[i] = 0x6a
	}
	if m.StickyTaskQueueScheduleToStartTimeout != nil {
		n9, err9 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.StickyTaskQueueScheduleToStartTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StickyTaskQueueScheduleToStartTimeout):])
		if err9 != nil {
			return 0, err9
		}
		i -= n9
		i = encodeVarintRequestResponse(dAtA, i, uint64(n9))
		i--
		dAtA[i] = 0x5a
	}
	if m.StickyTaskQueue != nil {
		{
			size, err := m.StickyTaskQueue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.TaskQueue != nil {
		{
			size, err := m.TaskQueue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.LastFirstEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.LastFirstEventId))
		i--
		dAtA[i] = 0x28
	}
	if m.PreviousStartedEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.PreviousStartedEventId))
		i--
		dAtA[i] = 0x20
	}
	if m.NextEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.NextEventId))
		i--
		dAtA[i] = 0x18
	}
	if m.WorkflowType != nil {
		{
			size, err := m.WorkflowType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PollMutableStateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PollMutableStateRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PollMutableStateRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.CurrentBranchToken) > 0 {
		i -= len(m.CurrentBranchToken)
		copy(dAtA[i:], m.CurrentBranchToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.CurrentBranchToken)))
		i--
		dAtA[i] = 0x22
	}
	if m.ExpectedNextEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ExpectedNextEventId))
		i--
		dAtA[i] = 0x18
	}
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PollMutableStateResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PollMutableStateResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PollMutableStateResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.WorkflowStatus != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.WorkflowStatus))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.WorkflowState != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.WorkflowState))
		i--
		dAtA[i] = 0x78
	}
	if m.VersionHistories != nil {
		{
			size, err := m.VersionHistories.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	if len(m.CurrentBranchToken) > 0 {
		i -= len(m.CurrentBranchToken)
		copy(dAtA[i:], m.CurrentBranchToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.CurrentBranchToken)))
		i--
		dAtA[i] = 0x62
	}
	if m.StickyTaskQueueScheduleToStartTimeout != nil {
		n16, err16 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.StickyTaskQueueScheduleToStartTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StickyTaskQueueScheduleToStartTimeout):])
		if err16 != nil {
			return 0, err16
		}
		i -= n16
		i = encodeVarintRequestResponse(dAtA, i, uint64(n16))
		i--
		dAtA[i] = 0x5a
	}
	if m.StickyTaskQueue != nil {
		{
			size, err := m.StickyTaskQueue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.TaskQueue != nil {
		{
			size, err := m.TaskQueue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.LastFirstEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.LastFirstEventId))
		i--
		dAtA[i] = 0x28
	}
	if m.PreviousStartedEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.PreviousStartedEventId))
		i--
		dAtA[i] = 0x20
	}
	if m.NextEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.NextEventId))
		i--
		dAtA[i] = 0x18
	}
	if m.WorkflowType != nil {
		{
			size, err := m.WorkflowType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResetStickyTaskQueueRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResetStickyTaskQueueRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResetStickyTaskQueueRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResetStickyTaskQueueResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResetStickyTaskQueueResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResetStickyTaskQueueResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *RecordWorkflowTaskStartedRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecordWorkflowTaskStartedRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RecordWorkflowTaskStartedRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PollRequest != nil {
		{
			size, err := m.PollRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.RequestId) > 0 {
		i -= len(m.RequestId)
		copy(dAtA[i:], m.RequestId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.RequestId)))
		i--
		dAtA[i] = 0x2a
	}
	if m.TaskId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x20
	}
	if m.ScheduleId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ScheduleId))
		i--
		dAtA[i] = 0x18
	}
	if m.WorkflowExecution != nil {
		{
			size, err := m.WorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RecordWorkflowTaskStartedResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecordWorkflowTaskStartedResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RecordWorkflowTaskStartedResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Queries) > 0 {
		for k := range m.Queries {
			v := m.Queries[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintRequestResponse(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRequestResponse(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRequestResponse(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x72
		}
	}
	if m.StartedTime != nil {
		n25, err25 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StartedTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartedTime):])
		if err25 != nil {
			return 0, err25
		}
		i -= n25
		i = encodeVarintRequestResponse(dAtA, i, uint64(n25))
		i--
		dAtA[i] = 0x6a
	}
	if m.ScheduledTime != nil {
		n26, err26 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ScheduledTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime):])
		if err26 != nil {
			return 0, err26
		}
		i -= n26
		i = encodeVarintRequestResponse(dAtA, i, uint64(n26))
		i--
		dAtA[i] = 0x62
	}
	if len(m.BranchToken) > 0 {
		i -= len(m.BranchToken)
		copy(dAtA[i:], m.BranchToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.BranchToken)))
		i--
		dAtA[i] = 0x5a
	}
	if m.WorkflowExecutionTaskQueue != nil {
		{
			size, err := m.WorkflowExecutionTaskQueue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.WorkflowTaskInfo != nil {
		{
			size, err := m.WorkflowTaskInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.StickyExecutionEnabled {
		i--
		if m.StickyExecutionEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.Attempt != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Attempt))
		i--
		dAtA[i] = 0x30
	}
	if m.NextEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.NextEventId))
		i--
		dAtA[i] = 0x28
	}
	if m.StartedEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.StartedEventId))
		i--
		dAtA[i] = 0x20
	}
	if m.ScheduledEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ScheduledEventId))
		i--
		dAtA[i] = 0x18
	}
	if m.PreviousStartedEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.PreviousStartedEventId))
		i--
		dAtA[i] = 0x10
	}
	if m.WorkflowType != nil {
		{
			size, err := m.WorkflowType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RecordActivityTaskStartedRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecordActivityTaskStartedRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RecordActivityTaskStartedRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PollRequest != nil {
		{
			size, err := m.PollRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.RequestId) > 0 {
		i -= len(m.RequestId)
		copy(dAtA[i:], m.RequestId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.RequestId)))
		i--
		dAtA[i] = 0x2a
	}
	if m.TaskId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x20
	}
	if m.ScheduleId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ScheduleId))
		i--
		dAtA[i] = 0x18
	}
	if m.WorkflowExecution != nil {
		{
			size, err := m.WorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RecordActivityTaskStartedResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecordActivityTaskStartedResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RecordActivityTaskStartedResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.WorkflowNamespace) > 0 {
		i -= len(m.WorkflowNamespace)
		copy(dAtA[i:], m.WorkflowNamespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.WorkflowNamespace)))
		i--
		dAtA[i] = 0x3a
	}
	if m.WorkflowType != nil {
		{
			size, err := m.WorkflowType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.HeartbeatDetails != nil {
		{
			size, err := m.HeartbeatDetails.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.CurrentAttemptScheduledTime != nil {
		n34, err34 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.CurrentAttemptScheduledTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.CurrentAttemptScheduledTime):])
		if err34 != nil {
			return 0, err34
		}
		i -= n34
		i = encodeVarintRequestResponse(dAtA, i, uint64(n34))
		i--
		dAtA[i] = 0x22
	}
	if m.Attempt != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Attempt))
		i--
		dAtA[i] = 0x18
	}
	if m.StartedTime != nil {
		n35, err35 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StartedTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartedTime):])
		if err35 != nil {
			return 0, err35
		}
		i -= n35
		i = encodeVarintRequestResponse(dAtA, i, uint64(n35))
		i--
		dAtA[i] = 0x12
	}
	if m.ScheduledEvent != nil {
		{
			size, err := m.ScheduledEvent.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RespondWorkflowTaskCompletedRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RespondWorkflowTaskCompletedRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RespondWorkflowTaskCompletedRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CompleteRequest != nil {
		{
			size, err := m.CompleteRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RespondWorkflowTaskCompletedResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RespondWorkflowTaskCompletedResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RespondWorkflowTaskCompletedResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.StartedResponse != nil {
		{
			size, err := m.StartedResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RespondWorkflowTaskFailedRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RespondWorkflowTaskFailedRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RespondWorkflowTaskFailedRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.FailedRequest != nil {
		{
			size, err := m.FailedRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RespondWorkflowTaskFailedResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RespondWorkflowTaskFailedResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RespondWorkflowTaskFailedResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *RecordActivityTaskHeartbeatRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecordActivityTaskHeartbeatRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RecordActivityTaskHeartbeatRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.HeartbeatRequest != nil {
		{
			size, err := m.HeartbeatRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RecordActivityTaskHeartbeatResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecordActivityTaskHeartbeatResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RecordActivityTaskHeartbeatResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CancelRequested {
		i--
		if m.CancelRequested {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RespondActivityTaskCompletedRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RespondActivityTaskCompletedRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RespondActivityTaskCompletedRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CompleteRequest != nil {
		{
			size, err := m.CompleteRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RespondActivityTaskCompletedResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RespondActivityTaskCompletedResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RespondActivityTaskCompletedResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *RespondActivityTaskFailedRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RespondActivityTaskFailedRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RespondActivityTaskFailedRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.FailedRequest != nil {
		{
			size, err := m.FailedRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RespondActivityTaskFailedResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RespondActivityTaskFailedResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RespondActivityTaskFailedResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *RespondActivityTaskCanceledRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RespondActivityTaskCanceledRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RespondActivityTaskCanceledRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CancelRequest != nil {
		{
			size, err := m.CancelRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RespondActivityTaskCanceledResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RespondActivityTaskCanceledResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RespondActivityTaskCanceledResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *SignalWorkflowExecutionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SignalWorkflowExecutionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SignalWorkflowExecutionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ChildWorkflowOnly {
		i--
		if m.ChildWorkflowOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.ExternalWorkflowExecution != nil {
		{
			size, err := m.ExternalWorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.SignalRequest != nil {
		{
			size, err := m.SignalRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SignalWorkflowExecutionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SignalWorkflowExecutionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SignalWorkflowExecutionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *SignalWithStartWorkflowExecutionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SignalWithStartWorkflowExecutionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SignalWithStartWorkflowExecutionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SignalWithStartRequest != nil {
		{
			size, err := m.SignalWithStartRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SignalWithStartWorkflowExecutionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SignalWithStartWorkflowExecutionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SignalWithStartWorkflowExecutionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RemoveSignalMutableStateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveSignalMutableStateRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveSignalMutableStateRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.RequestId) > 0 {
		i -= len(m.RequestId)
		copy(dAtA[i:], m.RequestId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.RequestId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.WorkflowExecution != nil {
		{
			size, err := m.WorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RemoveSignalMutableStateResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveSignalMutableStateResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveSignalMutableStateResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *TerminateWorkflowExecutionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TerminateWorkflowExecutionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TerminateWorkflowExecutionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TerminateRequest != nil {
		{
			size, err := m.TerminateRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TerminateWorkflowExecutionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TerminateWorkflowExecutionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TerminateWorkflowExecutionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *ResetWorkflowExecutionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResetWorkflowExecutionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResetWorkflowExecutionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ResetRequest != nil {
		{
			size, err := m.ResetRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResetWorkflowExecutionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResetWorkflowExecutionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResetWorkflowExecutionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RequestCancelWorkflowExecutionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestCancelWorkflowExecutionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RequestCancelWorkflowExecutionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ChildWorkflowOnly {
		i--
		if m.ChildWorkflowOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.ExternalWorkflowExecution != nil {
		{
			size, err := m.ExternalWorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.ExternalInitiatedEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ExternalInitiatedEventId))
		i--
		dAtA[i] = 0x18
	}
	if m.CancelRequest != nil {
		{
			size, err := m.CancelRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RequestCancelWorkflowExecutionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestCancelWorkflowExecutionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RequestCancelWorkflowExecutionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *ScheduleWorkflowTaskRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScheduleWorkflowTaskRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScheduleWorkflowTaskRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.IsFirstWorkflowTask {
		i--
		if m.IsFirstWorkflowTask {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.WorkflowExecution != nil {
		{
			size, err := m.WorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ScheduleWorkflowTaskResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScheduleWorkflowTaskResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScheduleWorkflowTaskResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *RecordChildExecutionCompletedRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecordChildExecutionCompletedRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RecordChildExecutionCompletedRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CompletionEvent != nil {
		{
			size, err := m.CompletionEvent.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.CompletedExecution != nil {
		{
			size, err := m.CompletedExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.InitiatedId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.InitiatedId))
		i--
		dAtA[i] = 0x18
	}
	if m.WorkflowExecution != nil {
		{
			size, err := m.WorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RecordChildExecutionCompletedResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecordChildExecutionCompletedResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RecordChildExecutionCompletedResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *DescribeWorkflowExecutionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeWorkflowExecutionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeWorkflowExecutionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Request != nil {
		{
			size, err := m.Request.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DescribeWorkflowExecutionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeWorkflowExecutionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeWorkflowExecutionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PendingChildren) > 0 {
		for iNdEx := len(m.PendingChildren) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PendingChildren[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.PendingActivities) > 0 {
		for iNdEx := len(m.PendingActivities) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PendingActivities[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.WorkflowExecutionInfo != nil {
		{
			size, err := m.WorkflowExecutionInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.ExecutionConfig != nil {
		{
			size, err := m.ExecutionConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReplicateEventsV2Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicateEventsV2Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicateEventsV2Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.NewRunEvents != nil {
		{
			size, err := m.NewRunEvents.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Events != nil {
		{
			size, err := m.Events.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.VersionHistoryItems) > 0 {
		for iNdEx := len(m.VersionHistoryItems) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.VersionHistoryItems[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.WorkflowExecution != nil {
		{
			size, err := m.WorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReplicateEventsV2Response) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicateEventsV2Response) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicateEventsV2Response) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *SyncShardStatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SyncShardStatusRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SyncShardStatusRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.StatusTime != nil {
		n62, err62 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StatusTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.StatusTime):])
		if err62 != nil {
			return 0, err62
		}
		i -= n62
		i = encodeVarintRequestResponse(dAtA, i, uint64(n62))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if len(m.SourceCluster) > 0 {
		i -= len(m.SourceCluster)
		copy(dAtA[i:], m.SourceCluster)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SourceCluster)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SyncShardStatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SyncShardStatusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SyncShardStatusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *SyncActivityRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SyncActivityRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SyncActivityRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VersionHistory != nil {
		{
			size, err := m.VersionHistory.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	if len(m.LastWorkerIdentity) > 0 {
		i -= len(m.LastWorkerIdentity)
		copy(dAtA[i:], m.LastWorkerIdentity)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.LastWorkerIdentity)))
		i--
		dAtA[i] = 0x6a
	}
	if m.LastFailure != nil {
		{
			size, err := m.LastFailure.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.Attempt != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Attempt))
		i--
		dAtA[i] = 0x58
	}
	if m.Details != nil {
		{
			size, err := m.Details.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.LastHeartbeatTime != nil {
		n66, err66 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.LastHeartbeatTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastHeartbeatTime):])
		if err66 != nil {
			return 0, err66
		}
		i -= n66
		i = encodeVarintRequestResponse(dAtA, i, uint64(n66))
		i--
		dAtA[i] = 0x4a
	}
	if m.StartedTime != nil {
		n67, err67 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StartedTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartedTime):])
		if err67 != nil {
			return 0, err67
		}
		i -= n67
		i = encodeVarintRequestResponse(dAtA, i, uint64(n67))
		i--
		dAtA[i] = 0x42
	}
	if m.StartedId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.StartedId))
		i--
		dAtA[i] = 0x38
	}
	if m.ScheduledTime != nil {
		n68, err68 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ScheduledTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime):])
		if err68 != nil {
			return 0, err68
		}
		i -= n68
		i = encodeVarintRequestResponse(dAtA, i, uint64(n68))
		i--
		dAtA[i] = 0x32
	}
	if m.ScheduledId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ScheduledId))
		i--
		dAtA[i] = 0x28
	}
	if m.Version != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SyncActivityResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SyncActivityResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SyncActivityResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *DescribeMutableStateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeMutableStateRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeMutableStateRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DescribeMutableStateResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeMutableStateResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeMutableStateResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DatabaseMutableState != nil {
		{
			size, err := m.DatabaseMutableState.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.CacheMutableState != nil {
		{
			size, err := m.CacheMutableState.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DescribeHistoryHostRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeHistoryHostRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeHistoryHostRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.WorkflowExecution != nil {
		{
			size, err := m.WorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if len(m.HostAddress) > 0 {
		i -= len(m.HostAddress)
		copy(dAtA[i:], m.HostAddress)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.HostAddress)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DescribeHistoryHostResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeHistoryHostResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeHistoryHostResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ShardControllerStatus) > 0 {
		i -= len(m.ShardControllerStatus)
		copy(dAtA[i:], m.ShardControllerStatus)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ShardControllerStatus)))
		i--
		dAtA[i] = 0x22
	}
	if m.NamespaceCache != nil {
		{
			size, err := m.NamespaceCache.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ShardIds) > 0 {
		dAtA75 := make([]byte, len(m.ShardIds)*10)
		var j74 int
		for _, num1 := range m.ShardIds {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA75[j74] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j74++
			}
			dAtA75[j74] = uint8(num)
			j74++
		}
		i -= j74
		copy(dAtA[i:], dAtA75[:j74])
		i = encodeVarintRequestResponse(dAtA, i, uint64(j74))
		i--
		dAtA[i] = 0x12
	}
	if m.ShardsNumber != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardsNumber))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CloseShardRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CloseShardRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CloseShardRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CloseShardResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CloseShardResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CloseShardResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *RemoveTaskRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveTaskRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveTaskRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VisibilityTime != nil {
		n76, err76 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.VisibilityTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime):])
		if err76 != nil {
			return 0, err76
		}
		i -= n76
		i = encodeVarintRequestResponse(dAtA, i, uint64(n76))
		i--
		dAtA[i] = 0x22
	}
	if m.TaskId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x18
	}
	if m.Category != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Category))
		i--
		dAtA[i] = 0x10
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RemoveTaskResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveTaskResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveTaskResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *GetReplicationMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetReplicationMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetReplicationMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Tokens) > 0 {
		for iNdEx := len(m.Tokens) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tokens[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetReplicationMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetReplicationMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetReplicationMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ShardMessages) > 0 {
		for k := range m.ShardMessages {
			v := m.ShardMessages[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintRequestResponse(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintRequestResponse(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintRequestResponse(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetDLQReplicationMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDLQReplicationMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDLQReplicationMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.TaskInfos) > 0 {
		for iNdEx := len(m.TaskInfos) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.TaskInfos[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetDLQReplicationMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDLQReplicationMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDLQReplicationMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ReplicationTasks) > 0 {
		for iNdEx := len(m.ReplicationTasks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ReplicationTasks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *QueryWorkflowRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryWorkflowRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryWorkflowRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Request != nil {
		{
			size, err := m.Request.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QueryWorkflowResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryWorkflowResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryWorkflowResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Response != nil {
		{
			size, err := m.Response.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReapplyEventsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReapplyEventsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReapplyEventsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Request != nil {
		{
			size, err := m.Request.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReapplyEventsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReapplyEventsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReapplyEventsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *GetDLQMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDLQMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDLQMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x32
	}
	if m.MaximumPageSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MaximumPageSize))
		i--
		dAtA[i] = 0x28
	}
	if m.InclusiveEndMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.InclusiveEndMessageId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.SourceCluster) > 0 {
		i -= len(m.SourceCluster)
		copy(dAtA[i:], m.SourceCluster)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SourceCluster)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GetDLQMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDLQMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDLQMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ReplicationTasks) > 0 {
		for iNdEx := len(m.ReplicationTasks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ReplicationTasks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Type != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PurgeDLQMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PurgeDLQMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PurgeDLQMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.InclusiveEndMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.InclusiveEndMessageId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.SourceCluster) > 0 {
		i -= len(m.SourceCluster)
		copy(dAtA[i:], m.SourceCluster)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SourceCluster)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PurgeDLQMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PurgeDLQMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PurgeDLQMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *MergeDLQMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeDLQMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MergeDLQMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x32
	}
	if m.MaximumPageSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MaximumPageSize))
		i--
		dAtA[i] = 0x28
	}
	if m.InclusiveEndMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.InclusiveEndMessageId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.SourceCluster) > 0 {
		i -= len(m.SourceCluster)
		copy(dAtA[i:], m.SourceCluster)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SourceCluster)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MergeDLQMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeDLQMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MergeDLQMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RefreshWorkflowTasksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshWorkflowTasksRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RefreshWorkflowTasksRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Request != nil {
		{
			size, err := m.Request.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RefreshWorkflowTasksResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshWorkflowTasksResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RefreshWorkflowTasksResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func encodeVarintRequestResponse(dAtA []byte, offset int, v uint64) int {
	offset -= sovRequestResponse(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *StartWorkflowExecutionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StartRequest != nil {
		l = m.StartRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ParentExecutionInfo != nil {
		l = m.ParentExecutionInfo.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Attempt != 0 {
		n += 1 + sovRequestResponse(uint64(m.Attempt))
	}
	if m.WorkflowExecutionExpirationTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowExecutionExpirationTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ContinueAsNewInitiator != 0 {
		n += 1 + sovRequestResponse(uint64(m.ContinueAsNewInitiator))
	}
	if m.ContinuedFailure != nil {
		l = m.ContinuedFailure.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.LastCompletionResult != nil {
		l = m.LastCompletionResult.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.FirstWorkflowTaskBackoff != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.FirstWorkflowTaskBackoff)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *StartWorkflowExecutionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetMutableStateRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ExpectedNextEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ExpectedNextEventId))
	}
	l = len(m.CurrentBranchToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetMutableStateResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowType != nil {
		l = m.WorkflowType.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.NextEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.NextEventId))
	}
	if m.PreviousStartedEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.PreviousStartedEventId))
	}
	if m.LastFirstEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.LastFirstEventId))
	}
	if m.TaskQueue != nil {
		l = m.TaskQueue.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StickyTaskQueue != nil {
		l = m.StickyTaskQueue.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StickyTaskQueueScheduleToStartTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StickyTaskQueueScheduleToStartTimeout)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.CurrentBranchToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowState != 0 {
		n += 1 + sovRequestResponse(uint64(m.WorkflowState))
	}
	if m.WorkflowStatus != 0 {
		n += 2 + sovRequestResponse(uint64(m.WorkflowStatus))
	}
	if m.VersionHistories != nil {
		l = m.VersionHistories.Size()
		n += 2 + l + sovRequestResponse(uint64(l))
	}
	if m.IsStickyTaskQueueEnabled {
		n += 3
	}
	return n
}

func (m *PollMutableStateRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ExpectedNextEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ExpectedNextEventId))
	}
	l = len(m.CurrentBranchToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *PollMutableStateResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowType != nil {
		l = m.WorkflowType.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.NextEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.NextEventId))
	}
	if m.PreviousStartedEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.PreviousStartedEventId))
	}
	if m.LastFirstEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.LastFirstEventId))
	}
	if m.TaskQueue != nil {
		l = m.TaskQueue.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StickyTaskQueue != nil {
		l = m.StickyTaskQueue.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StickyTaskQueueScheduleToStartTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StickyTaskQueueScheduleToStartTimeout)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.CurrentBranchToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.VersionHistories != nil {
		l = m.VersionHistories.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowState != 0 {
		n += 1 + sovRequestResponse(uint64(m.WorkflowState))
	}
	if m.WorkflowStatus != 0 {
		n += 2 + sovRequestResponse(uint64(m.WorkflowStatus))
	}
	return n
}

func (m *ResetStickyTaskQueueRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ResetStickyTaskQueueResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *RecordWorkflowTaskStartedRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecution != nil {
		l = m.WorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ScheduleId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ScheduleId))
	}
	if m.TaskId != 0 {
		n += 1 + sovRequestResponse(uint64(m.TaskId))
	}
	l = len(m.RequestId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.PollRequest != nil {
		l = m.PollRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RecordWorkflowTaskStartedResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.WorkflowType != nil {
		l = m.WorkflowType.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.PreviousStartedEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.PreviousStartedEventId))
	}
	if m.ScheduledEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ScheduledEventId))
	}
	if m.StartedEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.StartedEventId))
	}
	if m.NextEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.NextEventId))
	}
	if m.Attempt != 0 {
		n += 1 + sovRequestResponse(uint64(m.Attempt))
	}
	if m.StickyExecutionEnabled {
		n += 2
	}
	if m.WorkflowTaskInfo != nil {
		l = m.WorkflowTaskInfo.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecutionTaskQueue != nil {
		l = m.WorkflowExecutionTaskQueue.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.BranchToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ScheduledTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StartedTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartedTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if len(m.Queries) > 0 {
		for k, v := range m.Queries {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovRequestResponse(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovRequestResponse(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovRequestResponse(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *RecordActivityTaskStartedRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecution != nil {
		l = m.WorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ScheduleId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ScheduleId))
	}
	if m.TaskId != 0 {
		n += 1 + sovRequestResponse(uint64(m.TaskId))
	}
	l = len(m.RequestId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.PollRequest != nil {
		l = m.PollRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RecordActivityTaskStartedResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ScheduledEvent != nil {
		l = m.ScheduledEvent.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StartedTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartedTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Attempt != 0 {
		n += 1 + sovRequestResponse(uint64(m.Attempt))
	}
	if m.CurrentAttemptScheduledTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.CurrentAttemptScheduledTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.HeartbeatDetails != nil {
		l = m.HeartbeatDetails.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowType != nil {
		l = m.WorkflowType.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.WorkflowNamespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RespondWorkflowTaskCompletedRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.CompleteRequest != nil {
		l = m.CompleteRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RespondWorkflowTaskCompletedResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StartedResponse != nil {
		l = m.StartedResponse.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RespondWorkflowTaskFailedRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.FailedRequest != nil {
		l = m.FailedRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RespondWorkflowTaskFailedResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *RecordActivityTaskHeartbeatRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.HeartbeatRequest != nil {
		l = m.HeartbeatRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RecordActivityTaskHeartbeatResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CancelRequested {
		n += 2
	}
	return n
}

func (m *RespondActivityTaskCompletedRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.CompleteRequest != nil {
		l = m.CompleteRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RespondActivityTaskCompletedResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *RespondActivityTaskFailedRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.FailedRequest != nil {
		l = m.FailedRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RespondActivityTaskFailedResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *RespondActivityTaskCanceledRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.CancelRequest != nil {
		l = m.CancelRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RespondActivityTaskCanceledResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *SignalWorkflowExecutionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.SignalRequest != nil {
		l = m.SignalRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ExternalWorkflowExecution != nil {
		l = m.ExternalWorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ChildWorkflowOnly {
		n += 2
	}
	return n
}

func (m *SignalWorkflowExecutionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *SignalWithStartWorkflowExecutionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.SignalWithStartRequest != nil {
		l = m.SignalWithStartRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *SignalWithStartWorkflowExecutionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RemoveSignalMutableStateRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecution != nil {
		l = m.WorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.RequestId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RemoveSignalMutableStateResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *TerminateWorkflowExecutionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.TerminateRequest != nil {
		l = m.TerminateRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *TerminateWorkflowExecutionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ResetWorkflowExecutionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ResetRequest != nil {
		l = m.ResetRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ResetWorkflowExecutionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RequestCancelWorkflowExecutionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.CancelRequest != nil {
		l = m.CancelRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ExternalInitiatedEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ExternalInitiatedEventId))
	}
	if m.ExternalWorkflowExecution != nil {
		l = m.ExternalWorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ChildWorkflowOnly {
		n += 2
	}
	return n
}

func (m *RequestCancelWorkflowExecutionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ScheduleWorkflowTaskRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecution != nil {
		l = m.WorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.IsFirstWorkflowTask {
		n += 2
	}
	return n
}

func (m *ScheduleWorkflowTaskResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *RecordChildExecutionCompletedRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecution != nil {
		l = m.WorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.InitiatedId != 0 {
		n += 1 + sovRequestResponse(uint64(m.InitiatedId))
	}
	if m.CompletedExecution != nil {
		l = m.CompletedExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.CompletionEvent != nil {
		l = m.CompletionEvent.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RecordChildExecutionCompletedResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *DescribeWorkflowExecutionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Request != nil {
		l = m.Request.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *DescribeWorkflowExecutionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExecutionConfig != nil {
		l = m.ExecutionConfig.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecutionInfo != nil {
		l = m.WorkflowExecutionInfo.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if len(m.PendingActivities) > 0 {
		for _, e := range m.PendingActivities {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	if len(m.PendingChildren) > 0 {
		for _, e := range m.PendingChildren {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	return n
}

func (m *ReplicateEventsV2Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecution != nil {
		l = m.WorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if len(m.VersionHistoryItems) > 0 {
		for _, e := range m.VersionHistoryItems {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	if m.Events != nil {
		l = m.Events.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.NewRunEvents != nil {
		l = m.NewRunEvents.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ReplicateEventsV2Response) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *SyncShardStatusRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SourceCluster)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	if m.StatusTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StatusTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *SyncShardStatusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *SyncActivityRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Version != 0 {
		n += 1 + sovRequestResponse(uint64(m.Version))
	}
	if m.ScheduledId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ScheduledId))
	}
	if m.ScheduledTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StartedId != 0 {
		n += 1 + sovRequestResponse(uint64(m.StartedId))
	}
	if m.StartedTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartedTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.LastHeartbeatTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastHeartbeatTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Details != nil {
		l = m.Details.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Attempt != 0 {
		n += 1 + sovRequestResponse(uint64(m.Attempt))
	}
	if m.LastFailure != nil {
		l = m.LastFailure.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.LastWorkerIdentity)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.VersionHistory != nil {
		l = m.VersionHistory.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *SyncActivityResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *DescribeMutableStateRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *DescribeMutableStateResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CacheMutableState != nil {
		l = m.CacheMutableState.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.DatabaseMutableState != nil {
		l = m.DatabaseMutableState.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *DescribeHistoryHostRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HostAddress)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecution != nil {
		l = m.WorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *DescribeHistoryHostResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardsNumber != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardsNumber))
	}
	if len(m.ShardIds) > 0 {
		l = 0
		for _, e := range m.ShardIds {
			l += sovRequestResponse(uint64(e))
		}
		n += 1 + sovRequestResponse(uint64(l)) + l
	}
	if m.NamespaceCache != nil {
		l = m.NamespaceCache.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.ShardControllerStatus)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *CloseShardRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	return n
}

func (m *CloseShardResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *RemoveTaskRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	if m.Category != 0 {
		n += 1 + sovRequestResponse(uint64(m.Category))
	}
	if m.TaskId != 0 {
		n += 1 + sovRequestResponse(uint64(m.TaskId))
	}
	if m.VisibilityTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RemoveTaskResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *GetReplicationMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Tokens) > 0 {
		for _, e := range m.Tokens {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetReplicationMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ShardMessages) > 0 {
		for k, v := range m.ShardMessages {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovRequestResponse(uint64(l))
			}
			mapEntrySize := 1 + sovRequestResponse(uint64(k)) + l
			n += mapEntrySize + 1 + sovRequestResponse(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *GetDLQReplicationMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.TaskInfos) > 0 {
		for _, e := range m.TaskInfos {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	return n
}

func (m *GetDLQReplicationMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ReplicationTasks) > 0 {
		for _, e := range m.ReplicationTasks {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	return n
}

func (m *QueryWorkflowRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Request != nil {
		l = m.Request.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *QueryWorkflowResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Response != nil {
		l = m.Response.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ReapplyEventsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Request != nil {
		l = m.Request.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ReapplyEventsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *GetDLQMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRequestResponse(uint64(m.Type))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	l = len(m.SourceCluster)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.InclusiveEndMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.InclusiveEndMessageId))
	}
	if m.MaximumPageSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.MaximumPageSize))
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetDLQMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRequestResponse(uint64(m.Type))
	}
	if len(m.ReplicationTasks) > 0 {
		for _, e := range m.ReplicationTasks {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *PurgeDLQMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRequestResponse(uint64(m.Type))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	l = len(m.SourceCluster)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.InclusiveEndMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.InclusiveEndMessageId))
	}
	return n
}

func (m *PurgeDLQMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *MergeDLQMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRequestResponse(uint64(m.Type))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	l = len(m.SourceCluster)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.InclusiveEndMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.InclusiveEndMessageId))
	}
	if m.MaximumPageSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.MaximumPageSize))
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *MergeDLQMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RefreshWorkflowTasksRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Request != nil {
		l = m.Request.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RefreshWorkflowTasksResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func sovRequestResponse(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRequestResponse(x uint64) (n int) {
	return sovRequestResponse(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *StartWorkflowExecutionRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StartWorkflowExecutionRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`StartRequest:` + strings.Replace(fmt.Sprintf("%v", this.StartRequest), "StartWorkflowExecutionRequest", "v1.StartWorkflowExecutionRequest", 1) + `,`,
		`ParentExecutionInfo:` + strings.Replace(fmt.Sprintf("%v", this.ParentExecutionInfo), "ParentExecutionInfo", "v11.ParentExecutionInfo", 1) + `,`,
		`Attempt:` + fmt.Sprintf("%v", this.Attempt) + `,`,
		`WorkflowExecutionExpirationTime:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecutionExpirationTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`ContinueAsNewInitiator:` + fmt.Sprintf("%v", this.ContinueAsNewInitiator) + `,`,
		`ContinuedFailure:` + strings.Replace(fmt.Sprintf("%v", this.ContinuedFailure), "Failure", "v13.Failure", 1) + `,`,
		`LastCompletionResult:` + strings.Replace(fmt.Sprintf("%v", this.LastCompletionResult), "Payloads", "v14.Payloads", 1) + `,`,
		`FirstWorkflowTaskBackoff:` + strings.Replace(fmt.Sprintf("%v", this.FirstWorkflowTaskBackoff), "Duration", "types.Duration", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StartWorkflowExecutionResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StartWorkflowExecutionResponse{`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetMutableStateRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetMutableStateRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v14.WorkflowExecution", 1) + `,`,
		`ExpectedNextEventId:` + fmt.Sprintf("%v", this.ExpectedNextEventId) + `,`,
		`CurrentBranchToken:` + fmt.Sprintf("%v", this.CurrentBranchToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetMutableStateResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetMutableStateResponse{`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v14.WorkflowExecution", 1) + `,`,
		`WorkflowType:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowType), "WorkflowType", "v14.WorkflowType", 1) + `,`,
		`NextEventId:` + fmt.Sprintf("%v", this.NextEventId) + `,`,
		`PreviousStartedEventId:` + fmt.Sprintf("%v", this.PreviousStartedEventId) + `,`,
		`LastFirstEventId:` + fmt.Sprintf("%v", this.LastFirstEventId) + `,`,
		`TaskQueue:` + strings.Replace(fmt.Sprintf("%v", this.TaskQueue), "TaskQueue", "v15.TaskQueue", 1) + `,`,
		`StickyTaskQueue:` + strings.Replace(fmt.Sprintf("%v", this.StickyTaskQueue), "TaskQueue", "v15.TaskQueue", 1) + `,`,
		`StickyTaskQueueScheduleToStartTimeout:` + strings.Replace(fmt.Sprintf("%v", this.StickyTaskQueueScheduleToStartTimeout), "Duration", "types.Duration", 1) + `,`,
		`CurrentBranchToken:` + fmt.Sprintf("%v", this.CurrentBranchToken) + `,`,
		`WorkflowState:` + fmt.Sprintf("%v", this.WorkflowState) + `,`,
		`WorkflowStatus:` + fmt.Sprintf("%v", this.WorkflowStatus) + `,`,
		`VersionHistories:` + strings.Replace(fmt.Sprintf("%v", this.VersionHistories), "VersionHistories", "v17.VersionHistories", 1) + `,`,
		`IsStickyTaskQueueEnabled:` + fmt.Sprintf("%v", this.IsStickyTaskQueueEnabled) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PollMutableStateRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PollMutableStateRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v14.WorkflowExecution", 1) + `,`,
		`ExpectedNextEventId:` + fmt.Sprintf("%v", this.ExpectedNextEventId) + `,`,
		`CurrentBranchToken:` + fmt.Sprintf("%v", this.CurrentBranchToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PollMutableStateResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PollMutableStateResponse{`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v14.WorkflowExecution", 1) + `,`,
		`WorkflowType:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowType), "WorkflowType", "v14.WorkflowType", 1) + `,`,
		`NextEventId:` + fmt.Sprintf("%v", this.NextEventId) + `,`,
		`PreviousStartedEventId:` + fmt.Sprintf("%v", this.PreviousStartedEventId) + `,`,
		`LastFirstEventId:` + fmt.Sprintf("%v", this.LastFirstEventId) + `,`,
		`TaskQueue:` + strings.Replace(fmt.Sprintf("%v", this.TaskQueue), "TaskQueue", "v15.TaskQueue", 1) + `,`,
		`StickyTaskQueue:` + strings.Replace(fmt.Sprintf("%v", this.StickyTaskQueue), "TaskQueue", "v15.TaskQueue", 1) + `,`,
		`StickyTaskQueueScheduleToStartTimeout:` + strings.Replace(fmt.Sprintf("%v", this.StickyTaskQueueScheduleToStartTimeout), "Duration", "types.Duration", 1) + `,`,
		`CurrentBranchToken:` + fmt.Sprintf("%v", this.CurrentBranchToken) + `,`,
		`VersionHistories:` + strings.Replace(fmt.Sprintf("%v", this.VersionHistories), "VersionHistories", "v17.VersionHistories", 1) + `,`,
		`WorkflowState:` + fmt.Sprintf("%v", this.WorkflowState) + `,`,
		`WorkflowStatus:` + fmt.Sprintf("%v", this.WorkflowStatus) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResetStickyTaskQueueRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResetStickyTaskQueueRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v14.WorkflowExecution", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResetStickyTaskQueueResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResetStickyTaskQueueResponse{`,
		`}`,
	}, "")
	return s
}
func (this *RecordWorkflowTaskStartedRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RecordWorkflowTaskStartedRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecution), "WorkflowExecution", "v14.WorkflowExecution", 1) + `,`,
		`ScheduleId:` + fmt.Sprintf("%v", this.ScheduleId) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`RequestId:` + fmt.Sprintf("%v", this.RequestId) + `,`,
		`PollRequest:` + strings.Replace(fmt.Sprintf("%v", this.PollRequest), "PollWorkflowTaskQueueRequest", "v1.PollWorkflowTaskQueueRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RecordWorkflowTaskStartedResponse) String() string {
	if this == nil {
		return "nil"
	}
	keysForQueries := make([]string, 0, len(this.Queries))
	for k, _ := range this.Queries {
		keysForQueries = append(keysForQueries, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForQueries)
	mapStringForQueries := "map[string]*v18.WorkflowQuery{"
	for _, k := range keysForQueries {
		mapStringForQueries += fmt.Sprintf("%v: %v,", k, this.Queries[k])
	}
	mapStringForQueries += "}"
	s := strings.Join([]string{`&RecordWorkflowTaskStartedResponse{`,
		`WorkflowType:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowType), "WorkflowType", "v14.WorkflowType", 1) + `,`,
		`PreviousStartedEventId:` + fmt.Sprintf("%v", this.PreviousStartedEventId) + `,`,
		`ScheduledEventId:` + fmt.Sprintf("%v", this.ScheduledEventId) + `,`,
		`StartedEventId:` + fmt.Sprintf("%v", this.StartedEventId) + `,`,
		`NextEventId:` + fmt.Sprintf("%v", this.NextEventId) + `,`,
		`Attempt:` + fmt.Sprintf("%v", this.Attempt) + `,`,
		`StickyExecutionEnabled:` + fmt.Sprintf("%v", this.StickyExecutionEnabled) + `,`,
		`WorkflowTaskInfo:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowTaskInfo), "TransientWorkflowTaskInfo", "v17.TransientWorkflowTaskInfo", 1) + `,`,
		`WorkflowExecutionTaskQueue:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecutionTaskQueue), "TaskQueue", "v15.TaskQueue", 1) + `,`,
		`BranchToken:` + fmt.Sprintf("%v", this.BranchToken) + `,`,
		`ScheduledTime:` + strings.Replace(fmt.Sprintf("%v", this.ScheduledTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`StartedTime:` + strings.Replace(fmt.Sprintf("%v", this.StartedTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`Queries:` + mapStringForQueries + `,`,
		`}`,
	}, "")
	return s
}
func (this *RecordActivityTaskStartedRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RecordActivityTaskStartedRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecution), "WorkflowExecution", "v14.WorkflowExecution", 1) + `,`,
		`ScheduleId:` + fmt.Sprintf("%v", this.ScheduleId) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`RequestId:` + fmt.Sprintf("%v", this.RequestId) + `,`,
		`PollRequest:` + strings.Replace(fmt.Sprintf("%v", this.PollRequest), "PollActivityTaskQueueRequest", "v1.PollActivityTaskQueueRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RecordActivityTaskStartedResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RecordActivityTaskStartedResponse{`,
		`ScheduledEvent:` + strings.Replace(fmt.Sprintf("%v", this.ScheduledEvent), "HistoryEvent", "v19.HistoryEvent", 1) + `,`,
		`StartedTime:` + strings.Replace(fmt.Sprintf("%v", this.StartedTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`Attempt:` + fmt.Sprintf("%v", this.Attempt) + `,`,
		`CurrentAttemptScheduledTime:` + strings.Replace(fmt.Sprintf("%v", this.CurrentAttemptScheduledTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`HeartbeatDetails:` + strings.Replace(fmt.Sprintf("%v", this.HeartbeatDetails), "Payloads", "v14.Payloads", 1) + `,`,
		`WorkflowType:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowType), "WorkflowType", "v14.WorkflowType", 1) + `,`,
		`WorkflowNamespace:` + fmt.Sprintf("%v", this.WorkflowNamespace) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RespondWorkflowTaskCompletedRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RespondWorkflowTaskCompletedRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`CompleteRequest:` + strings.Replace(fmt.Sprintf("%v", this.CompleteRequest), "RespondWorkflowTaskCompletedRequest", "v1.RespondWorkflowTaskCompletedRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RespondWorkflowTaskCompletedResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RespondWorkflowTaskCompletedResponse{`,
		`StartedResponse:` + strings.Replace(this.StartedResponse.String(), "RecordWorkflowTaskStartedResponse", "RecordWorkflowTaskStartedResponse", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RespondWorkflowTaskFailedRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RespondWorkflowTaskFailedRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`FailedRequest:` + strings.Replace(fmt.Sprintf("%v", this.FailedRequest), "RespondWorkflowTaskFailedRequest", "v1.RespondWorkflowTaskFailedRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RespondWorkflowTaskFailedResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RespondWorkflowTaskFailedResponse{`,
		`}`,
	}, "")
	return s
}
func (this *RecordActivityTaskHeartbeatRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RecordActivityTaskHeartbeatRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`HeartbeatRequest:` + strings.Replace(fmt.Sprintf("%v", this.HeartbeatRequest), "RecordActivityTaskHeartbeatRequest", "v1.RecordActivityTaskHeartbeatRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RecordActivityTaskHeartbeatResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RecordActivityTaskHeartbeatResponse{`,
		`CancelRequested:` + fmt.Sprintf("%v", this.CancelRequested) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RespondActivityTaskCompletedRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RespondActivityTaskCompletedRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`CompleteRequest:` + strings.Replace(fmt.Sprintf("%v", this.CompleteRequest), "RespondActivityTaskCompletedRequest", "v1.RespondActivityTaskCompletedRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RespondActivityTaskCompletedResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RespondActivityTaskCompletedResponse{`,
		`}`,
	}, "")
	return s
}
func (this *RespondActivityTaskFailedRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RespondActivityTaskFailedRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`FailedRequest:` + strings.Replace(fmt.Sprintf("%v", this.FailedRequest), "RespondActivityTaskFailedRequest", "v1.RespondActivityTaskFailedRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RespondActivityTaskFailedResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RespondActivityTaskFailedResponse{`,
		`}`,
	}, "")
	return s
}
func (this *RespondActivityTaskCanceledRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RespondActivityTaskCanceledRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`CancelRequest:` + strings.Replace(fmt.Sprintf("%v", this.CancelRequest), "RespondActivityTaskCanceledRequest", "v1.RespondActivityTaskCanceledRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RespondActivityTaskCanceledResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RespondActivityTaskCanceledResponse{`,
		`}`,
	}, "")
	return s
}
func (this *SignalWorkflowExecutionRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SignalWorkflowExecutionRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`SignalRequest:` + strings.Replace(fmt.Sprintf("%v", this.SignalRequest), "SignalWorkflowExecutionRequest", "v1.SignalWorkflowExecutionRequest", 1) + `,`,
		`ExternalWorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.ExternalWorkflowExecution), "WorkflowExecution", "v14.WorkflowExecution", 1) + `,`,
		`ChildWorkflowOnly:` + fmt.Sprintf("%v", this.ChildWorkflowOnly) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SignalWorkflowExecutionResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SignalWorkflowExecutionResponse{`,
		`}`,
	}, "")
	return s
}
func (this *SignalWithStartWorkflowExecutionRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SignalWithStartWorkflowExecutionRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`SignalWithStartRequest:` + strings.Replace(fmt.Sprintf("%v", this.SignalWithStartRequest), "SignalWithStartWorkflowExecutionRequest", "v1.SignalWithStartWorkflowExecutionRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SignalWithStartWorkflowExecutionResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SignalWithStartWorkflowExecutionResponse{`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveSignalMutableStateRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveSignalMutableStateRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecution), "WorkflowExecution", "v14.WorkflowExecution", 1) + `,`,
		`RequestId:` + fmt.Sprintf("%v", this.RequestId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveSignalMutableStateResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveSignalMutableStateResponse{`,
		`}`,
	}, "")
	return s
}
func (this *TerminateWorkflowExecutionRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TerminateWorkflowExecutionRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`TerminateRequest:` + strings.Replace(fmt.Sprintf("%v", this.TerminateRequest), "TerminateWorkflowExecutionRequest", "v1.TerminateWorkflowExecutionRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TerminateWorkflowExecutionResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TerminateWorkflowExecutionResponse{`,
		`}`,
	}, "")
	return s
}
func (this *ResetWorkflowExecutionRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResetWorkflowExecutionRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`ResetRequest:` + strings.Replace(fmt.Sprintf("%v", this.ResetRequest), "ResetWorkflowExecutionRequest", "v1.ResetWorkflowExecutionRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResetWorkflowExecutionResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResetWorkflowExecutionResponse{`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RequestCancelWorkflowExecutionRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RequestCancelWorkflowExecutionRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`CancelRequest:` + strings.Replace(fmt.Sprintf("%v", this.CancelRequest), "RequestCancelWorkflowExecutionRequest", "v1.RequestCancelWorkflowExecutionRequest", 1) + `,`,
		`ExternalInitiatedEventId:` + fmt.Sprintf("%v", this.ExternalInitiatedEventId) + `,`,
		`ExternalWorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.ExternalWorkflowExecution), "WorkflowExecution", "v14.WorkflowExecution", 1) + `,`,
		`ChildWorkflowOnly:` + fmt.Sprintf("%v", this.ChildWorkflowOnly) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RequestCancelWorkflowExecutionResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RequestCancelWorkflowExecutionResponse{`,
		`}`,
	}, "")
	return s
}
func (this *ScheduleWorkflowTaskRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ScheduleWorkflowTaskRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecution), "WorkflowExecution", "v14.WorkflowExecution", 1) + `,`,
		`IsFirstWorkflowTask:` + fmt.Sprintf("%v", this.IsFirstWorkflowTask) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ScheduleWorkflowTaskResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ScheduleWorkflowTaskResponse{`,
		`}`,
	}, "")
	return s
}
func (this *RecordChildExecutionCompletedRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RecordChildExecutionCompletedRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecution), "WorkflowExecution", "v14.WorkflowExecution", 1) + `,`,
		`InitiatedId:` + fmt.Sprintf("%v", this.InitiatedId) + `,`,
		`CompletedExecution:` + strings.Replace(fmt.Sprintf("%v", this.CompletedExecution), "WorkflowExecution", "v14.WorkflowExecution", 1) + `,`,
		`CompletionEvent:` + strings.Replace(fmt.Sprintf("%v", this.CompletionEvent), "HistoryEvent", "v19.HistoryEvent", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RecordChildExecutionCompletedResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RecordChildExecutionCompletedResponse{`,
		`}`,
	}, "")
	return s
}
func (this *DescribeWorkflowExecutionRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeWorkflowExecutionRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`Request:` + strings.Replace(fmt.Sprintf("%v", this.Request), "DescribeWorkflowExecutionRequest", "v1.DescribeWorkflowExecutionRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DescribeWorkflowExecutionResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForPendingActivities := "[]*PendingActivityInfo{"
	for _, f := range this.PendingActivities {
		repeatedStringForPendingActivities += strings.Replace(fmt.Sprintf("%v", f), "PendingActivityInfo", "v110.PendingActivityInfo", 1) + ","
	}
	repeatedStringForPendingActivities += "}"
	repeatedStringForPendingChildren := "[]*PendingChildExecutionInfo{"
	for _, f := range this.PendingChildren {
		repeatedStringForPendingChildren += strings.Replace(fmt.Sprintf("%v", f), "PendingChildExecutionInfo", "v110.PendingChildExecutionInfo", 1) + ","
	}
	repeatedStringForPendingChildren += "}"
	s := strings.Join([]string{`&DescribeWorkflowExecutionResponse{`,
		`ExecutionConfig:` + strings.Replace(fmt.Sprintf("%v", this.ExecutionConfig), "WorkflowExecutionConfig", "v110.WorkflowExecutionConfig", 1) + `,`,
		`WorkflowExecutionInfo:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecutionInfo), "WorkflowExecutionInfo", "v110.WorkflowExecutionInfo", 1) + `,`,
		`PendingActivities:` + repeatedStringForPendingActivities + `,`,
		`PendingChildren:` + repeatedStringForPendingChildren + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReplicateEventsV2Request) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForVersionHistoryItems := "[]*VersionHistoryItem{"
	for _, f := range this.VersionHistoryItems {
		repeatedStringForVersionHistoryItems += strings.Replace(fmt.Sprintf("%v", f), "VersionHistoryItem", "v17.VersionHistoryItem", 1) + ","
	}
	repeatedStringForVersionHistoryItems += "}"
	s := strings.Join([]string{`&ReplicateEventsV2Request{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecution), "WorkflowExecution", "v14.WorkflowExecution", 1) + `,`,
		`VersionHistoryItems:` + repeatedStringForVersionHistoryItems + `,`,
		`Events:` + strings.Replace(fmt.Sprintf("%v", this.Events), "DataBlob", "v14.DataBlob", 1) + `,`,
		`NewRunEvents:` + strings.Replace(fmt.Sprintf("%v", this.NewRunEvents), "DataBlob", "v14.DataBlob", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReplicateEventsV2Response) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicateEventsV2Response{`,
		`}`,
	}, "")
	return s
}
func (this *SyncShardStatusRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SyncShardStatusRequest{`,
		`SourceCluster:` + fmt.Sprintf("%v", this.SourceCluster) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`StatusTime:` + strings.Replace(fmt.Sprintf("%v", this.StatusTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SyncShardStatusResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SyncShardStatusResponse{`,
		`}`,
	}, "")
	return s
}
func (this *SyncActivityRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SyncActivityRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`ScheduledId:` + fmt.Sprintf("%v", this.ScheduledId) + `,`,
		`ScheduledTime:` + strings.Replace(fmt.Sprintf("%v", this.ScheduledTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`StartedId:` + fmt.Sprintf("%v", this.StartedId) + `,`,
		`StartedTime:` + strings.Replace(fmt.Sprintf("%v", this.StartedTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`LastHeartbeatTime:` + strings.Replace(fmt.Sprintf("%v", this.LastHeartbeatTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`Details:` + strings.Replace(fmt.Sprintf("%v", this.Details), "Payloads", "v14.Payloads", 1) + `,`,
		`Attempt:` + fmt.Sprintf("%v", this.Attempt) + `,`,
		`LastFailure:` + strings.Replace(fmt.Sprintf("%v", this.LastFailure), "Failure", "v13.Failure", 1) + `,`,
		`LastWorkerIdentity:` + fmt.Sprintf("%v", this.LastWorkerIdentity) + `,`,
		`VersionHistory:` + strings.Replace(fmt.Sprintf("%v", this.VersionHistory), "VersionHistory", "v17.VersionHistory", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SyncActivityResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SyncActivityResponse{`,
		`}`,
	}, "")
	return s
}
func (this *DescribeMutableStateRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeMutableStateRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v14.WorkflowExecution", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DescribeMutableStateResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeMutableStateResponse{`,
		`CacheMutableState:` + strings.Replace(fmt.Sprintf("%v", this.CacheMutableState), "WorkflowMutableState", "v111.WorkflowMutableState", 1) + `,`,
		`DatabaseMutableState:` + strings.Replace(fmt.Sprintf("%v", this.DatabaseMutableState), "WorkflowMutableState", "v111.WorkflowMutableState", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DescribeHistoryHostRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeHistoryHostRequest{`,
		`HostAddress:` + fmt.Sprintf("%v", this.HostAddress) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecution), "WorkflowExecution", "v14.WorkflowExecution", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DescribeHistoryHostResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeHistoryHostResponse{`,
		`ShardsNumber:` + fmt.Sprintf("%v", this.ShardsNumber) + `,`,
		`ShardIds:` + fmt.Sprintf("%v", this.ShardIds) + `,`,
		`NamespaceCache:` + strings.Replace(fmt.Sprintf("%v", this.NamespaceCache), "NamespaceCacheInfo", "v112.NamespaceCacheInfo", 1) + `,`,
		`ShardControllerStatus:` + fmt.Sprintf("%v", this.ShardControllerStatus) + `,`,
		`Address:` + fmt.Sprintf("%v", this.Address) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CloseShardRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CloseShardRequest{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CloseShardResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CloseShardResponse{`,
		`}`,
	}, "")
	return s
}
func (this *RemoveTaskRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveTaskRequest{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`Category:` + fmt.Sprintf("%v", this.Category) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`VisibilityTime:` + strings.Replace(fmt.Sprintf("%v", this.VisibilityTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveTaskResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveTaskResponse{`,
		`}`,
	}, "")
	return s
}
func (this *GetReplicationMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForTokens := "[]*ReplicationToken{"
	for _, f := range this.Tokens {
		repeatedStringForTokens += strings.Replace(fmt.Sprintf("%v", f), "ReplicationToken", "v113.ReplicationToken", 1) + ","
	}
	repeatedStringForTokens += "}"
	s := strings.Join([]string{`&GetReplicationMessagesRequest{`,
		`Tokens:` + repeatedStringForTokens + `,`,
		`ClusterName:` + fmt.Sprintf("%v", this.ClusterName) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetReplicationMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	keysForShardMessages := make([]int32, 0, len(this.ShardMessages))
	for k, _ := range this.ShardMessages {
		keysForShardMessages = append(keysForShardMessages, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForShardMessages)
	mapStringForShardMessages := "map[int32]*v113.ReplicationMessages{"
	for _, k := range keysForShardMessages {
		mapStringForShardMessages += fmt.Sprintf("%v: %v,", k, this.ShardMessages[k])
	}
	mapStringForShardMessages += "}"
	s := strings.Join([]string{`&GetReplicationMessagesResponse{`,
		`ShardMessages:` + mapStringForShardMessages + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetDLQReplicationMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForTaskInfos := "[]*ReplicationTaskInfo{"
	for _, f := range this.TaskInfos {
		repeatedStringForTaskInfos += strings.Replace(fmt.Sprintf("%v", f), "ReplicationTaskInfo", "v113.ReplicationTaskInfo", 1) + ","
	}
	repeatedStringForTaskInfos += "}"
	s := strings.Join([]string{`&GetDLQReplicationMessagesRequest{`,
		`TaskInfos:` + repeatedStringForTaskInfos + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetDLQReplicationMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForReplicationTasks := "[]*ReplicationTask{"
	for _, f := range this.ReplicationTasks {
		repeatedStringForReplicationTasks += strings.Replace(fmt.Sprintf("%v", f), "ReplicationTask", "v113.ReplicationTask", 1) + ","
	}
	repeatedStringForReplicationTasks += "}"
	s := strings.Join([]string{`&GetDLQReplicationMessagesResponse{`,
		`ReplicationTasks:` + repeatedStringForReplicationTasks + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryWorkflowRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryWorkflowRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`Request:` + strings.Replace(fmt.Sprintf("%v", this.Request), "QueryWorkflowRequest", "v1.QueryWorkflowRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryWorkflowResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryWorkflowResponse{`,
		`Response:` + strings.Replace(fmt.Sprintf("%v", this.Response), "QueryWorkflowResponse", "v1.QueryWorkflowResponse", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReapplyEventsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReapplyEventsRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`Request:` + strings.Replace(fmt.Sprintf("%v", this.Request), "ReapplyEventsRequest", "v114.ReapplyEventsRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReapplyEventsResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReapplyEventsResponse{`,
		`}`,
	}, "")
	return s
}
func (this *GetDLQMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetDLQMessagesRequest{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`SourceCluster:` + fmt.Sprintf("%v", this.SourceCluster) + `,`,
		`InclusiveEndMessageId:` + fmt.Sprintf("%v", this.InclusiveEndMessageId) + `,`,
		`MaximumPageSize:` + fmt.Sprintf("%v", this.MaximumPageSize) + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetDLQMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForReplicationTasks := "[]*ReplicationTask{"
	for _, f := range this.ReplicationTasks {
		repeatedStringForReplicationTasks += strings.Replace(fmt.Sprintf("%v", f), "ReplicationTask", "v113.ReplicationTask", 1) + ","
	}
	repeatedStringForReplicationTasks += "}"
	s := strings.Join([]string{`&GetDLQMessagesResponse{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ReplicationTasks:` + repeatedStringForReplicationTasks + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PurgeDLQMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PurgeDLQMessagesRequest{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`SourceCluster:` + fmt.Sprintf("%v", this.SourceCluster) + `,`,
		`InclusiveEndMessageId:` + fmt.Sprintf("%v", this.InclusiveEndMessageId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PurgeDLQMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PurgeDLQMessagesResponse{`,
		`}`,
	}, "")
	return s
}
func (this *MergeDLQMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MergeDLQMessagesRequest{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`SourceCluster:` + fmt.Sprintf("%v", this.SourceCluster) + `,`,
		`InclusiveEndMessageId:` + fmt.Sprintf("%v", this.InclusiveEndMessageId) + `,`,
		`MaximumPageSize:` + fmt.Sprintf("%v", this.MaximumPageSize) + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MergeDLQMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MergeDLQMessagesResponse{`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RefreshWorkflowTasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RefreshWorkflowTasksRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`Request:` + strings.Replace(fmt.Sprintf("%v", this.Request), "RefreshWorkflowTasksRequest", "v114.RefreshWorkflowTasksRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RefreshWorkflowTasksResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RefreshWorkflowTasksResponse{`,
		`}`,
	}, "")
	return s
}
func valueToStringRequestResponse(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *StartWorkflowExecutionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StartWorkflowExecutionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StartWorkflowExecutionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartRequest == nil {
				m.StartRequest = &v1.StartWorkflowExecutionRequest{}
			}
			if err := m.StartRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentExecutionInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ParentExecutionInfo == nil {
				m.ParentExecutionInfo = &v11.ParentExecutionInfo{}
			}
			if err := m.ParentExecutionInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attempt", wireType)
			}
			m.Attempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Attempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecutionExpirationTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecutionExpirationTime == nil {
				m.WorkflowExecutionExpirationTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.WorkflowExecutionExpirationTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContinueAsNewInitiator", wireType)
			}
			m.ContinueAsNewInitiator = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ContinueAsNewInitiator |= v12.ContinueAsNewInitiator(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContinuedFailure", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContinuedFailure == nil {
				m.ContinuedFailure = &v13.Failure{}
			}
			if err := m.ContinuedFailure.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastCompletionResult", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastCompletionResult == nil {
				m.LastCompletionResult = &v14.Payloads{}
			}
			if err := m.LastCompletionResult.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstWorkflowTaskBackoff", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FirstWorkflowTaskBackoff == nil {
				m.FirstWorkflowTaskBackoff = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.FirstWorkflowTaskBackoff, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StartWorkflowExecutionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StartWorkflowExecutionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StartWorkflowExecutionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetMutableStateRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetMutableStateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetMutableStateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v14.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpectedNextEventId", wireType)
			}
			m.ExpectedNextEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExpectedNextEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentBranchToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CurrentBranchToken = append(m.CurrentBranchToken[:0], dAtA[iNdEx:postIndex]...)
			if m.CurrentBranchToken == nil {
				m.CurrentBranchToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetMutableStateResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetMutableStateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetMutableStateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v14.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowType == nil {
				m.WorkflowType = &v14.WorkflowType{}
			}
			if err := m.WorkflowType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextEventId", wireType)
			}
			m.NextEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PreviousStartedEventId", wireType)
			}
			m.PreviousStartedEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PreviousStartedEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastFirstEventId", wireType)
			}
			m.LastFirstEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastFirstEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskQueue == nil {
				m.TaskQueue = &v15.TaskQueue{}
			}
			if err := m.TaskQueue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StickyTaskQueue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StickyTaskQueue == nil {
				m.StickyTaskQueue = &v15.TaskQueue{}
			}
			if err := m.StickyTaskQueue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StickyTaskQueueScheduleToStartTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StickyTaskQueueScheduleToStartTimeout == nil {
				m.StickyTaskQueueScheduleToStartTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.StickyTaskQueueScheduleToStartTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentBranchToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CurrentBranchToken = append(m.CurrentBranchToken[:0], dAtA[iNdEx:postIndex]...)
			if m.CurrentBranchToken == nil {
				m.CurrentBranchToken = []byte{}
			}
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowState", wireType)
			}
			m.WorkflowState = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowState |= v16.WorkflowExecutionState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowStatus", wireType)
			}
			m.WorkflowStatus = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowStatus |= v12.WorkflowExecutionStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionHistories", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VersionHistories == nil {
				m.VersionHistories = &v17.VersionHistories{}
			}
			if err := m.VersionHistories.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsStickyTaskQueueEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsStickyTaskQueueEnabled = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PollMutableStateRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PollMutableStateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PollMutableStateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v14.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpectedNextEventId", wireType)
			}
			m.ExpectedNextEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExpectedNextEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentBranchToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CurrentBranchToken = append(m.CurrentBranchToken[:0], dAtA[iNdEx:postIndex]...)
			if m.CurrentBranchToken == nil {
				m.CurrentBranchToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PollMutableStateResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PollMutableStateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PollMutableStateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v14.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowType == nil {
				m.WorkflowType = &v14.WorkflowType{}
			}
			if err := m.WorkflowType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextEventId", wireType)
			}
			m.NextEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PreviousStartedEventId", wireType)
			}
			m.PreviousStartedEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PreviousStartedEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastFirstEventId", wireType)
			}
			m.LastFirstEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastFirstEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskQueue == nil {
				m.TaskQueue = &v15.TaskQueue{}
			}
			if err := m.TaskQueue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StickyTaskQueue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StickyTaskQueue == nil {
				m.StickyTaskQueue = &v15.TaskQueue{}
			}
			if err := m.StickyTaskQueue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StickyTaskQueueScheduleToStartTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StickyTaskQueueScheduleToStartTimeout == nil {
				m.StickyTaskQueueScheduleToStartTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.StickyTaskQueueScheduleToStartTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentBranchToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CurrentBranchToken = append(m.CurrentBranchToken[:0], dAtA[iNdEx:postIndex]...)
			if m.CurrentBranchToken == nil {
				m.CurrentBranchToken = []byte{}
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionHistories", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VersionHistories == nil {
				m.VersionHistories = &v17.VersionHistories{}
			}
			if err := m.VersionHistories.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowState", wireType)
			}
			m.WorkflowState = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowState |= v16.WorkflowExecutionState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowStatus", wireType)
			}
			m.WorkflowStatus = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowStatus |= v12.WorkflowExecutionStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResetStickyTaskQueueRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResetStickyTaskQueueRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResetStickyTaskQueueRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v14.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResetStickyTaskQueueResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResetStickyTaskQueueResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResetStickyTaskQueueResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RecordWorkflowTaskStartedRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RecordWorkflowTaskStartedRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RecordWorkflowTaskStartedRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecution == nil {
				m.WorkflowExecution = &v14.WorkflowExecution{}
			}
			if err := m.WorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleId", wireType)
			}
			m.ScheduleId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduleId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PollRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PollRequest == nil {
				m.PollRequest = &v1.PollWorkflowTaskQueueRequest{}
			}
			if err := m.PollRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RecordWorkflowTaskStartedResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RecordWorkflowTaskStartedResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RecordWorkflowTaskStartedResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowType == nil {
				m.WorkflowType = &v14.WorkflowType{}
			}
			if err := m.WorkflowType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PreviousStartedEventId", wireType)
			}
			m.PreviousStartedEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PreviousStartedEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledEventId", wireType)
			}
			m.ScheduledEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduledEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedEventId", wireType)
			}
			m.StartedEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartedEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextEventId", wireType)
			}
			m.NextEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attempt", wireType)
			}
			m.Attempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Attempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StickyExecutionEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StickyExecutionEnabled = bool(v != 0)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowTaskInfo == nil {
				m.WorkflowTaskInfo = &v17.TransientWorkflowTaskInfo{}
			}
			if err := m.WorkflowTaskInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecutionTaskQueue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecutionTaskQueue == nil {
				m.WorkflowExecutionTaskQueue = &v15.TaskQueue{}
			}
			if err := m.WorkflowExecutionTaskQueue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BranchToken = append(m.BranchToken[:0], dAtA[iNdEx:postIndex]...)
			if m.BranchToken == nil {
				m.BranchToken = []byte{}
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduledTime == nil {
				m.ScheduledTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ScheduledTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartedTime == nil {
				m.StartedTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StartedTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Queries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Queries == nil {
				m.Queries = make(map[string]*v18.WorkflowQuery)
			}
			var mapkey string
			var mapvalue *v18.WorkflowQuery
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v18.WorkflowQuery{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRequestResponse(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Queries[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RecordActivityTaskStartedRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RecordActivityTaskStartedRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RecordActivityTaskStartedRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecution == nil {
				m.WorkflowExecution = &v14.WorkflowExecution{}
			}
			if err := m.WorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleId", wireType)
			}
			m.ScheduleId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduleId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PollRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PollRequest == nil {
				m.PollRequest = &v1.PollActivityTaskQueueRequest{}
			}
			if err := m.PollRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RecordActivityTaskStartedResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RecordActivityTaskStartedResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RecordActivityTaskStartedResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledEvent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduledEvent == nil {
				m.ScheduledEvent = &v19.HistoryEvent{}
			}
			if err := m.ScheduledEvent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartedTime == nil {
				m.StartedTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StartedTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attempt", wireType)
			}
			m.Attempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Attempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentAttemptScheduledTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CurrentAttemptScheduledTime == nil {
				m.CurrentAttemptScheduledTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.CurrentAttemptScheduledTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatDetails", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HeartbeatDetails == nil {
				m.HeartbeatDetails = &v14.Payloads{}
			}
			if err := m.HeartbeatDetails.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowType == nil {
				m.WorkflowType = &v14.WorkflowType{}
			}
			if err := m.WorkflowType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RespondWorkflowTaskCompletedRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RespondWorkflowTaskCompletedRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RespondWorkflowTaskCompletedRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompleteRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CompleteRequest == nil {
				m.CompleteRequest = &v1.RespondWorkflowTaskCompletedRequest{}
			}
			if err := m.CompleteRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RespondWorkflowTaskCompletedResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RespondWorkflowTaskCompletedResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RespondWorkflowTaskCompletedResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartedResponse == nil {
				m.StartedResponse = &RecordWorkflowTaskStartedResponse{}
			}
			if err := m.StartedResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RespondWorkflowTaskFailedRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RespondWorkflowTaskFailedRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RespondWorkflowTaskFailedRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailedRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FailedRequest == nil {
				m.FailedRequest = &v1.RespondWorkflowTaskFailedRequest{}
			}
			if err := m.FailedRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RespondWorkflowTaskFailedResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RespondWorkflowTaskFailedResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RespondWorkflowTaskFailedResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RecordActivityTaskHeartbeatRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RecordActivityTaskHeartbeatRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RecordActivityTaskHeartbeatRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HeartbeatRequest == nil {
				m.HeartbeatRequest = &v1.RecordActivityTaskHeartbeatRequest{}
			}
			if err := m.HeartbeatRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RecordActivityTaskHeartbeatResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RecordActivityTaskHeartbeatResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RecordActivityTaskHeartbeatResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CancelRequested", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CancelRequested = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RespondActivityTaskCompletedRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RespondActivityTaskCompletedRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RespondActivityTaskCompletedRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompleteRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CompleteRequest == nil {
				m.CompleteRequest = &v1.RespondActivityTaskCompletedRequest{}
			}
			if err := m.CompleteRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RespondActivityTaskCompletedResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RespondActivityTaskCompletedResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RespondActivityTaskCompletedResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RespondActivityTaskFailedRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RespondActivityTaskFailedRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RespondActivityTaskFailedRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailedRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FailedRequest == nil {
				m.FailedRequest = &v1.RespondActivityTaskFailedRequest{}
			}
			if err := m.FailedRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RespondActivityTaskFailedResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RespondActivityTaskFailedResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RespondActivityTaskFailedResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RespondActivityTaskCanceledRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RespondActivityTaskCanceledRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RespondActivityTaskCanceledRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CancelRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CancelRequest == nil {
				m.CancelRequest = &v1.RespondActivityTaskCanceledRequest{}
			}
			if err := m.CancelRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RespondActivityTaskCanceledResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RespondActivityTaskCanceledResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RespondActivityTaskCanceledResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SignalWorkflowExecutionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SignalWorkflowExecutionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SignalWorkflowExecutionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SignalRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SignalRequest == nil {
				m.SignalRequest = &v1.SignalWorkflowExecutionRequest{}
			}
			if err := m.SignalRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExternalWorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExternalWorkflowExecution == nil {
				m.ExternalWorkflowExecution = &v14.WorkflowExecution{}
			}
			if err := m.ExternalWorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChildWorkflowOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ChildWorkflowOnly = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SignalWorkflowExecutionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SignalWorkflowExecutionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SignalWorkflowExecutionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SignalWithStartWorkflowExecutionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SignalWithStartWorkflowExecutionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SignalWithStartWorkflowExecutionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SignalWithStartRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SignalWithStartRequest == nil {
				m.SignalWithStartRequest = &v1.SignalWithStartWorkflowExecutionRequest{}
			}
			if err := m.SignalWithStartRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SignalWithStartWorkflowExecutionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SignalWithStartWorkflowExecutionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SignalWithStartWorkflowExecutionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveSignalMutableStateRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveSignalMutableStateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveSignalMutableStateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecution == nil {
				m.WorkflowExecution = &v14.WorkflowExecution{}
			}
			if err := m.WorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveSignalMutableStateResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveSignalMutableStateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveSignalMutableStateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TerminateWorkflowExecutionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TerminateWorkflowExecutionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TerminateWorkflowExecutionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TerminateRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TerminateRequest == nil {
				m.TerminateRequest = &v1.TerminateWorkflowExecutionRequest{}
			}
			if err := m.TerminateRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TerminateWorkflowExecutionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TerminateWorkflowExecutionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TerminateWorkflowExecutionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResetWorkflowExecutionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResetWorkflowExecutionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResetWorkflowExecutionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResetRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResetRequest == nil {
				m.ResetRequest = &v1.ResetWorkflowExecutionRequest{}
			}
			if err := m.ResetRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResetWorkflowExecutionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResetWorkflowExecutionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResetWorkflowExecutionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestCancelWorkflowExecutionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestCancelWorkflowExecutionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestCancelWorkflowExecutionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CancelRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CancelRequest == nil {
				m.CancelRequest = &v1.RequestCancelWorkflowExecutionRequest{}
			}
			if err := m.CancelRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExternalInitiatedEventId", wireType)
			}
			m.ExternalInitiatedEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExternalInitiatedEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExternalWorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExternalWorkflowExecution == nil {
				m.ExternalWorkflowExecution = &v14.WorkflowExecution{}
			}
			if err := m.ExternalWorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChildWorkflowOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ChildWorkflowOnly = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestCancelWorkflowExecutionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestCancelWorkflowExecutionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestCancelWorkflowExecutionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScheduleWorkflowTaskRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScheduleWorkflowTaskRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScheduleWorkflowTaskRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecution == nil {
				m.WorkflowExecution = &v14.WorkflowExecution{}
			}
			if err := m.WorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsFirstWorkflowTask", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsFirstWorkflowTask = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScheduleWorkflowTaskResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScheduleWorkflowTaskResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScheduleWorkflowTaskResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RecordChildExecutionCompletedRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RecordChildExecutionCompletedRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RecordChildExecutionCompletedRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecution == nil {
				m.WorkflowExecution = &v14.WorkflowExecution{}
			}
			if err := m.WorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatedId", wireType)
			}
			m.InitiatedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitiatedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletedExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CompletedExecution == nil {
				m.CompletedExecution = &v14.WorkflowExecution{}
			}
			if err := m.CompletedExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletionEvent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CompletionEvent == nil {
				m.CompletionEvent = &v19.HistoryEvent{}
			}
			if err := m.CompletionEvent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RecordChildExecutionCompletedResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RecordChildExecutionCompletedResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RecordChildExecutionCompletedResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeWorkflowExecutionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeWorkflowExecutionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeWorkflowExecutionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Request == nil {
				m.Request = &v1.DescribeWorkflowExecutionRequest{}
			}
			if err := m.Request.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeWorkflowExecutionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeWorkflowExecutionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeWorkflowExecutionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutionConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutionConfig == nil {
				m.ExecutionConfig = &v110.WorkflowExecutionConfig{}
			}
			if err := m.ExecutionConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecutionInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecutionInfo == nil {
				m.WorkflowExecutionInfo = &v110.WorkflowExecutionInfo{}
			}
			if err := m.WorkflowExecutionInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PendingActivities", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PendingActivities = append(m.PendingActivities, &v110.PendingActivityInfo{})
			if err := m.PendingActivities[len(m.PendingActivities)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PendingChildren", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PendingChildren = append(m.PendingChildren, &v110.PendingChildExecutionInfo{})
			if err := m.PendingChildren[len(m.PendingChildren)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicateEventsV2Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicateEventsV2Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicateEventsV2Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecution == nil {
				m.WorkflowExecution = &v14.WorkflowExecution{}
			}
			if err := m.WorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionHistoryItems", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VersionHistoryItems = append(m.VersionHistoryItems, &v17.VersionHistoryItem{})
			if err := m.VersionHistoryItems[len(m.VersionHistoryItems)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Events == nil {
				m.Events = &v14.DataBlob{}
			}
			if err := m.Events.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewRunEvents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NewRunEvents == nil {
				m.NewRunEvents = &v14.DataBlob{}
			}
			if err := m.NewRunEvents.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicateEventsV2Response) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicateEventsV2Response: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicateEventsV2Response: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SyncShardStatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SyncShardStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SyncShardStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatusTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StatusTime == nil {
				m.StatusTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StatusTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SyncShardStatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SyncShardStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SyncShardStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SyncActivityRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SyncActivityRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SyncActivityRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledId", wireType)
			}
			m.ScheduledId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduledId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduledTime == nil {
				m.ScheduledTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ScheduledTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedId", wireType)
			}
			m.StartedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartedTime == nil {
				m.StartedTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StartedTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbeatTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastHeartbeatTime == nil {
				m.LastHeartbeatTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.LastHeartbeatTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Details", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Details == nil {
				m.Details = &v14.Payloads{}
			}
			if err := m.Details.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attempt", wireType)
			}
			m.Attempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Attempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastFailure", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastFailure == nil {
				m.LastFailure = &v13.Failure{}
			}
			if err := m.LastFailure.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastWorkerIdentity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastWorkerIdentity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionHistory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VersionHistory == nil {
				m.VersionHistory = &v17.VersionHistory{}
			}
			if err := m.VersionHistory.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SyncActivityResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SyncActivityResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SyncActivityResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeMutableStateRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeMutableStateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeMutableStateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v14.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeMutableStateResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeMutableStateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeMutableStateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheMutableState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CacheMutableState == nil {
				m.CacheMutableState = &v111.WorkflowMutableState{}
			}
			if err := m.CacheMutableState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DatabaseMutableState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DatabaseMutableState == nil {
				m.DatabaseMutableState = &v111.WorkflowMutableState{}
			}
			if err := m.DatabaseMutableState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeHistoryHostRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeHistoryHostRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeHistoryHostRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecution == nil {
				m.WorkflowExecution = &v14.WorkflowExecution{}
			}
			if err := m.WorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeHistoryHostResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeHistoryHostResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeHistoryHostResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardsNumber", wireType)
			}
			m.ShardsNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardsNumber |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ShardIds = append(m.ShardIds, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthRequestResponse
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthRequestResponse
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.ShardIds) == 0 {
					m.ShardIds = make([]int32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ShardIds = append(m.ShardIds, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardIds", wireType)
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceCache", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NamespaceCache == nil {
				m.NamespaceCache = &v112.NamespaceCacheInfo{}
			}
			if err := m.NamespaceCache.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardControllerStatus", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ShardControllerStatus = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CloseShardRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CloseShardRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CloseShardRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CloseShardResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CloseShardResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CloseShardResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveTaskRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveTaskRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveTaskRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Category", wireType)
			}
			m.Category = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Category |= v16.TaskCategory(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VisibilityTime == nil {
				m.VisibilityTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.VisibilityTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveTaskResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveTaskResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveTaskResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetReplicationMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetReplicationMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetReplicationMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tokens", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tokens = append(m.Tokens, &v113.ReplicationToken{})
			if err := m.Tokens[len(m.Tokens)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetReplicationMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetReplicationMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetReplicationMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardMessages", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ShardMessages == nil {
				m.ShardMessages = make(map[int32]*v113.ReplicationMessages)
			}
			var mapkey int32
			var mapvalue *v113.ReplicationMessages
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v113.ReplicationMessages{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRequestResponse(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ShardMessages[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDLQReplicationMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDLQReplicationMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDLQReplicationMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskInfos = append(m.TaskInfos, &v113.ReplicationTaskInfo{})
			if err := m.TaskInfos[len(m.TaskInfos)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDLQReplicationMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDLQReplicationMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDLQReplicationMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplicationTasks = append(m.ReplicationTasks, &v113.ReplicationTask{})
			if err := m.ReplicationTasks[len(m.ReplicationTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryWorkflowRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryWorkflowRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryWorkflowRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Request == nil {
				m.Request = &v1.QueryWorkflowRequest{}
			}
			if err := m.Request.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryWorkflowResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryWorkflowResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryWorkflowResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Response", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Response == nil {
				m.Response = &v1.QueryWorkflowResponse{}
			}
			if err := m.Response.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReapplyEventsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReapplyEventsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReapplyEventsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Request == nil {
				m.Request = &v114.ReapplyEventsRequest{}
			}
			if err := m.Request.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReapplyEventsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReapplyEventsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReapplyEventsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDLQMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDLQMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDLQMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v16.DeadLetterQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InclusiveEndMessageId", wireType)
			}
			m.InclusiveEndMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InclusiveEndMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaximumPageSize", wireType)
			}
			m.MaximumPageSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaximumPageSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDLQMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDLQMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDLQMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v16.DeadLetterQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplicationTasks = append(m.ReplicationTasks, &v113.ReplicationTask{})
			if err := m.ReplicationTasks[len(m.ReplicationTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PurgeDLQMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PurgeDLQMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PurgeDLQMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v16.DeadLetterQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InclusiveEndMessageId", wireType)
			}
			m.InclusiveEndMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InclusiveEndMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PurgeDLQMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PurgeDLQMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PurgeDLQMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeDLQMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeDLQMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeDLQMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v16.DeadLetterQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InclusiveEndMessageId", wireType)
			}
			m.InclusiveEndMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InclusiveEndMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaximumPageSize", wireType)
			}
			m.MaximumPageSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaximumPageSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeDLQMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeDLQMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeDLQMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshWorkflowTasksRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshWorkflowTasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshWorkflowTasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Request == nil {
				m.Request = &v114.RefreshWorkflowTasksRequest{}
			}
			if err := m.Request.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshWorkflowTasksResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshWorkflowTasksResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshWorkflowTasksResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRequestResponse(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRequestResponse
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRequestResponse
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRequestResponse
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRequestResponse        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRequestResponse          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRequestResponse = fmt.Errorf("proto: unexpected end of group")
)
