// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by MockGen. DO NOT EDIT.
// Source: context.go

// Package workflow is a generated GoMock package.
package workflow

import (
	context "context"
	reflect "reflect"
	time "time"

	gomock "github.com/golang/mock/gomock"
	v1 "go.temporal.io/api/common/v1"
	v10 "go.temporal.io/server/api/persistence/v1"
	persistence "go.temporal.io/server/common/persistence"
)

// MockContext is a mock of Context interface.
type MockContext struct {
	ctrl     *gomock.Controller
	recorder *MockContextMockRecorder
}

// MockContextMockRecorder is the mock recorder for MockContext.
type MockContextMockRecorder struct {
	mock *MockContext
}

// NewMockContext creates a new mock instance.
func NewMockContext(ctrl *gomock.Controller) *MockContext {
	mock := &MockContext{ctrl: ctrl}
	mock.recorder = &MockContextMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockContext) EXPECT() *MockContextMockRecorder {
	return m.recorder
}

// Clear mocks base method.
func (m *MockContext) Clear() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Clear")
}

// Clear indicates an expected call of Clear.
func (mr *MockContextMockRecorder) Clear() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Clear", reflect.TypeOf((*MockContext)(nil).Clear))
}

// ConflictResolveWorkflowExecution mocks base method.
func (m *MockContext) ConflictResolveWorkflowExecution(now time.Time, conflictResolveMode persistence.ConflictResolveWorkflowMode, resetMutableState MutableState, newContext Context, newMutableState MutableState, currentContext Context, currentMutableState MutableState, currentTransactionPolicy *TransactionPolicy) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ConflictResolveWorkflowExecution", now, conflictResolveMode, resetMutableState, newContext, newMutableState, currentContext, currentMutableState, currentTransactionPolicy)
	ret0, _ := ret[0].(error)
	return ret0
}

// ConflictResolveWorkflowExecution indicates an expected call of ConflictResolveWorkflowExecution.
func (mr *MockContextMockRecorder) ConflictResolveWorkflowExecution(now, conflictResolveMode, resetMutableState, newContext, newMutableState, currentContext, currentMutableState, currentTransactionPolicy interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ConflictResolveWorkflowExecution", reflect.TypeOf((*MockContext)(nil).ConflictResolveWorkflowExecution), now, conflictResolveMode, resetMutableState, newContext, newMutableState, currentContext, currentMutableState, currentTransactionPolicy)
}

// CreateWorkflowExecution mocks base method.
func (m *MockContext) CreateWorkflowExecution(now time.Time, createMode persistence.CreateWorkflowMode, prevRunID string, prevLastWriteVersion int64, newMutableState MutableState, newWorkflow *persistence.WorkflowSnapshot, historySize int64) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateWorkflowExecution", now, createMode, prevRunID, prevLastWriteVersion, newMutableState, newWorkflow, historySize)
	ret0, _ := ret[0].(error)
	return ret0
}

// CreateWorkflowExecution indicates an expected call of CreateWorkflowExecution.
func (mr *MockContextMockRecorder) CreateWorkflowExecution(now, createMode, prevRunID, prevLastWriteVersion, newMutableState, newWorkflow, historySize interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateWorkflowExecution", reflect.TypeOf((*MockContext)(nil).CreateWorkflowExecution), now, createMode, prevRunID, prevLastWriteVersion, newMutableState, newWorkflow, historySize)
}

// GetExecution mocks base method.
func (m *MockContext) GetExecution() *v1.WorkflowExecution {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetExecution")
	ret0, _ := ret[0].(*v1.WorkflowExecution)
	return ret0
}

// GetExecution indicates an expected call of GetExecution.
func (mr *MockContextMockRecorder) GetExecution() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetExecution", reflect.TypeOf((*MockContext)(nil).GetExecution))
}

// GetHistorySize mocks base method.
func (m *MockContext) GetHistorySize() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetHistorySize")
	ret0, _ := ret[0].(int64)
	return ret0
}

// GetHistorySize indicates an expected call of GetHistorySize.
func (mr *MockContextMockRecorder) GetHistorySize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetHistorySize", reflect.TypeOf((*MockContext)(nil).GetHistorySize))
}

// GetNamespace mocks base method.
func (m *MockContext) GetNamespace() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetNamespace")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetNamespace indicates an expected call of GetNamespace.
func (mr *MockContextMockRecorder) GetNamespace() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetNamespace", reflect.TypeOf((*MockContext)(nil).GetNamespace))
}

// GetNamespaceID mocks base method.
func (m *MockContext) GetNamespaceID() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetNamespaceID")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetNamespaceID indicates an expected call of GetNamespaceID.
func (mr *MockContextMockRecorder) GetNamespaceID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetNamespaceID", reflect.TypeOf((*MockContext)(nil).GetNamespaceID))
}

// LoadExecutionStats mocks base method.
func (m *MockContext) LoadExecutionStats() (*v10.ExecutionStats, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LoadExecutionStats")
	ret0, _ := ret[0].(*v10.ExecutionStats)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// LoadExecutionStats indicates an expected call of LoadExecutionStats.
func (mr *MockContextMockRecorder) LoadExecutionStats() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LoadExecutionStats", reflect.TypeOf((*MockContext)(nil).LoadExecutionStats))
}

// LoadWorkflowExecution mocks base method.
func (m *MockContext) LoadWorkflowExecution() (MutableState, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LoadWorkflowExecution")
	ret0, _ := ret[0].(MutableState)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// LoadWorkflowExecution indicates an expected call of LoadWorkflowExecution.
func (mr *MockContextMockRecorder) LoadWorkflowExecution() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LoadWorkflowExecution", reflect.TypeOf((*MockContext)(nil).LoadWorkflowExecution))
}

// LoadWorkflowExecutionForReplication mocks base method.
func (m *MockContext) LoadWorkflowExecutionForReplication(incomingVersion int64) (MutableState, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LoadWorkflowExecutionForReplication", incomingVersion)
	ret0, _ := ret[0].(MutableState)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// LoadWorkflowExecutionForReplication indicates an expected call of LoadWorkflowExecutionForReplication.
func (mr *MockContextMockRecorder) LoadWorkflowExecutionForReplication(incomingVersion interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LoadWorkflowExecutionForReplication", reflect.TypeOf((*MockContext)(nil).LoadWorkflowExecutionForReplication), incomingVersion)
}

// Lock mocks base method.
func (m *MockContext) Lock(ctx context.Context, caller CallerType) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Lock", ctx, caller)
	ret0, _ := ret[0].(error)
	return ret0
}

// Lock indicates an expected call of Lock.
func (mr *MockContextMockRecorder) Lock(ctx, caller interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Lock", reflect.TypeOf((*MockContext)(nil).Lock), ctx, caller)
}

// PersistFirstWorkflowEvents mocks base method.
func (m *MockContext) PersistFirstWorkflowEvents(workflowEvents *persistence.WorkflowEvents) (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PersistFirstWorkflowEvents", workflowEvents)
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PersistFirstWorkflowEvents indicates an expected call of PersistFirstWorkflowEvents.
func (mr *MockContextMockRecorder) PersistFirstWorkflowEvents(workflowEvents interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PersistFirstWorkflowEvents", reflect.TypeOf((*MockContext)(nil).PersistFirstWorkflowEvents), workflowEvents)
}

// PersistNonFirstWorkflowEvents mocks base method.
func (m *MockContext) PersistNonFirstWorkflowEvents(workflowEvents *persistence.WorkflowEvents) (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PersistNonFirstWorkflowEvents", workflowEvents)
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PersistNonFirstWorkflowEvents indicates an expected call of PersistNonFirstWorkflowEvents.
func (mr *MockContextMockRecorder) PersistNonFirstWorkflowEvents(workflowEvents interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PersistNonFirstWorkflowEvents", reflect.TypeOf((*MockContext)(nil).PersistNonFirstWorkflowEvents), workflowEvents)
}

// ReapplyEvents mocks base method.
func (m *MockContext) ReapplyEvents(eventBatches []*persistence.WorkflowEvents) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReapplyEvents", eventBatches)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReapplyEvents indicates an expected call of ReapplyEvents.
func (mr *MockContextMockRecorder) ReapplyEvents(eventBatches interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReapplyEvents", reflect.TypeOf((*MockContext)(nil).ReapplyEvents), eventBatches)
}

// SetHistorySize mocks base method.
func (m *MockContext) SetHistorySize(size int64) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetHistorySize", size)
}

// SetHistorySize indicates an expected call of SetHistorySize.
func (mr *MockContextMockRecorder) SetHistorySize(size interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHistorySize", reflect.TypeOf((*MockContext)(nil).SetHistorySize), size)
}

// Unlock mocks base method.
func (m *MockContext) Unlock(caller CallerType) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Unlock", caller)
}

// Unlock indicates an expected call of Unlock.
func (mr *MockContextMockRecorder) Unlock(caller interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Unlock", reflect.TypeOf((*MockContext)(nil).Unlock), caller)
}

// UpdateWorkflowExecutionAsActive mocks base method.
func (m *MockContext) UpdateWorkflowExecutionAsActive(now time.Time) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateWorkflowExecutionAsActive", now)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateWorkflowExecutionAsActive indicates an expected call of UpdateWorkflowExecutionAsActive.
func (mr *MockContextMockRecorder) UpdateWorkflowExecutionAsActive(now interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateWorkflowExecutionAsActive", reflect.TypeOf((*MockContext)(nil).UpdateWorkflowExecutionAsActive), now)
}

// UpdateWorkflowExecutionAsPassive mocks base method.
func (m *MockContext) UpdateWorkflowExecutionAsPassive(now time.Time) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateWorkflowExecutionAsPassive", now)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateWorkflowExecutionAsPassive indicates an expected call of UpdateWorkflowExecutionAsPassive.
func (mr *MockContextMockRecorder) UpdateWorkflowExecutionAsPassive(now interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateWorkflowExecutionAsPassive", reflect.TypeOf((*MockContext)(nil).UpdateWorkflowExecutionAsPassive), now)
}

// UpdateWorkflowExecutionWithNew mocks base method.
func (m *MockContext) UpdateWorkflowExecutionWithNew(now time.Time, updateMode persistence.UpdateWorkflowMode, newContext Context, newMutableState MutableState, currentWorkflowTransactionPolicy TransactionPolicy, newWorkflowTransactionPolicy *TransactionPolicy) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateWorkflowExecutionWithNew", now, updateMode, newContext, newMutableState, currentWorkflowTransactionPolicy, newWorkflowTransactionPolicy)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateWorkflowExecutionWithNew indicates an expected call of UpdateWorkflowExecutionWithNew.
func (mr *MockContextMockRecorder) UpdateWorkflowExecutionWithNew(now, updateMode, newContext, newMutableState, currentWorkflowTransactionPolicy, newWorkflowTransactionPolicy interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateWorkflowExecutionWithNew", reflect.TypeOf((*MockContext)(nil).UpdateWorkflowExecutionWithNew), now, updateMode, newContext, newMutableState, currentWorkflowTransactionPolicy, newWorkflowTransactionPolicy)
}

// UpdateWorkflowExecutionWithNewAsActive mocks base method.
func (m *MockContext) UpdateWorkflowExecutionWithNewAsActive(now time.Time, newContext Context, newMutableState MutableState) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateWorkflowExecutionWithNewAsActive", now, newContext, newMutableState)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateWorkflowExecutionWithNewAsActive indicates an expected call of UpdateWorkflowExecutionWithNewAsActive.
func (mr *MockContextMockRecorder) UpdateWorkflowExecutionWithNewAsActive(now, newContext, newMutableState interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateWorkflowExecutionWithNewAsActive", reflect.TypeOf((*MockContext)(nil).UpdateWorkflowExecutionWithNewAsActive), now, newContext, newMutableState)
}

// UpdateWorkflowExecutionWithNewAsPassive mocks base method.
func (m *MockContext) UpdateWorkflowExecutionWithNewAsPassive(now time.Time, newContext Context, newMutableState MutableState) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateWorkflowExecutionWithNewAsPassive", now, newContext, newMutableState)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateWorkflowExecutionWithNewAsPassive indicates an expected call of UpdateWorkflowExecutionWithNewAsPassive.
func (mr *MockContextMockRecorder) UpdateWorkflowExecutionWithNewAsPassive(now, newContext, newMutableState interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateWorkflowExecutionWithNewAsPassive", reflect.TypeOf((*MockContext)(nil).UpdateWorkflowExecutionWithNewAsPassive), now, newContext, newMutableState)
}
