// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by MockGen. DO NOT EDIT.
// Source: mutable_state.go

// Package workflow is a generated GoMock package.
package workflow

import (
	reflect "reflect"
	time "time"

	gomock "github.com/golang/mock/gomock"
	v1 "go.temporal.io/api/command/v1"
	v10 "go.temporal.io/api/common/v1"
	v11 "go.temporal.io/api/enums/v1"
	v12 "go.temporal.io/api/failure/v1"
	v13 "go.temporal.io/api/history/v1"
	v14 "go.temporal.io/api/taskqueue/v1"
	v15 "go.temporal.io/api/workflowservice/v1"
	v16 "go.temporal.io/server/api/enums/v1"
	v17 "go.temporal.io/server/api/historyservice/v1"
	v18 "go.temporal.io/server/api/persistence/v1"
	cache "go.temporal.io/server/common/cache"
	definition "go.temporal.io/server/common/definition"
	persistence "go.temporal.io/server/common/persistence"
)

// MockMutableState is a mock of MutableState interface.
type MockMutableState struct {
	ctrl     *gomock.Controller
	recorder *MockMutableStateMockRecorder
}

// MockMutableStateMockRecorder is the mock recorder for MockMutableState.
type MockMutableStateMockRecorder struct {
	mock *MockMutableState
}

// NewMockMutableState creates a new mock instance.
func NewMockMutableState(ctrl *gomock.Controller) *MockMutableState {
	mock := &MockMutableState{ctrl: ctrl}
	mock.recorder = &MockMutableStateMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockMutableState) EXPECT() *MockMutableStateMockRecorder {
	return m.recorder
}

// AddActivityTaskCancelRequestedEvent mocks base method.
func (m *MockMutableState) AddActivityTaskCancelRequestedEvent(arg0, arg1 int64, arg2 string) (*v13.HistoryEvent, *v18.ActivityInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddActivityTaskCancelRequestedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(*v18.ActivityInfo)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddActivityTaskCancelRequestedEvent indicates an expected call of AddActivityTaskCancelRequestedEvent.
func (mr *MockMutableStateMockRecorder) AddActivityTaskCancelRequestedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddActivityTaskCancelRequestedEvent", reflect.TypeOf((*MockMutableState)(nil).AddActivityTaskCancelRequestedEvent), arg0, arg1, arg2)
}

// AddActivityTaskCanceledEvent mocks base method.
func (m *MockMutableState) AddActivityTaskCanceledEvent(arg0, arg1, arg2 int64, arg3 *v10.Payloads, arg4 string) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddActivityTaskCanceledEvent", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddActivityTaskCanceledEvent indicates an expected call of AddActivityTaskCanceledEvent.
func (mr *MockMutableStateMockRecorder) AddActivityTaskCanceledEvent(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddActivityTaskCanceledEvent", reflect.TypeOf((*MockMutableState)(nil).AddActivityTaskCanceledEvent), arg0, arg1, arg2, arg3, arg4)
}

// AddActivityTaskCompletedEvent mocks base method.
func (m *MockMutableState) AddActivityTaskCompletedEvent(arg0, arg1 int64, arg2 *v15.RespondActivityTaskCompletedRequest) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddActivityTaskCompletedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddActivityTaskCompletedEvent indicates an expected call of AddActivityTaskCompletedEvent.
func (mr *MockMutableStateMockRecorder) AddActivityTaskCompletedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddActivityTaskCompletedEvent", reflect.TypeOf((*MockMutableState)(nil).AddActivityTaskCompletedEvent), arg0, arg1, arg2)
}

// AddActivityTaskFailedEvent mocks base method.
func (m *MockMutableState) AddActivityTaskFailedEvent(arg0, arg1 int64, arg2 *v12.Failure, arg3 v11.RetryState, arg4 string) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddActivityTaskFailedEvent", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddActivityTaskFailedEvent indicates an expected call of AddActivityTaskFailedEvent.
func (mr *MockMutableStateMockRecorder) AddActivityTaskFailedEvent(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddActivityTaskFailedEvent", reflect.TypeOf((*MockMutableState)(nil).AddActivityTaskFailedEvent), arg0, arg1, arg2, arg3, arg4)
}

// AddActivityTaskScheduledEvent mocks base method.
func (m *MockMutableState) AddActivityTaskScheduledEvent(arg0 int64, arg1 *v1.ScheduleActivityTaskCommandAttributes) (*v13.HistoryEvent, *v18.ActivityInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddActivityTaskScheduledEvent", arg0, arg1)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(*v18.ActivityInfo)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddActivityTaskScheduledEvent indicates an expected call of AddActivityTaskScheduledEvent.
func (mr *MockMutableStateMockRecorder) AddActivityTaskScheduledEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddActivityTaskScheduledEvent", reflect.TypeOf((*MockMutableState)(nil).AddActivityTaskScheduledEvent), arg0, arg1)
}

// AddActivityTaskStartedEvent mocks base method.
func (m *MockMutableState) AddActivityTaskStartedEvent(arg0 *v18.ActivityInfo, arg1 int64, arg2, arg3 string) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddActivityTaskStartedEvent", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddActivityTaskStartedEvent indicates an expected call of AddActivityTaskStartedEvent.
func (mr *MockMutableStateMockRecorder) AddActivityTaskStartedEvent(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddActivityTaskStartedEvent", reflect.TypeOf((*MockMutableState)(nil).AddActivityTaskStartedEvent), arg0, arg1, arg2, arg3)
}

// AddActivityTaskTimedOutEvent mocks base method.
func (m *MockMutableState) AddActivityTaskTimedOutEvent(arg0, arg1 int64, arg2 *v12.Failure, arg3 v11.RetryState) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddActivityTaskTimedOutEvent", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddActivityTaskTimedOutEvent indicates an expected call of AddActivityTaskTimedOutEvent.
func (mr *MockMutableStateMockRecorder) AddActivityTaskTimedOutEvent(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddActivityTaskTimedOutEvent", reflect.TypeOf((*MockMutableState)(nil).AddActivityTaskTimedOutEvent), arg0, arg1, arg2, arg3)
}

// AddChildWorkflowExecutionCanceledEvent mocks base method.
func (m *MockMutableState) AddChildWorkflowExecutionCanceledEvent(arg0 int64, arg1 *v10.WorkflowExecution, arg2 *v13.WorkflowExecutionCanceledEventAttributes) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddChildWorkflowExecutionCanceledEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddChildWorkflowExecutionCanceledEvent indicates an expected call of AddChildWorkflowExecutionCanceledEvent.
func (mr *MockMutableStateMockRecorder) AddChildWorkflowExecutionCanceledEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddChildWorkflowExecutionCanceledEvent", reflect.TypeOf((*MockMutableState)(nil).AddChildWorkflowExecutionCanceledEvent), arg0, arg1, arg2)
}

// AddChildWorkflowExecutionCompletedEvent mocks base method.
func (m *MockMutableState) AddChildWorkflowExecutionCompletedEvent(arg0 int64, arg1 *v10.WorkflowExecution, arg2 *v13.WorkflowExecutionCompletedEventAttributes) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddChildWorkflowExecutionCompletedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddChildWorkflowExecutionCompletedEvent indicates an expected call of AddChildWorkflowExecutionCompletedEvent.
func (mr *MockMutableStateMockRecorder) AddChildWorkflowExecutionCompletedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddChildWorkflowExecutionCompletedEvent", reflect.TypeOf((*MockMutableState)(nil).AddChildWorkflowExecutionCompletedEvent), arg0, arg1, arg2)
}

// AddChildWorkflowExecutionFailedEvent mocks base method.
func (m *MockMutableState) AddChildWorkflowExecutionFailedEvent(arg0 int64, arg1 *v10.WorkflowExecution, arg2 *v13.WorkflowExecutionFailedEventAttributes) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddChildWorkflowExecutionFailedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddChildWorkflowExecutionFailedEvent indicates an expected call of AddChildWorkflowExecutionFailedEvent.
func (mr *MockMutableStateMockRecorder) AddChildWorkflowExecutionFailedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddChildWorkflowExecutionFailedEvent", reflect.TypeOf((*MockMutableState)(nil).AddChildWorkflowExecutionFailedEvent), arg0, arg1, arg2)
}

// AddChildWorkflowExecutionStartedEvent mocks base method.
func (m *MockMutableState) AddChildWorkflowExecutionStartedEvent(arg0 string, arg1 *v10.WorkflowExecution, arg2 *v10.WorkflowType, arg3 int64, arg4 *v10.Header) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddChildWorkflowExecutionStartedEvent", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddChildWorkflowExecutionStartedEvent indicates an expected call of AddChildWorkflowExecutionStartedEvent.
func (mr *MockMutableStateMockRecorder) AddChildWorkflowExecutionStartedEvent(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddChildWorkflowExecutionStartedEvent", reflect.TypeOf((*MockMutableState)(nil).AddChildWorkflowExecutionStartedEvent), arg0, arg1, arg2, arg3, arg4)
}

// AddChildWorkflowExecutionTerminatedEvent mocks base method.
func (m *MockMutableState) AddChildWorkflowExecutionTerminatedEvent(arg0 int64, arg1 *v10.WorkflowExecution, arg2 *v13.WorkflowExecutionTerminatedEventAttributes) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddChildWorkflowExecutionTerminatedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddChildWorkflowExecutionTerminatedEvent indicates an expected call of AddChildWorkflowExecutionTerminatedEvent.
func (mr *MockMutableStateMockRecorder) AddChildWorkflowExecutionTerminatedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddChildWorkflowExecutionTerminatedEvent", reflect.TypeOf((*MockMutableState)(nil).AddChildWorkflowExecutionTerminatedEvent), arg0, arg1, arg2)
}

// AddChildWorkflowExecutionTimedOutEvent mocks base method.
func (m *MockMutableState) AddChildWorkflowExecutionTimedOutEvent(arg0 int64, arg1 *v10.WorkflowExecution, arg2 *v13.WorkflowExecutionTimedOutEventAttributes) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddChildWorkflowExecutionTimedOutEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddChildWorkflowExecutionTimedOutEvent indicates an expected call of AddChildWorkflowExecutionTimedOutEvent.
func (mr *MockMutableStateMockRecorder) AddChildWorkflowExecutionTimedOutEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddChildWorkflowExecutionTimedOutEvent", reflect.TypeOf((*MockMutableState)(nil).AddChildWorkflowExecutionTimedOutEvent), arg0, arg1, arg2)
}

// AddCompletedWorkflowEvent mocks base method.
func (m *MockMutableState) AddCompletedWorkflowEvent(arg0 int64, arg1 *v1.CompleteWorkflowExecutionCommandAttributes) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddCompletedWorkflowEvent", arg0, arg1)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddCompletedWorkflowEvent indicates an expected call of AddCompletedWorkflowEvent.
func (mr *MockMutableStateMockRecorder) AddCompletedWorkflowEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddCompletedWorkflowEvent", reflect.TypeOf((*MockMutableState)(nil).AddCompletedWorkflowEvent), arg0, arg1)
}

// AddContinueAsNewEvent mocks base method.
func (m *MockMutableState) AddContinueAsNewEvent(arg0, arg1 int64, arg2 string, arg3 *v1.ContinueAsNewWorkflowExecutionCommandAttributes) (*v13.HistoryEvent, MutableState, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddContinueAsNewEvent", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(MutableState)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddContinueAsNewEvent indicates an expected call of AddContinueAsNewEvent.
func (mr *MockMutableStateMockRecorder) AddContinueAsNewEvent(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddContinueAsNewEvent", reflect.TypeOf((*MockMutableState)(nil).AddContinueAsNewEvent), arg0, arg1, arg2, arg3)
}

// AddExternalWorkflowExecutionCancelRequested mocks base method.
func (m *MockMutableState) AddExternalWorkflowExecutionCancelRequested(arg0 int64, arg1, arg2, arg3 string) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddExternalWorkflowExecutionCancelRequested", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddExternalWorkflowExecutionCancelRequested indicates an expected call of AddExternalWorkflowExecutionCancelRequested.
func (mr *MockMutableStateMockRecorder) AddExternalWorkflowExecutionCancelRequested(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddExternalWorkflowExecutionCancelRequested", reflect.TypeOf((*MockMutableState)(nil).AddExternalWorkflowExecutionCancelRequested), arg0, arg1, arg2, arg3)
}

// AddExternalWorkflowExecutionSignaled mocks base method.
func (m *MockMutableState) AddExternalWorkflowExecutionSignaled(arg0 int64, arg1, arg2, arg3, arg4 string) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddExternalWorkflowExecutionSignaled", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddExternalWorkflowExecutionSignaled indicates an expected call of AddExternalWorkflowExecutionSignaled.
func (mr *MockMutableStateMockRecorder) AddExternalWorkflowExecutionSignaled(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddExternalWorkflowExecutionSignaled", reflect.TypeOf((*MockMutableState)(nil).AddExternalWorkflowExecutionSignaled), arg0, arg1, arg2, arg3, arg4)
}

// AddFailWorkflowEvent mocks base method.
func (m *MockMutableState) AddFailWorkflowEvent(arg0 int64, arg1 v11.RetryState, arg2 *v1.FailWorkflowExecutionCommandAttributes) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddFailWorkflowEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddFailWorkflowEvent indicates an expected call of AddFailWorkflowEvent.
func (mr *MockMutableStateMockRecorder) AddFailWorkflowEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddFailWorkflowEvent", reflect.TypeOf((*MockMutableState)(nil).AddFailWorkflowEvent), arg0, arg1, arg2)
}

// AddFirstWorkflowTaskScheduled mocks base method.
func (m *MockMutableState) AddFirstWorkflowTaskScheduled(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddFirstWorkflowTaskScheduled", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// AddFirstWorkflowTaskScheduled indicates an expected call of AddFirstWorkflowTaskScheduled.
func (mr *MockMutableStateMockRecorder) AddFirstWorkflowTaskScheduled(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddFirstWorkflowTaskScheduled", reflect.TypeOf((*MockMutableState)(nil).AddFirstWorkflowTaskScheduled), arg0)
}

// AddRecordMarkerEvent mocks base method.
func (m *MockMutableState) AddRecordMarkerEvent(arg0 int64, arg1 *v1.RecordMarkerCommandAttributes) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddRecordMarkerEvent", arg0, arg1)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddRecordMarkerEvent indicates an expected call of AddRecordMarkerEvent.
func (mr *MockMutableStateMockRecorder) AddRecordMarkerEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddRecordMarkerEvent", reflect.TypeOf((*MockMutableState)(nil).AddRecordMarkerEvent), arg0, arg1)
}

// AddRequestCancelExternalWorkflowExecutionFailedEvent mocks base method.
func (m *MockMutableState) AddRequestCancelExternalWorkflowExecutionFailedEvent(arg0 int64, arg1, arg2, arg3 string, arg4 v11.CancelExternalWorkflowExecutionFailedCause) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddRequestCancelExternalWorkflowExecutionFailedEvent", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddRequestCancelExternalWorkflowExecutionFailedEvent indicates an expected call of AddRequestCancelExternalWorkflowExecutionFailedEvent.
func (mr *MockMutableStateMockRecorder) AddRequestCancelExternalWorkflowExecutionFailedEvent(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddRequestCancelExternalWorkflowExecutionFailedEvent", reflect.TypeOf((*MockMutableState)(nil).AddRequestCancelExternalWorkflowExecutionFailedEvent), arg0, arg1, arg2, arg3, arg4)
}

// AddRequestCancelExternalWorkflowExecutionInitiatedEvent mocks base method.
func (m *MockMutableState) AddRequestCancelExternalWorkflowExecutionInitiatedEvent(arg0 int64, arg1 string, arg2 *v1.RequestCancelExternalWorkflowExecutionCommandAttributes) (*v13.HistoryEvent, *v18.RequestCancelInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddRequestCancelExternalWorkflowExecutionInitiatedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(*v18.RequestCancelInfo)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddRequestCancelExternalWorkflowExecutionInitiatedEvent indicates an expected call of AddRequestCancelExternalWorkflowExecutionInitiatedEvent.
func (mr *MockMutableStateMockRecorder) AddRequestCancelExternalWorkflowExecutionInitiatedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddRequestCancelExternalWorkflowExecutionInitiatedEvent", reflect.TypeOf((*MockMutableState)(nil).AddRequestCancelExternalWorkflowExecutionInitiatedEvent), arg0, arg1, arg2)
}

// AddSignalExternalWorkflowExecutionFailedEvent mocks base method.
func (m *MockMutableState) AddSignalExternalWorkflowExecutionFailedEvent(arg0 int64, arg1, arg2, arg3, arg4 string, arg5 v11.SignalExternalWorkflowExecutionFailedCause) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddSignalExternalWorkflowExecutionFailedEvent", arg0, arg1, arg2, arg3, arg4, arg5)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddSignalExternalWorkflowExecutionFailedEvent indicates an expected call of AddSignalExternalWorkflowExecutionFailedEvent.
func (mr *MockMutableStateMockRecorder) AddSignalExternalWorkflowExecutionFailedEvent(arg0, arg1, arg2, arg3, arg4, arg5 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddSignalExternalWorkflowExecutionFailedEvent", reflect.TypeOf((*MockMutableState)(nil).AddSignalExternalWorkflowExecutionFailedEvent), arg0, arg1, arg2, arg3, arg4, arg5)
}

// AddSignalExternalWorkflowExecutionInitiatedEvent mocks base method.
func (m *MockMutableState) AddSignalExternalWorkflowExecutionInitiatedEvent(arg0 int64, arg1 string, arg2 *v1.SignalExternalWorkflowExecutionCommandAttributes) (*v13.HistoryEvent, *v18.SignalInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddSignalExternalWorkflowExecutionInitiatedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(*v18.SignalInfo)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddSignalExternalWorkflowExecutionInitiatedEvent indicates an expected call of AddSignalExternalWorkflowExecutionInitiatedEvent.
func (mr *MockMutableStateMockRecorder) AddSignalExternalWorkflowExecutionInitiatedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddSignalExternalWorkflowExecutionInitiatedEvent", reflect.TypeOf((*MockMutableState)(nil).AddSignalExternalWorkflowExecutionInitiatedEvent), arg0, arg1, arg2)
}

// AddSignalRequested mocks base method.
func (m *MockMutableState) AddSignalRequested(requestID string) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "AddSignalRequested", requestID)
}

// AddSignalRequested indicates an expected call of AddSignalRequested.
func (mr *MockMutableStateMockRecorder) AddSignalRequested(requestID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddSignalRequested", reflect.TypeOf((*MockMutableState)(nil).AddSignalRequested), requestID)
}

// AddStartChildWorkflowExecutionFailedEvent mocks base method.
func (m *MockMutableState) AddStartChildWorkflowExecutionFailedEvent(arg0 int64, arg1 v11.StartChildWorkflowExecutionFailedCause, arg2 *v13.StartChildWorkflowExecutionInitiatedEventAttributes) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddStartChildWorkflowExecutionFailedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddStartChildWorkflowExecutionFailedEvent indicates an expected call of AddStartChildWorkflowExecutionFailedEvent.
func (mr *MockMutableStateMockRecorder) AddStartChildWorkflowExecutionFailedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddStartChildWorkflowExecutionFailedEvent", reflect.TypeOf((*MockMutableState)(nil).AddStartChildWorkflowExecutionFailedEvent), arg0, arg1, arg2)
}

// AddStartChildWorkflowExecutionInitiatedEvent mocks base method.
func (m *MockMutableState) AddStartChildWorkflowExecutionInitiatedEvent(arg0 int64, arg1 string, arg2 *v1.StartChildWorkflowExecutionCommandAttributes) (*v13.HistoryEvent, *v18.ChildExecutionInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddStartChildWorkflowExecutionInitiatedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(*v18.ChildExecutionInfo)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddStartChildWorkflowExecutionInitiatedEvent indicates an expected call of AddStartChildWorkflowExecutionInitiatedEvent.
func (mr *MockMutableStateMockRecorder) AddStartChildWorkflowExecutionInitiatedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddStartChildWorkflowExecutionInitiatedEvent", reflect.TypeOf((*MockMutableState)(nil).AddStartChildWorkflowExecutionInitiatedEvent), arg0, arg1, arg2)
}

// AddTimeoutWorkflowEvent mocks base method.
func (m *MockMutableState) AddTimeoutWorkflowEvent(arg0 int64, arg1 v11.RetryState) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddTimeoutWorkflowEvent", arg0, arg1)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddTimeoutWorkflowEvent indicates an expected call of AddTimeoutWorkflowEvent.
func (mr *MockMutableStateMockRecorder) AddTimeoutWorkflowEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTimeoutWorkflowEvent", reflect.TypeOf((*MockMutableState)(nil).AddTimeoutWorkflowEvent), arg0, arg1)
}

// AddTimerCanceledEvent mocks base method.
func (m *MockMutableState) AddTimerCanceledEvent(arg0 int64, arg1 *v1.CancelTimerCommandAttributes, arg2 string) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddTimerCanceledEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddTimerCanceledEvent indicates an expected call of AddTimerCanceledEvent.
func (mr *MockMutableStateMockRecorder) AddTimerCanceledEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTimerCanceledEvent", reflect.TypeOf((*MockMutableState)(nil).AddTimerCanceledEvent), arg0, arg1, arg2)
}

// AddTimerFiredEvent mocks base method.
func (m *MockMutableState) AddTimerFiredEvent(arg0 string) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddTimerFiredEvent", arg0)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddTimerFiredEvent indicates an expected call of AddTimerFiredEvent.
func (mr *MockMutableStateMockRecorder) AddTimerFiredEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTimerFiredEvent", reflect.TypeOf((*MockMutableState)(nil).AddTimerFiredEvent), arg0)
}

// AddTimerStartedEvent mocks base method.
func (m *MockMutableState) AddTimerStartedEvent(arg0 int64, arg1 *v1.StartTimerCommandAttributes) (*v13.HistoryEvent, *v18.TimerInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddTimerStartedEvent", arg0, arg1)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(*v18.TimerInfo)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddTimerStartedEvent indicates an expected call of AddTimerStartedEvent.
func (mr *MockMutableStateMockRecorder) AddTimerStartedEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTimerStartedEvent", reflect.TypeOf((*MockMutableState)(nil).AddTimerStartedEvent), arg0, arg1)
}

// AddTimerTasks mocks base method.
func (m *MockMutableState) AddTimerTasks(timerTasks ...persistence.Task) {
	m.ctrl.T.Helper()
	varargs := []interface{}{}
	for _, a := range timerTasks {
		varargs = append(varargs, a)
	}
	m.ctrl.Call(m, "AddTimerTasks", varargs...)
}

// AddTimerTasks indicates an expected call of AddTimerTasks.
func (mr *MockMutableStateMockRecorder) AddTimerTasks(timerTasks ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTimerTasks", reflect.TypeOf((*MockMutableState)(nil).AddTimerTasks), timerTasks...)
}

// AddTransferTasks mocks base method.
func (m *MockMutableState) AddTransferTasks(transferTasks ...persistence.Task) {
	m.ctrl.T.Helper()
	varargs := []interface{}{}
	for _, a := range transferTasks {
		varargs = append(varargs, a)
	}
	m.ctrl.Call(m, "AddTransferTasks", varargs...)
}

// AddTransferTasks indicates an expected call of AddTransferTasks.
func (mr *MockMutableStateMockRecorder) AddTransferTasks(transferTasks ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTransferTasks", reflect.TypeOf((*MockMutableState)(nil).AddTransferTasks), transferTasks...)
}

// AddUpsertWorkflowSearchAttributesEvent mocks base method.
func (m *MockMutableState) AddUpsertWorkflowSearchAttributesEvent(arg0 int64, arg1 *v1.UpsertWorkflowSearchAttributesCommandAttributes) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddUpsertWorkflowSearchAttributesEvent", arg0, arg1)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddUpsertWorkflowSearchAttributesEvent indicates an expected call of AddUpsertWorkflowSearchAttributesEvent.
func (mr *MockMutableStateMockRecorder) AddUpsertWorkflowSearchAttributesEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddUpsertWorkflowSearchAttributesEvent", reflect.TypeOf((*MockMutableState)(nil).AddUpsertWorkflowSearchAttributesEvent), arg0, arg1)
}

// AddVisibilityTasks mocks base method.
func (m *MockMutableState) AddVisibilityTasks(visibilityTasks ...persistence.Task) {
	m.ctrl.T.Helper()
	varargs := []interface{}{}
	for _, a := range visibilityTasks {
		varargs = append(varargs, a)
	}
	m.ctrl.Call(m, "AddVisibilityTasks", varargs...)
}

// AddVisibilityTasks indicates an expected call of AddVisibilityTasks.
func (mr *MockMutableStateMockRecorder) AddVisibilityTasks(visibilityTasks ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddVisibilityTasks", reflect.TypeOf((*MockMutableState)(nil).AddVisibilityTasks), visibilityTasks...)
}

// AddWorkflowExecutionCancelRequestedEvent mocks base method.
func (m *MockMutableState) AddWorkflowExecutionCancelRequestedEvent(arg0 *v17.RequestCancelWorkflowExecutionRequest) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowExecutionCancelRequestedEvent", arg0)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowExecutionCancelRequestedEvent indicates an expected call of AddWorkflowExecutionCancelRequestedEvent.
func (mr *MockMutableStateMockRecorder) AddWorkflowExecutionCancelRequestedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowExecutionCancelRequestedEvent", reflect.TypeOf((*MockMutableState)(nil).AddWorkflowExecutionCancelRequestedEvent), arg0)
}

// AddWorkflowExecutionCanceledEvent mocks base method.
func (m *MockMutableState) AddWorkflowExecutionCanceledEvent(arg0 int64, arg1 *v1.CancelWorkflowExecutionCommandAttributes) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowExecutionCanceledEvent", arg0, arg1)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowExecutionCanceledEvent indicates an expected call of AddWorkflowExecutionCanceledEvent.
func (mr *MockMutableStateMockRecorder) AddWorkflowExecutionCanceledEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowExecutionCanceledEvent", reflect.TypeOf((*MockMutableState)(nil).AddWorkflowExecutionCanceledEvent), arg0, arg1)
}

// AddWorkflowExecutionSignaled mocks base method.
func (m *MockMutableState) AddWorkflowExecutionSignaled(signalName string, input *v10.Payloads, identity string) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowExecutionSignaled", signalName, input, identity)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowExecutionSignaled indicates an expected call of AddWorkflowExecutionSignaled.
func (mr *MockMutableStateMockRecorder) AddWorkflowExecutionSignaled(signalName, input, identity interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowExecutionSignaled", reflect.TypeOf((*MockMutableState)(nil).AddWorkflowExecutionSignaled), signalName, input, identity)
}

// AddWorkflowExecutionStartedEvent mocks base method.
func (m *MockMutableState) AddWorkflowExecutionStartedEvent(arg0 v10.WorkflowExecution, arg1 *v17.StartWorkflowExecutionRequest) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowExecutionStartedEvent", arg0, arg1)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowExecutionStartedEvent indicates an expected call of AddWorkflowExecutionStartedEvent.
func (mr *MockMutableStateMockRecorder) AddWorkflowExecutionStartedEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowExecutionStartedEvent", reflect.TypeOf((*MockMutableState)(nil).AddWorkflowExecutionStartedEvent), arg0, arg1)
}

// AddWorkflowExecutionTerminatedEvent mocks base method.
func (m *MockMutableState) AddWorkflowExecutionTerminatedEvent(firstEventID int64, reason string, details *v10.Payloads, identity string) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowExecutionTerminatedEvent", firstEventID, reason, details, identity)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowExecutionTerminatedEvent indicates an expected call of AddWorkflowExecutionTerminatedEvent.
func (mr *MockMutableStateMockRecorder) AddWorkflowExecutionTerminatedEvent(firstEventID, reason, details, identity interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowExecutionTerminatedEvent", reflect.TypeOf((*MockMutableState)(nil).AddWorkflowExecutionTerminatedEvent), firstEventID, reason, details, identity)
}

// AddWorkflowTaskCompletedEvent mocks base method.
func (m *MockMutableState) AddWorkflowTaskCompletedEvent(arg0, arg1 int64, arg2 *v15.RespondWorkflowTaskCompletedRequest, arg3 int) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowTaskCompletedEvent", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowTaskCompletedEvent indicates an expected call of AddWorkflowTaskCompletedEvent.
func (mr *MockMutableStateMockRecorder) AddWorkflowTaskCompletedEvent(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowTaskCompletedEvent", reflect.TypeOf((*MockMutableState)(nil).AddWorkflowTaskCompletedEvent), arg0, arg1, arg2, arg3)
}

// AddWorkflowTaskFailedEvent mocks base method.
func (m *MockMutableState) AddWorkflowTaskFailedEvent(scheduleEventID, startedEventID int64, cause v11.WorkflowTaskFailedCause, failure *v12.Failure, identity, binChecksum, baseRunID, newRunID string, forkEventVersion int64) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowTaskFailedEvent", scheduleEventID, startedEventID, cause, failure, identity, binChecksum, baseRunID, newRunID, forkEventVersion)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowTaskFailedEvent indicates an expected call of AddWorkflowTaskFailedEvent.
func (mr *MockMutableStateMockRecorder) AddWorkflowTaskFailedEvent(scheduleEventID, startedEventID, cause, failure, identity, binChecksum, baseRunID, newRunID, forkEventVersion interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowTaskFailedEvent", reflect.TypeOf((*MockMutableState)(nil).AddWorkflowTaskFailedEvent), scheduleEventID, startedEventID, cause, failure, identity, binChecksum, baseRunID, newRunID, forkEventVersion)
}

// AddWorkflowTaskScheduleToStartTimeoutEvent mocks base method.
func (m *MockMutableState) AddWorkflowTaskScheduleToStartTimeoutEvent(arg0 int64) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowTaskScheduleToStartTimeoutEvent", arg0)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowTaskScheduleToStartTimeoutEvent indicates an expected call of AddWorkflowTaskScheduleToStartTimeoutEvent.
func (mr *MockMutableStateMockRecorder) AddWorkflowTaskScheduleToStartTimeoutEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowTaskScheduleToStartTimeoutEvent", reflect.TypeOf((*MockMutableState)(nil).AddWorkflowTaskScheduleToStartTimeoutEvent), arg0)
}

// AddWorkflowTaskScheduledEvent mocks base method.
func (m *MockMutableState) AddWorkflowTaskScheduledEvent(bypassTaskGeneration bool) (*WorkflowTaskInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowTaskScheduledEvent", bypassTaskGeneration)
	ret0, _ := ret[0].(*WorkflowTaskInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowTaskScheduledEvent indicates an expected call of AddWorkflowTaskScheduledEvent.
func (mr *MockMutableStateMockRecorder) AddWorkflowTaskScheduledEvent(bypassTaskGeneration interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowTaskScheduledEvent", reflect.TypeOf((*MockMutableState)(nil).AddWorkflowTaskScheduledEvent), bypassTaskGeneration)
}

// AddWorkflowTaskScheduledEventAsHeartbeat mocks base method.
func (m *MockMutableState) AddWorkflowTaskScheduledEventAsHeartbeat(bypassTaskGeneration bool, originalScheduledTimestamp *time.Time) (*WorkflowTaskInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowTaskScheduledEventAsHeartbeat", bypassTaskGeneration, originalScheduledTimestamp)
	ret0, _ := ret[0].(*WorkflowTaskInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowTaskScheduledEventAsHeartbeat indicates an expected call of AddWorkflowTaskScheduledEventAsHeartbeat.
func (mr *MockMutableStateMockRecorder) AddWorkflowTaskScheduledEventAsHeartbeat(bypassTaskGeneration, originalScheduledTimestamp interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowTaskScheduledEventAsHeartbeat", reflect.TypeOf((*MockMutableState)(nil).AddWorkflowTaskScheduledEventAsHeartbeat), bypassTaskGeneration, originalScheduledTimestamp)
}

// AddWorkflowTaskStartedEvent mocks base method.
func (m *MockMutableState) AddWorkflowTaskStartedEvent(arg0 int64, arg1 string, arg2 *v14.TaskQueue, arg3 string) (*v13.HistoryEvent, *WorkflowTaskInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowTaskStartedEvent", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(*WorkflowTaskInfo)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddWorkflowTaskStartedEvent indicates an expected call of AddWorkflowTaskStartedEvent.
func (mr *MockMutableStateMockRecorder) AddWorkflowTaskStartedEvent(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowTaskStartedEvent", reflect.TypeOf((*MockMutableState)(nil).AddWorkflowTaskStartedEvent), arg0, arg1, arg2, arg3)
}

// AddWorkflowTaskTimedOutEvent mocks base method.
func (m *MockMutableState) AddWorkflowTaskTimedOutEvent(arg0, arg1 int64) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowTaskTimedOutEvent", arg0, arg1)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowTaskTimedOutEvent indicates an expected call of AddWorkflowTaskTimedOutEvent.
func (mr *MockMutableStateMockRecorder) AddWorkflowTaskTimedOutEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowTaskTimedOutEvent", reflect.TypeOf((*MockMutableState)(nil).AddWorkflowTaskTimedOutEvent), arg0, arg1)
}

// CheckResettable mocks base method.
func (m *MockMutableState) CheckResettable() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CheckResettable")
	ret0, _ := ret[0].(error)
	return ret0
}

// CheckResettable indicates an expected call of CheckResettable.
func (mr *MockMutableStateMockRecorder) CheckResettable() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CheckResettable", reflect.TypeOf((*MockMutableState)(nil).CheckResettable))
}

// ClearStickyness mocks base method.
func (m *MockMutableState) ClearStickyness() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "ClearStickyness")
}

// ClearStickyness indicates an expected call of ClearStickyness.
func (mr *MockMutableStateMockRecorder) ClearStickyness() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ClearStickyness", reflect.TypeOf((*MockMutableState)(nil).ClearStickyness))
}

// CloneToProto mocks base method.
func (m *MockMutableState) CloneToProto() *v18.WorkflowMutableState {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CloneToProto")
	ret0, _ := ret[0].(*v18.WorkflowMutableState)
	return ret0
}

// CloneToProto indicates an expected call of CloneToProto.
func (mr *MockMutableStateMockRecorder) CloneToProto() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CloneToProto", reflect.TypeOf((*MockMutableState)(nil).CloneToProto))
}

// CloseTransactionAsMutation mocks base method.
func (m *MockMutableState) CloseTransactionAsMutation(now time.Time, transactionPolicy TransactionPolicy) (*persistence.WorkflowMutation, []*persistence.WorkflowEvents, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CloseTransactionAsMutation", now, transactionPolicy)
	ret0, _ := ret[0].(*persistence.WorkflowMutation)
	ret1, _ := ret[1].([]*persistence.WorkflowEvents)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CloseTransactionAsMutation indicates an expected call of CloseTransactionAsMutation.
func (mr *MockMutableStateMockRecorder) CloseTransactionAsMutation(now, transactionPolicy interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CloseTransactionAsMutation", reflect.TypeOf((*MockMutableState)(nil).CloseTransactionAsMutation), now, transactionPolicy)
}

// CloseTransactionAsSnapshot mocks base method.
func (m *MockMutableState) CloseTransactionAsSnapshot(now time.Time, transactionPolicy TransactionPolicy) (*persistence.WorkflowSnapshot, []*persistence.WorkflowEvents, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CloseTransactionAsSnapshot", now, transactionPolicy)
	ret0, _ := ret[0].(*persistence.WorkflowSnapshot)
	ret1, _ := ret[1].([]*persistence.WorkflowEvents)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CloseTransactionAsSnapshot indicates an expected call of CloseTransactionAsSnapshot.
func (mr *MockMutableStateMockRecorder) CloseTransactionAsSnapshot(now, transactionPolicy interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CloseTransactionAsSnapshot", reflect.TypeOf((*MockMutableState)(nil).CloseTransactionAsSnapshot), now, transactionPolicy)
}

// CreateTransientWorkflowTaskEvents mocks base method.
func (m *MockMutableState) CreateTransientWorkflowTaskEvents(di *WorkflowTaskInfo, identity string) (*v13.HistoryEvent, *v13.HistoryEvent) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTransientWorkflowTaskEvents", di, identity)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(*v13.HistoryEvent)
	return ret0, ret1
}

// CreateTransientWorkflowTaskEvents indicates an expected call of CreateTransientWorkflowTaskEvents.
func (mr *MockMutableStateMockRecorder) CreateTransientWorkflowTaskEvents(di, identity interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransientWorkflowTaskEvents", reflect.TypeOf((*MockMutableState)(nil).CreateTransientWorkflowTaskEvents), di, identity)
}

// DeleteSignalRequested mocks base method.
func (m *MockMutableState) DeleteSignalRequested(requestID string) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "DeleteSignalRequested", requestID)
}

// DeleteSignalRequested indicates an expected call of DeleteSignalRequested.
func (mr *MockMutableStateMockRecorder) DeleteSignalRequested(requestID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSignalRequested", reflect.TypeOf((*MockMutableState)(nil).DeleteSignalRequested), requestID)
}

// DeleteWorkflowTask mocks base method.
func (m *MockMutableState) DeleteWorkflowTask() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "DeleteWorkflowTask")
}

// DeleteWorkflowTask indicates an expected call of DeleteWorkflowTask.
func (mr *MockMutableStateMockRecorder) DeleteWorkflowTask() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteWorkflowTask", reflect.TypeOf((*MockMutableState)(nil).DeleteWorkflowTask))
}

// FlushBufferedEvents mocks base method.
func (m *MockMutableState) FlushBufferedEvents() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "FlushBufferedEvents")
}

// FlushBufferedEvents indicates an expected call of FlushBufferedEvents.
func (mr *MockMutableStateMockRecorder) FlushBufferedEvents() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FlushBufferedEvents", reflect.TypeOf((*MockMutableState)(nil).FlushBufferedEvents))
}

// GetActivityByActivityID mocks base method.
func (m *MockMutableState) GetActivityByActivityID(arg0 string) (*v18.ActivityInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetActivityByActivityID", arg0)
	ret0, _ := ret[0].(*v18.ActivityInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetActivityByActivityID indicates an expected call of GetActivityByActivityID.
func (mr *MockMutableStateMockRecorder) GetActivityByActivityID(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetActivityByActivityID", reflect.TypeOf((*MockMutableState)(nil).GetActivityByActivityID), arg0)
}

// GetActivityInfo mocks base method.
func (m *MockMutableState) GetActivityInfo(arg0 int64) (*v18.ActivityInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetActivityInfo", arg0)
	ret0, _ := ret[0].(*v18.ActivityInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetActivityInfo indicates an expected call of GetActivityInfo.
func (mr *MockMutableStateMockRecorder) GetActivityInfo(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetActivityInfo", reflect.TypeOf((*MockMutableState)(nil).GetActivityInfo), arg0)
}

// GetActivityInfoWithTimerHeartbeat mocks base method.
func (m *MockMutableState) GetActivityInfoWithTimerHeartbeat(scheduleEventID int64) (*v18.ActivityInfo, time.Time, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetActivityInfoWithTimerHeartbeat", scheduleEventID)
	ret0, _ := ret[0].(*v18.ActivityInfo)
	ret1, _ := ret[1].(time.Time)
	ret2, _ := ret[2].(bool)
	return ret0, ret1, ret2
}

// GetActivityInfoWithTimerHeartbeat indicates an expected call of GetActivityInfoWithTimerHeartbeat.
func (mr *MockMutableStateMockRecorder) GetActivityInfoWithTimerHeartbeat(scheduleEventID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetActivityInfoWithTimerHeartbeat", reflect.TypeOf((*MockMutableState)(nil).GetActivityInfoWithTimerHeartbeat), scheduleEventID)
}

// GetActivityScheduledEvent mocks base method.
func (m *MockMutableState) GetActivityScheduledEvent(arg0 int64) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetActivityScheduledEvent", arg0)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetActivityScheduledEvent indicates an expected call of GetActivityScheduledEvent.
func (mr *MockMutableStateMockRecorder) GetActivityScheduledEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetActivityScheduledEvent", reflect.TypeOf((*MockMutableState)(nil).GetActivityScheduledEvent), arg0)
}

// GetChildExecutionInfo mocks base method.
func (m *MockMutableState) GetChildExecutionInfo(arg0 int64) (*v18.ChildExecutionInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetChildExecutionInfo", arg0)
	ret0, _ := ret[0].(*v18.ChildExecutionInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetChildExecutionInfo indicates an expected call of GetChildExecutionInfo.
func (mr *MockMutableStateMockRecorder) GetChildExecutionInfo(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetChildExecutionInfo", reflect.TypeOf((*MockMutableState)(nil).GetChildExecutionInfo), arg0)
}

// GetChildExecutionInitiatedEvent mocks base method.
func (m *MockMutableState) GetChildExecutionInitiatedEvent(arg0 int64) (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetChildExecutionInitiatedEvent", arg0)
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetChildExecutionInitiatedEvent indicates an expected call of GetChildExecutionInitiatedEvent.
func (mr *MockMutableStateMockRecorder) GetChildExecutionInitiatedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetChildExecutionInitiatedEvent", reflect.TypeOf((*MockMutableState)(nil).GetChildExecutionInitiatedEvent), arg0)
}

// GetCompletionEvent mocks base method.
func (m *MockMutableState) GetCompletionEvent() (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCompletionEvent")
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCompletionEvent indicates an expected call of GetCompletionEvent.
func (mr *MockMutableStateMockRecorder) GetCompletionEvent() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCompletionEvent", reflect.TypeOf((*MockMutableState)(nil).GetCompletionEvent))
}

// GetCronBackoffDuration mocks base method.
func (m *MockMutableState) GetCronBackoffDuration() (time.Duration, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCronBackoffDuration")
	ret0, _ := ret[0].(time.Duration)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCronBackoffDuration indicates an expected call of GetCronBackoffDuration.
func (mr *MockMutableStateMockRecorder) GetCronBackoffDuration() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCronBackoffDuration", reflect.TypeOf((*MockMutableState)(nil).GetCronBackoffDuration))
}

// GetCurrentBranchToken mocks base method.
func (m *MockMutableState) GetCurrentBranchToken() ([]byte, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCurrentBranchToken")
	ret0, _ := ret[0].([]byte)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCurrentBranchToken indicates an expected call of GetCurrentBranchToken.
func (mr *MockMutableStateMockRecorder) GetCurrentBranchToken() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCurrentBranchToken", reflect.TypeOf((*MockMutableState)(nil).GetCurrentBranchToken))
}

// GetCurrentVersion mocks base method.
func (m *MockMutableState) GetCurrentVersion() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCurrentVersion")
	ret0, _ := ret[0].(int64)
	return ret0
}

// GetCurrentVersion indicates an expected call of GetCurrentVersion.
func (mr *MockMutableStateMockRecorder) GetCurrentVersion() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCurrentVersion", reflect.TypeOf((*MockMutableState)(nil).GetCurrentVersion))
}

// GetExecutionInfo mocks base method.
func (m *MockMutableState) GetExecutionInfo() *v18.WorkflowExecutionInfo {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetExecutionInfo")
	ret0, _ := ret[0].(*v18.WorkflowExecutionInfo)
	return ret0
}

// GetExecutionInfo indicates an expected call of GetExecutionInfo.
func (mr *MockMutableStateMockRecorder) GetExecutionInfo() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetExecutionInfo", reflect.TypeOf((*MockMutableState)(nil).GetExecutionInfo))
}

// GetExecutionState mocks base method.
func (m *MockMutableState) GetExecutionState() *v18.WorkflowExecutionState {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetExecutionState")
	ret0, _ := ret[0].(*v18.WorkflowExecutionState)
	return ret0
}

// GetExecutionState indicates an expected call of GetExecutionState.
func (mr *MockMutableStateMockRecorder) GetExecutionState() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetExecutionState", reflect.TypeOf((*MockMutableState)(nil).GetExecutionState))
}

// GetInFlightWorkflowTask mocks base method.
func (m *MockMutableState) GetInFlightWorkflowTask() (*WorkflowTaskInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetInFlightWorkflowTask")
	ret0, _ := ret[0].(*WorkflowTaskInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetInFlightWorkflowTask indicates an expected call of GetInFlightWorkflowTask.
func (mr *MockMutableStateMockRecorder) GetInFlightWorkflowTask() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetInFlightWorkflowTask", reflect.TypeOf((*MockMutableState)(nil).GetInFlightWorkflowTask))
}

// GetLastFirstEventIDTxnID mocks base method.
func (m *MockMutableState) GetLastFirstEventIDTxnID() (int64, int64) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLastFirstEventIDTxnID")
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(int64)
	return ret0, ret1
}

// GetLastFirstEventIDTxnID indicates an expected call of GetLastFirstEventIDTxnID.
func (mr *MockMutableStateMockRecorder) GetLastFirstEventIDTxnID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLastFirstEventIDTxnID", reflect.TypeOf((*MockMutableState)(nil).GetLastFirstEventIDTxnID))
}

// GetLastWriteVersion mocks base method.
func (m *MockMutableState) GetLastWriteVersion() (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLastWriteVersion")
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetLastWriteVersion indicates an expected call of GetLastWriteVersion.
func (mr *MockMutableStateMockRecorder) GetLastWriteVersion() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLastWriteVersion", reflect.TypeOf((*MockMutableState)(nil).GetLastWriteVersion))
}

// GetNamespaceEntry mocks base method.
func (m *MockMutableState) GetNamespaceEntry() *cache.NamespaceCacheEntry {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetNamespaceEntry")
	ret0, _ := ret[0].(*cache.NamespaceCacheEntry)
	return ret0
}

// GetNamespaceEntry indicates an expected call of GetNamespaceEntry.
func (mr *MockMutableStateMockRecorder) GetNamespaceEntry() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetNamespaceEntry", reflect.TypeOf((*MockMutableState)(nil).GetNamespaceEntry))
}

// GetNextEventID mocks base method.
func (m *MockMutableState) GetNextEventID() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetNextEventID")
	ret0, _ := ret[0].(int64)
	return ret0
}

// GetNextEventID indicates an expected call of GetNextEventID.
func (mr *MockMutableStateMockRecorder) GetNextEventID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetNextEventID", reflect.TypeOf((*MockMutableState)(nil).GetNextEventID))
}

// GetPendingActivityInfos mocks base method.
func (m *MockMutableState) GetPendingActivityInfos() map[int64]*v18.ActivityInfo {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPendingActivityInfos")
	ret0, _ := ret[0].(map[int64]*v18.ActivityInfo)
	return ret0
}

// GetPendingActivityInfos indicates an expected call of GetPendingActivityInfos.
func (mr *MockMutableStateMockRecorder) GetPendingActivityInfos() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPendingActivityInfos", reflect.TypeOf((*MockMutableState)(nil).GetPendingActivityInfos))
}

// GetPendingChildExecutionInfos mocks base method.
func (m *MockMutableState) GetPendingChildExecutionInfos() map[int64]*v18.ChildExecutionInfo {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPendingChildExecutionInfos")
	ret0, _ := ret[0].(map[int64]*v18.ChildExecutionInfo)
	return ret0
}

// GetPendingChildExecutionInfos indicates an expected call of GetPendingChildExecutionInfos.
func (mr *MockMutableStateMockRecorder) GetPendingChildExecutionInfos() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPendingChildExecutionInfos", reflect.TypeOf((*MockMutableState)(nil).GetPendingChildExecutionInfos))
}

// GetPendingRequestCancelExternalInfos mocks base method.
func (m *MockMutableState) GetPendingRequestCancelExternalInfos() map[int64]*v18.RequestCancelInfo {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPendingRequestCancelExternalInfos")
	ret0, _ := ret[0].(map[int64]*v18.RequestCancelInfo)
	return ret0
}

// GetPendingRequestCancelExternalInfos indicates an expected call of GetPendingRequestCancelExternalInfos.
func (mr *MockMutableStateMockRecorder) GetPendingRequestCancelExternalInfos() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPendingRequestCancelExternalInfos", reflect.TypeOf((*MockMutableState)(nil).GetPendingRequestCancelExternalInfos))
}

// GetPendingSignalExternalInfos mocks base method.
func (m *MockMutableState) GetPendingSignalExternalInfos() map[int64]*v18.SignalInfo {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPendingSignalExternalInfos")
	ret0, _ := ret[0].(map[int64]*v18.SignalInfo)
	return ret0
}

// GetPendingSignalExternalInfos indicates an expected call of GetPendingSignalExternalInfos.
func (mr *MockMutableStateMockRecorder) GetPendingSignalExternalInfos() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPendingSignalExternalInfos", reflect.TypeOf((*MockMutableState)(nil).GetPendingSignalExternalInfos))
}

// GetPendingTimerInfos mocks base method.
func (m *MockMutableState) GetPendingTimerInfos() map[string]*v18.TimerInfo {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPendingTimerInfos")
	ret0, _ := ret[0].(map[string]*v18.TimerInfo)
	return ret0
}

// GetPendingTimerInfos indicates an expected call of GetPendingTimerInfos.
func (mr *MockMutableStateMockRecorder) GetPendingTimerInfos() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPendingTimerInfos", reflect.TypeOf((*MockMutableState)(nil).GetPendingTimerInfos))
}

// GetPendingWorkflowTask mocks base method.
func (m *MockMutableState) GetPendingWorkflowTask() (*WorkflowTaskInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPendingWorkflowTask")
	ret0, _ := ret[0].(*WorkflowTaskInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetPendingWorkflowTask indicates an expected call of GetPendingWorkflowTask.
func (mr *MockMutableStateMockRecorder) GetPendingWorkflowTask() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPendingWorkflowTask", reflect.TypeOf((*MockMutableState)(nil).GetPendingWorkflowTask))
}

// GetPreviousStartedEventID mocks base method.
func (m *MockMutableState) GetPreviousStartedEventID() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPreviousStartedEventID")
	ret0, _ := ret[0].(int64)
	return ret0
}

// GetPreviousStartedEventID indicates an expected call of GetPreviousStartedEventID.
func (mr *MockMutableStateMockRecorder) GetPreviousStartedEventID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPreviousStartedEventID", reflect.TypeOf((*MockMutableState)(nil).GetPreviousStartedEventID))
}

// GetQueryRegistry mocks base method.
func (m *MockMutableState) GetQueryRegistry() QueryRegistry {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetQueryRegistry")
	ret0, _ := ret[0].(QueryRegistry)
	return ret0
}

// GetQueryRegistry indicates an expected call of GetQueryRegistry.
func (mr *MockMutableStateMockRecorder) GetQueryRegistry() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetQueryRegistry", reflect.TypeOf((*MockMutableState)(nil).GetQueryRegistry))
}

// GetRequestCancelInfo mocks base method.
func (m *MockMutableState) GetRequestCancelInfo(arg0 int64) (*v18.RequestCancelInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetRequestCancelInfo", arg0)
	ret0, _ := ret[0].(*v18.RequestCancelInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetRequestCancelInfo indicates an expected call of GetRequestCancelInfo.
func (mr *MockMutableStateMockRecorder) GetRequestCancelInfo(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetRequestCancelInfo", reflect.TypeOf((*MockMutableState)(nil).GetRequestCancelInfo), arg0)
}

// GetRetryBackoffDuration mocks base method.
func (m *MockMutableState) GetRetryBackoffDuration(failure *v12.Failure) (time.Duration, v11.RetryState) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetRetryBackoffDuration", failure)
	ret0, _ := ret[0].(time.Duration)
	ret1, _ := ret[1].(v11.RetryState)
	return ret0, ret1
}

// GetRetryBackoffDuration indicates an expected call of GetRetryBackoffDuration.
func (mr *MockMutableStateMockRecorder) GetRetryBackoffDuration(failure interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetRetryBackoffDuration", reflect.TypeOf((*MockMutableState)(nil).GetRetryBackoffDuration), failure)
}

// GetSignalInfo mocks base method.
func (m *MockMutableState) GetSignalInfo(arg0 int64) (*v18.SignalInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSignalInfo", arg0)
	ret0, _ := ret[0].(*v18.SignalInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetSignalInfo indicates an expected call of GetSignalInfo.
func (mr *MockMutableStateMockRecorder) GetSignalInfo(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSignalInfo", reflect.TypeOf((*MockMutableState)(nil).GetSignalInfo), arg0)
}

// GetStartEvent mocks base method.
func (m *MockMutableState) GetStartEvent() (*v13.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetStartEvent")
	ret0, _ := ret[0].(*v13.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetStartEvent indicates an expected call of GetStartEvent.
func (mr *MockMutableStateMockRecorder) GetStartEvent() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetStartEvent", reflect.TypeOf((*MockMutableState)(nil).GetStartEvent))
}

// GetStartVersion mocks base method.
func (m *MockMutableState) GetStartVersion() (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetStartVersion")
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetStartVersion indicates an expected call of GetStartVersion.
func (mr *MockMutableStateMockRecorder) GetStartVersion() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetStartVersion", reflect.TypeOf((*MockMutableState)(nil).GetStartVersion))
}

// GetUpdateCondition mocks base method.
func (m *MockMutableState) GetUpdateCondition() (int64, int64) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUpdateCondition")
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(int64)
	return ret0, ret1
}

// GetUpdateCondition indicates an expected call of GetUpdateCondition.
func (mr *MockMutableStateMockRecorder) GetUpdateCondition() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUpdateCondition", reflect.TypeOf((*MockMutableState)(nil).GetUpdateCondition))
}

// GetUserTimerInfo mocks base method.
func (m *MockMutableState) GetUserTimerInfo(arg0 string) (*v18.TimerInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUserTimerInfo", arg0)
	ret0, _ := ret[0].(*v18.TimerInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetUserTimerInfo indicates an expected call of GetUserTimerInfo.
func (mr *MockMutableStateMockRecorder) GetUserTimerInfo(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUserTimerInfo", reflect.TypeOf((*MockMutableState)(nil).GetUserTimerInfo), arg0)
}

// GetUserTimerInfoByEventID mocks base method.
func (m *MockMutableState) GetUserTimerInfoByEventID(arg0 int64) (*v18.TimerInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUserTimerInfoByEventID", arg0)
	ret0, _ := ret[0].(*v18.TimerInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetUserTimerInfoByEventID indicates an expected call of GetUserTimerInfoByEventID.
func (mr *MockMutableStateMockRecorder) GetUserTimerInfoByEventID(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUserTimerInfoByEventID", reflect.TypeOf((*MockMutableState)(nil).GetUserTimerInfoByEventID), arg0)
}

// GetWorkflowStateStatus mocks base method.
func (m *MockMutableState) GetWorkflowStateStatus() (v16.WorkflowExecutionState, v11.WorkflowExecutionStatus) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetWorkflowStateStatus")
	ret0, _ := ret[0].(v16.WorkflowExecutionState)
	ret1, _ := ret[1].(v11.WorkflowExecutionStatus)
	return ret0, ret1
}

// GetWorkflowStateStatus indicates an expected call of GetWorkflowStateStatus.
func (mr *MockMutableStateMockRecorder) GetWorkflowStateStatus() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetWorkflowStateStatus", reflect.TypeOf((*MockMutableState)(nil).GetWorkflowStateStatus))
}

// GetWorkflowTaskInfo mocks base method.
func (m *MockMutableState) GetWorkflowTaskInfo(arg0 int64) (*WorkflowTaskInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetWorkflowTaskInfo", arg0)
	ret0, _ := ret[0].(*WorkflowTaskInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetWorkflowTaskInfo indicates an expected call of GetWorkflowTaskInfo.
func (mr *MockMutableStateMockRecorder) GetWorkflowTaskInfo(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetWorkflowTaskInfo", reflect.TypeOf((*MockMutableState)(nil).GetWorkflowTaskInfo), arg0)
}

// GetWorkflowType mocks base method.
func (m *MockMutableState) GetWorkflowType() *v10.WorkflowType {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetWorkflowType")
	ret0, _ := ret[0].(*v10.WorkflowType)
	return ret0
}

// GetWorkflowType indicates an expected call of GetWorkflowType.
func (mr *MockMutableStateMockRecorder) GetWorkflowType() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetWorkflowType", reflect.TypeOf((*MockMutableState)(nil).GetWorkflowType))
}

// HasBufferedEvents mocks base method.
func (m *MockMutableState) HasBufferedEvents() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HasBufferedEvents")
	ret0, _ := ret[0].(bool)
	return ret0
}

// HasBufferedEvents indicates an expected call of HasBufferedEvents.
func (mr *MockMutableStateMockRecorder) HasBufferedEvents() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HasBufferedEvents", reflect.TypeOf((*MockMutableState)(nil).HasBufferedEvents))
}

// HasInFlightWorkflowTask mocks base method.
func (m *MockMutableState) HasInFlightWorkflowTask() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HasInFlightWorkflowTask")
	ret0, _ := ret[0].(bool)
	return ret0
}

// HasInFlightWorkflowTask indicates an expected call of HasInFlightWorkflowTask.
func (mr *MockMutableStateMockRecorder) HasInFlightWorkflowTask() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HasInFlightWorkflowTask", reflect.TypeOf((*MockMutableState)(nil).HasInFlightWorkflowTask))
}

// HasParentExecution mocks base method.
func (m *MockMutableState) HasParentExecution() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HasParentExecution")
	ret0, _ := ret[0].(bool)
	return ret0
}

// HasParentExecution indicates an expected call of HasParentExecution.
func (mr *MockMutableStateMockRecorder) HasParentExecution() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HasParentExecution", reflect.TypeOf((*MockMutableState)(nil).HasParentExecution))
}

// HasPendingWorkflowTask mocks base method.
func (m *MockMutableState) HasPendingWorkflowTask() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HasPendingWorkflowTask")
	ret0, _ := ret[0].(bool)
	return ret0
}

// HasPendingWorkflowTask indicates an expected call of HasPendingWorkflowTask.
func (mr *MockMutableStateMockRecorder) HasPendingWorkflowTask() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HasPendingWorkflowTask", reflect.TypeOf((*MockMutableState)(nil).HasPendingWorkflowTask))
}

// HasProcessedOrPendingWorkflowTask mocks base method.
func (m *MockMutableState) HasProcessedOrPendingWorkflowTask() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HasProcessedOrPendingWorkflowTask")
	ret0, _ := ret[0].(bool)
	return ret0
}

// HasProcessedOrPendingWorkflowTask indicates an expected call of HasProcessedOrPendingWorkflowTask.
func (mr *MockMutableStateMockRecorder) HasProcessedOrPendingWorkflowTask() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HasProcessedOrPendingWorkflowTask", reflect.TypeOf((*MockMutableState)(nil).HasProcessedOrPendingWorkflowTask))
}

// IsCancelRequested mocks base method.
func (m *MockMutableState) IsCancelRequested() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsCancelRequested")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsCancelRequested indicates an expected call of IsCancelRequested.
func (mr *MockMutableStateMockRecorder) IsCancelRequested() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsCancelRequested", reflect.TypeOf((*MockMutableState)(nil).IsCancelRequested))
}

// IsCurrentWorkflowGuaranteed mocks base method.
func (m *MockMutableState) IsCurrentWorkflowGuaranteed() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsCurrentWorkflowGuaranteed")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsCurrentWorkflowGuaranteed indicates an expected call of IsCurrentWorkflowGuaranteed.
func (mr *MockMutableStateMockRecorder) IsCurrentWorkflowGuaranteed() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsCurrentWorkflowGuaranteed", reflect.TypeOf((*MockMutableState)(nil).IsCurrentWorkflowGuaranteed))
}

// IsResourceDuplicated mocks base method.
func (m *MockMutableState) IsResourceDuplicated(resourceDedupKey definition.DeduplicationID) bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsResourceDuplicated", resourceDedupKey)
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsResourceDuplicated indicates an expected call of IsResourceDuplicated.
func (mr *MockMutableStateMockRecorder) IsResourceDuplicated(resourceDedupKey interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsResourceDuplicated", reflect.TypeOf((*MockMutableState)(nil).IsResourceDuplicated), resourceDedupKey)
}

// IsSignalRequested mocks base method.
func (m *MockMutableState) IsSignalRequested(requestID string) bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsSignalRequested", requestID)
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsSignalRequested indicates an expected call of IsSignalRequested.
func (mr *MockMutableStateMockRecorder) IsSignalRequested(requestID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsSignalRequested", reflect.TypeOf((*MockMutableState)(nil).IsSignalRequested), requestID)
}

// IsStickyTaskQueueEnabled mocks base method.
func (m *MockMutableState) IsStickyTaskQueueEnabled() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsStickyTaskQueueEnabled")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsStickyTaskQueueEnabled indicates an expected call of IsStickyTaskQueueEnabled.
func (mr *MockMutableStateMockRecorder) IsStickyTaskQueueEnabled() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsStickyTaskQueueEnabled", reflect.TypeOf((*MockMutableState)(nil).IsStickyTaskQueueEnabled))
}

// IsWorkflowExecutionRunning mocks base method.
func (m *MockMutableState) IsWorkflowExecutionRunning() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsWorkflowExecutionRunning")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsWorkflowExecutionRunning indicates an expected call of IsWorkflowExecutionRunning.
func (mr *MockMutableStateMockRecorder) IsWorkflowExecutionRunning() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsWorkflowExecutionRunning", reflect.TypeOf((*MockMutableState)(nil).IsWorkflowExecutionRunning))
}

// ReplicateActivityInfo mocks base method.
func (m *MockMutableState) ReplicateActivityInfo(arg0 *v17.SyncActivityRequest, arg1 bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateActivityInfo", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateActivityInfo indicates an expected call of ReplicateActivityInfo.
func (mr *MockMutableStateMockRecorder) ReplicateActivityInfo(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateActivityInfo", reflect.TypeOf((*MockMutableState)(nil).ReplicateActivityInfo), arg0, arg1)
}

// ReplicateActivityTaskCancelRequestedEvent mocks base method.
func (m *MockMutableState) ReplicateActivityTaskCancelRequestedEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateActivityTaskCancelRequestedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateActivityTaskCancelRequestedEvent indicates an expected call of ReplicateActivityTaskCancelRequestedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateActivityTaskCancelRequestedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateActivityTaskCancelRequestedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateActivityTaskCancelRequestedEvent), arg0)
}

// ReplicateActivityTaskCanceledEvent mocks base method.
func (m *MockMutableState) ReplicateActivityTaskCanceledEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateActivityTaskCanceledEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateActivityTaskCanceledEvent indicates an expected call of ReplicateActivityTaskCanceledEvent.
func (mr *MockMutableStateMockRecorder) ReplicateActivityTaskCanceledEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateActivityTaskCanceledEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateActivityTaskCanceledEvent), arg0)
}

// ReplicateActivityTaskCompletedEvent mocks base method.
func (m *MockMutableState) ReplicateActivityTaskCompletedEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateActivityTaskCompletedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateActivityTaskCompletedEvent indicates an expected call of ReplicateActivityTaskCompletedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateActivityTaskCompletedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateActivityTaskCompletedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateActivityTaskCompletedEvent), arg0)
}

// ReplicateActivityTaskFailedEvent mocks base method.
func (m *MockMutableState) ReplicateActivityTaskFailedEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateActivityTaskFailedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateActivityTaskFailedEvent indicates an expected call of ReplicateActivityTaskFailedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateActivityTaskFailedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateActivityTaskFailedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateActivityTaskFailedEvent), arg0)
}

// ReplicateActivityTaskScheduledEvent mocks base method.
func (m *MockMutableState) ReplicateActivityTaskScheduledEvent(arg0 int64, arg1 *v13.HistoryEvent) (*v18.ActivityInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateActivityTaskScheduledEvent", arg0, arg1)
	ret0, _ := ret[0].(*v18.ActivityInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateActivityTaskScheduledEvent indicates an expected call of ReplicateActivityTaskScheduledEvent.
func (mr *MockMutableStateMockRecorder) ReplicateActivityTaskScheduledEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateActivityTaskScheduledEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateActivityTaskScheduledEvent), arg0, arg1)
}

// ReplicateActivityTaskStartedEvent mocks base method.
func (m *MockMutableState) ReplicateActivityTaskStartedEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateActivityTaskStartedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateActivityTaskStartedEvent indicates an expected call of ReplicateActivityTaskStartedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateActivityTaskStartedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateActivityTaskStartedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateActivityTaskStartedEvent), arg0)
}

// ReplicateActivityTaskTimedOutEvent mocks base method.
func (m *MockMutableState) ReplicateActivityTaskTimedOutEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateActivityTaskTimedOutEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateActivityTaskTimedOutEvent indicates an expected call of ReplicateActivityTaskTimedOutEvent.
func (mr *MockMutableStateMockRecorder) ReplicateActivityTaskTimedOutEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateActivityTaskTimedOutEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateActivityTaskTimedOutEvent), arg0)
}

// ReplicateChildWorkflowExecutionCanceledEvent mocks base method.
func (m *MockMutableState) ReplicateChildWorkflowExecutionCanceledEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateChildWorkflowExecutionCanceledEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateChildWorkflowExecutionCanceledEvent indicates an expected call of ReplicateChildWorkflowExecutionCanceledEvent.
func (mr *MockMutableStateMockRecorder) ReplicateChildWorkflowExecutionCanceledEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateChildWorkflowExecutionCanceledEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateChildWorkflowExecutionCanceledEvent), arg0)
}

// ReplicateChildWorkflowExecutionCompletedEvent mocks base method.
func (m *MockMutableState) ReplicateChildWorkflowExecutionCompletedEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateChildWorkflowExecutionCompletedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateChildWorkflowExecutionCompletedEvent indicates an expected call of ReplicateChildWorkflowExecutionCompletedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateChildWorkflowExecutionCompletedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateChildWorkflowExecutionCompletedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateChildWorkflowExecutionCompletedEvent), arg0)
}

// ReplicateChildWorkflowExecutionFailedEvent mocks base method.
func (m *MockMutableState) ReplicateChildWorkflowExecutionFailedEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateChildWorkflowExecutionFailedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateChildWorkflowExecutionFailedEvent indicates an expected call of ReplicateChildWorkflowExecutionFailedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateChildWorkflowExecutionFailedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateChildWorkflowExecutionFailedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateChildWorkflowExecutionFailedEvent), arg0)
}

// ReplicateChildWorkflowExecutionStartedEvent mocks base method.
func (m *MockMutableState) ReplicateChildWorkflowExecutionStartedEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateChildWorkflowExecutionStartedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateChildWorkflowExecutionStartedEvent indicates an expected call of ReplicateChildWorkflowExecutionStartedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateChildWorkflowExecutionStartedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateChildWorkflowExecutionStartedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateChildWorkflowExecutionStartedEvent), arg0)
}

// ReplicateChildWorkflowExecutionTerminatedEvent mocks base method.
func (m *MockMutableState) ReplicateChildWorkflowExecutionTerminatedEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateChildWorkflowExecutionTerminatedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateChildWorkflowExecutionTerminatedEvent indicates an expected call of ReplicateChildWorkflowExecutionTerminatedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateChildWorkflowExecutionTerminatedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateChildWorkflowExecutionTerminatedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateChildWorkflowExecutionTerminatedEvent), arg0)
}

// ReplicateChildWorkflowExecutionTimedOutEvent mocks base method.
func (m *MockMutableState) ReplicateChildWorkflowExecutionTimedOutEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateChildWorkflowExecutionTimedOutEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateChildWorkflowExecutionTimedOutEvent indicates an expected call of ReplicateChildWorkflowExecutionTimedOutEvent.
func (mr *MockMutableStateMockRecorder) ReplicateChildWorkflowExecutionTimedOutEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateChildWorkflowExecutionTimedOutEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateChildWorkflowExecutionTimedOutEvent), arg0)
}

// ReplicateExternalWorkflowExecutionCancelRequested mocks base method.
func (m *MockMutableState) ReplicateExternalWorkflowExecutionCancelRequested(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateExternalWorkflowExecutionCancelRequested", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateExternalWorkflowExecutionCancelRequested indicates an expected call of ReplicateExternalWorkflowExecutionCancelRequested.
func (mr *MockMutableStateMockRecorder) ReplicateExternalWorkflowExecutionCancelRequested(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateExternalWorkflowExecutionCancelRequested", reflect.TypeOf((*MockMutableState)(nil).ReplicateExternalWorkflowExecutionCancelRequested), arg0)
}

// ReplicateExternalWorkflowExecutionSignaled mocks base method.
func (m *MockMutableState) ReplicateExternalWorkflowExecutionSignaled(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateExternalWorkflowExecutionSignaled", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateExternalWorkflowExecutionSignaled indicates an expected call of ReplicateExternalWorkflowExecutionSignaled.
func (mr *MockMutableStateMockRecorder) ReplicateExternalWorkflowExecutionSignaled(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateExternalWorkflowExecutionSignaled", reflect.TypeOf((*MockMutableState)(nil).ReplicateExternalWorkflowExecutionSignaled), arg0)
}

// ReplicateRequestCancelExternalWorkflowExecutionFailedEvent mocks base method.
func (m *MockMutableState) ReplicateRequestCancelExternalWorkflowExecutionFailedEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateRequestCancelExternalWorkflowExecutionFailedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateRequestCancelExternalWorkflowExecutionFailedEvent indicates an expected call of ReplicateRequestCancelExternalWorkflowExecutionFailedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateRequestCancelExternalWorkflowExecutionFailedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateRequestCancelExternalWorkflowExecutionFailedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateRequestCancelExternalWorkflowExecutionFailedEvent), arg0)
}

// ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent mocks base method.
func (m *MockMutableState) ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent(arg0 int64, arg1 *v13.HistoryEvent, arg2 string) (*v18.RequestCancelInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*v18.RequestCancelInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent indicates an expected call of ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent), arg0, arg1, arg2)
}

// ReplicateSignalExternalWorkflowExecutionFailedEvent mocks base method.
func (m *MockMutableState) ReplicateSignalExternalWorkflowExecutionFailedEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateSignalExternalWorkflowExecutionFailedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateSignalExternalWorkflowExecutionFailedEvent indicates an expected call of ReplicateSignalExternalWorkflowExecutionFailedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateSignalExternalWorkflowExecutionFailedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateSignalExternalWorkflowExecutionFailedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateSignalExternalWorkflowExecutionFailedEvent), arg0)
}

// ReplicateSignalExternalWorkflowExecutionInitiatedEvent mocks base method.
func (m *MockMutableState) ReplicateSignalExternalWorkflowExecutionInitiatedEvent(arg0 int64, arg1 *v13.HistoryEvent, arg2 string) (*v18.SignalInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateSignalExternalWorkflowExecutionInitiatedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*v18.SignalInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateSignalExternalWorkflowExecutionInitiatedEvent indicates an expected call of ReplicateSignalExternalWorkflowExecutionInitiatedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateSignalExternalWorkflowExecutionInitiatedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateSignalExternalWorkflowExecutionInitiatedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateSignalExternalWorkflowExecutionInitiatedEvent), arg0, arg1, arg2)
}

// ReplicateStartChildWorkflowExecutionFailedEvent mocks base method.
func (m *MockMutableState) ReplicateStartChildWorkflowExecutionFailedEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateStartChildWorkflowExecutionFailedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateStartChildWorkflowExecutionFailedEvent indicates an expected call of ReplicateStartChildWorkflowExecutionFailedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateStartChildWorkflowExecutionFailedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateStartChildWorkflowExecutionFailedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateStartChildWorkflowExecutionFailedEvent), arg0)
}

// ReplicateStartChildWorkflowExecutionInitiatedEvent mocks base method.
func (m *MockMutableState) ReplicateStartChildWorkflowExecutionInitiatedEvent(arg0 int64, arg1 *v13.HistoryEvent, arg2 string) (*v18.ChildExecutionInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateStartChildWorkflowExecutionInitiatedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*v18.ChildExecutionInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateStartChildWorkflowExecutionInitiatedEvent indicates an expected call of ReplicateStartChildWorkflowExecutionInitiatedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateStartChildWorkflowExecutionInitiatedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateStartChildWorkflowExecutionInitiatedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateStartChildWorkflowExecutionInitiatedEvent), arg0, arg1, arg2)
}

// ReplicateTimerCanceledEvent mocks base method.
func (m *MockMutableState) ReplicateTimerCanceledEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateTimerCanceledEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateTimerCanceledEvent indicates an expected call of ReplicateTimerCanceledEvent.
func (mr *MockMutableStateMockRecorder) ReplicateTimerCanceledEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateTimerCanceledEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateTimerCanceledEvent), arg0)
}

// ReplicateTimerFiredEvent mocks base method.
func (m *MockMutableState) ReplicateTimerFiredEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateTimerFiredEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateTimerFiredEvent indicates an expected call of ReplicateTimerFiredEvent.
func (mr *MockMutableStateMockRecorder) ReplicateTimerFiredEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateTimerFiredEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateTimerFiredEvent), arg0)
}

// ReplicateTimerStartedEvent mocks base method.
func (m *MockMutableState) ReplicateTimerStartedEvent(arg0 *v13.HistoryEvent) (*v18.TimerInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateTimerStartedEvent", arg0)
	ret0, _ := ret[0].(*v18.TimerInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateTimerStartedEvent indicates an expected call of ReplicateTimerStartedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateTimerStartedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateTimerStartedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateTimerStartedEvent), arg0)
}

// ReplicateTransientWorkflowTaskScheduled mocks base method.
func (m *MockMutableState) ReplicateTransientWorkflowTaskScheduled() (*WorkflowTaskInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateTransientWorkflowTaskScheduled")
	ret0, _ := ret[0].(*WorkflowTaskInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateTransientWorkflowTaskScheduled indicates an expected call of ReplicateTransientWorkflowTaskScheduled.
func (mr *MockMutableStateMockRecorder) ReplicateTransientWorkflowTaskScheduled() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateTransientWorkflowTaskScheduled", reflect.TypeOf((*MockMutableState)(nil).ReplicateTransientWorkflowTaskScheduled))
}

// ReplicateUpsertWorkflowSearchAttributesEvent mocks base method.
func (m *MockMutableState) ReplicateUpsertWorkflowSearchAttributesEvent(arg0 *v13.HistoryEvent) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "ReplicateUpsertWorkflowSearchAttributesEvent", arg0)
}

// ReplicateUpsertWorkflowSearchAttributesEvent indicates an expected call of ReplicateUpsertWorkflowSearchAttributesEvent.
func (mr *MockMutableStateMockRecorder) ReplicateUpsertWorkflowSearchAttributesEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateUpsertWorkflowSearchAttributesEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateUpsertWorkflowSearchAttributesEvent), arg0)
}

// ReplicateWorkflowExecutionCancelRequestedEvent mocks base method.
func (m *MockMutableState) ReplicateWorkflowExecutionCancelRequestedEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionCancelRequestedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionCancelRequestedEvent indicates an expected call of ReplicateWorkflowExecutionCancelRequestedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateWorkflowExecutionCancelRequestedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionCancelRequestedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateWorkflowExecutionCancelRequestedEvent), arg0)
}

// ReplicateWorkflowExecutionCanceledEvent mocks base method.
func (m *MockMutableState) ReplicateWorkflowExecutionCanceledEvent(arg0 int64, arg1 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionCanceledEvent", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionCanceledEvent indicates an expected call of ReplicateWorkflowExecutionCanceledEvent.
func (mr *MockMutableStateMockRecorder) ReplicateWorkflowExecutionCanceledEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionCanceledEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateWorkflowExecutionCanceledEvent), arg0, arg1)
}

// ReplicateWorkflowExecutionCompletedEvent mocks base method.
func (m *MockMutableState) ReplicateWorkflowExecutionCompletedEvent(arg0 int64, arg1 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionCompletedEvent", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionCompletedEvent indicates an expected call of ReplicateWorkflowExecutionCompletedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateWorkflowExecutionCompletedEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionCompletedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateWorkflowExecutionCompletedEvent), arg0, arg1)
}

// ReplicateWorkflowExecutionContinuedAsNewEvent mocks base method.
func (m *MockMutableState) ReplicateWorkflowExecutionContinuedAsNewEvent(arg0 int64, arg1 string, arg2 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionContinuedAsNewEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionContinuedAsNewEvent indicates an expected call of ReplicateWorkflowExecutionContinuedAsNewEvent.
func (mr *MockMutableStateMockRecorder) ReplicateWorkflowExecutionContinuedAsNewEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionContinuedAsNewEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateWorkflowExecutionContinuedAsNewEvent), arg0, arg1, arg2)
}

// ReplicateWorkflowExecutionFailedEvent mocks base method.
func (m *MockMutableState) ReplicateWorkflowExecutionFailedEvent(arg0 int64, arg1 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionFailedEvent", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionFailedEvent indicates an expected call of ReplicateWorkflowExecutionFailedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateWorkflowExecutionFailedEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionFailedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateWorkflowExecutionFailedEvent), arg0, arg1)
}

// ReplicateWorkflowExecutionSignaled mocks base method.
func (m *MockMutableState) ReplicateWorkflowExecutionSignaled(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionSignaled", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionSignaled indicates an expected call of ReplicateWorkflowExecutionSignaled.
func (mr *MockMutableStateMockRecorder) ReplicateWorkflowExecutionSignaled(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionSignaled", reflect.TypeOf((*MockMutableState)(nil).ReplicateWorkflowExecutionSignaled), arg0)
}

// ReplicateWorkflowExecutionStartedEvent mocks base method.
func (m *MockMutableState) ReplicateWorkflowExecutionStartedEvent(arg0 string, arg1 v10.WorkflowExecution, arg2 string, arg3 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionStartedEvent", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionStartedEvent indicates an expected call of ReplicateWorkflowExecutionStartedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateWorkflowExecutionStartedEvent(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionStartedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateWorkflowExecutionStartedEvent), arg0, arg1, arg2, arg3)
}

// ReplicateWorkflowExecutionTerminatedEvent mocks base method.
func (m *MockMutableState) ReplicateWorkflowExecutionTerminatedEvent(arg0 int64, arg1 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionTerminatedEvent", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionTerminatedEvent indicates an expected call of ReplicateWorkflowExecutionTerminatedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateWorkflowExecutionTerminatedEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionTerminatedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateWorkflowExecutionTerminatedEvent), arg0, arg1)
}

// ReplicateWorkflowExecutionTimedoutEvent mocks base method.
func (m *MockMutableState) ReplicateWorkflowExecutionTimedoutEvent(arg0 int64, arg1 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionTimedoutEvent", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionTimedoutEvent indicates an expected call of ReplicateWorkflowExecutionTimedoutEvent.
func (mr *MockMutableStateMockRecorder) ReplicateWorkflowExecutionTimedoutEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionTimedoutEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateWorkflowExecutionTimedoutEvent), arg0, arg1)
}

// ReplicateWorkflowTaskCompletedEvent mocks base method.
func (m *MockMutableState) ReplicateWorkflowTaskCompletedEvent(arg0 *v13.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowTaskCompletedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowTaskCompletedEvent indicates an expected call of ReplicateWorkflowTaskCompletedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateWorkflowTaskCompletedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowTaskCompletedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateWorkflowTaskCompletedEvent), arg0)
}

// ReplicateWorkflowTaskFailedEvent mocks base method.
func (m *MockMutableState) ReplicateWorkflowTaskFailedEvent() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowTaskFailedEvent")
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowTaskFailedEvent indicates an expected call of ReplicateWorkflowTaskFailedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateWorkflowTaskFailedEvent() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowTaskFailedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateWorkflowTaskFailedEvent))
}

// ReplicateWorkflowTaskScheduledEvent mocks base method.
func (m *MockMutableState) ReplicateWorkflowTaskScheduledEvent(arg0, arg1 int64, arg2 *v14.TaskQueue, arg3, arg4 int32, arg5, arg6 *time.Time) (*WorkflowTaskInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowTaskScheduledEvent", arg0, arg1, arg2, arg3, arg4, arg5, arg6)
	ret0, _ := ret[0].(*WorkflowTaskInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateWorkflowTaskScheduledEvent indicates an expected call of ReplicateWorkflowTaskScheduledEvent.
func (mr *MockMutableStateMockRecorder) ReplicateWorkflowTaskScheduledEvent(arg0, arg1, arg2, arg3, arg4, arg5, arg6 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowTaskScheduledEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateWorkflowTaskScheduledEvent), arg0, arg1, arg2, arg3, arg4, arg5, arg6)
}

// ReplicateWorkflowTaskStartedEvent mocks base method.
func (m *MockMutableState) ReplicateWorkflowTaskStartedEvent(arg0 *WorkflowTaskInfo, arg1, arg2, arg3 int64, arg4 string, arg5 time.Time) (*WorkflowTaskInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowTaskStartedEvent", arg0, arg1, arg2, arg3, arg4, arg5)
	ret0, _ := ret[0].(*WorkflowTaskInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateWorkflowTaskStartedEvent indicates an expected call of ReplicateWorkflowTaskStartedEvent.
func (mr *MockMutableStateMockRecorder) ReplicateWorkflowTaskStartedEvent(arg0, arg1, arg2, arg3, arg4, arg5 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowTaskStartedEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateWorkflowTaskStartedEvent), arg0, arg1, arg2, arg3, arg4, arg5)
}

// ReplicateWorkflowTaskTimedOutEvent mocks base method.
func (m *MockMutableState) ReplicateWorkflowTaskTimedOutEvent(arg0 v11.TimeoutType) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowTaskTimedOutEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowTaskTimedOutEvent indicates an expected call of ReplicateWorkflowTaskTimedOutEvent.
func (mr *MockMutableStateMockRecorder) ReplicateWorkflowTaskTimedOutEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowTaskTimedOutEvent", reflect.TypeOf((*MockMutableState)(nil).ReplicateWorkflowTaskTimedOutEvent), arg0)
}

// RetryActivity mocks base method.
func (m *MockMutableState) RetryActivity(ai *v18.ActivityInfo, failure *v12.Failure) (v11.RetryState, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RetryActivity", ai, failure)
	ret0, _ := ret[0].(v11.RetryState)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RetryActivity indicates an expected call of RetryActivity.
func (mr *MockMutableStateMockRecorder) RetryActivity(ai, failure interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RetryActivity", reflect.TypeOf((*MockMutableState)(nil).RetryActivity), ai, failure)
}

// SetCurrentBranchToken mocks base method.
func (m *MockMutableState) SetCurrentBranchToken(branchToken []byte) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetCurrentBranchToken", branchToken)
	ret0, _ := ret[0].(error)
	return ret0
}

// SetCurrentBranchToken indicates an expected call of SetCurrentBranchToken.
func (mr *MockMutableStateMockRecorder) SetCurrentBranchToken(branchToken interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetCurrentBranchToken", reflect.TypeOf((*MockMutableState)(nil).SetCurrentBranchToken), branchToken)
}

// SetHistoryBuilder mocks base method.
func (m *MockMutableState) SetHistoryBuilder(hBuilder *HistoryBuilder) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetHistoryBuilder", hBuilder)
}

// SetHistoryBuilder indicates an expected call of SetHistoryBuilder.
func (mr *MockMutableStateMockRecorder) SetHistoryBuilder(hBuilder interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHistoryBuilder", reflect.TypeOf((*MockMutableState)(nil).SetHistoryBuilder), hBuilder)
}

// SetHistoryTree mocks base method.
func (m *MockMutableState) SetHistoryTree(treeID string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetHistoryTree", treeID)
	ret0, _ := ret[0].(error)
	return ret0
}

// SetHistoryTree indicates an expected call of SetHistoryTree.
func (mr *MockMutableStateMockRecorder) SetHistoryTree(treeID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHistoryTree", reflect.TypeOf((*MockMutableState)(nil).SetHistoryTree), treeID)
}

// SetUpdateCondition mocks base method.
func (m *MockMutableState) SetUpdateCondition(arg0, arg1 int64) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetUpdateCondition", arg0, arg1)
}

// SetUpdateCondition indicates an expected call of SetUpdateCondition.
func (mr *MockMutableStateMockRecorder) SetUpdateCondition(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetUpdateCondition", reflect.TypeOf((*MockMutableState)(nil).SetUpdateCondition), arg0, arg1)
}

// StartTransaction mocks base method.
func (m *MockMutableState) StartTransaction(entry *cache.NamespaceCacheEntry) (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartTransaction", entry)
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartTransaction indicates an expected call of StartTransaction.
func (mr *MockMutableStateMockRecorder) StartTransaction(entry interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartTransaction", reflect.TypeOf((*MockMutableState)(nil).StartTransaction), entry)
}

// StartTransactionSkipWorkflowTaskFail mocks base method.
func (m *MockMutableState) StartTransactionSkipWorkflowTaskFail(entry *cache.NamespaceCacheEntry) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartTransactionSkipWorkflowTaskFail", entry)
	ret0, _ := ret[0].(error)
	return ret0
}

// StartTransactionSkipWorkflowTaskFail indicates an expected call of StartTransactionSkipWorkflowTaskFail.
func (mr *MockMutableStateMockRecorder) StartTransactionSkipWorkflowTaskFail(entry interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartTransactionSkipWorkflowTaskFail", reflect.TypeOf((*MockMutableState)(nil).StartTransactionSkipWorkflowTaskFail), entry)
}

// UpdateActivity mocks base method.
func (m *MockMutableState) UpdateActivity(arg0 *v18.ActivityInfo) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateActivity", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateActivity indicates an expected call of UpdateActivity.
func (mr *MockMutableStateMockRecorder) UpdateActivity(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateActivity", reflect.TypeOf((*MockMutableState)(nil).UpdateActivity), arg0)
}

// UpdateActivityProgress mocks base method.
func (m *MockMutableState) UpdateActivityProgress(ai *v18.ActivityInfo, request *v15.RecordActivityTaskHeartbeatRequest) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "UpdateActivityProgress", ai, request)
}

// UpdateActivityProgress indicates an expected call of UpdateActivityProgress.
func (mr *MockMutableStateMockRecorder) UpdateActivityProgress(ai, request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateActivityProgress", reflect.TypeOf((*MockMutableState)(nil).UpdateActivityProgress), ai, request)
}

// UpdateActivityWithTimerHeartbeat mocks base method.
func (m *MockMutableState) UpdateActivityWithTimerHeartbeat(arg0 *v18.ActivityInfo, arg1 time.Time) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateActivityWithTimerHeartbeat", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateActivityWithTimerHeartbeat indicates an expected call of UpdateActivityWithTimerHeartbeat.
func (mr *MockMutableStateMockRecorder) UpdateActivityWithTimerHeartbeat(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateActivityWithTimerHeartbeat", reflect.TypeOf((*MockMutableState)(nil).UpdateActivityWithTimerHeartbeat), arg0, arg1)
}

// UpdateCurrentVersion mocks base method.
func (m *MockMutableState) UpdateCurrentVersion(version int64, forceUpdate bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateCurrentVersion", version, forceUpdate)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateCurrentVersion indicates an expected call of UpdateCurrentVersion.
func (mr *MockMutableStateMockRecorder) UpdateCurrentVersion(version, forceUpdate interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateCurrentVersion", reflect.TypeOf((*MockMutableState)(nil).UpdateCurrentVersion), version, forceUpdate)
}

// UpdateDuplicatedResource mocks base method.
func (m *MockMutableState) UpdateDuplicatedResource(resourceDedupKey definition.DeduplicationID) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "UpdateDuplicatedResource", resourceDedupKey)
}

// UpdateDuplicatedResource indicates an expected call of UpdateDuplicatedResource.
func (mr *MockMutableStateMockRecorder) UpdateDuplicatedResource(resourceDedupKey interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateDuplicatedResource", reflect.TypeOf((*MockMutableState)(nil).UpdateDuplicatedResource), resourceDedupKey)
}

// UpdateUserTimer mocks base method.
func (m *MockMutableState) UpdateUserTimer(arg0 *v18.TimerInfo) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateUserTimer", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateUserTimer indicates an expected call of UpdateUserTimer.
func (mr *MockMutableStateMockRecorder) UpdateUserTimer(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateUserTimer", reflect.TypeOf((*MockMutableState)(nil).UpdateUserTimer), arg0)
}

// UpdateWorkflowStateStatus mocks base method.
func (m *MockMutableState) UpdateWorkflowStateStatus(state v16.WorkflowExecutionState, status v11.WorkflowExecutionStatus) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateWorkflowStateStatus", state, status)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateWorkflowStateStatus indicates an expected call of UpdateWorkflowStateStatus.
func (mr *MockMutableStateMockRecorder) UpdateWorkflowStateStatus(state, status interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateWorkflowStateStatus", reflect.TypeOf((*MockMutableState)(nil).UpdateWorkflowStateStatus), state, status)
}

// UpdateWorkflowTask mocks base method.
func (m *MockMutableState) UpdateWorkflowTask(arg0 *WorkflowTaskInfo) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "UpdateWorkflowTask", arg0)
}

// UpdateWorkflowTask indicates an expected call of UpdateWorkflowTask.
func (mr *MockMutableStateMockRecorder) UpdateWorkflowTask(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateWorkflowTask", reflect.TypeOf((*MockMutableState)(nil).UpdateWorkflowTask), arg0)
}
