// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by MockGen. DO NOT EDIT.
// Source: persistenceInterface.go

// Package mock is a generated GoMock package.
package mock

import (
	reflect "reflect"

	gomock "github.com/golang/mock/gomock"
	common "go.temporal.io/api/common/v1"
	persistence "go.temporal.io/server/common/persistence"
)

// MockShardStore is a mock of ShardStore interface.
type MockShardStore struct {
	ctrl     *gomock.Controller
	recorder *MockShardStoreMockRecorder
}

// MockShardStoreMockRecorder is the mock recorder for MockShardStore.
type MockShardStoreMockRecorder struct {
	mock *MockShardStore
}

// NewMockShardStore creates a new mock instance.
func NewMockShardStore(ctrl *gomock.Controller) *MockShardStore {
	mock := &MockShardStore{ctrl: ctrl}
	mock.recorder = &MockShardStoreMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockShardStore) EXPECT() *MockShardStoreMockRecorder {
	return m.recorder
}

// Close mocks base method.
func (m *MockShardStore) Close() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close")
}

// Close indicates an expected call of Close.
func (mr *MockShardStoreMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockShardStore)(nil).Close))
}

// CreateShard mocks base method.
func (m *MockShardStore) CreateShard(request *persistence.InternalCreateShardRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateShard", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// CreateShard indicates an expected call of CreateShard.
func (mr *MockShardStoreMockRecorder) CreateShard(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateShard", reflect.TypeOf((*MockShardStore)(nil).CreateShard), request)
}

// GetClusterName mocks base method.
func (m *MockShardStore) GetClusterName() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetClusterName")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetClusterName indicates an expected call of GetClusterName.
func (mr *MockShardStoreMockRecorder) GetClusterName() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetClusterName", reflect.TypeOf((*MockShardStore)(nil).GetClusterName))
}

// GetName mocks base method.
func (m *MockShardStore) GetName() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetName")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetName indicates an expected call of GetName.
func (mr *MockShardStoreMockRecorder) GetName() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetName", reflect.TypeOf((*MockShardStore)(nil).GetName))
}

// GetShard mocks base method.
func (m *MockShardStore) GetShard(request *persistence.InternalGetShardRequest) (*persistence.InternalGetShardResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetShard", request)
	ret0, _ := ret[0].(*persistence.InternalGetShardResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetShard indicates an expected call of GetShard.
func (mr *MockShardStoreMockRecorder) GetShard(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetShard", reflect.TypeOf((*MockShardStore)(nil).GetShard), request)
}

// UpdateShard mocks base method.
func (m *MockShardStore) UpdateShard(request *persistence.InternalUpdateShardRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateShard", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateShard indicates an expected call of UpdateShard.
func (mr *MockShardStoreMockRecorder) UpdateShard(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateShard", reflect.TypeOf((*MockShardStore)(nil).UpdateShard), request)
}

// MockTaskStore is a mock of TaskStore interface.
type MockTaskStore struct {
	ctrl     *gomock.Controller
	recorder *MockTaskStoreMockRecorder
}

// MockTaskStoreMockRecorder is the mock recorder for MockTaskStore.
type MockTaskStoreMockRecorder struct {
	mock *MockTaskStore
}

// NewMockTaskStore creates a new mock instance.
func NewMockTaskStore(ctrl *gomock.Controller) *MockTaskStore {
	mock := &MockTaskStore{ctrl: ctrl}
	mock.recorder = &MockTaskStoreMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockTaskStore) EXPECT() *MockTaskStoreMockRecorder {
	return m.recorder
}

// Close mocks base method.
func (m *MockTaskStore) Close() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close")
}

// Close indicates an expected call of Close.
func (mr *MockTaskStoreMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockTaskStore)(nil).Close))
}

// CompleteTask mocks base method.
func (m *MockTaskStore) CompleteTask(request *persistence.CompleteTaskRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CompleteTask", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// CompleteTask indicates an expected call of CompleteTask.
func (mr *MockTaskStoreMockRecorder) CompleteTask(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CompleteTask", reflect.TypeOf((*MockTaskStore)(nil).CompleteTask), request)
}

// CompleteTasksLessThan mocks base method.
func (m *MockTaskStore) CompleteTasksLessThan(request *persistence.CompleteTasksLessThanRequest) (int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CompleteTasksLessThan", request)
	ret0, _ := ret[0].(int)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CompleteTasksLessThan indicates an expected call of CompleteTasksLessThan.
func (mr *MockTaskStoreMockRecorder) CompleteTasksLessThan(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CompleteTasksLessThan", reflect.TypeOf((*MockTaskStore)(nil).CompleteTasksLessThan), request)
}

// CreateTaskQueue mocks base method.
func (m *MockTaskStore) CreateTaskQueue(request *persistence.InternalCreateTaskQueueRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTaskQueue", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// CreateTaskQueue indicates an expected call of CreateTaskQueue.
func (mr *MockTaskStoreMockRecorder) CreateTaskQueue(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTaskQueue", reflect.TypeOf((*MockTaskStore)(nil).CreateTaskQueue), request)
}

// CreateTasks mocks base method.
func (m *MockTaskStore) CreateTasks(request *persistence.InternalCreateTasksRequest) (*persistence.CreateTasksResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTasks", request)
	ret0, _ := ret[0].(*persistence.CreateTasksResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTasks indicates an expected call of CreateTasks.
func (mr *MockTaskStoreMockRecorder) CreateTasks(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTasks", reflect.TypeOf((*MockTaskStore)(nil).CreateTasks), request)
}

// DeleteTaskQueue mocks base method.
func (m *MockTaskStore) DeleteTaskQueue(request *persistence.DeleteTaskQueueRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTaskQueue", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteTaskQueue indicates an expected call of DeleteTaskQueue.
func (mr *MockTaskStoreMockRecorder) DeleteTaskQueue(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTaskQueue", reflect.TypeOf((*MockTaskStore)(nil).DeleteTaskQueue), request)
}

// ExtendLease mocks base method.
func (m *MockTaskStore) ExtendLease(request *persistence.InternalExtendLeaseRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ExtendLease", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// ExtendLease indicates an expected call of ExtendLease.
func (mr *MockTaskStoreMockRecorder) ExtendLease(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExtendLease", reflect.TypeOf((*MockTaskStore)(nil).ExtendLease), request)
}

// GetName mocks base method.
func (m *MockTaskStore) GetName() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetName")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetName indicates an expected call of GetName.
func (mr *MockTaskStoreMockRecorder) GetName() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetName", reflect.TypeOf((*MockTaskStore)(nil).GetName))
}

// GetTaskQueue mocks base method.
func (m *MockTaskStore) GetTaskQueue(request *persistence.InternalGetTaskQueueRequest) (*persistence.InternalGetTaskQueueResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTaskQueue", request)
	ret0, _ := ret[0].(*persistence.InternalGetTaskQueueResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTaskQueue indicates an expected call of GetTaskQueue.
func (mr *MockTaskStoreMockRecorder) GetTaskQueue(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTaskQueue", reflect.TypeOf((*MockTaskStore)(nil).GetTaskQueue), request)
}

// GetTasks mocks base method.
func (m *MockTaskStore) GetTasks(request *persistence.GetTasksRequest) (*persistence.InternalGetTasksResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTasks", request)
	ret0, _ := ret[0].(*persistence.InternalGetTasksResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTasks indicates an expected call of GetTasks.
func (mr *MockTaskStoreMockRecorder) GetTasks(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTasks", reflect.TypeOf((*MockTaskStore)(nil).GetTasks), request)
}

// ListTaskQueue mocks base method.
func (m *MockTaskStore) ListTaskQueue(request *persistence.ListTaskQueueRequest) (*persistence.InternalListTaskQueueResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListTaskQueue", request)
	ret0, _ := ret[0].(*persistence.InternalListTaskQueueResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListTaskQueue indicates an expected call of ListTaskQueue.
func (mr *MockTaskStoreMockRecorder) ListTaskQueue(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTaskQueue", reflect.TypeOf((*MockTaskStore)(nil).ListTaskQueue), request)
}

// UpdateTaskQueue mocks base method.
func (m *MockTaskStore) UpdateTaskQueue(request *persistence.InternalUpdateTaskQueueRequest) (*persistence.UpdateTaskQueueResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateTaskQueue", request)
	ret0, _ := ret[0].(*persistence.UpdateTaskQueueResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateTaskQueue indicates an expected call of UpdateTaskQueue.
func (mr *MockTaskStoreMockRecorder) UpdateTaskQueue(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateTaskQueue", reflect.TypeOf((*MockTaskStore)(nil).UpdateTaskQueue), request)
}

// MockMetadataStore is a mock of MetadataStore interface.
type MockMetadataStore struct {
	ctrl     *gomock.Controller
	recorder *MockMetadataStoreMockRecorder
}

// MockMetadataStoreMockRecorder is the mock recorder for MockMetadataStore.
type MockMetadataStoreMockRecorder struct {
	mock *MockMetadataStore
}

// NewMockMetadataStore creates a new mock instance.
func NewMockMetadataStore(ctrl *gomock.Controller) *MockMetadataStore {
	mock := &MockMetadataStore{ctrl: ctrl}
	mock.recorder = &MockMetadataStoreMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockMetadataStore) EXPECT() *MockMetadataStoreMockRecorder {
	return m.recorder
}

// Close mocks base method.
func (m *MockMetadataStore) Close() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close")
}

// Close indicates an expected call of Close.
func (mr *MockMetadataStoreMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockMetadataStore)(nil).Close))
}

// CreateNamespace mocks base method.
func (m *MockMetadataStore) CreateNamespace(request *persistence.InternalCreateNamespaceRequest) (*persistence.CreateNamespaceResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateNamespace", request)
	ret0, _ := ret[0].(*persistence.CreateNamespaceResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateNamespace indicates an expected call of CreateNamespace.
func (mr *MockMetadataStoreMockRecorder) CreateNamespace(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNamespace", reflect.TypeOf((*MockMetadataStore)(nil).CreateNamespace), request)
}

// DeleteNamespace mocks base method.
func (m *MockMetadataStore) DeleteNamespace(request *persistence.DeleteNamespaceRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteNamespace", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteNamespace indicates an expected call of DeleteNamespace.
func (mr *MockMetadataStoreMockRecorder) DeleteNamespace(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNamespace", reflect.TypeOf((*MockMetadataStore)(nil).DeleteNamespace), request)
}

// DeleteNamespaceByName mocks base method.
func (m *MockMetadataStore) DeleteNamespaceByName(request *persistence.DeleteNamespaceByNameRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteNamespaceByName", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteNamespaceByName indicates an expected call of DeleteNamespaceByName.
func (mr *MockMetadataStoreMockRecorder) DeleteNamespaceByName(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNamespaceByName", reflect.TypeOf((*MockMetadataStore)(nil).DeleteNamespaceByName), request)
}

// GetMetadata mocks base method.
func (m *MockMetadataStore) GetMetadata() (*persistence.GetMetadataResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMetadata")
	ret0, _ := ret[0].(*persistence.GetMetadataResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetMetadata indicates an expected call of GetMetadata.
func (mr *MockMetadataStoreMockRecorder) GetMetadata() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMetadata", reflect.TypeOf((*MockMetadataStore)(nil).GetMetadata))
}

// GetName mocks base method.
func (m *MockMetadataStore) GetName() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetName")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetName indicates an expected call of GetName.
func (mr *MockMetadataStoreMockRecorder) GetName() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetName", reflect.TypeOf((*MockMetadataStore)(nil).GetName))
}

// GetNamespace mocks base method.
func (m *MockMetadataStore) GetNamespace(request *persistence.GetNamespaceRequest) (*persistence.InternalGetNamespaceResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetNamespace", request)
	ret0, _ := ret[0].(*persistence.InternalGetNamespaceResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetNamespace indicates an expected call of GetNamespace.
func (mr *MockMetadataStoreMockRecorder) GetNamespace(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetNamespace", reflect.TypeOf((*MockMetadataStore)(nil).GetNamespace), request)
}

// ListNamespaces mocks base method.
func (m *MockMetadataStore) ListNamespaces(request *persistence.ListNamespacesRequest) (*persistence.InternalListNamespacesResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListNamespaces", request)
	ret0, _ := ret[0].(*persistence.InternalListNamespacesResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListNamespaces indicates an expected call of ListNamespaces.
func (mr *MockMetadataStoreMockRecorder) ListNamespaces(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListNamespaces", reflect.TypeOf((*MockMetadataStore)(nil).ListNamespaces), request)
}

// UpdateNamespace mocks base method.
func (m *MockMetadataStore) UpdateNamespace(request *persistence.InternalUpdateNamespaceRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateNamespace", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateNamespace indicates an expected call of UpdateNamespace.
func (mr *MockMetadataStoreMockRecorder) UpdateNamespace(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateNamespace", reflect.TypeOf((*MockMetadataStore)(nil).UpdateNamespace), request)
}

// MockClusterMetadataStore is a mock of ClusterMetadataStore interface.
type MockClusterMetadataStore struct {
	ctrl     *gomock.Controller
	recorder *MockClusterMetadataStoreMockRecorder
}

// MockClusterMetadataStoreMockRecorder is the mock recorder for MockClusterMetadataStore.
type MockClusterMetadataStoreMockRecorder struct {
	mock *MockClusterMetadataStore
}

// NewMockClusterMetadataStore creates a new mock instance.
func NewMockClusterMetadataStore(ctrl *gomock.Controller) *MockClusterMetadataStore {
	mock := &MockClusterMetadataStore{ctrl: ctrl}
	mock.recorder = &MockClusterMetadataStoreMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockClusterMetadataStore) EXPECT() *MockClusterMetadataStoreMockRecorder {
	return m.recorder
}

// Close mocks base method.
func (m *MockClusterMetadataStore) Close() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close")
}

// Close indicates an expected call of Close.
func (mr *MockClusterMetadataStoreMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockClusterMetadataStore)(nil).Close))
}

// GetClusterMembers mocks base method.
func (m *MockClusterMetadataStore) GetClusterMembers(request *persistence.GetClusterMembersRequest) (*persistence.GetClusterMembersResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetClusterMembers", request)
	ret0, _ := ret[0].(*persistence.GetClusterMembersResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetClusterMembers indicates an expected call of GetClusterMembers.
func (mr *MockClusterMetadataStoreMockRecorder) GetClusterMembers(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetClusterMembers", reflect.TypeOf((*MockClusterMetadataStore)(nil).GetClusterMembers), request)
}

// GetClusterMetadata mocks base method.
func (m *MockClusterMetadataStore) GetClusterMetadata() (*persistence.InternalGetClusterMetadataResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetClusterMetadata")
	ret0, _ := ret[0].(*persistence.InternalGetClusterMetadataResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetClusterMetadata indicates an expected call of GetClusterMetadata.
func (mr *MockClusterMetadataStoreMockRecorder) GetClusterMetadata() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetClusterMetadata", reflect.TypeOf((*MockClusterMetadataStore)(nil).GetClusterMetadata))
}

// GetName mocks base method.
func (m *MockClusterMetadataStore) GetName() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetName")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetName indicates an expected call of GetName.
func (mr *MockClusterMetadataStoreMockRecorder) GetName() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetName", reflect.TypeOf((*MockClusterMetadataStore)(nil).GetName))
}

// PruneClusterMembership mocks base method.
func (m *MockClusterMetadataStore) PruneClusterMembership(request *persistence.PruneClusterMembershipRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PruneClusterMembership", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// PruneClusterMembership indicates an expected call of PruneClusterMembership.
func (mr *MockClusterMetadataStoreMockRecorder) PruneClusterMembership(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PruneClusterMembership", reflect.TypeOf((*MockClusterMetadataStore)(nil).PruneClusterMembership), request)
}

// SaveClusterMetadata mocks base method.
func (m *MockClusterMetadataStore) SaveClusterMetadata(request *persistence.InternalSaveClusterMetadataRequest) (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SaveClusterMetadata", request)
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SaveClusterMetadata indicates an expected call of SaveClusterMetadata.
func (mr *MockClusterMetadataStoreMockRecorder) SaveClusterMetadata(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SaveClusterMetadata", reflect.TypeOf((*MockClusterMetadataStore)(nil).SaveClusterMetadata), request)
}

// UpsertClusterMembership mocks base method.
func (m *MockClusterMetadataStore) UpsertClusterMembership(request *persistence.UpsertClusterMembershipRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpsertClusterMembership", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpsertClusterMembership indicates an expected call of UpsertClusterMembership.
func (mr *MockClusterMetadataStoreMockRecorder) UpsertClusterMembership(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpsertClusterMembership", reflect.TypeOf((*MockClusterMetadataStore)(nil).UpsertClusterMembership), request)
}

// MockExecutionStore is a mock of ExecutionStore interface.
type MockExecutionStore struct {
	ctrl     *gomock.Controller
	recorder *MockExecutionStoreMockRecorder
}

// MockExecutionStoreMockRecorder is the mock recorder for MockExecutionStore.
type MockExecutionStoreMockRecorder struct {
	mock *MockExecutionStore
}

// NewMockExecutionStore creates a new mock instance.
func NewMockExecutionStore(ctrl *gomock.Controller) *MockExecutionStore {
	mock := &MockExecutionStore{ctrl: ctrl}
	mock.recorder = &MockExecutionStoreMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockExecutionStore) EXPECT() *MockExecutionStoreMockRecorder {
	return m.recorder
}

// AddTasks mocks base method.
func (m *MockExecutionStore) AddTasks(request *persistence.AddTasksRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddTasks", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// AddTasks indicates an expected call of AddTasks.
func (mr *MockExecutionStoreMockRecorder) AddTasks(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTasks", reflect.TypeOf((*MockExecutionStore)(nil).AddTasks), request)
}

// Close mocks base method.
func (m *MockExecutionStore) Close() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close")
}

// Close indicates an expected call of Close.
func (mr *MockExecutionStoreMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockExecutionStore)(nil).Close))
}

// CompleteReplicationTask mocks base method.
func (m *MockExecutionStore) CompleteReplicationTask(request *persistence.CompleteReplicationTaskRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CompleteReplicationTask", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// CompleteReplicationTask indicates an expected call of CompleteReplicationTask.
func (mr *MockExecutionStoreMockRecorder) CompleteReplicationTask(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CompleteReplicationTask", reflect.TypeOf((*MockExecutionStore)(nil).CompleteReplicationTask), request)
}

// CompleteTimerTask mocks base method.
func (m *MockExecutionStore) CompleteTimerTask(request *persistence.CompleteTimerTaskRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CompleteTimerTask", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// CompleteTimerTask indicates an expected call of CompleteTimerTask.
func (mr *MockExecutionStoreMockRecorder) CompleteTimerTask(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CompleteTimerTask", reflect.TypeOf((*MockExecutionStore)(nil).CompleteTimerTask), request)
}

// CompleteTransferTask mocks base method.
func (m *MockExecutionStore) CompleteTransferTask(request *persistence.CompleteTransferTaskRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CompleteTransferTask", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// CompleteTransferTask indicates an expected call of CompleteTransferTask.
func (mr *MockExecutionStoreMockRecorder) CompleteTransferTask(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CompleteTransferTask", reflect.TypeOf((*MockExecutionStore)(nil).CompleteTransferTask), request)
}

// CompleteVisibilityTask mocks base method.
func (m *MockExecutionStore) CompleteVisibilityTask(request *persistence.CompleteVisibilityTaskRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CompleteVisibilityTask", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// CompleteVisibilityTask indicates an expected call of CompleteVisibilityTask.
func (mr *MockExecutionStoreMockRecorder) CompleteVisibilityTask(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CompleteVisibilityTask", reflect.TypeOf((*MockExecutionStore)(nil).CompleteVisibilityTask), request)
}

// ConflictResolveWorkflowExecution mocks base method.
func (m *MockExecutionStore) ConflictResolveWorkflowExecution(request *persistence.InternalConflictResolveWorkflowExecutionRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ConflictResolveWorkflowExecution", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// ConflictResolveWorkflowExecution indicates an expected call of ConflictResolveWorkflowExecution.
func (mr *MockExecutionStoreMockRecorder) ConflictResolveWorkflowExecution(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ConflictResolveWorkflowExecution", reflect.TypeOf((*MockExecutionStore)(nil).ConflictResolveWorkflowExecution), request)
}

// CreateWorkflowExecution mocks base method.
func (m *MockExecutionStore) CreateWorkflowExecution(request *persistence.InternalCreateWorkflowExecutionRequest) (*persistence.CreateWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateWorkflowExecution", request)
	ret0, _ := ret[0].(*persistence.CreateWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateWorkflowExecution indicates an expected call of CreateWorkflowExecution.
func (mr *MockExecutionStoreMockRecorder) CreateWorkflowExecution(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateWorkflowExecution", reflect.TypeOf((*MockExecutionStore)(nil).CreateWorkflowExecution), request)
}

// DeleteCurrentWorkflowExecution mocks base method.
func (m *MockExecutionStore) DeleteCurrentWorkflowExecution(request *persistence.DeleteCurrentWorkflowExecutionRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteCurrentWorkflowExecution", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteCurrentWorkflowExecution indicates an expected call of DeleteCurrentWorkflowExecution.
func (mr *MockExecutionStoreMockRecorder) DeleteCurrentWorkflowExecution(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteCurrentWorkflowExecution", reflect.TypeOf((*MockExecutionStore)(nil).DeleteCurrentWorkflowExecution), request)
}

// DeleteReplicationTaskFromDLQ mocks base method.
func (m *MockExecutionStore) DeleteReplicationTaskFromDLQ(request *persistence.DeleteReplicationTaskFromDLQRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteReplicationTaskFromDLQ", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteReplicationTaskFromDLQ indicates an expected call of DeleteReplicationTaskFromDLQ.
func (mr *MockExecutionStoreMockRecorder) DeleteReplicationTaskFromDLQ(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteReplicationTaskFromDLQ", reflect.TypeOf((*MockExecutionStore)(nil).DeleteReplicationTaskFromDLQ), request)
}

// DeleteWorkflowExecution mocks base method.
func (m *MockExecutionStore) DeleteWorkflowExecution(request *persistence.DeleteWorkflowExecutionRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteWorkflowExecution", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteWorkflowExecution indicates an expected call of DeleteWorkflowExecution.
func (mr *MockExecutionStoreMockRecorder) DeleteWorkflowExecution(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteWorkflowExecution", reflect.TypeOf((*MockExecutionStore)(nil).DeleteWorkflowExecution), request)
}

// GetCurrentExecution mocks base method.
func (m *MockExecutionStore) GetCurrentExecution(request *persistence.GetCurrentExecutionRequest) (*persistence.InternalGetCurrentExecutionResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCurrentExecution", request)
	ret0, _ := ret[0].(*persistence.InternalGetCurrentExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCurrentExecution indicates an expected call of GetCurrentExecution.
func (mr *MockExecutionStoreMockRecorder) GetCurrentExecution(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCurrentExecution", reflect.TypeOf((*MockExecutionStore)(nil).GetCurrentExecution), request)
}

// GetName mocks base method.
func (m *MockExecutionStore) GetName() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetName")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetName indicates an expected call of GetName.
func (mr *MockExecutionStoreMockRecorder) GetName() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetName", reflect.TypeOf((*MockExecutionStore)(nil).GetName))
}

// GetReplicationTask mocks base method.
func (m *MockExecutionStore) GetReplicationTask(request *persistence.GetReplicationTaskRequest) (*persistence.GetReplicationTaskResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetReplicationTask", request)
	ret0, _ := ret[0].(*persistence.GetReplicationTaskResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetReplicationTask indicates an expected call of GetReplicationTask.
func (mr *MockExecutionStoreMockRecorder) GetReplicationTask(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetReplicationTask", reflect.TypeOf((*MockExecutionStore)(nil).GetReplicationTask), request)
}

// GetReplicationTasks mocks base method.
func (m *MockExecutionStore) GetReplicationTasks(request *persistence.GetReplicationTasksRequest) (*persistence.GetReplicationTasksResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetReplicationTasks", request)
	ret0, _ := ret[0].(*persistence.GetReplicationTasksResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetReplicationTasks indicates an expected call of GetReplicationTasks.
func (mr *MockExecutionStoreMockRecorder) GetReplicationTasks(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetReplicationTasks", reflect.TypeOf((*MockExecutionStore)(nil).GetReplicationTasks), request)
}

// GetReplicationTasksFromDLQ mocks base method.
func (m *MockExecutionStore) GetReplicationTasksFromDLQ(request *persistence.GetReplicationTasksFromDLQRequest) (*persistence.GetReplicationTasksFromDLQResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetReplicationTasksFromDLQ", request)
	ret0, _ := ret[0].(*persistence.GetReplicationTasksFromDLQResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetReplicationTasksFromDLQ indicates an expected call of GetReplicationTasksFromDLQ.
func (mr *MockExecutionStoreMockRecorder) GetReplicationTasksFromDLQ(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetReplicationTasksFromDLQ", reflect.TypeOf((*MockExecutionStore)(nil).GetReplicationTasksFromDLQ), request)
}

// GetShardID mocks base method.
func (m *MockExecutionStore) GetShardID() int32 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetShardID")
	ret0, _ := ret[0].(int32)
	return ret0
}

// GetShardID indicates an expected call of GetShardID.
func (mr *MockExecutionStoreMockRecorder) GetShardID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetShardID", reflect.TypeOf((*MockExecutionStore)(nil).GetShardID))
}

// GetTimerIndexTasks mocks base method.
func (m *MockExecutionStore) GetTimerIndexTasks(request *persistence.GetTimerIndexTasksRequest) (*persistence.GetTimerIndexTasksResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTimerIndexTasks", request)
	ret0, _ := ret[0].(*persistence.GetTimerIndexTasksResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTimerIndexTasks indicates an expected call of GetTimerIndexTasks.
func (mr *MockExecutionStoreMockRecorder) GetTimerIndexTasks(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTimerIndexTasks", reflect.TypeOf((*MockExecutionStore)(nil).GetTimerIndexTasks), request)
}

// GetTimerTask mocks base method.
func (m *MockExecutionStore) GetTimerTask(request *persistence.GetTimerTaskRequest) (*persistence.GetTimerTaskResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTimerTask", request)
	ret0, _ := ret[0].(*persistence.GetTimerTaskResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTimerTask indicates an expected call of GetTimerTask.
func (mr *MockExecutionStoreMockRecorder) GetTimerTask(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTimerTask", reflect.TypeOf((*MockExecutionStore)(nil).GetTimerTask), request)
}

// GetTransferTask mocks base method.
func (m *MockExecutionStore) GetTransferTask(request *persistence.GetTransferTaskRequest) (*persistence.GetTransferTaskResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTransferTask", request)
	ret0, _ := ret[0].(*persistence.GetTransferTaskResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTransferTask indicates an expected call of GetTransferTask.
func (mr *MockExecutionStoreMockRecorder) GetTransferTask(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransferTask", reflect.TypeOf((*MockExecutionStore)(nil).GetTransferTask), request)
}

// GetTransferTasks mocks base method.
func (m *MockExecutionStore) GetTransferTasks(request *persistence.GetTransferTasksRequest) (*persistence.GetTransferTasksResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTransferTasks", request)
	ret0, _ := ret[0].(*persistence.GetTransferTasksResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTransferTasks indicates an expected call of GetTransferTasks.
func (mr *MockExecutionStoreMockRecorder) GetTransferTasks(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransferTasks", reflect.TypeOf((*MockExecutionStore)(nil).GetTransferTasks), request)
}

// GetVisibilityTask mocks base method.
func (m *MockExecutionStore) GetVisibilityTask(request *persistence.GetVisibilityTaskRequest) (*persistence.GetVisibilityTaskResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetVisibilityTask", request)
	ret0, _ := ret[0].(*persistence.GetVisibilityTaskResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetVisibilityTask indicates an expected call of GetVisibilityTask.
func (mr *MockExecutionStoreMockRecorder) GetVisibilityTask(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetVisibilityTask", reflect.TypeOf((*MockExecutionStore)(nil).GetVisibilityTask), request)
}

// GetVisibilityTasks mocks base method.
func (m *MockExecutionStore) GetVisibilityTasks(request *persistence.GetVisibilityTasksRequest) (*persistence.GetVisibilityTasksResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetVisibilityTasks", request)
	ret0, _ := ret[0].(*persistence.GetVisibilityTasksResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetVisibilityTasks indicates an expected call of GetVisibilityTasks.
func (mr *MockExecutionStoreMockRecorder) GetVisibilityTasks(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetVisibilityTasks", reflect.TypeOf((*MockExecutionStore)(nil).GetVisibilityTasks), request)
}

// GetWorkflowExecution mocks base method.
func (m *MockExecutionStore) GetWorkflowExecution(request *persistence.GetWorkflowExecutionRequest) (*persistence.InternalGetWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetWorkflowExecution", request)
	ret0, _ := ret[0].(*persistence.InternalGetWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetWorkflowExecution indicates an expected call of GetWorkflowExecution.
func (mr *MockExecutionStoreMockRecorder) GetWorkflowExecution(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetWorkflowExecution", reflect.TypeOf((*MockExecutionStore)(nil).GetWorkflowExecution), request)
}

// ListConcreteExecutions mocks base method.
func (m *MockExecutionStore) ListConcreteExecutions(request *persistence.ListConcreteExecutionsRequest) (*persistence.InternalListConcreteExecutionsResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListConcreteExecutions", request)
	ret0, _ := ret[0].(*persistence.InternalListConcreteExecutionsResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListConcreteExecutions indicates an expected call of ListConcreteExecutions.
func (mr *MockExecutionStoreMockRecorder) ListConcreteExecutions(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListConcreteExecutions", reflect.TypeOf((*MockExecutionStore)(nil).ListConcreteExecutions), request)
}

// PutReplicationTaskToDLQ mocks base method.
func (m *MockExecutionStore) PutReplicationTaskToDLQ(request *persistence.PutReplicationTaskToDLQRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PutReplicationTaskToDLQ", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// PutReplicationTaskToDLQ indicates an expected call of PutReplicationTaskToDLQ.
func (mr *MockExecutionStoreMockRecorder) PutReplicationTaskToDLQ(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutReplicationTaskToDLQ", reflect.TypeOf((*MockExecutionStore)(nil).PutReplicationTaskToDLQ), request)
}

// RangeCompleteReplicationTask mocks base method.
func (m *MockExecutionStore) RangeCompleteReplicationTask(request *persistence.RangeCompleteReplicationTaskRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RangeCompleteReplicationTask", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// RangeCompleteReplicationTask indicates an expected call of RangeCompleteReplicationTask.
func (mr *MockExecutionStoreMockRecorder) RangeCompleteReplicationTask(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RangeCompleteReplicationTask", reflect.TypeOf((*MockExecutionStore)(nil).RangeCompleteReplicationTask), request)
}

// RangeCompleteTimerTask mocks base method.
func (m *MockExecutionStore) RangeCompleteTimerTask(request *persistence.RangeCompleteTimerTaskRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RangeCompleteTimerTask", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// RangeCompleteTimerTask indicates an expected call of RangeCompleteTimerTask.
func (mr *MockExecutionStoreMockRecorder) RangeCompleteTimerTask(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RangeCompleteTimerTask", reflect.TypeOf((*MockExecutionStore)(nil).RangeCompleteTimerTask), request)
}

// RangeCompleteTransferTask mocks base method.
func (m *MockExecutionStore) RangeCompleteTransferTask(request *persistence.RangeCompleteTransferTaskRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RangeCompleteTransferTask", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// RangeCompleteTransferTask indicates an expected call of RangeCompleteTransferTask.
func (mr *MockExecutionStoreMockRecorder) RangeCompleteTransferTask(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RangeCompleteTransferTask", reflect.TypeOf((*MockExecutionStore)(nil).RangeCompleteTransferTask), request)
}

// RangeCompleteVisibilityTask mocks base method.
func (m *MockExecutionStore) RangeCompleteVisibilityTask(request *persistence.RangeCompleteVisibilityTaskRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RangeCompleteVisibilityTask", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// RangeCompleteVisibilityTask indicates an expected call of RangeCompleteVisibilityTask.
func (mr *MockExecutionStoreMockRecorder) RangeCompleteVisibilityTask(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RangeCompleteVisibilityTask", reflect.TypeOf((*MockExecutionStore)(nil).RangeCompleteVisibilityTask), request)
}

// RangeDeleteReplicationTaskFromDLQ mocks base method.
func (m *MockExecutionStore) RangeDeleteReplicationTaskFromDLQ(request *persistence.RangeDeleteReplicationTaskFromDLQRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RangeDeleteReplicationTaskFromDLQ", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// RangeDeleteReplicationTaskFromDLQ indicates an expected call of RangeDeleteReplicationTaskFromDLQ.
func (mr *MockExecutionStoreMockRecorder) RangeDeleteReplicationTaskFromDLQ(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RangeDeleteReplicationTaskFromDLQ", reflect.TypeOf((*MockExecutionStore)(nil).RangeDeleteReplicationTaskFromDLQ), request)
}

// UpdateWorkflowExecution mocks base method.
func (m *MockExecutionStore) UpdateWorkflowExecution(request *persistence.InternalUpdateWorkflowExecutionRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateWorkflowExecution", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateWorkflowExecution indicates an expected call of UpdateWorkflowExecution.
func (mr *MockExecutionStoreMockRecorder) UpdateWorkflowExecution(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateWorkflowExecution", reflect.TypeOf((*MockExecutionStore)(nil).UpdateWorkflowExecution), request)
}

// MockHistoryStore is a mock of HistoryStore interface.
type MockHistoryStore struct {
	ctrl     *gomock.Controller
	recorder *MockHistoryStoreMockRecorder
}

// MockHistoryStoreMockRecorder is the mock recorder for MockHistoryStore.
type MockHistoryStoreMockRecorder struct {
	mock *MockHistoryStore
}

// NewMockHistoryStore creates a new mock instance.
func NewMockHistoryStore(ctrl *gomock.Controller) *MockHistoryStore {
	mock := &MockHistoryStore{ctrl: ctrl}
	mock.recorder = &MockHistoryStoreMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockHistoryStore) EXPECT() *MockHistoryStoreMockRecorder {
	return m.recorder
}

// AppendHistoryNodes mocks base method.
func (m *MockHistoryStore) AppendHistoryNodes(request *persistence.InternalAppendHistoryNodesRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AppendHistoryNodes", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// AppendHistoryNodes indicates an expected call of AppendHistoryNodes.
func (mr *MockHistoryStoreMockRecorder) AppendHistoryNodes(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AppendHistoryNodes", reflect.TypeOf((*MockHistoryStore)(nil).AppendHistoryNodes), request)
}

// Close mocks base method.
func (m *MockHistoryStore) Close() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close")
}

// Close indicates an expected call of Close.
func (mr *MockHistoryStoreMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockHistoryStore)(nil).Close))
}

// DeleteHistoryBranch mocks base method.
func (m *MockHistoryStore) DeleteHistoryBranch(request *persistence.InternalDeleteHistoryBranchRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteHistoryBranch", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteHistoryBranch indicates an expected call of DeleteHistoryBranch.
func (mr *MockHistoryStoreMockRecorder) DeleteHistoryBranch(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteHistoryBranch", reflect.TypeOf((*MockHistoryStore)(nil).DeleteHistoryBranch), request)
}

// DeleteHistoryNodes mocks base method.
func (m *MockHistoryStore) DeleteHistoryNodes(request *persistence.InternalDeleteHistoryNodesRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteHistoryNodes", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteHistoryNodes indicates an expected call of DeleteHistoryNodes.
func (mr *MockHistoryStoreMockRecorder) DeleteHistoryNodes(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteHistoryNodes", reflect.TypeOf((*MockHistoryStore)(nil).DeleteHistoryNodes), request)
}

// ForkHistoryBranch mocks base method.
func (m *MockHistoryStore) ForkHistoryBranch(request *persistence.InternalForkHistoryBranchRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ForkHistoryBranch", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// ForkHistoryBranch indicates an expected call of ForkHistoryBranch.
func (mr *MockHistoryStoreMockRecorder) ForkHistoryBranch(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ForkHistoryBranch", reflect.TypeOf((*MockHistoryStore)(nil).ForkHistoryBranch), request)
}

// GetAllHistoryTreeBranches mocks base method.
func (m *MockHistoryStore) GetAllHistoryTreeBranches(request *persistence.GetAllHistoryTreeBranchesRequest) (*persistence.InternalGetAllHistoryTreeBranchesResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllHistoryTreeBranches", request)
	ret0, _ := ret[0].(*persistence.InternalGetAllHistoryTreeBranchesResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllHistoryTreeBranches indicates an expected call of GetAllHistoryTreeBranches.
func (mr *MockHistoryStoreMockRecorder) GetAllHistoryTreeBranches(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllHistoryTreeBranches", reflect.TypeOf((*MockHistoryStore)(nil).GetAllHistoryTreeBranches), request)
}

// GetHistoryTree mocks base method.
func (m *MockHistoryStore) GetHistoryTree(request *persistence.GetHistoryTreeRequest) (*persistence.InternalGetHistoryTreeResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetHistoryTree", request)
	ret0, _ := ret[0].(*persistence.InternalGetHistoryTreeResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetHistoryTree indicates an expected call of GetHistoryTree.
func (mr *MockHistoryStoreMockRecorder) GetHistoryTree(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetHistoryTree", reflect.TypeOf((*MockHistoryStore)(nil).GetHistoryTree), request)
}

// GetName mocks base method.
func (m *MockHistoryStore) GetName() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetName")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetName indicates an expected call of GetName.
func (mr *MockHistoryStoreMockRecorder) GetName() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetName", reflect.TypeOf((*MockHistoryStore)(nil).GetName))
}

// ReadHistoryBranch mocks base method.
func (m *MockHistoryStore) ReadHistoryBranch(request *persistence.InternalReadHistoryBranchRequest) (*persistence.InternalReadHistoryBranchResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReadHistoryBranch", request)
	ret0, _ := ret[0].(*persistence.InternalReadHistoryBranchResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReadHistoryBranch indicates an expected call of ReadHistoryBranch.
func (mr *MockHistoryStoreMockRecorder) ReadHistoryBranch(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReadHistoryBranch", reflect.TypeOf((*MockHistoryStore)(nil).ReadHistoryBranch), request)
}

// MockVisibilityStore is a mock of VisibilityStore interface.
type MockVisibilityStore struct {
	ctrl     *gomock.Controller
	recorder *MockVisibilityStoreMockRecorder
}

// MockVisibilityStoreMockRecorder is the mock recorder for MockVisibilityStore.
type MockVisibilityStoreMockRecorder struct {
	mock *MockVisibilityStore
}

// NewMockVisibilityStore creates a new mock instance.
func NewMockVisibilityStore(ctrl *gomock.Controller) *MockVisibilityStore {
	mock := &MockVisibilityStore{ctrl: ctrl}
	mock.recorder = &MockVisibilityStoreMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockVisibilityStore) EXPECT() *MockVisibilityStoreMockRecorder {
	return m.recorder
}

// Close mocks base method.
func (m *MockVisibilityStore) Close() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close")
}

// Close indicates an expected call of Close.
func (mr *MockVisibilityStoreMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockVisibilityStore)(nil).Close))
}

// CountWorkflowExecutions mocks base method.
func (m *MockVisibilityStore) CountWorkflowExecutions(request *persistence.CountWorkflowExecutionsRequest) (*persistence.CountWorkflowExecutionsResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CountWorkflowExecutions", request)
	ret0, _ := ret[0].(*persistence.CountWorkflowExecutionsResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CountWorkflowExecutions indicates an expected call of CountWorkflowExecutions.
func (mr *MockVisibilityStoreMockRecorder) CountWorkflowExecutions(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CountWorkflowExecutions", reflect.TypeOf((*MockVisibilityStore)(nil).CountWorkflowExecutions), request)
}

// DeleteWorkflowExecution mocks base method.
func (m *MockVisibilityStore) DeleteWorkflowExecution(request *persistence.VisibilityDeleteWorkflowExecutionRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteWorkflowExecution", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteWorkflowExecution indicates an expected call of DeleteWorkflowExecution.
func (mr *MockVisibilityStoreMockRecorder) DeleteWorkflowExecution(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteWorkflowExecution", reflect.TypeOf((*MockVisibilityStore)(nil).DeleteWorkflowExecution), request)
}

// GetClosedWorkflowExecution mocks base method.
func (m *MockVisibilityStore) GetClosedWorkflowExecution(request *persistence.GetClosedWorkflowExecutionRequest) (*persistence.InternalGetClosedWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetClosedWorkflowExecution", request)
	ret0, _ := ret[0].(*persistence.InternalGetClosedWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetClosedWorkflowExecution indicates an expected call of GetClosedWorkflowExecution.
func (mr *MockVisibilityStoreMockRecorder) GetClosedWorkflowExecution(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetClosedWorkflowExecution", reflect.TypeOf((*MockVisibilityStore)(nil).GetClosedWorkflowExecution), request)
}

// GetName mocks base method.
func (m *MockVisibilityStore) GetName() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetName")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetName indicates an expected call of GetName.
func (mr *MockVisibilityStoreMockRecorder) GetName() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetName", reflect.TypeOf((*MockVisibilityStore)(nil).GetName))
}

// ListClosedWorkflowExecutions mocks base method.
func (m *MockVisibilityStore) ListClosedWorkflowExecutions(request *persistence.ListWorkflowExecutionsRequest) (*persistence.InternalListWorkflowExecutionsResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListClosedWorkflowExecutions", request)
	ret0, _ := ret[0].(*persistence.InternalListWorkflowExecutionsResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListClosedWorkflowExecutions indicates an expected call of ListClosedWorkflowExecutions.
func (mr *MockVisibilityStoreMockRecorder) ListClosedWorkflowExecutions(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListClosedWorkflowExecutions", reflect.TypeOf((*MockVisibilityStore)(nil).ListClosedWorkflowExecutions), request)
}

// ListClosedWorkflowExecutionsByStatus mocks base method.
func (m *MockVisibilityStore) ListClosedWorkflowExecutionsByStatus(request *persistence.ListClosedWorkflowExecutionsByStatusRequest) (*persistence.InternalListWorkflowExecutionsResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListClosedWorkflowExecutionsByStatus", request)
	ret0, _ := ret[0].(*persistence.InternalListWorkflowExecutionsResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListClosedWorkflowExecutionsByStatus indicates an expected call of ListClosedWorkflowExecutionsByStatus.
func (mr *MockVisibilityStoreMockRecorder) ListClosedWorkflowExecutionsByStatus(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListClosedWorkflowExecutionsByStatus", reflect.TypeOf((*MockVisibilityStore)(nil).ListClosedWorkflowExecutionsByStatus), request)
}

// ListClosedWorkflowExecutionsByType mocks base method.
func (m *MockVisibilityStore) ListClosedWorkflowExecutionsByType(request *persistence.ListWorkflowExecutionsByTypeRequest) (*persistence.InternalListWorkflowExecutionsResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListClosedWorkflowExecutionsByType", request)
	ret0, _ := ret[0].(*persistence.InternalListWorkflowExecutionsResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListClosedWorkflowExecutionsByType indicates an expected call of ListClosedWorkflowExecutionsByType.
func (mr *MockVisibilityStoreMockRecorder) ListClosedWorkflowExecutionsByType(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListClosedWorkflowExecutionsByType", reflect.TypeOf((*MockVisibilityStore)(nil).ListClosedWorkflowExecutionsByType), request)
}

// ListClosedWorkflowExecutionsByWorkflowID mocks base method.
func (m *MockVisibilityStore) ListClosedWorkflowExecutionsByWorkflowID(request *persistence.ListWorkflowExecutionsByWorkflowIDRequest) (*persistence.InternalListWorkflowExecutionsResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListClosedWorkflowExecutionsByWorkflowID", request)
	ret0, _ := ret[0].(*persistence.InternalListWorkflowExecutionsResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListClosedWorkflowExecutionsByWorkflowID indicates an expected call of ListClosedWorkflowExecutionsByWorkflowID.
func (mr *MockVisibilityStoreMockRecorder) ListClosedWorkflowExecutionsByWorkflowID(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListClosedWorkflowExecutionsByWorkflowID", reflect.TypeOf((*MockVisibilityStore)(nil).ListClosedWorkflowExecutionsByWorkflowID), request)
}

// ListOpenWorkflowExecutions mocks base method.
func (m *MockVisibilityStore) ListOpenWorkflowExecutions(request *persistence.ListWorkflowExecutionsRequest) (*persistence.InternalListWorkflowExecutionsResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListOpenWorkflowExecutions", request)
	ret0, _ := ret[0].(*persistence.InternalListWorkflowExecutionsResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListOpenWorkflowExecutions indicates an expected call of ListOpenWorkflowExecutions.
func (mr *MockVisibilityStoreMockRecorder) ListOpenWorkflowExecutions(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListOpenWorkflowExecutions", reflect.TypeOf((*MockVisibilityStore)(nil).ListOpenWorkflowExecutions), request)
}

// ListOpenWorkflowExecutionsByType mocks base method.
func (m *MockVisibilityStore) ListOpenWorkflowExecutionsByType(request *persistence.ListWorkflowExecutionsByTypeRequest) (*persistence.InternalListWorkflowExecutionsResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListOpenWorkflowExecutionsByType", request)
	ret0, _ := ret[0].(*persistence.InternalListWorkflowExecutionsResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListOpenWorkflowExecutionsByType indicates an expected call of ListOpenWorkflowExecutionsByType.
func (mr *MockVisibilityStoreMockRecorder) ListOpenWorkflowExecutionsByType(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListOpenWorkflowExecutionsByType", reflect.TypeOf((*MockVisibilityStore)(nil).ListOpenWorkflowExecutionsByType), request)
}

// ListOpenWorkflowExecutionsByWorkflowID mocks base method.
func (m *MockVisibilityStore) ListOpenWorkflowExecutionsByWorkflowID(request *persistence.ListWorkflowExecutionsByWorkflowIDRequest) (*persistence.InternalListWorkflowExecutionsResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListOpenWorkflowExecutionsByWorkflowID", request)
	ret0, _ := ret[0].(*persistence.InternalListWorkflowExecutionsResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListOpenWorkflowExecutionsByWorkflowID indicates an expected call of ListOpenWorkflowExecutionsByWorkflowID.
func (mr *MockVisibilityStoreMockRecorder) ListOpenWorkflowExecutionsByWorkflowID(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListOpenWorkflowExecutionsByWorkflowID", reflect.TypeOf((*MockVisibilityStore)(nil).ListOpenWorkflowExecutionsByWorkflowID), request)
}

// ListWorkflowExecutions mocks base method.
func (m *MockVisibilityStore) ListWorkflowExecutions(request *persistence.ListWorkflowExecutionsRequestV2) (*persistence.InternalListWorkflowExecutionsResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListWorkflowExecutions", request)
	ret0, _ := ret[0].(*persistence.InternalListWorkflowExecutionsResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListWorkflowExecutions indicates an expected call of ListWorkflowExecutions.
func (mr *MockVisibilityStoreMockRecorder) ListWorkflowExecutions(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListWorkflowExecutions", reflect.TypeOf((*MockVisibilityStore)(nil).ListWorkflowExecutions), request)
}

// RecordWorkflowExecutionClosed mocks base method.
func (m *MockVisibilityStore) RecordWorkflowExecutionClosed(request *persistence.InternalRecordWorkflowExecutionClosedRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RecordWorkflowExecutionClosed", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// RecordWorkflowExecutionClosed indicates an expected call of RecordWorkflowExecutionClosed.
func (mr *MockVisibilityStoreMockRecorder) RecordWorkflowExecutionClosed(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RecordWorkflowExecutionClosed", reflect.TypeOf((*MockVisibilityStore)(nil).RecordWorkflowExecutionClosed), request)
}

// RecordWorkflowExecutionStarted mocks base method.
func (m *MockVisibilityStore) RecordWorkflowExecutionStarted(request *persistence.InternalRecordWorkflowExecutionStartedRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RecordWorkflowExecutionStarted", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// RecordWorkflowExecutionStarted indicates an expected call of RecordWorkflowExecutionStarted.
func (mr *MockVisibilityStoreMockRecorder) RecordWorkflowExecutionStarted(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RecordWorkflowExecutionStarted", reflect.TypeOf((*MockVisibilityStore)(nil).RecordWorkflowExecutionStarted), request)
}

// ScanWorkflowExecutions mocks base method.
func (m *MockVisibilityStore) ScanWorkflowExecutions(request *persistence.ListWorkflowExecutionsRequestV2) (*persistence.InternalListWorkflowExecutionsResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ScanWorkflowExecutions", request)
	ret0, _ := ret[0].(*persistence.InternalListWorkflowExecutionsResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ScanWorkflowExecutions indicates an expected call of ScanWorkflowExecutions.
func (mr *MockVisibilityStoreMockRecorder) ScanWorkflowExecutions(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ScanWorkflowExecutions", reflect.TypeOf((*MockVisibilityStore)(nil).ScanWorkflowExecutions), request)
}

// UpsertWorkflowExecution mocks base method.
func (m *MockVisibilityStore) UpsertWorkflowExecution(request *persistence.InternalUpsertWorkflowExecutionRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpsertWorkflowExecution", request)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpsertWorkflowExecution indicates an expected call of UpsertWorkflowExecution.
func (mr *MockVisibilityStoreMockRecorder) UpsertWorkflowExecution(request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpsertWorkflowExecution", reflect.TypeOf((*MockVisibilityStore)(nil).UpsertWorkflowExecution), request)
}

// MockQueue is a mock of Queue interface.
type MockQueue struct {
	ctrl     *gomock.Controller
	recorder *MockQueueMockRecorder
}

// MockQueueMockRecorder is the mock recorder for MockQueue.
type MockQueueMockRecorder struct {
	mock *MockQueue
}

// NewMockQueue creates a new mock instance.
func NewMockQueue(ctrl *gomock.Controller) *MockQueue {
	mock := &MockQueue{ctrl: ctrl}
	mock.recorder = &MockQueueMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockQueue) EXPECT() *MockQueueMockRecorder {
	return m.recorder
}

// Close mocks base method.
func (m *MockQueue) Close() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close")
}

// Close indicates an expected call of Close.
func (mr *MockQueueMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockQueue)(nil).Close))
}

// DeleteMessageFromDLQ mocks base method.
func (m *MockQueue) DeleteMessageFromDLQ(messageID int64) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteMessageFromDLQ", messageID)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteMessageFromDLQ indicates an expected call of DeleteMessageFromDLQ.
func (mr *MockQueueMockRecorder) DeleteMessageFromDLQ(messageID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteMessageFromDLQ", reflect.TypeOf((*MockQueue)(nil).DeleteMessageFromDLQ), messageID)
}

// DeleteMessagesBefore mocks base method.
func (m *MockQueue) DeleteMessagesBefore(messageID int64) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteMessagesBefore", messageID)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteMessagesBefore indicates an expected call of DeleteMessagesBefore.
func (mr *MockQueueMockRecorder) DeleteMessagesBefore(messageID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteMessagesBefore", reflect.TypeOf((*MockQueue)(nil).DeleteMessagesBefore), messageID)
}

// EnqueueMessage mocks base method.
func (m *MockQueue) EnqueueMessage(blob common.DataBlob) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnqueueMessage", blob)
	ret0, _ := ret[0].(error)
	return ret0
}

// EnqueueMessage indicates an expected call of EnqueueMessage.
func (mr *MockQueueMockRecorder) EnqueueMessage(blob interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnqueueMessage", reflect.TypeOf((*MockQueue)(nil).EnqueueMessage), blob)
}

// EnqueueMessageToDLQ mocks base method.
func (m *MockQueue) EnqueueMessageToDLQ(blob common.DataBlob) (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnqueueMessageToDLQ", blob)
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnqueueMessageToDLQ indicates an expected call of EnqueueMessageToDLQ.
func (mr *MockQueueMockRecorder) EnqueueMessageToDLQ(blob interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnqueueMessageToDLQ", reflect.TypeOf((*MockQueue)(nil).EnqueueMessageToDLQ), blob)
}

// GetAckLevels mocks base method.
func (m *MockQueue) GetAckLevels() (*persistence.InternalQueueMetadata, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAckLevels")
	ret0, _ := ret[0].(*persistence.InternalQueueMetadata)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAckLevels indicates an expected call of GetAckLevels.
func (mr *MockQueueMockRecorder) GetAckLevels() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAckLevels", reflect.TypeOf((*MockQueue)(nil).GetAckLevels))
}

// GetDLQAckLevels mocks base method.
func (m *MockQueue) GetDLQAckLevels() (*persistence.InternalQueueMetadata, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDLQAckLevels")
	ret0, _ := ret[0].(*persistence.InternalQueueMetadata)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDLQAckLevels indicates an expected call of GetDLQAckLevels.
func (mr *MockQueueMockRecorder) GetDLQAckLevels() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDLQAckLevels", reflect.TypeOf((*MockQueue)(nil).GetDLQAckLevels))
}

// Init mocks base method.
func (m *MockQueue) Init(blob *common.DataBlob) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Init", blob)
	ret0, _ := ret[0].(error)
	return ret0
}

// Init indicates an expected call of Init.
func (mr *MockQueueMockRecorder) Init(blob interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Init", reflect.TypeOf((*MockQueue)(nil).Init), blob)
}

// RangeDeleteMessagesFromDLQ mocks base method.
func (m *MockQueue) RangeDeleteMessagesFromDLQ(firstMessageID, lastMessageID int64) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RangeDeleteMessagesFromDLQ", firstMessageID, lastMessageID)
	ret0, _ := ret[0].(error)
	return ret0
}

// RangeDeleteMessagesFromDLQ indicates an expected call of RangeDeleteMessagesFromDLQ.
func (mr *MockQueueMockRecorder) RangeDeleteMessagesFromDLQ(firstMessageID, lastMessageID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RangeDeleteMessagesFromDLQ", reflect.TypeOf((*MockQueue)(nil).RangeDeleteMessagesFromDLQ), firstMessageID, lastMessageID)
}

// ReadMessages mocks base method.
func (m *MockQueue) ReadMessages(lastMessageID int64, maxCount int) ([]*persistence.QueueMessage, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReadMessages", lastMessageID, maxCount)
	ret0, _ := ret[0].([]*persistence.QueueMessage)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReadMessages indicates an expected call of ReadMessages.
func (mr *MockQueueMockRecorder) ReadMessages(lastMessageID, maxCount interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReadMessages", reflect.TypeOf((*MockQueue)(nil).ReadMessages), lastMessageID, maxCount)
}

// ReadMessagesFromDLQ mocks base method.
func (m *MockQueue) ReadMessagesFromDLQ(firstMessageID, lastMessageID int64, pageSize int, pageToken []byte) ([]*persistence.QueueMessage, []byte, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReadMessagesFromDLQ", firstMessageID, lastMessageID, pageSize, pageToken)
	ret0, _ := ret[0].([]*persistence.QueueMessage)
	ret1, _ := ret[1].([]byte)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// ReadMessagesFromDLQ indicates an expected call of ReadMessagesFromDLQ.
func (mr *MockQueueMockRecorder) ReadMessagesFromDLQ(firstMessageID, lastMessageID, pageSize, pageToken interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReadMessagesFromDLQ", reflect.TypeOf((*MockQueue)(nil).ReadMessagesFromDLQ), firstMessageID, lastMessageID, pageSize, pageToken)
}

// UpdateAckLevel mocks base method.
func (m *MockQueue) UpdateAckLevel(metadata *persistence.InternalQueueMetadata) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateAckLevel", metadata)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateAckLevel indicates an expected call of UpdateAckLevel.
func (mr *MockQueueMockRecorder) UpdateAckLevel(metadata interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateAckLevel", reflect.TypeOf((*MockQueue)(nil).UpdateAckLevel), metadata)
}

// UpdateDLQAckLevel mocks base method.
func (m *MockQueue) UpdateDLQAckLevel(metadata *persistence.InternalQueueMetadata) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateDLQAckLevel", metadata)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateDLQAckLevel indicates an expected call of UpdateDLQAckLevel.
func (mr *MockQueueMockRecorder) UpdateDLQAckLevel(metadata interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateDLQAckLevel", reflect.TypeOf((*MockQueue)(nil).UpdateDLQAckLevel), metadata)
}
