// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by MockGen. DO NOT EDIT.
// Source: historyservice/v1/service.pb.go

// Package historyservicemock is a generated GoMock package.
package historyservicemock

import (
	context "context"
	reflect "reflect"

	gomock "github.com/golang/mock/gomock"
	historyservice "go.temporal.io/server/api/historyservice/v1"
	grpc "google.golang.org/grpc"
)

// MockHistoryServiceClient is a mock of HistoryServiceClient interface.
type MockHistoryServiceClient struct {
	ctrl     *gomock.Controller
	recorder *MockHistoryServiceClientMockRecorder
}

// MockHistoryServiceClientMockRecorder is the mock recorder for MockHistoryServiceClient.
type MockHistoryServiceClientMockRecorder struct {
	mock *MockHistoryServiceClient
}

// NewMockHistoryServiceClient creates a new mock instance.
func NewMockHistoryServiceClient(ctrl *gomock.Controller) *MockHistoryServiceClient {
	mock := &MockHistoryServiceClient{ctrl: ctrl}
	mock.recorder = &MockHistoryServiceClientMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockHistoryServiceClient) EXPECT() *MockHistoryServiceClientMockRecorder {
	return m.recorder
}

// StartWorkflowExecution mocks base method.
func (m *MockHistoryServiceClient) StartWorkflowExecution(ctx context.Context, in *historyservice.StartWorkflowExecutionRequest, opts ...grpc.CallOption) (*historyservice.StartWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "StartWorkflowExecution", varargs...)
	ret0, _ := ret[0].(*historyservice.StartWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartWorkflowExecution indicates an expected call of StartWorkflowExecution.
func (mr *MockHistoryServiceClientMockRecorder) StartWorkflowExecution(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartWorkflowExecution", reflect.TypeOf((*MockHistoryServiceClient)(nil).StartWorkflowExecution), varargs...)
}

// GetMutableState mocks base method.
func (m *MockHistoryServiceClient) GetMutableState(ctx context.Context, in *historyservice.GetMutableStateRequest, opts ...grpc.CallOption) (*historyservice.GetMutableStateResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetMutableState", varargs...)
	ret0, _ := ret[0].(*historyservice.GetMutableStateResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetMutableState indicates an expected call of GetMutableState.
func (mr *MockHistoryServiceClientMockRecorder) GetMutableState(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMutableState", reflect.TypeOf((*MockHistoryServiceClient)(nil).GetMutableState), varargs...)
}

// PollMutableState mocks base method.
func (m *MockHistoryServiceClient) PollMutableState(ctx context.Context, in *historyservice.PollMutableStateRequest, opts ...grpc.CallOption) (*historyservice.PollMutableStateResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "PollMutableState", varargs...)
	ret0, _ := ret[0].(*historyservice.PollMutableStateResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PollMutableState indicates an expected call of PollMutableState.
func (mr *MockHistoryServiceClientMockRecorder) PollMutableState(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PollMutableState", reflect.TypeOf((*MockHistoryServiceClient)(nil).PollMutableState), varargs...)
}

// ResetStickyTaskQueue mocks base method.
func (m *MockHistoryServiceClient) ResetStickyTaskQueue(ctx context.Context, in *historyservice.ResetStickyTaskQueueRequest, opts ...grpc.CallOption) (*historyservice.ResetStickyTaskQueueResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ResetStickyTaskQueue", varargs...)
	ret0, _ := ret[0].(*historyservice.ResetStickyTaskQueueResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ResetStickyTaskQueue indicates an expected call of ResetStickyTaskQueue.
func (mr *MockHistoryServiceClientMockRecorder) ResetStickyTaskQueue(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ResetStickyTaskQueue", reflect.TypeOf((*MockHistoryServiceClient)(nil).ResetStickyTaskQueue), varargs...)
}

// RecordWorkflowTaskStarted mocks base method.
func (m *MockHistoryServiceClient) RecordWorkflowTaskStarted(ctx context.Context, in *historyservice.RecordWorkflowTaskStartedRequest, opts ...grpc.CallOption) (*historyservice.RecordWorkflowTaskStartedResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RecordWorkflowTaskStarted", varargs...)
	ret0, _ := ret[0].(*historyservice.RecordWorkflowTaskStartedResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RecordWorkflowTaskStarted indicates an expected call of RecordWorkflowTaskStarted.
func (mr *MockHistoryServiceClientMockRecorder) RecordWorkflowTaskStarted(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RecordWorkflowTaskStarted", reflect.TypeOf((*MockHistoryServiceClient)(nil).RecordWorkflowTaskStarted), varargs...)
}

// RecordActivityTaskStarted mocks base method.
func (m *MockHistoryServiceClient) RecordActivityTaskStarted(ctx context.Context, in *historyservice.RecordActivityTaskStartedRequest, opts ...grpc.CallOption) (*historyservice.RecordActivityTaskStartedResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RecordActivityTaskStarted", varargs...)
	ret0, _ := ret[0].(*historyservice.RecordActivityTaskStartedResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RecordActivityTaskStarted indicates an expected call of RecordActivityTaskStarted.
func (mr *MockHistoryServiceClientMockRecorder) RecordActivityTaskStarted(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RecordActivityTaskStarted", reflect.TypeOf((*MockHistoryServiceClient)(nil).RecordActivityTaskStarted), varargs...)
}

// RespondWorkflowTaskCompleted mocks base method.
func (m *MockHistoryServiceClient) RespondWorkflowTaskCompleted(ctx context.Context, in *historyservice.RespondWorkflowTaskCompletedRequest, opts ...grpc.CallOption) (*historyservice.RespondWorkflowTaskCompletedResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RespondWorkflowTaskCompleted", varargs...)
	ret0, _ := ret[0].(*historyservice.RespondWorkflowTaskCompletedResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RespondWorkflowTaskCompleted indicates an expected call of RespondWorkflowTaskCompleted.
func (mr *MockHistoryServiceClientMockRecorder) RespondWorkflowTaskCompleted(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RespondWorkflowTaskCompleted", reflect.TypeOf((*MockHistoryServiceClient)(nil).RespondWorkflowTaskCompleted), varargs...)
}

// RespondWorkflowTaskFailed mocks base method.
func (m *MockHistoryServiceClient) RespondWorkflowTaskFailed(ctx context.Context, in *historyservice.RespondWorkflowTaskFailedRequest, opts ...grpc.CallOption) (*historyservice.RespondWorkflowTaskFailedResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RespondWorkflowTaskFailed", varargs...)
	ret0, _ := ret[0].(*historyservice.RespondWorkflowTaskFailedResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RespondWorkflowTaskFailed indicates an expected call of RespondWorkflowTaskFailed.
func (mr *MockHistoryServiceClientMockRecorder) RespondWorkflowTaskFailed(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RespondWorkflowTaskFailed", reflect.TypeOf((*MockHistoryServiceClient)(nil).RespondWorkflowTaskFailed), varargs...)
}

// RecordActivityTaskHeartbeat mocks base method.
func (m *MockHistoryServiceClient) RecordActivityTaskHeartbeat(ctx context.Context, in *historyservice.RecordActivityTaskHeartbeatRequest, opts ...grpc.CallOption) (*historyservice.RecordActivityTaskHeartbeatResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RecordActivityTaskHeartbeat", varargs...)
	ret0, _ := ret[0].(*historyservice.RecordActivityTaskHeartbeatResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RecordActivityTaskHeartbeat indicates an expected call of RecordActivityTaskHeartbeat.
func (mr *MockHistoryServiceClientMockRecorder) RecordActivityTaskHeartbeat(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RecordActivityTaskHeartbeat", reflect.TypeOf((*MockHistoryServiceClient)(nil).RecordActivityTaskHeartbeat), varargs...)
}

// RespondActivityTaskCompleted mocks base method.
func (m *MockHistoryServiceClient) RespondActivityTaskCompleted(ctx context.Context, in *historyservice.RespondActivityTaskCompletedRequest, opts ...grpc.CallOption) (*historyservice.RespondActivityTaskCompletedResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RespondActivityTaskCompleted", varargs...)
	ret0, _ := ret[0].(*historyservice.RespondActivityTaskCompletedResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RespondActivityTaskCompleted indicates an expected call of RespondActivityTaskCompleted.
func (mr *MockHistoryServiceClientMockRecorder) RespondActivityTaskCompleted(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RespondActivityTaskCompleted", reflect.TypeOf((*MockHistoryServiceClient)(nil).RespondActivityTaskCompleted), varargs...)
}

// RespondActivityTaskFailed mocks base method.
func (m *MockHistoryServiceClient) RespondActivityTaskFailed(ctx context.Context, in *historyservice.RespondActivityTaskFailedRequest, opts ...grpc.CallOption) (*historyservice.RespondActivityTaskFailedResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RespondActivityTaskFailed", varargs...)
	ret0, _ := ret[0].(*historyservice.RespondActivityTaskFailedResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RespondActivityTaskFailed indicates an expected call of RespondActivityTaskFailed.
func (mr *MockHistoryServiceClientMockRecorder) RespondActivityTaskFailed(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RespondActivityTaskFailed", reflect.TypeOf((*MockHistoryServiceClient)(nil).RespondActivityTaskFailed), varargs...)
}

// RespondActivityTaskCanceled mocks base method.
func (m *MockHistoryServiceClient) RespondActivityTaskCanceled(ctx context.Context, in *historyservice.RespondActivityTaskCanceledRequest, opts ...grpc.CallOption) (*historyservice.RespondActivityTaskCanceledResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RespondActivityTaskCanceled", varargs...)
	ret0, _ := ret[0].(*historyservice.RespondActivityTaskCanceledResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RespondActivityTaskCanceled indicates an expected call of RespondActivityTaskCanceled.
func (mr *MockHistoryServiceClientMockRecorder) RespondActivityTaskCanceled(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RespondActivityTaskCanceled", reflect.TypeOf((*MockHistoryServiceClient)(nil).RespondActivityTaskCanceled), varargs...)
}

// SignalWorkflowExecution mocks base method.
func (m *MockHistoryServiceClient) SignalWorkflowExecution(ctx context.Context, in *historyservice.SignalWorkflowExecutionRequest, opts ...grpc.CallOption) (*historyservice.SignalWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SignalWorkflowExecution", varargs...)
	ret0, _ := ret[0].(*historyservice.SignalWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SignalWorkflowExecution indicates an expected call of SignalWorkflowExecution.
func (mr *MockHistoryServiceClientMockRecorder) SignalWorkflowExecution(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SignalWorkflowExecution", reflect.TypeOf((*MockHistoryServiceClient)(nil).SignalWorkflowExecution), varargs...)
}

// SignalWithStartWorkflowExecution mocks base method.
func (m *MockHistoryServiceClient) SignalWithStartWorkflowExecution(ctx context.Context, in *historyservice.SignalWithStartWorkflowExecutionRequest, opts ...grpc.CallOption) (*historyservice.SignalWithStartWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SignalWithStartWorkflowExecution", varargs...)
	ret0, _ := ret[0].(*historyservice.SignalWithStartWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SignalWithStartWorkflowExecution indicates an expected call of SignalWithStartWorkflowExecution.
func (mr *MockHistoryServiceClientMockRecorder) SignalWithStartWorkflowExecution(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SignalWithStartWorkflowExecution", reflect.TypeOf((*MockHistoryServiceClient)(nil).SignalWithStartWorkflowExecution), varargs...)
}

// RemoveSignalMutableState mocks base method.
func (m *MockHistoryServiceClient) RemoveSignalMutableState(ctx context.Context, in *historyservice.RemoveSignalMutableStateRequest, opts ...grpc.CallOption) (*historyservice.RemoveSignalMutableStateResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RemoveSignalMutableState", varargs...)
	ret0, _ := ret[0].(*historyservice.RemoveSignalMutableStateResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RemoveSignalMutableState indicates an expected call of RemoveSignalMutableState.
func (mr *MockHistoryServiceClientMockRecorder) RemoveSignalMutableState(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RemoveSignalMutableState", reflect.TypeOf((*MockHistoryServiceClient)(nil).RemoveSignalMutableState), varargs...)
}

// TerminateWorkflowExecution mocks base method.
func (m *MockHistoryServiceClient) TerminateWorkflowExecution(ctx context.Context, in *historyservice.TerminateWorkflowExecutionRequest, opts ...grpc.CallOption) (*historyservice.TerminateWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "TerminateWorkflowExecution", varargs...)
	ret0, _ := ret[0].(*historyservice.TerminateWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// TerminateWorkflowExecution indicates an expected call of TerminateWorkflowExecution.
func (mr *MockHistoryServiceClientMockRecorder) TerminateWorkflowExecution(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TerminateWorkflowExecution", reflect.TypeOf((*MockHistoryServiceClient)(nil).TerminateWorkflowExecution), varargs...)
}

// ResetWorkflowExecution mocks base method.
func (m *MockHistoryServiceClient) ResetWorkflowExecution(ctx context.Context, in *historyservice.ResetWorkflowExecutionRequest, opts ...grpc.CallOption) (*historyservice.ResetWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ResetWorkflowExecution", varargs...)
	ret0, _ := ret[0].(*historyservice.ResetWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ResetWorkflowExecution indicates an expected call of ResetWorkflowExecution.
func (mr *MockHistoryServiceClientMockRecorder) ResetWorkflowExecution(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ResetWorkflowExecution", reflect.TypeOf((*MockHistoryServiceClient)(nil).ResetWorkflowExecution), varargs...)
}

// RequestCancelWorkflowExecution mocks base method.
func (m *MockHistoryServiceClient) RequestCancelWorkflowExecution(ctx context.Context, in *historyservice.RequestCancelWorkflowExecutionRequest, opts ...grpc.CallOption) (*historyservice.RequestCancelWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RequestCancelWorkflowExecution", varargs...)
	ret0, _ := ret[0].(*historyservice.RequestCancelWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RequestCancelWorkflowExecution indicates an expected call of RequestCancelWorkflowExecution.
func (mr *MockHistoryServiceClientMockRecorder) RequestCancelWorkflowExecution(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RequestCancelWorkflowExecution", reflect.TypeOf((*MockHistoryServiceClient)(nil).RequestCancelWorkflowExecution), varargs...)
}

// ScheduleWorkflowTask mocks base method.
func (m *MockHistoryServiceClient) ScheduleWorkflowTask(ctx context.Context, in *historyservice.ScheduleWorkflowTaskRequest, opts ...grpc.CallOption) (*historyservice.ScheduleWorkflowTaskResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ScheduleWorkflowTask", varargs...)
	ret0, _ := ret[0].(*historyservice.ScheduleWorkflowTaskResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ScheduleWorkflowTask indicates an expected call of ScheduleWorkflowTask.
func (mr *MockHistoryServiceClientMockRecorder) ScheduleWorkflowTask(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ScheduleWorkflowTask", reflect.TypeOf((*MockHistoryServiceClient)(nil).ScheduleWorkflowTask), varargs...)
}

// RecordChildExecutionCompleted mocks base method.
func (m *MockHistoryServiceClient) RecordChildExecutionCompleted(ctx context.Context, in *historyservice.RecordChildExecutionCompletedRequest, opts ...grpc.CallOption) (*historyservice.RecordChildExecutionCompletedResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RecordChildExecutionCompleted", varargs...)
	ret0, _ := ret[0].(*historyservice.RecordChildExecutionCompletedResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RecordChildExecutionCompleted indicates an expected call of RecordChildExecutionCompleted.
func (mr *MockHistoryServiceClientMockRecorder) RecordChildExecutionCompleted(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RecordChildExecutionCompleted", reflect.TypeOf((*MockHistoryServiceClient)(nil).RecordChildExecutionCompleted), varargs...)
}

// DescribeWorkflowExecution mocks base method.
func (m *MockHistoryServiceClient) DescribeWorkflowExecution(ctx context.Context, in *historyservice.DescribeWorkflowExecutionRequest, opts ...grpc.CallOption) (*historyservice.DescribeWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeWorkflowExecution", varargs...)
	ret0, _ := ret[0].(*historyservice.DescribeWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeWorkflowExecution indicates an expected call of DescribeWorkflowExecution.
func (mr *MockHistoryServiceClientMockRecorder) DescribeWorkflowExecution(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeWorkflowExecution", reflect.TypeOf((*MockHistoryServiceClient)(nil).DescribeWorkflowExecution), varargs...)
}

// ReplicateEventsV2 mocks base method.
func (m *MockHistoryServiceClient) ReplicateEventsV2(ctx context.Context, in *historyservice.ReplicateEventsV2Request, opts ...grpc.CallOption) (*historyservice.ReplicateEventsV2Response, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ReplicateEventsV2", varargs...)
	ret0, _ := ret[0].(*historyservice.ReplicateEventsV2Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateEventsV2 indicates an expected call of ReplicateEventsV2.
func (mr *MockHistoryServiceClientMockRecorder) ReplicateEventsV2(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateEventsV2", reflect.TypeOf((*MockHistoryServiceClient)(nil).ReplicateEventsV2), varargs...)
}

// SyncShardStatus mocks base method.
func (m *MockHistoryServiceClient) SyncShardStatus(ctx context.Context, in *historyservice.SyncShardStatusRequest, opts ...grpc.CallOption) (*historyservice.SyncShardStatusResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SyncShardStatus", varargs...)
	ret0, _ := ret[0].(*historyservice.SyncShardStatusResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SyncShardStatus indicates an expected call of SyncShardStatus.
func (mr *MockHistoryServiceClientMockRecorder) SyncShardStatus(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SyncShardStatus", reflect.TypeOf((*MockHistoryServiceClient)(nil).SyncShardStatus), varargs...)
}

// SyncActivity mocks base method.
func (m *MockHistoryServiceClient) SyncActivity(ctx context.Context, in *historyservice.SyncActivityRequest, opts ...grpc.CallOption) (*historyservice.SyncActivityResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SyncActivity", varargs...)
	ret0, _ := ret[0].(*historyservice.SyncActivityResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SyncActivity indicates an expected call of SyncActivity.
func (mr *MockHistoryServiceClientMockRecorder) SyncActivity(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SyncActivity", reflect.TypeOf((*MockHistoryServiceClient)(nil).SyncActivity), varargs...)
}

// DescribeMutableState mocks base method.
func (m *MockHistoryServiceClient) DescribeMutableState(ctx context.Context, in *historyservice.DescribeMutableStateRequest, opts ...grpc.CallOption) (*historyservice.DescribeMutableStateResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeMutableState", varargs...)
	ret0, _ := ret[0].(*historyservice.DescribeMutableStateResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMutableState indicates an expected call of DescribeMutableState.
func (mr *MockHistoryServiceClientMockRecorder) DescribeMutableState(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMutableState", reflect.TypeOf((*MockHistoryServiceClient)(nil).DescribeMutableState), varargs...)
}

// DescribeHistoryHost mocks base method.
func (m *MockHistoryServiceClient) DescribeHistoryHost(ctx context.Context, in *historyservice.DescribeHistoryHostRequest, opts ...grpc.CallOption) (*historyservice.DescribeHistoryHostResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeHistoryHost", varargs...)
	ret0, _ := ret[0].(*historyservice.DescribeHistoryHostResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeHistoryHost indicates an expected call of DescribeHistoryHost.
func (mr *MockHistoryServiceClientMockRecorder) DescribeHistoryHost(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHistoryHost", reflect.TypeOf((*MockHistoryServiceClient)(nil).DescribeHistoryHost), varargs...)
}

// CloseShard mocks base method.
func (m *MockHistoryServiceClient) CloseShard(ctx context.Context, in *historyservice.CloseShardRequest, opts ...grpc.CallOption) (*historyservice.CloseShardResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CloseShard", varargs...)
	ret0, _ := ret[0].(*historyservice.CloseShardResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CloseShard indicates an expected call of CloseShard.
func (mr *MockHistoryServiceClientMockRecorder) CloseShard(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CloseShard", reflect.TypeOf((*MockHistoryServiceClient)(nil).CloseShard), varargs...)
}

// RemoveTask mocks base method.
func (m *MockHistoryServiceClient) RemoveTask(ctx context.Context, in *historyservice.RemoveTaskRequest, opts ...grpc.CallOption) (*historyservice.RemoveTaskResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RemoveTask", varargs...)
	ret0, _ := ret[0].(*historyservice.RemoveTaskResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RemoveTask indicates an expected call of RemoveTask.
func (mr *MockHistoryServiceClientMockRecorder) RemoveTask(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RemoveTask", reflect.TypeOf((*MockHistoryServiceClient)(nil).RemoveTask), varargs...)
}

// GetReplicationMessages mocks base method.
func (m *MockHistoryServiceClient) GetReplicationMessages(ctx context.Context, in *historyservice.GetReplicationMessagesRequest, opts ...grpc.CallOption) (*historyservice.GetReplicationMessagesResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetReplicationMessages", varargs...)
	ret0, _ := ret[0].(*historyservice.GetReplicationMessagesResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetReplicationMessages indicates an expected call of GetReplicationMessages.
func (mr *MockHistoryServiceClientMockRecorder) GetReplicationMessages(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetReplicationMessages", reflect.TypeOf((*MockHistoryServiceClient)(nil).GetReplicationMessages), varargs...)
}

// GetDLQReplicationMessages mocks base method.
func (m *MockHistoryServiceClient) GetDLQReplicationMessages(ctx context.Context, in *historyservice.GetDLQReplicationMessagesRequest, opts ...grpc.CallOption) (*historyservice.GetDLQReplicationMessagesResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetDLQReplicationMessages", varargs...)
	ret0, _ := ret[0].(*historyservice.GetDLQReplicationMessagesResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDLQReplicationMessages indicates an expected call of GetDLQReplicationMessages.
func (mr *MockHistoryServiceClientMockRecorder) GetDLQReplicationMessages(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDLQReplicationMessages", reflect.TypeOf((*MockHistoryServiceClient)(nil).GetDLQReplicationMessages), varargs...)
}

// QueryWorkflow mocks base method.
func (m *MockHistoryServiceClient) QueryWorkflow(ctx context.Context, in *historyservice.QueryWorkflowRequest, opts ...grpc.CallOption) (*historyservice.QueryWorkflowResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "QueryWorkflow", varargs...)
	ret0, _ := ret[0].(*historyservice.QueryWorkflowResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// QueryWorkflow indicates an expected call of QueryWorkflow.
func (mr *MockHistoryServiceClientMockRecorder) QueryWorkflow(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "QueryWorkflow", reflect.TypeOf((*MockHistoryServiceClient)(nil).QueryWorkflow), varargs...)
}

// ReapplyEvents mocks base method.
func (m *MockHistoryServiceClient) ReapplyEvents(ctx context.Context, in *historyservice.ReapplyEventsRequest, opts ...grpc.CallOption) (*historyservice.ReapplyEventsResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ReapplyEvents", varargs...)
	ret0, _ := ret[0].(*historyservice.ReapplyEventsResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReapplyEvents indicates an expected call of ReapplyEvents.
func (mr *MockHistoryServiceClientMockRecorder) ReapplyEvents(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReapplyEvents", reflect.TypeOf((*MockHistoryServiceClient)(nil).ReapplyEvents), varargs...)
}

// GetDLQMessages mocks base method.
func (m *MockHistoryServiceClient) GetDLQMessages(ctx context.Context, in *historyservice.GetDLQMessagesRequest, opts ...grpc.CallOption) (*historyservice.GetDLQMessagesResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetDLQMessages", varargs...)
	ret0, _ := ret[0].(*historyservice.GetDLQMessagesResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDLQMessages indicates an expected call of GetDLQMessages.
func (mr *MockHistoryServiceClientMockRecorder) GetDLQMessages(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDLQMessages", reflect.TypeOf((*MockHistoryServiceClient)(nil).GetDLQMessages), varargs...)
}

// PurgeDLQMessages mocks base method.
func (m *MockHistoryServiceClient) PurgeDLQMessages(ctx context.Context, in *historyservice.PurgeDLQMessagesRequest, opts ...grpc.CallOption) (*historyservice.PurgeDLQMessagesResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "PurgeDLQMessages", varargs...)
	ret0, _ := ret[0].(*historyservice.PurgeDLQMessagesResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PurgeDLQMessages indicates an expected call of PurgeDLQMessages.
func (mr *MockHistoryServiceClientMockRecorder) PurgeDLQMessages(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PurgeDLQMessages", reflect.TypeOf((*MockHistoryServiceClient)(nil).PurgeDLQMessages), varargs...)
}

// MergeDLQMessages mocks base method.
func (m *MockHistoryServiceClient) MergeDLQMessages(ctx context.Context, in *historyservice.MergeDLQMessagesRequest, opts ...grpc.CallOption) (*historyservice.MergeDLQMessagesResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "MergeDLQMessages", varargs...)
	ret0, _ := ret[0].(*historyservice.MergeDLQMessagesResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// MergeDLQMessages indicates an expected call of MergeDLQMessages.
func (mr *MockHistoryServiceClientMockRecorder) MergeDLQMessages(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MergeDLQMessages", reflect.TypeOf((*MockHistoryServiceClient)(nil).MergeDLQMessages), varargs...)
}

// RefreshWorkflowTasks mocks base method.
func (m *MockHistoryServiceClient) RefreshWorkflowTasks(ctx context.Context, in *historyservice.RefreshWorkflowTasksRequest, opts ...grpc.CallOption) (*historyservice.RefreshWorkflowTasksResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RefreshWorkflowTasks", varargs...)
	ret0, _ := ret[0].(*historyservice.RefreshWorkflowTasksResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RefreshWorkflowTasks indicates an expected call of RefreshWorkflowTasks.
func (mr *MockHistoryServiceClientMockRecorder) RefreshWorkflowTasks(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RefreshWorkflowTasks", reflect.TypeOf((*MockHistoryServiceClient)(nil).RefreshWorkflowTasks), varargs...)
}

// MockHistoryServiceServer is a mock of HistoryServiceServer interface.
type MockHistoryServiceServer struct {
	ctrl     *gomock.Controller
	recorder *MockHistoryServiceServerMockRecorder
}

// MockHistoryServiceServerMockRecorder is the mock recorder for MockHistoryServiceServer.
type MockHistoryServiceServerMockRecorder struct {
	mock *MockHistoryServiceServer
}

// NewMockHistoryServiceServer creates a new mock instance.
func NewMockHistoryServiceServer(ctrl *gomock.Controller) *MockHistoryServiceServer {
	mock := &MockHistoryServiceServer{ctrl: ctrl}
	mock.recorder = &MockHistoryServiceServerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockHistoryServiceServer) EXPECT() *MockHistoryServiceServerMockRecorder {
	return m.recorder
}

// StartWorkflowExecution mocks base method.
func (m *MockHistoryServiceServer) StartWorkflowExecution(arg0 context.Context, arg1 *historyservice.StartWorkflowExecutionRequest) (*historyservice.StartWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartWorkflowExecution", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.StartWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartWorkflowExecution indicates an expected call of StartWorkflowExecution.
func (mr *MockHistoryServiceServerMockRecorder) StartWorkflowExecution(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartWorkflowExecution", reflect.TypeOf((*MockHistoryServiceServer)(nil).StartWorkflowExecution), arg0, arg1)
}

// GetMutableState mocks base method.
func (m *MockHistoryServiceServer) GetMutableState(arg0 context.Context, arg1 *historyservice.GetMutableStateRequest) (*historyservice.GetMutableStateResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMutableState", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.GetMutableStateResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetMutableState indicates an expected call of GetMutableState.
func (mr *MockHistoryServiceServerMockRecorder) GetMutableState(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMutableState", reflect.TypeOf((*MockHistoryServiceServer)(nil).GetMutableState), arg0, arg1)
}

// PollMutableState mocks base method.
func (m *MockHistoryServiceServer) PollMutableState(arg0 context.Context, arg1 *historyservice.PollMutableStateRequest) (*historyservice.PollMutableStateResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PollMutableState", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.PollMutableStateResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PollMutableState indicates an expected call of PollMutableState.
func (mr *MockHistoryServiceServerMockRecorder) PollMutableState(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PollMutableState", reflect.TypeOf((*MockHistoryServiceServer)(nil).PollMutableState), arg0, arg1)
}

// ResetStickyTaskQueue mocks base method.
func (m *MockHistoryServiceServer) ResetStickyTaskQueue(arg0 context.Context, arg1 *historyservice.ResetStickyTaskQueueRequest) (*historyservice.ResetStickyTaskQueueResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ResetStickyTaskQueue", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.ResetStickyTaskQueueResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ResetStickyTaskQueue indicates an expected call of ResetStickyTaskQueue.
func (mr *MockHistoryServiceServerMockRecorder) ResetStickyTaskQueue(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ResetStickyTaskQueue", reflect.TypeOf((*MockHistoryServiceServer)(nil).ResetStickyTaskQueue), arg0, arg1)
}

// RecordWorkflowTaskStarted mocks base method.
func (m *MockHistoryServiceServer) RecordWorkflowTaskStarted(arg0 context.Context, arg1 *historyservice.RecordWorkflowTaskStartedRequest) (*historyservice.RecordWorkflowTaskStartedResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RecordWorkflowTaskStarted", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.RecordWorkflowTaskStartedResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RecordWorkflowTaskStarted indicates an expected call of RecordWorkflowTaskStarted.
func (mr *MockHistoryServiceServerMockRecorder) RecordWorkflowTaskStarted(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RecordWorkflowTaskStarted", reflect.TypeOf((*MockHistoryServiceServer)(nil).RecordWorkflowTaskStarted), arg0, arg1)
}

// RecordActivityTaskStarted mocks base method.
func (m *MockHistoryServiceServer) RecordActivityTaskStarted(arg0 context.Context, arg1 *historyservice.RecordActivityTaskStartedRequest) (*historyservice.RecordActivityTaskStartedResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RecordActivityTaskStarted", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.RecordActivityTaskStartedResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RecordActivityTaskStarted indicates an expected call of RecordActivityTaskStarted.
func (mr *MockHistoryServiceServerMockRecorder) RecordActivityTaskStarted(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RecordActivityTaskStarted", reflect.TypeOf((*MockHistoryServiceServer)(nil).RecordActivityTaskStarted), arg0, arg1)
}

// RespondWorkflowTaskCompleted mocks base method.
func (m *MockHistoryServiceServer) RespondWorkflowTaskCompleted(arg0 context.Context, arg1 *historyservice.RespondWorkflowTaskCompletedRequest) (*historyservice.RespondWorkflowTaskCompletedResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RespondWorkflowTaskCompleted", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.RespondWorkflowTaskCompletedResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RespondWorkflowTaskCompleted indicates an expected call of RespondWorkflowTaskCompleted.
func (mr *MockHistoryServiceServerMockRecorder) RespondWorkflowTaskCompleted(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RespondWorkflowTaskCompleted", reflect.TypeOf((*MockHistoryServiceServer)(nil).RespondWorkflowTaskCompleted), arg0, arg1)
}

// RespondWorkflowTaskFailed mocks base method.
func (m *MockHistoryServiceServer) RespondWorkflowTaskFailed(arg0 context.Context, arg1 *historyservice.RespondWorkflowTaskFailedRequest) (*historyservice.RespondWorkflowTaskFailedResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RespondWorkflowTaskFailed", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.RespondWorkflowTaskFailedResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RespondWorkflowTaskFailed indicates an expected call of RespondWorkflowTaskFailed.
func (mr *MockHistoryServiceServerMockRecorder) RespondWorkflowTaskFailed(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RespondWorkflowTaskFailed", reflect.TypeOf((*MockHistoryServiceServer)(nil).RespondWorkflowTaskFailed), arg0, arg1)
}

// RecordActivityTaskHeartbeat mocks base method.
func (m *MockHistoryServiceServer) RecordActivityTaskHeartbeat(arg0 context.Context, arg1 *historyservice.RecordActivityTaskHeartbeatRequest) (*historyservice.RecordActivityTaskHeartbeatResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RecordActivityTaskHeartbeat", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.RecordActivityTaskHeartbeatResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RecordActivityTaskHeartbeat indicates an expected call of RecordActivityTaskHeartbeat.
func (mr *MockHistoryServiceServerMockRecorder) RecordActivityTaskHeartbeat(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RecordActivityTaskHeartbeat", reflect.TypeOf((*MockHistoryServiceServer)(nil).RecordActivityTaskHeartbeat), arg0, arg1)
}

// RespondActivityTaskCompleted mocks base method.
func (m *MockHistoryServiceServer) RespondActivityTaskCompleted(arg0 context.Context, arg1 *historyservice.RespondActivityTaskCompletedRequest) (*historyservice.RespondActivityTaskCompletedResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RespondActivityTaskCompleted", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.RespondActivityTaskCompletedResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RespondActivityTaskCompleted indicates an expected call of RespondActivityTaskCompleted.
func (mr *MockHistoryServiceServerMockRecorder) RespondActivityTaskCompleted(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RespondActivityTaskCompleted", reflect.TypeOf((*MockHistoryServiceServer)(nil).RespondActivityTaskCompleted), arg0, arg1)
}

// RespondActivityTaskFailed mocks base method.
func (m *MockHistoryServiceServer) RespondActivityTaskFailed(arg0 context.Context, arg1 *historyservice.RespondActivityTaskFailedRequest) (*historyservice.RespondActivityTaskFailedResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RespondActivityTaskFailed", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.RespondActivityTaskFailedResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RespondActivityTaskFailed indicates an expected call of RespondActivityTaskFailed.
func (mr *MockHistoryServiceServerMockRecorder) RespondActivityTaskFailed(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RespondActivityTaskFailed", reflect.TypeOf((*MockHistoryServiceServer)(nil).RespondActivityTaskFailed), arg0, arg1)
}

// RespondActivityTaskCanceled mocks base method.
func (m *MockHistoryServiceServer) RespondActivityTaskCanceled(arg0 context.Context, arg1 *historyservice.RespondActivityTaskCanceledRequest) (*historyservice.RespondActivityTaskCanceledResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RespondActivityTaskCanceled", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.RespondActivityTaskCanceledResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RespondActivityTaskCanceled indicates an expected call of RespondActivityTaskCanceled.
func (mr *MockHistoryServiceServerMockRecorder) RespondActivityTaskCanceled(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RespondActivityTaskCanceled", reflect.TypeOf((*MockHistoryServiceServer)(nil).RespondActivityTaskCanceled), arg0, arg1)
}

// SignalWorkflowExecution mocks base method.
func (m *MockHistoryServiceServer) SignalWorkflowExecution(arg0 context.Context, arg1 *historyservice.SignalWorkflowExecutionRequest) (*historyservice.SignalWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SignalWorkflowExecution", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.SignalWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SignalWorkflowExecution indicates an expected call of SignalWorkflowExecution.
func (mr *MockHistoryServiceServerMockRecorder) SignalWorkflowExecution(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SignalWorkflowExecution", reflect.TypeOf((*MockHistoryServiceServer)(nil).SignalWorkflowExecution), arg0, arg1)
}

// SignalWithStartWorkflowExecution mocks base method.
func (m *MockHistoryServiceServer) SignalWithStartWorkflowExecution(arg0 context.Context, arg1 *historyservice.SignalWithStartWorkflowExecutionRequest) (*historyservice.SignalWithStartWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SignalWithStartWorkflowExecution", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.SignalWithStartWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SignalWithStartWorkflowExecution indicates an expected call of SignalWithStartWorkflowExecution.
func (mr *MockHistoryServiceServerMockRecorder) SignalWithStartWorkflowExecution(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SignalWithStartWorkflowExecution", reflect.TypeOf((*MockHistoryServiceServer)(nil).SignalWithStartWorkflowExecution), arg0, arg1)
}

// RemoveSignalMutableState mocks base method.
func (m *MockHistoryServiceServer) RemoveSignalMutableState(arg0 context.Context, arg1 *historyservice.RemoveSignalMutableStateRequest) (*historyservice.RemoveSignalMutableStateResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RemoveSignalMutableState", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.RemoveSignalMutableStateResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RemoveSignalMutableState indicates an expected call of RemoveSignalMutableState.
func (mr *MockHistoryServiceServerMockRecorder) RemoveSignalMutableState(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RemoveSignalMutableState", reflect.TypeOf((*MockHistoryServiceServer)(nil).RemoveSignalMutableState), arg0, arg1)
}

// TerminateWorkflowExecution mocks base method.
func (m *MockHistoryServiceServer) TerminateWorkflowExecution(arg0 context.Context, arg1 *historyservice.TerminateWorkflowExecutionRequest) (*historyservice.TerminateWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TerminateWorkflowExecution", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.TerminateWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// TerminateWorkflowExecution indicates an expected call of TerminateWorkflowExecution.
func (mr *MockHistoryServiceServerMockRecorder) TerminateWorkflowExecution(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TerminateWorkflowExecution", reflect.TypeOf((*MockHistoryServiceServer)(nil).TerminateWorkflowExecution), arg0, arg1)
}

// ResetWorkflowExecution mocks base method.
func (m *MockHistoryServiceServer) ResetWorkflowExecution(arg0 context.Context, arg1 *historyservice.ResetWorkflowExecutionRequest) (*historyservice.ResetWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ResetWorkflowExecution", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.ResetWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ResetWorkflowExecution indicates an expected call of ResetWorkflowExecution.
func (mr *MockHistoryServiceServerMockRecorder) ResetWorkflowExecution(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ResetWorkflowExecution", reflect.TypeOf((*MockHistoryServiceServer)(nil).ResetWorkflowExecution), arg0, arg1)
}

// RequestCancelWorkflowExecution mocks base method.
func (m *MockHistoryServiceServer) RequestCancelWorkflowExecution(arg0 context.Context, arg1 *historyservice.RequestCancelWorkflowExecutionRequest) (*historyservice.RequestCancelWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RequestCancelWorkflowExecution", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.RequestCancelWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RequestCancelWorkflowExecution indicates an expected call of RequestCancelWorkflowExecution.
func (mr *MockHistoryServiceServerMockRecorder) RequestCancelWorkflowExecution(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RequestCancelWorkflowExecution", reflect.TypeOf((*MockHistoryServiceServer)(nil).RequestCancelWorkflowExecution), arg0, arg1)
}

// ScheduleWorkflowTask mocks base method.
func (m *MockHistoryServiceServer) ScheduleWorkflowTask(arg0 context.Context, arg1 *historyservice.ScheduleWorkflowTaskRequest) (*historyservice.ScheduleWorkflowTaskResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ScheduleWorkflowTask", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.ScheduleWorkflowTaskResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ScheduleWorkflowTask indicates an expected call of ScheduleWorkflowTask.
func (mr *MockHistoryServiceServerMockRecorder) ScheduleWorkflowTask(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ScheduleWorkflowTask", reflect.TypeOf((*MockHistoryServiceServer)(nil).ScheduleWorkflowTask), arg0, arg1)
}

// RecordChildExecutionCompleted mocks base method.
func (m *MockHistoryServiceServer) RecordChildExecutionCompleted(arg0 context.Context, arg1 *historyservice.RecordChildExecutionCompletedRequest) (*historyservice.RecordChildExecutionCompletedResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RecordChildExecutionCompleted", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.RecordChildExecutionCompletedResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RecordChildExecutionCompleted indicates an expected call of RecordChildExecutionCompleted.
func (mr *MockHistoryServiceServerMockRecorder) RecordChildExecutionCompleted(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RecordChildExecutionCompleted", reflect.TypeOf((*MockHistoryServiceServer)(nil).RecordChildExecutionCompleted), arg0, arg1)
}

// DescribeWorkflowExecution mocks base method.
func (m *MockHistoryServiceServer) DescribeWorkflowExecution(arg0 context.Context, arg1 *historyservice.DescribeWorkflowExecutionRequest) (*historyservice.DescribeWorkflowExecutionResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeWorkflowExecution", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.DescribeWorkflowExecutionResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeWorkflowExecution indicates an expected call of DescribeWorkflowExecution.
func (mr *MockHistoryServiceServerMockRecorder) DescribeWorkflowExecution(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeWorkflowExecution", reflect.TypeOf((*MockHistoryServiceServer)(nil).DescribeWorkflowExecution), arg0, arg1)
}

// ReplicateEventsV2 mocks base method.
func (m *MockHistoryServiceServer) ReplicateEventsV2(arg0 context.Context, arg1 *historyservice.ReplicateEventsV2Request) (*historyservice.ReplicateEventsV2Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateEventsV2", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.ReplicateEventsV2Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateEventsV2 indicates an expected call of ReplicateEventsV2.
func (mr *MockHistoryServiceServerMockRecorder) ReplicateEventsV2(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateEventsV2", reflect.TypeOf((*MockHistoryServiceServer)(nil).ReplicateEventsV2), arg0, arg1)
}

// SyncShardStatus mocks base method.
func (m *MockHistoryServiceServer) SyncShardStatus(arg0 context.Context, arg1 *historyservice.SyncShardStatusRequest) (*historyservice.SyncShardStatusResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SyncShardStatus", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.SyncShardStatusResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SyncShardStatus indicates an expected call of SyncShardStatus.
func (mr *MockHistoryServiceServerMockRecorder) SyncShardStatus(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SyncShardStatus", reflect.TypeOf((*MockHistoryServiceServer)(nil).SyncShardStatus), arg0, arg1)
}

// SyncActivity mocks base method.
func (m *MockHistoryServiceServer) SyncActivity(arg0 context.Context, arg1 *historyservice.SyncActivityRequest) (*historyservice.SyncActivityResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SyncActivity", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.SyncActivityResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SyncActivity indicates an expected call of SyncActivity.
func (mr *MockHistoryServiceServerMockRecorder) SyncActivity(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SyncActivity", reflect.TypeOf((*MockHistoryServiceServer)(nil).SyncActivity), arg0, arg1)
}

// DescribeMutableState mocks base method.
func (m *MockHistoryServiceServer) DescribeMutableState(arg0 context.Context, arg1 *historyservice.DescribeMutableStateRequest) (*historyservice.DescribeMutableStateResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMutableState", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.DescribeMutableStateResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMutableState indicates an expected call of DescribeMutableState.
func (mr *MockHistoryServiceServerMockRecorder) DescribeMutableState(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMutableState", reflect.TypeOf((*MockHistoryServiceServer)(nil).DescribeMutableState), arg0, arg1)
}

// DescribeHistoryHost mocks base method.
func (m *MockHistoryServiceServer) DescribeHistoryHost(arg0 context.Context, arg1 *historyservice.DescribeHistoryHostRequest) (*historyservice.DescribeHistoryHostResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeHistoryHost", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.DescribeHistoryHostResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeHistoryHost indicates an expected call of DescribeHistoryHost.
func (mr *MockHistoryServiceServerMockRecorder) DescribeHistoryHost(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHistoryHost", reflect.TypeOf((*MockHistoryServiceServer)(nil).DescribeHistoryHost), arg0, arg1)
}

// CloseShard mocks base method.
func (m *MockHistoryServiceServer) CloseShard(arg0 context.Context, arg1 *historyservice.CloseShardRequest) (*historyservice.CloseShardResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CloseShard", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.CloseShardResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CloseShard indicates an expected call of CloseShard.
func (mr *MockHistoryServiceServerMockRecorder) CloseShard(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CloseShard", reflect.TypeOf((*MockHistoryServiceServer)(nil).CloseShard), arg0, arg1)
}

// RemoveTask mocks base method.
func (m *MockHistoryServiceServer) RemoveTask(arg0 context.Context, arg1 *historyservice.RemoveTaskRequest) (*historyservice.RemoveTaskResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RemoveTask", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.RemoveTaskResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RemoveTask indicates an expected call of RemoveTask.
func (mr *MockHistoryServiceServerMockRecorder) RemoveTask(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RemoveTask", reflect.TypeOf((*MockHistoryServiceServer)(nil).RemoveTask), arg0, arg1)
}

// GetReplicationMessages mocks base method.
func (m *MockHistoryServiceServer) GetReplicationMessages(arg0 context.Context, arg1 *historyservice.GetReplicationMessagesRequest) (*historyservice.GetReplicationMessagesResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetReplicationMessages", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.GetReplicationMessagesResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetReplicationMessages indicates an expected call of GetReplicationMessages.
func (mr *MockHistoryServiceServerMockRecorder) GetReplicationMessages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetReplicationMessages", reflect.TypeOf((*MockHistoryServiceServer)(nil).GetReplicationMessages), arg0, arg1)
}

// GetDLQReplicationMessages mocks base method.
func (m *MockHistoryServiceServer) GetDLQReplicationMessages(arg0 context.Context, arg1 *historyservice.GetDLQReplicationMessagesRequest) (*historyservice.GetDLQReplicationMessagesResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDLQReplicationMessages", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.GetDLQReplicationMessagesResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDLQReplicationMessages indicates an expected call of GetDLQReplicationMessages.
func (mr *MockHistoryServiceServerMockRecorder) GetDLQReplicationMessages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDLQReplicationMessages", reflect.TypeOf((*MockHistoryServiceServer)(nil).GetDLQReplicationMessages), arg0, arg1)
}

// QueryWorkflow mocks base method.
func (m *MockHistoryServiceServer) QueryWorkflow(arg0 context.Context, arg1 *historyservice.QueryWorkflowRequest) (*historyservice.QueryWorkflowResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "QueryWorkflow", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.QueryWorkflowResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// QueryWorkflow indicates an expected call of QueryWorkflow.
func (mr *MockHistoryServiceServerMockRecorder) QueryWorkflow(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "QueryWorkflow", reflect.TypeOf((*MockHistoryServiceServer)(nil).QueryWorkflow), arg0, arg1)
}

// ReapplyEvents mocks base method.
func (m *MockHistoryServiceServer) ReapplyEvents(arg0 context.Context, arg1 *historyservice.ReapplyEventsRequest) (*historyservice.ReapplyEventsResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReapplyEvents", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.ReapplyEventsResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReapplyEvents indicates an expected call of ReapplyEvents.
func (mr *MockHistoryServiceServerMockRecorder) ReapplyEvents(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReapplyEvents", reflect.TypeOf((*MockHistoryServiceServer)(nil).ReapplyEvents), arg0, arg1)
}

// GetDLQMessages mocks base method.
func (m *MockHistoryServiceServer) GetDLQMessages(arg0 context.Context, arg1 *historyservice.GetDLQMessagesRequest) (*historyservice.GetDLQMessagesResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDLQMessages", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.GetDLQMessagesResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDLQMessages indicates an expected call of GetDLQMessages.
func (mr *MockHistoryServiceServerMockRecorder) GetDLQMessages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDLQMessages", reflect.TypeOf((*MockHistoryServiceServer)(nil).GetDLQMessages), arg0, arg1)
}

// PurgeDLQMessages mocks base method.
func (m *MockHistoryServiceServer) PurgeDLQMessages(arg0 context.Context, arg1 *historyservice.PurgeDLQMessagesRequest) (*historyservice.PurgeDLQMessagesResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PurgeDLQMessages", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.PurgeDLQMessagesResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PurgeDLQMessages indicates an expected call of PurgeDLQMessages.
func (mr *MockHistoryServiceServerMockRecorder) PurgeDLQMessages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PurgeDLQMessages", reflect.TypeOf((*MockHistoryServiceServer)(nil).PurgeDLQMessages), arg0, arg1)
}

// MergeDLQMessages mocks base method.
func (m *MockHistoryServiceServer) MergeDLQMessages(arg0 context.Context, arg1 *historyservice.MergeDLQMessagesRequest) (*historyservice.MergeDLQMessagesResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MergeDLQMessages", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.MergeDLQMessagesResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// MergeDLQMessages indicates an expected call of MergeDLQMessages.
func (mr *MockHistoryServiceServerMockRecorder) MergeDLQMessages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MergeDLQMessages", reflect.TypeOf((*MockHistoryServiceServer)(nil).MergeDLQMessages), arg0, arg1)
}

// RefreshWorkflowTasks mocks base method.
func (m *MockHistoryServiceServer) RefreshWorkflowTasks(arg0 context.Context, arg1 *historyservice.RefreshWorkflowTasksRequest) (*historyservice.RefreshWorkflowTasksResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RefreshWorkflowTasks", arg0, arg1)
	ret0, _ := ret[0].(*historyservice.RefreshWorkflowTasksResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RefreshWorkflowTasks indicates an expected call of RefreshWorkflowTasks.
func (mr *MockHistoryServiceServerMockRecorder) RefreshWorkflowTasks(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RefreshWorkflowTasks", reflect.TypeOf((*MockHistoryServiceServer)(nil).RefreshWorkflowTasks), arg0, arg1)
}
