// Code generated by dagger. DO NOT EDIT.

package dagger

import (
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"net"
	"net/http"
	"os"
	"reflect"
	"strconv"

	"github.com/Khan/genqlient/graphql"
	"github.com/vektah/gqlparser/v2/gqlerror"
	"go.opentelemetry.io/otel"
	"go.opentelemetry.io/otel/propagation"
	"go.opentelemetry.io/otel/trace"

	"github.com/grafana/tanka/dagger/internal/querybuilder"
	"github.com/grafana/tanka/dagger/internal/telemetry"
)

func Tracer() trace.Tracer {
	return otel.Tracer("dagger.io/sdk.go")
}

// reassigned at runtime after the span is initialized
var marshalCtx = context.Background()

// SetMarshalContext is a hack that lets us set the ctx to use for
// MarshalJSON implementations that get an object's ID.
func SetMarshalContext(ctx context.Context) {
	marshalCtx = ctx
}

// assertNotNil panic if the given value is nil.
// This function is used to validate that input with pointer type are not nil.
// See https://github.com/dagger/dagger/issues/5696 for more context.
func assertNotNil(argName string, value any) {
	// We use reflect because just comparing value to nil is not working since
	// the value is wrapped into a type when passed as parameter.
	// E.g., nil become (*dagger.File)(nil).
	if reflect.ValueOf(value).IsNil() {
		panic(fmt.Sprintf("unexpected nil pointer for argument %q", argName))
	}
}

type DaggerObject = querybuilder.GraphQLMarshaller

type gqlExtendedError struct {
	inner *gqlerror.Error
}

// Same as telemetry.ExtendedError, but without the dependency, to simplify
// client generation.
type extendedError interface {
	error
	Extensions() map[string]any
}

func (e gqlExtendedError) Unwrap() error {
	return e.inner
}

var _ extendedError = gqlExtendedError{}

func (e gqlExtendedError) Error() string {
	return e.inner.Message
}

func (e gqlExtendedError) Extensions() map[string]any {
	return e.inner.Extensions
}

// getCustomError parses a GraphQL error into a more specific error type.
func getCustomError(err error) error {
	var gqlErr *gqlerror.Error
	if !errors.As(err, &gqlErr) {
		return nil
	}

	ext := gqlErr.Extensions

	typ, ok := ext["_type"].(string)
	if !ok {
		return gqlExtendedError{gqlErr}
	}

	if typ == "EXEC_ERROR" {
		e := &ExecError{
			original: gqlErr,
		}
		if code, ok := ext["exitCode"].(float64); ok {
			e.ExitCode = int(code)
		}
		if args, ok := ext["cmd"].([]interface{}); ok {
			cmd := make([]string, len(args))
			for i, v := range args {
				cmd[i] = v.(string)
			}
			e.Cmd = cmd
		}
		if stdout, ok := ext["stdout"].(string); ok {
			e.Stdout = stdout
		}
		if stderr, ok := ext["stderr"].(string); ok {
			e.Stderr = stderr
		}
		return e
	}

	return gqlExtendedError{gqlErr}
}

// ExecError is an API error from an exec operation.
type ExecError struct {
	original *gqlerror.Error
	Cmd      []string
	ExitCode int
	Stdout   string
	Stderr   string
}

var _ extendedError = (*ExecError)(nil)

func (e *ExecError) Error() string {
	return e.Message()
}

func (e *ExecError) Extensions() map[string]any {
	return e.original.Extensions
}

func (e *ExecError) Message() string {
	return e.original.Error()
}

func (e *ExecError) Unwrap() error {
	return e.original
}

// The `BindingID` scalar type represents an identifier for an object of type Binding.
type BindingID string

// The `CacheVolumeID` scalar type represents an identifier for an object of type CacheVolume.
type CacheVolumeID string

// The `CloudID` scalar type represents an identifier for an object of type Cloud.
type CloudID string

// The `ContainerID` scalar type represents an identifier for an object of type Container.
type ContainerID string

// The `CurrentModuleID` scalar type represents an identifier for an object of type CurrentModule.
type CurrentModuleID string

// The `DirectoryID` scalar type represents an identifier for an object of type Directory.
type DirectoryID string

// The `EnumTypeDefID` scalar type represents an identifier for an object of type EnumTypeDef.
type EnumTypeDefID string

// The `EnumValueTypeDefID` scalar type represents an identifier for an object of type EnumValueTypeDef.
type EnumValueTypeDefID string

// The `EnvID` scalar type represents an identifier for an object of type Env.
type EnvID string

// The `EnvVariableID` scalar type represents an identifier for an object of type EnvVariable.
type EnvVariableID string

// The `ErrorID` scalar type represents an identifier for an object of type Error.
type ErrorID string

// The `ErrorValueID` scalar type represents an identifier for an object of type ErrorValue.
type ErrorValueID string

// The `FieldTypeDefID` scalar type represents an identifier for an object of type FieldTypeDef.
type FieldTypeDefID string

// The `FileID` scalar type represents an identifier for an object of type File.
type FileID string

// The `FunctionArgID` scalar type represents an identifier for an object of type FunctionArg.
type FunctionArgID string

// The `FunctionCallArgValueID` scalar type represents an identifier for an object of type FunctionCallArgValue.
type FunctionCallArgValueID string

// The `FunctionCallID` scalar type represents an identifier for an object of type FunctionCall.
type FunctionCallID string

// The `FunctionID` scalar type represents an identifier for an object of type Function.
type FunctionID string

// The `GeneratedCodeID` scalar type represents an identifier for an object of type GeneratedCode.
type GeneratedCodeID string

// The `GitRefID` scalar type represents an identifier for an object of type GitRef.
type GitRefID string

// The `GitRepositoryID` scalar type represents an identifier for an object of type GitRepository.
type GitRepositoryID string

// The `InputTypeDefID` scalar type represents an identifier for an object of type InputTypeDef.
type InputTypeDefID string

// The `InterfaceTypeDefID` scalar type represents an identifier for an object of type InterfaceTypeDef.
type InterfaceTypeDefID string

// An arbitrary JSON-encoded value.
type JSON string

// The `K3SID` scalar type represents an identifier for an object of type K3S.
type K3SID string

// The `LLMID` scalar type represents an identifier for an object of type LLM.
type LLMID string

// The `LLMTokenUsageID` scalar type represents an identifier for an object of type LLMTokenUsage.
type LLMTokenUsageID string

// The `LabelID` scalar type represents an identifier for an object of type Label.
type LabelID string

// The `ListTypeDefID` scalar type represents an identifier for an object of type ListTypeDef.
type ListTypeDefID string

// The `ModuleConfigClientID` scalar type represents an identifier for an object of type ModuleConfigClient.
type ModuleConfigClientID string

// The `ModuleID` scalar type represents an identifier for an object of type Module.
type ModuleID string

// The `ModuleSourceID` scalar type represents an identifier for an object of type ModuleSource.
type ModuleSourceID string

// The `ObjectTypeDefID` scalar type represents an identifier for an object of type ObjectTypeDef.
type ObjectTypeDefID string

// The platform config OS and architecture in a Container.
//
// The format is [os]/[platform]/[version] (e.g., "darwin/arm64/v7", "windows/amd64", "linux/arm64").
type Platform string

// The `PortID` scalar type represents an identifier for an object of type Port.
type PortID string

// The `SDKConfigID` scalar type represents an identifier for an object of type SDKConfig.
type SDKConfigID string

// The `ScalarTypeDefID` scalar type represents an identifier for an object of type ScalarTypeDef.
type ScalarTypeDefID string

// The `SecretID` scalar type represents an identifier for an object of type Secret.
type SecretID string

// The `ServiceID` scalar type represents an identifier for an object of type Service.
type ServiceID string

// The `SocketID` scalar type represents an identifier for an object of type Socket.
type SocketID string

// The `SourceMapID` scalar type represents an identifier for an object of type SourceMap.
type SourceMapID string

// The `TerminalID` scalar type represents an identifier for an object of type Terminal.
type TerminalID string

// The `TypeDefID` scalar type represents an identifier for an object of type TypeDef.
type TypeDefID string

// The absence of a value.
//
// A Null Void is used as a placeholder for resolvers that do not return anything.
type Void string

// Key value object that represents a build argument.
type BuildArg struct {
	// The build argument name.
	Name string `json:"name"`

	// The build argument value.
	Value string `json:"value"`
}

// Key value object that represents a pipeline label.
type PipelineLabel struct {
	// Label name.
	Name string `json:"name"`

	// Label value.
	Value string `json:"value"`
}

// Port forwarding rules for tunneling network traffic.
type PortForward struct {
	// Destination port for traffic.
	Backend int `json:"backend"`

	// Port to expose to clients. If unspecified, a default will be chosen.
	Frontend int `json:"frontend"`

	// Transport layer protocol to use for traffic.
	Protocol NetworkProtocol `json:"protocol,omitempty"`
}

type Binding struct {
	query *querybuilder.Selection

	asString *string
	digest   *string
	id       *BindingID
	isNull   *bool
	name     *string
	typeName *string
}

func (r *Binding) WithGraphQLQuery(q *querybuilder.Selection) *Binding {
	return &Binding{
		query: q,
	}
}

// Retrieve the binding value, as type CacheVolume
func (r *Binding) AsCacheVolume() *CacheVolume {
	q := r.query.Select("asCacheVolume")

	return &CacheVolume{
		query: q,
	}
}

// Retrieve the binding value, as type Cloud
func (r *Binding) AsCloud() *Cloud {
	q := r.query.Select("asCloud")

	return &Cloud{
		query: q,
	}
}

// Retrieve the binding value, as type Container
func (r *Binding) AsContainer() *Container {
	q := r.query.Select("asContainer")

	return &Container{
		query: q,
	}
}

// Retrieve the binding value, as type Directory
func (r *Binding) AsDirectory() *Directory {
	q := r.query.Select("asDirectory")

	return &Directory{
		query: q,
	}
}

// Retrieve the binding value, as type Env
func (r *Binding) AsEnv() *Env {
	q := r.query.Select("asEnv")

	return &Env{
		query: q,
	}
}

// Retrieve the binding value, as type File
func (r *Binding) AsFile() *File {
	q := r.query.Select("asFile")

	return &File{
		query: q,
	}
}

// Retrieve the binding value, as type GitRef
func (r *Binding) AsGitRef() *GitRef {
	q := r.query.Select("asGitRef")

	return &GitRef{
		query: q,
	}
}

// Retrieve the binding value, as type GitRepository
func (r *Binding) AsGitRepository() *GitRepository {
	q := r.query.Select("asGitRepository")

	return &GitRepository{
		query: q,
	}
}

// Retrieve the binding value, as type K3S
func (r *Binding) AsK3S() *K3S {
	q := r.query.Select("asK3S")

	return &K3S{
		query: q,
	}
}

// Retrieve the binding value, as type LLM
func (r *Binding) AsLLM() *LLM {
	q := r.query.Select("asLLM")

	return &LLM{
		query: q,
	}
}

// Retrieve the binding value, as type Module
func (r *Binding) AsModule() *Module {
	q := r.query.Select("asModule")

	return &Module{
		query: q,
	}
}

// Retrieve the binding value, as type ModuleConfigClient
func (r *Binding) AsModuleConfigClient() *ModuleConfigClient {
	q := r.query.Select("asModuleConfigClient")

	return &ModuleConfigClient{
		query: q,
	}
}

// Retrieve the binding value, as type ModuleSource
func (r *Binding) AsModuleSource() *ModuleSource {
	q := r.query.Select("asModuleSource")

	return &ModuleSource{
		query: q,
	}
}

// Retrieve the binding value, as type Secret
func (r *Binding) AsSecret() *Secret {
	q := r.query.Select("asSecret")

	return &Secret{
		query: q,
	}
}

// Retrieve the binding value, as type Service
func (r *Binding) AsService() *Service {
	q := r.query.Select("asService")

	return &Service{
		query: q,
	}
}

// Retrieve the binding value, as type Socket
func (r *Binding) AsSocket() *Socket {
	q := r.query.Select("asSocket")

	return &Socket{
		query: q,
	}
}

// The binding's string value
func (r *Binding) AsString(ctx context.Context) (string, error) {
	if r.asString != nil {
		return *r.asString, nil
	}
	q := r.query.Select("asString")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The digest of the binding value
func (r *Binding) Digest(ctx context.Context) (string, error) {
	if r.digest != nil {
		return *r.digest, nil
	}
	q := r.query.Select("digest")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this Binding.
func (r *Binding) ID(ctx context.Context) (BindingID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response BindingID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *Binding) XXX_GraphQLType() string {
	return "Binding"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *Binding) XXX_GraphQLIDType() string {
	return "BindingID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *Binding) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *Binding) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *Binding) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadBindingFromID(BindingID(id))
	return nil
}

// Returns true if the binding is null
func (r *Binding) IsNull(ctx context.Context) (bool, error) {
	if r.isNull != nil {
		return *r.isNull, nil
	}
	q := r.query.Select("isNull")

	var response bool

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The binding name
func (r *Binding) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The binding type
func (r *Binding) TypeName(ctx context.Context) (string, error) {
	if r.typeName != nil {
		return *r.typeName, nil
	}
	q := r.query.Select("typeName")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A directory whose contents persist across runs.
type CacheVolume struct {
	query *querybuilder.Selection

	id *CacheVolumeID
}

func (r *CacheVolume) WithGraphQLQuery(q *querybuilder.Selection) *CacheVolume {
	return &CacheVolume{
		query: q,
	}
}

// A unique identifier for this CacheVolume.
func (r *CacheVolume) ID(ctx context.Context) (CacheVolumeID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response CacheVolumeID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *CacheVolume) XXX_GraphQLType() string {
	return "CacheVolume"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *CacheVolume) XXX_GraphQLIDType() string {
	return "CacheVolumeID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *CacheVolume) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *CacheVolume) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *CacheVolume) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadCacheVolumeFromID(CacheVolumeID(id))
	return nil
}

// Dagger Cloud configuration and state
type Cloud struct {
	query *querybuilder.Selection

	id       *CloudID
	traceURL *string
}

func (r *Cloud) WithGraphQLQuery(q *querybuilder.Selection) *Cloud {
	return &Cloud{
		query: q,
	}
}

// A unique identifier for this Cloud.
func (r *Cloud) ID(ctx context.Context) (CloudID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response CloudID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *Cloud) XXX_GraphQLType() string {
	return "Cloud"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *Cloud) XXX_GraphQLIDType() string {
	return "CloudID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *Cloud) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *Cloud) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *Cloud) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadCloudFromID(CloudID(id))
	return nil
}

// The trace URL for the current session
func (r *Cloud) TraceURL(ctx context.Context) (string, error) {
	if r.traceURL != nil {
		return *r.traceURL, nil
	}
	q := r.query.Select("traceURL")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// An OCI-compatible container, also known as a Docker container.
type Container struct {
	query *querybuilder.Selection

	envVariable *string
	exitCode    *int
	export      *string
	id          *ContainerID
	imageRef    *string
	label       *string
	platform    *Platform
	publish     *string
	stderr      *string
	stdout      *string
	sync        *ContainerID
	up          *Void
	user        *string
	workdir     *string
}
type WithContainerFunc func(r *Container) *Container

// With calls the provided function with current Container.
//
// This is useful for reusability and readability by not breaking the calling chain.
func (r *Container) With(f WithContainerFunc) *Container {
	return f(r)
}

func (r *Container) WithGraphQLQuery(q *querybuilder.Selection) *Container {
	return &Container{
		query: q,
	}
}

// ContainerAsServiceOpts contains options for Container.AsService
type ContainerAsServiceOpts struct {
	// Command to run instead of the container's default command (e.g., ["go", "run", "main.go"]).
	//
	// If empty, the container's default command is used.
	Args []string
	// If the container has an entrypoint, prepend it to the args.
	UseEntrypoint bool
	// Provides Dagger access to the executed command.
	ExperimentalPrivilegedNesting bool
	// Execute the command with all root capabilities. This is similar to running a command with "sudo" or executing "docker run" with the "--privileged" flag. Containerization does not provide any security guarantees when using this option. It should only be used when absolutely necessary and only with trusted commands.
	InsecureRootCapabilities bool
	// Replace "${VAR}" or "$VAR" in the args according to the current environment variables defined in the container (e.g. "/$VAR/foo").
	Expand bool
	// If set, skip the automatic init process injected into containers by default.
	//
	// This should only be used if the user requires that their exec process be the pid 1 process in the container. Otherwise it may result in unexpected behavior.
	NoInit bool
}

// Turn the container into a Service.
//
// Be sure to set any exposed ports before this conversion.
func (r *Container) AsService(opts ...ContainerAsServiceOpts) *Service {
	q := r.query.Select("asService")
	for i := len(opts) - 1; i >= 0; i-- {
		// `args` optional argument
		if !querybuilder.IsZeroValue(opts[i].Args) {
			q = q.Arg("args", opts[i].Args)
		}
		// `useEntrypoint` optional argument
		if !querybuilder.IsZeroValue(opts[i].UseEntrypoint) {
			q = q.Arg("useEntrypoint", opts[i].UseEntrypoint)
		}
		// `experimentalPrivilegedNesting` optional argument
		if !querybuilder.IsZeroValue(opts[i].ExperimentalPrivilegedNesting) {
			q = q.Arg("experimentalPrivilegedNesting", opts[i].ExperimentalPrivilegedNesting)
		}
		// `insecureRootCapabilities` optional argument
		if !querybuilder.IsZeroValue(opts[i].InsecureRootCapabilities) {
			q = q.Arg("insecureRootCapabilities", opts[i].InsecureRootCapabilities)
		}
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
		// `noInit` optional argument
		if !querybuilder.IsZeroValue(opts[i].NoInit) {
			q = q.Arg("noInit", opts[i].NoInit)
		}
	}

	return &Service{
		query: q,
	}
}

// ContainerAsTarballOpts contains options for Container.AsTarball
type ContainerAsTarballOpts struct {
	// Identifiers for other platform specific containers.
	//
	// Used for multi-platform images.
	PlatformVariants []*Container
	// Force each layer of the image to use the specified compression algorithm.
	//
	// If this is unset, then if a layer already has a compressed blob in the engine's cache, that will be used (this can result in a mix of compression algorithms for different layers). If this is unset and a layer has no compressed blob in the engine's cache, then it will be compressed using Gzip.
	ForcedCompression ImageLayerCompression
	// Use the specified media types for the image's layers.
	//
	// Defaults to OCI, which is largely compatible with most recent container runtimes, but Docker may be needed for older runtimes without OCI support.
	//
	// Default: OCIMediaTypes
	MediaTypes ImageMediaTypes
}

// Package the container state as an OCI image, and return it as a tar archive
func (r *Container) AsTarball(opts ...ContainerAsTarballOpts) *File {
	q := r.query.Select("asTarball")
	for i := len(opts) - 1; i >= 0; i-- {
		// `platformVariants` optional argument
		if !querybuilder.IsZeroValue(opts[i].PlatformVariants) {
			q = q.Arg("platformVariants", opts[i].PlatformVariants)
		}
		// `forcedCompression` optional argument
		if !querybuilder.IsZeroValue(opts[i].ForcedCompression) {
			q = q.Arg("forcedCompression", opts[i].ForcedCompression)
		}
		// `mediaTypes` optional argument
		if !querybuilder.IsZeroValue(opts[i].MediaTypes) {
			q = q.Arg("mediaTypes", opts[i].MediaTypes)
		}
	}

	return &File{
		query: q,
	}
}

// ContainerBuildOpts contains options for Container.Build
type ContainerBuildOpts struct {
	// Path to the Dockerfile to use.
	//
	// Default: "Dockerfile"
	Dockerfile string
	// Target build stage to build.
	Target string
	// Additional build arguments.
	BuildArgs []BuildArg
	// Secrets to pass to the build.
	//
	// They will be mounted at /run/secrets/[secret-name] in the build container
	//
	// They can be accessed in the Dockerfile using the "secret" mount type and mount path /run/secrets/[secret-name], e.g. RUN --mount=type=secret,id=my-secret curl [http://example.com?token=$(cat /run/secrets/my-secret)](http://example.com?token=$(cat /run/secrets/my-secret))
	Secrets []*Secret
	// If set, skip the automatic init process injected into containers created by RUN statements.
	//
	// This should only be used if the user requires that their exec processes be the pid 1 process in the container. Otherwise it may result in unexpected behavior.
	NoInit bool
}

// Initializes this container from a Dockerfile build.
func (r *Container) Build(context *Directory, opts ...ContainerBuildOpts) *Container {
	assertNotNil("context", context)
	q := r.query.Select("build")
	for i := len(opts) - 1; i >= 0; i-- {
		// `dockerfile` optional argument
		if !querybuilder.IsZeroValue(opts[i].Dockerfile) {
			q = q.Arg("dockerfile", opts[i].Dockerfile)
		}
		// `target` optional argument
		if !querybuilder.IsZeroValue(opts[i].Target) {
			q = q.Arg("target", opts[i].Target)
		}
		// `buildArgs` optional argument
		if !querybuilder.IsZeroValue(opts[i].BuildArgs) {
			q = q.Arg("buildArgs", opts[i].BuildArgs)
		}
		// `secrets` optional argument
		if !querybuilder.IsZeroValue(opts[i].Secrets) {
			q = q.Arg("secrets", opts[i].Secrets)
		}
		// `noInit` optional argument
		if !querybuilder.IsZeroValue(opts[i].NoInit) {
			q = q.Arg("noInit", opts[i].NoInit)
		}
	}
	q = q.Arg("context", context)

	return &Container{
		query: q,
	}
}

// Return the container's default arguments.
func (r *Container) DefaultArgs(ctx context.Context) ([]string, error) {
	q := r.query.Select("defaultArgs")

	var response []string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// ContainerDirectoryOpts contains options for Container.Directory
type ContainerDirectoryOpts struct {
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo").
	Expand bool
}

// Retrieve a directory from the container's root filesystem
//
// Mounts are included.
func (r *Container) Directory(path string, opts ...ContainerDirectoryOpts) *Directory {
	q := r.query.Select("directory")
	for i := len(opts) - 1; i >= 0; i-- {
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)

	return &Directory{
		query: q,
	}
}

// Return the container's OCI entrypoint.
func (r *Container) Entrypoint(ctx context.Context) ([]string, error) {
	q := r.query.Select("entrypoint")

	var response []string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Retrieves the value of the specified environment variable.
func (r *Container) EnvVariable(ctx context.Context, name string) (string, error) {
	if r.envVariable != nil {
		return *r.envVariable, nil
	}
	q := r.query.Select("envVariable")
	q = q.Arg("name", name)

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Retrieves the list of environment variables passed to commands.
func (r *Container) EnvVariables(ctx context.Context) ([]EnvVariable, error) {
	q := r.query.Select("envVariables")

	q = q.Select("id")

	type envVariables struct {
		Id EnvVariableID
	}

	convert := func(fields []envVariables) []EnvVariable {
		out := []EnvVariable{}

		for i := range fields {
			val := EnvVariable{id: &fields[i].Id}
			val.query = q.Root().Select("loadEnvVariableFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []envVariables

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// The exit code of the last executed command
//
// Returns an error if no command was executed
func (r *Container) ExitCode(ctx context.Context) (int, error) {
	if r.exitCode != nil {
		return *r.exitCode, nil
	}
	q := r.query.Select("exitCode")

	var response int

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// EXPERIMENTAL API! Subject to change/removal at any time.
//
// Configures all available GPUs on the host to be accessible to this container.
//
// This currently works for Nvidia devices only.
func (r *Container) ExperimentalWithAllGPUs() *Container {
	q := r.query.Select("experimentalWithAllGPUs")

	return &Container{
		query: q,
	}
}

// EXPERIMENTAL API! Subject to change/removal at any time.
//
// Configures the provided list of devices to be accessible to this container.
//
// This currently works for Nvidia devices only.
func (r *Container) ExperimentalWithGPU(devices []string) *Container {
	q := r.query.Select("experimentalWithGPU")
	q = q.Arg("devices", devices)

	return &Container{
		query: q,
	}
}

// ContainerExportOpts contains options for Container.Export
type ContainerExportOpts struct {
	// Identifiers for other platform specific containers.
	//
	// Used for multi-platform image.
	PlatformVariants []*Container
	// Force each layer of the exported image to use the specified compression algorithm.
	//
	// If this is unset, then if a layer already has a compressed blob in the engine's cache, that will be used (this can result in a mix of compression algorithms for different layers). If this is unset and a layer has no compressed blob in the engine's cache, then it will be compressed using Gzip.
	ForcedCompression ImageLayerCompression
	// Use the specified media types for the exported image's layers.
	//
	// Defaults to OCI, which is largely compatible with most recent container runtimes, but Docker may be needed for older runtimes without OCI support.
	//
	// Default: OCIMediaTypes
	MediaTypes ImageMediaTypes
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo").
	Expand bool
}

// Writes the container as an OCI tarball to the destination file path on the host.
//
// It can also export platform variants.
func (r *Container) Export(ctx context.Context, path string, opts ...ContainerExportOpts) (string, error) {
	if r.export != nil {
		return *r.export, nil
	}
	q := r.query.Select("export")
	for i := len(opts) - 1; i >= 0; i-- {
		// `platformVariants` optional argument
		if !querybuilder.IsZeroValue(opts[i].PlatformVariants) {
			q = q.Arg("platformVariants", opts[i].PlatformVariants)
		}
		// `forcedCompression` optional argument
		if !querybuilder.IsZeroValue(opts[i].ForcedCompression) {
			q = q.Arg("forcedCompression", opts[i].ForcedCompression)
		}
		// `mediaTypes` optional argument
		if !querybuilder.IsZeroValue(opts[i].MediaTypes) {
			q = q.Arg("mediaTypes", opts[i].MediaTypes)
		}
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Retrieves the list of exposed ports.
//
// This includes ports already exposed by the image, even if not explicitly added with dagger.
func (r *Container) ExposedPorts(ctx context.Context) ([]Port, error) {
	q := r.query.Select("exposedPorts")

	q = q.Select("id")

	type exposedPorts struct {
		Id PortID
	}

	convert := func(fields []exposedPorts) []Port {
		out := []Port{}

		for i := range fields {
			val := Port{id: &fields[i].Id}
			val.query = q.Root().Select("loadPortFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []exposedPorts

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// ContainerFileOpts contains options for Container.File
type ContainerFileOpts struct {
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo.txt").
	Expand bool
}

// Retrieves a file at the given path.
//
// Mounts are included.
func (r *Container) File(path string, opts ...ContainerFileOpts) *File {
	q := r.query.Select("file")
	for i := len(opts) - 1; i >= 0; i-- {
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)

	return &File{
		query: q,
	}
}

// Download a container image, and apply it to the container state. All previous state will be lost.
func (r *Container) From(address string) *Container {
	q := r.query.Select("from")
	q = q.Arg("address", address)

	return &Container{
		query: q,
	}
}

// A unique identifier for this Container.
func (r *Container) ID(ctx context.Context) (ContainerID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response ContainerID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *Container) XXX_GraphQLType() string {
	return "Container"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *Container) XXX_GraphQLIDType() string {
	return "ContainerID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *Container) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *Container) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *Container) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadContainerFromID(ContainerID(id))
	return nil
}

// The unique image reference which can only be retrieved immediately after the 'Container.From' call.
func (r *Container) ImageRef(ctx context.Context) (string, error) {
	if r.imageRef != nil {
		return *r.imageRef, nil
	}
	q := r.query.Select("imageRef")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// ContainerImportOpts contains options for Container.Import
type ContainerImportOpts struct {
	// Identifies the tag to import from the archive, if the archive bundles multiple tags.
	Tag string
}

// Reads the container from an OCI tarball.
func (r *Container) Import(source *File, opts ...ContainerImportOpts) *Container {
	assertNotNil("source", source)
	q := r.query.Select("import")
	for i := len(opts) - 1; i >= 0; i-- {
		// `tag` optional argument
		if !querybuilder.IsZeroValue(opts[i].Tag) {
			q = q.Arg("tag", opts[i].Tag)
		}
	}
	q = q.Arg("source", source)

	return &Container{
		query: q,
	}
}

// Retrieves the value of the specified label.
func (r *Container) Label(ctx context.Context, name string) (string, error) {
	if r.label != nil {
		return *r.label, nil
	}
	q := r.query.Select("label")
	q = q.Arg("name", name)

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Retrieves the list of labels passed to container.
func (r *Container) Labels(ctx context.Context) ([]Label, error) {
	q := r.query.Select("labels")

	q = q.Select("id")

	type labels struct {
		Id LabelID
	}

	convert := func(fields []labels) []Label {
		out := []Label{}

		for i := range fields {
			val := Label{id: &fields[i].Id}
			val.query = q.Root().Select("loadLabelFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []labels

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// Retrieves the list of paths where a directory is mounted.
func (r *Container) Mounts(ctx context.Context) ([]string, error) {
	q := r.query.Select("mounts")

	var response []string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The platform this container executes and publishes as.
func (r *Container) Platform(ctx context.Context) (Platform, error) {
	if r.platform != nil {
		return *r.platform, nil
	}
	q := r.query.Select("platform")

	var response Platform

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// ContainerPublishOpts contains options for Container.Publish
type ContainerPublishOpts struct {
	// Identifiers for other platform specific containers.
	//
	// Used for multi-platform image.
	PlatformVariants []*Container
	// Force each layer of the published image to use the specified compression algorithm.
	//
	// If this is unset, then if a layer already has a compressed blob in the engine's cache, that will be used (this can result in a mix of compression algorithms for different layers). If this is unset and a layer has no compressed blob in the engine's cache, then it will be compressed using Gzip.
	ForcedCompression ImageLayerCompression
	// Use the specified media types for the published image's layers.
	//
	// Defaults to "OCI", which is compatible with most recent registries, but "Docker" may be needed for older registries without OCI support.
	//
	// Default: OCIMediaTypes
	MediaTypes ImageMediaTypes
}

// Package the container state as an OCI image, and publish it to a registry
//
// Returns the fully qualified address of the published image, with digest
func (r *Container) Publish(ctx context.Context, address string, opts ...ContainerPublishOpts) (string, error) {
	if r.publish != nil {
		return *r.publish, nil
	}
	q := r.query.Select("publish")
	for i := len(opts) - 1; i >= 0; i-- {
		// `platformVariants` optional argument
		if !querybuilder.IsZeroValue(opts[i].PlatformVariants) {
			q = q.Arg("platformVariants", opts[i].PlatformVariants)
		}
		// `forcedCompression` optional argument
		if !querybuilder.IsZeroValue(opts[i].ForcedCompression) {
			q = q.Arg("forcedCompression", opts[i].ForcedCompression)
		}
		// `mediaTypes` optional argument
		if !querybuilder.IsZeroValue(opts[i].MediaTypes) {
			q = q.Arg("mediaTypes", opts[i].MediaTypes)
		}
	}
	q = q.Arg("address", address)

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Return a snapshot of the container's root filesystem. The snapshot can be modified then written back using withRootfs. Use that method for filesystem modifications.
func (r *Container) Rootfs() *Directory {
	q := r.query.Select("rootfs")

	return &Directory{
		query: q,
	}
}

// The buffered standard error stream of the last executed command
//
// Returns an error if no command was executed
func (r *Container) Stderr(ctx context.Context) (string, error) {
	if r.stderr != nil {
		return *r.stderr, nil
	}
	q := r.query.Select("stderr")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The buffered standard output stream of the last executed command
//
// Returns an error if no command was executed
func (r *Container) Stdout(ctx context.Context) (string, error) {
	if r.stdout != nil {
		return *r.stdout, nil
	}
	q := r.query.Select("stdout")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Forces evaluation of the pipeline in the engine.
//
// It doesn't run the default command if no exec has been set.
func (r *Container) Sync(ctx context.Context) (*Container, error) {
	q := r.query.Select("sync")

	var id ContainerID
	if err := q.Bind(&id).Execute(ctx); err != nil {
		return nil, err
	}
	return &Container{
		query: q.Root().Select("loadContainerFromID").Arg("id", id),
	}, nil
}

// ContainerTerminalOpts contains options for Container.Terminal
type ContainerTerminalOpts struct {
	// If set, override the container's default terminal command and invoke these command arguments instead.
	Cmd []string
	// Provides Dagger access to the executed command.
	ExperimentalPrivilegedNesting bool
	// Execute the command with all root capabilities. This is similar to running a command with "sudo" or executing "docker run" with the "--privileged" flag. Containerization does not provide any security guarantees when using this option. It should only be used when absolutely necessary and only with trusted commands.
	InsecureRootCapabilities bool
}

// Opens an interactive terminal for this container using its configured default terminal command if not overridden by args (or sh as a fallback default).
func (r *Container) Terminal(opts ...ContainerTerminalOpts) *Container {
	q := r.query.Select("terminal")
	for i := len(opts) - 1; i >= 0; i-- {
		// `cmd` optional argument
		if !querybuilder.IsZeroValue(opts[i].Cmd) {
			q = q.Arg("cmd", opts[i].Cmd)
		}
		// `experimentalPrivilegedNesting` optional argument
		if !querybuilder.IsZeroValue(opts[i].ExperimentalPrivilegedNesting) {
			q = q.Arg("experimentalPrivilegedNesting", opts[i].ExperimentalPrivilegedNesting)
		}
		// `insecureRootCapabilities` optional argument
		if !querybuilder.IsZeroValue(opts[i].InsecureRootCapabilities) {
			q = q.Arg("insecureRootCapabilities", opts[i].InsecureRootCapabilities)
		}
	}

	return &Container{
		query: q,
	}
}

// ContainerUpOpts contains options for Container.Up
type ContainerUpOpts struct {
	// Bind each tunnel port to a random port on the host.
	Random bool
	// List of frontend/backend port mappings to forward.
	//
	// Frontend is the port accepting traffic on the host, backend is the service port.
	Ports []PortForward
	// Command to run instead of the container's default command (e.g., ["go", "run", "main.go"]).
	//
	// If empty, the container's default command is used.
	Args []string
	// If the container has an entrypoint, prepend it to the args.
	UseEntrypoint bool
	// Provides Dagger access to the executed command.
	ExperimentalPrivilegedNesting bool
	// Execute the command with all root capabilities. This is similar to running a command with "sudo" or executing "docker run" with the "--privileged" flag. Containerization does not provide any security guarantees when using this option. It should only be used when absolutely necessary and only with trusted commands.
	InsecureRootCapabilities bool
	// Replace "${VAR}" or "$VAR" in the args according to the current environment variables defined in the container (e.g. "/$VAR/foo").
	Expand bool
	// If set, skip the automatic init process injected into containers by default.
	//
	// This should only be used if the user requires that their exec process be the pid 1 process in the container. Otherwise it may result in unexpected behavior.
	NoInit bool
}

// Starts a Service and creates a tunnel that forwards traffic from the caller's network to that service.
//
// Be sure to set any exposed ports before calling this api.
func (r *Container) Up(ctx context.Context, opts ...ContainerUpOpts) error {
	if r.up != nil {
		return nil
	}
	q := r.query.Select("up")
	for i := len(opts) - 1; i >= 0; i-- {
		// `random` optional argument
		if !querybuilder.IsZeroValue(opts[i].Random) {
			q = q.Arg("random", opts[i].Random)
		}
		// `ports` optional argument
		if !querybuilder.IsZeroValue(opts[i].Ports) {
			q = q.Arg("ports", opts[i].Ports)
		}
		// `args` optional argument
		if !querybuilder.IsZeroValue(opts[i].Args) {
			q = q.Arg("args", opts[i].Args)
		}
		// `useEntrypoint` optional argument
		if !querybuilder.IsZeroValue(opts[i].UseEntrypoint) {
			q = q.Arg("useEntrypoint", opts[i].UseEntrypoint)
		}
		// `experimentalPrivilegedNesting` optional argument
		if !querybuilder.IsZeroValue(opts[i].ExperimentalPrivilegedNesting) {
			q = q.Arg("experimentalPrivilegedNesting", opts[i].ExperimentalPrivilegedNesting)
		}
		// `insecureRootCapabilities` optional argument
		if !querybuilder.IsZeroValue(opts[i].InsecureRootCapabilities) {
			q = q.Arg("insecureRootCapabilities", opts[i].InsecureRootCapabilities)
		}
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
		// `noInit` optional argument
		if !querybuilder.IsZeroValue(opts[i].NoInit) {
			q = q.Arg("noInit", opts[i].NoInit)
		}
	}

	return q.Execute(ctx)
}

// Retrieves the user to be set for all commands.
func (r *Container) User(ctx context.Context) (string, error) {
	if r.user != nil {
		return *r.user, nil
	}
	q := r.query.Select("user")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Retrieves this container plus the given OCI anotation.
func (r *Container) WithAnnotation(name string, value string) *Container {
	q := r.query.Select("withAnnotation")
	q = q.Arg("name", name)
	q = q.Arg("value", value)

	return &Container{
		query: q,
	}
}

// Configures default arguments for future commands. Like CMD in Dockerfile.
func (r *Container) WithDefaultArgs(args []string) *Container {
	q := r.query.Select("withDefaultArgs")
	q = q.Arg("args", args)

	return &Container{
		query: q,
	}
}

// ContainerWithDefaultTerminalCmdOpts contains options for Container.WithDefaultTerminalCmd
type ContainerWithDefaultTerminalCmdOpts struct {
	// Provides Dagger access to the executed command.
	ExperimentalPrivilegedNesting bool
	// Execute the command with all root capabilities. This is similar to running a command with "sudo" or executing "docker run" with the "--privileged" flag. Containerization does not provide any security guarantees when using this option. It should only be used when absolutely necessary and only with trusted commands.
	InsecureRootCapabilities bool
}

// Set the default command to invoke for the container's terminal API.
func (r *Container) WithDefaultTerminalCmd(args []string, opts ...ContainerWithDefaultTerminalCmdOpts) *Container {
	q := r.query.Select("withDefaultTerminalCmd")
	for i := len(opts) - 1; i >= 0; i-- {
		// `experimentalPrivilegedNesting` optional argument
		if !querybuilder.IsZeroValue(opts[i].ExperimentalPrivilegedNesting) {
			q = q.Arg("experimentalPrivilegedNesting", opts[i].ExperimentalPrivilegedNesting)
		}
		// `insecureRootCapabilities` optional argument
		if !querybuilder.IsZeroValue(opts[i].InsecureRootCapabilities) {
			q = q.Arg("insecureRootCapabilities", opts[i].InsecureRootCapabilities)
		}
	}
	q = q.Arg("args", args)

	return &Container{
		query: q,
	}
}

// ContainerWithDirectoryOpts contains options for Container.WithDirectory
type ContainerWithDirectoryOpts struct {
	// Patterns to exclude in the written directory (e.g. ["node_modules/**", ".gitignore", ".git/"]).
	Exclude []string
	// Patterns to include in the written directory (e.g. ["*.go", "go.mod", "go.sum"]).
	Include []string
	// A user:group to set for the directory and its contents.
	//
	// The user and group can either be an ID (1000:1000) or a name (foo:bar).
	//
	// If the group is omitted, it defaults to the same as the user.
	Owner string
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo").
	Expand bool
}

// Return a new container snapshot, with a directory added to its filesystem
func (r *Container) WithDirectory(path string, directory *Directory, opts ...ContainerWithDirectoryOpts) *Container {
	assertNotNil("directory", directory)
	q := r.query.Select("withDirectory")
	for i := len(opts) - 1; i >= 0; i-- {
		// `exclude` optional argument
		if !querybuilder.IsZeroValue(opts[i].Exclude) {
			q = q.Arg("exclude", opts[i].Exclude)
		}
		// `include` optional argument
		if !querybuilder.IsZeroValue(opts[i].Include) {
			q = q.Arg("include", opts[i].Include)
		}
		// `owner` optional argument
		if !querybuilder.IsZeroValue(opts[i].Owner) {
			q = q.Arg("owner", opts[i].Owner)
		}
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)
	q = q.Arg("directory", directory)

	return &Container{
		query: q,
	}
}

// ContainerWithEntrypointOpts contains options for Container.WithEntrypoint
type ContainerWithEntrypointOpts struct {
	// Don't reset the default arguments when setting the entrypoint. By default it is reset, since entrypoint and default args are often tightly coupled.
	KeepDefaultArgs bool
}

// Set an OCI-style entrypoint. It will be included in the container's OCI configuration. Note, withExec ignores the entrypoint by default.
func (r *Container) WithEntrypoint(args []string, opts ...ContainerWithEntrypointOpts) *Container {
	q := r.query.Select("withEntrypoint")
	for i := len(opts) - 1; i >= 0; i-- {
		// `keepDefaultArgs` optional argument
		if !querybuilder.IsZeroValue(opts[i].KeepDefaultArgs) {
			q = q.Arg("keepDefaultArgs", opts[i].KeepDefaultArgs)
		}
	}
	q = q.Arg("args", args)

	return &Container{
		query: q,
	}
}

// ContainerWithEnvVariableOpts contains options for Container.WithEnvVariable
type ContainerWithEnvVariableOpts struct {
	// Replace "${VAR}" or "$VAR" in the value according to the current environment variables defined in the container (e.g. "/opt/bin:$PATH").
	Expand bool
}

// Set a new environment variable in the container.
func (r *Container) WithEnvVariable(name string, value string, opts ...ContainerWithEnvVariableOpts) *Container {
	q := r.query.Select("withEnvVariable")
	for i := len(opts) - 1; i >= 0; i-- {
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("name", name)
	q = q.Arg("value", value)

	return &Container{
		query: q,
	}
}

// ContainerWithExecOpts contains options for Container.WithExec
type ContainerWithExecOpts struct {
	// Apply the OCI entrypoint, if present, by prepending it to the args. Ignored by default.
	UseEntrypoint bool
	// Content to write to the command's standard input. Example: "Hello world")
	Stdin string
	// Redirect the command's standard output to a file in the container. Example: "./stdout.txt"
	RedirectStdout string
	// Like redirectStdout, but for standard error
	RedirectStderr string
	// Exit codes this command is allowed to exit with without error
	//
	// Default: SUCCESS
	Expect ReturnType
	// Provides Dagger access to the executed command.
	ExperimentalPrivilegedNesting bool
	// Execute the command with all root capabilities. Like --privileged in Docker
	//
	// DANGER: this grants the command full access to the host system. Only use when 1) you trust the command being executed and 2) you specifically need this level of access.
	InsecureRootCapabilities bool
	// Replace "${VAR}" or "$VAR" in the args according to the current environment variables defined in the container (e.g. "/$VAR/foo").
	Expand bool
	// Skip the automatic init process injected into containers by default.
	//
	// Only use this if you specifically need the command to be pid 1 in the container. Otherwise it may result in unexpected behavior. If you're not sure, you don't need this.
	NoInit bool
}

// Execute a command in the container, and return a new snapshot of the container state after execution.
func (r *Container) WithExec(args []string, opts ...ContainerWithExecOpts) *Container {
	q := r.query.Select("withExec")
	for i := len(opts) - 1; i >= 0; i-- {
		// `useEntrypoint` optional argument
		if !querybuilder.IsZeroValue(opts[i].UseEntrypoint) {
			q = q.Arg("useEntrypoint", opts[i].UseEntrypoint)
		}
		// `stdin` optional argument
		if !querybuilder.IsZeroValue(opts[i].Stdin) {
			q = q.Arg("stdin", opts[i].Stdin)
		}
		// `redirectStdout` optional argument
		if !querybuilder.IsZeroValue(opts[i].RedirectStdout) {
			q = q.Arg("redirectStdout", opts[i].RedirectStdout)
		}
		// `redirectStderr` optional argument
		if !querybuilder.IsZeroValue(opts[i].RedirectStderr) {
			q = q.Arg("redirectStderr", opts[i].RedirectStderr)
		}
		// `expect` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expect) {
			q = q.Arg("expect", opts[i].Expect)
		}
		// `experimentalPrivilegedNesting` optional argument
		if !querybuilder.IsZeroValue(opts[i].ExperimentalPrivilegedNesting) {
			q = q.Arg("experimentalPrivilegedNesting", opts[i].ExperimentalPrivilegedNesting)
		}
		// `insecureRootCapabilities` optional argument
		if !querybuilder.IsZeroValue(opts[i].InsecureRootCapabilities) {
			q = q.Arg("insecureRootCapabilities", opts[i].InsecureRootCapabilities)
		}
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
		// `noInit` optional argument
		if !querybuilder.IsZeroValue(opts[i].NoInit) {
			q = q.Arg("noInit", opts[i].NoInit)
		}
	}
	q = q.Arg("args", args)

	return &Container{
		query: q,
	}
}

// ContainerWithExposedPortOpts contains options for Container.WithExposedPort
type ContainerWithExposedPortOpts struct {
	// Network protocol. Example: "tcp"
	//
	// Default: TCP
	Protocol NetworkProtocol
	// Port description. Example: "payment API endpoint"
	Description string
	// Skip the health check when run as a service.
	ExperimentalSkipHealthcheck bool
}

// Expose a network port. Like EXPOSE in Dockerfile (but with healthcheck support)
//
// Exposed ports serve two purposes:
//
// - For health checks and introspection, when running services
//
// - For setting the EXPOSE OCI field when publishing the container
func (r *Container) WithExposedPort(port int, opts ...ContainerWithExposedPortOpts) *Container {
	q := r.query.Select("withExposedPort")
	for i := len(opts) - 1; i >= 0; i-- {
		// `protocol` optional argument
		if !querybuilder.IsZeroValue(opts[i].Protocol) {
			q = q.Arg("protocol", opts[i].Protocol)
		}
		// `description` optional argument
		if !querybuilder.IsZeroValue(opts[i].Description) {
			q = q.Arg("description", opts[i].Description)
		}
		// `experimentalSkipHealthcheck` optional argument
		if !querybuilder.IsZeroValue(opts[i].ExperimentalSkipHealthcheck) {
			q = q.Arg("experimentalSkipHealthcheck", opts[i].ExperimentalSkipHealthcheck)
		}
	}
	q = q.Arg("port", port)

	return &Container{
		query: q,
	}
}

// ContainerWithFileOpts contains options for Container.WithFile
type ContainerWithFileOpts struct {
	// Permissions of the new file. Example: 0600
	Permissions int
	// A user:group to set for the file.
	//
	// The user and group can either be an ID (1000:1000) or a name (foo:bar).
	//
	// If the group is omitted, it defaults to the same as the user.
	Owner string
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo.txt").
	Expand bool
}

// Return a container snapshot with a file added
func (r *Container) WithFile(path string, source *File, opts ...ContainerWithFileOpts) *Container {
	assertNotNil("source", source)
	q := r.query.Select("withFile")
	for i := len(opts) - 1; i >= 0; i-- {
		// `permissions` optional argument
		if !querybuilder.IsZeroValue(opts[i].Permissions) {
			q = q.Arg("permissions", opts[i].Permissions)
		}
		// `owner` optional argument
		if !querybuilder.IsZeroValue(opts[i].Owner) {
			q = q.Arg("owner", opts[i].Owner)
		}
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)
	q = q.Arg("source", source)

	return &Container{
		query: q,
	}
}

// ContainerWithFilesOpts contains options for Container.WithFiles
type ContainerWithFilesOpts struct {
	// Permission given to the copied files (e.g., 0600).
	Permissions int
	// A user:group to set for the files.
	//
	// The user and group can either be an ID (1000:1000) or a name (foo:bar).
	//
	// If the group is omitted, it defaults to the same as the user.
	Owner string
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo.txt").
	Expand bool
}

// Retrieves this container plus the contents of the given files copied to the given path.
func (r *Container) WithFiles(path string, sources []*File, opts ...ContainerWithFilesOpts) *Container {
	q := r.query.Select("withFiles")
	for i := len(opts) - 1; i >= 0; i-- {
		// `permissions` optional argument
		if !querybuilder.IsZeroValue(opts[i].Permissions) {
			q = q.Arg("permissions", opts[i].Permissions)
		}
		// `owner` optional argument
		if !querybuilder.IsZeroValue(opts[i].Owner) {
			q = q.Arg("owner", opts[i].Owner)
		}
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)
	q = q.Arg("sources", sources)

	return &Container{
		query: q,
	}
}

// Retrieves this container plus the given label.
func (r *Container) WithLabel(name string, value string) *Container {
	q := r.query.Select("withLabel")
	q = q.Arg("name", name)
	q = q.Arg("value", value)

	return &Container{
		query: q,
	}
}

// ContainerWithMountedCacheOpts contains options for Container.WithMountedCache
type ContainerWithMountedCacheOpts struct {
	// Identifier of the directory to use as the cache volume's root.
	Source *Directory
	// Sharing mode of the cache volume.
	//
	// Default: SHARED
	Sharing CacheSharingMode
	// A user:group to set for the mounted cache directory.
	//
	// Note that this changes the ownership of the specified mount along with the initial filesystem provided by source (if any). It does not have any effect if/when the cache has already been created.
	//
	// The user and group can either be an ID (1000:1000) or a name (foo:bar).
	//
	// If the group is omitted, it defaults to the same as the user.
	Owner string
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo").
	Expand bool
}

// Retrieves this container plus a cache volume mounted at the given path.
func (r *Container) WithMountedCache(path string, cache *CacheVolume, opts ...ContainerWithMountedCacheOpts) *Container {
	assertNotNil("cache", cache)
	q := r.query.Select("withMountedCache")
	for i := len(opts) - 1; i >= 0; i-- {
		// `source` optional argument
		if !querybuilder.IsZeroValue(opts[i].Source) {
			q = q.Arg("source", opts[i].Source)
		}
		// `sharing` optional argument
		if !querybuilder.IsZeroValue(opts[i].Sharing) {
			q = q.Arg("sharing", opts[i].Sharing)
		}
		// `owner` optional argument
		if !querybuilder.IsZeroValue(opts[i].Owner) {
			q = q.Arg("owner", opts[i].Owner)
		}
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)
	q = q.Arg("cache", cache)

	return &Container{
		query: q,
	}
}

// ContainerWithMountedDirectoryOpts contains options for Container.WithMountedDirectory
type ContainerWithMountedDirectoryOpts struct {
	// A user:group to set for the mounted directory and its contents.
	//
	// The user and group can either be an ID (1000:1000) or a name (foo:bar).
	//
	// If the group is omitted, it defaults to the same as the user.
	Owner string
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo").
	Expand bool
}

// Retrieves this container plus a directory mounted at the given path.
func (r *Container) WithMountedDirectory(path string, source *Directory, opts ...ContainerWithMountedDirectoryOpts) *Container {
	assertNotNil("source", source)
	q := r.query.Select("withMountedDirectory")
	for i := len(opts) - 1; i >= 0; i-- {
		// `owner` optional argument
		if !querybuilder.IsZeroValue(opts[i].Owner) {
			q = q.Arg("owner", opts[i].Owner)
		}
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)
	q = q.Arg("source", source)

	return &Container{
		query: q,
	}
}

// ContainerWithMountedFileOpts contains options for Container.WithMountedFile
type ContainerWithMountedFileOpts struct {
	// A user or user:group to set for the mounted file.
	//
	// The user and group can either be an ID (1000:1000) or a name (foo:bar).
	//
	// If the group is omitted, it defaults to the same as the user.
	Owner string
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo.txt").
	Expand bool
}

// Retrieves this container plus a file mounted at the given path.
func (r *Container) WithMountedFile(path string, source *File, opts ...ContainerWithMountedFileOpts) *Container {
	assertNotNil("source", source)
	q := r.query.Select("withMountedFile")
	for i := len(opts) - 1; i >= 0; i-- {
		// `owner` optional argument
		if !querybuilder.IsZeroValue(opts[i].Owner) {
			q = q.Arg("owner", opts[i].Owner)
		}
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)
	q = q.Arg("source", source)

	return &Container{
		query: q,
	}
}

// ContainerWithMountedSecretOpts contains options for Container.WithMountedSecret
type ContainerWithMountedSecretOpts struct {
	// A user:group to set for the mounted secret.
	//
	// The user and group can either be an ID (1000:1000) or a name (foo:bar).
	//
	// If the group is omitted, it defaults to the same as the user.
	Owner string
	// Permission given to the mounted secret (e.g., 0600).
	//
	// This option requires an owner to be set to be active.
	//
	// Default: 256
	Mode int
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo").
	Expand bool
}

// Retrieves this container plus a secret mounted into a file at the given path.
func (r *Container) WithMountedSecret(path string, source *Secret, opts ...ContainerWithMountedSecretOpts) *Container {
	assertNotNil("source", source)
	q := r.query.Select("withMountedSecret")
	for i := len(opts) - 1; i >= 0; i-- {
		// `owner` optional argument
		if !querybuilder.IsZeroValue(opts[i].Owner) {
			q = q.Arg("owner", opts[i].Owner)
		}
		// `mode` optional argument
		if !querybuilder.IsZeroValue(opts[i].Mode) {
			q = q.Arg("mode", opts[i].Mode)
		}
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)
	q = q.Arg("source", source)

	return &Container{
		query: q,
	}
}

// ContainerWithMountedTempOpts contains options for Container.WithMountedTemp
type ContainerWithMountedTempOpts struct {
	// Size of the temporary directory in bytes.
	Size int
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo").
	Expand bool
}

// Retrieves this container plus a temporary directory mounted at the given path. Any writes will be ephemeral to a single withExec call; they will not be persisted to subsequent withExecs.
func (r *Container) WithMountedTemp(path string, opts ...ContainerWithMountedTempOpts) *Container {
	q := r.query.Select("withMountedTemp")
	for i := len(opts) - 1; i >= 0; i-- {
		// `size` optional argument
		if !querybuilder.IsZeroValue(opts[i].Size) {
			q = q.Arg("size", opts[i].Size)
		}
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)

	return &Container{
		query: q,
	}
}

// ContainerWithNewFileOpts contains options for Container.WithNewFile
type ContainerWithNewFileOpts struct {
	// Permissions of the new file. Example: 0600
	//
	// Default: 420
	Permissions int
	// A user:group to set for the file.
	//
	// The user and group can either be an ID (1000:1000) or a name (foo:bar).
	//
	// If the group is omitted, it defaults to the same as the user.
	Owner string
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo.txt").
	Expand bool
}

// Return a new container snapshot, with a file added to its filesystem with text content
func (r *Container) WithNewFile(path string, contents string, opts ...ContainerWithNewFileOpts) *Container {
	q := r.query.Select("withNewFile")
	for i := len(opts) - 1; i >= 0; i-- {
		// `permissions` optional argument
		if !querybuilder.IsZeroValue(opts[i].Permissions) {
			q = q.Arg("permissions", opts[i].Permissions)
		}
		// `owner` optional argument
		if !querybuilder.IsZeroValue(opts[i].Owner) {
			q = q.Arg("owner", opts[i].Owner)
		}
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)
	q = q.Arg("contents", contents)

	return &Container{
		query: q,
	}
}

// Attach credentials for future publishing to a registry. Use in combination with publish
func (r *Container) WithRegistryAuth(address string, username string, secret *Secret) *Container {
	assertNotNil("secret", secret)
	q := r.query.Select("withRegistryAuth")
	q = q.Arg("address", address)
	q = q.Arg("username", username)
	q = q.Arg("secret", secret)

	return &Container{
		query: q,
	}
}

// Change the container's root filesystem. The previous root filesystem will be lost.
func (r *Container) WithRootfs(directory *Directory) *Container {
	assertNotNil("directory", directory)
	q := r.query.Select("withRootfs")
	q = q.Arg("directory", directory)

	return &Container{
		query: q,
	}
}

// Set a new environment variable, using a secret value
func (r *Container) WithSecretVariable(name string, secret *Secret) *Container {
	assertNotNil("secret", secret)
	q := r.query.Select("withSecretVariable")
	q = q.Arg("name", name)
	q = q.Arg("secret", secret)

	return &Container{
		query: q,
	}
}

// Establish a runtime dependency from a container to a network service.
//
// The service will be started automatically when needed and detached when it is no longer needed, executing the default command if none is set.
//
// The service will be reachable from the container via the provided hostname alias.
//
// The service dependency will also convey to any files or directories produced by the container.
func (r *Container) WithServiceBinding(alias string, service *Service) *Container {
	assertNotNil("service", service)
	q := r.query.Select("withServiceBinding")
	q = q.Arg("alias", alias)
	q = q.Arg("service", service)

	return &Container{
		query: q,
	}
}

// ContainerWithSymlinkOpts contains options for Container.WithSymlink
type ContainerWithSymlinkOpts struct {
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo.txt").
	Expand bool
}

// Return a snapshot with a symlink
func (r *Container) WithSymlink(target string, linkName string, opts ...ContainerWithSymlinkOpts) *Container {
	q := r.query.Select("withSymlink")
	for i := len(opts) - 1; i >= 0; i-- {
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("target", target)
	q = q.Arg("linkName", linkName)

	return &Container{
		query: q,
	}
}

// ContainerWithUnixSocketOpts contains options for Container.WithUnixSocket
type ContainerWithUnixSocketOpts struct {
	// A user:group to set for the mounted socket.
	//
	// The user and group can either be an ID (1000:1000) or a name (foo:bar).
	//
	// If the group is omitted, it defaults to the same as the user.
	Owner string
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo").
	Expand bool
}

// Retrieves this container plus a socket forwarded to the given Unix socket path.
func (r *Container) WithUnixSocket(path string, source *Socket, opts ...ContainerWithUnixSocketOpts) *Container {
	assertNotNil("source", source)
	q := r.query.Select("withUnixSocket")
	for i := len(opts) - 1; i >= 0; i-- {
		// `owner` optional argument
		if !querybuilder.IsZeroValue(opts[i].Owner) {
			q = q.Arg("owner", opts[i].Owner)
		}
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)
	q = q.Arg("source", source)

	return &Container{
		query: q,
	}
}

// Retrieves this container with a different command user.
func (r *Container) WithUser(name string) *Container {
	q := r.query.Select("withUser")
	q = q.Arg("name", name)

	return &Container{
		query: q,
	}
}

// ContainerWithWorkdirOpts contains options for Container.WithWorkdir
type ContainerWithWorkdirOpts struct {
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo").
	Expand bool
}

// Change the container's working directory. Like WORKDIR in Dockerfile.
func (r *Container) WithWorkdir(path string, opts ...ContainerWithWorkdirOpts) *Container {
	q := r.query.Select("withWorkdir")
	for i := len(opts) - 1; i >= 0; i-- {
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)

	return &Container{
		query: q,
	}
}

// Retrieves this container minus the given OCI annotation.
func (r *Container) WithoutAnnotation(name string) *Container {
	q := r.query.Select("withoutAnnotation")
	q = q.Arg("name", name)

	return &Container{
		query: q,
	}
}

// Remove the container's default arguments.
func (r *Container) WithoutDefaultArgs() *Container {
	q := r.query.Select("withoutDefaultArgs")

	return &Container{
		query: q,
	}
}

// ContainerWithoutDirectoryOpts contains options for Container.WithoutDirectory
type ContainerWithoutDirectoryOpts struct {
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo").
	Expand bool
}

// Return a new container snapshot, with a directory removed from its filesystem
func (r *Container) WithoutDirectory(path string, opts ...ContainerWithoutDirectoryOpts) *Container {
	q := r.query.Select("withoutDirectory")
	for i := len(opts) - 1; i >= 0; i-- {
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)

	return &Container{
		query: q,
	}
}

// ContainerWithoutEntrypointOpts contains options for Container.WithoutEntrypoint
type ContainerWithoutEntrypointOpts struct {
	// Don't remove the default arguments when unsetting the entrypoint.
	KeepDefaultArgs bool
}

// Reset the container's OCI entrypoint.
func (r *Container) WithoutEntrypoint(opts ...ContainerWithoutEntrypointOpts) *Container {
	q := r.query.Select("withoutEntrypoint")
	for i := len(opts) - 1; i >= 0; i-- {
		// `keepDefaultArgs` optional argument
		if !querybuilder.IsZeroValue(opts[i].KeepDefaultArgs) {
			q = q.Arg("keepDefaultArgs", opts[i].KeepDefaultArgs)
		}
	}

	return &Container{
		query: q,
	}
}

// Retrieves this container minus the given environment variable.
func (r *Container) WithoutEnvVariable(name string) *Container {
	q := r.query.Select("withoutEnvVariable")
	q = q.Arg("name", name)

	return &Container{
		query: q,
	}
}

// ContainerWithoutExposedPortOpts contains options for Container.WithoutExposedPort
type ContainerWithoutExposedPortOpts struct {
	// Port protocol to unexpose
	//
	// Default: TCP
	Protocol NetworkProtocol
}

// Unexpose a previously exposed port.
func (r *Container) WithoutExposedPort(port int, opts ...ContainerWithoutExposedPortOpts) *Container {
	q := r.query.Select("withoutExposedPort")
	for i := len(opts) - 1; i >= 0; i-- {
		// `protocol` optional argument
		if !querybuilder.IsZeroValue(opts[i].Protocol) {
			q = q.Arg("protocol", opts[i].Protocol)
		}
	}
	q = q.Arg("port", port)

	return &Container{
		query: q,
	}
}

// ContainerWithoutFileOpts contains options for Container.WithoutFile
type ContainerWithoutFileOpts struct {
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo.txt").
	Expand bool
}

// Retrieves this container with the file at the given path removed.
func (r *Container) WithoutFile(path string, opts ...ContainerWithoutFileOpts) *Container {
	q := r.query.Select("withoutFile")
	for i := len(opts) - 1; i >= 0; i-- {
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)

	return &Container{
		query: q,
	}
}

// ContainerWithoutFilesOpts contains options for Container.WithoutFiles
type ContainerWithoutFilesOpts struct {
	// Replace "${VAR}" or "$VAR" in the value of paths according to the current environment variables defined in the container (e.g. "/$VAR/foo.txt").
	Expand bool
}

// Return a new container spanshot with specified files removed
func (r *Container) WithoutFiles(paths []string, opts ...ContainerWithoutFilesOpts) *Container {
	q := r.query.Select("withoutFiles")
	for i := len(opts) - 1; i >= 0; i-- {
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("paths", paths)

	return &Container{
		query: q,
	}
}

// Retrieves this container minus the given environment label.
func (r *Container) WithoutLabel(name string) *Container {
	q := r.query.Select("withoutLabel")
	q = q.Arg("name", name)

	return &Container{
		query: q,
	}
}

// ContainerWithoutMountOpts contains options for Container.WithoutMount
type ContainerWithoutMountOpts struct {
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo").
	Expand bool
}

// Retrieves this container after unmounting everything at the given path.
func (r *Container) WithoutMount(path string, opts ...ContainerWithoutMountOpts) *Container {
	q := r.query.Select("withoutMount")
	for i := len(opts) - 1; i >= 0; i-- {
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)

	return &Container{
		query: q,
	}
}

// Retrieves this container without the registry authentication of a given address.
func (r *Container) WithoutRegistryAuth(address string) *Container {
	q := r.query.Select("withoutRegistryAuth")
	q = q.Arg("address", address)

	return &Container{
		query: q,
	}
}

// Retrieves this container minus the given environment variable containing the secret.
func (r *Container) WithoutSecretVariable(name string) *Container {
	q := r.query.Select("withoutSecretVariable")
	q = q.Arg("name", name)

	return &Container{
		query: q,
	}
}

// ContainerWithoutUnixSocketOpts contains options for Container.WithoutUnixSocket
type ContainerWithoutUnixSocketOpts struct {
	// Replace "${VAR}" or "$VAR" in the value of path according to the current environment variables defined in the container (e.g. "/$VAR/foo").
	Expand bool
}

// Retrieves this container with a previously added Unix socket removed.
func (r *Container) WithoutUnixSocket(path string, opts ...ContainerWithoutUnixSocketOpts) *Container {
	q := r.query.Select("withoutUnixSocket")
	for i := len(opts) - 1; i >= 0; i-- {
		// `expand` optional argument
		if !querybuilder.IsZeroValue(opts[i].Expand) {
			q = q.Arg("expand", opts[i].Expand)
		}
	}
	q = q.Arg("path", path)

	return &Container{
		query: q,
	}
}

// Retrieves this container with an unset command user.
//
// Should default to root.
func (r *Container) WithoutUser() *Container {
	q := r.query.Select("withoutUser")

	return &Container{
		query: q,
	}
}

// Unset the container's working directory.
//
// Should default to "/".
func (r *Container) WithoutWorkdir() *Container {
	q := r.query.Select("withoutWorkdir")

	return &Container{
		query: q,
	}
}

// Retrieves the working directory for all commands.
func (r *Container) Workdir(ctx context.Context) (string, error) {
	if r.workdir != nil {
		return *r.workdir, nil
	}
	q := r.query.Select("workdir")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Reflective module API provided to functions at runtime.
type CurrentModule struct {
	query *querybuilder.Selection

	id   *CurrentModuleID
	name *string
}

func (r *CurrentModule) WithGraphQLQuery(q *querybuilder.Selection) *CurrentModule {
	return &CurrentModule{
		query: q,
	}
}

// A unique identifier for this CurrentModule.
func (r *CurrentModule) ID(ctx context.Context) (CurrentModuleID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response CurrentModuleID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *CurrentModule) XXX_GraphQLType() string {
	return "CurrentModule"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *CurrentModule) XXX_GraphQLIDType() string {
	return "CurrentModuleID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *CurrentModule) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *CurrentModule) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *CurrentModule) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadCurrentModuleFromID(CurrentModuleID(id))
	return nil
}

// The name of the module being executed in
func (r *CurrentModule) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The directory containing the module's source code loaded into the engine (plus any generated code that may have been created).
func (r *CurrentModule) Source() *Directory {
	q := r.query.Select("source")

	return &Directory{
		query: q,
	}
}

// CurrentModuleWorkdirOpts contains options for CurrentModule.Workdir
type CurrentModuleWorkdirOpts struct {
	// Exclude artifacts that match the given pattern (e.g., ["node_modules/", ".git*"]).
	Exclude []string
	// Include only artifacts that match the given pattern (e.g., ["app/", "package.*"]).
	Include []string
}

// Load a directory from the module's scratch working directory, including any changes that may have been made to it during module function execution.
func (r *CurrentModule) Workdir(path string, opts ...CurrentModuleWorkdirOpts) *Directory {
	q := r.query.Select("workdir")
	for i := len(opts) - 1; i >= 0; i-- {
		// `exclude` optional argument
		if !querybuilder.IsZeroValue(opts[i].Exclude) {
			q = q.Arg("exclude", opts[i].Exclude)
		}
		// `include` optional argument
		if !querybuilder.IsZeroValue(opts[i].Include) {
			q = q.Arg("include", opts[i].Include)
		}
	}
	q = q.Arg("path", path)

	return &Directory{
		query: q,
	}
}

// Load a file from the module's scratch working directory, including any changes that may have been made to it during module function execution.Load a file from the module's scratch working directory, including any changes that may have been made to it during module function execution.
func (r *CurrentModule) WorkdirFile(path string) *File {
	q := r.query.Select("workdirFile")
	q = q.Arg("path", path)

	return &File{
		query: q,
	}
}

// A directory.
type Directory struct {
	query *querybuilder.Selection

	digest *string
	export *string
	id     *DirectoryID
	name   *string
	sync   *DirectoryID
}
type WithDirectoryFunc func(r *Directory) *Directory

// With calls the provided function with current Directory.
//
// This is useful for reusability and readability by not breaking the calling chain.
func (r *Directory) With(f WithDirectoryFunc) *Directory {
	return f(r)
}

func (r *Directory) WithGraphQLQuery(q *querybuilder.Selection) *Directory {
	return &Directory{
		query: q,
	}
}

// Converts this directory to a local git repository
func (r *Directory) AsGit() *GitRepository {
	q := r.query.Select("asGit")

	return &GitRepository{
		query: q,
	}
}

// DirectoryAsModuleOpts contains options for Directory.AsModule
type DirectoryAsModuleOpts struct {
	// An optional subpath of the directory which contains the module's configuration file.
	//
	// If not set, the module source code is loaded from the root of the directory.
	//
	// Default: "."
	SourceRootPath string
}

// Load the directory as a Dagger module source
func (r *Directory) AsModule(opts ...DirectoryAsModuleOpts) *Module {
	q := r.query.Select("asModule")
	for i := len(opts) - 1; i >= 0; i-- {
		// `sourceRootPath` optional argument
		if !querybuilder.IsZeroValue(opts[i].SourceRootPath) {
			q = q.Arg("sourceRootPath", opts[i].SourceRootPath)
		}
	}

	return &Module{
		query: q,
	}
}

// DirectoryAsModuleSourceOpts contains options for Directory.AsModuleSource
type DirectoryAsModuleSourceOpts struct {
	// An optional subpath of the directory which contains the module's configuration file.
	//
	// If not set, the module source code is loaded from the root of the directory.
	//
	// Default: "."
	SourceRootPath string
}

// Load the directory as a Dagger module source
func (r *Directory) AsModuleSource(opts ...DirectoryAsModuleSourceOpts) *ModuleSource {
	q := r.query.Select("asModuleSource")
	for i := len(opts) - 1; i >= 0; i-- {
		// `sourceRootPath` optional argument
		if !querybuilder.IsZeroValue(opts[i].SourceRootPath) {
			q = q.Arg("sourceRootPath", opts[i].SourceRootPath)
		}
	}

	return &ModuleSource{
		query: q,
	}
}

// Return the difference between this directory and an another directory. The difference is encoded as a directory.
func (r *Directory) Diff(other *Directory) *Directory {
	assertNotNil("other", other)
	q := r.query.Select("diff")
	q = q.Arg("other", other)

	return &Directory{
		query: q,
	}
}

// Return the directory's digest. The format of the digest is not guaranteed to be stable between releases of Dagger. It is guaranteed to be stable between invocations of the same Dagger engine.
func (r *Directory) Digest(ctx context.Context) (string, error) {
	if r.digest != nil {
		return *r.digest, nil
	}
	q := r.query.Select("digest")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Retrieves a directory at the given path.
func (r *Directory) Directory(path string) *Directory {
	q := r.query.Select("directory")
	q = q.Arg("path", path)

	return &Directory{
		query: q,
	}
}

// DirectoryDockerBuildOpts contains options for Directory.DockerBuild
type DirectoryDockerBuildOpts struct {
	// Path to the Dockerfile to use (e.g., "frontend.Dockerfile").
	//
	// Default: "Dockerfile"
	Dockerfile string
	// The platform to build.
	Platform Platform
	// Build arguments to use in the build.
	BuildArgs []BuildArg
	// Target build stage to build.
	Target string
	// Secrets to pass to the build.
	//
	// They will be mounted at /run/secrets/[secret-name].
	Secrets []*Secret
	// If set, skip the automatic init process injected into containers created by RUN statements.
	//
	// This should only be used if the user requires that their exec processes be the pid 1 process in the container. Otherwise it may result in unexpected behavior.
	NoInit bool
}

// Use Dockerfile compatibility to build a container from this directory. Only use this function for Dockerfile compatibility. Otherwise use the native Container type directly, it is feature-complete and supports all Dockerfile features.
func (r *Directory) DockerBuild(opts ...DirectoryDockerBuildOpts) *Container {
	q := r.query.Select("dockerBuild")
	for i := len(opts) - 1; i >= 0; i-- {
		// `dockerfile` optional argument
		if !querybuilder.IsZeroValue(opts[i].Dockerfile) {
			q = q.Arg("dockerfile", opts[i].Dockerfile)
		}
		// `platform` optional argument
		if !querybuilder.IsZeroValue(opts[i].Platform) {
			q = q.Arg("platform", opts[i].Platform)
		}
		// `buildArgs` optional argument
		if !querybuilder.IsZeroValue(opts[i].BuildArgs) {
			q = q.Arg("buildArgs", opts[i].BuildArgs)
		}
		// `target` optional argument
		if !querybuilder.IsZeroValue(opts[i].Target) {
			q = q.Arg("target", opts[i].Target)
		}
		// `secrets` optional argument
		if !querybuilder.IsZeroValue(opts[i].Secrets) {
			q = q.Arg("secrets", opts[i].Secrets)
		}
		// `noInit` optional argument
		if !querybuilder.IsZeroValue(opts[i].NoInit) {
			q = q.Arg("noInit", opts[i].NoInit)
		}
	}

	return &Container{
		query: q,
	}
}

// DirectoryEntriesOpts contains options for Directory.Entries
type DirectoryEntriesOpts struct {
	// Location of the directory to look at (e.g., "/src").
	Path string
}

// Returns a list of files and directories at the given path.
func (r *Directory) Entries(ctx context.Context, opts ...DirectoryEntriesOpts) ([]string, error) {
	q := r.query.Select("entries")
	for i := len(opts) - 1; i >= 0; i-- {
		// `path` optional argument
		if !querybuilder.IsZeroValue(opts[i].Path) {
			q = q.Arg("path", opts[i].Path)
		}
	}

	var response []string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// DirectoryExportOpts contains options for Directory.Export
type DirectoryExportOpts struct {
	// If true, then the host directory will be wiped clean before exporting so that it exactly matches the directory being exported; this means it will delete any files on the host that aren't in the exported dir. If false (the default), the contents of the directory will be merged with any existing contents of the host directory, leaving any existing files on the host that aren't in the exported directory alone.
	Wipe bool
}

// Writes the contents of the directory to a path on the host.
func (r *Directory) Export(ctx context.Context, path string, opts ...DirectoryExportOpts) (string, error) {
	if r.export != nil {
		return *r.export, nil
	}
	q := r.query.Select("export")
	for i := len(opts) - 1; i >= 0; i-- {
		// `wipe` optional argument
		if !querybuilder.IsZeroValue(opts[i].Wipe) {
			q = q.Arg("wipe", opts[i].Wipe)
		}
	}
	q = q.Arg("path", path)

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Retrieve a file at the given path.
func (r *Directory) File(path string) *File {
	q := r.query.Select("file")
	q = q.Arg("path", path)

	return &File{
		query: q,
	}
}

// DirectoryFilterOpts contains options for Directory.Filter
type DirectoryFilterOpts struct {
	// If set, paths matching one of these glob patterns is excluded from the new snapshot. Example: ["node_modules/", ".git*", ".env"]
	Exclude []string
	// If set, only paths matching one of these glob patterns is included in the new snapshot. Example: (e.g., ["app/", "package.*"]).
	Include []string
}

// Return a snapshot with some paths included or excluded
func (r *Directory) Filter(opts ...DirectoryFilterOpts) *Directory {
	q := r.query.Select("filter")
	for i := len(opts) - 1; i >= 0; i-- {
		// `exclude` optional argument
		if !querybuilder.IsZeroValue(opts[i].Exclude) {
			q = q.Arg("exclude", opts[i].Exclude)
		}
		// `include` optional argument
		if !querybuilder.IsZeroValue(opts[i].Include) {
			q = q.Arg("include", opts[i].Include)
		}
	}

	return &Directory{
		query: q,
	}
}

// Returns a list of files and directories that matche the given pattern.
func (r *Directory) Glob(ctx context.Context, pattern string) ([]string, error) {
	q := r.query.Select("glob")
	q = q.Arg("pattern", pattern)

	var response []string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this Directory.
func (r *Directory) ID(ctx context.Context) (DirectoryID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response DirectoryID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *Directory) XXX_GraphQLType() string {
	return "Directory"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *Directory) XXX_GraphQLIDType() string {
	return "DirectoryID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *Directory) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *Directory) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *Directory) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadDirectoryFromID(DirectoryID(id))
	return nil
}

// Returns the name of the directory.
func (r *Directory) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Force evaluation in the engine.
func (r *Directory) Sync(ctx context.Context) (*Directory, error) {
	q := r.query.Select("sync")

	var id DirectoryID
	if err := q.Bind(&id).Execute(ctx); err != nil {
		return nil, err
	}
	return &Directory{
		query: q.Root().Select("loadDirectoryFromID").Arg("id", id),
	}, nil
}

// DirectoryTerminalOpts contains options for Directory.Terminal
type DirectoryTerminalOpts struct {
	// If set, override the default container used for the terminal.
	Container *Container
	// If set, override the container's default terminal command and invoke these command arguments instead.
	Cmd []string
	// Provides Dagger access to the executed command.
	ExperimentalPrivilegedNesting bool
	// Execute the command with all root capabilities. This is similar to running a command with "sudo" or executing "docker run" with the "--privileged" flag. Containerization does not provide any security guarantees when using this option. It should only be used when absolutely necessary and only with trusted commands.
	InsecureRootCapabilities bool
}

// Opens an interactive terminal in new container with this directory mounted inside.
func (r *Directory) Terminal(opts ...DirectoryTerminalOpts) *Directory {
	q := r.query.Select("terminal")
	for i := len(opts) - 1; i >= 0; i-- {
		// `container` optional argument
		if !querybuilder.IsZeroValue(opts[i].Container) {
			q = q.Arg("container", opts[i].Container)
		}
		// `cmd` optional argument
		if !querybuilder.IsZeroValue(opts[i].Cmd) {
			q = q.Arg("cmd", opts[i].Cmd)
		}
		// `experimentalPrivilegedNesting` optional argument
		if !querybuilder.IsZeroValue(opts[i].ExperimentalPrivilegedNesting) {
			q = q.Arg("experimentalPrivilegedNesting", opts[i].ExperimentalPrivilegedNesting)
		}
		// `insecureRootCapabilities` optional argument
		if !querybuilder.IsZeroValue(opts[i].InsecureRootCapabilities) {
			q = q.Arg("insecureRootCapabilities", opts[i].InsecureRootCapabilities)
		}
	}

	return &Directory{
		query: q,
	}
}

// DirectoryWithDirectoryOpts contains options for Directory.WithDirectory
type DirectoryWithDirectoryOpts struct {
	// Exclude artifacts that match the given pattern (e.g., ["node_modules/", ".git*"]).
	Exclude []string
	// Include only artifacts that match the given pattern (e.g., ["app/", "package.*"]).
	Include []string
}

// Return a snapshot with a directory added
func (r *Directory) WithDirectory(path string, directory *Directory, opts ...DirectoryWithDirectoryOpts) *Directory {
	assertNotNil("directory", directory)
	q := r.query.Select("withDirectory")
	for i := len(opts) - 1; i >= 0; i-- {
		// `exclude` optional argument
		if !querybuilder.IsZeroValue(opts[i].Exclude) {
			q = q.Arg("exclude", opts[i].Exclude)
		}
		// `include` optional argument
		if !querybuilder.IsZeroValue(opts[i].Include) {
			q = q.Arg("include", opts[i].Include)
		}
	}
	q = q.Arg("path", path)
	q = q.Arg("directory", directory)

	return &Directory{
		query: q,
	}
}

// DirectoryWithFileOpts contains options for Directory.WithFile
type DirectoryWithFileOpts struct {
	// Permission given to the copied file (e.g., 0600).
	Permissions int
}

// Retrieves this directory plus the contents of the given file copied to the given path.
func (r *Directory) WithFile(path string, source *File, opts ...DirectoryWithFileOpts) *Directory {
	assertNotNil("source", source)
	q := r.query.Select("withFile")
	for i := len(opts) - 1; i >= 0; i-- {
		// `permissions` optional argument
		if !querybuilder.IsZeroValue(opts[i].Permissions) {
			q = q.Arg("permissions", opts[i].Permissions)
		}
	}
	q = q.Arg("path", path)
	q = q.Arg("source", source)

	return &Directory{
		query: q,
	}
}

// DirectoryWithFilesOpts contains options for Directory.WithFiles
type DirectoryWithFilesOpts struct {
	// Permission given to the copied files (e.g., 0600).
	Permissions int
}

// Retrieves this directory plus the contents of the given files copied to the given path.
func (r *Directory) WithFiles(path string, sources []*File, opts ...DirectoryWithFilesOpts) *Directory {
	q := r.query.Select("withFiles")
	for i := len(opts) - 1; i >= 0; i-- {
		// `permissions` optional argument
		if !querybuilder.IsZeroValue(opts[i].Permissions) {
			q = q.Arg("permissions", opts[i].Permissions)
		}
	}
	q = q.Arg("path", path)
	q = q.Arg("sources", sources)

	return &Directory{
		query: q,
	}
}

// DirectoryWithNewDirectoryOpts contains options for Directory.WithNewDirectory
type DirectoryWithNewDirectoryOpts struct {
	// Permission granted to the created directory (e.g., 0777).
	//
	// Default: 420
	Permissions int
}

// Retrieves this directory plus a new directory created at the given path.
func (r *Directory) WithNewDirectory(path string, opts ...DirectoryWithNewDirectoryOpts) *Directory {
	q := r.query.Select("withNewDirectory")
	for i := len(opts) - 1; i >= 0; i-- {
		// `permissions` optional argument
		if !querybuilder.IsZeroValue(opts[i].Permissions) {
			q = q.Arg("permissions", opts[i].Permissions)
		}
	}
	q = q.Arg("path", path)

	return &Directory{
		query: q,
	}
}

// DirectoryWithNewFileOpts contains options for Directory.WithNewFile
type DirectoryWithNewFileOpts struct {
	// Permissions of the new file. Example: 0600
	//
	// Default: 420
	Permissions int
}

// Return a snapshot with a new file added
func (r *Directory) WithNewFile(path string, contents string, opts ...DirectoryWithNewFileOpts) *Directory {
	q := r.query.Select("withNewFile")
	for i := len(opts) - 1; i >= 0; i-- {
		// `permissions` optional argument
		if !querybuilder.IsZeroValue(opts[i].Permissions) {
			q = q.Arg("permissions", opts[i].Permissions)
		}
	}
	q = q.Arg("path", path)
	q = q.Arg("contents", contents)

	return &Directory{
		query: q,
	}
}

// Return a snapshot with a symlink
func (r *Directory) WithSymlink(target string, linkName string) *Directory {
	q := r.query.Select("withSymlink")
	q = q.Arg("target", target)
	q = q.Arg("linkName", linkName)

	return &Directory{
		query: q,
	}
}

// Retrieves this directory with all file/dir timestamps set to the given time.
func (r *Directory) WithTimestamps(timestamp int) *Directory {
	q := r.query.Select("withTimestamps")
	q = q.Arg("timestamp", timestamp)

	return &Directory{
		query: q,
	}
}

// Return a snapshot with a subdirectory removed
func (r *Directory) WithoutDirectory(path string) *Directory {
	q := r.query.Select("withoutDirectory")
	q = q.Arg("path", path)

	return &Directory{
		query: q,
	}
}

// Return a snapshot with a file removed
func (r *Directory) WithoutFile(path string) *Directory {
	q := r.query.Select("withoutFile")
	q = q.Arg("path", path)

	return &Directory{
		query: q,
	}
}

// Return a snapshot with files removed
func (r *Directory) WithoutFiles(paths []string) *Directory {
	q := r.query.Select("withoutFiles")
	q = q.Arg("paths", paths)

	return &Directory{
		query: q,
	}
}

// A definition of a custom enum defined in a Module.
type EnumTypeDef struct {
	query *querybuilder.Selection

	description      *string
	id               *EnumTypeDefID
	name             *string
	sourceModuleName *string
}

func (r *EnumTypeDef) WithGraphQLQuery(q *querybuilder.Selection) *EnumTypeDef {
	return &EnumTypeDef{
		query: q,
	}
}

// A doc string for the enum, if any.
func (r *EnumTypeDef) Description(ctx context.Context) (string, error) {
	if r.description != nil {
		return *r.description, nil
	}
	q := r.query.Select("description")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this EnumTypeDef.
func (r *EnumTypeDef) ID(ctx context.Context) (EnumTypeDefID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response EnumTypeDefID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *EnumTypeDef) XXX_GraphQLType() string {
	return "EnumTypeDef"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *EnumTypeDef) XXX_GraphQLIDType() string {
	return "EnumTypeDefID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *EnumTypeDef) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *EnumTypeDef) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *EnumTypeDef) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadEnumTypeDefFromID(EnumTypeDefID(id))
	return nil
}

// The members of the enum.
func (r *EnumTypeDef) Members(ctx context.Context) ([]EnumValueTypeDef, error) {
	q := r.query.Select("members")

	q = q.Select("id")

	type members struct {
		Id EnumValueTypeDefID
	}

	convert := func(fields []members) []EnumValueTypeDef {
		out := []EnumValueTypeDef{}

		for i := range fields {
			val := EnumValueTypeDef{id: &fields[i].Id}
			val.query = q.Root().Select("loadEnumValueTypeDefFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []members

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// The name of the enum.
func (r *EnumTypeDef) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The location of this enum declaration.
func (r *EnumTypeDef) SourceMap() *SourceMap {
	q := r.query.Select("sourceMap")

	return &SourceMap{
		query: q,
	}
}

// If this EnumTypeDef is associated with a Module, the name of the module. Unset otherwise.
func (r *EnumTypeDef) SourceModuleName(ctx context.Context) (string, error) {
	if r.sourceModuleName != nil {
		return *r.sourceModuleName, nil
	}
	q := r.query.Select("sourceModuleName")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Deprecated: use members instead
func (r *EnumTypeDef) Values(ctx context.Context) ([]EnumValueTypeDef, error) {
	q := r.query.Select("values")

	q = q.Select("id")

	type values struct {
		Id EnumValueTypeDefID
	}

	convert := func(fields []values) []EnumValueTypeDef {
		out := []EnumValueTypeDef{}

		for i := range fields {
			val := EnumValueTypeDef{id: &fields[i].Id}
			val.query = q.Root().Select("loadEnumValueTypeDefFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []values

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// A definition of a value in a custom enum defined in a Module.
type EnumValueTypeDef struct {
	query *querybuilder.Selection

	description *string
	id          *EnumValueTypeDefID
	name        *string
	value       *string
}

func (r *EnumValueTypeDef) WithGraphQLQuery(q *querybuilder.Selection) *EnumValueTypeDef {
	return &EnumValueTypeDef{
		query: q,
	}
}

// A doc string for the enum member, if any.
func (r *EnumValueTypeDef) Description(ctx context.Context) (string, error) {
	if r.description != nil {
		return *r.description, nil
	}
	q := r.query.Select("description")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this EnumValueTypeDef.
func (r *EnumValueTypeDef) ID(ctx context.Context) (EnumValueTypeDefID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response EnumValueTypeDefID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *EnumValueTypeDef) XXX_GraphQLType() string {
	return "EnumValueTypeDef"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *EnumValueTypeDef) XXX_GraphQLIDType() string {
	return "EnumValueTypeDefID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *EnumValueTypeDef) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *EnumValueTypeDef) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *EnumValueTypeDef) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadEnumValueTypeDefFromID(EnumValueTypeDefID(id))
	return nil
}

// The name of the enum member.
func (r *EnumValueTypeDef) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The location of this enum member declaration.
func (r *EnumValueTypeDef) SourceMap() *SourceMap {
	q := r.query.Select("sourceMap")

	return &SourceMap{
		query: q,
	}
}

// The value of the enum member
func (r *EnumValueTypeDef) Value(ctx context.Context) (string, error) {
	if r.value != nil {
		return *r.value, nil
	}
	q := r.query.Select("value")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

type Env struct {
	query *querybuilder.Selection

	id *EnvID
}
type WithEnvFunc func(r *Env) *Env

// With calls the provided function with current Env.
//
// This is useful for reusability and readability by not breaking the calling chain.
func (r *Env) With(f WithEnvFunc) *Env {
	return f(r)
}

func (r *Env) WithGraphQLQuery(q *querybuilder.Selection) *Env {
	return &Env{
		query: q,
	}
}

// A unique identifier for this Env.
func (r *Env) ID(ctx context.Context) (EnvID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response EnvID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *Env) XXX_GraphQLType() string {
	return "Env"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *Env) XXX_GraphQLIDType() string {
	return "EnvID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *Env) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *Env) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *Env) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadEnvFromID(EnvID(id))
	return nil
}

// retrieve an input value by name
func (r *Env) Input(name string) *Binding {
	q := r.query.Select("input")
	q = q.Arg("name", name)

	return &Binding{
		query: q,
	}
}

// return all input values for the environment
func (r *Env) Inputs(ctx context.Context) ([]Binding, error) {
	q := r.query.Select("inputs")

	q = q.Select("id")

	type inputs struct {
		Id BindingID
	}

	convert := func(fields []inputs) []Binding {
		out := []Binding{}

		for i := range fields {
			val := Binding{id: &fields[i].Id}
			val.query = q.Root().Select("loadBindingFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []inputs

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// retrieve an output value by name
func (r *Env) Output(name string) *Binding {
	q := r.query.Select("output")
	q = q.Arg("name", name)

	return &Binding{
		query: q,
	}
}

// return all output values for the environment
func (r *Env) Outputs(ctx context.Context) ([]Binding, error) {
	q := r.query.Select("outputs")

	q = q.Select("id")

	type outputs struct {
		Id BindingID
	}

	convert := func(fields []outputs) []Binding {
		out := []Binding{}

		for i := range fields {
			val := Binding{id: &fields[i].Id}
			val.query = q.Root().Select("loadBindingFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []outputs

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// Create or update a binding of type CacheVolume in the environment
func (r *Env) WithCacheVolumeInput(name string, value *CacheVolume, description string) *Env {
	assertNotNil("value", value)
	q := r.query.Select("withCacheVolumeInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Declare a desired CacheVolume output to be assigned in the environment
func (r *Env) WithCacheVolumeOutput(name string, description string) *Env {
	q := r.query.Select("withCacheVolumeOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update a binding of type Cloud in the environment
func (r *Env) WithCloudInput(name string, value *Cloud, description string) *Env {
	assertNotNil("value", value)
	q := r.query.Select("withCloudInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Declare a desired Cloud output to be assigned in the environment
func (r *Env) WithCloudOutput(name string, description string) *Env {
	q := r.query.Select("withCloudOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update a binding of type Container in the environment
func (r *Env) WithContainerInput(name string, value *Container, description string) *Env {
	assertNotNil("value", value)
	q := r.query.Select("withContainerInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Declare a desired Container output to be assigned in the environment
func (r *Env) WithContainerOutput(name string, description string) *Env {
	q := r.query.Select("withContainerOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update a binding of type Directory in the environment
func (r *Env) WithDirectoryInput(name string, value *Directory, description string) *Env {
	assertNotNil("value", value)
	q := r.query.Select("withDirectoryInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Declare a desired Directory output to be assigned in the environment
func (r *Env) WithDirectoryOutput(name string, description string) *Env {
	q := r.query.Select("withDirectoryOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update a binding of type Env in the environment
func (r *Env) WithEnvInput(name string, value *Env, description string) *Env {
	assertNotNil("value", value)
	q := r.query.Select("withEnvInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Declare a desired Env output to be assigned in the environment
func (r *Env) WithEnvOutput(name string, description string) *Env {
	q := r.query.Select("withEnvOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update a binding of type File in the environment
func (r *Env) WithFileInput(name string, value *File, description string) *Env {
	assertNotNil("value", value)
	q := r.query.Select("withFileInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Declare a desired File output to be assigned in the environment
func (r *Env) WithFileOutput(name string, description string) *Env {
	q := r.query.Select("withFileOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update a binding of type GitRef in the environment
func (r *Env) WithGitRefInput(name string, value *GitRef, description string) *Env {
	assertNotNil("value", value)
	q := r.query.Select("withGitRefInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Declare a desired GitRef output to be assigned in the environment
func (r *Env) WithGitRefOutput(name string, description string) *Env {
	q := r.query.Select("withGitRefOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update a binding of type GitRepository in the environment
func (r *Env) WithGitRepositoryInput(name string, value *GitRepository, description string) *Env {
	assertNotNil("value", value)
	q := r.query.Select("withGitRepositoryInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Declare a desired GitRepository output to be assigned in the environment
func (r *Env) WithGitRepositoryOutput(name string, description string) *Env {
	q := r.query.Select("withGitRepositoryOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update a binding of type K3S in the environment
func (r *Env) WithK3SInput(name string, value *K3S, description string) *Env {
	assertNotNil("value", value)
	q := r.query.Select("withK3SInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Declare a desired K3S output to be assigned in the environment
func (r *Env) WithK3SOutput(name string, description string) *Env {
	q := r.query.Select("withK3SOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update a binding of type LLM in the environment
func (r *Env) WithLLMInput(name string, value *LLM, description string) *Env {
	assertNotNil("value", value)
	q := r.query.Select("withLLMInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Declare a desired LLM output to be assigned in the environment
func (r *Env) WithLLMOutput(name string, description string) *Env {
	q := r.query.Select("withLLMOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update a binding of type ModuleConfigClient in the environment
func (r *Env) WithModuleConfigClientInput(name string, value *ModuleConfigClient, description string) *Env {
	assertNotNil("value", value)
	q := r.query.Select("withModuleConfigClientInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Declare a desired ModuleConfigClient output to be assigned in the environment
func (r *Env) WithModuleConfigClientOutput(name string, description string) *Env {
	q := r.query.Select("withModuleConfigClientOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update a binding of type Module in the environment
func (r *Env) WithModuleInput(name string, value *Module, description string) *Env {
	assertNotNil("value", value)
	q := r.query.Select("withModuleInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Declare a desired Module output to be assigned in the environment
func (r *Env) WithModuleOutput(name string, description string) *Env {
	q := r.query.Select("withModuleOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update a binding of type ModuleSource in the environment
func (r *Env) WithModuleSourceInput(name string, value *ModuleSource, description string) *Env {
	assertNotNil("value", value)
	q := r.query.Select("withModuleSourceInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Declare a desired ModuleSource output to be assigned in the environment
func (r *Env) WithModuleSourceOutput(name string, description string) *Env {
	q := r.query.Select("withModuleSourceOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update a binding of type Secret in the environment
func (r *Env) WithSecretInput(name string, value *Secret, description string) *Env {
	assertNotNil("value", value)
	q := r.query.Select("withSecretInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Declare a desired Secret output to be assigned in the environment
func (r *Env) WithSecretOutput(name string, description string) *Env {
	q := r.query.Select("withSecretOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update a binding of type Service in the environment
func (r *Env) WithServiceInput(name string, value *Service, description string) *Env {
	assertNotNil("value", value)
	q := r.query.Select("withServiceInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Declare a desired Service output to be assigned in the environment
func (r *Env) WithServiceOutput(name string, description string) *Env {
	q := r.query.Select("withServiceOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update a binding of type Socket in the environment
func (r *Env) WithSocketInput(name string, value *Socket, description string) *Env {
	assertNotNil("value", value)
	q := r.query.Select("withSocketInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Declare a desired Socket output to be assigned in the environment
func (r *Env) WithSocketOutput(name string, description string) *Env {
	q := r.query.Select("withSocketOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update an input value of type string
func (r *Env) WithStringInput(name string, value string, description string) *Env {
	q := r.query.Select("withStringInput")
	q = q.Arg("name", name)
	q = q.Arg("value", value)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// Create or update an input value of type string
func (r *Env) WithStringOutput(name string, description string) *Env {
	q := r.query.Select("withStringOutput")
	q = q.Arg("name", name)
	q = q.Arg("description", description)

	return &Env{
		query: q,
	}
}

// An environment variable name and value.
type EnvVariable struct {
	query *querybuilder.Selection

	id    *EnvVariableID
	name  *string
	value *string
}

func (r *EnvVariable) WithGraphQLQuery(q *querybuilder.Selection) *EnvVariable {
	return &EnvVariable{
		query: q,
	}
}

// A unique identifier for this EnvVariable.
func (r *EnvVariable) ID(ctx context.Context) (EnvVariableID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response EnvVariableID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *EnvVariable) XXX_GraphQLType() string {
	return "EnvVariable"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *EnvVariable) XXX_GraphQLIDType() string {
	return "EnvVariableID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *EnvVariable) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *EnvVariable) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *EnvVariable) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadEnvVariableFromID(EnvVariableID(id))
	return nil
}

// The environment variable name.
func (r *EnvVariable) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The environment variable value.
func (r *EnvVariable) Value(ctx context.Context) (string, error) {
	if r.value != nil {
		return *r.value, nil
	}
	q := r.query.Select("value")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

type Error struct {
	query *querybuilder.Selection

	id      *ErrorID
	message *string
}
type WithErrorFunc func(r *Error) *Error

// With calls the provided function with current Error.
//
// This is useful for reusability and readability by not breaking the calling chain.
func (r *Error) With(f WithErrorFunc) *Error {
	return f(r)
}

func (r *Error) WithGraphQLQuery(q *querybuilder.Selection) *Error {
	return &Error{
		query: q,
	}
}

// A unique identifier for this Error.
func (r *Error) ID(ctx context.Context) (ErrorID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response ErrorID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *Error) XXX_GraphQLType() string {
	return "Error"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *Error) XXX_GraphQLIDType() string {
	return "ErrorID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *Error) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *Error) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *Error) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadErrorFromID(ErrorID(id))
	return nil
}

// A description of the error.
func (r *Error) Message(ctx context.Context) (string, error) {
	if r.message != nil {
		return *r.message, nil
	}
	q := r.query.Select("message")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The extensions of the error.
func (r *Error) Values(ctx context.Context) ([]ErrorValue, error) {
	q := r.query.Select("values")

	q = q.Select("id")

	type values struct {
		Id ErrorValueID
	}

	convert := func(fields []values) []ErrorValue {
		out := []ErrorValue{}

		for i := range fields {
			val := ErrorValue{id: &fields[i].Id}
			val.query = q.Root().Select("loadErrorValueFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []values

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// Add a value to the error.
func (r *Error) WithValue(name string, value JSON) *Error {
	q := r.query.Select("withValue")
	q = q.Arg("name", name)
	q = q.Arg("value", value)

	return &Error{
		query: q,
	}
}

type ErrorValue struct {
	query *querybuilder.Selection

	id    *ErrorValueID
	name  *string
	value *JSON
}

func (r *ErrorValue) WithGraphQLQuery(q *querybuilder.Selection) *ErrorValue {
	return &ErrorValue{
		query: q,
	}
}

// A unique identifier for this ErrorValue.
func (r *ErrorValue) ID(ctx context.Context) (ErrorValueID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response ErrorValueID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *ErrorValue) XXX_GraphQLType() string {
	return "ErrorValue"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *ErrorValue) XXX_GraphQLIDType() string {
	return "ErrorValueID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *ErrorValue) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *ErrorValue) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *ErrorValue) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadErrorValueFromID(ErrorValueID(id))
	return nil
}

// The name of the value.
func (r *ErrorValue) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The value.
func (r *ErrorValue) Value(ctx context.Context) (JSON, error) {
	if r.value != nil {
		return *r.value, nil
	}
	q := r.query.Select("value")

	var response JSON

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A definition of a field on a custom object defined in a Module.
//
// A field on an object has a static value, as opposed to a function on an object whose value is computed by invoking code (and can accept arguments).
type FieldTypeDef struct {
	query *querybuilder.Selection

	description *string
	id          *FieldTypeDefID
	name        *string
}

func (r *FieldTypeDef) WithGraphQLQuery(q *querybuilder.Selection) *FieldTypeDef {
	return &FieldTypeDef{
		query: q,
	}
}

// A doc string for the field, if any.
func (r *FieldTypeDef) Description(ctx context.Context) (string, error) {
	if r.description != nil {
		return *r.description, nil
	}
	q := r.query.Select("description")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this FieldTypeDef.
func (r *FieldTypeDef) ID(ctx context.Context) (FieldTypeDefID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response FieldTypeDefID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *FieldTypeDef) XXX_GraphQLType() string {
	return "FieldTypeDef"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *FieldTypeDef) XXX_GraphQLIDType() string {
	return "FieldTypeDefID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *FieldTypeDef) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *FieldTypeDef) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *FieldTypeDef) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadFieldTypeDefFromID(FieldTypeDefID(id))
	return nil
}

// The name of the field in lowerCamelCase format.
func (r *FieldTypeDef) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The location of this field declaration.
func (r *FieldTypeDef) SourceMap() *SourceMap {
	q := r.query.Select("sourceMap")

	return &SourceMap{
		query: q,
	}
}

// The type of the field.
func (r *FieldTypeDef) TypeDef() *TypeDef {
	q := r.query.Select("typeDef")

	return &TypeDef{
		query: q,
	}
}

// A file.
type File struct {
	query *querybuilder.Selection

	contents *string
	digest   *string
	export   *string
	id       *FileID
	name     *string
	size     *int
	sync     *FileID
}
type WithFileFunc func(r *File) *File

// With calls the provided function with current File.
//
// This is useful for reusability and readability by not breaking the calling chain.
func (r *File) With(f WithFileFunc) *File {
	return f(r)
}

func (r *File) WithGraphQLQuery(q *querybuilder.Selection) *File {
	return &File{
		query: q,
	}
}

// Retrieves the contents of the file.
func (r *File) Contents(ctx context.Context) (string, error) {
	if r.contents != nil {
		return *r.contents, nil
	}
	q := r.query.Select("contents")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// FileDigestOpts contains options for File.Digest
type FileDigestOpts struct {
	// If true, exclude metadata from the digest.
	ExcludeMetadata bool
}

// Return the file's digest. The format of the digest is not guaranteed to be stable between releases of Dagger. It is guaranteed to be stable between invocations of the same Dagger engine.
func (r *File) Digest(ctx context.Context, opts ...FileDigestOpts) (string, error) {
	if r.digest != nil {
		return *r.digest, nil
	}
	q := r.query.Select("digest")
	for i := len(opts) - 1; i >= 0; i-- {
		// `excludeMetadata` optional argument
		if !querybuilder.IsZeroValue(opts[i].ExcludeMetadata) {
			q = q.Arg("excludeMetadata", opts[i].ExcludeMetadata)
		}
	}

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// FileExportOpts contains options for File.Export
type FileExportOpts struct {
	// If allowParentDirPath is true, the path argument can be a directory path, in which case the file will be created in that directory.
	AllowParentDirPath bool
}

// Writes the file to a file path on the host.
func (r *File) Export(ctx context.Context, path string, opts ...FileExportOpts) (string, error) {
	if r.export != nil {
		return *r.export, nil
	}
	q := r.query.Select("export")
	for i := len(opts) - 1; i >= 0; i-- {
		// `allowParentDirPath` optional argument
		if !querybuilder.IsZeroValue(opts[i].AllowParentDirPath) {
			q = q.Arg("allowParentDirPath", opts[i].AllowParentDirPath)
		}
	}
	q = q.Arg("path", path)

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this File.
func (r *File) ID(ctx context.Context) (FileID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response FileID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *File) XXX_GraphQLType() string {
	return "File"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *File) XXX_GraphQLIDType() string {
	return "FileID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *File) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *File) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *File) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadFileFromID(FileID(id))
	return nil
}

// Retrieves the name of the file.
func (r *File) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Retrieves the size of the file, in bytes.
func (r *File) Size(ctx context.Context) (int, error) {
	if r.size != nil {
		return *r.size, nil
	}
	q := r.query.Select("size")

	var response int

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Force evaluation in the engine.
func (r *File) Sync(ctx context.Context) (*File, error) {
	q := r.query.Select("sync")

	var id FileID
	if err := q.Bind(&id).Execute(ctx); err != nil {
		return nil, err
	}
	return &File{
		query: q.Root().Select("loadFileFromID").Arg("id", id),
	}, nil
}

// Retrieves this file with its name set to the given name.
func (r *File) WithName(name string) *File {
	q := r.query.Select("withName")
	q = q.Arg("name", name)

	return &File{
		query: q,
	}
}

// Retrieves this file with its created/modified timestamps set to the given time.
func (r *File) WithTimestamps(timestamp int) *File {
	q := r.query.Select("withTimestamps")
	q = q.Arg("timestamp", timestamp)

	return &File{
		query: q,
	}
}

// Function represents a resolver provided by a Module.
//
// A function always evaluates against a parent object and is given a set of named arguments.
type Function struct {
	query *querybuilder.Selection

	description *string
	id          *FunctionID
	name        *string
}
type WithFunctionFunc func(r *Function) *Function

// With calls the provided function with current Function.
//
// This is useful for reusability and readability by not breaking the calling chain.
func (r *Function) With(f WithFunctionFunc) *Function {
	return f(r)
}

func (r *Function) WithGraphQLQuery(q *querybuilder.Selection) *Function {
	return &Function{
		query: q,
	}
}

// Arguments accepted by the function, if any.
func (r *Function) Args(ctx context.Context) ([]FunctionArg, error) {
	q := r.query.Select("args")

	q = q.Select("id")

	type args struct {
		Id FunctionArgID
	}

	convert := func(fields []args) []FunctionArg {
		out := []FunctionArg{}

		for i := range fields {
			val := FunctionArg{id: &fields[i].Id}
			val.query = q.Root().Select("loadFunctionArgFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []args

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// A doc string for the function, if any.
func (r *Function) Description(ctx context.Context) (string, error) {
	if r.description != nil {
		return *r.description, nil
	}
	q := r.query.Select("description")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this Function.
func (r *Function) ID(ctx context.Context) (FunctionID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response FunctionID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *Function) XXX_GraphQLType() string {
	return "Function"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *Function) XXX_GraphQLIDType() string {
	return "FunctionID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *Function) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *Function) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *Function) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadFunctionFromID(FunctionID(id))
	return nil
}

// The name of the function.
func (r *Function) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The type returned by the function.
func (r *Function) ReturnType() *TypeDef {
	q := r.query.Select("returnType")

	return &TypeDef{
		query: q,
	}
}

// The location of this function declaration.
func (r *Function) SourceMap() *SourceMap {
	q := r.query.Select("sourceMap")

	return &SourceMap{
		query: q,
	}
}

// FunctionWithArgOpts contains options for Function.WithArg
type FunctionWithArgOpts struct {
	// A doc string for the argument, if any
	Description string
	// A default value to use for this argument if not explicitly set by the caller, if any
	DefaultValue JSON
	// If the argument is a Directory or File type, default to load path from context directory, relative to root directory.
	DefaultPath string
	// Patterns to ignore when loading the contextual argument value.
	Ignore []string
	// The source map for the argument definition.
	SourceMap *SourceMap
}

// Returns the function with the provided argument
func (r *Function) WithArg(name string, typeDef *TypeDef, opts ...FunctionWithArgOpts) *Function {
	assertNotNil("typeDef", typeDef)
	q := r.query.Select("withArg")
	for i := len(opts) - 1; i >= 0; i-- {
		// `description` optional argument
		if !querybuilder.IsZeroValue(opts[i].Description) {
			q = q.Arg("description", opts[i].Description)
		}
		// `defaultValue` optional argument
		if !querybuilder.IsZeroValue(opts[i].DefaultValue) {
			q = q.Arg("defaultValue", opts[i].DefaultValue)
		}
		// `defaultPath` optional argument
		if !querybuilder.IsZeroValue(opts[i].DefaultPath) {
			q = q.Arg("defaultPath", opts[i].DefaultPath)
		}
		// `ignore` optional argument
		if !querybuilder.IsZeroValue(opts[i].Ignore) {
			q = q.Arg("ignore", opts[i].Ignore)
		}
		// `sourceMap` optional argument
		if !querybuilder.IsZeroValue(opts[i].SourceMap) {
			q = q.Arg("sourceMap", opts[i].SourceMap)
		}
	}
	q = q.Arg("name", name)
	q = q.Arg("typeDef", typeDef)

	return &Function{
		query: q,
	}
}

// Returns the function with the given doc string.
func (r *Function) WithDescription(description string) *Function {
	q := r.query.Select("withDescription")
	q = q.Arg("description", description)

	return &Function{
		query: q,
	}
}

// Returns the function with the given source map.
func (r *Function) WithSourceMap(sourceMap *SourceMap) *Function {
	assertNotNil("sourceMap", sourceMap)
	q := r.query.Select("withSourceMap")
	q = q.Arg("sourceMap", sourceMap)

	return &Function{
		query: q,
	}
}

// An argument accepted by a function.
//
// This is a specification for an argument at function definition time, not an argument passed at function call time.
type FunctionArg struct {
	query *querybuilder.Selection

	defaultPath  *string
	defaultValue *JSON
	description  *string
	id           *FunctionArgID
	name         *string
}

func (r *FunctionArg) WithGraphQLQuery(q *querybuilder.Selection) *FunctionArg {
	return &FunctionArg{
		query: q,
	}
}

// Only applies to arguments of type File or Directory. If the argument is not set, load it from the given path in the context directory
func (r *FunctionArg) DefaultPath(ctx context.Context) (string, error) {
	if r.defaultPath != nil {
		return *r.defaultPath, nil
	}
	q := r.query.Select("defaultPath")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A default value to use for this argument when not explicitly set by the caller, if any.
func (r *FunctionArg) DefaultValue(ctx context.Context) (JSON, error) {
	if r.defaultValue != nil {
		return *r.defaultValue, nil
	}
	q := r.query.Select("defaultValue")

	var response JSON

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A doc string for the argument, if any.
func (r *FunctionArg) Description(ctx context.Context) (string, error) {
	if r.description != nil {
		return *r.description, nil
	}
	q := r.query.Select("description")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this FunctionArg.
func (r *FunctionArg) ID(ctx context.Context) (FunctionArgID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response FunctionArgID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *FunctionArg) XXX_GraphQLType() string {
	return "FunctionArg"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *FunctionArg) XXX_GraphQLIDType() string {
	return "FunctionArgID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *FunctionArg) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *FunctionArg) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *FunctionArg) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadFunctionArgFromID(FunctionArgID(id))
	return nil
}

// Only applies to arguments of type Directory. The ignore patterns are applied to the input directory, and matching entries are filtered out, in a cache-efficient manner.
func (r *FunctionArg) Ignore(ctx context.Context) ([]string, error) {
	q := r.query.Select("ignore")

	var response []string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The name of the argument in lowerCamelCase format.
func (r *FunctionArg) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The location of this arg declaration.
func (r *FunctionArg) SourceMap() *SourceMap {
	q := r.query.Select("sourceMap")

	return &SourceMap{
		query: q,
	}
}

// The type of the argument.
func (r *FunctionArg) TypeDef() *TypeDef {
	q := r.query.Select("typeDef")

	return &TypeDef{
		query: q,
	}
}

// An active function call.
type FunctionCall struct {
	query *querybuilder.Selection

	id          *FunctionCallID
	name        *string
	parent      *JSON
	parentName  *string
	returnError *Void
	returnValue *Void
}

func (r *FunctionCall) WithGraphQLQuery(q *querybuilder.Selection) *FunctionCall {
	return &FunctionCall{
		query: q,
	}
}

// A unique identifier for this FunctionCall.
func (r *FunctionCall) ID(ctx context.Context) (FunctionCallID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response FunctionCallID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *FunctionCall) XXX_GraphQLType() string {
	return "FunctionCall"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *FunctionCall) XXX_GraphQLIDType() string {
	return "FunctionCallID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *FunctionCall) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *FunctionCall) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *FunctionCall) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadFunctionCallFromID(FunctionCallID(id))
	return nil
}

// The argument values the function is being invoked with.
func (r *FunctionCall) InputArgs(ctx context.Context) ([]FunctionCallArgValue, error) {
	q := r.query.Select("inputArgs")

	q = q.Select("id")

	type inputArgs struct {
		Id FunctionCallArgValueID
	}

	convert := func(fields []inputArgs) []FunctionCallArgValue {
		out := []FunctionCallArgValue{}

		for i := range fields {
			val := FunctionCallArgValue{id: &fields[i].Id}
			val.query = q.Root().Select("loadFunctionCallArgValueFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []inputArgs

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// The name of the function being called.
func (r *FunctionCall) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The value of the parent object of the function being called. If the function is top-level to the module, this is always an empty object.
func (r *FunctionCall) Parent(ctx context.Context) (JSON, error) {
	if r.parent != nil {
		return *r.parent, nil
	}
	q := r.query.Select("parent")

	var response JSON

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The name of the parent object of the function being called. If the function is top-level to the module, this is the name of the module.
func (r *FunctionCall) ParentName(ctx context.Context) (string, error) {
	if r.parentName != nil {
		return *r.parentName, nil
	}
	q := r.query.Select("parentName")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Return an error from the function.
func (r *FunctionCall) ReturnError(ctx context.Context, error *Error) error {
	assertNotNil("error", error)
	if r.returnError != nil {
		return nil
	}
	q := r.query.Select("returnError")
	q = q.Arg("error", error)

	return q.Execute(ctx)
}

// Set the return value of the function call to the provided value.
func (r *FunctionCall) ReturnValue(ctx context.Context, value JSON) error {
	if r.returnValue != nil {
		return nil
	}
	q := r.query.Select("returnValue")
	q = q.Arg("value", value)

	return q.Execute(ctx)
}

// A value passed as a named argument to a function call.
type FunctionCallArgValue struct {
	query *querybuilder.Selection

	id    *FunctionCallArgValueID
	name  *string
	value *JSON
}

func (r *FunctionCallArgValue) WithGraphQLQuery(q *querybuilder.Selection) *FunctionCallArgValue {
	return &FunctionCallArgValue{
		query: q,
	}
}

// A unique identifier for this FunctionCallArgValue.
func (r *FunctionCallArgValue) ID(ctx context.Context) (FunctionCallArgValueID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response FunctionCallArgValueID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *FunctionCallArgValue) XXX_GraphQLType() string {
	return "FunctionCallArgValue"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *FunctionCallArgValue) XXX_GraphQLIDType() string {
	return "FunctionCallArgValueID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *FunctionCallArgValue) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *FunctionCallArgValue) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *FunctionCallArgValue) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadFunctionCallArgValueFromID(FunctionCallArgValueID(id))
	return nil
}

// The name of the argument.
func (r *FunctionCallArgValue) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The value of the argument represented as a JSON serialized string.
func (r *FunctionCallArgValue) Value(ctx context.Context) (JSON, error) {
	if r.value != nil {
		return *r.value, nil
	}
	q := r.query.Select("value")

	var response JSON

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The result of running an SDK's codegen.
type GeneratedCode struct {
	query *querybuilder.Selection

	id *GeneratedCodeID
}
type WithGeneratedCodeFunc func(r *GeneratedCode) *GeneratedCode

// With calls the provided function with current GeneratedCode.
//
// This is useful for reusability and readability by not breaking the calling chain.
func (r *GeneratedCode) With(f WithGeneratedCodeFunc) *GeneratedCode {
	return f(r)
}

func (r *GeneratedCode) WithGraphQLQuery(q *querybuilder.Selection) *GeneratedCode {
	return &GeneratedCode{
		query: q,
	}
}

// The directory containing the generated code.
func (r *GeneratedCode) Code() *Directory {
	q := r.query.Select("code")

	return &Directory{
		query: q,
	}
}

// A unique identifier for this GeneratedCode.
func (r *GeneratedCode) ID(ctx context.Context) (GeneratedCodeID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response GeneratedCodeID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *GeneratedCode) XXX_GraphQLType() string {
	return "GeneratedCode"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *GeneratedCode) XXX_GraphQLIDType() string {
	return "GeneratedCodeID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *GeneratedCode) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *GeneratedCode) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *GeneratedCode) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadGeneratedCodeFromID(GeneratedCodeID(id))
	return nil
}

// List of paths to mark generated in version control (i.e. .gitattributes).
func (r *GeneratedCode) VcsGeneratedPaths(ctx context.Context) ([]string, error) {
	q := r.query.Select("vcsGeneratedPaths")

	var response []string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// List of paths to ignore in version control (i.e. .gitignore).
func (r *GeneratedCode) VcsIgnoredPaths(ctx context.Context) ([]string, error) {
	q := r.query.Select("vcsIgnoredPaths")

	var response []string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Set the list of paths to mark generated in version control.
func (r *GeneratedCode) WithVCSGeneratedPaths(paths []string) *GeneratedCode {
	q := r.query.Select("withVCSGeneratedPaths")
	q = q.Arg("paths", paths)

	return &GeneratedCode{
		query: q,
	}
}

// Set the list of paths to ignore in version control.
func (r *GeneratedCode) WithVCSIgnoredPaths(paths []string) *GeneratedCode {
	q := r.query.Select("withVCSIgnoredPaths")
	q = q.Arg("paths", paths)

	return &GeneratedCode{
		query: q,
	}
}

// A git ref (tag, branch, or commit).
type GitRef struct {
	query *querybuilder.Selection

	commit *string
	id     *GitRefID
	ref    *string
}

func (r *GitRef) WithGraphQLQuery(q *querybuilder.Selection) *GitRef {
	return &GitRef{
		query: q,
	}
}

// The resolved commit id at this ref.
func (r *GitRef) Commit(ctx context.Context) (string, error) {
	if r.commit != nil {
		return *r.commit, nil
	}
	q := r.query.Select("commit")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this GitRef.
func (r *GitRef) ID(ctx context.Context) (GitRefID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response GitRefID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *GitRef) XXX_GraphQLType() string {
	return "GitRef"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *GitRef) XXX_GraphQLIDType() string {
	return "GitRefID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *GitRef) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *GitRef) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *GitRef) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadGitRefFromID(GitRefID(id))
	return nil
}

// The resolved ref name at this ref.
func (r *GitRef) Ref(ctx context.Context) (string, error) {
	if r.ref != nil {
		return *r.ref, nil
	}
	q := r.query.Select("ref")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// GitRefTreeOpts contains options for GitRef.Tree
type GitRefTreeOpts struct {
	// Set to true to discard .git directory.
	DiscardGitDir bool
	// The depth of the tree to fetch.
	//
	// Default: 1
	Depth int
}

// The filesystem tree at this ref.
func (r *GitRef) Tree(opts ...GitRefTreeOpts) *Directory {
	q := r.query.Select("tree")
	for i := len(opts) - 1; i >= 0; i-- {
		// `discardGitDir` optional argument
		if !querybuilder.IsZeroValue(opts[i].DiscardGitDir) {
			q = q.Arg("discardGitDir", opts[i].DiscardGitDir)
		}
		// `depth` optional argument
		if !querybuilder.IsZeroValue(opts[i].Depth) {
			q = q.Arg("depth", opts[i].Depth)
		}
	}

	return &Directory{
		query: q,
	}
}

// A git repository.
type GitRepository struct {
	query *querybuilder.Selection

	id *GitRepositoryID
}
type WithGitRepositoryFunc func(r *GitRepository) *GitRepository

// With calls the provided function with current GitRepository.
//
// This is useful for reusability and readability by not breaking the calling chain.
func (r *GitRepository) With(f WithGitRepositoryFunc) *GitRepository {
	return f(r)
}

func (r *GitRepository) WithGraphQLQuery(q *querybuilder.Selection) *GitRepository {
	return &GitRepository{
		query: q,
	}
}

// Returns details of a branch.
func (r *GitRepository) Branch(name string) *GitRef {
	q := r.query.Select("branch")
	q = q.Arg("name", name)

	return &GitRef{
		query: q,
	}
}

// GitRepositoryBranchesOpts contains options for GitRepository.Branches
type GitRepositoryBranchesOpts struct {
	// Glob patterns (e.g., "refs/tags/v*").
	Patterns []string
}

// branches that match any of the given glob patterns.
func (r *GitRepository) Branches(ctx context.Context, opts ...GitRepositoryBranchesOpts) ([]string, error) {
	q := r.query.Select("branches")
	for i := len(opts) - 1; i >= 0; i-- {
		// `patterns` optional argument
		if !querybuilder.IsZeroValue(opts[i].Patterns) {
			q = q.Arg("patterns", opts[i].Patterns)
		}
	}

	var response []string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Returns details of a commit.
func (r *GitRepository) Commit(id string) *GitRef {
	q := r.query.Select("commit")
	q = q.Arg("id", id)

	return &GitRef{
		query: q,
	}
}

// Returns details for HEAD.
func (r *GitRepository) Head() *GitRef {
	q := r.query.Select("head")

	return &GitRef{
		query: q,
	}
}

// A unique identifier for this GitRepository.
func (r *GitRepository) ID(ctx context.Context) (GitRepositoryID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response GitRepositoryID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *GitRepository) XXX_GraphQLType() string {
	return "GitRepository"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *GitRepository) XXX_GraphQLIDType() string {
	return "GitRepositoryID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *GitRepository) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *GitRepository) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *GitRepository) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadGitRepositoryFromID(GitRepositoryID(id))
	return nil
}

// Returns details of a ref.
func (r *GitRepository) Ref(name string) *GitRef {
	q := r.query.Select("ref")
	q = q.Arg("name", name)

	return &GitRef{
		query: q,
	}
}

// Returns details of a tag.
func (r *GitRepository) Tag(name string) *GitRef {
	q := r.query.Select("tag")
	q = q.Arg("name", name)

	return &GitRef{
		query: q,
	}
}

// GitRepositoryTagsOpts contains options for GitRepository.Tags
type GitRepositoryTagsOpts struct {
	// Glob patterns (e.g., "refs/tags/v*").
	Patterns []string
}

// tags that match any of the given glob patterns.
func (r *GitRepository) Tags(ctx context.Context, opts ...GitRepositoryTagsOpts) ([]string, error) {
	q := r.query.Select("tags")
	for i := len(opts) - 1; i >= 0; i-- {
		// `patterns` optional argument
		if !querybuilder.IsZeroValue(opts[i].Patterns) {
			q = q.Arg("patterns", opts[i].Patterns)
		}
	}

	var response []string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Header to authenticate the remote with.
//
// Deprecated: Use "httpAuthHeader" in the constructor instead.
func (r *GitRepository) WithAuthHeader(header *Secret) *GitRepository {
	assertNotNil("header", header)
	q := r.query.Select("withAuthHeader")
	q = q.Arg("header", header)

	return &GitRepository{
		query: q,
	}
}

// Token to authenticate the remote with.
//
// Deprecated: Use "httpAuthToken" in the constructor instead.
func (r *GitRepository) WithAuthToken(token *Secret) *GitRepository {
	assertNotNil("token", token)
	q := r.query.Select("withAuthToken")
	q = q.Arg("token", token)

	return &GitRepository{
		query: q,
	}
}

// A graphql input type, which is essentially just a group of named args.
// This is currently only used to represent pre-existing usage of graphql input types
// in the core API. It is not used by user modules and shouldn't ever be as user
// module accept input objects via their id rather than graphql input types.
type InputTypeDef struct {
	query *querybuilder.Selection

	id   *InputTypeDefID
	name *string
}

func (r *InputTypeDef) WithGraphQLQuery(q *querybuilder.Selection) *InputTypeDef {
	return &InputTypeDef{
		query: q,
	}
}

// Static fields defined on this input object, if any.
func (r *InputTypeDef) Fields(ctx context.Context) ([]FieldTypeDef, error) {
	q := r.query.Select("fields")

	q = q.Select("id")

	type fields struct {
		Id FieldTypeDefID
	}

	convert := func(fields []fields) []FieldTypeDef {
		out := []FieldTypeDef{}

		for i := range fields {
			val := FieldTypeDef{id: &fields[i].Id}
			val.query = q.Root().Select("loadFieldTypeDefFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []fields

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// A unique identifier for this InputTypeDef.
func (r *InputTypeDef) ID(ctx context.Context) (InputTypeDefID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response InputTypeDefID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *InputTypeDef) XXX_GraphQLType() string {
	return "InputTypeDef"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *InputTypeDef) XXX_GraphQLIDType() string {
	return "InputTypeDefID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *InputTypeDef) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *InputTypeDef) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *InputTypeDef) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadInputTypeDefFromID(InputTypeDefID(id))
	return nil
}

// The name of the input object.
func (r *InputTypeDef) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A definition of a custom interface defined in a Module.
type InterfaceTypeDef struct {
	query *querybuilder.Selection

	description      *string
	id               *InterfaceTypeDefID
	name             *string
	sourceModuleName *string
}

func (r *InterfaceTypeDef) WithGraphQLQuery(q *querybuilder.Selection) *InterfaceTypeDef {
	return &InterfaceTypeDef{
		query: q,
	}
}

// The doc string for the interface, if any.
func (r *InterfaceTypeDef) Description(ctx context.Context) (string, error) {
	if r.description != nil {
		return *r.description, nil
	}
	q := r.query.Select("description")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Functions defined on this interface, if any.
func (r *InterfaceTypeDef) Functions(ctx context.Context) ([]Function, error) {
	q := r.query.Select("functions")

	q = q.Select("id")

	type functions struct {
		Id FunctionID
	}

	convert := func(fields []functions) []Function {
		out := []Function{}

		for i := range fields {
			val := Function{id: &fields[i].Id}
			val.query = q.Root().Select("loadFunctionFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []functions

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// A unique identifier for this InterfaceTypeDef.
func (r *InterfaceTypeDef) ID(ctx context.Context) (InterfaceTypeDefID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response InterfaceTypeDefID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *InterfaceTypeDef) XXX_GraphQLType() string {
	return "InterfaceTypeDef"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *InterfaceTypeDef) XXX_GraphQLIDType() string {
	return "InterfaceTypeDefID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *InterfaceTypeDef) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *InterfaceTypeDef) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *InterfaceTypeDef) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadInterfaceTypeDefFromID(InterfaceTypeDefID(id))
	return nil
}

// The name of the interface.
func (r *InterfaceTypeDef) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The location of this interface declaration.
func (r *InterfaceTypeDef) SourceMap() *SourceMap {
	q := r.query.Select("sourceMap")

	return &SourceMap{
		query: q,
	}
}

// If this InterfaceTypeDef is associated with a Module, the name of the module. Unset otherwise.
func (r *InterfaceTypeDef) SourceModuleName(ctx context.Context) (string, error) {
	if r.sourceModuleName != nil {
		return *r.sourceModuleName, nil
	}
	q := r.query.Select("sourceModuleName")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

type K3S struct {
	query *querybuilder.Selection

	id *K3SID
}
type WithK3SFunc func(r *K3S) *K3S

// With calls the provided function with current K3S.
//
// This is useful for reusability and readability by not breaking the calling chain.
func (r *K3S) With(f WithK3SFunc) *K3S {
	return f(r)
}

func (r *K3S) WithGraphQLQuery(q *querybuilder.Selection) *K3S {
	return &K3S{
		query: q,
	}
}

// K3SConfigOpts contains options for K3S.Config
type K3SConfigOpts struct {
	Local bool
}

// returns the config file for the k3s cluster
func (r *K3S) Config(opts ...K3SConfigOpts) *File {
	q := r.query.Select("config")
	for i := len(opts) - 1; i >= 0; i-- {
		// `local` optional argument
		if !querybuilder.IsZeroValue(opts[i].Local) {
			q = q.Arg("local", opts[i].Local)
		}
	}

	return &File{
		query: q,
	}
}

func (r *K3S) Container() *Container {
	q := r.query.Select("container")

	return &Container{
		query: q,
	}
}

// A unique identifier for this K3S.
func (r *K3S) ID(ctx context.Context) (K3SID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response K3SID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *K3S) XXX_GraphQLType() string {
	return "K3S"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *K3S) XXX_GraphQLIDType() string {
	return "K3SID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *K3S) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *K3S) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *K3S) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadK3SFromID(K3SID(id))
	return nil
}

// runs k9s on the target k3s cluster
func (r *K3S) Kns() *Container {
	q := r.query.Select("kns")

	return &Container{
		query: q,
	}
}

// runs kubectl on the target k3s cluster
func (r *K3S) Kubectl(args string) *Container {
	q := r.query.Select("kubectl")
	q = q.Arg("args", args)

	return &Container{
		query: q,
	}
}

// Returns a newly initialized kind cluster
func (r *K3S) Server() *Service {
	q := r.query.Select("server")

	return &Service{
		query: q,
	}
}

// Returns a newly initialized kind cluster
func (r *K3S) WithContainer(c *Container) *K3S {
	assertNotNil("c", c)
	q := r.query.Select("withContainer")
	q = q.Arg("c", c)

	return &K3S{
		query: q,
	}
}

type LLM struct {
	query *querybuilder.Selection

	historyJSON *JSON
	id          *LLMID
	lastReply   *string
	model       *string
	provider    *string
	sync        *LLMID
	tools       *string
}
type WithLLMFunc func(r *LLM) *LLM

// With calls the provided function with current LLM.
//
// This is useful for reusability and readability by not breaking the calling chain.
func (r *LLM) With(f WithLLMFunc) *LLM {
	return f(r)
}

func (r *LLM) WithGraphQLQuery(q *querybuilder.Selection) *LLM {
	return &LLM{
		query: q,
	}
}

// create a branch in the LLM's history
func (r *LLM) Attempt(number int) *LLM {
	q := r.query.Select("attempt")
	q = q.Arg("number", number)

	return &LLM{
		query: q,
	}
}

// returns the type of the current state
func (r *LLM) BindResult(name string) *Binding {
	q := r.query.Select("bindResult")
	q = q.Arg("name", name)

	return &Binding{
		query: q,
	}
}

// return the LLM's current environment
func (r *LLM) Env() *Env {
	q := r.query.Select("env")

	return &Env{
		query: q,
	}
}

// return the llm message history
func (r *LLM) History(ctx context.Context) ([]string, error) {
	q := r.query.Select("history")

	var response []string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// return the raw llm message history as json
func (r *LLM) HistoryJSON(ctx context.Context) (JSON, error) {
	if r.historyJSON != nil {
		return *r.historyJSON, nil
	}
	q := r.query.Select("historyJSON")

	var response JSON

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this LLM.
func (r *LLM) ID(ctx context.Context) (LLMID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response LLMID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *LLM) XXX_GraphQLType() string {
	return "LLM"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *LLM) XXX_GraphQLIDType() string {
	return "LLMID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *LLM) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *LLM) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *LLM) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadLLMFromID(LLMID(id))
	return nil
}

// return the last llm reply from the history
func (r *LLM) LastReply(ctx context.Context) (string, error) {
	if r.lastReply != nil {
		return *r.lastReply, nil
	}
	q := r.query.Select("lastReply")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// synchronize LLM state
func (r *LLM) Loop() *LLM {
	q := r.query.Select("loop")

	return &LLM{
		query: q,
	}
}

// return the model used by the llm
func (r *LLM) Model(ctx context.Context) (string, error) {
	if r.model != nil {
		return *r.model, nil
	}
	q := r.query.Select("model")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// return the provider used by the llm
func (r *LLM) Provider(ctx context.Context) (string, error) {
	if r.provider != nil {
		return *r.provider, nil
	}
	q := r.query.Select("provider")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// synchronize LLM state
func (r *LLM) Sync(ctx context.Context) (*LLM, error) {
	q := r.query.Select("sync")

	var id LLMID
	if err := q.Bind(&id).Execute(ctx); err != nil {
		return nil, err
	}
	return &LLM{
		query: q.Root().Select("loadLLMFromID").Arg("id", id),
	}, nil
}

// returns the token usage of the current state
func (r *LLM) TokenUsage() *LLMTokenUsage {
	q := r.query.Select("tokenUsage")

	return &LLMTokenUsage{
		query: q,
	}
}

// print documentation for available tools
func (r *LLM) Tools(ctx context.Context) (string, error) {
	if r.tools != nil {
		return *r.tools, nil
	}
	q := r.query.Select("tools")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// allow the LLM to interact with an environment via MCP
func (r *LLM) WithEnv(env *Env) *LLM {
	assertNotNil("env", env)
	q := r.query.Select("withEnv")
	q = q.Arg("env", env)

	return &LLM{
		query: q,
	}
}

// swap out the llm model
func (r *LLM) WithModel(model string) *LLM {
	q := r.query.Select("withModel")
	q = q.Arg("model", model)

	return &LLM{
		query: q,
	}
}

// append a prompt to the llm context
func (r *LLM) WithPrompt(prompt string) *LLM {
	q := r.query.Select("withPrompt")
	q = q.Arg("prompt", prompt)

	return &LLM{
		query: q,
	}
}

// append the contents of a file to the llm context
func (r *LLM) WithPromptFile(file *File) *LLM {
	assertNotNil("file", file)
	q := r.query.Select("withPromptFile")
	q = q.Arg("file", file)

	return &LLM{
		query: q,
	}
}

// Add a system prompt to the LLM's environment
func (r *LLM) WithSystemPrompt(prompt string) *LLM {
	q := r.query.Select("withSystemPrompt")
	q = q.Arg("prompt", prompt)

	return &LLM{
		query: q,
	}
}

// Disable the default system prompt
func (r *LLM) WithoutDefaultSystemPrompt() *LLM {
	q := r.query.Select("withoutDefaultSystemPrompt")

	return &LLM{
		query: q,
	}
}

type LLMTokenUsage struct {
	query *querybuilder.Selection

	cachedTokenReads  *int
	cachedTokenWrites *int
	id                *LLMTokenUsageID
	inputTokens       *int
	outputTokens      *int
	totalTokens       *int
}

func (r *LLMTokenUsage) WithGraphQLQuery(q *querybuilder.Selection) *LLMTokenUsage {
	return &LLMTokenUsage{
		query: q,
	}
}

func (r *LLMTokenUsage) CachedTokenReads(ctx context.Context) (int, error) {
	if r.cachedTokenReads != nil {
		return *r.cachedTokenReads, nil
	}
	q := r.query.Select("cachedTokenReads")

	var response int

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

func (r *LLMTokenUsage) CachedTokenWrites(ctx context.Context) (int, error) {
	if r.cachedTokenWrites != nil {
		return *r.cachedTokenWrites, nil
	}
	q := r.query.Select("cachedTokenWrites")

	var response int

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this LLMTokenUsage.
func (r *LLMTokenUsage) ID(ctx context.Context) (LLMTokenUsageID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response LLMTokenUsageID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *LLMTokenUsage) XXX_GraphQLType() string {
	return "LLMTokenUsage"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *LLMTokenUsage) XXX_GraphQLIDType() string {
	return "LLMTokenUsageID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *LLMTokenUsage) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *LLMTokenUsage) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *LLMTokenUsage) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadLLMTokenUsageFromID(LLMTokenUsageID(id))
	return nil
}

func (r *LLMTokenUsage) InputTokens(ctx context.Context) (int, error) {
	if r.inputTokens != nil {
		return *r.inputTokens, nil
	}
	q := r.query.Select("inputTokens")

	var response int

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

func (r *LLMTokenUsage) OutputTokens(ctx context.Context) (int, error) {
	if r.outputTokens != nil {
		return *r.outputTokens, nil
	}
	q := r.query.Select("outputTokens")

	var response int

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

func (r *LLMTokenUsage) TotalTokens(ctx context.Context) (int, error) {
	if r.totalTokens != nil {
		return *r.totalTokens, nil
	}
	q := r.query.Select("totalTokens")

	var response int

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A simple key value object that represents a label.
type Label struct {
	query *querybuilder.Selection

	id    *LabelID
	name  *string
	value *string
}

func (r *Label) WithGraphQLQuery(q *querybuilder.Selection) *Label {
	return &Label{
		query: q,
	}
}

// A unique identifier for this Label.
func (r *Label) ID(ctx context.Context) (LabelID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response LabelID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *Label) XXX_GraphQLType() string {
	return "Label"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *Label) XXX_GraphQLIDType() string {
	return "LabelID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *Label) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *Label) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *Label) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadLabelFromID(LabelID(id))
	return nil
}

// The label name.
func (r *Label) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The label value.
func (r *Label) Value(ctx context.Context) (string, error) {
	if r.value != nil {
		return *r.value, nil
	}
	q := r.query.Select("value")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A definition of a list type in a Module.
type ListTypeDef struct {
	query *querybuilder.Selection

	id *ListTypeDefID
}

func (r *ListTypeDef) WithGraphQLQuery(q *querybuilder.Selection) *ListTypeDef {
	return &ListTypeDef{
		query: q,
	}
}

// The type of the elements in the list.
func (r *ListTypeDef) ElementTypeDef() *TypeDef {
	q := r.query.Select("elementTypeDef")

	return &TypeDef{
		query: q,
	}
}

// A unique identifier for this ListTypeDef.
func (r *ListTypeDef) ID(ctx context.Context) (ListTypeDefID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response ListTypeDefID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *ListTypeDef) XXX_GraphQLType() string {
	return "ListTypeDef"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *ListTypeDef) XXX_GraphQLIDType() string {
	return "ListTypeDefID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *ListTypeDef) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *ListTypeDef) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *ListTypeDef) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadListTypeDefFromID(ListTypeDefID(id))
	return nil
}

// A Dagger module.
type Module struct {
	query *querybuilder.Selection

	description *string
	id          *ModuleID
	name        *string
	serve       *Void
	sync        *ModuleID
}
type WithModuleFunc func(r *Module) *Module

// With calls the provided function with current Module.
//
// This is useful for reusability and readability by not breaking the calling chain.
func (r *Module) With(f WithModuleFunc) *Module {
	return f(r)
}

func (r *Module) WithGraphQLQuery(q *querybuilder.Selection) *Module {
	return &Module{
		query: q,
	}
}

// The dependencies of the module.
func (r *Module) Dependencies(ctx context.Context) ([]Module, error) {
	q := r.query.Select("dependencies")

	q = q.Select("id")

	type dependencies struct {
		Id ModuleID
	}

	convert := func(fields []dependencies) []Module {
		out := []Module{}

		for i := range fields {
			val := Module{id: &fields[i].Id}
			val.query = q.Root().Select("loadModuleFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []dependencies

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// The doc string of the module, if any
func (r *Module) Description(ctx context.Context) (string, error) {
	if r.description != nil {
		return *r.description, nil
	}
	q := r.query.Select("description")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Enumerations served by this module.
func (r *Module) Enums(ctx context.Context) ([]TypeDef, error) {
	q := r.query.Select("enums")

	q = q.Select("id")

	type enums struct {
		Id TypeDefID
	}

	convert := func(fields []enums) []TypeDef {
		out := []TypeDef{}

		for i := range fields {
			val := TypeDef{id: &fields[i].Id}
			val.query = q.Root().Select("loadTypeDefFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []enums

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// The generated files and directories made on top of the module source's context directory.
func (r *Module) GeneratedContextDirectory() *Directory {
	q := r.query.Select("generatedContextDirectory")

	return &Directory{
		query: q,
	}
}

// A unique identifier for this Module.
func (r *Module) ID(ctx context.Context) (ModuleID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response ModuleID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *Module) XXX_GraphQLType() string {
	return "Module"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *Module) XXX_GraphQLIDType() string {
	return "ModuleID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *Module) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *Module) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *Module) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadModuleFromID(ModuleID(id))
	return nil
}

// Interfaces served by this module.
func (r *Module) Interfaces(ctx context.Context) ([]TypeDef, error) {
	q := r.query.Select("interfaces")

	q = q.Select("id")

	type interfaces struct {
		Id TypeDefID
	}

	convert := func(fields []interfaces) []TypeDef {
		out := []TypeDef{}

		for i := range fields {
			val := TypeDef{id: &fields[i].Id}
			val.query = q.Root().Select("loadTypeDefFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []interfaces

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// The name of the module
func (r *Module) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Objects served by this module.
func (r *Module) Objects(ctx context.Context) ([]TypeDef, error) {
	q := r.query.Select("objects")

	q = q.Select("id")

	type objects struct {
		Id TypeDefID
	}

	convert := func(fields []objects) []TypeDef {
		out := []TypeDef{}

		for i := range fields {
			val := TypeDef{id: &fields[i].Id}
			val.query = q.Root().Select("loadTypeDefFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []objects

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// The container that runs the module's entrypoint. It will fail to execute if the module doesn't compile.
func (r *Module) Runtime() *Container {
	q := r.query.Select("runtime")

	return &Container{
		query: q,
	}
}

// The SDK config used by this module.
func (r *Module) SDK() *SDKConfig {
	q := r.query.Select("sdk")

	return &SDKConfig{
		query: q,
	}
}

// ModuleServeOpts contains options for Module.Serve
type ModuleServeOpts struct {
	// Expose the dependencies of this module to the client
	IncludeDependencies bool
}

// Serve a module's API in the current session.
//
// Note: this can only be called once per session. In the future, it could return a stream or service to remove the side effect.
func (r *Module) Serve(ctx context.Context, opts ...ModuleServeOpts) error {
	if r.serve != nil {
		return nil
	}
	q := r.query.Select("serve")
	for i := len(opts) - 1; i >= 0; i-- {
		// `includeDependencies` optional argument
		if !querybuilder.IsZeroValue(opts[i].IncludeDependencies) {
			q = q.Arg("includeDependencies", opts[i].IncludeDependencies)
		}
	}

	return q.Execute(ctx)
}

// The source for the module.
func (r *Module) Source() *ModuleSource {
	q := r.query.Select("source")

	return &ModuleSource{
		query: q,
	}
}

// Forces evaluation of the module, including any loading into the engine and associated validation.
func (r *Module) Sync(ctx context.Context) (*Module, error) {
	q := r.query.Select("sync")

	var id ModuleID
	if err := q.Bind(&id).Execute(ctx); err != nil {
		return nil, err
	}
	return &Module{
		query: q.Root().Select("loadModuleFromID").Arg("id", id),
	}, nil
}

// Retrieves the module with the given description
func (r *Module) WithDescription(description string) *Module {
	q := r.query.Select("withDescription")
	q = q.Arg("description", description)

	return &Module{
		query: q,
	}
}

// This module plus the given Enum type and associated values
func (r *Module) WithEnum(enum *TypeDef) *Module {
	assertNotNil("enum", enum)
	q := r.query.Select("withEnum")
	q = q.Arg("enum", enum)

	return &Module{
		query: q,
	}
}

// This module plus the given Interface type and associated functions
func (r *Module) WithInterface(iface *TypeDef) *Module {
	assertNotNil("iface", iface)
	q := r.query.Select("withInterface")
	q = q.Arg("iface", iface)

	return &Module{
		query: q,
	}
}

// This module plus the given Object type and associated functions.
func (r *Module) WithObject(object *TypeDef) *Module {
	assertNotNil("object", object)
	q := r.query.Select("withObject")
	q = q.Arg("object", object)

	return &Module{
		query: q,
	}
}

// The client generated for the module.
type ModuleConfigClient struct {
	query *querybuilder.Selection

	directory *string
	generator *string
	id        *ModuleConfigClientID
}

func (r *ModuleConfigClient) WithGraphQLQuery(q *querybuilder.Selection) *ModuleConfigClient {
	return &ModuleConfigClient{
		query: q,
	}
}

// The directory the client is generated in.
func (r *ModuleConfigClient) Directory(ctx context.Context) (string, error) {
	if r.directory != nil {
		return *r.directory, nil
	}
	q := r.query.Select("directory")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The generator to use
func (r *ModuleConfigClient) Generator(ctx context.Context) (string, error) {
	if r.generator != nil {
		return *r.generator, nil
	}
	q := r.query.Select("generator")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this ModuleConfigClient.
func (r *ModuleConfigClient) ID(ctx context.Context) (ModuleConfigClientID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response ModuleConfigClientID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *ModuleConfigClient) XXX_GraphQLType() string {
	return "ModuleConfigClient"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *ModuleConfigClient) XXX_GraphQLIDType() string {
	return "ModuleConfigClientID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *ModuleConfigClient) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *ModuleConfigClient) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *ModuleConfigClient) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadModuleConfigClientFromID(ModuleConfigClientID(id))
	return nil
}

// The source needed to load and run a module, along with any metadata about the source such as versions/urls/etc.
type ModuleSource struct {
	query *querybuilder.Selection

	asString                  *string
	cloneRef                  *string
	commit                    *string
	configExists              *bool
	digest                    *string
	engineVersion             *string
	htmlRepoURL               *string
	htmlURL                   *string
	id                        *ModuleSourceID
	kind                      *ModuleSourceKind
	localContextDirectoryPath *string
	moduleName                *string
	moduleOriginalName        *string
	originalSubpath           *string
	pin                       *string
	repoRootPath              *string
	sourceRootSubpath         *string
	sourceSubpath             *string
	sync                      *ModuleSourceID
	version                   *string
}
type WithModuleSourceFunc func(r *ModuleSource) *ModuleSource

// With calls the provided function with current ModuleSource.
//
// This is useful for reusability and readability by not breaking the calling chain.
func (r *ModuleSource) With(f WithModuleSourceFunc) *ModuleSource {
	return f(r)
}

func (r *ModuleSource) WithGraphQLQuery(q *querybuilder.Selection) *ModuleSource {
	return &ModuleSource{
		query: q,
	}
}

// Load the source as a module. If this is a local source, the parent directory must have been provided during module source creation
func (r *ModuleSource) AsModule() *Module {
	q := r.query.Select("asModule")

	return &Module{
		query: q,
	}
}

// A human readable ref string representation of this module source.
func (r *ModuleSource) AsString(ctx context.Context) (string, error) {
	if r.asString != nil {
		return *r.asString, nil
	}
	q := r.query.Select("asString")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The ref to clone the root of the git repo from. Only valid for git sources.
func (r *ModuleSource) CloneRef(ctx context.Context) (string, error) {
	if r.cloneRef != nil {
		return *r.cloneRef, nil
	}
	q := r.query.Select("cloneRef")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The resolved commit of the git repo this source points to.
func (r *ModuleSource) Commit(ctx context.Context) (string, error) {
	if r.commit != nil {
		return *r.commit, nil
	}
	q := r.query.Select("commit")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The clients generated for the module.
func (r *ModuleSource) ConfigClients(ctx context.Context) ([]ModuleConfigClient, error) {
	q := r.query.Select("configClients")

	q = q.Select("id")

	type configClients struct {
		Id ModuleConfigClientID
	}

	convert := func(fields []configClients) []ModuleConfigClient {
		out := []ModuleConfigClient{}

		for i := range fields {
			val := ModuleConfigClient{id: &fields[i].Id}
			val.query = q.Root().Select("loadModuleConfigClientFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []configClients

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// Whether an existing dagger.json for the module was found.
func (r *ModuleSource) ConfigExists(ctx context.Context) (bool, error) {
	if r.configExists != nil {
		return *r.configExists, nil
	}
	q := r.query.Select("configExists")

	var response bool

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The full directory loaded for the module source, including the source code as a subdirectory.
func (r *ModuleSource) ContextDirectory() *Directory {
	q := r.query.Select("contextDirectory")

	return &Directory{
		query: q,
	}
}

// The dependencies of the module source.
func (r *ModuleSource) Dependencies(ctx context.Context) ([]ModuleSource, error) {
	q := r.query.Select("dependencies")

	q = q.Select("id")

	type dependencies struct {
		Id ModuleSourceID
	}

	convert := func(fields []dependencies) []ModuleSource {
		out := []ModuleSource{}

		for i := range fields {
			val := ModuleSource{id: &fields[i].Id}
			val.query = q.Root().Select("loadModuleSourceFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []dependencies

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// A content-hash of the module source. Module sources with the same digest will output the same generated context and convert into the same module instance.
func (r *ModuleSource) Digest(ctx context.Context) (string, error) {
	if r.digest != nil {
		return *r.digest, nil
	}
	q := r.query.Select("digest")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The directory containing the module configuration and source code (source code may be in a subdir).
func (r *ModuleSource) Directory(path string) *Directory {
	q := r.query.Select("directory")
	q = q.Arg("path", path)

	return &Directory{
		query: q,
	}
}

// The engine version of the module.
func (r *ModuleSource) EngineVersion(ctx context.Context) (string, error) {
	if r.engineVersion != nil {
		return *r.engineVersion, nil
	}
	q := r.query.Select("engineVersion")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The generated files and directories made on top of the module source's context directory.
func (r *ModuleSource) GeneratedContextDirectory() *Directory {
	q := r.query.Select("generatedContextDirectory")

	return &Directory{
		query: q,
	}
}

// The URL to access the web view of the repository (e.g., GitHub, GitLab, Bitbucket).
func (r *ModuleSource) HTMLRepoURL(ctx context.Context) (string, error) {
	if r.htmlRepoURL != nil {
		return *r.htmlRepoURL, nil
	}
	q := r.query.Select("htmlRepoURL")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The URL to the source's git repo in a web browser. Only valid for git sources.
func (r *ModuleSource) HTMLURL(ctx context.Context) (string, error) {
	if r.htmlURL != nil {
		return *r.htmlURL, nil
	}
	q := r.query.Select("htmlURL")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this ModuleSource.
func (r *ModuleSource) ID(ctx context.Context) (ModuleSourceID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response ModuleSourceID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *ModuleSource) XXX_GraphQLType() string {
	return "ModuleSource"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *ModuleSource) XXX_GraphQLIDType() string {
	return "ModuleSourceID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *ModuleSource) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *ModuleSource) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *ModuleSource) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadModuleSourceFromID(ModuleSourceID(id))
	return nil
}

// The kind of module source (currently local, git or dir).
func (r *ModuleSource) Kind(ctx context.Context) (ModuleSourceKind, error) {
	if r.kind != nil {
		return *r.kind, nil
	}
	q := r.query.Select("kind")

	var response ModuleSourceKind

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The full absolute path to the context directory on the caller's host filesystem that this module source is loaded from. Only valid for local module sources.
func (r *ModuleSource) LocalContextDirectoryPath(ctx context.Context) (string, error) {
	if r.localContextDirectoryPath != nil {
		return *r.localContextDirectoryPath, nil
	}
	q := r.query.Select("localContextDirectoryPath")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The name of the module, including any setting via the withName API.
func (r *ModuleSource) ModuleName(ctx context.Context) (string, error) {
	if r.moduleName != nil {
		return *r.moduleName, nil
	}
	q := r.query.Select("moduleName")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The original name of the module as read from the module's dagger.json (or set for the first time with the withName API).
func (r *ModuleSource) ModuleOriginalName(ctx context.Context) (string, error) {
	if r.moduleOriginalName != nil {
		return *r.moduleOriginalName, nil
	}
	q := r.query.Select("moduleOriginalName")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The original subpath used when instantiating this module source, relative to the context directory.
func (r *ModuleSource) OriginalSubpath(ctx context.Context) (string, error) {
	if r.originalSubpath != nil {
		return *r.originalSubpath, nil
	}
	q := r.query.Select("originalSubpath")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The pinned version of this module source.
func (r *ModuleSource) Pin(ctx context.Context) (string, error) {
	if r.pin != nil {
		return *r.pin, nil
	}
	q := r.query.Select("pin")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The import path corresponding to the root of the git repo this source points to. Only valid for git sources.
func (r *ModuleSource) RepoRootPath(ctx context.Context) (string, error) {
	if r.repoRootPath != nil {
		return *r.repoRootPath, nil
	}
	q := r.query.Select("repoRootPath")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The SDK configuration of the module.
func (r *ModuleSource) SDK() *SDKConfig {
	q := r.query.Select("sdk")

	return &SDKConfig{
		query: q,
	}
}

// The path, relative to the context directory, that contains the module's dagger.json.
func (r *ModuleSource) SourceRootSubpath(ctx context.Context) (string, error) {
	if r.sourceRootSubpath != nil {
		return *r.sourceRootSubpath, nil
	}
	q := r.query.Select("sourceRootSubpath")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The path to the directory containing the module's source code, relative to the context directory.
func (r *ModuleSource) SourceSubpath(ctx context.Context) (string, error) {
	if r.sourceSubpath != nil {
		return *r.sourceSubpath, nil
	}
	q := r.query.Select("sourceSubpath")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Forces evaluation of the module source, including any loading into the engine and associated validation.
func (r *ModuleSource) Sync(ctx context.Context) (*ModuleSource, error) {
	q := r.query.Select("sync")

	var id ModuleSourceID
	if err := q.Bind(&id).Execute(ctx); err != nil {
		return nil, err
	}
	return &ModuleSource{
		query: q.Root().Select("loadModuleSourceFromID").Arg("id", id),
	}, nil
}

// The specified version of the git repo this source points to.
func (r *ModuleSource) Version(ctx context.Context) (string, error) {
	if r.version != nil {
		return *r.version, nil
	}
	q := r.query.Select("version")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Update the module source with a new client to generate.
func (r *ModuleSource) WithClient(generator string, outputDir string) *ModuleSource {
	q := r.query.Select("withClient")
	q = q.Arg("generator", generator)
	q = q.Arg("outputDir", outputDir)

	return &ModuleSource{
		query: q,
	}
}

// Append the provided dependencies to the module source's dependency list.
func (r *ModuleSource) WithDependencies(dependencies []*ModuleSource) *ModuleSource {
	q := r.query.Select("withDependencies")
	q = q.Arg("dependencies", dependencies)

	return &ModuleSource{
		query: q,
	}
}

// Upgrade the engine version of the module to the given value.
func (r *ModuleSource) WithEngineVersion(version string) *ModuleSource {
	q := r.query.Select("withEngineVersion")
	q = q.Arg("version", version)

	return &ModuleSource{
		query: q,
	}
}

// Update the module source with additional include patterns for files+directories from its context that are required for building it
func (r *ModuleSource) WithIncludes(patterns []string) *ModuleSource {
	q := r.query.Select("withIncludes")
	q = q.Arg("patterns", patterns)

	return &ModuleSource{
		query: q,
	}
}

// Update the module source with a new name.
func (r *ModuleSource) WithName(name string) *ModuleSource {
	q := r.query.Select("withName")
	q = q.Arg("name", name)

	return &ModuleSource{
		query: q,
	}
}

// Update the module source with a new SDK.
func (r *ModuleSource) WithSDK(source string) *ModuleSource {
	q := r.query.Select("withSDK")
	q = q.Arg("source", source)

	return &ModuleSource{
		query: q,
	}
}

// Update the module source with a new source subpath.
func (r *ModuleSource) WithSourceSubpath(path string) *ModuleSource {
	q := r.query.Select("withSourceSubpath")
	q = q.Arg("path", path)

	return &ModuleSource{
		query: q,
	}
}

// Update one or more module dependencies.
func (r *ModuleSource) WithUpdateDependencies(dependencies []string) *ModuleSource {
	q := r.query.Select("withUpdateDependencies")
	q = q.Arg("dependencies", dependencies)

	return &ModuleSource{
		query: q,
	}
}

// Remove a client from the module source.
func (r *ModuleSource) WithoutClient(path string) *ModuleSource {
	q := r.query.Select("withoutClient")
	q = q.Arg("path", path)

	return &ModuleSource{
		query: q,
	}
}

// Remove the provided dependencies from the module source's dependency list.
func (r *ModuleSource) WithoutDependencies(dependencies []string) *ModuleSource {
	q := r.query.Select("withoutDependencies")
	q = q.Arg("dependencies", dependencies)

	return &ModuleSource{
		query: q,
	}
}

// A definition of a custom object defined in a Module.
type ObjectTypeDef struct {
	query *querybuilder.Selection

	description      *string
	id               *ObjectTypeDefID
	name             *string
	sourceModuleName *string
}

func (r *ObjectTypeDef) WithGraphQLQuery(q *querybuilder.Selection) *ObjectTypeDef {
	return &ObjectTypeDef{
		query: q,
	}
}

// The function used to construct new instances of this object, if any
func (r *ObjectTypeDef) Constructor() *Function {
	q := r.query.Select("constructor")

	return &Function{
		query: q,
	}
}

// The doc string for the object, if any.
func (r *ObjectTypeDef) Description(ctx context.Context) (string, error) {
	if r.description != nil {
		return *r.description, nil
	}
	q := r.query.Select("description")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Static fields defined on this object, if any.
func (r *ObjectTypeDef) Fields(ctx context.Context) ([]FieldTypeDef, error) {
	q := r.query.Select("fields")

	q = q.Select("id")

	type fields struct {
		Id FieldTypeDefID
	}

	convert := func(fields []fields) []FieldTypeDef {
		out := []FieldTypeDef{}

		for i := range fields {
			val := FieldTypeDef{id: &fields[i].Id}
			val.query = q.Root().Select("loadFieldTypeDefFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []fields

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// Functions defined on this object, if any.
func (r *ObjectTypeDef) Functions(ctx context.Context) ([]Function, error) {
	q := r.query.Select("functions")

	q = q.Select("id")

	type functions struct {
		Id FunctionID
	}

	convert := func(fields []functions) []Function {
		out := []Function{}

		for i := range fields {
			val := Function{id: &fields[i].Id}
			val.query = q.Root().Select("loadFunctionFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []functions

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// A unique identifier for this ObjectTypeDef.
func (r *ObjectTypeDef) ID(ctx context.Context) (ObjectTypeDefID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response ObjectTypeDefID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *ObjectTypeDef) XXX_GraphQLType() string {
	return "ObjectTypeDef"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *ObjectTypeDef) XXX_GraphQLIDType() string {
	return "ObjectTypeDefID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *ObjectTypeDef) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *ObjectTypeDef) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *ObjectTypeDef) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadObjectTypeDefFromID(ObjectTypeDefID(id))
	return nil
}

// The name of the object.
func (r *ObjectTypeDef) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The location of this object declaration.
func (r *ObjectTypeDef) SourceMap() *SourceMap {
	q := r.query.Select("sourceMap")

	return &SourceMap{
		query: q,
	}
}

// If this ObjectTypeDef is associated with a Module, the name of the module. Unset otherwise.
func (r *ObjectTypeDef) SourceModuleName(ctx context.Context) (string, error) {
	if r.sourceModuleName != nil {
		return *r.sourceModuleName, nil
	}
	q := r.query.Select("sourceModuleName")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A port exposed by a container.
type Port struct {
	query *querybuilder.Selection

	description                 *string
	experimentalSkipHealthcheck *bool
	id                          *PortID
	port                        *int
	protocol                    *NetworkProtocol
}

func (r *Port) WithGraphQLQuery(q *querybuilder.Selection) *Port {
	return &Port{
		query: q,
	}
}

// The port description.
func (r *Port) Description(ctx context.Context) (string, error) {
	if r.description != nil {
		return *r.description, nil
	}
	q := r.query.Select("description")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Skip the health check when run as a service.
func (r *Port) ExperimentalSkipHealthcheck(ctx context.Context) (bool, error) {
	if r.experimentalSkipHealthcheck != nil {
		return *r.experimentalSkipHealthcheck, nil
	}
	q := r.query.Select("experimentalSkipHealthcheck")

	var response bool

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this Port.
func (r *Port) ID(ctx context.Context) (PortID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response PortID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *Port) XXX_GraphQLType() string {
	return "Port"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *Port) XXX_GraphQLIDType() string {
	return "PortID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *Port) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *Port) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *Port) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadPortFromID(PortID(id))
	return nil
}

// The port number.
func (r *Port) Port(ctx context.Context) (int, error) {
	if r.port != nil {
		return *r.port, nil
	}
	q := r.query.Select("port")

	var response int

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The transport layer protocol.
func (r *Port) Protocol(ctx context.Context) (NetworkProtocol, error) {
	if r.protocol != nil {
		return *r.protocol, nil
	}
	q := r.query.Select("protocol")

	var response NetworkProtocol

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

func (r *Client) WithGraphQLQuery(q *querybuilder.Selection) *Client {
	return &Client{
		query:  q,
		client: r.client,
	}
}

// Constructs a cache volume for a given cache key.
func (r *Client) CacheVolume(key string) *CacheVolume {
	q := r.query.Select("cacheVolume")
	q = q.Arg("key", key)

	return &CacheVolume{
		query: q,
	}
}

// Dagger Cloud configuration and state
func (r *Client) Cloud() *Cloud {
	q := r.query.Select("cloud")

	return &Cloud{
		query: q,
	}
}

// ContainerOpts contains options for Client.Container
type ContainerOpts struct {
	// Platform to initialize the container with. Defaults to the native platform of the current engine
	Platform Platform
}

// Creates a scratch container, with no image or metadata.
//
// To pull an image, follow up with the "from" function.
func (r *Client) Container(opts ...ContainerOpts) *Container {
	q := r.query.Select("container")
	for i := len(opts) - 1; i >= 0; i-- {
		// `platform` optional argument
		if !querybuilder.IsZeroValue(opts[i].Platform) {
			q = q.Arg("platform", opts[i].Platform)
		}
	}

	return &Container{
		query: q,
	}
}

// The FunctionCall context that the SDK caller is currently executing in.
//
// If the caller is not currently executing in a function, this will return an error.
func (r *Client) CurrentFunctionCall() *FunctionCall {
	q := r.query.Select("currentFunctionCall")

	return &FunctionCall{
		query: q,
	}
}

// The module currently being served in the session, if any.
func (r *Client) CurrentModule() *CurrentModule {
	q := r.query.Select("currentModule")

	return &CurrentModule{
		query: q,
	}
}

// The TypeDef representations of the objects currently being served in the session.
func (r *Client) CurrentTypeDefs(ctx context.Context) ([]TypeDef, error) {
	q := r.query.Select("currentTypeDefs")

	q = q.Select("id")

	type currentTypeDefs struct {
		Id TypeDefID
	}

	convert := func(fields []currentTypeDefs) []TypeDef {
		out := []TypeDef{}

		for i := range fields {
			val := TypeDef{id: &fields[i].Id}
			val.query = q.Root().Select("loadTypeDefFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []currentTypeDefs

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// The default platform of the engine.
func (r *Client) DefaultPlatform(ctx context.Context) (Platform, error) {
	q := r.query.Select("defaultPlatform")

	var response Platform

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Creates an empty directory.
func (r *Client) Directory() *Directory {
	q := r.query.Select("directory")

	return &Directory{
		query: q,
	}
}

// EnvOpts contains options for Client.Env
type EnvOpts struct {
	// Give the environment the same privileges as the caller: core API including host access, current module, and dependencies
	Privileged bool
	// Allow new outputs to be declared and saved in the environment
	Writable bool
}

// Initialize a new environment
//
// Experimental: Environments are not yet stabilized
func (r *Client) Env(opts ...EnvOpts) *Env {
	q := r.query.Select("env")
	for i := len(opts) - 1; i >= 0; i-- {
		// `privileged` optional argument
		if !querybuilder.IsZeroValue(opts[i].Privileged) {
			q = q.Arg("privileged", opts[i].Privileged)
		}
		// `writable` optional argument
		if !querybuilder.IsZeroValue(opts[i].Writable) {
			q = q.Arg("writable", opts[i].Writable)
		}
	}

	return &Env{
		query: q,
	}
}

// Create a new error.
func (r *Client) Error(message string) *Error {
	q := r.query.Select("error")
	q = q.Arg("message", message)

	return &Error{
		query: q,
	}
}

// FileOpts contains options for Client.File
type FileOpts struct {
	// Permissions of the new file. Example: 0600
	//
	// Default: 420
	Permissions int
}

// Creates a file with the specified contents.
func (r *Client) File(name string, contents string, opts ...FileOpts) *File {
	q := r.query.Select("file")
	for i := len(opts) - 1; i >= 0; i-- {
		// `permissions` optional argument
		if !querybuilder.IsZeroValue(opts[i].Permissions) {
			q = q.Arg("permissions", opts[i].Permissions)
		}
	}
	q = q.Arg("name", name)
	q = q.Arg("contents", contents)

	return &File{
		query: q,
	}
}

// Creates a function.
func (r *Client) Function(name string, returnType *TypeDef) *Function {
	assertNotNil("returnType", returnType)
	q := r.query.Select("function")
	q = q.Arg("name", name)
	q = q.Arg("returnType", returnType)

	return &Function{
		query: q,
	}
}

// Create a code generation result, given a directory containing the generated code.
func (r *Client) GeneratedCode(code *Directory) *GeneratedCode {
	assertNotNil("code", code)
	q := r.query.Select("generatedCode")
	q = q.Arg("code", code)

	return &GeneratedCode{
		query: q,
	}
}

// GitOpts contains options for Client.Git
type GitOpts struct {
	// DEPRECATED: Set to true to keep .git directory.
	//
	// Default: true
	KeepGitDir bool
	// Set SSH known hosts
	SSHKnownHosts string
	// Set SSH auth socket
	SSHAuthSocket *Socket
	// Username used to populate the password during basic HTTP Authorization
	HTTPAuthUsername string
	// Secret used to populate the password during basic HTTP Authorization
	HTTPAuthToken *Secret
	// Secret used to populate the Authorization HTTP header
	HTTPAuthHeader *Secret
	// A service which must be started before the repo is fetched.
	ExperimentalServiceHost *Service
}

// Queries a Git repository.
func (r *Client) Git(url string, opts ...GitOpts) *GitRepository {
	q := r.query.Select("git")
	for i := len(opts) - 1; i >= 0; i-- {
		// `keepGitDir` optional argument
		if !querybuilder.IsZeroValue(opts[i].KeepGitDir) {
			q = q.Arg("keepGitDir", opts[i].KeepGitDir)
		}
		// `sshKnownHosts` optional argument
		if !querybuilder.IsZeroValue(opts[i].SSHKnownHosts) {
			q = q.Arg("sshKnownHosts", opts[i].SSHKnownHosts)
		}
		// `sshAuthSocket` optional argument
		if !querybuilder.IsZeroValue(opts[i].SSHAuthSocket) {
			q = q.Arg("sshAuthSocket", opts[i].SSHAuthSocket)
		}
		// `httpAuthUsername` optional argument
		if !querybuilder.IsZeroValue(opts[i].HTTPAuthUsername) {
			q = q.Arg("httpAuthUsername", opts[i].HTTPAuthUsername)
		}
		// `httpAuthToken` optional argument
		if !querybuilder.IsZeroValue(opts[i].HTTPAuthToken) {
			q = q.Arg("httpAuthToken", opts[i].HTTPAuthToken)
		}
		// `httpAuthHeader` optional argument
		if !querybuilder.IsZeroValue(opts[i].HTTPAuthHeader) {
			q = q.Arg("httpAuthHeader", opts[i].HTTPAuthHeader)
		}
		// `experimentalServiceHost` optional argument
		if !querybuilder.IsZeroValue(opts[i].ExperimentalServiceHost) {
			q = q.Arg("experimentalServiceHost", opts[i].ExperimentalServiceHost)
		}
	}
	q = q.Arg("url", url)

	return &GitRepository{
		query: q,
	}
}

// HTTPOpts contains options for Client.HTTP
type HTTPOpts struct {
	// File name to use for the file. Defaults to the last part of the URL.
	Name string
	// Permissions to set on the file.
	Permissions int
	// Secret used to populate the Authorization HTTP header
	AuthHeader *Secret
	// A service which must be started before the URL is fetched.
	ExperimentalServiceHost *Service
}

// Returns a file containing an http remote url content.
func (r *Client) HTTP(url string, opts ...HTTPOpts) *File {
	q := r.query.Select("http")
	for i := len(opts) - 1; i >= 0; i-- {
		// `name` optional argument
		if !querybuilder.IsZeroValue(opts[i].Name) {
			q = q.Arg("name", opts[i].Name)
		}
		// `permissions` optional argument
		if !querybuilder.IsZeroValue(opts[i].Permissions) {
			q = q.Arg("permissions", opts[i].Permissions)
		}
		// `authHeader` optional argument
		if !querybuilder.IsZeroValue(opts[i].AuthHeader) {
			q = q.Arg("authHeader", opts[i].AuthHeader)
		}
		// `experimentalServiceHost` optional argument
		if !querybuilder.IsZeroValue(opts[i].ExperimentalServiceHost) {
			q = q.Arg("experimentalServiceHost", opts[i].ExperimentalServiceHost)
		}
	}
	q = q.Arg("url", url)

	return &File{
		query: q,
	}
}

// K3SOpts contains options for Client.K3S
type K3SOpts struct {

	// Default: "rancher/k3s:latest"
	Image string
	//
	// keeps the state of the cluster (not recommended).
	//
	KeepState bool
}

func (r *Client) K3S(name string, opts ...K3SOpts) *K3S {
	q := r.query.Select("k3S")
	for i := len(opts) - 1; i >= 0; i-- {
		// `image` optional argument
		if !querybuilder.IsZeroValue(opts[i].Image) {
			q = q.Arg("image", opts[i].Image)
		}
		// `keepState` optional argument
		if !querybuilder.IsZeroValue(opts[i].KeepState) {
			q = q.Arg("keepState", opts[i].KeepState)
		}
	}
	q = q.Arg("name", name)

	return &K3S{
		query: q,
	}
}

// LLMOpts contains options for Client.LLM
type LLMOpts struct {
	// Model to use
	Model string
	// Cap the number of API calls for this LLM
	MaxAPICalls int
}

// Initialize a Large Language Model (LLM)
//
// Experimental: LLM support is not yet stabilized
func (r *Client) LLM(opts ...LLMOpts) *LLM {
	q := r.query.Select("llm")
	for i := len(opts) - 1; i >= 0; i-- {
		// `model` optional argument
		if !querybuilder.IsZeroValue(opts[i].Model) {
			q = q.Arg("model", opts[i].Model)
		}
		// `maxAPICalls` optional argument
		if !querybuilder.IsZeroValue(opts[i].MaxAPICalls) {
			q = q.Arg("maxAPICalls", opts[i].MaxAPICalls)
		}
	}

	return &LLM{
		query: q,
	}
}

// Load a Binding from its ID.
func (r *Client) LoadBindingFromID(id BindingID) *Binding {
	q := r.query.Select("loadBindingFromID")
	q = q.Arg("id", id)

	return &Binding{
		query: q,
	}
}

// Load a CacheVolume from its ID.
func (r *Client) LoadCacheVolumeFromID(id CacheVolumeID) *CacheVolume {
	q := r.query.Select("loadCacheVolumeFromID")
	q = q.Arg("id", id)

	return &CacheVolume{
		query: q,
	}
}

// Load a Cloud from its ID.
func (r *Client) LoadCloudFromID(id CloudID) *Cloud {
	q := r.query.Select("loadCloudFromID")
	q = q.Arg("id", id)

	return &Cloud{
		query: q,
	}
}

// Load a Container from its ID.
func (r *Client) LoadContainerFromID(id ContainerID) *Container {
	q := r.query.Select("loadContainerFromID")
	q = q.Arg("id", id)

	return &Container{
		query: q,
	}
}

// Load a CurrentModule from its ID.
func (r *Client) LoadCurrentModuleFromID(id CurrentModuleID) *CurrentModule {
	q := r.query.Select("loadCurrentModuleFromID")
	q = q.Arg("id", id)

	return &CurrentModule{
		query: q,
	}
}

// Load a Directory from its ID.
func (r *Client) LoadDirectoryFromID(id DirectoryID) *Directory {
	q := r.query.Select("loadDirectoryFromID")
	q = q.Arg("id", id)

	return &Directory{
		query: q,
	}
}

// Load a EnumTypeDef from its ID.
func (r *Client) LoadEnumTypeDefFromID(id EnumTypeDefID) *EnumTypeDef {
	q := r.query.Select("loadEnumTypeDefFromID")
	q = q.Arg("id", id)

	return &EnumTypeDef{
		query: q,
	}
}

// Load a EnumValueTypeDef from its ID.
func (r *Client) LoadEnumValueTypeDefFromID(id EnumValueTypeDefID) *EnumValueTypeDef {
	q := r.query.Select("loadEnumValueTypeDefFromID")
	q = q.Arg("id", id)

	return &EnumValueTypeDef{
		query: q,
	}
}

// Load a Env from its ID.
func (r *Client) LoadEnvFromID(id EnvID) *Env {
	q := r.query.Select("loadEnvFromID")
	q = q.Arg("id", id)

	return &Env{
		query: q,
	}
}

// Load a EnvVariable from its ID.
func (r *Client) LoadEnvVariableFromID(id EnvVariableID) *EnvVariable {
	q := r.query.Select("loadEnvVariableFromID")
	q = q.Arg("id", id)

	return &EnvVariable{
		query: q,
	}
}

// Load a Error from its ID.
func (r *Client) LoadErrorFromID(id ErrorID) *Error {
	q := r.query.Select("loadErrorFromID")
	q = q.Arg("id", id)

	return &Error{
		query: q,
	}
}

// Load a ErrorValue from its ID.
func (r *Client) LoadErrorValueFromID(id ErrorValueID) *ErrorValue {
	q := r.query.Select("loadErrorValueFromID")
	q = q.Arg("id", id)

	return &ErrorValue{
		query: q,
	}
}

// Load a FieldTypeDef from its ID.
func (r *Client) LoadFieldTypeDefFromID(id FieldTypeDefID) *FieldTypeDef {
	q := r.query.Select("loadFieldTypeDefFromID")
	q = q.Arg("id", id)

	return &FieldTypeDef{
		query: q,
	}
}

// Load a File from its ID.
func (r *Client) LoadFileFromID(id FileID) *File {
	q := r.query.Select("loadFileFromID")
	q = q.Arg("id", id)

	return &File{
		query: q,
	}
}

// Load a FunctionArg from its ID.
func (r *Client) LoadFunctionArgFromID(id FunctionArgID) *FunctionArg {
	q := r.query.Select("loadFunctionArgFromID")
	q = q.Arg("id", id)

	return &FunctionArg{
		query: q,
	}
}

// Load a FunctionCallArgValue from its ID.
func (r *Client) LoadFunctionCallArgValueFromID(id FunctionCallArgValueID) *FunctionCallArgValue {
	q := r.query.Select("loadFunctionCallArgValueFromID")
	q = q.Arg("id", id)

	return &FunctionCallArgValue{
		query: q,
	}
}

// Load a FunctionCall from its ID.
func (r *Client) LoadFunctionCallFromID(id FunctionCallID) *FunctionCall {
	q := r.query.Select("loadFunctionCallFromID")
	q = q.Arg("id", id)

	return &FunctionCall{
		query: q,
	}
}

// Load a Function from its ID.
func (r *Client) LoadFunctionFromID(id FunctionID) *Function {
	q := r.query.Select("loadFunctionFromID")
	q = q.Arg("id", id)

	return &Function{
		query: q,
	}
}

// Load a GeneratedCode from its ID.
func (r *Client) LoadGeneratedCodeFromID(id GeneratedCodeID) *GeneratedCode {
	q := r.query.Select("loadGeneratedCodeFromID")
	q = q.Arg("id", id)

	return &GeneratedCode{
		query: q,
	}
}

// Load a GitRef from its ID.
func (r *Client) LoadGitRefFromID(id GitRefID) *GitRef {
	q := r.query.Select("loadGitRefFromID")
	q = q.Arg("id", id)

	return &GitRef{
		query: q,
	}
}

// Load a GitRepository from its ID.
func (r *Client) LoadGitRepositoryFromID(id GitRepositoryID) *GitRepository {
	q := r.query.Select("loadGitRepositoryFromID")
	q = q.Arg("id", id)

	return &GitRepository{
		query: q,
	}
}

// Load a InputTypeDef from its ID.
func (r *Client) LoadInputTypeDefFromID(id InputTypeDefID) *InputTypeDef {
	q := r.query.Select("loadInputTypeDefFromID")
	q = q.Arg("id", id)

	return &InputTypeDef{
		query: q,
	}
}

// Load a InterfaceTypeDef from its ID.
func (r *Client) LoadInterfaceTypeDefFromID(id InterfaceTypeDefID) *InterfaceTypeDef {
	q := r.query.Select("loadInterfaceTypeDefFromID")
	q = q.Arg("id", id)

	return &InterfaceTypeDef{
		query: q,
	}
}

// Load a K3S from its ID.
func (r *Client) LoadK3SFromID(id K3SID) *K3S {
	q := r.query.Select("loadK3SFromID")
	q = q.Arg("id", id)

	return &K3S{
		query: q,
	}
}

// Load a LLM from its ID.
func (r *Client) LoadLLMFromID(id LLMID) *LLM {
	q := r.query.Select("loadLLMFromID")
	q = q.Arg("id", id)

	return &LLM{
		query: q,
	}
}

// Load a LLMTokenUsage from its ID.
func (r *Client) LoadLLMTokenUsageFromID(id LLMTokenUsageID) *LLMTokenUsage {
	q := r.query.Select("loadLLMTokenUsageFromID")
	q = q.Arg("id", id)

	return &LLMTokenUsage{
		query: q,
	}
}

// Load a Label from its ID.
func (r *Client) LoadLabelFromID(id LabelID) *Label {
	q := r.query.Select("loadLabelFromID")
	q = q.Arg("id", id)

	return &Label{
		query: q,
	}
}

// Load a ListTypeDef from its ID.
func (r *Client) LoadListTypeDefFromID(id ListTypeDefID) *ListTypeDef {
	q := r.query.Select("loadListTypeDefFromID")
	q = q.Arg("id", id)

	return &ListTypeDef{
		query: q,
	}
}

// Load a ModuleConfigClient from its ID.
func (r *Client) LoadModuleConfigClientFromID(id ModuleConfigClientID) *ModuleConfigClient {
	q := r.query.Select("loadModuleConfigClientFromID")
	q = q.Arg("id", id)

	return &ModuleConfigClient{
		query: q,
	}
}

// Load a Module from its ID.
func (r *Client) LoadModuleFromID(id ModuleID) *Module {
	q := r.query.Select("loadModuleFromID")
	q = q.Arg("id", id)

	return &Module{
		query: q,
	}
}

// Load a ModuleSource from its ID.
func (r *Client) LoadModuleSourceFromID(id ModuleSourceID) *ModuleSource {
	q := r.query.Select("loadModuleSourceFromID")
	q = q.Arg("id", id)

	return &ModuleSource{
		query: q,
	}
}

// Load a ObjectTypeDef from its ID.
func (r *Client) LoadObjectTypeDefFromID(id ObjectTypeDefID) *ObjectTypeDef {
	q := r.query.Select("loadObjectTypeDefFromID")
	q = q.Arg("id", id)

	return &ObjectTypeDef{
		query: q,
	}
}

// Load a Port from its ID.
func (r *Client) LoadPortFromID(id PortID) *Port {
	q := r.query.Select("loadPortFromID")
	q = q.Arg("id", id)

	return &Port{
		query: q,
	}
}

// Load a SDKConfig from its ID.
func (r *Client) LoadSDKConfigFromID(id SDKConfigID) *SDKConfig {
	q := r.query.Select("loadSDKConfigFromID")
	q = q.Arg("id", id)

	return &SDKConfig{
		query: q,
	}
}

// Load a ScalarTypeDef from its ID.
func (r *Client) LoadScalarTypeDefFromID(id ScalarTypeDefID) *ScalarTypeDef {
	q := r.query.Select("loadScalarTypeDefFromID")
	q = q.Arg("id", id)

	return &ScalarTypeDef{
		query: q,
	}
}

// Load a Secret from its ID.
func (r *Client) LoadSecretFromID(id SecretID) *Secret {
	q := r.query.Select("loadSecretFromID")
	q = q.Arg("id", id)

	return &Secret{
		query: q,
	}
}

// Load a Service from its ID.
func (r *Client) LoadServiceFromID(id ServiceID) *Service {
	q := r.query.Select("loadServiceFromID")
	q = q.Arg("id", id)

	return &Service{
		query: q,
	}
}

// Load a Socket from its ID.
func (r *Client) LoadSocketFromID(id SocketID) *Socket {
	q := r.query.Select("loadSocketFromID")
	q = q.Arg("id", id)

	return &Socket{
		query: q,
	}
}

// Load a SourceMap from its ID.
func (r *Client) LoadSourceMapFromID(id SourceMapID) *SourceMap {
	q := r.query.Select("loadSourceMapFromID")
	q = q.Arg("id", id)

	return &SourceMap{
		query: q,
	}
}

// Load a Terminal from its ID.
func (r *Client) LoadTerminalFromID(id TerminalID) *Terminal {
	q := r.query.Select("loadTerminalFromID")
	q = q.Arg("id", id)

	return &Terminal{
		query: q,
	}
}

// Load a TypeDef from its ID.
func (r *Client) LoadTypeDefFromID(id TypeDefID) *TypeDef {
	q := r.query.Select("loadTypeDefFromID")
	q = q.Arg("id", id)

	return &TypeDef{
		query: q,
	}
}

// Create a new module.
func (r *Client) Module() *Module {
	q := r.query.Select("module")

	return &Module{
		query: q,
	}
}

// ModuleSourceOpts contains options for Client.ModuleSource
type ModuleSourceOpts struct {
	// The pinned version of the module source
	RefPin string
	// If true, do not attempt to find dagger.json in a parent directory of the provided path. Only relevant for local module sources.
	DisableFindUp bool
	// If true, do not error out if the provided ref string is a local path and does not exist yet. Useful when initializing new modules in directories that don't exist yet.
	AllowNotExists bool
	// If set, error out if the ref string is not of the provided requireKind.
	RequireKind ModuleSourceKind
}

// Create a new module source instance from a source ref string
func (r *Client) ModuleSource(refString string, opts ...ModuleSourceOpts) *ModuleSource {
	q := r.query.Select("moduleSource")
	for i := len(opts) - 1; i >= 0; i-- {
		// `refPin` optional argument
		if !querybuilder.IsZeroValue(opts[i].RefPin) {
			q = q.Arg("refPin", opts[i].RefPin)
		}
		// `disableFindUp` optional argument
		if !querybuilder.IsZeroValue(opts[i].DisableFindUp) {
			q = q.Arg("disableFindUp", opts[i].DisableFindUp)
		}
		// `allowNotExists` optional argument
		if !querybuilder.IsZeroValue(opts[i].AllowNotExists) {
			q = q.Arg("allowNotExists", opts[i].AllowNotExists)
		}
		// `requireKind` optional argument
		if !querybuilder.IsZeroValue(opts[i].RequireKind) {
			q = q.Arg("requireKind", opts[i].RequireKind)
		}
	}
	q = q.Arg("refString", refString)

	return &ModuleSource{
		query: q,
	}
}

// SecretOpts contains options for Client.Secret
type SecretOpts struct {
	// If set, the given string will be used as the cache key for this secret. This means that any secrets with the same cache key will be considered equivalent in terms of cache lookups, even if they have different URIs or plaintext values.
	//
	// For example, two secrets with the same cache key provided as secret env vars to other wise equivalent containers will result in the container withExecs hitting the cache for each other.
	//
	// If not set, the cache key for the secret will be derived from its plaintext value as looked up when the secret is constructed.
	CacheKey string
}

// Creates a new secret.
func (r *Client) Secret(uri string, opts ...SecretOpts) *Secret {
	q := r.query.Select("secret")
	for i := len(opts) - 1; i >= 0; i-- {
		// `cacheKey` optional argument
		if !querybuilder.IsZeroValue(opts[i].CacheKey) {
			q = q.Arg("cacheKey", opts[i].CacheKey)
		}
	}
	q = q.Arg("uri", uri)

	return &Secret{
		query: q,
	}
}

// Sets a secret given a user defined name to its plaintext and returns the secret.
//
// The plaintext value is limited to a size of 128000 bytes.
func (r *Client) SetSecret(name string, plaintext string) *Secret {
	q := r.query.Select("setSecret")
	q = q.Arg("name", name)
	q = q.Arg("plaintext", plaintext)

	return &Secret{
		query: q,
	}
}

// Creates source map metadata.
func (r *Client) SourceMap(filename string, line int, column int) *SourceMap {
	q := r.query.Select("sourceMap")
	q = q.Arg("filename", filename)
	q = q.Arg("line", line)
	q = q.Arg("column", column)

	return &SourceMap{
		query: q,
	}
}

// Create a new TypeDef.
func (r *Client) TypeDef() *TypeDef {
	q := r.query.Select("typeDef")

	return &TypeDef{
		query: q,
	}
}

// Get the current Dagger Engine version.
func (r *Client) Version(ctx context.Context) (string, error) {
	q := r.query.Select("version")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The SDK config of the module.
type SDKConfig struct {
	query *querybuilder.Selection

	id     *SDKConfigID
	source *string
}

func (r *SDKConfig) WithGraphQLQuery(q *querybuilder.Selection) *SDKConfig {
	return &SDKConfig{
		query: q,
	}
}

// A unique identifier for this SDKConfig.
func (r *SDKConfig) ID(ctx context.Context) (SDKConfigID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response SDKConfigID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *SDKConfig) XXX_GraphQLType() string {
	return "SDKConfig"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *SDKConfig) XXX_GraphQLIDType() string {
	return "SDKConfigID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *SDKConfig) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *SDKConfig) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *SDKConfig) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadSDKConfigFromID(SDKConfigID(id))
	return nil
}

// Source of the SDK. Either a name of a builtin SDK or a module source ref string pointing to the SDK's implementation.
func (r *SDKConfig) Source(ctx context.Context) (string, error) {
	if r.source != nil {
		return *r.source, nil
	}
	q := r.query.Select("source")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A definition of a custom scalar defined in a Module.
type ScalarTypeDef struct {
	query *querybuilder.Selection

	description      *string
	id               *ScalarTypeDefID
	name             *string
	sourceModuleName *string
}

func (r *ScalarTypeDef) WithGraphQLQuery(q *querybuilder.Selection) *ScalarTypeDef {
	return &ScalarTypeDef{
		query: q,
	}
}

// A doc string for the scalar, if any.
func (r *ScalarTypeDef) Description(ctx context.Context) (string, error) {
	if r.description != nil {
		return *r.description, nil
	}
	q := r.query.Select("description")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this ScalarTypeDef.
func (r *ScalarTypeDef) ID(ctx context.Context) (ScalarTypeDefID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response ScalarTypeDefID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *ScalarTypeDef) XXX_GraphQLType() string {
	return "ScalarTypeDef"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *ScalarTypeDef) XXX_GraphQLIDType() string {
	return "ScalarTypeDefID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *ScalarTypeDef) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *ScalarTypeDef) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *ScalarTypeDef) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadScalarTypeDefFromID(ScalarTypeDefID(id))
	return nil
}

// The name of the scalar.
func (r *ScalarTypeDef) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// If this ScalarTypeDef is associated with a Module, the name of the module. Unset otherwise.
func (r *ScalarTypeDef) SourceModuleName(ctx context.Context) (string, error) {
	if r.sourceModuleName != nil {
		return *r.sourceModuleName, nil
	}
	q := r.query.Select("sourceModuleName")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A reference to a secret value, which can be handled more safely than the value itself.
type Secret struct {
	query *querybuilder.Selection

	id        *SecretID
	name      *string
	plaintext *string
	uri       *string
}

func (r *Secret) WithGraphQLQuery(q *querybuilder.Selection) *Secret {
	return &Secret{
		query: q,
	}
}

// A unique identifier for this Secret.
func (r *Secret) ID(ctx context.Context) (SecretID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response SecretID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *Secret) XXX_GraphQLType() string {
	return "Secret"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *Secret) XXX_GraphQLIDType() string {
	return "SecretID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *Secret) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *Secret) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *Secret) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadSecretFromID(SecretID(id))
	return nil
}

// The name of this secret.
func (r *Secret) Name(ctx context.Context) (string, error) {
	if r.name != nil {
		return *r.name, nil
	}
	q := r.query.Select("name")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The value of this secret.
func (r *Secret) Plaintext(ctx context.Context) (string, error) {
	if r.plaintext != nil {
		return *r.plaintext, nil
	}
	q := r.query.Select("plaintext")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The URI of this secret.
func (r *Secret) URI(ctx context.Context) (string, error) {
	if r.uri != nil {
		return *r.uri, nil
	}
	q := r.query.Select("uri")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A content-addressed service providing TCP connectivity.
type Service struct {
	query *querybuilder.Selection

	endpoint *string
	hostname *string
	id       *ServiceID
	start    *ServiceID
	stop     *ServiceID
	up       *Void
}
type WithServiceFunc func(r *Service) *Service

// With calls the provided function with current Service.
//
// This is useful for reusability and readability by not breaking the calling chain.
func (r *Service) With(f WithServiceFunc) *Service {
	return f(r)
}

func (r *Service) WithGraphQLQuery(q *querybuilder.Selection) *Service {
	return &Service{
		query: q,
	}
}

// ServiceEndpointOpts contains options for Service.Endpoint
type ServiceEndpointOpts struct {
	// The exposed port number for the endpoint
	Port int
	// Return a URL with the given scheme, eg. http for http://
	Scheme string
}

// Retrieves an endpoint that clients can use to reach this container.
//
// If no port is specified, the first exposed port is used. If none exist an error is returned.
//
// If a scheme is specified, a URL is returned. Otherwise, a host:port pair is returned.
func (r *Service) Endpoint(ctx context.Context, opts ...ServiceEndpointOpts) (string, error) {
	if r.endpoint != nil {
		return *r.endpoint, nil
	}
	q := r.query.Select("endpoint")
	for i := len(opts) - 1; i >= 0; i-- {
		// `port` optional argument
		if !querybuilder.IsZeroValue(opts[i].Port) {
			q = q.Arg("port", opts[i].Port)
		}
		// `scheme` optional argument
		if !querybuilder.IsZeroValue(opts[i].Scheme) {
			q = q.Arg("scheme", opts[i].Scheme)
		}
	}

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Retrieves a hostname which can be used by clients to reach this container.
func (r *Service) Hostname(ctx context.Context) (string, error) {
	if r.hostname != nil {
		return *r.hostname, nil
	}
	q := r.query.Select("hostname")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this Service.
func (r *Service) ID(ctx context.Context) (ServiceID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response ServiceID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *Service) XXX_GraphQLType() string {
	return "Service"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *Service) XXX_GraphQLIDType() string {
	return "ServiceID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *Service) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *Service) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *Service) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadServiceFromID(ServiceID(id))
	return nil
}

// Retrieves the list of ports provided by the service.
func (r *Service) Ports(ctx context.Context) ([]Port, error) {
	q := r.query.Select("ports")

	q = q.Select("id")

	type ports struct {
		Id PortID
	}

	convert := func(fields []ports) []Port {
		out := []Port{}

		for i := range fields {
			val := Port{id: &fields[i].Id}
			val.query = q.Root().Select("loadPortFromID").Arg("id", fields[i].Id)
			out = append(out, val)
		}

		return out
	}
	var response []ports

	q = q.Bind(&response)

	err := q.Execute(ctx)
	if err != nil {
		return nil, err
	}

	return convert(response), nil
}

// Start the service and wait for its health checks to succeed.
//
// Services bound to a Container do not need to be manually started.
func (r *Service) Start(ctx context.Context) (*Service, error) {
	q := r.query.Select("start")

	var id ServiceID
	if err := q.Bind(&id).Execute(ctx); err != nil {
		return nil, err
	}
	return &Service{
		query: q.Root().Select("loadServiceFromID").Arg("id", id),
	}, nil
}

// ServiceStopOpts contains options for Service.Stop
type ServiceStopOpts struct {
	// Immediately kill the service without waiting for a graceful exit
	Kill bool
}

// Stop the service.
func (r *Service) Stop(ctx context.Context, opts ...ServiceStopOpts) (*Service, error) {
	q := r.query.Select("stop")
	for i := len(opts) - 1; i >= 0; i-- {
		// `kill` optional argument
		if !querybuilder.IsZeroValue(opts[i].Kill) {
			q = q.Arg("kill", opts[i].Kill)
		}
	}

	var id ServiceID
	if err := q.Bind(&id).Execute(ctx); err != nil {
		return nil, err
	}
	return &Service{
		query: q.Root().Select("loadServiceFromID").Arg("id", id),
	}, nil
}

// ServiceUpOpts contains options for Service.Up
type ServiceUpOpts struct {
	// List of frontend/backend port mappings to forward.
	//
	// Frontend is the port accepting traffic on the host, backend is the service port.
	Ports []PortForward
	// Bind each tunnel port to a random port on the host.
	Random bool
}

// Creates a tunnel that forwards traffic from the caller's network to this service.
func (r *Service) Up(ctx context.Context, opts ...ServiceUpOpts) error {
	if r.up != nil {
		return nil
	}
	q := r.query.Select("up")
	for i := len(opts) - 1; i >= 0; i-- {
		// `ports` optional argument
		if !querybuilder.IsZeroValue(opts[i].Ports) {
			q = q.Arg("ports", opts[i].Ports)
		}
		// `random` optional argument
		if !querybuilder.IsZeroValue(opts[i].Random) {
			q = q.Arg("random", opts[i].Random)
		}
	}

	return q.Execute(ctx)
}

// Configures a hostname which can be used by clients within the session to reach this container.
func (r *Service) WithHostname(hostname string) *Service {
	q := r.query.Select("withHostname")
	q = q.Arg("hostname", hostname)

	return &Service{
		query: q,
	}
}

// A Unix or TCP/IP socket that can be mounted into a container.
type Socket struct {
	query *querybuilder.Selection

	id *SocketID
}

func (r *Socket) WithGraphQLQuery(q *querybuilder.Selection) *Socket {
	return &Socket{
		query: q,
	}
}

// A unique identifier for this Socket.
func (r *Socket) ID(ctx context.Context) (SocketID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response SocketID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *Socket) XXX_GraphQLType() string {
	return "Socket"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *Socket) XXX_GraphQLIDType() string {
	return "SocketID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *Socket) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *Socket) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *Socket) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadSocketFromID(SocketID(id))
	return nil
}

// Source location information.
type SourceMap struct {
	query *querybuilder.Selection

	column   *int
	filename *string
	id       *SourceMapID
	line     *int
	module   *string
}

func (r *SourceMap) WithGraphQLQuery(q *querybuilder.Selection) *SourceMap {
	return &SourceMap{
		query: q,
	}
}

// The column number within the line.
func (r *SourceMap) Column(ctx context.Context) (int, error) {
	if r.column != nil {
		return *r.column, nil
	}
	q := r.query.Select("column")

	var response int

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The filename from the module source.
func (r *SourceMap) Filename(ctx context.Context) (string, error) {
	if r.filename != nil {
		return *r.filename, nil
	}
	q := r.query.Select("filename")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// A unique identifier for this SourceMap.
func (r *SourceMap) ID(ctx context.Context) (SourceMapID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response SourceMapID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *SourceMap) XXX_GraphQLType() string {
	return "SourceMap"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *SourceMap) XXX_GraphQLIDType() string {
	return "SourceMapID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *SourceMap) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *SourceMap) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *SourceMap) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadSourceMapFromID(SourceMapID(id))
	return nil
}

// The line number within the filename.
func (r *SourceMap) Line(ctx context.Context) (int, error) {
	if r.line != nil {
		return *r.line, nil
	}
	q := r.query.Select("line")

	var response int

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// The module dependency this was declared in.
func (r *SourceMap) Module(ctx context.Context) (string, error) {
	if r.module != nil {
		return *r.module, nil
	}
	q := r.query.Select("module")

	var response string

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// An interactive terminal that clients can connect to.
type Terminal struct {
	query *querybuilder.Selection

	id   *TerminalID
	sync *TerminalID
}

func (r *Terminal) WithGraphQLQuery(q *querybuilder.Selection) *Terminal {
	return &Terminal{
		query: q,
	}
}

// A unique identifier for this Terminal.
func (r *Terminal) ID(ctx context.Context) (TerminalID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response TerminalID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *Terminal) XXX_GraphQLType() string {
	return "Terminal"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *Terminal) XXX_GraphQLIDType() string {
	return "TerminalID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *Terminal) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *Terminal) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *Terminal) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadTerminalFromID(TerminalID(id))
	return nil
}

// Forces evaluation of the pipeline in the engine.
//
// It doesn't run the default command if no exec has been set.
func (r *Terminal) Sync(ctx context.Context) (*Terminal, error) {
	q := r.query.Select("sync")

	var id TerminalID
	if err := q.Bind(&id).Execute(ctx); err != nil {
		return nil, err
	}
	return &Terminal{
		query: q.Root().Select("loadTerminalFromID").Arg("id", id),
	}, nil
}

// A definition of a parameter or return type in a Module.
type TypeDef struct {
	query *querybuilder.Selection

	id       *TypeDefID
	kind     *TypeDefKind
	optional *bool
}
type WithTypeDefFunc func(r *TypeDef) *TypeDef

// With calls the provided function with current TypeDef.
//
// This is useful for reusability and readability by not breaking the calling chain.
func (r *TypeDef) With(f WithTypeDefFunc) *TypeDef {
	return f(r)
}

func (r *TypeDef) WithGraphQLQuery(q *querybuilder.Selection) *TypeDef {
	return &TypeDef{
		query: q,
	}
}

// If kind is ENUM, the enum-specific type definition. If kind is not ENUM, this will be null.
func (r *TypeDef) AsEnum() *EnumTypeDef {
	q := r.query.Select("asEnum")

	return &EnumTypeDef{
		query: q,
	}
}

// If kind is INPUT, the input-specific type definition. If kind is not INPUT, this will be null.
func (r *TypeDef) AsInput() *InputTypeDef {
	q := r.query.Select("asInput")

	return &InputTypeDef{
		query: q,
	}
}

// If kind is INTERFACE, the interface-specific type definition. If kind is not INTERFACE, this will be null.
func (r *TypeDef) AsInterface() *InterfaceTypeDef {
	q := r.query.Select("asInterface")

	return &InterfaceTypeDef{
		query: q,
	}
}

// If kind is LIST, the list-specific type definition. If kind is not LIST, this will be null.
func (r *TypeDef) AsList() *ListTypeDef {
	q := r.query.Select("asList")

	return &ListTypeDef{
		query: q,
	}
}

// If kind is OBJECT, the object-specific type definition. If kind is not OBJECT, this will be null.
func (r *TypeDef) AsObject() *ObjectTypeDef {
	q := r.query.Select("asObject")

	return &ObjectTypeDef{
		query: q,
	}
}

// If kind is SCALAR, the scalar-specific type definition. If kind is not SCALAR, this will be null.
func (r *TypeDef) AsScalar() *ScalarTypeDef {
	q := r.query.Select("asScalar")

	return &ScalarTypeDef{
		query: q,
	}
}

// A unique identifier for this TypeDef.
func (r *TypeDef) ID(ctx context.Context) (TypeDefID, error) {
	if r.id != nil {
		return *r.id, nil
	}
	q := r.query.Select("id")

	var response TypeDefID

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// XXX_GraphQLType is an internal function. It returns the native GraphQL type name
func (r *TypeDef) XXX_GraphQLType() string {
	return "TypeDef"
}

// XXX_GraphQLIDType is an internal function. It returns the native GraphQL type name for the ID of this object
func (r *TypeDef) XXX_GraphQLIDType() string {
	return "TypeDefID"
}

// XXX_GraphQLID is an internal function. It returns the underlying type ID
func (r *TypeDef) XXX_GraphQLID(ctx context.Context) (string, error) {
	id, err := r.ID(ctx)
	if err != nil {
		return "", err
	}
	return string(id), nil
}

func (r *TypeDef) MarshalJSON() ([]byte, error) {
	id, err := r.ID(marshalCtx)
	if err != nil {
		return nil, err
	}
	return json.Marshal(id)
}
func (r *TypeDef) UnmarshalJSON(bs []byte) error {
	var id string
	err := json.Unmarshal(bs, &id)
	if err != nil {
		return err
	}
	*r = *dag.LoadTypeDefFromID(TypeDefID(id))
	return nil
}

// The kind of type this is (e.g. primitive, list, object).
func (r *TypeDef) Kind(ctx context.Context) (TypeDefKind, error) {
	if r.kind != nil {
		return *r.kind, nil
	}
	q := r.query.Select("kind")

	var response TypeDefKind

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Whether this type can be set to null. Defaults to false.
func (r *TypeDef) Optional(ctx context.Context) (bool, error) {
	if r.optional != nil {
		return *r.optional, nil
	}
	q := r.query.Select("optional")

	var response bool

	q = q.Bind(&response)
	return response, q.Execute(ctx)
}

// Adds a function for constructing a new instance of an Object TypeDef, failing if the type is not an object.
func (r *TypeDef) WithConstructor(function *Function) *TypeDef {
	assertNotNil("function", function)
	q := r.query.Select("withConstructor")
	q = q.Arg("function", function)

	return &TypeDef{
		query: q,
	}
}

// TypeDefWithEnumOpts contains options for TypeDef.WithEnum
type TypeDefWithEnumOpts struct {
	// A doc string for the enum, if any
	Description string
	// The source map for the enum definition.
	SourceMap *SourceMap
}

// Returns a TypeDef of kind Enum with the provided name.
//
// Note that an enum's values may be omitted if the intent is only to refer to an enum. This is how functions are able to return their own, or any other circular reference.
func (r *TypeDef) WithEnum(name string, opts ...TypeDefWithEnumOpts) *TypeDef {
	q := r.query.Select("withEnum")
	for i := len(opts) - 1; i >= 0; i-- {
		// `description` optional argument
		if !querybuilder.IsZeroValue(opts[i].Description) {
			q = q.Arg("description", opts[i].Description)
		}
		// `sourceMap` optional argument
		if !querybuilder.IsZeroValue(opts[i].SourceMap) {
			q = q.Arg("sourceMap", opts[i].SourceMap)
		}
	}
	q = q.Arg("name", name)

	return &TypeDef{
		query: q,
	}
}

// TypeDefWithEnumMemberOpts contains options for TypeDef.WithEnumMember
type TypeDefWithEnumMemberOpts struct {
	// The value of the member in the enum
	Value string
	// A doc string for the member, if any
	Description string
	// The source map for the enum member definition.
	SourceMap *SourceMap
}

// Adds a static value for an Enum TypeDef, failing if the type is not an enum.
func (r *TypeDef) WithEnumMember(name string, opts ...TypeDefWithEnumMemberOpts) *TypeDef {
	q := r.query.Select("withEnumMember")
	for i := len(opts) - 1; i >= 0; i-- {
		// `value` optional argument
		if !querybuilder.IsZeroValue(opts[i].Value) {
			q = q.Arg("value", opts[i].Value)
		}
		// `description` optional argument
		if !querybuilder.IsZeroValue(opts[i].Description) {
			q = q.Arg("description", opts[i].Description)
		}
		// `sourceMap` optional argument
		if !querybuilder.IsZeroValue(opts[i].SourceMap) {
			q = q.Arg("sourceMap", opts[i].SourceMap)
		}
	}
	q = q.Arg("name", name)

	return &TypeDef{
		query: q,
	}
}

// TypeDefWithEnumValueOpts contains options for TypeDef.WithEnumValue
type TypeDefWithEnumValueOpts struct {
	// A doc string for the value, if any
	Description string
	// The source map for the enum value definition.
	SourceMap *SourceMap
}

// Adds a static value for an Enum TypeDef, failing if the type is not an enum.
//
// Deprecated: Use WithEnumMember instead
func (r *TypeDef) WithEnumValue(value string, opts ...TypeDefWithEnumValueOpts) *TypeDef {
	q := r.query.Select("withEnumValue")
	for i := len(opts) - 1; i >= 0; i-- {
		// `description` optional argument
		if !querybuilder.IsZeroValue(opts[i].Description) {
			q = q.Arg("description", opts[i].Description)
		}
		// `sourceMap` optional argument
		if !querybuilder.IsZeroValue(opts[i].SourceMap) {
			q = q.Arg("sourceMap", opts[i].SourceMap)
		}
	}
	q = q.Arg("value", value)

	return &TypeDef{
		query: q,
	}
}

// TypeDefWithFieldOpts contains options for TypeDef.WithField
type TypeDefWithFieldOpts struct {
	// A doc string for the field, if any
	Description string
	// The source map for the field definition.
	SourceMap *SourceMap
}

// Adds a static field for an Object TypeDef, failing if the type is not an object.
func (r *TypeDef) WithField(name string, typeDef *TypeDef, opts ...TypeDefWithFieldOpts) *TypeDef {
	assertNotNil("typeDef", typeDef)
	q := r.query.Select("withField")
	for i := len(opts) - 1; i >= 0; i-- {
		// `description` optional argument
		if !querybuilder.IsZeroValue(opts[i].Description) {
			q = q.Arg("description", opts[i].Description)
		}
		// `sourceMap` optional argument
		if !querybuilder.IsZeroValue(opts[i].SourceMap) {
			q = q.Arg("sourceMap", opts[i].SourceMap)
		}
	}
	q = q.Arg("name", name)
	q = q.Arg("typeDef", typeDef)

	return &TypeDef{
		query: q,
	}
}

// Adds a function for an Object or Interface TypeDef, failing if the type is not one of those kinds.
func (r *TypeDef) WithFunction(function *Function) *TypeDef {
	assertNotNil("function", function)
	q := r.query.Select("withFunction")
	q = q.Arg("function", function)

	return &TypeDef{
		query: q,
	}
}

// TypeDefWithInterfaceOpts contains options for TypeDef.WithInterface
type TypeDefWithInterfaceOpts struct {
	Description string

	SourceMap *SourceMap
}

// Returns a TypeDef of kind Interface with the provided name.
func (r *TypeDef) WithInterface(name string, opts ...TypeDefWithInterfaceOpts) *TypeDef {
	q := r.query.Select("withInterface")
	for i := len(opts) - 1; i >= 0; i-- {
		// `description` optional argument
		if !querybuilder.IsZeroValue(opts[i].Description) {
			q = q.Arg("description", opts[i].Description)
		}
		// `sourceMap` optional argument
		if !querybuilder.IsZeroValue(opts[i].SourceMap) {
			q = q.Arg("sourceMap", opts[i].SourceMap)
		}
	}
	q = q.Arg("name", name)

	return &TypeDef{
		query: q,
	}
}

// Sets the kind of the type.
func (r *TypeDef) WithKind(kind TypeDefKind) *TypeDef {
	q := r.query.Select("withKind")
	q = q.Arg("kind", kind)

	return &TypeDef{
		query: q,
	}
}

// Returns a TypeDef of kind List with the provided type for its elements.
func (r *TypeDef) WithListOf(elementType *TypeDef) *TypeDef {
	assertNotNil("elementType", elementType)
	q := r.query.Select("withListOf")
	q = q.Arg("elementType", elementType)

	return &TypeDef{
		query: q,
	}
}

// TypeDefWithObjectOpts contains options for TypeDef.WithObject
type TypeDefWithObjectOpts struct {
	Description string

	SourceMap *SourceMap
}

// Returns a TypeDef of kind Object with the provided name.
//
// Note that an object's fields and functions may be omitted if the intent is only to refer to an object. This is how functions are able to return their own object, or any other circular reference.
func (r *TypeDef) WithObject(name string, opts ...TypeDefWithObjectOpts) *TypeDef {
	q := r.query.Select("withObject")
	for i := len(opts) - 1; i >= 0; i-- {
		// `description` optional argument
		if !querybuilder.IsZeroValue(opts[i].Description) {
			q = q.Arg("description", opts[i].Description)
		}
		// `sourceMap` optional argument
		if !querybuilder.IsZeroValue(opts[i].SourceMap) {
			q = q.Arg("sourceMap", opts[i].SourceMap)
		}
	}
	q = q.Arg("name", name)

	return &TypeDef{
		query: q,
	}
}

// Sets whether this type can be set to null.
func (r *TypeDef) WithOptional(optional bool) *TypeDef {
	q := r.query.Select("withOptional")
	q = q.Arg("optional", optional)

	return &TypeDef{
		query: q,
	}
}

// TypeDefWithScalarOpts contains options for TypeDef.WithScalar
type TypeDefWithScalarOpts struct {
	Description string
}

// Returns a TypeDef of kind Scalar with the provided name.
func (r *TypeDef) WithScalar(name string, opts ...TypeDefWithScalarOpts) *TypeDef {
	q := r.query.Select("withScalar")
	for i := len(opts) - 1; i >= 0; i-- {
		// `description` optional argument
		if !querybuilder.IsZeroValue(opts[i].Description) {
			q = q.Arg("description", opts[i].Description)
		}
	}
	q = q.Arg("name", name)

	return &TypeDef{
		query: q,
	}
}

// Sharing mode of the cache volume.
type CacheSharingMode string

func (CacheSharingMode) IsEnum() {}

func (v CacheSharingMode) Name() string {
	switch v {
	case CacheSharingModeShared:
		return "SHARED"
	case CacheSharingModePrivate:
		return "PRIVATE"
	case CacheSharingModeLocked:
		return "LOCKED"
	default:
		return ""
	}
}

func (v CacheSharingMode) Value() string {
	return string(v)
}

func (v *CacheSharingMode) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.Name())
}

func (v *CacheSharingMode) UnmarshalJSON(dt []byte) error {
	var s string
	if err := json.Unmarshal(dt, &s); err != nil {
		return err
	}
	switch s {
	case "LOCKED":
		*v = CacheSharingModeLocked
	case "PRIVATE":
		*v = CacheSharingModePrivate
	case "SHARED":
		*v = CacheSharingModeShared
	default:
		return fmt.Errorf("unknown enum value %q", s)
	}
	return nil
}

const (
	// Shares the cache volume amongst many build pipelines
	CacheSharingModeShared CacheSharingMode = "SHARED"

	// Keeps a cache volume for a single build pipeline
	CacheSharingModePrivate CacheSharingMode = "PRIVATE"

	// Shares the cache volume amongst many build pipelines, but will serialize the writes
	CacheSharingModeLocked CacheSharingMode = "LOCKED"
)

// Compression algorithm to use for image layers.
type ImageLayerCompression string

func (ImageLayerCompression) IsEnum() {}

func (v ImageLayerCompression) Name() string {
	switch v {
	case ImageLayerCompressionGzip:
		return "Gzip"
	case ImageLayerCompressionZstd:
		return "Zstd"
	case ImageLayerCompressionEstarGz:
		return "EStarGZ"
	case ImageLayerCompressionUncompressed:
		return "Uncompressed"
	default:
		return ""
	}
}

func (v ImageLayerCompression) Value() string {
	return string(v)
}

func (v *ImageLayerCompression) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.Name())
}

func (v *ImageLayerCompression) UnmarshalJSON(dt []byte) error {
	var s string
	if err := json.Unmarshal(dt, &s); err != nil {
		return err
	}
	switch s {
	case "EStarGZ":
		*v = ImageLayerCompressionEstarGz
	case "ESTARGZ":
		*v = ImageLayerCompressionEstargz
	case "Gzip":
		*v = ImageLayerCompressionGzip
	case "Uncompressed":
		*v = ImageLayerCompressionUncompressed
	case "Zstd":
		*v = ImageLayerCompressionZstd
	default:
		return fmt.Errorf("unknown enum value %q", s)
	}
	return nil
}

const (
	ImageLayerCompressionGzip ImageLayerCompression = "Gzip"

	ImageLayerCompressionZstd ImageLayerCompression = "Zstd"

	ImageLayerCompressionEstarGz ImageLayerCompression = "EStarGZ"
	ImageLayerCompressionEstargz ImageLayerCompression = ImageLayerCompressionEstarGz

	ImageLayerCompressionUncompressed ImageLayerCompression = "Uncompressed"
)

// Mediatypes to use in published or exported image metadata.
type ImageMediaTypes string

func (ImageMediaTypes) IsEnum() {}

func (v ImageMediaTypes) Name() string {
	switch v {
	case ImageMediaTypesOcimediaTypes:
		return "OCIMediaTypes"
	case ImageMediaTypesDockerMediaTypes:
		return "DockerMediaTypes"
	default:
		return ""
	}
}

func (v ImageMediaTypes) Value() string {
	return string(v)
}

func (v *ImageMediaTypes) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.Name())
}

func (v *ImageMediaTypes) UnmarshalJSON(dt []byte) error {
	var s string
	if err := json.Unmarshal(dt, &s); err != nil {
		return err
	}
	switch s {
	case "DOCKER":
		*v = ImageMediaTypesDocker
	case "DockerMediaTypes":
		*v = ImageMediaTypesDockerMediaTypes
	case "OCI":
		*v = ImageMediaTypesOci
	case "OCIMediaTypes":
		*v = ImageMediaTypesOcimediaTypes
	default:
		return fmt.Errorf("unknown enum value %q", s)
	}
	return nil
}

const (
	ImageMediaTypesOcimediaTypes ImageMediaTypes = "OCIMediaTypes"
	ImageMediaTypesOci           ImageMediaTypes = ImageMediaTypesOcimediaTypes

	ImageMediaTypesDockerMediaTypes ImageMediaTypes = "DockerMediaTypes"
	ImageMediaTypesDocker           ImageMediaTypes = ImageMediaTypesDockerMediaTypes
)

// The kind of module source.
type ModuleSourceKind string

func (ModuleSourceKind) IsEnum() {}

func (v ModuleSourceKind) Name() string {
	switch v {
	case ModuleSourceKindLocalSource:
		return "LOCAL_SOURCE"
	case ModuleSourceKindGitSource:
		return "GIT_SOURCE"
	case ModuleSourceKindDirSource:
		return "DIR_SOURCE"
	default:
		return ""
	}
}

func (v ModuleSourceKind) Value() string {
	return string(v)
}

func (v *ModuleSourceKind) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.Name())
}

func (v *ModuleSourceKind) UnmarshalJSON(dt []byte) error {
	var s string
	if err := json.Unmarshal(dt, &s); err != nil {
		return err
	}
	switch s {
	case "DIR":
		*v = ModuleSourceKindDir
	case "DIR_SOURCE":
		*v = ModuleSourceKindDirSource
	case "GIT":
		*v = ModuleSourceKindGit
	case "GIT_SOURCE":
		*v = ModuleSourceKindGitSource
	case "LOCAL":
		*v = ModuleSourceKindLocal
	case "LOCAL_SOURCE":
		*v = ModuleSourceKindLocalSource
	default:
		return fmt.Errorf("unknown enum value %q", s)
	}
	return nil
}

const (
	ModuleSourceKindLocalSource ModuleSourceKind = "LOCAL_SOURCE"
	ModuleSourceKindLocal       ModuleSourceKind = ModuleSourceKindLocalSource

	ModuleSourceKindGitSource ModuleSourceKind = "GIT_SOURCE"
	ModuleSourceKindGit       ModuleSourceKind = ModuleSourceKindGitSource

	ModuleSourceKindDirSource ModuleSourceKind = "DIR_SOURCE"
	ModuleSourceKindDir       ModuleSourceKind = ModuleSourceKindDirSource
)

// Transport layer network protocol associated to a port.
type NetworkProtocol string

func (NetworkProtocol) IsEnum() {}

func (v NetworkProtocol) Name() string {
	switch v {
	case NetworkProtocolTcp:
		return "TCP"
	case NetworkProtocolUdp:
		return "UDP"
	default:
		return ""
	}
}

func (v NetworkProtocol) Value() string {
	return string(v)
}

func (v *NetworkProtocol) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.Name())
}

func (v *NetworkProtocol) UnmarshalJSON(dt []byte) error {
	var s string
	if err := json.Unmarshal(dt, &s); err != nil {
		return err
	}
	switch s {
	case "TCP":
		*v = NetworkProtocolTcp
	case "UDP":
		*v = NetworkProtocolUdp
	default:
		return fmt.Errorf("unknown enum value %q", s)
	}
	return nil
}

const (
	NetworkProtocolTcp NetworkProtocol = "TCP"

	NetworkProtocolUdp NetworkProtocol = "UDP"
)

// Expected return type of an execution
type ReturnType string

func (ReturnType) IsEnum() {}

func (v ReturnType) Name() string {
	switch v {
	case ReturnTypeSuccess:
		return "SUCCESS"
	case ReturnTypeFailure:
		return "FAILURE"
	case ReturnTypeAny:
		return "ANY"
	default:
		return ""
	}
}

func (v ReturnType) Value() string {
	return string(v)
}

func (v *ReturnType) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.Name())
}

func (v *ReturnType) UnmarshalJSON(dt []byte) error {
	var s string
	if err := json.Unmarshal(dt, &s); err != nil {
		return err
	}
	switch s {
	case "ANY":
		*v = ReturnTypeAny
	case "FAILURE":
		*v = ReturnTypeFailure
	case "SUCCESS":
		*v = ReturnTypeSuccess
	default:
		return fmt.Errorf("unknown enum value %q", s)
	}
	return nil
}

const (
	// A successful execution (exit code 0)
	ReturnTypeSuccess ReturnType = "SUCCESS"

	// A failed execution (exit codes 1-127)
	ReturnTypeFailure ReturnType = "FAILURE"

	// Any execution (exit codes 0-127)
	ReturnTypeAny ReturnType = "ANY"
)

// Distinguishes the different kinds of TypeDefs.
type TypeDefKind string

func (TypeDefKind) IsEnum() {}

func (v TypeDefKind) Name() string {
	switch v {
	case TypeDefKindStringKind:
		return "STRING_KIND"
	case TypeDefKindIntegerKind:
		return "INTEGER_KIND"
	case TypeDefKindFloatKind:
		return "FLOAT_KIND"
	case TypeDefKindBooleanKind:
		return "BOOLEAN_KIND"
	case TypeDefKindScalarKind:
		return "SCALAR_KIND"
	case TypeDefKindListKind:
		return "LIST_KIND"
	case TypeDefKindObjectKind:
		return "OBJECT_KIND"
	case TypeDefKindInterfaceKind:
		return "INTERFACE_KIND"
	case TypeDefKindInputKind:
		return "INPUT_KIND"
	case TypeDefKindVoidKind:
		return "VOID_KIND"
	case TypeDefKindEnumKind:
		return "ENUM_KIND"
	default:
		return ""
	}
}

func (v TypeDefKind) Value() string {
	return string(v)
}

func (v *TypeDefKind) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.Name())
}

func (v *TypeDefKind) UnmarshalJSON(dt []byte) error {
	var s string
	if err := json.Unmarshal(dt, &s); err != nil {
		return err
	}
	switch s {
	case "BOOLEAN":
		*v = TypeDefKindBoolean
	case "BOOLEAN_KIND":
		*v = TypeDefKindBooleanKind
	case "ENUM":
		*v = TypeDefKindEnum
	case "ENUM_KIND":
		*v = TypeDefKindEnumKind
	case "FLOAT":
		*v = TypeDefKindFloat
	case "FLOAT_KIND":
		*v = TypeDefKindFloatKind
	case "INPUT":
		*v = TypeDefKindInput
	case "INPUT_KIND":
		*v = TypeDefKindInputKind
	case "INTEGER":
		*v = TypeDefKindInteger
	case "INTEGER_KIND":
		*v = TypeDefKindIntegerKind
	case "INTERFACE":
		*v = TypeDefKindInterface
	case "INTERFACE_KIND":
		*v = TypeDefKindInterfaceKind
	case "LIST":
		*v = TypeDefKindList
	case "LIST_KIND":
		*v = TypeDefKindListKind
	case "OBJECT":
		*v = TypeDefKindObject
	case "OBJECT_KIND":
		*v = TypeDefKindObjectKind
	case "SCALAR":
		*v = TypeDefKindScalar
	case "SCALAR_KIND":
		*v = TypeDefKindScalarKind
	case "STRING":
		*v = TypeDefKindString
	case "STRING_KIND":
		*v = TypeDefKindStringKind
	case "VOID":
		*v = TypeDefKindVoid
	case "VOID_KIND":
		*v = TypeDefKindVoidKind
	default:
		return fmt.Errorf("unknown enum value %q", s)
	}
	return nil
}

const (
	// A string value.
	TypeDefKindStringKind TypeDefKind = "STRING_KIND"
	// A string value.
	TypeDefKindString TypeDefKind = TypeDefKindStringKind

	// An integer value.
	TypeDefKindIntegerKind TypeDefKind = "INTEGER_KIND"
	// An integer value.
	TypeDefKindInteger TypeDefKind = TypeDefKindIntegerKind

	// A float value.
	TypeDefKindFloatKind TypeDefKind = "FLOAT_KIND"
	// A float value.
	TypeDefKindFloat TypeDefKind = TypeDefKindFloatKind

	// A boolean value.
	TypeDefKindBooleanKind TypeDefKind = "BOOLEAN_KIND"
	// A boolean value.
	TypeDefKindBoolean TypeDefKind = TypeDefKindBooleanKind

	// A scalar value of any basic kind.
	TypeDefKindScalarKind TypeDefKind = "SCALAR_KIND"
	// A scalar value of any basic kind.
	TypeDefKindScalar TypeDefKind = TypeDefKindScalarKind

	// Always paired with a ListTypeDef.
	//
	// A list of values all having the same type.
	TypeDefKindListKind TypeDefKind = "LIST_KIND"
	// Always paired with a ListTypeDef.
	//
	// A list of values all having the same type.
	TypeDefKindList TypeDefKind = TypeDefKindListKind

	// Always paired with an ObjectTypeDef.
	//
	// A named type defined in the GraphQL schema, with fields and functions.
	TypeDefKindObjectKind TypeDefKind = "OBJECT_KIND"
	// Always paired with an ObjectTypeDef.
	//
	// A named type defined in the GraphQL schema, with fields and functions.
	TypeDefKindObject TypeDefKind = TypeDefKindObjectKind

	// Always paired with an InterfaceTypeDef.
	//
	// A named type of functions that can be matched+implemented by other objects+interfaces.
	TypeDefKindInterfaceKind TypeDefKind = "INTERFACE_KIND"
	// Always paired with an InterfaceTypeDef.
	//
	// A named type of functions that can be matched+implemented by other objects+interfaces.
	TypeDefKindInterface TypeDefKind = TypeDefKindInterfaceKind

	// A graphql input type, used only when representing the core API via TypeDefs.
	TypeDefKindInputKind TypeDefKind = "INPUT_KIND"
	// A graphql input type, used only when representing the core API via TypeDefs.
	TypeDefKindInput TypeDefKind = TypeDefKindInputKind

	// A special kind used to signify that no value is returned.
	//
	// This is used for functions that have no return value. The outer TypeDef specifying this Kind is always Optional, as the Void is never actually represented.
	TypeDefKindVoidKind TypeDefKind = "VOID_KIND"
	// A special kind used to signify that no value is returned.
	//
	// This is used for functions that have no return value. The outer TypeDef specifying this Kind is always Optional, as the Void is never actually represented.
	TypeDefKindVoid TypeDefKind = TypeDefKindVoidKind

	// A GraphQL enum type and its values
	//
	// Always paired with an EnumTypeDef.
	TypeDefKindEnumKind TypeDefKind = "ENUM_KIND"
	// A GraphQL enum type and its values
	//
	// Always paired with an EnumTypeDef.
	TypeDefKindEnum TypeDefKind = TypeDefKindEnumKind
)

type Client struct {
	query  *querybuilder.Selection
	client graphql.Client
}

var dag *Client

func init() {
	gqlClient, q := getClientParams()
	dag = &Client{
		query:  q.Client(gqlClient),
		client: gqlClient,
	}
}

func Connect() *Client {
	return dag
}

// GraphQLClient returns the underlying graphql.Client
func (c *Client) GraphQLClient() graphql.Client {
	return c.client
}

func getClientParams() (graphql.Client, *querybuilder.Selection) {
	portStr, ok := os.LookupEnv("DAGGER_SESSION_PORT")
	if !ok {
		panic("DAGGER_SESSION_PORT is not set")
	}
	port, err := strconv.Atoi(portStr)
	if err != nil {
		panic(fmt.Errorf("DAGGER_SESSION_PORT %q is invalid: %w", portStr, err))
	}

	sessionToken := os.Getenv("DAGGER_SESSION_TOKEN")
	if sessionToken == "" {
		panic("DAGGER_SESSION_TOKEN is not set")
	}

	host := fmt.Sprintf("127.0.0.1:%d", port)

	dialTransport := &http.Transport{
		DialContext: func(_ context.Context, _, _ string) (net.Conn, error) {
			return net.Dial("tcp", host)
		},
	}
	httpClient := &http.Client{
		Transport: roundTripperFunc(func(r *http.Request) (*http.Response, error) {
			r.SetBasicAuth(sessionToken, "")

			// detect $TRACEPARENT set by 'dagger run'
			r = r.WithContext(fallbackSpanContext(r.Context()))

			// propagate span context via headers (i.e. for Dagger-in-Dagger)
			telemetry.Propagator.Inject(r.Context(), propagation.HeaderCarrier(r.Header))

			return dialTransport.RoundTrip(r)
		}),
	}
	gqlClient := errorWrappedClient{graphql.NewClient(fmt.Sprintf("http://%s/query", host), httpClient)}

	return gqlClient, querybuilder.Query()
}

func fallbackSpanContext(ctx context.Context) context.Context {
	if trace.SpanContextFromContext(ctx).IsValid() {
		return ctx
	}
	return telemetry.Propagator.Extract(ctx, telemetry.NewEnvCarrier(true))
}

// TODO: pollutes namespace, move to non internal package in dagger.io/dagger
type roundTripperFunc func(*http.Request) (*http.Response, error)

func (fn roundTripperFunc) RoundTrip(req *http.Request) (*http.Response, error) {
	return fn(req)
}

type errorWrappedClient struct {
	graphql.Client
}

func (c errorWrappedClient) MakeRequest(ctx context.Context, req *graphql.Request, resp *graphql.Response) error {
	err := c.Client.MakeRequest(ctx, req, resp)
	if err != nil {
		if e := getCustomError(err); e != nil {
			return e
		}
		return err
	}
	return nil
}
