// Copyright (c) Tailscale Inc & AUTHORS
// SPDX-License-Identifier: BSD-3-Clause

// Code generated by tailscale.com/cmd/cloner; DO NOT EDIT.

package filter

import (
	"net/netip"

	"tailscale.com/types/ipproto"
)

// Clone makes a deep copy of Match.
// The result aliases no memory with the original.
func (src *Match) Clone() *Match {
	if src == nil {
		return nil
	}
	dst := new(Match)
	*dst = *src
	dst.IPProto = append(src.IPProto[:0:0], src.IPProto...)
	dst.Srcs = append(src.Srcs[:0:0], src.Srcs...)
	dst.Dsts = append(src.Dsts[:0:0], src.Dsts...)
	dst.Caps = append(src.Caps[:0:0], src.Caps...)
	return dst
}

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _MatchCloneNeedsRegeneration = Match(struct {
	IPProto []ipproto.Proto
	Srcs    []netip.Prefix
	Dsts    []NetPortRange
	Caps    []CapMatch
}{})
