// Copyright (c) 2020 Tailscale Inc & AUTHORS All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated by the following command; DO NOT EDIT.
//   tailscale.com/cmd/cloner -type Match

package filter

import (
	"inet.af/netaddr"
	"tailscale.com/types/ipproto"
)

// Clone makes a deep copy of Match.
// The result aliases no memory with the original.
func (src *Match) Clone() *Match {
	if src == nil {
		return nil
	}
	dst := new(Match)
	*dst = *src
	dst.IPProto = append(src.IPProto[:0:0], src.IPProto...)
	dst.Dsts = append(src.Dsts[:0:0], src.Dsts...)
	dst.Srcs = append(src.Srcs[:0:0], src.Srcs...)
	return dst
}

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _MatchCloneNeedsRegeneration = Match(struct {
	IPProto []ipproto.Proto
	Dsts    []NetPortRange
	Srcs    []netaddr.IPPrefix
}{})
