// Code generated by github.com/abhimanyu003/sttr/cmd/generate.go. DO NOT EDIT

package cmd

import (
	"fmt"
	"io"
	"os"

	"github.com/abhimanyu003/sttr/processors"
	"github.com/spf13/cobra"
)

var removeNewlines_flag_s string

func init() {
	removeNewlinesCmd.Flags().StringVarP(&removeNewlines_flag_s, "separator", "s", "", "Separator to split multiple lines")
	rootCmd.AddCommand(removeNewlinesCmd)
}

var removeNewlinesCmd = &cobra.Command{
	Use:     "remove-newlines",
	Short:   "Remove all new lines",
	Aliases: []string{"remove-new-lines", "trim-newlines", "trim-new-lines"},
	Args:    cobra.MaximumNArgs(1),
	RunE: func(cmd *cobra.Command, args []string) error {
		var err error
		var in []byte
		var out string

		if len(args) == 0 {
			in, err = io.ReadAll(cmd.InOrStdin())
			if err != nil {
				return err
			}
		} else {
			if fi, err := os.Stat(args[0]); err == nil && !fi.IsDir() {
				d, err := os.ReadFile(args[0])
				if err != nil {
					return err
				}
				in = d
			} else {
				in = []byte(args[0])
			}
		}

		flags := make([]processors.Flag, 0)
		p := processors.RemoveNewLines{}
		flags = append(flags, processors.Flag{Short: "s", Value: removeNewlines_flag_s})

		out, err = p.Transform(in, flags...)
		if err != nil {
			return err
		}

		_, err = fmt.Fprint(os.Stdout, out)
		return err
	},
}
