package resource

import (
	"errors"

	"github.com/spf13/cobra"

	"github.com/stripe/stripe-cli/pkg/config"
)

// AddOrdersSubCmds adds custom subcommands to the `orders` command created
// automatically as a resource command.
func AddOrdersSubCmds(rootCmd *cobra.Command, cfg *config.Config) error {
	found := false

	for _, cmd := range rootCmd.Commands() {
		if cmd.Use == "orders" {
			found = true

			// Remove the autogenerated `create` and `update` command(s).
			commands := cmd.Commands()
			for _, c := range commands {
				if c.Use == "create" {
					cmd.RemoveCommand(c)
				} else if c.Use == "update" {
					cmd.RemoveCommand(c)
				}
			}

			NewOrdersCreateCmd(cmd, cfg)
			NewOrdersUpdateCmd(cmd, cfg)

			break
		}
	}

	if !found {
		return errors.New("Could not find orders command")
	}

	return nil
}
