package constants

const PostgresqlConfContent = `# -----------------------------
# PostgreSQL configuration file
# -----------------------------
#
# DO NOT EDIT THIS FILE
# it will be overwritten on server start
#
#------------------------------------------------------------------------------
# STEAMPIPE CONFIG ADDITIONS
#------------------------------------------------------------------------------

include = 'steampipe.conf'

# settings in this directory will override any steampipe provided values from the
# config file above

include_dir = 'postgresql.conf.d'    # includes files ending in .conf inside this dir
`

const SteampipeConfContent = `
# Custom settings for Steampipe
#
# DO NOT EDIT THIS FILE
# it will be overwritten on server start
#
# Modification or additions to postgres config should be placed in the
# postgresql.conf.d folder with a name alphabetically following this
# file - for example 01-custom-settings.conf
#
# see documentation on this behavior in the postgresql docs:
# https://www.postgresql.org/docs/11/config-setting.html#CONFIG-INCLUDES


bgwriter_lru_maxpages=0
effective_cache_size=64kB
fsync=off
full_page_writes=off
maintenance_work_mem=1024kB
password_encryption=scram-sha-256
random_page_cost=0.01
seq_page_cost=0.01

# If the shared buffers are too small then large tables in memory can create
# "no unpinned buffers available" errors.
#
# In that case, set shared_buffers in an overriding config file
# shared_buffers=128kB

# If synchronous_commit=off then the setup process can fail because the
# installation of the foreign server is not committed before the DB shutsdown.
# Steampipe does very few commits in general, so leaving this on will have
# very little impact on performance.
#
# In that case, set synchronous_commit in an overriding config file
# synchronous_commit=off

temp_buffers=800kB
timezone=UTC
track_activities=off
track_counts = on
wal_buffers=32kB
work_mem=64kB
jit=off
max_locks_per_transaction = 2048 

# postgres log collection
log_connections=on
log_disconnections=on
log_min_duration_statement=1000
log_destination=stderr
log_statement=none
log_min_error_statement=error
logging_collector=on
log_filename='database-%Y-%m-%d.log'
log_timezone=UTC


#------------------------------------------------------------------------------
# AUTOVACUUM PARAMETERS
#------------------------------------------------------------------------------

autovacuum = on                             # Enable autovacuum subprocess

# all params left as default: 
#autovacuum_analyze_scale_factor = 0.1      # fraction of table size before analyze
#autovacuum_analyze_threshold = 50          # min number of row updates before analyze
#autovacuum_freeze_max_age = 200000000      # maximum XID age before forced vacuum
#autovacuum_max_workers = 3                 # max number of autovacuum subprocesses
#autovacuum_multixact_freeze_max_age = 400000000
                                            # maximum multixact age
                                            # before forced vacuum
#autovacuum_naptime = 1min                  # time between autovacuum runs
#autovacuum_vacuum_cost_delay = 2ms         # default vacuum cost delay for
                                            # autovacuum, in milliseconds;
                                            # -1 means use vacuum_cost_delay
#autovacuum_vacuum_cost_limit = -1          # default vacuum cost limit for
                                            # autovacuum, -1 means use
                                            # vacuum_cost_limit
#autovacuum_vacuum_scale_factor = 0.2       # fraction of table size before vacuum
#autovacuum_vacuum_threshold = 50           # min number of row updates before vacuum
#autovacuum_work_mem = -1                   # qthe maximum memory to be used by each autovacuum worker process.        
#log_autovacuum_min_duration = -1           # -1 disables, 0 logs all actions and
                                            # their durations, > 0 logs only
                                            # actions running at least this number
                                            # of milliseconds. 

`
