<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw ipns`
IPFS Naming service API
  
- [A name is a hash of the public key within the IPNS (InterPlanetary Name System)](#a-name-is-a-hash-of-the-public-key-within-the-ipns-(interplanetary-name-system))
  - [Create a new name](#create-a-new-name)
  - [Delete an existing name](#delete-an-existing-name)
  - [Export your private key](#export-your-private-key)
  - [Get information about a name](#get-information-about-a-name)
  - [Import your private key](#import-your-private-key)
  - [List all names by a Project ID](#list-all-names-by-a-project-id)
  - [Update name information](#update-name-information)

  
## A name is a hash of the public key within the IPNS (InterPlanetary Name System)

This is the PKI namespace, where the private key is used to publish (sign) a record.


### Create a new name

You can use the `ipns key` command to list and generate more names and their respective keys.

**Usage:**

```
scw ipns name create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name |  | Name for your records |
| value |  | Value you want to associate with your records, CID or IPNS key |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete an existing name

Delete a name by its ID.

**Usage:**

```
scw ipns name delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name-id | Required | Name ID you wish to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Export your private key

Export a private key by its ID.

**Usage:**

```
scw ipns name export-key [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name-id | Required | Name ID whose keys you want to export |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get information about a name

Retrieve information about a specific name.

**Usage:**

```
scw ipns name get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name-id | Required | Name ID whose information you want to retrieve |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Import your private key

Import a private key.

**Usage:**

```
scw ipns name import-key [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name |  | Name for your records |
| private-key | Required | Base64 private key |
| value |  | Value you want to associate with your records, CID or IPNS key |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all names by a Project ID

Retrieve information about all names from a Project ID.

**Usage:**

```
scw ipns name list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID |
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort the order of the returned names |
| organization-id |  | Organization ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update name information

Update name information (CID, tag, name...).

**Usage:**

```
scw ipns name update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name-id | Required | Name ID you wish to update |
| name |  | New name you want to associate with your record |
| tags.{index} |  | New tags you want to associate with your record |
| value |  | Value you want to associate with your records, CID or IPNS key |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



