<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw iot`
IoT Hub API.
  
- [IoT Device commands](#iot-device-commands)
  - [Add a device](#add-a-device)
  - [Remove a device](#remove-a-device)
  - [Disable a device](#disable-a-device)
  - [Enable a device](#enable-a-device)
  - [Get a device](#get-a-device)
  - [Get a device's certificate](#get-a-device's-certificate)
  - [Get a device's metrics](#get-a-device's-metrics)
  - [List devices](#list-devices)
  - [Renew a device certificate](#renew-a-device-certificate)
  - [Set a custom certificate on a device](#set-a-custom-certificate-on-a-device)
  - [Update a device](#update-a-device)
- [IoT Hub commands](#iot-hub-commands)
  - [Create a hub](#create-a-hub)
  - [Delete a hub](#delete-a-hub)
  - [Disable a hub](#disable-a-hub)
  - [Enable a hub](#enable-a-hub)
  - [Get a hub](#get-a-hub)
  - [Get the certificate authority of a hub](#get-the-certificate-authority-of-a-hub)
  - [List hubs](#list-hubs)
  - [Set the certificate authority of a hub](#set-the-certificate-authority-of-a-hub)
  - [Update a hub](#update-a-hub)
- [IoT Network commands](#iot-network-commands)
  - [Create a new network](#create-a-new-network)
  - [Delete a Network](#delete-a-network)
  - [Retrieve a specific network](#retrieve-a-specific-network)
  - [List the networks](#list-the-networks)
- [IoT Route commands](#iot-route-commands)
  - [Create a route](#create-a-route)
  - [Delete a route](#delete-a-route)
  - [Get a route](#get-a-route)
  - [List routes](#list-routes)
  - [Update a route](#update-a-route)

  
## IoT Device commands

IoT Device commands.


### Add a device

Attach a device to a given Hub.

**Usage:**

```
scw iot device create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` | Device name |
| hub-id | Required | Hub ID of the device |
| allow-insecure |  | Defines whether to allow plain and server-authenticated SSL connections in addition to mutually-authenticated ones |
| allow-multiple-connections |  | Defines whether to allow multiple physical devices to connect with this device's credentials |
| message-filters.publish.policy | One of: `unknown`, `accept`, `reject` | How to use the topic list |
| message-filters.publish.topics.{index} |  | List of topics to accept or reject. It must be valid MQTT topics and up to 65535 characters |
| message-filters.subscribe.policy | One of: `unknown`, `accept`, `reject` | How to use the topic list |
| message-filters.subscribe.topics.{index} |  | List of topics to accept or reject. It must be valid MQTT topics and up to 65535 characters |
| description |  | Device description |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Remove a device

Remove a specific device from the specific Hub it is attached to.

**Usage:**

```
scw iot device delete <device-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| device-id | Required | Device ID |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Disable a device

Disable an existing device, specified by its device ID.

**Usage:**

```
scw iot device disable <device-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| device-id | Required | Device ID |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Enable a device

Enable a specific device, specified by its device ID.

**Usage:**

```
scw iot device enable <device-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| device-id | Required | Device ID |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Get a device

Retrieve information about an existing device, specified by its device ID. Its full details, including name, status and ID, are returned in the response object.

**Usage:**

```
scw iot device get <device-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| device-id | Required | Device ID |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Get a device's certificate

Get information for a particular PEM-encoded certificate, specified by the device ID. The response returns full details of the device, including its type of certificate.

**Usage:**

```
scw iot device get-certificate <device-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| device-id | Required | Device ID |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Get a device's metrics

Get the metrics of an existing device, specified by its device ID.

**Usage:**

```
scw iot device get-metrics <device-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| device-id | Required | Device ID |
| start-date | Required | Start date used to compute the best scale for the returned metrics |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### List devices

List all devices in the specified region. By default, returned devices are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw iot device list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `name_asc`, `name_desc`, `status_asc`, `status_desc`, `hub_id_asc`, `hub_id_desc`, `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc`, `allow_insecure_asc`, `allow_insecure_desc` | Ordering of requested devices |
| name |  | Name to filter for, only devices with this name will be returned |
| hub-id |  | Hub ID to filter for, only devices attached to this Hub will be returned |
| allow-insecure |  | Defines wheter to filter the allow_insecure flag |
| status | One of: `unknown`, `error`, `enabled`, `disabled` | Device status (enabled, disabled, etc.) |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



### Renew a device certificate

Renew the certificate of an existing device, specified by its device ID.

**Usage:**

```
scw iot device renew-certificate <device-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| device-id | Required | Device ID |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Set a custom certificate on a device

Switch the existing certificate of a given device with an EM-encoded custom certificate.

**Usage:**

```
scw iot device set-certificate <device-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| device-id | Required | Device ID |
| certificate-pem | Required | PEM-encoded custom certificate |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Update a device

Update the parameters of an existing device, specified by its device ID.

**Usage:**

```
scw iot device update <device-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| device-id | Required | Device ID |
| description |  | Description for the device |
| allow-insecure |  | Defines whether to allow plain and server-authenticated SSL connections in addition to mutually-authenticated ones |
| allow-multiple-connections |  | Defines whether to allow multiple physical devices to connect with this device's credentials |
| message-filters.publish.policy | One of: `unknown`, `accept`, `reject` | How to use the topic list |
| message-filters.publish.topics.{index} |  | List of topics to accept or reject. It must be valid MQTT topics and up to 65535 characters |
| message-filters.subscribe.policy | One of: `unknown`, `accept`, `reject` | How to use the topic list |
| message-filters.subscribe.topics.{index} |  | List of topics to accept or reject. It must be valid MQTT topics and up to 65535 characters |
| hub-id |  | Change Hub for this device, additional fees may apply, see IoT Hub pricing |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



## IoT Hub commands

IoT Hub commands.


### Create a hub

Create a new Hub in the targeted region, specifying its configuration including name and product plan.

**Usage:**

```
scw iot hub create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` | Hub name (up to 255 characters) |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| product-plan | Required<br />Default: `plan_shared`<br />One of: `plan_unknown`, `plan_shared`, `plan_dedicated`, `plan_ha` | Hub product plan |
| disable-events |  | Disable Hub events |
| events-topic-prefix |  | Topic prefix (default '$SCW/events') of Hub events |
| twins-graphite-config.push-uri |  |  |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Delete a hub

Delete an existing IoT Hub, specified by its Hub ID. Deleting a Hub is permanent, and cannot be undone.

**Usage:**

```
scw iot hub delete <hub-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hub-id | Required | Hub ID |
| delete-devices |  | Defines whether to force the deletion of devices added to this Hub or reject the operation |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Disable a hub

Disable an existing IoT Hub, specified by its Hub ID.

**Usage:**

```
scw iot hub disable <hub-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hub-id | Required | Hub ID |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Enable a hub

Enable an existing IoT Hub, specified by its Hub ID.

**Usage:**

```
scw iot hub enable <hub-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hub-id | Required | Hub ID |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Get a hub

Retrieve information about an existing IoT Hub, specified by its Hub ID. Its full details, including name, status and endpoint, are returned in the response object.

**Usage:**

```
scw iot hub get <hub-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hub-id | Required | Hub ID |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Get the certificate authority of a hub

Get information for a particular PEM-encoded certificate, specified by the Hub ID.

**Usage:**

```
scw iot hub get-ca [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hub-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### List hubs

List all Hubs in the specified zone. By default, returned Hubs are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw iot hub list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `name_asc`, `name_desc`, `status_asc`, `status_desc`, `product_plan_asc`, `product_plan_desc`, `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc` | Sort order of Hubs in the response |
| project-id |  | Only list Hubs of this Project ID |
| name |  | Hub name |
| organization-id |  | Only list Hubs of this Organization ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



### Set the certificate authority of a hub

Set a particular PEM-encoded certificate, specified by the Hub ID.

**Usage:**

```
scw iot hub set-ca <hub-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hub-id | Required | Hub ID |
| ca-cert-pem | Required | CA's PEM-encoded certificate |
| challenge-cert-pem | Required | Proof of possession of PEM-encoded certificate |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Update a hub

Update the parameters of an existing IoT Hub, specified by its Hub ID.

**Usage:**

```
scw iot hub update <hub-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hub-id | Required | ID of the Hub you want to update |
| name |  | Hub name (up to 255 characters) |
| product-plan | One of: `plan_unknown`, `plan_shared`, `plan_dedicated`, `plan_ha` | Hub product plan |
| disable-events |  | Disable Hub events |
| events-topic-prefix |  | Topic prefix of Hub events |
| enable-device-auto-provisioning |  | Enable device auto provisioning |
| twins-graphite-config.push-uri |  |  |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



## IoT Network commands

IoT Network commands.


### Create a new network

Create a new network for an existing hub.  Beside the default network, you can add networks for different data providers. Possible network types are Sigfox and REST.

**Usage:**

```
scw iot network create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` | Network name |
| type | Required<br />One of: `unknown`, `sigfox`, `rest` | Type of network to connect with |
| hub-id | Required | Hub ID to connect the Network to |
| topic-prefix | Required | Topic prefix for the Network |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Delete a Network

Delete an existing network, specified by its network ID. Deleting a network is permanent, and cannot be undone.

**Usage:**

```
scw iot network delete <network-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| network-id | Required | Network ID |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Retrieve a specific network

Retrieve an existing network, specified by its network ID.  The response returns full details of the network, including its type, the topic prefix and its endpoint.

**Usage:**

```
scw iot network get <network-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| network-id | Required | Network ID |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### List the networks

List the networks.

**Usage:**

```
scw iot network list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `name_asc`, `name_desc`, `type_asc`, `type_desc`, `created_at_asc`, `created_at_desc` | Ordering of requested routes |
| name |  | Network name to filter for |
| hub-id |  | Hub ID to filter for |
| topic-prefix |  | Topic prefix to filter for |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



## IoT Route commands

IoT Route commands.


### Create a route

Multiple kinds of routes can be created, such as:
- Database Route
  Create a route that will record subscribed MQTT messages into your database.
  <b>You need to manage the database by yourself</b>.
- REST Route.
  Create a route that will call a REST API on received subscribed MQTT messages.
- S3 Routes.
  Create a route that will put subscribed MQTT messages into an S3 bucket.
  You need to create the bucket yourself and grant write access.
  Granting can be done with s3cmd (`s3cmd setacl s3://<my-bucket> --acl-grant=write:555c69c3-87d0-4bf8-80f1-99a2f757d031:555c69c3-87d0-4bf8-80f1-99a2f757d031`).

**Usage:**

```
scw iot route create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Default: `<generated>` | Route name |
| hub-id |  | Hub ID of the route |
| topic |  | Topic the route subscribes to. It must be a valid MQTT topic and up to 65535 characters |
| s3-config.bucket-region |  |  |
| s3-config.bucket-name |  |  |
| s3-config.object-prefix |  |  |
| s3-config.strategy | One of: `unknown`, `per_topic`, `per_message` |  |
| db-config.host |  |  |
| db-config.port |  |  |
| db-config.dbname |  |  |
| db-config.username |  |  |
| db-config.password |  |  |
| db-config.query |  |  |
| db-config.engine | One of: `unknown`, `postgresql`, `mysql` |  |
| rest-config.verb | One of: `unknown`, `get`, `post`, `put`, `patch`, `delete` |  |
| rest-config.uri |  |  |
| rest-config.headers.{key} |  |  |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Delete a route

Delete an existing route, specified by its route ID. Deleting a route is permanent, and cannot be undone.

**Usage:**

```
scw iot route delete <route-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| route-id | Required | Route ID |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Get a route

Get information for a particular route, specified by the route ID. The response returns full details of the route, including its type, the topic it subscribes to and its configuration.

**Usage:**

```
scw iot route get <route-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| route-id | Required | Route ID |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### List routes

List all routes in the specified region. By default, returned routes are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw iot route list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `name_asc`, `name_desc`, `hub_id_asc`, `hub_id_desc`, `type_asc`, `type_desc`, `created_at_asc`, `created_at_desc` | Ordering of requested routes |
| hub-id |  | Hub ID to filter for |
| name |  | Route name to filter for |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



### Update a route

Update the parameters of an existing route, specified by its route ID.

**Usage:**

```
scw iot route update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| route-id | Required | Route id |
| name |  | Route name |
| topic |  | Topic the route subscribes to. It must be a valid MQTT topic and up to 65535 characters |
| s3-config.bucket-region |  |  |
| s3-config.bucket-name |  |  |
| s3-config.object-prefix |  |  |
| s3-config.strategy | One of: `unknown`, `per_topic`, `per_message` |  |
| db-config.host |  |  |
| db-config.port |  |  |
| db-config.dbname |  |  |
| db-config.username |  |  |
| db-config.password |  |  |
| db-config.query |  |  |
| db-config.engine | One of: `unknown`, `postgresql`, `mysql` |  |
| rest-config.verb | One of: `unknown`, `get`, `post`, `put`, `patch`, `delete` |  |
| rest-config.uri |  |  |
| rest-config.headers.{key} |  |  |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



