package control

import (
	"syscall"
)

func ReuseAddr() Func {
	return func(network, address string, conn syscall.RawConn) error {
		return Control(conn, func(fd uintptr) error {
			return syscall.SetsockoptInt(syscall.Handle(fd), syscall.SOL_SOCKET, syscall.SO_REUSEADDR, 1)
		})
	}
}
