// Code generated by ./internal/gen/main.go. DO NOT EDIT.

//go:generate go run ./internal/gen/main.go

package encoder

var testCasesSingle = []testCase{
	{ // 0
		mask: EncodeZero,
		in:   "␆2π\rｊ８␙aｗ␡k\x05\x19β\x00σ\x15τ７␗\x01R:␀τ␍β7７␊",
		out:  "␆2π\rｊ８␙aｗ␡k\x05\x19β␀σ\x15τ７␗\x01R:‛␀τ␍β7７␊",
	}, { // 1
		mask: EncodeSlash,
		in:   "＊␟VＪｇ␚Ｋ$/+\x00／φ␌/π>\x16ρRα/ζ␇＜VLν＞ｑ",
		out:  "＊␟VＪｇ␚Ｋ$／+␀‛／φ␌／π>\x16ρRα／ζ␇＜VLν＞ｑ",
	}, { // 2
		mask: EncodeSingleQuote,
		in:   "γ␇＇Ｐｎ\x06χ\x1eε␟[υ'］］ζM2ω␒␅$?ＡＮ＂^''\x02",
		out:  "γ␇‛＇Ｐｎ\x06χ\x1eε␟[υ＇］］ζM2ω␒␅$?ＡＮ＂^＇＇\x02",
	}, { // 3
		mask: EncodeBackQuote,
		in:   "\a␕θWfｃＲ␅(［｀|Ｖ６τη%＊\tmυ\x15␚\r＼βw｛`ρ",
		out:  "\a␕θWfｃＲ␅(［‛｀|Ｖ６τη%＊\tmυ\x15␚\r＼βw｛｀ρ",
	}, { // 4
		mask: EncodeLtGt,
		in:   "４␁>ｏ\x10\x1fＰι,␋Pυ\b＜?␍！９tπ＞<␞\x00(ης：oε",
		out:  "４␁＞ｏ\x10\x1fＰι,␋Pυ\b‛＜?␍！９tπ‛＞＜␞␀(ης：oε",
	}, { // 5
		mask: EncodeSquareBracket,
		in:   "␉␊*ενm\x1bρ[M+τ\v\x05\nνw＾］␄␔ｑ．ψＩ0Ｘ␎［]",
		out:  "␉␊*ενm\x1bρ［M+τ\v\x05\nνw＾‛］␄␔ｑ．ψＩ0Ｘ␎‛［］",
	}, { // 6
		mask: EncodeDollar,
		in:   "Rφ\x10'\r%ςY｜ψ＞ｌ%＄ｙｓｏ\x1f;$ς［ξ␟␚\x11#␗ι␃",
		out:  "Rφ\x10'\r%ςY｜ψ＞ｌ%‛＄ｙｓｏ\x1f;＄ς［ξ␟␚\x11#␗ι␃",
	}, { // 7
		mask: EncodeDoubleQuote,
		in:   "?\";Ｘτ*␍^εE＂π\x11＆＃＄／＆ψ␖ι～␌\x16~?\x14θ␆R",
		out:  "?＂;Ｘτ*␍^εE‛＂π\x11＆＃＄／＆ψ␖ι～␌\x16~?\x14θ␆R",
	}, { // 8
		mask: EncodeColon,
		in:   "ωQ＝λ␏γ␟：｀ε／#Ｒ:!%␀\x02:Ｙ*８#'π＞ν\x11␓=",
		out:  "ωQ＝λ␏γ␟‛：｀ε／#Ｒ：!%‛␀\x02：Ｙ*８#'π＞ν\x11␓=",
	}, { // 9
		mask: EncodeQuestion,
		in:   "χ＼ρ\x19\x19Ｅ\x01\x1bＣ␒\x13３sος＞７␜νk!π？␍o［?MＷ'",
		out:  "χ＼ρ\x19\x19Ｅ\x01\x1bＣ␒\x13３sος＞７␜νk!π‛？␍o［？MＷ'",
	}, { // 10
		mask: EncodeAsterisk,
		in:   ">\x0e\x1f～*␕`Ｑ＋δω＃R＇＊OζＩs␍*／/?％μτC␄φ",
		out:  ">\x0e\x1f～＊␕`Ｑ＋δω＃R＇‛＊OζＩs␍＊／/?％μτC␄φ",
	}, { // 11
		mask: EncodePipe,
		in:   "Q］Ｊａｌ｜Vz\x11␛％\x0e\n|％χκ][␅ι\x06＜␁ν?#βλＵ",
		out:  "Q］Ｊａｌ‛｜Vz\x11␛％\x0e\n｜％χκ][␅ι\x06＜␁ν?#βλＵ",
	}, { // 12
		mask: EncodeHash,
		in:   "W=\x03ｘξβ␓'mａε␍#＄'＃␄␙f\x19\x0e␟Yｈｚτ]δτｋ",
		out:  "W=\x03ｘξβ␓'mａε␍＃＄'‛＃␄␙f\x19\x0e␟Yｈｚτ]δτｋ",
	}, { // 13
		mask: EncodePercent,
		in:   "\n\x10␚␖Ｘ/␍ｋp＊λ[:\x17θｔg\a％ｋρ;%υο：Oξ␒␎",
		out:  "\n\x10␚␖Ｘ/␍ｋp＊λ[:\x17θｔg\a‛％ｋρ;％υο：Oξ␒␎",
	}, { // 14
		mask: EncodeBackSlash,
		in:   "\x02␒␍＞μ$φ\\\x03␟ｉδ\t\x1d＄ο＄χ\x03xI）\x0fyＧ＼！ςt９",
		out:  "\x02␒␍＞μ$φ＼\x03␟ｉδ\t\x1d＄ο＄χ\x03xI）\x0fyＧ‛＼！ςt９",
	}, { // 15
		mask: EncodeCrLf,
		in:   "λ２θNY:Ｈ␊\r］␂\x13ｂ\x15␎h\f␍@ε\r␆␋μQＰ\nξ␙φ",
		out:  "λ２θNY:Ｈ‛␊␍］␂\x13ｂ\x15␎h\f‛␍@ε␍␆␋μQＰ␊ξ␙φ",
	}, { // 16
		mask: EncodeDel,
		in:   "θ？␄＜μ7π\x1a＼␡2\"x\u007fο\x16ｚ%ο?␐ｗ＃␟ξa\tOＸ＇",
		out:  "θ？␄＜μ7π\x1a＼‛␡2\"x␡ο\x16ｚ%ο?␐ｗ＃␟ξa\tOＸ＇",
	}, { // 17
		mask: EncodeCtl,
		in:   "\x1f␝␚ν\b\x16＊\x05\x1b\x06\b␉\r\x02\aμ\x17␋␄/ω５␓δ\x0e\x1d␈IY\v␗\x14>３␔␊␍\t\a␕␁\x13\x18\x1e␞␎F␂\x03\x1a␙\x19χ！␌␑\x12␐␏␘␔\x11␅␌\x0f␖\x04\x1c\x10␜0␛\x01X␓\f\u007f␋␆␍\x15ｇ␇␟π＊]\n␃*␒？V",
		out:  "␟‛␝‛␚ν␈␖＊␅␛␆␈‛␉␍␂␇μ␗‛␋‛␄/ω５‛␓δ␎␝‛␈IY␋‛␗␔>３‛␔‛␊‛␍␉␇‛␕‛␁␓␘␞‛␞‛␎F‛␂␃␚‛␙␙χ！‛␌‛␑␒‛␐‛␏‛␘‛␔␑‛␅‛␌␏‛␖␄␜␐‛␜0‛␛␁X‛␓␌\u007f‛␋‛␆‛␍␕ｇ‛␇‛␟π＊]␊‛␃*‛␒？V",
	},
}

var testCasesSingleEdge = []testCase{
	{ // 0
		mask: EncodeLeftSpace,
		in:   " ",
		out:  "␠",
	}, { // 1
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ρ␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓ι",
		out:  "ρ␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓ι",
	}, { // 2
		mask: EncodeZero | EncodeLeftSpace,
		in:   " ␠]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓ι",
		out:  "␠␠]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓ι",
	}, { // 3
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␠␠]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓ι",
		out:  "‛␠␠]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓ι",
	}, { // 4
		mask: EncodeZero | EncodeLeftSpace,
		in:   " ␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␠ι",
		out:  "␠␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␠ι",
	}, { // 5
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␠␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␠ι",
		out:  "‛␠␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␠ι",
	}, { // 6
		mask: EncodeZero | EncodeLeftSpace,
		in:   " ␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓␠",
		out:  "␠␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓␠",
	}, { // 7
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␠␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓␠",
		out:  "‛␠␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓␠",
	}, { // 8
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ρ ]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓ι",
		out:  "ρ ]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓ι",
	}, { // 9
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ρ␠]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓ι",
		out:  "ρ␠]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓ι",
	}, { // 10
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ρ ]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␠ι",
		out:  "ρ ]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␠ι",
	}, { // 11
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ρ␠]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␠ι",
		out:  "ρ␠]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␠ι",
	}, { // 12
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ρ ]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓␠",
		out:  "ρ ]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓␠",
	}, { // 13
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ρ␠]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓␠",
		out:  "ρ␠]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓␠",
	}, { // 14
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ρ␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t ι",
		out:  "ρ␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t ι",
	}, { // 15
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ρ␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␠ι",
		out:  "ρ␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␠ι",
	}, { // 16
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ρ␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t ␠",
		out:  "ρ␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t ␠",
	}, { // 17
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ρ␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␠␠",
		out:  "ρ␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␠␠",
	}, { // 18
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ρ␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓ ",
		out:  "ρ␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓ ",
	}, { // 19
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ρ␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓␠",
		out:  "ρ␆]［␂\x1dＺ^；Ｊ ␘γ\nηtρ\n-D␆ηc３X\r␍\t␓␠",
	}, { // 20
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\x10ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ9",
		out:  "\x10ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ9",
	}, { // 21
		mask: EncodeSlash | EncodeLeftSpace,
		in:   " ␠[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ9",
		out:  "␠␠[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ9",
	}, { // 22
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "␠␠[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ9",
		out:  "‛␠␠[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ9",
	}, { // 23
		mask: EncodeSlash | EncodeLeftSpace,
		in:   " ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆␠9",
		out:  "␠ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆␠9",
	}, { // 24
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "␠ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆␠9",
		out:  "‛␠ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆␠9",
	}, { // 25
		mask: EncodeSlash | EncodeLeftSpace,
		in:   " ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ␠",
		out:  "␠ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ␠",
	}, { // 26
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "␠ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ␠",
		out:  "‛␠ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ␠",
	}, { // 27
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\x10 [＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ9",
		out:  "\x10 [＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ9",
	}, { // 28
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\x10␠[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ9",
		out:  "\x10␠[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ9",
	}, { // 29
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\x10 [＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆␠9",
		out:  "\x10 [＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆␠9",
	}, { // 30
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\x10␠[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆␠9",
		out:  "\x10␠[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆␠9",
	}, { // 31
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\x10 [＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ␠",
		out:  "\x10 [＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ␠",
	}, { // 32
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\x10␠[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ␠",
		out:  "\x10␠[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ␠",
	}, { // 33
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\x10ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆ 9",
		out:  "\x10ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆ 9",
	}, { // 34
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\x10ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆␠9",
		out:  "\x10ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆␠9",
	}, { // 35
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\x10ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆ ␠",
		out:  "\x10ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆ ␠",
	}, { // 36
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\x10ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆␠␠",
		out:  "\x10ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆␠␠",
	}, { // 37
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\x10ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ ",
		out:  "\x10ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ ",
	}, { // 38
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\x10ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ␠",
		out:  "\x10ψ[＂\x11ａ(\x10|␘ C＄４=␊␌％αs␂$ννρＤ\x19＆Ｄ␠",
	}, { // 39
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "Ｎ\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%9",
		out:  "Ｎ\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%9",
	}, { // 40
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   " ␠εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%9",
		out:  "␠␠εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%9",
	}, { // 41
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "␠␠εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%9",
		out:  "‛␠␠εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%9",
	}, { // 42
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   " \"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο␠9",
		out:  "␠\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο␠9",
	}, { // 43
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "␠\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο␠9",
		out:  "‛␠\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο␠9",
	}, { // 44
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   " \"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%␠",
		out:  "␠\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%␠",
	}, { // 45
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "␠\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%␠",
		out:  "‛␠\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%␠",
	}, { // 46
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "Ｎ εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%9",
		out:  "Ｎ εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%9",
	}, { // 47
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "Ｎ␠εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%9",
		out:  "Ｎ␠εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%9",
	}, { // 48
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "Ｎ εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο␠9",
		out:  "Ｎ εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο␠9",
	}, { // 49
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "Ｎ␠εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο␠9",
		out:  "Ｎ␠εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο␠9",
	}, { // 50
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "Ｎ εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%␠",
		out:  "Ｎ εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%␠",
	}, { // 51
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "Ｎ␠εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%␠",
		out:  "Ｎ␠εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%␠",
	}, { // 52
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "Ｎ\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο 9",
		out:  "Ｎ\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο 9",
	}, { // 53
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "Ｎ\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο␠9",
		out:  "Ｎ\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο␠9",
	}, { // 54
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "Ｎ\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο ␠",
		out:  "Ｎ\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο ␠",
	}, { // 55
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "Ｎ\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο␠␠",
		out:  "Ｎ\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο␠␠",
	}, { // 56
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "Ｎ\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο% ",
		out:  "Ｎ\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο% ",
	}, { // 57
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "Ｎ\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%␠",
		out:  "Ｎ\"εμ*＞τ␎nD λｈμ␍␚6S␅␍Ｑ/Cｌｚ␐\x14ο%␠",
	}, { // 58
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "\"\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r>",
		out:  "\"\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r>",
	}, { // 59
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   " ␠␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r>",
		out:  "␠␠␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r>",
	}, { // 60
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "␠␠␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r>",
		out:  "‛␠␠␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r>",
	}, { // 61
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   " \x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ␠>",
		out:  "␠\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ␠>",
	}, { // 62
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "␠\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ␠>",
		out:  "‛␠\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ␠>",
	}, { // 63
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   " \x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r␠",
		out:  "␠\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r␠",
	}, { // 64
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "␠\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r␠",
		out:  "‛␠\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r␠",
	}, { // 65
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "\" ␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r>",
		out:  "\" ␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r>",
	}, { // 66
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "\"␠␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r>",
		out:  "\"␠␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r>",
	}, { // 67
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "\" ␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ␠>",
		out:  "\" ␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ␠>",
	}, { // 68
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "\"␠␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ␠>",
		out:  "\"␠␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ␠>",
	}, { // 69
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "\" ␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r␠",
		out:  "\" ␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r␠",
	}, { // 70
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "\"␠␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r␠",
		out:  "\"␠␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r␠",
	}, { // 71
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "\"\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ >",
		out:  "\"\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ >",
	}, { // 72
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "\"\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ␠>",
		out:  "\"\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ␠>",
	}, { // 73
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "\"\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ ␠",
		out:  "\"\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ ␠",
	}, { // 74
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "\"\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ␠␠",
		out:  "\"\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ␠␠",
	}, { // 75
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "\"\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r ",
		out:  "\"\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r ",
	}, { // 76
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "\"\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r␠",
		out:  "\"\x19␐ｅ\x1b\x01o\rC＊ ␖ｓρW\x10M［πμ␍＄＇Ｕτ＂␂κ\r␠",
	}, { // 77
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␓␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"\x15",
		out:  "␓␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"\x15",
	}, { // 78
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   " ␠τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"\x15",
		out:  "␠␠τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"\x15",
	}, { // 79
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␠␠τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"\x15",
		out:  "‛␠␠τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"\x15",
	}, { // 80
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   " ␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7␠\x15",
		out:  "␠␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7␠\x15",
	}, { // 81
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␠␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7␠\x15",
		out:  "‛␠␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7␠\x15",
	}, { // 82
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   " ␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"␠",
		out:  "␠␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"␠",
	}, { // 83
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␠␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"␠",
		out:  "‛␠␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"␠",
	}, { // 84
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␓ τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"\x15",
		out:  "␓ τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"\x15",
	}, { // 85
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␓␠τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"\x15",
		out:  "␓␠τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"\x15",
	}, { // 86
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␓ τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7␠\x15",
		out:  "␓ τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7␠\x15",
	}, { // 87
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␓␠τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7␠\x15",
		out:  "␓␠τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7␠\x15",
	}, { // 88
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␓ τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"␠",
		out:  "␓ τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"␠",
	}, { // 89
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␓␠τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"␠",
		out:  "␓␠τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"␠",
	}, { // 90
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␓␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7 \x15",
		out:  "␓␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7 \x15",
	}, { // 91
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␓␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7␠\x15",
		out:  "␓␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7␠\x15",
	}, { // 92
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␓␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7 ␠",
		out:  "␓␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7 ␠",
	}, { // 93
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␓␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7␠␠",
		out:  "␓␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7␠␠",
	}, { // 94
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␓␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\" ",
		out:  "␓␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\" ",
	}, { // 95
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␓␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"␠",
		out:  "␓␝τOＥ4ι-␊| \x014ι\f６ｄ␂γν␋υ\x12ｔ＇］ｏ7\"␠",
	}, { // 96
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "\rκｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂd",
		out:  "\rκｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂd",
	}, { // 97
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   " ␠ｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂd",
		out:  "␠␠ｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂd",
	}, { // 98
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␠␠ｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂd",
		out:  "‛␠␠ｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂd",
	}, { // 99
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   " κｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛␠d",
		out:  "␠κｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛␠d",
	}, { // 100
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␠κｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛␠d",
		out:  "‛␠κｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛␠d",
	}, { // 101
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   " κｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂ␠",
		out:  "␠κｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂ␠",
	}, { // 102
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␠κｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂ␠",
		out:  "‛␠κｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂ␠",
	}, { // 103
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "\r ｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂd",
		out:  "\r ｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂd",
	}, { // 104
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "\r␠ｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂd",
		out:  "\r␠ｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂd",
	}, { // 105
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "\r ｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛␠d",
		out:  "\r ｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛␠d",
	}, { // 106
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "\r␠ｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛␠d",
		out:  "\r␠ｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛␠d",
	}, { // 107
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "\r ｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂ␠",
		out:  "\r ｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂ␠",
	}, { // 108
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "\r␠ｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂ␠",
		out:  "\r␠ｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂ␠",
	}, { // 109
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "\rκｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ d",
		out:  "\rκｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ d",
	}, { // 110
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "\rκｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛␠d",
		out:  "\rκｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛␠d",
	}, { // 111
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "\rκｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ ␠",
		out:  "\rκｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ ␠",
	}, { // 112
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "\rκｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛␠␠",
		out:  "\rκｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛␠␠",
	}, { // 113
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "\rκｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂ ",
		out:  "\rκｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂ ",
	}, { // 114
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "\rκｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂ␠",
		out:  "\rκｄ␝：＂νC\rη 7＂μＦt5\x10␋\\／ξ｀ξＢ:%␛ｂ␠",
	}, { // 115
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "\x1eς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11）",
		out:  "\x1eς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11）",
	}, { // 116
		mask: EncodeDollar | EncodeLeftSpace,
		in:   " ␠\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11）",
		out:  "␠␠\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11）",
	}, { // 117
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "␠␠\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11）",
		out:  "‛␠␠\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11）",
	}, { // 118
		mask: EncodeDollar | EncodeLeftSpace,
		in:   " ς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗␠）",
		out:  "␠ς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗␠）",
	}, { // 119
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "␠ς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗␠）",
		out:  "‛␠ς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗␠）",
	}, { // 120
		mask: EncodeDollar | EncodeLeftSpace,
		in:   " ς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11␠",
		out:  "␠ς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11␠",
	}, { // 121
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "␠ς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11␠",
		out:  "‛␠ς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11␠",
	}, { // 122
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "\x1e \x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11）",
		out:  "\x1e \x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11）",
	}, { // 123
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "\x1e␠\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11）",
		out:  "\x1e␠\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11）",
	}, { // 124
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "\x1e \x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗␠）",
		out:  "\x1e \x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗␠）",
	}, { // 125
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "\x1e␠\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗␠）",
		out:  "\x1e␠\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗␠）",
	}, { // 126
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "\x1e \x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11␠",
		out:  "\x1e \x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11␠",
	}, { // 127
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "\x1e␠\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11␠",
		out:  "\x1e␠\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11␠",
	}, { // 128
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "\x1eς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗ ）",
		out:  "\x1eς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗ ）",
	}, { // 129
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "\x1eς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗␠）",
		out:  "\x1eς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗␠）",
	}, { // 130
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "\x1eς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗ ␠",
		out:  "\x1eς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗ ␠",
	}, { // 131
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "\x1eς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗␠␠",
		out:  "\x1eς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗␠␠",
	}, { // 132
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "\x1eς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11 ",
		out:  "\x1eς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11 ",
	}, { // 133
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "\x1eς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11␠",
		out:  "\x1eς\x14κ|\r␞＿␑Ｂ ＇G%Tα␙ｉ␈qτｅzαδK`␗\x11␠",
	}, { // 134
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η\x06ν",
		out:  "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η\x06ν",
	}, { // 135
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   " ␠`ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η\x06ν",
		out:  "␠␠`ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η\x06ν",
	}, { // 136
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␠␠`ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η\x06ν",
		out:  "‛␠␠`ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η\x06ν",
	}, { // 137
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "  `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η␠ν",
		out:  "␠ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η␠ν",
	}, { // 138
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␠ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η␠ν",
		out:  "‛␠ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η␠ν",
	}, { // 139
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "  `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η\x06␠",
		out:  "␠ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η\x06␠",
	}, { // 140
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␠ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η\x06␠",
		out:  "‛␠ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η\x06␠",
	}, { // 141
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η\x06ν",
		out:  "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η\x06ν",
	}, { // 142
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␓␠`ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η\x06ν",
		out:  "␓␠`ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η\x06ν",
	}, { // 143
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η␠ν",
		out:  "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η␠ν",
	}, { // 144
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␓␠`ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η␠ν",
		out:  "␓␠`ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η␠ν",
	}, { // 145
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η\x06␠",
		out:  "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η\x06␠",
	}, { // 146
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␓␠`ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η\x06␠",
		out:  "␓␠`ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η\x06␠",
	}, { // 147
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η ν",
		out:  "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η ν",
	}, { // 148
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η␠ν",
		out:  "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η␠ν",
	}, { // 149
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η ␠",
		out:  "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η ␠",
	}, { // 150
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η␠␠",
		out:  "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η␠␠",
	}, { // 151
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η\x06 ",
		out:  "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η\x06 ",
	}, { // 152
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO\"␋）Ｘ＞η\x06␠",
		out:  "␓ `ν␆M＝\to＊ χ␂Ｆ \x12τ｀\x0eEζO＂␋）Ｘ＞η\x06␠",
	}, { // 153
		mask: EncodeColon | EncodeLeftSpace,
		in:   "Ｄ／␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q\v",
		out:  "Ｄ／␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q\v",
	}, { // 154
		mask: EncodeColon | EncodeLeftSpace,
		in:   " ␠␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q\v",
		out:  "␠␠␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q\v",
	}, { // 155
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␠␠␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q\v",
		out:  "‛␠␠␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q\v",
	}, { // 156
		mask: EncodeColon | EncodeLeftSpace,
		in:   " ／␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17␠\v",
		out:  "␠／␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17␠\v",
	}, { // 157
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␠／␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17␠\v",
		out:  "‛␠／␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17␠\v",
	}, { // 158
		mask: EncodeColon | EncodeLeftSpace,
		in:   " ／␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q␠",
		out:  "␠／␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q␠",
	}, { // 159
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␠／␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q␠",
		out:  "‛␠／␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q␠",
	}, { // 160
		mask: EncodeColon | EncodeLeftSpace,
		in:   "Ｄ ␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q\v",
		out:  "Ｄ ␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q\v",
	}, { // 161
		mask: EncodeColon | EncodeLeftSpace,
		in:   "Ｄ␠␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q\v",
		out:  "Ｄ␠␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q\v",
	}, { // 162
		mask: EncodeColon | EncodeLeftSpace,
		in:   "Ｄ ␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17␠\v",
		out:  "Ｄ ␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17␠\v",
	}, { // 163
		mask: EncodeColon | EncodeLeftSpace,
		in:   "Ｄ␠␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17␠\v",
		out:  "Ｄ␠␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17␠\v",
	}, { // 164
		mask: EncodeColon | EncodeLeftSpace,
		in:   "Ｄ ␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q␠",
		out:  "Ｄ ␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q␠",
	}, { // 165
		mask: EncodeColon | EncodeLeftSpace,
		in:   "Ｄ␠␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q␠",
		out:  "Ｄ␠␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q␠",
	}, { // 166
		mask: EncodeColon | EncodeLeftSpace,
		in:   "Ｄ／␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17 \v",
		out:  "Ｄ／␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17 \v",
	}, { // 167
		mask: EncodeColon | EncodeLeftSpace,
		in:   "Ｄ／␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17␠\v",
		out:  "Ｄ／␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17␠\v",
	}, { // 168
		mask: EncodeColon | EncodeLeftSpace,
		in:   "Ｄ／␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17 ␠",
		out:  "Ｄ／␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17 ␠",
	}, { // 169
		mask: EncodeColon | EncodeLeftSpace,
		in:   "Ｄ／␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17␠␠",
		out:  "Ｄ／␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17␠␠",
	}, { // 170
		mask: EncodeColon | EncodeLeftSpace,
		in:   "Ｄ／␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q ",
		out:  "Ｄ／␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q ",
	}, { // 171
		mask: EncodeColon | EncodeLeftSpace,
		in:   "Ｄ／␍[２␍S：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q␠",
		out:  "Ｄ／␍[２␍S‛：|␟ θω／a␟`ρθＸ␟２φC?iτ\x17q␠",
	}, { // 172
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "E\x05？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␚|",
		out:  "E\x05‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␚|",
	}, { // 173
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   " ␠？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␚|",
		out:  "␠␠‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␚|",
	}, { // 174
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "␠␠？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␚|",
		out:  "‛␠␠‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␚|",
	}, { // 175
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   " \x05？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␠|",
		out:  "␠\x05‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␠|",
	}, { // 176
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "␠\x05？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␠|",
		out:  "‛␠\x05‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␠|",
	}, { // 177
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   " \x05？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␚␠",
		out:  "␠\x05‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␚␠",
	}, { // 178
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "␠\x05？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␚␠",
		out:  "‛␠\x05‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␚␠",
	}, { // 179
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "E ？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␚|",
		out:  "E ‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␚|",
	}, { // 180
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "E␠？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␚|",
		out:  "E␠‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␚|",
	}, { // 181
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "E ？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␠|",
		out:  "E ‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␠|",
	}, { // 182
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "E␠？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␠|",
		out:  "E␠‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␠|",
	}, { // 183
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "E ？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␚␠",
		out:  "E ‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␚␠",
	}, { // 184
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "E␠？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␚␠",
		out:  "E␠‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␚␠",
	}, { // 185
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "E\x05？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00 |",
		out:  "E\x05‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀ |",
	}, { // 186
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "E\x05？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␠|",
		out:  "E\x05‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␠|",
	}, { // 187
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "E\x05？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00 ␠",
		out:  "E\x05‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀ ␠",
	}, { // 188
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "E\x05？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␠␠",
		out:  "E\x05‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␠␠",
	}, { // 189
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "E\x05？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␚ ",
		out:  "E\x05‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␚ ",
	}, { // 190
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "E\x05？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι？＜\x00␚␠",
		out:  "E\x05‛？ωκ\x12|＄vσ #␊\x18／１６r＄γＤ｜νeι‛？＜␀␚␠",
	}, { // 191
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\x01Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␅",
		out:  "\x01Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␅",
	}, { // 192
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   " ␠ο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␅",
		out:  "␠␠ο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␅",
	}, { // 193
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "␠␠ο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␅",
		out:  "‛␠␠ο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␅",
	}, { // 194
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   " Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭD␠␅",
		out:  "␠Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭD␠␅",
	}, { // 195
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "␠Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭD␠␅",
		out:  "‛␠Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭD␠␅",
	}, { // 196
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   " Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␠",
		out:  "␠Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␠",
	}, { // 197
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "␠Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␠",
		out:  "‛␠Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␠",
	}, { // 198
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\x01 ο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␅",
		out:  "\x01 ο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␅",
	}, { // 199
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\x01␠ο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␅",
		out:  "\x01␠ο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␅",
	}, { // 200
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\x01 ο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭD␠␅",
		out:  "\x01 ο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭD␠␅",
	}, { // 201
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\x01␠ο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭD␠␅",
		out:  "\x01␠ο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭD␠␅",
	}, { // 202
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\x01 ο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␠",
		out:  "\x01 ο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␠",
	}, { // 203
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\x01␠ο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␠",
		out:  "\x01␠ο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␠",
	}, { // 204
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\x01Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭD ␅",
		out:  "\x01Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭD ␅",
	}, { // 205
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\x01Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭD␠␅",
		out:  "\x01Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭD␠␅",
	}, { // 206
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\x01Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭD ␠",
		out:  "\x01Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭD ␠",
	}, { // 207
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\x01Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭD␠␠",
		out:  "\x01Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭD␠␠",
	}, { // 208
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\x01Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ ",
		out:  "\x01Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ ",
	}, { // 209
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\x01Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␠",
		out:  "\x01Ｏο｀h2␈χｐ\b \x17οv␑χ␇`ｆ\x06｛␉\rX＜\x03ＭDκ␠",
	}, { // 210
		mask: EncodePipe | EncodeLeftSpace,
		in:   "＞＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)m",
		out:  "＞＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)m",
	}, { // 211
		mask: EncodePipe | EncodeLeftSpace,
		in:   " ␠ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)m",
		out:  "␠␠ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)m",
	}, { // 212
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␠␠ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)m",
		out:  "‛␠␠ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)m",
	}, { // 213
		mask: EncodePipe | EncodeLeftSpace,
		in:   " ＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ␠m",
		out:  "␠＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ␠m",
	}, { // 214
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␠＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ␠m",
		out:  "‛␠＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ␠m",
	}, { // 215
		mask: EncodePipe | EncodeLeftSpace,
		in:   " ＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)␠",
		out:  "␠＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)␠",
	}, { // 216
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␠＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)␠",
		out:  "‛␠＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)␠",
	}, { // 217
		mask: EncodePipe | EncodeLeftSpace,
		in:   "＞ ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)m",
		out:  "＞ ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)m",
	}, { // 218
		mask: EncodePipe | EncodeLeftSpace,
		in:   "＞␠ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)m",
		out:  "＞␠ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)m",
	}, { // 219
		mask: EncodePipe | EncodeLeftSpace,
		in:   "＞ ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ␠m",
		out:  "＞ ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ␠m",
	}, { // 220
		mask: EncodePipe | EncodeLeftSpace,
		in:   "＞␠ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ␠m",
		out:  "＞␠ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ␠m",
	}, { // 221
		mask: EncodePipe | EncodeLeftSpace,
		in:   "＞ ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)␠",
		out:  "＞ ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)␠",
	}, { // 222
		mask: EncodePipe | EncodeLeftSpace,
		in:   "＞␠ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)␠",
		out:  "＞␠ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)␠",
	}, { // 223
		mask: EncodePipe | EncodeLeftSpace,
		in:   "＞＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ m",
		out:  "＞＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ m",
	}, { // 224
		mask: EncodePipe | EncodeLeftSpace,
		in:   "＞＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ␠m",
		out:  "＞＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ␠m",
	}, { // 225
		mask: EncodePipe | EncodeLeftSpace,
		in:   "＞＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ ␠",
		out:  "＞＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ ␠",
	}, { // 226
		mask: EncodePipe | EncodeLeftSpace,
		in:   "＞＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ␠␠",
		out:  "＞＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ␠␠",
	}, { // 227
		mask: EncodePipe | EncodeLeftSpace,
		in:   "＞＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ) ",
		out:  "＞＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ) ",
	}, { // 228
		mask: EncodePipe | EncodeLeftSpace,
		in:   "＞＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)␠",
		out:  "＞＊ＯO␛de\x1f\x13γ \rφλ\"\"：｀␕␍Ｐιμ\"␏＂＞δ)␠",
	}, { // 229
		mask: EncodeHash | EncodeLeftSpace,
		in:   "βJ\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％１",
		out:  "βJ\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％１",
	}, { // 230
		mask: EncodeHash | EncodeLeftSpace,
		in:   " ␠\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％１",
		out:  "␠␠\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％１",
	}, { // 231
		mask: EncodeHash | EncodeLeftSpace,
		in:   "␠␠\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％１",
		out:  "‛␠␠\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％１",
	}, { // 232
		mask: EncodeHash | EncodeLeftSpace,
		in:   " J\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒␠１",
		out:  "␠J\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒␠１",
	}, { // 233
		mask: EncodeHash | EncodeLeftSpace,
		in:   "␠J\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒␠１",
		out:  "‛␠J\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒␠１",
	}, { // 234
		mask: EncodeHash | EncodeLeftSpace,
		in:   " J\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％␠",
		out:  "␠J\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％␠",
	}, { // 235
		mask: EncodeHash | EncodeLeftSpace,
		in:   "␠J\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％␠",
		out:  "‛␠J\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％␠",
	}, { // 236
		mask: EncodeHash | EncodeLeftSpace,
		in:   "β \x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％１",
		out:  "β \x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％１",
	}, { // 237
		mask: EncodeHash | EncodeLeftSpace,
		in:   "β␠\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％１",
		out:  "β␠\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％１",
	}, { // 238
		mask: EncodeHash | EncodeLeftSpace,
		in:   "β \x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒␠１",
		out:  "β \x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒␠１",
	}, { // 239
		mask: EncodeHash | EncodeLeftSpace,
		in:   "β␠\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒␠１",
		out:  "β␠\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒␠１",
	}, { // 240
		mask: EncodeHash | EncodeLeftSpace,
		in:   "β \x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％␠",
		out:  "β \x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％␠",
	}, { // 241
		mask: EncodeHash | EncodeLeftSpace,
		in:   "β␠\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％␠",
		out:  "β␠\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％␠",
	}, { // 242
		mask: EncodeHash | EncodeLeftSpace,
		in:   "βJ\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒ １",
		out:  "βJ\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒ １",
	}, { // 243
		mask: EncodeHash | EncodeLeftSpace,
		in:   "βJ\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒␠１",
		out:  "βJ\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒␠１",
	}, { // 244
		mask: EncodeHash | EncodeLeftSpace,
		in:   "βJ\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒ ␠",
		out:  "βJ\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒ ␠",
	}, { // 245
		mask: EncodeHash | EncodeLeftSpace,
		in:   "βJ\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒␠␠",
		out:  "βJ\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒␠␠",
	}, { // 246
		mask: EncodeHash | EncodeLeftSpace,
		in:   "βJ\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％ ",
		out:  "βJ\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％ ",
	}, { // 247
		mask: EncodeHash | EncodeLeftSpace,
		in:   "βJ\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％␠",
		out:  "βJ\x1b␙．＞｀Ｓ\x02* ρη5\x1fα\uff00␊tρ\x01␛'μA２C␒％␠",
	}, { // 248
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␙␀＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|\x19",
		out:  "␙‛␀＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|\x19",
	}, { // 249
		mask: EncodePercent | EncodeLeftSpace,
		in:   " ␠＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|\x19",
		out:  "␠␠＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|\x19",
	}, { // 250
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␠␠＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|\x19",
		out:  "‛␠␠＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|\x19",
	}, { // 251
		mask: EncodePercent | EncodeLeftSpace,
		in:   " ␀＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^␠\x19",
		out:  "␠‛␀＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^␠\x19",
	}, { // 252
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␠␀＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^␠\x19",
		out:  "‛␠‛␀＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^␠\x19",
	}, { // 253
		mask: EncodePercent | EncodeLeftSpace,
		in:   " ␀＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|␠",
		out:  "␠‛␀＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|␠",
	}, { // 254
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␠␀＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|␠",
		out:  "‛␠‛␀＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|␠",
	}, { // 255
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␙ ＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|\x19",
		out:  "␙ ＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|\x19",
	}, { // 256
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␙␠＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|\x19",
		out:  "␙␠＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|\x19",
	}, { // 257
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␙ ＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^␠\x19",
		out:  "␙ ＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^␠\x19",
	}, { // 258
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␙␠＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^␠\x19",
		out:  "␙␠＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^␠\x19",
	}, { // 259
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␙ ＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|␠",
		out:  "␙ ＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|␠",
	}, { // 260
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␙␠＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|␠",
		out:  "␙␠＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|␠",
	}, { // 261
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␙␀＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^ \x19",
		out:  "␙‛␀＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^ \x19",
	}, { // 262
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␙␀＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^␠\x19",
		out:  "␙‛␀＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^␠\x19",
	}, { // 263
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␙␀＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^ ␠",
		out:  "␙‛␀＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^ ␠",
	}, { // 264
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␙␀＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^␠␠",
		out:  "␙‛␀＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^␠␠",
	}, { // 265
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␙␀＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^| ",
		out:  "␙‛␀＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^| ",
	}, { // 266
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␙␀＼％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|␠",
		out:  "␙‛␀＼‛％Osιｘ\x15\" >２／με\"\fIηＳν␃␡Ｖβｊ^|␠",
	}, { // 267
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "｀βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ6＇",
		out:  "｀βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ6＇",
	}, { // 268
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   " ␠rＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ6＇",
		out:  "␠␠rＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ6＇",
	}, { // 269
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␠␠rＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ6＇",
		out:  "‛␠␠rＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ6＇",
	}, { // 270
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   " βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ␠＇",
		out:  "␠βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ␠＇",
	}, { // 271
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␠βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ␠＇",
		out:  "‛␠βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ␠＇",
	}, { // 272
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   " βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ6␠",
		out:  "␠βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ6␠",
	}, { // 273
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␠βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ6␠",
		out:  "‛␠βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ6␠",
	}, { // 274
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "｀ rＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ6＇",
		out:  "｀ rＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ6＇",
	}, { // 275
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "｀␠rＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ6＇",
		out:  "｀␠rＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ6＇",
	}, { // 276
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "｀ rＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ␠＇",
		out:  "｀ rＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ␠＇",
	}, { // 277
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "｀␠rＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ␠＇",
		out:  "｀␠rＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ␠＇",
	}, { // 278
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "｀ rＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ6␠",
		out:  "｀ rＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ6␠",
	}, { // 279
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "｀␠rＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ6␠",
		out:  "｀␠rＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ6␠",
	}, { // 280
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "｀βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ ＇",
		out:  "｀βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ ＇",
	}, { // 281
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "｀βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ␠＇",
		out:  "｀βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ␠＇",
	}, { // 282
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "｀βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ ␠",
		out:  "｀βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ ␠",
	}, { // 283
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "｀βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ␠␠",
		out:  "｀βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ␠␠",
	}, { // 284
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "｀βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ6 ",
		out:  "｀βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ6 ",
	}, { // 285
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "｀βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞\\μ５FＢ6␠",
		out:  "｀βrＭ␎δ\x03\x1dς\b 6ν９%＇ο;␋␙R\x1f＞＼μ５FＢ6␠",
	}, { // 286
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "β/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z\u007f",
		out:  "β/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z\u007f",
	}, { // 287
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   " ␠UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z\u007f",
		out:  "␠␠UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z\u007f",
	}, { // 288
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "␠␠UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z\u007f",
		out:  "‛␠␠UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z\u007f",
	}, { // 289
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   " /UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／␠\u007f",
		out:  "␠/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／␠\u007f",
	}, { // 290
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "␠/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／␠\u007f",
		out:  "‛␠/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／␠\u007f",
	}, { // 291
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   " /UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z␠",
		out:  "␠/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z␠",
	}, { // 292
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "␠/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z␠",
		out:  "‛␠/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z␠",
	}, { // 293
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "β UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z\u007f",
		out:  "β UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z\u007f",
	}, { // 294
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "β␠UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z\u007f",
		out:  "β␠UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z\u007f",
	}, { // 295
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "β UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／␠\u007f",
		out:  "β UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／␠\u007f",
	}, { // 296
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "β␠UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／␠\u007f",
		out:  "β␠UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／␠\u007f",
	}, { // 297
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "β UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z␠",
		out:  "β UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z␠",
	}, { // 298
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "β␠UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z␠",
		out:  "β␠UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z␠",
	}, { // 299
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "β/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／ \u007f",
		out:  "β/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／ \u007f",
	}, { // 300
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "β/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／␠\u007f",
		out:  "β/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／␠\u007f",
	}, { // 301
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "β/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／ ␠",
		out:  "β/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／ ␠",
	}, { // 302
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "β/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／␠␠",
		out:  "β/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／␠␠",
	}, { // 303
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "β/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z ",
		out:  "β/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z ",
	}, { // 304
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "β/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z␠",
		out:  "β/UＲ＝μ␔\t］\x12 \x1f␖\">Ｙ&\x18υθλ␒u␖ｇ␔Ｉ／Z␠",
	}, { // 305
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x1a\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␜",
		out:  "\x1a\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␜",
	}, { // 306
		mask: EncodeDel | EncodeLeftSpace,
		in:   " ␠οＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␜",
		out:  "␠␠οＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␜",
	}, { // 307
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␠␠οＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␜",
		out:  "‛␠␠οＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␜",
	}, { // 308
		mask: EncodeDel | EncodeLeftSpace,
		in:   " \nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␠␜",
		out:  "␠\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␠␜",
	}, { // 309
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␠\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␠␜",
		out:  "‛␠\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␠␜",
	}, { // 310
		mask: EncodeDel | EncodeLeftSpace,
		in:   " \nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␠",
		out:  "␠\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␠",
	}, { // 311
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␠\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␠",
		out:  "‛␠\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␠",
	}, { // 312
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x1a οＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␜",
		out:  "\x1a οＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␜",
	}, { // 313
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x1a␠οＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␜",
		out:  "\x1a␠οＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␜",
	}, { // 314
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x1a οＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␠␜",
		out:  "\x1a οＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␠␜",
	}, { // 315
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x1a␠οＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␠␜",
		out:  "\x1a␠οＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␠␜",
	}, { // 316
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x1a οＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␠",
		out:  "\x1a οＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␠",
	}, { // 317
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x1a␠οＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␠",
		out:  "\x1a␠οＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␠",
	}, { // 318
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x1a\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂ ␜",
		out:  "\x1a\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂ ␜",
	}, { // 319
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x1a\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␠␜",
		out:  "\x1a\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␠␜",
	}, { // 320
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x1a\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂ ␠",
		out:  "\x1a\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂ ␠",
	}, { // 321
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x1a\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␠␠",
		out:  "\x1a\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␠␠",
	}, { // 322
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x1a\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗ ",
		out:  "\x1a\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗ ",
	}, { // 323
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x1a\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␠",
		out:  "\x1a\nοＣ\x04θＳb７␅ ]\x01z＼\x18β\bχι？（pS␌σc＂␗␠",
	}, { // 324
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "５ｕb\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρςa",
		out:  "５ｕb␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρςa",
	}, { // 325
		mask: EncodeCtl | EncodeLeftSpace,
		in:   " ␠b\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρςa",
		out:  "␠␠b␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρςa",
	}, { // 326
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␠␠b\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρςa",
		out:  "‛␠␠b␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρςa",
	}, { // 327
		mask: EncodeCtl | EncodeLeftSpace,
		in:   " ｕb\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρ␠a",
		out:  "␠ｕb␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρ␠a",
	}, { // 328
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␠ｕb\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρ␠a",
		out:  "‛␠ｕb␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρ␠a",
	}, { // 329
		mask: EncodeCtl | EncodeLeftSpace,
		in:   " ｕb\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρς␠",
		out:  "␠ｕb␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρς␠",
	}, { // 330
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␠ｕb\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρς␠",
		out:  "‛␠ｕb␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρς␠",
	}, { // 331
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "５ b\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρςa",
		out:  "５ b␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρςa",
	}, { // 332
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "５␠b\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρςa",
		out:  "５␠b␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρςa",
	}, { // 333
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "５ b\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρ␠a",
		out:  "５ b␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρ␠a",
	}, { // 334
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "５␠b\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρ␠a",
		out:  "５␠b␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρ␠a",
	}, { // 335
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "５ b\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρς␠",
		out:  "５ b␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρς␠",
	}, { // 336
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "５␠b\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρς␠",
		out:  "５␠b␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρς␠",
	}, { // 337
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "５ｕb\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρ a",
		out:  "５ｕb␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρ a",
	}, { // 338
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "５ｕb\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρ␠a",
		out:  "５ｕb␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρ␠a",
	}, { // 339
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "５ｕb\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρ ␠",
		out:  "５ｕb␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρ ␠",
	}, { // 340
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "５ｕb\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρ␠␠",
		out:  "５ｕb␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρ␠␠",
	}, { // 341
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "５ｕb\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρς ",
		out:  "５ｕb␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρς ",
	}, { // 342
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "５ｕb\x19υ\r｛mδ␊ \n>␝|\x0f␀＃@ｇ&δ<？␚ρｓρς␠",
		out:  "５ｕb␙υ␍｛mδ‛␊ ␊>‛␝|␏‛␀＃@ｇ&δ<？‛␚ρｓρς␠",
	}, { // 343
		mask: EncodeLeftPeriod,
		in:   ".",
		out:  "．",
	}, { // 344
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "θ\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮY",
		out:  "θ\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮY",
	}, { // 345
		mask: EncodeZero | EncodeLeftPeriod,
		in:   ".．ηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮY",
		out:  "．．ηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮY",
	}, { // 346
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "．．ηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮY",
		out:  "‛．．ηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮY",
	}, { // 347
		mask: EncodeZero | EncodeLeftPeriod,
		in:   ".\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bι．Y",
		out:  "．\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bι．Y",
	}, { // 348
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "．\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bι．Y",
		out:  "‛．\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bι．Y",
	}, { // 349
		mask: EncodeZero | EncodeLeftPeriod,
		in:   ".\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮ．",
		out:  "．\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮ．",
	}, { // 350
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "．\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮ．",
		out:  "‛．\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮ．",
	}, { // 351
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "θ.ηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮY",
		out:  "θ.ηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮY",
	}, { // 352
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "θ．ηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮY",
		out:  "θ．ηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮY",
	}, { // 353
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "θ.ηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bι．Y",
		out:  "θ.ηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bι．Y",
	}, { // 354
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "θ．ηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bι．Y",
		out:  "θ．ηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bι．Y",
	}, { // 355
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "θ.ηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮ．",
		out:  "θ.ηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮ．",
	}, { // 356
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "θ．ηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮ．",
		out:  "θ．ηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮ．",
	}, { // 357
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "θ\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bι.Y",
		out:  "θ\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bι.Y",
	}, { // 358
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "θ\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bι．Y",
		out:  "θ\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bι．Y",
	}, { // 359
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "θ\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bι.．",
		out:  "θ\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bι.．",
	}, { // 360
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "θ\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bι．．",
		out:  "θ\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bι．．",
	}, { // 361
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "θ\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮ.",
		out:  "θ\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮ.",
	}, { // 362
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "θ\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮ．",
		out:  "θ\x1eηκ＊\x0eＪ\x1a\x06［.］␖␆2Ｗ３？␄Mπoν1０\n\x1bιＮ．",
	}, { // 363
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "＼\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00＼J",
		out:  "＼\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀＼J",
	}, { // 364
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ".．(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00＼J",
		out:  "．．(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀＼J",
	}, { // 365
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "．．(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00＼J",
		out:  "‛．．(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀＼J",
	}, { // 366
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ".\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00．J",
		out:  "．\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀．J",
	}, { // 367
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "．\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00．J",
		out:  "‛．\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀．J",
	}, { // 368
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ".\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00＼．",
		out:  "．\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀＼．",
	}, { // 369
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "．\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00＼．",
		out:  "‛．\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀＼．",
	}, { // 370
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "＼.(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00＼J",
		out:  "＼.(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀＼J",
	}, { // 371
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "＼．(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00＼J",
		out:  "＼．(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀＼J",
	}, { // 372
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "＼.(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00．J",
		out:  "＼.(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀．J",
	}, { // 373
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "＼．(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00．J",
		out:  "＼．(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀．J",
	}, { // 374
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "＼.(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00＼．",
		out:  "＼.(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀＼．",
	}, { // 375
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "＼．(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00＼．",
		out:  "＼．(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀＼．",
	}, { // 376
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "＼\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00.J",
		out:  "＼\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀.J",
	}, { // 377
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "＼\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00．J",
		out:  "＼\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀．J",
	}, { // 378
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "＼\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00.．",
		out:  "＼\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀.．",
	}, { // 379
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "＼\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00．．",
		out:  "＼\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀．．",
	}, { // 380
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "＼\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00＼.",
		out:  "＼\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀＼.",
	}, { // 381
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "＼\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１\x00＼．",
		out:  "＼\n(υ~\rω$\x1bω.V）␚ο\n␍νV＼［ｓ[Ｍ␉％１␀＼．",
	}, { // 382
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "␞-ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂Ｈ",
		out:  "␞-ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂Ｈ",
	}, { // 383
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   ".．ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂Ｈ",
		out:  "．．ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂Ｈ",
	}, { // 384
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "．．ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂Ｈ",
		out:  "‛．．ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂Ｈ",
	}, { // 385
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   ".-ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／．Ｈ",
		out:  "．-ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／．Ｈ",
	}, { // 386
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "．-ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／．Ｈ",
		out:  "‛．-ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／．Ｈ",
	}, { // 387
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   ".-ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂．",
		out:  "．-ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂．",
	}, { // 388
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "．-ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂．",
		out:  "‛．-ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂．",
	}, { // 389
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "␞.ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂Ｈ",
		out:  "␞.ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂Ｈ",
	}, { // 390
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "␞．ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂Ｈ",
		out:  "␞．ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂Ｈ",
	}, { // 391
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "␞.ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／．Ｈ",
		out:  "␞.ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／．Ｈ",
	}, { // 392
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "␞．ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／．Ｈ",
		out:  "␞．ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／．Ｈ",
	}, { // 393
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "␞.ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂．",
		out:  "␞.ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂．",
	}, { // 394
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "␞．ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂．",
		out:  "␞．ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂．",
	}, { // 395
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "␞-ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／.Ｈ",
		out:  "␞-ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／.Ｈ",
	}, { // 396
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "␞-ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／．Ｈ",
		out:  "␞-ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／．Ｈ",
	}, { // 397
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "␞-ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／.．",
		out:  "␞-ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／.．",
	}, { // 398
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "␞-ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／．．",
		out:  "␞-ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／．．",
	}, { // 399
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "␞-ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂.",
		out:  "␞-ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂.",
	}, { // 400
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "␞-ι＆η＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂．",
		out:  "␞-ι＆η‛＇＄ιYρ.mＡ|\x11φ＾␂\x04Yς＃\x03/\x0fｅv／␂．",
	}, { // 401
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\n␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_\r",
		out:  "\n␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_\r",
	}, { // 402
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   ".．ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_\r",
		out:  "．．ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_\r",
	}, { // 403
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "．．ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_\r",
		out:  "‛．．ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_\r",
	}, { // 404
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   ".␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５．\r",
		out:  "．␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５．\r",
	}, { // 405
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "．␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５．\r",
		out:  "‛．␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５．\r",
	}, { // 406
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   ".␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_．",
		out:  "．␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_．",
	}, { // 407
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "．␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_．",
		out:  "‛．␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_．",
	}, { // 408
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\n.ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_\r",
		out:  "\n.ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_\r",
	}, { // 409
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\n．ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_\r",
		out:  "\n．ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_\r",
	}, { // 410
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\n.ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５．\r",
		out:  "\n.ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５．\r",
	}, { // 411
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\n．ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５．\r",
		out:  "\n．ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５．\r",
	}, { // 412
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\n.ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_．",
		out:  "\n.ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_．",
	}, { // 413
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\n．ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_．",
		out:  "\n．ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_．",
	}, { // 414
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\n␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５.\r",
		out:  "\n␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５.\r",
	}, { // 415
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\n␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５．\r",
		out:  "\n␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５．\r",
	}, { // 416
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\n␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５.．",
		out:  "\n␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５.．",
	}, { // 417
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\n␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５．．",
		out:  "\n␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５．．",
	}, { // 418
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\n␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_.",
		out:  "\n␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_.",
	}, { // 419
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\n␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_．",
		out:  "\n␉ｈN\x03\tδκ？\x12.E\\␊ＢFθkο␘？ν＠:｝？η５_．",
	}, { // 420
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\"\x1bςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３γψ",
		out:  "\"\x1bςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３γψ",
	}, { // 421
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   ".．ςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３γψ",
		out:  "．．ςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３γψ",
	}, { // 422
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "．．ςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３γψ",
		out:  "‛．．ςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３γψ",
	}, { // 423
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   ".\x1bςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３．ψ",
		out:  "．\x1bςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３．ψ",
	}, { // 424
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "．\x1bςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３．ψ",
		out:  "‛．\x1bςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３．ψ",
	}, { // 425
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   ".\x1bςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３γ．",
		out:  "．\x1bςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３γ．",
	}, { // 426
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "．\x1bςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３γ．",
		out:  "‛．\x1bςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３γ．",
	}, { // 427
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\".ςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３γψ",
		out:  "\".ςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３γψ",
	}, { // 428
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\"．ςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３γψ",
		out:  "\"．ςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３γψ",
	}, { // 429
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\".ςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３．ψ",
		out:  "\".ςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３．ψ",
	}, { // 430
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\"．ςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３．ψ",
		out:  "\"．ςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３．ψ",
	}, { // 431
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\".ςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３γ．",
		out:  "\".ςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３γ．",
	}, { // 432
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\"．ςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３γ．",
		out:  "\"．ςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３γ．",
	}, { // 433
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\"\x1bςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３.ψ",
		out:  "\"\x1bςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３.ψ",
	}, { // 434
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\"\x1bςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３．ψ",
		out:  "\"\x1bςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３．ψ",
	}, { // 435
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\"\x1bςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３.．",
		out:  "\"\x1bςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３.．",
	}, { // 436
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\"\x1bςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３．．",
		out:  "\"\x1bςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３．．",
	}, { // 437
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\"\x1bςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３γ.",
		out:  "\"\x1bςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３γ.",
	}, { // 438
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\"\x1bςA\x12K␋␕\\＞.M\tμ６０␍n\x1aｄ/Iｃκ３␀χ３γ．",
		out:  "\"\x1bςA\x12K␋␕\\‛＞.M\tμ６０␍n\x1aｄ/Iｃκ３‛␀χ３γ．",
	}, { // 439
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "％μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／␚",
		out:  "％μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／␚",
	}, { // 440
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   ".．\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／␚",
		out:  "．．\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／␚",
	}, { // 441
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "．．\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／␚",
		out:  "‛．．\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／␚",
	}, { // 442
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   ".μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|．␚",
		out:  "．μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|．␚",
	}, { // 443
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "．μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|．␚",
		out:  "‛．μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|．␚",
	}, { // 444
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   ".μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／．",
		out:  "．μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／．",
	}, { // 445
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "．μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／．",
		out:  "‛．μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／．",
	}, { // 446
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "％.\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／␚",
		out:  "％.\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／␚",
	}, { // 447
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "％．\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／␚",
		out:  "％．\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／␚",
	}, { // 448
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "％.\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|．␚",
		out:  "％.\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|．␚",
	}, { // 449
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "％．\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|．␚",
		out:  "％．\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|．␚",
	}, { // 450
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "％.\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／．",
		out:  "％.\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／．",
	}, { // 451
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "％．\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／．",
		out:  "％．\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／．",
	}, { // 452
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "％μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|.␚",
		out:  "％μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|.␚",
	}, { // 453
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "％μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|．␚",
		out:  "％μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|．␚",
	}, { // 454
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "％μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|.．",
		out:  "％μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|.．",
	}, { // 455
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "％μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|．．",
		out:  "％μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|．．",
	}, { // 456
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "％μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／.",
		out:  "％μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／.",
	}, { // 457
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "％μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／．",
		out:  "％μ\nＸs εr␔\r.Gβ，τＧ␙ρ␍>\x1b\a＋ψｆＥz|／．",
	}, { // 458
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "ζ␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043P",
		out:  "ζ␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043P",
	}, { // 459
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   ".．ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043P",
		out:  "．．ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043P",
	}, { // 460
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "．．ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043P",
		out:  "‛．．ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043P",
	}, { // 461
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   ".␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x04．P",
		out:  "．␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x04．P",
	}, { // 462
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "．␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x04．P",
		out:  "‛．␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x04．P",
	}, { // 463
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   ".␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043．",
		out:  "．␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043．",
	}, { // 464
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "．␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043．",
		out:  "‛．␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043．",
	}, { // 465
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "ζ.ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043P",
		out:  "ζ.ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043P",
	}, { // 466
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "ζ．ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043P",
		out:  "ζ．ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043P",
	}, { // 467
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "ζ.ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x04．P",
		out:  "ζ.ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x04．P",
	}, { // 468
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "ζ．ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x04．P",
		out:  "ζ．ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x04．P",
	}, { // 469
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "ζ.ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043．",
		out:  "ζ.ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043．",
	}, { // 470
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "ζ．ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043．",
		out:  "ζ．ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043．",
	}, { // 471
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "ζ␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x04.P",
		out:  "ζ␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x04.P",
	}, { // 472
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "ζ␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x04．P",
		out:  "ζ␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x04．P",
	}, { // 473
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "ζ␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x04.．",
		out:  "ζ␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x04.．",
	}, { // 474
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "ζ␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x04．．",
		out:  "ζ␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x04．．",
	}, { // 475
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "ζ␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043.",
		out:  "ζ␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043.",
	}, { // 476
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "ζ␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043．",
		out:  "ζ␒ｅκ\x13ｌxγＵa.␌％␞^\x1cPμλ␍ｓＶ␇\u007f\x06π␆\x043．",
	}, { // 477
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "␔π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀␚",
		out:  "␔π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀␚",
	}, { // 478
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   ".．␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀␚",
		out:  "．．␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀␚",
	}, { // 479
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "．．␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀␚",
		out:  "‛．．␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀␚",
	}, { // 480
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   ".π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030．␚",
		out:  "．π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030．␚",
	}, { // 481
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "．π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030．␚",
		out:  "‛．π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030．␚",
	}, { // 482
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   ".π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀．",
		out:  "．π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀．",
	}, { // 483
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "．π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀．",
		out:  "‛．π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀．",
	}, { // 484
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "␔.␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀␚",
		out:  "␔.␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀␚",
	}, { // 485
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "␔．␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀␚",
		out:  "␔．␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀␚",
	}, { // 486
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "␔.␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030．␚",
		out:  "␔.␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030．␚",
	}, { // 487
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "␔．␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030．␚",
		out:  "␔．␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030．␚",
	}, { // 488
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "␔.␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀．",
		out:  "␔.␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀．",
	}, { // 489
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "␔．␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀．",
		out:  "␔．␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀．",
	}, { // 490
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "␔π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030.␚",
		out:  "␔π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030.␚",
	}, { // 491
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "␔π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030．␚",
		out:  "␔π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030．␚",
	}, { // 492
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "␔π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030.．",
		out:  "␔π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030.．",
	}, { // 493
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "␔π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030．．",
		out:  "␔π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030．．",
	}, { // 494
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "␔π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀.",
		out:  "␔π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀.",
	}, { // 495
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "␔π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀．",
		out:  "␔π␜i\x1a／Ｏχ_ζ.φ\x1f\x1fｏ；０（5ζrρ？ｌQ\x19\x030｀．",
	}, { // 496
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ο｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡θD",
		out:  "ο｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡θD",
	}, { // 497
		mask: EncodeColon | EncodeLeftPeriod,
		in:   ".．i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡θD",
		out:  "．．i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡θD",
	}, { // 498
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "．．i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡θD",
		out:  "‛．．i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡θD",
	}, { // 499
		mask: EncodeColon | EncodeLeftPeriod,
		in:   ".｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡．D",
		out:  "．｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡．D",
	}, { // 500
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "．｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡．D",
		out:  "‛．｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡．D",
	}, { // 501
		mask: EncodeColon | EncodeLeftPeriod,
		in:   ".｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡θ．",
		out:  "．｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡θ．",
	}, { // 502
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "．｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡θ．",
		out:  "‛．｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡θ．",
	}, { // 503
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ο.i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡θD",
		out:  "ο.i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡θD",
	}, { // 504
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ο．i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡θD",
		out:  "ο．i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡θD",
	}, { // 505
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ο.i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡．D",
		out:  "ο.i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡．D",
	}, { // 506
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ο．i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡．D",
		out:  "ο．i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡．D",
	}, { // 507
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ο.i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡θ．",
		out:  "ο.i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡θ．",
	}, { // 508
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ο．i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡θ．",
		out:  "ο．i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡θ．",
	}, { // 509
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ο｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡.D",
		out:  "ο｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡.D",
	}, { // 510
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ο｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡．D",
		out:  "ο｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡．D",
	}, { // 511
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ο｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡.．",
		out:  "ο｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡.．",
	}, { // 512
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ο｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡．．",
		out:  "ο｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡．．",
	}, { // 513
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ο｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡θ.",
		out:  "ο｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡θ.",
	}, { // 514
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ο｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f:\x12？␡θ．",
		out:  "ο｛i%\t␕λ｜εｓ.！\a\x1fοＭ\v␋HχＬ；=f：\x12？␡θ．",
	}, { // 515
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "χ\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ]",
		out:  "χ\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ]",
	}, { // 516
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   ".．＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ]",
		out:  "．．＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ]",
	}, { // 517
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "．．＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ]",
		out:  "‛．．＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ]",
	}, { // 518
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   ".\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπ．]",
		out:  "．\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπ．]",
	}, { // 519
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "．\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπ．]",
		out:  "‛．\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπ．]",
	}, { // 520
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   ".\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ．",
		out:  "．\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ．",
	}, { // 521
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "．\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ．",
		out:  "‛．\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ．",
	}, { // 522
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "χ.＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ]",
		out:  "χ.＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ]",
	}, { // 523
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "χ．＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ]",
		out:  "χ．＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ]",
	}, { // 524
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "χ.＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπ．]",
		out:  "χ.＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπ．]",
	}, { // 525
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "χ．＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπ．]",
		out:  "χ．＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπ．]",
	}, { // 526
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "χ.＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ．",
		out:  "χ.＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ．",
	}, { // 527
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "χ．＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ．",
		out:  "χ．＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ．",
	}, { // 528
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "χ\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπ.]",
		out:  "χ\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπ.]",
	}, { // 529
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "χ\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπ．]",
		out:  "χ\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπ．]",
	}, { // 530
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "χ\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπ.．",
		out:  "χ\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπ.．",
	}, { // 531
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "χ\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπ．．",
		out:  "χ\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπ．．",
	}, { // 532
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "χ\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ.",
		out:  "χ\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ.",
	}, { // 533
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "χ\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ．",
		out:  "χ\x12＇E＂１N\x10\u007f＄.／␃-␑f\rφ＿*␈ＶＷδθｏtπθ．",
	}, { // 534
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "ｑ［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχＡ",
		out:  "ｑ［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχＡ",
	}, { // 535
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   ".．␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχＡ",
		out:  "．．␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχＡ",
	}, { // 536
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "．．␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχＡ",
		out:  "‛．．␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχＡ",
	}, { // 537
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   ".［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπ．Ａ",
		out:  "．［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπ．Ａ",
	}, { // 538
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "．［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπ．Ａ",
		out:  "‛．［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπ．Ａ",
	}, { // 539
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   ".［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχ．",
		out:  "．［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχ．",
	}, { // 540
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "．［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχ．",
		out:  "‛．［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχ．",
	}, { // 541
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "ｑ.␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχＡ",
		out:  "ｑ.␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχＡ",
	}, { // 542
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "ｑ．␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχＡ",
		out:  "ｑ．␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχＡ",
	}, { // 543
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "ｑ.␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπ．Ａ",
		out:  "ｑ.␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπ．Ａ",
	}, { // 544
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "ｑ．␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπ．Ａ",
		out:  "ｑ．␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπ．Ａ",
	}, { // 545
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "ｑ.␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχ．",
		out:  "ｑ.␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχ．",
	}, { // 546
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "ｑ．␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχ．",
		out:  "ｑ．␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχ．",
	}, { // 547
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "ｑ［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπ.Ａ",
		out:  "ｑ［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπ.Ａ",
	}, { // 548
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "ｑ［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπ．Ａ",
		out:  "ｑ［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπ．Ａ",
	}, { // 549
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "ｑ［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπ.．",
		out:  "ｑ［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπ.．",
	}, { // 550
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "ｑ［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπ．．",
		out:  "ｑ［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπ．．",
	}, { // 551
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "ｑ［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχ.",
		out:  "ｑ［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχ.",
	}, { // 552
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "ｑ［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχ．",
		out:  "ｑ［␞Ｔ\x1e␝␇/Uy.fａC@ζ\a␐\x14\x1fξ\x1dξ|＇νｗπχ．",
	}, { // 553
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍）",
		out:  "‛．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍）",
	}, { // 554
		mask: EncodePipe | EncodeLeftPeriod,
		in:   ".．␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍）",
		out:  "．．␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍）",
	}, { // 555
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．．␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍）",
		out:  "‛．．␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍）",
	}, { // 556
		mask: EncodePipe | EncodeLeftPeriod,
		in:   ".１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e．）",
		out:  "．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e．）",
	}, { // 557
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e．）",
		out:  "‛．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e．）",
	}, { // 558
		mask: EncodePipe | EncodeLeftPeriod,
		in:   ".１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍．",
		out:  "．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍．",
	}, { // 559
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍．",
		out:  "‛．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍．",
	}, { // 560
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．.␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍）",
		out:  "‛．.␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍）",
	}, { // 561
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．．␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍）",
		out:  "‛．．␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍）",
	}, { // 562
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．.␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e．）",
		out:  "‛．.␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e．）",
	}, { // 563
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．．␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e．）",
		out:  "‛．．␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e．）",
	}, { // 564
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．.␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍．",
		out:  "‛．.␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍．",
	}, { // 565
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．．␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍．",
		out:  "‛．．␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍．",
	}, { // 566
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e.）",
		out:  "‛．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e.）",
	}, { // 567
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e．）",
		out:  "‛．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e．）",
	}, { // 568
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e.．",
		out:  "‛．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e.．",
	}, { // 569
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e．．",
		out:  "‛．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e．．",
	}, { // 570
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍.",
		out:  "‛．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍.",
	}, { // 571
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍．",
		out:  "‛．１␟/\x0fγ3␄ε␒.␖A%υμF␚Ｐ\x1f\x04Ｈ?υ#\x02｀e␍．",
	}, { // 572
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "ｋτψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨιI",
		out:  "ｋτψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨιI",
	}, { // 573
		mask: EncodeHash | EncodeLeftPeriod,
		in:   ".．ψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨιI",
		out:  "．．ψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨιI",
	}, { // 574
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "．．ψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨιI",
		out:  "‛．．ψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨιI",
	}, { // 575
		mask: EncodeHash | EncodeLeftPeriod,
		in:   ".τψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨ．I",
		out:  "．τψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨ．I",
	}, { // 576
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "．τψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨ．I",
		out:  "‛．τψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨ．I",
	}, { // 577
		mask: EncodeHash | EncodeLeftPeriod,
		in:   ".τψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨι．",
		out:  "．τψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨι．",
	}, { // 578
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "．τψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨι．",
		out:  "‛．τψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨι．",
	}, { // 579
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "ｋ.ψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨιI",
		out:  "ｋ.ψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨιI",
	}, { // 580
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "ｋ．ψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨιI",
		out:  "ｋ．ψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨιI",
	}, { // 581
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "ｋ.ψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨ．I",
		out:  "ｋ.ψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨ．I",
	}, { // 582
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "ｋ．ψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨ．I",
		out:  "ｋ．ψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨ．I",
	}, { // 583
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "ｋ.ψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨι．",
		out:  "ｋ.ψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨι．",
	}, { // 584
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "ｋ．ψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨι．",
		out:  "ｋ．ψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨι．",
	}, { // 585
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "ｋτψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨ.I",
		out:  "ｋτψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨ.I",
	}, { // 586
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "ｋτψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨ．I",
		out:  "ｋτψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨ．I",
	}, { // 587
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "ｋτψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨ.．",
		out:  "ｋτψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨ.．",
	}, { // 588
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "ｋτψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨ．．",
		out:  "ｋτψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨ．．",
	}, { // 589
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "ｋτψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨι.",
		out:  "ｋτψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨι.",
	}, { // 590
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "ｋτψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε＃[uＨι．",
		out:  "ｋτψ）E␒\x0fμ－ｖ.aβW>｀␚｛\x04＂＂\f\x19ε‛＃[uＨι．",
	}, { // 591
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "λψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ␍",
		out:  "λψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ␍",
	}, { // 592
		mask: EncodePercent | EncodeLeftPeriod,
		in:   ".．␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ␍",
		out:  "．．␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ␍",
	}, { // 593
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "．．␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ␍",
		out:  "‛．．␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ␍",
	}, { // 594
		mask: EncodePercent | EncodeLeftPeriod,
		in:   ".ψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧ．␍",
		out:  "．ψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧ．␍",
	}, { // 595
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "．ψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧ．␍",
		out:  "‛．ψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧ．␍",
	}, { // 596
		mask: EncodePercent | EncodeLeftPeriod,
		in:   ".ψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ．",
		out:  "．ψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ．",
	}, { // 597
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "．ψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ．",
		out:  "‛．ψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ．",
	}, { // 598
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "λ.␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ␍",
		out:  "λ.␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ␍",
	}, { // 599
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "λ．␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ␍",
		out:  "λ．␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ␍",
	}, { // 600
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "λ.␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧ．␍",
		out:  "λ.␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧ．␍",
	}, { // 601
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "λ．␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧ．␍",
		out:  "λ．␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧ．␍",
	}, { // 602
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "λ.␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ．",
		out:  "λ.␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ．",
	}, { // 603
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "λ．␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ．",
		out:  "λ．␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ．",
	}, { // 604
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "λψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧ.␍",
		out:  "λψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧ.␍",
	}, { // 605
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "λψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧ．␍",
		out:  "λψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧ．␍",
	}, { // 606
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "λψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧ.．",
		out:  "λψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧ.．",
	}, { // 607
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "λψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧ．．",
		out:  "λψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧ．．",
	}, { // 608
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "λψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ.",
		out:  "λψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ.",
	}, { // 609
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "λψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ．",
		out:  "λψ␉␅\x18`␓η７C.N＃δ\vｓｓ：\x1fςj\x04β＞＄[GＧJ．",
	}, { // 610
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ω\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?ＡＶ",
		out:  "ω\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?ＡＶ",
	}, { // 611
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   ".．５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?ＡＶ",
		out:  "．．５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?ＡＶ",
	}, { // 612
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "．．５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?ＡＶ",
		out:  "‛．．５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?ＡＶ",
	}, { // 613
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   ".\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?．Ｖ",
		out:  "．\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?．Ｖ",
	}, { // 614
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "．\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?．Ｖ",
		out:  "‛．\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?．Ｖ",
	}, { // 615
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   ".\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?Ａ．",
		out:  "．\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?Ａ．",
	}, { // 616
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "．\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?Ａ．",
		out:  "‛．\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?Ａ．",
	}, { // 617
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ω.５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?ＡＶ",
		out:  "ω.５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?ＡＶ",
	}, { // 618
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ω．５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?ＡＶ",
		out:  "ω．５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?ＡＶ",
	}, { // 619
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ω.５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?．Ｖ",
		out:  "ω.５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?．Ｖ",
	}, { // 620
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ω．５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?．Ｖ",
		out:  "ω．５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?．Ｖ",
	}, { // 621
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ω.５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?Ａ．",
		out:  "ω.５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?Ａ．",
	}, { // 622
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ω．５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?Ａ．",
		out:  "ω．５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?Ａ．",
	}, { // 623
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ω\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?.Ｖ",
		out:  "ω\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?.Ｖ",
	}, { // 624
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ω\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?．Ｖ",
		out:  "ω\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?．Ｖ",
	}, { // 625
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ω\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?.．",
		out:  "ω\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?.．",
	}, { // 626
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ω\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?．．",
		out:  "ω\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?．．",
	}, { // 627
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ω\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?Ａ.",
		out:  "ω\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?Ａ.",
	}, { // 628
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ω\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?Ａ．",
		out:  "ω\x13５｜Dχ␃κ\x11Y.␊ｏ␘(εW>｛␍␋:\x06π：~W?Ａ．",
	}, { // 629
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "＊／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ\u007f",
		out:  "＊／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ\u007f",
	}, { // 630
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   ".．ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ\u007f",
		out:  "．．ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ\u007f",
	}, { // 631
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "．．ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ\u007f",
		out:  "‛．．ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ\u007f",
	}, { // 632
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   ".／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμ．\u007f",
		out:  "．／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμ．\u007f",
	}, { // 633
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "．／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμ．\u007f",
		out:  "‛．／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμ．\u007f",
	}, { // 634
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   ".／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ．",
		out:  "．／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ．",
	}, { // 635
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "．／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ．",
		out:  "‛．／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ．",
	}, { // 636
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "＊.ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ\u007f",
		out:  "＊.ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ\u007f",
	}, { // 637
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "＊．ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ\u007f",
		out:  "＊．ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ\u007f",
	}, { // 638
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "＊.ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμ．\u007f",
		out:  "＊.ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμ．\u007f",
	}, { // 639
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "＊．ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμ．\u007f",
		out:  "＊．ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμ．\u007f",
	}, { // 640
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "＊.ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ．",
		out:  "＊.ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ．",
	}, { // 641
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "＊．ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ．",
		out:  "＊．ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ．",
	}, { // 642
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "＊／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμ.\u007f",
		out:  "＊／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμ.\u007f",
	}, { // 643
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "＊／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμ．\u007f",
		out:  "＊／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμ．\u007f",
	}, { // 644
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "＊／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμ.．",
		out:  "＊／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμ.．",
	}, { // 645
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "＊／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμ．．",
		out:  "＊／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμ．．",
	}, { // 646
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "＊／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ.",
		out:  "＊／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ.",
	}, { // 647
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "＊／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ．",
		out:  "＊／ｋ\x1a\x10Fｈg：｀.ν␜`\x0e＾／Rj-^\x12βη␡αρμＤ．",
	}, { // 648
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "!_ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:οξ",
		out:  "!_ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:οξ",
	}, { // 649
		mask: EncodeDel | EncodeLeftPeriod,
		in:   ".．ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:οξ",
		out:  "．．ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:οξ",
	}, { // 650
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "．．ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:οξ",
		out:  "‛．．ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:οξ",
	}, { // 651
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "._ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:．ξ",
		out:  "．_ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:．ξ",
	}, { // 652
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "．_ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:．ξ",
		out:  "‛．_ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:．ξ",
	}, { // 653
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "._ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:ο．",
		out:  "．_ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:ο．",
	}, { // 654
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "．_ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:ο．",
		out:  "‛．_ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:ο．",
	}, { // 655
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "!.ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:οξ",
		out:  "!.ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:οξ",
	}, { // 656
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "!．ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:οξ",
		out:  "!．ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:οξ",
	}, { // 657
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "!.ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:．ξ",
		out:  "!.ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:．ξ",
	}, { // 658
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "!．ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:．ξ",
		out:  "!．ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:．ξ",
	}, { // 659
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "!.ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:ο．",
		out:  "!.ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:ο．",
	}, { // 660
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "!．ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:ο．",
		out:  "!．ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:ο．",
	}, { // 661
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "!_ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:.ξ",
		out:  "!_ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:.ξ",
	}, { // 662
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "!_ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:．ξ",
		out:  "!_ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:．ξ",
	}, { // 663
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "!_ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:.．",
		out:  "!_ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:.．",
	}, { // 664
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "!_ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:．．",
		out:  "!_ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:．．",
	}, { // 665
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "!_ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:ο.",
		out:  "!_ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:ο.",
	}, { // 666
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "!_ｘ＜ｃ␎\b␊/␀.］＋\x00?*\\＋u μ：\u007fβν／Ｘ:ο．",
		out:  "!_ｘ＜ｃ␎\b␊/‛␀.］＋␀?*\\＋u μ：␡βν／Ｘ:ο．",
	}, { // 667
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "ημ3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%1\t",
		out:  "ημ3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%1␉",
	}, { // 668
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   ".．3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%1\t",
		out:  "．．3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%1␉",
	}, { // 669
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "．．3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%1\t",
		out:  "‛．．3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%1␉",
	}, { // 670
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   ".μ3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%．\t",
		out:  "．μ3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%．␉",
	}, { // 671
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "．μ3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%．\t",
		out:  "‛．μ3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%．␉",
	}, { // 672
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   ".μ3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%1．",
		out:  "．μ3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%1．",
	}, { // 673
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "．μ3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%1．",
		out:  "‛．μ3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%1．",
	}, { // 674
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "η.3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%1\t",
		out:  "η.3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%1␉",
	}, { // 675
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "η．3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%1\t",
		out:  "η．3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%1␉",
	}, { // 676
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "η.3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%．\t",
		out:  "η.3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%．␉",
	}, { // 677
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "η．3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%．\t",
		out:  "η．3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%．␉",
	}, { // 678
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "η.3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%1．",
		out:  "η.3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%1．",
	}, { // 679
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "η．3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%1．",
		out:  "η．3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%1．",
	}, { // 680
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "ημ3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%.\t",
		out:  "ημ3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%.␉",
	}, { // 681
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "ημ3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%．\t",
		out:  "ημ3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%．␉",
	}, { // 682
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "ημ3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%.．",
		out:  "ημ3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%.．",
	}, { // 683
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "ημ3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%．．",
		out:  "ημ3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%．．",
	}, { // 684
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "ημ3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%1.",
		out:  "ημ3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%1.",
	}, { // 685
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "ημ3λxυ?*␉B.%␐\x14τ＇␆'！Ｖ␜！ｄ＼␜␘ρ%1．",
		out:  "ημ3λxυ?*‛␉B.%‛␐␔τ＇‛␆'！Ｖ‛␜！ｄ＼‛␜‛␘ρ%1．",
	}, { // 686
		mask: EncodeLeftTilde,
		in:   "~",
		out:  "～",
	}, { // 687
		mask: EncodeZero | EncodeLeftTilde,
		in:   "\nχα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ␌",
		out:  "\nχα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ␌",
	}, { // 688
		mask: EncodeZero | EncodeLeftTilde,
		in:   "~～α%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ␌",
		out:  "～～α%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ␌",
	}, { // 689
		mask: EncodeZero | EncodeLeftTilde,
		in:   "～～α%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ␌",
		out:  "‛～～α%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ␌",
	}, { // 690
		mask: EncodeZero | EncodeLeftTilde,
		in:   "~χα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ι～␌",
		out:  "～χα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ι～␌",
	}, { // 691
		mask: EncodeZero | EncodeLeftTilde,
		in:   "～χα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ι～␌",
		out:  "‛～χα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ι～␌",
	}, { // 692
		mask: EncodeZero | EncodeLeftTilde,
		in:   "~χα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ～",
		out:  "～χα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ～",
	}, { // 693
		mask: EncodeZero | EncodeLeftTilde,
		in:   "～χα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ～",
		out:  "‛～χα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ～",
	}, { // 694
		mask: EncodeZero | EncodeLeftTilde,
		in:   "\n~α%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ␌",
		out:  "\n~α%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ␌",
	}, { // 695
		mask: EncodeZero | EncodeLeftTilde,
		in:   "\n～α%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ␌",
		out:  "\n～α%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ␌",
	}, { // 696
		mask: EncodeZero | EncodeLeftTilde,
		in:   "\n~α%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ι～␌",
		out:  "\n~α%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ι～␌",
	}, { // 697
		mask: EncodeZero | EncodeLeftTilde,
		in:   "\n～α%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ι～␌",
		out:  "\n～α%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ι～␌",
	}, { // 698
		mask: EncodeZero | EncodeLeftTilde,
		in:   "\n~α%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ～",
		out:  "\n~α%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ～",
	}, { // 699
		mask: EncodeZero | EncodeLeftTilde,
		in:   "\n～α%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ～",
		out:  "\n～α%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ～",
	}, { // 700
		mask: EncodeZero | EncodeLeftTilde,
		in:   "\nχα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ι~␌",
		out:  "\nχα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ι~␌",
	}, { // 701
		mask: EncodeZero | EncodeLeftTilde,
		in:   "\nχα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ι～␌",
		out:  "\nχα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ι～␌",
	}, { // 702
		mask: EncodeZero | EncodeLeftTilde,
		in:   "\nχα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ι~～",
		out:  "\nχα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ι~～",
	}, { // 703
		mask: EncodeZero | EncodeLeftTilde,
		in:   "\nχα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ι～～",
		out:  "\nχα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ι～～",
	}, { // 704
		mask: EncodeZero | EncodeLeftTilde,
		in:   "\nχα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ~",
		out:  "\nχα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ~",
	}, { // 705
		mask: EncodeZero | EncodeLeftTilde,
		in:   "\nχα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ～",
		out:  "\nχα%3３］ο␖\b~？m␕ζν\tＡ␊\x15/<-7＠ｊ%ιＪ～",
	}, { // 706
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "o\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐r",
		out:  "o\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐r",
	}, { // 707
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "~～8Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐r",
		out:  "～～8Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐r",
	}, { // 708
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "～～8Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐r",
		out:  "‛～～8Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐r",
	}, { // 709
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "~\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ～r",
		out:  "～\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ～r",
	}, { // 710
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "～\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ～r",
		out:  "‛～\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ～r",
	}, { // 711
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "~\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐～",
		out:  "～\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐～",
	}, { // 712
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "～\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐～",
		out:  "‛～\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐～",
	}, { // 713
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "o~8Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐r",
		out:  "o~8Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐r",
	}, { // 714
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "o～8Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐r",
		out:  "o～8Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐r",
	}, { // 715
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "o~8Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ～r",
		out:  "o~8Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ～r",
	}, { // 716
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "o～8Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ～r",
		out:  "o～8Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ～r",
	}, { // 717
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "o~8Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐～",
		out:  "o~8Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐～",
	}, { // 718
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "o～8Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐～",
		out:  "o～8Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐～",
	}, { // 719
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "o\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ~r",
		out:  "o\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ~r",
	}, { // 720
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "o\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ～r",
		out:  "o\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ～r",
	}, { // 721
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "o\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ~～",
		out:  "o\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ~～",
	}, { // 722
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "o\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ～～",
		out:  "o\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ～～",
	}, { // 723
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "o\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐~",
		out:  "o\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐~",
	}, { // 724
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "o\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐～",
		out:  "o\x028Ｐσ\v\x1c＂\\｜~␝ogοａ-４２|ξ`ψα␉＂Ｕｋ␐～",
	}, { // 725
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "κχ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜Ｉ",
		out:  "κχ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜Ｉ",
	}, { // 726
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "~～3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜Ｉ",
		out:  "～～3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜Ｉ",
	}, { // 727
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "～～3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜Ｉ",
		out:  "‛～～3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜Ｉ",
	}, { // 728
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "~χ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN～Ｉ",
		out:  "～χ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN～Ｉ",
	}, { // 729
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "～χ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN～Ｉ",
		out:  "‛～χ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN～Ｉ",
	}, { // 730
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "~χ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜～",
		out:  "～χ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜～",
	}, { // 731
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "～χ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜～",
		out:  "‛～χ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜～",
	}, { // 732
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "κ~3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜Ｉ",
		out:  "κ~3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜Ｉ",
	}, { // 733
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "κ～3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜Ｉ",
		out:  "κ～3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜Ｉ",
	}, { // 734
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "κ~3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN～Ｉ",
		out:  "κ~3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN～Ｉ",
	}, { // 735
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "κ～3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN～Ｉ",
		out:  "κ～3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN～Ｉ",
	}, { // 736
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "κ~3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜～",
		out:  "κ~3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜～",
	}, { // 737
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "κ～3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜～",
		out:  "κ～3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜～",
	}, { // 738
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "κχ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN~Ｉ",
		out:  "κχ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN~Ｉ",
	}, { // 739
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "κχ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN～Ｉ",
		out:  "κχ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN～Ｉ",
	}, { // 740
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "κχ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN~～",
		out:  "κχ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN~～",
	}, { // 741
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "κχ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN～～",
		out:  "κχ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN～～",
	}, { // 742
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "κχ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜~",
		out:  "κχ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜~",
	}, { // 743
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "κχ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜～",
		out:  "κχ3\x0e␔λ\x12／ηn~εM␅␍\n\x1c␃␃ＺξＮE\x14＼\x10XN｜～",
	}, { // 744
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "␎ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'χ",
		out:  "␎ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'χ",
	}, { // 745
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "~～=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'χ",
		out:  "～～=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'χ",
	}, { // 746
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "～～=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'χ",
		out:  "‛～～=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'χ",
	}, { // 747
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "~ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5～χ",
		out:  "～ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5～χ",
	}, { // 748
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "～ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5～χ",
		out:  "‛～ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5～χ",
	}, { // 749
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "~ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'～",
		out:  "～ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'～",
	}, { // 750
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "～ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'～",
		out:  "‛～ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'～",
	}, { // 751
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "␎~=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'χ",
		out:  "␎~=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'χ",
	}, { // 752
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "␎～=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'χ",
		out:  "␎～=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'χ",
	}, { // 753
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "␎~=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5～χ",
		out:  "␎~=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5～χ",
	}, { // 754
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "␎～=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5～χ",
		out:  "␎～=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5～χ",
	}, { // 755
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "␎~=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'～",
		out:  "␎~=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'～",
	}, { // 756
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "␎～=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'～",
		out:  "␎～=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'～",
	}, { // 757
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "␎ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5~χ",
		out:  "␎ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5~χ",
	}, { // 758
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "␎ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5～χ",
		out:  "␎ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5～χ",
	}, { // 759
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "␎ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5~～",
		out:  "␎ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5~～",
	}, { // 760
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "␎ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5～～",
		out:  "␎ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5～～",
	}, { // 761
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "␎ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'~",
		out:  "␎ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'~",
	}, { // 762
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "␎ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'～",
		out:  "␎ι=\x1cζ␁ｔ0＼␞~\x12Ｉ␜\x11＋␃＇６Ｕ<2j\x0eγγ\f5'～",
	}, { // 763
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "ＢDＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a␗",
		out:  "ＢDＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a␗",
	}, { // 764
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "~～Ｇ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a␗",
		out:  "～～Ｇ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a␗",
	}, { // 765
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "～～Ｇ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a␗",
		out:  "‛～～Ｇ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a␗",
	}, { // 766
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "~DＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ～␗",
		out:  "～DＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ～␗",
	}, { // 767
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "～DＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ～␗",
		out:  "‛～DＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ～␗",
	}, { // 768
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "~DＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a～",
		out:  "～DＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a～",
	}, { // 769
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "～DＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a～",
		out:  "‛～DＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a～",
	}, { // 770
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Ｂ~Ｇ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a␗",
		out:  "Ｂ~Ｇ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a␗",
	}, { // 771
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Ｂ～Ｇ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a␗",
		out:  "Ｂ～Ｇ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a␗",
	}, { // 772
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Ｂ~Ｇ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ～␗",
		out:  "Ｂ~Ｇ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ～␗",
	}, { // 773
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Ｂ～Ｇ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ～␗",
		out:  "Ｂ～Ｇ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ～␗",
	}, { // 774
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Ｂ~Ｇ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a～",
		out:  "Ｂ~Ｇ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a～",
	}, { // 775
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Ｂ～Ｇ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a～",
		out:  "Ｂ～Ｇ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a～",
	}, { // 776
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "ＢDＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ~␗",
		out:  "ＢDＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ~␗",
	}, { // 777
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "ＢDＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ～␗",
		out:  "ＢDＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ～␗",
	}, { // 778
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "ＢDＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ~～",
		out:  "ＢDＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ~～",
	}, { // 779
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "ＢDＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ～～",
		out:  "ＢDＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ～～",
	}, { // 780
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "ＢDＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a~",
		out:  "ＢDＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a~",
	}, { // 781
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "ＢDＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a～",
		out:  "ＢDＧ$｀␐＄\x15γR~θ␋βM\x13οe？\r]xＵλX］ηｙ\a～",
	}, { // 782
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ζ| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤυ",
		out:  "ζ| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤυ",
	}, { // 783
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "~～ /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤυ",
		out:  "～～ /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤυ",
	}, { // 784
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "～～ /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤυ",
		out:  "‛～～ /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤυ",
	}, { // 785
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "~| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵ～υ",
		out:  "～| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵ～υ",
	}, { // 786
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "～| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵ～υ",
		out:  "‛～| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵ～υ",
	}, { // 787
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "~| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤ～",
		out:  "～| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤ～",
	}, { // 788
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "～| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤ～",
		out:  "‛～| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤ～",
	}, { // 789
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ζ~ /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤυ",
		out:  "ζ~ /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤυ",
	}, { // 790
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ζ～ /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤυ",
		out:  "ζ～ /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤυ",
	}, { // 791
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ζ~ /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵ～υ",
		out:  "ζ~ /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵ～υ",
	}, { // 792
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ζ～ /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵ～υ",
		out:  "ζ～ /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵ～υ",
	}, { // 793
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ζ~ /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤ～",
		out:  "ζ~ /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤ～",
	}, { // 794
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ζ～ /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤ～",
		out:  "ζ～ /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤ～",
	}, { // 795
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ζ| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵ~υ",
		out:  "ζ| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵ~υ",
	}, { // 796
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ζ| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵ～υ",
		out:  "ζ| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵ～υ",
	}, { // 797
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ζ| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵ~～",
		out:  "ζ| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵ~～",
	}, { // 798
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ζ| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵ～～",
		out:  "ζ| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵ～～",
	}, { // 799
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ζ| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤ~",
		out:  "ζ| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤ~",
	}, { // 800
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ζ| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤ～",
		out:  "ζ| /｜q␝␂\x1a-~．Ｕ\x01＂\r?χ＃ξf$\u007fμ／ｓλＵＤ～",
	}, { // 801
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "Ｃ\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？#",
		out:  "Ｃ\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？#",
	}, { // 802
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "~～v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？#",
		out:  "～～v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？#",
	}, { // 803
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "～～v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？#",
		out:  "‛～～v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？#",
	}, { // 804
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "~\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ～#",
		out:  "～\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ～#",
	}, { // 805
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "～\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ～#",
		out:  "‛～\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ～#",
	}, { // 806
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "~\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？～",
		out:  "～\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？～",
	}, { // 807
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "～\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？～",
		out:  "‛～\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？～",
	}, { // 808
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "Ｃ~v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？#",
		out:  "Ｃ~v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？#",
	}, { // 809
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "Ｃ～v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？#",
		out:  "Ｃ～v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？#",
	}, { // 810
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "Ｃ~v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ～#",
		out:  "Ｃ~v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ～#",
	}, { // 811
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "Ｃ～v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ～#",
		out:  "Ｃ～v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ～#",
	}, { // 812
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "Ｃ~v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？～",
		out:  "Ｃ~v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？～",
	}, { // 813
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "Ｃ～v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？～",
		out:  "Ｃ～v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？～",
	}, { // 814
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "Ｃ\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ~#",
		out:  "Ｃ\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ~#",
	}, { // 815
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "Ｃ\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ～#",
		out:  "Ｃ\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ～#",
	}, { // 816
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "Ｃ\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ~～",
		out:  "Ｃ\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ~～",
	}, { // 817
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "Ｃ\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ～～",
		out:  "Ｃ\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ～～",
	}, { // 818
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "Ｃ\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？~",
		out:  "Ｃ\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？~",
	}, { // 819
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "Ｃ\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？～",
		out:  "Ｃ\\v）␘\x1a｜ε\x1f\x19~θο:Z｛W#Ｐδ␈ ［eｋＳ␑δ？～",
	}, { // 820
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ｖＵ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％\x06",
		out:  "ｖＵ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％\x06",
	}, { // 821
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "~～␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％\x06",
		out:  "～～␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％\x06",
	}, { // 822
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "～～␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％\x06",
		out:  "‛～～␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％\x06",
	}, { // 823
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "~Ｕ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a～\x06",
		out:  "～Ｕ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a～\x06",
	}, { // 824
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "～Ｕ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a～\x06",
		out:  "‛～Ｕ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a～\x06",
	}, { // 825
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "~Ｕ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％～",
		out:  "～Ｕ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％～",
	}, { // 826
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "～Ｕ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％～",
		out:  "‛～Ｕ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％～",
	}, { // 827
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ｖ~␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％\x06",
		out:  "ｖ~␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％\x06",
	}, { // 828
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ｖ～␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％\x06",
		out:  "ｖ～␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％\x06",
	}, { // 829
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ｖ~␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a～\x06",
		out:  "ｖ~␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a～\x06",
	}, { // 830
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ｖ～␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a～\x06",
		out:  "ｖ～␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a～\x06",
	}, { // 831
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ｖ~␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％～",
		out:  "ｖ~␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％～",
	}, { // 832
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ｖ～␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％～",
		out:  "ｖ～␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％～",
	}, { // 833
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ｖＵ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a~\x06",
		out:  "ｖＵ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a~\x06",
	}, { // 834
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ｖＵ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a～\x06",
		out:  "ｖＵ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a～\x06",
	}, { // 835
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ｖＵ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a~～",
		out:  "ｖＵ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a~～",
	}, { // 836
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ｖＵ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a～～",
		out:  "ｖＵ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a～～",
	}, { // 837
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ｖＵ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％~",
		out:  "ｖＵ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％~",
	}, { // 838
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ｖＵ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％～",
		out:  "ｖＵ␐MＸFφγ＄＞~^\x03\x1fφ，ν\x04[＃(ηκ?＃ｅ\u007f\x1a％～",
	}, { // 839
		mask: EncodeColon | EncodeLeftTilde,
		in:   "δ\rtｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞δＬ",
		out:  "δ\rtｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞δＬ",
	}, { // 840
		mask: EncodeColon | EncodeLeftTilde,
		in:   "~～tｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞δＬ",
		out:  "～～tｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞δＬ",
	}, { // 841
		mask: EncodeColon | EncodeLeftTilde,
		in:   "～～tｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞δＬ",
		out:  "‛～～tｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞δＬ",
	}, { // 842
		mask: EncodeColon | EncodeLeftTilde,
		in:   "~\rtｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞～Ｌ",
		out:  "～\rtｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞～Ｌ",
	}, { // 843
		mask: EncodeColon | EncodeLeftTilde,
		in:   "～\rtｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞～Ｌ",
		out:  "‛～\rtｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞～Ｌ",
	}, { // 844
		mask: EncodeColon | EncodeLeftTilde,
		in:   "~\rtｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞δ～",
		out:  "～\rtｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞δ～",
	}, { // 845
		mask: EncodeColon | EncodeLeftTilde,
		in:   "～\rtｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞δ～",
		out:  "‛～\rtｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞δ～",
	}, { // 846
		mask: EncodeColon | EncodeLeftTilde,
		in:   "δ~tｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞δＬ",
		out:  "δ~tｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞δＬ",
	}, { // 847
		mask: EncodeColon | EncodeLeftTilde,
		in:   "δ～tｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞δＬ",
		out:  "δ～tｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞δＬ",
	}, { // 848
		mask: EncodeColon | EncodeLeftTilde,
		in:   "δ~tｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞～Ｌ",
		out:  "δ~tｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞～Ｌ",
	}, { // 849
		mask: EncodeColon | EncodeLeftTilde,
		in:   "δ～tｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞～Ｌ",
		out:  "δ～tｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞～Ｌ",
	}, { // 850
		mask: EncodeColon | EncodeLeftTilde,
		in:   "δ~tｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞δ～",
		out:  "δ~tｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞δ～",
	}, { // 851
		mask: EncodeColon | EncodeLeftTilde,
		in:   "δ～tｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞δ～",
		out:  "δ～tｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞δ～",
	}, { // 852
		mask: EncodeColon | EncodeLeftTilde,
		in:   "δ\rtｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞~Ｌ",
		out:  "δ\rtｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞~Ｌ",
	}, { // 853
		mask: EncodeColon | EncodeLeftTilde,
		in:   "δ\rtｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞～Ｌ",
		out:  "δ\rtｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞～Ｌ",
	}, { // 854
		mask: EncodeColon | EncodeLeftTilde,
		in:   "δ\rtｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞~～",
		out:  "δ\rtｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞~～",
	}, { // 855
		mask: EncodeColon | EncodeLeftTilde,
		in:   "δ\rtｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞～～",
		out:  "δ\rtｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞～～",
	}, { // 856
		mask: EncodeColon | EncodeLeftTilde,
		in:   "δ\rtｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞δ~",
		out:  "δ\rtｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞δ~",
	}, { // 857
		mask: EncodeColon | EncodeLeftTilde,
		in:   "δ\rtｖ␙ｘ\x1e\x1a>υ~ａm:\":␟χ：␑␘＜&ωηＤS␞δ～",
		out:  "δ\rtｖ␙ｘ\x1e\x1a>υ~ａm：\"：␟χ‛：␑␘＜&ωηＤS␞δ～",
	}, { // 858
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "）␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４Kc",
		out:  "）␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４Kc",
	}, { // 859
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "~～␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４Kc",
		out:  "～～␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４Kc",
	}, { // 860
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "～～␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４Kc",
		out:  "‛～～␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４Kc",
	}, { // 861
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "~␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４～c",
		out:  "～␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４～c",
	}, { // 862
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "～␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４～c",
		out:  "‛～␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４～c",
	}, { // 863
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "~␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４K～",
		out:  "～␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４K～",
	}, { // 864
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "～␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４K～",
		out:  "‛～␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４K～",
	}, { // 865
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "）~␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４Kc",
		out:  "）~␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４Kc",
	}, { // 866
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "）～␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４Kc",
		out:  "）～␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４Kc",
	}, { // 867
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "）~␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４～c",
		out:  "）~␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４～c",
	}, { // 868
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "）～␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４～c",
		out:  "）～␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４～c",
	}, { // 869
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "）~␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４K～",
		out:  "）~␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４K～",
	}, { // 870
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "）～␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４K～",
		out:  "）～␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４K～",
	}, { // 871
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "）␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４~c",
		out:  "）␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４~c",
	}, { // 872
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "）␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４～c",
		out:  "）␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４～c",
	}, { // 873
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "）␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４~～",
		out:  "）␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４~～",
	}, { // 874
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "）␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４～～",
		out:  "）␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４～～",
	}, { // 875
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "）␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４K~",
		out:  "）␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４K~",
	}, { // 876
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "）␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４K～",
		out:  "）␖␁dVｚ\x0fπρκ~␝ｇ６\x03 ␎ω\r␐%３σ␄α/t４K～",
	}, { // 877
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "｜\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７ｕ",
		out:  "｜\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７ｕ",
	}, { // 878
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "~～2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７ｕ",
		out:  "～～2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７ｕ",
	}, { // 879
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "～～2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７ｕ",
		out:  "‛～～2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７ｕ",
	}, { // 880
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "~\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊～ｕ",
		out:  "～\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊～ｕ",
	}, { // 881
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "～\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊～ｕ",
		out:  "‛～\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊～ｕ",
	}, { // 882
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "~\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７～",
		out:  "～\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７～",
	}, { // 883
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "～\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７～",
		out:  "‛～\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７～",
	}, { // 884
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "｜~2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７ｕ",
		out:  "｜~2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７ｕ",
	}, { // 885
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "｜～2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７ｕ",
		out:  "｜～2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７ｕ",
	}, { // 886
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "｜~2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊～ｕ",
		out:  "｜~2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊～ｕ",
	}, { // 887
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "｜～2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊～ｕ",
		out:  "｜～2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊～ｕ",
	}, { // 888
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "｜~2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７～",
		out:  "｜~2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７～",
	}, { // 889
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "｜～2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７～",
		out:  "｜～2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７～",
	}, { // 890
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "｜\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊~ｕ",
		out:  "｜\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊~ｕ",
	}, { // 891
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "｜\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊～ｕ",
		out:  "｜\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊～ｕ",
	}, { // 892
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "｜\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊~～",
		out:  "｜\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊~～",
	}, { // 893
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "｜\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊～～",
		out:  "｜\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊～～",
	}, { // 894
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "｜\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７~",
		out:  "｜\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７~",
	}, { // 895
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "｜\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７～",
		out:  "｜\t2:&υη／Pθ~π␃\x12␎␖\rＹπｖ7\nβＣＷ\rX␊７～",
	}, { // 896
		mask: EncodePipe | EncodeLeftTilde,
		in:   "β\x04Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀␒<",
		out:  "β\x04Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀␒<",
	}, { // 897
		mask: EncodePipe | EncodeLeftTilde,
		in:   "~～Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀␒<",
		out:  "～～Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀␒<",
	}, { // 898
		mask: EncodePipe | EncodeLeftTilde,
		in:   "～～Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀␒<",
		out:  "‛～～Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀␒<",
	}, { // 899
		mask: EncodePipe | EncodeLeftTilde,
		in:   "~\x04Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀～<",
		out:  "～\x04Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀～<",
	}, { // 900
		mask: EncodePipe | EncodeLeftTilde,
		in:   "～\x04Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀～<",
		out:  "‛～\x04Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀～<",
	}, { // 901
		mask: EncodePipe | EncodeLeftTilde,
		in:   "~\x04Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀␒～",
		out:  "～\x04Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀␒～",
	}, { // 902
		mask: EncodePipe | EncodeLeftTilde,
		in:   "～\x04Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀␒～",
		out:  "‛～\x04Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀␒～",
	}, { // 903
		mask: EncodePipe | EncodeLeftTilde,
		in:   "β~Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀␒<",
		out:  "β~Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀␒<",
	}, { // 904
		mask: EncodePipe | EncodeLeftTilde,
		in:   "β～Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀␒<",
		out:  "β～Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀␒<",
	}, { // 905
		mask: EncodePipe | EncodeLeftTilde,
		in:   "β~Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀～<",
		out:  "β~Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀～<",
	}, { // 906
		mask: EncodePipe | EncodeLeftTilde,
		in:   "β～Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀～<",
		out:  "β～Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀～<",
	}, { // 907
		mask: EncodePipe | EncodeLeftTilde,
		in:   "β~Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀␒～",
		out:  "β~Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀␒～",
	}, { // 908
		mask: EncodePipe | EncodeLeftTilde,
		in:   "β～Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀␒～",
		out:  "β～Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀␒～",
	}, { // 909
		mask: EncodePipe | EncodeLeftTilde,
		in:   "β\x04Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀~<",
		out:  "β\x04Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀~<",
	}, { // 910
		mask: EncodePipe | EncodeLeftTilde,
		in:   "β\x04Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀～<",
		out:  "β\x04Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀～<",
	}, { // 911
		mask: EncodePipe | EncodeLeftTilde,
		in:   "β\x04Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀~～",
		out:  "β\x04Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀~～",
	}, { // 912
		mask: EncodePipe | EncodeLeftTilde,
		in:   "β\x04Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀～～",
		out:  "β\x04Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀～～",
	}, { // 913
		mask: EncodePipe | EncodeLeftTilde,
		in:   "β\x04Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀␒~",
		out:  "β\x04Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀␒~",
	}, { // 914
		mask: EncodePipe | EncodeLeftTilde,
		in:   "β\x04Ｖ?οη\r\x03 ε~｜VG␊σε␝３％|␚F＞|Ｅ!␀␒～",
		out:  "β\x04Ｖ?οη\r\x03 ε~‛｜VG␊σε␝３％｜␚F＞｜Ｅ!‛␀␒～",
	}, { // 915
		mask: EncodeHash | EncodeLeftTilde,
		in:   "#␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5\x1f",
		out:  "＃␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5\x1f",
	}, { // 916
		mask: EncodeHash | EncodeLeftTilde,
		in:   "~～）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5\x1f",
		out:  "～～）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5\x1f",
	}, { // 917
		mask: EncodeHash | EncodeLeftTilde,
		in:   "～～）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5\x1f",
		out:  "‛～～）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5\x1f",
	}, { // 918
		mask: EncodeHash | EncodeLeftTilde,
		in:   "~␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ～\x1f",
		out:  "～␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ～\x1f",
	}, { // 919
		mask: EncodeHash | EncodeLeftTilde,
		in:   "～␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ～\x1f",
		out:  "‛～␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ～\x1f",
	}, { // 920
		mask: EncodeHash | EncodeLeftTilde,
		in:   "~␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5～",
		out:  "～␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5～",
	}, { // 921
		mask: EncodeHash | EncodeLeftTilde,
		in:   "～␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5～",
		out:  "‛～␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5～",
	}, { // 922
		mask: EncodeHash | EncodeLeftTilde,
		in:   "#~）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5\x1f",
		out:  "＃~）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5\x1f",
	}, { // 923
		mask: EncodeHash | EncodeLeftTilde,
		in:   "#～）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5\x1f",
		out:  "＃～）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5\x1f",
	}, { // 924
		mask: EncodeHash | EncodeLeftTilde,
		in:   "#~）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ～\x1f",
		out:  "＃~）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ～\x1f",
	}, { // 925
		mask: EncodeHash | EncodeLeftTilde,
		in:   "#～）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ～\x1f",
		out:  "＃～）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ～\x1f",
	}, { // 926
		mask: EncodeHash | EncodeLeftTilde,
		in:   "#~）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5～",
		out:  "＃~）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5～",
	}, { // 927
		mask: EncodeHash | EncodeLeftTilde,
		in:   "#～）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5～",
		out:  "＃～）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5～",
	}, { // 928
		mask: EncodeHash | EncodeLeftTilde,
		in:   "#␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ~\x1f",
		out:  "＃␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ~\x1f",
	}, { // 929
		mask: EncodeHash | EncodeLeftTilde,
		in:   "#␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ～\x1f",
		out:  "＃␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ～\x1f",
	}, { // 930
		mask: EncodeHash | EncodeLeftTilde,
		in:   "#␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ~～",
		out:  "＃␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ~～",
	}, { // 931
		mask: EncodeHash | EncodeLeftTilde,
		in:   "#␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ～～",
		out:  "＃␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ～～",
	}, { // 932
		mask: EncodeHash | EncodeLeftTilde,
		in:   "#␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5~",
		out:  "＃␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5~",
	}, { // 933
		mask: EncodeHash | EncodeLeftTilde,
		in:   "#␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5～",
		out:  "＃␡）γβ␃θ＇\x19５~ν\x1d\x0e␍h１2ｊFｚ␋h\x0fτ␈:Ｒ5～",
	}, { // 934
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Ｘ␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκζ",
		out:  "Ｘ␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκζ",
	}, { // 935
		mask: EncodePercent | EncodeLeftTilde,
		in:   "~～ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκζ",
		out:  "～～ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκζ",
	}, { // 936
		mask: EncodePercent | EncodeLeftTilde,
		in:   "～～ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκζ",
		out:  "‛～～ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκζ",
	}, { // 937
		mask: EncodePercent | EncodeLeftTilde,
		in:   "~␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖W～ζ",
		out:  "～␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖W～ζ",
	}, { // 938
		mask: EncodePercent | EncodeLeftTilde,
		in:   "～␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖W～ζ",
		out:  "‛～␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖W～ζ",
	}, { // 939
		mask: EncodePercent | EncodeLeftTilde,
		in:   "~␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκ～",
		out:  "～␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκ～",
	}, { // 940
		mask: EncodePercent | EncodeLeftTilde,
		in:   "～␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκ～",
		out:  "‛～␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκ～",
	}, { // 941
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Ｘ~ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκζ",
		out:  "Ｘ~ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκζ",
	}, { // 942
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Ｘ～ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκζ",
		out:  "Ｘ～ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκζ",
	}, { // 943
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Ｘ~ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖W～ζ",
		out:  "Ｘ~ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖W～ζ",
	}, { // 944
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Ｘ～ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖W～ζ",
		out:  "Ｘ～ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖W～ζ",
	}, { // 945
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Ｘ~ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκ～",
		out:  "Ｘ~ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκ～",
	}, { // 946
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Ｘ～ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκ～",
		out:  "Ｘ～ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκ～",
	}, { // 947
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Ｘ␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖W~ζ",
		out:  "Ｘ␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖W~ζ",
	}, { // 948
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Ｘ␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖W～ζ",
		out:  "Ｘ␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖W～ζ",
	}, { // 949
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Ｘ␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖W~～",
		out:  "Ｘ␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖W~～",
	}, { // 950
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Ｘ␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖W～～",
		out:  "Ｘ␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖W～～",
	}, { // 951
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Ｘ␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκ~",
		out:  "Ｘ␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκ~",
	}, { // 952
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Ｘ␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκ～",
		out:  "Ｘ␍ａｆ\"＇I␞＋＄~9\x1d＞$\n\x1f\x18τ\rοο␈(ＷD␖Wκ～",
	}, { // 953
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "？τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(R｛",
		out:  "？τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(R｛",
	}, { // 954
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "~～＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(R｛",
		out:  "～～＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(R｛",
	}, { // 955
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "～～＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(R｛",
		out:  "‛～～＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(R｛",
	}, { // 956
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "~τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(～｛",
		out:  "～τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(～｛",
	}, { // 957
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "～τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(～｛",
		out:  "‛～τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(～｛",
	}, { // 958
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "~τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(R～",
		out:  "～τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(R～",
	}, { // 959
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "～τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(R～",
		out:  "‛～τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(R～",
	}, { // 960
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "？~＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(R｛",
		out:  "？~＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(R｛",
	}, { // 961
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "？～＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(R｛",
		out:  "？～＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(R｛",
	}, { // 962
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "？~＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(～｛",
		out:  "？~＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(～｛",
	}, { // 963
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "？～＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(～｛",
		out:  "？～＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(～｛",
	}, { // 964
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "？~＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(R～",
		out:  "？~＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(R～",
	}, { // 965
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "？～＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(R～",
		out:  "？～＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(R～",
	}, { // 966
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "？τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(~｛",
		out:  "？τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(~｛",
	}, { // 967
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "？τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(～｛",
		out:  "？τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(～｛",
	}, { // 968
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "？τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(~～",
		out:  "？τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(~～",
	}, { // 969
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "？τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(～～",
		out:  "？τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(～～",
	}, { // 970
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "？τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(R~",
		out:  "？τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(R~",
	}, { // 971
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "？τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b\x00χ(R～",
		out:  "？τ＇␜␒ｑ\"\x13=Z~D␖'[Ｕπχ␝\u007fλ３ｙν\b␀χ(R～",
	}, { // 972
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "μ：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:J",
		out:  "μ：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:J",
	}, { // 973
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "~～］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:J",
		out:  "～～］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:J",
	}, { // 974
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "～～］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:J",
		out:  "‛～～］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:J",
	}, { // 975
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "~：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]～J",
		out:  "～：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]～J",
	}, { // 976
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "～：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]～J",
		out:  "‛～：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]～J",
	}, { // 977
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "~：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:～",
		out:  "～：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:～",
	}, { // 978
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "～：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:～",
		out:  "‛～：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:～",
	}, { // 979
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "μ~］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:J",
		out:  "μ~］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:J",
	}, { // 980
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "μ～］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:J",
		out:  "μ～］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:J",
	}, { // 981
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "μ~］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]～J",
		out:  "μ~］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]～J",
	}, { // 982
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "μ～］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]～J",
		out:  "μ～］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]～J",
	}, { // 983
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "μ~］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:～",
		out:  "μ~］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:～",
	}, { // 984
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "μ～］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:～",
		out:  "μ～］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:～",
	}, { // 985
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "μ：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]~J",
		out:  "μ：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]~J",
	}, { // 986
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "μ：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]～J",
		out:  "μ：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]～J",
	}, { // 987
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "μ：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]~～",
		out:  "μ：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]~～",
	}, { // 988
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "μ：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]～～",
		out:  "μ：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]～～",
	}, { // 989
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "μ：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:~",
		out:  "μ：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:~",
	}, { // 990
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "μ：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:～",
		out:  "μ：］Ｕβｄσ＋\a␈~ｕπＰ-␞q*␁χ\x0eω<␄␋F\x18]:～",
	}, { // 991
		mask: EncodeDel | EncodeLeftTilde,
		in:   "k␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ[",
		out:  "k␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ[",
	}, { // 992
		mask: EncodeDel | EncodeLeftTilde,
		in:   "~～\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ[",
		out:  "～～\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ[",
	}, { // 993
		mask: EncodeDel | EncodeLeftTilde,
		in:   "～～\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ[",
		out:  "‛～～\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ[",
	}, { // 994
		mask: EncodeDel | EncodeLeftTilde,
		in:   "~␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#～[",
		out:  "～␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#～[",
	}, { // 995
		mask: EncodeDel | EncodeLeftTilde,
		in:   "～␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#～[",
		out:  "‛～␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#～[",
	}, { // 996
		mask: EncodeDel | EncodeLeftTilde,
		in:   "~␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ～",
		out:  "～␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ～",
	}, { // 997
		mask: EncodeDel | EncodeLeftTilde,
		in:   "～␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ～",
		out:  "‛～␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ～",
	}, { // 998
		mask: EncodeDel | EncodeLeftTilde,
		in:   "k~\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ[",
		out:  "k~\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ[",
	}, { // 999
		mask: EncodeDel | EncodeLeftTilde,
		in:   "k～\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ[",
		out:  "k～\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ[",
	}, { // 1000
		mask: EncodeDel | EncodeLeftTilde,
		in:   "k~\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#～[",
		out:  "k~\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#～[",
	}, { // 1001
		mask: EncodeDel | EncodeLeftTilde,
		in:   "k～\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#～[",
		out:  "k～\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#～[",
	}, { // 1002
		mask: EncodeDel | EncodeLeftTilde,
		in:   "k~\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ～",
		out:  "k~\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ～",
	}, { // 1003
		mask: EncodeDel | EncodeLeftTilde,
		in:   "k～\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ～",
		out:  "k～\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ～",
	}, { // 1004
		mask: EncodeDel | EncodeLeftTilde,
		in:   "k␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#~[",
		out:  "k␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#~[",
	}, { // 1005
		mask: EncodeDel | EncodeLeftTilde,
		in:   "k␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#～[",
		out:  "k␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#～[",
	}, { // 1006
		mask: EncodeDel | EncodeLeftTilde,
		in:   "k␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#~～",
		out:  "k␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#~～",
	}, { // 1007
		mask: EncodeDel | EncodeLeftTilde,
		in:   "k␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#～～",
		out:  "k␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#～～",
	}, { // 1008
		mask: EncodeDel | EncodeLeftTilde,
		in:   "k␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ~",
		out:  "k␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ~",
	}, { // 1009
		mask: EncodeDel | EncodeLeftTilde,
		in:   "k␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ～",
		out:  "k␔\x1d␃\x02ψ－␍%α~f\a␑Ｄ\x18νyι０ς｛｜c：␊D#σ～",
	}, { // 1010
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x1a\x10ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ␗<",
		out:  "␚␐ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ‛␗<",
	}, { // 1011
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "~～ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ␗<",
		out:  "～～ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ‛␗<",
	}, { // 1012
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "～～ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ␗<",
		out:  "‛～～ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ‛␗<",
	}, { // 1013
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "~\x10ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ～<",
		out:  "～␐ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ～<",
	}, { // 1014
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "～\x10ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ～<",
		out:  "‛～␐ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ～<",
	}, { // 1015
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "~\x10ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ␗～",
		out:  "～␐ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ‛␗～",
	}, { // 1016
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "～\x10ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ␗～",
		out:  "‛～␐ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ‛␗～",
	}, { // 1017
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x1a~ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ␗<",
		out:  "␚~ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ‛␗<",
	}, { // 1018
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x1a～ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ␗<",
		out:  "␚～ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ‛␗<",
	}, { // 1019
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x1a~ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ～<",
		out:  "␚~ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ～<",
	}, { // 1020
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x1a～ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ～<",
		out:  "␚～ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ～<",
	}, { // 1021
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x1a~ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ␗～",
		out:  "␚~ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ‛␗～",
	}, { // 1022
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x1a～ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ␗～",
		out:  "␚～ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ‛␗～",
	}, { // 1023
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x1a\x10ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ~<",
		out:  "␚␐ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ~<",
	}, { // 1024
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x1a\x10ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ～<",
		out:  "␚␐ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ～<",
	}, { // 1025
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x1a\x10ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ~～",
		out:  "␚␐ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ~～",
	}, { // 1026
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x1a\x10ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ～～",
		out:  "␚␐ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ～～",
	}, { // 1027
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x1a\x10ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ␗~",
		out:  "␚␐ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ‛␗~",
	}, { // 1028
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x1a\x10ρＣＦWＷ－␙＇~␏%\x06ｃ@8z*Uυρζβ␕␃／ρ␗～",
		out:  "␚␐ρＣＦWＷ－‛␙＇~‛␏%␆ｃ@8z*Uυρζβ‛␕‛␃／ρ‛␗～",
	}, { // 1029
		mask: EncodeLeftCrLfHtVt,
		in:   "\t",
		out:  "␉",
	}, { // 1030
		mask: EncodeLeftCrLfHtVt,
		in:   "\n",
		out:  "␊",
	}, { // 1031
		mask: EncodeLeftCrLfHtVt,
		in:   "\v",
		out:  "␋",
	}, { // 1032
		mask: EncodeLeftCrLfHtVt,
		in:   "\r",
		out:  "␍",
	}, { // 1033
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "jＷ\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␟␝",
		out:  "jＷ\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␟␝",
	}, { // 1034
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\t␉\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␟␝",
		out:  "␉␉\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␟␝",
	}, { // 1035
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␉␉\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␟␝",
		out:  "‛␉␉\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␟␝",
	}, { // 1036
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\tＷ\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␉␝",
		out:  "␉Ｗ\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␉␝",
	}, { // 1037
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␉Ｗ\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␉␝",
		out:  "‛␉Ｗ\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␉␝",
	}, { // 1038
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\tＷ\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␟␉",
		out:  "␉Ｗ\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␟␉",
	}, { // 1039
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␉Ｗ\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␟␉",
		out:  "‛␉Ｗ\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␟␉",
	}, { // 1040
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "j\t\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␟␝",
		out:  "j\t\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␟␝",
	}, { // 1041
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "j␉\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␟␝",
		out:  "j␉\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␟␝",
	}, { // 1042
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "j\t\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␉␝",
		out:  "j\t\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␉␝",
	}, { // 1043
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "j␉\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␉␝",
		out:  "j␉\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␉␝",
	}, { // 1044
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "j\t\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␟␉",
		out:  "j\t\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␟␉",
	}, { // 1045
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "j␉\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␟␉",
		out:  "j␉\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␟␉",
	}, { // 1046
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "jＷ\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗\t␝",
		out:  "jＷ\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗\t␝",
	}, { // 1047
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "jＷ\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␉␝",
		out:  "jＷ\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␉␝",
	}, { // 1048
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "jＷ\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗\t␉",
		out:  "jＷ\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗\t␉",
	}, { // 1049
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "jＷ\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␉␉",
		out:  "jＷ\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␉␉",
	}, { // 1050
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "jＷ\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␟\t",
		out:  "jＷ\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␟\t",
	}, { // 1051
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "jＷ\x06\"ω\x19ｚν\x0eγ\t；＼␀xς７␜D␍a[/τ,|ρ␗␟␉",
		out:  "jＷ\x06\"ω\x19ｚν\x0eγ\t；＼‛␀xς７␜D␍a[/τ,|ρ␗␟␉",
	}, { // 1052
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␄κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％Ｑ",
		out:  "␄κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％Ｑ",
	}, { // 1053
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\n␊0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％Ｑ",
		out:  "␊␊0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％Ｑ",
	}, { // 1054
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␊␊0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％Ｑ",
		out:  "‛␊␊0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％Ｑ",
	}, { // 1055
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\nκ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c␊Ｑ",
		out:  "␊κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c␊Ｑ",
	}, { // 1056
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␊κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c␊Ｑ",
		out:  "‛␊κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c␊Ｑ",
	}, { // 1057
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\nκ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％␊",
		out:  "␊κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％␊",
	}, { // 1058
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␊κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％␊",
		out:  "‛␊κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％␊",
	}, { // 1059
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␄\n0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％Ｑ",
		out:  "␄\n0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％Ｑ",
	}, { // 1060
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␄␊0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％Ｑ",
		out:  "␄␊0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％Ｑ",
	}, { // 1061
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␄\n0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c␊Ｑ",
		out:  "␄\n0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c␊Ｑ",
	}, { // 1062
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␄␊0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c␊Ｑ",
		out:  "␄␊0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c␊Ｑ",
	}, { // 1063
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␄\n0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％␊",
		out:  "␄\n0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％␊",
	}, { // 1064
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␄␊0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％␊",
		out:  "␄␊0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％␊",
	}, { // 1065
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␄κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c\nＱ",
		out:  "␄κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c\nＱ",
	}, { // 1066
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␄κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c␊Ｑ",
		out:  "␄κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c␊Ｑ",
	}, { // 1067
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␄κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c\n␊",
		out:  "␄κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c\n␊",
	}, { // 1068
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␄κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c␊␊",
		out:  "␄κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c␊␊",
	}, { // 1069
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␄κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％\n",
		out:  "␄κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％\n",
	}, { // 1070
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␄κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％␊",
		out:  "␄κ0^φ\n*＃υ\x05\n[［θｘ␁μ␎；a\"χS#␝ａＬ\x1c％␊",
	}, { // 1071
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "xU＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍＜",
		out:  "xU＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍＜",
	}, { // 1072
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\v␋＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍＜",
		out:  "␋␋＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍＜",
	}, { // 1073
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␋␋＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍＜",
		out:  "‛␋␋＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍＜",
	}, { // 1074
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\vU＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␋＜",
		out:  "␋U＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␋＜",
	}, { // 1075
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␋U＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␋＜",
		out:  "‛␋U＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␋＜",
	}, { // 1076
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\vU＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍␋",
		out:  "␋U＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍␋",
	}, { // 1077
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␋U＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍␋",
		out:  "‛␋U＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍␋",
	}, { // 1078
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "x\v＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍＜",
		out:  "x\v＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍＜",
	}, { // 1079
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "x␋＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍＜",
		out:  "x␋＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍＜",
	}, { // 1080
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "x\v＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␋＜",
		out:  "x\v＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␋＜",
	}, { // 1081
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "x␋＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␋＜",
		out:  "x␋＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␋＜",
	}, { // 1082
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "x\v＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍␋",
		out:  "x\v＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍␋",
	}, { // 1083
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "x␋＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍␋",
		out:  "x␋＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍␋",
	}, { // 1084
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "xU＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］\v＜",
		out:  "xU＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］\v＜",
	}, { // 1085
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "xU＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␋＜",
		out:  "xU＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␋＜",
	}, { // 1086
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "xU＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］\v␋",
		out:  "xU＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］\v␋",
	}, { // 1087
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "xU＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␋␋",
		out:  "xU＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␋␋",
	}, { // 1088
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "xU＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍\v",
		out:  "xU＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍\v",
	}, { // 1089
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "xU＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍␋",
		out:  "xU＃δψ␇ηπ＠τ\v`\t!\x15＊ｂ\b＼␜|\x1dｅx\r\x03＿］␍␋",
	}, { // 1090
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ｎ3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ\\",
		out:  "ｎ3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ\\",
	}, { // 1091
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\r␍/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ\\",
		out:  "␍␍/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ\\",
	}, { // 1092
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␍␍/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ\\",
		out:  "‛␍␍/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ\\",
	}, { // 1093
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\r3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？␍\\",
		out:  "␍3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？␍\\",
	}, { // 1094
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␍3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？␍\\",
		out:  "‛␍3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？␍\\",
	}, { // 1095
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\r3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ␍",
		out:  "␍3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ␍",
	}, { // 1096
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␍3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ␍",
		out:  "‛␍3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ␍",
	}, { // 1097
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ｎ\r/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ\\",
		out:  "ｎ\r/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ\\",
	}, { // 1098
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ｎ␍/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ\\",
		out:  "ｎ␍/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ\\",
	}, { // 1099
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ｎ\r/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？␍\\",
		out:  "ｎ\r/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？␍\\",
	}, { // 1100
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ｎ␍/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？␍\\",
		out:  "ｎ␍/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？␍\\",
	}, { // 1101
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ｎ\r/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ␍",
		out:  "ｎ\r/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ␍",
	}, { // 1102
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ｎ␍/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ␍",
		out:  "ｎ␍/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ␍",
	}, { // 1103
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ｎ3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？\r\\",
		out:  "ｎ3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？\r\\",
	}, { // 1104
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ｎ3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？␍\\",
		out:  "ｎ3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？␍\\",
	}, { // 1105
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ｎ3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？\r␍",
		out:  "ｎ3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？\r␍",
	}, { // 1106
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ｎ3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？␍␍",
		out:  "ｎ3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？␍␍",
	}, { // 1107
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ｎ3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ\r",
		out:  "ｎ3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ\r",
	}, { // 1108
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ｎ3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ␍",
		out:  "ｎ3/Ohπσ]ｙ␇\r'λ３\x14LＦ-ＬＯ␆␋τ\x1c␔\\␂？τ␍",
	}, { // 1109
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ｑ[\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（'η",
		out:  "ｑ[\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（'η",
	}, { // 1110
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t␉\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（'η",
		out:  "␉␉\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（'η",
	}, { // 1111
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␉␉\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（'η",
		out:  "‛␉␉\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（'η",
	}, { // 1112
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t[\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（␉η",
		out:  "␉[\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（␉η",
	}, { // 1113
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␉[\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（␉η",
		out:  "‛␉[\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（␉η",
	}, { // 1114
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t[\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（'␉",
		out:  "␉[\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（'␉",
	}, { // 1115
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␉[\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（'␉",
		out:  "‛␉[\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（'␉",
	}, { // 1116
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ｑ\t\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（'η",
		out:  "ｑ\t\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（'η",
	}, { // 1117
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ｑ␉\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（'η",
		out:  "ｑ␉\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（'η",
	}, { // 1118
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ｑ\t\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（␉η",
		out:  "ｑ\t\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（␉η",
	}, { // 1119
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ｑ␉\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（␉η",
		out:  "ｑ␉\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（␉η",
	}, { // 1120
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ｑ\t\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（'␉",
		out:  "ｑ\t\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（'␉",
	}, { // 1121
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ｑ␉\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（'␉",
		out:  "ｑ␉\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（'␉",
	}, { // 1122
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ｑ[\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（\tη",
		out:  "ｑ[\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（\tη",
	}, { // 1123
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ｑ[\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（␉η",
		out:  "ｑ[\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（␉η",
	}, { // 1124
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ｑ[\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（\t␉",
		out:  "ｑ[\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（\t␉",
	}, { // 1125
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ｑ[\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（␉␉",
		out:  "ｑ[\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（␉␉",
	}, { // 1126
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ｑ[\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（'\t",
		out:  "ｑ[\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（'\t",
	}, { // 1127
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ｑ[\x13λ[$／ε␕<\t\r＇Gε␇？＇␊:\x14\x00ｖ␋ｚ/η（'␉",
		out:  "ｑ[\x13λ[$‛／ε␕<\t\r＇Gε␇？＇␊:\x14␀ｖ␋ｚ／η（'␉",
	}, { // 1128
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "σ］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13？",
		out:  "σ］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13？",
	}, { // 1129
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\n␊␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13？",
		out:  "␊␊␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13？",
	}, { // 1130
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␊␊␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13？",
		out:  "‛␊␊␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13？",
	}, { // 1131
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\n］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04␊？",
		out:  "␊］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04␊？",
	}, { // 1132
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␊］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04␊？",
		out:  "‛␊］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04␊？",
	}, { // 1133
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\n］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13␊",
		out:  "␊］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13␊",
	}, { // 1134
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␊］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13␊",
		out:  "‛␊］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13␊",
	}, { // 1135
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "σ\n␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13？",
		out:  "σ\n␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13？",
	}, { // 1136
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "σ␊␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13？",
		out:  "σ␊␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13？",
	}, { // 1137
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "σ\n␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04␊？",
		out:  "σ\n␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04␊？",
	}, { // 1138
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "σ␊␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04␊？",
		out:  "σ␊␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04␊？",
	}, { // 1139
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "σ\n␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13␊",
		out:  "σ\n␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13␊",
	}, { // 1140
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "σ␊␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13␊",
		out:  "σ␊␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13␊",
	}, { // 1141
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "σ］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\n？",
		out:  "σ］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\n？",
	}, { // 1142
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "σ］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04␊？",
		out:  "σ］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04␊？",
	}, { // 1143
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "σ］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\n␊",
		out:  "σ］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\n␊",
	}, { // 1144
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "σ］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04␊␊",
		out:  "σ］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04␊␊",
	}, { // 1145
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "σ］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13\n",
		out:  "σ］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13\n",
	}, { // 1146
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "σ］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13␊",
		out:  "σ］␊ｕψ\x04\\!\\π\n８d{␐␓＆?ξρ␉f>ξ<␊ｔ\x04\x13␊",
	}, { // 1147
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ξ\u007f7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,ｆ",
		out:  "ξ\u007f7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,ｆ",
	}, { // 1148
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\v␋7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,ｆ",
		out:  "␋␋7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,ｆ",
	}, { // 1149
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␋␋7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,ｆ",
		out:  "‛␋␋7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,ｆ",
	}, { // 1150
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\v\u007f7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ␋ｆ",
		out:  "␋\u007f7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ␋ｆ",
	}, { // 1151
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␋\u007f7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ␋ｆ",
		out:  "‛␋\u007f7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ␋ｆ",
	}, { // 1152
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\v\u007f7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,␋",
		out:  "␋\u007f7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,␋",
	}, { // 1153
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␋\u007f7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,␋",
		out:  "‛␋\u007f7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,␋",
	}, { // 1154
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ξ\v7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,ｆ",
		out:  "ξ\v7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,ｆ",
	}, { // 1155
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ξ␋7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,ｆ",
		out:  "ξ␋7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,ｆ",
	}, { // 1156
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ξ\v7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ␋ｆ",
		out:  "ξ\v7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ␋ｆ",
	}, { // 1157
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ξ␋7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ␋ｆ",
		out:  "ξ␋7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ␋ｆ",
	}, { // 1158
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ξ\v7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,␋",
		out:  "ξ\v7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,␋",
	}, { // 1159
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ξ␋7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,␋",
		out:  "ξ␋7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,␋",
	}, { // 1160
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ξ\u007f7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ\vｆ",
		out:  "ξ\u007f7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ\vｆ",
	}, { // 1161
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ξ\u007f7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ␋ｆ",
		out:  "ξ\u007f7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ␋ｆ",
	}, { // 1162
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ξ\u007f7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ\v␋",
		out:  "ξ\u007f7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ\v␋",
	}, { // 1163
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ξ\u007f7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ␋␋",
		out:  "ξ\u007f7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ␋␋",
	}, { // 1164
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ξ\u007f7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,\v",
		out:  "ξ\u007f7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,\v",
	}, { // 1165
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ξ\u007f7η;\x00θＴ\x00_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,␋",
		out:  "ξ\u007f7η;␀θＴ␀_\v␈?＄？ｌＷ␍＄z?\x15.｜κＢ␔κ,␋",
	}, { // 1166
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "}\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：＜",
		out:  "}\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：＜",
	}, { // 1167
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\r␍|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：＜",
		out:  "␍␍|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：＜",
	}, { // 1168
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␍␍|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：＜",
		out:  "‛␍␍|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：＜",
	}, { // 1169
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\r\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜␍＜",
		out:  "␍\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜␍＜",
	}, { // 1170
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␍\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜␍＜",
		out:  "‛␍\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜␍＜",
	}, { // 1171
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\r\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：␍",
		out:  "␍\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：␍",
	}, { // 1172
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␍\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：␍",
		out:  "‛␍\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：␍",
	}, { // 1173
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "}\r|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：＜",
		out:  "}\r|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：＜",
	}, { // 1174
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "}␍|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：＜",
		out:  "}␍|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：＜",
	}, { // 1175
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "}\r|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜␍＜",
		out:  "}\r|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜␍＜",
	}, { // 1176
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "}␍|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜␍＜",
		out:  "}␍|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜␍＜",
	}, { // 1177
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "}\r|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：␍",
		out:  "}\r|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：␍",
	}, { // 1178
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "}␍|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：␍",
		out:  "}␍|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：␍",
	}, { // 1179
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "}\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜\r＜",
		out:  "}\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜\r＜",
	}, { // 1180
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "}\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜␍＜",
		out:  "}\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜␍＜",
	}, { // 1181
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "}\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜\r␍",
		out:  "}\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜\r␍",
	}, { // 1182
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "}\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜␍␍",
		out:  "}\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜␍␍",
	}, { // 1183
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "}\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：\r",
		out:  "}\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：\r",
	}, { // 1184
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "}\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：␍",
		out:  "}\v|ε＿ｕ\"Ｙ\x12γ\rτ␅U9ｊ)πψ＃]？a\x1a␍'υ＜：␍",
	}, { // 1185
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\a\u007f＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ?:",
		out:  "\a\u007f＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ?:",
	}, { // 1186
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\t␉＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ?:",
		out:  "␉␉＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ?:",
	}, { // 1187
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␉␉＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ?:",
		out:  "‛␉␉＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ?:",
	}, { // 1188
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\t\u007f＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ␉:",
		out:  "␉\u007f＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ␉:",
	}, { // 1189
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␉\u007f＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ␉:",
		out:  "‛␉\u007f＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ␉:",
	}, { // 1190
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\t\u007f＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ?␉",
		out:  "␉\u007f＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ?␉",
	}, { // 1191
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␉\u007f＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ?␉",
		out:  "‛␉\u007f＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ?␉",
	}, { // 1192
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\a\t＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ?:",
		out:  "\a\t＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ?:",
	}, { // 1193
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\a␉＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ?:",
		out:  "\a␉＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ?:",
	}, { // 1194
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\a\t＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ␉:",
		out:  "\a\t＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ␉:",
	}, { // 1195
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\a␉＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ␉:",
		out:  "\a␉＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ␉:",
	}, { // 1196
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\a\t＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ?␉",
		out:  "\a\t＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ?␉",
	}, { // 1197
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\a␉＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ?␉",
		out:  "\a␉＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ?␉",
	}, { // 1198
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\a\u007f＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ\t:",
		out:  "\a\u007f＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ\t:",
	}, { // 1199
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\a\u007f＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ␉:",
		out:  "\a\u007f＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ␉:",
	}, { // 1200
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\a\u007f＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ\t␉",
		out:  "\a\u007f＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ\t␉",
	}, { // 1201
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\a\u007f＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ␉␉",
		out:  "\a\u007f＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ␉␉",
	}, { // 1202
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\a\u007f＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ?\t",
		out:  "\a\u007f＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ?\t",
	}, { // 1203
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\a\u007f＞η␇\"μ*＇␍\t␐Ｃbγ＇ι=πφVQH\x16Ｒ␡␏Ｕ?␉",
		out:  "\a\u007f＞η␇\"μ*‛＇␍\t␐Ｃbγ‛＇ι=πφVQH\x16Ｒ␡␏Ｕ?␉",
	}, { // 1204
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "κ'ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f/",
		out:  "κ＇ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f/",
	}, { // 1205
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\n␊ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f/",
		out:  "␊␊ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f/",
	}, { // 1206
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␊␊ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f/",
		out:  "‛␊␊ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f/",
	}, { // 1207
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\n'ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕␊/",
		out:  "␊＇ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕␊/",
	}, { // 1208
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␊'ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕␊/",
		out:  "‛␊＇ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕␊/",
	}, { // 1209
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\n'ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f␊",
		out:  "␊＇ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f␊",
	}, { // 1210
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␊'ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f␊",
		out:  "‛␊＇ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f␊",
	}, { // 1211
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "κ\nｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f/",
		out:  "κ\nｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f/",
	}, { // 1212
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "κ␊ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f/",
		out:  "κ␊ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f/",
	}, { // 1213
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "κ\nｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕␊/",
		out:  "κ\nｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕␊/",
	}, { // 1214
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "κ␊ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕␊/",
		out:  "κ␊ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕␊/",
	}, { // 1215
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "κ\nｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f␊",
		out:  "κ\nｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f␊",
	}, { // 1216
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "κ␊ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f␊",
		out:  "κ␊ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f␊",
	}, { // 1217
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "κ'ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\n/",
		out:  "κ＇ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\n/",
	}, { // 1218
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "κ'ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕␊/",
		out:  "κ＇ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕␊/",
	}, { // 1219
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "κ'ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\n␊",
		out:  "κ＇ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\n␊",
	}, { // 1220
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "κ'ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕␊␊",
		out:  "κ＇ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕␊␊",
	}, { // 1221
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "κ'ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f\n",
		out:  "κ＇ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f\n",
	}, { // 1222
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "κ'ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f␊",
		out:  "κ＇ｕ１␌/ｋψ\rς\nH6Ｍｏπ＜Z␆ａθ␑;m\x05␙υ␕\u007f␊",
	}, { // 1223
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｈ␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//eａ",
		out:  "Ｈ␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//eａ",
	}, { // 1224
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\v␋＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//eａ",
		out:  "␋␋＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//eａ",
	}, { // 1225
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␋␋＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//eａ",
		out:  "‛␋␋＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//eａ",
	}, { // 1226
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\v␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//␋ａ",
		out:  "␋␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//␋ａ",
	}, { // 1227
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␋␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//␋ａ",
		out:  "‛␋␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//␋ａ",
	}, { // 1228
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\v␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//e␋",
		out:  "␋␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//e␋",
	}, { // 1229
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␋␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//e␋",
		out:  "‛␋␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//e␋",
	}, { // 1230
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｈ\v＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//eａ",
		out:  "Ｈ\v＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//eａ",
	}, { // 1231
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｈ␋＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//eａ",
		out:  "Ｈ␋＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//eａ",
	}, { // 1232
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｈ\v＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//␋ａ",
		out:  "Ｈ\v＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//␋ａ",
	}, { // 1233
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｈ␋＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//␋ａ",
		out:  "Ｈ␋＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//␋ａ",
	}, { // 1234
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｈ\v＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//e␋",
		out:  "Ｈ\v＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//e␋",
	}, { // 1235
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｈ␋＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//e␋",
		out:  "Ｈ␋＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//e␋",
	}, { // 1236
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｈ␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//\vａ",
		out:  "Ｈ␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//\vａ",
	}, { // 1237
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｈ␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//␋ａ",
		out:  "Ｈ␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//␋ａ",
	}, { // 1238
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｈ␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//\v␋",
		out:  "Ｈ␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//\v␋",
	}, { // 1239
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｈ␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//␋␋",
		out:  "Ｈ␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//␋␋",
	}, { // 1240
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｈ␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//e\v",
		out:  "Ｈ␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//e\v",
	}, { // 1241
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｈ␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//e␋",
		out:  "Ｈ␔＄＄Ｌ\x14\x10μ\r>\vVςχ\"γ2x：␏γ␇／␖␖φ//e␋",
	}, { // 1242
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␓\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ\x02",
		out:  "␓\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ\x02",
	}, { // 1243
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␍␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ\x02",
		out:  "␍␍␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ\x02",
	}, { // 1244
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␍␍␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ\x02",
		out:  "‛␍␍␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ\x02",
	}, { // 1245
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎t␍\x02",
		out:  "␍\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎t␍\x02",
	}, { // 1246
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␍\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎t␍\x02",
		out:  "‛␍\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎t␍\x02",
	}, { // 1247
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ␍",
		out:  "␍\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ␍",
	}, { // 1248
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␍\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ␍",
		out:  "‛␍\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ␍",
	}, { // 1249
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␓\r␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ\x02",
		out:  "␓\r␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ\x02",
	}, { // 1250
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␓␍␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ\x02",
		out:  "␓␍␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ\x02",
	}, { // 1251
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␓\r␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎t␍\x02",
		out:  "␓\r␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎t␍\x02",
	}, { // 1252
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␓␍␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎t␍\x02",
		out:  "␓␍␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎t␍\x02",
	}, { // 1253
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␓\r␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ␍",
		out:  "␓\r␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ␍",
	}, { // 1254
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␓␍␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ␍",
		out:  "␓␍␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ␍",
	}, { // 1255
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␓\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎t\r\x02",
		out:  "␓\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎t\r\x02",
	}, { // 1256
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␓\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎t␍\x02",
		out:  "␓\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎t␍\x02",
	}, { // 1257
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␓\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎t\r␍",
		out:  "␓\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎t\r␍",
	}, { // 1258
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␓\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎t␍␍",
		out:  "␓\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎t␍␍",
	}, { // 1259
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␓\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ\r",
		out:  "␓\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ\r",
	}, { // 1260
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␓\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ␍",
		out:  "␓\b␎<ξ␊)Ｃ:γ\rπ\tUh\x01␋ｗ｜Ｗσ\"x［λι␎tＶ␍",
	}, { // 1261
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\x14Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!μＱ",
		out:  "\x14Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!μＱ",
	}, { // 1262
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\t␉？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!μＱ",
		out:  "␉␉？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!μＱ",
	}, { // 1263
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␉␉？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!μＱ",
		out:  "‛␉␉？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!μＱ",
	}, { // 1264
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\tＷ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!␉Ｑ",
		out:  "␉Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!␉Ｑ",
	}, { // 1265
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␉Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!␉Ｑ",
		out:  "‛␉Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!␉Ｑ",
	}, { // 1266
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\tＷ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!μ␉",
		out:  "␉Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!μ␉",
	}, { // 1267
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␉Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!μ␉",
		out:  "‛␉Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!μ␉",
	}, { // 1268
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\x14\t？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!μＱ",
		out:  "\x14\t？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!μＱ",
	}, { // 1269
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\x14␉？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!μＱ",
		out:  "\x14␉？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!μＱ",
	}, { // 1270
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\x14\t？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!␉Ｑ",
		out:  "\x14\t？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!␉Ｑ",
	}, { // 1271
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\x14␉？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!␉Ｑ",
		out:  "\x14␉？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!␉Ｑ",
	}, { // 1272
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\x14\t？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!μ␉",
		out:  "\x14\t？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!μ␉",
	}, { // 1273
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\x14␉？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!μ␉",
		out:  "\x14␉？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!μ␉",
	}, { // 1274
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\x14Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!\tＱ",
		out:  "\x14Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!\tＱ",
	}, { // 1275
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\x14Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!␉Ｑ",
		out:  "\x14Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!␉Ｑ",
	}, { // 1276
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\x14Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!\t␉",
		out:  "\x14Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!\t␉",
	}, { // 1277
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\x14Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!␉␉",
		out:  "\x14Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!␉␉",
	}, { // 1278
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\x14Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!μ\t",
		out:  "\x14Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!μ\t",
	}, { // 1279
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\x14Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ\x00!μ␉",
		out:  "\x14Ｗ？V␇［]G\x1f|\tJDｍ\x1fnＳ＂］␇␕υπμκｚ␀!μ␉",
	}, { // 1280
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ｔγ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␕#",
		out:  "ｔγ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␕#",
	}, { // 1281
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\n␊\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␕#",
		out:  "␊␊\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␕#",
	}, { // 1282
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␊␊\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␕#",
		out:  "‛␊␊\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␕#",
	}, { // 1283
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\nγ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␊#",
		out:  "␊γ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␊#",
	}, { // 1284
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␊γ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␊#",
		out:  "‛␊γ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␊#",
	}, { // 1285
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\nγ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␕␊",
		out:  "␊γ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␕␊",
	}, { // 1286
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␊γ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␕␊",
		out:  "‛␊γ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␕␊",
	}, { // 1287
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ｔ\n\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␕#",
		out:  "ｔ\n\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␕#",
	}, { // 1288
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ｔ␊\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␕#",
		out:  "ｔ␊\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␕#",
	}, { // 1289
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ｔ\n\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␊#",
		out:  "ｔ\n\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␊#",
	}, { // 1290
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ｔ␊\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␊#",
		out:  "ｔ␊\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␊#",
	}, { // 1291
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ｔ\n\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␕␊",
		out:  "ｔ\n\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␕␊",
	}, { // 1292
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ｔ␊\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␕␊",
		out:  "ｔ␊\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␕␊",
	}, { // 1293
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ｔγ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；\n#",
		out:  "ｔγ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；\n#",
	}, { // 1294
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ｔγ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␊#",
		out:  "ｔγ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␊#",
	}, { // 1295
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ｔγ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；\n␊",
		out:  "ｔγ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；\n␊",
	}, { // 1296
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ｔγ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␊␊",
		out:  "ｔγ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␊␊",
	}, { // 1297
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ｔγ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␕\n",
		out:  "ｔγ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␕\n",
	}, { // 1298
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ｔγ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃␀␍οqοη␈U？；␕␊",
		out:  "ｔγ\"\x10μ\u007f．？?\x11\nhＧDFπ}␃‛␀␍οqοη␈U？；␕␊",
	}, { // 1299
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "τC␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*Ｒn",
		out:  "τC␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*Ｒn",
	}, { // 1300
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\v␋␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*Ｒn",
		out:  "␋␋␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*Ｒn",
	}, { // 1301
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␋␋␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*Ｒn",
		out:  "‛␋␋␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*Ｒn",
	}, { // 1302
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\vC␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*␋n",
		out:  "␋C␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*␋n",
	}, { // 1303
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␋C␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*␋n",
		out:  "‛␋C␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*␋n",
	}, { // 1304
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\vC␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*Ｒ␋",
		out:  "␋C␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*Ｒ␋",
	}, { // 1305
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␋C␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*Ｒ␋",
		out:  "‛␋C␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*Ｒ␋",
	}, { // 1306
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "τ\v␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*Ｒn",
		out:  "τ\v␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*Ｒn",
	}, { // 1307
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "τ␋␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*Ｒn",
		out:  "τ␋␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*Ｒn",
	}, { // 1308
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "τ\v␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*␋n",
		out:  "τ\v␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*␋n",
	}, { // 1309
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "τ␋␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*␋n",
		out:  "τ␋␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*␋n",
	}, { // 1310
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "τ\v␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*Ｒ␋",
		out:  "τ\v␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*Ｒ␋",
	}, { // 1311
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "τ␋␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*Ｒ␋",
		out:  "τ␋␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*Ｒ␋",
	}, { // 1312
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "τC␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*\vn",
		out:  "τC␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*\vn",
	}, { // 1313
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "τC␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*␋n",
		out:  "τC␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*␋n",
	}, { // 1314
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "τC␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*\v␋",
		out:  "τC␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*\v␋",
	}, { // 1315
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "τC␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*␋␋",
		out:  "τC␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*␋␋",
	}, { // 1316
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "τC␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*Ｒ\v",
		out:  "τC␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*Ｒ\v",
	}, { // 1317
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "τC␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆｀\x02*Ｒ␋",
		out:  "τC␇ＤιηIsJγ\vν／］␓／;θ\x1f：０\f|\x03＆‛｀\x02*Ｒ␋",
	}, { // 1318
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␔␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７％",
		out:  "␔␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７％",
	}, { // 1319
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\r␍i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７％",
		out:  "␍␍i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７％",
	}, { // 1320
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␍␍i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７％",
		out:  "‛␍␍i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７％",
	}, { // 1321
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\r␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"␍％",
		out:  "␍␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"␍％",
	}, { // 1322
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␍␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"␍％",
		out:  "‛␍␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"␍％",
	}, { // 1323
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\r␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７␍",
		out:  "␍␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７␍",
	}, { // 1324
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␍␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７␍",
		out:  "‛␍␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７␍",
	}, { // 1325
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␔\ri＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７％",
		out:  "␔\ri＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７％",
	}, { // 1326
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␔␍i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７％",
		out:  "␔␍i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７％",
	}, { // 1327
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␔\ri＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"␍％",
		out:  "␔\ri＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"␍％",
	}, { // 1328
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␔␍i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"␍％",
		out:  "␔␍i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"␍％",
	}, { // 1329
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␔\ri＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７␍",
		out:  "␔\ri＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７␍",
	}, { // 1330
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␔␍i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７␍",
		out:  "␔␍i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７␍",
	}, { // 1331
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␔␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"\r％",
		out:  "␔␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"\r％",
	}, { // 1332
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␔␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"␍％",
		out:  "␔␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"␍％",
	}, { // 1333
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␔␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"\r␍",
		out:  "␔␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"\r␍",
	}, { // 1334
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␔␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"␍␍",
		out:  "␔␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"␍␍",
	}, { // 1335
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␔␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７\r",
		out:  "␔␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７\r",
	}, { // 1336
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␔␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７␍",
		out:  "␔␚i＼%｛α␔Ｘ␗\r＜\"μ\x0fζ␐βμ=?/\"ω-g.\"７␍",
	}, { // 1337
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\b；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι＆",
		out:  "\b；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι＆",
	}, { // 1338
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\t␉/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι＆",
		out:  "␉␉/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι＆",
	}, { // 1339
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␉␉/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι＆",
		out:  "‛␉␉/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι＆",
	}, { // 1340
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\t；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡␉＆",
		out:  "␉；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡␉＆",
	}, { // 1341
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␉；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡␉＆",
		out:  "‛␉；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡␉＆",
	}, { // 1342
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\t；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι␉",
		out:  "␉；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι␉",
	}, { // 1343
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␉；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι␉",
		out:  "‛␉；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι␉",
	}, { // 1344
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\b\t/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι＆",
		out:  "\b\t/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι＆",
	}, { // 1345
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\b␉/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι＆",
		out:  "\b␉/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι＆",
	}, { // 1346
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\b\t/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡␉＆",
		out:  "\b\t/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡␉＆",
	}, { // 1347
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\b␉/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡␉＆",
		out:  "\b␉/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡␉＆",
	}, { // 1348
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\b\t/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι␉",
		out:  "\b\t/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι␉",
	}, { // 1349
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\b␉/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι␉",
		out:  "\b␉/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι␉",
	}, { // 1350
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\b；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡\t＆",
		out:  "\b；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡\t＆",
	}, { // 1351
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\b；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡␉＆",
		out:  "\b；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡␉＆",
	}, { // 1352
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\b；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡\t␉",
		out:  "\b；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡\t␉",
	}, { // 1353
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\b；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡␉␉",
		out:  "\b；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡␉␉",
	}, { // 1354
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\b；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι\t",
		out:  "\b；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι\t",
	}, { // 1355
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\b；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι␉",
		out:  "\b；/:␔,\x02␝，\x16\tjω＇␚ａ5\x06χ－δ{γ＿\x0f␓/␡ι␉",
	}, { // 1356
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\\Ｉ［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［（＄",
		out:  "\\Ｉ［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［（＄",
	}, { // 1357
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\n␊［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［（＄",
		out:  "␊␊［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［（＄",
	}, { // 1358
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␊␊［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［（＄",
		out:  "‛␊␊［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［（＄",
	}, { // 1359
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\nＩ［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［␊＄",
		out:  "␊Ｉ［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［␊＄",
	}, { // 1360
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␊Ｉ［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［␊＄",
		out:  "‛␊Ｉ［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［␊＄",
	}, { // 1361
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\nＩ［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［（␊",
		out:  "␊Ｉ［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［（␊",
	}, { // 1362
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␊Ｉ［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［（␊",
		out:  "‛␊Ｉ［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［（␊",
	}, { // 1363
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\\\n［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［（＄",
		out:  "\\\n［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［（＄",
	}, { // 1364
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\\␊［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［（＄",
		out:  "\\␊［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［（＄",
	}, { // 1365
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\\\n［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［␊＄",
		out:  "\\\n［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［␊＄",
	}, { // 1366
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\\␊［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［␊＄",
		out:  "\\␊［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［␊＄",
	}, { // 1367
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\\\n［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［（␊",
		out:  "\\\n［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［（␊",
	}, { // 1368
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\\␊［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［（␊",
		out:  "\\␊［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［（␊",
	}, { // 1369
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\\Ｉ［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［\n＄",
		out:  "\\Ｉ［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［\n＄",
	}, { // 1370
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\\Ｉ［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［␊＄",
		out:  "\\Ｉ［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［␊＄",
	}, { // 1371
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\\Ｉ［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［\n␊",
		out:  "\\Ｉ［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［\n␊",
	}, { // 1372
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\\Ｉ［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［␊␊",
		out:  "\\Ｉ［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［␊␊",
	}, { // 1373
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\\Ｉ［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［（\n",
		out:  "\\Ｉ［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［（\n",
	}, { // 1374
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\\Ｉ［Ｈη[C␟\"φ\nχz\x00␊υθ\n␁＄\x05_␉l/+！［（␊",
		out:  "\\Ｉ［Ｈη[C␟\"φ\nχz␀␊υθ\n␁＄\x05_␉l/+！［（␊",
	}, { // 1375
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "bω\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␕",
		out:  "bω\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␕",
	}, { // 1376
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\v␋\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␕",
		out:  "␋␋\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␕",
	}, { // 1377
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␋␋\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␕",
		out:  "‛␋␋\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␕",
	}, { // 1378
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\vω\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓ␋␕",
		out:  "␋ω\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓ␋␕",
	}, { // 1379
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␋ω\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓ␋␕",
		out:  "‛␋ω\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓ␋␕",
	}, { // 1380
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\vω\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␋",
		out:  "␋ω\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␋",
	}, { // 1381
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␋ω\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␋",
		out:  "‛␋ω\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␋",
	}, { // 1382
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "b\v\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␕",
		out:  "b\v\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␕",
	}, { // 1383
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "b␋\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␕",
		out:  "b␋\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␕",
	}, { // 1384
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "b\v\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓ␋␕",
		out:  "b\v\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓ␋␕",
	}, { // 1385
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "b␋\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓ␋␕",
		out:  "b␋\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓ␋␕",
	}, { // 1386
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "b\v\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␋",
		out:  "b\v\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␋",
	}, { // 1387
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "b␋\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␋",
		out:  "b␋\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␋",
	}, { // 1388
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "bω\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓ\v␕",
		out:  "bω\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓ\v␕",
	}, { // 1389
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "bω\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓ␋␕",
		out:  "bω\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓ␋␕",
	}, { // 1390
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "bω\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓ\v␋",
		out:  "bω\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓ\v␋",
	}, { // 1391
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "bω\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓ␋␋",
		out:  "bω\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓ␋␋",
	}, { // 1392
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "bω\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ\v",
		out:  "bω\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ\v",
	}, { // 1393
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "bω\b\x00＠rμ]`？\v／｛>ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␋",
		out:  "bω\b␀＠rμ]`？\v／｛＞ｒ\x03\bκ［ωφ？.＇`Ｗ\vｓψ␋",
	}, { // 1394
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "κＴ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|｀",
		out:  "κＴ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|｀",
	}, { // 1395
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\r␍？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|｀",
		out:  "␍␍？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|｀",
	}, { // 1396
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␍␍？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|｀",
		out:  "‛␍␍？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|｀",
	}, { // 1397
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\rＴ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈␍｀",
		out:  "␍Ｔ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈␍｀",
	}, { // 1398
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␍Ｔ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈␍｀",
		out:  "‛␍Ｔ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈␍｀",
	}, { // 1399
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\rＴ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|␍",
		out:  "␍Ｔ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|␍",
	}, { // 1400
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␍Ｔ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|␍",
		out:  "‛␍Ｔ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|␍",
	}, { // 1401
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "κ\r？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|｀",
		out:  "κ\r？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|｀",
	}, { // 1402
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "κ␍？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|｀",
		out:  "κ␍？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|｀",
	}, { // 1403
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "κ\r？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈␍｀",
		out:  "κ\r？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈␍｀",
	}, { // 1404
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "κ␍？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈␍｀",
		out:  "κ␍？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈␍｀",
	}, { // 1405
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "κ\r？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|␍",
		out:  "κ\r？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|␍",
	}, { // 1406
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "κ␍？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|␍",
		out:  "κ␍？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|␍",
	}, { // 1407
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "κＴ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈\r｀",
		out:  "κＴ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈\r｀",
	}, { // 1408
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "κＴ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈␍｀",
		out:  "κＴ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈␍｀",
	}, { // 1409
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "κＴ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈\r␍",
		out:  "κＴ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈\r␍",
	}, { // 1410
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "κＴ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈␍␍",
		out:  "κＴ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈␍␍",
	}, { // 1411
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "κＴ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|\r",
		out:  "κＴ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|\r",
	}, { // 1412
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "κＴ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|␍",
		out:  "κＴ？␙ψθwＴπQ\r％␔\t*!\"ωl\x05[＃～φ［｜2␈|␍",
	}, { // 1413
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "？／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍]",
		out:  "？／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍］",
	}, { // 1414
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\t␉ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍]",
		out:  "␉␉ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍］",
	}, { // 1415
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␉␉ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍]",
		out:  "‛␉␉ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍］",
	}, { // 1416
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\t／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␉]",
		out:  "␉／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␉］",
	}, { // 1417
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␉／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␉]",
		out:  "‛␉／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␉］",
	}, { // 1418
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\t／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍␉",
		out:  "␉／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍␉",
	}, { // 1419
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␉／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍␉",
		out:  "‛␉／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍␉",
	}, { // 1420
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "？\tω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍]",
		out:  "？\tω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍］",
	}, { // 1421
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "？␉ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍]",
		out:  "？␉ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍］",
	}, { // 1422
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "？\tω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␉]",
		out:  "？\tω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␉］",
	}, { // 1423
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "？␉ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␉]",
		out:  "？␉ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␉］",
	}, { // 1424
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "？\tω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍␉",
		out:  "？\tω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍␉",
	}, { // 1425
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "？␉ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍␉",
		out:  "？␉ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍␉",
	}, { // 1426
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "？／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ\t]",
		out:  "？／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ\t］",
	}, { // 1427
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "？／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␉]",
		out:  "？／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␉］",
	}, { // 1428
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "？／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ\t␉",
		out:  "？／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ\t␉",
	}, { // 1429
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "？／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␉␉",
		out:  "？／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␉␉",
	}, { // 1430
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "？／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍\t",
		out:  "？／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍\t",
	}, { // 1431
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "？／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍␉",
		out:  "？／ω＂=Ｉ\x16?Ｄ␡\tξ\r_␍Cｄ＞Ｇ\nｌ\"<ν;ιzθ␍␉",
	}, { // 1432
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ωＵ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙy\x1d",
		out:  "ωＵ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙy\x1d",
	}, { // 1433
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\n␊(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙy\x1d",
		out:  "␊␊(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙy\x1d",
	}, { // 1434
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␊␊(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙy\x1d",
		out:  "‛␊␊(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙy\x1d",
	}, { // 1435
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\nＵ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙ␊\x1d",
		out:  "␊Ｕ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙ␊\x1d",
	}, { // 1436
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␊Ｕ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙ␊\x1d",
		out:  "‛␊Ｕ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙ␊\x1d",
	}, { // 1437
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\nＵ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙy␊",
		out:  "␊Ｕ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙy␊",
	}, { // 1438
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␊Ｕ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙy␊",
		out:  "‛␊Ｕ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙy␊",
	}, { // 1439
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ω\n(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙy\x1d",
		out:  "ω\n(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙy\x1d",
	}, { // 1440
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ω␊(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙy\x1d",
		out:  "ω␊(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙy\x1d",
	}, { // 1441
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ω\n(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙ␊\x1d",
		out:  "ω\n(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙ␊\x1d",
	}, { // 1442
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ω␊(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙ␊\x1d",
		out:  "ω␊(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙ␊\x1d",
	}, { // 1443
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ω\n(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙy␊",
		out:  "ω\n(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙy␊",
	}, { // 1444
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ω␊(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙy␊",
		out:  "ω␊(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙy␊",
	}, { // 1445
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ωＵ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙ\n\x1d",
		out:  "ωＵ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙ\n\x1d",
	}, { // 1446
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ωＵ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙ␊\x1d",
		out:  "ωＵ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙ␊\x1d",
	}, { // 1447
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ωＵ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙ\n␊",
		out:  "ωＵ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙ\n␊",
	}, { // 1448
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ωＵ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙ␊␊",
		out:  "ωＵ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙ␊␊",
	}, { // 1449
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ωＵ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙy\n",
		out:  "ωＵ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙy\n",
	}, { // 1450
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ωＵ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞］＃Ｙy␊",
		out:  "ωＵ(\rηxκJ$␗\n％@＄ａ\uff00ζ?\x14<Ｖ\x04γσ＞‛］＃Ｙy␊",
	}, { // 1451
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "＂␊␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄx",
		out:  "＂␊␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄx",
	}, { // 1452
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\v␋␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄx",
		out:  "␋␋␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄx",
	}, { // 1453
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␋␋␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄx",
		out:  "‛␋␋␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄx",
	}, { // 1454
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\v␊␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐␋x",
		out:  "␋␊␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐␋x",
	}, { // 1455
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␋␊␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐␋x",
		out:  "‛␋␊␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐␋x",
	}, { // 1456
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\v␊␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄ␋",
		out:  "␋␊␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄ␋",
	}, { // 1457
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␋␊␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄ␋",
		out:  "‛␋␊␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄ␋",
	}, { // 1458
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "＂\v␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄx",
		out:  "＂\v␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄx",
	}, { // 1459
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "＂␋␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄx",
		out:  "＂␋␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄx",
	}, { // 1460
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "＂\v␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐␋x",
		out:  "＂\v␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐␋x",
	}, { // 1461
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "＂␋␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐␋x",
		out:  "＂␋␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐␋x",
	}, { // 1462
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "＂\v␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄ␋",
		out:  "＂\v␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄ␋",
	}, { // 1463
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "＂␋␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄ␋",
		out:  "＂␋␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄ␋",
	}, { // 1464
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "＂␊␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐\vx",
		out:  "＂␊␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐\vx",
	}, { // 1465
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "＂␊␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐␋x",
		out:  "＂␊␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐␋x",
	}, { // 1466
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "＂␊␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐\v␋",
		out:  "＂␊␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐\v␋",
	}, { // 1467
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "＂␊␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐␋␋",
		out:  "＂␊␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐␋␋",
	}, { // 1468
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "＂␊␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄ\v",
		out:  "＂␊␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄ\v",
	}, { // 1469
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "＂␊␙DtβＸ#:ε\v｜[γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄ␋",
		out:  "＂␊␙DtβＸ#:ε\v｜［γ␗？ζ\x12:Mｎuαγ｀\x10ｒ␐Ｄ␋",
	}, { // 1470
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "π＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␄",
		out:  "π＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␄",
	}, { // 1471
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\r␍δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␄",
		out:  "␍␍δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␄",
	}, { // 1472
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␍␍δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␄",
		out:  "‛␍␍δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␄",
	}, { // 1473
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\r＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ␍␄",
		out:  "␍＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ␍␄",
	}, { // 1474
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␍＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ␍␄",
		out:  "‛␍＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ␍␄",
	}, { // 1475
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\r＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␍",
		out:  "␍＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␍",
	}, { // 1476
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␍＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␍",
		out:  "‛␍＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␍",
	}, { // 1477
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "π\rδ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␄",
		out:  "π\rδ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␄",
	}, { // 1478
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "π␍δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␄",
		out:  "π␍δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␄",
	}, { // 1479
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "π\rδ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ␍␄",
		out:  "π\rδ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ␍␄",
	}, { // 1480
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "π␍δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ␍␄",
		out:  "π␍δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ␍␄",
	}, { // 1481
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "π\rδ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␍",
		out:  "π\rδ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␍",
	}, { // 1482
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "π␍δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␍",
		out:  "π␍δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␍",
	}, { // 1483
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "π＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ\r␄",
		out:  "π＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ\r␄",
	}, { // 1484
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "π＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ␍␄",
		out:  "π＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ␍␄",
	}, { // 1485
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "π＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ\r␍",
		out:  "π＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ\r␍",
	}, { // 1486
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "π＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ␍␍",
		out:  "π＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ␍␍",
	}, { // 1487
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "π＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*\r",
		out:  "π＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*\r",
	}, { // 1488
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "π＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␍",
		out:  "π＂δ\x0e};\x17οπ\uff00\r␕ηＢOl␛␏N␞！\x02\x1aPπ％>Ｉ*␍",
	}, { // 1489
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "?９%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␜；",
		out:  "?９%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␜；",
	}, { // 1490
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\t␉%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␜；",
		out:  "␉␉%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␜；",
	}, { // 1491
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␉␉%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␜；",
		out:  "‛␉␉%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␜；",
	}, { // 1492
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\t９%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␉；",
		out:  "␉９%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␉；",
	}, { // 1493
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␉９%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␉；",
		out:  "‛␉９%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␉；",
	}, { // 1494
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\t９%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␜␉",
		out:  "␉９%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␜␉",
	}, { // 1495
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␉９%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␜␉",
		out:  "‛␉９%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␜␉",
	}, { // 1496
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "?\t%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␜；",
		out:  "?\t%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␜；",
	}, { // 1497
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "?␉%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␜；",
		out:  "?␉%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␜；",
	}, { // 1498
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "?\t%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␉；",
		out:  "?\t%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␉；",
	}, { // 1499
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "?␉%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␉；",
		out:  "?␉%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␉；",
	}, { // 1500
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "?\t%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␜␉",
		out:  "?\t%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␜␉",
	}, { // 1501
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "?␉%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␜␉",
		out:  "?␉%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␜␉",
	}, { // 1502
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "?９%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ\t；",
		out:  "?９%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ\t；",
	}, { // 1503
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "?９%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␉；",
		out:  "?９%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␉；",
	}, { // 1504
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "?９%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ\t␉",
		out:  "?９%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ\t␉",
	}, { // 1505
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "?９%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␉␉",
		out:  "?９%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␉␉",
	}, { // 1506
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "?９%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␜\t",
		out:  "?９%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␜\t",
	}, { // 1507
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "?９%\x10\\/d＂４π\tς}ｘ＄Ｎ\b|αη␘␌π?W＿mξ␜␉",
		out:  "?９%\x10\\/d＂４π\tς}ｘ‛＄Ｎ\b|αη␘␌π?W＿mξ␜␉",
	}, { // 1508
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "{＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#α",
		out:  "{＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#α",
	}, { // 1509
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\n␊５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#α",
		out:  "␊␊５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#α",
	}, { // 1510
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊␊５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#α",
		out:  "‛␊␊５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#α",
	}, { // 1511
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\n＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]␊α",
		out:  "␊＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]␊α",
	}, { // 1512
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]␊α",
		out:  "‛␊＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]␊α",
	}, { // 1513
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\n＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#␊",
		out:  "␊＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#␊",
	}, { // 1514
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#␊",
		out:  "‛␊＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#␊",
	}, { // 1515
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "{\n５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#α",
		out:  "{\n５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#α",
	}, { // 1516
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "{␊５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#α",
		out:  "{␊５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#α",
	}, { // 1517
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "{\n５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]␊α",
		out:  "{\n５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]␊α",
	}, { // 1518
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "{␊５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]␊α",
		out:  "{␊５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]␊α",
	}, { // 1519
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "{\n５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#␊",
		out:  "{\n５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#␊",
	}, { // 1520
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "{␊５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#␊",
		out:  "{␊５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#␊",
	}, { // 1521
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "{＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]\nα",
		out:  "{＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]\nα",
	}, { // 1522
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "{＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]␊α",
		out:  "{＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]␊α",
	}, { // 1523
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "{＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]\n␊",
		out:  "{＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]\n␊",
	}, { // 1524
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "{＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]␊␊",
		out:  "{＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]␊␊",
	}, { // 1525
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "{＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#\n",
		out:  "{＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#\n",
	}, { // 1526
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "{＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#␊",
		out:  "{＾５\f＇／␈s␉＼\nＯ␚:ηομCＳ/\x14φγ\v２v*]#␊",
	}, { // 1527
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5｀",
		out:  "｀␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5｀",
	}, { // 1528
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\v␋\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5｀",
		out:  "␋␋\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5｀",
	}, { // 1529
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␋␋\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5｀",
		out:  "‛␋␋\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5｀",
	}, { // 1530
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\v␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ␋｀",
		out:  "␋␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ␋｀",
	}, { // 1531
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␋␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ␋｀",
		out:  "‛␋␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ␋｀",
	}, { // 1532
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\v␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5␋",
		out:  "␋␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5␋",
	}, { // 1533
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␋␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5␋",
		out:  "‛␋␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5␋",
	}, { // 1534
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀\v\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5｀",
		out:  "｀\v\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5｀",
	}, { // 1535
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␋\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5｀",
		out:  "｀␋\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5｀",
	}, { // 1536
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀\v\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ␋｀",
		out:  "｀\v\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ␋｀",
	}, { // 1537
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␋\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ␋｀",
		out:  "｀␋\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ␋｀",
	}, { // 1538
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀\v\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5␋",
		out:  "｀\v\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5␋",
	}, { // 1539
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␋\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5␋",
		out:  "｀␋\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5␋",
	}, { // 1540
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ\v｀",
		out:  "｀␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ\v｀",
	}, { // 1541
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ␋｀",
		out:  "｀␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ␋｀",
	}, { // 1542
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ\v␋",
		out:  "｀␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ\v␋",
	}, { // 1543
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ␋␋",
		out:  "｀␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ␋␋",
	}, { // 1544
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5\v",
		out:  "｀␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5\v",
	}, { // 1545
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5␋",
		out:  "｀␞\t5\x01M\r␒Ｊ\r\v␉␅O[\"ｅｕx\x1b␇βγ］οＩπυ5␋",
	}, { // 1546
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "kc！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a?H",
		out:  "kc！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a?H",
	}, { // 1547
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\r␍！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a?H",
		out:  "␍␍！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a?H",
	}, { // 1548
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␍␍！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a?H",
		out:  "‛␍␍！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a?H",
	}, { // 1549
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\rc！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a␍H",
		out:  "␍c！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a␍H",
	}, { // 1550
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␍c！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a␍H",
		out:  "‛␍c！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a␍H",
	}, { // 1551
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\rc！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a?␍",
		out:  "␍c！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a?␍",
	}, { // 1552
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␍c！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a?␍",
		out:  "‛␍c！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a?␍",
	}, { // 1553
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "k\r！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a?H",
		out:  "k\r！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a?H",
	}, { // 1554
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "k␍！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a?H",
		out:  "k␍！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a?H",
	}, { // 1555
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "k\r！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a␍H",
		out:  "k\r！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a␍H",
	}, { // 1556
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "k␍！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a␍H",
		out:  "k␍！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a␍H",
	}, { // 1557
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "k\r！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a?␍",
		out:  "k\r！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a?␍",
	}, { // 1558
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "k␍！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a?␍",
		out:  "k␍！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a?␍",
	}, { // 1559
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "kc！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a\rH",
		out:  "kc！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a\rH",
	}, { // 1560
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "kc！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a␍H",
		out:  "kc！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a␍H",
	}, { // 1561
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "kc！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a\r␍",
		out:  "kc！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a\r␍",
	}, { // 1562
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "kc！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a␍␍",
		out:  "kc！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a␍␍",
	}, { // 1563
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "kc！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a?\r",
		out:  "kc！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a?\r",
	}, { // 1564
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "kc！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ＄＇β\n＃a?␍",
		out:  "kc！\b\x1e␔hＹ␖μ\rζ/\x12ａ␂θ（λ＜nγ‛＄＇β\n＃a?␍",
	}, { // 1565
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "I␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５μ",
		out:  "I␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５μ",
	}, { // 1566
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\t␉>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５μ",
		out:  "␉␉>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５μ",
	}, { // 1567
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␉␉>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５μ",
		out:  "‛␉␉>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５μ",
	}, { // 1568
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\t␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊␉μ",
		out:  "␉␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊␉μ",
	}, { // 1569
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␉␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊␉μ",
		out:  "‛␉␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊␉μ",
	}, { // 1570
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\t␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５␉",
		out:  "␉␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５␉",
	}, { // 1571
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␉␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５␉",
		out:  "‛␉␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５␉",
	}, { // 1572
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "I\t>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５μ",
		out:  "I\t>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５μ",
	}, { // 1573
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "I␉>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５μ",
		out:  "I␉>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５μ",
	}, { // 1574
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "I\t>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊␉μ",
		out:  "I\t>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊␉μ",
	}, { // 1575
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "I␉>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊␉μ",
		out:  "I␉>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊␉μ",
	}, { // 1576
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "I\t>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５␉",
		out:  "I\t>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５␉",
	}, { // 1577
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "I␉>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５␉",
		out:  "I␉>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５␉",
	}, { // 1578
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "I␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊\tμ",
		out:  "I␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊\tμ",
	}, { // 1579
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "I␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊␉μ",
		out:  "I␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊␉μ",
	}, { // 1580
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "I␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊\t␉",
		out:  "I␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊\t␉",
	}, { // 1581
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "I␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊␉␉",
		out:  "I␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊␉␉",
	}, { // 1582
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "I␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５\t",
		out:  "I␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５\t",
	}, { // 1583
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "I␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５␉",
		out:  "I␓>\nｅ␍␁κ\x18ｙ\tO␎｛β␡=ζχ\x1eω$＋_＞H\u007f＊５␉",
	}, { // 1584
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␕ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␖",
		out:  "␕ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␖",
	}, { // 1585
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\n␊\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␖",
		out:  "␊␊\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␖",
	}, { // 1586
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␊␊\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␖",
		out:  "‛␊␊\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␖",
	}, { // 1587
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\nｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁␊␖",
		out:  "␊ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁␊␖",
	}, { // 1588
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␊ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁␊␖",
		out:  "‛␊ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁␊␖",
	}, { // 1589
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\nｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␊",
		out:  "␊ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␊",
	}, { // 1590
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␊ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␊",
		out:  "‛␊ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␊",
	}, { // 1591
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␕\n\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␖",
		out:  "␕\n\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␖",
	}, { // 1592
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␕␊\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␖",
		out:  "␕␊\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␖",
	}, { // 1593
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␕\n\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁␊␖",
		out:  "␕\n\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁␊␖",
	}, { // 1594
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␕␊\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁␊␖",
		out:  "␕␊\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁␊␖",
	}, { // 1595
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␕\n\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␊",
		out:  "␕\n\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␊",
	}, { // 1596
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␕␊\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␊",
		out:  "␕␊\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␊",
	}, { // 1597
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␕ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁\n␖",
		out:  "␕ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁\n␖",
	}, { // 1598
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␕ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁␊␖",
		out:  "␕ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁␊␖",
	}, { // 1599
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␕ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁\n␊",
		out:  "␕ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁\n␊",
	}, { // 1600
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␕ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁␊␊",
		out:  "␕ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁␊␊",
	}, { // 1601
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␕ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η\n",
		out:  "␕ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η\n",
	}, { // 1602
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␕ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␊",
		out:  "␕ｓ\x17Z\x10␇\x0f\x049κ\n|␏π&\x0fｔｈＯε\x16@π␃ψ．2␁η␊",
	}, { // 1603
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "［i␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<Ｘ␆",
		out:  "［i␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<Ｘ␆",
	}, { // 1604
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\v␋␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<Ｘ␆",
		out:  "␋␋␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<Ｘ␆",
	}, { // 1605
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋␋␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<Ｘ␆",
		out:  "‛␋␋␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<Ｘ␆",
	}, { // 1606
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\vi␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<␋␆",
		out:  "␋i␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<␋␆",
	}, { // 1607
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋i␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<␋␆",
		out:  "‛␋i␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<␋␆",
	}, { // 1608
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\vi␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<Ｘ␋",
		out:  "␋i␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<Ｘ␋",
	}, { // 1609
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋i␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<Ｘ␋",
		out:  "‛␋i␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<Ｘ␋",
	}, { // 1610
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "［\v␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<Ｘ␆",
		out:  "［\v␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<Ｘ␆",
	}, { // 1611
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "［␋␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<Ｘ␆",
		out:  "［␋␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<Ｘ␆",
	}, { // 1612
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "［\v␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<␋␆",
		out:  "［\v␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<␋␆",
	}, { // 1613
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "［␋␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<␋␆",
		out:  "［␋␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<␋␆",
	}, { // 1614
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "［\v␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<Ｘ␋",
		out:  "［\v␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<Ｘ␋",
	}, { // 1615
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "［␋␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<Ｘ␋",
		out:  "［␋␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<Ｘ␋",
	}, { // 1616
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "［i␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<\v␆",
		out:  "［i␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<\v␆",
	}, { // 1617
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "［i␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<␋␆",
		out:  "［i␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<␋␆",
	}, { // 1618
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "［i␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<\v␋",
		out:  "［i␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<\v␋",
	}, { // 1619
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "［i␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<␋␋",
		out:  "［i␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<␋␋",
	}, { // 1620
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "［i␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<Ｘ\v",
		out:  "［i␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<Ｘ\v",
	}, { // 1621
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "［i␕5␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β\"λ<Ｘ␋",
		out:  "［i␕5‛␀8２７\x06␘\vη\x11πθ_ｐρＡ\x15＊_I␊β＂λ<Ｘ␋",
	}, { // 1622
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␌ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％^",
		out:  "␌ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％^",
	}, { // 1623
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␍\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％^",
		out:  "␍␍\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％^",
	}, { // 1624
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␍␍\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％^",
		out:  "‛␍␍\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％^",
	}, { // 1625
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\rξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇␍^",
		out:  "␍ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇␍^",
	}, { // 1626
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␍ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇␍^",
		out:  "‛␍ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇␍^",
	}, { // 1627
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\rξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％␍",
		out:  "␍ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％␍",
	}, { // 1628
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␍ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％␍",
		out:  "‛␍ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％␍",
	}, { // 1629
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␌\r\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％^",
		out:  "␌\r\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％^",
	}, { // 1630
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␌␍\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％^",
		out:  "␌␍\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％^",
	}, { // 1631
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␌\r\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇␍^",
		out:  "␌\r\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇␍^",
	}, { // 1632
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␌␍\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇␍^",
		out:  "␌␍\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇␍^",
	}, { // 1633
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␌\r\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％␍",
		out:  "␌\r\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％␍",
	}, { // 1634
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␌␍\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％␍",
		out:  "␌␍\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％␍",
	}, { // 1635
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␌ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇\r^",
		out:  "␌ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇\r^",
	}, { // 1636
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␌ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇␍^",
		out:  "␌ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇␍^",
	}, { // 1637
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␌ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇\r␍",
		out:  "␌ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇\r␍",
	}, { // 1638
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␌ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇␍␍",
		out:  "␌ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇␍␍",
	}, { // 1639
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␌ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％\r",
		out:  "␌ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％\r",
	}, { // 1640
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␌ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％␍",
		out:  "␌ξ\x1b{PＺγπ＊\r\r\x11ｃ\x12δｔz＊ｃ８８Pατ\x01h␇＇％␍",
	}, { // 1641
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x1a＊`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z]",
		out:  "\x1a＊`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z]",
	}, { // 1642
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\t␉`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z]",
		out:  "␉␉`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z]",
	}, { // 1643
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␉␉`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z]",
		out:  "‛␉␉`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z]",
	}, { // 1644
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\t＊`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&␉]",
		out:  "␉＊`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&␉]",
	}, { // 1645
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␉＊`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&␉]",
		out:  "‛␉＊`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&␉]",
	}, { // 1646
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\t＊`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z␉",
		out:  "␉＊`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z␉",
	}, { // 1647
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␉＊`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z␉",
		out:  "‛␉＊`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z␉",
	}, { // 1648
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x1a\t`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z]",
		out:  "\x1a\t`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z]",
	}, { // 1649
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x1a␉`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z]",
		out:  "\x1a␉`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z]",
	}, { // 1650
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x1a\t`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&␉]",
		out:  "\x1a\t`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&␉]",
	}, { // 1651
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x1a␉`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&␉]",
		out:  "\x1a␉`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&␉]",
	}, { // 1652
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x1a\t`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z␉",
		out:  "\x1a\t`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z␉",
	}, { // 1653
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x1a␉`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z␉",
		out:  "\x1a␉`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z␉",
	}, { // 1654
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x1a＊`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&\t]",
		out:  "\x1a＊`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&\t]",
	}, { // 1655
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x1a＊`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&␉]",
		out:  "\x1a＊`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&␉]",
	}, { // 1656
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x1a＊`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&\t␉",
		out:  "\x1a＊`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&\t␉",
	}, { // 1657
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x1a＊`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&␉␉",
		out:  "\x1a＊`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&␉␉",
	}, { // 1658
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x1a＊`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z\t",
		out:  "\x1a＊`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z\t",
	}, { // 1659
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x1a＊`υ\aN␃％\x0f\"\tο␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z␉",
		out:  "\x1a＊`υ\aN␃％\x0f\"\tο‛␀␐９\r␅ＯζAο\x1f␎Ｆπｕ␓&Z␉",
	}, { // 1660
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ςψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞\x10",
		out:  "ςψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞\x10",
	}, { // 1661
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\n␊///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞\x10",
		out:  "␊␊///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞\x10",
	}, { // 1662
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␊␊///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞\x10",
		out:  "‛␊␊///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞\x10",
	}, { // 1663
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\nψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍␊\x10",
		out:  "␊ψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍␊\x10",
	}, { // 1664
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␊ψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍␊\x10",
		out:  "‛␊ψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍␊\x10",
	}, { // 1665
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\nψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞␊",
		out:  "␊ψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞␊",
	}, { // 1666
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␊ψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞␊",
		out:  "‛␊ψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞␊",
	}, { // 1667
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ς\n///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞\x10",
		out:  "ς\n///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞\x10",
	}, { // 1668
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ς␊///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞\x10",
		out:  "ς␊///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞\x10",
	}, { // 1669
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ς\n///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍␊\x10",
		out:  "ς\n///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍␊\x10",
	}, { // 1670
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ς␊///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍␊\x10",
		out:  "ς␊///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍␊\x10",
	}, { // 1671
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ς\n///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞␊",
		out:  "ς\n///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞␊",
	}, { // 1672
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ς␊///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞␊",
		out:  "ς␊///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞␊",
	}, { // 1673
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ςψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍\n\x10",
		out:  "ςψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍\n\x10",
	}, { // 1674
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ςψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍␊\x10",
		out:  "ςψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍␊\x10",
	}, { // 1675
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ςψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍\n␊",
		out:  "ςψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍\n␊",
	}, { // 1676
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ςψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍␊␊",
		out:  "ςψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍␊␊",
	}, { // 1677
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ςψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞\n",
		out:  "ςψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞\n",
	}, { // 1678
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ςψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞␊",
		out:  "ςψ///μＣι␕％\n＂ＯU＇m5hＲ␍Ｕ？\tAμτ\x03␍＞␊",
	}, { // 1679
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀\r",
		out:  "k␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀\r",
	}, { // 1680
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v␋δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀\r",
		out:  "␋␋δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀\r",
	}, { // 1681
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␋␋δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀\r",
		out:  "‛␋␋δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀\r",
	}, { // 1682
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%␋\r",
		out:  "␋␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%␋\r",
	}, { // 1683
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␋␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%␋\r",
		out:  "‛␋␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%␋\r",
	}, { // 1684
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀␋",
		out:  "␋␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀␋",
	}, { // 1685
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␋␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀␋",
		out:  "‛␋␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀␋",
	}, { // 1686
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k\vδ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀\r",
		out:  "k\vδ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀\r",
	}, { // 1687
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k␋δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀\r",
		out:  "k␋δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀\r",
	}, { // 1688
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k\vδ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%␋\r",
		out:  "k\vδ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%␋\r",
	}, { // 1689
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k␋δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%␋\r",
		out:  "k␋δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%␋\r",
	}, { // 1690
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k\vδ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀␋",
		out:  "k\vδ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀␋",
	}, { // 1691
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k␋δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀␋",
		out:  "k␋δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀␋",
	}, { // 1692
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%\v\r",
		out:  "k␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%\v\r",
	}, { // 1693
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%␋\r",
		out:  "k␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%␋\r",
	}, { // 1694
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%\v␋",
		out:  "k␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%\v␋",
	}, { // 1695
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%␋␋",
		out:  "k␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%␋␋",
	}, { // 1696
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀\v",
		out:  "k␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀\v",
	}, { // 1697
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀␋",
		out:  "k␊δ\x1f＂Ａ␌Os\\\vＵoςF／␋\a\"θＧｋο（\\ππ%｀␋",
	}, { // 1698
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␈\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴａ",
		out:  "␈\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴａ",
	}, { // 1699
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\r␍\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴａ",
		out:  "␍␍\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴａ",
	}, { // 1700
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␍␍\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴａ",
		out:  "‛␍␍\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴａ",
	}, { // 1701
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\r\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βe␍ａ",
		out:  "␍\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βe␍ａ",
	}, { // 1702
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␍\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βe␍ａ",
		out:  "‛␍\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βe␍ａ",
	}, { // 1703
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\r\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴ␍",
		out:  "␍\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴ␍",
	}, { // 1704
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␍\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴ␍",
		out:  "‛␍\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴ␍",
	}, { // 1705
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␈\r\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴａ",
		out:  "␈\r\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴａ",
	}, { // 1706
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␈␍\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴａ",
		out:  "␈␍\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴａ",
	}, { // 1707
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␈\r\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βe␍ａ",
		out:  "␈\r\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βe␍ａ",
	}, { // 1708
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␈␍\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βe␍ａ",
		out:  "␈␍\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βe␍ａ",
	}, { // 1709
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␈\r\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴ␍",
		out:  "␈\r\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴ␍",
	}, { // 1710
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␈␍\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴ␍",
		out:  "␈␍\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴ␍",
	}, { // 1711
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␈\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βe\rａ",
		out:  "␈\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βe\rａ",
	}, { // 1712
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␈\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βe␍ａ",
		out:  "␈\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βe␍ａ",
	}, { // 1713
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␈\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βe\r␍",
		out:  "␈\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βe\r␍",
	}, { // 1714
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␈\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βe␍␍",
		out:  "␈\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βe␍␍",
	}, { // 1715
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␈\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴ\r",
		out:  "␈\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴ\r",
	}, { // 1716
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␈\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴ␍",
		out:  "␈\n\x14␛␕Hπ,\t｀\rOγ］？９\x1d]\\\uff00γＺiγβ＞βeＴ␍",
	}, { // 1717
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ｔ␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3tｔ",
		out:  "Ｔ␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3tｔ",
	}, { // 1718
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\t␉τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3tｔ",
		out:  "␉␉τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3tｔ",
	}, { // 1719
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉␉τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3tｔ",
		out:  "‛␉␉τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3tｔ",
	}, { // 1720
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\t␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3␉ｔ",
		out:  "␉␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3␉ｔ",
	}, { // 1721
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3␉ｔ",
		out:  "‛␉␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3␉ｔ",
	}, { // 1722
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\t␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3t␉",
		out:  "␉␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3t␉",
	}, { // 1723
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3t␉",
		out:  "‛␉␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3t␉",
	}, { // 1724
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ｔ\tτ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3tｔ",
		out:  "Ｔ\tτ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3tｔ",
	}, { // 1725
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ｔ␉τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3tｔ",
		out:  "Ｔ␉τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3tｔ",
	}, { // 1726
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ｔ\tτ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3␉ｔ",
		out:  "Ｔ\tτ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3␉ｔ",
	}, { // 1727
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ｔ␉τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3␉ｔ",
		out:  "Ｔ␉τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3␉ｔ",
	}, { // 1728
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ｔ\tτ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3t␉",
		out:  "Ｔ\tτ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3t␉",
	}, { // 1729
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ｔ␉τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3t␉",
		out:  "Ｔ␉τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3t␉",
	}, { // 1730
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ｔ␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3\tｔ",
		out:  "Ｔ␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3\tｔ",
	}, { // 1731
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ｔ␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3␉ｔ",
		out:  "Ｔ␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3␉ｔ",
	}, { // 1732
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ｔ␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3\t␉",
		out:  "Ｔ␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3\t␉",
	}, { // 1733
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ｔ␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3␉␉",
		out:  "Ｔ␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3␉␉",
	}, { // 1734
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ｔ␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3t\t",
		out:  "Ｔ␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3t\t",
	}, { // 1735
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ｔ␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3t␉",
		out:  "Ｔ␆τ\x10\x10＂６\x11Ck\t\r␄%/σ＾＃δ＂o＄μ␋ξδＣ3t␉",
	}, { // 1736
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "υχ!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％＇",
		out:  "υχ!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％＇",
	}, { // 1737
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\n␊!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％＇",
		out:  "␊␊!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％＇",
	}, { // 1738
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␊␊!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％＇",
		out:  "‛␊␊!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％＇",
	}, { // 1739
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\nχ!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>␊＇",
		out:  "␊χ!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>␊＇",
	}, { // 1740
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␊χ!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>␊＇",
		out:  "‛␊χ!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>␊＇",
	}, { // 1741
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\nχ!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％␊",
		out:  "␊χ!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％␊",
	}, { // 1742
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␊χ!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％␊",
		out:  "‛␊χ!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％␊",
	}, { // 1743
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "υ\n!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％＇",
		out:  "υ\n!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％＇",
	}, { // 1744
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "υ␊!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％＇",
		out:  "υ␊!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％＇",
	}, { // 1745
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "υ\n!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>␊＇",
		out:  "υ\n!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>␊＇",
	}, { // 1746
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "υ␊!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>␊＇",
		out:  "υ␊!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>␊＇",
	}, { // 1747
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "υ\n!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％␊",
		out:  "υ\n!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％␊",
	}, { // 1748
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "υ␊!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％␊",
		out:  "υ␊!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％␊",
	}, { // 1749
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "υχ!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>\n＇",
		out:  "υχ!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>\n＇",
	}, { // 1750
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "υχ!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>␊＇",
		out:  "υχ!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>␊＇",
	}, { // 1751
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "υχ!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>\n␊",
		out:  "υχ!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>\n␊",
	}, { // 1752
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "υχ!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>␊␊",
		out:  "υχ!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>␊␊",
	}, { // 1753
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "υχ!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％\n",
		out:  "υχ!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％\n",
	}, { // 1754
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "υχ!Ｘb␙%Ｗ\x00\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％␊",
		out:  "υχ!Ｘb␙%Ｗ␀\v\nｚＴν2ο６␖ψ２：\t␌\\W.η>％␊",
	}, { // 1755
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "７／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␎",
		out:  "７／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␎",
	}, { // 1756
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\v␋\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␎",
		out:  "␋␋\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␎",
	}, { // 1757
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␋␋\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␎",
		out:  "‛␋␋\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␎",
	}, { // 1758
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\v／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r␋␎",
		out:  "␋／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r␋␎",
	}, { // 1759
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␋／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r␋␎",
		out:  "‛␋／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r␋␎",
	}, { // 1760
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\v／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␋",
		out:  "␋／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␋",
	}, { // 1761
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␋／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␋",
		out:  "‛␋／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␋",
	}, { // 1762
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "７\v\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␎",
		out:  "７\v\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␎",
	}, { // 1763
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "７␋\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␎",
		out:  "７␋\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␎",
	}, { // 1764
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "７\v\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r␋␎",
		out:  "７\v\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r␋␎",
	}, { // 1765
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "７␋\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r␋␎",
		out:  "７␋\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r␋␎",
	}, { // 1766
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "７\v\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␋",
		out:  "７\v\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␋",
	}, { // 1767
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "７␋\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␋",
		out:  "７␋\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␋",
	}, { // 1768
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "７／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r\v␎",
		out:  "７／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r\v␎",
	}, { // 1769
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "７／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r␋␎",
		out:  "７／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r␋␎",
	}, { // 1770
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "７／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r\v␋",
		out:  "７／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r\v␋",
	}, { // 1771
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "７／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r␋␋",
		out:  "７／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r␋␋",
	}, { // 1772
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "７／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５\v",
		out:  "７／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５\v",
	}, { // 1773
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "７／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␋",
		out:  "７／\u007fρπ[d␔Y\a\vυ％ｋ\x13π#Ｍｈrｍzτ(␘／η\r５␋",
	}, { // 1774
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "#ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓lＥ",
		out:  "#ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓lＥ",
	}, { // 1775
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\r␍;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓lＥ",
		out:  "␍␍;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓lＥ",
	}, { // 1776
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␍␍;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓lＥ",
		out:  "‛␍␍;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓lＥ",
	}, { // 1777
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\rζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓␍Ｅ",
		out:  "␍ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓␍Ｅ",
	}, { // 1778
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␍ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓␍Ｅ",
		out:  "‛␍ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓␍Ｅ",
	}, { // 1779
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\rζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓l␍",
		out:  "␍ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓l␍",
	}, { // 1780
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␍ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓l␍",
		out:  "‛␍ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓l␍",
	}, { // 1781
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "#\r;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓lＥ",
		out:  "#\r;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓lＥ",
	}, { // 1782
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "#␍;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓lＥ",
		out:  "#␍;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓lＥ",
	}, { // 1783
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "#\r;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓␍Ｅ",
		out:  "#\r;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓␍Ｅ",
	}, { // 1784
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "#␍;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓␍Ｅ",
		out:  "#␍;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓␍Ｅ",
	}, { // 1785
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "#\r;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓l␍",
		out:  "#\r;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓l␍",
	}, { // 1786
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "#␍;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓l␍",
		out:  "#␍;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓l␍",
	}, { // 1787
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "#ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓\rＥ",
		out:  "#ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓\rＥ",
	}, { // 1788
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "#ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓␍Ｅ",
		out:  "#ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓␍Ｅ",
	}, { // 1789
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "#ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓\r␍",
		out:  "#ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓\r␍",
	}, { // 1790
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "#ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓␍␍",
		out:  "#ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓␍␍",
	}, { // 1791
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "#ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓l\r",
		out:  "#ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓l\r",
	}, { // 1792
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "#ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓l␍",
		out:  "#ζ;／\b＃\x13Ｏβ-\rｖ␑2π0＃Ｈ\x02αδ)／\x1e｜θ:␓l␍",
	}, { // 1793
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "L␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４\x00｀",
		out:  "L␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␀｀",
	}, { // 1794
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\t␉＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４\x00｀",
		out:  "␉␉＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␀｀",
	}, { // 1795
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␉␉＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４\x00｀",
		out:  "‛␉␉＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␀｀",
	}, { // 1796
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\t␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␉｀",
		out:  "␉␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␉｀",
	}, { // 1797
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␉␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␉｀",
		out:  "‛␉␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␉｀",
	}, { // 1798
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\t␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４\x00␉",
		out:  "␉␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␀␉",
	}, { // 1799
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␉␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４\x00␉",
		out:  "‛␉␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␀␉",
	}, { // 1800
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "L\t＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４\x00｀",
		out:  "L\t＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␀｀",
	}, { // 1801
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "L␉＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４\x00｀",
		out:  "L␉＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␀｀",
	}, { // 1802
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "L\t＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␉｀",
		out:  "L\t＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␉｀",
	}, { // 1803
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "L␉＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␉｀",
		out:  "L␉＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␉｀",
	}, { // 1804
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "L\t＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４\x00␉",
		out:  "L\t＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␀␉",
	}, { // 1805
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "L␉＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４\x00␉",
		out:  "L␉＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␀␉",
	}, { // 1806
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "L␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４\t｀",
		out:  "L␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４\t｀",
	}, { // 1807
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "L␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␉｀",
		out:  "L␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␉｀",
	}, { // 1808
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "L␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４\t␉",
		out:  "L␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４\t␉",
	}, { // 1809
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "L␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␉␉",
		out:  "L␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␉␉",
	}, { // 1810
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "L␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４\x00\t",
		out:  "L␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␀\t",
	}, { // 1811
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "L␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４\x00␉",
		out:  "L␑＞ξν\x0e(Fe＆\tＷ＞\x1aψ{ｗ$\x10\x1aχ4␖）ν␊ω４␀␉",
	}, { // 1812
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "｜*，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃6:",
		out:  "｜＊，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃6:",
	}, { // 1813
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n␊，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃6:",
		out:  "␊␊，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃6:",
	}, { // 1814
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␊␊，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃6:",
		out:  "‛␊␊，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃6:",
	}, { // 1815
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n*，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃␊:",
		out:  "␊＊，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃␊:",
	}, { // 1816
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␊*，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃␊:",
		out:  "‛␊＊，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃␊:",
	}, { // 1817
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n*，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃6␊",
		out:  "␊＊，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃6␊",
	}, { // 1818
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␊*，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃6␊",
		out:  "‛␊＊，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃6␊",
	}, { // 1819
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "｜\n，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃6:",
		out:  "｜\n，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃6:",
	}, { // 1820
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "｜␊，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃6:",
		out:  "｜␊，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃6:",
	}, { // 1821
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "｜\n，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃␊:",
		out:  "｜\n，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃␊:",
	}, { // 1822
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "｜␊，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃␊:",
		out:  "｜␊，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃␊:",
	}, { // 1823
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "｜\n，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃6␊",
		out:  "｜\n，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃6␊",
	}, { // 1824
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "｜␊，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃6␊",
		out:  "｜␊，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃6␊",
	}, { // 1825
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "｜*，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃\n:",
		out:  "｜＊，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃\n:",
	}, { // 1826
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "｜*，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃␊:",
		out:  "｜＊，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃␊:",
	}, { // 1827
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "｜*，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃\n␊",
		out:  "｜＊，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃\n␊",
	}, { // 1828
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "｜*，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃␊␊",
		out:  "｜＊，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃␊␊",
	}, { // 1829
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "｜*，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃6\n",
		out:  "｜＊，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃6\n",
	}, { // 1830
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "｜*，␎iζω\x1fXＤ\n＋␔＊）␑ν*DＢ\n'␏νlγι＃6␊",
		out:  "｜＊，␎iζω\x1fXＤ\n＋␔‛＊）␑ν＊DＢ\n'␏νlγι＃6␊",
	}, { // 1831
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\x12ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χj",
		out:  "\x12ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χj",
	}, { // 1832
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\v␋Ｏ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χj",
		out:  "␋␋Ｏ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χj",
	}, { // 1833
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␋␋Ｏ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χj",
		out:  "‛␋␋Ｏ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χj",
	}, { // 1834
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\vιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚␋j",
		out:  "␋ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚␋j",
	}, { // 1835
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␋ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚␋j",
		out:  "‛␋ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚␋j",
	}, { // 1836
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\vιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χ␋",
		out:  "␋ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χ␋",
	}, { // 1837
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␋ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χ␋",
		out:  "‛␋ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χ␋",
	}, { // 1838
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\x12\vＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χj",
		out:  "\x12\vＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χj",
	}, { // 1839
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\x12␋Ｏ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χj",
		out:  "\x12␋Ｏ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χj",
	}, { // 1840
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\x12\vＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚␋j",
		out:  "\x12\vＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚␋j",
	}, { // 1841
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\x12␋Ｏ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚␋j",
		out:  "\x12␋Ｏ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚␋j",
	}, { // 1842
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\x12\vＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χ␋",
		out:  "\x12\vＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χ␋",
	}, { // 1843
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\x12␋Ｏ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χ␋",
		out:  "\x12␋Ｏ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χ␋",
	}, { // 1844
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\x12ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚\vj",
		out:  "\x12ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚\vj",
	}, { // 1845
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\x12ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚␋j",
		out:  "\x12ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚␋j",
	}, { // 1846
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\x12ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚\v␋",
		out:  "\x12ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚\v␋",
	}, { // 1847
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\x12ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚␋␋",
		out:  "\x12ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚␋␋",
	}, { // 1848
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\x12ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χ\v",
		out:  "\x12ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χ\v",
	}, { // 1849
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\x12ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χ␋",
		out:  "\x12ιＯ\rＥUｕ＿\aα\v／T［\x17：α]␖k␚5␉_χςｍ␚χ␋",
	}, { // 1850
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n\x02Ｅｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ*＂",
		out:  "␊\x02Ｅｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ＊＂",
	}, { // 1851
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\r␍Ｅｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ*＂",
		out:  "␍␍Ｅｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ＊＂",
	}, { // 1852
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␍␍Ｅｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ*＂",
		out:  "‛␍␍Ｅｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ＊＂",
	}, { // 1853
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\r\x02Ｅｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ␍＂",
		out:  "␍\x02Ｅｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ␍＂",
	}, { // 1854
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␍\x02Ｅｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ␍＂",
		out:  "‛␍\x02Ｅｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ␍＂",
	}, { // 1855
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\r\x02Ｅｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ*␍",
		out:  "␍\x02Ｅｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ＊␍",
	}, { // 1856
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␍\x02Ｅｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ*␍",
		out:  "‛␍\x02Ｅｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ＊␍",
	}, { // 1857
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n\rＥｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ*＂",
		out:  "␊\rＥｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ＊＂",
	}, { // 1858
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n␍Ｅｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ*＂",
		out:  "␊␍Ｅｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ＊＂",
	}, { // 1859
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n\rＥｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ␍＂",
		out:  "␊\rＥｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ␍＂",
	}, { // 1860
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n␍Ｅｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ␍＂",
		out:  "␊␍Ｅｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ␍＂",
	}, { // 1861
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n\rＥｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ*␍",
		out:  "␊\rＥｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ＊␍",
	}, { // 1862
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n␍Ｅｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ*␍",
		out:  "␊␍Ｅｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ＊␍",
	}, { // 1863
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n\x02Ｅｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ\r＂",
		out:  "␊\x02Ｅｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ\r＂",
	}, { // 1864
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n\x02Ｅｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ␍＂",
		out:  "␊\x02Ｅｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ␍＂",
	}, { // 1865
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n\x02Ｅｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ\r␍",
		out:  "␊\x02Ｅｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ\r␍",
	}, { // 1866
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n\x02Ｅｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ␍␍",
		out:  "␊\x02Ｅｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ␍␍",
	}, { // 1867
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n\x02Ｅｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ*\r",
		out:  "␊\x02Ｅｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ＊\r",
	}, { // 1868
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n\x02Ｅｘλ\x02＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ*␍",
		out:  "␊\x02Ｅｘλ\x02‛＊q;P\rμUκτ－＜#φＳψz␘#␌␑＾ｐ＊␍",
	}, { // 1869
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ς\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧＪ",
		out:  "ς\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧＪ",
	}, { // 1870
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\t␉␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧＪ",
		out:  "␉␉␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧＪ",
	}, { // 1871
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␉␉␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧＪ",
		out:  "‛␉␉␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧＪ",
	}, { // 1872
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\t\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δ␉Ｊ",
		out:  "␉\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δ␉Ｊ",
	}, { // 1873
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␉\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δ␉Ｊ",
		out:  "‛␉\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δ␉Ｊ",
	}, { // 1874
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\t\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧ␉",
		out:  "␉\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧ␉",
	}, { // 1875
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␉\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧ␉",
		out:  "‛␉\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧ␉",
	}, { // 1876
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ς\t␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧＪ",
		out:  "ς\t␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧＪ",
	}, { // 1877
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ς␉␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧＪ",
		out:  "ς␉␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧＪ",
	}, { // 1878
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ς\t␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δ␉Ｊ",
		out:  "ς\t␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δ␉Ｊ",
	}, { // 1879
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ς␉␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δ␉Ｊ",
		out:  "ς␉␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δ␉Ｊ",
	}, { // 1880
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ς\t␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧ␉",
		out:  "ς\t␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧ␉",
	}, { // 1881
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ς␉␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧ␉",
		out:  "ς␉␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧ␉",
	}, { // 1882
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ς\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δ\tＪ",
		out:  "ς\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δ\tＪ",
	}, { // 1883
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ς\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δ␉Ｊ",
		out:  "ς\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δ␉Ｊ",
	}, { // 1884
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ς\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δ\t␉",
		out:  "ς\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δ\t␉",
	}, { // 1885
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ς\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δ␉␉",
		out:  "ς\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δ␉␉",
	}, { // 1886
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ς\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧ\t",
		out:  "ς\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧ\t",
	}, { // 1887
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ς\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧ␉",
		out:  "ς\x03␍：Ｖ␒3$~\x05\t\x11Ｄ␡：％ε＠\x14τT␍pψi4\x19δＧ␉",
	}, { // 1888
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "γｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␚",
		out:  "γｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␚",
	}, { // 1889
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\n␊?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␚",
		out:  "␊␊?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␚",
	}, { // 1890
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␊␊?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␚",
		out:  "‛␊␊?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␚",
	}, { // 1891
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\nｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␊␚",
		out:  "␊ｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␊␚",
	}, { // 1892
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␊ｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␊␚",
		out:  "‛␊ｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␊␚",
	}, { // 1893
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\nｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␊",
		out:  "␊ｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␊",
	}, { // 1894
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␊ｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␊",
		out:  "‛␊ｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␊",
	}, { // 1895
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "γ\n?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␚",
		out:  "γ\n?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␚",
	}, { // 1896
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "γ␊?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␚",
		out:  "γ␊?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␚",
	}, { // 1897
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "γ\n?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␊␚",
		out:  "γ\n?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␊␚",
	}, { // 1898
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "γ␊?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␊␚",
		out:  "γ␊?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␊␚",
	}, { // 1899
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "γ\n?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␊",
		out:  "γ\n?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␊",
	}, { // 1900
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "γ␊?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␊",
		out:  "γ␊?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␊",
	}, { // 1901
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "γｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ\n␚",
		out:  "γｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ\n␚",
	}, { // 1902
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "γｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␊␚",
		out:  "γｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␊␚",
	}, { // 1903
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "γｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ\n␊",
		out:  "γｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ\n␊",
	}, { // 1904
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "γｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␊␊",
		out:  "γｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␊␊",
	}, { // 1905
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "γｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍\n",
		out:  "γｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍\n",
	}, { // 1906
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "γｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␊",
		out:  "γｖ?`\t／／ζ␕H\n\bｗμ\\μσBｕH>\"␎：δ`２ｓ␍␊",
	}, { // 1907
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "Pfqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝Ｃ",
		out:  "Pfqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝Ｃ",
	}, { // 1908
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\v␋qμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝Ｃ",
		out:  "␋␋qμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝Ｃ",
	}, { // 1909
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␋␋qμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝Ｃ",
		out:  "‛␋␋qμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝Ｃ",
	}, { // 1910
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\vfqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ␋Ｃ",
		out:  "␋fqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ␋Ｃ",
	}, { // 1911
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␋fqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ␋Ｃ",
		out:  "‛␋fqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ␋Ｃ",
	}, { // 1912
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\vfqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝␋",
		out:  "␋fqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝␋",
	}, { // 1913
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␋fqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝␋",
		out:  "‛␋fqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝␋",
	}, { // 1914
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "P\vqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝Ｃ",
		out:  "P\vqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝Ｃ",
	}, { // 1915
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "P␋qμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝Ｃ",
		out:  "P␋qμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝Ｃ",
	}, { // 1916
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "P\vqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ␋Ｃ",
		out:  "P\vqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ␋Ｃ",
	}, { // 1917
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "P␋qμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ␋Ｃ",
		out:  "P␋qμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ␋Ｃ",
	}, { // 1918
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "P\vqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝␋",
		out:  "P\vqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝␋",
	}, { // 1919
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "P␋qμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝␋",
		out:  "P␋qμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝␋",
	}, { // 1920
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "Pfqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ\vＣ",
		out:  "Pfqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ\vＣ",
	}, { // 1921
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "Pfqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ␋Ｃ",
		out:  "Pfqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ␋Ｃ",
	}, { // 1922
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "Pfqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ\v␋",
		out:  "Pfqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ\v␋",
	}, { // 1923
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "Pfqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ␋␋",
		out:  "Pfqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ␋␋",
	}, { // 1924
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "Pfqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝\v",
		out:  "Pfqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝\v",
	}, { // 1925
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "Pfqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝␋",
		out:  "Pfqμ］\u007fｅ＂υ\r\vT\x04\x11τα␡␍.\x1cＩ＼␟$１zθτ＝␋",
	}, { // 1926
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␏＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n［",
		out:  "␏＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n［",
	}, { // 1927
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\r␍ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n［",
		out:  "␍␍ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n［",
	}, { // 1928
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␍␍ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n［",
		out:  "‛␍␍ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n［",
	}, { // 1929
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\r＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,␍［",
		out:  "␍＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,␍［",
	}, { // 1930
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␍＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,␍［",
		out:  "‛␍＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,␍［",
	}, { // 1931
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\r＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n␍",
		out:  "␍＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n␍",
	}, { // 1932
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␍＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n␍",
		out:  "‛␍＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n␍",
	}, { // 1933
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␏\rψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n［",
		out:  "␏\rψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n［",
	}, { // 1934
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␏␍ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n［",
		out:  "␏␍ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n［",
	}, { // 1935
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␏\rψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,␍［",
		out:  "␏\rψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,␍［",
	}, { // 1936
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␏␍ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,␍［",
		out:  "␏␍ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,␍［",
	}, { // 1937
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␏\rψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n␍",
		out:  "␏\rψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n␍",
	}, { // 1938
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␏␍ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n␍",
		out:  "␏␍ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n␍",
	}, { // 1939
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␏＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\r［",
		out:  "␏＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\r［",
	}, { // 1940
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␏＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,␍［",
		out:  "␏＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,␍［",
	}, { // 1941
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␏＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\r␍",
		out:  "␏＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\r␍",
	}, { // 1942
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␏＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,␍␍",
		out:  "␏＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,␍␍",
	}, { // 1943
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␏＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n\r",
		out:  "␏＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n\r",
	}, { // 1944
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␏＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n␍",
		out:  "␏＾ψ\x11ωρ␖␐tＶ\rEｗ7γＰ＇␑ｌzζ`＜\x12\x1d\x1b.,\n␍",
	}, { // 1945
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\nＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝Ａ",
		out:  "␊ＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝Ａ",
	}, { // 1946
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\t␉υＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝Ａ",
		out:  "␉␉υＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝Ａ",
	}, { // 1947
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␉␉υＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝Ａ",
		out:  "‛␉␉υＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝Ａ",
	}, { // 1948
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\tＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␉Ａ",
		out:  "␉ＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␉Ａ",
	}, { // 1949
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␉ＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␉Ａ",
		out:  "‛␉ＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␉Ａ",
	}, { // 1950
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\tＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝␉",
		out:  "␉ＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝␉",
	}, { // 1951
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␉ＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝␉",
		out:  "‛␉ＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝␉",
	}, { // 1952
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\n\tυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝Ａ",
		out:  "␊\tυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝Ａ",
	}, { // 1953
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\n␉υＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝Ａ",
		out:  "␊␉υＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝Ａ",
	}, { // 1954
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\n\tυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␉Ａ",
		out:  "␊\tυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␉Ａ",
	}, { // 1955
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\n␉υＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␉Ａ",
		out:  "␊␉υＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␉Ａ",
	}, { // 1956
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\n\tυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝␉",
		out:  "␊\tυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝␉",
	}, { // 1957
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\n␉υＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝␉",
		out:  "␊␉υＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝␉",
	}, { // 1958
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\nＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο\tＡ",
		out:  "␊ＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο\tＡ",
	}, { // 1959
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\nＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␉Ａ",
		out:  "␊ＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␉Ａ",
	}, { // 1960
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\nＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο\t␉",
		out:  "␊ＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο\t␉",
	}, { // 1961
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\nＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␉␉",
		out:  "␊ＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␉␉",
	}, { // 1962
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\nＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝\t",
		out:  "␊ＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝\t",
	}, { // 1963
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\nＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝␉",
		out:  "␊ＮυＧ\x19Ｑ\x1a␒\rρ\t?Jψ-ψ\x0f９\"／＊<φEG／４ο␝␉",
	}, { // 1964
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｃτ｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19t",
		out:  "Ｃτ｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19t",
	}, { // 1965
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\n␊｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19t",
		out:  "␊␊｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19t",
	}, { // 1966
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␊␊｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19t",
		out:  "‛␊␊｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19t",
	}, { // 1967
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\nτ｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［␊t",
		out:  "␊τ｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［␊t",
	}, { // 1968
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␊τ｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［␊t",
		out:  "‛␊τ｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［␊t",
	}, { // 1969
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\nτ｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19␊",
		out:  "␊τ｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19␊",
	}, { // 1970
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␊τ｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19␊",
		out:  "‛␊τ｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19␊",
	}, { // 1971
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｃ\n｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19t",
		out:  "Ｃ\n｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19t",
	}, { // 1972
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｃ␊｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19t",
		out:  "Ｃ␊｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19t",
	}, { // 1973
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｃ\n｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［␊t",
		out:  "Ｃ\n｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［␊t",
	}, { // 1974
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｃ␊｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［␊t",
		out:  "Ｃ␊｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［␊t",
	}, { // 1975
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｃ\n｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19␊",
		out:  "Ｃ\n｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19␊",
	}, { // 1976
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｃ␊｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19␊",
		out:  "Ｃ␊｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19␊",
	}, { // 1977
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｃτ｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\nt",
		out:  "Ｃτ｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\nt",
	}, { // 1978
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｃτ｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［␊t",
		out:  "Ｃτ｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［␊t",
	}, { // 1979
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｃτ｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\n␊",
		out:  "Ｃτ｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\n␊",
	}, { // 1980
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｃτ｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［␊␊",
		out:  "Ｃτ｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［␊␊",
	}, { // 1981
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｃτ｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19\n",
		out:  "Ｃτ｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19\n",
	}, { // 1982
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｃτ｜ν␝\x16ｏ｀\a^\nH#ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19␊",
		out:  "Ｃτ｜ν␝\x16ｏ｀\a^\nH＃ωLδＬχ＋Ｇ␡␁\x0e/ｉδ\b［\x19␊",
	}, { // 1983
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ｄＪλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷg",
		out:  "ｄＪλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷg",
	}, { // 1984
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\v␋λ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷg",
		out:  "␋␋λ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷg",
	}, { // 1985
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␋␋λ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷg",
		out:  "‛␋␋λ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷg",
	}, { // 1986
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\vＪλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8π␋g",
		out:  "␋Ｊλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8π␋g",
	}, { // 1987
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␋Ｊλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8π␋g",
		out:  "‛␋Ｊλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8π␋g",
	}, { // 1988
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\vＪλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷ␋",
		out:  "␋Ｊλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷ␋",
	}, { // 1989
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␋Ｊλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷ␋",
		out:  "‛␋Ｊλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷ␋",
	}, { // 1990
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ｄ\vλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷg",
		out:  "ｄ\vλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷg",
	}, { // 1991
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ｄ␋λ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷg",
		out:  "ｄ␋λ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷg",
	}, { // 1992
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ｄ\vλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8π␋g",
		out:  "ｄ\vλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8π␋g",
	}, { // 1993
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ｄ␋λ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8π␋g",
		out:  "ｄ␋λ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8π␋g",
	}, { // 1994
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ｄ\vλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷ␋",
		out:  "ｄ\vλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷ␋",
	}, { // 1995
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ｄ␋λ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷ␋",
		out:  "ｄ␋λ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷ␋",
	}, { // 1996
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ｄＪλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8π\vg",
		out:  "ｄＪλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8π\vg",
	}, { // 1997
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ｄＪλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8π␋g",
		out:  "ｄＪλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8π␋g",
	}, { // 1998
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ｄＪλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8π\v␋",
		out:  "ｄＪλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8π\v␋",
	}, { // 1999
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ｄＪλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8π␋␋",
		out:  "ｄＪλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8π␋␋",
	}, { // 2000
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ｄＪλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷ\v",
		out:  "ｄＪλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷ\v",
	}, { // 2001
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ｄＪλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷ␋",
		out:  "ｄＪλ␕｜,λ␝＞\x18\v\x0e／Ｆh．<６\x05ξβ\x16ξ＜$[8πＷ␋",
	}, { // 2002
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυｔ",
		out:  "υ（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυｔ",
	}, { // 2003
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\r␍␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυｔ",
		out:  "␍␍␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυｔ",
	}, { // 2004
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␍␍␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυｔ",
		out:  "‛␍␍␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυｔ",
	}, { // 2005
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\r（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚU␍ｔ",
		out:  "␍（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚU␍ｔ",
	}, { // 2006
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␍（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚU␍ｔ",
		out:  "‛␍（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚU␍ｔ",
	}, { // 2007
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\r（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυ␍",
		out:  "␍（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυ␍",
	}, { // 2008
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␍（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυ␍",
		out:  "‛␍（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυ␍",
	}, { // 2009
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ\r␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυｔ",
		out:  "υ\r␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυｔ",
	}, { // 2010
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ␍␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυｔ",
		out:  "υ␍␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυｔ",
	}, { // 2011
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ\r␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚU␍ｔ",
		out:  "υ\r␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚU␍ｔ",
	}, { // 2012
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ␍␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚU␍ｔ",
		out:  "υ␍␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚU␍ｔ",
	}, { // 2013
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ\r␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυ␍",
		out:  "υ\r␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυ␍",
	}, { // 2014
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ␍␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυ␍",
		out:  "υ␍␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυ␍",
	}, { // 2015
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚU\rｔ",
		out:  "υ（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚU\rｔ",
	}, { // 2016
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚU␍ｔ",
		out:  "υ（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚU␍ｔ",
	}, { // 2017
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚU\r␍",
		out:  "υ（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚU\r␍",
	}, { // 2018
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚU␍␍",
		out:  "υ（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚU␍␍",
	}, { // 2019
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυ\r",
		out:  "υ（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυ\r",
	}, { // 2020
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυ␍",
		out:  "υ（␃ＡGδ␉？\vA\r␉７υ7\x1fXＦ␛\x1e\x1c␎:ξNγｚUυ␍",
	}, { // 2021
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ιQ｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␆",
		out:  "ιQ｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␆",
	}, { // 2022
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\t␉｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␆",
		out:  "␉␉｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␆",
	}, { // 2023
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␉␉｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␆",
		out:  "‛␉␉｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␆",
	}, { // 2024
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\tQ｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+␉␆",
		out:  "␉Q｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+␉␆",
	}, { // 2025
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␉Q｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+␉␆",
		out:  "‛␉Q｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+␉␆",
	}, { // 2026
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\tQ｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␉",
		out:  "␉Q｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␉",
	}, { // 2027
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␉Q｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␉",
		out:  "‛␉Q｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␉",
	}, { // 2028
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ι\t｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␆",
		out:  "ι\t｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␆",
	}, { // 2029
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ι␉｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␆",
		out:  "ι␉｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␆",
	}, { // 2030
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ι\t｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+␉␆",
		out:  "ι\t｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+␉␆",
	}, { // 2031
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ι␉｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+␉␆",
		out:  "ι␉｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+␉␆",
	}, { // 2032
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ι\t｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␉",
		out:  "ι\t｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␉",
	}, { // 2033
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ι␉｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␉",
		out:  "ι␉｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␉",
	}, { // 2034
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ιQ｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+\t␆",
		out:  "ιQ｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+\t␆",
	}, { // 2035
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ιQ｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+␉␆",
		out:  "ιQ｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+␉␆",
	}, { // 2036
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ιQ｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+\t␉",
		out:  "ιQ｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+\t␉",
	}, { // 2037
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ιQ｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+␉␉",
		out:  "ιQ｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+␉␉",
	}, { // 2038
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ιQ｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝\t",
		out:  "ιQ｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝\t",
	}, { // 2039
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ιQ｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␉",
		out:  "ιQ｜␐οｂＤ\x1aητ\t８π␛\x1fｑK＄\x06Nm[ｊ\x05\x1eα␓+｝␉",
	}, { // 2040
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\x19｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［t７",
		out:  "\x19｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［t７",
	}, { // 2041
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n␊μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［t７",
		out:  "␊␊μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［t７",
	}, { // 2042
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊␊μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［t７",
		out:  "‛␊␊μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［t７",
	}, { // 2043
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［␊７",
		out:  "␊｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［␊７",
	}, { // 2044
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［␊７",
		out:  "‛␊｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［␊７",
	}, { // 2045
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［t␊",
		out:  "␊｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［t␊",
	}, { // 2046
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［t␊",
		out:  "‛␊｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［t␊",
	}, { // 2047
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\x19\nμ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［t７",
		out:  "\x19\nμ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［t７",
	}, { // 2048
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\x19␊μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［t７",
		out:  "\x19␊μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［t７",
	}, { // 2049
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\x19\nμ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［␊７",
		out:  "\x19\nμ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［␊７",
	}, { // 2050
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\x19␊μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［␊７",
		out:  "\x19␊μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［␊７",
	}, { // 2051
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\x19\nμ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［t␊",
		out:  "\x19\nμ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［t␊",
	}, { // 2052
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\x19␊μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［t␊",
		out:  "\x19␊μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［t␊",
	}, { // 2053
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\x19｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［\n７",
		out:  "\x19｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［\n７",
	}, { // 2054
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\x19｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［␊７",
		out:  "\x19｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［␊７",
	}, { // 2055
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\x19｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［\n␊",
		out:  "\x19｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［\n␊",
	}, { // 2056
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\x19｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［␊␊",
		out:  "\x19｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［␊␊",
	}, { // 2057
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\x19｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［t\n",
		out:  "\x19｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［t\n",
	}, { // 2058
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\x19｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／␀\x15υνM［t␊",
		out:  "\x19｜μ\t␘\"ωＢ␋␚\nＲ\x04β πq\b＇uｊ／‛␀\x15υνM［t␊",
	}, { // 2059
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "λ$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z␀",
		out:  "λ$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z‛␀",
	}, { // 2060
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\v␋ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z␀",
		out:  "␋␋ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z‛␀",
	}, { // 2061
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␋␋ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z␀",
		out:  "‛␋␋ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z‛␀",
	}, { // 2062
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\v$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒␋␀",
		out:  "␋$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒␋‛␀",
	}, { // 2063
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␋$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒␋␀",
		out:  "‛␋$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒␋‛␀",
	}, { // 2064
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\v$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z␋",
		out:  "␋$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z␋",
	}, { // 2065
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␋$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z␋",
		out:  "‛␋$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z␋",
	}, { // 2066
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "λ\vｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z␀",
		out:  "λ\vｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z‛␀",
	}, { // 2067
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "λ␋ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z␀",
		out:  "λ␋ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z‛␀",
	}, { // 2068
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "λ\vｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒␋␀",
		out:  "λ\vｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒␋‛␀",
	}, { // 2069
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "λ␋ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒␋␀",
		out:  "λ␋ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒␋‛␀",
	}, { // 2070
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "λ\vｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z␋",
		out:  "λ\vｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z␋",
	}, { // 2071
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "λ␋ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z␋",
		out:  "λ␋ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z␋",
	}, { // 2072
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "λ$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒\v␀",
		out:  "λ$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒\v‛␀",
	}, { // 2073
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "λ$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒␋␀",
		out:  "λ$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒␋‛␀",
	}, { // 2074
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "λ$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒\v␋",
		out:  "λ$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒\v␋",
	}, { // 2075
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "λ$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒␋␋",
		out:  "λ$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒␋␋",
	}, { // 2076
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "λ$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z\v",
		out:  "λ$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z\v",
	}, { // 2077
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "λ$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z␋",
		out:  "λ$ｎν3ｂ\x17φ０␐\vｈ/_␅σｏ\x1f\b␔λ！［θ\"Oh␒z␋",
	}, { // 2078
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\"２：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15Ｖ",
		out:  "\"２：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15Ｖ",
	}, { // 2079
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\r␍：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15Ｖ",
		out:  "␍␍：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15Ｖ",
	}, { // 2080
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␍␍：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15Ｖ",
		out:  "‛␍␍：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15Ｖ",
	}, { // 2081
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\r２：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4␍Ｖ",
		out:  "␍２：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4␍Ｖ",
	}, { // 2082
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␍２：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4␍Ｖ",
		out:  "‛␍２：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4␍Ｖ",
	}, { // 2083
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\r２：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15␍",
		out:  "␍２：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15␍",
	}, { // 2084
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␍２：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15␍",
		out:  "‛␍２：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15␍",
	}, { // 2085
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\"\r：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15Ｖ",
		out:  "\"\r：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15Ｖ",
	}, { // 2086
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\"␍：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15Ｖ",
		out:  "\"␍：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15Ｖ",
	}, { // 2087
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\"\r：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4␍Ｖ",
		out:  "\"\r：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4␍Ｖ",
	}, { // 2088
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\"␍：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4␍Ｖ",
		out:  "\"␍：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4␍Ｖ",
	}, { // 2089
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\"\r：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15␍",
		out:  "\"\r：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15␍",
	}, { // 2090
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\"␍：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15␍",
		out:  "\"␍：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15␍",
	}, { // 2091
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\"２：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\rＶ",
		out:  "\"２：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\rＶ",
	}, { // 2092
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\"２：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4␍Ｖ",
		out:  "\"２：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4␍Ｖ",
	}, { // 2093
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\"２：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\r␍",
		out:  "\"２：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\r␍",
	}, { // 2094
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\"２：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4␍␍",
		out:  "\"２：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4␍␍",
	}, { // 2095
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\"２：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15\r",
		out:  "\"２：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15\r",
	}, { // 2096
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\"２：ω@ς`％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15␍",
		out:  "\"２：ω@ς`‛％？４\r］ο\x0eξａｚ}␃\x1cM７υ｜Wpγ4\x15␍",
	}, { // 2097
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "πG␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ\x16",
		out:  "πG␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ\x16",
	}, { // 2098
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\t␉␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ\x16",
		out:  "␉␉␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ\x16",
	}, { // 2099
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉␉␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ\x16",
		out:  "‛␉␉␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ\x16",
	}, { // 2100
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\tG␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψD␉\x16",
		out:  "␉G␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψD␉\x16",
	}, { // 2101
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉G␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψD␉\x16",
		out:  "‛␉G␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψD␉\x16",
	}, { // 2102
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\tG␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ␉",
		out:  "␉G␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ␉",
	}, { // 2103
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉G␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ␉",
		out:  "‛␉G␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ␉",
	}, { // 2104
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "π\t␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ\x16",
		out:  "π\t␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ\x16",
	}, { // 2105
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "π␉␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ\x16",
		out:  "π␉␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ\x16",
	}, { // 2106
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "π\t␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψD␉\x16",
		out:  "π\t␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψD␉\x16",
	}, { // 2107
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "π␉␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψD␉\x16",
		out:  "π␉␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψD␉\x16",
	}, { // 2108
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "π\t␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ␉",
		out:  "π\t␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ␉",
	}, { // 2109
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "π␉␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ␉",
		out:  "π␉␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ␉",
	}, { // 2110
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "πG␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψD\t\x16",
		out:  "πG␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψD\t\x16",
	}, { // 2111
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "πG␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψD␉\x16",
		out:  "πG␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψD␉\x16",
	}, { // 2112
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "πG␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψD\t␉",
		out:  "πG␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψD\t␉",
	}, { // 2113
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "πG␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψD␉␉",
		out:  "πG␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψD␉␉",
	}, { // 2114
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "πG␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ\t",
		out:  "πG␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ\t",
	}, { // 2115
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "πG␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ␉",
		out:  "πG␃τ&|␏^␗Ｊ\tιξｗｐ８wＮ+δ␚␗␔$\n\x1fψDＤ␉",
	}, { // 2116
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\\Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14Ｄ",
		out:  "＼Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14Ｄ",
	}, { // 2117
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\n␊εδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14Ｄ",
		out:  "␊␊εδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14Ｄ",
	}, { // 2118
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊␊εδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14Ｄ",
		out:  "‛␊␊εδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14Ｄ",
	}, { // 2119
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\nＦεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇␊Ｄ",
		out:  "␊Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇␊Ｄ",
	}, { // 2120
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇␊Ｄ",
		out:  "‛␊Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇␊Ｄ",
	}, { // 2121
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\nＦεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14␊",
		out:  "␊Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14␊",
	}, { // 2122
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14␊",
		out:  "‛␊Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14␊",
	}, { // 2123
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\\\nεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14Ｄ",
		out:  "＼\nεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14Ｄ",
	}, { // 2124
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\\␊εδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14Ｄ",
		out:  "＼␊εδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14Ｄ",
	}, { // 2125
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\\\nεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇␊Ｄ",
		out:  "＼\nεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇␊Ｄ",
	}, { // 2126
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\\␊εδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇␊Ｄ",
		out:  "＼␊εδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇␊Ｄ",
	}, { // 2127
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\\\nεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14␊",
		out:  "＼\nεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14␊",
	}, { // 2128
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\\␊εδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14␊",
		out:  "＼␊εδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14␊",
	}, { // 2129
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\\Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\nＤ",
		out:  "＼Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\nＤ",
	}, { // 2130
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\\Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇␊Ｄ",
		out:  "＼Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇␊Ｄ",
	}, { // 2131
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\\Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\n␊",
		out:  "＼Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\n␊",
	}, { // 2132
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\\Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇␊␊",
		out:  "＼Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇␊␊",
	}, { // 2133
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\\Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14\n",
		out:  "＼Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14\n",
	}, { // 2134
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\\Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14␊",
		out:  "＼Ｆεδς␂／\x15οｍ\n␃|␖ａφo'６/Xγr`\x16%␃␇\x14␊",
	}, { // 2135
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊\x00\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:δ",
		out:  "‛␊␀\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:δ",
	}, { // 2136
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\v␋\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:δ",
		out:  "␋␋\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:δ",
	}, { // 2137
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␋␋\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:δ",
		out:  "‛␋␋\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:δ",
	}, { // 2138
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\v\x00\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜␋δ",
		out:  "␋␀\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜␋δ",
	}, { // 2139
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␋\x00\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜␋δ",
		out:  "‛␋␀\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜␋δ",
	}, { // 2140
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\v\x00\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:␋",
		out:  "␋␀\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:␋",
	}, { // 2141
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␋\x00\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:␋",
		out:  "‛␋␀\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:␋",
	}, { // 2142
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊\v\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:δ",
		out:  "‛␊\v\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:δ",
	}, { // 2143
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊␋\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:δ",
		out:  "‛␊␋\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:δ",
	}, { // 2144
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊\v\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜␋δ",
		out:  "‛␊\v\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜␋δ",
	}, { // 2145
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊␋\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜␋δ",
		out:  "‛␊␋\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜␋δ",
	}, { // 2146
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊\v\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:␋",
		out:  "‛␊\v\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:␋",
	}, { // 2147
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊␋\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:␋",
		out:  "‛␊␋\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:␋",
	}, { // 2148
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊\x00\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜\vδ",
		out:  "‛␊␀\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜\vδ",
	}, { // 2149
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊\x00\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜␋δ",
		out:  "‛␊␀\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜␋δ",
	}, { // 2150
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊\x00\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜\v␋",
		out:  "‛␊␀\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜\v␋",
	}, { // 2151
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊\x00\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜␋␋",
		out:  "‛␊␀\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜␋␋",
	}, { // 2152
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊\x00\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:\v",
		out:  "‛␊␀\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:\v",
	}, { // 2153
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊\x00\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:␋",
		out:  "‛␊␀\x17*␂λＺμＵＧ\vβ］\bβO␖*＾\b\n２J␘{>␔｜:␋",
	}, { // 2154
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "１＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␎",
		out:  "１＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␎",
	}, { // 2155
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\r␍>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␎",
		out:  "␍␍>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␎",
	}, { // 2156
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍␍>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␎",
		out:  "‛␍␍>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␎",
	}, { // 2157
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\r＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0␍␎",
		out:  "␍＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0␍␎",
	}, { // 2158
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0␍␎",
		out:  "‛␍＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0␍␎",
	}, { // 2159
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\r＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␍",
		out:  "␍＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␍",
	}, { // 2160
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␍",
		out:  "‛␍＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␍",
	}, { // 2161
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "１\r>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␎",
		out:  "１\r>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␎",
	}, { // 2162
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "１␍>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␎",
		out:  "１␍>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␎",
	}, { // 2163
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "１\r>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0␍␎",
		out:  "１\r>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0␍␎",
	}, { // 2164
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "１␍>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0␍␎",
		out:  "１␍>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0␍␎",
	}, { // 2165
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "１\r>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␍",
		out:  "１\r>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␍",
	}, { // 2166
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "１␍>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␍",
		out:  "１␍>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␍",
	}, { // 2167
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "１＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\r␎",
		out:  "１＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\r␎",
	}, { // 2168
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "１＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0␍␎",
		out:  "１＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0␍␎",
	}, { // 2169
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "１＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\r␍",
		out:  "１＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\r␍",
	}, { // 2170
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "１＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0␍␍",
		out:  "１＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0␍␍",
	}, { // 2171
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "１＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15\r",
		out:  "１＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15\r",
	}, { // 2172
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "１＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␍",
		out:  "１＊>␈Ｃ␟4ｈ$\n\rw3｜δψ\x1cξ`Bｄ＄μ＄ω'σ0\x15␍",
	}, { // 2173
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "π@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β\x0f",
		out:  "π@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β\x0f",
	}, { // 2174
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\t␉\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β\x0f",
		out:  "␉␉\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β\x0f",
	}, { // 2175
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␉␉\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β\x0f",
		out:  "‛␉␉\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β\x0f",
	}, { // 2176
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\t@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|␉\x0f",
		out:  "␉@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|␉\x0f",
	}, { // 2177
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␉@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|␉\x0f",
		out:  "‛␉@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|␉\x0f",
	}, { // 2178
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\t@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β␉",
		out:  "␉@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β␉",
	}, { // 2179
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␉@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β␉",
		out:  "‛␉@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β␉",
	}, { // 2180
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "π\t\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β\x0f",
		out:  "π\t\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β\x0f",
	}, { // 2181
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "π␉\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β\x0f",
		out:  "π␉\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β\x0f",
	}, { // 2182
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "π\t\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|␉\x0f",
		out:  "π\t\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|␉\x0f",
	}, { // 2183
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "π␉\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|␉\x0f",
		out:  "π␉\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|␉\x0f",
	}, { // 2184
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "π\t\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β␉",
		out:  "π\t\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β␉",
	}, { // 2185
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "π␉\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β␉",
		out:  "π␉\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β␉",
	}, { // 2186
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "π@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|\t\x0f",
		out:  "π@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|\t\x0f",
	}, { // 2187
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "π@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|␉\x0f",
		out:  "π@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|␉\x0f",
	}, { // 2188
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "π@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|\t␉",
		out:  "π@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|\t␉",
	}, { // 2189
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "π@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|␉␉",
		out:  "π@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|␉␉",
	}, { // 2190
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "π@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β\t",
		out:  "π@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β\t",
	}, { // 2191
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "π@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β␉",
		out:  "π@\x11*K\x1d␃I.［\t＂]␓␆νX＠␇υＱθδ␆８Ｈy|β␉",
	}, { // 2192
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "｀:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘/",
		out:  "｀:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘/",
	}, { // 2193
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\n␊\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘/",
		out:  "␊␊\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘/",
	}, { // 2194
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␊␊\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘/",
		out:  "‛␊␊\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘/",
	}, { // 2195
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\n:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␊/",
		out:  "␊:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␊/",
	}, { // 2196
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␊:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␊/",
		out:  "‛␊:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␊/",
	}, { // 2197
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\n:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘␊",
		out:  "␊:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘␊",
	}, { // 2198
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␊:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘␊",
		out:  "‛␊:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘␊",
	}, { // 2199
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "｀\n\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘/",
		out:  "｀\n\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘/",
	}, { // 2200
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "｀␊\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘/",
		out:  "｀␊\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘/",
	}, { // 2201
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "｀\n\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␊/",
		out:  "｀\n\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␊/",
	}, { // 2202
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "｀␊\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␊/",
		out:  "｀␊\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␊/",
	}, { // 2203
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "｀\n\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘␊",
		out:  "｀\n\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘␊",
	}, { // 2204
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "｀␊\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘␊",
		out:  "｀␊\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘␊",
	}, { // 2205
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "｀:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη\n/",
		out:  "｀:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη\n/",
	}, { // 2206
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "｀:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␊/",
		out:  "｀:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␊/",
	}, { // 2207
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "｀:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη\n␊",
		out:  "｀:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη\n␊",
	}, { // 2208
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "｀:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␊␊",
		out:  "｀:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␊␊",
	}, { // 2209
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "｀:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘\n",
		out:  "｀:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘\n",
	}, { // 2210
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "｀:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘␊",
		out:  "｀:\x11t\nZ？５\"ζ\n#ｓｍ\x16>］]␅ωι␟ｑ␑οｕνη␘␊",
	}, { // 2211
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␃／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ\x17",
		out:  "␃／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ\x17",
	}, { // 2212
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\v␋E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ\x17",
		out:  "␋␋E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ\x17",
	}, { // 2213
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␋␋E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ\x17",
		out:  "‛␋␋E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ\x17",
	}, { // 2214
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\v／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄␋\x17",
		out:  "␋／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄␋\x17",
	}, { // 2215
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␋／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄␋\x17",
		out:  "‛␋／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄␋\x17",
	}, { // 2216
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\v／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ␋",
		out:  "␋／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ␋",
	}, { // 2217
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␋／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ␋",
		out:  "‛␋／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ␋",
	}, { // 2218
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␃\vE␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ\x17",
		out:  "␃\vE␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ\x17",
	}, { // 2219
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␃␋E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ\x17",
		out:  "␃␋E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ\x17",
	}, { // 2220
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␃\vE␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄␋\x17",
		out:  "␃\vE␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄␋\x17",
	}, { // 2221
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␃␋E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄␋\x17",
		out:  "␃␋E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄␋\x17",
	}, { // 2222
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␃\vE␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ␋",
		out:  "␃\vE␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ␋",
	}, { // 2223
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␃␋E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ␋",
		out:  "␃␋E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ␋",
	}, { // 2224
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␃／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄\v\x17",
		out:  "␃／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄\v\x17",
	}, { // 2225
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␃／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄␋\x17",
		out:  "␃／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄␋\x17",
	}, { // 2226
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␃／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄\v␋",
		out:  "␃／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄\v␋",
	}, { // 2227
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␃／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄␋␋",
		out:  "␃／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄␋␋",
	}, { // 2228
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␃／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ\v",
		out:  "␃／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ\v",
	}, { // 2229
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␃／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ␋",
		out:  "␃／E␜\x19２\v｝ξ}\vυ３ｌυ＜e␞γ|␙*\vG\x11ｕρ␄θ␋",
	}, { // 2230
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x06Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!＇",
		out:  "\x06Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!＇",
	}, { // 2231
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\r␍＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!＇",
		out:  "␍␍＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!＇",
	}, { // 2232
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␍␍＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!＇",
		out:  "‛␍␍＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!＇",
	}, { // 2233
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\rＱ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ␍＇",
		out:  "␍Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ␍＇",
	}, { // 2234
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␍Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ␍＇",
		out:  "‛␍Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ␍＇",
	}, { // 2235
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\rＱ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!␍",
		out:  "␍Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!␍",
	}, { // 2236
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␍Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!␍",
		out:  "‛␍Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!␍",
	}, { // 2237
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x06\r＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!＇",
		out:  "\x06\r＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!＇",
	}, { // 2238
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x06␍＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!＇",
		out:  "\x06␍＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!＇",
	}, { // 2239
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x06\r＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ␍＇",
		out:  "\x06\r＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ␍＇",
	}, { // 2240
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x06␍＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ␍＇",
		out:  "\x06␍＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ␍＇",
	}, { // 2241
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x06\r＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!␍",
		out:  "\x06\r＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!␍",
	}, { // 2242
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x06␍＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!␍",
		out:  "\x06␍＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!␍",
	}, { // 2243
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x06Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ\r＇",
		out:  "\x06Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ\r＇",
	}, { // 2244
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x06Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ␍＇",
		out:  "\x06Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ␍＇",
	}, { // 2245
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x06Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ\r␍",
		out:  "\x06Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ\r␍",
	}, { // 2246
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x06Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ␍␍",
		out:  "\x06Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ␍␍",
	}, { // 2247
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x06Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!\r",
		out:  "\x06Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!\r",
	}, { // 2248
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x06Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!␍",
		out:  "\x06Ｑ＜\x1eν?\x1b␘ι␅\rｐ\x19\x0e!｜␅Wο#ｌζς\x06␚␙ｈμ!␍",
	}, { // 2249
		mask: EncodeRightSpace,
		in:   " ",
		out:  "␠",
	}, { // 2250
		mask: EncodeZero | EncodeRightSpace,
		in:   "␛␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％c",
		out:  "␛␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％c",
	}, { // 2251
		mask: EncodeZero | EncodeRightSpace,
		in:   " ␠Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％c",
		out:  " ␠Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％c",
	}, { // 2252
		mask: EncodeZero | EncodeRightSpace,
		in:   "␠␠Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％c",
		out:  "␠␠Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％c",
	}, { // 2253
		mask: EncodeZero | EncodeRightSpace,
		in:   " ␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I␠c",
		out:  " ␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I␠c",
	}, { // 2254
		mask: EncodeZero | EncodeRightSpace,
		in:   "␠␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I␠c",
		out:  "␠␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I␠c",
	}, { // 2255
		mask: EncodeZero | EncodeRightSpace,
		in:   " ␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％␠",
		out:  " ␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％‛␠",
	}, { // 2256
		mask: EncodeZero | EncodeRightSpace,
		in:   "␠␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％␠",
		out:  "␠␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％‛␠",
	}, { // 2257
		mask: EncodeZero | EncodeRightSpace,
		in:   "␛ Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％c",
		out:  "␛ Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％c",
	}, { // 2258
		mask: EncodeZero | EncodeRightSpace,
		in:   "␛␠Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％c",
		out:  "␛␠Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％c",
	}, { // 2259
		mask: EncodeZero | EncodeRightSpace,
		in:   "␛ Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I␠c",
		out:  "␛ Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I␠c",
	}, { // 2260
		mask: EncodeZero | EncodeRightSpace,
		in:   "␛␠Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I␠c",
		out:  "␛␠Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I␠c",
	}, { // 2261
		mask: EncodeZero | EncodeRightSpace,
		in:   "␛ Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％␠",
		out:  "␛ Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％‛␠",
	}, { // 2262
		mask: EncodeZero | EncodeRightSpace,
		in:   "␛␠Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％␠",
		out:  "␛␠Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％‛␠",
	}, { // 2263
		mask: EncodeZero | EncodeRightSpace,
		in:   "␛␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I c",
		out:  "␛␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I c",
	}, { // 2264
		mask: EncodeZero | EncodeRightSpace,
		in:   "␛␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I␠c",
		out:  "␛␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I␠c",
	}, { // 2265
		mask: EncodeZero | EncodeRightSpace,
		in:   "␛␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I ␠",
		out:  "␛␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I ‛␠",
	}, { // 2266
		mask: EncodeZero | EncodeRightSpace,
		in:   "␛␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I␠␠",
		out:  "␛␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I␠‛␠",
	}, { // 2267
		mask: EncodeZero | EncodeRightSpace,
		in:   "␛␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％ ",
		out:  "␛␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％␠",
	}, { // 2268
		mask: EncodeZero | EncodeRightSpace,
		in:   "␛␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％␠",
		out:  "␛␑Ep＃τｌ\x19Ｚ\f ρ]οξ｀␇Ｕ\a\x02Ｔα␎&\x1aｏ]I％‛␠",
	}, { // 2269
		mask: EncodeSlash | EncodeRightSpace,
		in:   "_（␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"Ｑλ",
		out:  "_（␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"Ｑλ",
	}, { // 2270
		mask: EncodeSlash | EncodeRightSpace,
		in:   " ␠␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"Ｑλ",
		out:  " ␠␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"Ｑλ",
	}, { // 2271
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␠␠␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"Ｑλ",
		out:  "␠␠␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"Ｑλ",
	}, { // 2272
		mask: EncodeSlash | EncodeRightSpace,
		in:   " （␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"␠λ",
		out:  " （␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"␠λ",
	}, { // 2273
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␠（␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"␠λ",
		out:  "␠（␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"␠λ",
	}, { // 2274
		mask: EncodeSlash | EncodeRightSpace,
		in:   " （␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"Ｑ␠",
		out:  " （␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"Ｑ‛␠",
	}, { // 2275
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␠（␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"Ｑ␠",
		out:  "␠（␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"Ｑ‛␠",
	}, { // 2276
		mask: EncodeSlash | EncodeRightSpace,
		in:   "_ ␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"Ｑλ",
		out:  "_ ␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"Ｑλ",
	}, { // 2277
		mask: EncodeSlash | EncodeRightSpace,
		in:   "_␠␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"Ｑλ",
		out:  "_␠␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"Ｑλ",
	}, { // 2278
		mask: EncodeSlash | EncodeRightSpace,
		in:   "_ ␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"␠λ",
		out:  "_ ␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"␠λ",
	}, { // 2279
		mask: EncodeSlash | EncodeRightSpace,
		in:   "_␠␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"␠λ",
		out:  "_␠␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"␠λ",
	}, { // 2280
		mask: EncodeSlash | EncodeRightSpace,
		in:   "_ ␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"Ｑ␠",
		out:  "_ ␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"Ｑ‛␠",
	}, { // 2281
		mask: EncodeSlash | EncodeRightSpace,
		in:   "_␠␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"Ｑ␠",
		out:  "_␠␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"Ｑ‛␠",
	}, { // 2282
		mask: EncodeSlash | EncodeRightSpace,
		in:   "_（␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\" λ",
		out:  "_（␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\" λ",
	}, { // 2283
		mask: EncodeSlash | EncodeRightSpace,
		in:   "_（␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"␠λ",
		out:  "_（␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"␠λ",
	}, { // 2284
		mask: EncodeSlash | EncodeRightSpace,
		in:   "_（␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\" ␠",
		out:  "_（␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\" ‛␠",
	}, { // 2285
		mask: EncodeSlash | EncodeRightSpace,
		in:   "_（␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"␠␠",
		out:  "_（␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"␠‛␠",
	}, { // 2286
		mask: EncodeSlash | EncodeRightSpace,
		in:   "_（␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"Ｑ ",
		out:  "_（␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"Ｑ␠",
	}, { // 2287
		mask: EncodeSlash | EncodeRightSpace,
		in:   "_（␋εＯ%␄ε*｜ ４ｇ/␌πh\x16．λk␅$4＞γ\x11\"Ｑ␠",
		out:  "_（␋εＯ%␄ε*｜ ４ｇ／␌πh\x16．λk␅$4＞γ\x11\"Ｑ‛␠",
	}, { // 2288
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "_ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι$",
		out:  "_ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι$",
	}, { // 2289
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   " ␠ςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι$",
		out:  " ␠ςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι$",
	}, { // 2290
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␠␠ςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι$",
		out:  "␠␠ςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι$",
	}, { // 2291
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   " ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜␠$",
		out:  " ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜␠$",
	}, { // 2292
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␠ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜␠$",
		out:  "␠ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜␠$",
	}, { // 2293
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   " ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι␠",
		out:  " ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι‛␠",
	}, { // 2294
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␠ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι␠",
		out:  "␠ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι‛␠",
	}, { // 2295
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "_ ςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι$",
		out:  "_ ςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι$",
	}, { // 2296
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "_␠ςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι$",
		out:  "_␠ςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι$",
	}, { // 2297
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "_ ςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜␠$",
		out:  "_ ςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜␠$",
	}, { // 2298
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "_␠ςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜␠$",
		out:  "_␠ςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜␠$",
	}, { // 2299
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "_ ςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι␠",
		out:  "_ ςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι‛␠",
	}, { // 2300
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "_␠ςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι␠",
		out:  "_␠ςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι‛␠",
	}, { // 2301
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "_ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ $",
		out:  "_ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ $",
	}, { // 2302
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "_ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜␠$",
		out:  "_ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜␠$",
	}, { // 2303
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "_ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ ␠",
		out:  "_ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ ‛␠",
	}, { // 2304
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "_ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜␠␠",
		out:  "_ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜␠‛␠",
	}, { // 2305
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "_ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι ",
		out:  "_ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι␠",
	}, { // 2306
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "_ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι␠",
		out:  "_ςςγ\x1b␟ζ＾\x19＂ ＞Irｎ\x1bοD8／ｍ\x19␑５3␓\x14＜ι‛␠",
	}, { // 2307
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "Ｘ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~␜",
		out:  "Ｘ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~␜",
	}, { // 2308
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   " ␠βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~␜",
		out:  " ␠βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~␜",
	}, { // 2309
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "␠␠βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~␜",
		out:  "␠␠βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~␜",
	}, { // 2310
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   " ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!␠␜",
		out:  " ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!␠␜",
	}, { // 2311
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "␠␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!␠␜",
		out:  "␠␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!␠␜",
	}, { // 2312
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   " ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~␠",
		out:  " ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~‛␠",
	}, { // 2313
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "␠␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~␠",
		out:  "␠␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~‛␠",
	}, { // 2314
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "Ｘ βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~␜",
		out:  "Ｘ βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~␜",
	}, { // 2315
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "Ｘ␠βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~␜",
		out:  "Ｘ␠βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~␜",
	}, { // 2316
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "Ｘ βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!␠␜",
		out:  "Ｘ βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!␠␜",
	}, { // 2317
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "Ｘ␠βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!␠␜",
		out:  "Ｘ␠βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!␠␜",
	}, { // 2318
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "Ｘ βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~␠",
		out:  "Ｘ βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~‛␠",
	}, { // 2319
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "Ｘ␠βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~␠",
		out:  "Ｘ␠βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~‛␠",
	}, { // 2320
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "Ｘ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑! ␜",
		out:  "Ｘ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑! ␜",
	}, { // 2321
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "Ｘ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!␠␜",
		out:  "Ｘ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!␠␜",
	}, { // 2322
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "Ｘ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑! ␠",
		out:  "Ｘ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑! ‛␠",
	}, { // 2323
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "Ｘ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!␠␠",
		out:  "Ｘ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!␠‛␠",
	}, { // 2324
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "Ｘ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~ ",
		out:  "Ｘ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~␠",
	}, { // 2325
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "Ｘ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~␠",
		out:  "Ｘ␍βＦ\fα'κυ？ ｆ\x19uλ\x1diＤx␐σ␊ａ*Ｍ\u007f␑!~‛␠",
	}, { // 2326
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "\nnσＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／ρ␛",
		out:  "\nnσＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／ρ␛",
	}, { // 2327
		mask: EncodeLtGt | EncodeRightSpace,
		in:   " ␠σＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／ρ␛",
		out:  " ␠σＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／ρ␛",
	}, { // 2328
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "␠␠σＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／ρ␛",
		out:  "␠␠σＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／ρ␛",
	}, { // 2329
		mask: EncodeLtGt | EncodeRightSpace,
		in:   " nσＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／␠␛",
		out:  " nσＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／␠␛",
	}, { // 2330
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "␠nσＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／␠␛",
		out:  "␠nσＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／␠␛",
	}, { // 2331
		mask: EncodeLtGt | EncodeRightSpace,
		in:   " nσＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／ρ␠",
		out:  " nσＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／ρ‛␠",
	}, { // 2332
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "␠nσＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／ρ␠",
		out:  "␠nσＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／ρ‛␠",
	}, { // 2333
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "\n σＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／ρ␛",
		out:  "\n σＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／ρ␛",
	}, { // 2334
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "\n␠σＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／ρ␛",
		out:  "\n␠σＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／ρ␛",
	}, { // 2335
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "\n σＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／␠␛",
		out:  "\n σＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／␠␛",
	}, { // 2336
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "\n␠σＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／␠␛",
		out:  "\n␠σＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／␠␛",
	}, { // 2337
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "\n σＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／ρ␠",
		out:  "\n σＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／ρ‛␠",
	}, { // 2338
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "\n␠σＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／ρ␠",
		out:  "\n␠σＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／ρ‛␠",
	}, { // 2339
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "\nnσＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／ ␛",
		out:  "\nnσＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／ ␛",
	}, { // 2340
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "\nnσＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／␠␛",
		out:  "\nnσＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／␠␛",
	}, { // 2341
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "\nnσＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／ ␠",
		out:  "\nnσＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／ ‛␠",
	}, { // 2342
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "\nnσＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／␠␠",
		out:  "\nnσＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／␠‛␠",
	}, { // 2343
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "\nnσＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／ρ ",
		out:  "\nnσＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／ρ␠",
	}, { // 2344
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "\nnσＢ,\x18ｊχ/\f ＠η%χ␌␀\x04＞aeε␁r％ｇ＜／ρ␠",
		out:  "\nnσＢ,\x18ｊχ/\f ＠η%χ␌‛␀\x04‛＞aeε␁r％ｇ‛＜／ρ‛␠",
	}, { // 2345
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   ",＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣａ＿",
		out:  ",＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣａ＿",
	}, { // 2346
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   " ␠oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣａ＿",
		out:  " ␠oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣａ＿",
	}, { // 2347
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␠␠oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣａ＿",
		out:  "␠␠oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣａ＿",
	}, { // 2348
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   " ＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣ␠＿",
		out:  " ＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣ␠＿",
	}, { // 2349
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␠＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣ␠＿",
		out:  "␠＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣ␠＿",
	}, { // 2350
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   " ＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣａ␠",
		out:  " ＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣａ‛␠",
	}, { // 2351
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␠＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣａ␠",
		out:  "␠＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣａ‛␠",
	}, { // 2352
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   ", oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣａ＿",
		out:  ", oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣａ＿",
	}, { // 2353
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   ",␠oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣａ＿",
		out:  ",␠oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣａ＿",
	}, { // 2354
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   ", oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣ␠＿",
		out:  ", oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣ␠＿",
	}, { // 2355
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   ",␠oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣ␠＿",
		out:  ",␠oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣ␠＿",
	}, { // 2356
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   ", oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣａ␠",
		out:  ", oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣａ‛␠",
	}, { // 2357
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   ",␠oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣａ␠",
		out:  ",␠oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣａ‛␠",
	}, { // 2358
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   ",＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣ ＿",
		out:  ",＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣ ＿",
	}, { // 2359
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   ",＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣ␠＿",
		out:  ",＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣ␠＿",
	}, { // 2360
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   ",＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣ ␠",
		out:  ",＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣ ‛␠",
	}, { // 2361
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   ",＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣ␠␠",
		out:  ",＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣ␠‛␠",
	}, { // 2362
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   ",＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣａ ",
		out:  ",＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣａ␠",
	}, { // 2363
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   ",＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'\x00αpζＣａ␠",
		out:  ",＞oＬ\x16＂γ\x04μ1 \"＜μ$＼ψ\x19\x1c␊｀＃'␀αpζＣａ‛␠",
	}, { // 2364
		mask: EncodeDollar | EncodeRightSpace,
		in:   "4#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\&",
		out:  "4#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\&",
	}, { // 2365
		mask: EncodeDollar | EncodeRightSpace,
		in:   " ␠γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\&",
		out:  " ␠γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\&",
	}, { // 2366
		mask: EncodeDollar | EncodeRightSpace,
		in:   "␠␠γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\&",
		out:  "␠␠γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\&",
	}, { // 2367
		mask: EncodeDollar | EncodeRightSpace,
		in:   " #γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc␠&",
		out:  " #γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc␠&",
	}, { // 2368
		mask: EncodeDollar | EncodeRightSpace,
		in:   "␠#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc␠&",
		out:  "␠#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc␠&",
	}, { // 2369
		mask: EncodeDollar | EncodeRightSpace,
		in:   " #γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\␠",
		out:  " #γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\‛␠",
	}, { // 2370
		mask: EncodeDollar | EncodeRightSpace,
		in:   "␠#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\␠",
		out:  "␠#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\‛␠",
	}, { // 2371
		mask: EncodeDollar | EncodeRightSpace,
		in:   "4 γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\&",
		out:  "4 γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\&",
	}, { // 2372
		mask: EncodeDollar | EncodeRightSpace,
		in:   "4␠γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\&",
		out:  "4␠γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\&",
	}, { // 2373
		mask: EncodeDollar | EncodeRightSpace,
		in:   "4 γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc␠&",
		out:  "4 γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc␠&",
	}, { // 2374
		mask: EncodeDollar | EncodeRightSpace,
		in:   "4␠γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc␠&",
		out:  "4␠γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc␠&",
	}, { // 2375
		mask: EncodeDollar | EncodeRightSpace,
		in:   "4 γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\␠",
		out:  "4 γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\‛␠",
	}, { // 2376
		mask: EncodeDollar | EncodeRightSpace,
		in:   "4␠γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\␠",
		out:  "4␠γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\‛␠",
	}, { // 2377
		mask: EncodeDollar | EncodeRightSpace,
		in:   "4#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc &",
		out:  "4#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc &",
	}, { // 2378
		mask: EncodeDollar | EncodeRightSpace,
		in:   "4#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc␠&",
		out:  "4#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc␠&",
	}, { // 2379
		mask: EncodeDollar | EncodeRightSpace,
		in:   "4#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc ␠",
		out:  "4#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc ‛␠",
	}, { // 2380
		mask: EncodeDollar | EncodeRightSpace,
		in:   "4#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc␠␠",
		out:  "4#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc␠‛␠",
	}, { // 2381
		mask: EncodeDollar | EncodeRightSpace,
		in:   "4#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\ ",
		out:  "4#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\␠",
	}, { // 2382
		mask: EncodeDollar | EncodeRightSpace,
		in:   "4#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\␠",
		out:  "4#γ␋/\v/＇\tT ␍γςｂ\x01？␝πξｋ０Ｏ}␃ｊχc\\‛␠",
	}, { // 2383
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␇ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ|",
		out:  "␇ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ|",
	}, { // 2384
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   " ␠>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ|",
		out:  " ␠>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ|",
	}, { // 2385
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␠␠>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ|",
		out:  "␠␠>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ|",
	}, { // 2386
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   " ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4␠|",
		out:  " ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4␠|",
	}, { // 2387
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␠ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4␠|",
		out:  "␠ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4␠|",
	}, { // 2388
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   " ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ␠",
		out:  " ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ‛␠",
	}, { // 2389
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␠ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ␠",
		out:  "␠ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ‛␠",
	}, { // 2390
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␇ >ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ|",
		out:  "␇ >ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ|",
	}, { // 2391
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␇␠>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ|",
		out:  "␇␠>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ|",
	}, { // 2392
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␇ >ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4␠|",
		out:  "␇ >ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4␠|",
	}, { // 2393
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␇␠>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4␠|",
		out:  "␇␠>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4␠|",
	}, { // 2394
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␇ >ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ␠",
		out:  "␇ >ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ‛␠",
	}, { // 2395
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␇␠>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ␠",
		out:  "␇␠>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ‛␠",
	}, { // 2396
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␇ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4 |",
		out:  "␇ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4 |",
	}, { // 2397
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␇ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4␠|",
		out:  "␇ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4␠|",
	}, { // 2398
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␇ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4 ␠",
		out:  "␇ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4 ‛␠",
	}, { // 2399
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␇ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4␠␠",
		out:  "␇ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4␠‛␠",
	}, { // 2400
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␇ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ ",
		out:  "␇ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ␠",
	}, { // 2401
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␇ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ␠",
		out:  "␇ａ>ςｙ\\０'ξι \u007f␈λ＞ψq␟)' Ｋ`\n␛ｏｐ4μ‛␠",
	}, { // 2402
		mask: EncodeColon | EncodeRightSpace,
		in:   "５？\x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛\x00~",
		out:  "５？\x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␀~",
	}, { // 2403
		mask: EncodeColon | EncodeRightSpace,
		in:   " ␠\x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛\x00~",
		out:  " ␠\x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␀~",
	}, { // 2404
		mask: EncodeColon | EncodeRightSpace,
		in:   "␠␠\x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛\x00~",
		out:  "␠␠\x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␀~",
	}, { // 2405
		mask: EncodeColon | EncodeRightSpace,
		in:   " ？\x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛␠~",
		out:  " ？\x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␠~",
	}, { // 2406
		mask: EncodeColon | EncodeRightSpace,
		in:   "␠？\x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛␠~",
		out:  "␠？\x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␠~",
	}, { // 2407
		mask: EncodeColon | EncodeRightSpace,
		in:   " ？\x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛\x00␠",
		out:  " ？\x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␀‛␠",
	}, { // 2408
		mask: EncodeColon | EncodeRightSpace,
		in:   "␠？\x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛\x00␠",
		out:  "␠？\x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␀‛␠",
	}, { // 2409
		mask: EncodeColon | EncodeRightSpace,
		in:   "５ \x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛\x00~",
		out:  "５ \x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␀~",
	}, { // 2410
		mask: EncodeColon | EncodeRightSpace,
		in:   "５␠\x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛\x00~",
		out:  "５␠\x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␀~",
	}, { // 2411
		mask: EncodeColon | EncodeRightSpace,
		in:   "５ \x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛␠~",
		out:  "５ \x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␠~",
	}, { // 2412
		mask: EncodeColon | EncodeRightSpace,
		in:   "５␠\x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛␠~",
		out:  "５␠\x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␠~",
	}, { // 2413
		mask: EncodeColon | EncodeRightSpace,
		in:   "５ \x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛\x00␠",
		out:  "５ \x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␀‛␠",
	}, { // 2414
		mask: EncodeColon | EncodeRightSpace,
		in:   "５␠\x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛\x00␠",
		out:  "５␠\x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␀‛␠",
	}, { // 2415
		mask: EncodeColon | EncodeRightSpace,
		in:   "５？\x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛ ~",
		out:  "５？\x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛ ~",
	}, { // 2416
		mask: EncodeColon | EncodeRightSpace,
		in:   "５？\x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛␠~",
		out:  "５？\x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␠~",
	}, { // 2417
		mask: EncodeColon | EncodeRightSpace,
		in:   "５？\x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛ ␠",
		out:  "５？\x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛ ‛␠",
	}, { // 2418
		mask: EncodeColon | EncodeRightSpace,
		in:   "５？\x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛␠␠",
		out:  "５？\x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␠‛␠",
	}, { // 2419
		mask: EncodeColon | EncodeRightSpace,
		in:   "５？\x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛\x00 ",
		out:  "５？\x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␀␠",
	}, { // 2420
		mask: EncodeColon | EncodeRightSpace,
		in:   "５？\x18\x00␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*␀␛\x00␠",
		out:  "５？\x18␀␡ν＃Jμχ WςＱ\x1agζＳ␐ι\x01Mv｀␍*‛␀␛␀‛␠",
	}, { // 2421
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "B＞␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊－",
		out:  "B＞␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊－",
	}, { // 2422
		mask: EncodeQuestion | EncodeRightSpace,
		in:   " ␠␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊－",
		out:  " ␠␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊－",
	}, { // 2423
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "␠␠␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊－",
		out:  "␠␠␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊－",
	}, { // 2424
		mask: EncodeQuestion | EncodeRightSpace,
		in:   " ＞␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␠－",
		out:  " ＞␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␠－",
	}, { // 2425
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "␠＞␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␠－",
		out:  "␠＞␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␠－",
	}, { // 2426
		mask: EncodeQuestion | EncodeRightSpace,
		in:   " ＞␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊␠",
		out:  " ＞␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊‛␠",
	}, { // 2427
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "␠＞␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊␠",
		out:  "␠＞␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊‛␠",
	}, { // 2428
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "B ␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊－",
		out:  "B ␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊－",
	}, { // 2429
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "B␠␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊－",
		out:  "B␠␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊－",
	}, { // 2430
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "B ␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␠－",
		out:  "B ␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␠－",
	}, { // 2431
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "B␠␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␠－",
		out:  "B␠␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␠－",
	}, { // 2432
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "B ␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊␠",
		out:  "B ␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊‛␠",
	}, { // 2433
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "B␠␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊␠",
		out:  "B␠␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊‛␠",
	}, { // 2434
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "B＞␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞ －",
		out:  "B＞␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞ －",
	}, { // 2435
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "B＞␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␠－",
		out:  "B＞␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␠－",
	}, { // 2436
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "B＞␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞ ␠",
		out:  "B＞␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞ ‛␠",
	}, { // 2437
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "B＞␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␠␠",
		out:  "B＞␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␠‛␠",
	}, { // 2438
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "B＞␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊ ",
		out:  "B＞␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊␠",
	}, { // 2439
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "B＞␁ＲＲＫο␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊␠",
		out:  "B＞␁ＲＲＫο‛␀(␆ YCn\u007f>ρ＂ο\x14\u007fx␕εφ/α␞␊‛␠",
	}, { // 2440
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＼?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο\x1fθ",
		out:  "＼?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο\x1fθ",
	}, { // 2441
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   " ␠％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο\x1fθ",
		out:  " ␠％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο\x1fθ",
	}, { // 2442
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "␠␠％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο\x1fθ",
		out:  "␠␠％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο\x1fθ",
	}, { // 2443
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   " ?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο␠θ",
		out:  " ?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο␠θ",
	}, { // 2444
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "␠?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο␠θ",
		out:  "␠?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο␠θ",
	}, { // 2445
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   " ?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο\x1f␠",
		out:  " ?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο\x1f‛␠",
	}, { // 2446
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "␠?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο\x1f␠",
		out:  "␠?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο\x1f‛␠",
	}, { // 2447
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＼ ％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο\x1fθ",
		out:  "＼ ％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο\x1fθ",
	}, { // 2448
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＼␠％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο\x1fθ",
		out:  "＼␠％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο\x1fθ",
	}, { // 2449
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＼ ％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο␠θ",
		out:  "＼ ％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο␠θ",
	}, { // 2450
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＼␠％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο␠θ",
		out:  "＼␠％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο␠θ",
	}, { // 2451
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＼ ％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο\x1f␠",
		out:  "＼ ％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο\x1f‛␠",
	}, { // 2452
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＼␠％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο\x1f␠",
		out:  "＼␠％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο\x1f‛␠",
	}, { // 2453
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＼?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο θ",
		out:  "＼?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο θ",
	}, { // 2454
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＼?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο␠θ",
		out:  "＼?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο␠θ",
	}, { // 2455
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＼?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο ␠",
		out:  "＼?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο ‛␠",
	}, { // 2456
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＼?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο␠␠",
		out:  "＼?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο␠‛␠",
	}, { // 2457
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＼?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο\x1f ",
		out:  "＼?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο\x1f␠",
	}, { // 2458
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＼?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ*:ο\x1f␠",
		out:  "＼?％γＲωψ\x05:␗ \x05␆＝%ν\a␊ｆK：／n＞Ｄ＊:ο\x1f‛␠",
	}, { // 2459
		mask: EncodePipe | EncodeRightSpace,
		in:   "-T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/τ",
		out:  "-T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/τ",
	}, { // 2460
		mask: EncodePipe | EncodeRightSpace,
		in:   " ␠\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/τ",
		out:  " ␠\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/τ",
	}, { // 2461
		mask: EncodePipe | EncodeRightSpace,
		in:   "␠␠\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/τ",
		out:  "␠␠\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/τ",
	}, { // 2462
		mask: EncodePipe | EncodeRightSpace,
		in:   " T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍␠τ",
		out:  " T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍␠τ",
	}, { // 2463
		mask: EncodePipe | EncodeRightSpace,
		in:   "␠T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍␠τ",
		out:  "␠T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍␠τ",
	}, { // 2464
		mask: EncodePipe | EncodeRightSpace,
		in:   " T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/␠",
		out:  " T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/‛␠",
	}, { // 2465
		mask: EncodePipe | EncodeRightSpace,
		in:   "␠T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/␠",
		out:  "␠T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/‛␠",
	}, { // 2466
		mask: EncodePipe | EncodeRightSpace,
		in:   "- \x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/τ",
		out:  "- \x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/τ",
	}, { // 2467
		mask: EncodePipe | EncodeRightSpace,
		in:   "-␠\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/τ",
		out:  "-␠\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/τ",
	}, { // 2468
		mask: EncodePipe | EncodeRightSpace,
		in:   "- \x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍␠τ",
		out:  "- \x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍␠τ",
	}, { // 2469
		mask: EncodePipe | EncodeRightSpace,
		in:   "-␠\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍␠τ",
		out:  "-␠\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍␠τ",
	}, { // 2470
		mask: EncodePipe | EncodeRightSpace,
		in:   "- \x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/␠",
		out:  "- \x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/‛␠",
	}, { // 2471
		mask: EncodePipe | EncodeRightSpace,
		in:   "-␠\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/␠",
		out:  "-␠\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/‛␠",
	}, { // 2472
		mask: EncodePipe | EncodeRightSpace,
		in:   "-T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍ τ",
		out:  "-T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍ τ",
	}, { // 2473
		mask: EncodePipe | EncodeRightSpace,
		in:   "-T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍␠τ",
		out:  "-T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍␠τ",
	}, { // 2474
		mask: EncodePipe | EncodeRightSpace,
		in:   "-T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍ ␠",
		out:  "-T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍ ‛␠",
	}, { // 2475
		mask: EncodePipe | EncodeRightSpace,
		in:   "-T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍␠␠",
		out:  "-T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍␠‛␠",
	}, { // 2476
		mask: EncodePipe | EncodeRightSpace,
		in:   "-T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/ ",
		out:  "-T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/␠",
	}, { // 2477
		mask: EncodePipe | EncodeRightSpace,
		in:   "-T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/␠",
		out:  "-T\x18λξ␊νＳ$Ｏ ␘φDＱ＄␟ η\x15＊\x18␕\nＤ＿+␍/‛␠",
	}, { // 2478
		mask: EncodeHash | EncodeRightSpace,
		in:   "σ＠α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇［",
		out:  "σ＠α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇［",
	}, { // 2479
		mask: EncodeHash | EncodeRightSpace,
		in:   " ␠α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇［",
		out:  " ␠α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇［",
	}, { // 2480
		mask: EncodeHash | EncodeRightSpace,
		in:   "␠␠α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇［",
		out:  "␠␠α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇［",
	}, { // 2481
		mask: EncodeHash | EncodeRightSpace,
		in:   " ＠α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␠［",
		out:  " ＠α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␠［",
	}, { // 2482
		mask: EncodeHash | EncodeRightSpace,
		in:   "␠＠α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␠［",
		out:  "␠＠α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␠［",
	}, { // 2483
		mask: EncodeHash | EncodeRightSpace,
		in:   " ＠α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇␠",
		out:  " ＠α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇‛␠",
	}, { // 2484
		mask: EncodeHash | EncodeRightSpace,
		in:   "␠＠α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇␠",
		out:  "␠＠α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇‛␠",
	}, { // 2485
		mask: EncodeHash | EncodeRightSpace,
		in:   "σ α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇［",
		out:  "σ α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇［",
	}, { // 2486
		mask: EncodeHash | EncodeRightSpace,
		in:   "σ␠α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇［",
		out:  "σ␠α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇［",
	}, { // 2487
		mask: EncodeHash | EncodeRightSpace,
		in:   "σ α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␠［",
		out:  "σ α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␠［",
	}, { // 2488
		mask: EncodeHash | EncodeRightSpace,
		in:   "σ␠α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␠［",
		out:  "σ␠α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␠［",
	}, { // 2489
		mask: EncodeHash | EncodeRightSpace,
		in:   "σ α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇␠",
		out:  "σ α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇‛␠",
	}, { // 2490
		mask: EncodeHash | EncodeRightSpace,
		in:   "σ␠α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇␠",
		out:  "σ␠α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇‛␠",
	}, { // 2491
		mask: EncodeHash | EncodeRightSpace,
		in:   "σ＠α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ ［",
		out:  "σ＠α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ ［",
	}, { // 2492
		mask: EncodeHash | EncodeRightSpace,
		in:   "σ＠α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␠［",
		out:  "σ＠α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␠［",
	}, { // 2493
		mask: EncodeHash | EncodeRightSpace,
		in:   "σ＠α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ ␠",
		out:  "σ＠α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ ‛␠",
	}, { // 2494
		mask: EncodeHash | EncodeRightSpace,
		in:   "σ＠α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␠␠",
		out:  "σ＠α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␠‛␠",
	}, { // 2495
		mask: EncodeHash | EncodeRightSpace,
		in:   "σ＠α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇ ",
		out:  "σ＠α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇␠",
	}, { // 2496
		mask: EncodeHash | EncodeRightSpace,
		in:   "σ＠α␝\x14＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇␠",
		out:  "σ＠α␝\x14‛＃ρ0␉␇ )␌*MｉUλ\v\x16<＝␝μ>kωＶ␇‛␠",
	}, { // 2497
		mask: EncodePercent | EncodeRightSpace,
		in:   "θψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χe",
		out:  "θψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χe",
	}, { // 2498
		mask: EncodePercent | EncodeRightSpace,
		in:   " ␠␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χe",
		out:  " ␠␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χe",
	}, { // 2499
		mask: EncodePercent | EncodeRightSpace,
		in:   "␠␠␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χe",
		out:  "␠␠␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χe",
	}, { // 2500
		mask: EncodePercent | EncodeRightSpace,
		in:   " ψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$␠e",
		out:  " ψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$␠e",
	}, { // 2501
		mask: EncodePercent | EncodeRightSpace,
		in:   "␠ψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$␠e",
		out:  "␠ψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$␠e",
	}, { // 2502
		mask: EncodePercent | EncodeRightSpace,
		in:   " ψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χ␠",
		out:  " ψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χ‛␠",
	}, { // 2503
		mask: EncodePercent | EncodeRightSpace,
		in:   "␠ψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χ␠",
		out:  "␠ψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χ‛␠",
	}, { // 2504
		mask: EncodePercent | EncodeRightSpace,
		in:   "θ ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χe",
		out:  "θ ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χe",
	}, { // 2505
		mask: EncodePercent | EncodeRightSpace,
		in:   "θ␠␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χe",
		out:  "θ␠␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χe",
	}, { // 2506
		mask: EncodePercent | EncodeRightSpace,
		in:   "θ ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$␠e",
		out:  "θ ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$␠e",
	}, { // 2507
		mask: EncodePercent | EncodeRightSpace,
		in:   "θ␠␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$␠e",
		out:  "θ␠␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$␠e",
	}, { // 2508
		mask: EncodePercent | EncodeRightSpace,
		in:   "θ ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χ␠",
		out:  "θ ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χ‛␠",
	}, { // 2509
		mask: EncodePercent | EncodeRightSpace,
		in:   "θ␠␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χ␠",
		out:  "θ␠␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χ‛␠",
	}, { // 2510
		mask: EncodePercent | EncodeRightSpace,
		in:   "θψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$ e",
		out:  "θψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$ e",
	}, { // 2511
		mask: EncodePercent | EncodeRightSpace,
		in:   "θψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$␠e",
		out:  "θψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$␠e",
	}, { // 2512
		mask: EncodePercent | EncodeRightSpace,
		in:   "θψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$ ␠",
		out:  "θψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$ ‛␠",
	}, { // 2513
		mask: EncodePercent | EncodeRightSpace,
		in:   "θψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$␠␠",
		out:  "θψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$␠‛␠",
	}, { // 2514
		mask: EncodePercent | EncodeRightSpace,
		in:   "θψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χ ",
		out:  "θψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χ␠",
	}, { // 2515
		mask: EncodePercent | EncodeRightSpace,
		in:   "θψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χ␠",
		out:  "θψ␙*r␞ω␍＜) |ι@EW＄＜｛８，\x1b\\＂\bＷＧ$χ‛␠",
	}, { // 2516
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "λｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b\x1e",
		out:  "λｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b\x1e",
	}, { // 2517
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   " ␠\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b\x1e",
		out:  " ␠\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b\x1e",
	}, { // 2518
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␠␠\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b\x1e",
		out:  "␠␠\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b\x1e",
	}, { // 2519
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   " ｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇␠\x1e",
		out:  " ｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇␠\x1e",
	}, { // 2520
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␠ｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇␠\x1e",
		out:  "␠ｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇␠\x1e",
	}, { // 2521
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   " ｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b␠",
		out:  " ｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b‛␠",
	}, { // 2522
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␠ｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b␠",
		out:  "␠ｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b‛␠",
	}, { // 2523
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "λ \rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b\x1e",
		out:  "λ \rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b\x1e",
	}, { // 2524
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "λ␠\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b\x1e",
		out:  "λ␠\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b\x1e",
	}, { // 2525
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "λ \rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇␠\x1e",
		out:  "λ \rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇␠\x1e",
	}, { // 2526
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "λ␠\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇␠\x1e",
		out:  "λ␠\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇␠\x1e",
	}, { // 2527
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "λ \rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b␠",
		out:  "λ \rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b‛␠",
	}, { // 2528
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "λ␠\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b␠",
		out:  "λ␠\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b‛␠",
	}, { // 2529
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "λｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇ \x1e",
		out:  "λｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇ \x1e",
	}, { // 2530
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "λｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇␠\x1e",
		out:  "λｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇␠\x1e",
	}, { // 2531
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "λｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇ ␠",
		out:  "λｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇ ‛␠",
	}, { // 2532
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "λｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇␠␠",
		out:  "λｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇␠‛␠",
	}, { // 2533
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "λｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b ",
		out:  "λｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b␠",
	}, { // 2534
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "λｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b␠",
		out:  "λｏ\rＡ␡ｘο%ｆω ＤJ␂\nYjｄψ|［>-␜␎κβ＇b‛␠",
	}, { // 2535
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "\u007fδ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␑％",
		out:  "\u007fδ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␑％",
	}, { // 2536
		mask: EncodeCrLf | EncodeRightSpace,
		in:   " ␠\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␑％",
		out:  " ␠\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␑％",
	}, { // 2537
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␠␠\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␑％",
		out:  "␠␠\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␑％",
	}, { // 2538
		mask: EncodeCrLf | EncodeRightSpace,
		in:   " δ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␠％",
		out:  " δ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␠％",
	}, { // 2539
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␠δ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␠％",
		out:  "␠δ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␠％",
	}, { // 2540
		mask: EncodeCrLf | EncodeRightSpace,
		in:   " δ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␑␠",
		out:  " δ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␑‛␠",
	}, { // 2541
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␠δ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␑␠",
		out:  "␠δ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␑‛␠",
	}, { // 2542
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "\u007f \f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␑％",
		out:  "\u007f \f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␑％",
	}, { // 2543
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "\u007f␠\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␑％",
		out:  "\u007f␠\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␑％",
	}, { // 2544
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "\u007f \f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␠％",
		out:  "\u007f \f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␠％",
	}, { // 2545
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "\u007f␠\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␠％",
		out:  "\u007f␠\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␠％",
	}, { // 2546
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "\u007f \f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␑␠",
		out:  "\u007f \f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␑‛␠",
	}, { // 2547
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "\u007f␠\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␑␠",
		out:  "\u007f␠\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␑‛␠",
	}, { // 2548
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "\u007fδ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ ％",
		out:  "\u007fδ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ ％",
	}, { // 2549
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "\u007fδ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␠％",
		out:  "\u007fδ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␠％",
	}, { // 2550
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "\u007fδ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ ␠",
		out:  "\u007fδ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ ‛␠",
	}, { // 2551
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "\u007fδ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␠␠",
		out:  "\u007fδ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␠‛␠",
	}, { // 2552
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "\u007fδ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␑ ",
		out:  "\u007fδ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␑␠",
	}, { // 2553
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "\u007fδ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ\nＣA\x15␈ｋ␑␠",
		out:  "\u007fδ\f\u007fτ␆ｎξκＦ xσy<␃bMZ␔␟μ␊ＣA\x15␈ｋ␑‛␠",
	}, { // 2554
		mask: EncodeDel | EncodeRightSpace,
		in:   "γＺ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00]π",
		out:  "γＺ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀]π",
	}, { // 2555
		mask: EncodeDel | EncodeRightSpace,
		in:   " ␠0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00]π",
		out:  " ␠0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀]π",
	}, { // 2556
		mask: EncodeDel | EncodeRightSpace,
		in:   "␠␠0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00]π",
		out:  "␠␠0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀]π",
	}, { // 2557
		mask: EncodeDel | EncodeRightSpace,
		in:   " Ｚ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00␠π",
		out:  " Ｚ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀␠π",
	}, { // 2558
		mask: EncodeDel | EncodeRightSpace,
		in:   "␠Ｚ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00␠π",
		out:  "␠Ｚ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀␠π",
	}, { // 2559
		mask: EncodeDel | EncodeRightSpace,
		in:   " Ｚ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00]␠",
		out:  " Ｚ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀]‛␠",
	}, { // 2560
		mask: EncodeDel | EncodeRightSpace,
		in:   "␠Ｚ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00]␠",
		out:  "␠Ｚ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀]‛␠",
	}, { // 2561
		mask: EncodeDel | EncodeRightSpace,
		in:   "γ 0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00]π",
		out:  "γ 0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀]π",
	}, { // 2562
		mask: EncodeDel | EncodeRightSpace,
		in:   "γ␠0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00]π",
		out:  "γ␠0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀]π",
	}, { // 2563
		mask: EncodeDel | EncodeRightSpace,
		in:   "γ 0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00␠π",
		out:  "γ 0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀␠π",
	}, { // 2564
		mask: EncodeDel | EncodeRightSpace,
		in:   "γ␠0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00␠π",
		out:  "γ␠0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀␠π",
	}, { // 2565
		mask: EncodeDel | EncodeRightSpace,
		in:   "γ 0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00]␠",
		out:  "γ 0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀]‛␠",
	}, { // 2566
		mask: EncodeDel | EncodeRightSpace,
		in:   "γ␠0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00]␠",
		out:  "γ␠0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀]‛␠",
	}, { // 2567
		mask: EncodeDel | EncodeRightSpace,
		in:   "γＺ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00 π",
		out:  "γＺ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀ π",
	}, { // 2568
		mask: EncodeDel | EncodeRightSpace,
		in:   "γＺ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00␠π",
		out:  "γＺ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀␠π",
	}, { // 2569
		mask: EncodeDel | EncodeRightSpace,
		in:   "γＺ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00 ␠",
		out:  "γＺ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀ ‛␠",
	}, { // 2570
		mask: EncodeDel | EncodeRightSpace,
		in:   "γＺ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00␠␠",
		out:  "γＺ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀␠‛␠",
	}, { // 2571
		mask: EncodeDel | EncodeRightSpace,
		in:   "γＺ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00] ",
		out:  "γＺ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀]␠",
	}, { // 2572
		mask: EncodeDel | EncodeRightSpace,
		in:   "γＺ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜\x00]␠",
		out:  "γＺ0＿V＄␌\x02！\\ βη\"␇␍οθ\x1du) \uff00Ｄ␘E＜␀]‛␠",
	}, { // 2573
		mask: EncodeCtl | EncodeRightSpace,
		in:   "＞１θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␡␑",
		out:  "＞１θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␡‛␑",
	}, { // 2574
		mask: EncodeCtl | EncodeRightSpace,
		in:   " ␠θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␡␑",
		out:  " ␠θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␡‛␑",
	}, { // 2575
		mask: EncodeCtl | EncodeRightSpace,
		in:   "␠␠θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␡␑",
		out:  "␠␠θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␡‛␑",
	}, { // 2576
		mask: EncodeCtl | EncodeRightSpace,
		in:   " １θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␠␑",
		out:  " １θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␠‛␑",
	}, { // 2577
		mask: EncodeCtl | EncodeRightSpace,
		in:   "␠１θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␠␑",
		out:  "␠１θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␠‛␑",
	}, { // 2578
		mask: EncodeCtl | EncodeRightSpace,
		in:   " １θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␡␠",
		out:  " １θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␡‛␠",
	}, { // 2579
		mask: EncodeCtl | EncodeRightSpace,
		in:   "␠１θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␡␠",
		out:  "␠１θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␡‛␠",
	}, { // 2580
		mask: EncodeCtl | EncodeRightSpace,
		in:   "＞ θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␡␑",
		out:  "＞ θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␡‛␑",
	}, { // 2581
		mask: EncodeCtl | EncodeRightSpace,
		in:   "＞␠θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␡␑",
		out:  "＞␠θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␡‛␑",
	}, { // 2582
		mask: EncodeCtl | EncodeRightSpace,
		in:   "＞ θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␠␑",
		out:  "＞ θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␠‛␑",
	}, { // 2583
		mask: EncodeCtl | EncodeRightSpace,
		in:   "＞␠θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␠␑",
		out:  "＞␠θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␠‛␑",
	}, { // 2584
		mask: EncodeCtl | EncodeRightSpace,
		in:   "＞ θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␡␠",
		out:  "＞ θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␡‛␠",
	}, { // 2585
		mask: EncodeCtl | EncodeRightSpace,
		in:   "＞␠θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␡␠",
		out:  "＞␠θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␡‛␠",
	}, { // 2586
		mask: EncodeCtl | EncodeRightSpace,
		in:   "＞１θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/； ␑",
		out:  "＞１θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/； ‛␑",
	}, { // 2587
		mask: EncodeCtl | EncodeRightSpace,
		in:   "＞１θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␠␑",
		out:  "＞１θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␠‛␑",
	}, { // 2588
		mask: EncodeCtl | EncodeRightSpace,
		in:   "＞１θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/； ␠",
		out:  "＞１θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/； ‛␠",
	}, { // 2589
		mask: EncodeCtl | EncodeRightSpace,
		in:   "＞１θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␠␠",
		out:  "＞１θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␠‛␠",
	}, { // 2590
		mask: EncodeCtl | EncodeRightSpace,
		in:   "＞１θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␡ ",
		out:  "＞１θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␡␠",
	}, { // 2591
		mask: EncodeCtl | EncodeRightSpace,
		in:   "＞１θε？\r␀＊(q ␕9?\x11ησ[\x01λＸf\no）β/；␡␠",
		out:  "＞１θε？␍‛␀＊(q ‛␕9?␑ησ[␁λＸf␊o）β/；␡‛␠",
	}, { // 2592
		mask: EncodeRightPeriod,
		in:   ".",
		out:  "．",
	}, { // 2593
		mask: EncodeZero | EncodeRightPeriod,
		in:   "λnξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ␏",
		out:  "λnξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ␏",
	}, { // 2594
		mask: EncodeZero | EncodeRightPeriod,
		in:   ".．ξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ␏",
		out:  ".．ξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ␏",
	}, { // 2595
		mask: EncodeZero | EncodeRightPeriod,
		in:   "．．ξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ␏",
		out:  "．．ξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ␏",
	}, { // 2596
		mask: EncodeZero | EncodeRightPeriod,
		in:   ".nξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυ．␏",
		out:  ".nξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυ．␏",
	}, { // 2597
		mask: EncodeZero | EncodeRightPeriod,
		in:   "．nξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυ．␏",
		out:  "．nξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυ．␏",
	}, { // 2598
		mask: EncodeZero | EncodeRightPeriod,
		in:   ".nξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ．",
		out:  ".nξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ‛．",
	}, { // 2599
		mask: EncodeZero | EncodeRightPeriod,
		in:   "．nξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ．",
		out:  "．nξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ‛．",
	}, { // 2600
		mask: EncodeZero | EncodeRightPeriod,
		in:   "λ.ξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ␏",
		out:  "λ.ξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ␏",
	}, { // 2601
		mask: EncodeZero | EncodeRightPeriod,
		in:   "λ．ξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ␏",
		out:  "λ．ξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ␏",
	}, { // 2602
		mask: EncodeZero | EncodeRightPeriod,
		in:   "λ.ξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυ．␏",
		out:  "λ.ξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυ．␏",
	}, { // 2603
		mask: EncodeZero | EncodeRightPeriod,
		in:   "λ．ξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυ．␏",
		out:  "λ．ξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυ．␏",
	}, { // 2604
		mask: EncodeZero | EncodeRightPeriod,
		in:   "λ.ξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ．",
		out:  "λ.ξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ‛．",
	}, { // 2605
		mask: EncodeZero | EncodeRightPeriod,
		in:   "λ．ξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ．",
		out:  "λ．ξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ‛．",
	}, { // 2606
		mask: EncodeZero | EncodeRightPeriod,
		in:   "λnξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυ.␏",
		out:  "λnξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυ.␏",
	}, { // 2607
		mask: EncodeZero | EncodeRightPeriod,
		in:   "λnξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυ．␏",
		out:  "λnξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυ．␏",
	}, { // 2608
		mask: EncodeZero | EncodeRightPeriod,
		in:   "λnξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυ.．",
		out:  "λnξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυ.‛．",
	}, { // 2609
		mask: EncodeZero | EncodeRightPeriod,
		in:   "λnξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυ．．",
		out:  "λnξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυ．‛．",
	}, { // 2610
		mask: EncodeZero | EncodeRightPeriod,
		in:   "λnξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ.",
		out:  "λnξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ．",
	}, { // 2611
		mask: EncodeZero | EncodeRightPeriod,
		in:   "λnξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ．",
		out:  "λnξ｛［/Ｕbx#.\\h,２␌␅␝$＾\x0fζｉε#␞αυｃ‛．",
	}, { // 2612
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␖φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμX␜",
		out:  "␖φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμX␜",
	}, { // 2613
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ".．ｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμX␜",
		out:  ".．ｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμX␜",
	}, { // 2614
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "．．ｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμX␜",
		out:  "．．ｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμX␜",
	}, { // 2615
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ".φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμ．␜",
		out:  ".φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμ．␜",
	}, { // 2616
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "．φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμ．␜",
		out:  "．φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμ．␜",
	}, { // 2617
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ".φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμX．",
		out:  ".φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμX‛．",
	}, { // 2618
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "．φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμX．",
		out:  "．φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμX‛．",
	}, { // 2619
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␖.ｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμX␜",
		out:  "␖.ｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμX␜",
	}, { // 2620
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␖．ｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμX␜",
		out:  "␖．ｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμX␜",
	}, { // 2621
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␖.ｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμ．␜",
		out:  "␖.ｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμ．␜",
	}, { // 2622
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␖．ｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμ．␜",
		out:  "␖．ｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμ．␜",
	}, { // 2623
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␖.ｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμX．",
		out:  "␖.ｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμX‛．",
	}, { // 2624
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␖．ｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμX．",
		out:  "␖．ｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμX‛．",
	}, { // 2625
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␖φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμ.␜",
		out:  "␖φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμ.␜",
	}, { // 2626
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␖φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμ．␜",
		out:  "␖φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμ．␜",
	}, { // 2627
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␖φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμ.．",
		out:  "␖φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμ.‛．",
	}, { // 2628
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␖φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμ．．",
		out:  "␖φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμ．‛．",
	}, { // 2629
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␖φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμX.",
		out:  "␖φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμX．",
	}, { // 2630
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␖φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ\x00!z＠#μ＃␊ιoμX．",
		out:  "␖φｇ５␌>␈yＯ*.ｎ\x1eｖ\n\nκ␀!z＠#μ＃␊ιoμX‛．",
	}, { // 2631
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "\x18Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg，",
		out:  "\x18Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg，",
	}, { // 2632
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   ".．lδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg，",
		out:  ".．lδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg，",
	}, { // 2633
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "．．lδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg，",
		out:  "．．lδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg，",
	}, { // 2634
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   ".Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υ．，",
		out:  ".Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υ．，",
	}, { // 2635
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "．Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υ．，",
		out:  "．Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υ．，",
	}, { // 2636
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   ".Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg．",
		out:  ".Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg‛．",
	}, { // 2637
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "．Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg．",
		out:  "．Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg‛．",
	}, { // 2638
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "\x18.lδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg，",
		out:  "\x18.lδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg，",
	}, { // 2639
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "\x18．lδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg，",
		out:  "\x18．lδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg，",
	}, { // 2640
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "\x18.lδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υ．，",
		out:  "\x18.lδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υ．，",
	}, { // 2641
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "\x18．lδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υ．，",
		out:  "\x18．lδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υ．，",
	}, { // 2642
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "\x18.lδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg．",
		out:  "\x18.lδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg‛．",
	}, { // 2643
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "\x18．lδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg．",
		out:  "\x18．lδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg‛．",
	}, { // 2644
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "\x18Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υ.，",
		out:  "\x18Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υ.，",
	}, { // 2645
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "\x18Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υ．，",
		out:  "\x18Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υ．，",
	}, { // 2646
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "\x18Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υ.．",
		out:  "\x18Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υ.‛．",
	}, { // 2647
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "\x18Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υ．．",
		out:  "\x18Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υ．‛．",
	}, { // 2648
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "\x18Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg.",
		out:  "\x18Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg．",
	}, { // 2649
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "\x18Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg．",
		out:  "\x18Ｔlδqι，␓␖\x19.\x17＂｀ρ7`ｆ｛θｌ*ςT／*／υg‛．",
	}, { // 2650
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "␔＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`＇␒",
		out:  "␔＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀＇␒",
	}, { // 2651
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   ".．␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`＇␒",
		out:  ".．␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀＇␒",
	}, { // 2652
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "．．␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`＇␒",
		out:  "．．␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀＇␒",
	}, { // 2653
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   ".＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`．␒",
		out:  ".＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀．␒",
	}, { // 2654
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "．＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`．␒",
		out:  "．＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀．␒",
	}, { // 2655
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   ".＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`＇．",
		out:  ".＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀＇‛．",
	}, { // 2656
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "．＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`＇．",
		out:  "．＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀＇‛．",
	}, { // 2657
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "␔.␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`＇␒",
		out:  "␔.␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀＇␒",
	}, { // 2658
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "␔．␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`＇␒",
		out:  "␔．␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀＇␒",
	}, { // 2659
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "␔.␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`．␒",
		out:  "␔.␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀．␒",
	}, { // 2660
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "␔．␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`．␒",
		out:  "␔．␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀．␒",
	}, { // 2661
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "␔.␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`＇．",
		out:  "␔.␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀＇‛．",
	}, { // 2662
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "␔．␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`＇．",
		out:  "␔．␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀＇‛．",
	}, { // 2663
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "␔＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`.␒",
		out:  "␔＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀.␒",
	}, { // 2664
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "␔＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`．␒",
		out:  "␔＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀．␒",
	}, { // 2665
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "␔＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`.．",
		out:  "␔＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀.‛．",
	}, { // 2666
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "␔＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`．．",
		out:  "␔＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀．‛．",
	}, { // 2667
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "␔＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`＇.",
		out:  "␔＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀＇．",
	}, { // 2668
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "␔＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z`＇．",
		out:  "␔＊␟９␏Ｓ；P6ｇ.\x12?Ｆβcξ\rξ8␃\x16ψ/ν'z｀＇‛．",
	}, { // 2669
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "τｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?λ",
		out:  "τｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?λ",
	}, { // 2670
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   ".．\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?λ",
		out:  ".．\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?λ",
	}, { // 2671
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "．．\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?λ",
		out:  "．．\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?λ",
	}, { // 2672
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   ".ｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓．λ",
		out:  ".ｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓．λ",
	}, { // 2673
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "．ｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓．λ",
		out:  "．ｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓．λ",
	}, { // 2674
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   ".ｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?．",
		out:  ".ｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?‛．",
	}, { // 2675
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "．ｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?．",
		out:  "．ｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?‛．",
	}, { // 2676
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "τ.\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?λ",
		out:  "τ.\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?λ",
	}, { // 2677
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "τ．\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?λ",
		out:  "τ．\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?λ",
	}, { // 2678
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "τ.\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓．λ",
		out:  "τ.\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓．λ",
	}, { // 2679
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "τ．\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓．λ",
		out:  "τ．\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓．λ",
	}, { // 2680
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "τ.\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?．",
		out:  "τ.\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?‛．",
	}, { // 2681
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "τ．\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?．",
		out:  "τ．\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?‛．",
	}, { // 2682
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "τｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓.λ",
		out:  "τｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓.λ",
	}, { // 2683
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "τｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓．λ",
		out:  "τｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓．λ",
	}, { // 2684
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "τｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓.．",
		out:  "τｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓.‛．",
	}, { // 2685
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "τｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓．．",
		out:  "τｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓．‛．",
	}, { // 2686
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "τｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?.",
		out:  "τｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?．",
	}, { // 2687
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "τｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?．",
		out:  "τｗ\x06\x01\"␑G／δ＼.αＨ\\␚\\ｐ［ｓi\toοσ5}＿␓?‛．",
	}, { // 2688
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "/\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈␀｜",
		out:  "/\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈‛␀｜",
	}, { // 2689
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   ".．'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈␀｜",
		out:  ".．'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈‛␀｜",
	}, { // 2690
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "．．'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈␀｜",
		out:  "．．'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈‛␀｜",
	}, { // 2691
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   ".\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈．｜",
		out:  ".\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈．｜",
	}, { // 2692
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "．\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈．｜",
		out:  "．\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈．｜",
	}, { // 2693
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   ".\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈␀．",
		out:  ".\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈‛␀‛．",
	}, { // 2694
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "．\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈␀．",
		out:  "．\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈‛␀‛．",
	}, { // 2695
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "/.'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈␀｜",
		out:  "/.'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈‛␀｜",
	}, { // 2696
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "/．'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈␀｜",
		out:  "/．'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈‛␀｜",
	}, { // 2697
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "/.'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈．｜",
		out:  "/.'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈．｜",
	}, { // 2698
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "/．'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈．｜",
		out:  "/．'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈．｜",
	}, { // 2699
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "/.'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈␀．",
		out:  "/.'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈‛␀‛．",
	}, { // 2700
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "/．'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈␀．",
		out:  "/．'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈‛␀‛．",
	}, { // 2701
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "/\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈.｜",
		out:  "/\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈.｜",
	}, { // 2702
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "/\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈．｜",
		out:  "/\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈．｜",
	}, { // 2703
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "/\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈.．",
		out:  "/\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈.‛．",
	}, { // 2704
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "/\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈．．",
		out:  "/\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈．‛．",
	}, { // 2705
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "/\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈␀.",
		out:  "/\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈‛␀．",
	}, { // 2706
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "/\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈␀．",
		out:  "/\x12'９： ιOμλ.９s\u007fαρＵFＷ\x10|ι:␅␝Ｅ5␈‛␀‛．",
	}, { // 2707
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "６␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄ω｛",
		out:  "６␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄ω｛",
	}, { // 2708
		mask: EncodeDollar | EncodeRightPeriod,
		in:   ".．ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄ω｛",
		out:  ".．ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄ω｛",
	}, { // 2709
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "．．ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄ω｛",
		out:  "．．ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄ω｛",
	}, { // 2710
		mask: EncodeDollar | EncodeRightPeriod,
		in:   ".␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄．｛",
		out:  ".␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄．｛",
	}, { // 2711
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "．␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄．｛",
		out:  "．␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄．｛",
	}, { // 2712
		mask: EncodeDollar | EncodeRightPeriod,
		in:   ".␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄ω．",
		out:  ".␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄ω‛．",
	}, { // 2713
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "．␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄ω．",
		out:  "．␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄ω‛．",
	}, { // 2714
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "６.ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄ω｛",
		out:  "６.ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄ω｛",
	}, { // 2715
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "６．ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄ω｛",
		out:  "６．ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄ω｛",
	}, { // 2716
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "６.ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄．｛",
		out:  "６.ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄．｛",
	}, { // 2717
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "６．ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄．｛",
		out:  "６．ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄．｛",
	}, { // 2718
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "６.ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄ω．",
		out:  "６.ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄ω‛．",
	}, { // 2719
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "６．ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄ω．",
		out:  "６．ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄ω‛．",
	}, { // 2720
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "６␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄.｛",
		out:  "６␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄.｛",
	}, { // 2721
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "６␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄．｛",
		out:  "６␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄．｛",
	}, { // 2722
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "６␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄.．",
		out:  "６␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄.‛．",
	}, { // 2723
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "６␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄．．",
		out:  "６␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄．‛．",
	}, { // 2724
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "６␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄ω.",
		out:  "６␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄ω．",
	}, { // 2725
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "６␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[␀δ＄ω．",
		out:  "６␑ςＷ\x14\bjU\x1d＼.␙νOEλz\x1c␅τＴ１ｎ\x10[‛␀δ‛＄ω‛．",
	}, { // 2726
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "Gρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007fｄ",
		out:  "Gρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007fｄ",
	}, { // 2727
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   ".． ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007fｄ",
		out:  ".． ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007fｄ",
	}, { // 2728
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．． ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007fｄ",
		out:  "．． ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007fｄ",
	}, { // 2729
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   ".ρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19．ｄ",
		out:  ".ρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19．ｄ",
	}, { // 2730
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．ρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19．ｄ",
		out:  "．ρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19．ｄ",
	}, { // 2731
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   ".ρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007f．",
		out:  ".ρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007f‛．",
	}, { // 2732
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．ρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007f．",
		out:  "．ρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007f‛．",
	}, { // 2733
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "G. ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007fｄ",
		out:  "G. ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007fｄ",
	}, { // 2734
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "G． ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007fｄ",
		out:  "G． ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007fｄ",
	}, { // 2735
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "G. ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19．ｄ",
		out:  "G. ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19．ｄ",
	}, { // 2736
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "G． ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19．ｄ",
		out:  "G． ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19．ｄ",
	}, { // 2737
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "G. ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007f．",
		out:  "G. ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007f‛．",
	}, { // 2738
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "G． ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007f．",
		out:  "G． ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007f‛．",
	}, { // 2739
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "Gρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19.ｄ",
		out:  "Gρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19.ｄ",
	}, { // 2740
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "Gρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19．ｄ",
		out:  "Gρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19．ｄ",
	}, { // 2741
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "Gρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19.．",
		out:  "Gρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19.‛．",
	}, { // 2742
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "Gρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19．．",
		out:  "Gρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19．‛．",
	}, { // 2743
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "Gρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007f.",
		out:  "Gρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007f．",
	}, { // 2744
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "Gρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007f．",
		out:  "Gρ ＵＩρη／υa.:＼γ?4κ/Ｖ／$％␐␙%;０\x19\u007f‛．",
	}, { // 2745
		mask: EncodeColon | EncodeRightPeriod,
		in:   "|ν＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α`\x1f",
		out:  "|ν＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α`\x1f",
	}, { // 2746
		mask: EncodeColon | EncodeRightPeriod,
		in:   ".．＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α`\x1f",
		out:  ".．＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α`\x1f",
	}, { // 2747
		mask: EncodeColon | EncodeRightPeriod,
		in:   "．．＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α`\x1f",
		out:  "．．＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α`\x1f",
	}, { // 2748
		mask: EncodeColon | EncodeRightPeriod,
		in:   ".ν＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α．\x1f",
		out:  ".ν＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α．\x1f",
	}, { // 2749
		mask: EncodeColon | EncodeRightPeriod,
		in:   "．ν＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α．\x1f",
		out:  "．ν＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α．\x1f",
	}, { // 2750
		mask: EncodeColon | EncodeRightPeriod,
		in:   ".ν＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α`．",
		out:  ".ν＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α`‛．",
	}, { // 2751
		mask: EncodeColon | EncodeRightPeriod,
		in:   "．ν＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α`．",
		out:  "．ν＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α`‛．",
	}, { // 2752
		mask: EncodeColon | EncodeRightPeriod,
		in:   "|.＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α`\x1f",
		out:  "|.＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α`\x1f",
	}, { // 2753
		mask: EncodeColon | EncodeRightPeriod,
		in:   "|．＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α`\x1f",
		out:  "|．＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α`\x1f",
	}, { // 2754
		mask: EncodeColon | EncodeRightPeriod,
		in:   "|.＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α．\x1f",
		out:  "|.＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α．\x1f",
	}, { // 2755
		mask: EncodeColon | EncodeRightPeriod,
		in:   "|．＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α．\x1f",
		out:  "|．＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α．\x1f",
	}, { // 2756
		mask: EncodeColon | EncodeRightPeriod,
		in:   "|.＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α`．",
		out:  "|.＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α`‛．",
	}, { // 2757
		mask: EncodeColon | EncodeRightPeriod,
		in:   "|．＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α`．",
		out:  "|．＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α`‛．",
	}, { // 2758
		mask: EncodeColon | EncodeRightPeriod,
		in:   "|ν＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α.\x1f",
		out:  "|ν＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α.\x1f",
	}, { // 2759
		mask: EncodeColon | EncodeRightPeriod,
		in:   "|ν＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α．\x1f",
		out:  "|ν＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α．\x1f",
	}, { // 2760
		mask: EncodeColon | EncodeRightPeriod,
		in:   "|ν＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α.．",
		out:  "|ν＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α.‛．",
	}, { // 2761
		mask: EncodeColon | EncodeRightPeriod,
		in:   "|ν＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α．．",
		out:  "|ν＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α．‛．",
	}, { // 2762
		mask: EncodeColon | EncodeRightPeriod,
		in:   "|ν＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α`.",
		out:  "|ν＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α`．",
	}, { // 2763
		mask: EncodeColon | EncodeRightPeriod,
		in:   "|ν＂[｀ｐＪ．ι␌.t：*～＇ω␂2β\f1␕θ_+?α`．",
		out:  "|ν＂[｀ｐＪ．ι␌.t‛：*～＇ω␂2β\f1␕θ_+?α`‛．",
	}, { // 2764
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\ndυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO\x05",
		out:  "\ndυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO\x05",
	}, { // 2765
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   ".．υ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO\x05",
		out:  ".．υ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO\x05",
	}, { // 2766
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "．．υ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO\x05",
		out:  "．．υ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO\x05",
	}, { // 2767
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   ".dυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθ．\x05",
		out:  ".dυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθ．\x05",
	}, { // 2768
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "．dυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθ．\x05",
		out:  "．dυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθ．\x05",
	}, { // 2769
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   ".dυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO．",
		out:  ".dυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO‛．",
	}, { // 2770
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "．dυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO．",
		out:  "．dυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO‛．",
	}, { // 2771
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\n.υ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO\x05",
		out:  "\n.υ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO\x05",
	}, { // 2772
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\n．υ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO\x05",
		out:  "\n．υ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO\x05",
	}, { // 2773
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\n.υ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθ．\x05",
		out:  "\n.υ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθ．\x05",
	}, { // 2774
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\n．υ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθ．\x05",
		out:  "\n．υ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθ．\x05",
	}, { // 2775
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\n.υ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO．",
		out:  "\n.υ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO‛．",
	}, { // 2776
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\n．υ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO．",
		out:  "\n．υ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO‛．",
	}, { // 2777
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\ndυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθ.\x05",
		out:  "\ndυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθ.\x05",
	}, { // 2778
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\ndυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθ．\x05",
		out:  "\ndυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθ．\x05",
	}, { // 2779
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\ndυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθ.．",
		out:  "\ndυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθ.‛．",
	}, { // 2780
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\ndυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθ．．",
		out:  "\ndυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθ．‛．",
	}, { // 2781
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\ndυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO.",
		out:  "\ndυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO．",
	}, { // 2782
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\ndυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO．",
		out:  "\ndυ&\x1f␑␉*εε.／ｚ｜｛#1＃␊＃␂πψ｜，4\x0fθO‛．",
	}, { // 2783
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "ｅ?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>α",
		out:  "ｅ?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>α",
	}, { // 2784
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   ".．\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>α",
		out:  ".．\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>α",
	}, { // 2785
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "．．\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>α",
		out:  "．．\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>α",
	}, { // 2786
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   ".?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10．α",
		out:  ".?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10．α",
	}, { // 2787
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "．?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10．α",
		out:  "．?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10．α",
	}, { // 2788
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   ".?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>．",
		out:  ".?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>‛．",
	}, { // 2789
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "．?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>．",
		out:  "．?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>‛．",
	}, { // 2790
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "ｅ.\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>α",
		out:  "ｅ.\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>α",
	}, { // 2791
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "ｅ．\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>α",
		out:  "ｅ．\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>α",
	}, { // 2792
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "ｅ.\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10．α",
		out:  "ｅ.\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10．α",
	}, { // 2793
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "ｅ．\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10．α",
		out:  "ｅ．\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10．α",
	}, { // 2794
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "ｅ.\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>．",
		out:  "ｅ.\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>‛．",
	}, { // 2795
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "ｅ．\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>．",
		out:  "ｅ．\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>‛．",
	}, { // 2796
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "ｅ?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10.α",
		out:  "ｅ?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10.α",
	}, { // 2797
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "ｅ?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10．α",
		out:  "ｅ?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10．α",
	}, { // 2798
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "ｅ?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10.．",
		out:  "ｅ?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10.‛．",
	}, { // 2799
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "ｅ?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10．．",
		out:  "ｅ?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10．‛．",
	}, { // 2800
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "ｅ?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>.",
		out:  "ｅ?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>．",
	}, { // 2801
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "ｅ?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>．",
		out:  "ｅ?\x1cJ␗υＥｇ,/.\nｍ␙␗δＹκ^␄ω［x?６Vτ\x10>‛．",
	}, { // 2802
		mask: EncodePipe | EncodeRightPeriod,
		in:   ">ιＯη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17␒\f",
		out:  ">ιＯη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17␒\f",
	}, { // 2803
		mask: EncodePipe | EncodeRightPeriod,
		in:   ".．Ｏη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17␒\f",
		out:  ".．Ｏη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17␒\f",
	}, { // 2804
		mask: EncodePipe | EncodeRightPeriod,
		in:   "．．Ｏη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17␒\f",
		out:  "．．Ｏη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17␒\f",
	}, { // 2805
		mask: EncodePipe | EncodeRightPeriod,
		in:   ".ιＯη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17．\f",
		out:  ".ιＯη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17．\f",
	}, { // 2806
		mask: EncodePipe | EncodeRightPeriod,
		in:   "．ιＯη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17．\f",
		out:  "．ιＯη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17．\f",
	}, { // 2807
		mask: EncodePipe | EncodeRightPeriod,
		in:   ".ιＯη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17␒．",
		out:  ".ιＯη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17␒‛．",
	}, { // 2808
		mask: EncodePipe | EncodeRightPeriod,
		in:   "．ιＯη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17␒．",
		out:  "．ιＯη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17␒‛．",
	}, { // 2809
		mask: EncodePipe | EncodeRightPeriod,
		in:   ">.Ｏη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17␒\f",
		out:  ">.Ｏη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17␒\f",
	}, { // 2810
		mask: EncodePipe | EncodeRightPeriod,
		in:   ">．Ｏη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17␒\f",
		out:  ">．Ｏη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17␒\f",
	}, { // 2811
		mask: EncodePipe | EncodeRightPeriod,
		in:   ">.Ｏη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17．\f",
		out:  ">.Ｏη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17．\f",
	}, { // 2812
		mask: EncodePipe | EncodeRightPeriod,
		in:   ">．Ｏη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17．\f",
		out:  ">．Ｏη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17．\f",
	}, { // 2813
		mask: EncodePipe | EncodeRightPeriod,
		in:   ">.Ｏη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17␒．",
		out:  ">.Ｏη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17␒‛．",
	}, { // 2814
		mask: EncodePipe | EncodeRightPeriod,
		in:   ">．Ｏη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17␒．",
		out:  ">．Ｏη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17␒‛．",
	}, { // 2815
		mask: EncodePipe | EncodeRightPeriod,
		in:   ">ιＯη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17.\f",
		out:  ">ιＯη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17.\f",
	}, { // 2816
		mask: EncodePipe | EncodeRightPeriod,
		in:   ">ιＯη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17．\f",
		out:  ">ιＯη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17．\f",
	}, { // 2817
		mask: EncodePipe | EncodeRightPeriod,
		in:   ">ιＯη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17.．",
		out:  ">ιＯη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17.‛．",
	}, { // 2818
		mask: EncodePipe | EncodeRightPeriod,
		in:   ">ιＯη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17．．",
		out:  ">ιＯη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17．‛．",
	}, { // 2819
		mask: EncodePipe | EncodeRightPeriod,
		in:   ">ιＯη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17␒.",
		out:  ">ιＯη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17␒．",
	}, { // 2820
		mask: EncodePipe | EncodeRightPeriod,
		in:   ">ιＯη\x16＆r6υ␓.]＾\"s␔\x19\x00Ｌθς␊［＜␛^ο\x17␒．",
		out:  ">ιＯη\x16＆r6υ␓.]＾\"s␔\x19␀Ｌθς␊［＜␛^ο\x17␒‛．",
	}, { // 2821
		mask: EncodeHash | EncodeRightPeriod,
		in:   "\x18γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19εＯ",
		out:  "\x18γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19εＯ",
	}, { // 2822
		mask: EncodeHash | EncodeRightPeriod,
		in:   ".．]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19εＯ",
		out:  ".．]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19εＯ",
	}, { // 2823
		mask: EncodeHash | EncodeRightPeriod,
		in:   "．．]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19εＯ",
		out:  "．．]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19εＯ",
	}, { // 2824
		mask: EncodeHash | EncodeRightPeriod,
		in:   ".γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19．Ｏ",
		out:  ".γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19．Ｏ",
	}, { // 2825
		mask: EncodeHash | EncodeRightPeriod,
		in:   "．γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19．Ｏ",
		out:  "．γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19．Ｏ",
	}, { // 2826
		mask: EncodeHash | EncodeRightPeriod,
		in:   ".γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19ε．",
		out:  ".γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19ε‛．",
	}, { // 2827
		mask: EncodeHash | EncodeRightPeriod,
		in:   "．γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19ε．",
		out:  "．γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19ε‛．",
	}, { // 2828
		mask: EncodeHash | EncodeRightPeriod,
		in:   "\x18.]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19εＯ",
		out:  "\x18.]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19εＯ",
	}, { // 2829
		mask: EncodeHash | EncodeRightPeriod,
		in:   "\x18．]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19εＯ",
		out:  "\x18．]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19εＯ",
	}, { // 2830
		mask: EncodeHash | EncodeRightPeriod,
		in:   "\x18.]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19．Ｏ",
		out:  "\x18.]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19．Ｏ",
	}, { // 2831
		mask: EncodeHash | EncodeRightPeriod,
		in:   "\x18．]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19．Ｏ",
		out:  "\x18．]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19．Ｏ",
	}, { // 2832
		mask: EncodeHash | EncodeRightPeriod,
		in:   "\x18.]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19ε．",
		out:  "\x18.]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19ε‛．",
	}, { // 2833
		mask: EncodeHash | EncodeRightPeriod,
		in:   "\x18．]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19ε．",
		out:  "\x18．]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19ε‛．",
	}, { // 2834
		mask: EncodeHash | EncodeRightPeriod,
		in:   "\x18γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19.Ｏ",
		out:  "\x18γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19.Ｏ",
	}, { // 2835
		mask: EncodeHash | EncodeRightPeriod,
		in:   "\x18γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19．Ｏ",
		out:  "\x18γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19．Ｏ",
	}, { // 2836
		mask: EncodeHash | EncodeRightPeriod,
		in:   "\x18γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19.．",
		out:  "\x18γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19.‛．",
	}, { // 2837
		mask: EncodeHash | EncodeRightPeriod,
		in:   "\x18γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19．．",
		out:  "\x18γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19．‛．",
	}, { // 2838
		mask: EncodeHash | EncodeRightPeriod,
		in:   "\x18γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19ε.",
		out:  "\x18γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19ε．",
	}, { // 2839
		mask: EncodeHash | EncodeRightPeriod,
		in:   "\x18γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19ε．",
		out:  "\x18γ]S␒ｏβ＄：γ.rθ'e\x04＜Ａ／Ｋ`␒␗βｐd/\x19ε‛．",
	}, { // 2840
		mask: EncodePercent | EncodeRightPeriod,
		in:   "νοzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"δ\b",
		out:  "νοzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"δ\b",
	}, { // 2841
		mask: EncodePercent | EncodeRightPeriod,
		in:   ".．zχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"δ\b",
		out:  ".．zχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"δ\b",
	}, { // 2842
		mask: EncodePercent | EncodeRightPeriod,
		in:   "．．zχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"δ\b",
		out:  "．．zχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"δ\b",
	}, { // 2843
		mask: EncodePercent | EncodeRightPeriod,
		in:   ".οzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"．\b",
		out:  ".οzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"．\b",
	}, { // 2844
		mask: EncodePercent | EncodeRightPeriod,
		in:   "．οzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"．\b",
		out:  "．οzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"．\b",
	}, { // 2845
		mask: EncodePercent | EncodeRightPeriod,
		in:   ".οzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"δ．",
		out:  ".οzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"δ‛．",
	}, { // 2846
		mask: EncodePercent | EncodeRightPeriod,
		in:   "．οzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"δ．",
		out:  "．οzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"δ‛．",
	}, { // 2847
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ν.zχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"δ\b",
		out:  "ν.zχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"δ\b",
	}, { // 2848
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ν．zχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"δ\b",
		out:  "ν．zχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"δ\b",
	}, { // 2849
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ν.zχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"．\b",
		out:  "ν.zχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"．\b",
	}, { // 2850
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ν．zχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"．\b",
		out:  "ν．zχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"．\b",
	}, { // 2851
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ν.zχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"δ．",
		out:  "ν.zχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"δ‛．",
	}, { // 2852
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ν．zχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"δ．",
		out:  "ν．zχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"δ‛．",
	}, { // 2853
		mask: EncodePercent | EncodeRightPeriod,
		in:   "νοzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\".\b",
		out:  "νοzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\".\b",
	}, { // 2854
		mask: EncodePercent | EncodeRightPeriod,
		in:   "νοzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"．\b",
		out:  "νοzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"．\b",
	}, { // 2855
		mask: EncodePercent | EncodeRightPeriod,
		in:   "νοzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\".．",
		out:  "νοzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\".‛．",
	}, { // 2856
		mask: EncodePercent | EncodeRightPeriod,
		in:   "νοzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"．．",
		out:  "νοzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"．‛．",
	}, { // 2857
		mask: EncodePercent | EncodeRightPeriod,
		in:   "νοzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"δ.",
		out:  "νοzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"δ．",
	}, { // 2858
		mask: EncodePercent | EncodeRightPeriod,
		in:   "νοzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01%Ｖ␂pＺβ␊b\"δ．",
		out:  "νοzχｇ*８ｉ␌τ.|u,␊NＰ␗\x01％Ｖ␂pＺβ␊b\"δ‛．",
	}, { // 2859
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "ι＇Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02｜",
		out:  "ι＇Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02｜",
	}, { // 2860
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   ".．Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02｜",
		out:  ".．Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02｜",
	}, { // 2861
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "．．Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02｜",
		out:  "．．Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02｜",
	}, { // 2862
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   ".＇Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉．｜",
		out:  ".＇Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉．｜",
	}, { // 2863
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "．＇Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉．｜",
		out:  "．＇Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉．｜",
	}, { // 2864
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   ".＇Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02．",
		out:  ".＇Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02‛．",
	}, { // 2865
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "．＇Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02．",
		out:  "．＇Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02‛．",
	}, { // 2866
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "ι.Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02｜",
		out:  "ι.Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02｜",
	}, { // 2867
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "ι．Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02｜",
		out:  "ι．Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02｜",
	}, { // 2868
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "ι.Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉．｜",
		out:  "ι.Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉．｜",
	}, { // 2869
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "ι．Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉．｜",
		out:  "ι．Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉．｜",
	}, { // 2870
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "ι.Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02．",
		out:  "ι.Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02‛．",
	}, { // 2871
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "ι．Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02．",
		out:  "ι．Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02‛．",
	}, { // 2872
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "ι＇Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉.｜",
		out:  "ι＇Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉.｜",
	}, { // 2873
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "ι＇Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉．｜",
		out:  "ι＇Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉．｜",
	}, { // 2874
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "ι＇Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉.．",
		out:  "ι＇Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉.‛．",
	}, { // 2875
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "ι＇Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉．．",
		out:  "ι＇Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉．‛．",
	}, { // 2876
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "ι＇Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02.",
		out:  "ι＇Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02．",
	}, { // 2877
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "ι＇Ｒ\x1d\x0e;mnＬψ.＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02．",
		out:  "ι＇Ｒ\x1d\x0e;mnＬψ.‛＼oｂｙ＂｀\x14$πξ␞.Dπ：λ␉\x02‛．",
	}, { // 2878
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "\x17A␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφc",
		out:  "\x17A␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφc",
	}, { // 2879
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   ".．␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφc",
		out:  ".．␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφc",
	}, { // 2880
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "．．␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφc",
		out:  "．．␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφc",
	}, { // 2881
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   ".A␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａ．c",
		out:  ".A␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａ．c",
	}, { // 2882
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "．A␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａ．c",
		out:  "．A␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａ．c",
	}, { // 2883
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   ".A␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφ．",
		out:  ".A␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφ‛．",
	}, { // 2884
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "．A␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφ．",
		out:  "．A␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφ‛．",
	}, { // 2885
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "\x17.␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφc",
		out:  "\x17.␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφc",
	}, { // 2886
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "\x17．␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφc",
		out:  "\x17．␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφc",
	}, { // 2887
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "\x17.␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａ．c",
		out:  "\x17.␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａ．c",
	}, { // 2888
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "\x17．␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａ．c",
		out:  "\x17．␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａ．c",
	}, { // 2889
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "\x17.␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφ．",
		out:  "\x17.␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφ‛．",
	}, { // 2890
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "\x17．␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφ．",
		out:  "\x17．␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφ‛．",
	}, { // 2891
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "\x17A␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａ.c",
		out:  "\x17A␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａ.c",
	}, { // 2892
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "\x17A␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａ．c",
		out:  "\x17A␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａ．c",
	}, { // 2893
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "\x17A␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａ.．",
		out:  "\x17A␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａ.‛．",
	}, { // 2894
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "\x17A␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａ．．",
		out:  "\x17A␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａ．‛．",
	}, { // 2895
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "\x17A␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφ.",
		out:  "\x17A␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφ．",
	}, { // 2896
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "\x17A␉η\r>ρ２πL.␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφ．",
		out:  "\x17A␉η␍>ρ２πL.‛␍>\x1d＜K｜Eｈ␐ρ＃>λ］＇$ａφ‛．",
	}, { // 2897
		mask: EncodeDel | EncodeRightPeriod,
		in:   "/ρχ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃcv",
		out:  "/ρχ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃcv",
	}, { // 2898
		mask: EncodeDel | EncodeRightPeriod,
		in:   ".．χ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃcv",
		out:  ".．χ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃcv",
	}, { // 2899
		mask: EncodeDel | EncodeRightPeriod,
		in:   "．．χ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃcv",
		out:  "．．χ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃcv",
	}, { // 2900
		mask: EncodeDel | EncodeRightPeriod,
		in:   ".ρχ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃ．v",
		out:  ".ρχ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃ．v",
	}, { // 2901
		mask: EncodeDel | EncodeRightPeriod,
		in:   "．ρχ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃ．v",
		out:  "．ρχ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃ．v",
	}, { // 2902
		mask: EncodeDel | EncodeRightPeriod,
		in:   ".ρχ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃc．",
		out:  ".ρχ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃc‛．",
	}, { // 2903
		mask: EncodeDel | EncodeRightPeriod,
		in:   "．ρχ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃc．",
		out:  "．ρχ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃc‛．",
	}, { // 2904
		mask: EncodeDel | EncodeRightPeriod,
		in:   "/.χ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃcv",
		out:  "/.χ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃcv",
	}, { // 2905
		mask: EncodeDel | EncodeRightPeriod,
		in:   "/．χ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃcv",
		out:  "/．χ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃcv",
	}, { // 2906
		mask: EncodeDel | EncodeRightPeriod,
		in:   "/.χ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃ．v",
		out:  "/.χ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃ．v",
	}, { // 2907
		mask: EncodeDel | EncodeRightPeriod,
		in:   "/．χ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃ．v",
		out:  "/．χ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃ．v",
	}, { // 2908
		mask: EncodeDel | EncodeRightPeriod,
		in:   "/.χ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃc．",
		out:  "/.χ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃc‛．",
	}, { // 2909
		mask: EncodeDel | EncodeRightPeriod,
		in:   "/．χ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃc．",
		out:  "/．χ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃc‛．",
	}, { // 2910
		mask: EncodeDel | EncodeRightPeriod,
		in:   "/ρχ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃ.v",
		out:  "/ρχ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃ.v",
	}, { // 2911
		mask: EncodeDel | EncodeRightPeriod,
		in:   "/ρχ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃ．v",
		out:  "/ρχ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃ．v",
	}, { // 2912
		mask: EncodeDel | EncodeRightPeriod,
		in:   "/ρχ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃ.．",
		out:  "/ρχ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃ.‛．",
	}, { // 2913
		mask: EncodeDel | EncodeRightPeriod,
		in:   "/ρχ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃ．．",
		out:  "/ρχ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃ．‛．",
	}, { // 2914
		mask: EncodeDel | EncodeRightPeriod,
		in:   "/ρχ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃc.",
		out:  "/ρχ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃc．",
	}, { // 2915
		mask: EncodeDel | EncodeRightPeriod,
		in:   "/ρχ␑9／\fr␜i.；␃λ\x0f\u007f␞ς＼ι\x1f４\x17μ␛R（Ｃc．",
		out:  "/ρχ␑9／\fr␜i.；␃λ\x0f␡␞ς＼ι\x1f４\x17μ␛R（Ｃc‛．",
	}, { // 2916
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␝\tｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/τＩ",
		out:  "‛␝␉ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/τＩ",
	}, { // 2917
		mask: EncodeCtl | EncodeRightPeriod,
		in:   ".．ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/τＩ",
		out:  ".．ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/τＩ",
	}, { // 2918
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "．．ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/τＩ",
		out:  "．．ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/τＩ",
	}, { // 2919
		mask: EncodeCtl | EncodeRightPeriod,
		in:   ".\tｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/．Ｉ",
		out:  ".␉ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/．Ｉ",
	}, { // 2920
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "．\tｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/．Ｉ",
		out:  "．␉ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/．Ｉ",
	}, { // 2921
		mask: EncodeCtl | EncodeRightPeriod,
		in:   ".\tｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/τ．",
		out:  ".␉ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/τ‛．",
	}, { // 2922
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "．\tｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/τ．",
		out:  "．␉ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/τ‛．",
	}, { // 2923
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␝.ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/τＩ",
		out:  "‛␝.ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/τＩ",
	}, { // 2924
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␝．ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/τＩ",
		out:  "‛␝．ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/τＩ",
	}, { // 2925
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␝.ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/．Ｉ",
		out:  "‛␝.ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/．Ｉ",
	}, { // 2926
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␝．ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/．Ｉ",
		out:  "‛␝．ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/．Ｉ",
	}, { // 2927
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␝.ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/τ．",
		out:  "‛␝.ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/τ‛．",
	}, { // 2928
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␝．ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/τ．",
		out:  "‛␝．ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/τ‛．",
	}, { // 2929
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␝\tｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/.Ｉ",
		out:  "‛␝␉ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/.Ｉ",
	}, { // 2930
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␝\tｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/．Ｉ",
		out:  "‛␝␉ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/．Ｉ",
	}, { // 2931
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␝\tｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/.．",
		out:  "‛␝␉ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/.‛．",
	}, { // 2932
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␝\tｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/．．",
		out:  "‛␝␉ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/．‛．",
	}, { // 2933
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␝\tｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/τ.",
		out:  "‛␝␉ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/τ．",
	}, { // 2934
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␝\tｒｎ＄Ｈεψ<h.η＼ζ／:$ ４\x04？␉\x17Ｓξw2/τ．",
		out:  "‛␝␉ｒｎ＄Ｈεψ<h.η＼ζ／:$ ４␄？‛␉␗Ｓξw2/τ‛．",
	}, { // 2935
		mask: EncodeRightCrLfHtVt,
		in:   "\t",
		out:  "␉",
	}, { // 2936
		mask: EncodeRightCrLfHtVt,
		in:   "\n",
		out:  "␊",
	}, { // 2937
		mask: EncodeRightCrLfHtVt,
		in:   "\v",
		out:  "␋",
	}, { // 2938
		mask: EncodeRightCrLfHtVt,
		in:   "\r",
		out:  "␍",
	}, { // 2939
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␁␁␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης＾",
		out:  "␁␁‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης＾",
	}, { // 2940
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\t␉␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης＾",
		out:  "\t␉‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης＾",
	}, { // 2941
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␉␉␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης＾",
		out:  "␉␉‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης＾",
	}, { // 2942
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\t␁␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊη␉＾",
		out:  "\t␁‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊη␉＾",
	}, { // 2943
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␉␁␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊη␉＾",
		out:  "␉␁‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊη␉＾",
	}, { // 2944
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\t␁␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης␉",
		out:  "\t␁‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης‛␉",
	}, { // 2945
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␉␁␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης␉",
		out:  "␉␁‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης‛␉",
	}, { // 2946
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␁\t␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης＾",
		out:  "␁\t‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης＾",
	}, { // 2947
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␁␉␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης＾",
		out:  "␁␉‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης＾",
	}, { // 2948
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␁\t␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊη␉＾",
		out:  "␁\t‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊη␉＾",
	}, { // 2949
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␁␉␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊη␉＾",
		out:  "␁␉‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊη␉＾",
	}, { // 2950
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␁\t␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης␉",
		out:  "␁\t‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης‛␉",
	}, { // 2951
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␁␉␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης␉",
		out:  "␁␉‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης‛␉",
	}, { // 2952
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␁␁␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊη\t＾",
		out:  "␁␁‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊη\t＾",
	}, { // 2953
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␁␁␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊη␉＾",
		out:  "␁␁‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊη␉＾",
	}, { // 2954
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␁␁␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊη\t␉",
		out:  "␁␁‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊη\t‛␉",
	}, { // 2955
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␁␁␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊη␉␉",
		out:  "␁␁‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊη␉‛␉",
	}, { // 2956
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␁␁␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης\t",
		out:  "␁␁‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης␉",
	}, { // 2957
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␁␁␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης␉",
		out:  "␁␁‛␀\x06π3Ｇｅη\x17\t：5Oｙ␘=ιγ\x17\nC＞\x1c␂\x15Ｊης‛␉",
	}, { // 2958
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "χ␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γθ",
		out:  "χ␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γθ",
	}, { // 2959
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n␊ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γθ",
		out:  "\n␊ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γθ",
	}, { // 2960
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␊␊ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γθ",
		out:  "␊␊ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γθ",
	}, { // 2961
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４␊θ",
		out:  "\n␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４␊θ",
	}, { // 2962
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␊␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４␊θ",
		out:  "␊␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４␊θ",
	}, { // 2963
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γ␊",
		out:  "\n␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γ‛␊",
	}, { // 2964
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␊␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γ␊",
		out:  "␊␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γ‛␊",
	}, { // 2965
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "χ\nςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γθ",
		out:  "χ\nςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γθ",
	}, { // 2966
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "χ␊ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γθ",
		out:  "χ␊ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γθ",
	}, { // 2967
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "χ\nςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４␊θ",
		out:  "χ\nςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４␊θ",
	}, { // 2968
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "χ␊ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４␊θ",
		out:  "χ␊ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４␊θ",
	}, { // 2969
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "χ\nςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γ␊",
		out:  "χ\nςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γ‛␊",
	}, { // 2970
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "χ␊ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γ␊",
		out:  "χ␊ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γ‛␊",
	}, { // 2971
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "χ␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４\nθ",
		out:  "χ␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４\nθ",
	}, { // 2972
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "χ␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４␊θ",
		out:  "χ␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４␊θ",
	}, { // 2973
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "χ␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４\n␊",
		out:  "χ␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４\n‛␊",
	}, { // 2974
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "χ␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４␊␊",
		out:  "χ␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４␊‛␊",
	}, { // 2975
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "χ␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γ\n",
		out:  "χ␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γ␊",
	}, { // 2976
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "χ␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γ␊",
		out:  "χ␔ςhς0z\x13%＃\n\x06␁Ｒ＂ς␛＄ｆB\x05^ｙ\x0f\x02Ｓ［４γ‛␊",
	}, { // 2977
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "λ２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␀_",
		out:  "λ２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ‛␀_",
	}, { // 2978
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\v␋ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␀_",
		out:  "\v␋ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ‛␀_",
	}, { // 2979
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␋␋ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␀_",
		out:  "␋␋ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ‛␀_",
	}, { // 2980
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\v２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␋_",
		out:  "\v２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␋_",
	}, { // 2981
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␋２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␋_",
		out:  "␋２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␋_",
	}, { // 2982
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\v２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␀␋",
		out:  "\v２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ‛␀‛␋",
	}, { // 2983
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␋２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␀␋",
		out:  "␋２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ‛␀‛␋",
	}, { // 2984
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "λ\v |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␀_",
		out:  "λ\v |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ‛␀_",
	}, { // 2985
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "λ␋ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␀_",
		out:  "λ␋ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ‛␀_",
	}, { // 2986
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "λ\v |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␋_",
		out:  "λ\v |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␋_",
	}, { // 2987
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "λ␋ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␋_",
		out:  "λ␋ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␋_",
	}, { // 2988
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "λ\v |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␀␋",
		out:  "λ\v |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ‛␀‛␋",
	}, { // 2989
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "λ␋ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␀␋",
		out:  "λ␋ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ‛␀‛␋",
	}, { // 2990
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "λ２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ\v_",
		out:  "λ２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ\v_",
	}, { // 2991
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "λ２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␋_",
		out:  "λ２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␋_",
	}, { // 2992
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "λ２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ\v␋",
		out:  "λ２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ\v‛␋",
	}, { // 2993
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "λ２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␋␋",
		out:  "λ２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␋‛␋",
	}, { // 2994
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "λ２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␀\v",
		out:  "λ２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ‛␀␋",
	}, { // 2995
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "λ２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ␀␋",
		out:  "λ２ |␊Ｄ\x01δsN\vυ␆ςR␄Ｕ／＋\x12Ｈζ\x0fη\x05\x14:ｏ‛␀‛␋",
	}, { // 2996
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "δ\x138β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌[\x17",
		out:  "δ\x138β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌[\x17",
	}, { // 2997
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r␍8β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌[\x17",
		out:  "\r␍8β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌[\x17",
	}, { // 2998
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␍␍8β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌[\x17",
		out:  "␍␍8β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌[\x17",
	}, { // 2999
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r\x138β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌␍\x17",
		out:  "\r\x138β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌␍\x17",
	}, { // 3000
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␍\x138β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌␍\x17",
		out:  "␍\x138β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌␍\x17",
	}, { // 3001
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r\x138β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌[␍",
		out:  "\r\x138β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌[‛␍",
	}, { // 3002
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␍\x138β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌[␍",
		out:  "␍\x138β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌[‛␍",
	}, { // 3003
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "δ\r8β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌[\x17",
		out:  "δ\r8β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌[\x17",
	}, { // 3004
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "δ␍8β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌[\x17",
		out:  "δ␍8β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌[\x17",
	}, { // 3005
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "δ\r8β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌␍\x17",
		out:  "δ\r8β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌␍\x17",
	}, { // 3006
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "δ␍8β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌␍\x17",
		out:  "δ␍8β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌␍\x17",
	}, { // 3007
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "δ\r8β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌[␍",
		out:  "δ\r8β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌[‛␍",
	}, { // 3008
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "δ␍8β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌[␍",
		out:  "δ␍8β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌[‛␍",
	}, { // 3009
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "δ\x138β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌\r\x17",
		out:  "δ\x138β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌\r\x17",
	}, { // 3010
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "δ\x138β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌␍\x17",
		out:  "δ\x138β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌␍\x17",
	}, { // 3011
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "δ\x138β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌\r␍",
		out:  "δ\x138β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌\r‛␍",
	}, { // 3012
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "δ\x138β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌␍␍",
		out:  "δ\x138β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌␍‛␍",
	}, { // 3013
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "δ\x138β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌[\r",
		out:  "δ\x138β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌[␍",
	}, { // 3014
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "δ\x138β{v｜\x1dη＜\rＤ\x006＼４υβ␔␜mｂLＵ｝ｗκ␌[␍",
		out:  "δ\x138β{v｜\x1dη＜\rＤ␀6＼４υβ␔␜mｂLＵ｝ｗκ␌[‛␍",
	}, { // 3015
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "ｉ␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；μ",
		out:  "ｉ␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；μ",
	}, { // 3016
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\t␉␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；μ",
		out:  "\t␉␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；μ",
	}, { // 3017
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␉␉␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；μ",
		out:  "␉␉␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；μ",
	}, { // 3018
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\t␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿␉μ",
		out:  "\t␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿␉μ",
	}, { // 3019
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␉␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿␉μ",
		out:  "␉␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿␉μ",
	}, { // 3020
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\t␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；␉",
		out:  "\t␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；‛␉",
	}, { // 3021
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␉␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；␉",
		out:  "␉␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；‛␉",
	}, { // 3022
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "ｉ\t␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；μ",
		out:  "ｉ\t␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；μ",
	}, { // 3023
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "ｉ␉␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；μ",
		out:  "ｉ␉␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；μ",
	}, { // 3024
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "ｉ\t␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿␉μ",
		out:  "ｉ\t␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿␉μ",
	}, { // 3025
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "ｉ␉␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿␉μ",
		out:  "ｉ␉␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿␉μ",
	}, { // 3026
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "ｉ\t␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；␉",
		out:  "ｉ\t␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；‛␉",
	}, { // 3027
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "ｉ␉␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；␉",
		out:  "ｉ␉␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；‛␉",
	}, { // 3028
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "ｉ␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿\tμ",
		out:  "ｉ␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿\tμ",
	}, { // 3029
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "ｉ␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿␉μ",
		out:  "ｉ␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿␉μ",
	}, { // 3030
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "ｉ␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿\t␉",
		out:  "ｉ␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿\t‛␉",
	}, { // 3031
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "ｉ␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿␉␉",
		out:  "ｉ␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿␉‛␉",
	}, { // 3032
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "ｉ␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；\t",
		out:  "ｉ␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；␉",
	}, { // 3033
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "ｉ␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；␉",
		out:  "ｉ␌␃οr\x16c？χσ\tυ２␘Iθ\u007f\x19\x03\\␒\x01\x04OYＬ␃＿；‛␉",
	}, { // 3034
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,}",
		out:  "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,}",
	}, { // 3035
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\n␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,}",
		out:  "\n␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,}",
	}, { // 3036
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␊␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,}",
		out:  "␊␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,}",
	}, { // 3037
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\n␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗␊}",
		out:  "\n␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗␊}",
	}, { // 3038
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␊␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗␊}",
		out:  "␊␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗␊}",
	}, { // 3039
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\n␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,␊",
		out:  "\n␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,‛␊",
	}, { // 3040
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␊␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,␊",
		out:  "␊␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,‛␊",
	}, { // 3041
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "｝\nη␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,}",
		out:  "｝\nη␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,}",
	}, { // 3042
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,}",
		out:  "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,}",
	}, { // 3043
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "｝\nη␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗␊}",
		out:  "｝\nη␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗␊}",
	}, { // 3044
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗␊}",
		out:  "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗␊}",
	}, { // 3045
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "｝\nη␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,␊",
		out:  "｝\nη␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,‛␊",
	}, { // 3046
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,␊",
		out:  "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,‛␊",
	}, { // 3047
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗\n}",
		out:  "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗\n}",
	}, { // 3048
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗␊}",
		out:  "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗␊}",
	}, { // 3049
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗\n␊",
		out:  "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗\n‛␊",
	}, { // 3050
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗␊␊",
		out:  "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗␊‛␊",
	}, { // 3051
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,\n",
		out:  "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,␊",
	}, { // 3052
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,␊",
		out:  "｝␊η␈κζ%;:０\nf＿ο)#｝\x12\uff00␈ρ␡>?λQｕ␗,‛␊",
	}, { // 3053
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␒w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15.",
		out:  "␒w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15.",
	}, { // 3054
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\v␋\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15.",
		out:  "\v␋\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15.",
	}, { // 3055
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␋␋\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15.",
		out:  "␋␋\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15.",
	}, { // 3056
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\vw\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎␋.",
		out:  "\vw\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎␋.",
	}, { // 3057
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␋w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎␋.",
		out:  "␋w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎␋.",
	}, { // 3058
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\vw\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15␋",
		out:  "\vw\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15‛␋",
	}, { // 3059
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␋w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15␋",
		out:  "␋w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15‛␋",
	}, { // 3060
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␒\v\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15.",
		out:  "␒\v\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15.",
	}, { // 3061
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␒␋\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15.",
		out:  "␒␋\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15.",
	}, { // 3062
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␒\v\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎␋.",
		out:  "␒\v\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎␋.",
	}, { // 3063
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␒␋\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎␋.",
		out:  "␒␋\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎␋.",
	}, { // 3064
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␒\v\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15␋",
		out:  "␒\v\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15‛␋",
	}, { // 3065
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␒␋\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15␋",
		out:  "␒␋\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15‛␋",
	}, { // 3066
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␒w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\v.",
		out:  "␒w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\v.",
	}, { // 3067
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␒w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎␋.",
		out:  "␒w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎␋.",
	}, { // 3068
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␒w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\v␋",
		out:  "␒w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\v‛␋",
	}, { // 3069
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␒w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎␋␋",
		out:  "␒w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎␋‛␋",
	}, { // 3070
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␒w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15\v",
		out:  "␒w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15␋",
	}, { // 3071
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␒w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15␋",
		out:  "␒w\x1bκ\x17␒\x1fYφＪ\v｀［\vM␐ｕω｝ｆ5\x1eγπ～␂_␎\x15‛␋",
	}, { // 3072
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "/υ␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３ακ",
		out:  "／υ␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３ακ",
	}, { // 3073
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\r␍␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３ακ",
		out:  "\r␍␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３ακ",
	}, { // 3074
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␍␍␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３ακ",
		out:  "␍␍␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３ακ",
	}, { // 3075
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\rυ␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３␍κ",
		out:  "\rυ␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３␍κ",
	}, { // 3076
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␍υ␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３␍κ",
		out:  "␍υ␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３␍κ",
	}, { // 3077
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\rυ␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３α␍",
		out:  "\rυ␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３α‛␍",
	}, { // 3078
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␍υ␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３α␍",
		out:  "␍υ␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３α‛␍",
	}, { // 3079
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "/\r␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３ακ",
		out:  "／\r␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３ακ",
	}, { // 3080
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "/␍␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３ακ",
		out:  "／␍␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３ακ",
	}, { // 3081
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "/\r␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３␍κ",
		out:  "／\r␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３␍κ",
	}, { // 3082
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "/␍␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３␍κ",
		out:  "／␍␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３␍κ",
	}, { // 3083
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "/\r␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３α␍",
		out:  "／\r␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３α‛␍",
	}, { // 3084
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "/␍␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３α␍",
		out:  "／␍␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３α‛␍",
	}, { // 3085
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "/υ␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３\rκ",
		out:  "／υ␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３\rκ",
	}, { // 3086
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "/υ␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３␍κ",
		out:  "／υ␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３␍κ",
	}, { // 3087
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "/υ␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３\r␍",
		out:  "／υ␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３\r‛␍",
	}, { // 3088
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "/υ␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３␍␍",
		out:  "／υ␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３␍‛␍",
	}, { // 3089
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "/υ␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３α\r",
		out:  "／υ␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３α␍",
	}, { // 3090
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "/υ␝\u007f＼e[\x1a／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３α␍",
		out:  "／υ␝\u007f＼e[\x1a‛／o\rv:｛␁T＞Ｉ\\#ｋδςξ␔ｇM３α‛␍",
	}, { // 3091
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "＼%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛Ｌ",
		out:  "＼%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛Ｌ",
	}, { // 3092
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\t␉\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛Ｌ",
		out:  "\t␉\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛Ｌ",
	}, { // 3093
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␉␉\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛Ｌ",
		out:  "␉␉\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛Ｌ",
	}, { // 3094
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\t%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␉Ｌ",
		out:  "\t%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␉Ｌ",
	}, { // 3095
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␉%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␉Ｌ",
		out:  "␉%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␉Ｌ",
	}, { // 3096
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\t%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛␉",
		out:  "\t%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛‛␉",
	}, { // 3097
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␉%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛␉",
		out:  "␉%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛‛␉",
	}, { // 3098
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "＼\t\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛Ｌ",
		out:  "＼\t\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛Ｌ",
	}, { // 3099
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "＼␉\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛Ｌ",
		out:  "＼␉\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛Ｌ",
	}, { // 3100
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "＼\t\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␉Ｌ",
		out:  "＼\t\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␉Ｌ",
	}, { // 3101
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "＼␉\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␉Ｌ",
		out:  "＼␉\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␉Ｌ",
	}, { // 3102
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "＼\t\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛␉",
		out:  "＼\t\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛‛␉",
	}, { // 3103
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "＼␉\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛␉",
		out:  "＼␉\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛‛␉",
	}, { // 3104
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "＼%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10\tＬ",
		out:  "＼%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10\tＬ",
	}, { // 3105
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "＼%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␉Ｌ",
		out:  "＼%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␉Ｌ",
	}, { // 3106
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "＼%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10\t␉",
		out:  "＼%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10\t‛␉",
	}, { // 3107
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "＼%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␉␉",
		out:  "＼%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␉‛␉",
	}, { // 3108
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "＼%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛\t",
		out:  "＼%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛␉",
	}, { // 3109
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "＼%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛␉",
		out:  "＼%\x0eο␍IＮki␕\t\r］ζ*θ\x03ρ７7␈εＫIσＲＭ\x10␛‛␉",
	}, { // 3110
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␜ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e/",
		out:  "␜ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e/",
	}, { // 3111
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\n␊\x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e/",
		out:  "\n␊\x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e/",
	}, { // 3112
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␊␊\x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e/",
		out:  "␊␊\x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e/",
	}, { // 3113
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\n \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ␊/",
		out:  "\n \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ␊/",
	}, { // 3114
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␊ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ␊/",
		out:  "␊ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ␊/",
	}, { // 3115
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\n \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e␊",
		out:  "\n \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e‛␊",
	}, { // 3116
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␊ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e␊",
		out:  "␊ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e‛␊",
	}, { // 3117
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␜\n\x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e/",
		out:  "␜\n\x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e/",
	}, { // 3118
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␜␊\x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e/",
		out:  "␜␊\x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e/",
	}, { // 3119
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␜\n\x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ␊/",
		out:  "␜\n\x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ␊/",
	}, { // 3120
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␜␊\x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ␊/",
		out:  "␜␊\x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ␊/",
	}, { // 3121
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␜\n\x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e␊",
		out:  "␜\n\x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e‛␊",
	}, { // 3122
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␜␊\x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e␊",
		out:  "␜␊\x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e‛␊",
	}, { // 3123
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␜ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\n/",
		out:  "␜ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\n/",
	}, { // 3124
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␜ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ␊/",
		out:  "␜ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ␊/",
	}, { // 3125
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␜ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\n␊",
		out:  "␜ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\n‛␊",
	}, { // 3126
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␜ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ␊␊",
		out:  "␜ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ␊‛␊",
	}, { // 3127
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␜ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e\n",
		out:  "␜ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e␊",
	}, { // 3128
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␜ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e␊",
		out:  "␜ \x18`L␍?οｋ？\nαφθ^D\x17ｄｃ␁2␕Ｂζ\n␉＿ｈ\x0e‛␊",
	}, { // 3129
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ｘ1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\ο",
		out:  "ｘ1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\ο",
	}, { // 3130
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\v␋`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\ο",
		out:  "\v␋`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\ο",
	}, { // 3131
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␋␋`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\ο",
		out:  "␋␋`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\ο",
	}, { // 3132
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\v1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ␋ο",
		out:  "\v1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ␋ο",
	}, { // 3133
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␋1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ␋ο",
		out:  "␋1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ␋ο",
	}, { // 3134
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\v1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\␋",
		out:  "\v1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\‛␋",
	}, { // 3135
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␋1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\␋",
		out:  "␋1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\‛␋",
	}, { // 3136
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ｘ\v`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\ο",
		out:  "ｘ\v`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\ο",
	}, { // 3137
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ｘ␋`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\ο",
		out:  "ｘ␋`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\ο",
	}, { // 3138
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ｘ\v`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ␋ο",
		out:  "ｘ\v`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ␋ο",
	}, { // 3139
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ｘ␋`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ␋ο",
		out:  "ｘ␋`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ␋ο",
	}, { // 3140
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ｘ\v`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\␋",
		out:  "ｘ\v`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\‛␋",
	}, { // 3141
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ｘ␋`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\␋",
		out:  "ｘ␋`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\‛␋",
	}, { // 3142
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ｘ1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\vο",
		out:  "ｘ1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\vο",
	}, { // 3143
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ｘ1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ␋ο",
		out:  "ｘ1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ␋ο",
	}, { // 3144
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ｘ1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\v␋",
		out:  "ｘ1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\v‛␋",
	}, { // 3145
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ｘ1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ␋␋",
		out:  "ｘ1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ␋‛␋",
	}, { // 3146
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ｘ1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\\v",
		out:  "ｘ1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\␋",
	}, { // 3147
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ｘ1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\␋",
		out:  "ｘ1`␓\x06ｚπz␡＞\v＃D/\"Ｎkπo␃Dψ\fυ％␇＾χ\\‛␋",
	}, { // 3148
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "σL/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05Iθ",
		out:  "σL/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05Iθ",
	}, { // 3149
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\r␍/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05Iθ",
		out:  "\r␍/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05Iθ",
	}, { // 3150
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␍␍/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05Iθ",
		out:  "␍␍/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05Iθ",
	}, { // 3151
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\rL/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05␍θ",
		out:  "\rL/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05␍θ",
	}, { // 3152
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␍L/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05␍θ",
		out:  "␍L/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05␍θ",
	}, { // 3153
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\rL/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05I␍",
		out:  "\rL/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05I‛␍",
	}, { // 3154
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␍L/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05I␍",
		out:  "␍L/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05I‛␍",
	}, { // 3155
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "σ\r/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05Iθ",
		out:  "σ\r/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05Iθ",
	}, { // 3156
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "σ␍/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05Iθ",
		out:  "σ␍/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05Iθ",
	}, { // 3157
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "σ\r/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05␍θ",
		out:  "σ\r/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05␍θ",
	}, { // 3158
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "σ␍/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05␍θ",
		out:  "σ␍/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05␍θ",
	}, { // 3159
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "σ\r/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05I␍",
		out:  "σ\r/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05I‛␍",
	}, { // 3160
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "σ␍/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05I␍",
		out:  "σ␍/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05I‛␍",
	}, { // 3161
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "σL/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05\rθ",
		out:  "σL/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05\rθ",
	}, { // 3162
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "σL/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05␍θ",
		out:  "σL/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05␍θ",
	}, { // 3163
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "σL/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05\r␍",
		out:  "σL/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05\r‛␍",
	}, { // 3164
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "σL/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05␍␍",
		out:  "σL/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05␍‛␍",
	}, { // 3165
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "σL/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05I\r",
		out:  "σL/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05I␍",
	}, { // 3166
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "σL/Ｋθ`\x01<'␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05I␍",
		out:  "σL/Ｋθ`\x01<＇␡\r＜＃\x18Ｄ␑ρＳＪ＿g␅７π␆ι\x1d\x05I‛␍",
	}, { // 3167
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\x1d\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙa",
		out:  "\x1d\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙa",
	}, { // 3168
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\t␉\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙa",
		out:  "\t␉\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙa",
	}, { // 3169
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␉␉\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙa",
		out:  "␉␉\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙa",
	}, { // 3170
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\t\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜␉a",
		out:  "\t\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜␉a",
	}, { // 3171
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␉\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜␉a",
		out:  "␉\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜␉a",
	}, { // 3172
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\t\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙ␉",
		out:  "\t\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙ‛␉",
	}, { // 3173
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␉\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙ␉",
		out:  "␉\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙ‛␉",
	}, { // 3174
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\x1d\t\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙa",
		out:  "\x1d\t\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙa",
	}, { // 3175
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\x1d␉\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙa",
		out:  "\x1d␉\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙa",
	}, { // 3176
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\x1d\t\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜␉a",
		out:  "\x1d\t\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜␉a",
	}, { // 3177
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\x1d␉\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜␉a",
		out:  "\x1d␉\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜␉a",
	}, { // 3178
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\x1d\t\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙ␉",
		out:  "\x1d\t\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙ‛␉",
	}, { // 3179
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\x1d␉\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙ␉",
		out:  "\x1d␉\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙ‛␉",
	}, { // 3180
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\x1d\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜\ta",
		out:  "\x1d\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜\ta",
	}, { // 3181
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\x1d\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜␉a",
		out:  "\x1d\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜␉a",
	}, { // 3182
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\x1d\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜\t␉",
		out:  "\x1d\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜\t‛␉",
	}, { // 3183
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\x1d\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜␉␉",
		out:  "\x1d\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜␉‛␉",
	}, { // 3184
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\x1d\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙ\t",
		out:  "\x1d\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙ␉",
	}, { // 3185
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\x1d\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙ␉",
		out:  "\x1d\x1f\x06␛λ>'Oγ7\tｔμξο␌\x15％K␟␡$＝␞ｂＴψ␜ｙ‛␉",
	}, { // 3186
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "<：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11ｘ",
		out:  "<：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11ｘ",
	}, { // 3187
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\n␊π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11ｘ",
		out:  "\n␊π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11ｘ",
	}, { // 3188
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␊␊π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11ｘ",
		out:  "␊␊π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11ｘ",
	}, { // 3189
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\n：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz␊ｘ",
		out:  "\n：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz␊ｘ",
	}, { // 3190
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␊：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz␊ｘ",
		out:  "␊：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz␊ｘ",
	}, { // 3191
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\n：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11␊",
		out:  "\n：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11‛␊",
	}, { // 3192
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␊：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11␊",
		out:  "␊：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11‛␊",
	}, { // 3193
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "<\nπ␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11ｘ",
		out:  "<\nπ␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11ｘ",
	}, { // 3194
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "<␊π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11ｘ",
		out:  "<␊π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11ｘ",
	}, { // 3195
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "<\nπ␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz␊ｘ",
		out:  "<\nπ␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz␊ｘ",
	}, { // 3196
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "<␊π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz␊ｘ",
		out:  "<␊π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz␊ｘ",
	}, { // 3197
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "<\nπ␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11␊",
		out:  "<\nπ␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11‛␊",
	}, { // 3198
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "<␊π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11␊",
		out:  "<␊π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11‛␊",
	}, { // 3199
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "<：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\nｘ",
		out:  "<：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\nｘ",
	}, { // 3200
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "<：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz␊ｘ",
		out:  "<：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz␊ｘ",
	}, { // 3201
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "<：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\n␊",
		out:  "<：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\n‛␊",
	}, { // 3202
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "<：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz␊␊",
		out:  "<：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz␊‛␊",
	}, { // 3203
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "<：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11\n",
		out:  "<：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11␊",
	}, { // 3204
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "<：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11␊",
		out:  "<：π␒κ\ra\aι\x1a\n5B\x0eχ␒～ξ？T␜（；Z７ξｕz\x11‛␊",
	}, { // 3205
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ξ？ｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆␏",
		out:  "ξ？ｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆␏",
	}, { // 3206
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\v␋ｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆␏",
		out:  "\v␋ｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆␏",
	}, { // 3207
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␋␋ｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆␏",
		out:  "␋␋ｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆␏",
	}, { // 3208
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\v？ｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜␋␏",
		out:  "\v？ｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜␋␏",
	}, { // 3209
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␋？ｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜␋␏",
		out:  "␋？ｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜␋␏",
	}, { // 3210
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\v？ｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆␋",
		out:  "\v？ｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆‛␋",
	}, { // 3211
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␋？ｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆␋",
		out:  "␋？ｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆‛␋",
	}, { // 3212
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ξ\vｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆␏",
		out:  "ξ\vｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆␏",
	}, { // 3213
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ξ␋ｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆␏",
		out:  "ξ␋ｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆␏",
	}, { // 3214
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ξ\vｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜␋␏",
		out:  "ξ\vｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜␋␏",
	}, { // 3215
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ξ␋ｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜␋␏",
		out:  "ξ␋ｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜␋␏",
	}, { // 3216
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ξ\vｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆␋",
		out:  "ξ\vｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆‛␋",
	}, { // 3217
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ξ␋ｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆␋",
		out:  "ξ␋ｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆‛␋",
	}, { // 3218
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ξ？ｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜\v␏",
		out:  "ξ？ｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜\v␏",
	}, { // 3219
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ξ？ｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜␋␏",
		out:  "ξ？ｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜␋␏",
	}, { // 3220
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ξ？ｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜\v␋",
		out:  "ξ？ｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜\v‛␋",
	}, { // 3221
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ξ？ｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜␋␋",
		out:  "ξ？ｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜␋‛␋",
	}, { // 3222
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ξ？ｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆\v",
		out:  "ξ？ｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆␋",
	}, { // 3223
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ξ？ｙ\x03％｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆␋",
		out:  "ξ？ｙ\x03％‛｀Ｕ\x01\x1cｑ\v␆Kμlδψ\x016ω␔\v^Y|o＂＜＆‛␋",
	}, { // 3224
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "αYk\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(Ｙ",
		out:  "αYk\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(Ｙ",
	}, { // 3225
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\r␍k\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(Ｙ",
		out:  "\r␍k\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(Ｙ",
	}, { // 3226
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␍␍k\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(Ｙ",
		out:  "␍␍k\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(Ｙ",
	}, { // 3227
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\rYk\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*␍Ｙ",
		out:  "\rYk\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*␍Ｙ",
	}, { // 3228
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␍Yk\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*␍Ｙ",
		out:  "␍Yk\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*␍Ｙ",
	}, { // 3229
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\rYk\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(␍",
		out:  "\rYk\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(‛␍",
	}, { // 3230
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␍Yk\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(␍",
		out:  "␍Yk\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(‛␍",
	}, { // 3231
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "α\rk\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(Ｙ",
		out:  "α\rk\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(Ｙ",
	}, { // 3232
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "α␍k\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(Ｙ",
		out:  "α␍k\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(Ｙ",
	}, { // 3233
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "α\rk\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*␍Ｙ",
		out:  "α\rk\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*␍Ｙ",
	}, { // 3234
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "α␍k\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*␍Ｙ",
		out:  "α␍k\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*␍Ｙ",
	}, { // 3235
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "α\rk\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(␍",
		out:  "α\rk\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(‛␍",
	}, { // 3236
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "α␍k\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(␍",
		out:  "α␍k\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(‛␍",
	}, { // 3237
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "αYk\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*\rＹ",
		out:  "αYk\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*\rＹ",
	}, { // 3238
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "αYk\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*␍Ｙ",
		out:  "αYk\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*␍Ｙ",
	}, { // 3239
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "αYk\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*\r␍",
		out:  "αYk\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*\r‛␍",
	}, { // 3240
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "αYk\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*␍␍",
		out:  "αYk\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*␍‛␍",
	}, { // 3241
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "αYk\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(\r",
		out:  "αYk\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(␍",
	}, { // 3242
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "αYk\x1b?Ｒθ｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(␍",
		out:  "αYk\x1b?Ｒθ‛｀μ｜\rζ\nβ：EB｜\x0e［６Ｒρ␋\x04␌\x06*(‛␍",
	}, { // 3243
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "ｆο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␞I",
		out:  "ｆο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␞I",
	}, { // 3244
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\t␉\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␞I",
		out:  "\t␉\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␞I",
	}, { // 3245
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␉␉\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␞I",
		out:  "␉␉\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␞I",
	}, { // 3246
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\tο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␉I",
		out:  "\tο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␉I",
	}, { // 3247
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␉ο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␉I",
		out:  "␉ο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␉I",
	}, { // 3248
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\tο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␞␉",
		out:  "\tο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␞‛␉",
	}, { // 3249
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␉ο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␞␉",
		out:  "␉ο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␞‛␉",
	}, { // 3250
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "ｆ\t\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␞I",
		out:  "ｆ\t\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␞I",
	}, { // 3251
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "ｆ␉\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␞I",
		out:  "ｆ␉\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␞I",
	}, { // 3252
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "ｆ\t\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␉I",
		out:  "ｆ\t\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␉I",
	}, { // 3253
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "ｆ␉\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␉I",
		out:  "ｆ␉\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␉I",
	}, { // 3254
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "ｆ\t\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␞␉",
		out:  "ｆ\t\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␞‛␉",
	}, { // 3255
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "ｆ␉\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␞␉",
		out:  "ｆ␉\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␞‛␉",
	}, { // 3256
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "ｆο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ\tI",
		out:  "ｆο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ\tI",
	}, { // 3257
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "ｆο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␉I",
		out:  "ｆο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␉I",
	}, { // 3258
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "ｆο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ\t␉",
		out:  "ｆο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ\t‛␉",
	}, { // 3259
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "ｆο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␉␉",
		out:  "ｆο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␉‛␉",
	}, { // 3260
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "ｆο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␞\t",
		out:  "ｆο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␞␉",
	}, { // 3261
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "ｆο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐＜nυd0μ␡：\x0fχ\x10Ｐ␞␉",
		out:  "ｆο\x06\x18｀␆}｀Ｍ\\\tβO\nλ␐‛＜nυd0μ␡：\x0fχ\x10Ｐ␞‛␉",
	}, { // 3262
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "xR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\bκＧ",
		out:  "xR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\bκＧ",
	}, { // 3263
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\n␊\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\bκＧ",
		out:  "\n␊\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\bκＧ",
	}, { // 3264
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␊␊\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\bκＧ",
		out:  "␊␊\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\bκＧ",
	}, { // 3265
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\nR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\b␊Ｇ",
		out:  "\nR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\b␊Ｇ",
	}, { // 3266
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␊R\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\b␊Ｇ",
		out:  "␊R\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\b␊Ｇ",
	}, { // 3267
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\nR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\bκ␊",
		out:  "\nR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\bκ‛␊",
	}, { // 3268
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␊R\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\bκ␊",
		out:  "␊R\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\bκ‛␊",
	}, { // 3269
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "x\n\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\bκＧ",
		out:  "x\n\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\bκＧ",
	}, { // 3270
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "x␊\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\bκＧ",
		out:  "x␊\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\bκＧ",
	}, { // 3271
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "x\n\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\b␊Ｇ",
		out:  "x\n\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\b␊Ｇ",
	}, { // 3272
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "x␊\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\b␊Ｇ",
		out:  "x␊\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\b␊Ｇ",
	}, { // 3273
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "x\n\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\bκ␊",
		out:  "x\n\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\bκ‛␊",
	}, { // 3274
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "x␊\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\bκ␊",
		out:  "x␊\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\bκ‛␊",
	}, { // 3275
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "xR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\b\nＧ",
		out:  "xR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\b\nＧ",
	}, { // 3276
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "xR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\b␊Ｇ",
		out:  "xR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\b␊Ｇ",
	}, { // 3277
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "xR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\b\n␊",
		out:  "xR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\b\n‛␊",
	}, { // 3278
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "xR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\b␊␊",
		out:  "xR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\b␊‛␊",
	}, { // 3279
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "xR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\bκ\n",
		out:  "xR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\bκ␊",
	}, { // 3280
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "xR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[\x00?Ｑ\x10χ＜␒οＢ\bκ␊",
		out:  "xR\x11＄ζ␃]ρpｗ\nψ␒:␕z＄[␀?Ｑ\x10χ‛＜␒οＢ\bκ‛␊",
	}, { // 3281
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␐；y␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～ω␜",
		out:  "␐；y␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～ω␜",
	}, { // 3282
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\v␋y␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～ω␜",
		out:  "\v␋y␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～ω␜",
	}, { // 3283
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␋␋y␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～ω␜",
		out:  "␋␋y␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～ω␜",
	}, { // 3284
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\v；y␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～␋␜",
		out:  "\v；y␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～␋␜",
	}, { // 3285
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␋；y␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～␋␜",
		out:  "␋；y␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～␋␜",
	}, { // 3286
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\v；y␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～ω␋",
		out:  "\v；y␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～ω‛␋",
	}, { // 3287
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␋；y␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～ω␋",
		out:  "␋；y␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～ω‛␋",
	}, { // 3288
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␐\vy␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～ω␜",
		out:  "␐\vy␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～ω␜",
	}, { // 3289
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␐␋y␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～ω␜",
		out:  "␐␋y␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～ω␜",
	}, { // 3290
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␐\vy␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～␋␜",
		out:  "␐\vy␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～␋␜",
	}, { // 3291
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␐␋y␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～␋␜",
		out:  "␐␋y␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～␋␜",
	}, { // 3292
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␐\vy␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～ω␋",
		out:  "␐\vy␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～ω‛␋",
	}, { // 3293
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␐␋y␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～ω␋",
		out:  "␐␋y␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～ω‛␋",
	}, { // 3294
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␐；y␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～\v␜",
		out:  "␐；y␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～\v␜",
	}, { // 3295
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␐；y␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～␋␜",
		out:  "␐；y␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～␋␜",
	}, { // 3296
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␐；y␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～\v␋",
		out:  "␐；y␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～\v‛␋",
	}, { // 3297
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␐；y␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～␋␋",
		out:  "␐；y␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～␋‛␋",
	}, { // 3298
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␐；y␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～ω\v",
		out:  "␐；y␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～ω␋",
	}, { // 3299
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␐；y␙DWＭω+＾\v\x1aρ\vδρ␙o>zρ\x1a\\！␊ｊ␄～ω␋",
		out:  "␐；y␙DWＭω+＾\v\x1aρ\vδρ␙o＞zρ\x1a\\！␊ｊ␄～ω‛␋",
	}, { // 3300
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "γ$＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15χ",
		out:  "γ$‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15χ",
	}, { // 3301
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\r␍＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15χ",
		out:  "\r␍‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15χ",
	}, { // 3302
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␍␍＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15χ",
		out:  "␍␍‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15χ",
	}, { // 3303
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\r$＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ␍χ",
		out:  "\r$‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ␍χ",
	}, { // 3304
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␍$＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ␍χ",
		out:  "␍$‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ␍χ",
	}, { // 3305
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\r$＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15␍",
		out:  "\r$‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15‛␍",
	}, { // 3306
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␍$＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15␍",
		out:  "␍$‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15‛␍",
	}, { // 3307
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "γ\r＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15χ",
		out:  "γ\r‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15χ",
	}, { // 3308
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "γ␍＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15χ",
		out:  "γ␍‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15χ",
	}, { // 3309
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "γ\r＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ␍χ",
		out:  "γ\r‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ␍χ",
	}, { // 3310
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "γ␍＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ␍χ",
		out:  "γ␍‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ␍χ",
	}, { // 3311
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "γ\r＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15␍",
		out:  "γ\r‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15‛␍",
	}, { // 3312
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "γ␍＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15␍",
		out:  "γ␍‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15‛␍",
	}, { // 3313
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "γ$＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\rχ",
		out:  "γ$‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\rχ",
	}, { // 3314
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "γ$＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ␍χ",
		out:  "γ$‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ␍χ",
	}, { // 3315
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "γ$＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\r␍",
		out:  "γ$‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\r‛␍",
	}, { // 3316
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "γ$＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ␍␍",
		out:  "γ$‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ␍‛␍",
	}, { // 3317
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "γ$＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15\r",
		out:  "γ$‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15␍",
	}, { // 3318
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "γ$＞3nＦοθ＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15␍",
		out:  "γ$‛＞3nＦοθ‛＞\x01\r{δ␙␒'＊5ａｖ\x18／#␇\x1f＠\uff00ξ\x15‛␍",
	}, { // 3319
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "]\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］ｇ^",
		out:  "］\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］ｇ^",
	}, { // 3320
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\t␉\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］ｇ^",
		out:  "\t␉\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］ｇ^",
	}, { // 3321
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␉␉\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］ｇ^",
		out:  "␉␉\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］ｇ^",
	}, { // 3322
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\t\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］␉^",
		out:  "\t\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］␉^",
	}, { // 3323
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␉\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］␉^",
		out:  "␉\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］␉^",
	}, { // 3324
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\t\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］ｇ␉",
		out:  "\t\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］ｇ‛␉",
	}, { // 3325
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␉\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］ｇ␉",
		out:  "␉\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］ｇ‛␉",
	}, { // 3326
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "]\t\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］ｇ^",
		out:  "］\t\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］ｇ^",
	}, { // 3327
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "]␉\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］ｇ^",
		out:  "］␉\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］ｇ^",
	}, { // 3328
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "]\t\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］␉^",
		out:  "］\t\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］␉^",
	}, { // 3329
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "]␉\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］␉^",
		out:  "］␉\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］␉^",
	}, { // 3330
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "]\t\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］ｇ␉",
		out:  "］\t\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］ｇ‛␉",
	}, { // 3331
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "]␉\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］ｇ␉",
		out:  "］␉\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］ｇ‛␉",
	}, { // 3332
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "]\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］\t^",
		out:  "］\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］\t^",
	}, { // 3333
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "]\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］␉^",
		out:  "］\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］␉^",
	}, { // 3334
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "]\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］\t␉",
		out:  "］\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］\t‛␉",
	}, { // 3335
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "]\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］␉␉",
		out:  "］\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］␉‛␉",
	}, { // 3336
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "]\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］ｇ\t",
		out:  "］\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］ｇ␉",
	}, { // 3337
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "]\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι］ｇ␉",
		out:  "］\x0f\t＃\x05Ｉ-\x0faｂ\tＴωοＵψ％␞R␚␑%αqq␜ι‛］ｇ‛␉",
	}, { // 3338
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   ".ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓ζ",
		out:  ".ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓ζ",
	}, { // 3339
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n␊␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓ζ",
		out:  "\n␊␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓ζ",
	}, { // 3340
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␊␊␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓ζ",
		out:  "␊␊␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓ζ",
	}, { // 3341
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\nｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␊ζ",
		out:  "\nｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␊ζ",
	}, { // 3342
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␊ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␊ζ",
		out:  "␊ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␊ζ",
	}, { // 3343
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\nｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓␊",
		out:  "\nｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓‛␊",
	}, { // 3344
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␊ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓␊",
		out:  "␊ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓‛␊",
	}, { // 3345
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   ".\n␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓ζ",
		out:  ".\n␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓ζ",
	}, { // 3346
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   ".␊␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓ζ",
		out:  ".␊␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓ζ",
	}, { // 3347
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   ".\n␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␊ζ",
		out:  ".\n␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␊ζ",
	}, { // 3348
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   ".␊␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␊ζ",
		out:  ".␊␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␊ζ",
	}, { // 3349
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   ".\n␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓␊",
		out:  ".\n␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓‛␊",
	}, { // 3350
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   ".␊␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓␊",
		out:  ".␊␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓‛␊",
	}, { // 3351
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   ".ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９\nζ",
		out:  ".ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９\nζ",
	}, { // 3352
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   ".ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␊ζ",
		out:  ".ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␊ζ",
	}, { // 3353
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   ".ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９\n␊",
		out:  ".ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９\n‛␊",
	}, { // 3354
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   ".ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␊␊",
		out:  ".ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␊‛␊",
	}, { // 3355
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   ".ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓\n",
		out:  ".ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓␊",
	}, { // 3356
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   ".ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓␊",
		out:  ".ｎ␓？%\x0e\x1e>τQ\n ␅χχｈ␃␍／~{σｆｕw/\x04９␓‛␊",
	}, { // 3357
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␇\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␍λ",
		out:  "␇\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␍λ",
	}, { // 3358
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\v␋M\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␍λ",
		out:  "\v␋M\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␍λ",
	}, { // 3359
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␋␋M\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␍λ",
		out:  "␋␋M\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␍λ",
	}, { // 3360
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\v\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␋λ",
		out:  "\v\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␋λ",
	}, { // 3361
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␋\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␋λ",
		out:  "␋\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␋λ",
	}, { // 3362
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\v\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␍␋",
		out:  "\v\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␍‛␋",
	}, { // 3363
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␋\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␍␋",
		out:  "␋\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␍‛␋",
	}, { // 3364
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␇\vM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␍λ",
		out:  "␇\vM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␍λ",
	}, { // 3365
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␇␋M\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␍λ",
		out:  "␇␋M\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␍λ",
	}, { // 3366
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␇\vM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␋λ",
		out:  "␇\vM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␋λ",
	}, { // 3367
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␇␋M\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␋λ",
		out:  "␇␋M\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␋λ",
	}, { // 3368
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␇\vM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␍␋",
		out:  "␇\vM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␍‛␋",
	}, { // 3369
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␇␋M\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␍␋",
		out:  "␇␋M\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␍‛␋",
	}, { // 3370
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␇\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]\vλ",
		out:  "␇\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］\vλ",
	}, { // 3371
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␇\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␋λ",
		out:  "␇\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␋λ",
	}, { // 3372
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␇\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]\v␋",
		out:  "␇\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］\v‛␋",
	}, { // 3373
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␇\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␋␋",
		out:  "␇\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␋‛␋",
	}, { // 3374
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␇\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␍\v",
		out:  "␇\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␍␋",
	}, { // 3375
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␇\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊］ｗ\v\n\\]␍␋",
		out:  "␇\rM\x11␡τ３9６δ\v５ωeUJτ␁ν｜ｒ＊‛］ｗ\v\n\\］␍‛␋",
	}, { // 3376
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＃：υＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν５［",
		out:  "＃：υＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν５‛［",
	}, { // 3377
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\r␍υＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν５［",
		out:  "\r␍υＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν５‛［",
	}, { // 3378
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍␍υＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν５［",
		out:  "␍␍υＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν５‛［",
	}, { // 3379
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\r：υＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν␍［",
		out:  "\r：υＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν␍‛［",
	}, { // 3380
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍：υＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν␍［",
		out:  "␍：υＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν␍‛［",
	}, { // 3381
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\r：υＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν５␍",
		out:  "\r：υＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν５‛␍",
	}, { // 3382
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍：υＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν５␍",
		out:  "␍：υＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν５‛␍",
	}, { // 3383
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＃\rυＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν５［",
		out:  "＃\rυＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν５‛［",
	}, { // 3384
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＃␍υＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν５［",
		out:  "＃␍υＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν５‛［",
	}, { // 3385
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＃\rυＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν␍［",
		out:  "＃\rυＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν␍‛［",
	}, { // 3386
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＃␍υＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν␍［",
		out:  "＃␍υＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν␍‛［",
	}, { // 3387
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＃\rυＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν５␍",
		out:  "＃\rυＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν５‛␍",
	}, { // 3388
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＃␍υＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν５␍",
		out:  "＃␍υＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν５‛␍",
	}, { // 3389
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＃：υＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν\r［",
		out:  "＃：υＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν\r‛［",
	}, { // 3390
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＃：υＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν␍［",
		out:  "＃：υＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν␍‛［",
	}, { // 3391
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＃：υＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν\r␍",
		out:  "＃：υＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν\r‛␍",
	}, { // 3392
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＃：υＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν␍␍",
		out:  "＃：υＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν␍‛␍",
	}, { // 3393
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＃：υＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν５\r",
		out:  "＃：υＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν５␍",
	}, { // 3394
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＃：υＦf］\x16sＹν\r\x0e[9λo０＞Kλ_␍'\x1b３\x06␡ν５␍",
		out:  "＃：υＦf‛］\x16sＹν\r\x0e［9λo０＞Kλ_␍'\x1b３\x06␡ν５‛␍",
	}, { // 3395
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␈\x1am/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔＊",
		out:  "␈\x1am/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔＊",
	}, { // 3396
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\t␉m/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔＊",
		out:  "\t␉m/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔＊",
	}, { // 3397
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␉␉m/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔＊",
		out:  "␉␉m/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔＊",
	}, { // 3398
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\t\x1am/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␉＊",
		out:  "\t\x1am/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␉＊",
	}, { // 3399
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␉\x1am/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␉＊",
		out:  "␉\x1am/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␉＊",
	}, { // 3400
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\t\x1am/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔␉",
		out:  "\t\x1am/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔‛␉",
	}, { // 3401
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␉\x1am/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔␉",
		out:  "␉\x1am/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔‛␉",
	}, { // 3402
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␈\tm/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔＊",
		out:  "␈\tm/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔＊",
	}, { // 3403
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␈␉m/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔＊",
		out:  "␈␉m/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔＊",
	}, { // 3404
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␈\tm/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␉＊",
		out:  "␈\tm/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␉＊",
	}, { // 3405
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␈␉m/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␉＊",
		out:  "␈␉m/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␉＊",
	}, { // 3406
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␈\tm/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔␉",
		out:  "␈\tm/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔‛␉",
	}, { // 3407
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␈␉m/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔␉",
		out:  "␈␉m/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔‛␉",
	}, { // 3408
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␈\x1am/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ\t＊",
		out:  "␈\x1am/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ\t＊",
	}, { // 3409
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␈\x1am/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␉＊",
		out:  "␈\x1am/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␉＊",
	}, { // 3410
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␈\x1am/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ\t␉",
		out:  "␈\x1am/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ\t‛␉",
	}, { // 3411
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␈\x1am/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␉␉",
		out:  "␈\x1am/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␉‛␉",
	}, { // 3412
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␈\x1am/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔\t",
		out:  "␈\x1am/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔␉",
	}, { // 3413
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␈\x1am/\x17Ｈν␅｜$\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔␉",
		out:  "␈\x1am/\x17Ｈν␅｜＄\tπＱ6␇ｇη␚σ\"\x16π[4＊~\bθ␔‛␉",
	}, { // 3414
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ωξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞７ξ",
		out:  "ωξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞７ξ",
	}, { // 3415
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n␊␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞７ξ",
		out:  "\n␊␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞７ξ",
	}, { // 3416
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␊␊␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞７ξ",
		out:  "␊␊␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞７ξ",
	}, { // 3417
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\nξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞␊ξ",
		out:  "\nξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞␊ξ",
	}, { // 3418
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␊ξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞␊ξ",
		out:  "␊ξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞␊ξ",
	}, { // 3419
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\nξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞７␊",
		out:  "\nξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞７‛␊",
	}, { // 3420
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␊ξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞７␊",
		out:  "␊ξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞７‛␊",
	}, { // 3421
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ω\n␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞７ξ",
		out:  "ω\n␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞７ξ",
	}, { // 3422
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ω␊␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞７ξ",
		out:  "ω␊␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞７ξ",
	}, { // 3423
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ω\n␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞␊ξ",
		out:  "ω\n␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞␊ξ",
	}, { // 3424
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ω␊␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞␊ξ",
		out:  "ω␊␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞␊ξ",
	}, { // 3425
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ω\n␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞７␊",
		out:  "ω\n␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞７‛␊",
	}, { // 3426
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ω␊␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞７␊",
		out:  "ω␊␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞７‛␊",
	}, { // 3427
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ωξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞\nξ",
		out:  "ωξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞\nξ",
	}, { // 3428
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ωξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞␊ξ",
		out:  "ωξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞␊ξ",
	}, { // 3429
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ωξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞\n␊",
		out:  "ωξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞\n‛␊",
	}, { // 3430
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ωξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞␊␊",
		out:  "ωξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞␊‛␊",
	}, { // 3431
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ωξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞７\n",
		out:  "ωξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞７␊",
	}, { // 3432
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ωξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ$H\b>Ａ＞７␊",
		out:  "ωξ␟-％␍Wu␡ｄ\n\x04\x1d␄+υσ`σＲ␉ｆ＄H\b>Ａ＞７‛␊",
	}, { // 3433
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β８",
		out:  "\n\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β８",
	}, { // 3434
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\v␋ςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β８",
		out:  "\v␋ςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β８",
	}, { // 3435
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␋␋ςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β８",
		out:  "␋␋ςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β８",
	}, { // 3436
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\v\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅␋８",
		out:  "\v\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅␋８",
	}, { // 3437
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␋\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅␋８",
		out:  "␋\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅␋８",
	}, { // 3438
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\v\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β␋",
		out:  "\v\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β‛␋",
	}, { // 3439
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␋\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β␋",
		out:  "␋\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β‛␋",
	}, { // 3440
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n\vςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β８",
		out:  "\n\vςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β８",
	}, { // 3441
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n␋ςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β８",
		out:  "\n␋ςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β８",
	}, { // 3442
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n\vςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅␋８",
		out:  "\n\vςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅␋８",
	}, { // 3443
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n␋ςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅␋８",
		out:  "\n␋ςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅␋８",
	}, { // 3444
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n\vςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β␋",
		out:  "\n\vςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β‛␋",
	}, { // 3445
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n␋ςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β␋",
		out:  "\n␋ςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β‛␋",
	}, { // 3446
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅\v８",
		out:  "\n\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅\v８",
	}, { // 3447
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅␋８",
		out:  "\n\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅␋８",
	}, { // 3448
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅\v␋",
		out:  "\n\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅\v‛␋",
	}, { // 3449
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅␋␋",
		out:  "\n\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅␋‛␋",
	}, { // 3450
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β\v",
		out:  "\n\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β␋",
	}, { // 3451
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β␋",
		out:  "\n\bςＧ＿2Bmｏδ\vα\x17:［／\"␈νｍf␆％\x11␘uπ␅β‛␋",
	}, { // 3452
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "*εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aXς",
		out:  "*εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aXς",
	}, { // 3453
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\r␍Ｑλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aXς",
		out:  "\r␍Ｑλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aXς",
	}, { // 3454
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␍␍Ｑλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aXς",
		out:  "␍␍Ｑλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aXς",
	}, { // 3455
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\rεＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]a␍ς",
		out:  "\rεＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]a␍ς",
	}, { // 3456
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␍εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]a␍ς",
		out:  "␍εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]a␍ς",
	}, { // 3457
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\rεＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aX␍",
		out:  "\rεＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aX‛␍",
	}, { // 3458
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␍εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aX␍",
		out:  "␍εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aX‛␍",
	}, { // 3459
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "*\rＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aXς",
		out:  "*\rＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aXς",
	}, { // 3460
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "*␍Ｑλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aXς",
		out:  "*␍Ｑλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aXς",
	}, { // 3461
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "*\rＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]a␍ς",
		out:  "*\rＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]a␍ς",
	}, { // 3462
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "*␍Ｑλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]a␍ς",
		out:  "*␍Ｑλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]a␍ς",
	}, { // 3463
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "*\rＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aX␍",
		out:  "*\rＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aX‛␍",
	}, { // 3464
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "*␍Ｑλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aX␍",
		out:  "*␍Ｑλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aX‛␍",
	}, { // 3465
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "*εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]a\rς",
		out:  "*εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]a\rς",
	}, { // 3466
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "*εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]a␍ς",
		out:  "*εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]a␍ς",
	}, { // 3467
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "*εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]a\r␍",
		out:  "*εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]a\r‛␍",
	}, { // 3468
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "*εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]a␍␍",
		out:  "*εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]a␍‛␍",
	}, { // 3469
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "*εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aX\r",
		out:  "*εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aX␍",
	}, { // 3470
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "*εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aX␍",
		out:  "*εＱλ␚ω\x1f\x14>θ\r\x13Ｎ９␟␚0？ν８}␛ｄ\x05［7]aX‛␍",
	}, { // 3471
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "β｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆy",
		out:  "β｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆy",
	}, { // 3472
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\t␉␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆy",
		out:  "\t␉␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆy",
	}, { // 3473
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉␉␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆy",
		out:  "␉␉␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆy",
	}, { // 3474
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\t｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\b␉y",
		out:  "\t｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\b␉y",
	}, { // 3475
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\b␉y",
		out:  "␉｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\b␉y",
	}, { // 3476
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\t｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆ␉",
		out:  "\t｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆ‛␉",
	}, { // 3477
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆ␉",
		out:  "␉｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆ‛␉",
	}, { // 3478
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "β\t␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆy",
		out:  "β\t␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆy",
	}, { // 3479
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "β␉␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆy",
		out:  "β␉␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆy",
	}, { // 3480
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "β\t␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\b␉y",
		out:  "β\t␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\b␉y",
	}, { // 3481
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "β␉␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\b␉y",
		out:  "β␉␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\b␉y",
	}, { // 3482
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "β\t␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆ␉",
		out:  "β\t␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆ‛␉",
	}, { // 3483
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "β␉␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆ␉",
		out:  "β␉␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆ‛␉",
	}, { // 3484
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "β｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\b\ty",
		out:  "β｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\b\ty",
	}, { // 3485
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "β｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\b␉y",
		out:  "β｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\b␉y",
	}, { // 3486
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "β｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\b\t␉",
		out:  "β｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\b\t‛␉",
	}, { // 3487
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "β｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\b␉␉",
		out:  "β｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\b␉‛␉",
	}, { // 3488
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "β｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆ\t",
		out:  "β｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆ␉",
	}, { // 3489
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "β｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆ␉",
		out:  "β｜␚Ａr＞ξ␂u［\t␆ν6γη\x1bｎ<ｃο*$u␖*\x16\bｆ‛␉",
	}, { // 3490
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "６γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007fγ",
		out:  "６γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007fγ",
	}, { // 3491
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\n␊dＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007fγ",
		out:  "\n␊dＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007fγ",
	}, { // 3492
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␊␊dＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007fγ",
		out:  "␊␊dＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007fγ",
	}, { // 3493
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\nγdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ␊γ",
		out:  "\nγdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ␊γ",
	}, { // 3494
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␊γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ␊γ",
		out:  "␊γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ␊γ",
	}, { // 3495
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\nγdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007f␊",
		out:  "\nγdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007f‛␊",
	}, { // 3496
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␊γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007f␊",
		out:  "␊γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007f‛␊",
	}, { // 3497
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "６\ndＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007fγ",
		out:  "６\ndＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007fγ",
	}, { // 3498
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "６␊dＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007fγ",
		out:  "６␊dＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007fγ",
	}, { // 3499
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "６\ndＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ␊γ",
		out:  "６\ndＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ␊γ",
	}, { // 3500
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "６␊dＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ␊γ",
		out:  "６␊dＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ␊γ",
	}, { // 3501
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "６\ndＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007f␊",
		out:  "６\ndＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007f‛␊",
	}, { // 3502
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "６␊dＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007f␊",
		out:  "６␊dＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007f‛␊",
	}, { // 3503
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "６γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\nγ",
		out:  "６γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\nγ",
	}, { // 3504
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "６γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ␊γ",
		out:  "６γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ␊γ",
	}, { // 3505
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "６γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\n␊",
		out:  "６γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\n‛␊",
	}, { // 3506
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "６γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ␊␊",
		out:  "６γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ␊‛␊",
	}, { // 3507
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "６γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007f\n",
		out:  "６γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007f␊",
	}, { // 3508
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "６γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007f␊",
		out:  "６γdＢ=ν␁\x10θ\u007f\nＶ␗@␞2\x11ｈ␄δ\x0ew1\b␛？（σ\u007f‛␊",
	}, { // 3509
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉α）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␐０",
		out:  "␉α）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␐０",
	}, { // 3510
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\v␋）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␐０",
		out:  "\v␋）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␐０",
	}, { // 3511
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␋␋）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␐０",
		out:  "␋␋）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␐０",
	}, { // 3512
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\vα）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␋０",
		out:  "\vα）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␋０",
	}, { // 3513
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␋α）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␋０",
		out:  "␋α）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␋０",
	}, { // 3514
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\vα）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␐␋",
		out:  "\vα）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␐‛␋",
	}, { // 3515
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␋α）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␐␋",
		out:  "␋α）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␐‛␋",
	}, { // 3516
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉\v）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␐０",
		out:  "␉\v）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␐０",
	}, { // 3517
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉␋）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␐０",
		out:  "␉␋）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␐０",
	}, { // 3518
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉\v）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␋０",
		out:  "␉\v）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␋０",
	}, { // 3519
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉␋）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␋０",
		out:  "␉␋）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␋０",
	}, { // 3520
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉\v）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␐␋",
		out:  "␉\v）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␐‛␋",
	}, { // 3521
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉␋）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␐␋",
		out:  "␉␋）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␐‛␋",
	}, { // 3522
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉α）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ\v０",
		out:  "␉α）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ\v０",
	}, { // 3523
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉α）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␋０",
		out:  "␉α）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␋０",
	}, { // 3524
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉α）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ\v␋",
		out:  "␉α）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ\v‛␋",
	}, { // 3525
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉α）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␋␋",
		out:  "␉α）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␋‛␋",
	}, { // 3526
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉α）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␐\v",
		out:  "␉α）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␐␋",
	}, { // 3527
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉α）\x11αＡ␇ＮG{\vＲ＼\x00ν#n＜\x01␅␎@\x1eι\x18νtχ␐␋",
		out:  "␉α）\x11αＡ␇ＮG{\vＲ＼␀ν#n＜\x01␅␎@\x1eι\x18νtχ␐‛␋",
	}, { // 3528
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␃＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［πσｆ",
		out:  "␃＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［πσｆ",
	}, { // 3529
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\r␍ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［πσｆ",
		out:  "\r␍ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［πσｆ",
	}, { // 3530
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␍␍ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［πσｆ",
		out:  "␍␍ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［πσｆ",
	}, { // 3531
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\r＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［π␍ｆ",
		out:  "\r＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［π␍ｆ",
	}, { // 3532
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␍＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［π␍ｆ",
		out:  "␍＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［π␍ｆ",
	}, { // 3533
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\r＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［πσ␍",
		out:  "\r＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［πσ‛␍",
	}, { // 3534
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␍＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［πσ␍",
		out:  "␍＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［πσ‛␍",
	}, { // 3535
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␃\rｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［πσｆ",
		out:  "␃\rｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［πσｆ",
	}, { // 3536
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␃␍ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［πσｆ",
		out:  "␃␍ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［πσｆ",
	}, { // 3537
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␃\rｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［π␍ｆ",
		out:  "␃\rｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［π␍ｆ",
	}, { // 3538
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␃␍ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［π␍ｆ",
		out:  "␃␍ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［π␍ｆ",
	}, { // 3539
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␃\rｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［πσ␍",
		out:  "␃\rｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［πσ‛␍",
	}, { // 3540
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␃␍ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［πσ␍",
		out:  "␃␍ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［πσ‛␍",
	}, { // 3541
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␃＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［π\rｆ",
		out:  "␃＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［π\rｆ",
	}, { // 3542
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␃＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［π␍ｆ",
		out:  "␃＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［π␍ｆ",
	}, { // 3543
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␃＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［π\r␍",
		out:  "␃＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［π\r‛␍",
	}, { // 3544
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␃＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［π␍␍",
		out:  "␃＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［π␍‛␍",
	}, { // 3545
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␃＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［πσ\r",
		out:  "␃＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［πσ␍",
	}, { // 3546
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␃＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n\x00［πσ␍",
		out:  "␃＞ｗτ：␜δ\\␗\x19\rkＬβοｍ␍suO_\x19Ｐ]n␀［πσ‛␍",
	}, { // 3547
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␘φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐σ",
		out:  "␘φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐σ",
	}, { // 3548
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\t␉Ｏ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐σ",
		out:  "\t␉Ｏ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐σ",
	}, { // 3549
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉␉Ｏ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐σ",
		out:  "␉␉Ｏ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐σ",
	}, { // 3550
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\tφＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␉σ",
		out:  "\tφＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␉σ",
	}, { // 3551
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␉σ",
		out:  "␉φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␉σ",
	}, { // 3552
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\tφＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐␉",
		out:  "\tφＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐‛␉",
	}, { // 3553
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐␉",
		out:  "␉φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐‛␉",
	}, { // 3554
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␘\tＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐σ",
		out:  "␘\tＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐σ",
	}, { // 3555
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␘␉Ｏ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐σ",
		out:  "␘␉Ｏ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐σ",
	}, { // 3556
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␘\tＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␉σ",
		out:  "␘\tＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␉σ",
	}, { // 3557
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␘␉Ｏ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␉σ",
		out:  "␘␉Ｏ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␉σ",
	}, { // 3558
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␘\tＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐␉",
		out:  "␘\tＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐‛␉",
	}, { // 3559
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␘␉Ｏ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐␉",
		out:  "␘␉Ｏ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐‛␉",
	}, { // 3560
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␘φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ\tσ",
		out:  "␘φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ\tσ",
	}, { // 3561
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␘φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␉σ",
		out:  "␘φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␉σ",
	}, { // 3562
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␘φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ\t␉",
		out:  "␘φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ\t‛␉",
	}, { // 3563
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␘φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␉␉",
		out:  "␘φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␉‛␉",
	}, { // 3564
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␘φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐\t",
		out:  "␘φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐␉",
	}, { // 3565
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␘φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐␉",
		out:  "␘φＯ\a␗ｗ\x17DθJ\t｜␞V＄\x06ε\x01＆＼B␟ωS#;ζＧ␐‛␉",
	}, { // 3566
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "：ｈy\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞jｏ＊",
		out:  "‛：ｈy\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞jｏ＊",
	}, { // 3567
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\n␊y\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞jｏ＊",
		out:  "\n␊y\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞jｏ＊",
	}, { // 3568
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␊␊y\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞jｏ＊",
		out:  "␊␊y\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞jｏ＊",
	}, { // 3569
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\nｈy\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞j␊＊",
		out:  "\nｈy\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞j␊＊",
	}, { // 3570
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␊ｈy\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞j␊＊",
		out:  "␊ｈy\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞j␊＊",
	}, { // 3571
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\nｈy\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞jｏ␊",
		out:  "\nｈy\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞jｏ‛␊",
	}, { // 3572
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␊ｈy\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞jｏ␊",
		out:  "␊ｈy\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞jｏ‛␊",
	}, { // 3573
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "：\ny\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞jｏ＊",
		out:  "‛：\ny\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞jｏ＊",
	}, { // 3574
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "：␊y\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞jｏ＊",
		out:  "‛：␊y\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞jｏ＊",
	}, { // 3575
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "：\ny\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞j␊＊",
		out:  "‛：\ny\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞j␊＊",
	}, { // 3576
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "：␊y\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞j␊＊",
		out:  "‛：␊y\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞j␊＊",
	}, { // 3577
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "：\ny\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞jｏ␊",
		out:  "‛：\ny\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞jｏ‛␊",
	}, { // 3578
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "：␊y\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞jｏ␊",
		out:  "‛：␊y\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞jｏ‛␊",
	}, { // 3579
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "：ｈy\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞j\n＊",
		out:  "‛：ｈy\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞j\n＊",
	}, { // 3580
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "：ｈy\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞j␊＊",
		out:  "‛：ｈy\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞j␊＊",
	}, { // 3581
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "：ｈy\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞j\n␊",
		out:  "‛：ｈy\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞j\n‛␊",
	}, { // 3582
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "：ｈy\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞j␊␊",
		out:  "‛：ｈy\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞j␊‛␊",
	}, { // 3583
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "：ｈy\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞jｏ\n",
		out:  "‛：ｈy\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞jｏ␊",
	}, { // 3584
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "：ｈy\x0eL9<β\rψ\n］[\x1d:γ␍ζ␌Ｚ］δ\x1e：ｚe＞jｏ␊",
		out:  "‛：ｈy\x0eL9<β\rψ\n］[\x1d：γ␍ζ␌Ｚ］δ\x1e‛：ｚe＞jｏ‛␊",
	}, { // 3585
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␟BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆＮ",
		out:  "␟BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆＮ",
	}, { // 3586
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\v␋E＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆＮ",
		out:  "\v␋E＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆＮ",
	}, { // 3587
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␋␋E＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆＮ",
		out:  "␋␋E＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆＮ",
	}, { // 3588
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\vBE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！␋Ｎ",
		out:  "\vBE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！␋Ｎ",
	}, { // 3589
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␋BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！␋Ｎ",
		out:  "␋BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！␋Ｎ",
	}, { // 3590
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\vBE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆ␋",
		out:  "\vBE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆ‛␋",
	}, { // 3591
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␋BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆ␋",
		out:  "␋BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆ‛␋",
	}, { // 3592
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␟\vE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆＮ",
		out:  "␟\vE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆＮ",
	}, { // 3593
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␟␋E＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆＮ",
		out:  "␟␋E＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆＮ",
	}, { // 3594
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␟\vE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！␋Ｎ",
		out:  "␟\vE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！␋Ｎ",
	}, { // 3595
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␟␋E＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！␋Ｎ",
		out:  "␟␋E＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！␋Ｎ",
	}, { // 3596
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␟\vE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆ␋",
		out:  "␟\vE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆ‛␋",
	}, { // 3597
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␟␋E＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆ␋",
		out:  "␟␋E＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆ‛␋",
	}, { // 3598
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␟BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！\vＮ",
		out:  "␟BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！\vＮ",
	}, { // 3599
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␟BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！␋Ｎ",
		out:  "␟BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！␋Ｎ",
	}, { // 3600
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␟BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！\v␋",
		out:  "␟BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！\v‛␋",
	}, { // 3601
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␟BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！␋␋",
		out:  "␟BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！␋‛␋",
	}, { // 3602
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␟BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆ\v",
		out:  "␟BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆ␋",
	}, { // 3603
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␟BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆ␋",
		out:  "␟BE＇０\nＣＸH\x0e\vς␆ε-=λε＂\"\x02\x0fδK␡␆\v！ｆ‛␋",
	}, { // 3604
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｚｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05［",
		out:  "Ｚｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05［",
	}, { // 3605
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\r␍␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05［",
		out:  "\r␍␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05［",
	}, { // 3606
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␍␍␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05［",
		out:  "␍␍␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05［",
	}, { // 3607
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\rｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς␍［",
		out:  "\rｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς␍［",
	}, { // 3608
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␍ｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς␍［",
		out:  "␍ｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς␍［",
	}, { // 3609
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\rｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05␍",
		out:  "\rｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05‛␍",
	}, { // 3610
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␍ｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05␍",
		out:  "␍ｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05‛␍",
	}, { // 3611
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｚ\r␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05［",
		out:  "Ｚ\r␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05［",
	}, { // 3612
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｚ␍␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05［",
		out:  "Ｚ␍␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05［",
	}, { // 3613
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｚ\r␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς␍［",
		out:  "Ｚ\r␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς␍［",
	}, { // 3614
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｚ␍␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς␍［",
		out:  "Ｚ␍␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς␍［",
	}, { // 3615
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｚ\r␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05␍",
		out:  "Ｚ\r␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05‛␍",
	}, { // 3616
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｚ␍␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05␍",
		out:  "Ｚ␍␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05‛␍",
	}, { // 3617
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｚｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\r［",
		out:  "Ｚｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\r［",
	}, { // 3618
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｚｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς␍［",
		out:  "Ｚｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς␍［",
	}, { // 3619
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｚｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\r␍",
		out:  "Ｚｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\r‛␍",
	}, { // 3620
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｚｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς␍␍",
		out:  "Ｚｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς␍‛␍",
	}, { // 3621
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｚｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05\r",
		out:  "Ｚｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05␍",
	}, { // 3622
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｚｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05␍",
		out:  "Ｚｋ␗\x1b)-␓\aLε\r@｀␡\x04ηκＧ－B*?␓εｊ␝ρς\x05‛␍",
	}, { // 3623
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "z８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"＂",
		out:  "z８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"＂",
	}, { // 3624
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\t␉／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"＂",
		out:  "\t␉／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"＂",
	}, { // 3625
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␉␉／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"＂",
		out:  "␉␉／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"＂",
	}, { // 3626
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\t８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1␉＂",
		out:  "\t８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1␉＂",
	}, { // 3627
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␉８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1␉＂",
		out:  "␉８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1␉＂",
	}, { // 3628
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\t８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"␉",
		out:  "\t８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"‛␉",
	}, { // 3629
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␉８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"␉",
		out:  "␉８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"‛␉",
	}, { // 3630
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "z\t／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"＂",
		out:  "z\t／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"＂",
	}, { // 3631
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "z␉／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"＂",
		out:  "z␉／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"＂",
	}, { // 3632
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "z\t／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1␉＂",
		out:  "z\t／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1␉＂",
	}, { // 3633
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "z␉／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1␉＂",
		out:  "z␉／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1␉＂",
	}, { // 3634
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "z\t／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"␉",
		out:  "z\t／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"‛␉",
	}, { // 3635
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "z␉／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"␉",
		out:  "z␉／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"‛␉",
	}, { // 3636
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "z８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\t＂",
		out:  "z８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\t＂",
	}, { // 3637
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "z８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1␉＂",
		out:  "z８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1␉＂",
	}, { // 3638
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "z８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\t␉",
		out:  "z８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\t‛␉",
	}, { // 3639
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "z８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1␉␉",
		out:  "z８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1␉‛␉",
	}, { // 3640
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "z８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"\t",
		out:  "z８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"␉",
	}, { // 3641
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "z８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"␉",
		out:  "z８／\x02％`\nπＱ/\t␆ψ：␂I\ryδ０␉\x06πε｀τ␝1\"‛␉",
	}, { // 3642
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/ｚ",
		out:  "\r␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/ｚ",
	}, { // 3643
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\n␊χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/ｚ",
		out:  "\n␊χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/ｚ",
	}, { // 3644
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␊␊χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/ｚ",
		out:  "␊␊χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/ｚ",
	}, { // 3645
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\n␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3␊ｚ",
		out:  "\n␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3␊ｚ",
	}, { // 3646
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␊␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3␊ｚ",
		out:  "␊␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3␊ｚ",
	}, { // 3647
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\n␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/␊",
		out:  "\n␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/‛␊",
	}, { // 3648
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␊␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/␊",
		out:  "␊␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/‛␊",
	}, { // 3649
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r\nχαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/ｚ",
		out:  "\r\nχαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/ｚ",
	}, { // 3650
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␊χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/ｚ",
		out:  "\r␊χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/ｚ",
	}, { // 3651
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r\nχαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3␊ｚ",
		out:  "\r\nχαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3␊ｚ",
	}, { // 3652
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␊χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3␊ｚ",
		out:  "\r␊χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3␊ｚ",
	}, { // 3653
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r\nχαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/␊",
		out:  "\r\nχαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/‛␊",
	}, { // 3654
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␊χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/␊",
		out:  "\r␊χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/‛␊",
	}, { // 3655
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3\nｚ",
		out:  "\r␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3\nｚ",
	}, { // 3656
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3␊ｚ",
		out:  "\r␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3␊ｚ",
	}, { // 3657
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3\n␊",
		out:  "\r␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3\n‛␊",
	}, { // 3658
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3␊␊",
		out:  "\r␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3␊‛␊",
	}, { // 3659
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/\n",
		out:  "\r␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/␊",
	}, { // 3660
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/␊",
		out:  "\r␗χαξ％/κ␅=\n\x12９␈\x13ｊ:dＨ\x1f：Ｅl）␊Vχ3/‛␊",
	}, { // 3661
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "／\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%ｗ\b",
		out:  "／\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%ｗ\b",
	}, { // 3662
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\v␋Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%ｗ\b",
		out:  "\v␋Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%ｗ\b",
	}, { // 3663
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␋␋Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%ｗ\b",
		out:  "␋␋Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%ｗ\b",
	}, { // 3664
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\v\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%␋\b",
		out:  "\v\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%␋\b",
	}, { // 3665
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␋\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%␋\b",
		out:  "␋\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%␋\b",
	}, { // 3666
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\v\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%ｗ␋",
		out:  "\v\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%ｗ‛␋",
	}, { // 3667
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␋\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%ｗ␋",
		out:  "␋\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%ｗ‛␋",
	}, { // 3668
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "／\vＫ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%ｗ\b",
		out:  "／\vＫ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%ｗ\b",
	}, { // 3669
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "／␋Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%ｗ\b",
		out:  "／␋Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%ｗ\b",
	}, { // 3670
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "／\vＫ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%␋\b",
		out:  "／\vＫ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%␋\b",
	}, { // 3671
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "／␋Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%␋\b",
		out:  "／␋Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%␋\b",
	}, { // 3672
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "／\vＫ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%ｗ␋",
		out:  "／\vＫ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%ｗ‛␋",
	}, { // 3673
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "／␋Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%ｗ␋",
		out:  "／␋Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%ｗ‛␋",
	}, { // 3674
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "／\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%\v\b",
		out:  "／\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%\v\b",
	}, { // 3675
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "／\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%␋\b",
		out:  "／\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%␋\b",
	}, { // 3676
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "／\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%\v␋",
		out:  "／\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%\v‛␋",
	}, { // 3677
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "／\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%␋␋",
		out:  "／\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%␋‛␋",
	}, { // 3678
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "／\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%ｗ\v",
		out:  "／\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%ｗ␋",
	}, { // 3679
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "／\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ\x00x\x19ｅ␞␙%ｗ␋",
		out:  "／\\Ｋ`G␎␟@\vρ\vιφ\x02\x12μ＆Ｅλ＇δ␀x\x19ｅ␞␙%ｗ‛␋",
	}, { // 3680
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "＾␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%+",
		out:  "＾␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%+",
	}, { // 3681
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␍@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%+",
		out:  "\r␍@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%+",
	}, { // 3682
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␍␍@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%+",
		out:  "␍␍@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%+",
	}, { // 3683
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ␍+",
		out:  "\r␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ␍+",
	}, { // 3684
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␍␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ␍+",
		out:  "␍␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ␍+",
	}, { // 3685
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%␍",
		out:  "\r␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%‛␍",
	}, { // 3686
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␍␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%␍",
		out:  "␍␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%‛␍",
	}, { // 3687
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "＾\r@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%+",
		out:  "＾\r@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%+",
	}, { // 3688
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "＾␍@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%+",
		out:  "＾␍@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%+",
	}, { // 3689
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "＾\r@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ␍+",
		out:  "＾\r@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ␍+",
	}, { // 3690
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "＾␍@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ␍+",
		out:  "＾␍@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ␍+",
	}, { // 3691
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "＾\r@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%␍",
		out:  "＾\r@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%‛␍",
	}, { // 3692
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "＾␍@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%␍",
		out:  "＾␍@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%‛␍",
	}, { // 3693
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "＾␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ\r+",
		out:  "＾␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ\r+",
	}, { // 3694
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "＾␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ␍+",
		out:  "＾␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ␍+",
	}, { // 3695
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "＾␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ\r␍",
		out:  "＾␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ\r‛␍",
	}, { // 3696
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "＾␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ␍␍",
		out:  "＾␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ␍‛␍",
	}, { // 3697
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "＾␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%\r",
		out:  "＾␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%␍",
	}, { // 3698
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "＾␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%␍",
		out:  "＾␂@f＊３\rφ［：\r\x12μζ）Ｃ\x1b␘Q␄~>Pσχμ\x02ｅ%‛␍",
	}, { // 3699
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｈ␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04Aｊ",
		out:  "ｈ␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04Aｊ",
	}, { // 3700
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\t␉ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04Aｊ",
		out:  "\t␉ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04Aｊ",
	}, { // 3701
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␉␉ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04Aｊ",
		out:  "␉␉ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04Aｊ",
	}, { // 3702
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\t␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04␉ｊ",
		out:  "\t␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04␉ｊ",
	}, { // 3703
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␉␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04␉ｊ",
		out:  "␉␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04␉ｊ",
	}, { // 3704
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\t␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04A␉",
		out:  "\t␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04A‛␉",
	}, { // 3705
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␉␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04A␉",
		out:  "␉␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04A‛␉",
	}, { // 3706
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｈ\tψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04Aｊ",
		out:  "ｈ\tψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04Aｊ",
	}, { // 3707
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｈ␉ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04Aｊ",
		out:  "ｈ␉ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04Aｊ",
	}, { // 3708
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｈ\tψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04␉ｊ",
		out:  "ｈ\tψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04␉ｊ",
	}, { // 3709
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｈ␉ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04␉ｊ",
		out:  "ｈ␉ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04␉ｊ",
	}, { // 3710
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｈ\tψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04A␉",
		out:  "ｈ\tψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04A‛␉",
	}, { // 3711
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｈ␉ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04A␉",
		out:  "ｈ␉ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04A‛␉",
	}, { // 3712
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｈ␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04\tｊ",
		out:  "ｈ␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04\tｊ",
	}, { // 3713
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｈ␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04␉ｊ",
		out:  "ｈ␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04␉ｊ",
	}, { // 3714
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｈ␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04\t␉",
		out:  "ｈ␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04\t‛␉",
	}, { // 3715
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｈ␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04␉␉",
		out:  "ｈ␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04␉‛␉",
	}, { // 3716
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｈ␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04A\t",
		out:  "ｈ␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04A␉",
	}, { // 3717
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｈ␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04A␉",
		out:  "ｈ␁ψ␘F\x03␡γ\\\v\tＺRvＷ\t／Ｘκ,␎\rτＱOγρ\x04A‛␉",
	}, { // 3718
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λd",
		out:  "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λd",
	}, { // 3719
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\n␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λd",
		out:  "\n␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λd",
	}, { // 3720
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␊␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λd",
		out:  "␊␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λd",
	}, { // 3721
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\n␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|␊d",
		out:  "\n␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|␊d",
	}, { // 3722
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␊␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|␊d",
		out:  "␊␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|␊d",
	}, { // 3723
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\n␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λ␊",
		out:  "\n␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λ‛␊",
	}, { // 3724
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␊␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λ␊",
		out:  "␊␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λ‛␊",
	}, { // 3725
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｏ\n％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λd",
		out:  "ｏ\n％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λd",
	}, { // 3726
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λd",
		out:  "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λd",
	}, { // 3727
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｏ\n％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|␊d",
		out:  "ｏ\n％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|␊d",
	}, { // 3728
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|␊d",
		out:  "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|␊d",
	}, { // 3729
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｏ\n％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λ␊",
		out:  "ｏ\n％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λ‛␊",
	}, { // 3730
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λ␊",
		out:  "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λ‛␊",
	}, { // 3731
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|\nd",
		out:  "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|\nd",
	}, { // 3732
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|␊d",
		out:  "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|␊d",
	}, { // 3733
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|\n␊",
		out:  "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|\n‛␊",
	}, { // 3734
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|␊␊",
		out:  "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|␊‛␊",
	}, { // 3735
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λ\n",
		out:  "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λ␊",
	}, { // 3736
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λ␊",
		out:  "ｏ␊％ＶＮρ␊＂\"\x05\n`'Ｏ\aδ␙ιζζ/\uff00K5ｔ\x1b^|λ‛␊",
	}, { // 3737
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␂ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"-:",
		out:  "␂ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"-:",
	}, { // 3738
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\v␋␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"-:",
		out:  "\v␋␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"-:",
	}, { // 3739
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␋␋␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"-:",
		out:  "␋␋␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"-:",
	}, { // 3740
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\vξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"␋:",
		out:  "\vξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"␋:",
	}, { // 3741
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␋ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"␋:",
		out:  "␋ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"␋:",
	}, { // 3742
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\vξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"-␋",
		out:  "\vξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"-‛␋",
	}, { // 3743
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␋ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"-␋",
		out:  "␋ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"-‛␋",
	}, { // 3744
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␂\v␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"-:",
		out:  "␂\v␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"-:",
	}, { // 3745
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␂␋␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"-:",
		out:  "␂␋␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"-:",
	}, { // 3746
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␂\v␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"␋:",
		out:  "␂\v␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"␋:",
	}, { // 3747
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␂␋␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"␋:",
		out:  "␂␋␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"␋:",
	}, { // 3748
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␂\v␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"-␋",
		out:  "␂\v␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"-‛␋",
	}, { // 3749
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␂␋␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"-␋",
		out:  "␂␋␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"-‛␋",
	}, { // 3750
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␂ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"\v:",
		out:  "␂ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"\v:",
	}, { // 3751
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␂ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"␋:",
		out:  "␂ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"␋:",
	}, { // 3752
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␂ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"\v␋",
		out:  "␂ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"\v‛␋",
	}, { // 3753
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␂ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"␋␋",
		out:  "␂ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"␋‛␋",
	}, { // 3754
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␂ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"-\v",
		out:  "␂ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"-␋",
	}, { // 3755
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␂ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12\x00＄８＋ο'\"-␋",
		out:  "␂ξ␅！８Ｎoιφγ\v%\x17␞:\x10＜\x13：φ\x12␀＄８＋ο'\"-‛␋",
	}, { // 3756
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "`＼ρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[!",
		out:  "`＼ρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[!",
	}, { // 3757
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\r␍ρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[!",
		out:  "\r␍ρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[!",
	}, { // 3758
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␍␍ρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[!",
		out:  "␍␍ρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[!",
	}, { // 3759
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\r＼ρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ␍!",
		out:  "\r＼ρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ␍!",
	}, { // 3760
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␍＼ρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ␍!",
		out:  "␍＼ρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ␍!",
	}, { // 3761
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\r＼ρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[␍",
		out:  "\r＼ρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[‛␍",
	}, { // 3762
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␍＼ρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[␍",
		out:  "␍＼ρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[‛␍",
	}, { // 3763
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "`\rρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[!",
		out:  "`\rρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[!",
	}, { // 3764
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "`␍ρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[!",
		out:  "`␍ρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[!",
	}, { // 3765
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "`\rρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ␍!",
		out:  "`\rρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ␍!",
	}, { // 3766
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "`␍ρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ␍!",
		out:  "`␍ρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ␍!",
	}, { // 3767
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "`\rρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[␍",
		out:  "`\rρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[‛␍",
	}, { // 3768
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "`␍ρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[␍",
		out:  "`␍ρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[‛␍",
	}, { // 3769
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "`＼ρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ\r!",
		out:  "`＼ρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ\r!",
	}, { // 3770
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "`＼ρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ␍!",
		out:  "`＼ρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ␍!",
	}, { // 3771
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "`＼ρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ\r␍",
		out:  "`＼ρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ\r‛␍",
	}, { // 3772
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "`＼ρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ␍␍",
		out:  "`＼ρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ␍‛␍",
	}, { // 3773
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "`＼ρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[\r",
		out:  "`＼ρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[␍",
	}, { // 3774
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "`＼ρ＜*qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[␍",
		out:  "`＼ρ＜＊qδ\x0f/＄\r␈ｘ！\a␌υ＜\uff00τ>G␙９=＾bβ[‛␍",
	}, { // 3775
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "．ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉτ",
		out:  "．ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉτ",
	}, { // 3776
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\t␉␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉτ",
		out:  "\t␉␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉτ",
	}, { // 3777
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␉␉␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉτ",
		out:  "␉␉␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉτ",
	}, { // 3778
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\tζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋C␉τ",
		out:  "\tζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋C␉τ",
	}, { // 3779
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␉ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋C␉τ",
		out:  "␉ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋C␉τ",
	}, { // 3780
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\tζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉ␉",
		out:  "\tζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉ‛␉",
	}, { // 3781
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␉ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉ␉",
		out:  "␉ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉ‛␉",
	}, { // 3782
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "．\t␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉτ",
		out:  "．\t␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉτ",
	}, { // 3783
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "．␉␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉτ",
		out:  "．␉␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉτ",
	}, { // 3784
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "．\t␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋C␉τ",
		out:  "．\t␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋C␉τ",
	}, { // 3785
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "．␉␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋C␉τ",
		out:  "．␉␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋C␉τ",
	}, { // 3786
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "．\t␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉ␉",
		out:  "．\t␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉ‛␉",
	}, { // 3787
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "．␉␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉ␉",
		out:  "．␉␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉ‛␉",
	}, { // 3788
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "．ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋C\tτ",
		out:  "．ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋C\tτ",
	}, { // 3789
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "．ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋C␉τ",
		out:  "．ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋C␉τ",
	}, { // 3790
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "．ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋C\t␉",
		out:  "．ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋C\t‛␉",
	}, { // 3791
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "．ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋C␉␉",
		out:  "．ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋C␉‛␉",
	}, { // 3792
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "．ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉ\t",
		out:  "．ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉ␉",
	}, { // 3793
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "．ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉ␉",
		out:  "．ζ␏ψ\x1cρＸ/οv\t]?'Xｐ␛＂jｋ␍χ␘&\r\x15␋Cｉ‛␉",
	}, { // 3794
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "`φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ\t",
		out:  "`φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ␉",
	}, { // 3795
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\n␊＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ\t",
		out:  "\n␊＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ␉",
	}, { // 3796
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␊␊＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ\t",
		out:  "␊␊＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ␉",
	}, { // 3797
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\nφ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01␊\t",
		out:  "\nφ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01␊␉",
	}, { // 3798
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␊φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01␊\t",
		out:  "␊φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01␊␉",
	}, { // 3799
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\nφ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ␊",
		out:  "\nφ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ‛␊",
	}, { // 3800
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␊φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ␊",
		out:  "␊φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ‛␊",
	}, { // 3801
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "`\n＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ\t",
		out:  "`\n＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ␉",
	}, { // 3802
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "`␊＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ\t",
		out:  "`␊＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ␉",
	}, { // 3803
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "`\n＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01␊\t",
		out:  "`\n＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01␊␉",
	}, { // 3804
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "`␊＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01␊\t",
		out:  "`␊＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01␊␉",
	}, { // 3805
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "`\n＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ␊",
		out:  "`\n＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ‛␊",
	}, { // 3806
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "`␊＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ␊",
		out:  "`␊＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ‛␊",
	}, { // 3807
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "`φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01\n\t",
		out:  "`φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01\n␉",
	}, { // 3808
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "`φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01␊\t",
		out:  "`φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01␊␉",
	}, { // 3809
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "`φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01\n␊",
		out:  "`φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01\n‛␊",
	}, { // 3810
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "`φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01␊␊",
		out:  "`φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01␊‛␊",
	}, { // 3811
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "`φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ\n",
		out:  "`φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ␊",
	}, { // 3812
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "`φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ␊",
		out:  "`φ＼：？}␕ty␇\n␍βε#λψ␐8#Ｅ\x17οＬ\u007f␟Y\x01Ａ‛␊",
	}, { // 3813
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｌＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇％",
		out:  "ｌＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇％",
	}, { // 3814
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\v␋ｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇％",
		out:  "\v␋ｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇％",
	}, { // 3815
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␋␋ｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇％",
		out:  "␋␋ｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇％",
	}, { // 3816
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\vＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␋％",
		out:  "\vＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␋％",
	}, { // 3817
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␋Ｚｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␋％",
		out:  "␋Ｚｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␋％",
	}, { // 3818
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\vＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇␋",
		out:  "\vＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇‛␋",
	}, { // 3819
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␋Ｚｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇␋",
		out:  "␋Ｚｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇‛␋",
	}, { // 3820
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｌ\vｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇％",
		out:  "ｌ\vｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇％",
	}, { // 3821
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｌ␋ｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇％",
		out:  "ｌ␋ｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇％",
	}, { // 3822
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｌ\vｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␋％",
		out:  "ｌ\vｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␋％",
	}, { // 3823
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｌ␋ｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␋％",
		out:  "ｌ␋ｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␋％",
	}, { // 3824
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｌ\vｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇␋",
		out:  "ｌ\vｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇‛␋",
	}, { // 3825
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｌ␋ｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇␋",
		out:  "ｌ␋ｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇‛␋",
	}, { // 3826
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｌＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη\v％",
		out:  "ｌＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη\v％",
	}, { // 3827
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｌＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␋％",
		out:  "ｌＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␋％",
	}, { // 3828
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｌＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη\v␋",
		out:  "ｌＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη\v‛␋",
	}, { // 3829
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｌＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␋␋",
		out:  "ｌＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␋‛␋",
	}, { // 3830
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｌＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇\v",
		out:  "ｌＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇␋",
	}, { // 3831
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｌＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇␋",
		out:  "ｌＺｗ\x18g␉υ＄Hυ\v\x1dβLＲ[\x1b\nfη\"␍\x14␒μ␉Ｔη␇‛␋",
	}, { // 3832
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "：Ｖ１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη␊",
		out:  "：Ｖ１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη‛␊",
	}, { // 3833
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\r␍１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη␊",
		out:  "\r␍１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη‛␊",
	}, { // 3834
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␍␍１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη␊",
		out:  "␍␍１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη‛␊",
	}, { // 3835
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\rＶ１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋ␍␊",
		out:  "\rＶ１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋ␍‛␊",
	}, { // 3836
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␍Ｖ１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋ␍␊",
		out:  "␍Ｖ１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋ␍‛␊",
	}, { // 3837
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\rＶ１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη␍",
		out:  "\rＶ１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη‛␍",
	}, { // 3838
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␍Ｖ１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη␍",
		out:  "␍Ｖ１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη‛␍",
	}, { // 3839
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "：\r１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη␊",
		out:  "：\r１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη‛␊",
	}, { // 3840
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "：␍１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη␊",
		out:  "：␍１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη‛␊",
	}, { // 3841
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "：\r１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋ␍␊",
		out:  "：\r１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋ␍‛␊",
	}, { // 3842
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "：␍１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋ␍␊",
		out:  "：␍１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋ␍‛␊",
	}, { // 3843
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "：\r１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη␍",
		out:  "：\r１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη‛␍",
	}, { // 3844
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "：␍１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη␍",
		out:  "：␍１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη‛␍",
	}, { // 3845
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "：Ｖ１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋ\r␊",
		out:  "：Ｖ１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋ\r‛␊",
	}, { // 3846
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "：Ｖ１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋ␍␊",
		out:  "：Ｖ１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋ␍‛␊",
	}, { // 3847
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "：Ｖ１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋ\r␍",
		out:  "：Ｖ１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋ\r‛␍",
	}, { // 3848
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "：Ｖ１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋ␍␍",
		out:  "：Ｖ１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋ␍‛␍",
	}, { // 3849
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "：Ｖ１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη\r",
		out:  "：Ｖ１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη␍",
	}, { // 3850
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "：Ｖ１ｐ＇πm\x00\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη␍",
		out:  "：Ｖ１ｐ＇πm␀\x15［\rMμ\a\x1f\f␒＂?ζμ␌gπ␆\\\x15Ｋη‛␍",
	}, { // 3851
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n␒",
		out:  "\x16＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n␒",
	}, { // 3852
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\t␉＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n␒",
		out:  "\t␉＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n␒",
	}, { // 3853
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␉␉＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n␒",
		out:  "␉␉＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n␒",
	}, { // 3854
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\t＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο␉␒",
		out:  "\t＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο␉␒",
	}, { // 3855
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␉＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο␉␒",
		out:  "␉＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο␉␒",
	}, { // 3856
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\t＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n␉",
		out:  "\t＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n‛␉",
	}, { // 3857
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␉＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n␉",
		out:  "␉＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n‛␉",
	}, { // 3858
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16\t＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n␒",
		out:  "\x16\t＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n␒",
	}, { // 3859
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16␉＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n␒",
		out:  "\x16␉＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n␒",
	}, { // 3860
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16\t＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο␉␒",
		out:  "\x16\t＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο␉␒",
	}, { // 3861
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16␉＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο␉␒",
		out:  "\x16␉＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο␉␒",
	}, { // 3862
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16\t＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n␉",
		out:  "\x16\t＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n‛␉",
	}, { // 3863
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16␉＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n␉",
		out:  "\x16␉＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n‛␉",
	}, { // 3864
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\t␒",
		out:  "\x16＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\t␒",
	}, { // 3865
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο␉␒",
		out:  "\x16＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο␉␒",
	}, { // 3866
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\t␉",
		out:  "\x16＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\t‛␉",
	}, { // 3867
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο␉␉",
		out:  "\x16＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο␉‛␉",
	}, { // 3868
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n\t",
		out:  "\x16＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n␉",
	}, { // 3869
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n␉",
		out:  "\x16＊＿{｜（*ν．＼\t\x1d\x03ｉωＢ1η\x1a␚αλCi\x19X␙ο\n‛␉",
	}, { // 3870
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "υ～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜\x11",
		out:  "υ～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜\x11",
	}, { // 3871
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\n␊\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜\x11",
		out:  "\n␊\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜\x11",
	}, { // 3872
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␊␊\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜\x11",
		out:  "␊␊\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜\x11",
	}, { // 3873
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\n～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆␊\x11",
		out:  "\n～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆␊\x11",
	}, { // 3874
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␊～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆␊\x11",
		out:  "␊～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆␊\x11",
	}, { // 3875
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\n～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜␊",
		out:  "\n～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜‛␊",
	}, { // 3876
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␊～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜␊",
		out:  "␊～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜‛␊",
	}, { // 3877
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "υ\n\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜\x11",
		out:  "υ\n\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜\x11",
	}, { // 3878
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "υ␊\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜\x11",
		out:  "υ␊\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜\x11",
	}, { // 3879
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "υ\n\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆␊\x11",
		out:  "υ\n\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆␊\x11",
	}, { // 3880
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "υ␊\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆␊\x11",
		out:  "υ␊\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆␊\x11",
	}, { // 3881
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "υ\n\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜␊",
		out:  "υ\n\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜‛␊",
	}, { // 3882
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "υ␊\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜␊",
		out:  "υ␊\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜‛␊",
	}, { // 3883
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "υ～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆\n\x11",
		out:  "υ～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆\n\x11",
	}, { // 3884
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "υ～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆␊\x11",
		out:  "υ～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆␊\x11",
	}, { // 3885
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "υ～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆\n␊",
		out:  "υ～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆\n‛␊",
	}, { // 3886
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "υ～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆␊␊",
		out:  "υ～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆␊‛␊",
	}, { // 3887
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "υ～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜\n",
		out:  "υ～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜␊",
	}, { // 3888
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "υ～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜␊",
		out:  "υ～\x01＼vＩ\x11(ψ_\n＼μs\x03Ｅ<-:␍：／＂ν４\x1dι＆＜‛␊",
	}, { // 3889
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␑[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τφ",
		out:  "␑[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τφ",
	}, { // 3890
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\v␋␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τφ",
		out:  "\v␋␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τφ",
	}, { // 3891
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␋␋␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τφ",
		out:  "␋␋␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τφ",
	}, { // 3892
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\v[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*␋φ",
		out:  "\v[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*␋φ",
	}, { // 3893
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␋[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*␋φ",
		out:  "␋[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*␋φ",
	}, { // 3894
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\v[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τ␋",
		out:  "\v[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τ‛␋",
	}, { // 3895
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␋[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τ␋",
		out:  "␋[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τ‛␋",
	}, { // 3896
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␑\v␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τφ",
		out:  "␑\v␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τφ",
	}, { // 3897
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␑␋␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τφ",
		out:  "␑␋␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τφ",
	}, { // 3898
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␑\v␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*␋φ",
		out:  "␑\v␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*␋φ",
	}, { // 3899
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␑␋␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*␋φ",
		out:  "␑␋␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*␋φ",
	}, { // 3900
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␑\v␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τ␋",
		out:  "␑\v␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τ‛␋",
	}, { // 3901
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␑␋␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τ␋",
		out:  "␑␋␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τ‛␋",
	}, { // 3902
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␑[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*\vφ",
		out:  "␑[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*\vφ",
	}, { // 3903
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␑[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*␋φ",
		out:  "␑[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*␋φ",
	}, { // 3904
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␑[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*\v␋",
		out:  "␑[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*\v‛␋",
	}, { // 3905
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␑[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*␋␋",
		out:  "␑[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*␋‛␋",
	}, { // 3906
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␑[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τ\v",
		out:  "␑[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τ␋",
	}, { // 3907
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␑[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τ␋",
		out:  "␑[␅７c␂δ＝ｇ\x17\v\f\x06\bαμ4␟␖2｝\r␘～！Vρ*τ‛␋",
	}, { // 3908
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "／ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγａθ",
		out:  "／ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγａθ",
	}, { // 3909
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\r␍＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγａθ",
		out:  "\r␍＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγａθ",
	}, { // 3910
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␍␍＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγａθ",
		out:  "␍␍＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγａθ",
	}, { // 3911
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\rｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγ␍θ",
		out:  "\rｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγ␍θ",
	}, { // 3912
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␍ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγ␍θ",
		out:  "␍ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγ␍θ",
	}, { // 3913
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\rｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγａ␍",
		out:  "\rｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγａ‛␍",
	}, { // 3914
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␍ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγａ␍",
		out:  "␍ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγａ‛␍",
	}, { // 3915
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "／\r＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγａθ",
		out:  "／\r＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγａθ",
	}, { // 3916
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "／␍＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγａθ",
		out:  "／␍＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγａθ",
	}, { // 3917
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "／\r＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγ␍θ",
		out:  "／\r＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγ␍θ",
	}, { // 3918
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "／␍＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγ␍θ",
		out:  "／␍＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγ␍θ",
	}, { // 3919
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "／\r＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγａ␍",
		out:  "／\r＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγａ‛␍",
	}, { // 3920
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "／␍＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγａ␍",
		out:  "／␍＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγａ‛␍",
	}, { // 3921
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "／ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγ\rθ",
		out:  "／ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγ\rθ",
	}, { // 3922
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "／ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγ␍θ",
		out:  "／ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγ␍θ",
	}, { // 3923
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "／ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγ\r␍",
		out:  "／ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγ\r‛␍",
	}, { // 3924
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "／ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγ␍␍",
		out:  "／ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγ␍‛␍",
	}, { // 3925
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "／ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγａ\r",
		out:  "／ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγａ␍",
	}, { // 3926
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "／ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎#]P␊\x15\x0f.␍Yγａ␍",
		out:  "／ｚ＜σ\\\x02σ␑ηＡ\rX\x14５８␟ς␎＃]P␊\x15\x0f.␍Yγａ‛␍",
	}, { // 3927
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "：%␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒\x0fg",
		out:  "：％␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒\x0fg",
	}, { // 3928
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\t␉␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒\x0fg",
		out:  "\t␉␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒\x0fg",
	}, { // 3929
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␉␉␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒\x0fg",
		out:  "␉␉␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒\x0fg",
	}, { // 3930
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\t%␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒␉g",
		out:  "\t％␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒␉g",
	}, { // 3931
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␉%␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒␉g",
		out:  "␉％␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒␉g",
	}, { // 3932
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\t%␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒\x0f␉",
		out:  "\t％␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒\x0f‛␉",
	}, { // 3933
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␉%␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒\x0f␉",
		out:  "␉％␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒\x0f‛␉",
	}, { // 3934
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "：\t␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒\x0fg",
		out:  "：\t␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒\x0fg",
	}, { // 3935
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "：␉␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒\x0fg",
		out:  "：␉␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒\x0fg",
	}, { // 3936
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "：\t␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒␉g",
		out:  "：\t␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒␉g",
	}, { // 3937
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "：␉␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒␉g",
		out:  "：␉␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒␉g",
	}, { // 3938
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "：\t␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒\x0f␉",
		out:  "：\t␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒\x0f‛␉",
	}, { // 3939
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "：␉␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒\x0f␉",
		out:  "：␉␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒\x0f‛␉",
	}, { // 3940
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "：%␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒\tg",
		out:  "：％␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒\tg",
	}, { // 3941
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "：%␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒␉g",
		out:  "：％␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒␉g",
	}, { // 3942
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "：%␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒\t␉",
		out:  "：％␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒\t‛␉",
	}, { // 3943
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "：%␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒␉␉",
		out:  "：％␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒␉‛␉",
	}, { // 3944
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "：%␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒\x0f\t",
		out:  "：％␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒\x0f␉",
	}, { // 3945
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "：%␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y％ι@ο\x105␙Ｑ␒\x0f␉",
		out:  "：％␂ｙ\x15␈\x10μYP\tＺ␈ι５ηθ␇y‛％ι@ο\x105␙Ｑ␒\x0f‛␉",
	}, { // 3946
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "3\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？Ｃ",
		out:  "3\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？Ｃ",
	}, { // 3947
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\n␊｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？Ｃ",
		out:  "\n␊｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？Ｃ",
	}, { // 3948
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊␊｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？Ｃ",
		out:  "␊␊｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？Ｃ",
	}, { // 3949
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\n\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ␊Ｃ",
		out:  "\n\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ␊Ｃ",
	}, { // 3950
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ␊Ｃ",
		out:  "␊\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ␊Ｃ",
	}, { // 3951
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\n\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？␊",
		out:  "\n\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？‛␊",
	}, { // 3952
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？␊",
		out:  "␊\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？‛␊",
	}, { // 3953
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "3\n｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？Ｃ",
		out:  "3\n｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？Ｃ",
	}, { // 3954
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "3␊｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？Ｃ",
		out:  "3␊｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？Ｃ",
	}, { // 3955
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "3\n｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ␊Ｃ",
		out:  "3\n｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ␊Ｃ",
	}, { // 3956
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "3␊｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ␊Ｃ",
		out:  "3␊｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ␊Ｃ",
	}, { // 3957
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "3\n｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？␊",
		out:  "3\n｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？‛␊",
	}, { // 3958
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "3␊｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？␊",
		out:  "3␊｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？‛␊",
	}, { // 3959
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "3\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ\nＣ",
		out:  "3\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ\nＣ",
	}, { // 3960
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "3\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ␊Ｃ",
		out:  "3\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ␊Ｃ",
	}, { // 3961
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "3\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ\n␊",
		out:  "3\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ\n‛␊",
	}, { // 3962
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "3\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ␊␊",
		out:  "3\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ␊‛␊",
	}, { // 3963
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "3\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？\n",
		out:  "3\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？␊",
	}, { // 3964
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "3\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？␊",
		out:  "3\x14｛\v［χσ＊α＂\n<F>\x11＂＊k：Ｒη\x15β\vyτ-ｃ？‛␊",
	}, { // 3965
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "［）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14n",
		out:  "［）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14n",
	}, { // 3966
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\v␋\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14n",
		out:  "\v␋\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14n",
	}, { // 3967
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␋␋\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14n",
		out:  "␋␋\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14n",
	}, { // 3968
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\v）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ␋n",
		out:  "\v）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ␋n",
	}, { // 3969
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␋）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ␋n",
		out:  "␋）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ␋n",
	}, { // 3970
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\v）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14␋",
		out:  "\v）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14‛␋",
	}, { // 3971
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␋）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14␋",
		out:  "␋）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14‛␋",
	}, { // 3972
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "［\v\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14n",
		out:  "［\v\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14n",
	}, { // 3973
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "［␋\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14n",
		out:  "［␋\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14n",
	}, { // 3974
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "［\v\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ␋n",
		out:  "［\v\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ␋n",
	}, { // 3975
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "［␋\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ␋n",
		out:  "［␋\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ␋n",
	}, { // 3976
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "［\v\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14␋",
		out:  "［\v\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14‛␋",
	}, { // 3977
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "［␋\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14␋",
		out:  "［␋\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14‛␋",
	}, { // 3978
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "［）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\vn",
		out:  "［）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\vn",
	}, { // 3979
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "［）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ␋n",
		out:  "［）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ␋n",
	}, { // 3980
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "［）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\v␋",
		out:  "［）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\v‛␋",
	}, { // 3981
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "［）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ␋␋",
		out:  "［）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ␋‛␋",
	}, { // 3982
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "［）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14\v",
		out:  "［）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14␋",
	}, { // 3983
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "［）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14␋",
		out:  "［）\x1bοQＲ\x14Ｉκο\v_>χ\x1dＨ\b␏{ｖ␜␙ζM␞ι␓ａ\x14‛␋",
	}, { // 3984
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "δ＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕\\",
		out:  "δ＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕\\",
	}, { // 3985
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\r␍Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕\\",
		out:  "\r␍Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕\\",
	}, { // 3986
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␍␍Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕\\",
		out:  "␍␍Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕\\",
	}, { // 3987
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\r＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␍\\",
		out:  "\r＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␍\\",
	}, { // 3988
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␍＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␍\\",
		out:  "␍＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␍\\",
	}, { // 3989
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\r＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕␍",
		out:  "\r＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕‛␍",
	}, { // 3990
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␍＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕␍",
		out:  "␍＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕‛␍",
	}, { // 3991
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "δ\rＤ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕\\",
		out:  "δ\rＤ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕\\",
	}, { // 3992
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "δ␍Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕\\",
		out:  "δ␍Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕\\",
	}, { // 3993
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "δ\rＤ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␍\\",
		out:  "δ\rＤ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␍\\",
	}, { // 3994
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "δ␍Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␍\\",
		out:  "δ␍Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␍\\",
	}, { // 3995
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "δ\rＤ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕␍",
		out:  "δ\rＤ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕‛␍",
	}, { // 3996
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "δ␍Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕␍",
		out:  "δ␍Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕‛␍",
	}, { // 3997
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "δ＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔\r\\",
		out:  "δ＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔\r\\",
	}, { // 3998
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "δ＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␍\\",
		out:  "δ＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␍\\",
	}, { // 3999
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "δ＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔\r␍",
		out:  "δ＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔\r‛␍",
	}, { // 4000
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "δ＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␍␍",
		out:  "δ＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␍‛␍",
	}, { // 4001
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "δ＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕\r",
		out:  "δ＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕␍",
	}, { // 4002
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "δ＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕␍",
		out:  "δ＼Ｄ\x1b］>\x18κ'Ｂ\r*α\x1bηδ（,μ␄^ｄ~␓］+␈␔␕‛␍",
	}, { // 4003
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP>",
		out:  "|3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP>",
	}, { // 4004
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\t␉␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP>",
		out:  "\t␉␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP>",
	}, { // 4005
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␉␉␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP>",
		out:  "␉␉␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP>",
	}, { // 4006
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\t3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％Z␉>",
		out:  "\t3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％Z␉>",
	}, { // 4007
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␉3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％Z␉>",
		out:  "␉3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％Z␉>",
	}, { // 4008
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\t3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP␉",
		out:  "\t3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP‛␉",
	}, { // 4009
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␉3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP␉",
		out:  "␉3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP‛␉",
	}, { // 4010
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|\t␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP>",
		out:  "|\t␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP>",
	}, { // 4011
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|␉␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP>",
		out:  "|␉␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP>",
	}, { // 4012
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|\t␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％Z␉>",
		out:  "|\t␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％Z␉>",
	}, { // 4013
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|␉␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％Z␉>",
		out:  "|␉␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％Z␉>",
	}, { // 4014
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|\t␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP␉",
		out:  "|\t␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP‛␉",
	}, { // 4015
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|␉␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP␉",
		out:  "|␉␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP‛␉",
	}, { // 4016
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％Z\t>",
		out:  "|3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％Z\t>",
	}, { // 4017
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％Z␉>",
		out:  "|3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％Z␉>",
	}, { // 4018
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％Z\t␉",
		out:  "|3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％Z\t‛␉",
	}, { // 4019
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％Z␉␉",
		out:  "|3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％Z␉‛␉",
	}, { // 4020
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP\t",
		out:  "|3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP␉",
	}, { // 4021
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP␉",
		out:  "|3␆]Ａ␊＇θ]\x18\t\rｖξ␛\"\x04φυ␖｀$＆␟ｅπ％ZP‛␉",
	}, { // 4022
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "｜５ξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？π＞",
		out:  "｜５ξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？π＞",
	}, { // 4023
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\n␊ξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？π＞",
		out:  "\n␊ξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？π＞",
	}, { // 4024
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␊␊ξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？π＞",
		out:  "␊␊ξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？π＞",
	}, { // 4025
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\n５ξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？␊＞",
		out:  "\n５ξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？␊＞",
	}, { // 4026
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␊５ξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？␊＞",
		out:  "␊５ξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？␊＞",
	}, { // 4027
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\n５ξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？π␊",
		out:  "\n５ξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？π‛␊",
	}, { // 4028
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␊５ξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？π␊",
		out:  "␊５ξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？π‛␊",
	}, { // 4029
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "｜\nξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？π＞",
		out:  "｜\nξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？π＞",
	}, { // 4030
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "｜␊ξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？π＞",
		out:  "｜␊ξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？π＞",
	}, { // 4031
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "｜\nξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？␊＞",
		out:  "｜\nξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？␊＞",
	}, { // 4032
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "｜␊ξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？␊＞",
		out:  "｜␊ξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？␊＞",
	}, { // 4033
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "｜\nξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？π␊",
		out:  "｜\nξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？π‛␊",
	}, { // 4034
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "｜␊ξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？π␊",
		out:  "｜␊ξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？π‛␊",
	}, { // 4035
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "｜５ξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？\n＞",
		out:  "｜５ξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？\n＞",
	}, { // 4036
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "｜５ξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？␊＞",
		out:  "｜５ξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？␊＞",
	}, { // 4037
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "｜５ξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？\n␊",
		out:  "｜５ξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？\n‛␊",
	}, { // 4038
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "｜５ξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？␊␊",
		out:  "｜５ξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？␊‛␊",
	}, { // 4039
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "｜５ξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？π\n",
		out:  "｜５ξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？π␊",
	}, { // 4040
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "｜５ξ#δλp／␙＠\n\x06=ｏεｙ\\#|\x1b␑\x17ρ\x11c／\x06？π␊",
		out:  "｜５ξ#δλp／␙＠\n\x06=ｏεｙ＼#|\x1b␑\x17ρ\x11c／\x06？π‛␊",
	}, { // 4041
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "[␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν(",
		out:  "[␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν(",
	}, { // 4042
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\v␋τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν(",
		out:  "\v␋τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν(",
	}, { // 4043
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␋␋τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν(",
		out:  "␋␋τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν(",
	}, { // 4044
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\v␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19␋(",
		out:  "\v␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19␋(",
	}, { // 4045
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␋␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19␋(",
		out:  "␋␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19␋(",
	}, { // 4046
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\v␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν␋",
		out:  "\v␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν‛␋",
	}, { // 4047
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␋␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν␋",
		out:  "␋␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν‛␋",
	}, { // 4048
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "[\vτ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν(",
		out:  "[\vτ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν(",
	}, { // 4049
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "[␋τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν(",
		out:  "[␋τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν(",
	}, { // 4050
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "[\vτ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19␋(",
		out:  "[\vτ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19␋(",
	}, { // 4051
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "[␋τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19␋(",
		out:  "[␋τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19␋(",
	}, { // 4052
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "[\vτ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν␋",
		out:  "[\vτ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν‛␋",
	}, { // 4053
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "[␋τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν␋",
		out:  "[␋τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν‛␋",
	}, { // 4054
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "[␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19\v(",
		out:  "[␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19\v(",
	}, { // 4055
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "[␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19␋(",
		out:  "[␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19␋(",
	}, { // 4056
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "[␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19\v␋",
		out:  "[␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19\v‛␋",
	}, { // 4057
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "[␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19␋␋",
		out:  "[␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19␋‛␋",
	}, { // 4058
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "[␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν\v",
		out:  "[␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν␋",
	}, { // 4059
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "[␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν␋",
		out:  "[␍τ\x17x␍＞/!/\ve␜，\rθ`＋＿γ＂Ｋη␉fｕ＊\x19ν‛␋",
	}, { // 4060
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ａα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇|",
		out:  "Ａα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇|",
	}, { // 4061
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r␍␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇|",
		out:  "\r␍␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇|",
	}, { // 4062
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␍␍␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇|",
		out:  "␍␍␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇|",
	}, { // 4063
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\rα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee␍|",
		out:  "\rα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee␍|",
	}, { // 4064
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␍α␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee␍|",
		out:  "␍α␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee␍|",
	}, { // 4065
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\rα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇␍",
		out:  "\rα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇‛␍",
	}, { // 4066
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␍α␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇␍",
		out:  "␍α␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇‛␍",
	}, { // 4067
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ａ\r␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇|",
		out:  "Ａ\r␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇|",
	}, { // 4068
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ａ␍␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇|",
		out:  "Ａ␍␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇|",
	}, { // 4069
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ａ\r␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee␍|",
		out:  "Ａ\r␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee␍|",
	}, { // 4070
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ａ␍␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee␍|",
		out:  "Ａ␍␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee␍|",
	}, { // 4071
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ａ\r␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇␍",
		out:  "Ａ\r␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇‛␍",
	}, { // 4072
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ａ␍␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇␍",
		out:  "Ａ␍␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇‛␍",
	}, { // 4073
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ａα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee\r|",
		out:  "Ａα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee\r|",
	}, { // 4074
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ａα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee␍|",
		out:  "Ａα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee␍|",
	}, { // 4075
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ａα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee\r␍",
		out:  "Ａα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee\r‛␍",
	}, { // 4076
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ａα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee␍␍",
		out:  "Ａα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee␍‛␍",
	}, { // 4077
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ａα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇\r",
		out:  "Ａα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇␍",
	}, { // 4078
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ａα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇␍",
		out:  "Ａα␖␓]\x1c＇\x05*ξ\rｋM␚\rCχκ\x10＜ς\x1f\uff00｝␔λee＇‛␍",
	}, { // 4079
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/\\",
		out:  "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/\\",
	}, { // 4080
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\t␉？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/\\",
		out:  "\t␉？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/\\",
	}, { // 4081
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␉？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/\\",
		out:  "␉␉？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/\\",
	}, { // 4082
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\t␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=␉\\",
		out:  "\t␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=␉\\",
	}, { // 4083
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=␉\\",
		out:  "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=␉\\",
	}, { // 4084
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\t␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/␉",
		out:  "\t␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/‛␉",
	}, { // 4085
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/␉",
		out:  "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/‛␉",
	}, { // 4086
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉\t？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/\\",
		out:  "␉\t？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/\\",
	}, { // 4087
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␉？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/\\",
		out:  "␉␉？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/\\",
	}, { // 4088
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉\t？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=␉\\",
		out:  "␉\t？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=␉\\",
	}, { // 4089
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␉？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=␉\\",
		out:  "␉␉？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=␉\\",
	}, { // 4090
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉\t？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/␉",
		out:  "␉\t？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/‛␉",
	}, { // 4091
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␉？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/␉",
		out:  "␉␉？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/‛␉",
	}, { // 4092
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=\t\\",
		out:  "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=\t\\",
	}, { // 4093
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=␉\\",
		out:  "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=␉\\",
	}, { // 4094
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=\t␉",
		out:  "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=\t‛␉",
	}, { // 4095
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=␉␉",
		out:  "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=␉‛␉",
	}, { // 4096
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/\t",
		out:  "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/␉",
	}, { // 4097
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/␉",
		out:  "␉␄？5，3ηγ\x15_\t\bξＩN␅λζ␊）＃␎␚πＶQ<=/‛␉",
	}, { // 4098
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ε'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`：",
		out:  "ε'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`：",
	}, { // 4099
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\n␊ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`：",
		out:  "\n␊ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`：",
	}, { // 4100
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␊␊ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`：",
		out:  "␊␊ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`：",
	}, { // 4101
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\n'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ␊：",
		out:  "\n'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ␊：",
	}, { // 4102
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␊'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ␊：",
		out:  "␊'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ␊：",
	}, { // 4103
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\n'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`␊",
		out:  "\n'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`‛␊",
	}, { // 4104
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␊'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`␊",
		out:  "␊'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`‛␊",
	}, { // 4105
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ε\nｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`：",
		out:  "ε\nｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`：",
	}, { // 4106
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ε␊ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`：",
		out:  "ε␊ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`：",
	}, { // 4107
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ε\nｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ␊：",
		out:  "ε\nｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ␊：",
	}, { // 4108
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ε␊ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ␊：",
		out:  "ε␊ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ␊：",
	}, { // 4109
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ε\nｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`␊",
		out:  "ε\nｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`‛␊",
	}, { // 4110
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ε␊ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`␊",
		out:  "ε␊ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`‛␊",
	}, { // 4111
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ε'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ\n：",
		out:  "ε'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ\n：",
	}, { // 4112
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ε'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ␊：",
		out:  "ε'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ␊：",
	}, { // 4113
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ε'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ\n␊",
		out:  "ε'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ\n‛␊",
	}, { // 4114
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ε'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ␊␊",
		out:  "ε'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ␊‛␊",
	}, { // 4115
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ε'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`\n",
		out:  "ε'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`␊",
	}, { // 4116
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ε'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`␊",
		out:  "ε'ｊ\x15\rE␍＇e\x14\n␅＇＜νψ#ｗρ<％␊B｛\x1b␟ωκ`‛␊",
	}, { // 4117
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ω2ｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e␜",
		out:  "ω2ｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e␜",
	}, { // 4118
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\v␋ｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e␜",
		out:  "\v␋ｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e␜",
	}, { // 4119
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␋␋ｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e␜",
		out:  "␋␋ｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e␜",
	}, { // 4120
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\v2ｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％␋␜",
		out:  "\v2ｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％␋␜",
	}, { // 4121
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␋2ｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％␋␜",
		out:  "␋2ｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％␋␜",
	}, { // 4122
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\v2ｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e␋",
		out:  "\v2ｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e‛␋",
	}, { // 4123
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␋2ｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e␋",
		out:  "␋2ｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e‛␋",
	}, { // 4124
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ω\vｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e␜",
		out:  "ω\vｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e␜",
	}, { // 4125
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ω␋ｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e␜",
		out:  "ω␋ｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e␜",
	}, { // 4126
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ω\vｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％␋␜",
		out:  "ω\vｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％␋␜",
	}, { // 4127
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ω␋ｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％␋␜",
		out:  "ω␋ｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％␋␜",
	}, { // 4128
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ω\vｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e␋",
		out:  "ω\vｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e‛␋",
	}, { // 4129
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ω␋ｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e␋",
		out:  "ω␋ｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e‛␋",
	}, { // 4130
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ω2ｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\v␜",
		out:  "ω2ｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\v␜",
	}, { // 4131
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ω2ｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％␋␜",
		out:  "ω2ｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％␋␜",
	}, { // 4132
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ω2ｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\v␋",
		out:  "ω2ｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\v‛␋",
	}, { // 4133
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ω2ｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％␋␋",
		out:  "ω2ｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％␋‛␋",
	}, { // 4134
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ω2ｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e\v",
		out:  "ω2ｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e␋",
	}, { // 4135
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ω2ｖ［\u007ft&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e␋",
		out:  "ω2ｖ［␡t&（␙\x1d\vρ␕ωａν%ｆωｈ５,δ\x0eW␓{％\x0e‛␋",
	}, { // 4136
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a%",
		out:  "␉␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a%",
	}, { // 4137
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\r␍>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a%",
		out:  "\r␍>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a%",
	}, { // 4138
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍␍>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a%",
		out:  "␍␍>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a%",
	}, { // 4139
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\r␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿␍%",
		out:  "\r␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿␍%",
	}, { // 4140
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿␍%",
		out:  "␍␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿␍%",
	}, { // 4141
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\r␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a␍",
		out:  "\r␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a‛␍",
	}, { // 4142
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a␍",
		out:  "␍␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a‛␍",
	}, { // 4143
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉\r>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a%",
		out:  "␉\r>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a%",
	}, { // 4144
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␍>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a%",
		out:  "␉␍>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a%",
	}, { // 4145
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉\r>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿␍%",
		out:  "␉\r>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿␍%",
	}, { // 4146
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␍>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿␍%",
		out:  "␉␍>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿␍%",
	}, { // 4147
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉\r>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a␍",
		out:  "␉\r>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a‛␍",
	}, { // 4148
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␍>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a␍",
		out:  "␉␍>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a‛␍",
	}, { // 4149
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\r%",
		out:  "␉␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\r%",
	}, { // 4150
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿␍%",
		out:  "␉␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿␍%",
	}, { // 4151
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\r␍",
		out:  "␉␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\r‛␍",
	}, { // 4152
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿␍␍",
		out:  "␉␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿␍‛␍",
	}, { // 4153
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a\r",
		out:  "␉␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a␍",
	}, { // 4154
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a␍",
		out:  "␉␁>\x1e＂oχ＜Hχ\r．３tａ＞ζ(εｏ␓ι#m(｝\x19＿\a‛␍",
	}, { // 4155
		mask: EncodeLeftSpace,
		in:   "  ",
		out:  "␠ ",
	}, { // 4156
		mask: EncodeLeftPeriod,
		in:   "..",
		out:  "．.",
	}, { // 4157
		mask: EncodeLeftTilde,
		in:   "~~",
		out:  "～~",
	}, { // 4158
		mask: EncodeRightSpace,
		in:   "  ",
		out:  " ␠",
	}, { // 4159
		mask: EncodeRightPeriod,
		in:   "..",
		out:  ".．",
	}, { // 4160
		mask: EncodeLeftSpace | EncodeRightPeriod,
		in:   " .",
		out:  "␠．",
	}, { // 4161
		mask: EncodeLeftSpace | EncodeRightSpace,
		in:   " ",
		out:  "␠",
	}, { // 4162
		mask: EncodeLeftSpace | EncodeRightSpace,
		in:   "  ",
		out:  "␠␠",
	}, { // 4163
		mask: EncodeLeftSpace | EncodeRightSpace,
		in:   "   ",
		out:  "␠ ␠",
	}, { // 4164
		mask: EncodeLeftPeriod | EncodeRightPeriod,
		in:   "...",
		out:  "．.．",
	}, { // 4165
		mask: EncodeRightPeriod | EncodeRightSpace,
		in:   "a. ",
		out:  "a.␠",
	}, { // 4166
		mask: EncodeRightPeriod | EncodeRightSpace,
		in:   "a .",
		out:  "a ．",
	},
}

var testCasesDoubleEdge = []testCase{
	{ // 0
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .uγＮ＜λχ\x15 \x18\\ｗt＇＝（␞ςυ␛Ｆ␚\x1f␑ｙk<.Z",
		out:  "␠.uγＮ＜λχ\x15 \x18\\ｗt＇＝（␞ςυ␛Ｆ␚\x1f␑ｙk<.Z",
	}, { // 1
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.uγＮ＜λχ\x15 \x18\\ｗt＇＝（␞ςυ␛Ｆ␚\x1f␑ｙk<.Z",
		out:  "‛␠.uγＮ＜λχ\x15 \x18\\ｗt＇＝（␞ςυ␛Ｆ␚\x1f␑ｙk<.Z",
	}, { // 2
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\v.uγＮ＜λχ\x15 \x18\\ｗt＇＝（␞ςυ␛Ｆ␚\x1f␑ｙk<. ",
		out:  "\v.uγＮ＜λχ\x15 \x18\\ｗt＇＝（␞ςυ␛Ｆ␚\x1f␑ｙk<. ",
	}, { // 3
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\v.uγＮ＜λχ\x15 \x18\\ｗt＇＝（␞ςυ␛Ｆ␚\x1f␑ｙk<.␠",
		out:  "\v.uγＮ＜λχ\x15 \x18\\ｗt＇＝（␞ςυ␛Ｆ␚\x1f␑ｙk<.␠",
	}, { // 4
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " ./clφ␊\x12＞＂.YωδN\x0f：％９=Ｐπ␖κｑ#ω\f.␑",
		out:  "␠.／clφ␊\x12＞＂.YωδN\x0f：％９=Ｐπ␖κｑ#ω\f.␑",
	}, { // 5
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠./clφ␊\x12＞＂.YωδN\x0f：％９=Ｐπ␖κｑ#ω\f.␑",
		out:  "‛␠.／clφ␊\x12＞＂.YωδN\x0f：％９=Ｐπ␖κｑ#ω\f.␑",
	}, { // 6
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "？./clφ␊\x12＞＂.YωδN\x0f：％９=Ｐπ␖κｑ#ω\f. ",
		out:  "？.／clφ␊\x12＞＂.YωδN\x0f：％９=Ｐπ␖κｑ#ω\f. ",
	}, { // 7
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "？./clφ␊\x12＞＂.YωδN\x0f：％９=Ｐπ␖κｑ#ω\f.␠",
		out:  "？.／clφ␊\x12＞＂.YωδN\x0f：％９=Ｐπ␖κｑ#ω\f.␠",
	}, { // 8
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .#ｙ＠％η'␜\rj␔␁ｆｊH：λκ\x1c]Dｍ\a\a\x18g␛.ζ",
		out:  "␠.#ｙ＠％η＇␜\rj␔␁ｆｊH：λκ\x1c]Dｍ\a\a\x18g␛.ζ",
	}, { // 9
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.#ｙ＠％η'␜\rj␔␁ｆｊH：λκ\x1c]Dｍ\a\a\x18g␛.ζ",
		out:  "‛␠.#ｙ＠％η＇␜\rj␔␁ｆｊH：λκ\x1c]Dｍ\a\a\x18g␛.ζ",
	}, { // 10
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "ξ.#ｙ＠％η'␜\rj␔␁ｆｊH：λκ\x1c]Dｍ\a\a\x18g␛. ",
		out:  "ξ.#ｙ＠％η＇␜\rj␔␁ｆｊH：λκ\x1c]Dｍ\a\a\x18g␛. ",
	}, { // 11
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "ξ.#ｙ＠％η'␜\rj␔␁ｆｊH：λκ\x1c]Dｍ\a\a\x18g␛.␠",
		out:  "ξ.#ｙ＠％η＇␜\rj␔␁ｆｊH：λκ\x1c]Dｍ\a\a\x18g␛.␠",
	}, { // 12
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .ζkυ␉Ｘ＄3－κ\x1fο'ｑ␄2Ｌγ\u007f␀$ｒ(＼\"\\␁.s",
		out:  "␠.ζkυ␉Ｘ＄3－κ\x1fο'ｑ␄2Ｌγ\u007f‛␀$ｒ(＼\"\\␁.s",
	}, { // 13
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.ζkυ␉Ｘ＄3－κ\x1fο'ｑ␄2Ｌγ\u007f␀$ｒ(＼\"\\␁.s",
		out:  "‛␠.ζkυ␉Ｘ＄3－κ\x1fο'ｑ␄2Ｌγ\u007f‛␀$ｒ(＼\"\\␁.s",
	}, { // 14
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "ｋ.ζkυ␉Ｘ＄3－κ\x1fο'ｑ␄2Ｌγ\u007f␀$ｒ(＼\"\\␁. ",
		out:  "ｋ.ζkυ␉Ｘ＄3－κ\x1fο'ｑ␄2Ｌγ\u007f‛␀$ｒ(＼\"\\␁. ",
	}, { // 15
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "ｋ.ζkυ␉Ｘ＄3－κ\x1fο'ｑ␄2Ｌγ\u007f␀$ｒ(＼\"\\␁.␠",
		out:  "ｋ.ζkυ␉Ｘ＄3－κ\x1fο'ｑ␄2Ｌγ\u007f‛␀$ｒ(＼\"\\␁.␠",
	}, { // 16
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .：［ＭηαC␗\x04sα[θ␡\x02␒：３␙σy\x01ν␆ｙ\x1a\n.z",
		out:  "␠.：［ＭηαC␗\x04sα[θ␡\x02␒：３␙σy\x01ν␆ｙ\x1a\n.z",
	}, { // 17
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.：［ＭηαC␗\x04sα[θ␡\x02␒：３␙σy\x01ν␆ｙ\x1a\n.z",
		out:  "‛␠.：［ＭηαC␗\x04sα[θ␡\x02␒：３␙σy\x01ν␆ｙ\x1a\n.z",
	}, { // 18
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␅.：［ＭηαC␗\x04sα[θ␡\x02␒：３␙σy\x01ν␆ｙ\x1a\n. ",
		out:  "␅.：［ＭηαC␗\x04sα[θ␡\x02␒：３␙σy\x01ν␆ｙ\x1a\n. ",
	}, { // 19
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␅.：［ＭηαC␗\x04sα[θ␡\x02␒：３␙σy\x01ν␆ｙ\x1a\n.␠",
		out:  "␅.：［ＭηαC␗\x04sα[θ␡\x02␒：３␙σy\x01ν␆ｙ\x1a\n.␠",
	}, { // 20
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .1４φ␈\aρT\x0e\x06V＞>ｈ＊␀\nυσaT９ｈ％Ｃ\x06？.␔",
		out:  "␠.1４φ␈\aρT\x0e\x06V＞>ｈ＊‛␀\nυσaT９ｈ％Ｃ\x06？.␔",
	}, { // 21
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.1４φ␈\aρT\x0e\x06V＞>ｈ＊␀\nυσaT９ｈ％Ｃ\x06？.␔",
		out:  "‛␠.1４φ␈\aρT\x0e\x06V＞>ｈ＊‛␀\nυσaT９ｈ％Ｃ\x06？.␔",
	}, { // 22
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "χ.1４φ␈\aρT\x0e\x06V＞>ｈ＊␀\nυσaT９ｈ％Ｃ\x06？. ",
		out:  "χ.1４φ␈\aρT\x0e\x06V＞>ｈ＊‛␀\nυσaT９ｈ％Ｃ\x06？. ",
	}, { // 23
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "χ.1４φ␈\aρT\x0e\x06V＞>ｈ＊␀\nυσaT９ｈ％Ｃ\x06？.␠",
		out:  "χ.1４φ␈\aρT\x0e\x06V＞>ｈ＊‛␀\nυσaT９ｈ％Ｃ\x06？.␠",
	}, { // 24
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .#αＯlδ／＊ｊＮ＊\x10］τηｉ>ι1{␈Sｙ@␊\x1c␙.α",
		out:  "␠.#αＯlδ／＊ｊＮ＊\x10］τηｉ>ι1{␈Sｙ@␊\x1c␙.α",
	}, { // 25
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.#αＯlδ／＊ｊＮ＊\x10］τηｉ>ι1{␈Sｙ@␊\x1c␙.α",
		out:  "‛␠.#αＯlδ／＊ｊＮ＊\x10］τηｉ>ι1{␈Sｙ@␊\x1c␙.α",
	}, { // 26
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x1c.#αＯlδ／＊ｊＮ＊\x10］τηｉ>ι1{␈Sｙ@␊\x1c␙. ",
		out:  "\x1c.#αＯlδ／＊ｊＮ＊\x10］τηｉ>ι1{␈Sｙ@␊\x1c␙. ",
	}, { // 27
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x1c.#αＯlδ／＊ｊＮ＊\x10］τηｉ>ι1{␈Sｙ@␊\x1c␙.␠",
		out:  "\x1c.#αＯlδ／＊ｊＮ＊\x10］τηｉ>ι1{␈Sｙ@␊\x1c␙.␠",
	}, { // 28
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .Ｋμ␂v␖\x06ιＩｈγ^olκ\x0f␂＜H\x16\x03␇N：τφ＝.Ｖ",
		out:  "␠.Ｋμ␂v␖\x06ιＩｈγ^olκ\x0f␂＜H\x16\x03␇N：τφ＝.Ｖ",
	}, { // 29
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.Ｋμ␂v␖\x06ιＩｈγ^olκ\x0f␂＜H\x16\x03␇N：τφ＝.Ｖ",
		out:  "‛␠.Ｋμ␂v␖\x06ιＩｈγ^olκ\x0f␂＜H\x16\x03␇N：τφ＝.Ｖ",
	}, { // 30
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␍.Ｋμ␂v␖\x06ιＩｈγ^olκ\x0f␂＜H\x16\x03␇N：τφ＝. ",
		out:  "␍.Ｋμ␂v␖\x06ιＩｈγ^olκ\x0f␂＜H\x16\x03␇N：τφ＝. ",
	}, { // 31
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␍.Ｋμ␂v␖\x06ιＩｈγ^olκ\x0f␂＜H\x16\x03␇N：τφ＝.␠",
		out:  "␍.Ｋμ␂v␖\x06ιＩｈγ^olκ\x0f␂＜H\x16\x03␇N：τφ＝.␠",
	}, { // 32
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .␆τ\x17␟E＜␋Mν8＄\fψ!！Ｐ\x1dνω\x1fh\x0e１␜␉）.K",
		out:  "␠.␆τ\x17␟E＜␋Mν8＄\fψ!！Ｐ\x1dνω\x1fh\x0e１␜␉）.K",
	}, { // 33
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.␆τ\x17␟E＜␋Mν8＄\fψ!！Ｐ\x1dνω\x1fh\x0e１␜␉）.K",
		out:  "‛␠.␆τ\x17␟E＜␋Mν8＄\fψ!！Ｐ\x1dνω\x1fh\x0e１␜␉）.K",
	}, { // 34
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "δ.␆τ\x17␟E＜␋Mν8＄\fψ!！Ｐ\x1dνω\x1fh\x0e１␜␉）. ",
		out:  "δ.␆τ\x17␟E＜␋Mν8＄\fψ!！Ｐ\x1dνω\x1fh\x0e１␜␉）. ",
	}, { // 35
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "δ.␆τ\x17␟E＜␋Mν8＄\fψ!！Ｐ\x1dνω\x1fh\x0e１␜␉）.␠",
		out:  "δ.␆τ\x17␟E＜␋Mν8＄\fψ!！Ｐ\x1dνω\x1fh\x0e１␜␉）.␠",
	}, { // 36
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .dＯd[～ｓ?*λ＊\x1c␜(θοC#\"ζω\r␘␀␈：Ｉ.Ｙ",
		out:  "␠.dＯd[～ｓ？*λ＊\x1c␜(θοC#\"ζω\r␘‛␀␈：Ｉ.Ｙ",
	}, { // 37
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.dＯd[～ｓ?*λ＊\x1c␜(θοC#\"ζω\r␘␀␈：Ｉ.Ｙ",
		out:  "‛␠.dＯd[～ｓ？*λ＊\x1c␜(θοC#\"ζω\r␘‛␀␈：Ｉ.Ｙ",
	}, { // 38
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␈.dＯd[～ｓ?*λ＊\x1c␜(θοC#\"ζω\r␘␀␈：Ｉ. ",
		out:  "␈.dＯd[～ｓ？*λ＊\x1c␜(θοC#\"ζω\r␘‛␀␈：Ｉ. ",
	}, { // 39
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␈.dＯd[～ｓ?*λ＊\x1c␜(θοC#\"ζω\r␘␀␈：Ｉ.␠",
		out:  "␈.dＯd[～ｓ？*λ＊\x1c␜(θοC#\"ζω\r␘‛␀␈：Ｉ.␠",
	}, { // 40
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .%<ρtｗpωＢD␍？γ\x1fc\x06ρＡρD1Ｘ␐ι␗␘３.\x16",
		out:  "␠.%<ρtｗpωＢD␍？γ\x1fc\x06ρＡρD1Ｘ␐ι␗␘３.\x16",
	}, { // 41
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.%<ρtｗpωＢD␍？γ\x1fc\x06ρＡρD1Ｘ␐ι␗␘３.\x16",
		out:  "‛␠.%<ρtｗpωＢD␍？γ\x1fc\x06ρＡρD1Ｘ␐ι␗␘３.\x16",
	}, { // 42
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "｝.%<ρtｗpωＢD␍？γ\x1fc\x06ρＡρD1Ｘ␐ι␗␘３. ",
		out:  "｝.%<ρtｗpωＢD␍？γ\x1fc\x06ρＡρD1Ｘ␐ι␗␘３. ",
	}, { // 43
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "｝.%<ρtｗpωＢD␍？γ\x1fc\x06ρＡρD1Ｘ␐ι␗␘３.␠",
		out:  "｝.%<ρtｗpωＢD␍？γ\x1fc\x06ρＡρD1Ｘ␐ι␗␘３.␠",
	}, { // 44
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .\x15τψ\x033＜λI␗Ｖ\x10ρe␕Ｆiυ\n␗．␍１fθ｀ .ｖ",
		out:  "␠.\x15τψ\x033＜λI␗Ｖ\x10ρe␕Ｆiυ\n␗．␍１fθ｀ .ｖ",
	}, { // 45
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.\x15τψ\x033＜λI␗Ｖ\x10ρe␕Ｆiυ\n␗．␍１fθ｀ .ｖ",
		out:  "‛␠.\x15τψ\x033＜λI␗Ｖ\x10ρe␕Ｆiυ\n␗．␍１fθ｀ .ｖ",
	}, { // 46
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x04.\x15τψ\x033＜λI␗Ｖ\x10ρe␕Ｆiυ\n␗．␍１fθ｀ . ",
		out:  "\x04.\x15τψ\x033＜λI␗Ｖ\x10ρe␕Ｆiυ\n␗．␍１fθ｀ . ",
	}, { // 47
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x04.\x15τψ\x033＜λI␗Ｖ\x10ρe␕Ｆiυ\n␗．␍１fθ｀ .␠",
		out:  "\x04.\x15τψ\x033＜λI␗Ｖ\x10ρe␕Ｆiυ\n␗．␍１fθ｀ .␠",
	}, { // 48
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .οＧψ｀?\fmｔ~ｂ␑␁xρ␇τ␡b␞\x04＄Ｔjh\x1a\x12.\x02",
		out:  "␠.οＧψ｀?\fmｔ~ｂ␑␁xρ␇τ␡b␞\x04＄Ｔjh\x1a\x12.\x02",
	}, { // 49
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.οＧψ｀?\fmｔ~ｂ␑␁xρ␇τ␡b␞\x04＄Ｔjh\x1a\x12.\x02",
		out:  "‛␠.οＧψ｀?\fmｔ~ｂ␑␁xρ␇τ␡b␞\x04＄Ｔjh\x1a\x12.\x02",
	}, { // 50
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "＜.οＧψ｀?\fmｔ~ｂ␑␁xρ␇τ␡b␞\x04＄Ｔjh\x1a\x12. ",
		out:  "＜.οＧψ｀?\fmｔ~ｂ␑␁xρ␇τ␡b␞\x04＄Ｔjh\x1a\x12. ",
	}, { // 51
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "＜.οＧψ｀?\fmｔ~ｂ␑␁xρ␇τ␡b␞\x04＄Ｔjh\x1a\x12.␠",
		out:  "＜.οＧψ｀?\fmｔ~ｂ␑␁xρ␇τ␡b␞\x04＄Ｔjh\x1a\x12.␠",
	}, { // 52
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .␂␜␘/Ｔψφ\t\x05A－␅ιQＫg:P＃οｘ␄πδ\x064.\b",
		out:  "␠.␂␜␘/Ｔψφ\t\x05A－␅ιQＫg:P＃οｘ␄πδ\x064.\b",
	}, { // 53
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.␂␜␘/Ｔψφ\t\x05A－␅ιQＫg:P＃οｘ␄πδ\x064.\b",
		out:  "‛␠.␂␜␘/Ｔψφ\t\x05A－␅ιQＫg:P＃οｘ␄πδ\x064.\b",
	}, { // 54
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "６.␂␜␘/Ｔψφ\t\x05A－␅ιQＫg:P＃οｘ␄πδ\x064. ",
		out:  "６.␂␜␘/Ｔψφ\t\x05A－␅ιQＫg:P＃οｘ␄πδ\x064. ",
	}, { // 55
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "６.␂␜␘/Ｔψφ\t\x05A－␅ιQＫg:P＃οｘ␄πδ\x064.␠",
		out:  "６.␂␜␘/Ｔψφ\t\x05A－␅ιQＫg:P＃οｘ␄πδ\x064.␠",
	}, { // 56
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .］\u007f␄g␑8*／３９\x16N：λvψγ\x02*ρ/$\x16θ（κ.＃",
		out:  "␠.］\u007f␄g␑8*／３９\x16N：λvψγ\x02*ρ/$\x16θ（κ.＃",
	}, { // 57
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.］\u007f␄g␑8*／３９\x16N：λvψγ\x02*ρ/$\x16θ（κ.＃",
		out:  "‛␠.］\u007f␄g␑8*／３９\x16N：λvψγ\x02*ρ/$\x16θ（κ.＃",
	}, { // 58
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "９.］\u007f␄g␑8*／３９\x16N：λvψγ\x02*ρ/$\x16θ（κ. ",
		out:  "９.］\u007f␄g␑8*／３９\x16N：λvψγ\x02*ρ/$\x16θ（κ. ",
	}, { // 59
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "９.］\u007f␄g␑8*／３９\x16N：λvψγ\x02*ρ/$\x16θ（κ.␠",
		out:  "９.］\u007f␄g␑8*／３９\x16N：λvψγ\x02*ρ/$\x16θ（κ.␠",
	}, { // 60
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .\x17υi\x13＇?＂Z)β\x1aζ\x12＄␙ｋＴ！%'␞\x12λ＼ｕλ.ς",
		out:  "␠.\x17υi\x13＇?＂Z)β\x1aζ\x12＄␙ｋＴ！%'␞\x12λ＼ｕλ.ς",
	}, { // 61
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.\x17υi\x13＇?＂Z)β\x1aζ\x12＄␙ｋＴ！%'␞\x12λ＼ｕλ.ς",
		out:  "‛␠.\x17υi\x13＇?＂Z)β\x1aζ\x12＄␙ｋＴ！%'␞\x12λ＼ｕλ.ς",
	}, { // 62
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "ｃ.\x17υi\x13＇?＂Z)β\x1aζ\x12＄␙ｋＴ！%'␞\x12λ＼ｕλ. ",
		out:  "ｃ.\x17υi\x13＇?＂Z)β\x1aζ\x12＄␙ｋＴ！%'␞\x12λ＼ｕλ. ",
	}, { // 63
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "ｃ.\x17υi\x13＇?＂Z)β\x1aζ\x12＄␙ｋＴ！%'␞\x12λ＼ｕλ.␠",
		out:  "ｃ.\x17υi\x13＇?＂Z)β\x1aζ\x12＄␙ｋＴ！%'␞\x12λ＼ｕλ.␠",
	}, { // 64
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .／ｄ6０Ehｉhρ\n\x02␙χ)\x0e␔cυ␊οτ）＋ｐο␋.␞",
		out:  "␠.／ｄ6０Ehｉhρ\n\x02␙χ)\x0e␔cυ␊οτ）＋ｐο␋.␞",
	}, { // 65
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.／ｄ6０Ehｉhρ\n\x02␙χ)\x0e␔cυ␊οτ）＋ｐο␋.␞",
		out:  "‛␠.／ｄ6０Ehｉhρ\n\x02␙χ)\x0e␔cυ␊οτ）＋ｐο␋.␞",
	}, { // 66
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "?.／ｄ6０Ehｉhρ\n\x02␙χ)\x0e␔cυ␊οτ）＋ｐο␋. ",
		out:  "?.／ｄ6０Ehｉhρ\n\x02␙χ)\x0e␔cυ␊οτ）＋ｐο␋. ",
	}, { // 67
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "?.／ｄ6０Ehｉhρ\n\x02␙χ)\x0e␔cυ␊οτ）＋ｐο␋.␠",
		out:  "?.／ｄ6０Ehｉhρ\n\x02␙χ)\x0e␔cυ␊οτ）＋ｐο␋.␠",
	}, { // 68
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .oπ#␁␞Ｘ８ＯωNq\x17@κ]vκ２λ\x13'␆␆＃Mθ.␄",
		out:  "␠.oπ#‛␁‛␞Ｘ８ＯωNq␗@κ]vκ２λ␓'‛␆‛␆＃Mθ.‛␄",
	}, { // 69
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.oπ#␁␞Ｘ８ＯωNq\x17@κ]vκ２λ\x13'␆␆＃Mθ.␄",
		out:  "‛␠.oπ#‛␁‛␞Ｘ８ＯωNq␗@κ]vκ２λ␓'‛␆‛␆＃Mθ.‛␄",
	}, { // 70
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\\.oπ#␁␞Ｘ８ＯωNq\x17@κ]vκ２λ\x13'␆␆＃Mθ. ",
		out:  "\\.oπ#‛␁‛␞Ｘ８ＯωNq␗@κ]vκ２λ␓'‛␆‛␆＃Mθ. ",
	}, { // 71
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\\.oπ#␁␞Ｘ８ＯωNq\x17@κ]vκ２λ\x13'␆␆＃Mθ.␠",
		out:  "\\.oπ#‛␁‛␞Ｘ８ＯωNq␗@κ]vκ２λ␓'‛␆‛␆＃Mθ.␠",
	}, { // 72
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~μ␂␓␀_\tT３J\x14\x1cφｆ）E＂`␚υ␂y\x11γ/`？~χ",
		out:  "␠~μ␂␓‛␀_\tT３J\x14\x1cφｆ）E＂`␚υ␂y\x11γ/`？~χ",
	}, { // 73
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~μ␂␓␀_\tT３J\x14\x1cφｆ）E＂`␚υ␂y\x11γ/`？~χ",
		out:  "‛␠~μ␂␓‛␀_\tT３J\x14\x1cφｆ）E＂`␚υ␂y\x11γ/`？~χ",
	}, { // 74
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ｗ~μ␂␓␀_\tT３J\x14\x1cφｆ）E＂`␚υ␂y\x11γ/`？~ ",
		out:  "Ｗ~μ␂␓‛␀_\tT３J\x14\x1cφｆ）E＂`␚υ␂y\x11γ/`？~ ",
	}, { // 75
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ｗ~μ␂␓␀_\tT３J\x14\x1cφｆ）E＂`␚υ␂y\x11γ/`？~␠",
		out:  "Ｗ~μ␂␓‛␀_\tT３J\x14\x1cφｆ）E＂`␚υ␂y\x11γ/`？~␠",
	}, { // 76
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~θG\x14\v␁δ␊[T␍．χ\uff00δ␄νe␆\x16ｎ％?η（'９~\a",
		out:  "␠~θG\x14\v␁δ␊[T␍．χ\uff00δ␄νe␆\x16ｎ％?η（'９~\a",
	}, { // 77
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~θG\x14\v␁δ␊[T␍．χ\uff00δ␄νe␆\x16ｎ％?η（'９~\a",
		out:  "‛␠~θG\x14\v␁δ␊[T␍．χ\uff00δ␄νe␆\x16ｎ％?η（'９~\a",
	}, { // 78
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "u~θG\x14\v␁δ␊[T␍．χ\uff00δ␄νe␆\x16ｎ％?η（'９~ ",
		out:  "u~θG\x14\v␁δ␊[T␍．χ\uff00δ␄νe␆\x16ｎ％?η（'９~ ",
	}, { // 79
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "u~θG\x14\v␁δ␊[T␍．χ\uff00δ␄νe␆\x16ｎ％?η（'９~␠",
		out:  "u~θG\x14\v␁δ␊[T␍．χ\uff00δ␄νe␆\x16ｎ％?η（'９~␠",
	}, { // 80
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~a＇␑|Bβ\x17\x1bν\x1d\x1cS＊Ｈη␍／;υυＨ％Ｆ␞$/~：",
		out:  "␠~a‛＇␑|Bβ\x17\x1bν\x1d\x1cS＊Ｈη␍／;υυＨ％Ｆ␞$/~：",
	}, { // 81
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~a＇␑|Bβ\x17\x1bν\x1d\x1cS＊Ｈη␍／;υυＨ％Ｆ␞$/~：",
		out:  "‛␠~a‛＇␑|Bβ\x17\x1bν\x1d\x1cS＊Ｈη␍／;υυＨ％Ｆ␞$/~：",
	}, { // 82
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "η~a＇␑|Bβ\x17\x1bν\x1d\x1cS＊Ｈη␍／;υυＨ％Ｆ␞$/~ ",
		out:  "η~a‛＇␑|Bβ\x17\x1bν\x1d\x1cS＊Ｈη␍／;υυＨ％Ｆ␞$/~ ",
	}, { // 83
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "η~a＇␑|Bβ\x17\x1bν\x1d\x1cS＊Ｈη␍／;υυＨ％Ｆ␞$/~␠",
		out:  "η~a‛＇␑|Bβ\x17\x1bν\x1d\x1cS＊Ｈη␍／;υυＨ％Ｆ␞$/~␠",
	}, { // 84
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~?jρＪκ␡␜Xφrφ␒␘γｒ;δ␏!３\n\x1e／%N\x15~Ｐ",
		out:  "␠~?jρＪκ␡␜Xφrφ␒␘γｒ;δ␏!３\n\x1e／%N\x15~Ｐ",
	}, { // 85
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~?jρＪκ␡␜Xφrφ␒␘γｒ;δ␏!３\n\x1e／%N\x15~Ｐ",
		out:  "‛␠~?jρＪκ␡␜Xφrφ␒␘γｒ;δ␏!３\n\x1e／%N\x15~Ｐ",
	}, { // 86
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ｍ~?jρＪκ␡␜Xφrφ␒␘γｒ;δ␏!３\n\x1e／%N\x15~ ",
		out:  "Ｍ~?jρＪκ␡␜Xφrφ␒␘γｒ;δ␏!３\n\x1e／%N\x15~ ",
	}, { // 87
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ｍ~?jρＪκ␡␜Xφrφ␒␘γｒ;δ␏!３\n\x1e／%N\x15~␠",
		out:  "Ｍ~?jρＪκ␡␜Xφrφ␒␘γｒ;δ␏!３\n\x1e／%N\x15~␠",
	}, { // 88
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~）_U?κξ␛\x02Xεr＼'\f?$＇ζｏ\v␇ν／ｆ＝%~Ａ",
		out:  "␠~）_U?κξ␛\x02Xεr＼'\f?$＇ζｏ\v␇ν／ｆ＝%~Ａ",
	}, { // 89
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~）_U?κξ␛\x02Xεr＼'\f?$＇ζｏ\v␇ν／ｆ＝%~Ａ",
		out:  "‛␠~）_U?κξ␛\x02Xεr＼'\f?$＇ζｏ\v␇ν／ｆ＝%~Ａ",
	}, { // 90
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ｋ~）_U?κξ␛\x02Xεr＼'\f?$＇ζｏ\v␇ν／ｆ＝%~ ",
		out:  "Ｋ~）_U?κξ␛\x02Xεr＼'\f?$＇ζｏ\v␇ν／ｆ＝%~ ",
	}, { // 91
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ｋ~）_U?κξ␛\x02Xεr＼'\f?$＇ζｏ\v␇ν／ｆ＝%~␠",
		out:  "Ｋ~）_U?κξ␛\x02Xεr＼'\f?$＇ζｏ\v␇ν／ｆ＝%~␠",
	}, { // 92
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~\x19␅'␇ＬｂpQγ␛Mmημ␛␍%βδ\x16\u007f␎θaｈ＃~\f",
		out:  "␠~\x19␅'␇ＬｂpQγ␛Mmημ␛␍%βδ\x16\u007f␎θaｈ＃~\f",
	}, { // 93
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~\x19␅'␇ＬｂpQγ␛Mmημ␛␍%βδ\x16\u007f␎θaｈ＃~\f",
		out:  "‛␠~\x19␅'␇ＬｂpQγ␛Mmημ␛␍%βδ\x16\u007f␎θaｈ＃~\f",
	}, { // 94
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftTilde,
		in:   "\x16~\x19␅'␇ＬｂpQγ␛Mmημ␛␍%βδ\x16\u007f␎θaｈ＃~ ",
		out:  "\x16~\x19␅'␇ＬｂpQγ␛Mmημ␛␍%βδ\x16\u007f␎θaｈ＃~ ",
	}, { // 95
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftTilde,
		in:   "\x16~\x19␅'␇ＬｂpQγ␛Mmημ␛␍%βδ\x16\u007f␎θaｈ＃~␠",
		out:  "\x16~\x19␅'␇ＬｂpQγ␛Mmημ␛␍%βδ\x16\u007f␎θaｈ＃~␠",
	}, { // 96
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~\x04ω＄P）ｓ␍z\x14ξＳ：＊␘ｄβ\x1f\x11ＸhαB|␍i\x03~N",
		out:  "␠~\x04ω‛＄P）ｓ␍z\x14ξＳ：＊␘ｄβ\x1f\x11ＸhαB|␍i\x03~N",
	}, { // 97
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~\x04ω＄P）ｓ␍z\x14ξＳ：＊␘ｄβ\x1f\x11ＸhαB|␍i\x03~N",
		out:  "‛␠~\x04ω‛＄P）ｓ␍z\x14ξＳ：＊␘ｄβ\x1f\x11ＸhαB|␍i\x03~N",
	}, { // 98
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ι~\x04ω＄P）ｓ␍z\x14ξＳ：＊␘ｄβ\x1f\x11ＸhαB|␍i\x03~ ",
		out:  "ι~\x04ω‛＄P）ｓ␍z\x14ξＳ：＊␘ｄβ\x1f\x11ＸhαB|␍i\x03~ ",
	}, { // 99
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ι~\x04ω＄P）ｓ␍z\x14ξＳ：＊␘ｄβ\x1f\x11ＸhαB|␍i\x03~␠",
		out:  "ι~\x04ω‛＄P）ｓ␍z\x14ξＳ：＊␘ｄβ\x1f\x11ＸhαB|␍i\x03~␠",
	}, { // 100
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~ζβ+`，．οκ\x13␄␕␊＂Ｏ␓␅ａ\x1ao\x11α$υｙ\ry~Ｍ",
		out:  "␠~ζβ+`，．οκ\x13␄␕␊‛＂Ｏ␓␅ａ\x1ao\x11α$υｙ\ry~Ｍ",
	}, { // 101
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~ζβ+`，．οκ\x13␄␕␊＂Ｏ␓␅ａ\x1ao\x11α$υｙ\ry~Ｍ",
		out:  "‛␠~ζβ+`，．οκ\x13␄␕␊‛＂Ｏ␓␅ａ\x1ao\x11α$υｙ\ry~Ｍ",
	}, { // 102
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "b~ζβ+`，．οκ\x13␄␕␊＂Ｏ␓␅ａ\x1ao\x11α$υｙ\ry~ ",
		out:  "b~ζβ+`，．οκ\x13␄␕␊‛＂Ｏ␓␅ａ\x1ao\x11α$υｙ\ry~ ",
	}, { // 103
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "b~ζβ+`，．οκ\x13␄␕␊＂Ｏ␓␅ａ\x1ao\x11α$υｙ\ry~␠",
		out:  "b~ζβ+`，．οκ\x13␄␕␊‛＂Ｏ␓␅ａ\x1ao\x11α$υｙ\ry~␠",
	}, { // 104
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~d␕Ｔ\t␜`␛λ\r\x0eγkX\x16\x14Ｗ％４ε＇#｜θAｐ%~ρ",
		out:  "␠~d␕Ｔ\t␜`␛λ\r\x0eγkX\x16\x14Ｗ％４ε＇#｜θAｐ%~ρ",
	}, { // 105
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~d␕Ｔ\t␜`␛λ\r\x0eγkX\x16\x14Ｗ％４ε＇#｜θAｐ%~ρ",
		out:  "‛␠~d␕Ｔ\t␜`␛λ\r\x0eγkX\x16\x14Ｗ％４ε＇#｜θAｐ%~ρ",
	}, { // 106
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␏~d␕Ｔ\t␜`␛λ\r\x0eγkX\x16\x14Ｗ％４ε＇#｜θAｐ%~ ",
		out:  "␏~d␕Ｔ\t␜`␛λ\r\x0eγkX\x16\x14Ｗ％４ε＇#｜θAｐ%~ ",
	}, { // 107
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␏~d␕Ｔ\t␜`␛λ\r\x0eγkX\x16\x14Ｗ％４ε＇#｜θAｐ%~␠",
		out:  "␏~d␕Ｔ\t␜`␛λ\r\x0eγkX\x16\x14Ｗ％４ε＇#｜θAｐ%~␠",
	}, { // 108
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~␆\n＃α＃\x19\x10\x16／υ＝＄οＱςη８-␔pξM/\x12\n␕~u",
		out:  "␠~␆\n＃α＃\x19\x10\x16／υ＝＄οＱςη８-␔pξM/\x12\n␕~u",
	}, { // 109
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~␆\n＃α＃\x19\x10\x16／υ＝＄οＱςη８-␔pξM/\x12\n␕~u",
		out:  "‛␠~␆\n＃α＃\x19\x10\x16／υ＝＄οＱςη８-␔pξM/\x12\n␕~u",
	}, { // 110
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␘~␆\n＃α＃\x19\x10\x16／υ＝＄οＱςη８-␔pξM/\x12\n␕~ ",
		out:  "␘~␆\n＃α＃\x19\x10\x16／υ＝＄οＱςη８-␔pξM/\x12\n␕~ ",
	}, { // 111
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␘~␆\n＃α＃\x19\x10\x16／υ＝＄οＱςη８-␔pξM/\x12\n␕~␠",
		out:  "␘~␆\n＃α＃\x19\x10\x16／υ＝＄οＱςη８-␔pξM/\x12\n␕~␠",
	}, { // 112
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~\x03Ｅ\aC［f␓)ψ|ａｕＷ？ιｇ\x06οQρ*π＄`␡？~)",
		out:  "␠~\x03Ｅ\aC［f␓)ψ|ａｕＷ？ιｇ\x06οQρ＊π＄`␡？~)",
	}, { // 113
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~\x03Ｅ\aC［f␓)ψ|ａｕＷ？ιｇ\x06οQρ*π＄`␡？~)",
		out:  "‛␠~\x03Ｅ\aC［f␓)ψ|ａｕＷ？ιｇ\x06οQρ＊π＄`␡？~)",
	}, { // 114
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ν~\x03Ｅ\aC［f␓)ψ|ａｕＷ？ιｇ\x06οQρ*π＄`␡？~ ",
		out:  "ν~\x03Ｅ\aC［f␓)ψ|ａｕＷ？ιｇ\x06οQρ＊π＄`␡？~ ",
	}, { // 115
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ν~\x03Ｅ\aC［f␓)ψ|ａｕＷ？ιｇ\x06οQρ*π＄`␡？~␠",
		out:  "ν~\x03Ｅ\aC［f␓)ψ|ａｕＷ？ιｇ\x06οQρ＊π＄`␡？~␠",
	}, { // 116
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~Ｃ␇ｓ＼＜\x0eα/\x04\x1a?＠\x1d/Z#φK␁9υγ］Ｗπι~］",
		out:  "␠~Ｃ␇ｓ＼＜\x0eα/\x04\x1a?＠\x1d/Z#φK␁9υγ］Ｗπι~］",
	}, { // 117
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~Ｃ␇ｓ＼＜\x0eα/\x04\x1a?＠\x1d/Z#φK␁9υγ］Ｗπι~］",
		out:  "‛␠~Ｃ␇ｓ＼＜\x0eα/\x04\x1a?＠\x1d/Z#φK␁9υγ］Ｗπι~］",
	}, { // 118
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ｓ~Ｃ␇ｓ＼＜\x0eα/\x04\x1a?＠\x1d/Z#φK␁9υγ］Ｗπι~ ",
		out:  "ｓ~Ｃ␇ｓ＼＜\x0eα/\x04\x1a?＠\x1d/Z#φK␁9υγ］Ｗπι~ ",
	}, { // 119
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ｓ~Ｃ␇ｓ＼＜\x0eα/\x04\x1a?＠\x1d/Z#φK␁9υγ］Ｗπι~␠",
		out:  "ｓ~Ｃ␇ｓ＼＜\x0eα/\x04\x1a?＠\x1d/Z#φK␁9υγ］Ｗπι~␠",
	}, { // 120
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~ψ\r␛ＡHv７θ#ν␜Ａ\nκＦ␇Ｗ\x1eλο\fｍ1u\x10␊~＼",
		out:  "␠~ψ\r␛ＡHv７θ＃ν␜Ａ\nκＦ␇Ｗ\x1eλο\fｍ1u\x10␊~＼",
	}, { // 121
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~ψ\r␛ＡHv７θ#ν␜Ａ\nκＦ␇Ｗ\x1eλο\fｍ1u\x10␊~＼",
		out:  "‛␠~ψ\r␛ＡHv７θ＃ν␜Ａ\nκＦ␇Ｗ\x1eλο\fｍ1u\x10␊~＼",
	}, { // 122
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "L~ψ\r␛ＡHv７θ#ν␜Ａ\nκＦ␇Ｗ\x1eλο\fｍ1u\x10␊~ ",
		out:  "L~ψ\r␛ＡHv７θ＃ν␜Ａ\nκＦ␇Ｗ\x1eλο\fｍ1u\x10␊~ ",
	}, { // 123
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "L~ψ\r␛ＡHv７θ#ν␜Ａ\nκＦ␇Ｗ\x1eλο\fｍ1u\x10␊~␠",
		out:  "L~ψ\r␛ＡHv７θ＃ν␜Ａ\nκＦ␇Ｗ\x1eλο\fｍ1u\x10␊~␠",
	}, { // 124
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~τε？$:␍a＂\x14R5[␜␅＄σｈ；Z␆?ｓＩζ\x16ρ~\x14",
		out:  "␠~τε？$:␍a＂\x14R5[␜␅＄σｈ；Z␆?ｓＩζ\x16ρ~\x14",
	}, { // 125
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~τε？$:␍a＂\x14R5[␜␅＄σｈ；Z␆?ｓＩζ\x16ρ~\x14",
		out:  "‛␠~τε？$:␍a＂\x14R5[␜␅＄σｈ；Z␆?ｓＩζ\x16ρ~\x14",
	}, { // 126
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftTilde,
		in:   "\x06~τε？$:␍a＂\x14R5[␜␅＄σｈ；Z␆?ｓＩζ\x16ρ~ ",
		out:  "\x06~τε？$:␍a＂\x14R5[␜␅＄σｈ；Z␆?ｓＩζ\x16ρ~ ",
	}, { // 127
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftTilde,
		in:   "\x06~τε？$:␍a＂\x14R5[␜␅＄σｈ；Z␆?ｓＩζ\x16ρ~␠",
		out:  "\x06~τε？$:␍a＂\x14R5[␜␅＄σｈ；Z␆?ｓＩζ\x16ρ~␠",
	}, { // 128
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~ς␄ＭO␔Ｊ］｝％␖μ?＃σ\x0f␇,C]χＷ'%ς*_~β",
		out:  "␠~ς␄ＭO␔Ｊ］｝％␖μ?＃σ\x0f␇,C]χＷ'%ς*_~β",
	}, { // 129
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~ς␄ＭO␔Ｊ］｝％␖μ?＃σ\x0f␇,C]χＷ'%ς*_~β",
		out:  "‛␠~ς␄ＭO␔Ｊ］｝％␖μ?＃σ\x0f␇,C]χＷ'%ς*_~β",
	}, { // 130
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "H~ς␄ＭO␔Ｊ］｝％␖μ?＃σ\x0f␇,C]χＷ'%ς*_~ ",
		out:  "H~ς␄ＭO␔Ｊ］｝％␖μ?＃σ\x0f␇,C]χＷ'%ς*_~ ",
	}, { // 131
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "H~ς␄ＭO␔Ｊ］｝％␖μ?＃σ\x0f␇,C]χＷ'%ς*_~␠",
		out:  "H~ς␄ＭO␔Ｊ］｝％␖μ?＃σ\x0f␇,C]χＷ'%ς*_~␠",
	}, { // 132
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~\\ｍς/␖δυ\nP␍ｓ(\x13\x0e\x17␓␍β／＜Ｄ/ω+OＸ~ο",
		out:  "␠~\\ｍς/␖δυ␊P‛␍ｓ(\x13\x0e\x17␓‛␍β／＜Ｄ/ω+OＸ~ο",
	}, { // 133
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~\\ｍς/␖δυ\nP␍ｓ(\x13\x0e\x17␓␍β／＜Ｄ/ω+OＸ~ο",
		out:  "‛␠~\\ｍς/␖δυ␊P‛␍ｓ(\x13\x0e\x17␓‛␍β／＜Ｄ/ω+OＸ~ο",
	}, { // 134
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ｕ~\\ｍς/␖δυ\nP␍ｓ(\x13\x0e\x17␓␍β／＜Ｄ/ω+OＸ~ ",
		out:  "Ｕ~\\ｍς/␖δυ␊P‛␍ｓ(\x13\x0e\x17␓‛␍β／＜Ｄ/ω+OＸ~ ",
	}, { // 135
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ｕ~\\ｍς/␖δυ\nP␍ｓ(\x13\x0e\x17␓␍β／＜Ｄ/ω+OＸ~␠",
		out:  "Ｕ~\\ｍς/␖δυ␊P‛␍ｓ(\x13\x0e\x17␓‛␍β／＜Ｄ/ω+OＸ~␠",
	}, { // 136
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~u␖γl９\x03\x10．[␁ｐη'␁ｈ\"γεＮb␜\x04β%n␗~｝",
		out:  "␠~u␖γl９\x03\x10．[␁ｐη'␁ｈ\"γεＮb␜\x04β%n␗~｝",
	}, { // 137
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~u␖γl９\x03\x10．[␁ｐη'␁ｈ\"γεＮb␜\x04β%n␗~｝",
		out:  "‛␠~u␖γl９\x03\x10．[␁ｐη'␁ｈ\"γεＮb␜\x04β%n␗~｝",
	}, { // 138
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftTilde,
		in:   "：~u␖γl９\x03\x10．[␁ｐη'␁ｈ\"γεＮb␜\x04β%n␗~ ",
		out:  "：~u␖γl９\x03\x10．[␁ｐη'␁ｈ\"γεＮb␜\x04β%n␗~ ",
	}, { // 139
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftTilde,
		in:   "：~u␖γl９\x03\x10．[␁ｐη'␁ｈ\"γεＮb␜\x04β%n␗~␠",
		out:  "：~u␖γl９\x03\x10．[␁ｐη'␁ｈ\"γεＮb␜\x04β%n␗~␠",
	}, { // 140
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~\x12＄(␝ρ|ο␌＾６＞m␈<σν＊\v＃-uoαＴ\x1e\b~λ",
		out:  "␠~␒＄(‛␝ρ|ο‛␌＾６＞m‛␈<σν＊␋＃-uoαＴ␞␈~λ",
	}, { // 141
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~\x12＄(␝ρ|ο␌＾６＞m␈<σν＊\v＃-uoαＴ\x1e\b~λ",
		out:  "‛␠~␒＄(‛␝ρ|ο‛␌＾６＞m‛␈<σν＊␋＃-uoαＴ␞␈~λ",
	}, { // 142
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftTilde,
		in:   "＄~\x12＄(␝ρ|ο␌＾６＞m␈<σν＊\v＃-uoαＴ\x1e\b~ ",
		out:  "＄~␒＄(‛␝ρ|ο‛␌＾６＞m‛␈<σν＊␋＃-uoαＴ␞␈~ ",
	}, { // 143
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftTilde,
		in:   "＄~\x12＄(␝ρ|ο␌＾６＞m␈<σν＊\v＃-uoαＴ\x1e\b~␠",
		out:  "＄~␒＄(‛␝ρ|ο‛␌＾６＞m‛␈<σν＊␋＃-uoαＴ␞␈~␠",
	}, { // 144
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\tc",
		out:  "␠\t$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\tc",
	}, { // 145
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\tc",
		out:  "‛␠\t$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\tc",
	}, { // 146
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\nc",
		out:  "␠\n$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\nc",
	}, { // 147
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\nc",
		out:  "‛␠\n$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\nc",
	}, { // 148
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\vc",
		out:  "␠\v$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\vc",
	}, { // 149
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\vc",
		out:  "‛␠\v$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\vc",
	}, { // 150
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\rc",
		out:  "␠\r$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\rc",
	}, { // 151
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\rc",
		out:  "‛␠\r$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\rc",
	}, { // 152
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "９\t$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\t ",
		out:  "９\t$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\t ",
	}, { // 153
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "９\t$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\t␠",
		out:  "９\t$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\t␠",
	}, { // 154
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "９\n$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\n ",
		out:  "９\n$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\n ",
	}, { // 155
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "９\n$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\n␠",
		out:  "９\n$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\n␠",
	}, { // 156
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "９\v$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\v ",
		out:  "９\v$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\v ",
	}, { // 157
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "９\v$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\v␠",
		out:  "９\v$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\v␠",
	}, { // 158
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "９\r$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\r ",
		out:  "９\r$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\r ",
	}, { // 159
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "９\r$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\r␠",
		out:  "９\r$８\x12/\x1b␡＊εθ＇\x01r\u007f］＆cｓ0␊＼λβ!␆ι␇\r␠",
	}, { // 160
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\t␃",
		out:  "␠\t'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\t␃",
	}, { // 161
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\t␃",
		out:  "‛␠\t'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\t␃",
	}, { // 162
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\n␃",
		out:  "␠\n'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\n␃",
	}, { // 163
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\n␃",
		out:  "‛␠\n'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\n␃",
	}, { // 164
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\v␃",
		out:  "␠\v'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\v␃",
	}, { // 165
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\v␃",
		out:  "‛␠\v'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\v␃",
	}, { // 166
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\r␃",
		out:  "␠\r'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\r␃",
	}, { // 167
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\r␃",
		out:  "‛␠\r'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\r␃",
	}, { // 168
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "λ\t'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\t ",
		out:  "λ\t'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\t ",
	}, { // 169
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "λ\t'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\t␠",
		out:  "λ\t'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\t␠",
	}, { // 170
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "λ\n'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\n ",
		out:  "λ\n'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\n ",
	}, { // 171
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "λ\n'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\n␠",
		out:  "λ\n'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\n␠",
	}, { // 172
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "λ\v'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\v ",
		out:  "λ\v'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\v ",
	}, { // 173
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "λ\v'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\v␠",
		out:  "λ\v'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\v␠",
	}, { // 174
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "λ\r'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\r ",
		out:  "λ\r'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\r ",
	}, { // 175
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "λ\r'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\r␠",
		out:  "λ\r'Ｈ␍*;λＵ␒？1\x02υ\x11σ␕\x01R＄ｂd-υＪ\v．ο\r␠",
	}, { // 176
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R'\b\tS",
		out:  "␠\tＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R＇\b\tS",
	}, { // 177
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R'\b\tS",
		out:  "‛␠\tＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R＇\b\tS",
	}, { // 178
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R'\b\nS",
		out:  "␠\nＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R＇\b\nS",
	}, { // 179
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R'\b\nS",
		out:  "‛␠\nＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R＇\b\nS",
	}, { // 180
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R'\b\vS",
		out:  "␠\vＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R＇\b\vS",
	}, { // 181
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R'\b\vS",
		out:  "‛␠\vＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R＇\b\vS",
	}, { // 182
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R'\b\rS",
		out:  "␠\rＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R＇\b\rS",
	}, { // 183
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R'\b\rS",
		out:  "‛␠\rＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R＇\b\rS",
	}, { // 184
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␍\tＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R'\b\t ",
		out:  "‛␍\tＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R＇\b\t ",
	}, { // 185
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␍\tＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R'\b\t␠",
		out:  "‛␍\tＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R＇\b\t␠",
	}, { // 186
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␍\nＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R'\b\n ",
		out:  "‛␍\nＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R＇\b\n ",
	}, { // 187
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␍\nＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R'\b\n␠",
		out:  "‛␍\nＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R＇\b\n␠",
	}, { // 188
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␍\vＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R'\b\v ",
		out:  "‛␍\vＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R＇\b\v ",
	}, { // 189
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␍\vＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R'\b\v␠",
		out:  "‛␍\vＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R＇\b\v␠",
	}, { // 190
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␍\rＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R'\b\r ",
		out:  "‛␍\rＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R＇\b\r ",
	}, { // 191
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␍\rＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R'\b\r␠",
		out:  "‛␍\rＪqＳｍ␔\n␐\x1bbςＨTｕ＜\x01ηｇ␎［\aφξ<R＇\b\r␠",
	}, { // 192
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\t｛",
		out:  "␠\tQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\t｛",
	}, { // 193
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\t｛",
		out:  "‛␠\tQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\t｛",
	}, { // 194
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\n｛",
		out:  "␠\nQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\n｛",
	}, { // 195
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\n｛",
		out:  "‛␠\nQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\n｛",
	}, { // 196
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\v｛",
		out:  "␠\vQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\v｛",
	}, { // 197
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\v｛",
		out:  "‛␠\vQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\v｛",
	}, { // 198
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\r｛",
		out:  "␠\rQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\r｛",
	}, { // 199
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\r｛",
		out:  "‛␠\rQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\r｛",
	}, { // 200
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "φ\tQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\t ",
		out:  "φ\tQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\t ",
	}, { // 201
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "φ\tQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\t␠",
		out:  "φ\tQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\t␠",
	}, { // 202
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "φ\nQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\n ",
		out:  "φ\nQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\n ",
	}, { // 203
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "φ\nQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\n␠",
		out:  "φ\nQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\n␠",
	}, { // 204
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "φ\vQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\v ",
		out:  "φ\vQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\v ",
	}, { // 205
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "φ\vQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\v␠",
		out:  "φ\vQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\v␠",
	}, { // 206
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "φ\rQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\r ",
		out:  "φ\rQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\r ",
	}, { // 207
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "φ\rQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\r␠",
		out:  "φ\rQ\x1f＜＃αO␑Eφ-Ｎφ␕]Ｉ\rκ\u007fｓs␉κ:％%\x18\r␠",
	}, { // 208
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\t'",
		out:  "␠\tＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\t'",
	}, { // 209
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\t'",
		out:  "‛␠\tＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\t'",
	}, { // 210
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\n'",
		out:  "␠\nＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\n'",
	}, { // 211
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\n'",
		out:  "‛␠\nＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\n'",
	}, { // 212
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\v'",
		out:  "␠\vＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\v'",
	}, { // 213
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\v'",
		out:  "‛␠\vＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\v'",
	}, { // 214
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\r'",
		out:  "␠\rＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\r'",
	}, { // 215
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\r'",
		out:  "‛␠\rＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\r'",
	}, { // 216
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "）\tＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\t ",
		out:  "）\tＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\t ",
	}, { // 217
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "）\tＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\t␠",
		out:  "）\tＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\t␠",
	}, { // 218
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "）\nＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\n ",
		out:  "）\nＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\n ",
	}, { // 219
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "）\nＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\n␠",
		out:  "）\nＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\n␠",
	}, { // 220
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "）\vＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\v ",
		out:  "）\vＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\v ",
	}, { // 221
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "）\vＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\v␠",
		out:  "）\vＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\v␠",
	}, { // 222
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "）\rＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\r ",
		out:  "）\rＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\r ",
	}, { // 223
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "）\rＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\r␠",
		out:  "）\rＰＶｅ%␙ν3\x1eθ＊)=␃！：\x19μ\x01{[η/？␙ξη\r␠",
	}, { // 224
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tχ=αＩν␟\t\x1f! Ｗ０］␘τι␏YTε\r\x0fｚｆＬ｜\t\x02",
		out:  "␠\tχ=αＩν␟\t\x1f! Ｗ０‛］␘τι␏YTε\r\x0fｚｆＬ｜\t\x02",
	}, { // 225
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tχ=αＩν␟\t\x1f! Ｗ０］␘τι␏YTε\r\x0fｚｆＬ｜\t\x02",
		out:  "‛␠\tχ=αＩν␟\t\x1f! Ｗ０‛］␘τι␏YTε\r\x0fｚｆＬ｜\t\x02",
	}, { // 226
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nχ=αＩν␟\t\x1f! Ｗ０］␘τι␏YTε\r\x0fｚｆＬ｜\n\x02",
		out:  "␠\nχ=αＩν␟\t\x1f! Ｗ０‛］␘τι␏YTε\r\x0fｚｆＬ｜\n\x02",
	}, { // 227
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nχ=αＩν␟\t\x1f! Ｗ０］␘τι␏YTε\r\x0fｚｆＬ｜\n\x02",
		out:  "‛␠\nχ=αＩν␟\t\x1f! Ｗ０‛］␘τι␏YTε\r\x0fｚｆＬ｜\n\x02",
	}, { // 228
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vχ=αＩν␟\t\x1f! Ｗ０］␘τι␏YTε\r\x0fｚｆＬ｜\v\x02",
		out:  "␠\vχ=αＩν␟\t\x1f! Ｗ０‛］␘τι␏YTε\r\x0fｚｆＬ｜\v\x02",
	}, { // 229
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vχ=αＩν␟\t\x1f! Ｗ０］␘τι␏YTε\r\x0fｚｆＬ｜\v\x02",
		out:  "‛␠\vχ=αＩν␟\t\x1f! Ｗ０‛］␘τι␏YTε\r\x0fｚｆＬ｜\v\x02",
	}, { // 230
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rχ=αＩν␟\t\x1f! Ｗ０］␘τι␏YTε\r\x0fｚｆＬ｜\r\x02",
		out:  "␠\rχ=αＩν␟\t\x1f! Ｗ０‛］␘τι␏YTε\r\x0fｚｆＬ｜\r\x02",
	}, { // 231
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rχ=αＩν␟\t\x1f! Ｗ０］␘τι␏YTε\r\x0fｚｆＬ｜\r\x02",
		out:  "‛␠\rχ=αＩν␟\t\x1f! Ｗ０‛］␘τι␏YTε\r\x0fｚｆＬ｜\r\x02",
	}, { // 232
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␔\tχ=αＩν␟\t\x1f! Ｗ０］␘τι␏YTε\r\x0fｚｆＬ｜\t ",
		out:  "␔\tχ=αＩν␟\t\x1f! Ｗ０‛］␘τι␏YTε\r\x0fｚｆＬ｜\t ",
	}, { // 233
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␔\tχ=αＩν␟\t\x1f! Ｗ０］␘τι␏YTε\r\x0fｚｆＬ｜\t␠",
		out:  "␔\tχ=αＩν␟\t\x1f! Ｗ０‛］␘τι␏YTε\r\x0fｚｆＬ｜\t␠",
	}, { // 234
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␔\nχ=αＩν␟\t\x1f! Ｗ０］␘τι␏YTε\r\x0fｚｆＬ｜\n ",
		out:  "␔\nχ=αＩν␟\t\x1f! Ｗ０‛］␘τι␏YTε\r\x0fｚｆＬ｜\n ",
	}, { // 235
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␔\nχ=αＩν␟\t\x1f! Ｗ０］␘τι␏YTε\r\x0fｚｆＬ｜\n␠",
		out:  "␔\nχ=αＩν␟\t\x1f! Ｗ０‛］␘τι␏YTε\r\x0fｚｆＬ｜\n␠",
	}, { // 236
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␔\vχ=αＩν␟\t\x1f! Ｗ０］␘τι␏YTε\r\x0fｚｆＬ｜\v ",
		out:  "␔\vχ=αＩν␟\t\x1f! Ｗ０‛］␘τι␏YTε\r\x0fｚｆＬ｜\v ",
	}, { // 237
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␔\vχ=αＩν␟\t\x1f! Ｗ０］␘τι␏YTε\r\x0fｚｆＬ｜\v␠",
		out:  "␔\vχ=αＩν␟\t\x1f! Ｗ０‛］␘τι␏YTε\r\x0fｚｆＬ｜\v␠",
	}, { // 238
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␔\rχ=αＩν␟\t\x1f! Ｗ０］␘τι␏YTε\r\x0fｚｆＬ｜\r ",
		out:  "␔\rχ=αＩν␟\t\x1f! Ｗ０‛］␘τι␏YTε\r\x0fｚｆＬ｜\r ",
	}, { // 239
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␔\rχ=αＩν␟\t\x1f! Ｗ０］␘τι␏YTε\r\x0fｚｆＬ｜\r␠",
		out:  "␔\rχ=αＩν␟\t\x1f! Ｗ０‛］␘τι␏YTε\r\x0fｚｆＬ｜\r␠",
	}, { // 240
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t`\n$␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\tψ",
		out:  "␠\t`\n＄␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\tψ",
	}, { // 241
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t`\n$␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\tψ",
		out:  "‛␠\t`\n＄␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\tψ",
	}, { // 242
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n`\n$␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\nψ",
		out:  "␠\n`\n＄␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\nψ",
	}, { // 243
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n`\n$␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\nψ",
		out:  "‛␠\n`\n＄␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\nψ",
	}, { // 244
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v`\n$␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\vψ",
		out:  "␠\v`\n＄␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\vψ",
	}, { // 245
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v`\n$␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\vψ",
		out:  "‛␠\v`\n＄␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\vψ",
	}, { // 246
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r`\n$␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\rψ",
		out:  "␠\r`\n＄␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\rψ",
	}, { // 247
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r`\n$␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\rψ",
		out:  "‛␠\r`\n＄␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\rψ",
	}, { // 248
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｌ\t`\n$␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\t ",
		out:  "ｌ\t`\n＄␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\t ",
	}, { // 249
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｌ\t`\n$␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\t␠",
		out:  "ｌ\t`\n＄␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\t␠",
	}, { // 250
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｌ\n`\n$␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\n ",
		out:  "ｌ\n`\n＄␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\n ",
	}, { // 251
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｌ\n`\n$␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\n␠",
		out:  "ｌ\n`\n＄␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\n␠",
	}, { // 252
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｌ\v`\n$␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\v ",
		out:  "ｌ\v`\n＄␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\v ",
	}, { // 253
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｌ\v`\n$␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\v␠",
		out:  "ｌ\v`\n＄␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\v␠",
	}, { // 254
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｌ\r`\n$␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\r ",
		out:  "ｌ\r`\n＄␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\r ",
	}, { // 255
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｌ\r`\n$␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\r␠",
		out:  "ｌ\r`\n＄␅␑xＩ＃η[␟πγU３^B␈\x1eｅｕＤ\x1d␐ςγ\r␠",
	}, { // 256
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\t0",
		out:  "␠\t␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\t0",
	}, { // 257
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\t0",
		out:  "‛␠\t␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\t0",
	}, { // 258
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\n0",
		out:  "␠\n␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\n0",
	}, { // 259
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\n0",
		out:  "‛␠\n␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\n0",
	}, { // 260
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\v0",
		out:  "␠\v␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\v0",
	}, { // 261
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\v0",
		out:  "‛␠\v␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\v0",
	}, { // 262
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\r0",
		out:  "␠\r␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\r0",
	}, { // 263
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\r0",
		out:  "‛␠\r␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\r0",
	}, { // 264
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｑ\t␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\t ",
		out:  "ｑ\t␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\t ",
	}, { // 265
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｑ\t␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\t␠",
		out:  "ｑ\t␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\t␠",
	}, { // 266
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｑ\n␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\n ",
		out:  "ｑ\n␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\n ",
	}, { // 267
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｑ\n␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\n␠",
		out:  "ｑ\n␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\n␠",
	}, { // 268
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｑ\v␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\v ",
		out:  "ｑ\v␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\v ",
	}, { // 269
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｑ\v␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\v␠",
		out:  "ｑ\v␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\v␠",
	}, { // 270
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｑ\r␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\r ",
		out:  "ｑ\r␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\r ",
	}, { // 271
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｑ\r␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\r␠",
		out:  "ｑ\r␉o␏\x1d＼ＧβδＣＪ\x12φ．s\x19␋␁␛\nζ{`=Ｖ\x14:\r␠",
	}, { // 272
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tD\x1b␜\fφ\fκ：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\tＭ",
		out:  "␠\tD\x1b␜\fφ\fκ‛：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\tＭ",
	}, { // 273
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tD\x1b␜\fφ\fκ：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\tＭ",
		out:  "‛␠\tD\x1b␜\fφ\fκ‛：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\tＭ",
	}, { // 274
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nD\x1b␜\fφ\fκ：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\nＭ",
		out:  "␠\nD\x1b␜\fφ\fκ‛：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\nＭ",
	}, { // 275
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nD\x1b␜\fφ\fκ：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\nＭ",
		out:  "‛␠\nD\x1b␜\fφ\fκ‛：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\nＭ",
	}, { // 276
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vD\x1b␜\fφ\fκ：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\vＭ",
		out:  "␠\vD\x1b␜\fφ\fκ‛：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\vＭ",
	}, { // 277
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vD\x1b␜\fφ\fκ：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\vＭ",
		out:  "‛␠\vD\x1b␜\fφ\fκ‛：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\vＭ",
	}, { // 278
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rD\x1b␜\fφ\fκ：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\rＭ",
		out:  "␠\rD\x1b␜\fφ\fκ‛：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\rＭ",
	}, { // 279
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rD\x1b␜\fφ\fκ：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\rＭ",
		out:  "‛␠\rD\x1b␜\fφ\fκ‛：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\rＭ",
	}, { // 280
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "｀\tD\x1b␜\fφ\fκ：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\t ",
		out:  "｀\tD\x1b␜\fφ\fκ‛：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\t ",
	}, { // 281
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "｀\tD\x1b␜\fφ\fκ：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\t␠",
		out:  "｀\tD\x1b␜\fφ\fκ‛：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\t␠",
	}, { // 282
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "｀\nD\x1b␜\fφ\fκ：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\n ",
		out:  "｀\nD\x1b␜\fφ\fκ‛：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\n ",
	}, { // 283
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "｀\nD\x1b␜\fφ\fκ：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\n␠",
		out:  "｀\nD\x1b␜\fφ\fκ‛：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\n␠",
	}, { // 284
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "｀\vD\x1b␜\fφ\fκ：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\v ",
		out:  "｀\vD\x1b␜\fφ\fκ‛：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\v ",
	}, { // 285
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "｀\vD\x1b␜\fφ\fκ：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\v␠",
		out:  "｀\vD\x1b␜\fφ\fκ‛：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\v␠",
	}, { // 286
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "｀\rD\x1b␜\fφ\fκ：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\r ",
		out:  "｀\rD\x1b␜\fφ\fκ‛：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\r ",
	}, { // 287
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "｀\rD\x1b␜\fφ\fκ：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\r␠",
		out:  "｀\rD\x1b␜\fφ\fκ‛：</Ｍe\x05σｆδη／␡S１␓ｕQ␉ι\r␠",
	}, { // 288
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\tλ",
		out:  "␠\t[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\tλ",
	}, { // 289
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\tλ",
		out:  "‛␠\t[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\tλ",
	}, { // 290
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\nλ",
		out:  "␠\n[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\nλ",
	}, { // 291
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\nλ",
		out:  "‛␠\n[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\nλ",
	}, { // 292
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\vλ",
		out:  "␠\v[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\vλ",
	}, { // 293
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\vλ",
		out:  "‛␠\v[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\vλ",
	}, { // 294
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\rλ",
		out:  "␠\r[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\rλ",
	}, { // 295
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\rλ",
		out:  "‛␠\r[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\rλ",
	}, { // 296
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＇\t[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\t ",
		out:  "＇\t[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\t ",
	}, { // 297
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＇\t[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\t␠",
		out:  "＇\t[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\t␠",
	}, { // 298
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＇\n[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\n ",
		out:  "＇\n[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\n ",
	}, { // 299
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＇\n[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\n␠",
		out:  "＇\n[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\n␠",
	}, { // 300
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＇\v[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\v ",
		out:  "＇\v[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\v ",
	}, { // 301
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＇\v[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\v␠",
		out:  "＇\v[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\v␠",
	}, { // 302
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＇\r[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\r ",
		out:  "＇\r[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\r ",
	}, { // 303
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＇\r[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\r␠",
		out:  "＇\r[＊EＥι\x1b\x18+Ｓｐｑτ[W\x1bλ[\"␝␝！α／␅Tj\r␠",
	}, { // 304
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\tL",
		out:  "␠\tα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\tL",
	}, { // 305
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\tL",
		out:  "‛␠\tα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\tL",
	}, { // 306
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\nL",
		out:  "␠\nα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\nL",
	}, { // 307
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\nL",
		out:  "‛␠\nα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\nL",
	}, { // 308
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\vL",
		out:  "␠\vα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\vL",
	}, { // 309
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\vL",
		out:  "‛␠\vα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\vL",
	}, { // 310
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\rL",
		out:  "␠\rα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\rL",
	}, { // 311
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\rL",
		out:  "‛␠\rα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\rL",
	}, { // 312
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "o\tα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\t ",
		out:  "o\tα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\t ",
	}, { // 313
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "o\tα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\t␠",
		out:  "o\tα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\t␠",
	}, { // 314
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "o\nα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\n ",
		out:  "o\nα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\n ",
	}, { // 315
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "o\nα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\n␠",
		out:  "o\nα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\n␠",
	}, { // 316
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "o\vα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\v ",
		out:  "o\vα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\v ",
	}, { // 317
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "o\vα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\v␠",
		out:  "o\vα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\v␠",
	}, { // 318
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "o\rα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\r ",
		out:  "o\rα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\r ",
	}, { // 319
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "o\rα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\r␠",
		out:  "o\rα\rE\x12␔δ｜#＃，␍pχ＼χ：GＬC／αｄ\x03\x1fｔ␜\r␠",
	}, { // 320
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tοζ:ｃ\x15［｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\tσ",
		out:  "␠\tοζ:ｃ\x15［‛｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\tσ",
	}, { // 321
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tοζ:ｃ\x15［｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\tσ",
		out:  "‛␠\tοζ:ｃ\x15［‛｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\tσ",
	}, { // 322
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nοζ:ｃ\x15［｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\nσ",
		out:  "␠\nοζ:ｃ\x15［‛｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\nσ",
	}, { // 323
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nοζ:ｃ\x15［｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\nσ",
		out:  "‛␠\nοζ:ｃ\x15［‛｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\nσ",
	}, { // 324
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vοζ:ｃ\x15［｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\vσ",
		out:  "␠\vοζ:ｃ\x15［‛｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\vσ",
	}, { // 325
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vοζ:ｃ\x15［｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\vσ",
		out:  "‛␠\vοζ:ｃ\x15［‛｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\vσ",
	}, { // 326
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rοζ:ｃ\x15［｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\rσ",
		out:  "␠\rοζ:ｃ\x15［‛｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\rσ",
	}, { // 327
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rοζ:ｃ\x15［｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\rσ",
		out:  "‛␠\rοζ:ｃ\x15［‛｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\rσ",
	}, { // 328
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x10\tοζ:ｃ\x15［｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\t ",
		out:  "\x10\tοζ:ｃ\x15［‛｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\t ",
	}, { // 329
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x10\tοζ:ｃ\x15［｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\t␠",
		out:  "\x10\tοζ:ｃ\x15［‛｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\t␠",
	}, { // 330
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x10\nοζ:ｃ\x15［｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\n ",
		out:  "\x10\nοζ:ｃ\x15［‛｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\n ",
	}, { // 331
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x10\nοζ:ｃ\x15［｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\n␠",
		out:  "\x10\nοζ:ｃ\x15［‛｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\n␠",
	}, { // 332
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x10\vοζ:ｃ\x15［｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\v ",
		out:  "\x10\vοζ:ｃ\x15［‛｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\v ",
	}, { // 333
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x10\vοζ:ｃ\x15［｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\v␠",
		out:  "\x10\vοζ:ｃ\x15［‛｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\v␠",
	}, { // 334
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x10\rοζ:ｃ\x15［｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\r ",
		out:  "\x10\rοζ:ｃ\x15［‛｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\r ",
	}, { // 335
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x10\rοζ:ｃ\x15［｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\r␠",
		out:  "\x10\rοζ:ｃ\x15［‛｜］Ｌ３Ｓｌ＇=␆^\n^α#Zμ<ＯL␍\r␠",
	}, { // 336
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t／uλθｕβ\x01\x01␛８χ␀７␓NγD\\nＱω\vCｒ\x01：\t/",
		out:  "␠\t／uλθｕβ\x01\x01␛８χ‛␀７␓NγD\\nＱω\vCｒ\x01：\t/",
	}, { // 337
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t／uλθｕβ\x01\x01␛８χ␀７␓NγD\\nＱω\vCｒ\x01：\t/",
		out:  "‛␠\t／uλθｕβ\x01\x01␛８χ‛␀７␓NγD\\nＱω\vCｒ\x01：\t/",
	}, { // 338
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n／uλθｕβ\x01\x01␛８χ␀７␓NγD\\nＱω\vCｒ\x01：\n/",
		out:  "␠\n／uλθｕβ\x01\x01␛８χ‛␀７␓NγD\\nＱω\vCｒ\x01：\n/",
	}, { // 339
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n／uλθｕβ\x01\x01␛８χ␀７␓NγD\\nＱω\vCｒ\x01：\n/",
		out:  "‛␠\n／uλθｕβ\x01\x01␛８χ‛␀７␓NγD\\nＱω\vCｒ\x01：\n/",
	}, { // 340
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v／uλθｕβ\x01\x01␛８χ␀７␓NγD\\nＱω\vCｒ\x01：\v/",
		out:  "␠\v／uλθｕβ\x01\x01␛８χ‛␀７␓NγD\\nＱω\vCｒ\x01：\v/",
	}, { // 341
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v／uλθｕβ\x01\x01␛８χ␀７␓NγD\\nＱω\vCｒ\x01：\v/",
		out:  "‛␠\v／uλθｕβ\x01\x01␛８χ‛␀７␓NγD\\nＱω\vCｒ\x01：\v/",
	}, { // 342
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r／uλθｕβ\x01\x01␛８χ␀７␓NγD\\nＱω\vCｒ\x01：\r/",
		out:  "␠\r／uλθｕβ\x01\x01␛８χ‛␀７␓NγD\\nＱω\vCｒ\x01：\r/",
	}, { // 343
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r／uλθｕβ\x01\x01␛８χ␀７␓NγD\\nＱω\vCｒ\x01：\r/",
		out:  "‛␠\r／uλθｕβ\x01\x01␛８χ‛␀７␓NγD\\nＱω\vCｒ\x01：\r/",
	}, { // 344
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "U\t／uλθｕβ\x01\x01␛８χ␀７␓NγD\\nＱω\vCｒ\x01：\t ",
		out:  "U\t／uλθｕβ\x01\x01␛８χ‛␀７␓NγD\\nＱω\vCｒ\x01：\t ",
	}, { // 345
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "U\t／uλθｕβ\x01\x01␛８χ␀７␓NγD\\nＱω\vCｒ\x01：\t␠",
		out:  "U\t／uλθｕβ\x01\x01␛８χ‛␀７␓NγD\\nＱω\vCｒ\x01：\t␠",
	}, { // 346
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "U\n／uλθｕβ\x01\x01␛８χ␀７␓NγD\\nＱω\vCｒ\x01：\n ",
		out:  "U\n／uλθｕβ\x01\x01␛８χ‛␀７␓NγD\\nＱω\vCｒ\x01：\n ",
	}, { // 347
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "U\n／uλθｕβ\x01\x01␛８χ␀７␓NγD\\nＱω\vCｒ\x01：\n␠",
		out:  "U\n／uλθｕβ\x01\x01␛８χ‛␀７␓NγD\\nＱω\vCｒ\x01：\n␠",
	}, { // 348
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "U\v／uλθｕβ\x01\x01␛８χ␀７␓NγD\\nＱω\vCｒ\x01：\v ",
		out:  "U\v／uλθｕβ\x01\x01␛８χ‛␀７␓NγD\\nＱω\vCｒ\x01：\v ",
	}, { // 349
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "U\v／uλθｕβ\x01\x01␛８χ␀７␓NγD\\nＱω\vCｒ\x01：\v␠",
		out:  "U\v／uλθｕβ\x01\x01␛８χ‛␀７␓NγD\\nＱω\vCｒ\x01：\v␠",
	}, { // 350
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "U\r／uλθｕβ\x01\x01␛８χ␀７␓NγD\\nＱω\vCｒ\x01：\r ",
		out:  "U\r／uλθｕβ\x01\x01␛８χ‛␀７␓NγD\\nＱω\vCｒ\x01：\r ",
	}, { // 351
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "U\r／uλθｕβ\x01\x01␛８χ␀７␓NγD\\nＱω\vCｒ\x01：\r␠",
		out:  "U\r／uλθｕβ\x01\x01␛８χ‛␀７␓NγD\\nＱω\vCｒ\x01：\r␠",
	}, { // 352
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t)1］d＝\x00］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\t␈",
		out:  "␠\t)1］d＝␀］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\t␈",
	}, { // 353
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t)1］d＝\x00］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\t␈",
		out:  "‛␠\t)1］d＝␀］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\t␈",
	}, { // 354
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n)1］d＝\x00］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\n␈",
		out:  "␠\n)1］d＝␀］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\n␈",
	}, { // 355
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n)1］d＝\x00］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\n␈",
		out:  "‛␠\n)1］d＝␀］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\n␈",
	}, { // 356
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v)1］d＝\x00］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\v␈",
		out:  "␠\v)1］d＝␀］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\v␈",
	}, { // 357
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v)1］d＝\x00］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\v␈",
		out:  "‛␠\v)1］d＝␀］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\v␈",
	}, { // 358
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r)1］d＝\x00］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\r␈",
		out:  "␠\r)1］d＝␀］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\r␈",
	}, { // 359
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r)1］d＝\x00］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\r␈",
		out:  "‛␠\r)1］d＝␀］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\r␈",
	}, { // 360
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␜\t)1］d＝\x00］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\t ",
		out:  "␜\t)1］d＝␀］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\t ",
	}, { // 361
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␜\t)1］d＝\x00］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\t␠",
		out:  "␜\t)1］d＝␀］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\t␠",
	}, { // 362
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␜\n)1］d＝\x00］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\n ",
		out:  "␜\n)1］d＝␀］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\n ",
	}, { // 363
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␜\n)1］d＝\x00］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\n␠",
		out:  "␜\n)1］d＝␀］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\n␠",
	}, { // 364
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␜\v)1］d＝\x00］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\v ",
		out:  "␜\v)1］d＝␀］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\v ",
	}, { // 365
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␜\v)1］d＝\x00］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\v␠",
		out:  "␜\v)1］d＝␀］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\v␠",
	}, { // 366
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␜\r)1］d＝\x00］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\r ",
		out:  "␜\r)1］d＝␀］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\r ",
	}, { // 367
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␜\r)1］d＝\x00］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\r␠",
		out:  "␜\r)1］d＝␀］μＹ\x14κσｙκ\x11␒)d\x06κ：ζ\x19ｂ＿Ｊ\r␠",
	}, { // 368
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t｝␃Zςυ．\\υ\x0e／Ｓ@L␚\\．ας｜\x01oz\x05Z｜␌\t␕",
		out:  "␠\t｝␃Zςυ．＼υ\x0e／Ｓ@L␚＼．ας｜\x01oz\x05Z｜␌\t␕",
	}, { // 369
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t｝␃Zςυ．\\υ\x0e／Ｓ@L␚\\．ας｜\x01oz\x05Z｜␌\t␕",
		out:  "‛␠\t｝␃Zςυ．＼υ\x0e／Ｓ@L␚＼．ας｜\x01oz\x05Z｜␌\t␕",
	}, { // 370
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n｝␃Zςυ．\\υ\x0e／Ｓ@L␚\\．ας｜\x01oz\x05Z｜␌\n␕",
		out:  "␠\n｝␃Zςυ．＼υ\x0e／Ｓ@L␚＼．ας｜\x01oz\x05Z｜␌\n␕",
	}, { // 371
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n｝␃Zςυ．\\υ\x0e／Ｓ@L␚\\．ας｜\x01oz\x05Z｜␌\n␕",
		out:  "‛␠\n｝␃Zςυ．＼υ\x0e／Ｓ@L␚＼．ας｜\x01oz\x05Z｜␌\n␕",
	}, { // 372
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v｝␃Zςυ．\\υ\x0e／Ｓ@L␚\\．ας｜\x01oz\x05Z｜␌\v␕",
		out:  "␠\v｝␃Zςυ．＼υ\x0e／Ｓ@L␚＼．ας｜\x01oz\x05Z｜␌\v␕",
	}, { // 373
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v｝␃Zςυ．\\υ\x0e／Ｓ@L␚\\．ας｜\x01oz\x05Z｜␌\v␕",
		out:  "‛␠\v｝␃Zςυ．＼υ\x0e／Ｓ@L␚＼．ας｜\x01oz\x05Z｜␌\v␕",
	}, { // 374
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r｝␃Zςυ．\\υ\x0e／Ｓ@L␚\\．ας｜\x01oz\x05Z｜␌\r␕",
		out:  "␠\r｝␃Zςυ．＼υ\x0e／Ｓ@L␚＼．ας｜\x01oz\x05Z｜␌\r␕",
	}, { // 375
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r｝␃Zςυ．\\υ\x0e／Ｓ@L␚\\．ας｜\x01oz\x05Z｜␌\r␕",
		out:  "‛␠\r｝␃Zςυ．＼υ\x0e／Ｓ@L␚＼．ας｜\x01oz\x05Z｜␌\r␕",
	}, { // 376
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x00\t｝␃Zςυ．\\υ\x0e／Ｓ@L␚\\．ας｜\x01oz\x05Z｜␌\t ",
		out:  "␀\t｝␃Zςυ．＼υ\x0e／Ｓ@L␚＼．ας｜\x01oz\x05Z｜␌\t ",
	}, { // 377
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x00\t｝␃Zςυ．\\υ\x0e／Ｓ@L␚\\．ας｜\x01oz\x05Z｜␌\t␠",
		out:  "␀\t｝␃Zςυ．＼υ\x0e／Ｓ@L␚＼．ας｜\x01oz\x05Z｜␌\t␠",
	}, { // 378
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x00\n｝␃Zςυ．\\υ\x0e／Ｓ@L␚\\．ας｜\x01oz\x05Z｜␌\n ",
		out:  "␀\n｝␃Zςυ．＼υ\x0e／Ｓ@L␚＼．ας｜\x01oz\x05Z｜␌\n ",
	}, { // 379
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x00\n｝␃Zςυ．\\υ\x0e／Ｓ@L␚\\．ας｜\x01oz\x05Z｜␌\n␠",
		out:  "␀\n｝␃Zςυ．＼υ\x0e／Ｓ@L␚＼．ας｜\x01oz\x05Z｜␌\n␠",
	}, { // 380
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x00\v｝␃Zςυ．\\υ\x0e／Ｓ@L␚\\．ας｜\x01oz\x05Z｜␌\v ",
		out:  "␀\v｝␃Zςυ．＼υ\x0e／Ｓ@L␚＼．ας｜\x01oz\x05Z｜␌\v ",
	}, { // 381
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x00\v｝␃Zςυ．\\υ\x0e／Ｓ@L␚\\．ας｜\x01oz\x05Z｜␌\v␠",
		out:  "␀\v｝␃Zςυ．＼υ\x0e／Ｓ@L␚＼．ας｜\x01oz\x05Z｜␌\v␠",
	}, { // 382
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x00\r｝␃Zςυ．\\υ\x0e／Ｓ@L␚\\．ας｜\x01oz\x05Z｜␌\r ",
		out:  "␀\r｝␃Zςυ．＼υ\x0e／Ｓ@L␚＼．ας｜\x01oz\x05Z｜␌\r ",
	}, { // 383
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x00\r｝␃Zςυ．\\υ\x0e／Ｓ@L␚\\．ας｜\x01oz\x05Z｜␌\r␠",
		out:  "␀\r｝␃Zςυ．＼υ\x0e／Ｓ@L␚＼．ας｜\x01oz\x05Z｜␌\r␠",
	}, { // 384
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t␊αｊＶ\"\u007f␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\tτ",
		out:  "␠\t␊αｊＶ\"␡␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\tτ",
	}, { // 385
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t␊αｊＶ\"\u007f␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\tτ",
		out:  "‛␠\t␊αｊＶ\"␡␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\tτ",
	}, { // 386
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n␊αｊＶ\"\u007f␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\nτ",
		out:  "␠\n␊αｊＶ\"␡␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\nτ",
	}, { // 387
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n␊αｊＶ\"\u007f␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\nτ",
		out:  "‛␠\n␊αｊＶ\"␡␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\nτ",
	}, { // 388
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v␊αｊＶ\"\u007f␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\vτ",
		out:  "␠\v␊αｊＶ\"␡␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\vτ",
	}, { // 389
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v␊αｊＶ\"\u007f␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\vτ",
		out:  "‛␠\v␊αｊＶ\"␡␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\vτ",
	}, { // 390
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r␊αｊＶ\"\u007f␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\rτ",
		out:  "␠\r␊αｊＶ\"␡␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\rτ",
	}, { // 391
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r␊αｊＶ\"\u007f␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\rτ",
		out:  "‛␠\r␊αｊＶ\"␡␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\rτ",
	}, { // 392
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␘\t␊αｊＶ\"\u007f␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\t ",
		out:  "␘\t␊αｊＶ\"␡␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\t ",
	}, { // 393
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␘\t␊αｊＶ\"\u007f␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\t␠",
		out:  "␘\t␊αｊＶ\"␡␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\t␠",
	}, { // 394
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␘\n␊αｊＶ\"\u007f␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\n ",
		out:  "␘\n␊αｊＶ\"␡␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\n ",
	}, { // 395
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␘\n␊αｊＶ\"\u007f␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\n␠",
		out:  "␘\n␊αｊＶ\"␡␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\n␠",
	}, { // 396
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␘\v␊αｊＶ\"\u007f␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\v ",
		out:  "␘\v␊αｊＶ\"␡␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\v ",
	}, { // 397
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␘\v␊αｊＶ\"\u007f␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\v␠",
		out:  "␘\v␊αｊＶ\"␡␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\v␠",
	}, { // 398
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␘\r␊αｊＶ\"\u007f␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\r ",
		out:  "␘\r␊αｊＶ\"␡␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\r ",
	}, { // 399
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␘\r␊αｊＶ\"\u007f␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\r␠",
		out:  "␘\r␊αｊＶ\"␡␇＄＄οeιｋ4ψNｇλR\fw\x19\x1dＹ:0\r␠",
	}, { // 400
		mask: EncodeZero | EncodeLeftSpace | EncodeRightSpace,
		in:   "  \n(aｔ＠γ␅/d8ψ\x16%｀κ［／？i２μο{＄ω` ␛",
		out:  "␠ \n(aｔ＠γ␅/d8ψ\x16%｀κ［／？i２μο{＄ω` ␛",
	}, { // 401
		mask: EncodeZero | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ \n(aｔ＠γ␅/d8ψ\x16%｀κ［／？i２μο{＄ω` ␛",
		out:  "‛␠ \n(aｔ＠γ␅/d8ψ\x16%｀κ［／？i２μο{＄ω` ␛",
	}, { // 402
		mask: EncodeZero | EncodeLeftSpace | EncodeRightSpace,
		in:   "␂ \n(aｔ＠γ␅/d8ψ\x16%｀κ［／？i２μο{＄ω`  ",
		out:  "␂ \n(aｔ＠γ␅/d8ψ\x16%｀κ［／？i２μο{＄ω` ␠",
	}, { // 403
		mask: EncodeZero | EncodeLeftSpace | EncodeRightSpace,
		in:   "␂ \n(aｔ＠γ␅/d8ψ\x16%｀κ［／？i２μο{＄ω` ␠",
		out:  "␂ \n(aｔ＠γ␅/d8ψ\x16%｀κ［／？i２μο{＄ω` ‛␠",
	}, { // 404
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ^ιρ␓Ｘ␚＇＞aγ］ＯＰ/Rw␏ｙ\x00␈<δN\u007f#τ \"",
		out:  "␠ ^ιρ␓Ｘ␚＇＞aγ］ＯＰ／Rw␏ｙ␀␈<δN\u007f#τ \"",
	}, { // 405
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ^ιρ␓Ｘ␚＇＞aγ］ＯＰ/Rw␏ｙ\x00␈<δN\u007f#τ \"",
		out:  "‛␠ ^ιρ␓Ｘ␚＇＞aγ］ＯＰ／Rw␏ｙ␀␈<δN\u007f#τ \"",
	}, { // 406
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "τ ^ιρ␓Ｘ␚＇＞aγ］ＯＰ/Rw␏ｙ\x00␈<δN\u007f#τ  ",
		out:  "τ ^ιρ␓Ｘ␚＇＞aγ］ＯＰ／Rw␏ｙ␀␈<δN\u007f#τ ␠",
	}, { // 407
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "τ ^ιρ␓Ｘ␚＇＞aγ］ＯＰ/Rw␏ｙ\x00␈<δN\u007f#τ ␠",
		out:  "τ ^ιρ␓Ｘ␚＇＞aγ］ＯＰ／Rw␏ｙ␀␈<δN\u007f#τ ‛␠",
	}, { // 408
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "  θψ]ｃ␃Lςγ\n＄＞＃κ９\\␕=Ｊ\r%οR/\x11!\x17 Ｅ",
		out:  "␠ θψ]ｃ␃Lςγ\n＄＞＃κ９\\␕=Ｊ\r%οR/\x11!\x17 Ｅ",
	}, { // 409
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ θψ]ｃ␃Lςγ\n＄＞＃κ９\\␕=Ｊ\r%οR/\x11!\x17 Ｅ",
		out:  "‛␠ θψ]ｃ␃Lςγ\n＄＞＃κ９\\␕=Ｊ\r%οR/\x11!\x17 Ｅ",
	}, { // 410
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␂ θψ]ｃ␃Lςγ\n＄＞＃κ９\\␕=Ｊ\r%οR/\x11!\x17  ",
		out:  "␂ θψ]ｃ␃Lςγ\n＄＞＃κ９\\␕=Ｊ\r%οR/\x11!\x17 ␠",
	}, { // 411
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␂ θψ]ｃ␃Lςγ\n＄＞＃κ９\\␕=Ｊ\r%οR/\x11!\x17 ␠",
		out:  "␂ θψ]ｃ␃Lςγ\n＄＞＃κ９\\␕=Ｊ\r%οR/\x11!\x17 ‛␠",
	}, { // 412
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "  c\\τｂ<␖ιβ／F\x11２α／τ\x1f\x06）τ\x02␊V\x17l＞Ｆ ｄ",
		out:  "␠ c\\τｂ<␖ιβ／F\x11２α／τ\x1f\x06）τ\x02␊V\x17l＞Ｆ ｄ",
	}, { // 413
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ c\\τｂ<␖ιβ／F\x11２α／τ\x1f\x06）τ\x02␊V\x17l＞Ｆ ｄ",
		out:  "‛␠ c\\τｂ<␖ιβ／F\x11２α／τ\x1f\x06）τ\x02␊V\x17l＞Ｆ ｄ",
	}, { // 414
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␞ c\\τｂ<␖ιβ／F\x11２α／τ\x1f\x06）τ\x02␊V\x17l＞Ｆ  ",
		out:  "␞ c\\τｂ<␖ιβ／F\x11２α／τ\x1f\x06）τ\x02␊V\x17l＞Ｆ ␠",
	}, { // 415
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␞ c\\τｂ<␖ιβ／F\x11２α／τ\x1f\x06）τ\x02␊V\x17l＞Ｆ ␠",
		out:  "␞ c\\τｂ<␖ιβ／F\x11２α／τ\x1f\x06）τ\x02␊V\x17l＞Ｆ ‛␠",
	}, { // 416
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightSpace,
		in:   "  \x1e5＋U;！Ｘ␋␛%\x1b｜δ/Nγκv␛πｌＸςμD␙ ？",
		out:  "␠ \x1e5＋U;！Ｘ␋␛%\x1b｜δ/Nγκv␛πｌＸςμD␙ ？",
	}, { // 417
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ \x1e5＋U;！Ｘ␋␛%\x1b｜δ/Nγκv␛πｌＸςμD␙ ？",
		out:  "‛␠ \x1e5＋U;！Ｘ␋␛%\x1b｜δ/Nγκv␛πｌＸςμD␙ ？",
	}, { // 418
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightSpace,
		in:   "ｈ \x1e5＋U;！Ｘ␋␛%\x1b｜δ/Nγκv␛πｌＸςμD␙  ",
		out:  "ｈ \x1e5＋U;！Ｘ␋␛%\x1b｜δ/Nγκv␛πｌＸςμD␙ ␠",
	}, { // 419
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightSpace,
		in:   "ｈ \x1e5＋U;！Ｘ␋␛%\x1b｜δ/Nγκv␛πｌＸςμD␙ ␠",
		out:  "ｈ \x1e5＋U;！Ｘ␋␛%\x1b｜δ/Nγκv␛πｌＸςμD␙ ‛␠",
	}, { // 420
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightSpace,
		in:   "  Ａ+Reη@\"Ａ\x1cλ\x17Ｎ␊\x13ζ␝\x12\x1e␟␂＄␝υ|υ\n ９",
		out:  "␠ Ａ+Reη@\"Ａ\x1cλ\x17Ｎ␊\x13ζ␝\x12\x1e␟␂＄␝υ|υ\n ９",
	}, { // 421
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ Ａ+Reη@\"Ａ\x1cλ\x17Ｎ␊\x13ζ␝\x12\x1e␟␂＄␝υ|υ\n ９",
		out:  "‛␠ Ａ+Reη@\"Ａ\x1cλ\x17Ｎ␊\x13ζ␝\x12\x1e␟␂＄␝υ|υ\n ９",
	}, { // 422
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightSpace,
		in:   "Ｒ Ａ+Reη@\"Ａ\x1cλ\x17Ｎ␊\x13ζ␝\x12\x1e␟␂＄␝υ|υ\n  ",
		out:  "Ｒ Ａ+Reη@\"Ａ\x1cλ\x17Ｎ␊\x13ζ␝\x12\x1e␟␂＄␝υ|υ\n ␠",
	}, { // 423
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightSpace,
		in:   "Ｒ Ａ+Reη@\"Ａ\x1cλ\x17Ｎ␊\x13ζ␝\x12\x1e␟␂＄␝υ|υ\n ␠",
		out:  "Ｒ Ａ+Reη@\"Ａ\x1cλ\x17Ｎ␊\x13ζ␝\x12\x1e␟␂＄␝υ|υ\n ‛␠",
	}, { // 424
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightSpace,
		in:   "  β\x05７z_ε.]␋␆␔\x1a\x19ＨHｔ｛?Ｘβξ|␐\tο％ ＞",
		out:  "␠ β\x05７z_ε.]␋␆␔\x1a\x19ＨHｔ｛?Ｘβξ|␐\tο％ ＞",
	}, { // 425
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ β\x05７z_ε.]␋␆␔\x1a\x19ＨHｔ｛?Ｘβξ|␐\tο％ ＞",
		out:  "‛␠ β\x05７z_ε.]␋␆␔\x1a\x19ＨHｔ｛?Ｘβξ|␐\tο％ ＞",
	}, { // 426
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightSpace,
		in:   "ρ β\x05７z_ε.]␋␆␔\x1a\x19ＨHｔ｛?Ｘβξ|␐\tο％  ",
		out:  "ρ β\x05７z_ε.]␋␆␔\x1a\x19ＨHｔ｛?Ｘβξ|␐\tο％ ␠",
	}, { // 427
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightSpace,
		in:   "ρ β\x05７z_ε.]␋␆␔\x1a\x19ＨHｔ｛?Ｘβξ|␐\tο％ ␠",
		out:  "ρ β\x05７z_ε.]␋␆␔\x1a\x19ＨHｔ｛?Ｘβξ|␐\tο％ ‛␠",
	}, { // 428
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ｉ＇ξ`ｕ\x1fDι｝χ\x05␕_\"ＬＵ\f＼κqc\x1eoπ：␘ <",
		out:  "␠ ｉ＇ξ`ｕ\x1fDι｝χ\x05␕_＂ＬＵ\f＼κqc\x1eoπ：␘ <",
	}, { // 429
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ｉ＇ξ`ｕ\x1fDι｝χ\x05␕_\"ＬＵ\f＼κqc\x1eoπ：␘ <",
		out:  "‛␠ ｉ＇ξ`ｕ\x1fDι｝χ\x05␕_＂ＬＵ\f＼κqc\x1eoπ：␘ <",
	}, { // 430
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "α ｉ＇ξ`ｕ\x1fDι｝χ\x05␕_\"ＬＵ\f＼κqc\x1eoπ：␘  ",
		out:  "α ｉ＇ξ`ｕ\x1fDι｝χ\x05␕_＂ＬＵ\f＼κqc\x1eoπ：␘ ␠",
	}, { // 431
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "α ｉ＇ξ`ｕ\x1fDι｝χ\x05␕_\"ＬＵ\f＼κqc\x1eoπ：␘ ␠",
		out:  "α ｉ＇ξ`ｕ\x1fDι｝χ\x05␕_＂ＬＵ\f＼κqc\x1eoπ：␘ ‛␠",
	}, { // 432
		mask: EncodeColon | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ,]ψ\x1eση.Ｌ␁␌φ～＼θＮ；\x0eγ\x17␑；v＞\r｝␈ \x1f",
		out:  "␠ ,]ψ\x1eση.Ｌ␁␌φ～＼θＮ；\x0eγ\x17␑；v＞\r｝␈ \x1f",
	}, { // 433
		mask: EncodeColon | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ,]ψ\x1eση.Ｌ␁␌φ～＼θＮ；\x0eγ\x17␑；v＞\r｝␈ \x1f",
		out:  "‛␠ ,]ψ\x1eση.Ｌ␁␌φ～＼θＮ；\x0eγ\x17␑；v＞\r｝␈ \x1f",
	}, { // 434
		mask: EncodeColon | EncodeLeftSpace | EncodeRightSpace,
		in:   "t ,]ψ\x1eση.Ｌ␁␌φ～＼θＮ；\x0eγ\x17␑；v＞\r｝␈  ",
		out:  "t ,]ψ\x1eση.Ｌ␁␌φ～＼θＮ；\x0eγ\x17␑；v＞\r｝␈ ␠",
	}, { // 435
		mask: EncodeColon | EncodeLeftSpace | EncodeRightSpace,
		in:   "t ,]ψ\x1eση.Ｌ␁␌φ～＼θＮ；\x0eγ\x17␑；v＞\r｝␈ ␠",
		out:  "t ,]ψ\x1eση.Ｌ␁␌φ～＼θＮ；\x0eγ\x17␑；v＞\r｝␈ ‛␠",
	}, { // 436
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightSpace,
		in:   "  z</～α／５$␉\x06ｓ：κ|`Ａεμ+／５\x17ＰρVB \x01",
		out:  "␠ z</～α／５$␉\x06ｓ：κ|`Ａεμ+／５\x17ＰρVB \x01",
	}, { // 437
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ z</～α／５$␉\x06ｓ：κ|`Ａεμ+／５\x17ＰρVB \x01",
		out:  "‛␠ z</～α／５$␉\x06ｓ：κ|`Ａεμ+／５\x17ＰρVB \x01",
	}, { // 438
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightSpace,
		in:   "␃ z</～α／５$␉\x06ｓ：κ|`Ａεμ+／５\x17ＰρVB  ",
		out:  "␃ z</～α／５$␉\x06ｓ：κ|`Ａεμ+／５\x17ＰρVB ␠",
	}, { // 439
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightSpace,
		in:   "␃ z</～α／５$␉\x06ｓ：κ|`Ａεμ+／５\x17ＰρVB ␠",
		out:  "␃ z</～α／５$␉\x06ｓ：κ|`Ａεμ+／５\x17ＰρVB ‛␠",
	}, { // 440
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightSpace,
		in:   "  2wＥ\aθcs］>␑＜λπ`｀[ｊＮ:ω␊\bξ，␙μ ␆",
		out:  "␠ 2wＥ\aθcs］>␑＜λπ`｀[ｊＮ:ω␊\bξ，␙μ ␆",
	}, { // 441
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ 2wＥ\aθcs］>␑＜λπ`｀[ｊＮ:ω␊\bξ，␙μ ␆",
		out:  "‛␠ 2wＥ\aθcs］>␑＜λπ`｀[ｊＮ:ω␊\bξ，␙μ ␆",
	}, { // 442
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightSpace,
		in:   "Ｃ 2wＥ\aθcs］>␑＜λπ`｀[ｊＮ:ω␊\bξ，␙μ  ",
		out:  "Ｃ 2wＥ\aθcs］>␑＜λπ`｀[ｊＮ:ω␊\bξ，␙μ ␠",
	}, { // 443
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightSpace,
		in:   "Ｃ 2wＥ\aθcs］>␑＜λπ`｀[ｊＮ:ω␊\bξ，␙μ ␠",
		out:  "Ｃ 2wＥ\aθcs］>␑＜λπ`｀[ｊＮ:ω␊\bξ，␙μ ‛␠",
	}, { // 444
		mask: EncodePipe | EncodeLeftSpace | EncodeRightSpace,
		in:   "  Ｌς\x1f{ｚ\x19␖rＬＪ＇κ␍ｚδ{GDψ\x16８［\"＜B\x10 ␗",
		out:  "␠ Ｌς\x1f{ｚ\x19␖rＬＪ＇κ␍ｚδ{GDψ\x16８［\"＜B\x10 ␗",
	}, { // 445
		mask: EncodePipe | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ Ｌς\x1f{ｚ\x19␖rＬＪ＇κ␍ｚδ{GDψ\x16８［\"＜B\x10 ␗",
		out:  "‛␠ Ｌς\x1f{ｚ\x19␖rＬＪ＇κ␍ｚδ{GDψ\x16８［\"＜B\x10 ␗",
	}, { // 446
		mask: EncodePipe | EncodeLeftSpace | EncodeRightSpace,
		in:   "ψ Ｌς\x1f{ｚ\x19␖rＬＪ＇κ␍ｚδ{GDψ\x16８［\"＜B\x10  ",
		out:  "ψ Ｌς\x1f{ｚ\x19␖rＬＪ＇κ␍ｚδ{GDψ\x16８［\"＜B\x10 ␠",
	}, { // 447
		mask: EncodePipe | EncodeLeftSpace | EncodeRightSpace,
		in:   "ψ Ｌς\x1f{ｚ\x19␖rＬＪ＇κ␍ｚδ{GDψ\x16８［\"＜B\x10 ␠",
		out:  "ψ Ｌς\x1f{ｚ\x19␖rＬＪ＇κ␍ｚδ{GDψ\x16８［\"＜B\x10 ‛␠",
	}, { // 448
		mask: EncodeHash | EncodeLeftSpace | EncodeRightSpace,
		in:   "  Ｉx␛␅\\␀ｇ？W&β\x1fｎ␋／[\x12*υκ%^ψ%ρ␗ \x18",
		out:  "␠ Ｉx␛␅\\‛␀ｇ？W&β\x1fｎ␋／[\x12*υκ%^ψ%ρ␗ \x18",
	}, { // 449
		mask: EncodeHash | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ Ｉx␛␅\\␀ｇ？W&β\x1fｎ␋／[\x12*υκ%^ψ%ρ␗ \x18",
		out:  "‛␠ Ｉx␛␅\\‛␀ｇ？W&β\x1fｎ␋／[\x12*υκ%^ψ%ρ␗ \x18",
	}, { // 450
		mask: EncodeHash | EncodeLeftSpace | EncodeRightSpace,
		in:   "τ Ｉx␛␅\\␀ｇ？W&β\x1fｎ␋／[\x12*υκ%^ψ%ρ␗  ",
		out:  "τ Ｉx␛␅\\‛␀ｇ？W&β\x1fｎ␋／[\x12*υκ%^ψ%ρ␗ ␠",
	}, { // 451
		mask: EncodeHash | EncodeLeftSpace | EncodeRightSpace,
		in:   "τ Ｉx␛␅\\␀ｇ？W&β\x1fｎ␋／[\x12*υκ%^ψ%ρ␗ ␠",
		out:  "τ Ｉx␛␅\\‛␀ｇ？W&β\x1fｎ␋／[\x12*υκ%^ψ%ρ␗ ‛␠",
	}, { // 452
		mask: EncodePercent | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ｔ#Ｂ␃9ｘ＜\n#ντ5␊κ＆Ｅ␛\r]ｄ␊／\x0f\x11\x16τ κ",
		out:  "␠ ｔ#Ｂ␃9ｘ＜\n#ντ5␊κ＆Ｅ␛\r]ｄ␊／\x0f\x11\x16τ κ",
	}, { // 453
		mask: EncodePercent | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ｔ#Ｂ␃9ｘ＜\n#ντ5␊κ＆Ｅ␛\r]ｄ␊／\x0f\x11\x16τ κ",
		out:  "‛␠ ｔ#Ｂ␃9ｘ＜\n#ντ5␊κ＆Ｅ␛\r]ｄ␊／\x0f\x11\x16τ κ",
	}, { // 454
		mask: EncodePercent | EncodeLeftSpace | EncodeRightSpace,
		in:   "\" ｔ#Ｂ␃9ｘ＜\n#ντ5␊κ＆Ｅ␛\r]ｄ␊／\x0f\x11\x16τ  ",
		out:  "\" ｔ#Ｂ␃9ｘ＜\n#ντ5␊κ＆Ｅ␛\r]ｄ␊／\x0f\x11\x16τ ␠",
	}, { // 455
		mask: EncodePercent | EncodeLeftSpace | EncodeRightSpace,
		in:   "\" ｔ#Ｂ␃9ｘ＜\n#ντ5␊κ＆Ｅ␛\r]ｄ␊／\x0f\x11\x16τ ␠",
		out:  "\" ｔ#Ｂ␃9ｘ＜\n#ντ5␊κ＆Ｅ␛\r]ｄ␊／\x0f\x11\x16τ ‛␠",
	}, { // 456
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ioυ$Ｄη%␅␁／／／\x1dχＰ\"ｂ~␘o：␀c%k\x13 ζ",
		out:  "␠ ioυ$Ｄη%␅␁／／／\x1dχＰ\"ｂ~␘o：‛␀c%k\x13 ζ",
	}, { // 457
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ioυ$Ｄη%␅␁／／／\x1dχＰ\"ｂ~␘o：␀c%k\x13 ζ",
		out:  "‛␠ ioυ$Ｄη%␅␁／／／\x1dχＰ\"ｂ~␘o：‛␀c%k\x13 ζ",
	}, { // 458
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "σ ioυ$Ｄη%␅␁／／／\x1dχＰ\"ｂ~␘o：␀c%k\x13  ",
		out:  "σ ioυ$Ｄη%␅␁／／／\x1dχＰ\"ｂ~␘o：‛␀c%k\x13 ␠",
	}, { // 459
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "σ ioυ$Ｄη%␅␁／／／\x1dχＰ\"ｂ~␘o：␀c%k\x13 ␠",
		out:  "σ ioυ$Ｄη%␅␁／／／\x1dχＰ\"ｂ~␘o：‛␀c%k\x13 ‛␠",
	}, { // 460
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ␊κ␀\x1eＳ\a<ｎr␔ρ␟qDSｄθ<␍χ：\x0f，Lδ％ *",
		out:  "␠ ‛␊κ‛␀\x1eＳ\a<ｎr␔ρ␟qDSｄθ<‛␍χ：\x0f，Lδ％ *",
	}, { // 461
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ␊κ␀\x1eＳ\a<ｎr␔ρ␟qDSｄθ<␍χ：\x0f，Lδ％ *",
		out:  "‛␠ ‛␊κ‛␀\x1eＳ\a<ｎr␔ρ␟qDSｄθ<‛␍χ：\x0f，Lδ％ *",
	}, { // 462
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x1b ␊κ␀\x1eＳ\a<ｎr␔ρ␟qDSｄθ<␍χ：\x0f，Lδ％  ",
		out:  "\x1b ‛␊κ‛␀\x1eＳ\a<ｎr␔ρ␟qDSｄθ<‛␍χ：\x0f，Lδ％ ␠",
	}, { // 463
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x1b ␊κ␀\x1eＳ\a<ｎr␔ρ␟qDSｄθ<␍χ：\x0f，Lδ％ ␠",
		out:  "\x1b ‛␊κ‛␀\x1eＳ\a<ｎr␔ρ␟qDSｄθ<‛␍χ：\x0f，Lδ％ ‛␠",
	}, { // 464
		mask: EncodeDel | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ＦψＦ\n｜κK9␌ＦεH␟Dσ\x06＄␀<+␍\x0f␡␊\x01ｒ \r",
		out:  "␠ ＦψＦ\n｜κK9␌ＦεH␟Dσ\x06＄‛␀<+␍\x0f‛␡␊\x01ｒ \r",
	}, { // 465
		mask: EncodeDel | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ＦψＦ\n｜κK9␌ＦεH␟Dσ\x06＄␀<+␍\x0f␡␊\x01ｒ \r",
		out:  "‛␠ ＦψＦ\n｜κK9␌ＦεH␟Dσ\x06＄‛␀<+␍\x0f‛␡␊\x01ｒ \r",
	}, { // 466
		mask: EncodeDel | EncodeLeftSpace | EncodeRightSpace,
		in:   "π ＦψＦ\n｜κK9␌ＦεH␟Dσ\x06＄␀<+␍\x0f␡␊\x01ｒ  ",
		out:  "π ＦψＦ\n｜κK9␌ＦεH␟Dσ\x06＄‛␀<+␍\x0f‛␡␊\x01ｒ ␠",
	}, { // 467
		mask: EncodeDel | EncodeLeftSpace | EncodeRightSpace,
		in:   "π ＦψＦ\n｜κK9␌ＦεH␟Dσ\x06＄␀<+␍\x0f␡␊\x01ｒ ␠",
		out:  "π ＦψＦ\n｜κK9␌ＦεH␟Dσ\x06＄‛␀<+␍\x0f‛␡␊\x01ｒ ‛␠",
	}, { // 468
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ％␝ψ\n␚ｅ：_τｙ`\x12A␀δｌ(<!\x18Ｇ\f｛\x01λ␟ ξ",
		out:  "␠ ％‛␝ψ␊‛␚ｅ：_τｙ`␒A‛␀δｌ(<!␘Ｇ␌｛␁λ‛␟ ξ",
	}, { // 469
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ％␝ψ\n␚ｅ：_τｙ`\x12A␀δｌ(<!\x18Ｇ\f｛\x01λ␟ ξ",
		out:  "‛␠ ％‛␝ψ␊‛␚ｅ：_τｙ`␒A‛␀δｌ(<!␘Ｇ␌｛␁λ‛␟ ξ",
	}, { // 470
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightSpace,
		in:   ". ％␝ψ\n␚ｅ：_τｙ`\x12A␀δｌ(<!\x18Ｇ\f｛\x01λ␟  ",
		out:  ". ％‛␝ψ␊‛␚ｅ：_τｙ`␒A‛␀δｌ(<!␘Ｇ␌｛␁λ‛␟ ␠",
	}, { // 471
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightSpace,
		in:   ". ％␝ψ\n␚ｅ：_τｙ`\x12A␀δｌ(<!\x18Ｇ\f｛\x01λ␟ ␠",
		out:  ". ％‛␝ψ␊‛␚ｅ：_τｙ`␒A‛␀δｌ(<!␘Ｇ␌｛␁λ‛␟ ‛␠",
	}, { // 472
		mask: EncodeZero | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .Ｎｇα␕ητ␜␐\x05\u007f\x1axο␍]ｓJπno＿ψ？Ｇ\x02K.␒",
		out:  "␠.Ｎｇα␕ητ␜␐\x05\u007f\x1axο␍]ｓJπno＿ψ？Ｇ\x02K.␒",
	}, { // 473
		mask: EncodeZero | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.Ｎｇα␕ητ␜␐\x05\u007f\x1axο␍]ｓJπno＿ψ？Ｇ\x02K.␒",
		out:  "‛␠.Ｎｇα␕ητ␜␐\x05\u007f\x1axο␍]ｓJπno＿ψ？Ｇ\x02K.␒",
	}, { // 474
		mask: EncodeZero | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\\.Ｎｇα␕ητ␜␐\x05\u007f\x1axο␍]ｓJπno＿ψ？Ｇ\x02K. ",
		out:  "\\.Ｎｇα␕ητ␜␐\x05\u007f\x1axο␍]ｓJπno＿ψ？Ｇ\x02K. ",
	}, { // 475
		mask: EncodeZero | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\\.Ｎｇα␕ητ␜␐\x05\u007f\x1axο␍]ｓJπno＿ψ？Ｇ\x02K.␠",
		out:  "\\.Ｎｇα␕ητ␜␐\x05\u007f\x1axο␍]ｓJπno＿ψ？Ｇ\x02K.␠",
	}, { // 476
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .δ␇ω＆J\x01?|μ＃␓ψ(／Ｐ＇ ９\x05｝φ␈␟*＜ν.[",
		out:  "␠.δ␇ω＆J\x01?|μ＃␓ψ(‛／Ｐ＇ ９\x05｝φ␈␟*＜ν.[",
	}, { // 477
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.δ␇ω＆J\x01?|μ＃␓ψ(／Ｐ＇ ９\x05｝φ␈␟*＜ν.[",
		out:  "‛␠.δ␇ω＆J\x01?|μ＃␓ψ(‛／Ｐ＇ ９\x05｝φ␈␟*＜ν.[",
	}, { // 478
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "K.δ␇ω＆J\x01?|μ＃␓ψ(／Ｐ＇ ９\x05｝φ␈␟*＜ν. ",
		out:  "K.δ␇ω＆J\x01?|μ＃␓ψ(‛／Ｐ＇ ９\x05｝φ␈␟*＜ν. ",
	}, { // 479
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "K.δ␇ω＆J\x01?|μ＃␓ψ(／Ｐ＇ ９\x05｝φ␈␟*＜ν.␠",
		out:  "K.δ␇ω＆J\x01?|μ＃␓ψ(‛／Ｐ＇ ９\x05｝φ␈␟*＜ν.␠",
	}, { // 480
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .<\no␞｛π\x11\x11κ␡＼α８9：］&␔]␇３６\aζ\x1b_.Ｏ",
		out:  "␠.<\no␞｛π\x11\x11κ␡＼α８9：］&␔]␇３６\aζ\x1b_.Ｏ",
	}, { // 481
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.<\no␞｛π\x11\x11κ␡＼α８9：］&␔]␇３６\aζ\x1b_.Ｏ",
		out:  "‛␠.<\no␞｛π\x11\x11κ␡＼α８9：］&␔]␇３６\aζ\x1b_.Ｏ",
	}, { // 482
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "τ.<\no␞｛π\x11\x11κ␡＼α８9：］&␔]␇３６\aζ\x1b_. ",
		out:  "τ.<\no␞｛π\x11\x11κ␡＼α８9：］&␔]␇３６\aζ\x1b_. ",
	}, { // 483
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "τ.<\no␞｛π\x11\x11κ␡＼α８9：］&␔]␇３６\aζ\x1b_.␠",
		out:  "τ.<\no␞｛π\x11\x11κ␡＼α８9：］&␔]␇３６\aζ\x1b_.␠",
	}, { // 484
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .？%ＺｚOO␞＾␝πο␁\x10＼υευ\ft␈Ｎz７␓*\x0f.\a",
		out:  "␠.？%ＺｚOO␞＾␝πο␁\x10＼υευ\ft␈Ｎz７␓*\x0f.\a",
	}, { // 485
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.？%ＺｚOO␞＾␝πο␁\x10＼υευ\ft␈Ｎz７␓*\x0f.\a",
		out:  "‛␠.？%ＺｚOO␞＾␝πο␁\x10＼υευ\ft␈Ｎz７␓*\x0f.\a",
	}, { // 486
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ζ.？%ＺｚOO␞＾␝πο␁\x10＼υευ\ft␈Ｎz７␓*\x0f. ",
		out:  "ζ.？%ＺｚOO␞＾␝πο␁\x10＼υευ\ft␈Ｎz７␓*\x0f. ",
	}, { // 487
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ζ.？%ＺｚOO␞＾␝πο␁\x10＼υευ\ft␈Ｎz７␓*\x0f.␠",
		out:  "ζ.？%ＺｚOO␞＾␝πο␁\x10＼υευ\ft␈Ｎz７␓*\x0f.␠",
	}, { // 488
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .␃（*;␂@\x06μｋ9␑ｂηＡξ`␎\x1d>\x1d␐␑．t\vν.φ",
		out:  "␠.␃（*;␂@\x06μｋ9␑ｂηＡξ`␎\x1d＞\x1d␐␑．t\vν.φ",
	}, { // 489
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.␃（*;␂@\x06μｋ9␑ｂηＡξ`␎\x1d>\x1d␐␑．t\vν.φ",
		out:  "‛␠.␃（*;␂@\x06μｋ9␑ｂηＡξ`␎\x1d＞\x1d␐␑．t\vν.φ",
	}, { // 490
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ｓ.␃（*;␂@\x06μｋ9␑ｂηＡξ`␎\x1d>\x1d␐␑．t\vν. ",
		out:  "ｓ.␃（*;␂@\x06μｋ9␑ｂηＡξ`␎\x1d＞\x1d␐␑．t\vν. ",
	}, { // 491
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ｓ.␃（*;␂@\x06μｋ9␑ｂηＡξ`␎\x1d>\x1d␐␑．t\vν.␠",
		out:  "ｓ.␃（*;␂@\x06μｋ9␑ｂηＡξ`␎\x1d＞\x1d␐␑．t\vν.␠",
	}, { // 492
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .\n'βo＜υ＆␡V␅Z\x1cμ\x15~␙ψ\x12␊＇;\x1dｃχτＷ.＆",
		out:  "␠.\n'βo＜υ＆␡V␅Z\x1cμ\x15~␙ψ\x12␊＇;\x1dｃχτＷ.＆",
	}, { // 493
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.\n'βo＜υ＆␡V␅Z\x1cμ\x15~␙ψ\x12␊＇;\x1dｃχτＷ.＆",
		out:  "‛␠.\n'βo＜υ＆␡V␅Z\x1cμ\x15~␙ψ\x12␊＇;\x1dｃχτＷ.＆",
	}, { // 494
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightPeriod,
		in:   "Ｂ.\n'βo＜υ＆␡V␅Z\x1cμ\x15~␙ψ\x12␊＇;\x1dｃχτＷ. ",
		out:  "Ｂ.\n'βo＜υ＆␡V␅Z\x1cμ\x15~␙ψ\x12␊＇;\x1dｃχτＷ. ",
	}, { // 495
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightPeriod,
		in:   "Ｂ.\n'βo＜υ＆␡V␅Z\x1cμ\x15~␙ψ\x12␊＇;\x1dｃχτＷ.␠",
		out:  "Ｂ.\n'βo＜υ＆␡V␅Z\x1cμ\x15~␙ψ\x12␊＇;\x1dｃχτＷ.␠",
	}, { // 496
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .\x03@φ<1Z␈|ξ？＇␞＊\x0f␃γｍ！\f*τＦδ'＿C.Ｉ",
		out:  "␠.\x03@φ<1Z␈|ξ？＇␞＊\x0f␃γｍ！\f*τＦδ'＿C.Ｉ",
	}, { // 497
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.\x03@φ<1Z␈|ξ？＇␞＊\x0f␃γｍ！\f*τＦδ'＿C.Ｉ",
		out:  "‛␠.\x03@φ<1Z␈|ξ？＇␞＊\x0f␃γｍ！\f*τＦδ'＿C.Ｉ",
	}, { // 498
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ψ.\x03@φ<1Z␈|ξ？＇␞＊\x0f␃γｍ！\f*τＦδ'＿C. ",
		out:  "ψ.\x03@φ<1Z␈|ξ？＇␞＊\x0f␃γｍ！\f*τＦδ'＿C. ",
	}, { // 499
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ψ.\x03@φ<1Z␈|ξ？＇␞＊\x0f␃γｍ！\f*τＦδ'＿C.␠",
		out:  "ψ.\x03@φ<1Z␈|ξ？＇␞＊\x0f␃γｍ！\f*τＦδ'＿C.␠",
	}, { // 500
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .λJ\x05Ｌ１βｑ\n<#］s［＊␌[\x16␊｜α８ξφI＼／.9",
		out:  "␠.λJ\x05Ｌ１βｑ\n<#］s［＊␌[\x16␊｜α８ξφI＼／.9",
	}, { // 501
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.λJ\x05Ｌ１βｑ\n<#］s［＊␌[\x16␊｜α８ξφI＼／.9",
		out:  "‛␠.λJ\x05Ｌ１βｑ\n<#］s［＊␌[\x16␊｜α８ξφI＼／.9",
	}, { // 502
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "υ.λJ\x05Ｌ１βｑ\n<#］s［＊␌[\x16␊｜α８ξφI＼／. ",
		out:  "υ.λJ\x05Ｌ１βｑ\n<#］s［＊␌[\x16␊｜α８ξφI＼／. ",
	}, { // 503
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "υ.λJ\x05Ｌ１βｑ\n<#］s［＊␌[\x16␊｜α８ξφI＼／.␠",
		out:  "υ.λJ\x05Ｌ１βｑ\n<#］s［＊␌[\x16␊｜α８ξφI＼／.␠",
	}, { // 504
		mask: EncodeColon | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .πr\u007f(δ␋\x01θ．＂ｔ９\x13␐？＠＇Tη\u007fβ\x18␆\x1cs$.［",
		out:  "␠.πr\u007f(δ␋\x01θ．＂ｔ９\x13␐？＠＇Tη\u007fβ\x18␆\x1cs$.［",
	}, { // 505
		mask: EncodeColon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.πr\u007f(δ␋\x01θ．＂ｔ９\x13␐？＠＇Tη\u007fβ\x18␆\x1cs$.［",
		out:  "‛␠.πr\u007f(δ␋\x01θ．＂ｔ９\x13␐？＠＇Tη\u007fβ\x18␆\x1cs$.［",
	}, { // 506
		mask: EncodeColon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "N.πr\u007f(δ␋\x01θ．＂ｔ９\x13␐？＠＇Tη\u007fβ\x18␆\x1cs$. ",
		out:  "N.πr\u007f(δ␋\x01θ．＂ｔ９\x13␐？＠＇Tη\u007fβ\x18␆\x1cs$. ",
	}, { // 507
		mask: EncodeColon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "N.πr\u007f(δ␋\x01θ．＂ｔ９\x13␐？＠＇Tη\u007fβ\x18␆\x1cs$.␠",
		out:  "N.πr\u007f(δ␋\x01θ．＂ｔ９\x13␐？＠＇Tη\u007fβ\x18␆\x1cs$.␠",
	}, { // 508
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .ωｙA｀｜\x11ι\x1fβε␍＋␆εσ％␜３\x1b／␍/\buｆ].F",
		out:  "␠.ωｙA｀｜\x11ι\x1fβε␍＋␆εσ％␜３\x1b／␍/\buｆ].F",
	}, { // 509
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.ωｙA｀｜\x11ι\x1fβε␍＋␆εσ％␜３\x1b／␍/\buｆ].F",
		out:  "‛␠.ωｙA｀｜\x11ι\x1fβε␍＋␆εσ％␜３\x1b／␍/\buｆ].F",
	}, { // 510
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\x1a.ωｙA｀｜\x11ι\x1fβε␍＋␆εσ％␜３\x1b／␍/\buｆ]. ",
		out:  "\x1a.ωｙA｀｜\x11ι\x1fβε␍＋␆εσ％␜３\x1b／␍/\buｆ]. ",
	}, { // 511
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\x1a.ωｙA｀｜\x11ι\x1fβε␍＋␆εσ％␜３\x1b／␍/\buｆ].␠",
		out:  "\x1a.ωｙA｀｜\x11ι\x1fβε␍＋␆εσ％␜３\x1b／␍/\buｆ].␠",
	}, { // 512
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .\u007f３Ｎ\x03ｂ7␈｜␑Bκθ\\␒βL｛π␐］mδ\rl]ε.［",
		out:  "␠.\u007f３Ｎ\x03ｂ7␈｜␑Bκθ\\␒βL｛π␐］mδ\rl]ε.［",
	}, { // 513
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.\u007f３Ｎ\x03ｂ7␈｜␑Bκθ\\␒βL｛π␐］mδ\rl]ε.［",
		out:  "‛␠.\u007f３Ｎ\x03ｂ7␈｜␑Bκθ\\␒βL｛π␐］mδ\rl]ε.［",
	}, { // 514
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\".\u007f３Ｎ\x03ｂ7␈｜␑Bκθ\\␒βL｛π␐］mδ\rl]ε. ",
		out:  "\".\u007f３Ｎ\x03ｂ7␈｜␑Bκθ\\␒βL｛π␐］mδ\rl]ε. ",
	}, { // 515
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\".\u007f３Ｎ\x03ｂ7␈｜␑Bκθ\\␒βL｛π␐］mδ\rl]ε.␠",
		out:  "\".\u007f３Ｎ\x03ｂ7␈｜␑Bκθ\\␒βL｛π␐］mδ\rl]ε.␠",
	}, { // 516
		mask: EncodePipe | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .ｘGＺχ?\tθ1δｂD\x19α＊␗ｄL＠:␒２␉ω##λ.\x14",
		out:  "␠.ｘGＺχ?\tθ1δｂD\x19α＊␗ｄL＠:␒２␉ω##λ.\x14",
	}, { // 517
		mask: EncodePipe | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.ｘGＺχ?\tθ1δｂD\x19α＊␗ｄL＠:␒２␉ω##λ.\x14",
		out:  "‛␠.ｘGＺχ?\tθ1δｂD\x19α＊␗ｄL＠:␒２␉ω##λ.\x14",
	}, { // 518
		mask: EncodePipe | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␍.ｘGＺχ?\tθ1δｂD\x19α＊␗ｄL＠:␒２␉ω##λ. ",
		out:  "␍.ｘGＺχ?\tθ1δｂD\x19α＊␗ｄL＠:␒２␉ω##λ. ",
	}, { // 519
		mask: EncodePipe | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␍.ｘGＺχ?\tθ1δｂD\x19α＊␗ｄL＠:␒２␉ω##λ.␠",
		out:  "␍.ｘGＺχ?\tθ1δｂD\x19α＊␗ｄL＠:␒２␉ω##λ.␠",
	}, { // 520
		mask: EncodeHash | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .␖ξ␛Ｆο<ｑ＝\x11\x1c\x1dXn%\x0e［\x1d－Cγ／］σKＧ7.＂",
		out:  "␠.␖ξ␛Ｆο<ｑ＝\x11\x1c\x1dXn%\x0e［\x1d－Cγ／］σKＧ7.＂",
	}, { // 521
		mask: EncodeHash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.␖ξ␛Ｆο<ｑ＝\x11\x1c\x1dXn%\x0e［\x1d－Cγ／］σKＧ7.＂",
		out:  "‛␠.␖ξ␛Ｆο<ｑ＝\x11\x1c\x1dXn%\x0e［\x1d－Cγ／］σKＧ7.＂",
	}, { // 522
		mask: EncodeHash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "＞.␖ξ␛Ｆο<ｑ＝\x11\x1c\x1dXn%\x0e［\x1d－Cγ／］σKＧ7. ",
		out:  "＞.␖ξ␛Ｆο<ｑ＝\x11\x1c\x1dXn%\x0e［\x1d－Cγ／］σKＧ7. ",
	}, { // 523
		mask: EncodeHash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "＞.␖ξ␛Ｆο<ｑ＝\x11\x1c\x1dXn%\x0e［\x1d－Cγ／］σKＧ7.␠",
		out:  "＞.␖ξ␛Ｆο<ｑ＝\x11\x1c\x1dXn%\x0e［\x1d－Cγ／］σKＧ7.␠",
	}, { // 524
		mask: EncodePercent | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .＇９{σ｜J{Ｚ／<８j\fψ＿\am,␌Ｚ␃γ？｀χ|.ψ",
		out:  "␠.＇９{σ｜J{Ｚ／<８j\fψ＿\am,␌Ｚ␃γ？｀χ|.ψ",
	}, { // 525
		mask: EncodePercent | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.＇９{σ｜J{Ｚ／<８j\fψ＿\am,␌Ｚ␃γ？｀χ|.ψ",
		out:  "‛␠.＇９{σ｜J{Ｚ／<８j\fψ＿\am,␌Ｚ␃γ？｀χ|.ψ",
	}, { // 526
		mask: EncodePercent | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\x0f.＇９{σ｜J{Ｚ／<８j\fψ＿\am,␌Ｚ␃γ？｀χ|. ",
		out:  "\x0f.＇９{σ｜J{Ｚ／<８j\fψ＿\am,␌Ｚ␃γ？｀χ|. ",
	}, { // 527
		mask: EncodePercent | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\x0f.＇９{σ｜J{Ｚ／<８j\fψ＿\am,␌Ｚ␃γ？｀χ|.␠",
		out:  "\x0f.＇９{σ｜J{Ｚ／<８j\fψ＿\am,␌Ｚ␃γ？｀χ|.␠",
	}, { // 528
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .／O␒\n␊\x15μ？<φ␏．0βt\x19/␊０E9～[ω＜β.z",
		out:  "␠.／O␒\n␊\x15μ？<φ␏．0βt\x19/␊０E9～[ω＜β.z",
	}, { // 529
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.／O␒\n␊\x15μ？<φ␏．0βt\x19/␊０E9～[ω＜β.z",
		out:  "‛␠.／O␒\n␊\x15μ？<φ␏．0βt\x19/␊０E9～[ω＜β.z",
	}, { // 530
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "α.／O␒\n␊\x15μ？<φ␏．0βt\x19/␊０E9～[ω＜β. ",
		out:  "α.／O␒\n␊\x15μ？<φ␏．0βt\x19/␊０E9～[ω＜β. ",
	}, { // 531
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "α.／O␒\n␊\x15μ？<φ␏．0βt\x19/␊０E9～[ω＜β.␠",
		out:  "α.／O␒\n␊\x15μ？<φ␏．0βt\x19/␊０E9～[ω＜β.␠",
	}, { // 532
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .λM:dπBＫ\\\r<\rＦ５η␑α｛π（＃␒␜ｊ＄\x01\x13.T",
		out:  "␠.λM:dπBＫ\\␍<␍Ｆ５η␑α｛π（＃␒␜ｊ＄\x01\x13.T",
	}, { // 533
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.λM:dπBＫ\\\r<\rＦ５η␑α｛π（＃␒␜ｊ＄\x01\x13.T",
		out:  "‛␠.λM:dπBＫ\\␍<␍Ｆ５η␑α｛π（＃␒␜ｊ＄\x01\x13.T",
	}, { // 534
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightPeriod,
		in:   "d.λM:dπBＫ\\\r<\rＦ５η␑α｛π（＃␒␜ｊ＄\x01\x13. ",
		out:  "d.λM:dπBＫ\\␍<␍Ｆ５η␑α｛π（＃␒␜ｊ＄\x01\x13. ",
	}, { // 535
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightPeriod,
		in:   "d.λM:dπBＫ\\\r<\rＦ５η␑α｛π（＃␒␜ｊ＄\x01\x13.␠",
		out:  "d.λM:dπBＫ\\␍<␍Ｆ５η␑α｛π（＃␒␜ｊ＄\x01\x13.␠",
	}, { // 536
		mask: EncodeDel | EncodeLeftSpace | EncodeRightPeriod,
		in:   " ./Tkσζｖ␎␋z＃＼\x06ｘ>␐φＴ［ζνｈ\x04\x03π)8.l",
		out:  "␠./Tkσζｖ␎␋z＃＼\x06ｘ>␐φＴ［ζνｈ\x04\x03π)8.l",
	}, { // 537
		mask: EncodeDel | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠./Tkσζｖ␎␋z＃＼\x06ｘ>␐φＴ［ζνｈ\x04\x03π)8.l",
		out:  "‛␠./Tkσζｖ␎␋z＃＼\x06ｘ>␐φＴ［ζνｈ\x04\x03π)8.l",
	}, { // 538
		mask: EncodeDel | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␍./Tkσζｖ␎␋z＃＼\x06ｘ>␐φＴ［ζνｈ\x04\x03π)8. ",
		out:  "␍./Tkσζｖ␎␋z＃＼\x06ｘ>␐φＴ［ζνｈ\x04\x03π)8. ",
	}, { // 539
		mask: EncodeDel | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␍./Tkσζｖ␎␋z＃＼\x06ｘ>␐φＴ［ζνｈ\x04\x03π)8.␠",
		out:  "␍./Tkσζｖ␎␋z＃＼\x06ｘ>␐φＴ［ζνｈ\x04\x03π)8.␠",
	}, { // 540
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .Ｚd.␜=｛9＞μ＇Hκη%\x0e␜η\r\rδｍ＠［␀|ｔ.σ",
		out:  "␠.Ｚd.‛␜=｛9＞μ＇Hκη%␎‛␜η␍␍δｍ＠［‛␀|ｔ.σ",
	}, { // 541
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.Ｚd.␜=｛9＞μ＇Hκη%\x0e␜η\r\rδｍ＠［␀|ｔ.σ",
		out:  "‛␠.Ｚd.‛␜=｛9＞μ＇Hκη%␎‛␜η␍␍δｍ＠［‛␀|ｔ.σ",
	}, { // 542
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\x04.Ｚd.␜=｛9＞μ＇Hκη%\x0e␜η\r\rδｍ＠［␀|ｔ. ",
		out:  "␄.Ｚd.‛␜=｛9＞μ＇Hκη%␎‛␜η␍␍δｍ＠［‛␀|ｔ. ",
	}, { // 543
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\x04.Ｚd.␜=｛9＞μ＇Hκη%\x0e␜η\r\rδｍ＠［␀|ｔ.␠",
		out:  "␄.Ｚd.‛␜=｛9＞μ＇Hκη%␎‛␜η␍␍δｍ＠［‛␀|ｔ.␠",
	}, { // 544
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\t＼",
		out:  "␠\t\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\t＼",
	}, { // 545
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\t＼",
		out:  "‛␠\t\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\t＼",
	}, { // 546
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\n＼",
		out:  "␠\n\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\n＼",
	}, { // 547
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\n＼",
		out:  "‛␠\n\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\n＼",
	}, { // 548
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\v＼",
		out:  "␠\v\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\v＼",
	}, { // 549
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\v＼",
		out:  "‛␠\v\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\v＼",
	}, { // 550
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\r＼",
		out:  "␠\r\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\r＼",
	}, { // 551
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\r＼",
		out:  "‛␠\r\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\r＼",
	}, { // 552
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␊\t\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\t ",
		out:  "␊\t\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\t ",
	}, { // 553
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␊\t\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\t␠",
		out:  "␊\t\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\t␠",
	}, { // 554
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␊\n\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\n ",
		out:  "␊\n\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\n ",
	}, { // 555
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␊\n\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\n␠",
		out:  "␊\n\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\n␠",
	}, { // 556
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␊\v\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\v ",
		out:  "␊\v\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\v ",
	}, { // 557
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␊\v\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\v␠",
		out:  "␊\v\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\v␠",
	}, { // 558
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␊\r\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\r ",
		out:  "␊\r\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\r ",
	}, { // 559
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␊\r\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\r␠",
		out:  "␊\r\x1bＵρρψν_-ｓ␌`␊v␡＜\r>ｑ#\u007f␙π\x01IＱｘ\r␠",
	}, { // 560
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tSο％␓ςο>\vt\x01κ␓?＝ａ/␘，Ｃ［\x17'Ｉhκι\t^",
		out:  "␠\tSο％␓ςο>\vt\x01κ␓?＝ａ／␘，Ｃ［\x17'Ｉhκι\t^",
	}, { // 561
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tSο％␓ςο>\vt\x01κ␓?＝ａ/␘，Ｃ［\x17'Ｉhκι\t^",
		out:  "‛␠\tSο％␓ςο>\vt\x01κ␓?＝ａ／␘，Ｃ［\x17'Ｉhκι\t^",
	}, { // 562
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nSο％␓ςο>\vt\x01κ␓?＝ａ/␘，Ｃ［\x17'Ｉhκι\n^",
		out:  "␠\nSο％␓ςο>\vt\x01κ␓?＝ａ／␘，Ｃ［\x17'Ｉhκι\n^",
	}, { // 563
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nSο％␓ςο>\vt\x01κ␓?＝ａ/␘，Ｃ［\x17'Ｉhκι\n^",
		out:  "‛␠\nSο％␓ςο>\vt\x01κ␓?＝ａ／␘，Ｃ［\x17'Ｉhκι\n^",
	}, { // 564
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vSο％␓ςο>\vt\x01κ␓?＝ａ/␘，Ｃ［\x17'Ｉhκι\v^",
		out:  "␠\vSο％␓ςο>\vt\x01κ␓?＝ａ／␘，Ｃ［\x17'Ｉhκι\v^",
	}, { // 565
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vSο％␓ςο>\vt\x01κ␓?＝ａ/␘，Ｃ［\x17'Ｉhκι\v^",
		out:  "‛␠\vSο％␓ςο>\vt\x01κ␓?＝ａ／␘，Ｃ［\x17'Ｉhκι\v^",
	}, { // 566
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rSο％␓ςο>\vt\x01κ␓?＝ａ/␘，Ｃ［\x17'Ｉhκι\r^",
		out:  "␠\rSο％␓ςο>\vt\x01κ␓?＝ａ／␘，Ｃ［\x17'Ｉhκι\r^",
	}, { // 567
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rSο％␓ςο>\vt\x01κ␓?＝ａ/␘，Ｃ［\x17'Ｉhκι\r^",
		out:  "‛␠\rSο％␓ςο>\vt\x01κ␓?＝ａ／␘，Ｃ［\x17'Ｉhκι\r^",
	}, { // 568
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "u\tSο％␓ςο>\vt\x01κ␓?＝ａ/␘，Ｃ［\x17'Ｉhκι\t ",
		out:  "u\tSο％␓ςο>\vt\x01κ␓?＝ａ／␘，Ｃ［\x17'Ｉhκι\t ",
	}, { // 569
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "u\tSο％␓ςο>\vt\x01κ␓?＝ａ/␘，Ｃ［\x17'Ｉhκι\t␠",
		out:  "u\tSο％␓ςο>\vt\x01κ␓?＝ａ／␘，Ｃ［\x17'Ｉhκι\t␠",
	}, { // 570
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "u\nSο％␓ςο>\vt\x01κ␓?＝ａ/␘，Ｃ［\x17'Ｉhκι\n ",
		out:  "u\nSο％␓ςο>\vt\x01κ␓?＝ａ／␘，Ｃ［\x17'Ｉhκι\n ",
	}, { // 571
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "u\nSο％␓ςο>\vt\x01κ␓?＝ａ/␘，Ｃ［\x17'Ｉhκι\n␠",
		out:  "u\nSο％␓ςο>\vt\x01κ␓?＝ａ／␘，Ｃ［\x17'Ｉhκι\n␠",
	}, { // 572
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "u\vSο％␓ςο>\vt\x01κ␓?＝ａ/␘，Ｃ［\x17'Ｉhκι\v ",
		out:  "u\vSο％␓ςο>\vt\x01κ␓?＝ａ／␘，Ｃ［\x17'Ｉhκι\v ",
	}, { // 573
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "u\vSο％␓ςο>\vt\x01κ␓?＝ａ/␘，Ｃ［\x17'Ｉhκι\v␠",
		out:  "u\vSο％␓ςο>\vt\x01κ␓?＝ａ／␘，Ｃ［\x17'Ｉhκι\v␠",
	}, { // 574
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "u\rSο％␓ςο>\vt\x01κ␓?＝ａ/␘，Ｃ［\x17'Ｉhκι\r ",
		out:  "u\rSο％␓ςο>\vt\x01κ␓?＝ａ／␘，Ｃ［\x17'Ｉhκι\r ",
	}, { // 575
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "u\rSο％␓ςο>\vt\x01κ␓?＝ａ/␘，Ｃ［\x17'Ｉhκι\r␠",
		out:  "u\rSο％␓ςο>\vt\x01κ␓?＝ａ／␘，Ｃ［\x17'Ｉhκι\r␠",
	}, { // 576
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t２Ｖ\x00ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\t|",
		out:  "␠\t２Ｖ␀ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\t|",
	}, { // 577
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t２Ｖ\x00ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\t|",
		out:  "‛␠\t２Ｖ␀ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\t|",
	}, { // 578
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n２Ｖ\x00ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\n|",
		out:  "␠\n２Ｖ␀ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\n|",
	}, { // 579
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n２Ｖ\x00ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\n|",
		out:  "‛␠\n２Ｖ␀ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\n|",
	}, { // 580
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v２Ｖ\x00ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\v|",
		out:  "␠\v２Ｖ␀ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\v|",
	}, { // 581
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v２Ｖ\x00ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\v|",
		out:  "‛␠\v２Ｖ␀ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\v|",
	}, { // 582
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r２Ｖ\x00ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\r|",
		out:  "␠\r２Ｖ␀ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\r|",
	}, { // 583
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r２Ｖ\x00ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\r|",
		out:  "‛␠\r２Ｖ␀ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\r|",
	}, { // 584
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\f\t２Ｖ\x00ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\t ",
		out:  "\f\t２Ｖ␀ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\t ",
	}, { // 585
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\f\t２Ｖ\x00ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\t␠",
		out:  "\f\t２Ｖ␀ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\t␠",
	}, { // 586
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\f\n２Ｖ\x00ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\n ",
		out:  "\f\n２Ｖ␀ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\n ",
	}, { // 587
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\f\n２Ｖ\x00ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\n␠",
		out:  "\f\n２Ｖ␀ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\n␠",
	}, { // 588
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\f\v２Ｖ\x00ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\v ",
		out:  "\f\v２Ｖ␀ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\v ",
	}, { // 589
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\f\v２Ｖ\x00ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\v␠",
		out:  "\f\v２Ｖ␀ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\v␠",
	}, { // 590
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\f\r２Ｖ\x00ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\r ",
		out:  "\f\r２Ｖ␀ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\r ",
	}, { // 591
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\f\r２Ｖ\x00ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\r␠",
		out:  "\f\r２Ｖ␀ι\x13:\x1b]５eＥi␝␕␜\fL：Ｄ␁{δ␆δＸβ\r␠",
	}, { // 592
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\tｔ",
		out:  "␠\tGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\tｔ",
	}, { // 593
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\tｔ",
		out:  "‛␠\tGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\tｔ",
	}, { // 594
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\nｔ",
		out:  "␠\nGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\nｔ",
	}, { // 595
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\nｔ",
		out:  "‛␠\nGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\nｔ",
	}, { // 596
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\vｔ",
		out:  "␠\vGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\vｔ",
	}, { // 597
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\vｔ",
		out:  "‛␠\vGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\vｔ",
	}, { // 598
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\rｔ",
		out:  "␠\rGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\rｔ",
	}, { // 599
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\rｔ",
		out:  "‛␠\rGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\rｔ",
	}, { // 600
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ς\tGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\t ",
		out:  "ς\tGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\t ",
	}, { // 601
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ς\tGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\t␠",
		out:  "ς\tGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\t␠",
	}, { // 602
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ς\nGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\n ",
		out:  "ς\nGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\n ",
	}, { // 603
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ς\nGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\n␠",
		out:  "ς\nGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\n␠",
	}, { // 604
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ς\vGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\v ",
		out:  "ς\vGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\v ",
	}, { // 605
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ς\vGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\v␠",
		out:  "ς\vGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\v␠",
	}, { // 606
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ς\rGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\r ",
		out:  "ς\rGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\r ",
	}, { // 607
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ς\rGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\r␠",
		out:  "ς\rGα␊␚\x15＠\x03７６␜␡\r<χ*G␍␁R\x05ｓ\x11Vψ７ζ\r␠",
	}, { // 608
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\t␇",
		out:  "␠\t\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\t␇",
	}, { // 609
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\t␇",
		out:  "‛␠\t\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\t␇",
	}, { // 610
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\n␇",
		out:  "␠\n\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\n␇",
	}, { // 611
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\n␇",
		out:  "‛␠\n\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\n␇",
	}, { // 612
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\v␇",
		out:  "␠\v\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\v␇",
	}, { // 613
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\v␇",
		out:  "‛␠\v\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\v␇",
	}, { // 614
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\r␇",
		out:  "␠\r\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\r␇",
	}, { // 615
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\r␇",
		out:  "‛␠\r\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\r␇",
	}, { // 616
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\t\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\t ",
		out:  "␀\t\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\t ",
	}, { // 617
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\t\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\t␠",
		out:  "␀\t\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\t␠",
	}, { // 618
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\n\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\n ",
		out:  "␀\n\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\n ",
	}, { // 619
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\n\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\n␠",
		out:  "␀\n\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\n␠",
	}, { // 620
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\v\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\v ",
		out:  "␀\v\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\v ",
	}, { // 621
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\v\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\v␠",
		out:  "␀\v\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\v␠",
	}, { // 622
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\r\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\r ",
		out:  "␀\r\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\r ",
	}, { // 623
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\r\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\r␠",
		out:  "␀\r\x0eψτο３\x0f；␘［\x13@\uff00２a＊｜]?HＹC\r？ｎθω\r␠",
	}, { // 624
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11[␗＿＇＂G␞'＇βa\tι",
		out:  "␠\tχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11［␗＿＇＂G␞'＇βa\tι",
	}, { // 625
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11[␗＿＇＂G␞'＇βa\tι",
		out:  "‛␠\tχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11［␗＿＇＂G␞'＇βa\tι",
	}, { // 626
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11[␗＿＇＂G␞'＇βa\nι",
		out:  "␠\nχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11［␗＿＇＂G␞'＇βa\nι",
	}, { // 627
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11[␗＿＇＂G␞'＇βa\nι",
		out:  "‛␠\nχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11［␗＿＇＂G␞'＇βa\nι",
	}, { // 628
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11[␗＿＇＂G␞'＇βa\vι",
		out:  "␠\vχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11［␗＿＇＂G␞'＇βa\vι",
	}, { // 629
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11[␗＿＇＂G␞'＇βa\vι",
		out:  "‛␠\vχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11［␗＿＇＂G␞'＇βa\vι",
	}, { // 630
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11[␗＿＇＂G␞'＇βa\rι",
		out:  "␠\rχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11［␗＿＇＂G␞'＇βa\rι",
	}, { // 631
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11[␗＿＇＂G␞'＇βa\rι",
		out:  "‛␠\rχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11［␗＿＇＂G␞'＇βa\rι",
	}, { // 632
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x19\tχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11[␗＿＇＂G␞'＇βa\t ",
		out:  "\x19\tχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11［␗＿＇＂G␞'＇βa\t ",
	}, { // 633
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x19\tχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11[␗＿＇＂G␞'＇βa\t␠",
		out:  "\x19\tχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11［␗＿＇＂G␞'＇βa\t␠",
	}, { // 634
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x19\nχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11[␗＿＇＂G␞'＇βa\n ",
		out:  "\x19\nχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11［␗＿＇＂G␞'＇βa\n ",
	}, { // 635
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x19\nχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11[␗＿＇＂G␞'＇βa\n␠",
		out:  "\x19\nχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11［␗＿＇＂G␞'＇βa\n␠",
	}, { // 636
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x19\vχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11[␗＿＇＂G␞'＇βa\v ",
		out:  "\x19\vχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11［␗＿＇＂G␞'＇βa\v ",
	}, { // 637
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x19\vχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11[␗＿＇＂G␞'＇βa\v␠",
		out:  "\x19\vχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11［␗＿＇＂G␞'＇βa\v␠",
	}, { // 638
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x19\rχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11[␗＿＇＂G␞'＇βa\r ",
		out:  "\x19\rχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11［␗＿＇＂G␞'＇βa\r ",
	}, { // 639
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x19\rχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11[␗＿＇＂G␞'＇βa\r␠",
		out:  "\x19\rχχYｓｔ␊6\x10{ｋ␊Lθ\r\x11［␗＿＇＂G␞'＇βa\r␠",
	}, { // 640
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\tπ",
		out:  "␠\tｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\tπ",
	}, { // 641
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\tπ",
		out:  "‛␠\tｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\tπ",
	}, { // 642
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\nπ",
		out:  "␠\nｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\nπ",
	}, { // 643
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\nπ",
		out:  "‛␠\nｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\nπ",
	}, { // 644
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\vπ",
		out:  "␠\vｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\vπ",
	}, { // 645
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\vπ",
		out:  "‛␠\vｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\vπ",
	}, { // 646
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\rπ",
		out:  "␠\rｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\rπ",
	}, { // 647
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\rπ",
		out:  "‛␠\rｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\rπ",
	}, { // 648
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "/\tｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\t ",
		out:  "/\tｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\t ",
	}, { // 649
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "/\tｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\t␠",
		out:  "/\tｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\t␠",
	}, { // 650
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "/\nｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\n ",
		out:  "/\nｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\n ",
	}, { // 651
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "/\nｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\n␠",
		out:  "/\nｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\n␠",
	}, { // 652
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "/\vｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\v ",
		out:  "/\vｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\v ",
	}, { // 653
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "/\vｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\v␠",
		out:  "/\vｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\v␠",
	}, { // 654
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "/\rｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\r ",
		out:  "/\rｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\r ",
	}, { // 655
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "/\rｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\r␠",
		out:  "/\rｑ/`－κEＣ8λElδτ␈␓\x1b＝\b？η＞／／］=␁\r␠",
	}, { // 656
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tｎ␀*ｆ4(φ}@Ｉ\x00ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\t\n",
		out:  "␠\tｎ‛␀*ｆ4(φ}@Ｉ␀ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\t␊",
	}, { // 657
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tｎ␀*ｆ4(φ}@Ｉ\x00ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\t\n",
		out:  "‛␠\tｎ‛␀*ｆ4(φ}@Ｉ␀ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\t␊",
	}, { // 658
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nｎ␀*ｆ4(φ}@Ｉ\x00ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\n\n",
		out:  "␠\nｎ‛␀*ｆ4(φ}@Ｉ␀ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\n␊",
	}, { // 659
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nｎ␀*ｆ4(φ}@Ｉ\x00ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\n\n",
		out:  "‛␠\nｎ‛␀*ｆ4(φ}@Ｉ␀ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\n␊",
	}, { // 660
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vｎ␀*ｆ4(φ}@Ｉ\x00ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\v\n",
		out:  "␠\vｎ‛␀*ｆ4(φ}@Ｉ␀ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\v␊",
	}, { // 661
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vｎ␀*ｆ4(φ}@Ｉ\x00ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\v\n",
		out:  "‛␠\vｎ‛␀*ｆ4(φ}@Ｉ␀ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\v␊",
	}, { // 662
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rｎ␀*ｆ4(φ}@Ｉ\x00ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\r\n",
		out:  "␠\rｎ‛␀*ｆ4(φ}@Ｉ␀ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\r␊",
	}, { // 663
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rｎ␀*ｆ4(φ}@Ｉ\x00ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\r\n",
		out:  "‛␠\rｎ‛␀*ｆ4(φ}@Ｉ␀ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\r␊",
	}, { // 664
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｙ\tｎ␀*ｆ4(φ}@Ｉ\x00ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\t ",
		out:  "Ｙ\tｎ‛␀*ｆ4(φ}@Ｉ␀ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\t ",
	}, { // 665
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｙ\tｎ␀*ｆ4(φ}@Ｉ\x00ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\t␠",
		out:  "Ｙ\tｎ‛␀*ｆ4(φ}@Ｉ␀ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\t␠",
	}, { // 666
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｙ\nｎ␀*ｆ4(φ}@Ｉ\x00ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\n ",
		out:  "Ｙ\nｎ‛␀*ｆ4(φ}@Ｉ␀ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\n ",
	}, { // 667
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｙ\nｎ␀*ｆ4(φ}@Ｉ\x00ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\n␠",
		out:  "Ｙ\nｎ‛␀*ｆ4(φ}@Ｉ␀ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\n␠",
	}, { // 668
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｙ\vｎ␀*ｆ4(φ}@Ｉ\x00ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\v ",
		out:  "Ｙ\vｎ‛␀*ｆ4(φ}@Ｉ␀ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\v ",
	}, { // 669
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｙ\vｎ␀*ｆ4(φ}@Ｉ\x00ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\v␠",
		out:  "Ｙ\vｎ‛␀*ｆ4(φ}@Ｉ␀ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\v␠",
	}, { // 670
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｙ\rｎ␀*ｆ4(φ}@Ｉ\x00ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\r ",
		out:  "Ｙ\rｎ‛␀*ｆ4(φ}@Ｉ␀ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\r ",
	}, { // 671
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｙ\rｎ␀*ｆ4(φ}@Ｉ\x00ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\r␠",
		out:  "Ｙ\rｎ‛␀*ｆ4(φ}@Ｉ␀ς＊γＣ７α␛\x03*＜＇\x14L\x17κ\r␠",
	}, { // 672
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t]␃β｀9t\x1fＫ＂QＴ\x01π␀＆＊ω｜?μ␍\tθ;6␉\t␜",
		out:  "␠\t]␃β｀9t\x1fＫ＂QＴ\x01π‛␀＆＊ω｜?μ␍\tθ;6␉\t␜",
	}, { // 673
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t]␃β｀9t\x1fＫ＂QＴ\x01π␀＆＊ω｜?μ␍\tθ;6␉\t␜",
		out:  "‛␠\t]␃β｀9t\x1fＫ＂QＴ\x01π‛␀＆＊ω｜?μ␍\tθ;6␉\t␜",
	}, { // 674
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n]␃β｀9t\x1fＫ＂QＴ\x01π␀＆＊ω｜?μ␍\tθ;6␉\n␜",
		out:  "␠\n]␃β｀9t\x1fＫ＂QＴ\x01π‛␀＆＊ω｜?μ␍\tθ;6␉\n␜",
	}, { // 675
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n]␃β｀9t\x1fＫ＂QＴ\x01π␀＆＊ω｜?μ␍\tθ;6␉\n␜",
		out:  "‛␠\n]␃β｀9t\x1fＫ＂QＴ\x01π‛␀＆＊ω｜?μ␍\tθ;6␉\n␜",
	}, { // 676
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v]␃β｀9t\x1fＫ＂QＴ\x01π␀＆＊ω｜?μ␍\tθ;6␉\v␜",
		out:  "␠\v]␃β｀9t\x1fＫ＂QＴ\x01π‛␀＆＊ω｜?μ␍\tθ;6␉\v␜",
	}, { // 677
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v]␃β｀9t\x1fＫ＂QＴ\x01π␀＆＊ω｜?μ␍\tθ;6␉\v␜",
		out:  "‛␠\v]␃β｀9t\x1fＫ＂QＴ\x01π‛␀＆＊ω｜?μ␍\tθ;6␉\v␜",
	}, { // 678
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r]␃β｀9t\x1fＫ＂QＴ\x01π␀＆＊ω｜?μ␍\tθ;6␉\r␜",
		out:  "␠\r]␃β｀9t\x1fＫ＂QＴ\x01π‛␀＆＊ω｜?μ␍\tθ;6␉\r␜",
	}, { // 679
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r]␃β｀9t\x1fＫ＂QＴ\x01π␀＆＊ω｜?μ␍\tθ;6␉\r␜",
		out:  "‛␠\r]␃β｀9t\x1fＫ＂QＴ\x01π‛␀＆＊ω｜?μ␍\tθ;6␉\r␜",
	}, { // 680
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "κ\t]␃β｀9t\x1fＫ＂QＴ\x01π␀＆＊ω｜?μ␍\tθ;6␉\t ",
		out:  "κ\t]␃β｀9t\x1fＫ＂QＴ\x01π‛␀＆＊ω｜?μ␍\tθ;6␉\t ",
	}, { // 681
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "κ\t]␃β｀9t\x1fＫ＂QＴ\x01π␀＆＊ω｜?μ␍\tθ;6␉\t␠",
		out:  "κ\t]␃β｀9t\x1fＫ＂QＴ\x01π‛␀＆＊ω｜?μ␍\tθ;6␉\t␠",
	}, { // 682
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "κ\n]␃β｀9t\x1fＫ＂QＴ\x01π␀＆＊ω｜?μ␍\tθ;6␉\n ",
		out:  "κ\n]␃β｀9t\x1fＫ＂QＴ\x01π‛␀＆＊ω｜?μ␍\tθ;6␉\n ",
	}, { // 683
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "κ\n]␃β｀9t\x1fＫ＂QＴ\x01π␀＆＊ω｜?μ␍\tθ;6␉\n␠",
		out:  "κ\n]␃β｀9t\x1fＫ＂QＴ\x01π‛␀＆＊ω｜?μ␍\tθ;6␉\n␠",
	}, { // 684
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "κ\v]␃β｀9t\x1fＫ＂QＴ\x01π␀＆＊ω｜?μ␍\tθ;6␉\v ",
		out:  "κ\v]␃β｀9t\x1fＫ＂QＴ\x01π‛␀＆＊ω｜?μ␍\tθ;6␉\v ",
	}, { // 685
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "κ\v]␃β｀9t\x1fＫ＂QＴ\x01π␀＆＊ω｜?μ␍\tθ;6␉\v␠",
		out:  "κ\v]␃β｀9t\x1fＫ＂QＴ\x01π‛␀＆＊ω｜?μ␍\tθ;6␉\v␠",
	}, { // 686
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "κ\r]␃β｀9t\x1fＫ＂QＴ\x01π␀＆＊ω｜?μ␍\tθ;6␉\r ",
		out:  "κ\r]␃β｀9t\x1fＫ＂QＴ\x01π‛␀＆＊ω｜?μ␍\tθ;6␉\r ",
	}, { // 687
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "κ\r]␃β｀9t\x1fＫ＂QＴ\x01π␀＆＊ω｜?μ␍\tθ;6␉\r␠",
		out:  "κ\r]␃β｀9t\x1fＫ＂QＴ\x01π‛␀＆＊ω｜?μ␍\tθ;6␉\r␠",
	}, { // 688
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t\x06␍\x01?i␏ｆPＷ␓χy\t\a#ψ％?Ｚζ␍␞η@E＋\t～",
		out:  "␠\t\x06␍\x01？i␏ｆPＷ␓χy\t\a#ψ％？Ｚζ␍␞η@E＋\t～",
	}, { // 689
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t\x06␍\x01?i␏ｆPＷ␓χy\t\a#ψ％?Ｚζ␍␞η@E＋\t～",
		out:  "‛␠\t\x06␍\x01？i␏ｆPＷ␓χy\t\a#ψ％？Ｚζ␍␞η@E＋\t～",
	}, { // 690
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n\x06␍\x01?i␏ｆPＷ␓χy\t\a#ψ％?Ｚζ␍␞η@E＋\n～",
		out:  "␠\n\x06␍\x01？i␏ｆPＷ␓χy\t\a#ψ％？Ｚζ␍␞η@E＋\n～",
	}, { // 691
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n\x06␍\x01?i␏ｆPＷ␓χy\t\a#ψ％?Ｚζ␍␞η@E＋\n～",
		out:  "‛␠\n\x06␍\x01？i␏ｆPＷ␓χy\t\a#ψ％？Ｚζ␍␞η@E＋\n～",
	}, { // 692
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v\x06␍\x01?i␏ｆPＷ␓χy\t\a#ψ％?Ｚζ␍␞η@E＋\v～",
		out:  "␠\v\x06␍\x01？i␏ｆPＷ␓χy\t\a#ψ％？Ｚζ␍␞η@E＋\v～",
	}, { // 693
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v\x06␍\x01?i␏ｆPＷ␓χy\t\a#ψ％?Ｚζ␍␞η@E＋\v～",
		out:  "‛␠\v\x06␍\x01？i␏ｆPＷ␓χy\t\a#ψ％？Ｚζ␍␞η@E＋\v～",
	}, { // 694
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r\x06␍\x01?i␏ｆPＷ␓χy\t\a#ψ％?Ｚζ␍␞η@E＋\r～",
		out:  "␠\r\x06␍\x01？i␏ｆPＷ␓χy\t\a#ψ％？Ｚζ␍␞η@E＋\r～",
	}, { // 695
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r\x06␍\x01?i␏ｆPＷ␓χy\t\a#ψ％?Ｚζ␍␞η@E＋\r～",
		out:  "‛␠\r\x06␍\x01？i␏ｆPＷ␓χy\t\a#ψ％？Ｚζ␍␞η@E＋\r～",
	}, { // 696
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＄\t\x06␍\x01?i␏ｆPＷ␓χy\t\a#ψ％?Ｚζ␍␞η@E＋\t ",
		out:  "＄\t\x06␍\x01？i␏ｆPＷ␓χy\t\a#ψ％？Ｚζ␍␞η@E＋\t ",
	}, { // 697
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＄\t\x06␍\x01?i␏ｆPＷ␓χy\t\a#ψ％?Ｚζ␍␞η@E＋\t␠",
		out:  "＄\t\x06␍\x01？i␏ｆPＷ␓χy\t\a#ψ％？Ｚζ␍␞η@E＋\t␠",
	}, { // 698
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＄\n\x06␍\x01?i␏ｆPＷ␓χy\t\a#ψ％?Ｚζ␍␞η@E＋\n ",
		out:  "＄\n\x06␍\x01？i␏ｆPＷ␓χy\t\a#ψ％？Ｚζ␍␞η@E＋\n ",
	}, { // 699
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＄\n\x06␍\x01?i␏ｆPＷ␓χy\t\a#ψ％?Ｚζ␍␞η@E＋\n␠",
		out:  "＄\n\x06␍\x01？i␏ｆPＷ␓χy\t\a#ψ％？Ｚζ␍␞η@E＋\n␠",
	}, { // 700
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＄\v\x06␍\x01?i␏ｆPＷ␓χy\t\a#ψ％?Ｚζ␍␞η@E＋\v ",
		out:  "＄\v\x06␍\x01？i␏ｆPＷ␓χy\t\a#ψ％？Ｚζ␍␞η@E＋\v ",
	}, { // 701
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＄\v\x06␍\x01?i␏ｆPＷ␓χy\t\a#ψ％?Ｚζ␍␞η@E＋\v␠",
		out:  "＄\v\x06␍\x01？i␏ｆPＷ␓χy\t\a#ψ％？Ｚζ␍␞η@E＋\v␠",
	}, { // 702
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＄\r\x06␍\x01?i␏ｆPＷ␓χy\t\a#ψ％?Ｚζ␍␞η@E＋\r ",
		out:  "＄\r\x06␍\x01？i␏ｆPＷ␓χy\t\a#ψ％？Ｚζ␍␞η@E＋\r ",
	}, { // 703
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＄\r\x06␍\x01?i␏ｆPＷ␓χy\t\a#ψ％?Ｚζ␍␞η@E＋\r␠",
		out:  "＄\r\x06␍\x01？i␏ｆPＷ␓χy\t\a#ψ％？Ｚζ␍␞η@E＋\r␠",
	}, { // 704
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tｘmａ␌B\x1aρημｕπ！C\x14<k␛＄\x00␖ρ␂␅'/＃\tν",
		out:  "␠\tｘmａ␌B\x1aρημｕπ！C\x14<k␛＄␀␖ρ␂␅'/＃\tν",
	}, { // 705
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tｘmａ␌B\x1aρημｕπ！C\x14<k␛＄\x00␖ρ␂␅'/＃\tν",
		out:  "‛␠\tｘmａ␌B\x1aρημｕπ！C\x14<k␛＄␀␖ρ␂␅'/＃\tν",
	}, { // 706
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nｘmａ␌B\x1aρημｕπ！C\x14<k␛＄\x00␖ρ␂␅'/＃\nν",
		out:  "␠\nｘmａ␌B\x1aρημｕπ！C\x14<k␛＄␀␖ρ␂␅'/＃\nν",
	}, { // 707
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nｘmａ␌B\x1aρημｕπ！C\x14<k␛＄\x00␖ρ␂␅'/＃\nν",
		out:  "‛␠\nｘmａ␌B\x1aρημｕπ！C\x14<k␛＄␀␖ρ␂␅'/＃\nν",
	}, { // 708
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vｘmａ␌B\x1aρημｕπ！C\x14<k␛＄\x00␖ρ␂␅'/＃\vν",
		out:  "␠\vｘmａ␌B\x1aρημｕπ！C\x14<k␛＄␀␖ρ␂␅'/＃\vν",
	}, { // 709
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vｘmａ␌B\x1aρημｕπ！C\x14<k␛＄\x00␖ρ␂␅'/＃\vν",
		out:  "‛␠\vｘmａ␌B\x1aρημｕπ！C\x14<k␛＄␀␖ρ␂␅'/＃\vν",
	}, { // 710
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rｘmａ␌B\x1aρημｕπ！C\x14<k␛＄\x00␖ρ␂␅'/＃\rν",
		out:  "␠\rｘmａ␌B\x1aρημｕπ！C\x14<k␛＄␀␖ρ␂␅'/＃\rν",
	}, { // 711
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rｘmａ␌B\x1aρημｕπ！C\x14<k␛＄\x00␖ρ␂␅'/＃\rν",
		out:  "‛␠\rｘmａ␌B\x1aρημｕπ！C\x14<k␛＄␀␖ρ␂␅'/＃\rν",
	}, { // 712
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "n\tｘmａ␌B\x1aρημｕπ！C\x14<k␛＄\x00␖ρ␂␅'/＃\t ",
		out:  "n\tｘmａ␌B\x1aρημｕπ！C\x14<k␛＄␀␖ρ␂␅'/＃\t ",
	}, { // 713
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "n\tｘmａ␌B\x1aρημｕπ！C\x14<k␛＄\x00␖ρ␂␅'/＃\t␠",
		out:  "n\tｘmａ␌B\x1aρημｕπ！C\x14<k␛＄␀␖ρ␂␅'/＃\t␠",
	}, { // 714
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "n\nｘmａ␌B\x1aρημｕπ！C\x14<k␛＄\x00␖ρ␂␅'/＃\n ",
		out:  "n\nｘmａ␌B\x1aρημｕπ！C\x14<k␛＄␀␖ρ␂␅'/＃\n ",
	}, { // 715
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "n\nｘmａ␌B\x1aρημｕπ！C\x14<k␛＄\x00␖ρ␂␅'/＃\n␠",
		out:  "n\nｘmａ␌B\x1aρημｕπ！C\x14<k␛＄␀␖ρ␂␅'/＃\n␠",
	}, { // 716
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "n\vｘmａ␌B\x1aρημｕπ！C\x14<k␛＄\x00␖ρ␂␅'/＃\v ",
		out:  "n\vｘmａ␌B\x1aρημｕπ！C\x14<k␛＄␀␖ρ␂␅'/＃\v ",
	}, { // 717
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "n\vｘmａ␌B\x1aρημｕπ！C\x14<k␛＄\x00␖ρ␂␅'/＃\v␠",
		out:  "n\vｘmａ␌B\x1aρημｕπ！C\x14<k␛＄␀␖ρ␂␅'/＃\v␠",
	}, { // 718
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "n\rｘmａ␌B\x1aρημｕπ！C\x14<k␛＄\x00␖ρ␂␅'/＃\r ",
		out:  "n\rｘmａ␌B\x1aρημｕπ！C\x14<k␛＄␀␖ρ␂␅'/＃\r ",
	}, { // 719
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "n\rｘmａ␌B\x1aρημｕπ！C\x14<k␛＄\x00␖ρ␂␅'/＃\r␠",
		out:  "n\rｘmａ␌B\x1aρημｕπ！C\x14<k␛＄␀␖ρ␂␅'/＃\r␠",
	}, { // 720
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw｜υs\tＦ",
		out:  "␠\t\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw‛｜υs\tＦ",
	}, { // 721
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw｜υs\tＦ",
		out:  "‛␠\t\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw‛｜υs\tＦ",
	}, { // 722
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw｜υs\nＦ",
		out:  "␠\n\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw‛｜υs\nＦ",
	}, { // 723
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw｜υs\nＦ",
		out:  "‛␠\n\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw‛｜υs\nＦ",
	}, { // 724
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw｜υs\vＦ",
		out:  "␠\v\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw‛｜υs\vＦ",
	}, { // 725
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw｜υs\vＦ",
		out:  "‛␠\v\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw‛｜υs\vＦ",
	}, { // 726
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw｜υs\rＦ",
		out:  "␠\r\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw‛｜υs\rＦ",
	}, { // 727
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw｜υs\rＦ",
		out:  "‛␠\r\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw‛｜υs\rＦ",
	}, { // 728
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␘\t\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw｜υs\t ",
		out:  "␘\t\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw‛｜υs\t ",
	}, { // 729
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␘\t\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw｜υs\t␠",
		out:  "␘\t\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw‛｜υs\t␠",
	}, { // 730
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␘\n\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw｜υs\n ",
		out:  "␘\n\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw‛｜υs\n ",
	}, { // 731
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␘\n\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw｜υs\n␠",
		out:  "␘\n\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw‛｜υs\n␠",
	}, { // 732
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␘\v\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw｜υs\v ",
		out:  "␘\v\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw‛｜υs\v ",
	}, { // 733
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␘\v\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw｜υs\v␠",
		out:  "␘\v\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw‛｜υs\v␠",
	}, { // 734
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␘\r\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw｜υs\r ",
		out:  "␘\r\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw‛｜υs\r ",
	}, { // 735
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␘\r\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw｜υs\r␠",
		out:  "␘\r\nＯs]κ？␈＇Ｋδ␒ＯξI\vσ｝\x06κ[␓Jw‛｜υs\r␠",
	}, { // 736
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ\x00ｕ\x17\t％",
		out:  "␠\t／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ␀ｕ\x17\t％",
	}, { // 737
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ\x00ｕ\x17\t％",
		out:  "‛␠\t／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ␀ｕ\x17\t％",
	}, { // 738
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ\x00ｕ\x17\n％",
		out:  "␠\n／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ␀ｕ\x17\n％",
	}, { // 739
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ\x00ｕ\x17\n％",
		out:  "‛␠\n／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ␀ｕ\x17\n％",
	}, { // 740
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ\x00ｕ\x17\v％",
		out:  "␠\v／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ␀ｕ\x17\v％",
	}, { // 741
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ\x00ｕ\x17\v％",
		out:  "‛␠\v／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ␀ｕ\x17\v％",
	}, { // 742
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ\x00ｕ\x17\r％",
		out:  "␠\r／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ␀ｕ\x17\r％",
	}, { // 743
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ\x00ｕ\x17\r％",
		out:  "‛␠\r／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ␀ｕ\x17\r％",
	}, { // 744
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "G\t／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ\x00ｕ\x17\t ",
		out:  "G\t／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ␀ｕ\x17\t ",
	}, { // 745
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "G\t／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ\x00ｕ\x17\t␠",
		out:  "G\t／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ␀ｕ\x17\t␠",
	}, { // 746
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "G\n／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ\x00ｕ\x17\n ",
		out:  "G\n／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ␀ｕ\x17\n ",
	}, { // 747
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "G\n／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ\x00ｕ\x17\n␠",
		out:  "G\n／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ␀ｕ\x17\n␠",
	}, { // 748
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "G\v／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ\x00ｕ\x17\v ",
		out:  "G\v／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ␀ｕ\x17\v ",
	}, { // 749
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "G\v／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ\x00ｕ\x17\v␠",
		out:  "G\v／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ␀ｕ\x17\v␠",
	}, { // 750
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "G\r／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ\x00ｕ\x17\r ",
		out:  "G\r／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ␀ｕ\x17\r ",
	}, { // 751
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "G\r／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ\x00ｕ\x17\r␠",
		out:  "G\r／\x1aμ3r\x19␌| ３ｚττ\x12<␙／τ4κ␄：ｖ␀ｕ\x17\r␠",
	}, { // 752
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t｀Ｎ\x00␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\tv",
		out:  "␠\t｀Ｎ␀␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\tv",
	}, { // 753
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t｀Ｎ\x00␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\tv",
		out:  "‛␠\t｀Ｎ␀␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\tv",
	}, { // 754
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n｀Ｎ\x00␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\nv",
		out:  "␠\n｀Ｎ␀␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\nv",
	}, { // 755
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n｀Ｎ\x00␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\nv",
		out:  "‛␠\n｀Ｎ␀␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\nv",
	}, { // 756
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v｀Ｎ\x00␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\vv",
		out:  "␠\v｀Ｎ␀␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\vv",
	}, { // 757
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v｀Ｎ\x00␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\vv",
		out:  "‛␠\v｀Ｎ␀␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\vv",
	}, { // 758
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r｀Ｎ\x00␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\rv",
		out:  "␠\r｀Ｎ␀␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\rv",
	}, { // 759
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r｀Ｎ\x00␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\rv",
		out:  "‛␠\r｀Ｎ␀␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\rv",
	}, { // 760
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "：\t｀Ｎ\x00␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\t ",
		out:  "：\t｀Ｎ␀␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\t ",
	}, { // 761
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "：\t｀Ｎ\x00␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\t␠",
		out:  "：\t｀Ｎ␀␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\t␠",
	}, { // 762
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "：\n｀Ｎ\x00␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\n ",
		out:  "：\n｀Ｎ␀␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\n ",
	}, { // 763
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "：\n｀Ｎ\x00␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\n␠",
		out:  "：\n｀Ｎ␀␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\n␠",
	}, { // 764
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "：\v｀Ｎ\x00␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\v ",
		out:  "：\v｀Ｎ␀␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\v ",
	}, { // 765
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "：\v｀Ｎ\x00␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\v␠",
		out:  "：\v｀Ｎ␀␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\v␠",
	}, { // 766
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "：\r｀Ｎ\x00␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\r ",
		out:  "：\r｀Ｎ␀␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\r ",
	}, { // 767
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "：\r｀Ｎ\x00␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\r␠",
		out:  "：\r｀Ｎ␀␈\x1bι＿:β\u007fK:ｃ｛Ｚ\x17u␆\x14␇ξ?␈ν␅Y\r␠",
	}, { // 768
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ＼S3␄ο\r\tI",
		out:  "␠\tχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ‛＼S3␄ο\r\tI",
	}, { // 769
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ＼S3␄ο\r\tI",
		out:  "‛␠\tχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ‛＼S3␄ο\r\tI",
	}, { // 770
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ＼S3␄ο\r\nI",
		out:  "␠\nχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ‛＼S3␄ο\r\nI",
	}, { // 771
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ＼S3␄ο\r\nI",
		out:  "‛␠\nχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ‛＼S3␄ο\r\nI",
	}, { // 772
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ＼S3␄ο\r\vI",
		out:  "␠\vχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ‛＼S3␄ο\r\vI",
	}, { // 773
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ＼S3␄ο\r\vI",
		out:  "‛␠\vχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ‛＼S3␄ο\r\vI",
	}, { // 774
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ＼S3␄ο\r\rI",
		out:  "␠\rχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ‛＼S3␄ο\r\rI",
	}, { // 775
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ＼S3␄ο\r\rI",
		out:  "‛␠\rχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ‛＼S3␄ο\r\rI",
	}, { // 776
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "]\tχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ＼S3␄ο\r\t ",
		out:  "]\tχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ‛＼S3␄ο\r\t ",
	}, { // 777
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "]\tχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ＼S3␄ο\r\t␠",
		out:  "]\tχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ‛＼S3␄ο\r\t␠",
	}, { // 778
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "]\nχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ＼S3␄ο\r\n ",
		out:  "]\nχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ‛＼S3␄ο\r\n ",
	}, { // 779
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "]\nχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ＼S3␄ο\r\n␠",
		out:  "]\nχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ‛＼S3␄ο\r\n␠",
	}, { // 780
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "]\vχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ＼S3␄ο\r\v ",
		out:  "]\vχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ‛＼S3␄ο\r\v ",
	}, { // 781
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "]\vχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ＼S3␄ο\r\v␠",
		out:  "]\vχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ‛＼S3␄ο\r\v␠",
	}, { // 782
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "]\rχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ＼S3␄ο\r\r ",
		out:  "]\rχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ‛＼S3␄ο\r\r ",
	}, { // 783
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "]\rχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ＼S3␄ο\r\r␠",
		out:  "]\rχO：ρ␈Ｗφ\rＱα␗\x1fς`０␃\n*bＢ‛＼S3␄ο\r\r␠",
	}, { // 784
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\tＧ",
		out:  "␠\tδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\tＧ",
	}, { // 785
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\tＧ",
		out:  "‛␠\tδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\tＧ",
	}, { // 786
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\nＧ",
		out:  "␠\nδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\nＧ",
	}, { // 787
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\nＧ",
		out:  "‛␠\nδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\nＧ",
	}, { // 788
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\vＧ",
		out:  "␠\vδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\vＧ",
	}, { // 789
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\vＧ",
		out:  "‛␠\vδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\vＧ",
	}, { // 790
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\rＧ",
		out:  "␠\rδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\rＧ",
	}, { // 791
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\rＧ",
		out:  "‛␠\rδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\rＧ",
	}, { // 792
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x1e\tδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\t ",
		out:  "\x1e\tδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\t ",
	}, { // 793
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x1e\tδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\t␠",
		out:  "\x1e\tδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\t␠",
	}, { // 794
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x1e\nδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\n ",
		out:  "\x1e\nδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\n ",
	}, { // 795
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x1e\nδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\n␠",
		out:  "\x1e\nδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\n␠",
	}, { // 796
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x1e\vδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\v ",
		out:  "\x1e\vδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\v ",
	}, { // 797
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x1e\vδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\v␠",
		out:  "\x1e\vδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\v␠",
	}, { // 798
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x1e\rδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\r ",
		out:  "\x1e\rδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\r ",
	}, { // 799
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x1e\rδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\r␠",
		out:  "\x1e\rδμ\\x％K!Ａ\x1c9ｓσ]β／＞λ␆＼␈Yς\f\x0f－\x17\r␠",
	}, { // 800
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ｀ψς2␑ρ％F＃\x14\x1ei#１␑｜οd\x16Vγ＃/ｕＯχ ；",
		out:  "． ｀ψς2␑ρ％F＃\x14\x1ei#１␑｜οd\x16Vγ＃/ｕＯχ ；",
	}, { // 801
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ｀ψς2␑ρ％F＃\x14\x1ei#１␑｜οd\x16Vγ＃/ｕＯχ ；",
		out:  "‛． ｀ψς2␑ρ％F＃\x14\x1ei#１␑｜οd\x16Vγ＃/ｕＯχ ；",
	}, { // 802
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␚ ｀ψς2␑ρ％F＃\x14\x1ei#１␑｜οd\x16Vγ＃/ｕＯχ .",
		out:  "␚ ｀ψς2␑ρ％F＃\x14\x1ei#１␑｜οd\x16Vγ＃/ｕＯχ .",
	}, { // 803
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␚ ｀ψς2␑ρ％F＃\x14\x1ei#１␑｜οd\x16Vγ＃/ｕＯχ ．",
		out:  "␚ ｀ψς2␑ρ％F＃\x14\x1ei#１␑｜οd\x16Vγ＃/ｕＯχ ．",
	}, { // 804
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". Ｌ＼J／ζ．␡＇<o\x15\r]ι\"?χNj␗␘ｂ'χＭ４ ε",
		out:  "． Ｌ＼J‛／ζ．␡＇<o\x15\r]ι\"?χNj␗␘ｂ'χＭ４ ε",
	}, { // 805
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． Ｌ＼J／ζ．␡＇<o\x15\r]ι\"?χNj␗␘ｂ'χＭ４ ε",
		out:  "‛． Ｌ＼J‛／ζ．␡＇<o\x15\r]ι\"?χNj␗␘ｂ'χＭ４ ε",
	}, { // 806
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "η Ｌ＼J／ζ．␡＇<o\x15\r]ι\"?χNj␗␘ｂ'χＭ４ .",
		out:  "η Ｌ＼J‛／ζ．␡＇<o\x15\r]ι\"?χNj␗␘ｂ'χＭ４ .",
	}, { // 807
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "η Ｌ＼J／ζ．␡＇<o\x15\r]ι\"?χNj␗␘ｂ'χＭ４ ．",
		out:  "η Ｌ＼J‛／ζ．␡＇<o\x15\r]ι\"?χNj␗␘ｂ'χＭ４ ．",
	}, { // 808
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ο␕W｝␀ψ␆:8~␇\x05\x1dνJＤπｈ␏／\x12%７＇E? Ｂ",
		out:  "． ο␕W｝‛␀ψ␆:8~␇\x05\x1dνJＤπｈ␏／\x12%７‛＇E? Ｂ",
	}, { // 809
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ο␕W｝␀ψ␆:8~␇\x05\x1dνJＤπｈ␏／\x12%７＇E? Ｂ",
		out:  "‛． ο␕W｝‛␀ψ␆:8~␇\x05\x1dνJＤπｈ␏／\x12%７‛＇E? Ｂ",
	}, { // 810
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "υ ο␕W｝␀ψ␆:8~␇\x05\x1dνJＤπｈ␏／\x12%７＇E? .",
		out:  "υ ο␕W｝‛␀ψ␆:8~␇\x05\x1dνJＤπｈ␏／\x12%７‛＇E? .",
	}, { // 811
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "υ ο␕W｝␀ψ␆:8~␇\x05\x1dνJＤπｈ␏／\x12%７＇E? ．",
		out:  "υ ο␕W｝‛␀ψ␆:8~␇\x05\x1dνJＤπｈ␏／\x12%７‛＇E? ．",
	}, { // 812
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". \x04＂z␟，μτ\\ｂβｂ=|\x18？＊|␀]`-ε7＿＞\x1e （",
		out:  "． \x04＂z␟，μτ\\ｂβｂ=|\x18？＊|‛␀]｀-ε7＿＞\x1e （",
	}, { // 813
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． \x04＂z␟，μτ\\ｂβｂ=|\x18？＊|␀]`-ε7＿＞\x1e （",
		out:  "‛． \x04＂z␟，μτ\\ｂβｂ=|\x18？＊|‛␀]｀-ε7＿＞\x1e （",
	}, { // 814
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ξ \x04＂z␟，μτ\\ｂβｂ=|\x18？＊|␀]`-ε7＿＞\x1e .",
		out:  "ξ \x04＂z␟，μτ\\ｂβｂ=|\x18？＊|‛␀]｀-ε7＿＞\x1e .",
	}, { // 815
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ξ \x04＂z␟，μτ\\ｂβｂ=|\x18？＊|␀]`-ε7＿＞\x1e ．",
		out:  "ξ \x04＂z␟，μτ\\ｂβｂ=|\x18？＊|‛␀]｀-ε7＿＞\x1e ．",
	}, { // 816
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ␂␛-\x14χy␇\x02P＂３＾τβμ/／|1μ９'θＡ\x0e% @",
		out:  "． ␂␛-\x14χy␇\x02P＂３＾τβμ/／|1μ９'θＡ\x0e% @",
	}, { // 817
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ␂␛-\x14χy␇\x02P＂３＾τβμ/／|1μ９'θＡ\x0e% @",
		out:  "‛． ␂␛-\x14χy␇\x02P＂３＾τβμ/／|1μ９'θＡ\x0e% @",
	}, { // 818
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␖ ␂␛-\x14χy␇\x02P＂３＾τβμ/／|1μ９'θＡ\x0e% .",
		out:  "␖ ␂␛-\x14χy␇\x02P＂３＾τβμ/／|1μ９'θＡ\x0e% .",
	}, { // 819
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␖ ␂␛-\x14χy␇\x02P＂３＾τβμ/／|1μ９'θＡ\x0e% ．",
		out:  "␖ ␂␛-\x14χy␇\x02P＂３＾τβμ/／|1μ９'θＡ\x0e% ．",
	}, { // 820
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". IY\"Ｊoλ３υ＄１+８η␛\ft/γＸ␛\x01\x19＞ο＞\x12 ：",
		out:  "． IY\"Ｊoλ３υ＄１+８η␛\ft/γＸ␛\x01\x19＞ο＞\x12 ：",
	}, { // 821
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． IY\"Ｊoλ３υ＄１+８η␛\ft/γＸ␛\x01\x19＞ο＞\x12 ：",
		out:  "‛． IY\"Ｊoλ３υ＄１+８η␛\ft/γＸ␛\x01\x19＞ο＞\x12 ：",
	}, { // 822
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ψ IY\"Ｊoλ３υ＄１+８η␛\ft/γＸ␛\x01\x19＞ο＞\x12 .",
		out:  "ψ IY\"Ｊoλ３υ＄１+８η␛\ft/γＸ␛\x01\x19＞ο＞\x12 .",
	}, { // 823
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ψ IY\"Ｊoλ３υ＄１+８η␛\ft/γＸ␛\x01\x19＞ο＞\x12 ．",
		out:  "ψ IY\"Ｊoλ３υ＄１+８η␛\ft/γＸ␛\x01\x19＞ο＞\x12 ．",
	}, { // 824
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". \x03\nsι／ＳD＠WνＤ\fψ[ξψ␉␇ｊ␝T\x06`σ␀｀ \x11",
		out:  "． \x03\nsι／ＳD＠WνＤ\fψ[ξψ␉␇ｊ␝T\x06`σ‛␀｀ \x11",
	}, { // 825
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． \x03\nsι／ＳD＠WνＤ\fψ[ξψ␉␇ｊ␝T\x06`σ␀｀ \x11",
		out:  "‛． \x03\nsι／ＳD＠WνＤ\fψ[ξψ␉␇ｊ␝T\x06`σ‛␀｀ \x11",
	}, { // 826
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␑ \x03\nsι／ＳD＠WνＤ\fψ[ξψ␉␇ｊ␝T\x06`σ␀｀ .",
		out:  "␑ \x03\nsι／ＳD＠WνＤ\fψ[ξψ␉␇ｊ␝T\x06`σ‛␀｀ .",
	}, { // 827
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␑ \x03\nsι／ＳD＠WνＤ\fψ[ξψ␉␇ｊ␝T\x06`σ␀｀ ．",
		out:  "␑ \x03\nsι／ＳD＠WνＤ\fψ[ξψ␉␇ｊ␝T\x06`σ‛␀｀ ．",
	}, { // 828
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". .T７:φ｝｜\x1a＊1␋＃/F:␖γcξυP\x1f␙ｑ＜， ␙",
		out:  "． .T７:φ｝｜\x1a＊1␋＃/F:␖γcξυP\x1f␙ｑ＜， ␙",
	}, { // 829
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． .T７:φ｝｜\x1a＊1␋＃/F:␖γcξυP\x1f␙ｑ＜， ␙",
		out:  "‛． .T７:φ｝｜\x1a＊1␋＃/F:␖γcξυP\x1f␙ｑ＜， ␙",
	}, { // 830
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "\x18 .T７:φ｝｜\x1a＊1␋＃/F:␖γcξυP\x1f␙ｑ＜， .",
		out:  "\x18 .T７:φ｝｜\x1a＊1␋＃/F:␖γcξυP\x1f␙ｑ＜， .",
	}, { // 831
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "\x18 .T７:φ｝｜\x1a＊1␋＃/F:␖γcξυP\x1f␙ｑ＜， ．",
		out:  "\x18 .T７:φ｝｜\x1a＊1␋＃/F:␖γcξυP\x1f␙ｑ＜， ．",
	}, { // 832
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ＠>]E／rnβｗaＲuＬψ６λ$Ｂ\x0f/␏\x15λ［χ： φ",
		out:  "． ＠>]E／rnβｗaＲuＬψ６λ$Ｂ\x0f/␏\x15λ［χ‛： φ",
	}, { // 833
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ＠>]E／rnβｗaＲuＬψ６λ$Ｂ\x0f/␏\x15λ［χ： φ",
		out:  "‛． ＠>]E／rnβｗaＲuＬψ６λ$Ｂ\x0f/␏\x15λ［χ‛： φ",
	}, { // 834
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␄ ＠>]E／rnβｗaＲuＬψ６λ$Ｂ\x0f/␏\x15λ［χ： .",
		out:  "␄ ＠>]E／rnβｗaＲuＬψ６λ$Ｂ\x0f/␏\x15λ［χ‛： .",
	}, { // 835
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␄ ＠>]E／rnβｗaＲuＬψ６λ$Ｂ\x0f/␏\x15λ［χ： ．",
		out:  "␄ ＠>]E／rnβｗaＲuＬψ６λ$Ｂ\x0f/␏\x15λ［χ‛： ．",
	}, { // 836
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". \x0e\x1f］e（␞ψ\x1a\x1d＇!XＦｔ\x1dε＃δＶφi`g\x1cξ␚ ＄",
		out:  "． \x0e\x1f］e（␞ψ\x1a\x1d＇!XＦｔ\x1dε＃δＶφi`g\x1cξ␚ ＄",
	}, { // 837
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． \x0e\x1f］e（␞ψ\x1a\x1d＇!XＦｔ\x1dε＃δＶφi`g\x1cξ␚ ＄",
		out:  "‛． \x0e\x1f］e（␞ψ\x1a\x1d＇!XＦｔ\x1dε＃δＶφi`g\x1cξ␚ ＄",
	}, { // 838
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ｖ \x0e\x1f］e（␞ψ\x1a\x1d＇!XＦｔ\x1dε＃δＶφi`g\x1cξ␚ .",
		out:  "ｖ \x0e\x1f］e（␞ψ\x1a\x1d＇!XＦｔ\x1dε＃δＶφi`g\x1cξ␚ .",
	}, { // 839
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ｖ \x0e\x1f］e（␞ψ\x1a\x1d＇!XＦｔ\x1dε＃δＶφi`g\x1cξ␚ ．",
		out:  "ｖ \x0e\x1f］e（␞ψ\x1a\x1d＇!XＦｔ\x1dε＃δＶφi`g\x1cξ␚ ．",
	}, { // 840
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ＂Ｇ]η\r＂＊pＬFｍＮζυ␜ξ\f＂\r␍X␜ψ\x1f$} [",
		out:  "． ＂Ｇ]η\r＂‛＊pＬFｍＮζυ␜ξ\f＂\r␍X␜ψ\x1f$} [",
	}, { // 841
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ＂Ｇ]η\r＂＊pＬFｍＮζυ␜ξ\f＂\r␍X␜ψ\x1f$} [",
		out:  "‛． ＂Ｇ]η\r＂‛＊pＬFｍＮζυ␜ξ\f＂\r␍X␜ψ\x1f$} [",
	}, { // 842
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␈ ＂Ｇ]η\r＂＊pＬFｍＮζυ␜ξ\f＂\r␍X␜ψ\x1f$} .",
		out:  "␈ ＂Ｇ]η\r＂‛＊pＬFｍＮζυ␜ξ\f＂\r␍X␜ψ\x1f$} .",
	}, { // 843
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␈ ＂Ｇ]η\r＂＊pＬFｍＮζυ␜ξ\f＂\r␍X␜ψ\x1f$} ．",
		out:  "␈ ＂Ｇ]η\r＂‛＊pＬFｍＮζυ␜ξ\f＂\r␍X␜ψ\x1f$} ．",
	}, { // 844
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". 'ο␏Ｒ\x14W/L＃Ｍμ\tｈ␑ｊ~␉\x0fδ␏Ｙτ｛}\x1fζ θ",
		out:  "． 'ο␏Ｒ\x14W/L＃Ｍμ\tｈ␑ｊ~␉\x0fδ␏Ｙτ｛}\x1fζ θ",
	}, { // 845
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． 'ο␏Ｒ\x14W/L＃Ｍμ\tｈ␑ｊ~␉\x0fδ␏Ｙτ｛}\x1fζ θ",
		out:  "‛． 'ο␏Ｒ\x14W/L＃Ｍμ\tｈ␑ｊ~␉\x0fδ␏Ｙτ｛}\x1fζ θ",
	}, { // 846
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "? 'ο␏Ｒ\x14W/L＃Ｍμ\tｈ␑ｊ~␉\x0fδ␏Ｙτ｛}\x1fζ .",
		out:  "? 'ο␏Ｒ\x14W/L＃Ｍμ\tｈ␑ｊ~␉\x0fδ␏Ｙτ｛}\x1fζ .",
	}, { // 847
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "? 'ο␏Ｒ\x14W/L＃Ｍμ\tｈ␑ｊ~␉\x0fδ␏Ｙτ｛}\x1fζ ．",
		out:  "? 'ο␏Ｒ\x14W/L＃Ｍμ\tｈ␑ｊ~␉\x0fδ␏Ｙτ｛}\x1fζ ．",
	}, { // 848
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". \n<␏\x16ＶＡ%␌\a＂θ|μ_Ｈ␙σ9dν\x16λｌＡ␒5 ␟",
		out:  "． \n<␏\x16ＶＡ%␌\a＂θ|μ_Ｈ␙σ9dν\x16λｌＡ␒5 ␟",
	}, { // 849
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． \n<␏\x16ＶＡ%␌\a＂θ|μ_Ｈ␙σ9dν\x16λｌＡ␒5 ␟",
		out:  "‛． \n<␏\x16ＶＡ%␌\a＂θ|μ_Ｈ␙σ9dν\x16λｌＡ␒5 ␟",
	}, { // 850
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ο \n<␏\x16ＶＡ%␌\a＂θ|μ_Ｈ␙σ9dν\x16λｌＡ␒5 .",
		out:  "ο \n<␏\x16ＶＡ%␌\a＂θ|μ_Ｈ␙σ9dν\x16λｌＡ␒5 .",
	}, { // 851
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ο \n<␏\x16ＶＡ%␌\a＂θ|μ_Ｈ␙σ9dν\x16λｌＡ␒5 ．",
		out:  "ο \n<␏\x16ＶＡ%␌\a＂θ|μ_Ｈ␙σ9dν\x16λｌＡ␒5 ．",
	}, { // 852
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ｎδ␑\\␊hｄ:␟sθ＝\x04\x01␁ &\x00\"ＯγＭψαγ␂ /",
		out:  "． ｎδ␑\\␊hｄ:␟sθ＝\x04\x01␁ &␀\"ＯγＭψαγ␂ /",
	}, { // 853
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ｎδ␑\\␊hｄ:␟sθ＝\x04\x01␁ &\x00\"ＯγＭψαγ␂ /",
		out:  "‛． ｎδ␑\\␊hｄ:␟sθ＝\x04\x01␁ &␀\"ＯγＭψαγ␂ /",
	}, { // 854
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ｘ ｎδ␑\\␊hｄ:␟sθ＝\x04\x01␁ &\x00\"ＯγＭψαγ␂ .",
		out:  "ｘ ｎδ␑\\␊hｄ:␟sθ＝\x04\x01␁ &␀\"ＯγＭψαγ␂ .",
	}, { // 855
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ｘ ｎδ␑\\␊hｄ:␟sθ＝\x04\x01␁ &\x00\"ＯγＭψαγ␂ ．",
		out:  "ｘ ｎδ␑\\␊hｄ:␟sθ＝\x04\x01␁ &␀\"ＯγＭψαγ␂ ．",
	}, { // 856
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". \aψP\x1cｋ\x1c␆\bｚ:␆␘πω\a1｀>F*．␚ηPｄ␕ ρ",
		out:  "． \aψP\x1cｋ\x1c␆\bｚ:␆␘πω\a1｀>F*．␚ηPｄ␕ ρ",
	}, { // 857
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． \aψP\x1cｋ\x1c␆\bｚ:␆␘πω\a1｀>F*．␚ηPｄ␕ ρ",
		out:  "‛． \aψP\x1cｋ\x1c␆\bｚ:␆␘πω\a1｀>F*．␚ηPｄ␕ ρ",
	}, { // 858
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ｏ \aψP\x1cｋ\x1c␆\bｚ:␆␘πω\a1｀>F*．␚ηPｄ␕ .",
		out:  "ｏ \aψP\x1cｋ\x1c␆\bｚ:␆␘πω\a1｀>F*．␚ηPｄ␕ .",
	}, { // 859
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ｏ \aψP\x1cｋ\x1c␆\bｚ:␆␘πω\a1｀>F*．␚ηPｄ␕ ．",
		out:  "ｏ \aψP\x1cｋ\x1c␆\bｚ:␆␘πω\a1｀>F*．␚ηPｄ␕ ．",
	}, { // 860
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ␓:｝␀\x16/ａxx｀＂εW\t＜δＲ\rｐ\x1a$ξκｘ6␖ ␐",
		out:  "． ␓:｝‛␀\x16/ａxx｀＂εW\t＜δＲ␍ｐ\x1a$ξκｘ6␖ ␐",
	}, { // 861
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ␓:｝␀\x16/ａxx｀＂εW\t＜δＲ\rｐ\x1a$ξκｘ6␖ ␐",
		out:  "‛． ␓:｝‛␀\x16/ａxx｀＂εW\t＜δＲ␍ｐ\x1a$ξκｘ6␖ ␐",
	}, { // 862
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ζ ␓:｝␀\x16/ａxx｀＂εW\t＜δＲ\rｐ\x1a$ξκｘ6␖ .",
		out:  "ζ ␓:｝‛␀\x16/ａxx｀＂εW\t＜δＲ␍ｐ\x1a$ξκｘ6␖ .",
	}, { // 863
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ζ ␓:｝␀\x16/ａxx｀＂εW\t＜δＲ\rｐ\x1a$ξκｘ6␖ ．",
		out:  "ζ ␓:｝‛␀\x16/ａxx｀＂εW\t＜δＲ␍ｐ\x1a$ξκｘ6␖ ．",
	}, { // 864
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ␉|␆\x17T．＼ψρ(\x1f＄ς７｛]｜\\｝φ\x1a2(α\x03： ␓",
		out:  "． ␉|␆\x17T．＼ψρ(\x1f＄ς７｛]｜\\｝φ\x1a2(α\x03： ␓",
	}, { // 865
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ␉|␆\x17T．＼ψρ(\x1f＄ς７｛]｜\\｝φ\x1a2(α\x03： ␓",
		out:  "‛． ␉|␆\x17T．＼ψρ(\x1f＄ς７｛]｜\\｝φ\x1a2(α\x03： ␓",
	}, { // 866
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "S ␉|␆\x17T．＼ψρ(\x1f＄ς７｛]｜\\｝φ\x1a2(α\x03： .",
		out:  "S ␉|␆\x17T．＼ψρ(\x1f＄ς７｛]｜\\｝φ\x1a2(α\x03： .",
	}, { // 867
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "S ␉|␆\x17T．＼ψρ(\x1f＄ς７｛]｜\\｝φ\x1a2(α\x03： ．",
		out:  "S ␉|␆\x17T．＼ψρ(\x1f＄ς７｛]｜\\｝φ\x1a2(α\x03： ．",
	}, { // 868
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". \x1dｕχ[D］＃ε：␍Ｚ␓␖Vν｛3Sｄ\x15ψ_␗σ\b－ >",
		out:  "． ␝ｕχ[D］＃ε：‛␍Ｚ‛␓‛␖Vν｛3Sｄ␕ψ_‛␗σ␈－ >",
	}, { // 869
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． \x1dｕχ[D］＃ε：␍Ｚ␓␖Vν｛3Sｄ\x15ψ_␗σ\b－ >",
		out:  "‛． ␝ｕχ[D］＃ε：‛␍Ｚ‛␓‛␖Vν｛3Sｄ␕ψ_‛␗σ␈－ >",
	}, { // 870
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ς \x1dｕχ[D］＃ε：␍Ｚ␓␖Vν｛3Sｄ\x15ψ_␗σ\b－ .",
		out:  "ς ␝ｕχ[D］＃ε：‛␍Ｚ‛␓‛␖Vν｛3Sｄ␕ψ_‛␗σ␈－ .",
	}, { // 871
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ς \x1dｕχ[D］＃ε：␍Ｚ␓␖Vν｛3Sｄ\x15ψ_␗σ\b－ ．",
		out:  "ς ␝ｕχ[D］＃ε：‛␍Ｚ‛␓‛␖Vν｛3Sｄ␕ψ_‛␗σ␈－ ．",
	}, { // 872
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~［ο<ｑ\rK～θＳJ␒J\\ζｌβ*\x13Ｒ\x14αρp\x05*␒~␌",
		out:  "．~［ο<ｑ\rK～θＳJ␒J\\ζｌβ*\x13Ｒ\x14αρp\x05*␒~␌",
	}, { // 873
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~［ο<ｑ\rK～θＳJ␒J\\ζｌβ*\x13Ｒ\x14αρp\x05*␒~␌",
		out:  "‛．~［ο<ｑ\rK～θＳJ␒J\\ζｌβ*\x13Ｒ\x14αρp\x05*␒~␌",
	}, { // 874
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␕~［ο<ｑ\rK～θＳJ␒J\\ζｌβ*\x13Ｒ\x14αρp\x05*␒~.",
		out:  "␕~［ο<ｑ\rK～θＳJ␒J\\ζｌβ*\x13Ｒ\x14αρp\x05*␒~.",
	}, { // 875
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␕~［ο<ｑ\rK～θＳJ␒J\\ζｌβ*\x13Ｒ\x14αρp\x05*␒~．",
		out:  "␕~［ο<ｑ\rK～θＳJ␒J\\ζｌβ*\x13Ｒ\x14αρp\x05*␒~．",
	}, { // 876
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~；*\x05＂[v\x19Ｚ␕＾OψＹ\x02π␀ι9>υλ=␟ｗτq~５",
		out:  "．~；*\x05＂[v\x19Ｚ␕＾OψＹ\x02π‛␀ι9>υλ=␟ｗτq~５",
	}, { // 877
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~；*\x05＂[v\x19Ｚ␕＾OψＹ\x02π␀ι9>υλ=␟ｗτq~５",
		out:  "‛．~；*\x05＂[v\x19Ｚ␕＾OψＹ\x02π‛␀ι9>υλ=␟ｗτq~５",
	}, { // 878
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "／~；*\x05＂[v\x19Ｚ␕＾OψＹ\x02π␀ι9>υλ=␟ｗτq~.",
		out:  "‛／~；*\x05＂[v\x19Ｚ␕＾OψＹ\x02π‛␀ι9>υλ=␟ｗτq~.",
	}, { // 879
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "／~；*\x05＂[v\x19Ｚ␕＾OψＹ\x02π␀ι9>υλ=␟ｗτq~．",
		out:  "‛／~；*\x05＂[v\x19Ｚ␕＾OψＹ\x02π‛␀ι9>υλ=␟ｗτq~．",
	}, { // 880
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~␓#δ４／＆#T\t(％u\x1a$ｅ␙␍νfθgｈ：３μι~f",
		out:  "．~␓#δ４／＆#T\t(％u\x1a$ｅ␙␍νfθgｈ：３μι~f",
	}, { // 881
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~␓#δ４／＆#T\t(％u\x1a$ｅ␙␍νfθgｈ：３μι~f",
		out:  "‛．~␓#δ４／＆#T\t(％u\x1a$ｅ␙␍νfθgｈ：３μι~f",
	}, { // 882
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "κ~␓#δ４／＆#T\t(％u\x1a$ｅ␙␍νfθgｈ：３μι~.",
		out:  "κ~␓#δ４／＆#T\t(％u\x1a$ｅ␙␍νfθgｈ：３μι~.",
	}, { // 883
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "κ~␓#δ４／＆#T\t(％u\x1a$ｅ␙␍νfθgｈ：３μι~．",
		out:  "κ~␓#δ４／＆#T\t(％u\x1a$ｅ␙␍νfθgｈ：３μι~．",
	}, { // 884
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~\a\x0eτＥ２％␆δπ\x1d\n＜＊␓＃ARη␙ＵCγ=QF\x19~ψ",
		out:  "．~\a\x0eτＥ２％␆δπ\x1d\n＜＊␓＃ARη␙ＵCγ=QF\x19~ψ",
	}, { // 885
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~\a\x0eτＥ２％␆δπ\x1d\n＜＊␓＃ARη␙ＵCγ=QF\x19~ψ",
		out:  "‛．~\a\x0eτＥ２％␆δπ\x1d\n＜＊␓＃ARη␙ＵCγ=QF\x19~ψ",
	}, { // 886
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "１~\a\x0eτＥ２％␆δπ\x1d\n＜＊␓＃ARη␙ＵCγ=QF\x19~.",
		out:  "１~\a\x0eτＥ２％␆δπ\x1d\n＜＊␓＃ARη␙ＵCγ=QF\x19~.",
	}, { // 887
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "１~\a\x0eτＥ２％␆δπ\x1d\n＜＊␓＃ARη␙ＵCγ=QF\x19~．",
		out:  "１~\a\x0eτＥ２％␆δπ\x1d\n＜＊␓＃ARη␙ＵCγ=QF\x19~．",
	}, { // 888
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~␈Ｖ\x01rθ６ν\b␂Lο5P｛␜\n１θVξ:\x10␃␕τ␡~'",
		out:  "．~␈Ｖ\x01rθ６ν\b␂Lο5P｛␜\n１θVξ:\x10␃␕τ␡~'",
	}, { // 889
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~␈Ｖ\x01rθ６ν\b␂Lο5P｛␜\n１θVξ:\x10␃␕τ␡~'",
		out:  "‛．~␈Ｖ\x01rθ６ν\b␂Lο5P｛␜\n１θVξ:\x10␃␕τ␡~'",
	}, { // 890
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "＿~␈Ｖ\x01rθ６ν\b␂Lο5P｛␜\n１θVξ:\x10␃␕τ␡~.",
		out:  "＿~␈Ｖ\x01rθ６ν\b␂Lο5P｛␜\n１θVξ:\x10␃␕τ␡~.",
	}, { // 891
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "＿~␈Ｖ\x01rθ６ν\b␂Lο5P｛␜\n１θVξ:\x10␃␕τ␡~．",
		out:  "＿~␈Ｖ\x01rθ６ν\b␂Lο5P｛␜\n１θVξ:\x10␃␕τ␡~．",
	}, { // 892
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~?`ｆ｜ι［2oστ\u007fｙ\x02|｀εC\x02＃W␡θ＇＂＇h~δ",
		out:  "．~?`ｆ｜ι‛［2oστ\u007fｙ\x02|｀εC\x02＃W␡θ＇＂＇h~δ",
	}, { // 893
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~?`ｆ｜ι［2oστ\u007fｙ\x02|｀εC\x02＃W␡θ＇＂＇h~δ",
		out:  "‛．~?`ｆ｜ι‛［2oστ\u007fｙ\x02|｀εC\x02＃W␡θ＇＂＇h~δ",
	}, { // 894
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ｔ~?`ｆ｜ι［2oστ\u007fｙ\x02|｀εC\x02＃W␡θ＇＂＇h~.",
		out:  "ｔ~?`ｆ｜ι‛［2oστ\u007fｙ\x02|｀εC\x02＃W␡θ＇＂＇h~.",
	}, { // 895
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ｔ~?`ｆ｜ι［2oστ\u007fｙ\x02|｀εC\x02＃W␡θ＇＂＇h~．",
		out:  "ｔ~?`ｆ｜ι‛［2oστ\u007fｙ\x02|｀εC\x02＃W␡θ＇＂＇h~．",
	}, { // 896
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~␞␛\bY*\x1fＤ`\n＋␡μ!～\\ＵεＤυ>o［+＂χ？~ξ",
		out:  "．~␞␛\bY*\x1fＤ`\n＋␡μ!～\\ＵεＤυ>o［+＂χ？~ξ",
	}, { // 897
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~␞␛\bY*\x1fＤ`\n＋␡μ!～\\ＵεＤυ>o［+＂χ？~ξ",
		out:  "‛．~␞␛\bY*\x1fＤ`\n＋␡μ!～\\ＵεＤυ>o［+＂χ？~ξ",
	}, { // 898
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "k~␞␛\bY*\x1fＤ`\n＋␡μ!～\\ＵεＤυ>o［+＂χ？~.",
		out:  "k~␞␛\bY*\x1fＤ`\n＋␡μ!～\\ＵεＤυ>o［+＂χ？~.",
	}, { // 899
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "k~␞␛\bY*\x1fＤ`\n＋␡μ!～\\ＵεＤυ>o［+＂χ？~．",
		out:  "k~␞␛\bY*\x1fＤ`\n＋␡μ!～\\ＵεＤυ>o［+＂χ？~．",
	}, { // 900
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~ｋＢ\x11 \x1a：＊／<aμ\vιo０\"λuＴ/␉Ｐ\x14ολρ~：",
		out:  "．~ｋＢ\x11 \x1a：＊／<aμ\vιo０＂λuＴ/␉Ｐ\x14ολρ~：",
	}, { // 901
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~ｋＢ\x11 \x1a：＊／<aμ\vιo０\"λuＴ/␉Ｐ\x14ολρ~：",
		out:  "‛．~ｋＢ\x11 \x1a：＊／<aμ\vιo０＂λuＴ/␉Ｐ\x14ολρ~：",
	}, { // 902
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␞~ｋＢ\x11 \x1a：＊／<aμ\vιo０\"λuＴ/␉Ｐ\x14ολρ~.",
		out:  "␞~ｋＢ\x11 \x1a：＊／<aμ\vιo０＂λuＴ/␉Ｐ\x14ολρ~.",
	}, { // 903
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␞~ｋＢ\x11 \x1a：＊／<aμ\vιo０\"λuＴ/␉Ｐ\x14ολρ~．",
		out:  "␞~ｋＢ\x11 \x1a：＊／<aμ\vιo０＂λuＴ/␉Ｐ\x14ολρ~．",
	}, { // 904
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~％\b␐ηψ␟\x16\x13S２＄␊^␖θ2*φSｎ｛␈－\x00Zｂ~/",
		out:  "．~％\b␐ηψ␟\x16\x13S２＄␊^␖θ2*φSｎ｛␈－␀Zｂ~/",
	}, { // 905
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~％\b␐ηψ␟\x16\x13S２＄␊^␖θ2*φSｎ｛␈－\x00Zｂ~/",
		out:  "‛．~％\b␐ηψ␟\x16\x13S２＄␊^␖θ2*φSｎ｛␈－␀Zｂ~/",
	}, { // 906
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "δ~％\b␐ηψ␟\x16\x13S２＄␊^␖θ2*φSｎ｛␈－\x00Zｂ~.",
		out:  "δ~％\b␐ηψ␟\x16\x13S２＄␊^␖θ2*φSｎ｛␈－␀Zｂ~.",
	}, { // 907
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "δ~％\b␐ηψ␟\x16\x13S２＄␊^␖θ2*φSｎ｛␈－\x00Zｂ~．",
		out:  "δ~％\b␐ηψ␟\x16\x13S２＄␊^␖θ2*φSｎ｛␈－␀Zｂ~．",
	}, { // 908
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~＃␑＠＝πｐ%sυ␏y:ι\tςｉ␗\x1eι␃C\x16/δV]~'",
		out:  "．~＃␑＠＝πｐ%sυ␏y:ι\tςｉ␗\x1eι␃C\x16/δV]~'",
	}, { // 909
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~＃␑＠＝πｐ%sυ␏y:ι\tςｉ␗\x1eι␃C\x16/δV]~'",
		out:  "‛．~＃␑＠＝πｐ%sυ␏y:ι\tςｉ␗\x1eι␃C\x16/δV]~'",
	}, { // 910
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "４~＃␑＠＝πｐ%sυ␏y:ι\tςｉ␗\x1eι␃C\x16/δV]~.",
		out:  "４~＃␑＠＝πｐ%sυ␏y:ι\tςｉ␗\x1eι␃C\x16/δV]~.",
	}, { // 911
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "４~＃␑＠＝πｐ%sυ␏y:ι\tςｉ␗\x1eι␃C\x16/δV]~．",
		out:  "４~＃␑＠＝πｐ%sυ␏y:ι\tςｉ␗\x1eι␃C\x16/δV]~．",
	}, { // 912
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~ｆζιψR␐␐R␡\x0e\x1cζ\\\rσ␉／?␝\f－*\x10）ｏ2~γ",
		out:  "．~ｆζιψR␐␐R␡\x0e\x1cζ\\\rσ␉／?␝\f－＊\x10）ｏ2~γ",
	}, { // 913
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~ｆζιψR␐␐R␡\x0e\x1cζ\\\rσ␉／?␝\f－*\x10）ｏ2~γ",
		out:  "‛．~ｆζιψR␐␐R␡\x0e\x1cζ\\\rσ␉／?␝\f－＊\x10）ｏ2~γ",
	}, { // 914
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "$~ｆζιψR␐␐R␡\x0e\x1cζ\\\rσ␉／?␝\f－*\x10）ｏ2~.",
		out:  "$~ｆζιψR␐␐R␡\x0e\x1cζ\\\rσ␉／?␝\f－＊\x10）ｏ2~.",
	}, { // 915
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "$~ｆζιψR␐␐R␡\x0e\x1cζ\\\rσ␉／?␝\f－*\x10）ｏ2~．",
		out:  "$~ｆζιψR␐␐R␡\x0e\x1cζ\\\rσ␉／?␝\f－＊\x10）ｏ2~．",
	}, { // 916
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~Ｑσ6\x06ω\x10τ␈E：ρ␑x＃?oA）#\x1bＮRκ%ｈε~␙",
		out:  "．~Ｑσ6\x06ω\x10τ␈E：ρ␑x＃?oA）#\x1bＮRκ%ｈε~␙",
	}, { // 917
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~Ｑσ6\x06ω\x10τ␈E：ρ␑x＃?oA）#\x1bＮRκ%ｈε~␙",
		out:  "‛．~Ｑσ6\x06ω\x10τ␈E：ρ␑x＃?oA）#\x1bＮRκ%ｈε~␙",
	}, { // 918
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "，~Ｑσ6\x06ω\x10τ␈E：ρ␑x＃?oA）#\x1bＮRκ%ｈε~.",
		out:  "，~Ｑσ6\x06ω\x10τ␈E：ρ␑x＃?oA）#\x1bＮRκ%ｈε~.",
	}, { // 919
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "，~Ｑσ6\x06ω\x10τ␈E：ρ␑x＃?oA）#\x1bＮRκ%ｈε~．",
		out:  "，~Ｑσ6\x06ω\x10τ␈E：ρ␑x＃?oA）#\x1bＮRκ%ｈε~．",
	}, { // 920
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~`μｎ\a\a\x03<R␏Y７ｚπ␐ν＇QA\x14_υK␏：：３~μ",
		out:  "．~`μｎ\a\a\x03<R␏Y７ｚπ␐ν＇QA\x14_υK␏：：３~μ",
	}, { // 921
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~`μｎ\a\a\x03<R␏Y７ｚπ␐ν＇QA\x14_υK␏：：３~μ",
		out:  "‛．~`μｎ\a\a\x03<R␏Y７ｚπ␐ν＇QA\x14_υK␏：：３~μ",
	}, { // 922
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "π~`μｎ\a\a\x03<R␏Y７ｚπ␐ν＇QA\x14_υK␏：：３~.",
		out:  "π~`μｎ\a\a\x03<R␏Y７ｚπ␐ν＇QA\x14_υK␏：：３~.",
	}, { // 923
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "π~`μｎ\a\a\x03<R␏Y７ｚπ␐ν＇QA\x14_υK␏：：３~．",
		out:  "π~`μｎ\a\a\x03<R␏Y７ｚπ␐ν＇QA\x14_υK␏：：３~．",
	}, { // 924
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~m7␙ｋ␑\a9Ｌ\x03␉υ%+ποσ：:i␟ＰＭ＄ε\f?~Ｄ",
		out:  "．~m7␙ｋ␑\a9Ｌ\x03␉υ％+ποσ：:i␟ＰＭ＄ε\f?~Ｄ",
	}, { // 925
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~m7␙ｋ␑\a9Ｌ\x03␉υ%+ποσ：:i␟ＰＭ＄ε\f?~Ｄ",
		out:  "‛．~m7␙ｋ␑\a9Ｌ\x03␉υ％+ποσ：:i␟ＰＭ＄ε\f?~Ｄ",
	}, { // 926
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "β~m7␙ｋ␑\a9Ｌ\x03␉υ%+ποσ：:i␟ＰＭ＄ε\f?~.",
		out:  "β~m7␙ｋ␑\a9Ｌ\x03␉υ％+ποσ：:i␟ＰＭ＄ε\f?~.",
	}, { // 927
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "β~m7␙ｋ␑\a9Ｌ\x03␉υ%+ποσ：:i␟ＰＭ＄ε\f?~．",
		out:  "β~m7␙ｋ␑\a9Ｌ\x03␉υ％+ποσ：:i␟ＰＭ＄ε\f?~．",
	}, { // 928
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~@ρV_Ｏερμ\x1c／\uff00␊fｒ␔\n*\x14ｓι］␌\u007f1>Ｃ~φ",
		out:  "．~@ρV_Ｏερμ\x1c／\uff00␊fｒ␔\n*\x14ｓι］␌\u007f1>Ｃ~φ",
	}, { // 929
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~@ρV_Ｏερμ\x1c／\uff00␊fｒ␔\n*\x14ｓι］␌\u007f1>Ｃ~φ",
		out:  "‛．~@ρV_Ｏερμ\x1c／\uff00␊fｒ␔\n*\x14ｓι］␌\u007f1>Ｃ~φ",
	}, { // 930
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "：~@ρV_Ｏερμ\x1c／\uff00␊fｒ␔\n*\x14ｓι］␌\u007f1>Ｃ~.",
		out:  "：~@ρV_Ｏερμ\x1c／\uff00␊fｒ␔\n*\x14ｓι］␌\u007f1>Ｃ~.",
	}, { // 931
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "：~@ρV_Ｏερμ\x1c／\uff00␊fｒ␔\n*\x14ｓι］␌\u007f1>Ｃ~．",
		out:  "：~@ρV_Ｏερμ\x1c／\uff00␊fｒ␔\n*\x14ｓι］␌\u007f1>Ｃ~．",
	}, { // 932
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~ξ%\tλｈ(ωＵHν［｜μQ␂3␃Ｗ\x12␒ξ\x1f:␍R\x04~＼",
		out:  "．~ξ%\tλｈ(ωＵHν［｜μQ␂3␃Ｗ\x12␒ξ\x1f:‛␍R\x04~＼",
	}, { // 933
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~ξ%\tλｈ(ωＵHν［｜μQ␂3␃Ｗ\x12␒ξ\x1f:␍R\x04~＼",
		out:  "‛．~ξ%\tλｈ(ωＵHν［｜μQ␂3␃Ｗ\x12␒ξ\x1f:‛␍R\x04~＼",
	}, { // 934
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\n~ξ%\tλｈ(ωＵHν［｜μQ␂3␃Ｗ\x12␒ξ\x1f:␍R\x04~.",
		out:  "␊~ξ%\tλｈ(ωＵHν［｜μQ␂3␃Ｗ\x12␒ξ\x1f:‛␍R\x04~.",
	}, { // 935
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\n~ξ%\tλｈ(ωＵHν［｜μQ␂3␃Ｗ\x12␒ξ\x1f:␍R\x04~．",
		out:  "␊~ξ%\tλｈ(ωＵHν［｜μQ␂3␃Ｗ\x12␒ξ\x1f:‛␍R\x04~．",
	}, { // 936
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~\b\x0fSςε｀ＦυδR:4␒／␌Ａ\a＃｀\x05Ｚｕ,␖BA~κ",
		out:  "．~\b\x0fSςε｀ＦυδR:4␒／␌Ａ\a＃｀\x05Ｚｕ,␖BA~κ",
	}, { // 937
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~\b\x0fSςε｀ＦυδR:4␒／␌Ａ\a＃｀\x05Ｚｕ,␖BA~κ",
		out:  "‛．~\b\x0fSςε｀ＦυδR:4␒／␌Ａ\a＃｀\x05Ｚｕ,␖BA~κ",
	}, { // 938
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\x15~\b\x0fSςε｀ＦυδR:4␒／␌Ａ\a＃｀\x05Ｚｕ,␖BA~.",
		out:  "\x15~\b\x0fSςε｀ＦυδR:4␒／␌Ａ\a＃｀\x05Ｚｕ,␖BA~.",
	}, { // 939
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\x15~\b\x0fSςε｀ＦυδR:4␒／␌Ａ\a＃｀\x05Ｚｕ,␖BA~．",
		out:  "\x15~\b\x0fSςε｀ＦυδR:4␒／␌Ａ\a＃｀\x05Ｚｕ,␖BA~．",
	}, { // 940
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~ｂ\v+β\n␡Ｇ=\x11ξχ␙Ｗ／Ｋ\"@\uff00C\x1dτ１ξ␏␄\x00~␕",
		out:  "．~ｂ␋+β␊␡Ｇ=␑ξχ‛␙Ｗ／Ｋ\"@\uff00C␝τ１ξ‛␏‛␄␀~‛␕",
	}, { // 941
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~ｂ\v+β\n␡Ｇ=\x11ξχ␙Ｗ／Ｋ\"@\uff00C\x1dτ１ξ␏␄\x00~␕",
		out:  "‛．~ｂ␋+β␊␡Ｇ=␑ξχ‛␙Ｗ／Ｋ\"@\uff00C␝τ１ξ‛␏‛␄␀~‛␕",
	}, { // 942
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "θ~ｂ\v+β\n␡Ｇ=\x11ξχ␙Ｗ／Ｋ\"@\uff00C\x1dτ１ξ␏␄\x00~.",
		out:  "θ~ｂ␋+β␊␡Ｇ=␑ξχ‛␙Ｗ／Ｋ\"@\uff00C␝τ１ξ‛␏‛␄␀~.",
	}, { // 943
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "θ~ｂ\v+β\n␡Ｇ=\x11ξχ␙Ｗ／Ｋ\"@\uff00C\x1dτ１ξ␏␄\x00~．",
		out:  "θ~ｂ␋+β␊␡Ｇ=␑ξχ‛␙Ｗ／Ｋ\"@\uff00C␝τ１ξ‛␏‛␄␀~．",
	}, { // 944
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\t␔",
		out:  "．\t␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\t␔",
	}, { // 945
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\t␔",
		out:  "‛．\t␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\t␔",
	}, { // 946
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\n␔",
		out:  "．\n␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\n␔",
	}, { // 947
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\n␔",
		out:  "‛．\n␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\n␔",
	}, { // 948
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\v␔",
		out:  "．\v␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\v␔",
	}, { // 949
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\v␔",
		out:  "‛．\v␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\v␔",
	}, { // 950
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\r␔",
		out:  "．\r␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\r␔",
	}, { // 951
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\r␔",
		out:  "‛．\r␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\r␔",
	}, { // 952
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "o\t␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\t.",
		out:  "o\t␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\t.",
	}, { // 953
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "o\t␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\t．",
		out:  "o\t␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\t．",
	}, { // 954
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "o\n␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\n.",
		out:  "o\n␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\n.",
	}, { // 955
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "o\n␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\n．",
		out:  "o\n␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\n．",
	}, { // 956
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "o\v␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\v.",
		out:  "o\v␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\v.",
	}, { // 957
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "o\v␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\v．",
		out:  "o\v␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\v．",
	}, { // 958
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "o\r␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\r.",
		out:  "o\r␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\r.",
	}, { // 959
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "o\r␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\r．",
		out:  "o\r␇\x10␒υ\x1b5γεｗｊ\x01\x01\x1cβＩφ.｀＇＝␒.\x11Ｆlａ\r．",
	}, { // 960
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tιZ＼：｜␊␞␏ς/：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\tχ",
		out:  "．\tιZ＼：｜␊␞␏ς／：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\tχ",
	}, { // 961
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tιZ＼：｜␊␞␏ς/：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\tχ",
		out:  "‛．\tιZ＼：｜␊␞␏ς／：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\tχ",
	}, { // 962
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nιZ＼：｜␊␞␏ς/：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\nχ",
		out:  "．\nιZ＼：｜␊␞␏ς／：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\nχ",
	}, { // 963
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nιZ＼：｜␊␞␏ς/：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\nχ",
		out:  "‛．\nιZ＼：｜␊␞␏ς／：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\nχ",
	}, { // 964
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vιZ＼：｜␊␞␏ς/：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\vχ",
		out:  "．\vιZ＼：｜␊␞␏ς／：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\vχ",
	}, { // 965
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vιZ＼：｜␊␞␏ς/：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\vχ",
		out:  "‛．\vιZ＼：｜␊␞␏ς／：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\vχ",
	}, { // 966
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rιZ＼：｜␊␞␏ς/：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\rχ",
		out:  "．\rιZ＼：｜␊␞␏ς／：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\rχ",
	}, { // 967
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rιZ＼：｜␊␞␏ς/：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\rχ",
		out:  "‛．\rιZ＼：｜␊␞␏ς／：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\rχ",
	}, { // 968
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "2\tιZ＼：｜␊␞␏ς/：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\t.",
		out:  "2\tιZ＼：｜␊␞␏ς／：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\t.",
	}, { // 969
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "2\tιZ＼：｜␊␞␏ς/：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\t．",
		out:  "2\tιZ＼：｜␊␞␏ς／：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\t．",
	}, { // 970
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "2\nιZ＼：｜␊␞␏ς/：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\n.",
		out:  "2\nιZ＼：｜␊␞␏ς／：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\n.",
	}, { // 971
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "2\nιZ＼：｜␊␞␏ς/：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\n．",
		out:  "2\nιZ＼：｜␊␞␏ς／：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\n．",
	}, { // 972
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "2\vιZ＼：｜␊␞␏ς/：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\v.",
		out:  "2\vιZ＼：｜␊␞␏ς／：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\v.",
	}, { // 973
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "2\vιZ＼：｜␊␞␏ς/：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\v．",
		out:  "2\vιZ＼：｜␊␞␏ς／：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\v．",
	}, { // 974
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "2\rιZ＼：｜␊␞␏ς/：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\r.",
		out:  "2\rιZ＼：｜␊␞␏ς／：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\r.",
	}, { // 975
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "2\rιZ＼：｜␊␞␏ς/：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\r．",
		out:  "2\rιZ＼：｜␊␞␏ς／：␂5υ＼6nδ:\x1d４η\x01\x1cＵ｝\r．",
	}, { // 976
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tδ␏\r\"＇}υ＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\t-",
		out:  "．\tδ␏\r\"‛＇}υ‛＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\t-",
	}, { // 977
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tδ␏\r\"＇}υ＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\t-",
		out:  "‛．\tδ␏\r\"‛＇}υ‛＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\t-",
	}, { // 978
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nδ␏\r\"＇}υ＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\n-",
		out:  "．\nδ␏\r\"‛＇}υ‛＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\n-",
	}, { // 979
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nδ␏\r\"＇}υ＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\n-",
		out:  "‛．\nδ␏\r\"‛＇}υ‛＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\n-",
	}, { // 980
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vδ␏\r\"＇}υ＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\v-",
		out:  "．\vδ␏\r\"‛＇}υ‛＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\v-",
	}, { // 981
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vδ␏\r\"＇}υ＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\v-",
		out:  "‛．\vδ␏\r\"‛＇}υ‛＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\v-",
	}, { // 982
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rδ␏\r\"＇}υ＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\r-",
		out:  "．\rδ␏\r\"‛＇}υ‛＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\r-",
	}, { // 983
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rδ␏\r\"＇}υ＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\r-",
		out:  "‛．\rδ␏\r\"‛＇}υ‛＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\r-",
	}, { // 984
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x1a\tδ␏\r\"＇}υ＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\t.",
		out:  "\x1a\tδ␏\r\"‛＇}υ‛＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\t.",
	}, { // 985
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x1a\tδ␏\r\"＇}υ＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\t．",
		out:  "\x1a\tδ␏\r\"‛＇}υ‛＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\t．",
	}, { // 986
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x1a\nδ␏\r\"＇}υ＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\n.",
		out:  "\x1a\nδ␏\r\"‛＇}υ‛＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\n.",
	}, { // 987
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x1a\nδ␏\r\"＇}υ＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\n．",
		out:  "\x1a\nδ␏\r\"‛＇}υ‛＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\n．",
	}, { // 988
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x1a\vδ␏\r\"＇}υ＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\v.",
		out:  "\x1a\vδ␏\r\"‛＇}υ‛＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\v.",
	}, { // 989
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x1a\vδ␏\r\"＇}υ＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\v．",
		out:  "\x1a\vδ␏\r\"‛＇}υ‛＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\v．",
	}, { // 990
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x1a\rδ␏\r\"＇}υ＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\r.",
		out:  "\x1a\rδ␏\r\"‛＇}υ‛＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\r.",
	}, { // 991
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x1a\rδ␏\r\"＇}υ＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\r．",
		out:  "\x1a\rδ␏\r\"‛＇}υ‛＇ｔ␓/␆␐λｚｔ\x1aη＂ｑxwμF6Ｏ\r．",
	}, { // 992
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\ts",
		out:  "．\t2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\ts",
	}, { // 993
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\ts",
		out:  "‛．\t2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\ts",
	}, { // 994
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\ns",
		out:  "．\n2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\ns",
	}, { // 995
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\ns",
		out:  "‛．\n2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\ns",
	}, { // 996
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\vs",
		out:  "．\v2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\vs",
	}, { // 997
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\vs",
		out:  "‛．\v2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\vs",
	}, { // 998
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\rs",
		out:  "．\r2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\rs",
	}, { // 999
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\rs",
		out:  "‛．\r2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\rs",
	}, { // 1000
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ζ\t2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\t.",
		out:  "ζ\t2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\t.",
	}, { // 1001
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ζ\t2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\t．",
		out:  "ζ\t2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\t．",
	}, { // 1002
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ζ\n2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\n.",
		out:  "ζ\n2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\n.",
	}, { // 1003
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ζ\n2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\n．",
		out:  "ζ\n2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\n．",
	}, { // 1004
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ζ\v2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\v.",
		out:  "ζ\v2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\v.",
	}, { // 1005
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ζ\v2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\v．",
		out:  "ζ\v2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\v．",
	}, { // 1006
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ζ\r2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\r.",
		out:  "ζ\r2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\r.",
	}, { // 1007
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ζ\r2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\r．",
		out:  "ζ\r2η\x1f:CＺχＵ5ｎμ\u007fμ\x1ew\x0e␍＜ε／ｃ5␋␐:␋\r．",
	}, { // 1008
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\tα",
		out:  "．\tＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\tα",
	}, { // 1009
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\tα",
		out:  "‛．\tＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\tα",
	}, { // 1010
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\nα",
		out:  "．\nＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\nα",
	}, { // 1011
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\nα",
		out:  "‛．\nＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\nα",
	}, { // 1012
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\vα",
		out:  "．\vＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\vα",
	}, { // 1013
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\vα",
		out:  "‛．\vＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\vα",
	}, { // 1014
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\rα",
		out:  "．\rＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\rα",
	}, { // 1015
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\rα",
		out:  "‛．\rＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\rα",
	}, { // 1016
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x1d\tＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\t.",
		out:  "\x1d\tＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\t.",
	}, { // 1017
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x1d\tＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\t．",
		out:  "\x1d\tＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\t．",
	}, { // 1018
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x1d\nＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\n.",
		out:  "\x1d\nＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\n.",
	}, { // 1019
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x1d\nＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\n．",
		out:  "\x1d\nＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\n．",
	}, { // 1020
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x1d\vＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\v.",
		out:  "\x1d\vＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\v.",
	}, { // 1021
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x1d\vＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\v．",
		out:  "\x1d\vＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\v．",
	}, { // 1022
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x1d\rＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\r.",
		out:  "\x1d\rＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\r.",
	}, { // 1023
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x1d\rＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\r．",
		out:  "\x1d\rＵ－{␌f？７\x06␌ω：\x14＇\r|\x17`ι｝κιi\x11／a␈\r．",
	}, { // 1024
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\t＼",
		out:  "．\t\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\t＼",
	}, { // 1025
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\t＼",
		out:  "‛．\t\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\t＼",
	}, { // 1026
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\n＼",
		out:  "．\n\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\n＼",
	}, { // 1027
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\n＼",
		out:  "‛．\n\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\n＼",
	}, { // 1028
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\v＼",
		out:  "．\v\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\v＼",
	}, { // 1029
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\v＼",
		out:  "‛．\v\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\v＼",
	}, { // 1030
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\r＼",
		out:  "．\r\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\r＼",
	}, { // 1031
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\r＼",
		out:  "‛．\r\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\r＼",
	}, { // 1032
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "_\t\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\t.",
		out:  "_\t\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\t.",
	}, { // 1033
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "_\t\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\t．",
		out:  "_\t\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\t．",
	}, { // 1034
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "_\n\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\n.",
		out:  "_\n\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\n.",
	}, { // 1035
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "_\n\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\n．",
		out:  "_\n\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\n．",
	}, { // 1036
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "_\v\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\v.",
		out:  "_\v\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\v.",
	}, { // 1037
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "_\v\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\v．",
		out:  "_\v\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\v．",
	}, { // 1038
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "_\r\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\r.",
		out:  "_\r\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\r.",
	}, { // 1039
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "_\r\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\r．",
		out:  "_\r\x0e\"δ?＃％ν*␖␏␡$＾ξ:$κ\nxφ(Ｅδ＾*３\r．",
	}, { // 1040
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tυο␓fＪ]Ｖπ\x12D\x00ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\t＇",
		out:  "．\tυο␓fＪ]Ｖπ\x12D␀ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\t＇",
	}, { // 1041
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tυο␓fＪ]Ｖπ\x12D\x00ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\t＇",
		out:  "‛．\tυο␓fＪ]Ｖπ\x12D␀ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\t＇",
	}, { // 1042
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nυο␓fＪ]Ｖπ\x12D\x00ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\n＇",
		out:  "．\nυο␓fＪ]Ｖπ\x12D␀ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\n＇",
	}, { // 1043
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nυο␓fＪ]Ｖπ\x12D\x00ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\n＇",
		out:  "‛．\nυο␓fＪ]Ｖπ\x12D␀ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\n＇",
	}, { // 1044
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vυο␓fＪ]Ｖπ\x12D\x00ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\v＇",
		out:  "．\vυο␓fＪ]Ｖπ\x12D␀ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\v＇",
	}, { // 1045
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vυο␓fＪ]Ｖπ\x12D\x00ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\v＇",
		out:  "‛．\vυο␓fＪ]Ｖπ\x12D␀ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\v＇",
	}, { // 1046
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rυο␓fＪ]Ｖπ\x12D\x00ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\r＇",
		out:  "．\rυο␓fＪ]Ｖπ\x12D␀ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\r＇",
	}, { // 1047
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rυο␓fＪ]Ｖπ\x12D\x00ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\r＇",
		out:  "‛．\rυο␓fＪ]Ｖπ\x12D␀ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\r＇",
	}, { // 1048
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｚ\tυο␓fＪ]Ｖπ\x12D\x00ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\t.",
		out:  "Ｚ\tυο␓fＪ]Ｖπ\x12D␀ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\t.",
	}, { // 1049
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｚ\tυο␓fＪ]Ｖπ\x12D\x00ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\t．",
		out:  "Ｚ\tυο␓fＪ]Ｖπ\x12D␀ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\t．",
	}, { // 1050
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｚ\nυο␓fＪ]Ｖπ\x12D\x00ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\n.",
		out:  "Ｚ\nυο␓fＪ]Ｖπ\x12D␀ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\n.",
	}, { // 1051
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｚ\nυο␓fＪ]Ｖπ\x12D\x00ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\n．",
		out:  "Ｚ\nυο␓fＪ]Ｖπ\x12D␀ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\n．",
	}, { // 1052
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｚ\vυο␓fＪ]Ｖπ\x12D\x00ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\v.",
		out:  "Ｚ\vυο␓fＪ]Ｖπ\x12D␀ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\v.",
	}, { // 1053
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｚ\vυο␓fＪ]Ｖπ\x12D\x00ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\v．",
		out:  "Ｚ\vυο␓fＪ]Ｖπ\x12D␀ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\v．",
	}, { // 1054
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｚ\rυο␓fＪ]Ｖπ\x12D\x00ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\r.",
		out:  "Ｚ\rυο␓fＪ]Ｖπ\x12D␀ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\r.",
	}, { // 1055
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｚ\rυο␓fＪ]Ｖπ\x12D\x00ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\r．",
		out:  "Ｚ\rυο␓fＪ]Ｖπ\x12D␀ｓJ\a=υ␍␡ν\x1b␜>␓\x01␌τ\r．",
	}, { // 1056
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\t&",
		out:  "．\tl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\t&",
	}, { // 1057
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\t&",
		out:  "‛．\tl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\t&",
	}, { // 1058
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\n&",
		out:  "．\nl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\n&",
	}, { // 1059
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\n&",
		out:  "‛．\nl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\n&",
	}, { // 1060
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\v&",
		out:  "．\vl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\v&",
	}, { // 1061
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\v&",
		out:  "‛．\vl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\v&",
	}, { // 1062
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\r&",
		out:  "．\rl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\r&",
	}, { // 1063
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\r&",
		out:  "‛．\rl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\r&",
	}, { // 1064
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\u007f\tl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\t.",
		out:  "\u007f\tl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\t.",
	}, { // 1065
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\u007f\tl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\t．",
		out:  "\u007f\tl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\t．",
	}, { // 1066
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\u007f\nl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\n.",
		out:  "\u007f\nl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\n.",
	}, { // 1067
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\u007f\nl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\n．",
		out:  "\u007f\nl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\n．",
	}, { // 1068
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\u007f\vl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\v.",
		out:  "\u007f\vl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\v.",
	}, { // 1069
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\u007f\vl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\v．",
		out:  "\u007f\vl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\v．",
	}, { // 1070
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\u007f\rl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\r.",
		out:  "\u007f\rl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\r.",
	}, { // 1071
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\u007f\rl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\r．",
		out:  "\u007f\rl0␄４I\n|Ｇ－δβ＜θλθ␖＞ｐ[␡４|&0ｋ␂\r．",
	}, { // 1072
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>：｀b！χ+R\x00␏\x12c\t/",
		out:  "．\t␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>‛：｀b！χ+R␀␏\x12c\t/",
	}, { // 1073
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>：｀b！χ+R\x00␏\x12c\t/",
		out:  "‛．\t␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>‛：｀b！χ+R␀␏\x12c\t/",
	}, { // 1074
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>：｀b！χ+R\x00␏\x12c\n/",
		out:  "．\n␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>‛：｀b！χ+R␀␏\x12c\n/",
	}, { // 1075
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>：｀b！χ+R\x00␏\x12c\n/",
		out:  "‛．\n␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>‛：｀b！χ+R␀␏\x12c\n/",
	}, { // 1076
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>：｀b！χ+R\x00␏\x12c\v/",
		out:  "．\v␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>‛：｀b！χ+R␀␏\x12c\v/",
	}, { // 1077
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>：｀b！χ+R\x00␏\x12c\v/",
		out:  "‛．\v␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>‛：｀b！χ+R␀␏\x12c\v/",
	}, { // 1078
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>：｀b！χ+R\x00␏\x12c\r/",
		out:  "．\r␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>‛：｀b！χ+R␀␏\x12c\r/",
	}, { // 1079
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>：｀b！χ+R\x00␏\x12c\r/",
		out:  "‛．\r␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>‛：｀b！χ+R␀␏\x12c\r/",
	}, { // 1080
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\\\t␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>：｀b！χ+R\x00␏\x12c\t.",
		out:  "\\\t␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>‛：｀b！χ+R␀␏\x12c\t.",
	}, { // 1081
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\\\t␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>：｀b！χ+R\x00␏\x12c\t．",
		out:  "\\\t␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>‛：｀b！χ+R␀␏\x12c\t．",
	}, { // 1082
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\\\n␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>：｀b！χ+R\x00␏\x12c\n.",
		out:  "\\\n␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>‛：｀b！χ+R␀␏\x12c\n.",
	}, { // 1083
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\\\n␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>：｀b！χ+R\x00␏\x12c\n．",
		out:  "\\\n␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>‛：｀b！χ+R␀␏\x12c\n．",
	}, { // 1084
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\\\v␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>：｀b！χ+R\x00␏\x12c\v.",
		out:  "\\\v␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>‛：｀b！χ+R␀␏\x12c\v.",
	}, { // 1085
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\\\v␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>：｀b！χ+R\x00␏\x12c\v．",
		out:  "\\\v␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>‛：｀b！χ+R␀␏\x12c\v．",
	}, { // 1086
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\\\r␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>：｀b！χ+R\x00␏\x12c\r.",
		out:  "\\\r␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>‛：｀b！χ+R␀␏\x12c\r.",
	}, { // 1087
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\\\r␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>：｀b！χ+R\x00␏\x12c\r．",
		out:  "\\\r␏␊Ｏν\x01ξςς）Qο＋Ｊ\x1c>‛：｀b！χ+R␀␏\x12c\r．",
	}, { // 1088
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\t%",
		out:  "．\t\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\t%",
	}, { // 1089
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\t%",
		out:  "‛．\t\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\t%",
	}, { // 1090
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\n%",
		out:  "．\n\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\n%",
	}, { // 1091
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\n%",
		out:  "‛．\n\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\n%",
	}, { // 1092
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\v%",
		out:  "．\v\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\v%",
	}, { // 1093
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\v%",
		out:  "‛．\v\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\v%",
	}, { // 1094
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\r%",
		out:  "．\r\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\r%",
	}, { // 1095
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\r%",
		out:  "‛．\r\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\r%",
	}, { // 1096
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "R\t\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\t.",
		out:  "R\t\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\t.",
	}, { // 1097
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "R\t\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\t．",
		out:  "R\t\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\t．",
	}, { // 1098
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "R\n\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\n.",
		out:  "R\n\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\n.",
	}, { // 1099
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "R\n\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\n．",
		out:  "R\n\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\n．",
	}, { // 1100
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "R\v\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\v.",
		out:  "R\v\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\v.",
	}, { // 1101
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "R\v\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\v．",
		out:  "R\v\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\v．",
	}, { // 1102
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "R\r\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\r.",
		out:  "R\r\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\r.",
	}, { // 1103
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "R\r\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\r．",
		out:  "R\r\x11φν\x1d３＇βwｍyγ␞|<Ｆ％\rδ\x12\x02＞\x1cＱ；␈␏\r．",
	}, { // 1104
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\tｖ",
		out:  "．\t\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\tｖ",
	}, { // 1105
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\tｖ",
		out:  "‛．\t\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\tｖ",
	}, { // 1106
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\nｖ",
		out:  "．\n\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\nｖ",
	}, { // 1107
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\nｖ",
		out:  "‛．\n\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\nｖ",
	}, { // 1108
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\vｖ",
		out:  "．\v\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\vｖ",
	}, { // 1109
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\vｖ",
		out:  "‛．\v\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\vｖ",
	}, { // 1110
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\rｖ",
		out:  "．\r\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\rｖ",
	}, { // 1111
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\rｖ",
		out:  "‛．\r\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\rｖ",
	}, { // 1112
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␓\t\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\t.",
		out:  "␓\t\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\t.",
	}, { // 1113
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␓\t\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\t．",
		out:  "␓\t\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\t．",
	}, { // 1114
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␓\n\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\n.",
		out:  "␓\n\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\n.",
	}, { // 1115
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␓\n\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\n．",
		out:  "␓\n\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\n．",
	}, { // 1116
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␓\v\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\v.",
		out:  "␓\v\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\v.",
	}, { // 1117
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␓\v\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\v．",
		out:  "␓\v\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\v．",
	}, { // 1118
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␓\r\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\r.",
		out:  "␓\r\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\r.",
	}, { // 1119
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␓\r\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\r．",
		out:  "␓\r\x0e＋9ς.␂λｅ］；\x06\x12␊␜9η␝θT/ι\f0:［\x1c\r．",
	}, { // 1120
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\t｜",
		out:  "．\tＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\t‛｜",
	}, { // 1121
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\t｜",
		out:  "‛．\tＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\t‛｜",
	}, { // 1122
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\n｜",
		out:  "．\nＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\n‛｜",
	}, { // 1123
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\n｜",
		out:  "‛．\nＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\n‛｜",
	}, { // 1124
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\v｜",
		out:  "．\vＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\v‛｜",
	}, { // 1125
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\v｜",
		out:  "‛．\vＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\v‛｜",
	}, { // 1126
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\r｜",
		out:  "．\rＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\r‛｜",
	}, { // 1127
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\r｜",
		out:  "‛．\rＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\r‛｜",
	}, { // 1128
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "σ\tＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\t.",
		out:  "σ\tＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\t.",
	}, { // 1129
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "σ\tＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\t．",
		out:  "σ\tＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\t．",
	}, { // 1130
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "σ\nＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\n.",
		out:  "σ\nＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\n.",
	}, { // 1131
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "σ\nＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\n．",
		out:  "σ\nＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\n．",
	}, { // 1132
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "σ\vＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\v.",
		out:  "σ\vＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\v.",
	}, { // 1133
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "σ\vＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\v．",
		out:  "σ\vＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\v．",
	}, { // 1134
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "σ\rＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\r.",
		out:  "σ\rＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\r.",
	}, { // 1135
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "σ\rＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\r．",
		out:  "σ\rＩ｀Gγ\f＇\x15：ＱE#\x14␎?／κι␓＊ο：κ@\x03\x1d%\r．",
	}, { // 1136
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\t\x11",
		out:  "．\tυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\t\x11",
	}, { // 1137
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\t\x11",
		out:  "‛．\tυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\t\x11",
	}, { // 1138
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\n\x11",
		out:  "．\nυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\n\x11",
	}, { // 1139
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\n\x11",
		out:  "‛．\nυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\n\x11",
	}, { // 1140
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\v\x11",
		out:  "．\vυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\v\x11",
	}, { // 1141
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\v\x11",
		out:  "‛．\vυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\v\x11",
	}, { // 1142
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\r\x11",
		out:  "．\rυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\r\x11",
	}, { // 1143
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\r\x11",
		out:  "‛．\rυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\r\x11",
	}, { // 1144
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "｝\tυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\t.",
		out:  "｝\tυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\t.",
	}, { // 1145
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "｝\tυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\t．",
		out:  "｝\tυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\t．",
	}, { // 1146
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "｝\nυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\n.",
		out:  "｝\nυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\n.",
	}, { // 1147
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "｝\nυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\n．",
		out:  "｝\nυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\n．",
	}, { // 1148
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "｝\vυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\v.",
		out:  "｝\vυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\v.",
	}, { // 1149
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "｝\vυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\v．",
		out:  "｝\vυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\v．",
	}, { // 1150
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "｝\rυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\r.",
		out:  "｝\rυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\r.",
	}, { // 1151
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "｝\rυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\r．",
		out:  "｝\rυｍ］＜ρ*\x1d＞Ｈ␘δ␙υ：＇\x19η｜h'2φ\x1cｆ>P\r．",
	}, { // 1152
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\t1",
		out:  "．\t␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\t1",
	}, { // 1153
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\t1",
		out:  "‛．\t␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\t1",
	}, { // 1154
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\n1",
		out:  "．\n␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\n1",
	}, { // 1155
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\n1",
		out:  "‛．\n␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\n1",
	}, { // 1156
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\v1",
		out:  "．\v␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\v1",
	}, { // 1157
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\v1",
		out:  "‛．\v␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\v1",
	}, { // 1158
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\r1",
		out:  "．\r␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\r1",
	}, { // 1159
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\r1",
		out:  "‛．\r␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\r1",
	}, { // 1160
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "?\t␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\t.",
		out:  "?\t␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\t.",
	}, { // 1161
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "?\t␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\t．",
		out:  "?\t␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\t．",
	}, { // 1162
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "?\n␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\n.",
		out:  "?\n␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\n.",
	}, { // 1163
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "?\n␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\n．",
		out:  "?\n␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\n．",
	}, { // 1164
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "?\v␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\v.",
		out:  "?\v␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\v.",
	}, { // 1165
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "?\v␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\v．",
		out:  "?\v␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\v．",
	}, { // 1166
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "?\r␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\r.",
		out:  "?\r␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\r.",
	}, { // 1167
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "?\r␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\r．",
		out:  "?\r␐\"＿ｚη\rεδ]μ＿Vη␕]a［␡｛␓ｒχ{<\x0eＥ\r．",
	}, { // 1168
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t－][＂␎/］<gοκ␎k\rＩ*μ\r␀!：２ο／αＪ\tπ",
		out:  "．\t－][＂␎/］<gοκ␎k\rＩ*μ\r‛␀!：２ο／αＪ\tπ",
	}, { // 1169
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t－][＂␎/］<gοκ␎k\rＩ*μ\r␀!：２ο／αＪ\tπ",
		out:  "‛．\t－][＂␎/］<gοκ␎k\rＩ*μ\r‛␀!：２ο／αＪ\tπ",
	}, { // 1170
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n－][＂␎/］<gοκ␎k\rＩ*μ\r␀!：２ο／αＪ\nπ",
		out:  "．\n－][＂␎/］<gοκ␎k\rＩ*μ\r‛␀!：２ο／αＪ\nπ",
	}, { // 1171
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n－][＂␎/］<gοκ␎k\rＩ*μ\r␀!：２ο／αＪ\nπ",
		out:  "‛．\n－][＂␎/］<gοκ␎k\rＩ*μ\r‛␀!：２ο／αＪ\nπ",
	}, { // 1172
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v－][＂␎/］<gοκ␎k\rＩ*μ\r␀!：２ο／αＪ\vπ",
		out:  "．\v－][＂␎/］<gοκ␎k\rＩ*μ\r‛␀!：２ο／αＪ\vπ",
	}, { // 1173
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v－][＂␎/］<gοκ␎k\rＩ*μ\r␀!：２ο／αＪ\vπ",
		out:  "‛．\v－][＂␎/］<gοκ␎k\rＩ*μ\r‛␀!：２ο／αＪ\vπ",
	}, { // 1174
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r－][＂␎/］<gοκ␎k\rＩ*μ\r␀!：２ο／αＪ\rπ",
		out:  "．\r－][＂␎/］<gοκ␎k\rＩ*μ\r‛␀!：２ο／αＪ\rπ",
	}, { // 1175
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r－][＂␎/］<gοκ␎k\rＩ*μ\r␀!：２ο／αＪ\rπ",
		out:  "‛．\r－][＂␎/］<gοκ␎k\rＩ*μ\r‛␀!：２ο／αＪ\rπ",
	}, { // 1176
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "！\t－][＂␎/］<gοκ␎k\rＩ*μ\r␀!：２ο／αＪ\t.",
		out:  "！\t－][＂␎/］<gοκ␎k\rＩ*μ\r‛␀!：２ο／αＪ\t.",
	}, { // 1177
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "！\t－][＂␎/］<gοκ␎k\rＩ*μ\r␀!：２ο／αＪ\t．",
		out:  "！\t－][＂␎/］<gοκ␎k\rＩ*μ\r‛␀!：２ο／αＪ\t．",
	}, { // 1178
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "！\n－][＂␎/］<gοκ␎k\rＩ*μ\r␀!：２ο／αＪ\n.",
		out:  "！\n－][＂␎/］<gοκ␎k\rＩ*μ\r‛␀!：２ο／αＪ\n.",
	}, { // 1179
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "！\n－][＂␎/］<gοκ␎k\rＩ*μ\r␀!：２ο／αＪ\n．",
		out:  "！\n－][＂␎/］<gοκ␎k\rＩ*μ\r‛␀!：２ο／αＪ\n．",
	}, { // 1180
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "！\v－][＂␎/］<gοκ␎k\rＩ*μ\r␀!：２ο／αＪ\v.",
		out:  "！\v－][＂␎/］<gοκ␎k\rＩ*μ\r‛␀!：２ο／αＪ\v.",
	}, { // 1181
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "！\v－][＂␎/］<gοκ␎k\rＩ*μ\r␀!：２ο／αＪ\v．",
		out:  "！\v－][＂␎/］<gοκ␎k\rＩ*μ\r‛␀!：２ο／αＪ\v．",
	}, { // 1182
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "！\r－][＂␎/］<gοκ␎k\rＩ*μ\r␀!：２ο／αＪ\r.",
		out:  "！\r－][＂␎/］<gοκ␎k\rＩ*μ\r‛␀!：２ο／αＪ\r.",
	}, { // 1183
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "！\r－][＂␎/］<gοκ␎k\rＩ*μ\r␀!：２ο／αＪ\r．",
		out:  "！\r－][＂␎/］<gοκ␎k\rＩ*μ\r‛␀!：２ο／αＪ\r．",
	}, { // 1184
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\tｚ",
		out:  "．\t＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\tｚ",
	}, { // 1185
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\tｚ",
		out:  "‛．\t＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\tｚ",
	}, { // 1186
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\nｚ",
		out:  "．\n＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\nｚ",
	}, { // 1187
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\nｚ",
		out:  "‛．\n＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\nｚ",
	}, { // 1188
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\vｚ",
		out:  "．\v＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\vｚ",
	}, { // 1189
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\vｚ",
		out:  "‛．\v＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\vｚ",
	}, { // 1190
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\rｚ",
		out:  "．\r＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\rｚ",
	}, { // 1191
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\rｚ",
		out:  "‛．\r＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\rｚ",
	}, { // 1192
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␌\t＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\t.",
		out:  "␌\t＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\t.",
	}, { // 1193
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␌\t＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\t．",
		out:  "␌\t＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\t．",
	}, { // 1194
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␌\n＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\n.",
		out:  "␌\n＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\n.",
	}, { // 1195
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␌\n＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\n．",
		out:  "␌\n＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\n．",
	}, { // 1196
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␌\v＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\v.",
		out:  "␌\v＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\v.",
	}, { // 1197
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␌\v＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\v．",
		out:  "␌\v＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\v．",
	}, { // 1198
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␌\r＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\r.",
		out:  "␌\r＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\r.",
	}, { // 1199
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␌\r＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\r．",
		out:  "␌\r＾Qε/@＂␞\x18ω\x04wε？a(\x1c;\rυ）␔␏φｙψ＿\r．",
	}, { // 1200
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". εＩ0\x1eα[＼ξαs␀\x02：＂B\f␌Ｄ[␓␈\rＬｖｖL \"",
		out:  "． εＩ0\x1eα[＼ξαs‛␀\x02：＂B\f␌Ｄ[␓␈\rＬｖｖL \"",
	}, { // 1201
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． εＩ0\x1eα[＼ξαs␀\x02：＂B\f␌Ｄ[␓␈\rＬｖｖL \"",
		out:  "‛． εＩ0\x1eα[＼ξαs‛␀\x02：＂B\f␌Ｄ[␓␈\rＬｖｖL \"",
	}, { // 1202
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightSpace,
		in:   "α εＩ0\x1eα[＼ξαs␀\x02：＂B\f␌Ｄ[␓␈\rＬｖｖL .",
		out:  "α εＩ0\x1eα[＼ξαs‛␀\x02：＂B\f␌Ｄ[␓␈\rＬｖｖL .",
	}, { // 1203
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightSpace,
		in:   "α εＩ0\x1eα[＼ξαs␀\x02：＂B\f␌Ｄ[␓␈\rＬｖｖL ．",
		out:  "α εＩ0\x1eα[＼ξαs‛␀\x02：＂B\f␌Ｄ[␓␈\rＬｖｖL ．",
	}, { // 1204
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ＄\x1aｂζ\x1fＷ？/sqＰβx␍Z\aρＳpμv\x1d#␡␄␙ ␖",
		out:  "． ＄\x1aｂζ\x1fＷ？／sqＰβx␍Z\aρＳpμv\x1d#␡␄␙ ␖",
	}, { // 1205
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ＄\x1aｂζ\x1fＷ？/sqＰβx␍Z\aρＳpμv\x1d#␡␄␙ ␖",
		out:  "‛． ＄\x1aｂζ\x1fＷ？／sqＰβx␍Z\aρＳpμv\x1d#␡␄␙ ␖",
	}, { // 1206
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "Ａ ＄\x1aｂζ\x1fＷ？/sqＰβx␍Z\aρＳpμv\x1d#␡␄␙ .",
		out:  "Ａ ＄\x1aｂζ\x1fＷ？／sqＰβx␍Z\aρＳpμv\x1d#␡␄␙ .",
	}, { // 1207
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "Ａ ＄\x1aｂζ\x1fＷ？/sqＰβx␍Z\aρＳpμv\x1d#␡␄␙ ．",
		out:  "Ａ ＄\x1aｂζ\x1fＷ？／sqＰβx␍Z\aρＳpμv\x1d#␡␄␙ ．",
	}, { // 1208
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ＞γeｗ|υCι［\t）4'␊␕χ␘\x14πＣ\x12Ｔ|L+ｄ ［",
		out:  "． ＞γeｗ|υCι［\t）4＇␊␕χ␘\x14πＣ\x12Ｔ|L+ｄ ［",
	}, { // 1209
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ＞γeｗ|υCι［\t）4'␊␕χ␘\x14πＣ\x12Ｔ|L+ｄ ［",
		out:  "‛． ＞γeｗ|υCι［\t）4＇␊␕χ␘\x14πＣ\x12Ｔ|L+ｄ ［",
	}, { // 1210
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x13 ＞γeｗ|υCι［\t）4'␊␕χ␘\x14πＣ\x12Ｔ|L+ｄ .",
		out:  "\x13 ＞γeｗ|υCι［\t）4＇␊␕χ␘\x14πＣ\x12Ｔ|L+ｄ .",
	}, { // 1211
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x13 ＞γeｗ|υCι［\t）4'␊␕χ␘\x14πＣ\x12Ｔ|L+ｄ ．",
		out:  "\x13 ＞γeｗ|υCι［\t）4＇␊␕χ␘\x14πＣ\x12Ｔ|L+ｄ ．",
	}, { // 1212
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". I\x17Ｖωι!␝φｋｎ␡4:␕T\a\rλ\x11hE␓ｒ*␆ω ｍ",
		out:  "． I\x17Ｖωι!␝φｋｎ␡4:␕T\a\rλ\x11hE␓ｒ*␆ω ｍ",
	}, { // 1213
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． I\x17Ｖωι!␝φｋｎ␡4:␕T\a\rλ\x11hE␓ｒ*␆ω ｍ",
		out:  "‛． I\x17Ｖωι!␝φｋｎ␡4:␕T\a\rλ\x11hE␓ｒ*␆ω ｍ",
	}, { // 1214
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "θ I\x17Ｖωι!␝φｋｎ␡4:␕T\a\rλ\x11hE␓ｒ*␆ω .",
		out:  "θ I\x17Ｖωι!␝φｋｎ␡4:␕T\a\rλ\x11hE␓ｒ*␆ω .",
	}, { // 1215
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "θ I\x17Ｖωι!␝φｋｎ␡4:␕T\a\rλ\x11hE␓ｒ*␆ω ．",
		out:  "θ I\x17Ｖωι!␝φｋｎ␡4:␕T\a\rλ\x11hE␓ｒ*␆ω ．",
	}, { // 1216
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ｐ␑λＥυ\x0ftrＲ＊α／z＝Cκ＄\x19\x1a0αG／␝␘\x02 ρ",
		out:  "． ｐ␑λＥυ\x0ftrＲ＊α／z＝Cκ＄\x19\x1a0αG／␝␘\x02 ρ",
	}, { // 1217
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ｐ␑λＥυ\x0ftrＲ＊α／z＝Cκ＄\x19\x1a0αG／␝␘\x02 ρ",
		out:  "‛． ｐ␑λＥυ\x0ftrＲ＊α／z＝Cκ＄\x19\x1a0αG／␝␘\x02 ρ",
	}, { // 1218
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x10 ｐ␑λＥυ\x0ftrＲ＊α／z＝Cκ＄\x19\x1a0αG／␝␘\x02 .",
		out:  "\x10 ｐ␑λＥυ\x0ftrＲ＊α／z＝Cκ＄\x19\x1a0αG／␝␘\x02 .",
	}, { // 1219
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x10 ｐ␑λＥυ\x0ftrＲ＊α／z＝Cκ＄\x19\x1a0αG／␝␘\x02 ．",
		out:  "\x10 ｐ␑λＥυ\x0ftrＲ＊α／z＝Cκ＄\x19\x1a0αG／␝␘\x02 ．",
	}, { // 1220
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". *␐ωω．VＺ1％＇\n2␃ε／k␅ｄ＊σ\x0fM:｀\nφ π",
		out:  "． *␐ωω．VＺ1％＇\n2␃ε／k␅ｄ＊σ\x0fM:｀\nφ π",
	}, { // 1221
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． *␐ωω．VＺ1％＇\n2␃ε／k␅ｄ＊σ\x0fM:｀\nφ π",
		out:  "‛． *␐ωω．VＺ1％＇\n2␃ε／k␅ｄ＊σ\x0fM:｀\nφ π",
	}, { // 1222
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightSpace,
		in:   "V *␐ωω．VＺ1％＇\n2␃ε／k␅ｄ＊σ\x0fM:｀\nφ .",
		out:  "V *␐ωω．VＺ1％＇\n2␃ε／k␅ｄ＊σ\x0fM:｀\nφ .",
	}, { // 1223
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightSpace,
		in:   "V *␐ωω．VＺ1％＇\n2␃ε／k␅ｄ＊σ\x0fM:｀\nφ ．",
		out:  "V *␐ωω．VＺ1％＇\n2␃ε／k␅ｄ＊σ\x0fM:｀\nφ ．",
	}, { // 1224
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". Ｅ？␏＇O>＃\x1bg\x0eπＹ␞ο［-ς␞χ\x05vｂκ［ｘ# *",
		out:  "． Ｅ？␏＇O>＃\x1bg\x0eπＹ␞ο［-ς␞χ\x05vｂκ［ｘ# *",
	}, { // 1225
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． Ｅ？␏＇O>＃\x1bg\x0eπＹ␞ο［-ς␞χ\x05vｂκ［ｘ# *",
		out:  "‛． Ｅ？␏＇O>＃\x1bg\x0eπＹ␞ο［-ς␞χ\x05vｂκ［ｘ# *",
	}, { // 1226
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightSpace,
		in:   "d Ｅ？␏＇O>＃\x1bg\x0eπＹ␞ο［-ς␞χ\x05vｂκ［ｘ# .",
		out:  "d Ｅ？␏＇O>＃\x1bg\x0eπＹ␞ο［-ς␞χ\x05vｂκ［ｘ# .",
	}, { // 1227
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightSpace,
		in:   "d Ｅ？␏＇O>＃\x1bg\x0eπＹ␞ο［-ς␞χ\x05vｂκ［ｘ# ．",
		out:  "d Ｅ？␏＇O>＃\x1bg\x0eπＹ␞ο［-ς␞χ\x05vｂκ［ｘ# ．",
	}, { // 1228
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". a7[@ν␡␍＂ψｓ＜\x15｝␄\aε^␅Ｙ[lψＧ\x16θψ %",
		out:  "． a7[@ν␡␍‛＂ψｓ＜\x15｝␄\aε^␅Ｙ[lψＧ\x16θψ %",
	}, { // 1229
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． a7[@ν␡␍＂ψｓ＜\x15｝␄\aε^␅Ｙ[lψＧ\x16θψ %",
		out:  "‛． a7[@ν␡␍‛＂ψｓ＜\x15｝␄\aε^␅Ｙ[lψＧ\x16θψ %",
	}, { // 1230
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␡ a7[@ν␡␍＂ψｓ＜\x15｝␄\aε^␅Ｙ[lψＧ\x16θψ .",
		out:  "␡ a7[@ν␡␍‛＂ψｓ＜\x15｝␄\aε^␅Ｙ[lψＧ\x16θψ .",
	}, { // 1231
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␡ a7[@ν␡␍＂ψｓ＜\x15｝␄\aε^␅Ｙ[lψＧ\x16θψ ．",
		out:  "␡ a7[@ν␡␍‛＂ψｓ＜\x15｝␄\aε^␅Ｙ[lψＧ\x16θψ ．",
	}, { // 1232
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". τζ\x1bσ]6γWＳ\x15t␗Ｎ␙␄８Ｓ：ｅ\rο␄WＰλU \t",
		out:  "． τζ\x1bσ]6γWＳ\x15t␗Ｎ␙␄８Ｓ‛：ｅ\rο␄WＰλU \t",
	}, { // 1233
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． τζ\x1bσ]6γWＳ\x15t␗Ｎ␙␄８Ｓ：ｅ\rο␄WＰλU \t",
		out:  "‛． τζ\x1bσ]6γWＳ\x15t␗Ｎ␙␄８Ｓ‛：ｅ\rο␄WＰλU \t",
	}, { // 1234
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␏ τζ\x1bσ]6γWＳ\x15t␗Ｎ␙␄８Ｓ：ｅ\rο␄WＰλU .",
		out:  "␏ τζ\x1bσ]6γWＳ\x15t␗Ｎ␙␄８Ｓ‛：ｅ\rο␄WＰλU .",
	}, { // 1235
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␏ τζ\x1bσ]6γWＳ\x15t␗Ｎ␙␄８Ｓ：ｅ\rο␄WＰλU ．",
		out:  "␏ τζ\x1bσ]6γWＳ\x15t␗Ｎ␙␄８Ｓ‛：ｅ\rο␄WＰλU ．",
	}, { // 1236
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ^P␍ｕ*␜␊σＹｌ％μ/:l+\f?␍ｈγςＪ$β＂ Ｍ",
		out:  "． ^P␍ｕ*␜␊σＹｌ％μ/:l+\f？␍ｈγςＪ$β＂ Ｍ",
	}, { // 1237
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ^P␍ｕ*␜␊σＹｌ％μ/:l+\f?␍ｈγςＪ$β＂ Ｍ",
		out:  "‛． ^P␍ｕ*␜␊σＹｌ％μ/:l+\f？␍ｈγςＪ$β＂ Ｍ",
	}, { // 1238
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightSpace,
		in:   "ξ ^P␍ｕ*␜␊σＹｌ％μ/:l+\f?␍ｈγςＪ$β＂ .",
		out:  "ξ ^P␍ｕ*␜␊σＹｌ％μ/:l+\f？␍ｈγςＪ$β＂ .",
	}, { // 1239
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightSpace,
		in:   "ξ ^P␍ｕ*␜␊σＹｌ％μ/:l+\f?␍ｈγςＪ$β＂ ．",
		out:  "ξ ^P␍ｕ*␜␊σＹｌ％μ/:l+\f？␍ｈγςＪ$β＂ ．",
	}, { // 1240
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". #\x16\x00＇␈$ο\x18$ｏ＞πμｑ1<ψｔο)ｚ－␕ξu␃ ＿",
		out:  "． #\x16␀＇␈$ο\x18$ｏ＞πμｑ1<ψｔο)ｚ－␕ξu␃ ＿",
	}, { // 1241
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． #\x16\x00＇␈$ο\x18$ｏ＞πμｑ1<ψｔο)ｚ－␕ξu␃ ＿",
		out:  "‛． #\x16␀＇␈$ο\x18$ｏ＞πμｑ1<ψｔο)ｚ－␕ξu␃ ＿",
	}, { // 1242
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightSpace,
		in:   "］ #\x16\x00＇␈$ο\x18$ｏ＞πμｑ1<ψｔο)ｚ－␕ξu␃ .",
		out:  "］ #\x16␀＇␈$ο\x18$ｏ＞πμｑ1<ψｔο)ｚ－␕ξu␃ .",
	}, { // 1243
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightSpace,
		in:   "］ #\x16\x00＇␈$ο\x18$ｏ＞πμｑ1<ψｔο)ｚ－␕ξu␃ ．",
		out:  "］ #\x16␀＇␈$ο\x18$ｏ＞πμｑ1<ψｔο)ｚ－␕ξu␃ ．",
	}, { // 1244
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". @ｇ\x1b\x03σ\x15uＹｇσζｕ␞η|␜１g：\"／4ｔ}m＄ ο",
		out:  "． @ｇ\x1b\x03σ\x15uＹｇσζｕ␞η｜␜１g：\"／4ｔ}m＄ ο",
	}, { // 1245
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． @ｇ\x1b\x03σ\x15uＹｇσζｕ␞η|␜１g：\"／4ｔ}m＄ ο",
		out:  "‛． @ｇ\x1b\x03σ\x15uＹｇσζｕ␞η｜␜１g：\"／4ｔ}m＄ ο",
	}, { // 1246
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\v @ｇ\x1b\x03σ\x15uＹｇσζｕ␞η|␜１g：\"／4ｔ}m＄ .",
		out:  "\v @ｇ\x1b\x03σ\x15uＹｇσζｕ␞η｜␜１g：\"／4ｔ}m＄ .",
	}, { // 1247
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\v @ｇ\x1b\x03σ\x15uＹｇσζｕ␞η|␜１g：\"／4ｔ}m＄ ．",
		out:  "\v @ｇ\x1b\x03σ\x15uＹｇσζｕ␞η｜␜１g：\"／4ｔ}m＄ ．",
	}, { // 1248
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". G␒<ς␏jWςＯ\x06ｑθ\t\x1eκ\x0eｕｗψAｄρ␀␝d␕ Ｆ",
		out:  "． G␒<ς␏jWςＯ\x06ｑθ\t\x1eκ\x0eｕｗψAｄρ‛␀␝d␕ Ｆ",
	}, { // 1249
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． G␒<ς␏jWςＯ\x06ｑθ\t\x1eκ\x0eｕｗψAｄρ␀␝d␕ Ｆ",
		out:  "‛． G␒<ς␏jWςＯ\x06ｑθ\t\x1eκ\x0eｕｗψAｄρ‛␀␝d␕ Ｆ",
	}, { // 1250
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\r G␒<ς␏jWςＯ\x06ｑθ\t\x1eκ\x0eｕｗψAｄρ␀␝d␕ .",
		out:  "\r G␒<ς␏jWςＯ\x06ｑθ\t\x1eκ\x0eｕｗψAｄρ‛␀␝d␕ .",
	}, { // 1251
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\r G␒<ς␏jWςＯ\x06ｑθ\t\x1eκ\x0eｕｗψAｄρ␀␝d␕ ．",
		out:  "\r G␒<ς␏jWςＯ\x06ｑθ\t\x1eκ\x0eｕｗψAｄρ‛␀␝d␕ ．",
	}, { // 1252
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ｎ;κＹχ\x06CＫ␕α\u007f＃ν＋＊ \"␉:／ε＞ut＄\x1f ;",
		out:  "． ｎ;κＹχ\x06CＫ␕α\u007f＃ν＋＊ \"␉:／ε＞ut＄\x1f ;",
	}, { // 1253
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ｎ;κＹχ\x06CＫ␕α\u007f＃ν＋＊ \"␉:／ε＞ut＄\x1f ;",
		out:  "‛． ｎ;κＹχ\x06CＫ␕α\u007f＃ν＋＊ \"␉:／ε＞ut＄\x1f ;",
	}, { // 1254
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x00 ｎ;κＹχ\x06CＫ␕α\u007f＃ν＋＊ \"␉:／ε＞ut＄\x1f .",
		out:  "␀ ｎ;κＹχ\x06CＫ␕α\u007f＃ν＋＊ \"␉:／ε＞ut＄\x1f .",
	}, { // 1255
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x00 ｎ;κＹχ\x06CＫ␕α\u007f＃ν＋＊ \"␉:／ε＞ut＄\x1f ．",
		out:  "␀ ｎ;κＹχ\x06CＫ␕α\u007f＃ν＋＊ \"␉:／ε＞ut＄\x1f ．",
	}, { // 1256
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". O5'％␞ζ＂|AＤ）γ！?\x11χ\x11Kθ␀κυwｂ␔｜ ３",
		out:  "． O5'％␞ζ＂|AＤ）γ！?\x11χ\x11Kθ‛␀κυwｂ␔｜ ３",
	}, { // 1257
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． O5'％␞ζ＂|AＤ）γ！?\x11χ\x11Kθ␀κυwｂ␔｜ ３",
		out:  "‛． O5'％␞ζ＂|AＤ）γ！?\x11χ\x11Kθ‛␀κυwｂ␔｜ ３",
	}, { // 1258
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x14 O5'％␞ζ＂|AＤ）γ！?\x11χ\x11Kθ␀κυwｂ␔｜ .",
		out:  "\x14 O5'％␞ζ＂|AＤ）γ！?\x11χ\x11Kθ‛␀κυwｂ␔｜ .",
	}, { // 1259
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x14 O5'％␞ζ＂|AＤ）γ！?\x11χ\x11Kθ␀κυwｂ␔｜ ．",
		out:  "\x14 O5'％␞ζ＂|AＤ）γ！?\x11χ\x11Kθ‛␀κυwｂ␔｜ ．",
	}, { // 1260
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". μ｀ｂjＢψ］ρν␆Ｇ/␞Ｈ?πφＦ｀G␆C\re\x04\x19 \b",
		out:  "． μ｀ｂjＢψ］ρν␆Ｇ/␞Ｈ?πφＦ｀G␆C␍e\x04\x19 \b",
	}, { // 1261
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． μ｀ｂjＢψ］ρν␆Ｇ/␞Ｈ?πφＦ｀G␆C\re\x04\x19 \b",
		out:  "‛． μ｀ｂjＢψ］ρν␆Ｇ/␞Ｈ?πφＦ｀G␆C␍e\x04\x19 \b",
	}, { // 1262
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x12 μ｀ｂjＢψ］ρν␆Ｇ/␞Ｈ?πφＦ｀G␆C\re\x04\x19 .",
		out:  "\x12 μ｀ｂjＢψ］ρν␆Ｇ/␞Ｈ?πφＦ｀G␆C␍e\x04\x19 .",
	}, { // 1263
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x12 μ｀ｂjＢψ］ρν␆Ｇ/␞Ｈ?πφＦ｀G␆C\re\x04\x19 ．",
		out:  "\x12 μ｀ｂjＢψ］ρν␆Ｇ/␞Ｈ?πφＦ｀G␆C␍e\x04\x19 ．",
	}, { // 1264
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ␞％␅|：}ｅχｇ\x10\x04βυ：\x17η2ζ*９ｉj␝\r^［ λ",
		out:  "． ␞％␅|：}ｅχｇ\x10\x04βυ：\x17η2ζ*９ｉj␝\r^［ λ",
	}, { // 1265
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ␞％␅|：}ｅχｇ\x10\x04βυ：\x17η2ζ*９ｉj␝\r^［ λ",
		out:  "‛． ␞％␅|：}ｅχｇ\x10\x04βυ：\x17η2ζ*９ｉj␝\r^［ λ",
	}, { // 1266
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\n ␞％␅|：}ｅχｇ\x10\x04βυ：\x17η2ζ*９ｉj␝\r^［ .",
		out:  "\n ␞％␅|：}ｅχｇ\x10\x04βυ：\x17η2ζ*９ｉj␝\r^［ .",
	}, { // 1267
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\n ␞％␅|：}ｅχｇ\x10\x04βυ：\x17η2ζ*９ｉj␝\r^［ ．",
		out:  "\n ␞％␅|：}ｅχｇ\x10\x04βυ：\x17η2ζ*９ｉj␝\r^［ ．",
	}, { // 1268
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". r␏!\nuε␝hＯ+\x18？␋8．μο:＞ε\x1cｏ，｜ςＤ ｘ",
		out:  "． r‛␏!␊uε‛␝hＯ+␘？‛␋8．μο:＞ε␜ｏ，｜ςＤ ｘ",
	}, { // 1269
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． r␏!\nuε␝hＯ+\x18？␋8．μο:＞ε\x1cｏ，｜ςＤ ｘ",
		out:  "‛． r‛␏!␊uε‛␝hＯ+␘？‛␋8．μο:＞ε␜ｏ，｜ςＤ ｘ",
	}, { // 1270
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightSpace,
		in:   "τ r␏!\nuε␝hＯ+\x18？␋8．μο:＞ε\x1cｏ，｜ςＤ .",
		out:  "τ r‛␏!␊uε‛␝hＯ+␘？‛␋8．μο:＞ε␜ｏ，｜ςＤ .",
	}, { // 1271
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightSpace,
		in:   "τ r␏!\nuε␝hＯ+\x18？␋8．μο:＞ε\x1cｏ，｜ςＤ ．",
		out:  "τ r‛␏!␊uε‛␝hＯ+␘？‛␋8．μο:＞ε␜ｏ，｜ςＤ ．",
	}, { // 1272
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..@eｉ$κ␊）γ␚ｚO\u007fφ␃\x11:Ｋ？？\x18＋ρ:U␚␜.χ",
		out:  "．.@eｉ$κ␊）γ␚ｚO\u007fφ␃\x11:Ｋ？？\x18＋ρ:U␚␜.χ",
	}, { // 1273
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.@eｉ$κ␊）γ␚ｚO\u007fφ␃\x11:Ｋ？？\x18＋ρ:U␚␜.χ",
		out:  "‛．.@eｉ$κ␊）γ␚ｚO\u007fφ␃\x11:Ｋ？？\x18＋ρ:U␚␜.χ",
	}, { // 1274
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "[.@eｉ$κ␊）γ␚ｚO\u007fφ␃\x11:Ｋ？？\x18＋ρ:U␚␜..",
		out:  "[.@eｉ$κ␊）γ␚ｚO\u007fφ␃\x11:Ｋ？？\x18＋ρ:U␚␜.．",
	}, { // 1275
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "[.@eｉ$κ␊）γ␚ｚO\u007fφ␃\x11:Ｋ？？\x18＋ρ:U␚␜.．",
		out:  "[.@eｉ$κ␊）γ␚ｚO\u007fφ␃\x11:Ｋ？？\x18＋ρ:U␚␜.‛．",
	}, { // 1276
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..>νｕt\n␂７ψ／\\＄｜sK\x16\x02θmπ␖＼．%ιλ＞.ｇ",
		out:  "．.>νｕt\n␂７ψ‛／\\＄｜sK\x16\x02θmπ␖＼．%ιλ＞.ｇ",
	}, { // 1277
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.>νｕt\n␂７ψ／\\＄｜sK\x16\x02θmπ␖＼．%ιλ＞.ｇ",
		out:  "‛．.>νｕt\n␂７ψ‛／\\＄｜sK\x16\x02θmπ␖＼．%ιλ＞.ｇ",
	}, { // 1278
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "e.>νｕt\n␂７ψ／\\＄｜sK\x16\x02θmπ␖＼．%ιλ＞..",
		out:  "e.>νｕt\n␂７ψ‛／\\＄｜sK\x16\x02θmπ␖＼．%ιλ＞.．",
	}, { // 1279
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "e.>νｕt\n␂７ψ／\\＄｜sK\x16\x02θmπ␖＼．%ιλ＞.．",
		out:  "e.>νｕt\n␂７ψ‛／\\＄｜sK\x16\x02θmπ␖＼．%ιλ＞.‛．",
	}, { // 1280
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..:␐]ＮQ\x17στ［wζＩυ\x1dσ＊＜nJ%␑y［␑␐Ｐ.\x05",
		out:  "．.:␐]ＮQ\x17στ［wζＩυ\x1dσ＊＜nJ%␑y［␑␐Ｐ.\x05",
	}, { // 1281
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.:␐]ＮQ\x17στ［wζＩυ\x1dσ＊＜nJ%␑y［␑␐Ｐ.\x05",
		out:  "‛．.:␐]ＮQ\x17στ［wζＩυ\x1dσ＊＜nJ%␑y［␑␐Ｐ.\x05",
	}, { // 1282
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "＜.:␐]ＮQ\x17στ［wζＩυ\x1dσ＊＜nJ%␑y［␑␐Ｐ..",
		out:  "＜.:␐]ＮQ\x17στ［wζＩυ\x1dσ＊＜nJ%␑y［␑␐Ｐ.．",
	}, { // 1283
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "＜.:␐]ＮQ\x17στ［wζＩυ\x1dσ＊＜nJ%␑y［␑␐Ｐ.．",
		out:  "＜.:␐]ＮQ\x17στ［wζＩυ\x1dσ＊＜nJ%␑y［␑␐Ｐ.‛．",
	}, { // 1284
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..%～/y␚\x19φｒ４ψυ９＜\x16\nF<＂␂h\aρｏT␑ε.φ",
		out:  "．.%～/y␚\x19φｒ４ψυ９＜\x16\nF<＂␂h\aρｏT␑ε.φ",
	}, { // 1285
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.%～/y␚\x19φｒ４ψυ９＜\x16\nF<＂␂h\aρｏT␑ε.φ",
		out:  "‛．.%～/y␚\x19φｒ４ψυ９＜\x16\nF<＂␂h\aρｏT␑ε.φ",
	}, { // 1286
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "=.%～/y␚\x19φｒ４ψυ９＜\x16\nF<＂␂h\aρｏT␑ε..",
		out:  "=.%～/y␚\x19φｒ４ψυ９＜\x16\nF<＂␂h\aρｏT␑ε.．",
	}, { // 1287
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "=.%～/y␚\x19φｒ４ψυ９＜\x16\nF<＂␂h\aρｏT␑ε.．",
		out:  "=.%～/y␚\x19φｒ４ψυ９＜\x16\nF<＂␂h\aρｏT␑ε.‛．",
	}, { // 1288
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..τ\x1d␓-\x18／␊\x02␓Ｄ\rMPｍ␒ｆδθ（／［\x19θτκB.X",
		out:  "．.τ\x1d␓-\x18／␊\x02␓Ｄ\rMPｍ␒ｆδθ（／［\x19θτκB.X",
	}, { // 1289
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.τ\x1d␓-\x18／␊\x02␓Ｄ\rMPｍ␒ｆδθ（／［\x19θτκB.X",
		out:  "‛．.τ\x1d␓-\x18／␊\x02␓Ｄ\rMPｍ␒ｆδθ（／［\x19θτκB.X",
	}, { // 1290
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "~.τ\x1d␓-\x18／␊\x02␓Ｄ\rMPｍ␒ｆδθ（／［\x19θτκB..",
		out:  "~.τ\x1d␓-\x18／␊\x02␓Ｄ\rMPｍ␒ｆδθ（／［\x19θτκB.．",
	}, { // 1291
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "~.τ\x1d␓-\x18／␊\x02␓Ｄ\rMPｍ␒ｆδθ（／［\x19θτκB.．",
		out:  "~.τ\x1d␓-\x18／␊\x02␓Ｄ\rMPｍ␒ｆδθ（／［\x19θτκB.‛．",
	}, { // 1292
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..P｝␁ｍ^αλ$］β＂＞␙１4\x18␌>s９εｆ>\a＞G.τ",
		out:  "．.P｝␁ｍ^αλ$‛］β＂＞␙１4\x18␌>s９εｆ>\a＞G.τ",
	}, { // 1293
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.P｝␁ｍ^αλ$］β＂＞␙１4\x18␌>s９εｆ>\a＞G.τ",
		out:  "‛．.P｝␁ｍ^αλ$‛］β＂＞␙１4\x18␌>s９εｆ>\a＞G.τ",
	}, { // 1294
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "\x1d.P｝␁ｍ^αλ$］β＂＞␙１4\x18␌>s９εｆ>\a＞G..",
		out:  "\x1d.P｝␁ｍ^αλ$‛］β＂＞␙１4\x18␌>s９εｆ>\a＞G.．",
	}, { // 1295
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "\x1d.P｝␁ｍ^αλ$］β＂＞␙１4\x18␌>s９εｆ>\a＞G.．",
		out:  "\x1d.P｝␁ｍ^αλ$‛］β＂＞␙１4\x18␌>s９εｆ>\a＞G.‛．",
	}, { // 1296
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..＂Ｊ␗\\4νρ\x14ｄ：t\aπh^＠␍\x02ςX＂\x15＼<␍ξ.$",
		out:  "．.＂Ｊ␗\\4νρ\x14ｄ：t\aπh^＠␍\x02ςX＂\x15＼<␍ξ.＄",
	}, { // 1297
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.＂Ｊ␗\\4νρ\x14ｄ：t\aπh^＠␍\x02ςX＂\x15＼<␍ξ.$",
		out:  "‛．.＂Ｊ␗\\4νρ\x14ｄ：t\aπh^＠␍\x02ςX＂\x15＼<␍ξ.＄",
	}, { // 1298
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "Ｑ.＂Ｊ␗\\4νρ\x14ｄ：t\aπh^＠␍\x02ςX＂\x15＼<␍ξ..",
		out:  "Ｑ.＂Ｊ␗\\4νρ\x14ｄ：t\aπh^＠␍\x02ςX＂\x15＼<␍ξ.．",
	}, { // 1299
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "Ｑ.＂Ｊ␗\\4νρ\x14ｄ：t\aπh^＠␍\x02ςX＂\x15＼<␍ξ.．",
		out:  "Ｑ.＂Ｊ␗\\4νρ\x14ｄ：t\aπh^＠␍\x02ςX＂\x15＼<␍ξ.‛．",
	}, { // 1300
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..:．Ｂ＃H\uff00ςＵ０L\nmςς␋-\x04＜␃\x1aρW␃\x04\x0fι.％",
		out:  "．.:．Ｂ＃H\uff00ςＵ０L\nmςς␋-\x04＜␃\x1aρW␃\x04\x0fι.％",
	}, { // 1301
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.:．Ｂ＃H\uff00ςＵ０L\nmςς␋-\x04＜␃\x1aρW␃\x04\x0fι.％",
		out:  "‛．.:．Ｂ＃H\uff00ςＵ０L\nmςς␋-\x04＜␃\x1aρW␃\x04\x0fι.％",
	}, { // 1302
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "］.:．Ｂ＃H\uff00ςＵ０L\nmςς␋-\x04＜␃\x1aρW␃\x04\x0fι..",
		out:  "］.:．Ｂ＃H\uff00ςＵ０L\nmςς␋-\x04＜␃\x1aρW␃\x04\x0fι.．",
	}, { // 1303
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "］.:．Ｂ＃H\uff00ςＵ０L\nmςς␋-\x04＜␃\x1aρW␃\x04\x0fι.．",
		out:  "］.:．Ｂ＃H\uff00ςＵ０L\nmςς␋-\x04＜␃\x1aρW␃\x04\x0fι.‛．",
	}, { // 1304
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..ｒ：\rｚlζκ␐␟P４\x00<\nψ\x12bfＫδ｜␝'ς␋\x14.S",
		out:  "．.ｒ‛：\rｚlζκ␐␟P４␀<\nψ\x12bfＫδ｜␝'ς␋\x14.S",
	}, { // 1305
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.ｒ：\rｚlζκ␐␟P４\x00<\nψ\x12bfＫδ｜␝'ς␋\x14.S",
		out:  "‛．.ｒ‛：\rｚlζκ␐␟P４␀<\nψ\x12bfＫδ｜␝'ς␋\x14.S",
	}, { // 1306
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "ζ.ｒ：\rｚlζκ␐␟P４\x00<\nψ\x12bfＫδ｜␝'ς␋\x14..",
		out:  "ζ.ｒ‛：\rｚlζκ␐␟P４␀<\nψ\x12bfＫδ｜␝'ς␋\x14.．",
	}, { // 1307
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "ζ.ｒ：\rｚlζκ␐␟P４\x00<\nψ\x12bfＫδ｜␝'ς␋\x14.．",
		out:  "ζ.ｒ‛：\rｚlζκ␐␟P４␀<\nψ\x12bfＫδ｜␝'ς␋\x14.‛．",
	}, { // 1308
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..s␗５ωｅT\\\x14ψ␏\rχ＇\x0f\x02α\x1c＊λｚ;\u007f％'［Ｈ.ι",
		out:  "．.s␗５ωｅT\\\x14ψ␏\rχ＇\x0f\x02α\x1c＊λｚ;\u007f％'［Ｈ.ι",
	}, { // 1309
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.s␗５ωｅT\\\x14ψ␏\rχ＇\x0f\x02α\x1c＊λｚ;\u007f％'［Ｈ.ι",
		out:  "‛．.s␗５ωｅT\\\x14ψ␏\rχ＇\x0f\x02α\x1c＊λｚ;\u007f％'［Ｈ.ι",
	}, { // 1310
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "j.s␗５ωｅT\\\x14ψ␏\rχ＇\x0f\x02α\x1c＊λｚ;\u007f％'［Ｈ..",
		out:  "j.s␗５ωｅT\\\x14ψ␏\rχ＇\x0f\x02α\x1c＊λｚ;\u007f％'［Ｈ.．",
	}, { // 1311
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "j.s␗５ωｅT\\\x14ψ␏\rχ＇\x0f\x02α\x1c＊λｚ;\u007f％'［Ｈ.．",
		out:  "j.s␗５ωｅT\\\x14ψ␏\rχ＇\x0f\x02α\x1c＊λｚ;\u007f％'［Ｈ.‛．",
	}, { // 1312
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..-φ\b␄Ａ␑\x14Ｎ␑λ␆{\x14-δςγY#`｛$␝\x1f｜ｄ.κ",
		out:  "．.-φ\b␄Ａ␑\x14Ｎ␑λ␆{\x14-δςγY#`｛$␝\x1f｜ｄ.κ",
	}, { // 1313
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.-φ\b␄Ａ␑\x14Ｎ␑λ␆{\x14-δςγY#`｛$␝\x1f｜ｄ.κ",
		out:  "‛．.-φ\b␄Ａ␑\x14Ｎ␑λ␆{\x14-δςγY#`｛$␝\x1f｜ｄ.κ",
	}, { // 1314
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "Ｔ.-φ\b␄Ａ␑\x14Ｎ␑λ␆{\x14-δςγY#`｛$␝\x1f｜ｄ..",
		out:  "Ｔ.-φ\b␄Ａ␑\x14Ｎ␑λ␆{\x14-δςγY#`｛$␝\x1f｜ｄ.．",
	}, { // 1315
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "Ｔ.-φ\b␄Ａ␑\x14Ｎ␑λ␆{\x14-δςγY#`｛$␝\x1f｜ｄ.．",
		out:  "Ｔ.-φ\b␄Ａ␑\x14Ｎ␑λ␆{\x14-δςγY#`｛$␝\x1f｜ｄ.‛．",
	}, { // 1316
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..\x16U|＇.＼␚Ｏ␀Ｖλ＂χ\t\b\x17ας｀␡ｐｈvκ/&.ε",
		out:  "．.\x16U｜＇.＼␚Ｏ‛␀Ｖλ＂χ\t\b\x17ας｀␡ｐｈvκ/&.ε",
	}, { // 1317
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.\x16U|＇.＼␚Ｏ␀Ｖλ＂χ\t\b\x17ας｀␡ｐｈvκ/&.ε",
		out:  "‛．.\x16U｜＇.＼␚Ｏ‛␀Ｖλ＂χ\t\b\x17ας｀␡ｐｈvκ/&.ε",
	}, { // 1318
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "Ｅ.\x16U|＇.＼␚Ｏ␀Ｖλ＂χ\t\b\x17ας｀␡ｐｈvκ/&..",
		out:  "Ｅ.\x16U｜＇.＼␚Ｏ‛␀Ｖλ＂χ\t\b\x17ας｀␡ｐｈvκ/&.．",
	}, { // 1319
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "Ｅ.\x16U|＇.＼␚Ｏ␀Ｖλ＂χ\t\b\x17ας｀␡ｐｈvκ/&.．",
		out:  "Ｅ.\x16U｜＇.＼␚Ｏ‛␀Ｖλ＂χ\t\b\x17ας｀␡ｐｈvκ/&.‛．",
	}, { // 1320
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..ＤN;χXpＬο=］␇\a\vο－␘␡8\x11＿\x0eαω\x19␉＂.ｘ",
		out:  "．.ＤN;χXpＬο=］␇\a\vο－␘␡8\x11＿\x0eαω\x19␉＂.ｘ",
	}, { // 1321
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.ＤN;χXpＬο=］␇\a\vο－␘␡8\x11＿\x0eαω\x19␉＂.ｘ",
		out:  "‛．.ＤN;χXpＬο=］␇\a\vο－␘␡8\x11＿\x0eαω\x19␉＂.ｘ",
	}, { // 1322
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "＋.ＤN;χXpＬο=］␇\a\vο－␘␡8\x11＿\x0eαω\x19␉＂..",
		out:  "＋.ＤN;χXpＬο=］␇\a\vο－␘␡8\x11＿\x0eαω\x19␉＂.．",
	}, { // 1323
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "＋.ＤN;χXpＬο=］␇\a\vο－␘␡8\x11＿\x0eαω\x19␉＂.．",
		out:  "＋.ＤN;χXpＬο=］␇\a\vο－␘␡8\x11＿\x0eαω\x19␉＂.‛．",
	}, { // 1324
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..\x06φrη＞'ν δ｀]ｉVψ\x17\x04（␛［（！$␇ξ[\x10.＇",
		out:  "．.\x06φrη＞'ν δ｀]ｉVψ\x17\x04（␛［（！$␇ξ[\x10.＇",
	}, { // 1325
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.\x06φrη＞'ν δ｀]ｉVψ\x17\x04（␛［（！$␇ξ[\x10.＇",
		out:  "‛．.\x06φrη＞'ν δ｀]ｉVψ\x17\x04（␛［（！$␇ξ[\x10.＇",
	}, { // 1326
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "␎.\x06φrη＞'ν δ｀]ｉVψ\x17\x04（␛［（！$␇ξ[\x10..",
		out:  "␎.\x06φrη＞'ν δ｀]ｉVψ\x17\x04（␛［（！$␇ξ[\x10.．",
	}, { // 1327
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "␎.\x06φrη＞'ν δ｀]ｉVψ\x17\x04（␛［（！$␇ξ[\x10.．",
		out:  "␎.\x06φrη＞'ν δ｀]ｉVψ\x17\x04（␛［（！$␇ξ[\x10.‛．",
	}, { // 1328
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..F\x19/κ␉\x19#␏ｗ[␟χπρ\x1e␛Ｂ␒#s|UＰωA␈.Ｅ",
		out:  "．.F\x19/κ␉\x19#␏ｗ[␟χπρ\x1e␛Ｂ␒#s|UＰωA␈.Ｅ",
	}, { // 1329
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.F\x19/κ␉\x19#␏ｗ[␟χπρ\x1e␛Ｂ␒#s|UＰωA␈.Ｅ",
		out:  "‛．.F\x19/κ␉\x19#␏ｗ[␟χπρ\x1e␛Ｂ␒#s|UＰωA␈.Ｅ",
	}, { // 1330
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "η.F\x19/κ␉\x19#␏ｗ[␟χπρ\x1e␛Ｂ␒#s|UＰωA␈..",
		out:  "η.F\x19/κ␉\x19#␏ｗ[␟χπρ\x1e␛Ｂ␒#s|UＰωA␈.．",
	}, { // 1331
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "η.F\x19/κ␉\x19#␏ｗ[␟χπρ\x1e␛Ｂ␒#s|UＰωA␈.．",
		out:  "η.F\x19/κ␉\x19#␏ｗ[␟χπρ\x1e␛Ｂ␒#s|UＰωA␈.‛．",
	}, { // 1332
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..ν\x05SＨq`ａi\t＝<\x17＞＆)：φ␓Ｊ＂ε␋π\x1f\x04␏.␞",
		out:  "．.ν\x05SＨq`ａi\t＝<\x17＞＆)：φ␓Ｊ＂ε␋π\x1f\x04␏.␞",
	}, { // 1333
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.ν\x05SＨq`ａi\t＝<\x17＞＆)：φ␓Ｊ＂ε␋π\x1f\x04␏.␞",
		out:  "‛．.ν\x05SＨq`ａi\t＝<\x17＞＆)：φ␓Ｊ＂ε␋π\x1f\x04␏.␞",
	}, { // 1334
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "λ.ν\x05SＨq`ａi\t＝<\x17＞＆)：φ␓Ｊ＂ε␋π\x1f\x04␏..",
		out:  "λ.ν\x05SＨq`ａi\t＝<\x17＞＆)：φ␓Ｊ＂ε␋π\x1f\x04␏.．",
	}, { // 1335
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "λ.ν\x05SＨq`ａi\t＝<\x17＞＆)：φ␓Ｊ＂ε␋π\x1f\x04␏.．",
		out:  "λ.ν\x05SＨq`ａi\t＝<\x17＞＆)：φ␓Ｊ＂ε␋π\x1f\x04␏.‛．",
	}, { // 1336
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..%1\x05^＆\x1e\f}O␔␍ςςβ␃γ．＄χ／\x06/υ\x0e␆！.１",
		out:  "．.%1\x05^＆\x1e\f}O␔␍ςςβ␃γ．＄χ／\x06/υ\x0e␆！.１",
	}, { // 1337
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.%1\x05^＆\x1e\f}O␔␍ςςβ␃γ．＄χ／\x06/υ\x0e␆！.１",
		out:  "‛．.%1\x05^＆\x1e\f}O␔␍ςςβ␃γ．＄χ／\x06/υ\x0e␆！.１",
	}, { // 1338
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "＠.%1\x05^＆\x1e\f}O␔␍ςςβ␃γ．＄χ／\x06/υ\x0e␆！..",
		out:  "＠.%1\x05^＆\x1e\f}O␔␍ςςβ␃γ．＄χ／\x06/υ\x0e␆！.．",
	}, { // 1339
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "＠.%1\x05^＆\x1e\f}O␔␍ςςβ␃γ．＄χ／\x06/υ\x0e␆！.．",
		out:  "＠.%1\x05^＆\x1e\f}O␔␍ςςβ␃γ．＄χ／\x06/υ\x0e␆！.‛．",
	}, { // 1340
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..?e＇ｚ␝t\\ｉ␕υζTＱ=ο\vH＜σ６␊<␄１\x13\x0e.λ",
		out:  "．.?e＇ｚ‛␝t\\ｉ‛␕υζTＱ=ο␋H＜σ６‛␊<‛␄１␓␎.λ",
	}, { // 1341
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.?e＇ｚ␝t\\ｉ␕υζTＱ=ο\vH＜σ６␊<␄１\x13\x0e.λ",
		out:  "‛．.?e＇ｚ‛␝t\\ｉ‛␕υζTＱ=ο␋H＜σ６‛␊<‛␄１␓␎.λ",
	}, { // 1342
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "ν.?e＇ｚ␝t\\ｉ␕υζTＱ=ο\vH＜σ６␊<␄１\x13\x0e..",
		out:  "ν.?e＇ｚ‛␝t\\ｉ‛␕υζTＱ=ο␋H＜σ６‛␊<‛␄１␓␎.．",
	}, { // 1343
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "ν.?e＇ｚ␝t\\ｉ␕υζTＱ=ο\vH＜σ６␊<␄１\x13\x0e.．",
		out:  "ν.?e＇ｚ‛␝t\\ｉ‛␕υζTＱ=ο␋H＜σ６‛␊<‛␄１␓␎.‛．",
	}, { // 1344
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\tＧ",
		out:  "．\t|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\tＧ",
	}, { // 1345
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\tＧ",
		out:  "‛．\t|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\tＧ",
	}, { // 1346
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\nＧ",
		out:  "．\n|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\nＧ",
	}, { // 1347
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\nＧ",
		out:  "‛．\n|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\nＧ",
	}, { // 1348
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\vＧ",
		out:  "．\v|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\vＧ",
	}, { // 1349
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\vＧ",
		out:  "‛．\v|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\vＧ",
	}, { // 1350
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\rＧ",
		out:  "．\r|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\rＧ",
	}, { // 1351
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\rＧ",
		out:  "‛．\r|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\rＧ",
	}, { // 1352
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\x17\t|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\t.",
		out:  "\x17\t|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\t.",
	}, { // 1353
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\x17\t|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\t．",
		out:  "\x17\t|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\t．",
	}, { // 1354
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\x17\n|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\n.",
		out:  "\x17\n|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\n.",
	}, { // 1355
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\x17\n|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\n．",
		out:  "\x17\n|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\n．",
	}, { // 1356
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\x17\v|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\v.",
		out:  "\x17\v|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\v.",
	}, { // 1357
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\x17\v|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\v．",
		out:  "\x17\v|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\v．",
	}, { // 1358
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\x17\r|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\r.",
		out:  "\x17\r|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\r.",
	}, { // 1359
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\x17\r|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\r．",
		out:  "\x17\r|$␔Ｄβ＞\x0e｜／ｔα)dκ\x10\x1d\r%LＩ␎＿␆αυφ\r．",
	}, { // 1360
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t[υ＼｜μ,Ｙ:＞␆／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\t\r",
		out:  "．\t[υ＼｜μ,Ｙ:＞␆‛／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\t␍",
	}, { // 1361
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t[υ＼｜μ,Ｙ:＞␆／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\t\r",
		out:  "‛．\t[υ＼｜μ,Ｙ:＞␆‛／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\t␍",
	}, { // 1362
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n[υ＼｜μ,Ｙ:＞␆／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\n\r",
		out:  "．\n[υ＼｜μ,Ｙ:＞␆‛／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\n␍",
	}, { // 1363
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n[υ＼｜μ,Ｙ:＞␆／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\n\r",
		out:  "‛．\n[υ＼｜μ,Ｙ:＞␆‛／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\n␍",
	}, { // 1364
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v[υ＼｜μ,Ｙ:＞␆／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\v\r",
		out:  "．\v[υ＼｜μ,Ｙ:＞␆‛／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\v␍",
	}, { // 1365
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v[υ＼｜μ,Ｙ:＞␆／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\v\r",
		out:  "‛．\v[υ＼｜μ,Ｙ:＞␆‛／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\v␍",
	}, { // 1366
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r[υ＼｜μ,Ｙ:＞␆／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\r\r",
		out:  "．\r[υ＼｜μ,Ｙ:＞␆‛／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\r␍",
	}, { // 1367
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r[υ＼｜μ,Ｙ:＞␆／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\r\r",
		out:  "‛．\r[υ＼｜μ,Ｙ:＞␆‛／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\r␍",
	}, { // 1368
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "γ\t[υ＼｜μ,Ｙ:＞␆／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\t.",
		out:  "γ\t[υ＼｜μ,Ｙ:＞␆‛／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\t.",
	}, { // 1369
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "γ\t[υ＼｜μ,Ｙ:＞␆／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\t．",
		out:  "γ\t[υ＼｜μ,Ｙ:＞␆‛／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\t．",
	}, { // 1370
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "γ\n[υ＼｜μ,Ｙ:＞␆／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\n.",
		out:  "γ\n[υ＼｜μ,Ｙ:＞␆‛／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\n.",
	}, { // 1371
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "γ\n[υ＼｜μ,Ｙ:＞␆／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\n．",
		out:  "γ\n[υ＼｜μ,Ｙ:＞␆‛／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\n．",
	}, { // 1372
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "γ\v[υ＼｜μ,Ｙ:＞␆／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\v.",
		out:  "γ\v[υ＼｜μ,Ｙ:＞␆‛／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\v.",
	}, { // 1373
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "γ\v[υ＼｜μ,Ｙ:＞␆／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\v．",
		out:  "γ\v[υ＼｜μ,Ｙ:＞␆‛／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\v．",
	}, { // 1374
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "γ\r[υ＼｜μ,Ｙ:＞␆／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\r.",
		out:  "γ\r[υ＼｜μ,Ｙ:＞␆‛／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\r.",
	}, { // 1375
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "γ\r[υ＼｜μ,Ｙ:＞␆／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\r．",
		out:  "γ\r[υ＼｜μ,Ｙ:＞␆‛／πζ\x02␕qγＥ\u007f\t｝␑２F␊8\r．",
	}, { // 1376
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\th␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\t\f",
		out:  "．\th␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\t\f",
	}, { // 1377
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\th␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\t\f",
		out:  "‛．\th␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\t\f",
	}, { // 1378
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\nh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\n\f",
		out:  "．\nh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\n\f",
	}, { // 1379
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\nh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\n\f",
		out:  "‛．\nh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\n\f",
	}, { // 1380
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\vh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\v\f",
		out:  "．\vh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\v\f",
	}, { // 1381
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\vh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\v\f",
		out:  "‛．\vh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\v\f",
	}, { // 1382
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\rh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\r\f",
		out:  "．\rh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\r\f",
	}, { // 1383
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\rh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\r\f",
		out:  "‛．\rh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\r\f",
	}, { // 1384
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｍ\th␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\t.",
		out:  "Ｍ\th␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\t.",
	}, { // 1385
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｍ\th␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\t．",
		out:  "Ｍ\th␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\t．",
	}, { // 1386
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｍ\nh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\n.",
		out:  "Ｍ\nh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\n.",
	}, { // 1387
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｍ\nh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\n．",
		out:  "Ｍ\nh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\n．",
	}, { // 1388
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｍ\vh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\v.",
		out:  "Ｍ\vh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\v.",
	}, { // 1389
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｍ\vh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\v．",
		out:  "Ｍ\vh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\v．",
	}, { // 1390
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｍ\rh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\r.",
		out:  "Ｍ\rh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\r.",
	}, { // 1391
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｍ\rh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\r．",
		out:  "Ｍ\rh␌χd\x18Ｉβ\nsτ＃\bM␍β＼Ｏ\x02␉\x04χｗeο：␄\r．",
	}, { // 1392
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\tψ",
		out:  "．\t}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\tψ",
	}, { // 1393
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\tψ",
		out:  "‛．\t}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\tψ",
	}, { // 1394
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\nψ",
		out:  "．\n}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\nψ",
	}, { // 1395
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\nψ",
		out:  "‛．\n}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\nψ",
	}, { // 1396
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\vψ",
		out:  "．\v}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\vψ",
	}, { // 1397
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\vψ",
		out:  "‛．\v}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\vψ",
	}, { // 1398
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\rψ",
		out:  "．\r}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\rψ",
	}, { // 1399
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\rψ",
		out:  "‛．\r}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\rψ",
	}, { // 1400
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｖ\t}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\t.",
		out:  "Ｖ\t}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\t.",
	}, { // 1401
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｖ\t}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\t．",
		out:  "Ｖ\t}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\t．",
	}, { // 1402
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｖ\n}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\n.",
		out:  "Ｖ\n}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\n.",
	}, { // 1403
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｖ\n}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\n．",
		out:  "Ｖ\n}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\n．",
	}, { // 1404
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｖ\v}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\v.",
		out:  "Ｖ\v}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\v.",
	}, { // 1405
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｖ\v}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\v．",
		out:  "Ｖ\v}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\v．",
	}, { // 1406
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｖ\r}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\r.",
		out:  "Ｖ\r}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\r.",
	}, { // 1407
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｖ\r}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\r．",
		out:  "Ｖ\r}Ｚ\x02␘＇G\r4＼μjς␏MY\x1e\x15␍ρ｜␊θγ＿$Ｒ\r．",
	}, { // 1408
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t＄λ'J＄ζ␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\t␅",
		out:  "．\t＄λ'J＄ζ‛␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\t␅",
	}, { // 1409
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t＄λ'J＄ζ␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\t␅",
		out:  "‛．\t＄λ'J＄ζ‛␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\t␅",
	}, { // 1410
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n＄λ'J＄ζ␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\n␅",
		out:  "．\n＄λ'J＄ζ‛␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\n␅",
	}, { // 1411
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n＄λ'J＄ζ␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\n␅",
		out:  "‛．\n＄λ'J＄ζ‛␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\n␅",
	}, { // 1412
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v＄λ'J＄ζ␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\v␅",
		out:  "．\v＄λ'J＄ζ‛␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\v␅",
	}, { // 1413
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v＄λ'J＄ζ␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\v␅",
		out:  "‛．\v＄λ'J＄ζ‛␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\v␅",
	}, { // 1414
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r＄λ'J＄ζ␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\r␅",
		out:  "．\r＄λ'J＄ζ‛␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\r␅",
	}, { // 1415
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r＄λ'J＄ζ␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\r␅",
		out:  "‛．\r＄λ'J＄ζ‛␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\r␅",
	}, { // 1416
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\b\t＄λ'J＄ζ␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\t.",
		out:  "\b\t＄λ'J＄ζ‛␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\t.",
	}, { // 1417
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\b\t＄λ'J＄ζ␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\t．",
		out:  "\b\t＄λ'J＄ζ‛␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\t．",
	}, { // 1418
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\b\n＄λ'J＄ζ␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\n.",
		out:  "\b\n＄λ'J＄ζ‛␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\n.",
	}, { // 1419
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\b\n＄λ'J＄ζ␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\n．",
		out:  "\b\n＄λ'J＄ζ‛␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\n．",
	}, { // 1420
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\b\v＄λ'J＄ζ␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\v.",
		out:  "\b\v＄λ'J＄ζ‛␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\v.",
	}, { // 1421
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\b\v＄λ'J＄ζ␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\v．",
		out:  "\b\v＄λ'J＄ζ‛␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\v．",
	}, { // 1422
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\b\r＄λ'J＄ζ␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\r.",
		out:  "\b\r＄λ'J＄ζ‛␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\r.",
	}, { // 1423
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\b\r＄λ'J＄ζ␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\r．",
		out:  "\b\r＄λ'J＄ζ‛␀ＰζY$|\x01Ｑ␃＾＃！#λγt4␕\x11［\r．",
	}, { // 1424
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\tｑBπ８ξε％δ1］?#ＭχＵE｀\x14ξ␓YAn６␏\x00\t\x1d",
		out:  "．\tｑBπ８ξε％δ1‛］?#ＭχＵE｀\x14ξ␓YAn６␏␀\t\x1d",
	}, { // 1425
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\tｑBπ８ξε％δ1］?#ＭχＵE｀\x14ξ␓YAn６␏\x00\t\x1d",
		out:  "‛．\tｑBπ８ξε％δ1‛］?#ＭχＵE｀\x14ξ␓YAn６␏␀\t\x1d",
	}, { // 1426
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\nｑBπ８ξε％δ1］?#ＭχＵE｀\x14ξ␓YAn６␏\x00\n\x1d",
		out:  "．\nｑBπ８ξε％δ1‛］?#ＭχＵE｀\x14ξ␓YAn６␏␀\n\x1d",
	}, { // 1427
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\nｑBπ８ξε％δ1］?#ＭχＵE｀\x14ξ␓YAn６␏\x00\n\x1d",
		out:  "‛．\nｑBπ８ξε％δ1‛］?#ＭχＵE｀\x14ξ␓YAn６␏␀\n\x1d",
	}, { // 1428
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\vｑBπ８ξε％δ1］?#ＭχＵE｀\x14ξ␓YAn６␏\x00\v\x1d",
		out:  "．\vｑBπ８ξε％δ1‛］?#ＭχＵE｀\x14ξ␓YAn６␏␀\v\x1d",
	}, { // 1429
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\vｑBπ８ξε％δ1］?#ＭχＵE｀\x14ξ␓YAn６␏\x00\v\x1d",
		out:  "‛．\vｑBπ８ξε％δ1‛］?#ＭχＵE｀\x14ξ␓YAn６␏␀\v\x1d",
	}, { // 1430
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\rｑBπ８ξε％δ1］?#ＭχＵE｀\x14ξ␓YAn６␏\x00\r\x1d",
		out:  "．\rｑBπ８ξε％δ1‛］?#ＭχＵE｀\x14ξ␓YAn６␏␀\r\x1d",
	}, { // 1431
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\rｑBπ８ξε％δ1］?#ＭχＵE｀\x14ξ␓YAn６␏\x00\r\x1d",
		out:  "‛．\rｑBπ８ξε％δ1‛］?#ＭχＵE｀\x14ξ␓YAn６␏␀\r\x1d",
	}, { // 1432
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␂\tｑBπ８ξε％δ1］?#ＭχＵE｀\x14ξ␓YAn６␏\x00\t.",
		out:  "␂\tｑBπ８ξε％δ1‛］?#ＭχＵE｀\x14ξ␓YAn６␏␀\t.",
	}, { // 1433
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␂\tｑBπ８ξε％δ1］?#ＭχＵE｀\x14ξ␓YAn６␏\x00\t．",
		out:  "␂\tｑBπ８ξε％δ1‛］?#ＭχＵE｀\x14ξ␓YAn６␏␀\t．",
	}, { // 1434
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␂\nｑBπ８ξε％δ1］?#ＭχＵE｀\x14ξ␓YAn６␏\x00\n.",
		out:  "␂\nｑBπ８ξε％δ1‛］?#ＭχＵE｀\x14ξ␓YAn６␏␀\n.",
	}, { // 1435
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␂\nｑBπ８ξε％δ1］?#ＭχＵE｀\x14ξ␓YAn６␏\x00\n．",
		out:  "␂\nｑBπ８ξε％δ1‛］?#ＭχＵE｀\x14ξ␓YAn６␏␀\n．",
	}, { // 1436
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␂\vｑBπ８ξε％δ1］?#ＭχＵE｀\x14ξ␓YAn６␏\x00\v.",
		out:  "␂\vｑBπ８ξε％δ1‛］?#ＭχＵE｀\x14ξ␓YAn６␏␀\v.",
	}, { // 1437
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␂\vｑBπ８ξε％δ1］?#ＭχＵE｀\x14ξ␓YAn６␏\x00\v．",
		out:  "␂\vｑBπ８ξε％δ1‛］?#ＭχＵE｀\x14ξ␓YAn６␏␀\v．",
	}, { // 1438
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␂\rｑBπ８ξε％δ1］?#ＭχＵE｀\x14ξ␓YAn６␏\x00\r.",
		out:  "␂\rｑBπ８ξε％δ1‛］?#ＭχＵE｀\x14ξ␓YAn６␏␀\r.",
	}, { // 1439
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␂\rｑBπ８ξε％δ1］?#ＭχＵE｀\x14ξ␓YAn６␏\x00\r．",
		out:  "␂\rｑBπ８ξε％δ1‛］?#ＭχＵE｀\x14ξ␓YAn６␏␀\r．",
	}, { // 1440
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\tψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\ti",
		out:  "．\tψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\ti",
	}, { // 1441
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\tψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\ti",
		out:  "‛．\tψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\ti",
	}, { // 1442
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\nψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\ni",
		out:  "．\nψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\ni",
	}, { // 1443
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\nψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\ni",
		out:  "‛．\nψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\ni",
	}, { // 1444
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\vψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\vi",
		out:  "．\vψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\vi",
	}, { // 1445
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\vψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\vi",
		out:  "‛．\vψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\vi",
	}, { // 1446
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\rψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\ri",
		out:  "．\rψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\ri",
	}, { // 1447
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\rψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\ri",
		out:  "‛．\rψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\ri",
	}, { // 1448
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ζ\tψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\t.",
		out:  "ζ\tψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\t.",
	}, { // 1449
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ζ\tψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\t．",
		out:  "ζ\tψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\t．",
	}, { // 1450
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ζ\nψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\n.",
		out:  "ζ\nψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\n.",
	}, { // 1451
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ζ\nψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\n．",
		out:  "ζ\nψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\n．",
	}, { // 1452
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ζ\vψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\v.",
		out:  "ζ\vψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\v.",
	}, { // 1453
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ζ\vψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\v．",
		out:  "ζ\vψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\v．",
	}, { // 1454
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ζ\rψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\r.",
		out:  "ζ\rψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\r.",
	}, { // 1455
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ζ\rψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\r．",
		out:  "ζ\rψK：R␎#Ｒ␎␗＼;３Ａρ\x1dζ\x1d\x12ιi\x10␊］α␄Ｗ\r．",
	}, { // 1456
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\t}",
		out:  "．\t[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\t}",
	}, { // 1457
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\t}",
		out:  "‛．\t[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\t}",
	}, { // 1458
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\n}",
		out:  "．\n[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\n}",
	}, { // 1459
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\n}",
		out:  "‛．\n[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\n}",
	}, { // 1460
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\v}",
		out:  "．\v[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\v}",
	}, { // 1461
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\v}",
		out:  "‛．\v[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\v}",
	}, { // 1462
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\r}",
		out:  "．\r[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\r}",
	}, { // 1463
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\r}",
		out:  "‛．\r[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\r}",
	}, { // 1464
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␇\t[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\t.",
		out:  "␇\t[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\t.",
	}, { // 1465
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␇\t[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\t．",
		out:  "␇\t[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\t．",
	}, { // 1466
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␇\n[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\n.",
		out:  "␇\n[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\n.",
	}, { // 1467
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␇\n[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\n．",
		out:  "␇\n[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\n．",
	}, { // 1468
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␇\v[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\v.",
		out:  "␇\v[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\v.",
	}, { // 1469
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␇\v[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\v．",
		out:  "␇\v[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\v．",
	}, { // 1470
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␇\r[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\r.",
		out:  "␇\r[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\r.",
	}, { // 1471
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␇\r[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\r．",
		out:  "␇\r[␍ν＄\x18κπ\x16yς＼οｖ␊\vς２~ｉ␙Ｄ'\x06\x06nａ\r．",
	}, { // 1472
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t␟␑μ\\：９οο=κmｐAζＭD␞␃\x1a/４␝ι&\x00：\t\x1b",
		out:  "．\t␟␑μ\\‛：９οο=κmｐAζＭD␞␃\x1a/４␝ι&␀‛：\t\x1b",
	}, { // 1473
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t␟␑μ\\：９οο=κmｐAζＭD␞␃\x1a/４␝ι&\x00：\t\x1b",
		out:  "‛．\t␟␑μ\\‛：９οο=κmｐAζＭD␞␃\x1a/４␝ι&␀‛：\t\x1b",
	}, { // 1474
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n␟␑μ\\：９οο=κmｐAζＭD␞␃\x1a/４␝ι&\x00：\n\x1b",
		out:  "．\n␟␑μ\\‛：９οο=κmｐAζＭD␞␃\x1a/４␝ι&␀‛：\n\x1b",
	}, { // 1475
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n␟␑μ\\：９οο=κmｐAζＭD␞␃\x1a/４␝ι&\x00：\n\x1b",
		out:  "‛．\n␟␑μ\\‛：９οο=κmｐAζＭD␞␃\x1a/４␝ι&␀‛：\n\x1b",
	}, { // 1476
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v␟␑μ\\：９οο=κmｐAζＭD␞␃\x1a/４␝ι&\x00：\v\x1b",
		out:  "．\v␟␑μ\\‛：９οο=κmｐAζＭD␞␃\x1a/４␝ι&␀‛：\v\x1b",
	}, { // 1477
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v␟␑μ\\：９οο=κmｐAζＭD␞␃\x1a/４␝ι&\x00：\v\x1b",
		out:  "‛．\v␟␑μ\\‛：９οο=κmｐAζＭD␞␃\x1a/４␝ι&␀‛：\v\x1b",
	}, { // 1478
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r␟␑μ\\：９οο=κmｐAζＭD␞␃\x1a/４␝ι&\x00：\r\x1b",
		out:  "．\r␟␑μ\\‛：９οο=κmｐAζＭD␞␃\x1a/４␝ι&␀‛：\r\x1b",
	}, { // 1479
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r␟␑μ\\：９οο=κmｐAζＭD␞␃\x1a/４␝ι&\x00：\r\x1b",
		out:  "‛．\r␟␑μ\\‛：９οο=κmｐAζＭD␞␃\x1a/４␝ι&␀‛：\r\x1b",
	}, { // 1480
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＊\t␟␑μ\\：９οο=κmｐAζＭD␞␃\x1a/４␝ι&\x00：\t.",
		out:  "＊\t␟␑μ\\‛：９οο=κmｐAζＭD␞␃\x1a/４␝ι&␀‛：\t.",
	}, { // 1481
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＊\t␟␑μ\\：９οο=κmｐAζＭD␞␃\x1a/４␝ι&\x00：\t．",
		out:  "＊\t␟␑μ\\‛：９οο=κmｐAζＭD␞␃\x1a/４␝ι&␀‛：\t．",
	}, { // 1482
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＊\n␟␑μ\\：９οο=κmｐAζＭD␞␃\x1a/４␝ι&\x00：\n.",
		out:  "＊\n␟␑μ\\‛：９οο=κmｐAζＭD␞␃\x1a/４␝ι&␀‛：\n.",
	}, { // 1483
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＊\n␟␑μ\\：９οο=κmｐAζＭD␞␃\x1a/４␝ι&\x00：\n．",
		out:  "＊\n␟␑μ\\‛：９οο=κmｐAζＭD␞␃\x1a/４␝ι&␀‛：\n．",
	}, { // 1484
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＊\v␟␑μ\\：９οο=κmｐAζＭD␞␃\x1a/４␝ι&\x00：\v.",
		out:  "＊\v␟␑μ\\‛：９οο=κmｐAζＭD␞␃\x1a/４␝ι&␀‛：\v.",
	}, { // 1485
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＊\v␟␑μ\\：９οο=κmｐAζＭD␞␃\x1a/４␝ι&\x00：\v．",
		out:  "＊\v␟␑μ\\‛：９οο=κmｐAζＭD␞␃\x1a/４␝ι&␀‛：\v．",
	}, { // 1486
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＊\r␟␑μ\\：９οο=κmｐAζＭD␞␃\x1a/４␝ι&\x00：\r.",
		out:  "＊\r␟␑μ\\‛：９οο=κmｐAζＭD␞␃\x1a/４␝ι&␀‛：\r.",
	}, { // 1487
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＊\r␟␑μ\\：９οο=κmｐAζＭD␞␃\x1a/４␝ι&\x00：\r．",
		out:  "＊\r␟␑μ\\‛：９οο=κmｐAζＭD␞␃\x1a/４␝ι&␀‛：\r．",
	}, { // 1488
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\tη",
		out:  "．\t␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\tη",
	}, { // 1489
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\tη",
		out:  "‛．\t␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\tη",
	}, { // 1490
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\nη",
		out:  "．\n␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\nη",
	}, { // 1491
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\nη",
		out:  "‛．\n␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\nη",
	}, { // 1492
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\vη",
		out:  "．\v␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\vη",
	}, { // 1493
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\vη",
		out:  "‛．\v␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\vη",
	}, { // 1494
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\rη",
		out:  "．\r␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\rη",
	}, { // 1495
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\rη",
		out:  "‛．\r␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\rη",
	}, { // 1496
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "/\t␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\t.",
		out:  "/\t␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\t.",
	}, { // 1497
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "/\t␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\t．",
		out:  "/\t␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\t．",
	}, { // 1498
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "/\n␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\n.",
		out:  "/\n␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\n.",
	}, { // 1499
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "/\n␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\n．",
		out:  "/\n␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\n．",
	}, { // 1500
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "/\v␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\v.",
		out:  "/\v␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\v.",
	}, { // 1501
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "/\v␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\v．",
		out:  "/\v␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\v．",
	}, { // 1502
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "/\r␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\r.",
		out:  "/\r␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\r.",
	}, { // 1503
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "/\r␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\r．",
		out:  "/\r␔/FπＣｂψω＂\x05ｑ|\f／=2␞＄\x0f#(Ｄυ]ｉ␇\r．",
	}, { // 1504
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\tρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\t％",
		out:  "．\tρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\t％",
	}, { // 1505
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\tρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\t％",
		out:  "‛．\tρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\t％",
	}, { // 1506
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\nρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\n％",
		out:  "．\nρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\n％",
	}, { // 1507
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\nρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\n％",
		out:  "‛．\nρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\n％",
	}, { // 1508
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\vρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\v％",
		out:  "．\vρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\v％",
	}, { // 1509
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\vρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\v％",
		out:  "‛．\vρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\v％",
	}, { // 1510
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\rρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\r％",
		out:  "．\rρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\r％",
	}, { // 1511
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\rρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\r％",
		out:  "‛．\rρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\r％",
	}, { // 1512
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "－\tρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\t.",
		out:  "－\tρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\t.",
	}, { // 1513
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "－\tρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\t．",
		out:  "－\tρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\t．",
	}, { // 1514
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "－\nρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\n.",
		out:  "－\nρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\n.",
	}, { // 1515
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "－\nρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\n．",
		out:  "－\nρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\n．",
	}, { // 1516
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "－\vρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\v.",
		out:  "－\vρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\v.",
	}, { // 1517
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "－\vρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\v．",
		out:  "－\vρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\v．",
	}, { // 1518
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "－\rρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\r.",
		out:  "－\rρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\r.",
	}, { // 1519
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "－\rρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\r．",
		out:  "－\rρτkρ\x11＾Z\x0fκ[＂'λ\x1b%＜jθＰ\x04＄Ｋ\x18␝Ｓ＂\r．",
	}, { // 1520
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q｜σοＪＬβ\te",
		out:  "．\t\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q‛｜σοＪＬβ\te",
	}, { // 1521
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q｜σοＪＬβ\te",
		out:  "‛．\t\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q‛｜σοＪＬβ\te",
	}, { // 1522
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q｜σοＪＬβ\ne",
		out:  "．\n\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q‛｜σοＪＬβ\ne",
	}, { // 1523
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q｜σοＪＬβ\ne",
		out:  "‛．\n\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q‛｜σοＪＬβ\ne",
	}, { // 1524
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q｜σοＪＬβ\ve",
		out:  "．\v\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q‛｜σοＪＬβ\ve",
	}, { // 1525
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q｜σοＪＬβ\ve",
		out:  "‛．\v\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q‛｜σοＪＬβ\ve",
	}, { // 1526
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q｜σοＪＬβ\re",
		out:  "．\r\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q‛｜σοＪＬβ\re",
	}, { // 1527
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q｜σοＪＬβ\re",
		out:  "‛．\r\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q‛｜σοＪＬβ\re",
	}, { // 1528
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｓ\t\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q｜σοＪＬβ\t.",
		out:  "ｓ\t\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q‛｜σοＪＬβ\t.",
	}, { // 1529
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｓ\t\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q｜σοＪＬβ\t．",
		out:  "ｓ\t\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q‛｜σοＪＬβ\t．",
	}, { // 1530
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｓ\n\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q｜σοＪＬβ\n.",
		out:  "ｓ\n\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q‛｜σοＪＬβ\n.",
	}, { // 1531
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｓ\n\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q｜σοＪＬβ\n．",
		out:  "ｓ\n\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q‛｜σοＪＬβ\n．",
	}, { // 1532
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｓ\v\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q｜σοＪＬβ\v.",
		out:  "ｓ\v\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q‛｜σοＪＬβ\v.",
	}, { // 1533
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｓ\v\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q｜σοＪＬβ\v．",
		out:  "ｓ\v\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q‛｜σοＪＬβ\v．",
	}, { // 1534
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｓ\r\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q｜σοＪＬβ\r.",
		out:  "ｓ\r\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q‛｜σοＪＬβ\r.",
	}, { // 1535
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｓ\r\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q｜σοＪＬβ\r．",
		out:  "ｓ\r\x03ｆ}[iG\x0fι（␅␎［\x01ψ␊α\a８\x05q‛｜σοＪＬβ\r．",
	}, { // 1536
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\tＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\t␕",
		out:  "．\tＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\t␕",
	}, { // 1537
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\tＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\t␕",
		out:  "‛．\tＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\t␕",
	}, { // 1538
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\nＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\n␕",
		out:  "．\nＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\n␕",
	}, { // 1539
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\nＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\n␕",
		out:  "‛．\nＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\n␕",
	}, { // 1540
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\vＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\v␕",
		out:  "．\vＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\v␕",
	}, { // 1541
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\vＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\v␕",
		out:  "‛．\vＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\v␕",
	}, { // 1542
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\rＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\r␕",
		out:  "．\rＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\r␕",
	}, { // 1543
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\rＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\r␕",
		out:  "‛．\rＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\r␕",
	}, { // 1544
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＄\tＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\t.",
		out:  "＄\tＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\t.",
	}, { // 1545
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＄\tＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\t．",
		out:  "＄\tＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\t．",
	}, { // 1546
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＄\nＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\n.",
		out:  "＄\nＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\n.",
	}, { // 1547
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＄\nＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\n．",
		out:  "＄\nＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\n．",
	}, { // 1548
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＄\vＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\v.",
		out:  "＄\vＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\v.",
	}, { // 1549
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＄\vＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\v．",
		out:  "＄\vＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\v．",
	}, { // 1550
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＄\rＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\r.",
		out:  "＄\rＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\r.",
	}, { // 1551
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＄\rＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\r．",
		out:  "＄\rＧ／c␐<`ιrγQzＸ/o<\x06ξ＠ζδ\x14｝ι１␎＂\r．",
	}, { // 1552
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\tυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\t␓",
		out:  "．\tυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\t␓",
	}, { // 1553
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\tυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\t␓",
		out:  "‛．\tυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\t␓",
	}, { // 1554
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\nυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\n␓",
		out:  "．\nυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\n␓",
	}, { // 1555
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\nυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\n␓",
		out:  "‛．\nυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\n␓",
	}, { // 1556
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\vυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\v␓",
		out:  "．\vυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\v␓",
	}, { // 1557
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\vυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\v␓",
		out:  "‛．\vυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\v␓",
	}, { // 1558
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\rυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\r␓",
		out:  "．\rυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\r␓",
	}, { // 1559
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\rυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\r␓",
		out:  "‛．\rυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\r␓",
	}, { // 1560
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␕\tυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\t.",
		out:  "␕\tυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\t.",
	}, { // 1561
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␕\tυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\t．",
		out:  "␕\tυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\t．",
	}, { // 1562
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␕\nυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\n.",
		out:  "␕\nυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\n.",
	}, { // 1563
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␕\nυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\n．",
		out:  "␕\nυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\n．",
	}, { // 1564
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␕\vυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\v.",
		out:  "␕\vυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\v.",
	}, { // 1565
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␕\vυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\v．",
		out:  "␕\vυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\v．",
	}, { // 1566
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␕\rυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\r.",
		out:  "␕\rυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\r.",
	}, { // 1567
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␕\rυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\r．",
		out:  "␕\rυξｑ\x1c｜\x10ｐ␌\x12.Ｎ\b９CDOρ␟\x0fκt>τ␓&ｖ\r．",
	}, { // 1568
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\t)",
		out:  "．\t:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\t)",
	}, { // 1569
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\t)",
		out:  "‛．\t:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\t)",
	}, { // 1570
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\n)",
		out:  "．\n:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\n)",
	}, { // 1571
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\n)",
		out:  "‛．\n:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\n)",
	}, { // 1572
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\v)",
		out:  "．\v:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\v)",
	}, { // 1573
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\v)",
		out:  "‛．\v:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\v)",
	}, { // 1574
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\r)",
		out:  "．\r:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\r)",
	}, { // 1575
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\r)",
		out:  "‛．\r:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\r)",
	}, { // 1576
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "*\t:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\t.",
		out:  "*\t:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\t.",
	}, { // 1577
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "*\t:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\t．",
		out:  "*\t:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\t．",
	}, { // 1578
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "*\n:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\n.",
		out:  "*\n:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\n.",
	}, { // 1579
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "*\n:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\n．",
		out:  "*\n:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\n．",
	}, { // 1580
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "*\v:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\v.",
		out:  "*\v:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\v.",
	}, { // 1581
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "*\v:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\v．",
		out:  "*\v:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\v．",
	}, { // 1582
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "*\r:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\r.",
		out:  "*\r:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\r.",
	}, { // 1583
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "*\r:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\r．",
		out:  "*\r:␁Ｒσ␅８iζ␋'␄｜Vα\x04\x19β;ν\aＨＤｓj＃＞\r．",
	}, { // 1584
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t␎κγ7［\u007fＺx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\tψ",
		out:  "．\t␎κγ7［␡Ｚx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\tψ",
	}, { // 1585
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t␎κγ7［\u007fＺx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\tψ",
		out:  "‛．\t␎κγ7［␡Ｚx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\tψ",
	}, { // 1586
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n␎κγ7［\u007fＺx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\nψ",
		out:  "．\n␎κγ7［␡Ｚx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\nψ",
	}, { // 1587
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n␎κγ7［\u007fＺx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\nψ",
		out:  "‛．\n␎κγ7［␡Ｚx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\nψ",
	}, { // 1588
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v␎κγ7［\u007fＺx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\vψ",
		out:  "．\v␎κγ7［␡Ｚx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\vψ",
	}, { // 1589
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v␎κγ7［\u007fＺx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\vψ",
		out:  "‛．\v␎κγ7［␡Ｚx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\vψ",
	}, { // 1590
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r␎κγ7［\u007fＺx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\rψ",
		out:  "．\r␎κγ7［␡Ｚx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\rψ",
	}, { // 1591
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r␎κγ7［\u007fＺx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\rψ",
		out:  "‛．\r␎κγ7［␡Ｚx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\rψ",
	}, { // 1592
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\r\t␎κγ7［\u007fＺx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\t.",
		out:  "\r\t␎κγ7［␡Ｚx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\t.",
	}, { // 1593
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\r\t␎κγ7［\u007fＺx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\t．",
		out:  "\r\t␎κγ7［␡Ｚx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\t．",
	}, { // 1594
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\r\n␎κγ7［\u007fＺx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\n.",
		out:  "\r\n␎κγ7［␡Ｚx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\n.",
	}, { // 1595
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\r\n␎κγ7［\u007fＺx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\n．",
		out:  "\r\n␎κγ7［␡Ｚx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\n．",
	}, { // 1596
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\r\v␎κγ7［\u007fＺx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\v.",
		out:  "\r\v␎κγ7［␡Ｚx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\v.",
	}, { // 1597
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\r\v␎κγ7［\u007fＺx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\v．",
		out:  "\r\v␎κγ7［␡Ｚx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\v．",
	}, { // 1598
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\r\r␎κγ7［\u007fＺx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\r.",
		out:  "\r\r␎κγ7［␡Ｚx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\r.",
	}, { // 1599
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\r\r␎κγ7［\u007fＺx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\r．",
		out:  "\r\r␎κγ7［␡Ｚx\x1b＞－\b\x14νＣ␝lＣ＂κ％]␊,_Ｚ\r．",
	}, { // 1600
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ j␇A\x19zλ]\t８␍θ␐\bβ：＋ｆε＊kξ;ρ\x10Ｒ： \x02",
		out:  "～ j␇A\x19zλ]\t８␍θ␐\bβ：＋ｆε＊kξ;ρ\x10Ｒ： \x02",
	}, { // 1601
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ j␇A\x19zλ]\t８␍θ␐\bβ：＋ｆε＊kξ;ρ\x10Ｒ： \x02",
		out:  "‛～ j␇A\x19zλ]\t８␍θ␐\bβ：＋ｆε＊kξ;ρ\x10Ｒ： \x02",
	}, { // 1602
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftSpace,
		in:   "G j␇A\x19zλ]\t８␍θ␐\bβ：＋ｆε＊kξ;ρ\x10Ｒ： ~",
		out:  "G j␇A\x19zλ]\t８␍θ␐\bβ：＋ｆε＊kξ;ρ\x10Ｒ： ~",
	}, { // 1603
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftSpace,
		in:   "G j␇A\x19zλ]\t８␍θ␐\bβ：＋ｆε＊kξ;ρ\x10Ｒ： ～",
		out:  "G j␇A\x19zλ]\t８␍θ␐\bβ：＋ｆε＊kξ;ρ\x10Ｒ： ～",
	}, { // 1604
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ ␌H＞υλ\t\r␗ＩiＮφ9ξ␍ｊnS\x0e\rＷＺ＠＞ιφ \x1e",
		out:  "～ ␌H＞υλ\t\r␗ＩiＮφ9ξ␍ｊnS\x0e\rＷＺ＠＞ιφ \x1e",
	}, { // 1605
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ ␌H＞υλ\t\r␗ＩiＮφ9ξ␍ｊnS\x0e\rＷＺ＠＞ιφ \x1e",
		out:  "‛～ ␌H＞υλ\t\r␗ＩiＮφ9ξ␍ｊnS\x0e\rＷＺ＠＞ιφ \x1e",
	}, { // 1606
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "␅ ␌H＞υλ\t\r␗ＩiＮφ9ξ␍ｊnS\x0e\rＷＺ＠＞ιφ ~",
		out:  "␅ ␌H＞υλ\t\r␗ＩiＮφ9ξ␍ｊnS\x0e\rＷＺ＠＞ιφ ~",
	}, { // 1607
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "␅ ␌H＞υλ\t\r␗ＩiＮφ9ξ␍ｊnS\x0e\rＷＺ＠＞ιφ ～",
		out:  "␅ ␌H＞υλ\t\r␗ＩiＮφ9ξ␍ｊnS\x0e\rＷＺ＠＞ιφ ～",
	}, { // 1608
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ \tλｊＩξ\x1b_␓５*6σ|␏␝／\x11Ｑ9η＇+\v\x02ο␁ １",
		out:  "～ \tλｊＩξ\x1b_␓５*6σ|␏␝／\x11Ｑ9η‛＇+\v\x02ο␁ １",
	}, { // 1609
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ \tλｊＩξ\x1b_␓５*6σ|␏␝／\x11Ｑ9η＇+\v\x02ο␁ １",
		out:  "‛～ \tλｊＩξ\x1b_␓５*6σ|␏␝／\x11Ｑ9η‛＇+\v\x02ο␁ １",
	}, { // 1610
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "( \tλｊＩξ\x1b_␓５*6σ|␏␝／\x11Ｑ9η＇+\v\x02ο␁ ~",
		out:  "( \tλｊＩξ\x1b_␓５*6σ|␏␝／\x11Ｑ9η‛＇+\v\x02ο␁ ~",
	}, { // 1611
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "( \tλｊＩξ\x1b_␓５*6σ|␏␝／\x11Ｑ9η＇+\v\x02ο␁ ～",
		out:  "( \tλｊＩξ\x1b_␓５*6σ|␏␝／\x11Ｑ9η‛＇+\v\x02ο␁ ～",
	}, { // 1612
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ ␀ｙα3#Ｓτ␈y␏ωC\n.\"\x02\x04γ0␟Ｏ␘␃７０| υ",
		out:  "～ ‛␀ｙα3#Ｓτ␈y␏ωC\n.\"\x02\x04γ0␟Ｏ␘␃７０| υ",
	}, { // 1613
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ ␀ｙα3#Ｓτ␈y␏ωC\n.\"\x02\x04γ0␟Ｏ␘␃７０| υ",
		out:  "‛～ ‛␀ｙα3#Ｓτ␈y␏ωC\n.\"\x02\x04γ0␟Ｏ␘␃７０| υ",
	}, { // 1614
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "ｒ ␀ｙα3#Ｓτ␈y␏ωC\n.\"\x02\x04γ0␟Ｏ␘␃７０| ~",
		out:  "ｒ ‛␀ｙα3#Ｓτ␈y␏ωC\n.\"\x02\x04γ0␟Ｏ␘␃７０| ~",
	}, { // 1615
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "ｒ ␀ｙα3#Ｓτ␈y␏ωC\n.\"\x02\x04γ0␟Ｏ␘␃７０| ～",
		out:  "ｒ ‛␀ｙα3#Ｓτ␈y␏ωC\n.\"\x02\x04γ0␟Ｏ␘␃７０| ～",
	}, { // 1616
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ \x0f4␊＜δ｜οCＰ\a＼␇␃\aρ\x16'π：， Ｍ/)７η \x0f",
		out:  "～ \x0f4␊‛＜δ｜οCＰ\a＼␇␃\aρ\x16'π：， Ｍ/)７η \x0f",
	}, { // 1617
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ \x0f4␊＜δ｜οCＰ\a＼␇␃\aρ\x16'π：， Ｍ/)７η \x0f",
		out:  "‛～ \x0f4␊‛＜δ｜οCＰ\a＼␇␃\aρ\x16'π：， Ｍ/)７η \x0f",
	}, { // 1618
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftSpace,
		in:   "π \x0f4␊＜δ｜οCＰ\a＼␇␃\aρ\x16'π：， Ｍ/)７η ~",
		out:  "π \x0f4␊‛＜δ｜οCＰ\a＼␇␃\aρ\x16'π：， Ｍ/)７η ~",
	}, { // 1619
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftSpace,
		in:   "π \x0f4␊＜δ｜οCＰ\a＼␇␃\aρ\x16'π：， Ｍ/)７η ～",
		out:  "π \x0f4␊‛＜δ｜οCＰ\a＼␇␃\aρ\x16'π：， Ｍ/)７η ～",
	}, { // 1620
		mask: EncodeSquareBracket | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ ＼7\x1eκα:Ｕj|␗#\n␋τ|＂υ＠Q#η（＊?ｃＡ ［",
		out:  "～ ＼7\x1eκα:Ｕj|␗#\n␋τ|＂υ＠Q#η（＊?ｃＡ ‛［",
	}, { // 1621
		mask: EncodeSquareBracket | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ ＼7\x1eκα:Ｕj|␗#\n␋τ|＂υ＠Q#η（＊?ｃＡ ［",
		out:  "‛～ ＼7\x1eκα:Ｕj|␗#\n␋τ|＂υ＠Q#η（＊?ｃＡ ‛［",
	}, { // 1622
		mask: EncodeSquareBracket | EncodeLeftTilde | EncodeLeftSpace,
		in:   "␞ ＼7\x1eκα:Ｕj|␗#\n␋τ|＂υ＠Q#η（＊?ｃＡ ~",
		out:  "␞ ＼7\x1eκα:Ｕj|␗#\n␋τ|＂υ＠Q#η（＊?ｃＡ ~",
	}, { // 1623
		mask: EncodeSquareBracket | EncodeLeftTilde | EncodeLeftSpace,
		in:   "␞ ＼7\x1eκα:Ｕj|␗#\n␋τ|＂υ＠Q#η（＊?ｃＡ ～",
		out:  "␞ ＼7\x1eκα:Ｕj|␗#\n␋τ|＂υ＠Q#η（＊?ｃＡ ～",
	}, { // 1624
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ ␒υ*ｏ＞6Ｂ␇Ｆ\x0e\x06,|β␔Aμ{␅λ＂θ\x14Ｘ'\x02 ␍",
		out:  "～ ␒υ*ｏ＞6Ｂ␇Ｆ\x0e\x06,|β␔Aμ{␅λ＂θ\x14Ｘ'\x02 ␍",
	}, { // 1625
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ ␒υ*ｏ＞6Ｂ␇Ｆ\x0e\x06,|β␔Aμ{␅λ＂θ\x14Ｘ'\x02 ␍",
		out:  "‛～ ␒υ*ｏ＞6Ｂ␇Ｆ\x0e\x06,|β␔Aμ{␅λ＂θ\x14Ｘ'\x02 ␍",
	}, { // 1626
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftSpace,
		in:   "0 ␒υ*ｏ＞6Ｂ␇Ｆ\x0e\x06,|β␔Aμ{␅λ＂θ\x14Ｘ'\x02 ~",
		out:  "0 ␒υ*ｏ＞6Ｂ␇Ｆ\x0e\x06,|β␔Aμ{␅λ＂θ\x14Ｘ'\x02 ~",
	}, { // 1627
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftSpace,
		in:   "0 ␒υ*ｏ＞6Ｂ␇Ｆ\x0e\x06,|β␔Aμ{␅λ＂θ\x14Ｘ'\x02 ～",
		out:  "0 ␒υ*ｏ＞6Ｂ␇Ｆ\x0e\x06,|β␔Aμ{␅λ＂θ\x14Ｘ'\x02 ～",
	}, { // 1628
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ ｋ{％１ｃ\x11：\x10␉ξ/ςγ＠zς｀,␒>p␟m=\x1c\a ＂",
		out:  "～ ｋ{％１ｃ\x11：\x10␉ξ/ςγ＠zς｀,␒>p␟m=\x1c\a ‛＂",
	}, { // 1629
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ ｋ{％１ｃ\x11：\x10␉ξ/ςγ＠zς｀,␒>p␟m=\x1c\a ＂",
		out:  "‛～ ｋ{％１ｃ\x11：\x10␉ξ/ςγ＠zς｀,␒>p␟m=\x1c\a ‛＂",
	}, { // 1630
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "ζ ｋ{％１ｃ\x11：\x10␉ξ/ςγ＠zς｀,␒>p␟m=\x1c\a ~",
		out:  "ζ ｋ{％１ｃ\x11：\x10␉ξ/ςγ＠zς｀,␒>p␟m=\x1c\a ~",
	}, { // 1631
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "ζ ｋ{％１ｃ\x11：\x10␉ξ/ςγ＠zς｀,␒>p␟m=\x1c\a ～",
		out:  "ζ ｋ{％１ｃ\x11：\x10␉ξ/ςγ＠zς｀,␒>p␟m=\x1c\a ～",
	}, { // 1632
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ f＞\t｜ｖ％｀υａ；Vπγｕ >\x02ν\t>AＪ␋？χ` :",
		out:  "～ f＞\t｜ｖ％｀υａ；Vπγｕ >\x02ν\t>AＪ␋？χ` ：",
	}, { // 1633
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ f＞\t｜ｖ％｀υａ；Vπγｕ >\x02ν\t>AＪ␋？χ` :",
		out:  "‛～ f＞\t｜ｖ％｀υａ；Vπγｕ >\x02ν\t>AＪ␋？χ` ：",
	}, { // 1634
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftSpace,
		in:   "μ f＞\t｜ｖ％｀υａ；Vπγｕ >\x02ν\t>AＪ␋？χ` ~",
		out:  "μ f＞\t｜ｖ％｀υａ；Vπγｕ >\x02ν\t>AＪ␋？χ` ~",
	}, { // 1635
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftSpace,
		in:   "μ f＞\t｜ｖ％｀υａ；Vπγｕ >\x02ν\t>AＪ␋？χ` ～",
		out:  "μ f＞\t｜ｖ％｀υａ；Vπγｕ >\x02ν\t>AＪ␋？χ` ～",
	}, { // 1636
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ q\x14θ␗␁\x1cν／ιｃθｅ␋λ␛/`ａ\f\x0f\x10＄␏\x03%θ \"",
		out:  "～ q\x14θ␗␁\x1cν／ιｃθｅ␋λ␛/`ａ\f\x0f\x10＄␏\x03%θ \"",
	}, { // 1637
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ q\x14θ␗␁\x1cν／ιｃθｅ␋λ␛/`ａ\f\x0f\x10＄␏\x03%θ \"",
		out:  "‛～ q\x14θ␗␁\x1cν／ιｃθｅ␋λ␛/`ａ\f\x0f\x10＄␏\x03%θ \"",
	}, { // 1638
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftSpace,
		in:   "i q\x14θ␗␁\x1cν／ιｃθｅ␋λ␛/`ａ\f\x0f\x10＄␏\x03%θ ~",
		out:  "i q\x14θ␗␁\x1cν／ιｃθｅ␋λ␛/`ａ\f\x0f\x10＄␏\x03%θ ~",
	}, { // 1639
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftSpace,
		in:   "i q\x14θ␗␁\x1cν／ιｃθｅ␋λ␛/`ａ\f\x0f\x10＄␏\x03%θ ～",
		out:  "i q\x14θ␗␁\x1cν／ιｃθｅ␋λ␛/`ａ\f\x0f\x10＄␏\x03%θ ～",
	}, { // 1640
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ \x1e.AＢ＃␅/θη\x13：}Ｊ\nο[｛＜\x1d␈Y］<ｊ＼ω Ｒ",
		out:  "～ \x1e.AＢ＃␅/θη\x13：}Ｊ\nο[｛＜\x1d␈Y］<ｊ＼ω Ｒ",
	}, { // 1641
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ \x1e.AＢ＃␅/θη\x13：}Ｊ\nο[｛＜\x1d␈Y］<ｊ＼ω Ｒ",
		out:  "‛～ \x1e.AＢ＃␅/θη\x13：}Ｊ\nο[｛＜\x1d␈Y］<ｊ＼ω Ｒ",
	}, { // 1642
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftSpace,
		in:   "ζ \x1e.AＢ＃␅/θη\x13：}Ｊ\nο[｛＜\x1d␈Y］<ｊ＼ω ~",
		out:  "ζ \x1e.AＢ＃␅/θη\x13：}Ｊ\nο[｛＜\x1d␈Y］<ｊ＼ω ~",
	}, { // 1643
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftSpace,
		in:   "ζ \x1e.AＢ＃␅/θη\x13：}Ｊ\nο[｛＜\x1d␈Y］<ｊ＼ω ～",
		out:  "ζ \x1e.AＢ＃␅/θη\x13：}Ｊ\nο[｛＜\x1d␈Y］<ｊ＼ω ～",
	}, { // 1644
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ <eα\x15κ\x05α␖？␖ｇ\x16␗ｃ␜（\x1cC␂２.␈ω\bＮz χ",
		out:  "～ <eα\x15κ\x05α␖？␖ｇ\x16␗ｃ␜（\x1cC␂２.␈ω\bＮz χ",
	}, { // 1645
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ <eα\x15κ\x05α␖？␖ｇ\x16␗ｃ␜（\x1cC␂２.␈ω\bＮz χ",
		out:  "‛～ <eα\x15κ\x05α␖？␖ｇ\x16␗ｃ␜（\x1cC␂２.␈ω\bＮz χ",
	}, { // 1646
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftSpace,
		in:   "j <eα\x15κ\x05α␖？␖ｇ\x16␗ｃ␜（\x1cC␂２.␈ω\bＮz ~",
		out:  "j <eα\x15κ\x05α␖？␖ｇ\x16␗ｃ␜（\x1cC␂２.␈ω\bＮz ~",
	}, { // 1647
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftSpace,
		in:   "j <eα\x15κ\x05α␖？␖ｇ\x16␗ｃ␜（\x1cC␂２.␈ω\bＮz ～",
		out:  "j <eα\x15κ\x05α␖？␖ｇ\x16␗ｃ␜（\x1cC␂２.␈ω\bＮz ～",
	}, { // 1648
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ t\fτ,␡ρ␐\x18/ｊ\x1f␟εｌ*`ｓγ␐ｏ␚／6？＼/ ο",
		out:  "～ t\fτ,␡ρ␐\x18/ｊ\x1f␟εｌ*`ｓγ␐ｏ␚／6？＼/ ο",
	}, { // 1649
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ t\fτ,␡ρ␐\x18/ｊ\x1f␟εｌ*`ｓγ␐ｏ␚／6？＼/ ο",
		out:  "‛～ t\fτ,␡ρ␐\x18/ｊ\x1f␟εｌ*`ｓγ␐ｏ␚／6？＼/ ο",
	}, { // 1650
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "[ t\fτ,␡ρ␐\x18/ｊ\x1f␟εｌ*`ｓγ␐ｏ␚／6？＼/ ~",
		out:  "[ t\fτ,␡ρ␐\x18/ｊ\x1f␟εｌ*`ｓγ␐ｏ␚／6？＼/ ~",
	}, { // 1651
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "[ t\fτ,␡ρ␐\x18/ｊ\x1f␟εｌ*`ｓγ␐ｏ␚／6？＼/ ～",
		out:  "[ t\fτ,␡ρ␐\x18/ｊ\x1f␟εｌ*`ｓγ␐ｏ␚／6？＼/ ～",
	}, { // 1652
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ ␛ζ０S:)*!\rf／]＝␀[υ␍`：，Ｋa~｀ｚ／ ν",
		out:  "～ ␛ζ０S:)*!\rf／]＝‛␀[υ␍`：，Ｋa~｀ｚ／ ν",
	}, { // 1653
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ ␛ζ０S:)*!\rf／]＝␀[υ␍`：，Ｋa~｀ｚ／ ν",
		out:  "‛～ ␛ζ０S:)*!\rf／]＝‛␀[υ␍`：，Ｋa~｀ｚ／ ν",
	}, { // 1654
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftSpace,
		in:   "λ ␛ζ０S:)*!\rf／]＝␀[υ␍`：，Ｋa~｀ｚ／ ~",
		out:  "λ ␛ζ０S:)*!\rf／]＝‛␀[υ␍`：，Ｋa~｀ｚ／ ~",
	}, { // 1655
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftSpace,
		in:   "λ ␛ζ０S:)*!\rf／]＝␀[υ␍`：，Ｋa~｀ｚ／ ～",
		out:  "λ ␛ζ０S:)*!\rf／]＝‛␀[υ␍`：，Ｋa~｀ｚ／ ～",
	}, { // 1656
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ h␉ρZ%ος\\␁ｗγθ\bH␓：␞[Ａｚ，\nγ＇[X \x0f",
		out:  "～ h␉ρZ%ος＼␁ｗγθ\bH␓：␞[Ａｚ，\nγ＇[X \x0f",
	}, { // 1657
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ h␉ρZ%ος\\␁ｗγθ\bH␓：␞[Ａｚ，\nγ＇[X \x0f",
		out:  "‛～ h␉ρZ%ος＼␁ｗγθ\bH␓：␞[Ａｚ，\nγ＇[X \x0f",
	}, { // 1658
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "␎ h␉ρZ%ος\\␁ｗγθ\bH␓：␞[Ａｚ，\nγ＇[X ~",
		out:  "␎ h␉ρZ%ος＼␁ｗγθ\bH␓：␞[Ａｚ，\nγ＇[X ~",
	}, { // 1659
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "␎ h␉ρZ%ος\\␁ｗγθ\bH␓：␞[Ａｚ，\nγ＇[X ～",
		out:  "␎ h␉ρZ%ος＼␁ｗγθ\bH␓：␞[Ａｚ，\nγ＇[X ～",
	}, { // 1660
		mask: EncodeCrLf | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ ␌4\x19c<\x12ρuςδ␅Ｎ\x01π＼␅χｍ：Ｋ%Tμw\\␚ 2",
		out:  "～ ␌4\x19c<\x12ρuςδ␅Ｎ\x01π＼␅χｍ：Ｋ%Tμw\\␚ 2",
	}, { // 1661
		mask: EncodeCrLf | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ ␌4\x19c<\x12ρuςδ␅Ｎ\x01π＼␅χｍ：Ｋ%Tμw\\␚ 2",
		out:  "‛～ ␌4\x19c<\x12ρuςδ␅Ｎ\x01π＼␅χｍ：Ｋ%Tμw\\␚ 2",
	}, { // 1662
		mask: EncodeCrLf | EncodeLeftTilde | EncodeLeftSpace,
		in:   "Ｗ ␌4\x19c<\x12ρuςδ␅Ｎ\x01π＼␅χｍ：Ｋ%Tμw\\␚ ~",
		out:  "Ｗ ␌4\x19c<\x12ρuςδ␅Ｎ\x01π＼␅χｍ：Ｋ%Tμw\\␚ ~",
	}, { // 1663
		mask: EncodeCrLf | EncodeLeftTilde | EncodeLeftSpace,
		in:   "Ｗ ␌4\x19c<\x12ρuςδ␅Ｎ\x01π＼␅χｍ：Ｋ%Tμw\\␚ ～",
		out:  "Ｗ ␌4\x19c<\x12ρuςδ␅Ｎ\x01π＼␅χｍ：Ｋ%Tμw\\␚ ～",
	}, { // 1664
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ θz!ＢＳ\x1a\v␍μq！{␑κ`\x11␁＄＇␝pｒ1ξςｍ \x06",
		out:  "～ θz!ＢＳ\x1a\v␍μq！{␑κ`\x11␁＄＇␝pｒ1ξςｍ \x06",
	}, { // 1665
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ θz!ＢＳ\x1a\v␍μq！{␑κ`\x11␁＄＇␝pｒ1ξςｍ \x06",
		out:  "‛～ θz!ＢＳ\x1a\v␍μq！{␑κ`\x11␁＄＇␝pｒ1ξςｍ \x06",
	}, { // 1666
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftSpace,
		in:   "σ θz!ＢＳ\x1a\v␍μq！{␑κ`\x11␁＄＇␝pｒ1ξςｍ ~",
		out:  "σ θz!ＢＳ\x1a\v␍μq！{␑κ`\x11␁＄＇␝pｒ1ξςｍ ~",
	}, { // 1667
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftSpace,
		in:   "σ θz!ＢＳ\x1a\v␍μq！{␑κ`\x11␁＄＇␝pｒ1ξςｍ ～",
		out:  "σ θz!ＢＳ\x1a\v␍μq！{␑κ`\x11␁＄＇␝pｒ1ξςｍ ～",
	}, { // 1668
		mask: EncodeCtl | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ ςｆνδ␙φ[Ｓ\x15zY\nς＼lＫ\\1S␔\v\x1b␗?ＡＣ ␐",
		out:  "～ ςｆνδ‛␙φ[Ｓ␕zY␊ς＼lＫ\\1S‛␔␋␛‛␗?ＡＣ ‛␐",
	}, { // 1669
		mask: EncodeCtl | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ ςｆνδ␙φ[Ｓ\x15zY\nς＼lＫ\\1S␔\v\x1b␗?ＡＣ ␐",
		out:  "‛～ ςｆνδ‛␙φ[Ｓ␕zY␊ς＼lＫ\\1S‛␔␋␛‛␗?ＡＣ ‛␐",
	}, { // 1670
		mask: EncodeCtl | EncodeLeftTilde | EncodeLeftSpace,
		in:   "Ｃ ςｆνδ␙φ[Ｓ\x15zY\nς＼lＫ\\1S␔\v\x1b␗?ＡＣ ~",
		out:  "Ｃ ςｆνδ‛␙φ[Ｓ␕zY␊ς＼lＫ\\1S‛␔␋␛‛␗?ＡＣ ~",
	}, { // 1671
		mask: EncodeCtl | EncodeLeftTilde | EncodeLeftSpace,
		in:   "Ｃ ςｆνδ␙φ[Ｓ\x15zY\nς＼lＫ\\1S␔\v\x1b␗?ＡＣ ～",
		out:  "Ｃ ςｆνδ‛␙φ[Ｓ␕zY␊ς＼lＫ\\1S‛␔␋␛‛␗?ＡＣ ～",
	}, { // 1672
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.␁＾␕ζ␕}R\x11o␚＼εＦν\x00τ３␙'\x06G＞［.αS.Ｂ",
		out:  "～.␁＾␕ζ␕}R\x11o␚＼εＦν␀τ３␙'\x06G＞［.αS.Ｂ",
	}, { // 1673
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.␁＾␕ζ␕}R\x11o␚＼εＦν\x00τ３␙'\x06G＞［.αS.Ｂ",
		out:  "‛～.␁＾␕ζ␕}R\x11o␚＼εＦν␀τ３␙'\x06G＞［.αS.Ｂ",
	}, { // 1674
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "`.␁＾␕ζ␕}R\x11o␚＼εＦν\x00τ３␙'\x06G＞［.αS.~",
		out:  "`.␁＾␕ζ␕}R\x11o␚＼εＦν␀τ３␙'\x06G＞［.αS.~",
	}, { // 1675
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "`.␁＾␕ζ␕}R\x11o␚＼εＦν\x00τ３␙'\x06G＞［.αS.～",
		out:  "`.␁＾␕ζ␕}R\x11o␚＼εＦν␀τ３␙'\x06G＞［.αS.～",
	}, { // 1676
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.９W\n2Ａν\x04␜４␈a\x18␡σ␟χδＣ\x1bＶ\x00ｌys\x0f␑.χ",
		out:  "～.９W\n2Ａν\x04␜４␈a\x18␡σ␟χδＣ\x1bＶ␀ｌys\x0f␑.χ",
	}, { // 1677
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.９W\n2Ａν\x04␜４␈a\x18␡σ␟χδＣ\x1bＶ\x00ｌys\x0f␑.χ",
		out:  "‛～.９W\n2Ａν\x04␜４␈a\x18␡σ␟χδＣ\x1bＶ␀ｌys\x0f␑.χ",
	}, { // 1678
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "␍.９W\n2Ａν\x04␜４␈a\x18␡σ␟χδＣ\x1bＶ\x00ｌys\x0f␑.~",
		out:  "␍.９W\n2Ａν\x04␜４␈a\x18␡σ␟χδＣ\x1bＶ␀ｌys\x0f␑.~",
	}, { // 1679
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "␍.９W\n2Ａν\x04␜４␈a\x18␡σ␟χδＣ\x1bＶ\x00ｌys\x0f␑.～",
		out:  "␍.９W\n2Ａν\x04␜４␈a\x18␡σ␟χδＣ\x1bＶ␀ｌys\x0f␑.～",
	}, { // 1680
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.\x13\x02ｇε␈␚\tχ4ｒ\x01Ｘ`k\x14z＇\x17τＸ␗ςQ／'ο.μ",
		out:  "～.\x13\x02ｇε␈␚\tχ4ｒ\x01Ｘ`k\x14z‛＇\x17τＸ␗ςQ／＇ο.μ",
	}, { // 1681
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.\x13\x02ｇε␈␚\tχ4ｒ\x01Ｘ`k\x14z＇\x17τＸ␗ςQ／'ο.μ",
		out:  "‛～.\x13\x02ｇε␈␚\tχ4ｒ\x01Ｘ`k\x14z‛＇\x17τＸ␗ςQ／＇ο.μ",
	}, { // 1682
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "␔.\x13\x02ｇε␈␚\tχ4ｒ\x01Ｘ`k\x14z＇\x17τＸ␗ςQ／'ο.~",
		out:  "␔.\x13\x02ｇε␈␚\tχ4ｒ\x01Ｘ`k\x14z‛＇\x17τＸ␗ςQ／＇ο.~",
	}, { // 1683
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "␔.\x13\x02ｇε␈␚\tχ4ｒ\x01Ｘ`k\x14z＇\x17τＸ␗ςQ／'ο.～",
		out:  "␔.\x13\x02ｇε␈␚\tχ4ｒ\x01Ｘ`k\x14z‛＇\x17τＸ␗ςQ／＇ο.～",
	}, { // 1684
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.Ｐ／\x06x&$␛＜\"＊\x04\t4 6ω␐π\x0eυ␋E＆γ／ν.κ",
		out:  "～.Ｐ／\x06x&$␛＜\"＊\x04\t4 6ω␐π\x0eυ␋E＆γ／ν.κ",
	}, { // 1685
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.Ｐ／\x06x&$␛＜\"＊\x04\t4 6ω␐π\x0eυ␋E＆γ／ν.κ",
		out:  "‛～.Ｐ／\x06x&$␛＜\"＊\x04\t4 6ω␐π\x0eυ␋E＆γ／ν.κ",
	}, { // 1686
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "␊.Ｐ／\x06x&$␛＜\"＊\x04\t4 6ω␐π\x0eυ␋E＆γ／ν.~",
		out:  "␊.Ｐ／\x06x&$␛＜\"＊\x04\t4 6ω␐π\x0eυ␋E＆γ／ν.~",
	}, { // 1687
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "␊.Ｐ／\x06x&$␛＜\"＊\x04\t4 6ω␐π\x0eυ␋E＆γ／ν.～",
		out:  "␊.Ｐ／\x06x&$␛＜\"＊\x04\t4 6ω␐π\x0eυ␋E＆γ／ν.～",
	}, { // 1688
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.ξμ␐\a\x14ａ␏ρ＆?Ｈｋxν<=＊＠γ␎5C␙\x0eκ␕.ｂ",
		out:  "～.ξμ␐\a\x14ａ␏ρ＆?Ｈｋxν＜=＊＠γ␎5C␙\x0eκ␕.ｂ",
	}, { // 1689
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.ξμ␐\a\x14ａ␏ρ＆?Ｈｋxν<=＊＠γ␎5C␙\x0eκ␕.ｂ",
		out:  "‛～.ξμ␐\a\x14ａ␏ρ＆?Ｈｋxν＜=＊＠γ␎5C␙\x0eκ␕.ｂ",
	}, { // 1690
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "\x04.ξμ␐\a\x14ａ␏ρ＆?Ｈｋxν<=＊＠γ␎5C␙\x0eκ␕.~",
		out:  "\x04.ξμ␐\a\x14ａ␏ρ＆?Ｈｋxν＜=＊＠γ␎5C␙\x0eκ␕.~",
	}, { // 1691
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "\x04.ξμ␐\a\x14ａ␏ρ＆?Ｈｋxν<=＊＠γ␎5C␙\x0eκ␕.～",
		out:  "\x04.ξμ␐\a\x14ａ␏ρ＆?Ｈｋxν＜=＊＠γ␎5C␙\x0eκ␕.～",
	}, { // 1692
		mask: EncodeSquareBracket | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.＃\x1f`；＜υξTβｘ＃S\x03␓４＂/ψ＜uκ␇Gω␎\x1a.?",
		out:  "～.＃\x1f`；＜υξTβｘ＃S\x03␓４＂/ψ＜uκ␇Gω␎\x1a.?",
	}, { // 1693
		mask: EncodeSquareBracket | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.＃\x1f`；＜υξTβｘ＃S\x03␓４＂/ψ＜uκ␇Gω␎\x1a.?",
		out:  "‛～.＃\x1f`；＜υξTβｘ＃S\x03␓４＂/ψ＜uκ␇Gω␎\x1a.?",
	}, { // 1694
		mask: EncodeSquareBracket | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "＞.＃\x1f`；＜υξTβｘ＃S\x03␓４＂/ψ＜uκ␇Gω␎\x1a.~",
		out:  "＞.＃\x1f`；＜υξTβｘ＃S\x03␓４＂/ψ＜uκ␇Gω␎\x1a.~",
	}, { // 1695
		mask: EncodeSquareBracket | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "＞.＃\x1f`；＜υξTβｘ＃S\x03␓４＂/ψ＜uκ␇Gω␎\x1a.～",
		out:  "＞.＃\x1f`；＜υξTβｘ＃S\x03␓４＂/ψ＜uκ␇Gω␎\x1a.～",
	}, { // 1696
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.η\x02␆cγE/８＇Ｙiρ␒\x14␞Ｓ\x01μ|␕υ␟0ν\v－.ｓ",
		out:  "～.η\x02␆cγE/８＇Ｙiρ␒\x14␞Ｓ\x01μ|␕υ␟0ν\v－.ｓ",
	}, { // 1697
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.η\x02␆cγE/８＇Ｙiρ␒\x14␞Ｓ\x01μ|␕υ␟0ν\v－.ｓ",
		out:  "‛～.η\x02␆cγE/８＇Ｙiρ␒\x14␞Ｓ\x01μ|␕υ␟0ν\v－.ｓ",
	}, { // 1698
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "\x19.η\x02␆cγE/８＇Ｙiρ␒\x14␞Ｓ\x01μ|␕υ␟0ν\v－.~",
		out:  "\x19.η\x02␆cγE/８＇Ｙiρ␒\x14␞Ｓ\x01μ|␕υ␟0ν\v－.~",
	}, { // 1699
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "\x19.η\x02␆cγE/８＇Ｙiρ␒\x14␞Ｓ\x01μ|␕υ␟0ν\v－.～",
		out:  "\x19.η\x02␆cγE/８＇Ｙiρ␒\x14␞Ｓ\x01μ|␕υ␟0ν\v－.～",
	}, { // 1700
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.ξ％$τｏ[ν\x0e\x1b*Ｘ＂η＃|␑ＴγO␑χ#＂#*␕.4",
		out:  "～.ξ％$τｏ[ν\x0e\x1b*Ｘ‛＂η＃|␑ＴγO␑χ#‛＂#*␕.4",
	}, { // 1701
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.ξ％$τｏ[ν\x0e\x1b*Ｘ＂η＃|␑ＴγO␑χ#＂#*␕.4",
		out:  "‛～.ξ％$τｏ[ν\x0e\x1b*Ｘ‛＂η＃|␑ＴγO␑χ#‛＂#*␕.4",
	}, { // 1702
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "ｅ.ξ％$τｏ[ν\x0e\x1b*Ｘ＂η＃|␑ＴγO␑χ#＂#*␕.~",
		out:  "ｅ.ξ％$τｏ[ν\x0e\x1b*Ｘ‛＂η＃|␑ＴγO␑χ#‛＂#*␕.~",
	}, { // 1703
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "ｅ.ξ％$τｏ[ν\x0e\x1b*Ｘ＂η＃|␑ＴγO␑χ#＂#*␕.～",
		out:  "ｅ.ξ％$τｏ[ν\x0e\x1b*Ｘ‛＂η＃|␑ＴγO␑χ#‛＂#*␕.～",
	}, { // 1704
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.AＰ\nλ>ξＺｏς\x12G\x13␟␅ＢＪ\x03βγ\\）ν␙\x17␇*.␝",
		out:  "～.AＰ\nλ>ξＺｏς\x12G\x13␟␅ＢＪ\x03βγ\\）ν␙\x17␇*.␝",
	}, { // 1705
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.AＰ\nλ>ξＺｏς\x12G\x13␟␅ＢＪ\x03βγ\\）ν␙\x17␇*.␝",
		out:  "‛～.AＰ\nλ>ξＺｏς\x12G\x13␟␅ＢＪ\x03βγ\\）ν␙\x17␇*.␝",
	}, { // 1706
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "|.AＰ\nλ>ξＺｏς\x12G\x13␟␅ＢＪ\x03βγ\\）ν␙\x17␇*.~",
		out:  "|.AＰ\nλ>ξＺｏς\x12G\x13␟␅ＢＪ\x03βγ\\）ν␙\x17␇*.~",
	}, { // 1707
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "|.AＰ\nλ>ξＺｏς\x12G\x13␟␅ＢＪ\x03βγ\\）ν␙\x17␇*.～",
		out:  "|.AＰ\nλ>ξＺｏς\x12G\x13␟␅ＢＪ\x03βγ\\）ν␙\x17␇*.～",
	}, { // 1708
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.\x06]＃␏i：␇H＞␇λψφ*|␓Ｖd!＼\x17χ␡ｍｒ|.ε",
		out:  "～.\x06]＃␏i：␇H＞␇λψφ*|␓Ｖd!＼\x17χ␡ｍｒ|.ε",
	}, { // 1709
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.\x06]＃␏i：␇H＞␇λψφ*|␓Ｖd!＼\x17χ␡ｍｒ|.ε",
		out:  "‛～.\x06]＃␏i：␇H＞␇λψφ*|␓Ｖd!＼\x17χ␡ｍｒ|.ε",
	}, { // 1710
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "\x01.\x06]＃␏i：␇H＞␇λψφ*|␓Ｖd!＼\x17χ␡ｍｒ|.~",
		out:  "\x01.\x06]＃␏i：␇H＞␇λψφ*|␓Ｖd!＼\x17χ␡ｍｒ|.~",
	}, { // 1711
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "\x01.\x06]＃␏i：␇H＞␇λψφ*|␓Ｖd!＼\x17χ␡ｍｒ|.～",
		out:  "\x01.\x06]＃␏i：␇H＞␇λψφ*|␓Ｖd!＼\x17χ␡ｍｒ|.～",
	}, { // 1712
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.ψ␀μＫＱι>＝\"＇θＡ␒\x0e␛S\u007fR／xn\f\x13\n␄ψ.␑",
		out:  "～.ψ‛␀μＫＱι>＝\"＇θＡ␒\x0e␛S\u007fR／xn\f\x13\n␄ψ.␑",
	}, { // 1713
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.ψ␀μＫＱι>＝\"＇θＡ␒\x0e␛S\u007fR／xn\f\x13\n␄ψ.␑",
		out:  "‛～.ψ‛␀μＫＱι>＝\"＇θＡ␒\x0e␛S\u007fR／xn\f\x13\n␄ψ.␑",
	}, { // 1714
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "Ｖ.ψ␀μＫＱι>＝\"＇θＡ␒\x0e␛S\u007fR／xn\f\x13\n␄ψ.~",
		out:  "Ｖ.ψ‛␀μＫＱι>＝\"＇θＡ␒\x0e␛S\u007fR／xn\f\x13\n␄ψ.~",
	}, { // 1715
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "Ｖ.ψ␀μＫＱι>＝\"＇θＡ␒\x0e␛S\u007fR／xn\f\x13\n␄ψ.～",
		out:  "Ｖ.ψ‛␀μＫＱι>＝\"＇θＡ␒\x0e␛S\u007fR／xn\f\x13\n␄ψ.～",
	}, { // 1716
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.␅Ｏ４0S␋B＇ωκ␆ｋ０\x17κ␌ζ\r\u007f\v␓＊λ␈l\n./",
		out:  "～.␅Ｏ４0S␋B＇ωκ␆ｋ０\x17κ␌ζ\r\u007f\v␓＊λ␈l\n./",
	}, { // 1717
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.␅Ｏ４0S␋B＇ωκ␆ｋ０\x17κ␌ζ\r\u007f\v␓＊λ␈l\n./",
		out:  "‛～.␅Ｏ４0S␋B＇ωκ␆ｋ０\x17κ␌ζ\r\u007f\v␓＊λ␈l\n./",
	}, { // 1718
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "3.␅Ｏ４0S␋B＇ωκ␆ｋ０\x17κ␌ζ\r\u007f\v␓＊λ␈l\n.~",
		out:  "3.␅Ｏ４0S␋B＇ωκ␆ｋ０\x17κ␌ζ\r\u007f\v␓＊λ␈l\n.~",
	}, { // 1719
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "3.␅Ｏ４0S␋B＇ωκ␆ｋ０\x17κ␌ζ\r\u007f\v␓＊λ␈l\n.～",
		out:  "3.␅Ｏ４0S␋B＇ωκ␆ｋ０\x17κ␌ζ\r\u007f\v␓＊λ␈l\n.～",
	}, { // 1720
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.\x15ς＊πＳ\x0f\x04＾␖H-＼OFδ：＇Dｅθ＇\x10％\x19ε\x13. ",
		out:  "～.\x15ς＊πＳ\x0f\x04＾␖H-＼OFδ：＇Dｅθ＇\x10％\x19ε\x13. ",
	}, { // 1721
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.\x15ς＊πＳ\x0f\x04＾␖H-＼OFδ：＇Dｅθ＇\x10％\x19ε\x13. ",
		out:  "‛～.\x15ς＊πＳ\x0f\x04＾␖H-＼OFδ：＇Dｅθ＇\x10％\x19ε\x13. ",
	}, { // 1722
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "τ.\x15ς＊πＳ\x0f\x04＾␖H-＼OFδ：＇Dｅθ＇\x10％\x19ε\x13.~",
		out:  "τ.\x15ς＊πＳ\x0f\x04＾␖H-＼OFδ：＇Dｅθ＇\x10％\x19ε\x13.~",
	}, { // 1723
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "τ.\x15ς＊πＳ\x0f\x04＾␖H-＼OFδ：＇Dｅθ＇\x10％\x19ε\x13.～",
		out:  "τ.\x15ς＊πＳ\x0f\x04＾␖H-＼OFδ：＇Dｅθ＇\x10％\x19ε\x13.～",
	}, { // 1724
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.υ]Wσ␃/\x1b|1Ｄ␛␏*␚\u007f)ｇ｛␚τ０ζψZｚβ.＼",
		out:  "～.υ]Wσ␃/\x1b|1Ｄ␛␏*␚\u007f)ｇ｛␚τ０ζψZｚβ.＼",
	}, { // 1725
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.υ]Wσ␃/\x1b|1Ｄ␛␏*␚\u007f)ｇ｛␚τ０ζψZｚβ.＼",
		out:  "‛～.υ]Wσ␃/\x1b|1Ｄ␛␏*␚\u007f)ｇ｛␚τ０ζψZｚβ.＼",
	}, { // 1726
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "?.υ]Wσ␃/\x1b|1Ｄ␛␏*␚\u007f)ｇ｛␚τ０ζψZｚβ.~",
		out:  "?.υ]Wσ␃/\x1b|1Ｄ␛␏*␚\u007f)ｇ｛␚τ０ζψZｚβ.~",
	}, { // 1727
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "?.υ]Wσ␃/\x1b|1Ｄ␛␏*␚\u007f)ｇ｛␚τ０ζψZｚβ.～",
		out:  "?.υ]Wσ␃/\x1b|1Ｄ␛␏*␚\u007f)ｇ｛␚τ０ζψZｚβ.～",
	}, { // 1728
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.is\"_\\＂Ｐ\x18\rＶ␙ζη\x12\uff003ρ/␍␡\nＩ％␡$␒.ς",
		out:  "～.is\"_＼＂Ｐ\x18\rＶ␙ζη\x12\uff003ρ/␍␡\nＩ％␡$␒.ς",
	}, { // 1729
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.is\"_\\＂Ｐ\x18\rＶ␙ζη\x12\uff003ρ/␍␡\nＩ％␡$␒.ς",
		out:  "‛～.is\"_＼＂Ｐ\x18\rＶ␙ζη\x12\uff003ρ/␍␡\nＩ％␡$␒.ς",
	}, { // 1730
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "／.is\"_\\＂Ｐ\x18\rＶ␙ζη\x12\uff003ρ/␍␡\nＩ％␡$␒.~",
		out:  "／.is\"_＼＂Ｐ\x18\rＶ␙ζη\x12\uff003ρ/␍␡\nＩ％␡$␒.~",
	}, { // 1731
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "／.is\"_\\＂Ｐ\x18\rＶ␙ζη\x12\uff003ρ/␍␡\nＩ％␡$␒.～",
		out:  "／.is\"_＼＂Ｐ\x18\rＶ␙ζη\x12\uff003ρ/␍␡\nＩ％␡$␒.～",
	}, { // 1732
		mask: EncodeCrLf | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.θ␊jｋ%$␌N/Ｈ＝ｅη:␎␊␟'θ+jσｉ\\ζｌ.\x14",
		out:  "～.θ‛␊jｋ%$␌N/Ｈ＝ｅη:␎‛␊␟'θ+jσｉ\\ζｌ.\x14",
	}, { // 1733
		mask: EncodeCrLf | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.θ␊jｋ%$␌N/Ｈ＝ｅη:␎␊␟'θ+jσｉ\\ζｌ.\x14",
		out:  "‛～.θ‛␊jｋ%$␌N/Ｈ＝ｅη:␎‛␊␟'θ+jσｉ\\ζｌ.\x14",
	}, { // 1734
		mask: EncodeCrLf | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "\".θ␊jｋ%$␌N/Ｈ＝ｅη:␎␊␟'θ+jσｉ\\ζｌ.~",
		out:  "\".θ‛␊jｋ%$␌N/Ｈ＝ｅη:␎‛␊␟'θ+jσｉ\\ζｌ.~",
	}, { // 1735
		mask: EncodeCrLf | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "\".θ␊jｋ%$␌N/Ｈ＝ｅη:␎␊␟'θ+jσｉ\\ζｌ.～",
		out:  "\".θ‛␊jｋ%$␌N/Ｈ＝ｅη:␎‛␊␟'θ+jσｉ\\ζｌ.～",
	}, { // 1736
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.ｌποη＄＜\x06\x0e－\"φQ\x1a｀<␇＼%␒λς!ｙ\x05\r..)",
		out:  "～.ｌποη＄＜\x06\x0e－\"φQ\x1a｀<␇＼%␒λς!ｙ\x05\r..)",
	}, { // 1737
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.ｌποη＄＜\x06\x0e－\"φQ\x1a｀<␇＼%␒λς!ｙ\x05\r..)",
		out:  "‛～.ｌποη＄＜\x06\x0e－\"φQ\x1a｀<␇＼%␒λς!ｙ\x05\r..)",
	}, { // 1738
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "？.ｌποη＄＜\x06\x0e－\"φQ\x1a｀<␇＼%␒λς!ｙ\x05\r..~",
		out:  "？.ｌποη＄＜\x06\x0e－\"φQ\x1a｀<␇＼%␒λς!ｙ\x05\r..~",
	}, { // 1739
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "？.ｌποη＄＜\x06\x0e－\"φQ\x1a｀<␇＼%␒λς!ｙ\x05\r..～",
		out:  "？.ｌποη＄＜\x06\x0e－\"φQ\x1a｀<␇＼%␒λς!ｙ\x05\r..～",
	}, { // 1740
		mask: EncodeCtl | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.\x01［XhI\x1cＴ＞ο］\x12␁αλ␁#β\x12＾＄F␁，\x04％κ.B",
		out:  "～.␁［XhI␜Ｔ＞ο］␒‛␁αλ‛␁#β␒＾＄F‛␁，␄％κ.B",
	}, { // 1741
		mask: EncodeCtl | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.\x01［XhI\x1cＴ＞ο］\x12␁αλ␁#β\x12＾＄F␁，\x04％κ.B",
		out:  "‛～.␁［XhI␜Ｔ＞ο］␒‛␁αλ‛␁#β␒＾＄F‛␁，␄％κ.B",
	}, { // 1742
		mask: EncodeCtl | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "λ.\x01［XhI\x1cＴ＞ο］\x12␁αλ␁#β\x12＾＄F␁，\x04％κ.~",
		out:  "λ.␁［XhI␜Ｔ＞ο］␒‛␁αλ‛␁#β␒＾＄F‛␁，␄％κ.~",
	}, { // 1743
		mask: EncodeCtl | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "λ.\x01［XhI\x1cＴ＞ο］\x12␁αλ␁#β\x12＾＄F␁，\x04％κ.～",
		out:  "λ.␁［XhI␜Ｔ＞ο］␒‛␁αλ‛␁#β␒＾＄F‛␁，␄％κ.～",
	}, { // 1744
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\tｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\t\x13",
		out:  "～\tｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\t\x13",
	}, { // 1745
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\tｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\t\x13",
		out:  "‛～\tｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\t\x13",
	}, { // 1746
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\nｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\n\x13",
		out:  "～\nｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\n\x13",
	}, { // 1747
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\nｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\n\x13",
		out:  "‛～\nｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\n\x13",
	}, { // 1748
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\vｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\v\x13",
		out:  "～\vｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\v\x13",
	}, { // 1749
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\vｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\v\x13",
		out:  "‛～\vｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\v\x13",
	}, { // 1750
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\rｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\r\x13",
		out:  "～\rｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\r\x13",
	}, { // 1751
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\rｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\r\x13",
		out:  "‛～\rｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\r\x13",
	}, { // 1752
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "J\tｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\t~",
		out:  "J\tｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\t~",
	}, { // 1753
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "J\tｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\t～",
		out:  "J\tｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\t～",
	}, { // 1754
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "J\nｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\n~",
		out:  "J\nｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\n~",
	}, { // 1755
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "J\nｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\n～",
		out:  "J\nｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\n～",
	}, { // 1756
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "J\vｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\v~",
		out:  "J\vｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\v~",
	}, { // 1757
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "J\vｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\v～",
		out:  "J\vｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\v～",
	}, { // 1758
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "J\rｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\r~",
		out:  "J\rｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\r~",
	}, { // 1759
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "J\rｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\r～",
		out:  "J\rｔＮｎηξ␄0␙ςκκ \nＥm／\x06\x1c␊?Ａ'｛cφ␅\r～",
	}, { // 1760
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\t\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\tk",
		out:  "～\t\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\tk",
	}, { // 1761
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\t\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\tk",
		out:  "‛～\t\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\tk",
	}, { // 1762
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\n\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\nk",
		out:  "～\n\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\nk",
	}, { // 1763
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\n\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\nk",
		out:  "‛～\n\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\nk",
	}, { // 1764
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\v\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\vk",
		out:  "～\v\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\vk",
	}, { // 1765
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\v\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\vk",
		out:  "‛～\v\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\vk",
	}, { // 1766
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\r\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\rk",
		out:  "～\r\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\rk",
	}, { // 1767
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\r\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\rk",
		out:  "‛～\r\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\rk",
	}, { // 1768
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "η\t\x1c\tＴ\uff00ρ｜␝Ｃςθ␆<\x10＜_d<υN%＜ｒ\x02C␘［\t~",
		out:  "η\t\x1c\tＴ\uff00ρ｜␝Ｃς