# Libuplink

Go library for Storj V3 Network.

[![Go Report Card](https://goreportcard.com/badge/storj.io/uplink)](https://goreportcard.com/report/storj.io/uplink)
[![Go Doc](https://img.shields.io/badge/godoc-reference-blue.svg?style=flat-square)](https://pkg.go.dev/storj.io/uplink)
![Beta](https://img.shields.io/badge/version-beta-green.svg)

<img src="https://github.com/storj/storj/raw/master/resources/logo.png" width="100">

Storj is building a decentralized cloud storage network.
[Check out our white paper for more info!](https://storj.io/white-paper)

----

Storj is an S3-compatible platform and suite of decentralized applications that
allows you to store data in a secure and decentralized manner. Your files are
encrypted, broken into little pieces and stored in a global decentralized
network of computers. Luckily, we also support allowing you (and only you) to
retrieve those files!

### A Note about Versioning

Our versioning in this repo is intended to primarily support the expectations of the
[Go modules](https://blog.golang.org/using-go-modules) system, so you can expect that
within a major version release, backwards-incompatible changes will be avoided at high
cost. This is not the case with our downstream repo,
[storj/storj](https://github.com/storj/storj/).

# Documentation

- [Go Doc](https://pkg.go.dev/storj.io/uplink)
- [Libuplink Walkthrough](https://github.com/storj/storj/wiki/Libuplink-Walkthrough)

# Language bindings

- [Uplink-C](https://github.com/storj/uplink-c)

# License

This library is distributed under the
[BSD-2-clause license with an explicit patent grant](https://spdx.org/licenses/BSD-2-Clause-Patent.html).

See https://writing.kemitchell.com/2019/11/07/BSD-Patents.html for more details.

# Support

If you have any questions or suggestions please reach out to us on [our community forum](https://forum.storj.io/) or file a support ticket at https://support.tardigrade.io.
