// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: orders.proto

package pb

import (
	context "context"
	fmt "fmt"
	math "math"
	time "time"

	proto "github.com/gogo/protobuf/proto"

	drpc "storj.io/drpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// PieceAction is an enumeration of all possible executed actions on storage node.
type PieceAction int32

const (
	PieceAction_INVALID           PieceAction = 0
	PieceAction_PUT               PieceAction = 1
	PieceAction_GET               PieceAction = 2
	PieceAction_GET_AUDIT         PieceAction = 3
	PieceAction_GET_REPAIR        PieceAction = 4
	PieceAction_PUT_REPAIR        PieceAction = 5
	PieceAction_DELETE            PieceAction = 6
	PieceAction_PUT_GRACEFUL_EXIT PieceAction = 7
)

var PieceAction_name = map[int32]string{
	0: "INVALID",
	1: "PUT",
	2: "GET",
	3: "GET_AUDIT",
	4: "GET_REPAIR",
	5: "PUT_REPAIR",
	6: "DELETE",
	7: "PUT_GRACEFUL_EXIT",
}

var PieceAction_value = map[string]int32{
	"INVALID":           0,
	"PUT":               1,
	"GET":               2,
	"GET_AUDIT":         3,
	"GET_REPAIR":        4,
	"PUT_REPAIR":        5,
	"DELETE":            6,
	"PUT_GRACEFUL_EXIT": 7,
}

func (x PieceAction) String() string {
	return proto.EnumName(PieceAction_name, int32(x))
}

func (PieceAction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e0f5d4cf0fc9e41b, []int{0}
}

type SettlementResponse_Status int32

const (
	SettlementResponse_INVALID  SettlementResponse_Status = 0
	SettlementResponse_ACCEPTED SettlementResponse_Status = 1
	SettlementResponse_REJECTED SettlementResponse_Status = 2
)

var SettlementResponse_Status_name = map[int32]string{
	0: "INVALID",
	1: "ACCEPTED",
	2: "REJECTED",
}

var SettlementResponse_Status_value = map[string]int32{
	"INVALID":  0,
	"ACCEPTED": 1,
	"REJECTED": 2,
}

func (x SettlementResponse_Status) String() string {
	return proto.EnumName(SettlementResponse_Status_name, int32(x))
}

func (SettlementResponse_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e0f5d4cf0fc9e41b, []int{7, 0}
}

// OrderLimit is provided by satellite to execute specific action on storage node within some limits.
type OrderLimit struct {
	// unique serial to avoid replay attacks
	SerialNumber SerialNumber `protobuf:"bytes,1,opt,name=serial_number,json=serialNumber,proto3,customtype=SerialNumber" json:"serial_number"`
	// satellite who issued this order limit allowing orderer to do the specified action
	SatelliteId NodeID `protobuf:"bytes,2,opt,name=satellite_id,json=satelliteId,proto3,customtype=NodeID" json:"satellite_id"`
	// uplink who requested or whom behalf the order limit to do an action
	DeprecatedUplinkId *NodeID `protobuf:"bytes,3,opt,name=deprecated_uplink_id,json=deprecatedUplinkId,proto3,customtype=NodeID" json:"deprecated_uplink_id,omitempty"`
	// public key that will be used to sign orders and piece hash
	UplinkPublicKey PiecePublicKey `protobuf:"bytes,13,opt,name=uplink_public_key,json=uplinkPublicKey,proto3,customtype=PiecePublicKey" json:"uplink_public_key"`
	// storage node who can re claimthe order limit specified by serial
	StorageNodeId NodeID `protobuf:"bytes,4,opt,name=storage_node_id,json=storageNodeId,proto3,customtype=NodeID" json:"storage_node_id"`
	// piece which is allowed to be touched
	PieceId PieceID `protobuf:"bytes,5,opt,name=piece_id,json=pieceId,proto3,customtype=PieceID" json:"piece_id"`
	// limit in bytes how much can be changed
	Limit              int64       `protobuf:"varint,6,opt,name=limit,proto3" json:"limit,omitempty"`
	Action             PieceAction `protobuf:"varint,7,opt,name=action,proto3,enum=orders.PieceAction" json:"action,omitempty"`
	PieceExpiration    time.Time   `protobuf:"bytes,8,opt,name=piece_expiration,json=pieceExpiration,proto3,stdtime" json:"piece_expiration"`
	OrderExpiration    time.Time   `protobuf:"bytes,9,opt,name=order_expiration,json=orderExpiration,proto3,stdtime" json:"order_expiration"`
	OrderCreation      time.Time   `protobuf:"bytes,12,opt,name=order_creation,json=orderCreation,proto3,stdtime" json:"order_creation"`
	SatelliteSignature []byte      `protobuf:"bytes,10,opt,name=satellite_signature,json=satelliteSignature,proto3" json:"satellite_signature,omitempty"`
	// satellites aren't necessarily discoverable in kademlia. this allows
	// a storage node to find a satellite and handshake with it to get its key.
	SatelliteAddress     *NodeAddress `protobuf:"bytes,11,opt,name=satellite_address,json=satelliteAddress,proto3" json:"satellite_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *OrderLimit) Reset()         { *m = OrderLimit{} }
func (m *OrderLimit) String() string { return proto.CompactTextString(m) }
func (*OrderLimit) ProtoMessage()    {}
func (*OrderLimit) Descriptor() ([]byte, []int) {
	return fileDescriptor_e0f5d4cf0fc9e41b, []int{0}
}
func (m *OrderLimit) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OrderLimit.Unmarshal(m, b)
}
func (m *OrderLimit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OrderLimit.Marshal(b, m, deterministic)
}
func (m *OrderLimit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrderLimit.Merge(m, src)
}
func (m *OrderLimit) XXX_Size() int {
	return xxx_messageInfo_OrderLimit.Size(m)
}
func (m *OrderLimit) XXX_DiscardUnknown() {
	xxx_messageInfo_OrderLimit.DiscardUnknown(m)
}

var xxx_messageInfo_OrderLimit proto.InternalMessageInfo

func (m *OrderLimit) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *OrderLimit) GetAction() PieceAction {
	if m != nil {
		return m.Action
	}
	return PieceAction_INVALID
}

func (m *OrderLimit) GetPieceExpiration() time.Time {
	if m != nil {
		return m.PieceExpiration
	}
	return time.Time{}
}

func (m *OrderLimit) GetOrderExpiration() time.Time {
	if m != nil {
		return m.OrderExpiration
	}
	return time.Time{}
}

func (m *OrderLimit) GetOrderCreation() time.Time {
	if m != nil {
		return m.OrderCreation
	}
	return time.Time{}
}

func (m *OrderLimit) GetSatelliteSignature() []byte {
	if m != nil {
		return m.SatelliteSignature
	}
	return nil
}

func (m *OrderLimit) GetSatelliteAddress() *NodeAddress {
	if m != nil {
		return m.SatelliteAddress
	}
	return nil
}

// OrderLimitSigning provides OrderLimit signing serialization.
//
// It is never used for sending across the network, it is
// used in signing to ensure that nullable=false fields get handled properly.
// Its purpose is to solidify the format of how we serialize for
// signing, to handle some backwards compatibility considerations.
type OrderLimitSigning struct {
	// unique serial to avoid replay attacks
	SerialNumber SerialNumber `protobuf:"bytes,1,opt,name=serial_number,json=serialNumber,proto3,customtype=SerialNumber" json:"serial_number"`
	// satellite who issued this order limit allowing orderer to do the specified action
	SatelliteId NodeID `protobuf:"bytes,2,opt,name=satellite_id,json=satelliteId,proto3,customtype=NodeID" json:"satellite_id"`
	// uplink who requested or whom behalf the order limit to do an action
	DeprecatedUplinkId *NodeID `protobuf:"bytes,3,opt,name=deprecated_uplink_id,json=deprecatedUplinkId,proto3,customtype=NodeID" json:"deprecated_uplink_id,omitempty"`
	// public key that will be used to sign orders and piece hash
	UplinkPublicKey *PiecePublicKey `protobuf:"bytes,13,opt,name=uplink_public_key,json=uplinkPublicKey,proto3,customtype=PiecePublicKey" json:"uplink_public_key,omitempty"`
	// storage node who can re claimthe order limit specified by serial
	StorageNodeId NodeID `protobuf:"bytes,4,opt,name=storage_node_id,json=storageNodeId,proto3,customtype=NodeID" json:"storage_node_id"`
	// piece which is allowed to be touched
	PieceId PieceID `protobuf:"bytes,5,opt,name=piece_id,json=pieceId,proto3,customtype=PieceID" json:"piece_id"`
	// limit in bytes how much can be changed
	Limit              int64       `protobuf:"varint,6,opt,name=limit,proto3" json:"limit,omitempty"`
	Action             PieceAction `protobuf:"varint,7,opt,name=action,proto3,enum=orders.PieceAction" json:"action,omitempty"`
	PieceExpiration    *time.Time  `protobuf:"bytes,8,opt,name=piece_expiration,json=pieceExpiration,proto3,stdtime" json:"piece_expiration,omitempty"`
	OrderExpiration    *time.Time  `protobuf:"bytes,9,opt,name=order_expiration,json=orderExpiration,proto3,stdtime" json:"order_expiration,omitempty"`
	OrderCreation      *time.Time  `protobuf:"bytes,12,opt,name=order_creation,json=orderCreation,proto3,stdtime" json:"order_creation,omitempty"`
	SatelliteSignature []byte      `protobuf:"bytes,10,opt,name=satellite_signature,json=satelliteSignature,proto3" json:"satellite_signature,omitempty"`
	// this allows a storage node to find a satellite and handshake with it to get its key.
	SatelliteAddress     *NodeAddress `protobuf:"bytes,11,opt,name=satellite_address,json=satelliteAddress,proto3" json:"satellite_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *OrderLimitSigning) Reset()         { *m = OrderLimitSigning{} }
func (m *OrderLimitSigning) String() string { return proto.CompactTextString(m) }
func (*OrderLimitSigning) ProtoMessage()    {}
func (*OrderLimitSigning) Descriptor() ([]byte, []int) {
	return fileDescriptor_e0f5d4cf0fc9e41b, []int{1}
}
func (m *OrderLimitSigning) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OrderLimitSigning.Unmarshal(m, b)
}
func (m *OrderLimitSigning) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OrderLimitSigning.Marshal(b, m, deterministic)
}
func (m *OrderLimitSigning) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrderLimitSigning.Merge(m, src)
}
func (m *OrderLimitSigning) XXX_Size() int {
	return xxx_messageInfo_OrderLimitSigning.Size(m)
}
func (m *OrderLimitSigning) XXX_DiscardUnknown() {
	xxx_messageInfo_OrderLimitSigning.DiscardUnknown(m)
}

var xxx_messageInfo_OrderLimitSigning proto.InternalMessageInfo

func (m *OrderLimitSigning) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *OrderLimitSigning) GetAction() PieceAction {
	if m != nil {
		return m.Action
	}
	return PieceAction_INVALID
}

func (m *OrderLimitSigning) GetPieceExpiration() *time.Time {
	if m != nil {
		return m.PieceExpiration
	}
	return nil
}

func (m *OrderLimitSigning) GetOrderExpiration() *time.Time {
	if m != nil {
		return m.OrderExpiration
	}
	return nil
}

func (m *OrderLimitSigning) GetOrderCreation() *time.Time {
	if m != nil {
		return m.OrderCreation
	}
	return nil
}

func (m *OrderLimitSigning) GetSatelliteSignature() []byte {
	if m != nil {
		return m.SatelliteSignature
	}
	return nil
}

func (m *OrderLimitSigning) GetSatelliteAddress() *NodeAddress {
	if m != nil {
		return m.SatelliteAddress
	}
	return nil
}

// Order is a one step of fullfilling Amount number of bytes from an OrderLimit with SerialNumber.
type Order struct {
	// serial of the order limit that was signed
	SerialNumber SerialNumber `protobuf:"bytes,1,opt,name=serial_number,json=serialNumber,proto3,customtype=SerialNumber" json:"serial_number"`
	// amount to be signed for
	Amount int64 `protobuf:"varint,2,opt,name=amount,proto3" json:"amount,omitempty"`
	// signature
	UplinkSignature      []byte   `protobuf:"bytes,3,opt,name=uplink_signature,json=uplinkSignature,proto3" json:"uplink_signature,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Order) Reset()         { *m = Order{} }
func (m *Order) String() string { return proto.CompactTextString(m) }
func (*Order) ProtoMessage()    {}
func (*Order) Descriptor() ([]byte, []int) {
	return fileDescriptor_e0f5d4cf0fc9e41b, []int{2}
}
func (m *Order) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Order.Unmarshal(m, b)
}
func (m *Order) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Order.Marshal(b, m, deterministic)
}
func (m *Order) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Order.Merge(m, src)
}
func (m *Order) XXX_Size() int {
	return xxx_messageInfo_Order.Size(m)
}
func (m *Order) XXX_DiscardUnknown() {
	xxx_messageInfo_Order.DiscardUnknown(m)
}

var xxx_messageInfo_Order proto.InternalMessageInfo

func (m *Order) GetAmount() int64 {
	if m != nil {
		return m.Amount
	}
	return 0
}

func (m *Order) GetUplinkSignature() []byte {
	if m != nil {
		return m.UplinkSignature
	}
	return nil
}

// OrderSigning provides Order signing format.
//
// It is never used for sending across the network, it is
// used in signing to ensure that nullable=false fields get handled properly.
// Its purpose is to solidify the format of how we serialize for
// signing, to handle some backwards compatibility considerations.
type OrderSigning struct {
	// serial of the order limit that was signed
	SerialNumber SerialNumber `protobuf:"bytes,1,opt,name=serial_number,json=serialNumber,proto3,customtype=SerialNumber" json:"serial_number"`
	// amount to be signed for
	Amount int64 `protobuf:"varint,2,opt,name=amount,proto3" json:"amount,omitempty"`
	// signature
	UplinkSignature      []byte   `protobuf:"bytes,3,opt,name=uplink_signature,json=uplinkSignature,proto3" json:"uplink_signature,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OrderSigning) Reset()         { *m = OrderSigning{} }
func (m *OrderSigning) String() string { return proto.CompactTextString(m) }
func (*OrderSigning) ProtoMessage()    {}
func (*OrderSigning) Descriptor() ([]byte, []int) {
	return fileDescriptor_e0f5d4cf0fc9e41b, []int{3}
}
func (m *OrderSigning) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OrderSigning.Unmarshal(m, b)
}
func (m *OrderSigning) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OrderSigning.Marshal(b, m, deterministic)
}
func (m *OrderSigning) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrderSigning.Merge(m, src)
}
func (m *OrderSigning) XXX_Size() int {
	return xxx_messageInfo_OrderSigning.Size(m)
}
func (m *OrderSigning) XXX_DiscardUnknown() {
	xxx_messageInfo_OrderSigning.DiscardUnknown(m)
}

var xxx_messageInfo_OrderSigning proto.InternalMessageInfo

func (m *OrderSigning) GetAmount() int64 {
	if m != nil {
		return m.Amount
	}
	return 0
}

func (m *OrderSigning) GetUplinkSignature() []byte {
	if m != nil {
		return m.UplinkSignature
	}
	return nil
}

type PieceHash struct {
	// piece id
	PieceId PieceID `protobuf:"bytes,1,opt,name=piece_id,json=pieceId,proto3,customtype=PieceID" json:"piece_id"`
	// hash of the piece that was/is uploaded
	Hash []byte `protobuf:"bytes,2,opt,name=hash,proto3" json:"hash,omitempty"`
	// size of uploaded piece
	PieceSize int64 `protobuf:"varint,4,opt,name=piece_size,json=pieceSize,proto3" json:"piece_size,omitempty"`
	// timestamp when upload occurred
	Timestamp time.Time `protobuf:"bytes,5,opt,name=timestamp,proto3,stdtime" json:"timestamp"`
	// signature either satellite or storage node
	Signature            []byte   `protobuf:"bytes,3,opt,name=signature,proto3" json:"signature,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PieceHash) Reset()         { *m = PieceHash{} }
func (m *PieceHash) String() string { return proto.CompactTextString(m) }
func (*PieceHash) ProtoMessage()    {}
func (*PieceHash) Descriptor() ([]byte, []int) {
	return fileDescriptor_e0f5d4cf0fc9e41b, []int{4}
}
func (m *PieceHash) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PieceHash.Unmarshal(m, b)
}
func (m *PieceHash) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PieceHash.Marshal(b, m, deterministic)
}
func (m *PieceHash) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PieceHash.Merge(m, src)
}
func (m *PieceHash) XXX_Size() int {
	return xxx_messageInfo_PieceHash.Size(m)
}
func (m *PieceHash) XXX_DiscardUnknown() {
	xxx_messageInfo_PieceHash.DiscardUnknown(m)
}

var xxx_messageInfo_PieceHash proto.InternalMessageInfo

func (m *PieceHash) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *PieceHash) GetPieceSize() int64 {
	if m != nil {
		return m.PieceSize
	}
	return 0
}

func (m *PieceHash) GetTimestamp() time.Time {
	if m != nil {
		return m.Timestamp
	}
	return time.Time{}
}

func (m *PieceHash) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

// PieceHashSigning provides piece hash signing format.
//
// It is never used for sending across the network, it is
// used in signing to ensure that nullable=false fields get handled properly.
// Its purpose is to solidify the format of how we serialize for
// signing, to handle some backwards compatibility considerations.
type PieceHashSigning struct {
	// piece id
	PieceId PieceID `protobuf:"bytes,1,opt,name=piece_id,json=pieceId,proto3,customtype=PieceID" json:"piece_id"`
	// hash of the piece that was/is uploaded
	Hash []byte `protobuf:"bytes,2,opt,name=hash,proto3" json:"hash,omitempty"`
	// size of uploaded piece
	PieceSize int64 `protobuf:"varint,4,opt,name=piece_size,json=pieceSize,proto3" json:"piece_size,omitempty"`
	// timestamp when upload occurred
	Timestamp *time.Time `protobuf:"bytes,5,opt,name=timestamp,proto3,stdtime" json:"timestamp,omitempty"`
	// signature either satellite or storage node
	Signature            []byte   `protobuf:"bytes,3,opt,name=signature,proto3" json:"signature,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PieceHashSigning) Reset()         { *m = PieceHashSigning{} }
func (m *PieceHashSigning) String() string { return proto.CompactTextString(m) }
func (*PieceHashSigning) ProtoMessage()    {}
func (*PieceHashSigning) Descriptor() ([]byte, []int) {
	return fileDescriptor_e0f5d4cf0fc9e41b, []int{5}
}
func (m *PieceHashSigning) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PieceHashSigning.Unmarshal(m, b)
}
func (m *PieceHashSigning) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PieceHashSigning.Marshal(b, m, deterministic)
}
func (m *PieceHashSigning) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PieceHashSigning.Merge(m, src)
}
func (m *PieceHashSigning) XXX_Size() int {
	return xxx_messageInfo_PieceHashSigning.Size(m)
}
func (m *PieceHashSigning) XXX_DiscardUnknown() {
	xxx_messageInfo_PieceHashSigning.DiscardUnknown(m)
}

var xxx_messageInfo_PieceHashSigning proto.InternalMessageInfo

func (m *PieceHashSigning) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *PieceHashSigning) GetPieceSize() int64 {
	if m != nil {
		return m.PieceSize
	}
	return 0
}

func (m *PieceHashSigning) GetTimestamp() *time.Time {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *PieceHashSigning) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

// Expected order of messages from storagenode:
//   go repeated
//      SettlementRequest -> (async)
//   go repeated
//      <- SettlementResponse
type SettlementRequest struct {
	Limit                *OrderLimit `protobuf:"bytes,1,opt,name=limit,proto3" json:"limit,omitempty"`
	Order                *Order      `protobuf:"bytes,2,opt,name=order,proto3" json:"order,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *SettlementRequest) Reset()         { *m = SettlementRequest{} }
func (m *SettlementRequest) String() string { return proto.CompactTextString(m) }
func (*SettlementRequest) ProtoMessage()    {}
func (*SettlementRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e0f5d4cf0fc9e41b, []int{6}
}
func (m *SettlementRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SettlementRequest.Unmarshal(m, b)
}
func (m *SettlementRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SettlementRequest.Marshal(b, m, deterministic)
}
func (m *SettlementRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SettlementRequest.Merge(m, src)
}
func (m *SettlementRequest) XXX_Size() int {
	return xxx_messageInfo_SettlementRequest.Size(m)
}
func (m *SettlementRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SettlementRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SettlementRequest proto.InternalMessageInfo

func (m *SettlementRequest) GetLimit() *OrderLimit {
	if m != nil {
		return m.Limit
	}
	return nil
}

func (m *SettlementRequest) GetOrder() *Order {
	if m != nil {
		return m.Order
	}
	return nil
}

type SettlementResponse struct {
	SerialNumber         SerialNumber              `protobuf:"bytes,1,opt,name=serial_number,json=serialNumber,proto3,customtype=SerialNumber" json:"serial_number"`
	Status               SettlementResponse_Status `protobuf:"varint,2,opt,name=status,proto3,enum=orders.SettlementResponse_Status" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *SettlementResponse) Reset()         { *m = SettlementResponse{} }
func (m *SettlementResponse) String() string { return proto.CompactTextString(m) }
func (*SettlementResponse) ProtoMessage()    {}
func (*SettlementResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e0f5d4cf0fc9e41b, []int{7}
}
func (m *SettlementResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SettlementResponse.Unmarshal(m, b)
}
func (m *SettlementResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SettlementResponse.Marshal(b, m, deterministic)
}
func (m *SettlementResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SettlementResponse.Merge(m, src)
}
func (m *SettlementResponse) XXX_Size() int {
	return xxx_messageInfo_SettlementResponse.Size(m)
}
func (m *SettlementResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SettlementResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SettlementResponse proto.InternalMessageInfo

func (m *SettlementResponse) GetStatus() SettlementResponse_Status {
	if m != nil {
		return m.Status
	}
	return SettlementResponse_INVALID
}

func init() {
	proto.RegisterEnum("orders.PieceAction", PieceAction_name, PieceAction_value)
	proto.RegisterEnum("orders.SettlementResponse_Status", SettlementResponse_Status_name, SettlementResponse_Status_value)
	proto.RegisterType((*OrderLimit)(nil), "orders.OrderLimit")
	proto.RegisterType((*OrderLimitSigning)(nil), "orders.OrderLimitSigning")
	proto.RegisterType((*Order)(nil), "orders.Order")
	proto.RegisterType((*OrderSigning)(nil), "orders.OrderSigning")
	proto.RegisterType((*PieceHash)(nil), "orders.PieceHash")
	proto.RegisterType((*PieceHashSigning)(nil), "orders.PieceHashSigning")
	proto.RegisterType((*SettlementRequest)(nil), "orders.SettlementRequest")
	proto.RegisterType((*SettlementResponse)(nil), "orders.SettlementResponse")
}

func init() { proto.RegisterFile("orders.proto", fileDescriptor_e0f5d4cf0fc9e41b) }

var fileDescriptor_e0f5d4cf0fc9e41b = []byte{
	// 892 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x55, 0x4b, 0x6f, 0x23, 0x45,
	0x10, 0x4e, 0xc7, 0xf6, 0x38, 0x2e, 0x3f, 0x32, 0xee, 0x0d, 0x2b, 0x63, 0x81, 0x12, 0xcc, 0xc5,
	0x2c, 0x92, 0xcd, 0x1a, 0x09, 0x69, 0x25, 0x14, 0xc9, 0x8f, 0x21, 0x0c, 0x89, 0xb2, 0x56, 0xdb,
	0x46, 0x88, 0x8b, 0x35, 0xf6, 0x34, 0xce, 0xb0, 0xf6, 0xcc, 0x30, 0xdd, 0x23, 0xb1, 0x7b, 0xe0,
	0x82, 0xb8, 0x71, 0xe0, 0x0f, 0x71, 0xe7, 0x80, 0xc4, 0x9d, 0xc3, 0xf2, 0x3f, 0x38, 0xa1, 0xae,
	0x79, 0x39, 0x90, 0x15, 0x38, 0x1b, 0x24, 0xd8, 0xdb, 0x54, 0x57, 0x7d, 0x55, 0x5d, 0x5d, 0xdf,
	0x57, 0x03, 0x15, 0x2f, 0xb0, 0x79, 0x20, 0x3a, 0x7e, 0xe0, 0x49, 0x8f, 0x6a, 0x91, 0xd5, 0x84,
	0x95, 0xb7, 0xf2, 0xa2, 0xb3, 0xe6, 0xf1, 0xca, 0xf3, 0x56, 0x6b, 0xde, 0x45, 0x6b, 0x11, 0x7e,
	0xd1, 0x95, 0xce, 0x86, 0x0b, 0x69, 0x6d, 0xfc, 0x38, 0x00, 0x5c, 0xcf, 0xe6, 0xd1, 0x77, 0xeb,
	0x5b, 0x0d, 0xe0, 0xb1, 0xca, 0x71, 0xe1, 0x6c, 0x1c, 0x49, 0x1f, 0x41, 0x55, 0xf0, 0xc0, 0xb1,
	0xd6, 0x73, 0x37, 0xdc, 0x2c, 0x78, 0xd0, 0x20, 0x27, 0xa4, 0x5d, 0x19, 0x1c, 0xfd, 0xf4, 0xfc,
	0x78, 0xef, 0xd7, 0xe7, 0xc7, 0x95, 0x09, 0x3a, 0x2f, 0xd1, 0xc7, 0x2a, 0x62, 0xcb, 0xa2, 0x0f,
	0xa1, 0x22, 0x2c, 0xc9, 0xd7, 0x6b, 0x47, 0xf2, 0xb9, 0x63, 0x37, 0xf6, 0x11, 0x59, 0x8b, 0x91,
	0xda, 0xa5, 0x67, 0x73, 0x73, 0xc4, 0xca, 0x69, 0x8c, 0x69, 0xd3, 0x0f, 0xe1, 0xc8, 0xe6, 0x7e,
	0xc0, 0x97, 0x96, 0xe4, 0xf6, 0x3c, 0xf4, 0xd7, 0x8e, 0xfb, 0x44, 0x41, 0x73, 0x08, 0x85, 0x2d,
	0x18, 0xcd, 0xe2, 0x66, 0x18, 0x66, 0xda, 0x74, 0x00, 0xf5, 0x18, 0xe2, 0x87, 0x8b, 0xb5, 0xb3,
	0x9c, 0x3f, 0xe1, 0x4f, 0x1b, 0x55, 0x84, 0xde, 0x8f, 0xab, 0xd6, 0xc6, 0x0e, 0x5f, 0xf2, 0x31,
	0xba, 0xcf, 0xf9, 0x53, 0x76, 0x18, 0x01, 0xd2, 0x03, 0xfa, 0x01, 0x1c, 0x0a, 0xe9, 0x05, 0xd6,
	0x8a, 0xcf, 0xd5, 0xa3, 0xa8, 0xe2, 0xf9, 0x1b, 0xef, 0x5d, 0x8d, 0xc3, 0xd0, 0xb4, 0xe9, 0x03,
	0x38, 0xf0, 0x55, 0x6a, 0x05, 0x28, 0x20, 0xe0, 0x30, 0x06, 0x14, 0xb1, 0xa4, 0x39, 0x62, 0x45,
	0x0c, 0x30, 0x6d, 0x7a, 0x04, 0x85, 0xb5, 0x7a, 0xdc, 0x86, 0x76, 0x42, 0xda, 0x39, 0x16, 0x19,
	0xf4, 0x5d, 0xd0, 0xac, 0xa5, 0x74, 0x3c, 0xb7, 0x51, 0x3c, 0x21, 0xed, 0x5a, 0xef, 0x5e, 0x27,
	0x1e, 0x2c, 0xe2, 0xfb, 0xe8, 0x62, 0x71, 0x08, 0x7d, 0x0c, 0x7a, 0x54, 0x8e, 0x7f, 0xed, 0x3b,
	0x81, 0x85, 0xb0, 0x83, 0x13, 0xd2, 0x2e, 0xf7, 0x9a, 0x9d, 0x68, 0xda, 0x9d, 0x64, 0xda, 0x9d,
	0x69, 0x32, 0xed, 0xc1, 0x81, 0xba, 0xd2, 0x0f, 0xbf, 0x1d, 0x13, 0x76, 0x88, 0x68, 0x23, 0x05,
	0xab, 0x84, 0x58, 0x6e, 0x3b, 0x61, 0x69, 0x97, 0x84, 0x88, 0xde, 0x4a, 0x78, 0x0e, 0xb5, 0x28,
	0xe1, 0x32, 0xe0, 0x51, 0xba, 0xca, 0x0e, 0xe9, 0xaa, 0x88, 0x1d, 0xc6, 0x50, 0xda, 0x85, 0x7b,
	0x19, 0x95, 0x84, 0xb3, 0x72, 0x2d, 0x19, 0x06, 0xbc, 0x01, 0xea, 0xa1, 0x19, 0x4d, 0x5d, 0x93,
	0xc4, 0x43, 0x4f, 0xa1, 0x9e, 0x01, 0x2c, 0xdb, 0x0e, 0xb8, 0x10, 0x8d, 0x32, 0x5e, 0xa0, 0xde,
	0x41, 0xb6, 0xab, 0xb9, 0xf5, 0x23, 0x07, 0xd3, 0xd3, 0xd8, 0xf8, 0xa4, 0xf5, 0x7b, 0x01, 0xea,
	0x99, 0x0a, 0x54, 0x5e, 0xc7, 0x5d, 0xfd, 0xaf, 0xc4, 0x70, 0xfa, 0x62, 0x31, 0xd0, 0x57, 0x48,
	0x08, 0xe7, 0xb7, 0x12, 0x42, 0xfe, 0x66, 0x11, 0x9c, 0xdf, 0x4a, 0x04, 0xf9, 0x9b, 0x05, 0x70,
	0x76, 0x0b, 0x01, 0xe4, 0xff, 0x13, 0xe4, 0xff, 0x8e, 0x40, 0x01, 0xc9, 0xff, 0x32, 0x84, 0xbf,
	0x0f, 0x9a, 0xb5, 0xf1, 0x42, 0x57, 0x22, 0xd5, 0x73, 0x2c, 0xb6, 0xe8, 0x3b, 0xa0, 0xc7, 0xbc,
	0xcc, 0x5a, 0x41, 0x46, 0x27, 0x14, 0x4c, 0xfb, 0x68, 0x7d, 0x4f, 0xa0, 0x82, 0xf7, 0xb8, 0x03,
	0xfd, 0xdd, 0xc1, 0x75, 0x7e, 0x26, 0x50, 0x42, 0x0a, 0x7e, 0x6c, 0x89, 0xab, 0x6b, 0x3c, 0x27,
	0x7f, 0xc3, 0x73, 0x0a, 0xf9, 0x2b, 0x4b, 0x5c, 0x45, 0xa2, 0x67, 0xf8, 0x4d, 0xdf, 0x04, 0x88,
	0xf0, 0xc2, 0x79, 0xc6, 0x51, 0x5a, 0x39, 0x56, 0xc2, 0x93, 0x89, 0xf3, 0x8c, 0xd3, 0x01, 0x94,
	0xd2, 0xbf, 0x34, 0xea, 0xe8, 0x9f, 0x6e, 0xce, 0x0c, 0x46, 0xdf, 0x80, 0xd2, 0x9f, 0x9b, 0xca,
	0x0e, 0x5a, 0xbf, 0x10, 0xd0, 0xd3, 0x76, 0x92, 0x17, 0xfe, 0x97, 0xbb, 0x3a, 0xdd, 0xad, 0xab,
	0xfc, 0x6e, 0x1d, 0x2d, 0xa0, 0x3e, 0xe1, 0x52, 0xae, 0xf9, 0x86, 0xbb, 0x92, 0xf1, 0xaf, 0x42,
	0x2e, 0x24, 0x6d, 0x27, 0x3b, 0x86, 0x60, 0x39, 0x9a, 0x2c, 0x93, 0x6c, 0xbb, 0x27, 0x7b, 0xe7,
	0x6d, 0x28, 0xa0, 0x0f, 0x1b, 0x2a, 0xf7, 0xaa, 0xd7, 0x22, 0x59, 0xe4, 0x6b, 0xfd, 0x48, 0x80,
	0x6e, 0x17, 0x11, 0xbe, 0xe7, 0x0a, 0xfe, 0x32, 0xcc, 0x7c, 0x04, 0x9a, 0x90, 0x96, 0x0c, 0x05,
	0xd6, 0xad, 0xf5, 0xde, 0x4a, 0xea, 0xfe, 0xb5, 0x4c, 0x67, 0x82, 0x81, 0x2c, 0x06, 0xb4, 0x1e,
	0x82, 0x16, 0x9d, 0xd0, 0x32, 0x14, 0xcd, 0xcb, 0x4f, 0xfb, 0x17, 0xe6, 0x48, 0xdf, 0xa3, 0x15,
	0x38, 0xe8, 0x0f, 0x87, 0xc6, 0x78, 0x6a, 0x8c, 0x74, 0xa2, 0x2c, 0x66, 0x7c, 0x62, 0x0c, 0x95,
	0xb5, 0xff, 0xe0, 0x1b, 0x28, 0x6f, 0xad, 0xd1, 0xeb, 0xb8, 0x22, 0xe4, 0xc6, 0xb3, 0xa9, 0x4e,
	0xd4, 0xc7, 0x99, 0x31, 0xd5, 0xf7, 0x69, 0x15, 0x4a, 0x67, 0xc6, 0x74, 0xde, 0x9f, 0x8d, 0xcc,
	0xa9, 0x9e, 0xa3, 0x35, 0x00, 0x65, 0x32, 0x63, 0xdc, 0x37, 0x99, 0x9e, 0x57, 0xf6, 0x78, 0x96,
	0xda, 0x05, 0x0a, 0xa0, 0x8d, 0x8c, 0x0b, 0x63, 0x6a, 0xe8, 0x1a, 0x7d, 0x0d, 0xea, 0xca, 0x77,
	0xc6, 0xfa, 0x43, 0xe3, 0xa3, 0xd9, 0xc5, 0xdc, 0xf8, 0xcc, 0x9c, 0xea, 0xc5, 0xde, 0x04, 0x34,
	0x7c, 0x4f, 0x41, 0x4d, 0x80, 0xac, 0x43, 0xfa, 0xfa, 0x4d, 0x5d, 0xe3, 0x04, 0x9b, 0xcd, 0x17,
	0x3f, 0x48, 0x6b, 0xaf, 0x4d, 0xde, 0x23, 0x83, 0xa3, 0xcf, 0xa9, 0xfa, 0x09, 0x7d, 0xd9, 0x71,
	0xbc, 0xee, 0xd2, 0xdb, 0x6c, 0x3c, 0xb7, 0xeb, 0x2f, 0x16, 0x1a, 0x32, 0xea, 0xfd, 0x3f, 0x02,
	0x00, 0x00, 0xff, 0xff, 0xb4, 0xbc, 0x85, 0xa1, 0x21, 0x0b, 0x00, 0x00,
}

// --- DRPC BEGIN ---

type DRPCOrdersClient interface {
	DRPCConn() drpc.Conn

	Settlement(ctx context.Context) (DRPCOrders_SettlementClient, error)
}

type drpcOrdersClient struct {
	cc drpc.Conn
}

func NewDRPCOrdersClient(cc drpc.Conn) DRPCOrdersClient {
	return &drpcOrdersClient{cc}
}

func (c *drpcOrdersClient) DRPCConn() drpc.Conn { return c.cc }

func (c *drpcOrdersClient) Settlement(ctx context.Context) (DRPCOrders_SettlementClient, error) {
	stream, err := c.cc.NewStream(ctx, "/orders.Orders/Settlement")
	if err != nil {
		return nil, err
	}
	x := &drpcOrdersSettlementClient{stream}
	return x, nil
}

type DRPCOrders_SettlementClient interface {
	drpc.Stream
	Send(*SettlementRequest) error
	Recv() (*SettlementResponse, error)
}

type drpcOrdersSettlementClient struct {
	drpc.Stream
}

func (x *drpcOrdersSettlementClient) Send(m *SettlementRequest) error {
	return x.MsgSend(m)
}

func (x *drpcOrdersSettlementClient) Recv() (*SettlementResponse, error) {
	m := new(SettlementResponse)
	if err := x.MsgRecv(m); err != nil {
		return nil, err
	}
	return m, nil
}

type DRPCOrdersServer interface {
	Settlement(DRPCOrders_SettlementStream) error
}

type DRPCOrdersDescription struct{}

func (DRPCOrdersDescription) NumMethods() int { return 1 }

func (DRPCOrdersDescription) Method(n int) (string, drpc.Receiver, interface{}, bool) {
	switch n {
	case 0:
		return "/orders.Orders/Settlement",
			func(srv interface{}, ctx context.Context, in1, in2 interface{}) (drpc.Message, error) {
				return nil, srv.(DRPCOrdersServer).
					Settlement(
						&drpcOrdersSettlementStream{in1.(drpc.Stream)},
					)
			}, DRPCOrdersServer.Settlement, true
	default:
		return "", nil, nil, false
	}
}

func DRPCRegisterOrders(mux drpc.Mux, impl DRPCOrdersServer) error {
	return mux.Register(impl, DRPCOrdersDescription{})
}

type DRPCOrders_SettlementStream interface {
	drpc.Stream
	Send(*SettlementResponse) error
	Recv() (*SettlementRequest, error)
}

type drpcOrdersSettlementStream struct {
	drpc.Stream
}

func (x *drpcOrdersSettlementStream) Send(m *SettlementResponse) error {
	return x.MsgSend(m)
}

func (x *drpcOrdersSettlementStream) Recv() (*SettlementRequest, error) {
	m := new(SettlementRequest)
	if err := x.MsgRecv(m); err != nil {
		return nil, err
	}
	return m, nil
}

// --- DRPC END ---
