
---
title: "getAmiIds"
title_tag: "mypkg.getAmiIds"
meta_desc: "Documentation for the mypkg.getAmiIds function with examples, input properties, output properties, and supporting types."
layout: api
no_edit_this_page: true
---



<!-- WARNING: this file was generated by test. -->
<!-- Do not edit by hand unless you're certain you know what you are doing! -->
<p class="resource-deprecated">Deprecated:<p>aws.getAmiIds has been deprecated in favor of aws.ec2.getAmiIds</p>
</p>

Taken from pulumi-AWS to regress an issue




## Using getAmiIds {#using}

Two invocation forms are available. The direct form accepts plain
arguments and either blocks until the result value is available, or
returns a Promise-wrapped result. The output form accepts
Input-wrapped arguments and returns an Output-wrapped result.

<div>
<pulumi-chooser type="language" options="typescript,python,go,csharp,java,yaml"></pulumi-chooser>
</div>


<div>
<pulumi-choosable type="language" values="javascript,typescript">
<div class="highlight"
><pre class="chroma"><code class="language-typescript" data-lang="typescript"
><span class="k">function </span>getAmiIds<span class="p">(</span><span class="nx">args</span><span class="p">:</span> <span class="nx">GetAmiIdsArgs</span><span class="p">,</span> <span class="nx">opts</span><span class="p">?:</span> <span class="nx"><a href="/docs/reference/pkg/nodejs/pulumi/pulumi/#InvokeOptions">InvokeOptions</a></span><span class="p">): Promise&lt;<span class="nx"><a href="#result">GetAmiIdsResult</a></span>></span
><span class="k">
function </span>getAmiIdsOutput<span class="p">(</span><span class="nx">args</span><span class="p">:</span> <span class="nx">GetAmiIdsOutputArgs</span><span class="p">,</span> <span class="nx">opts</span><span class="p">?:</span> <span class="nx"><a href="/docs/reference/pkg/nodejs/pulumi/pulumi/#InvokeOptions">InvokeOptions</a></span><span class="p">): Output&lt;<span class="nx"><a href="#result">GetAmiIdsResult</a></span>></span
></code></pre></div>
</pulumi-choosable>
</div>


<div>
<pulumi-choosable type="language" values="python">
<div class="highlight"><pre class="chroma"><code class="language-python" data-lang="python"
><span class="k">def </span>get_ami_ids<span class="p">(</span><span class="nx">executable_users</span><span class="p">:</span> <span class="nx">Optional[Sequence[str]]</span> = None<span class="p">,</span>
                <span class="nx">filters</span><span class="p">:</span> <span class="nx">Optional[Sequence[GetAmiIdsFilter]]</span> = None<span class="p">,</span>
                <span class="nx">name_regex</span><span class="p">:</span> <span class="nx">Optional[str]</span> = None<span class="p">,</span>
                <span class="nx">owners</span><span class="p">:</span> <span class="nx">Optional[Sequence[str]]</span> = None<span class="p">,</span>
                <span class="nx">sort_ascending</span><span class="p">:</span> <span class="nx">Optional[bool]</span> = None<span class="p">,</span>
                <span class="nx">opts</span><span class="p">:</span> <span class="nx"><a href="/docs/reference/pkg/python/pulumi/#pulumi.InvokeOptions">Optional[InvokeOptions]</a></span> = None<span class="p">) -&gt;</span> <span>GetAmiIdsResult</span
><span class="k">
def </span>get_ami_ids_output<span class="p">(</span><span class="nx">executable_users</span><span class="p">:</span> <span class="nx">Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]</span> = None<span class="p">,</span>
                <span class="nx">filters</span><span class="p">:</span> <span class="nx">Optional[pulumi.Input[Sequence[pulumi.Input[GetAmiIdsFilterArgs]]]]</span> = None<span class="p">,</span>
                <span class="nx">name_regex</span><span class="p">:</span> <span class="nx">Optional[pulumi.Input[str]]</span> = None<span class="p">,</span>
                <span class="nx">owners</span><span class="p">:</span> <span class="nx">Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]</span> = None<span class="p">,</span>
                <span class="nx">sort_ascending</span><span class="p">:</span> <span class="nx">Optional[pulumi.Input[bool]]</span> = None<span class="p">,</span>
                <span class="nx">opts</span><span class="p">:</span> <span class="nx"><a href="/docs/reference/pkg/python/pulumi/#pulumi.InvokeOptions">Optional[InvokeOptions]</a></span> = None<span class="p">) -&gt;</span> <span>Output[GetAmiIdsResult]</span
></code></pre></div>
</pulumi-choosable>
</div>


<div>
<pulumi-choosable type="language" values="go">
<div class="highlight"><pre class="chroma"><code class="language-go" data-lang="go"
><span class="k">func </span>GetAmiIds<span class="p">(</span><span class="nx">ctx</span><span class="p"> *</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#Context">Context</a></span><span class="p">,</span> <span class="nx">args</span><span class="p"> *</span><span class="nx">GetAmiIdsArgs</span><span class="p">,</span> <span class="nx">opts</span><span class="p"> ...</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#InvokeOption">InvokeOption</a></span><span class="p">) (*<span class="nx"><a href="#result">GetAmiIdsResult</a></span>, error)</span
><span class="k">
func </span>GetAmiIdsOutput<span class="p">(</span><span class="nx">ctx</span><span class="p"> *</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#Context">Context</a></span><span class="p">,</span> <span class="nx">args</span><span class="p"> *</span><span class="nx">GetAmiIdsOutputArgs</span><span class="p">,</span> <span class="nx">opts</span><span class="p"> ...</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#InvokeOption">InvokeOption</a></span><span class="p">) GetAmiIdsResultOutput</span
></code></pre></div>

&gt; Note: This function is named `GetAmiIds` in the Go SDK.

</pulumi-choosable>
</div>


<div>
<pulumi-choosable type="language" values="csharp">
<div class="highlight"><pre class="chroma"><code class="language-csharp" data-lang="csharp"><span class="k">public static class </span><span class="nx">GetAmiIds </span><span class="p">
{</span><span class="k">
    public static </span>Task&lt;<span class="nx"><a href="#result">GetAmiIdsResult</a></span>> <span class="p">InvokeAsync(</span><span class="nx">GetAmiIdsArgs</span><span class="p"> </span><span class="nx">args<span class="p">,</span> <span class="nx"><a href="/docs/reference/pkg/dotnet/Pulumi/Pulumi.InvokeOptions.html">InvokeOptions</a></span><span class="p">? </span><span class="nx">opts = null<span class="p">)</span><span class="k">
    public static </span>Output&lt;<span class="nx"><a href="#result">GetAmiIdsResult</a></span>> <span class="p">Invoke(</span><span class="nx">GetAmiIdsInvokeArgs</span><span class="p"> </span><span class="nx">args<span class="p">,</span> <span class="nx"><a href="/docs/reference/pkg/dotnet/Pulumi/Pulumi.InvokeOptions.html">InvokeOptions</a></span><span class="p">? </span><span class="nx">opts = null<span class="p">)</span><span class="p">
}</span></code></pre></div>
</pulumi-choosable>
</div>


<div>
<pulumi-choosable type="language" values="java">
<div class="highlight"><pre class="chroma"><code class="language-java" data-lang="java"><span class="k">public static CompletableFuture&lt;<span class="nx"><a href="#result">GetAmiIdsResult</a></span>> </span>getAmiIds<span class="p">(</span><span class="nx">GetAmiIdsArgs</span><span class="p"> </span><span class="nx">args<span class="p">,</span> <span class="nx">InvokeOptions</span><span class="p"> </span><span class="nx">options<span class="p">)</span>
<span class="c">// Output-based functions aren't available in Java yet</span>
</code></pre></div>
</pulumi-choosable>
</div>


<div>
<pulumi-choosable type="language" values="java">
<div class="highlight"><pre class="chroma"><code class="language-yaml" data-lang="yaml"><span class="k">Fn::Invoke:</span>
<span class="k">&nbsp;&nbsp;Function:</span> mypkg:getAmiIds
<span class="k">&nbsp;&nbsp;Arguments:</span>
<span class="c">&nbsp;&nbsp;&nbsp;&nbsp;# Arguments dictionary</span></code></pre></div>
</pulumi-choosable>
</div>



The following arguments are supported:


<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="owners_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#owners_csharp" style="color: inherit; text-decoration: inherit;">Owners</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd><p>List of AMI owners to limit search. At least 1 value must be specified. Valid values: an AWS account ID, <code>self</code> (the current account), or an AWS owner alias (e.g. <code>amazon</code>, <code>aws-marketplace</code>, <code>microsoft</code>).</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="executableusers_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#executableusers_csharp" style="color: inherit; text-decoration: inherit;">Executable<wbr>Users</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd><p>Limit search to users with <em>explicit</em> launch
permission on  the image. Valid items are the numeric account ID or <code>self</code>.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="filters_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filters_csharp" style="color: inherit; text-decoration: inherit;">Filters</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#getamiidsfilter">List&lt;Get<wbr>Ami<wbr>Ids<wbr>Filter&gt;</a></span>
    </dt>
    <dd><p>One or more name/value pairs to filter off of. There
are several valid keys, for a full reference, check out
[describe-images in the AWS CLI reference][1].</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="nameregex_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nameregex_csharp" style="color: inherit; text-decoration: inherit;">Name<wbr>Regex</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>A regex string to apply to the AMI list returned
by AWS. This allows more advanced filtering not supported from the AWS API.
This filtering is done locally on what AWS returns, and could have a performance
impact if the result is large. It is recommended to combine this with other
options to narrow down the list AWS returns.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="sortascending_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#sortascending_csharp" style="color: inherit; text-decoration: inherit;">Sort<wbr>Ascending</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd><p>Used to sort AMIs by creation time.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="owners_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#owners_go" style="color: inherit; text-decoration: inherit;">Owners</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd><p>List of AMI owners to limit search. At least 1 value must be specified. Valid values: an AWS account ID, <code>self</code> (the current account), or an AWS owner alias (e.g. <code>amazon</code>, <code>aws-marketplace</code>, <code>microsoft</code>).</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="executableusers_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#executableusers_go" style="color: inherit; text-decoration: inherit;">Executable<wbr>Users</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd><p>Limit search to users with <em>explicit</em> launch
permission on  the image. Valid items are the numeric account ID or <code>self</code>.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="filters_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filters_go" style="color: inherit; text-decoration: inherit;">Filters</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#getamiidsfilter">[]Get<wbr>Ami<wbr>Ids<wbr>Filter</a></span>
    </dt>
    <dd><p>One or more name/value pairs to filter off of. There
are several valid keys, for a full reference, check out
[describe-images in the AWS CLI reference][1].</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="nameregex_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nameregex_go" style="color: inherit; text-decoration: inherit;">Name<wbr>Regex</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>A regex string to apply to the AMI list returned
by AWS. This allows more advanced filtering not supported from the AWS API.
This filtering is done locally on what AWS returns, and could have a performance
impact if the result is large. It is recommended to combine this with other
options to narrow down the list AWS returns.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="sortascending_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#sortascending_go" style="color: inherit; text-decoration: inherit;">Sort<wbr>Ascending</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd><p>Used to sort AMIs by creation time.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="owners_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#owners_java" style="color: inherit; text-decoration: inherit;">owners</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd><p>List of AMI owners to limit search. At least 1 value must be specified. Valid values: an AWS account ID, <code>self</code> (the current account), or an AWS owner alias (e.g. <code>amazon</code>, <code>aws-marketplace</code>, <code>microsoft</code>).</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="executableusers_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#executableusers_java" style="color: inherit; text-decoration: inherit;">executable<wbr>Users</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd><p>Limit search to users with <em>explicit</em> launch
permission on  the image. Valid items are the numeric account ID or <code>self</code>.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="filters_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filters_java" style="color: inherit; text-decoration: inherit;">filters</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#getamiidsfilter">List<Get<wbr>Ami<wbr>Ids<wbr>Filter></a></span>
    </dt>
    <dd><p>One or more name/value pairs to filter off of. There
are several valid keys, for a full reference, check out
[describe-images in the AWS CLI reference][1].</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="nameregex_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nameregex_java" style="color: inherit; text-decoration: inherit;">name<wbr>Regex</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>A regex string to apply to the AMI list returned
by AWS. This allows more advanced filtering not supported from the AWS API.
This filtering is done locally on what AWS returns, and could have a performance
impact if the result is large. It is recommended to combine this with other
options to narrow down the list AWS returns.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="sortascending_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#sortascending_java" style="color: inherit; text-decoration: inherit;">sort<wbr>Ascending</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Boolean</span>
    </dt>
    <dd><p>Used to sort AMIs by creation time.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="owners_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#owners_nodejs" style="color: inherit; text-decoration: inherit;">owners</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd><p>List of AMI owners to limit search. At least 1 value must be specified. Valid values: an AWS account ID, <code>self</code> (the current account), or an AWS owner alias (e.g. <code>amazon</code>, <code>aws-marketplace</code>, <code>microsoft</code>).</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="executableusers_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#executableusers_nodejs" style="color: inherit; text-decoration: inherit;">executable<wbr>Users</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd><p>Limit search to users with <em>explicit</em> launch
permission on  the image. Valid items are the numeric account ID or <code>self</code>.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="filters_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filters_nodejs" style="color: inherit; text-decoration: inherit;">filters</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#getamiidsfilter">Get<wbr>Ami<wbr>Ids<wbr>Filter[]</a></span>
    </dt>
    <dd><p>One or more name/value pairs to filter off of. There
are several valid keys, for a full reference, check out
[describe-images in the AWS CLI reference][1].</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="nameregex_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nameregex_nodejs" style="color: inherit; text-decoration: inherit;">name<wbr>Regex</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>A regex string to apply to the AMI list returned
by AWS. This allows more advanced filtering not supported from the AWS API.
This filtering is done locally on what AWS returns, and could have a performance
impact if the result is large. It is recommended to combine this with other
options to narrow down the list AWS returns.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="sortascending_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#sortascending_nodejs" style="color: inherit; text-decoration: inherit;">sort<wbr>Ascending</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">boolean</span>
    </dt>
    <dd><p>Used to sort AMIs by creation time.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="owners_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#owners_python" style="color: inherit; text-decoration: inherit;">owners</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd><p>List of AMI owners to limit search. At least 1 value must be specified. Valid values: an AWS account ID, <code>self</code> (the current account), or an AWS owner alias (e.g. <code>amazon</code>, <code>aws-marketplace</code>, <code>microsoft</code>).</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="executable_users_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#executable_users_python" style="color: inherit; text-decoration: inherit;">executable_<wbr>users</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd><p>Limit search to users with <em>explicit</em> launch
permission on  the image. Valid items are the numeric account ID or <code>self</code>.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="filters_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filters_python" style="color: inherit; text-decoration: inherit;">filters</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#getamiidsfilter">Sequence[Get<wbr>Ami<wbr>Ids<wbr>Filter]</a></span>
    </dt>
    <dd><p>One or more name/value pairs to filter off of. There
are several valid keys, for a full reference, check out
[describe-images in the AWS CLI reference][1].</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="name_regex_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_regex_python" style="color: inherit; text-decoration: inherit;">name_<wbr>regex</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>A regex string to apply to the AMI list returned
by AWS. This allows more advanced filtering not supported from the AWS API.
This filtering is done locally on what AWS returns, and could have a performance
impact if the result is large. It is recommended to combine this with other
options to narrow down the list AWS returns.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="sort_ascending_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#sort_ascending_python" style="color: inherit; text-decoration: inherit;">sort_<wbr>ascending</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd><p>Used to sort AMIs by creation time.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="owners_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#owners_yaml" style="color: inherit; text-decoration: inherit;">owners</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd><p>List of AMI owners to limit search. At least 1 value must be specified. Valid values: an AWS account ID, <code>self</code> (the current account), or an AWS owner alias (e.g. <code>amazon</code>, <code>aws-marketplace</code>, <code>microsoft</code>).</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="executableusers_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#executableusers_yaml" style="color: inherit; text-decoration: inherit;">executable<wbr>Users</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd><p>Limit search to users with <em>explicit</em> launch
permission on  the image. Valid items are the numeric account ID or <code>self</code>.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="filters_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filters_yaml" style="color: inherit; text-decoration: inherit;">filters</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#getamiidsfilter">List<Property Map></a></span>
    </dt>
    <dd><p>One or more name/value pairs to filter off of. There
are several valid keys, for a full reference, check out
[describe-images in the AWS CLI reference][1].</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="nameregex_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nameregex_yaml" style="color: inherit; text-decoration: inherit;">name<wbr>Regex</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>A regex string to apply to the AMI list returned
by AWS. This allows more advanced filtering not supported from the AWS API.
This filtering is done locally on what AWS returns, and could have a performance
impact if the result is large. It is recommended to combine this with other
options to narrow down the list AWS returns.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="sortascending_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#sortascending_yaml" style="color: inherit; text-decoration: inherit;">sort<wbr>Ascending</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Boolean</span>
    </dt>
    <dd><p>Used to sort AMIs by creation time.</p>
</dd></dl>
</pulumi-choosable>
</div>




## getAmiIds Result {#result}

The following output properties are available:



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#id_csharp" style="color: inherit; text-decoration: inherit;">Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>The provider-assigned unique ID for this managed resource.</p>
</dd><dt class="property-"
            title="">
        <span id="ids_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#ids_csharp" style="color: inherit; text-decoration: inherit;">Ids</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="owners_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#owners_csharp" style="color: inherit; text-decoration: inherit;">Owners</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="executableusers_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#executableusers_csharp" style="color: inherit; text-decoration: inherit;">Executable<wbr>Users</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="filters_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filters_csharp" style="color: inherit; text-decoration: inherit;">Filters</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#getamiidsfilter">List&lt;Get<wbr>Ami<wbr>Ids<wbr>Filter&gt;</a></span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="nameregex_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nameregex_csharp" style="color: inherit; text-decoration: inherit;">Name<wbr>Regex</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="sortascending_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#sortascending_csharp" style="color: inherit; text-decoration: inherit;">Sort<wbr>Ascending</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#id_go" style="color: inherit; text-decoration: inherit;">Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>The provider-assigned unique ID for this managed resource.</p>
</dd><dt class="property-"
            title="">
        <span id="ids_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#ids_go" style="color: inherit; text-decoration: inherit;">Ids</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="owners_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#owners_go" style="color: inherit; text-decoration: inherit;">Owners</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="executableusers_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#executableusers_go" style="color: inherit; text-decoration: inherit;">Executable<wbr>Users</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="filters_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filters_go" style="color: inherit; text-decoration: inherit;">Filters</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#getamiidsfilter">[]Get<wbr>Ami<wbr>Ids<wbr>Filter</a></span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="nameregex_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nameregex_go" style="color: inherit; text-decoration: inherit;">Name<wbr>Regex</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="sortascending_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#sortascending_go" style="color: inherit; text-decoration: inherit;">Sort<wbr>Ascending</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#id_java" style="color: inherit; text-decoration: inherit;">id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>The provider-assigned unique ID for this managed resource.</p>
</dd><dt class="property-"
            title="">
        <span id="ids_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#ids_java" style="color: inherit; text-decoration: inherit;">ids</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="owners_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#owners_java" style="color: inherit; text-decoration: inherit;">owners</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="executableusers_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#executableusers_java" style="color: inherit; text-decoration: inherit;">executable<wbr>Users</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="filters_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filters_java" style="color: inherit; text-decoration: inherit;">filters</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#getamiidsfilter">List<Get<wbr>Ami<wbr>Ids<wbr>Filter></a></span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="nameregex_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nameregex_java" style="color: inherit; text-decoration: inherit;">name<wbr>Regex</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="sortascending_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#sortascending_java" style="color: inherit; text-decoration: inherit;">sort<wbr>Ascending</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Boolean</span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#id_nodejs" style="color: inherit; text-decoration: inherit;">id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>The provider-assigned unique ID for this managed resource.</p>
</dd><dt class="property-"
            title="">
        <span id="ids_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#ids_nodejs" style="color: inherit; text-decoration: inherit;">ids</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="owners_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#owners_nodejs" style="color: inherit; text-decoration: inherit;">owners</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="executableusers_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#executableusers_nodejs" style="color: inherit; text-decoration: inherit;">executable<wbr>Users</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="filters_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filters_nodejs" style="color: inherit; text-decoration: inherit;">filters</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#getamiidsfilter">Get<wbr>Ami<wbr>Ids<wbr>Filter[]</a></span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="nameregex_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nameregex_nodejs" style="color: inherit; text-decoration: inherit;">name<wbr>Regex</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="sortascending_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#sortascending_nodejs" style="color: inherit; text-decoration: inherit;">sort<wbr>Ascending</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">boolean</span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#id_python" style="color: inherit; text-decoration: inherit;">id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>The provider-assigned unique ID for this managed resource.</p>
</dd><dt class="property-"
            title="">
        <span id="ids_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#ids_python" style="color: inherit; text-decoration: inherit;">ids</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="owners_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#owners_python" style="color: inherit; text-decoration: inherit;">owners</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="executable_users_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#executable_users_python" style="color: inherit; text-decoration: inherit;">executable_<wbr>users</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="filters_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filters_python" style="color: inherit; text-decoration: inherit;">filters</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#getamiidsfilter">Sequence[Get<wbr>Ami<wbr>Ids<wbr>Filter]</a></span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="name_regex_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_regex_python" style="color: inherit; text-decoration: inherit;">name_<wbr>regex</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="sort_ascending_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#sort_ascending_python" style="color: inherit; text-decoration: inherit;">sort_<wbr>ascending</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#id_yaml" style="color: inherit; text-decoration: inherit;">id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>The provider-assigned unique ID for this managed resource.</p>
</dd><dt class="property-"
            title="">
        <span id="ids_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#ids_yaml" style="color: inherit; text-decoration: inherit;">ids</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="owners_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#owners_yaml" style="color: inherit; text-decoration: inherit;">owners</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="executableusers_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#executableusers_yaml" style="color: inherit; text-decoration: inherit;">executable<wbr>Users</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="filters_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filters_yaml" style="color: inherit; text-decoration: inherit;">filters</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#getamiidsfilter">List<Property Map></a></span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="nameregex_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nameregex_yaml" style="color: inherit; text-decoration: inherit;">name<wbr>Regex</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd></dd><dt class="property-"
            title="">
        <span id="sortascending_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#sortascending_yaml" style="color: inherit; text-decoration: inherit;">sort<wbr>Ascending</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Boolean</span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>




## Supporting Types


<h4 id="getamiidsfilter">Get<wbr>Ami<wbr>Ids<wbr>Filter</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_csharp" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="values_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#values_csharp" style="color: inherit; text-decoration: inherit;">Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_go" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="values_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#values_go" style="color: inherit; text-decoration: inherit;">Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_java" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="values_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#values_java" style="color: inherit; text-decoration: inherit;">values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_nodejs" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="values_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#values_nodejs" style="color: inherit; text-decoration: inherit;">values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_python" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="values_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#values_python" style="color: inherit; text-decoration: inherit;">values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_yaml" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="values_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#values_yaml" style="color: inherit; text-decoration: inherit;">values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>





<h2 id="package-details">Package Details</h2>
<dl class="package-details">
	<dt>Repository</dt>
	<dd><a href=""></a></dd>
	<dt>License</dt>
	<dd></dd>
</dl>

