// Copyright 2016-2018, Pulumi Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package fsutil

import (
	"os"
	"strings"

	"github.com/pulumi/pulumi/sdk/v3/go/common/tokens"
)

// QnamePath just cleans a name and makes sure it's appropriate to use as a path.
func QnamePath(nm tokens.QName) string {
	return strings.Replace(string(nm), tokens.QNameDelimiter, string(os.PathSeparator), -1)
}

// NamePath just cleans a name and makes sure it's appropriate to use as a path.
func NamePath(nm tokens.Name) string {
	// Currently this is a no-op because the set of chars allowed in a Name [A-Za-z0-9_.-] are also
	// valid file names
	return string(nm)
}
