package main

import (
	"github.com/pulumi/pulumi-azure/sdk/v3/go/azure/core"
	"github.com/pulumi/pulumi-azure/sdk/v3/go/azure/storage"
	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
)

func main() {
	pulumi.Run(func(ctx *pulumi.Context) error {
		cfg := config.New(ctx, "")
		storageAccountNameParam := cfg.Require("storageAccountNameParam")
		resourceGroupNameParam := cfg.Require("resourceGroupNameParam")
		resourceGroupVar, err := core.LookupResourceGroup(ctx, &core.LookupResourceGroupArgs{
			Name: resourceGroupNameParam,
		}, nil)
		if err != nil {
			return err
		}
		locationParam := resourceGroupVar.Location
		if param := cfg.Get("locationParam"); param != "" {
			locationParam = param
		}
		storageAccountTierParam := "Standard"
		if param := cfg.Get("storageAccountTierParam"); param != "" {
			storageAccountTierParam = param
		}
		storageAccountTypeReplicationParam := "LRS"
		if param := cfg.Get("storageAccountTypeReplicationParam"); param != "" {
			storageAccountTypeReplicationParam = param
		}
		storageAccountResource, err := storage.NewAccount(ctx, "storageAccountResource", &storage.AccountArgs{
			Name:                   pulumi.String(storageAccountNameParam),
			AccountKind:            pulumi.String("StorageV2"),
			Location:               pulumi.String(locationParam),
			ResourceGroupName:      pulumi.String(resourceGroupNameParam),
			AccountTier:            pulumi.String(storageAccountTierParam),
			AccountReplicationType: pulumi.String(storageAccountTypeReplicationParam),
		})
		if err != nil {
			return err
		}
		ctx.Export("storageAccountNameOut", storageAccountResource.Name)
		return nil
	})
}
