package python

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

var pyNameTests = []struct {
	input    string
	expected string
	legacy   string
}{
	{"kubeletConfigKey", "kubelet_config_key", "kubelet_config_key"},
	{"podCIDR", "pod_cidr", "pod_cidr"},
	{"podCidr", "pod_cidr", "pod_cidr"},
	{"podCIDRs", "pod_cidrs", "pod_cid_rs"},
	{"podIPs", "pod_ips", "pod_i_ps"},
	{"nonResourceURLs", "non_resource_urls", "non_resource_ur_ls"},
	{"someTHINGsAREWeird", "some_things_are_weird", "some_thin_gs_are_weird"},
	{"podCIDRSet", "pod_cidr_set", "pod_cidr_set"},
	{"Sha256Hash", "sha256_hash", "sha256_hash"},
	{"SHA256Hash", "sha256_hash", "sha256_hash"},
}

func TestPyName(t *testing.T) {
	for _, tt := range pyNameTests {
		t.Run(tt.input, func(t *testing.T) {
			result := PyName(tt.input)
			assert.Equal(t, tt.expected, result)
		})
	}
}

func TestPyNameLegacy(t *testing.T) {
	for _, tt := range pyNameTests {
		t.Run(tt.input, func(t *testing.T) {
			result := PyNameLegacy(tt.input)
			assert.Equal(t, tt.legacy, result)
		})
	}
}
