package retryablehttp

import (
	"io"
	"net/http"
)

type ContextOverride string

const (
	RETRY_MAX ContextOverride = "retry-max"
)

// Discard is an helper function that discards the response body and closes the underlying connection
func Discard(req *Request, resp *http.Response, RespReadLimit int64) {
	_, err := io.Copy(io.Discard, io.LimitReader(resp.Body, RespReadLimit))
	if err != nil {
		req.Metrics.DrainErrors++
	}
	resp.Body.Close()
}

// getLength returns length of a Reader efficiently
func getLength(x io.Reader) (int64, error) {
	len, err := io.Copy(io.Discard, x)
	return len, err
}
