//
// Code generated by rdl 1.5.2 DO NOT EDIT.
//

package zts

import (
	"log"

	rdl "github.com/ardielle/ardielle-go/rdl"
)

var schema *rdl.Schema

func init() {
	sb := rdl.NewSchemaBuilder("ZTS")
	sb.Version(1)
	sb.Namespace("com.yahoo.athenz.zts")
	sb.Comment("Copyright 2016 Yahoo Inc. Licensed under the terms of the Apache version 2.0 license. See LICENSE file for terms. The Authorization Token Service (ZTS) API")

	tSimpleName := rdl.NewStringTypeBuilder("SimpleName")
	tSimpleName.Comment("Copyright 2016 Yahoo Inc. Licensed under the terms of the Apache version 2.0 license. See LICENSE file for terms. Common name types used by several API definitions A simple identifier, an element of compound name.")
	tSimpleName.Pattern("[a-zA-Z0-9_][a-zA-Z0-9_-]*")
	sb.AddType(tSimpleName.Build())

	tCompoundName := rdl.NewStringTypeBuilder("CompoundName")
	tCompoundName.Comment("A compound name. Most names in this API are compound names.")
	tCompoundName.Pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*")
	sb.AddType(tCompoundName.Build())

	tDomainName := rdl.NewStringTypeBuilder("DomainName")
	tDomainName.Comment("A domain name is the general qualifier prefix, as its uniqueness is managed.")
	tDomainName.Pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*")
	sb.AddType(tDomainName.Build())

	tEntityName := rdl.NewStringTypeBuilder("EntityName")
	tEntityName.Comment("An entity name is a short form of a resource name, including only the domain and entity.")
	tEntityName.Pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*")
	sb.AddType(tEntityName.Build())

	tEntityList := rdl.NewStringTypeBuilder("EntityList")
	tEntityList.Comment("An Entity list is comma separated compound Names")
	tEntityList.Pattern("(([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*,)*([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*")
	sb.AddType(tEntityList.Build())

	tServiceName := rdl.NewStringTypeBuilder("ServiceName")
	tServiceName.Comment("A service name will generally be a unique subdomain.")
	tServiceName.Pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*")
	sb.AddType(tServiceName.Build())

	tActionName := rdl.NewStringTypeBuilder("ActionName")
	tActionName.Comment("An action (operation) name.")
	tActionName.Pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*")
	sb.AddType(tActionName.Build())

	tResourceName := rdl.NewStringTypeBuilder("ResourceName")
	tResourceName.Comment("A resource name Note that the EntityName part is optional, that is, a domain name followed by a colon is valid resource name.")
	tResourceName.Pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*(:([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*)?")
	sb.AddType(tResourceName.Build())

	tYBase64 := rdl.NewStringTypeBuilder("YBase64")
	tYBase64.Comment("The Y-specific URL-safe Base64 variant.")
	tYBase64.Pattern("[a-zA-Z0-9\\._-]+")
	sb.AddType(tYBase64.Build())

	tYEncoded := rdl.NewStringTypeBuilder("YEncoded")
	tYEncoded.Comment("YEncoded includes ybase64 chars, as well as = and %. This can represent a user cookie and URL-encoded values.")
	tYEncoded.Pattern("[a-zA-Z0-9\\._%=-]*")
	sb.AddType(tYEncoded.Build())

	tAuthorityName := rdl.NewStringTypeBuilder("AuthorityName")
	tAuthorityName.Comment("Used as the prefix in a signed assertion. This uniquely identifies a signing authority.")
	tAuthorityName.Pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*")
	sb.AddType(tAuthorityName.Build())

	tSignedToken := rdl.NewStringTypeBuilder("SignedToken")
	tSignedToken.Comment("A signed assertion if identity. i.e. the user cookie value. This token will only make sense to the authority that generated it, so it is beneficial to have something in the value that is cheaply recognized to quickly reject if it belongs to another authority. In addition to the YEncoded set our token includes ; to separate components and , to separate roles")
	tSignedToken.Pattern("[a-zA-Z0-9\\._%=;,-]*")
	sb.AddType(tSignedToken.Build())

	tPathElement := rdl.NewStringTypeBuilder("PathElement")
	tPathElement.Comment("A uri-safe path element")
	tPathElement.Pattern("[a-zA-Z0-9-\\._~=+@$,:]*")
	sb.AddType(tPathElement.Build())

	tCertType := rdl.NewEnumTypeBuilder("Enum", "CertType")
	tCertType.Comment("CertType denotes various types of certs issued by Athenz")
	tCertType.Element("X509", "TLS X.509 Certificate")
	tCertType.Element("SSH_HOST", "SSH Host certificate")
	tCertType.Element("SSH_USER", "SSH User certificate")
	sb.AddType(tCertType.Build())

	tResourceAccess := rdl.NewStructTypeBuilder("Struct", "ResourceAccess")
	tResourceAccess.Comment("ResourceAccess can be checked and returned as this resource. (same as ZMS.Access)")
	tResourceAccess.Field("granted", "Bool", false, nil, "true (allowed) or false (denied)")
	sb.AddType(tResourceAccess.Build())

	tPublicKeyEntry := rdl.NewStructTypeBuilder("Struct", "PublicKeyEntry")
	tPublicKeyEntry.Comment("The representation of the public key in a service identity object.")
	tPublicKeyEntry.Field("key", "String", false, nil, "the public key for the service")
	tPublicKeyEntry.Field("id", "String", false, nil, "the key identifier (version or zone name)")
	sb.AddType(tPublicKeyEntry.Build())

	tServiceIdentity := rdl.NewStructTypeBuilder("Struct", "ServiceIdentity")
	tServiceIdentity.Comment("The representation of the service identity object.")
	tServiceIdentity.Field("name", "ServiceName", false, nil, "the full name of the service, i.e. \"sports.storage\"")
	tServiceIdentity.ArrayField("publicKeys", "PublicKeyEntry", true, "array of public keys for key rotation")
	tServiceIdentity.Field("providerEndpoint", "String", true, nil, "if present, then this service can provision tenants via this endpoint.")
	tServiceIdentity.Field("modified", "Timestamp", true, nil, "the timestamp when this entry was last modified")
	tServiceIdentity.Field("executable", "String", true, nil, "the path of the executable that runs the service")
	tServiceIdentity.ArrayField("hosts", "String", true, "list of host names that this service can run on")
	tServiceIdentity.Field("user", "String", true, nil, "local (unix) user name this service can run as")
	tServiceIdentity.Field("group", "String", true, nil, "local (unix) group name this service can run as")
	sb.AddType(tServiceIdentity.Build())

	tServiceIdentityList := rdl.NewStructTypeBuilder("Struct", "ServiceIdentityList")
	tServiceIdentityList.Comment("The representation for an enumeration of services in the namespace.")
	tServiceIdentityList.ArrayField("names", "EntityName", false, "list of service names")
	sb.AddType(tServiceIdentityList.Build())

	tHostServices := rdl.NewStructTypeBuilder("Struct", "HostServices")
	tHostServices.Comment("The representation for an enumeration of services authorized to run on a specific host.")
	tHostServices.Field("host", "String", false, nil, "name of the host")
	tHostServices.ArrayField("names", "EntityName", false, "list of service names authorized to run on this host")
	sb.AddType(tHostServices.Build())

	tAssertionEffect := rdl.NewEnumTypeBuilder("Enum", "AssertionEffect")
	tAssertionEffect.Comment("Every assertion can have the effect of ALLOW or DENY.")
	tAssertionEffect.Element("ALLOW", "")
	tAssertionEffect.Element("DENY", "")
	sb.AddType(tAssertionEffect.Build())

	tAssertion := rdl.NewStructTypeBuilder("Struct", "Assertion")
	tAssertion.Comment("A representation for the encapsulation of an action to be performed on a resource by a principal.")
	tAssertion.Field("role", "String", false, nil, "the subject of the assertion, a role")
	tAssertion.Field("resource", "String", false, nil, "the object of the assertion. Must be in the local namespace. Can contain wildcards")
	tAssertion.Field("action", "String", false, nil, "the predicate of the assertion. Can contain wildcards")
	tAssertion.Field("effect", "AssertionEffect", true, ALLOW, "the effect of the assertion in the policy language")
	tAssertion.Field("id", "Int64", true, nil, "assertion id - auto generated by server")
	tAssertion.Field("caseSensitive", "Bool", true, nil, "If true, we should store action and resource in their original case")
	sb.AddType(tAssertion.Build())

	tPolicy := rdl.NewStructTypeBuilder("Struct", "Policy")
	tPolicy.Comment("The representation for a Policy with set of assertions.")
	tPolicy.Field("name", "ResourceName", false, nil, "name of the policy")
	tPolicy.Field("modified", "Timestamp", true, nil, "last modification timestamp of this policy")
	tPolicy.ArrayField("assertions", "Assertion", false, "list of defined assertions for this policy")
	tPolicy.Field("caseSensitive", "Bool", true, nil, "If true, we should store action and resource in their original case")
	sb.AddType(tPolicy.Build())

	tPolicyData := rdl.NewStructTypeBuilder("Struct", "PolicyData")
	tPolicyData.Field("domain", "DomainName", false, nil, "name of the domain")
	tPolicyData.ArrayField("policies", "Policy", false, "list of policies defined in this server")
	sb.AddType(tPolicyData.Build())

	tSignedPolicyData := rdl.NewStructTypeBuilder("Struct", "SignedPolicyData")
	tSignedPolicyData.Comment("A representation of policies object defined in a given server.")
	tSignedPolicyData.Field("policyData", "PolicyData", false, nil, "list of policies defined in a domain")
	tSignedPolicyData.Field("zmsSignature", "String", false, nil, "zms signature generated based on the domain policies object")
	tSignedPolicyData.Field("zmsKeyId", "String", false, nil, "the identifier of the zms key used to generate the signature")
	tSignedPolicyData.Field("modified", "Timestamp", false, nil, "when the domain itself was last modified")
	tSignedPolicyData.Field("expires", "Timestamp", false, nil, "timestamp specifying the expiration time for using this set of policies")
	sb.AddType(tSignedPolicyData.Build())

	tDomainSignedPolicyData := rdl.NewStructTypeBuilder("Struct", "DomainSignedPolicyData")
	tDomainSignedPolicyData.Comment("A signed bulk transfer of policies. The data is signed with server's private key.")
	tDomainSignedPolicyData.Field("signedPolicyData", "SignedPolicyData", false, nil, "policy data signed by ZMS")
	tDomainSignedPolicyData.Field("signature", "String", false, nil, "signature generated based on the domain policies object")
	tDomainSignedPolicyData.Field("keyId", "String", false, nil, "the identifier of the key used to generate the signature")
	sb.AddType(tDomainSignedPolicyData.Build())

	tRoleToken := rdl.NewStructTypeBuilder("Struct", "RoleToken")
	tRoleToken.Comment("A representation of a signed RoleToken")
	tRoleToken.Field("token", "String", false, nil, "")
	tRoleToken.Field("expiryTime", "Int64", false, nil, "")
	sb.AddType(tRoleToken.Build())

	tRoleCertificateRequest := rdl.NewStructTypeBuilder("Struct", "RoleCertificateRequest")
	tRoleCertificateRequest.Comment("RoleCertificateRequest - a certificate signing request")
	tRoleCertificateRequest.Field("csr", "String", false, nil, "")
	tRoleCertificateRequest.Field("proxyForPrincipal", "EntityName", true, nil, "this request is proxy for this principal")
	tRoleCertificateRequest.Field("expiryTime", "Int64", false, nil, "")
	sb.AddType(tRoleCertificateRequest.Build())

	tAccess := rdl.NewStructTypeBuilder("Struct", "Access")
	tAccess.Comment("Access can be checked and returned as this resource.")
	tAccess.Field("granted", "Bool", false, nil, "true (allowed) or false (denied)")
	sb.AddType(tAccess.Build())

	tRoleAccess := rdl.NewStructTypeBuilder("Struct", "RoleAccess")
	tRoleAccess.ArrayField("roles", "EntityName", false, "")
	sb.AddType(tRoleAccess.Build())

	tTenantDomains := rdl.NewStructTypeBuilder("Struct", "TenantDomains")
	tTenantDomains.ArrayField("tenantDomainNames", "DomainName", false, "")
	sb.AddType(tTenantDomains.Build())

	tIdentity := rdl.NewStructTypeBuilder("Struct", "Identity")
	tIdentity.Comment("Identity - a signed assertion of service or human identity, the response could be either a client certificate or just a regular NToken (depending if the request contained a csr or not).")
	tIdentity.Field("name", "CompoundName", false, nil, "name of the identity, fully qualified, i.e. my.domain.service1, or aws.1232321321312.myusername")
	tIdentity.Field("certificate", "String", true, nil, "a certificate usable for both client and server in TLS connections")
	tIdentity.Field("caCertBundle", "String", true, nil, "the CA certificate chain to use with all IMS-generated certs")
	tIdentity.Field("sshCertificate", "String", true, nil, "the SSH certificate, signed by the CA (user or host)")
	tIdentity.Field("sshCertificateSigner", "String", true, nil, "the SSH CA's public key for the sshCertificate (user or host)")
	tIdentity.Field("serviceToken", "SignedToken", true, nil, "service token instead of TLS certificate")
	tIdentity.MapField("attributes", "String", "String", true, "other config-like attributes determined at boot time")
	sb.AddType(tIdentity.Build())

	tInstanceRefreshRequest := rdl.NewStructTypeBuilder("Struct", "InstanceRefreshRequest")
	tInstanceRefreshRequest.Comment("InstanceRefreshRequest - a certificate refresh request")
	tInstanceRefreshRequest.Field("csr", "String", false, nil, "Cert CSR signed by the service's private key (public key registered in ZMS)")
	tInstanceRefreshRequest.Field("expiryTime", "Int32", true, nil, "in minutes how long token should be valid for")
	tInstanceRefreshRequest.Field("keyId", "String", true, nil, "public key identifier")
	sb.AddType(tInstanceRefreshRequest.Build())

	tAWSRoleName := rdl.NewStringTypeBuilder("AWSRoleName")
	tAWSRoleName.Comment("AWS role name without the path")
	tAWSRoleName.Pattern("[a-zA-Z0-9-\\._=+@,]*")
	sb.AddType(tAWSRoleName.Build())

	tAWSRolePathElement := rdl.NewStringTypeBuilder("AWSRolePathElement")
	tAWSRolePathElement.Comment("AWS role path single element")
	tAWSRolePathElement.Pattern("[a-zA-Z0-9][a-zA-Z0-9-\\._]*")
	sb.AddType(tAWSRolePathElement.Build())

	tAWSRolePath := rdl.NewStringTypeBuilder("AWSRolePath")
	tAWSRolePath.Comment("AWS role path")
	tAWSRolePath.Pattern("([a-zA-Z0-9][a-zA-Z0-9-\\._]*/)+")
	sb.AddType(tAWSRolePath.Build())

	tAWSArnRoleName := rdl.NewStringTypeBuilder("AWSArnRoleName")
	tAWSArnRoleName.Comment("AWS full role name with path")
	tAWSArnRoleName.Pattern("(([a-zA-Z0-9][a-zA-Z0-9-\\._]*/)+)*[a-zA-Z0-9-\\._=+@,]*")
	sb.AddType(tAWSArnRoleName.Build())

	tAWSTemporaryCredentials := rdl.NewStructTypeBuilder("Struct", "AWSTemporaryCredentials")
	tAWSTemporaryCredentials.Field("accessKeyId", "String", false, nil, "")
	tAWSTemporaryCredentials.Field("secretAccessKey", "String", false, nil, "")
	tAWSTemporaryCredentials.Field("sessionToken", "String", false, nil, "")
	tAWSTemporaryCredentials.Field("expiration", "Timestamp", false, nil, "")
	sb.AddType(tAWSTemporaryCredentials.Build())

	tInstanceRegisterInformation := rdl.NewStructTypeBuilder("Struct", "InstanceRegisterInformation")
	tInstanceRegisterInformation.Field("provider", "ServiceName", false, nil, "the provider service name (i.e. \"aws.us-west-2\", \"sys.openstack.cluster1\")")
	tInstanceRegisterInformation.Field("domain", "DomainName", false, nil, "the domain of the instance")
	tInstanceRegisterInformation.Field("service", "SimpleName", false, nil, "the service this instance is supposed to run")
	tInstanceRegisterInformation.Field("attestationData", "String", false, nil, "identity attestation data including document with its signature containing attributes like IP address, instance-id, account#, etc.")
	tInstanceRegisterInformation.Field("csr", "String", false, nil, "the Certificate Signing Request for the expected X.509 certificate in the response")
	tInstanceRegisterInformation.Field("ssh", "String", true, nil, "if present, return an SSH host certificate. Format is JSON.")
	tInstanceRegisterInformation.Field("token", "Bool", true, nil, "if true, return a service token signed by ZTS for this service")
	tInstanceRegisterInformation.Field("expiryTime", "Int32", true, nil, "expiry time in minutes for the certificate (server enforces max expiry)")
	tInstanceRegisterInformation.Field("hostname", "DomainName", true, nil, "optional hostname in case included in the csr SAN dnsName attribute")
	tInstanceRegisterInformation.ArrayField("hostCnames", "DomainName", true, "optional host CNAMEs included in the csr SAN dnsName attribute")
	sb.AddType(tInstanceRegisterInformation.Build())

	tInstanceRefreshInformation := rdl.NewStructTypeBuilder("Struct", "InstanceRefreshInformation")
	tInstanceRefreshInformation.Field("attestationData", "String", true, nil, "identity attestation data including document with its signature containing attributes like IP address, instance-id, account#, etc.")
	tInstanceRefreshInformation.Field("csr", "String", true, nil, "the Certificate Signing Request for the expected X.509 certificate in the response")
	tInstanceRefreshInformation.Field("ssh", "String", true, nil, "if present, return an SSH host certificate. Format is JSON.")
	tInstanceRefreshInformation.Field("token", "Bool", true, nil, "if true, return a service token signed by ZTS for this service")
	tInstanceRefreshInformation.Field("expiryTime", "Int32", true, nil, "expiry time in minutes for the certificate (server enforces max expiry)")
	tInstanceRefreshInformation.Field("hostname", "DomainName", true, nil, "optional hostname in case included in the csr SAN dnsName attribute")
	tInstanceRefreshInformation.ArrayField("hostCnames", "DomainName", true, "optional host CNAMEs included in the csr SAN dnsName attribute")
	sb.AddType(tInstanceRefreshInformation.Build())

	tInstanceRegisterToken := rdl.NewStructTypeBuilder("Struct", "InstanceRegisterToken")
	tInstanceRegisterToken.Field("provider", "ServiceName", false, nil, "provider service name")
	tInstanceRegisterToken.Field("domain", "DomainName", false, nil, "the domain of the instance")
	tInstanceRegisterToken.Field("service", "SimpleName", false, nil, "the service this instance is supposed to run")
	tInstanceRegisterToken.Field("attestationData", "String", false, nil, "identity attestation data including document with its signature containing attributes like IP address, instance-id, account#, etc.")
	tInstanceRegisterToken.MapField("attributes", "String", "String", true, "additional non-signed attributes that assist in attestation. I.e. \"keyId\", \"accessKey\", etc")
	sb.AddType(tInstanceRegisterToken.Build())

	tInstanceIdentity := rdl.NewStructTypeBuilder("Struct", "InstanceIdentity")
	tInstanceIdentity.Field("provider", "ServiceName", false, nil, "the provider service name (i.e. \"aws.us-west-2\", \"sys.openstack.cluster1\")")
	tInstanceIdentity.Field("name", "ServiceName", false, nil, "name of the identity, fully qualified, i.e. my.domain.service1")
	tInstanceIdentity.Field("instanceId", "PathElement", false, nil, "unique instance id within provider's namespace")
	tInstanceIdentity.Field("x509Certificate", "String", true, nil, "an X.509 certificate usable for both client and server in TLS connections")
	tInstanceIdentity.Field("x509CertificateSigner", "String", true, nil, "the CA certificate chain to verify all generated X.509 certs")
	tInstanceIdentity.Field("sshCertificate", "String", true, nil, "the SSH certificate, signed by the CA (user or host)")
	tInstanceIdentity.Field("sshCertificateSigner", "String", true, nil, "the SSH CA's public key for the sshCertificate (user or host)")
	tInstanceIdentity.Field("serviceToken", "SignedToken", true, nil, "service token instead of TLS certificate")
	tInstanceIdentity.MapField("attributes", "String", "String", true, "other config-like attributes determined at boot time")
	sb.AddType(tInstanceIdentity.Build())

	tCertificateAuthorityBundle := rdl.NewStructTypeBuilder("Struct", "CertificateAuthorityBundle")
	tCertificateAuthorityBundle.Field("name", "SimpleName", false, nil, "name of the bundle")
	tCertificateAuthorityBundle.Field("certs", "String", false, nil, "set of certificates included in the bundle")
	sb.AddType(tCertificateAuthorityBundle.Build())

	tDomainMetricType := rdl.NewEnumTypeBuilder("Enum", "DomainMetricType")
	tDomainMetricType.Comment("zpe metric attributes")
	tDomainMetricType.Element("ACCESS_ALLOWED", "")
	tDomainMetricType.Element("ACCESS_ALLOWED_DENY", "")
	tDomainMetricType.Element("ACCESS_ALLOWED_DENY_NO_MATCH", "")
	tDomainMetricType.Element("ACCESS_ALLOWED_ALLOW", "")
	tDomainMetricType.Element("ACCESS_ALLOWED_ERROR", "")
	tDomainMetricType.Element("ACCESS_ALLOWED_TOKEN_INVALID", "")
	tDomainMetricType.Element("ACCESS_Allowed_TOKEN_EXPIRED", "")
	tDomainMetricType.Element("ACCESS_ALLOWED_DOMAIN_NOT_FOUND", "")
	tDomainMetricType.Element("ACCESS_ALLOWED_DOMAIN_MISMATCH", "")
	tDomainMetricType.Element("ACCESS_ALLOWED_DOMAIN_EXPIRED", "")
	tDomainMetricType.Element("ACCESS_ALLOWED_DOMAIN_EMPTY", "")
	tDomainMetricType.Element("ACCESS_ALLOWED_TOKEN_CACHE_FAILURE", "")
	tDomainMetricType.Element("ACCESS_ALLOWED_TOKEN_CACHE_NOT_FOUND", "")
	tDomainMetricType.Element("ACCESS_ALLOWED_TOKEN_CACHE_SUCCESS", "")
	tDomainMetricType.Element("ACCESS_ALLOWED_TOKEN_VALIDATE", "")
	tDomainMetricType.Element("LOAD_FILE_FAIL", "")
	tDomainMetricType.Element("LOAD_FILE_GOOD", "")
	tDomainMetricType.Element("LOAD_DOMAIN_GOOD", "")
	sb.AddType(tDomainMetricType.Build())

	tDomainMetric := rdl.NewStructTypeBuilder("Struct", "DomainMetric")
	tDomainMetric.Field("metricType", "DomainMetricType", false, nil, "")
	tDomainMetric.Field("metricVal", "Int32", false, nil, "")
	sb.AddType(tDomainMetric.Build())

	tDomainMetrics := rdl.NewStructTypeBuilder("Struct", "DomainMetrics")
	tDomainMetrics.Field("domainName", "DomainName", false, nil, "name of the domain the metrics pertain to")
	tDomainMetrics.ArrayField("metricList", "DomainMetric", false, "list of the domains metrics")
	sb.AddType(tDomainMetrics.Build())

	tStatus := rdl.NewStructTypeBuilder("Struct", "Status")
	tStatus.Comment("The representation for a status object")
	tStatus.Field("code", "Int32", false, nil, "status message code")
	tStatus.Field("message", "String", false, nil, "status message of the server")
	sb.AddType(tStatus.Build())

	tSSHCertRequestData := rdl.NewStructTypeBuilder("Struct", "SSHCertRequestData")
	tSSHCertRequestData.ArrayField("principals", "String", false, "principals in the ssh certificate (usually only one)")
	tSSHCertRequestData.ArrayField("sources", "String", true, "source FQDNs or ip addresses")
	tSSHCertRequestData.ArrayField("destinations", "String", true, "destination FQDNs or ip addresses")
	tSSHCertRequestData.Field("publicKey", "String", true, nil, "public key for ssh certificate")
	tSSHCertRequestData.Field("touchPublicKey", "String", true, nil, "yubikey/touch public key for ssh certificate")
	sb.AddType(tSSHCertRequestData.Build())

	tSSHCertRequestMeta := rdl.NewStructTypeBuilder("Struct", "SSHCertRequestMeta")
	tSSHCertRequestMeta.Field("requestor", "String", false, nil, "requesting user")
	tSSHCertRequestMeta.Field("origin", "String", false, nil, "origin FQDN or ip")
	tSSHCertRequestMeta.Field("clientInfo", "String", true, nil, "client info")
	tSSHCertRequestMeta.Field("sshClientVersion", "String", true, nil, "ssh client version")
	tSSHCertRequestMeta.Field("certType", "String", false, nil, "cert type - user or host")
	tSSHCertRequestMeta.Field("athenzService", "EntityName", true, nil, "ssh host cert request is for this athenz service")
	tSSHCertRequestMeta.Field("instanceId", "PathElement", true, nil, "ssh host cert request is for this instance id")
	sb.AddType(tSSHCertRequestMeta.Build())

	tSSHCertRequest := rdl.NewStructTypeBuilder("Struct", "SSHCertRequest")
	tSSHCertRequest.Field("certRequestData", "SSHCertRequestData", false, nil, "ssh certificate request data")
	tSSHCertRequest.Field("certRequestMeta", "SSHCertRequestMeta", false, nil, "ssh certificate request meta")
	tSSHCertRequest.Field("csr", "String", true, nil, "free-form csr if not using data/meta fields.")
	sb.AddType(tSSHCertRequest.Build())

	tSSHCertificate := rdl.NewStructTypeBuilder("Struct", "SSHCertificate")
	tSSHCertificate.Field("certificate", "String", false, nil, "the SSH certificate, signed by the CA")
	tSSHCertificate.Field("publicKey", "String", true, nil, "certificate public key if generated by SSH RA")
	tSSHCertificate.Field("privateKey", "String", true, nil, "certificate private key if generated by SSH Agent")
	sb.AddType(tSSHCertificate.Build())

	tSSHCertificates := rdl.NewStructTypeBuilder("Struct", "SSHCertificates")
	tSSHCertificates.ArrayField("certificates", "SSHCertificate", false, "set of user ssh certificates")
	tSSHCertificates.Field("certificateSigner", "String", true, nil, "the SSH CA's public key for the sshCertificate (user or host)")
	sb.AddType(tSSHCertificates.Build())

	tAccessTokenResponse := rdl.NewStructTypeBuilder("Struct", "AccessTokenResponse")
	tAccessTokenResponse.Field("access_token", "String", false, nil, "access token")
	tAccessTokenResponse.Field("token_type", "String", false, nil, "token type e.g. Bearer")
	tAccessTokenResponse.Field("expires_in", "Int32", true, nil, "expiration in seconds")
	tAccessTokenResponse.Field("scope", "String", true, nil, "scope of the access token e.g. openid")
	tAccessTokenResponse.Field("refresh_token", "String", true, nil, "refresh token")
	tAccessTokenResponse.Field("id_token", "String", true, nil, "id token")
	sb.AddType(tAccessTokenResponse.Build())

	tJWK := rdl.NewStructTypeBuilder("Struct", "JWK")
	tJWK.Field("kty", "String", false, nil, "key type: EC or RSA")
	tJWK.Field("kid", "String", false, nil, "identifier")
	tJWK.Field("alg", "String", true, nil, "key algorithm")
	tJWK.Field("use", "String", true, nil, "usage: sig or enc")
	tJWK.Field("crv", "String", true, nil, "ec curve name")
	tJWK.Field("x", "String", true, nil, "ec x value")
	tJWK.Field("y", "String", true, nil, "ec y value")
	tJWK.Field("n", "String", true, nil, "rsa modulus value")
	tJWK.Field("e", "String", true, nil, "rsa public exponent value")
	sb.AddType(tJWK.Build())

	tJWKList := rdl.NewStructTypeBuilder("Struct", "JWKList")
	tJWKList.Comment("JSON Web Key (JWK) List")
	tJWKList.ArrayField("keys", "JWK", false, "array of JWKs")
	sb.AddType(tJWKList.Build())

	tAccessTokenRequest := rdl.NewAliasTypeBuilder("String", "AccessTokenRequest")
	sb.AddType(tAccessTokenRequest.Build())

	tRoleCertificate := rdl.NewStructTypeBuilder("Struct", "RoleCertificate")
	tRoleCertificate.Comment("Copyright 2019 Oath Holdings Inc Licensed under the terms of the Apache version 2.0 license. See LICENSE file for terms. RoleCertificate - a role certificate")
	tRoleCertificate.Field("x509Certificate", "String", false, nil, "")
	sb.AddType(tRoleCertificate.Build())

	tWorkload := rdl.NewStructTypeBuilder("Struct", "Workload")
	tWorkload.Field("domainName", "DomainName", false, nil, "name of the domain, optional for getWorkloadsByService API call")
	tWorkload.Field("serviceName", "EntityName", false, nil, "name of the service, , optional for getWorkloadsByService API call")
	tWorkload.Field("uuid", "String", false, nil, "unique identifier for the workload, usually defined by provider")
	tWorkload.ArrayField("ipAddresses", "String", false, "list of IP addresses associated with the workload, optional for getWorkloadsByIP API call")
	tWorkload.Field("hostname", "String", false, nil, "hostname associated with the workload")
	tWorkload.Field("provider", "String", false, nil, "infrastructure provider e.g. k8s, AWS, Azure, openstack etc.")
	tWorkload.Field("updateTime", "Timestamp", false, nil, "most recent update timestamp in the backend")
	tWorkload.Field("certExpiryTime", "Timestamp", false, nil, "certificate expiry time (ex: getNotAfter)")
	sb.AddType(tWorkload.Build())

	tWorkloads := rdl.NewStructTypeBuilder("Struct", "Workloads")
	tWorkloads.ArrayField("workloadList", "Workload", false, "list of workloads")
	sb.AddType(tWorkloads.Build())

	tTransportDirection := rdl.NewEnumTypeBuilder("Enum", "TransportDirection")
	tTransportDirection.Comment("Copyright The Athenz Authors Licensed under the terms of the Apache version 2.0 license. See LICENSE file for terms.")
	tTransportDirection.Element("IN", "")
	tTransportDirection.Element("OUT", "")
	sb.AddType(tTransportDirection.Build())

	tTransportRule := rdl.NewStructTypeBuilder("Struct", "TransportRule")
	tTransportRule.Field("endPoint", "String", false, nil, "source or destination endpoints defined in terms of CIDR notation")
	tTransportRule.Field("sourcePortRange", "String", false, nil, "range of port numbers for incoming connections")
	tTransportRule.Field("port", "Int32", false, nil, "destination / listener port of the service")
	tTransportRule.Field("protocol", "String", false, nil, "protocol of the connection")
	tTransportRule.Field("direction", "TransportDirection", false, nil, "transport direction")
	sb.AddType(tTransportRule.Build())

	tTransportRules := rdl.NewStructTypeBuilder("Struct", "TransportRules")
	tTransportRules.ArrayField("ingressRules", "TransportRule", false, "")
	tTransportRules.ArrayField("egressRules", "TransportRule", false, "")
	sb.AddType(tTransportRules.Build())

	mGetResourceAccess := rdl.NewResourceBuilder("ResourceAccess", "GET", "/access/{action}/{resource}")
	mGetResourceAccess.Comment("Check access for the specified operation on the specified resource for the currently authenticated user. This is the slow centralized access for control-plane purposes. Use distributed mechanisms for decentralized (data-plane) access by fetching signed policies and role tokens for users. With this endpoint the resource is part of the uri and restricted to its strict definition of resource name. If needed, you can use the GetAccessExt api that allows resource name to be less restrictive.")
	mGetResourceAccess.Input("action", "ActionName", true, "", "", false, nil, "action as specified in the policy assertion, i.e. update or read")
	mGetResourceAccess.Input("resource", "ResourceName", true, "", "", false, nil, "the resource to check access against, i.e. \"media.news:articles\"")
	mGetResourceAccess.Input("domain", "DomainName", false, "domain", "", true, nil, "usually null. If present, it specifies an alternate domain for cross-domain trust relation")
	mGetResourceAccess.Input("checkPrincipal", "EntityName", false, "principal", "", true, nil, "usually null. If present, carry out the access check for this principal")
	mGetResourceAccess.Auth("", "", true, "")
	mGetResourceAccess.Exception("BAD_REQUEST", "ResourceError", "")
	mGetResourceAccess.Exception("FORBIDDEN", "ResourceError", "")
	mGetResourceAccess.Exception("NOT_FOUND", "ResourceError", "")
	mGetResourceAccess.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mGetResourceAccess.Build())

	mGetResourceAccessExt := rdl.NewResourceBuilder("ResourceAccess", "GET", "/access/{action}")
	mGetResourceAccessExt.Comment("Check access for the specified operation on the specified resource for the currently authenticated user. This is the slow centralized access for control-plane purposes.")
	mGetResourceAccessExt.Name("GetResourceAccessExt")
	mGetResourceAccessExt.Input("action", "ActionName", true, "", "", false, nil, "action as specified in the policy assertion, i.e. update or read")
	mGetResourceAccessExt.Input("resource", "String", false, "resource", "", false, nil, "the resource to check access against, i.e. \"media.news:articles\"")
	mGetResourceAccessExt.Input("domain", "DomainName", false, "domain", "", true, nil, "usually null. If present, it specifies an alternate domain for cross-domain trust relation")
	mGetResourceAccessExt.Input("checkPrincipal", "EntityName", false, "principal", "", true, nil, "usually null. If present, carry out the access check for this principal")
	mGetResourceAccessExt.Auth("", "", true, "")
	mGetResourceAccessExt.Exception("BAD_REQUEST", "ResourceError", "")
	mGetResourceAccessExt.Exception("FORBIDDEN", "ResourceError", "")
	mGetResourceAccessExt.Exception("NOT_FOUND", "ResourceError", "")
	mGetResourceAccessExt.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mGetResourceAccessExt.Build())

	mGetServiceIdentity := rdl.NewResourceBuilder("ServiceIdentity", "GET", "/domain/{domainName}/service/{serviceName}")
	mGetServiceIdentity.Comment("Get info for the specified ServiceIdentity.")
	mGetServiceIdentity.Input("domainName", "DomainName", true, "", "", false, nil, "name of the domain")
	mGetServiceIdentity.Input("serviceName", "ServiceName", true, "", "", false, nil, "name of the service to be retrieved")
	mGetServiceIdentity.Auth("", "", true, "")
	mGetServiceIdentity.Exception("BAD_REQUEST", "ResourceError", "")
	mGetServiceIdentity.Exception("NOT_FOUND", "ResourceError", "")
	mGetServiceIdentity.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mGetServiceIdentity.Build())

	mGetServiceIdentityList := rdl.NewResourceBuilder("ServiceIdentityList", "GET", "/domain/{domainName}/service")
	mGetServiceIdentityList.Comment("Enumerate services provisioned in this domain.")
	mGetServiceIdentityList.Input("domainName", "DomainName", true, "", "", false, nil, "name of the domain")
	mGetServiceIdentityList.Auth("", "", true, "")
	mGetServiceIdentityList.Exception("BAD_REQUEST", "ResourceError", "")
	mGetServiceIdentityList.Exception("NOT_FOUND", "ResourceError", "")
	mGetServiceIdentityList.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mGetServiceIdentityList.Build())

	mGetPublicKeyEntry := rdl.NewResourceBuilder("PublicKeyEntry", "GET", "/domain/{domainName}/service/{serviceName}/publickey/{keyId}")
	mGetPublicKeyEntry.Comment("Retrieve the specified public key from the service.")
	mGetPublicKeyEntry.Input("domainName", "DomainName", true, "", "", false, nil, "name of the domain")
	mGetPublicKeyEntry.Input("serviceName", "SimpleName", true, "", "", false, nil, "name of the service")
	mGetPublicKeyEntry.Input("keyId", "String", true, "", "", false, nil, "the identifier of the public key to be retrieved")
	mGetPublicKeyEntry.Auth("", "", true, "")
	mGetPublicKeyEntry.Exception("BAD_REQUEST", "ResourceError", "")
	mGetPublicKeyEntry.Exception("NOT_FOUND", "ResourceError", "")
	sb.AddResource(mGetPublicKeyEntry.Build())

	mGetHostServices := rdl.NewResourceBuilder("HostServices", "GET", "/host/{host}/services")
	mGetHostServices.Comment("Enumerate services provisioned on a specific host")
	mGetHostServices.Input("host", "String", true, "", "", false, nil, "name of the host")
	mGetHostServices.Auth("", "", true, "")
	mGetHostServices.Exception("BAD_REQUEST", "ResourceError", "")
	sb.AddResource(mGetHostServices.Build())

	mGetDomainSignedPolicyData := rdl.NewResourceBuilder("DomainSignedPolicyData", "GET", "/domain/{domainName}/signed_policy_data")
	mGetDomainSignedPolicyData.Comment("Get a signed policy enumeration from the service, to transfer to a local store. An ETag is generated for the PolicyList that changes when any item in the list changes. If the If-None-Match header is provided, and it matches the ETag that would be returned, then a NOT_MODIFIED response is returned instead of the list.")
	mGetDomainSignedPolicyData.Input("domainName", "DomainName", true, "", "", false, nil, "name of the domain")
	mGetDomainSignedPolicyData.Input("matchingTag", "String", false, "", "If-None-Match", false, nil, "Retrieved from the previous request, this timestamp specifies to the server to return any policies modified since this time")
	mGetDomainSignedPolicyData.Output("tag", "String", "ETag", false, "The current latest modification timestamp is returned in this header")
	mGetDomainSignedPolicyData.Auth("", "", true, "")
	mGetDomainSignedPolicyData.Exception("BAD_REQUEST", "ResourceError", "")
	mGetDomainSignedPolicyData.Exception("NOT_FOUND", "ResourceError", "")
	sb.AddResource(mGetDomainSignedPolicyData.Build())

	mGetRoleToken := rdl.NewResourceBuilder("RoleToken", "GET", "/domain/{domainName}/token")
	mGetRoleToken.Comment("Return a security token for the specific role in the namespace that the principal can assume. If the role is omitted, then all roles in the namespace that the authenticated user can assume are returned. the caller can specify how long the RoleToken should be valid for by specifying the minExpiryTime and maxExpiryTime parameters. The minExpiryTime specifies that the returned RoleToken must be at least valid (min/lower bound) for specified number of seconds, while maxExpiryTime specifies that the RoleToken must be at most valid (max/upper bound) for specified number of seconds. If both values are the same, the server must return a RoleToken for that many seconds. If no values are specified, the server's default RoleToken Timeout value is used.")
	mGetRoleToken.Input("domainName", "DomainName", true, "", "", false, nil, "name of the domain")
	mGetRoleToken.Input("role", "EntityList", false, "role", "", true, nil, "only interested for a token for these comma separated roles")
	mGetRoleToken.Input("minExpiryTime", "Int32", false, "minExpiryTime", "", true, nil, "in seconds min expiry time")
	mGetRoleToken.Input("maxExpiryTime", "Int32", false, "maxExpiryTime", "", true, nil, "in seconds max expiry time")
	mGetRoleToken.Input("proxyForPrincipal", "EntityName", false, "proxyForPrincipal", "", true, nil, "optional this request is proxy for this principal")
	mGetRoleToken.Auth("", "", true, "")
	mGetRoleToken.Exception("BAD_REQUEST", "ResourceError", "")
	mGetRoleToken.Exception("FORBIDDEN", "ResourceError", "")
	mGetRoleToken.Exception("NOT_FOUND", "ResourceError", "")
	mGetRoleToken.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mGetRoleToken.Build())

	mPostRoleCertificateRequest := rdl.NewResourceBuilder("RoleToken", "POST", "/domain/{domainName}/role/{roleName}/token")
	mPostRoleCertificateRequest.Comment("Return a TLS certificate for the specific role in the namespace that the principal can assume. Role certificates are valid for 30 days by default. This is deprecated and \"POST /rolecert\" api should be used instead.")
	mPostRoleCertificateRequest.Input("domainName", "DomainName", true, "", "", false, nil, "name of the domain")
	mPostRoleCertificateRequest.Input("roleName", "EntityName", true, "", "", false, nil, "name of role")
	mPostRoleCertificateRequest.Input("req", "RoleCertificateRequest", false, "", "", false, nil, "csr request")
	mPostRoleCertificateRequest.Auth("", "", true, "")
	mPostRoleCertificateRequest.Exception("BAD_REQUEST", "ResourceError", "")
	mPostRoleCertificateRequest.Exception("FORBIDDEN", "ResourceError", "")
	mPostRoleCertificateRequest.Exception("NOT_FOUND", "ResourceError", "")
	mPostRoleCertificateRequest.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mPostRoleCertificateRequest.Build())

	mGetAccess := rdl.NewResourceBuilder("Access", "GET", "/access/domain/{domainName}/role/{roleName}/principal/{principal}")
	mGetAccess.Input("domainName", "DomainName", true, "", "", false, nil, "name of the domain")
	mGetAccess.Input("roleName", "EntityName", true, "", "", false, nil, "name of the role to check access for")
	mGetAccess.Input("principal", "EntityName", true, "", "", false, nil, "carry out the access check for this principal")
	mGetAccess.Auth("", "", true, "")
	mGetAccess.Exception("BAD_REQUEST", "ResourceError", "")
	mGetAccess.Exception("FORBIDDEN", "ResourceError", "")
	mGetAccess.Exception("NOT_FOUND", "ResourceError", "")
	mGetAccess.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mGetAccess.Build())

	mGetRoleAccess := rdl.NewResourceBuilder("RoleAccess", "GET", "/access/domain/{domainName}/principal/{principal}")
	mGetRoleAccess.Input("domainName", "DomainName", true, "", "", false, nil, "name of the domain")
	mGetRoleAccess.Input("principal", "EntityName", true, "", "", false, nil, "carry out the role access lookup for this principal")
	mGetRoleAccess.Auth("", "", true, "")
	mGetRoleAccess.Exception("BAD_REQUEST", "ResourceError", "")
	mGetRoleAccess.Exception("NOT_FOUND", "ResourceError", "")
	mGetRoleAccess.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mGetRoleAccess.Build())

	mGetTenantDomains := rdl.NewResourceBuilder("TenantDomains", "GET", "/providerdomain/{providerDomainName}/user/{userName}")
	mGetTenantDomains.Comment("Get list of tenant domains user has access to for specified provider domain and service")
	mGetTenantDomains.Input("providerDomainName", "DomainName", true, "", "", false, nil, "name of the provider domain")
	mGetTenantDomains.Input("userName", "EntityName", true, "", "", false, nil, "name of the user to retrieve tenant domain access for")
	mGetTenantDomains.Input("roleName", "EntityName", false, "roleName", "", true, nil, "role name to filter on when looking for the tenants in provider")
	mGetTenantDomains.Input("serviceName", "ServiceName", false, "serviceName", "", true, nil, "service name to filter on when looking for the tenants in provider")
	mGetTenantDomains.Auth("", "", true, "")
	mGetTenantDomains.Exception("BAD_REQUEST", "ResourceError", "")
	mGetTenantDomains.Exception("NOT_FOUND", "ResourceError", "")
	mGetTenantDomains.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mGetTenantDomains.Build())

	mPostInstanceRefreshRequest := rdl.NewResourceBuilder("Identity", "POST", "/instance/{domain}/{service}/refresh")
	mPostInstanceRefreshRequest.Comment("Refresh Service tokens into TLS Certificate")
	mPostInstanceRefreshRequest.Input("domain", "CompoundName", true, "", "", false, nil, "name of the domain requesting the refresh")
	mPostInstanceRefreshRequest.Input("service", "SimpleName", true, "", "", false, nil, "name of the service requesting the refresh")
	mPostInstanceRefreshRequest.Input("req", "InstanceRefreshRequest", false, "", "", false, nil, "the refresh request")
	mPostInstanceRefreshRequest.Auth("", "", true, "")
	mPostInstanceRefreshRequest.Exception("BAD_REQUEST", "ResourceError", "")
	mPostInstanceRefreshRequest.Exception("FORBIDDEN", "ResourceError", "")
	mPostInstanceRefreshRequest.Exception("INTERNAL_SERVER_ERROR", "ResourceError", "")
	mPostInstanceRefreshRequest.Exception("NOT_FOUND", "ResourceError", "")
	mPostInstanceRefreshRequest.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mPostInstanceRefreshRequest.Build())

	mGetAWSTemporaryCredentials := rdl.NewResourceBuilder("AWSTemporaryCredentials", "GET", "/domain/{domainName}/role/{role}/creds")
	mGetAWSTemporaryCredentials.Comment("perform an AWS AssumeRole of the target role and return the credentials. ZTS must have been granted the ability to assume the role in IAM, and granted the ability to assume_aws_role in Athenz for this to succeed.")
	mGetAWSTemporaryCredentials.Input("domainName", "DomainName", true, "", "", false, nil, "name of the domain containing the role, which implies the target account")
	mGetAWSTemporaryCredentials.Input("role", "AWSArnRoleName", true, "", "", false, nil, "the target AWS role name in the domain account, in Athenz terms, i.e. \"the.role\"")
	mGetAWSTemporaryCredentials.Input("durationSeconds", "Int32", false, "durationSeconds", "", true, nil, "how long the aws temp creds should be issued for")
	mGetAWSTemporaryCredentials.Input("externalId", "String", false, "externalId", "", true, nil, "aws assume role external id")
	mGetAWSTemporaryCredentials.Auth("", "", true, "")
	mGetAWSTemporaryCredentials.Exception("BAD_REQUEST", "ResourceError", "")
	mGetAWSTemporaryCredentials.Exception("FORBIDDEN", "ResourceError", "")
	mGetAWSTemporaryCredentials.Exception("NOT_FOUND", "ResourceError", "")
	mGetAWSTemporaryCredentials.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mGetAWSTemporaryCredentials.Build())

	mPostInstanceRegisterInformation := rdl.NewResourceBuilder("InstanceIdentity", "POST", "/instance")
	mPostInstanceRegisterInformation.Comment("Register a new service instance and issue an x.509 service identity certificate once the provider validates the attestation data along with the request attributes. We have an authenticate enabled for this endpoint but in most cases the service owner might need to make it optional by setting the zts servers no_auth_uri list to include this endpoint. We need the authenticate in case the request comes with a client certificate and the provider needs to know who that principal was in the client certificate")
	mPostInstanceRegisterInformation.Input("info", "InstanceRegisterInformation", false, "", "", false, nil, "")
	mPostInstanceRegisterInformation.Output("location", "String", "Location", false, "return location for subsequent patch requests")
	mPostInstanceRegisterInformation.Auth("", "", true, "")
	mPostInstanceRegisterInformation.Expected("CREATED")
	mPostInstanceRegisterInformation.Exception("BAD_REQUEST", "ResourceError", "")
	mPostInstanceRegisterInformation.Exception("FORBIDDEN", "ResourceError", "")
	mPostInstanceRegisterInformation.Exception("INTERNAL_SERVER_ERROR", "ResourceError", "")
	mPostInstanceRegisterInformation.Exception("NOT_FOUND", "ResourceError", "")
	mPostInstanceRegisterInformation.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mPostInstanceRegisterInformation.Build())

	mPostInstanceRefreshInformation := rdl.NewResourceBuilder("InstanceIdentity", "POST", "/instance/{provider}/{domain}/{service}/{instanceId}")
	mPostInstanceRefreshInformation.Comment("Refresh the given service instance and issue a new x.509 service identity certificate once the provider validates the attestation data along with the request attributes. only TLS Certificate authentication is allowed")
	mPostInstanceRefreshInformation.Input("provider", "ServiceName", true, "", "", false, nil, "the provider service name (i.e. \"aws.us-west-2\", \"paas.manhattan.corp-gq1\")")
	mPostInstanceRefreshInformation.Input("domain", "DomainName", true, "", "", false, nil, "the domain of the instance")
	mPostInstanceRefreshInformation.Input("service", "SimpleName", true, "", "", false, nil, "the service this instance is supposed to run")
	mPostInstanceRefreshInformation.Input("instanceId", "PathElement", true, "", "", false, nil, "unique instance id within provider's namespace")
	mPostInstanceRefreshInformation.Input("info", "InstanceRefreshInformation", false, "", "", false, nil, "the refresh request")
	mPostInstanceRefreshInformation.Auth("", "", true, "")
	mPostInstanceRefreshInformation.Exception("BAD_REQUEST", "ResourceError", "")
	mPostInstanceRefreshInformation.Exception("FORBIDDEN", "ResourceError", "")
	mPostInstanceRefreshInformation.Exception("INTERNAL_SERVER_ERROR", "ResourceError", "")
	mPostInstanceRefreshInformation.Exception("NOT_FOUND", "ResourceError", "")
	mPostInstanceRefreshInformation.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mPostInstanceRefreshInformation.Build())

	mGetInstanceRegisterToken := rdl.NewResourceBuilder("InstanceRegisterToken", "GET", "/instance/{provider}/{domain}/{service}/{instanceId}/token")
	mGetInstanceRegisterToken.Comment("Request a token for the given service to be bootstrapped for the given provider. The caller must have authorization to manage the service in the given domain. The token will be valid for 30 mins for one time use only for the initial registration. The token must be sent back in the register request as the value of the attestationData field in the InstanceRegisterInformation object")
	mGetInstanceRegisterToken.Input("provider", "ServiceName", true, "", "", false, nil, "the provider service name (i.e. \"aws.us-west-2\")")
	mGetInstanceRegisterToken.Input("domain", "DomainName", true, "", "", false, nil, "the domain of the instance")
	mGetInstanceRegisterToken.Input("service", "SimpleName", true, "", "", false, nil, "the service this instance is supposed to run")
	mGetInstanceRegisterToken.Input("instanceId", "PathElement", true, "", "", false, nil, "unique instance id within provider's namespace")
	mGetInstanceRegisterToken.Auth("update", "{domain}:service.{service}", false, "")
	mGetInstanceRegisterToken.Exception("BAD_REQUEST", "ResourceError", "")
	mGetInstanceRegisterToken.Exception("FORBIDDEN", "ResourceError", "")
	mGetInstanceRegisterToken.Exception("INTERNAL_SERVER_ERROR", "ResourceError", "")
	mGetInstanceRegisterToken.Exception("NOT_FOUND", "ResourceError", "")
	mGetInstanceRegisterToken.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mGetInstanceRegisterToken.Build())

	mDeleteInstanceIdentity := rdl.NewResourceBuilder("InstanceIdentity", "DELETE", "/instance/{provider}/{domain}/{service}/{instanceId}")
	mDeleteInstanceIdentity.Comment("Delete the given service instance certificate record thus blocking any future refresh requests from the given instance for this service")
	mDeleteInstanceIdentity.Input("provider", "ServiceName", true, "", "", false, nil, "the provider service name (i.e. \"aws.us-west-2\", \"paas.manhattan.corp-gq1\")")
	mDeleteInstanceIdentity.Input("domain", "DomainName", true, "", "", false, nil, "the domain of the instance")
	mDeleteInstanceIdentity.Input("service", "SimpleName", true, "", "", false, nil, "the service this instance is supposed to run")
	mDeleteInstanceIdentity.Input("instanceId", "PathElement", true, "", "", false, nil, "unique instance id within provider's namespace")
	mDeleteInstanceIdentity.Auth("delete", "{domain}:instance.{instanceId}", false, "")
	mDeleteInstanceIdentity.Expected("NO_CONTENT")
	mDeleteInstanceIdentity.Exception("BAD_REQUEST", "ResourceError", "")
	mDeleteInstanceIdentity.Exception("FORBIDDEN", "ResourceError", "")
	mDeleteInstanceIdentity.Exception("INTERNAL_SERVER_ERROR", "ResourceError", "")
	mDeleteInstanceIdentity.Exception("NOT_FOUND", "ResourceError", "")
	mDeleteInstanceIdentity.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mDeleteInstanceIdentity.Build())

	mGetCertificateAuthorityBundle := rdl.NewResourceBuilder("CertificateAuthorityBundle", "GET", "/cacerts/{name}")
	mGetCertificateAuthorityBundle.Comment("Return the request CA X.509 Certificate bundle")
	mGetCertificateAuthorityBundle.Input("name", "SimpleName", true, "", "", false, nil, "name of the CA cert bundle")
	mGetCertificateAuthorityBundle.Auth("", "", true, "")
	mGetCertificateAuthorityBundle.Exception("BAD_REQUEST", "ResourceError", "")
	mGetCertificateAuthorityBundle.Exception("NOT_FOUND", "ResourceError", "")
	mGetCertificateAuthorityBundle.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mGetCertificateAuthorityBundle.Build())

	mGetStatus := rdl.NewResourceBuilder("Status", "GET", "/status")
	mGetStatus.Comment("Retrieve the server status")
	mGetStatus.Auth("", "", true, "")
	mGetStatus.Exception("BAD_REQUEST", "ResourceError", "")
	mGetStatus.Exception("NOT_FOUND", "ResourceError", "")
	mGetStatus.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mGetStatus.Build())

	mPostSSHCertRequest := rdl.NewResourceBuilder("SSHCertificates", "POST", "/sshcert")
	mPostSSHCertRequest.Input("certRequest", "SSHCertRequest", false, "", "", false, nil, "ssh certificate request")
	mPostSSHCertRequest.Auth("", "", true, "")
	mPostSSHCertRequest.Expected("CREATED")
	mPostSSHCertRequest.Exception("BAD_REQUEST", "ResourceError", "")
	mPostSSHCertRequest.Exception("FORBIDDEN", "ResourceError", "")
	mPostSSHCertRequest.Exception("INTERNAL_SERVER_ERROR", "ResourceError", "")
	mPostSSHCertRequest.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mPostSSHCertRequest.Build())

	mGetJWKList := rdl.NewResourceBuilder("JWKList", "GET", "/oauth2/keys")
	mGetJWKList.Input("rfc", "Bool", false, "rfc", "", true, false, "flag to indicate ec curve names are restricted to RFC values")
	mGetJWKList.Auth("", "", true, "")
	mGetJWKList.Exception("BAD_REQUEST", "ResourceError", "")
	mGetJWKList.Exception("NOT_FOUND", "ResourceError", "")
	mGetJWKList.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mGetJWKList.Build())

	mPostAccessTokenRequest := rdl.NewResourceBuilder("AccessTokenResponse", "POST", "/oauth2/token")
	mPostAccessTokenRequest.Input("request", "AccessTokenRequest", false, "", "", false, nil, "")
	mPostAccessTokenRequest.Auth("", "", true, "")
	mPostAccessTokenRequest.Exception("BAD_REQUEST", "ResourceError", "")
	mPostAccessTokenRequest.Exception("FORBIDDEN", "ResourceError", "")
	mPostAccessTokenRequest.Exception("NOT_FOUND", "ResourceError", "")
	mPostAccessTokenRequest.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mPostAccessTokenRequest.Build())

	mPostRoleCertificateRequestExt := rdl.NewResourceBuilder("RoleCertificate", "POST", "/rolecert")
	mPostRoleCertificateRequestExt.Comment("Return a TLS certificate for a role that the principal can assume. The role arn is in the CN field of the Subject and the principal is in the SAN URI field.")
	mPostRoleCertificateRequestExt.Name("PostRoleCertificateRequestExt")
	mPostRoleCertificateRequestExt.Input("req", "RoleCertificateRequest", false, "", "", false, nil, "csr request")
	mPostRoleCertificateRequestExt.Auth("", "", true, "")
	mPostRoleCertificateRequestExt.Exception("BAD_REQUEST", "ResourceError", "")
	mPostRoleCertificateRequestExt.Exception("FORBIDDEN", "ResourceError", "")
	mPostRoleCertificateRequestExt.Exception("NOT_FOUND", "ResourceError", "")
	mPostRoleCertificateRequestExt.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mPostRoleCertificateRequestExt.Build())

	mGetWorkloadsByService := rdl.NewResourceBuilder("Workloads", "GET", "/domain/{domainName}/service/{serviceName}/workloads")
	mGetWorkloadsByService.Name("getWorkloadsByService")
	mGetWorkloadsByService.Input("domainName", "DomainName", true, "", "", false, nil, "name of the domain")
	mGetWorkloadsByService.Input("serviceName", "EntityName", true, "", "", false, nil, "name of the service")
	mGetWorkloadsByService.Auth("", "", true, "")
	mGetWorkloadsByService.Exception("BAD_REQUEST", "ResourceError", "")
	mGetWorkloadsByService.Exception("FORBIDDEN", "ResourceError", "")
	mGetWorkloadsByService.Exception("NOT_FOUND", "ResourceError", "")
	mGetWorkloadsByService.Exception("TOO_MANY_REQUESTS", "ResourceError", "")
	mGetWorkloadsByService.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mGetWorkloadsByService.Build())

	mGetWorkloadsByIP := rdl.NewResourceBuilder("Workloads", "GET", "/workloads/{ip}")
	mGetWorkloadsByIP.Name("getWorkloadsByIP")
	mGetWorkloadsByIP.Input("ip", "String", true, "", "", false, nil, "ip address to query")
	mGetWorkloadsByIP.Auth("", "", true, "")
	mGetWorkloadsByIP.Exception("BAD_REQUEST", "ResourceError", "")
	mGetWorkloadsByIP.Exception("FORBIDDEN", "ResourceError", "")
	mGetWorkloadsByIP.Exception("NOT_FOUND", "ResourceError", "")
	mGetWorkloadsByIP.Exception("TOO_MANY_REQUESTS", "ResourceError", "")
	mGetWorkloadsByIP.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mGetWorkloadsByIP.Build())

	mGetTransportRules := rdl.NewResourceBuilder("TransportRules", "GET", "/domain/{domainName}/service/{serviceName}/transportRules")
	mGetTransportRules.Input("domainName", "DomainName", true, "", "", false, nil, "name of the domain")
	mGetTransportRules.Input("serviceName", "EntityName", true, "", "", false, nil, "name of the service")
	mGetTransportRules.Auth("", "", true, "")
	mGetTransportRules.Exception("BAD_REQUEST", "ResourceError", "")
	mGetTransportRules.Exception("FORBIDDEN", "ResourceError", "")
	mGetTransportRules.Exception("NOT_FOUND", "ResourceError", "")
	mGetTransportRules.Exception("TOO_MANY_REQUESTS", "ResourceError", "")
	mGetTransportRules.Exception("UNAUTHORIZED", "ResourceError", "")
	sb.AddResource(mGetTransportRules.Build())

	var err error
	schema, err = sb.BuildParanoid()
	if err != nil {
		log.Fatalf("rdl: schema build failed: %s", err)
	}
}

func ZTSSchema() *rdl.Schema {
	return schema
}
