// Code is generated by ucloud-model, DO NOT EDIT IT.

package ufile

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// CreateBucketRequest is request schema for CreateBucket action
type CreateBucketRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 待创建Bucket的名称，具有全局唯一性
	BucketName *string `required:"true"`

	// Bucket访问类型，public或private; 默认为private
	Type *string `required:"false"`
}

// CreateBucketResponse is response schema for CreateBucket action
type CreateBucketResponse struct {
	response.CommonBase

	// 已创建Bucket的ID
	BucketId string

	// 已创建Bucket的名称
	BucketName string
}

// NewCreateBucketRequest will create request of CreateBucket action.
func (c *UFileClient) NewCreateBucketRequest() *CreateBucketRequest {
	req := &CreateBucketRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

// CreateBucket - 创建Bucket
func (c *UFileClient) CreateBucket(req *CreateBucketRequest) (*CreateBucketResponse, error) {
	var err error
	var res CreateBucketResponse

	reqCopier := *req

	err = c.Client.InvokeAction("CreateBucket", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
