/*
 * 3DS OUTSCALE API
 *
 * Welcome to the 3DS OUTSCALE's API documentation.<br /><br />  The 3DS OUTSCALE API enables you to manage your resources in the 3DS OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the 3DS OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the 3DS OUTSCALE API. You can find a list of the differences [here](https://wiki.outscale.net/display/EN/3DS+OUTSCALE+APIs+Reference).<br /><br />  You can also manage your resources using the [Cockpit](https://wiki.outscale.net/display/EN/About+Cockpit) web interface.
 *
 * API version: 1.2
 * Contact: support@outscale.com
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package osc
// Log Information about the log.
type Log struct {
	// The account ID.
	AccountId string `json:"AccountId,omitempty"`
	// The duration of the call (in milliseconds).
	CallDuration int32 `json:"CallDuration,omitempty"`
	// The API key used for the query.
	QueryAccessKey string `json:"QueryAccessKey,omitempty"`
	// The name of the API service used by the call.
	QueryApiName string `json:"QueryApiName,omitempty"`
	// The version of the API service used by the call.
	QueryApiVersion string `json:"QueryApiVersion,omitempty"`
	// The name of the call.
	QueryCallName string `json:"QueryCallName,omitempty"`
	// The date and time of the query (in ISO 8601 base or extended format).
	QueryDate string `json:"QueryDate,omitempty"`
	// The query header raw.
	QueryHeaderRaw string `json:"QueryHeaderRaw,omitempty"`
	// The query header size.
	QueryHeaderSize int32 `json:"QueryHeaderSize,omitempty"`
	// The IP address used for the query.
	QueryIpAddress string `json:"QueryIpAddress,omitempty"`
	// The query payload raw.
	QueryPayloadRaw string `json:"QueryPayloadRaw,omitempty"`
	// The query payload size.
	QueryPayloadSize int32 `json:"QueryPayloadSize,omitempty"`
	// The user agent used for the HTTP request.
	QueryUserAgent string `json:"QueryUserAgent,omitempty"`
	// The ID provided in the response.
	RequestId string `json:"RequestId,omitempty"`
	// The size of the response (in bytes).
	ResponseSize int32 `json:"ResponseSize,omitempty"`
	// The HTTP code provided in the response.
	ResponseStatusCode int32 `json:"ResponseStatusCode,omitempty"`
}
