---
title: v1.41.0
weight: 998959000
---

## Upgrade Go version to 1.24

Update the Go version used to `1.24`. This affects:

**Dockerfile:**
```diff
- FROM golang:1.23 AS builder
+ FROM golang:1.24 AS builder
```

**.devcontainer/devcontainer.json:**
```diff
- "image": "golang:1.23",
+ "image": "golang:1.24",
```

**go.mod:**
```diff
- go 1.23.0
+ go 1.24.0
```

_See [#6954](https://github.com/operator-framework/operator-sdk/pull/6954) for more details._

## Upgrade golangci-lint and use v2 config

Update golangci-lint usage across the project:

**Makefile:**
```diff
- GOLANGCI_LINT_VERSION ?= v1.63.4
+ GOLANGCI_LINT_VERSION ?= v2.1.0

- $(call go-install-tool,$(GOLANGCI_LINT),github.com/golangci/golangci-lint/cmd/golangci-lint,$(GOLANGCI_LINT_VERSION))
+ $(call go-install-tool,$(GOLANGCI_LINT),github.com/golangci/golangci-lint/v2/cmd/golangci-lint,$(GOLANGCI_LINT_VERSION))
```

**GitHub Actions Workflow:**
```diff
- uses: golangci/golangci-lint-action@v6
+ uses: golangci/golangci-lint-action@v8
```

**.golangci.yml:**  
Convert to v2 layout with keys like `version`, `linters`, `settings`, `formatters`, `exclusions`.
You might want to copy and paste the file from the Memcached sample from the tag release `v1.40.0`: [testdata/go/v4/memcached-operator/.golangci.yml](https://github.com/operator-framework/operator-sdk/tree/v1.40.0/testdata/go/v4/memcached-operator/.golangci.yml)

_See [#6954](https://github.com/operator-framework/operator-sdk/pull/6954) for more details._

## Upgrade controller-gen to `v0.18.0`

Update controller-gen tooling and annotations:

**Makefile:**
```diff
- CONTROLLER_TOOLS_VERSION ?= v0.17.2
+ CONTROLLER_TOOLS_VERSION ?= v0.18.0
```

Run `make generate` to regenerate code and manifests with the new version.

_See [#6954](https://github.com/operator-framework/operator-sdk/pull/6954) for more details._

## Upgrade controller-runtime to `v0.21.0`

Update the `go.mod` import:
```diff
- sigs.k8s.io/controller-runtime v0.20.4
+ sigs.k8s.io/controller-runtime v0.21.0
```

Run `go mod tidy` to upgrade the k8s dependencies.

_See [#6954](https://github.com/operator-framework/operator-sdk/pull/6954) for more details._

## Add cluster setup for e2e tests in Makefile and update CI workflow

Remove direct Kind commands in GitHub workflows:

**Removed:**
```yaml
- name: Create kind cluster
  run: kind create cluster
```

**Added to Makefile:**
```makefile
KIND_CLUSTER ?= <project-name>-test-e2e

.PHONY: setup-test-e2e
setup-test-e2e: ## Set up a Kind cluster for e2e tests if it does not exist
  @command -v $(KIND) >/dev/null 2>&1 || { \
    echo "Kind is not installed. Please install Kind manually."; \
    exit 1; \
  }
  @case "$$($(KIND) get clusters)" in \
    *"$(KIND_CLUSTER)"*) \
      echo "Kind cluster '$(KIND_CLUSTER)' already exists. Skipping creation." ;; \
    *) \
    echo "Creating Kind cluster '$(KIND_CLUSTER)'..."; \
    $(KIND) create cluster --name $(KIND_CLUSTER) ;; \
  esac

.PHONY: cleanup-test-e2e
cleanup-test-e2e:
	$(KIND) delete cluster --name $(KIND_CLUSTER)
```

Update `test-e2e` target to call these appropriately.

_See [#6954](https://github.com/operator-framework/operator-sdk/pull/6954) for more details._
