---
title: v1.39.0
weight: 998961000
---

## Upgrade K8s versions to use 1.31 and Kubebuilder network-policy scaffolding

This release contains a decent amount of migrations, but not nearly as many as the [previous versions migrations](https://sdk.operatorframework.io/docs/upgrading-sdk-version/v1.38.0/)
so this release should be easier to follow.

1) [helm/v1, ansible/v1] Update the kustomize version in your Makefile
   ```diff
    - curl -sSLo - https://github.com/kubernetes-sigs/kustomize/releases/download/kustomize/v5.3.2/kustomize_v5.3.0_$(OS)_$(ARCH).tar.gz | \
    + curl -sSLo - https://github.com/kubernetes-sigs/kustomize/releases/download/kustomize/v5.4.3/kustomize_v5.4.2_$(OS)_$(ARCH).tar.gz | \
   ```

2) [go/v4] Update your `go.mod` file to upgrade the dependencies and run `go mod tidy` to download them
   ```go
    github.com/onsi/ginkgo/v2 v2.17.1
    github.com/onsi/gomega v1.32.0
    k8s.io/api v0.30.1
    k8s.io/apimachinery v0.30.1
    k8s.io/client-go v0.30.1
    sigs.k8s.io/controller-runtime v0.18.4
    github.com/onsi/ginkgo/v2 v2.19.0
    github.com/onsi/gomega v1.33.1
    k8s.io/api v0.31.0
    k8s.io/apimachinery v0.31.0
    k8s.io/client-go v0.31.0
    sigs.k8s.io/controller-runtime v0.19.0
   ```

3) [go/v4] Update your `Makefile` with the below changes:
   ```diff
    - ENVTEST_K8S_VERSION = 1.30.0
    + ENVTEST_K8S_VERSION = 1.31.0
   ```

   ```diff
    - KUSTOMIZE_VERSION ?= v5.4.2
    - CONTROLLER_TOOLS_VERSION ?= v0.15.0
    - ENVTEST_VERSION ?= release-0.18
    + KUSTOMIZE_VERSION ?= v5.4.3
    + CONTROLLER_TOOLS_VERSION ?= v0.16.1
    + ENVTEST_VERSION ?= release-0.19
   ```

4) [go/v4] Update your `main.go` file with the below changes:
   ```diff
    - // - https://pkg.go.dev/sigs.k8s.io/controller-runtime@v0.18.4/pkg/metrics/server
    + // - https://pkg.go.dev/sigs.k8s.io/controller-runtime@v0.19.0/pkg/metrics/server

    - // https://pkg.go.dev/sigs.k8s.io/controller-runtime@v0.18.4/pkg/metrics/filters#WithAuthenticationAndAuthorization
    + // https://pkg.go.dev/sigs.k8s.io/controller-runtime@v0.19.0/pkg/metrics/filters#WithAuthenticationAndAuthorization
   ```

5) [go/v4, helm/v1, ansible/v1] Update your `/config/default/kustomization.yaml` file with the below changes:
   ```diff
    +# [NETWORK POLICY] Protect the /metrics endpoint and Webhook Server with NetworkPolicy.
    +# Only Pod(s) running a namespace labeled with 'metrics: enabled' will be able to gather the metrics.
    +# Only CR(s) which requires webhooks and are applied on namespaces labeled with 'webhooks: enabled' will
    +# be able to communicate with the Webhook Server.
    +#- ../network-policy
   ```

6) [go/v4, helm/v1, ansible/v1] Add `/config/network-policy/allow-metrics-traffic.yaml`
   ```diff
    + # This NetworkPolicy allows ingress traffic
    + # with Pods running on namespaces labeled with 'metrics: enabled'. Only Pods on those
    + # namespaces are able to gathering data from the metrics endpoint.
    + apiVersion: networking.k8s.io/v1
    + kind: NetworkPolicy
    + metadata:
    +   labels:
    +     app.kubernetes.io/name: <operator-name>
    +     app.kubernetes.io/managed-by: kustomize
    +   name: allow-metrics-traffic
    +   namespace: system
    + spec:
    +   podSelector:
    +     matchLabels:
    +       control-plane: controller-manager
    +   policyTypes:
    +     - Ingress
    +   ingress:
    +     # This allows ingress traffic from any namespace with the label metrics: enabled
    +     - from:
    +       - namespaceSelector:
    +           matchLabels:
    +             metrics: enabled  # Only from namespaces with this label
    +       ports:
    +         - port: 8443
    +           protocol: TCP
   ```

7) [helm/v1, ansible/v1] Add `/config/network-policy/kustomization.yaml`
   ```diff
    + resources:
    + - allow-metrics-traffic.yaml

8) [go/v4] Add `/config/network-policy/allow-webhook-traffic.yaml`
   ```diff
    + # This NetworkPolicy allows ingress traffic to your webhook server running
    + # as part of the controller-manager from specific namespaces and pods. CR(s) which uses webhooks
    + # will only work when applied in namespaces labeled with 'webhook: enabled'
    + apiVersion: networking.k8s.io/v1
    + kind: NetworkPolicy
    + metadata:
    +   labels:
    +     app.kubernetes.io/name: <operator-name>
    +     app.kubernetes.io/managed-by: kustomize
    +   name: allow-webhook-traffic
    +   namespace: system
    + spec:
    +   podSelector:
    +     matchLabels:
    +       control-plane: controller-manager
    +   policyTypes:
    +     - Ingress
    +   ingress:
    +     # This allows ingress traffic from any namespace with the label webhook: enabled
    +     - from:
    +       - namespaceSelector:
    +           matchLabels:
    +             webhook: enabled # Only from namespaces with this label
    +       ports:
    +         - port: 443
    +           protocol: TCP
   ```

9) [go/v4] Add `/config/network-policy/kustomization.yaml`
   ```diff
    + resources:
    + - allow-webhook-traffic.yaml
    + - allow-metrics-traffic.yaml
   ```

_See [#6878](https://github.com/operator-framework/operator-sdk/pull/6878) for more details._
