## v1.40.0

### Additions

- (go/v4) For Go-based operators, a devcontainer is now available to allow users to develop and test the operator in a local environment and leverage on solutions such as VS Code Remote Containers and GitHub Codespaces to have a consistent development environment. ([#6928](https://github.com/operator-framework/operator-sdk/pull/6928))
- (go/v4) For Go-based operators, new GitHub Actions are available to ensure better quality of their code. ([#6928](https://github.com/operator-framework/operator-sdk/pull/6928))
- (go/v4) For Go-based operators, controllers now use `.Named("<Kind>")` in  `SetupWithManager` to prevent naming conflicts in multi-group projects. ([More info](https://github.com/kubernetes-sigs/kubebuilder/pull/4162)). ([#6928](https://github.com/operator-framework/operator-sdk/pull/6928))
- (go/v4) For Go-based operators, a new Makefile target named `lint-config` has been added to verify that your `.golangci.yaml` configuration file is valid. This helps catch issues early when customizing lint rules.
([More info](https://github.com/kubernetes-sigs/kubebuilder/pull/4462)). ([#6928](https://github.com/operator-framework/operator-sdk/pull/6928))
- For ALL-based operators, scaffolded resources now include the `app.kubernetes.io/name` label to support Kubernetes best practices for app identification. ([More info](https://github.com/kubernetes-sigs/kubebuilder/pull/4437/files)). ([#6928](https://github.com/operator-framework/operator-sdk/pull/6928))
- For ALL-based operators, new role manifests are now scaffolded under the `config/rbac/` directory to assist cluster administrators. For each API defined in the project, three role files are generated: `<kind>_admin_role.yaml`, `<kind>_editor_role.yaml`, and `<kind>_viewer_role.yaml`.
These roles are not applied by default. Instead, they are provided as helpers, allowing cluster administrators to customize and apply appropriate permissions as needed.
The primary motivation for scaffolding these roles is to simplify integration with Kubernetes' aggregated roles mechanism. By including annotations such as `rbac.authorization.k8s.io/aggregate-to-admin: "true"`, `rbac.authorization.k8s.io/aggregate-to-edit: "true"`, and `rbac.authorization.k8s.io/aggregate-to-view: "true"`, these role definitions can automatically contribute permissions to the default admin, edit, and view roles in a cluster when applied.
For more information on Kubernetes RBAC and aggregated roles, see: https://kubernetes.io/docs/reference/access-authn-authz/rbac/. ([#6928](https://github.com/operator-framework/operator-sdk/pull/6928))
- For ALL-based operators, new role manifests are now scaffolded under the `config/rbac/` directory to assist cluster administrators. For each API defined in the project, three role files are generated: `<kind>_admin_role.yaml`, `<kind>_editor_role.yaml`, and `<kind>_viewer_role.yaml`.
These roles are not applied by default. Instead, they are provided as helpers, allowing cluster administrators to customize and apply appropriate permissions as needed.
The primary motivation for scaffolding these roles is to simplify integration with Kubernetes' aggregated roles mechanism. By including annotations such as `rbac.authorization.k8s.io/aggregate-to-admin: "true"`, `rbac.authorization.k8s.io/aggregate-to-edit: "true"`, and `rbac.authorization.k8s.io/aggregate-to-view: "true"`, these role definitions can automatically contribute permissions to the default admin, edit, and view roles in a cluster when applied.
For more information on Kubernetes RBAC and aggregated roles, see: https://kubernetes.io/docs/reference/access-authn-authz/rbac/. ([#6928](https://github.com/operator-framework/operator-sdk/pull/6928))

### Changes

- The bundle build target now respects the CONTAINER_TOOL variable, allowing users to use alternative container tools like podman instead of docker. ([#6932](https://github.com/operator-framework/operator-sdk/pull/6932))
- For All-based Operators, upgrade OPM to version from `v1.23.0` to `v1.55.0`, which includes several bug fixes and  improvements. For further information, see: https://github.com/operator-framework/operator-registry/releases. ([#6953](https://github.com/operator-framework/operator-sdk/pull/6953))
- (go/v4) For Go-based Operators, the `main.go` file has been enhanced to support real TLS certificates for both webhooks and the metrics server, with automated certificate rotation via cert-manager. This change improves security and aligns with production-grade best practices.
Previously, setups relied on kube-rbac-proxy (deprecated in Operator SDK and Kubebuilder, see: [kubebuilder/discussions/3907](https://github.com/kubernetes-sigs/kubebuilder/discussions/3907)), which generated TLS certificates dynamically — a method no longer recommended for secure environments. The updated approach adopts static certificates managed by cert-manager.
Additionally, integrations with Prometheus now support scraping metrics using the cert-manager generated certificates. A related fix was introduced to ensure that CA injection patches are only applied to CRDs with a conversion webhook, avoiding unnecessary annotations.
To support these improvements, changes to `config/default/kustomization.yaml` are required. These include: configuring webhook and metrics server certificates, enabling Prometheus scraping with TLS, and correcting CA injection behavior.
These updates also introduce flexible opt-in mechanisms, allowing users to selectively enable or disable: - TLS for the metrics server via cert-manager - TLS for webhooks via cert-manager - TLS configuration for Prometheus scraping
Together, these changes are part of a broader effort to elevate the default security posture and configurability of Go-based operators. ([#6928](https://github.com/operator-framework/operator-sdk/pull/6928))
- (go/v4) For Go-based operators, a fix has been implemented to ensure that the Prometheus configuration can properly scrape metrics from the operator's metrics server when TLS is enabled. ([#6928](https://github.com/operator-framework/operator-sdk/pull/6928))
- (go/v4) For Go-based operators, a fix has been implemented to ensure that CA injection patches are applied only to CRDs that define a conversion webhook.
Previously, the CA injection patch logic was overly broad — applying injection annotations to all CRDs whenever a webhook was scaffolded with the `--conversion` flag. This behavior was introduced in Kubebuilder release `v3.5.0` when replacements were introduced in place of legacy vars and the `kustomize/v2-alpha` plugin was adopted.
The incorrect behavior likely went unnoticed due to incomplete support for conversion webhooks in earlier versions. This release addresses that gap, enabling proper scaffolding and CA injection behavior specifically for CRDs with conversion webhooks.
To support this improvement, a new marker has been introduced: `+kubebuilder:scaffold:crdkustomizecainjectionns`. This marker ensures that the correct replacements are generated in `config/default/kustomization.yaml` for CA injection. Additionally, the `kubebuilder:scaffold:crdkustomizewebhookpatch` marker was created to ensure that the webhook patch is only applied to CRDs that have a conversion webhook in the `config/crd/kustomization.yaml` file.
For more information on this and other scaffolding markers, refer to the official Kubebuilder documentation: https://book.kubebuilder.io/reference/markers/scaffold. ([#6928](https://github.com/operator-framework/operator-sdk/pull/6928))
- (go/v4) For Go-based operators, ENVTEST version management is now automated by  deriving values from `go.mod`, and controller tests now locate binaries dynamically.  ([More info](https://github.com/kubernetes-sigs/kubebuilder/pull/4401))
These updates improve the developer experience by: - Reducing manual configuration for ENVTEST. - Ensuring IDEs or test runners can locate the binaries reliably. - Making controller test scaffolding more robust and portable. ([#6928](https://github.com/operator-framework/operator-sdk/pull/6928))
- (go/v4) For Go-based operators, updated GolangCI-Lint configuration to replace  the deprecated `exportloopref` linter with the `copyloopvar` linter. ([#6928](https://github.com/operator-framework/operator-sdk/pull/6928))
- (go/v4) For Go-based operators, upgraded project scaffolding to Go 1.23,  Kubernetes v0.32.1, and controller-runtime v0.20.4.
The default project scaffolding for Go-based operators has been updated to use:
  - **Go 1.23**
  - **Kubernetes modules v0.32.1**
  - **controller-runtime v0.20.4**
  - **Ginkgo v2.22.0** and **Gomega v1.36.1**. ([#6928](https://github.com/operator-framework/operator-sdk/pull/6928))
- **Breaking change**: (go/v4) For Go-based operators, upgraded controller-runtime from `v0.19.4` to `v0.20.0` and added support for Kubernetes 1.32.  Removed deprecated `webhook.Validator` and `webhook.Defaulter` interfaces from the runtime. Webhooks should no longer reside under the `api/` directory—this has been the default behavior since Kubebuilder rlease [v4.3.0)(https://github.com/kubernetes-sigs/kubebuilder/releases/tag/v4.3.0). 
A `--legacy=true` flag was added to support scaffolding webhooks in the old layout when needed. ([More info](https://github.com/kubernetes-sigs/kubebuilder/pull/4492) ·  [Migration guide](https://github.com/kubernetes-sigs/kubebuilder/releases/tag/v4.3.0)). ([#6928](https://github.com/operator-framework/operator-sdk/pull/6928))
