## v1.25.0

### Changes

- (ansible/v1): Modified ansible scaffolding in order to incorporate  changes with Kubebuilder on `--component-config` flag changes.  Previously, the changes with `--component-config` flag were not  considered by default.
The following are the modifications: 1. If the `--component-config` flag is passed then look for `- /manager`  in `manager.yaml` in order to add leader election id. If the component  config flag is not passed then check for `--leader-elect` flag. 2. In `manager_proxy_patch.yaml` file, look for `memory: 64Mi`  if the component flag is passed flag is passed. If not then look  for `--leader-elect`. 3. Repeat the same logic for replacing the port number from the file. 4. At the end, update the `manager.yaml` file to avoid lint errors. ([#6047](https://github.com/operator-framework/operator-sdk/pull/6047))
- (go/v3, hybrid.helm/v1-alpha, and quarkus/v1-alpha): Upgrade Kubernetes dependencies from `1.24` to `1.25`. ([#6044](https://github.com/operator-framework/operator-sdk/pull/6044))
- This PR bumped Kubebuilder to 3.7.1,  with this version comes the addition of the `--component-config` flag.
This flag is passed through `operator-sdk init` command.  If this flag is passed through the command line as an argument then only the  `controller_manager_config.yaml` file will be scaffolded in the  manifest.  If it is not passed then it will not scaffold out this file.  The command for passing the flag is:  operator-sdk init --domain example.com --repo github.com/example/memcached-operator --component-config. ([#6047](https://github.com/operator-framework/operator-sdk/pull/6047))
- (ansible/v1): updates the base ansible base operator event api, api server,  and proxy to now have a 5 second timeout when reading the request headers.  This is to prevent the possibility of a [Slowloris attack](https://www.cloudflare.com/learning/ddos/ddos-attack-tools/slowloris/). ([#6088](https://github.com/operator-framework/operator-sdk/pull/6088))
- Modified go version to 1.19 and Kubebuilder to 3.7.1. The `config-gen` is  completely removed from Kubebuilder. As part of this bump, the  website content of SDK was updated where the doc is referring to  `config-gen`. ([#6047](https://github.com/operator-framework/operator-sdk/pull/6047))
- Updated ginkgo to ginkgo/v2 in all of the files. ([#6047](https://github.com/operator-framework/operator-sdk/pull/6047))
- Updated: - ginko to `ginko/v2` - `io/ioutil` packages to either `io` or `os` since its not longer supported in go1.19. ([#6047](https://github.com/operator-framework/operator-sdk/pull/6047))
- (helm/v1): Modified helm scaffolding in order to incorporate changes with Kubebuilder on `--component-config` flag changes. Previously,  the changes with `--component-config` flag were not considered by  default.
The following are the modifications: 1. If the `--component-config` flag is passed then look for `- /manager`  in `manager.yaml` in order to add leader election id. If the component  config flag is not passed then check for `--leader-elect` flag. 2. In `manager_proxy_patch.yaml` file, look for `memory: 64Mi`  if the component flag is passed flag is passed. If not then look  for `--leader-elect`. 3. Repeat the same logic for replacing the port number from the file. 4. At the end, update the `manager.yaml` file to avoid lint errors. ([#6047](https://github.com/operator-framework/operator-sdk/pull/6047))
- (ansible/v1, helm/v1): Added support to build multi-arch images from the project Makefile. A docker-buildx target will build the images for the platforms specified by the PLATFORMS variable. ([#6093](https://github.com/operator-framework/operator-sdk/pull/6093))

### Bug Fixes

- (docs) Update the go version in the developer guide.  The documentation wasn't updated when the go version was bumped to v1.18. ([#6101](https://github.com/operator-framework/operator-sdk/pull/6101))
- For operator-sdk run bundle and bundle-upgrade subcommands: Added --security-context-config flag to enable seccompprofile. It defaults to restricted to support k8s 1.25. You can disable it with --security-context-config=legacy. ([#6062](https://github.com/operator-framework/operator-sdk/pull/6062))
