---
title: v1.34.1
weight: 998965999
---

## To fix multi-arch build, replace docker-buildx target in project Makefile

In the project `Makefile`, replace existing `docker-buildx` target with following definition.

```make
docker-buildx: ## Build and push docker image for the manager for cross-platform support
	- docker buildx create --name project-v3-builder
	docker buildx use project-v3-builder
	- docker buildx build --push --platform=$(PLATFORMS) --tag ${IMG} -f Dockerfile .
	- docker buildx rm project-v3-builder
```

_See [#6661](https://github.com/operator-framework/operator-sdk/pull/6661) for more details._
