## v1.30.0

### Additions

- Add a Parameter to the Makefile to allow modifying the 'operator-sdk' binary before running any commands. If necessary, a specific version of the SDK can be downloaded for cases when the project has yet to upgrade to a later or latest version. ([#6443](https://github.com/operator-framework/operator-sdk/pull/6443))
- Currently, the operator SDK for the Ansible operator lacks options to customize the leader election resource lock behavior. This limits the flexibility of the operator and prevents users from adjusting lease duration and renew deadline according to their specific needs.
Changes: Implemented enhancements to the operator SDK to include additional flags for configuring leader election resource lock options. These changes provide users with the ability to specify the type of resource object used for locking during leader election and customize the lease duration and renew deadline.
Introduced --leader-elect-lease-duration flag to allow users to define the duration that non-leader candidates will wait to force acquire leadership. The default duration is set to 15 seconds.
Introduced --leader-elect-renew-deadline flag, enabling users to set the renew deadline, which determines the duration that the acting control plane will retry refreshing leadership before giving up. The default duration is set to 10 seconds.
Introduced --leader-elect-resource-lock flag to allow users to define the type of resource object that is used for locking during leader election. Supported options are 'leases', 'endpointsleases', and 'configmapsleases'. The default option is 'leases'.
These changes provide more flexibility and control over leader election behavior, allowing operators to adapt to various deployment scenarios and specific requirements. ([#6426](https://github.com/operator-framework/operator-sdk/pull/6426))

### Changes

- Currently, when setting `overrideValues` in your `watches.yaml`, every entry is logged with its key and its value. When working with confidential information such as credentials, logging those information would not be optimal nor desirable. Therefore, there should be a way to silence/suppress these values.
This feature introduces the `--suppress-override-values` boolean-flag for the `helm-operator`. When set to true, the value of the overrideValues entry is sanitized with this value "****".
This is a simple example of `overrideValues` of the `watches.yaml` ```yaml overrideValues:
  x: y
```
The default-value of `--suppress-override-values` is `false` so therefore we would get this warning logged: `Chart value x overridden to y by operator's watches.yaml`
When setting `--suppress-override-values` `true` the warning will be logged in the following manner: `Chart value x overridden to **** by operator's watches.yaml`. ([#6469](https://github.com/operator-framework/operator-sdk/pull/6469))
- (images): Bumps all Operator SDK maintained images to now use ubi(-minimal) tag 8.8. ([#6466](https://github.com/operator-framework/operator-sdk/pull/6466))

### Bug Fixes

- In `run bundle-upgrade`, hash the cache directory name to avoid error of too long file name. ([#6477](https://github.com/operator-framework/operator-sdk/pull/6477))
