## v1.22.0

### Additions

- For Go (go/v3) and Hybrid Helm (hybrid.helm/v1-alpha) language based operators: Add support for Go 1.18. ([#5843](https://github.com/operator-framework/operator-sdk/pull/5843))
- For `operator-sdk bundle validate` command and GoodPractices validator (`--select-optional name=good-practices`): Add CRD description check validation [More info](https://github.com/operator-framework/api/pull/234). ([#5843](https://github.com/operator-framework/operator-sdk/pull/5843))
- For `operator-sdk bundle validate` command and GoodPractices validator (`--select-optional name=good-practices`): Add a new check to warn authors when permissions to create CRDs are found [More info](https://github.com/operator-framework/api/pull/241). ([#5843](https://github.com/operator-framework/operator-sdk/pull/5843))
- For Quarkus (quarkus/v1-alpha) language based operator: add bundle generation [More info](https://github.com/operator-framework/java-operator-plugins/pull/84). ([#5843](https://github.com/operator-framework/operator-sdk/pull/5843))
- For operator-sdk run bundle and bundle-upgrade subcommands: improve message from common scenario faced to add a new bundle [More info](https://github.com/operator-framework/operator-registry/pull/954). ([#5843](https://github.com/operator-framework/operator-sdk/pull/5843))
- For operator-sdk run bundle and bundle-upgrade subcommands: adds some extra text context to sql statement errors [More info](https://github.com/operator-framework/operator-registry/pull/953). ([#5843](https://github.com/operator-framework/operator-sdk/pull/5843))
- For Golang/Ansible/Helm/HybridHelm language-based operators (go/v3, ansible/v1, helm/v1, hybrid.helm/v1-alpha, add a new comment with the option `leaderElectionReleaseOnCancel` [More info] (https://github.com/kubernetes-sigs/kubebuilder/pull/2596]). ([#5814](https://github.com/operator-framework/operator-sdk/pull/5814))

### Changes

- **Breaking change**: For Ansible-based language operators, upgrade `community.kubernetes` from `1.2.1` to `2.0.1`. **IMPORTANT** The `community.kubernetes` collection is being renamed to kubernetes.core. As of version 2.0.0, the collection has been replaced by deprecated redirects for all content to kubernetes.core. If you are using FQCNs starting with `community.kubernetes`, please update them to `kubernetes.core`. ([#5846](https://github.com/operator-framework/operator-sdk/pull/5846))
- For Ansible-based language operators, upgrade `kubernetes.core` from `2.2.0` to `2.3.1`. **IMPORTANT** The `community.kubernetes` collection is being renamed to kubernetes.core. As of version 2.0.0, the collection has been replaced by deprecated redirects for all content to kubernetes.core. If you are using FQCNs starting with `community.kubernetes`, please update them to `kubernetes.core`. ([#5846](https://github.com/operator-framework/operator-sdk/pull/5846))
- For Ansible-based language operators, upgrade `community.kubernetes` from `1.2.1` to `2.0.1`. **IMPORTANT** The `community.kubernetes` collection is being renamed to kubernetes.core. As of version 2.0.0, the collection has been replaced by deprecated redirects for all content to kubernetes.core. If you are using FQCNs starting with `community.kubernetes`, please update them to `kubernetes.core`. ([#5846](https://github.com/operator-framework/operator-sdk/pull/5846))
- Scorecard details got generated for the bundle even if no details were present for the scorecard in the java plugin. This change will add scorecard changes on conditional basis. ([#5800](https://github.com/operator-framework/operator-sdk/pull/5800))
- Hide --skip-tls flag as it is deprecated. ([#5830](https://github.com/operator-framework/operator-sdk/pull/5830))
- For Go (go/v3) and Helm Hybrid (hybrid.helm/v1-alpha) language based operators: Upgrade Kubernetes dependencies from `1.23` to `1.24` and controller-gen from `v0.8.0` to `v0.9.0`. ([#5843](https://github.com/operator-framework/operator-sdk/pull/5843))
- For Helm (helm/v1) and Hybrid Helm (hybrid.helm/v1-alpha) language based operators: Upgrade helm from `v3.6.2` to `v3.9.0`. ([#5843](https://github.com/operator-framework/operator-sdk/pull/5843))
- For Ansible (ansible/v1) and Helm (helm/v1) language based operators: change the default value for the manager.option LeaderElectionResourceLock from `comfigmaps` to `configmapsleases` to allow a safe transition to use the leases option on the future. [More info](https://github.com/kubernetes-sigs/controller-runtime/pull/1903). ([#5843](https://github.com/operator-framework/operator-sdk/pull/5843))
- For Quarkus (quarkus/v1-alpha) language based operator: upgrade dependency from `v0.0.3` to `v0.5.1` [More info](https://github.com/operator-framework/java-operator-plugins/releases). ([#5843](https://github.com/operator-framework/operator-sdk/pull/5843))
- For Helm Hybrid (hybrid.helm/v1-alpha) language based operator: Upgrade dependency from `v0.0.10` to `v0.0.11`. [More info](https://github.com/operator-framework/helm-operator-plugins/releases). ([#5843](https://github.com/operator-framework/operator-sdk/pull/5843))
- For Go (go/v3, go/v2), Ansible (ansible/v1), Helm (helm/v1), and Helm Hybrid (hybrid.helm/v1-alpha) language based operators: Bump OPM version from `v1.19.1` to `v1.23.0`. ([#5843](https://github.com/operator-framework/operator-sdk/pull/5843))
- For Docker images: Bump Go from 1.17 to 1.18. ([#5843](https://github.com/operator-framework/operator-sdk/pull/5843))
- Docs: Update Go 1.17 references to Go 1.18. ([#5843](https://github.com/operator-framework/operator-sdk/pull/5843))
- For HybridHelm based-language (hybrid.helm/v1-alpha), update its version from v0.0.10 to [v0.0.11-0.20220607145946-5b29693d1612](https://github.com/operator-framework/helm-operator-plugins/commit/5b29693d1612f87797e1e91e6cf1253842a5714e). [More info](https://github.com/operator-framework/helm-operator-plugins/compare/v0.0.8...5b29693d1612). ([#5814](https://github.com/operator-framework/operator-sdk/pull/5814))
- Add support for File-Based Catalog to the subcommands [operator-sdk run bundle](https://sdk.operatorframework.io/docs/cli/operator-sdk_run_bundle/#m-docsclioperator-sdk_run_bundle)  and [run bundle-upgrade](https://sdk.operatorframework.io/docs/cli/operator-sdk_run_bundle-upgrade/) so that  new indexes created by these subcommands are using the new format.  Users are able to pass in an index catalog with FBC format via the flag option `--index-image`. ([#5809](https://github.com/operator-framework/operator-sdk/pull/5809))

### Deprecations

- For Ansible/Helm based-operators (ansible/v1, helm/v1), deprecate the flag `crd-version` since `v1beta1` APIs is not longer offered from k8s 1.22 and this flag is deprecated for Golang. ([#5815](https://github.com/operator-framework/operator-sdk/pull/5815))

### Bug Fixes

- Enable `run bundle` command to handle large File-Based Catalog index images  by generating the extra FBC with the bundle contents and mounting a ConfigMap with that extra FBC, without regenerating the entire index. ([#5868](https://github.com/operator-framework/operator-sdk/pull/5868))
- For `operator-sdk bundle validate` command and GoodPractices validator (`--select-optional name=good-practices`): fix channel naming validation [More info](https://github.com/operator-framework/api/pull/231). ([#5843](https://github.com/operator-framework/operator-sdk/pull/5843))
- For Golang-based language (go/v2), fix issue introduced by removing the GO111MODULE=on from Dockerfile. ([More info](https://github.com/kubernetes-sigs/kubebuilder/pull/2678))
**IMPORTANT NOTE**: If you are using `go/v2` we highly recommend to upgrade your project to latest `go/v3` plugin (default operator-sdk scaffold). Please be aware that `go/v2` is a plugin which was kept to ensure the backwards compatibility with old Kubebuilder layout produced using its CLI versions < `3.0.0`. ([More info](https://book.kubebuilder.io/plugins/go-v2-plugin.html)) Therefore, we are unable to upgrade this plugin continuously and solve tech-debts as it is very likely that it would soon be deprecated by the Kubebuilder community. Note that projects built with this plugin do not produce CRDs for example using v1 APIs so that cannot work on Kubernetes cluster >= `1.22`). Please, ensure that you follow our migration guide [Migrating from pre-v1.0.0 to latest](https://sdk.operatorframework.io/docs/building-operators/golang/migration/). ([#5814](https://github.com/operator-framework/operator-sdk/pull/5814))
