/*
Copyright 2023.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package main

import (
	"bytes"
	"fmt"
	"sort"
	"text/template"

	"github.com/example/memcached-operator/monitoring"
)

func main() {
	metricDescriptions := monitoring.ListMetrics()
	sort.Slice(metricDescriptions, func(i, j int) bool {
		return metricDescriptions[i].Name < metricDescriptions[j].Name
	})

	tmpl, err := template.New("Operator metrics").Parse("# Operator Metrics\n" +
		"This document aims to help users that are not familiar with metrics exposed by this operator.\n" +
		"The metrics documentation is auto-generated by the utility tool \"monitoring/metricsdocs\" and reflects all of the metrics that are exposed by the operator.\n\n" +
		"## Operator Metrics List" +
		"{{range .}}\n" +
		"### {{.Name}}\n" +
		"{{.Help}} " +
		"Type: {{.Type}}.\n" +
		"{{end}}" +
		"## Developing new metrics\n" +
		"After developing new metrics or changing old ones, please run \"make generate-metricsdocs\" to regenerate this document.\n\n" +
		"If you feel that the new metric doesn't follow these rules, please change \"monitoring/metricsdocs\" according to your needs.")

	if err != nil {
		panic(err)
	}

	// generate the template using the sorted list of metrics
	var buf bytes.Buffer
	if err := tmpl.Execute(&buf, metricDescriptions); err != nil {
		panic(err)
	}

	// print the generated metrics documentation
	fmt.Println(buf.String())
}
