## v1.21.0

### Additions

- (declarative/v1): For Golang-based operators, copy the channels directory in the Dockerfile ([More info](https://github.com/kubernetes-sigs/kubebuilder/pull/2507/files)). ([#4863](https://github.com/operator-framework/operator-sdk/pull/4863))
- (go/v3):For Golang-based operators, new README.md will begin to be scaffolded. ([#4863](https://github.com/operator-framework/operator-sdk/pull/4863))

### Changes

- The validate package was inadvertantly exposed, it should be internal as all the other packages are in operator-sdk. The package was moved from `pkg/validate` to `internal/validate`. ([#5726](https://github.com/operator-framework/operator-sdk/pull/5726))
- Changed the default reconcile period of Ansible-based operators to 10h instead of 1m. ([#5781](https://github.com/operator-framework/operator-sdk/pull/5781))
- Bump the helm-operator-plugins dependency version to v0.0.10. ([#5772](https://github.com/operator-framework/operator-sdk/pull/5772))
- (go/v3):For Golang-based operators, upgrade controller-runtime and Kubernetes deps. ([#4863](https://github.com/operator-framework/operator-sdk/pull/4863))
- (kustomize/v1):For Golang/Helm/Ansible-based operators, upgrade kube-rbac-proxy image from v0.8.0 to v0.11.0. ([#4863](https://github.com/operator-framework/operator-sdk/pull/4863))
- (config-gen alpha command): Updated the image `gcr.io/kubebuilder/kube-rbac-proxy` from v0.5.0 to v0.11.0. ([#4863](https://github.com/operator-framework/operator-sdk/pull/4863))
- (config-gen alpha command): upgrade sigs.k8s.io/controller-tools from v0.7.0 to v0.8.0. ([#4863](https://github.com/operator-framework/operator-sdk/pull/4863))
- For Golang-based operators, change Makefile targets to replace go get with go install in order to remove deprecation and begin to be prepared to support go 1.18 in the future releases (IMPORTANT: Golang projects still not supporting versions >= 1.18. To know more about what needs to be done in order to support Golang 1.18, see [here](https://github.com/kubernetes-sigs/kubebuilder/issues/2559) ). ([#4863](https://github.com/operator-framework/operator-sdk/pull/4863))
- Update the `operator-sdk run bundle` command to have a more detailed help output, stating the intent of the command and that index-images passed via the `--index-image` flag should not already contain the bundle. ([#5727](https://github.com/operator-framework/operator-sdk/pull/5727))

### Bug Fixes

- (go/v3): For Golang-based operators, fix suite test using global cfg ([More info](https://github.com/kubernetes-sigs/kubebuilder/pull/2602)). ([#4863](https://github.com/operator-framework/operator-sdk/pull/4863))
- (go/v3): For Golang-based operators, ensure that the plugin can only be used with its go supported version >= 1.17 (IMPORTANT: Golang projects still not supporting versions >= 1.18. To know more about what needs to be done in order to support Golang 1.18, see [here](https://github.com/kubernetes-sigs/kubebuilder/issues/2559) ). ([#4863](https://github.com/operator-framework/operator-sdk/pull/4863))
- (kustomize/v1): For Golang-based operators, fix the issue to scaffold the same Kind for different groups with multi-group support by using group name in crd/patches and rbac editor/viewer manifests ([More info](https://github.com/kubernetes-sigs/kubebuilder/pull/2500)). ([#4863](https://github.com/operator-framework/operator-sdk/pull/4863))
- (kustomize/v1): For Golang-based operators, fix the issue to scaffold the same Kind for different groups with multi-group support by using group name in crd/patches and rbac editor/viewer manifests ([More info](https://github.com/kubernetes-sigs/kubebuilder/pull/2500)). ([#4863](https://github.com/operator-framework/operator-sdk/pull/4863))
- (go/v3): For Golang-based operators, avoid adding duplicated code fragments ([More info](https://github.com/kubernetes-sigs/kubebuilder/pull/2619)). ([#4863](https://github.com/operator-framework/operator-sdk/pull/4863))
