package bmtree

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/require"
)

func TestPathBitsAndMask(t *testing.T) {

	ta := require.New(t)

	u64 := func(s string) uint64 {
		i, _ := strconv.ParseUint(s, 2, 64)
		return i
	}

	cases := []struct {
		path    string
		wantlen int32
	}{
		{"00000000000000000000000000000000" + "00000000000000000000000000000000", 0},
		{"00000000000000000000000000000000" + "00000000000000000000000000000000", 0},
		{"00000000000000000000000000000000" + "00000000000000000000000000000000", 0},
		{"00000000000000000000000000000000" + "00000000000000000000000000000000", 0},
		{"00000000000000000000000000000000" + "00000000000000000000000000000001", 1},
		{"00000000000000000000000000000001" + "00000000000000000000000000000011", 2},
		{"00000000000000000000000000001100" + "00000000000000000000000000011111", 5},
		{"00000000000000000000000000011000" + "00000000000000000000000000111111", 6},
		{"00000000000000000000000000110000" + "00000000000000000000000001111111", 7},
		{"00000000000000000000000001100001" + "00000000000000000000000011111111", 8},
		{"00000000000000000000000000000000" + "00000000000000000000000000000000", 0},
		{"00000000000000000000000000000001" + "00000000000000000000000000000001", 1},
		{"00000000000000000000000000000010" + "00000000000000000000000000000011", 2},
		{"00000000000000000000000000010000" + "00000000000000000000000000011111", 5},
		{"00000000000000000000000000100001" + "00000000000000000000000000111111", 6},
		{"00000000000000000000000010000100" + "00000000000000000000000011111100", 6},
		{"10001001100011000000000000000000" + "11111111111111000000000000000000", 14},
		{"00000000000000000000000010000000" + "00000000000000000000000010000000", 1},
		{"00110010101100110011001110110100" + "11111111111111111111111111111111", 32},
		{"01100101011001100110011101101000" + "11111111111111111111111111111111", 32},
		{"11001010110011001100111011010000" + "11111111111111111111111111111110", 31},
	}

	for i, c := range cases {
		p := u64(c.path)
		gotbits := PathBits(p)
		gotmask := PathMask(p)
		ta.Equal(p>>32, gotbits, "%d-th: case: %+v", i+1, c)
		ta.Equal(p&0xffffffff, gotmask, "%d-th: case: %+v", i+1, c)
	}
}
