# Zipkin Exporter Example

Send an example span to a [Zipkin](https://zipkin.io/) service.
These instructions expect you have [docker-compose](https://docs.docker.com/compose/) installed.

Bring up the `zipkin-collector` service and example `zipkin-client` service to send an example trace:
```sh
docker-compose up --detach zipkin-collector zipkin-client
```

The `zipkin-client` service sends just one trace and exits. Retrieve the `traceId` generated by the `zipkin-client` service; should be the last line in the logs:
```sh
docker-compose logs --tail=1 zipkin-client
```

With the `traceId` you can view the trace from the `zipkin-collector` service UI hosted on port `9411`, e.g. with `traceId` of `f5695ba3b2ed00ea583fa4fa0badbeef`:
http://localhost:9411/zipkin/traces/f5695ba3b2ed00ea583fa4fa0badbeef

Shut down the services when you are finished with the example:
```sh
docker-compose down
```
