---
name: Component Request
about: Suggest component to include in this project
title: New Component: <component-name>
labels: 'enhancement'
assignees: ''

---

### Problem Statement

A clear and concise description of what the problem is.

#### Why can this component not be hosted in a different repository?

Describe the attempts to host it a different repository (preferably native to the component).

### Proposed Solution

A clear and concise description of what you want to happen.

#### Alternatives

A clear and concise description of any alternative solutions or features you've considered.

#### Prior Art

A clear and concise list of any similar and existing solutions from other projects that provide context to possible solutions.

### Additional Context

Add any other information about the request here.

### Code Owners

Name at least one person matching the [Code Owners requirements](https://github.com/open-telemetry/opentelemetry-go-contrib/blob/main/CONTRIBUTING.md#code-owners) (this can be you) who will maintain the component.

### Tasks

- Code complete:
  - [ ] Comprehensive unit tests.
  - [ ] End-to-end integration tests.
  - [ ] Tests all passing.
  - [ ] Functionality verified.
- Documented
  - [ ] Added to the [OpenTelemetry Registry](https://opentelemetry.io/registry/)
  - [ ] README included for the module describing high-level purpose.
  - [ ] Complete documentation of all public API including package documentation.
- [Examples](https://pkg.go.dev/testing#hdr-Examples) added.

<sub>**Tip**: [React](https://github.blog/news-insights/product-news/add-reactions-to-pull-requests-issues-and-comments/) with 👍 to help prioritize this issue. Please use comments to provide useful context, avoiding `+1` or `me too`, to help us triage it. Learn more [here](https://opentelemetry.io/community/end-user/issue-participation/).</sub>
