package segments

type Pnpm struct {
	Language
}

func (n *Pnpm) Enabled() bool {
	n.extensions = []string{"package.json", "pnpm-lock.yaml"}
	n.tooling = map[string]*cmd{
		"pnpm": {
			executable: "pnpm",
			args:       []string{"--version"},
			regex:      `(?P<version>((?P<major>[0-9]+).(?P<minor>[0-9]+).(?P<patch>[0-9]+)))`,
		},
	}
	n.defaultTooling = []string{"pnpm"}
	n.versionURLTemplate = "https://github.com/pnpm/pnpm/releases/tag/v{{ .Full }}"

	return n.Language.Enabled()
}

func (n *Pnpm) Template() string {
	return " \U000F02C1 {{.Full}} "
}
