package font

import (
	"encoding/gob"

	"github.com/jandedobbeleer/oh-my-posh/src/dsc"
	"github.com/jandedobbeleer/oh-my-posh/src/log"
)

func init() {
	gob.Register([]*Font{})
}

type Resource struct {
	dsc.Resource[*Font]
}

func DSC() *Resource {
	return &Resource{
		Resource: dsc.Resource[*Font]{
			JSONSchemaURL: "https://ohmyposh.dev/dsc.font.schema.json",
		},
	}
}

func (s *Resource) Apply(schema string) error {
	return s.Resource.Apply(schema)
}

func (s *Resource) Add(name string) {
	if IsLocalZipFile(name) {
		log.Debug("Skipping local zip file font:", name)
		return
	}

	s.Resource.Add(&Font{
		Name: name,
	})
}
