// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "github.com/openshift/api/config/v1"
	configv1 "github.com/openshift/client-go/config/applyconfigurations/config/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeProxies implements ProxyInterface
type FakeProxies struct {
	Fake *FakeConfigV1
}

var proxiesResource = v1.SchemeGroupVersion.WithResource("proxies")

var proxiesKind = v1.SchemeGroupVersion.WithKind("Proxy")

// Get takes name of the proxy, and returns the corresponding proxy object, and an error if there is any.
func (c *FakeProxies) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.Proxy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(proxiesResource, name), &v1.Proxy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Proxy), err
}

// List takes label and field selectors, and returns the list of Proxies that match those selectors.
func (c *FakeProxies) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ProxyList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(proxiesResource, proxiesKind, opts), &v1.ProxyList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.ProxyList{ListMeta: obj.(*v1.ProxyList).ListMeta}
	for _, item := range obj.(*v1.ProxyList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested proxies.
func (c *FakeProxies) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(proxiesResource, opts))
}

// Create takes the representation of a proxy and creates it.  Returns the server's representation of the proxy, and an error, if there is any.
func (c *FakeProxies) Create(ctx context.Context, proxy *v1.Proxy, opts metav1.CreateOptions) (result *v1.Proxy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(proxiesResource, proxy), &v1.Proxy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Proxy), err
}

// Update takes the representation of a proxy and updates it. Returns the server's representation of the proxy, and an error, if there is any.
func (c *FakeProxies) Update(ctx context.Context, proxy *v1.Proxy, opts metav1.UpdateOptions) (result *v1.Proxy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(proxiesResource, proxy), &v1.Proxy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Proxy), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeProxies) UpdateStatus(ctx context.Context, proxy *v1.Proxy, opts metav1.UpdateOptions) (*v1.Proxy, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(proxiesResource, "status", proxy), &v1.Proxy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Proxy), err
}

// Delete takes name of the proxy and deletes it. Returns an error if one occurs.
func (c *FakeProxies) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(proxiesResource, name, opts), &v1.Proxy{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeProxies) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(proxiesResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1.ProxyList{})
	return err
}

// Patch applies the patch and returns the patched proxy.
func (c *FakeProxies) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Proxy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(proxiesResource, name, pt, data, subresources...), &v1.Proxy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Proxy), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied proxy.
func (c *FakeProxies) Apply(ctx context.Context, proxy *configv1.ProxyApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Proxy, err error) {
	if proxy == nil {
		return nil, fmt.Errorf("proxy provided to Apply must not be nil")
	}
	data, err := json.Marshal(proxy)
	if err != nil {
		return nil, err
	}
	name := proxy.Name
	if name == nil {
		return nil, fmt.Errorf("proxy.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(proxiesResource, *name, types.ApplyPatchType, data), &v1.Proxy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Proxy), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeProxies) ApplyStatus(ctx context.Context, proxy *configv1.ProxyApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Proxy, err error) {
	if proxy == nil {
		return nil, fmt.Errorf("proxy provided to Apply must not be nil")
	}
	data, err := json.Marshal(proxy)
	if err != nil {
		return nil, err
	}
	name := proxy.Name
	if name == nil {
		return nil, fmt.Errorf("proxy.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(proxiesResource, *name, types.ApplyPatchType, data, "status"), &v1.Proxy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Proxy), err
}
