# Vx.x.x (Pre-release)

## Release Highlights

## Important Notes

## Breaking Changes

## Changes since v7.0.1

# V7.0.1

## Release Highlights

- Fixed a bug that meant that flag ordering mattered
- Fixed a bug where response headers for groups were not being flattened

## Important Notes

N/A

## Breaking Changes

N/A

## Changes since v7.0.0

- [#1020](https://github.com/oauth2-proxy/oauth2-proxy/pull/1020) Flatten array-based response headers (@NickMeves)
- [#1026](https://github.com/oauth2-proxy/oauth2-proxy/pull/1026) Ensure config flags get parsed correctly when other flags precede them (@JoelSpeed)

# V7.0.0

## Release Highlights

- Major internal improvements to provider interfaces
- Added group authorization support
- Improved support for external auth for Traefik
- Introduced alpha configuration format to allow users to trial new configuration format and alpha features
- GitLab provider now supports restricting to members of a project
- Keycloak provider now supports restricting users to members of a set of groups
- (Alpha) Flexible header configuration allowing user defined mapping of session claims to header values


## Important Notes

- [GHSA-4mf2-f3wh-gvf2](https://github.com/oauth2-proxy/oauth2-proxy/security/advisories/GHSA-4mf2-f3wh-gvf2) The whitelist domain feature has been updated to fix a vulnerability that was identified, please see the linked advisory for details
- [#964](https://github.com/oauth2-proxy/oauth2-proxy/pull/964) Redirect URL generation will attempt secondary strategies
  in the priority chain if any fail the `IsValidRedirect` security check. Previously any failures fell back to `/`.
- [#953](https://github.com/oauth2-proxy/oauth2-proxy/pull/953) Keycloak will now use `--profile-url` if set for the userinfo endpoint
  instead of `--validate-url`. `--validate-url` will still work for backwards compatibility.
- [#957](https://github.com/oauth2-proxy/oauth2-proxy/pull/957) To use X-Forwarded-{Proto,Host,Uri} on redirect detection, `--reverse-proxy` must be `true`.
- [#936](https://github.com/oauth2-proxy/oauth2-proxy/pull/936) `--user-id-claim` option is deprecated and replaced by `--oidc-email-claim`
- [#630](https://github.com/oauth2-proxy/oauth2-proxy/pull/630) Gitlab projects needs a Gitlab application with the extra `read_api` enabled
- [#849](https://github.com/oauth2-proxy/oauth2-proxy/pull/849) `/oauth2/auth` `allowed_groups` querystring parameter can be paired with the `allowed-groups` configuration option.
  - The `allowed_groups` querystring parameter can specify multiple comma delimited groups.
  - In this scenario, the user must have a group (from their multiple groups) present in both lists to not get a 401 or 403 response code.
  - Example:
    - OAuth2-Proxy globally sets the `allowed_groups` as `engineering`.
    - An application using Kubernetes ingress uses the `/oauth2/auth` endpoint with `allowed_groups` querystring set to `backend`.
    - A user must have a session with the groups `["engineering", "backend"]` to pass authorization.
    - Another user with the groups `["engineering", "frontend"]` would fail the querystring authorization portion.
- [#905](https://github.com/oauth2-proxy/oauth2-proxy/pull/905) Existing sessions from v6.0.0 or earlier are no longer valid. They will trigger a reauthentication.
- [#826](https://github.com/oauth2-proxy/oauth2-proxy/pull/826) `skip-auth-strip-headers` now applies to all requests, not just those where authentication would be skipped.
- [#797](https://github.com/oauth2-proxy/oauth2-proxy/pull/797) The behavior of the Google provider Groups restriction changes with this
  - Either `--google-group` or the new `--allowed-group` will work for Google now (`--google-group` will be used if both are set)
  - Group membership lists will be passed to the backend with the `X-Forwarded-Groups` header
  - If you change the list of allowed groups, existing sessions that now don't have a valid group will be logged out immediately.
    - Previously, group membership was only checked on session creation and refresh.
- [#789](https://github.com/oauth2-proxy/oauth2-proxy/pull/789) `--skip-auth-route` is (almost) backwards compatible with `--skip-auth-regex`
  - We are marking `--skip-auth-regex` as DEPRECATED and will remove it in the next major version.
  - If your regex contains an `=` and you want it for all methods, you will need to add a leading `=` (this is the area where `--skip-auth-regex` doesn't port perfectly)
- [#575](https://github.com/oauth2-proxy/oauth2-proxy/pull/575) Sessions from v5.1.1 or earlier will no longer validate since they were not signed with SHA1.
  - Sessions from v6.0.0 or later had a graceful conversion to SHA256 that resulted in no reauthentication
  - Upgrading from v5.1.1 or earlier will result in a reauthentication
- [#616](https://github.com/oauth2-proxy/oauth2-proxy/pull/616) Ensure you have configured oauth2-proxy to use the `groups` scope.
  - The user may be logged out initially as they may not currently have the `groups` claim however after going back through login process wil be authenticated.
- [#839](https://github.com/oauth2-proxy/oauth2-proxy/pull/839) Enables complex data structures for group claim entries, which are output as Json by default.

## Breaking Changes

- [#964](https://github.com/oauth2-proxy/oauth2-proxy/pull/964) `--reverse-proxy` must be true to trust `X-Forwarded-*` headers as canonical.
  These are used throughout the application in redirect URLs, cookie domains and host logging logic. These are the headers:
  - `X-Forwarded-Proto` instead of `req.URL.Scheme`
  - `X-Forwarded-Host` instead of `req.Host`
  - `X-Forwarded-Uri` instead of `req.URL.RequestURI()`
- [#953](https://github.com/oauth2-proxy/oauth2-proxy/pull/953) In config files & envvar configs, `keycloak_group` is now the plural `keycloak_groups`.
  Flag configs are still `--keycloak-group` but it can be passed multiple times.
- [#911](https://github.com/oauth2-proxy/oauth2-proxy/pull/911) Specifying a non-existent provider will cause OAuth2-Proxy to fail on startup instead of defaulting to "google".
- [#797](https://github.com/oauth2-proxy/oauth2-proxy/pull/797) Security changes to Google provider group authorization flow
  - If you change the list of allowed groups, existing sessions that now don't have a valid group will be logged out immediately.
    - Previously, group membership was only checked on session creation and refresh.
- [#722](https://github.com/oauth2-proxy/oauth2-proxy/pull/722) When a Redis session store is configured, OAuth2-Proxy will fail to start up unless connection and health checks to Redis pass
- [#800](https://github.com/oauth2-proxy/oauth2-proxy/pull/800) Fix import path for v7. The import path has changed to support the go get installation.
  - You can now `go get github.com/oauth2-proxy/oauth2-proxy/v7` to get the latest `v7` version of OAuth2 Proxy
  - Import paths for package are now under `v7`, eg `github.com/oauth2-proxy/oauth2-proxy/v7/pkg/<module>`
- [#753](https://github.com/oauth2-proxy/oauth2-proxy/pull/753) A bug in the Azure provider prevented it from properly passing the configured protected `--resource`
  via the login url. If this option was used in the past, behavior will change with this release as it will
  affect the tokens returned by Azure. In the past, the tokens were always for `https://graph.microsoft.com` (the default)
  and will now be for the configured resource (if it exists, otherwise it will run into errors)
- [#754](https://github.com/oauth2-proxy/oauth2-proxy/pull/754) The Azure provider now has token refresh functionality implemented. This means that there won't
  be any redirects in the browser anymore when tokens expire, but instead a token refresh is initiated
  in the background, which leads to new tokens being returned in the cookies.
  - Please note that `--cookie-refresh` must be 0 (the default) or equal to the token lifespan configured in Azure AD to make
    Azure token refresh reliable. Setting this value to 0 means that it relies on the provider implementation
    to decide if a refresh is required.

## Changes since v6.1.1

- [GHSA-4mf2-f3wh-gvf2](https://github.com/oauth2-proxy/oauth2-proxy/security/advisories/GHSA-4mf2-f3wh-gvf2) Subdomain checking of whitelisted domains could allow unintended redirects (@NickMeves)
- [#1002](https://github.com/oauth2-proxy/oauth2-proxy/pull/1002) Use logger for logging refreshed session in azure and gitlab provider (@Bibob7)
- [#799](https://github.com/oauth2-proxy/oauth2-proxy/pull/799) Use comma separated multiple values for header (@lilida)
- [#903](https://github.com/oauth2-proxy/oauth2-proxy/pull/903) Add docs and generated reference for Alpha configuration (@JoelSpeed)
- [#995](https://github.com/oauth2-proxy/oauth2-proxy/pull/995) Add Security Policy (@JoelSpeed)
- [#964](https://github.com/oauth2-proxy/oauth2-proxy/pull/964) Require `--reverse-proxy` true to trust `X-Forwareded-*` type headers (@NickMeves)
- [#970](https://github.com/oauth2-proxy/oauth2-proxy/pull/970) Fix joined cookie name for those containing underline in the suffix (@peppered)
- [#953](https://github.com/oauth2-proxy/oauth2-proxy/pull/953) Migrate Keycloak to EnrichSession & support multiple groups for authorization (@NickMeves)
- [#957](https://github.com/oauth2-proxy/oauth2-proxy/pull/957) Use X-Forwarded-{Proto,Host,Uri} on redirect as last resort (@linuxgemini)
- [#630](https://github.com/oauth2-proxy/oauth2-proxy/pull/630) Add support for Gitlab project based authentication (@factorysh)
- [#907](https://github.com/oauth2-proxy/oauth2-proxy/pull/907) Introduce alpha configuration option to enable testing of structured configuration (@JoelSpeed)
- [#938](https://github.com/oauth2-proxy/oauth2-proxy/pull/938) Cleanup missed provider renaming refactor methods (@NickMeves)
- [#816](https://github.com/oauth2-proxy/oauth2-proxy/pull/816) (via [#936](https://github.com/oauth2-proxy/oauth2-proxy/pull/936)) Support non-list group claims (@loafoe)
- [#936](https://github.com/oauth2-proxy/oauth2-proxy/pull/936) Refactor OIDC Provider and support groups from Profile URL (@NickMeves)
- [#869](https://github.com/oauth2-proxy/oauth2-proxy/pull/869) Streamline provider interface method names and signatures (@NickMeves)
- [#849](https://github.com/oauth2-proxy/oauth2-proxy/pull/849) Support group authorization on `oauth2/auth` endpoint via `allowed_groups` querystring (@NickMeves)
- [#925](https://github.com/oauth2-proxy/oauth2-proxy/pull/925) Fix basic auth legacy header conversion (@JoelSpeed)
- [#916](https://github.com/oauth2-proxy/oauth2-proxy/pull/916) Add AlphaOptions struct to prepare for alpha config loading (@JoelSpeed)
- [#923](https://github.com/oauth2-proxy/oauth2-proxy/pull/923) Support TLS 1.3 (@aajisaka)
- [#918](https://github.com/oauth2-proxy/oauth2-proxy/pull/918) Fix log header output (@JoelSpeed)
- [#911](https://github.com/oauth2-proxy/oauth2-proxy/pull/911) Validate provider type on startup. (@arcivanov)
- [#906](https://github.com/oauth2-proxy/oauth2-proxy/pull/906) Set up v6.1.x versioned documentation as default documentation (@JoelSpeed)
- [#905](https://github.com/oauth2-proxy/oauth2-proxy/pull/905) Remove v5 legacy sessions support (@NickMeves)
- [#904](https://github.com/oauth2-proxy/oauth2-proxy/pull/904) Set `skip-auth-strip-headers` to `true` by default (@NickMeves)
- [#826](https://github.com/oauth2-proxy/oauth2-proxy/pull/826) Integrate new header injectors into project (@JoelSpeed)
- [#797](https://github.com/oauth2-proxy/oauth2-proxy/pull/797) Create universal Authorization behavior across providers (@NickMeves)
- [#898](https://github.com/oauth2-proxy/oauth2-proxy/pull/898) Migrate documentation to Docusaurus (@JoelSpeed)
- [#754](https://github.com/oauth2-proxy/oauth2-proxy/pull/754) Azure token refresh (@codablock)
- [#850](https://github.com/oauth2-proxy/oauth2-proxy/pull/850) Increase session fields in `/oauth2/userinfo` endpoint (@NickMeves)
- [#825](https://github.com/oauth2-proxy/oauth2-proxy/pull/825) Fix code coverage reporting on GitHub actions(@JoelSpeed)
- [#796](https://github.com/oauth2-proxy/oauth2-proxy/pull/796) Deprecate GetUserName & GetEmailAdress for EnrichSessionState (@NickMeves)
- [#705](https://github.com/oauth2-proxy/oauth2-proxy/pull/705) Add generic Header injectors for upstream request and response headers (@JoelSpeed)
- [#753](https://github.com/oauth2-proxy/oauth2-proxy/pull/753) Pass resource parameter in login url (@codablock)
- [#789](https://github.com/oauth2-proxy/oauth2-proxy/pull/789) Add `--skip-auth-route` configuration option for `METHOD=pathRegex` based allowlists (@NickMeves)
- [#575](https://github.com/oauth2-proxy/oauth2-proxy/pull/575) Stop accepting legacy SHA1 signed cookies (@NickMeves)
- [#722](https://github.com/oauth2-proxy/oauth2-proxy/pull/722) Validate Redis configuration options at startup (@NickMeves)
- [#791](https://github.com/oauth2-proxy/oauth2-proxy/pull/791) Remove GetPreferredUsername method from provider interface (@NickMeves)
- [#764](https://github.com/oauth2-proxy/oauth2-proxy/pull/764) Document bcrypt encryption for htpasswd (and hide SHA) (@lentzi90)
- [#778](https://github.com/oauth2-proxy/oauth2-proxy/pull/778) Use display-htpasswd-form flag
- [#616](https://github.com/oauth2-proxy/oauth2-proxy/pull/616) Add support to ensure user belongs in required groups when using the OIDC provider (@stefansedich)
- [#800](https://github.com/oauth2-proxy/oauth2-proxy/pull/800) Fix import path for v7 (@johejo)
- [#783](https://github.com/oauth2-proxy/oauth2-proxy/pull/783) Update Go to 1.15 (@johejo)
- [#813](https://github.com/oauth2-proxy/oauth2-proxy/pull/813) Fix build (@thiagocaiubi)
- [#801](https://github.com/oauth2-proxy/oauth2-proxy/pull/801) Update go-redis/redis to v8 (@johejo)
- [#750](https://github.com/oauth2-proxy/oauth2-proxy/pull/750) ci: Migrate to Github Actions (@shinebayar-g)
- [#829](https://github.com/oauth2-proxy/oauth2-proxy/pull/820) Rename test directory to testdata (@johejo)
- [#819](https://github.com/oauth2-proxy/oauth2-proxy/pull/819) Improve CI (@johejo)
- [#989](https://github.com/oauth2-proxy/oauth2-proxy/pull/989) Adapt isAjax to support mimetype lists (@rassie)
- [#1013](https://github.com/oauth2-proxy/oauth2-proxy/pull/1013) Update alpine version to 3.13 (@nishanth-pinnapareddy)

# v6.1.1

## Release Highlights

- Fixed a bug which prevented static upstreams from being used
- Fixed a bug which prevented file based upstreams from being used
- Ensure that X-Forwarded-Host is respected consistently

## Important Notes

N/A

## Breaking

N/A

## Changes since v6.1.0

- [#729](https://github.com/oauth2-proxy/oauth2-proxy/pull/729) Use X-Forwarded-Host consistently when set (@NickMeves)
- [#746](https://github.com/oauth2-proxy/oauth2-proxy/pull/746) Fix conversion of static responses in upstreams (@JoelSpeed)

# v6.1.0

## Release Highlights

- Redis session stores now support authenticated connections
- Error logging can now be separated from info logging by directing error logs to stderr
- Added --session-cookie-minimal flag which helps prevent large session cookies
- Improvements to force-https behaviour
- Allow requests to skip authentication based on their source IP

## Important Notes

- [#632](https://github.com/oauth2-proxy/oauth2-proxy/pull/632) There is backwards compatibility to sessions from v5
  - Any unencrypted sessions from before v5 that only contained a Username & Email will trigger a reauthentication

## Breaking Changes

## Changes since v6.0.0

- [#742](https://github.com/oauth2-proxy/oauth2-proxy/pull/742) Only log no cookie match if cookie domains specified (@JoelSpeed)
- [#562](https://github.com/oauth2-proxy/oauth2-proxy/pull/562) Create generic Authorization Header constructor (@JoelSpeed)
- [#715](https://github.com/oauth2-proxy/oauth2-proxy/pull/715) Ensure session times are not nil before printing them (@JoelSpeed)
- [#714](https://github.com/oauth2-proxy/oauth2-proxy/pull/714) Support passwords with Redis session stores (@NickMeves)
- [#719](https://github.com/oauth2-proxy/oauth2-proxy/pull/719) Add Gosec fixes to areas that are intermittently flagged on PRs (@NickMeves)
- [#718](https://github.com/oauth2-proxy/oauth2-proxy/pull/718) Allow Logging to stdout with separate Error Log Channel
- [#690](https://github.com/oauth2-proxy/oauth2-proxy/pull/690) Address GoSec security findings & remediate (@NickMeves)
- [#689](https://github.com/oauth2-proxy/oauth2-proxy/pull/689) Fix finicky logging_handler_test from time drift (@NickMeves)
- [#700](https://github.com/oauth2-proxy/oauth2-proxy/pull/700) Allow OIDC Bearer auth IDTokens to have empty email claim & profile URL (@NickMeves)
- [#699](https://github.com/oauth2-proxy/oauth2-proxy/pull/699) Align persistence ginkgo tests with conventions (@NickMeves)
- [#696](https://github.com/oauth2-proxy/oauth2-proxy/pull/696) Preserve query when building redirect
- [#561](https://github.com/oauth2-proxy/oauth2-proxy/pull/561) Refactor provider URLs to package level vars (@JoelSpeed)
- [#682](https://github.com/oauth2-proxy/oauth2-proxy/pull/682) Refactor persistent session store session ticket management (@NickMeves)
- [#688](https://github.com/oauth2-proxy/oauth2-proxy/pull/688) Refactor session loading to make use of middleware pattern (@JoelSpeed)
- [#593](https://github.com/oauth2-proxy/oauth2-proxy/pull/593) Integrate upstream package with OAuth2 Proxy (@JoelSpeed)
- [#687](https://github.com/oauth2-proxy/oauth2-proxy/pull/687) Refactor HTPasswd Validator (@JoelSpeed)
- [#624](https://github.com/oauth2-proxy/oauth2-proxy/pull/624) Allow stripping authentication headers from whitelisted requests with `--skip-auth-strip-headers` (@NickMeves)
- [#673](https://github.com/oauth2-proxy/oauth2-proxy/pull/673) Add --session-cookie-minimal option to create session cookies with no tokens (@NickMeves)
- [#632](https://github.com/oauth2-proxy/oauth2-proxy/pull/632) Reduce session size by encoding with MessagePack and using LZ4 compression (@NickMeves)
- [#675](https://github.com/oauth2-proxy/oauth2-proxy/pull/675) Fix required ruby version and deprecated option for building docs (@mkontani)
- [#669](https://github.com/oauth2-proxy/oauth2-proxy/pull/669) Reduce docker context to improve build times (@JoelSpeed)
- [#668](https://github.com/oauth2-proxy/oauth2-proxy/pull/668) Use req.Host in --force-https when req.URL.Host is empty (@zucaritask)
- [#660](https://github.com/oauth2-proxy/oauth2-proxy/pull/660) Use builder pattern to simplify requests to external endpoints (@JoelSpeed)
- [#591](https://github.com/oauth2-proxy/oauth2-proxy/pull/591) Introduce upstream package with new reverse proxy implementation (@JoelSpeed)
- [#576](https://github.com/oauth2-proxy/oauth2-proxy/pull/576) Separate Cookie validation out of main options validation (@JoelSpeed)
- [#656](https://github.com/oauth2-proxy/oauth2-proxy/pull/656) Split long session cookies more precisely (@NickMeves)
- [#619](https://github.com/oauth2-proxy/oauth2-proxy/pull/619) Improve Redirect to HTTPs behaviour (@JoelSpeed)
- [#654](https://github.com/oauth2-proxy/oauth2-proxy/pull/654) Close client connections after each redis test (@JoelSpeed)
- [#542](https://github.com/oauth2-proxy/oauth2-proxy/pull/542) Move SessionStore tests to independent package (@JoelSpeed)
- [#577](https://github.com/oauth2-proxy/oauth2-proxy/pull/577) Move Cipher and Session Store initialisation out of Validation (@JoelSpeed)
- [#635](https://github.com/oauth2-proxy/oauth2-proxy/pull/635) Support specifying alternative provider TLS trust source(s) (@k-wall)
- [#649](https://github.com/oauth2-proxy/oauth2-proxy/pull/650) Resolve an issue where an empty healthcheck URL and ping-user-agent returns the healthcheck response (@jordancrawfordnz)
- [#662](https://github.com/oauth2-proxy/oauth2-proxy/pull/662) Do not add Cache-Control header to response from auth only endpoint (@johejo)
- [#552](https://github.com/oauth2-proxy/oauth2-proxy/pull/522) Implements --trusted-ip option to allow clients behind specified IPs or CIDR ranges to bypass authentication (@Izzette)
- [#733](https://github.com/oauth2-proxy/oauth2-proxy/pull/733) dist.sh: remove go version from asset links (@syscll)

# v6.0.0

## Release Highlights

- Migrated to an independent GitHub organisation
- Added local test environment examples using docker-compose and kind
- Error pages will now be rendered when upstream connections fail
- Non-Existent options in config files will now return errors on startup
- Sessions are now always encrypted, independent of configuration

## Important Notes

- (Security) Fix for [open redirect vulnerability](https://github.com/oauth2-proxy/oauth2-proxy/security/advisories/GHSA-5m6c-jp6f-2vcv).
  - More invalid redirects that lead to open-redirects were reported
  - An extensive test suite has been added to prevent future regressions
- [#453](https://github.com/oauth2-proxy/oauth2-proxy/pull/453) Responses to endpoints with a proxy prefix will now return headers for preventing browser caching.

## Breaking Changes

- [#464](https://github.com/oauth2-proxy/oauth2-proxy/pull/464) Migration from Pusher to independent org may have introduced breaking changes for your environment.
  - See the changes listed below for PR [#464](https://github.com/oauth2-proxy/oauth2-proxy/pull/464) for full details
  - Binaries renamed from `oauth2_proxy` to `oauth2-proxy`
- [#440](https://github.com/oauth2-proxy/oauth2-proxy/pull/440) Switch Azure AD Graph API to Microsoft Graph API
  - The Azure AD Graph API has been [deprecated](https://docs.microsoft.com/en-us/azure/active-directory/develop/active-directory-graph-api) and is being replaced by the Microsoft Graph API.
    If your application relies on the access token being passed to it to access the Azure AD Graph API, you should migrate your application to use the Microsoft Graph API.
    Existing behaviour can be retained by setting `-resource=https://graph.windows.net`.
- [#484](https://github.com/oauth2-proxy/oauth2-proxy/pull/484) Configuration loading has been replaced with Viper and PFlag
  - Flags now require a `--` prefix before the option
  - Previously flags allowed either `-` or `--` to prefix the option name
  - Eg `-provider` must now be `--provider`
- [#487](https://github.com/oauth2-proxy/oauth2-proxy/pull/487) Switch flags to StringSlice instead of StringArray
  - Options that take multiple arguments now split strings on commas if present
  - Eg `--foo=a,b,c,d` would result in the values `a`, `b`, `c` and `d` instead of a single `a,b,c,d` value as before
- [#535](https://github.com/oauth2-proxy/oauth2-proxy/pull/535) Drop support for pre v3.1 cookies
  - The encoding for session cookies was changed starting in v3.1.0, support for the previous encoding is now dropped
  - If you are upgrading from a version earlier than this, please upgrade via a version between v3.1.0 and v5.1.1
- [#537](https://github.com/oauth2-proxy/oauth2-proxy/pull/537) Drop Fallback to Email if User not set
  - Previously, when a session was loaded, if the User was not set, it would be replaced by the Email.
    This behaviour was inconsistent as it required the session to be stored and then loaded to function properly.
  - This behaviour has now been removed and the User field will remain empty if it was not set when the session was saved.
  - In some scenarios `X-Forwarded-User` will now be empty. Use `X-Forwarded-Email` instead.
  - In some scenarios, this may break setting Basic Auth on upstream or responses.
    Use `--prefer-email-to-user` to restore falling back to the Email in these cases.
- [#556](https://github.com/oauth2-proxy/oauth2-proxy/pull/556) Remove unintentional auto-padding of secrets that were too short
  - Previously, after cookie-secrets were opportunistically base64 decoded to raw bytes,
    they were padded to have a length divisible by 4.
  - This led to wrong sized secrets being valid AES lengths of 16, 24, or 32 bytes. Or it led to confusing errors
    reporting an invalid length of 20 or 28 when the user input cookie-secret was not that length.
  - Now we will only base64 decode a cookie-secret to raw bytes if it is 16, 24, or 32 bytes long. Otherwise, we will convert
    the direct cookie-secret to bytes without silent padding added.
- [#412](https://github.com/oauth2-proxy/oauth2-proxy/pull/412)/[#559](https://github.com/oauth2-proxy/oauth2-proxy/pull/559) Allow multiple cookie domains to be specified
  - Multiple cookie domains may now be configured. The longest domain that matches will be used.
  - The config options `cookie_domain` is now `cookie_domains`
  - The environment variable `OAUTH2_PROXY_COOKIE_DOMAIN` is now `OAUTH2_PROXY_COOKIE_DOMAINS`
- [#414](https://github.com/oauth2-proxy/oauth2-proxy/pull/414) Always encrypt sessions regardless of config
  - Previously, sessions were encrypted only when certain options were configured.
    This lead to confusion and misconfiguration as it was not obvious when a session should be encrypted.
  - Cookie Secrets must now be 16, 24 or 32 bytes.
  - If you need to change your secret, this will force users to reauthenticate.
- [#548](https://github.com/oauth2-proxy/oauth2-proxy/pull/548) Separate logging options out of main options structure
  - Fixes an inconsistency in the `--exclude-logging-paths` option by renaming it to `--exclude-logging-option`.
  - This flag may now be given multiple times as with other list options
  - This flag also accepts comma separated values
- [#639](https://github.com/oauth2-proxy/oauth2-proxy/pull/639) Change how gitlab-group is parsed on options
  - Previously, the flag gitlab-group used comma seperated values, while the config option used space seperated values.
  - This fixes the config value to use slices internally.
  - The config option `gitlab_group` is now `gitlab_groups`
  - The environment variable `OAUTH2_PROXY_GITLAB_GROUP` is now `OAUTH2_PROXY_GITLAB_GROUPS`

## Changes since v5.1.1

- [GHSA-5m6c-jp6f-2vcv](https://github.com/oauth2-proxy/oauth2-proxy/security/advisories/GHSA-5m6c-jp6f-2vcv) New OpenRedirect cases have been found (@JoelSpeed)
- [#639](https://github.com/oauth2-proxy/oauth2-proxy/pull/639) Change how gitlab-group is parsed on options (@linuxgemini)
- [#615](https://github.com/oauth2-proxy/oauth2-proxy/pull/615) Kubernetes example based on Kind cluster and Nginx ingress (@EvgeniGordeev)
- [#596](https://github.com/oauth2-proxy/oauth2-proxy/pull/596) Validate Bearer IDTokens in headers with correct provider/extra JWT Verifier (@NickMeves)
- [#620](https://github.com/oauth2-proxy/oauth2-proxy/pull/620) Add HealthCheck middleware (@JoelSpeed)
- [#597](https://github.com/oauth2-proxy/oauth2-proxy/pull/597) Don't log invalid redirect if redirect is empty (@JoelSpeed)
- [#604](https://github.com/oauth2-proxy/oauth2-proxy/pull/604) Add Keycloak local testing environment (@EvgeniGordeev)
- [#539](https://github.com/oauth2-proxy/oauth2-proxy/pull/539) Refactor encryption ciphers and add AES-GCM support (@NickMeves)
- [#601](https://github.com/oauth2-proxy/oauth2-proxy/pull/601) Ensure decrypted user/email are valid UTF8 (@JoelSpeed)
- [#560](https://github.com/oauth2-proxy/oauth2-proxy/pull/560) Fallback to UserInfo is User ID claim not present (@JoelSpeed)
- [#598](https://github.com/oauth2-proxy/oauth2-proxy/pull/598) acr_values no longer sent to IdP when empty (@ScottGuymer)
- [#548](https://github.com/oauth2-proxy/oauth2-proxy/pull/548) Separate logging options out of main options structure (@JoelSpeed)
- [#567](https://github.com/oauth2-proxy/oauth2-proxy/pull/567) Allow health/ping request to be identified via User-Agent (@chkohner)
- [#536](https://github.com/oauth2-proxy/oauth2-proxy/pull/536) Improvements to Session State code (@JoelSpeed)
- [#573](https://github.com/oauth2-proxy/oauth2-proxy/pull/573) Properly parse redis urls for cluster and sentinel connections (@amnay-mo)
- [#574](https://github.com/oauth2-proxy/oauth2-proxy/pull/574) render error page on 502 proxy status (@amnay-mo)
- [#559](https://github.com/oauth2-proxy/oauth2-proxy/pull/559) Rename cookie-domain config to cookie-domains (@JoelSpeed)
- [#569](https://github.com/oauth2-proxy/oauth2-proxy/pull/569) Updated autocompletion for `--` long options. (@Izzette)
- [#489](https://github.com/oauth2-proxy/oauth2-proxy/pull/489) Move Options and Validation to separate packages (@JoelSpeed)
- [#556](https://github.com/oauth2-proxy/oauth2-proxy/pull/556) Remove unintentional auto-padding of secrets that were too short (@NickMeves)
- [#538](https://github.com/oauth2-proxy/oauth2-proxy/pull/538) Refactor sessions/utils.go functionality to other areas (@NickMeves)
- [#503](https://github.com/oauth2-proxy/oauth2-proxy/pull/503) Implements --real-client-ip-header option to select the header from which to obtain a proxied client's IP (@Izzette)
- [#529](https://github.com/oauth2-proxy/oauth2-proxy/pull/529) Add local test environments for testing changes and new features (@JoelSpeed)
- [#537](https://github.com/oauth2-proxy/oauth2-proxy/pull/537) Drop Fallback to Email if User not set (@JoelSpeed)
- [#535](https://github.com/oauth2-proxy/oauth2-proxy/pull/535) Drop support for pre v3.1 cookies (@JoelSpeed)
- [#533](https://github.com/oauth2-proxy/oauth2-proxy/pull/487) Set up code coverage within Travis for Code Climate (@JoelSpeed)
- [#514](https://github.com/oauth2-proxy/oauth2-proxy/pull/514) Add basic string functions to templates (@n-i-x)
- [#524](https://github.com/oauth2-proxy/oauth2-proxy/pull/524) Sign cookies with SHA256 (@NickMeves)
- [#515](https://github.com/oauth2-proxy/oauth2-proxy/pull/515) Drop configure script in favour of native Makefile env and checks (@JoelSpeed)
- [#519](https://github.com/oauth2-proxy/oauth2-proxy/pull/519) Support context in providers (@johejo)
- [#487](https://github.com/oauth2-proxy/oauth2-proxy/pull/487) Switch flags to PFlag to remove StringArray (@JoelSpeed)
- [#484](https://github.com/oauth2-proxy/oauth2-proxy/pull/484) Replace configuration loading with Viper (@JoelSpeed)
- [#499](https://github.com/oauth2-proxy/oauth2-proxy/pull/499) Add `-user-id-claim` to support generic claims in addition to email (@holyjak)
- [#486](https://github.com/oauth2-proxy/oauth2-proxy/pull/486) Add new linters (@johejo)
- [#440](https://github.com/oauth2-proxy/oauth2-proxy/pull/440) Switch Azure AD Graph API to Microsoft Graph API (@johejo)
- [#453](https://github.com/oauth2-proxy/oauth2-proxy/pull/453) Prevent browser caching during auth flow (@johejo)
- [#467](https://github.com/oauth2-proxy/oauth2-proxy/pull/467) Allow OIDC issuer verification to be skipped (@chkohner)
- [#481](https://github.com/oauth2-proxy/oauth2-proxy/pull/481) Update Okta docs (@trevorbox)
- [#474](https://github.com/oauth2-proxy/oauth2-proxy/pull/474) Always log hasMember request error object (@jbielick)
- [#468](https://github.com/oauth2-proxy/oauth2-proxy/pull/468) Implement graceful shutdown and propagate request context (@johejo)
- [#464](https://github.com/oauth2-proxy/oauth2-proxy/pull/464) Migrate to oauth2-proxy/oauth2-proxy (@JoelSpeed)
  - Project renamed from `pusher/oauth2_proxy` to `oauth2-proxy`
  - Move Go import path from `github.com/pusher/oauth2_proxy` to `github.com/oauth2-proxy/oauth2-proxy`
  - Remove Pusher Cloud Team from CODEOWNERS
  - Release images moved to `quay.io/oauth2-proxy/oauth2-proxy`
  - Binaries renamed from `oauth2_proxy` to `oauth2-proxy`
- [#432](https://github.com/oauth2-proxy/oauth2-proxy/pull/432) Update ruby dependencies for documentation (@theobarberbany)
- [#471](https://github.com/oauth2-proxy/oauth2-proxy/pull/471) Add logging in case of invalid redirects (@gargath)
- [#462](https://github.com/oauth2-proxy/oauth2-proxy/pull/462) Allow HTML in banner message (@eritikass)
- [#412](https://github.com/oauth2-proxy/oauth2-proxy/pull/412) Allow multiple cookie domains to be specified (@edahlseng)
- [#413](https://github.com/oauth2-proxy/oauth2-proxy/pull/413) Add -set-basic-auth param to set the Basic Authorization header for upstreams (@morarucostel)
- [#483](https://github.com/oauth2-proxy/oauth2-proxy/pull/483) Warn users when session cookies are split (@JoelSpeed)
- [#488](https://github.com/oauth2-proxy/oauth2-proxy/pull/488) Set-Basic-Auth should default to false (@JoelSpeed)
- [#494](https://github.com/oauth2-proxy/oauth2-proxy/pull/494) Upstream websockets TLS certificate validation now depends on ssl-upstream-insecure-skip-verify (@yaroslavros)
- [#497](https://github.com/oauth2-proxy/oauth2-proxy/pull/497) Restrict access using Github collaborators (@jsclayton)
- [#414](https://github.com/oauth2-proxy/oauth2-proxy/pull/414) Always encrypt sessions regardless of config (@ti-mo)
- [#421](https://github.com/oauth2-proxy/oauth2-proxy/pull/421) Allow logins by usernames even if they do not belong to the specified org and team or collaborators (@yyoshiki41)

# v5.1.1

## Release Highlights

N/A

## Important Notes

- (Security) Fix for [open redirect vulnerability](https://github.com/oauth2-proxy/oauth2-proxy/security/advisories/GHSA-j7px-6hwj-hpjg).
  - A bad actor using encoded whitespace in redirect URIs can redirect a session to another domain

## Breaking Changes

N/A

## Changes since v5.1.0

- [GHSA-j7px-6hwj-hpjg](https://github.com/oauth2-proxy/oauth2-proxy/security/advisories/GHSA-j7px-6hwj-hpjg) Fix Open Redirect Vulnerability with encoded Whitespace characters (@JoelSpeed)

# v5.1.0

## Release Highlights

- Bump to Go 1.14
- Reduced number of Google API requests for group validation
- Support for Redis Cluster
- Support for overriding hosts in hosts file

## Important Notes

- [#335] The session expiry for the OIDC provider is now taken from the Token Response (expires_in) rather than from the id_token (exp)

## Breaking Changes

N/A

## Changes since v5.0.0

- [#450](https://github.com/oauth2-proxy/oauth2-proxy/pull/450) Fix http.Cookie SameSite is not copied (@johejo)
- [#445](https://github.com/oauth2-proxy/oauth2-proxy/pull/445) Expose `acr_values` to all providers (@holyjak)
- [#419](https://github.com/oauth2-proxy/oauth2-proxy/pull/419) Support Go 1.14, upgrade dependencies, upgrade golangci-lint to 1.23.6 (@johejo)
- [#444](https://github.com/oauth2-proxy/oauth2-proxy/pull/444) Support prompt in addition to approval-prompt (@holyjak)
- [#435](https://github.com/oauth2-proxy/oauth2-proxy/pull/435) Fix issue with group validation calling google directory API on every HTTP request (@ericofusco)
- [#400](https://github.com/oauth2-proxy/oauth2-proxy/pull/400) Add `nsswitch.conf` to Docker image to allow hosts file to work (@luketainton)
- [#385](https://github.com/oauth2-proxy/oauth2-proxy/pull/385) Use the `Authorization` header instead of `access_token` for refreshing GitHub Provider sessions (@ibuclaw)
- [#372](https://github.com/oauth2-proxy/oauth2-proxy/pull/372) Allow fallback to secondary verified email address in GitHub provider (@dmnemec)
- [#335](https://github.com/oauth2-proxy/oauth2-proxy/pull/335) OIDC Provider support for empty id_tokens in the access token refresh response (@howzat)
- [#363](https://github.com/oauth2-proxy/oauth2-proxy/pull/363) Extension of Redis Session Store to Support Redis Cluster (@yan-dblinf)
- [#353](https://github.com/oauth2-proxy/oauth2-proxy/pull/353) Fix login page fragment handling after soft reload on Firefox (@ffdybuster)
- [#355](https://github.com/oauth2-proxy/oauth2-proxy/pull/355) Add Client Secret File support for providers that rotate client secret via file system (@pasha-r)
- [#401](https://github.com/oauth2-proxy/oauth2-proxy/pull/401) Give the option to pass email address in the Basic auth header instead of upstream usernames. (@Spindel)
- [#405](https://github.com/oauth2-proxy/oauth2-proxy/pull/405) The `/sign_in` page now honors the `rd` query parameter, fixing the redirect after a successful authentication (@ti-mo)
- [#434](https://github.com/oauth2-proxy/oauth2-proxy/pull/434) Give the option to prefer email address in the username header when using the -pass-user-headers option (@jordancrawfordnz)

# v5.0.0

## Release Highlights

- Disabled CGO (binaries will work regardless og glibc/musl)
- Allow whitelisted redirect ports
- Nextcloud provider support added
- DigitalOcean provider support added

## Important Notes

- (Security) Fix for [open redirect vulnerability](https://github.com/oauth2-proxy/oauth2-proxy/security/advisories/GHSA-qqxw-m5fj-f7gv).. a bad actor using `/\` in redirect URIs can redirect a session to another domain

## Breaking Changes

- [#321](https://github.com/oauth2-proxy/oauth2-proxy/pull/331) Add reverse proxy boolean flag to control whether headers like `X-Real-Ip` are accepted.
  This defaults to false. **Usage behind a reverse proxy will require this flag to be set to avoid logging the reverse proxy IP address**.

## Changes since v4.1.0

- [#331](https://github.com/oauth2-proxy/oauth2-proxy/pull/331) Add reverse proxy setting (@martin-css)
- [#365](https://github.com/oauth2-proxy/oauth2-proxy/pull/365) Build with CGO=0 (@tomelliff)
- [#339](https://github.com/oauth2-proxy/oauth2-proxy/pull/339) Add configuration for cookie 'SameSite' value. (@pgroudas)
- [#347](https://github.com/oauth2-proxy/oauth2-proxy/pull/347) Update keycloak provider configuration documentation. (@sushiMix)
- [#325](https://github.com/oauth2-proxy/oauth2-proxy/pull/325) dist.sh: use sha256sum (@syscll)
- [#179](https://github.com/oauth2-proxy/oauth2-proxy/pull/179) Add Nextcloud provider (@Ramblurr)
- [#280](https://github.com/oauth2-proxy/oauth2-proxy/pull/280) whitelisted redirect domains: add support for whitelisting specific ports or allowing wildcard ports (@kamaln7)
- [#351](https://github.com/oauth2-proxy/oauth2-proxy/pull/351) Add DigitalOcean Auth provider (@kamaln7)

# v4.1.0

## Release Highlights

- Added Keycloak provider
- Build on Go 1.13
- Upgrade Docker image to use Debian Buster
- Added support for FreeBSD builds
- Added new logo
- Added support for GitHub teams

## Important Notes

N/A

## Breaking Changes

N/A

## Changes since v4.0.0

- [#292](https://github.com/oauth2-proxy/oauth2-proxy/pull/292) Added bash >= 4.0 dependency to configure script (@jmfrank63)
- [#227](https://github.com/oauth2-proxy/oauth2-proxy/pull/227) Add Keycloak provider (@Ofinka)
- [#259](https://github.com/oauth2-proxy/oauth2-proxy/pull/259) Redirect to HTTPS (@jmickey)
- [#273](https://github.com/oauth2-proxy/oauth2-proxy/pull/273) Support Go 1.13 (@dio)
- [#275](https://github.com/oauth2-proxy/oauth2-proxy/pull/275) docker: build from debian buster (@syscll)
- [#258](https://github.com/oauth2-proxy/oauth2-proxy/pull/258) Add IDToken for Azure provider (@leyshon)
  - This PR adds the IDToken into the session for the Azure provider allowing requests to a backend to be identified as a specific user. As a consequence, if you are using a cookie to store the session the cookie will now exceed the 4kb size limit and be split into multiple cookies. This can cause problems when using nginx as a proxy, resulting in no cookie being passed at all. Either increase the proxy_buffer_size in nginx or implement the redis session storage (see https://oauth2-proxy.github.io/oauth2-proxy/configuration#redis-storage)
- [#286](https://github.com/oauth2-proxy/oauth2-proxy/pull/286) Requests.go updated with useful error messages (@biotom)
- [#274](https://github.com/oauth2-proxy/oauth2-proxy/pull/274) Supports many github teams with api pagination support (@toshi-miura, @apratina)
- [#302](https://github.com/oauth2-proxy/oauth2-proxy/pull/302) Rewrite dist script (@syscll)
- [#304](https://github.com/oauth2-proxy/oauth2-proxy/pull/304) Add new Logo! :tada: (@JoelSpeed)
- [#300](https://github.com/oauth2-proxy/oauth2-proxy/pull/300) Added userinfo endpoint (@kbabuadze)
- [#309](https://github.com/oauth2-proxy/oauth2-proxy/pull/309) Added support for custom CA when connecting to Redis cache (@lleszczu)
- [#248](https://github.com/oauth2-proxy/oauth2-proxy/pull/248) Fix issue with X-Auth-Request-Redirect header being ignored (@webnard)
- [#314](https://github.com/oauth2-proxy/oauth2-proxy/pull/314) Add redirect capability to sign_out (@costelmoraru)
- [#265](https://github.com/oauth2-proxy/oauth2-proxy/pull/265) Add upstream with static response (@cgroschupp)
- [#317](https://github.com/oauth2-proxy/oauth2-proxy/pull/317) Add build for FreeBSD (@fnkr)
- [#296](https://github.com/oauth2-proxy/oauth2-proxy/pull/296) Allow to override provider's name for sign-in page (@ffdybuster)

# v4.0.0

## Release Highlights

- Documentation is now on a [microsite](https://oauth2-proxy.github.io/oauth2-proxy/)
- Health check logging can now be disabled for quieter logs
- Authorization Header JWTs can now be verified by the proxy to skip authentication for machine users
- Sessions can now be stored in Redis. This reduces refresh failures and uses smaller cookies (Recommended for those using OIDC refreshing)
- Logging overhaul allows customisable logging formats

## Important Notes

- This release includes a number of breaking changes that will require users to
  reconfigure their proxies. Please read the Breaking Changes below thoroughly.

## Breaking Changes

- [#231](https://github.com/oauth2-proxy/oauth2-proxy/pull/231) Rework GitLab provider
  - This PR changes the configuration options for the GitLab provider to use
    a self-hosted instance. You now need to specify a `-oidc-issuer-url` rather than
    explicit `-login-url`, `-redeem-url` and `-validate-url` parameters.
- [#186](https://github.com/oauth2-proxy/oauth2-proxy/pull/186) Make config consistent
  - This PR changes configuration options so that all flags have a config counterpart
    of the same name but with underscores (`_`) in place of hyphens (`-`).
    This change affects the following flags:
  - The `--tls-key` flag is now `--tls-key-file` to be consistent with existing
    file flags and the existing config and environment settings
  - The `--tls-cert` flag is now `--tls-cert-file` to be consistent with existing
    file flags and the existing config and environment settings
    This change affects the following existing configuration options:
  - The `proxy-prefix` option is now `proxy_prefix`.
    This PR changes environment variables so that all flags have an environment
    counterpart of the same name but capitalised, with underscores (`_`) in place
    of hyphens (`-`) and with the prefix `OAUTH2_PROXY_`.
    This change affects the following existing environment variables:
  - The `OAUTH2_SKIP_OIDC_DISCOVERY` environment variable is now `OAUTH2_PROXY_SKIP_OIDC_DISCOVERY`.
  - The `OAUTH2_OIDC_JWKS_URL` environment variable is now `OAUTH2_PROXY_OIDC_JWKS_URL`.
- [#146](https://github.com/oauth2-proxy/oauth2-proxy/pull/146) Use full email address as `User` if the auth response did not contain a `User` field
  - This change modifies the contents of the `X-Forwarded-User` header supplied by the proxy for users where the auth response from the IdP did not contain
    a username.
    In that case, this header used to only contain the local part of the user's email address (e.g. `john.doe` for `john.doe@example.com`) but now contains
    the user's full email address instead.
- [#170](https://github.com/oauth2-proxy/oauth2-proxy/pull/170) Pre-built binary tarballs changed format
  - The pre-built binary tarballs again match the format of the [bitly](https://github.com/bitly/oauth2_proxy) repository, where the unpacked directory
    has the same name as the tarball and the binary is always named `oauth2_proxy`. This was done to restore compatibility with third-party automation
    recipes like https://github.com/jhoblitt/puppet-oauth2_proxy.

## Changes since v3.2.0

- [#234](https://github.com/oauth2-proxy/oauth2-proxy/pull/234) Added option `-ssl-upstream-insecure-skip-validation` to skip validation of upstream SSL certificates (@jansinger)
- [#224](https://github.com/oauth2-proxy/oauth2-proxy/pull/224) Check Google group membership using hasMember to support nested groups and external users (@jpalpant)
- [#231](https://github.com/oauth2-proxy/oauth2-proxy/pull/231) Add optional group membership and email domain checks to the GitLab provider (@Overv)
- [#226](https://github.com/oauth2-proxy/oauth2-proxy/pull/226) Made setting of proxied headers deterministic based on configuration alone (@aeijdenberg)
- [#178](https://github.com/oauth2-proxy/oauth2-proxy/pull/178) Add Silence Ping Logging and Exclude Logging Paths flags (@kskewes)
- [#209](https://github.com/oauth2-proxy/oauth2-proxy/pull/209) Improve docker build caching of layers (@dekimsey)
- [#186](https://github.com/oauth2-proxy/oauth2-proxy/pull/186) Make config consistent (@JoelSpeed)
- [#187](https://github.com/oauth2-proxy/oauth2-proxy/pull/187) Move root packages to pkg folder (@JoelSpeed)
- [#65](https://github.com/oauth2-proxy/oauth2-proxy/pull/65) Improvements to authenticate requests with a JWT bearer token in the `Authorization` header via
  the `-skip-jwt-bearer-token` options. (@brianv0)
  - Additional verifiers can be configured via the `-extra-jwt-issuers` flag if the JWT issuers is either an OpenID provider or has a JWKS URL
    (e.g. `https://example.com/.well-known/jwks.json`).
- [#180](https://github.com/oauth2-proxy/oauth2-proxy/pull/180) Minor refactor of core proxying path (@aeijdenberg).
- [#175](https://github.com/oauth2-proxy/oauth2-proxy/pull/175) Bump go-oidc to v2.0.0 (@aeijdenberg).
  - Includes fix for potential signature checking issue when OIDC discovery is skipped.
- [#155](https://github.com/oauth2-proxy/oauth2-proxy/pull/155) Add RedisSessionStore implementation (@brianv0, @JoelSpeed)
  - Implement flags to configure the redis session store
    - `-session-store-type=redis` Sets the store type to redis
    - `-redis-connection-url` Sets the Redis connection URL
    - `-redis-use-sentinel=true` Enables Redis Sentinel support
    - `-redis-sentinel-master-name` Sets the Sentinel master name, if sentinel is enabled
    - `-redis-sentinel-connection-urls` Defines the Redis Sentinel Connection URLs, if sentinel is enabled
  - Introduces the concept of a session ticket. Tickets are composed of the cookie name, a session ID, and a secret.
  - Redis Sessions are stored encrypted with a per-session secret
  - Added tests for server based session stores
- [#168](https://github.com/oauth2-proxy/oauth2-proxy/pull/168) Drop Go 1.11 support in Travis (@JoelSpeed)
- [#169](https://github.com/oauth2-proxy/oauth2-proxy/pull/169) Update Alpine to 3.9 (@kskewes)
- [#148](https://github.com/oauth2-proxy/oauth2-proxy/pull/148) Implement SessionStore interface within proxy (@JoelSpeed)
- [#147](https://github.com/oauth2-proxy/oauth2-proxy/pull/147) Add SessionStore interfaces and initial implementation (@JoelSpeed)
  - Allows for multiple different session storage implementations including client and server side
  - Adds tests suite for interface to ensure consistency across implementations
  - Refactor some configuration options (around cookies) into packages
- [#114](https://github.com/oauth2-proxy/oauth2-proxy/pull/114), [#154](https://github.com/oauth2-proxy/oauth2-proxy/pull/154) Documentation is now available live at our [docs website](https://oauth2-proxy.github.io/oauth2-proxy/) (@JoelSpeed, @icelynjennings)
- [#146](https://github.com/oauth2-proxy/oauth2-proxy/pull/146) Use full email address as `User` if the auth response did not contain a `User` field (@gargath)
- [#144](https://github.com/oauth2-proxy/oauth2-proxy/pull/144) Use GO 1.12 for ARM builds (@kskewes)
- [#142](https://github.com/oauth2-proxy/oauth2-proxy/pull/142) ARM Docker USER fix (@kskewes)
- [#52](https://github.com/oauth2-proxy/oauth2-proxy/pull/52) Logging Improvements (@MisterWil)
  - Implement flags to configure file logging
    - `-logging-filename` Defines the filename to log to
    - `-logging-max-size` Defines the maximum
    - `-logging-max-age` Defines the maximum age of backups to retain
    - `-logging-max-backups` Defines the maximum number of rollover log files to retain
    - `-logging-compress` Defines if rollover log files should be compressed
    - `-logging-local-time` Defines if logging date and time should be local or UTC
  - Implement two new flags to enable or disable specific logging types
    - `-standard-logging` Enables or disables standard (not request or auth) logging
    - `-auth-logging` Enables or disables auth logging
  - Implement two new flags to customize the logging format
    - `-standard-logging-format` Sets the format for standard logging
    - `-auth-logging-format` Sets the format for auth logging
- [#111](https://github.com/oauth2-proxy/oauth2-proxy/pull/111) Add option for telling where to find a login.gov JWT key file (@timothy-spencer)
- [#170](https://github.com/oauth2-proxy/oauth2-proxy/pull/170) Restore binary tarball contents to be compatible with bitlys original tarballs (@zeha)
- [#185](https://github.com/oauth2-proxy/oauth2-proxy/pull/185) Fix an unsupported protocol scheme error during token validation when using the Azure provider (@jonas)
- [#141](https://github.com/oauth2-proxy/oauth2-proxy/pull/141) Check google group membership based on email address (@bchess)
  - Google Group membership is additionally checked via email address, allowing users outside a GSuite domain to be authorized.
- [#195](https://github.com/oauth2-proxy/oauth2-proxy/pull/195) Add `-banner` flag for overriding the banner line that is displayed (@steakunderscore)
- [#198](https://github.com/oauth2-proxy/oauth2-proxy/pull/198) Switch from gometalinter to golangci-lint (@steakunderscore)
- [#159](https://github.com/oauth2-proxy/oauth2-proxy/pull/159) Add option to skip the OIDC provider verified email check: `--insecure-oidc-allow-unverified-email` (@djfinlay)
- [#210](https://github.com/oauth2-proxy/oauth2-proxy/pull/210) Update base image from Alpine 3.9 to 3.10 (@steakunderscore)
- [#201](https://github.com/oauth2-proxy/oauth2-proxy/pull/201) Add Bitbucket as new OAuth2 provider, accepts email, team and repository permissions to determine authorization (@aledeganopix4d)
  - Implement flags to enable Bitbucket authentication:
    - `-bitbucket-repository` Restrict authorization to users that can access this repository
    - `-bitbucket-team` Restrict authorization to users that are part of this Bitbucket team
- [#211](https://github.com/oauth2-proxy/oauth2-proxy/pull/211) Switch from dep to go modules (@steakunderscore)
- [#145](https://github.com/oauth2-proxy/oauth2-proxy/pull/145) Add support for OIDC UserInfo endpoint email verification (@rtluckie)

# v3.2.0

## Release highlights

- Internal restructure of session state storage to use JSON rather than proprietary scheme
- Added health check options for running on GCP behind a load balancer
- Improved support for protecting websockets
- Added provider for login.gov
- Allow manual configuration of OIDC providers

## Important notes

- Dockerfile user is now non-root, this may break your existing deployment
- In the OIDC provider, when no email is returned, the ID Token subject will be used
  instead of returning an error
- GitHub user emails must now be primary and verified before authenticating

## Changes since v3.1.0

- [#96](https://github.com/bitly/oauth2_proxy/pull/96) Check if email is verified on GitHub (@caarlos0)
- [#110](https://github.com/oauth2-proxy/oauth2-proxy/pull/110) Added GCP healthcheck option (@timothy-spencer)
- [#112](https://github.com/oauth2-proxy/oauth2-proxy/pull/112) Improve websocket support (@gyson)
- [#63](https://github.com/oauth2-proxy/oauth2-proxy/pull/63) Use encoding/json for SessionState serialization (@yaegashi)
  - Use JSON to encode session state to be stored in browser cookies
  - Implement legacy decode function to support existing cookies generated by older versions
  - Add detailed table driven tests in session_state_test.go
- [#120](https://github.com/oauth2-proxy/oauth2-proxy/pull/120) Encrypting user/email from cookie (@costelmoraru)
- [#55](https://github.com/oauth2-proxy/oauth2-proxy/pull/55) Added login.gov provider (@timothy-spencer)
- [#55](https://github.com/oauth2-proxy/oauth2-proxy/pull/55) Added environment variables for all config options (@timothy-spencer)
- [#70](https://github.com/oauth2-proxy/oauth2-proxy/pull/70) Fix handling of splitted cookies (@einfachchr)
- [#92](https://github.com/oauth2-proxy/oauth2-proxy/pull/92) Merge websocket proxy feature from openshift/oauth-proxy (@butzist)
- [#57](https://github.com/oauth2-proxy/oauth2-proxy/pull/57) Fall back to using OIDC Subject instead of Email (@aigarius)
- [#85](https://github.com/oauth2-proxy/oauth2-proxy/pull/85) Use non-root user in docker images (@kskewes)
- [#68](https://github.com/oauth2-proxy/oauth2-proxy/pull/68) forward X-Auth-Access-Token header (@davidholsgrove)
- [#41](https://github.com/oauth2-proxy/oauth2-proxy/pull/41) Added option to manually specify OIDC endpoints instead of relying on discovery
- [#83](https://github.com/oauth2-proxy/oauth2-proxy/pull/83) Add `id_token` refresh to Google provider (@leki75)
- [#10](https://github.com/oauth2-proxy/oauth2-proxy/pull/10) fix redirect url param handling (@dt-rush)
- [#122](https://github.com/oauth2-proxy/oauth2-proxy/pull/122) Expose -cookie-path as configuration parameter (@costelmoraru)
- [#124](https://github.com/oauth2-proxy/oauth2-proxy/pull/124) Use Go 1.12 for testing and build environments (@syscll)

# v3.1.0

## Release highlights

- Introduction of ARM releases and and general improvements to Docker builds
- Improvements to OIDC provider allowing pass-through of ID Tokens
- Multiple redirect domains can now be whitelisted
- Streamed responses are now flushed periodically

## Important notes

- If you have been using [#bitly/621](https://github.com/bitly/oauth2_proxy/pull/621)
  and have cookies larger than the 4kb limit,
  the cookie splitting pattern has changed and now uses `_` in place of `-` when
  indexing cookies.
  This will force users to reauthenticate the first time they use `v3.1.0`.
- Streamed responses will now be flushed every 1 second by default.
  Previously streamed responses were flushed only when the buffer was full.
  To retain the old behaviour set `--flush-interval=0`.
  See [#23](https://github.com/oauth2-proxy/oauth2-proxy/pull/23) for further details.

## Changes since v3.0.0

- [#14](https://github.com/oauth2-proxy/oauth2-proxy/pull/14) OIDC ID Token, Authorization Headers, Refreshing and Verification (@joelspeed)
  - Implement `pass-authorization-header` and `set-authorization-header` flags
  - Implement token refreshing in OIDC provider
  - Split cookies larger than 4k limit into multiple cookies
  - Implement token validation in OIDC provider
- [#15](https://github.com/oauth2-proxy/oauth2-proxy/pull/15) WhitelistDomains (@joelspeed)
  - Add `--whitelist-domain` flag to allow redirection to approved domains after OAuth flow
- [#21](https://github.com/oauth2-proxy/oauth2-proxy/pull/21) Docker Improvement (@yaegashi)
  - Move Docker base image from debian to alpine
  - Install ca-certificates in docker image
- [#23](https://github.com/oauth2-proxy/oauth2-proxy/pull/23) Flushed streaming responses
  - Long-running upstream responses will get flushed every <timeperiod> (1 second by default)
- [#24](https://github.com/oauth2-proxy/oauth2-proxy/pull/24) Redirect fix (@agentgonzo)
  - After a successful login, you will be redirected to your original URL rather than /
- [#35](https://github.com/oauth2-proxy/oauth2-proxy/pull/35) arm and arm64 binary releases (@kskewes)
  - Add armv6 and arm64 to Makefile `release` target
- [#37](https://github.com/oauth2-proxy/oauth2-proxy/pull/37) cross build arm and arm64 docker images (@kskewes)

# v3.0.0

Adoption of OAuth2_Proxy by Pusher.
Project was hard forked and tidied however no logical changes have occurred since
v2.2 as released by Bitly.

## Changes since v2.2:

- [#7](https://github.com/oauth2-proxy/oauth2-proxy/pull/7) Migration to Pusher (@joelspeed)
  - Move automated build to debian base image
  - Add Makefile
    - Update CI to run `make test`
    - Update Dockerfile to use `make clean oauth2_proxy`
    - Update `VERSION` parameter to be set by `ldflags` from Git Status
    - Remove lint and test scripts
  - Remove Go v1.8.x from Travis CI testing
  - Add CODEOWNERS file
  - Add CONTRIBUTING guide
  - Add Issue and Pull Request templates
  - Add Dockerfile
  - Fix fsnotify import
  - Update README to reflect new repository ownership
  - Update CI scripts to separate linting and testing
    - Now using `gometalinter` for linting
  - Move Go import path from `github.com/bitly/oauth2_proxy` to `github.com/pusher/oauth2_proxy`
  - Repository forked on 27/11/18
    - README updated to include note that this repository is forked
    - CHANGLOG created to track changes to repository from original fork
