// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// DO NOT EDIT: this file is automatically generated by docgen
package templates

import (
	"github.com/projectdiscovery/yamldoc-go/encoder"
)

var (
	TemplateDoc                   encoder.Doc
	MODELInfoDoc                  encoder.Doc
	STRINGSLICEStringSliceDoc     encoder.Doc
	STRINGSLICERawStringSliceDoc  encoder.Doc
	SEVERITYHolderDoc             encoder.Doc
	MODELClassificationDoc        encoder.Doc
	HTTPRequestDoc                encoder.Doc
	GENERATORSAttackTypeHolderDoc encoder.Doc
	HTTPMethodTypeHolderDoc       encoder.Doc
	FUZZRuleDoc                   encoder.Doc
	SliceOrMapSliceDoc            encoder.Doc
	SignatureTypeHolderDoc        encoder.Doc
	MATCHERSMatcherDoc            encoder.Doc
	MatcherTypeHolderDoc          encoder.Doc
	DNSRequestDoc                 encoder.Doc
	DNSRequestTypeHolderDoc       encoder.Doc
	FILERequestDoc                encoder.Doc
	NETWORKRequestDoc             encoder.Doc
	NETWORKInputDoc               encoder.Doc
	NetworkInputTypeHolderDoc     encoder.Doc
	HEADLESSRequestDoc            encoder.Doc
	ENGINEActionDoc               encoder.Doc
	ActionTypeHolderDoc           encoder.Doc
	USERAGENTUserAgentHolderDoc   encoder.Doc
	SSLRequestDoc                 encoder.Doc
	WEBSOCKETRequestDoc           encoder.Doc
	WEBSOCKETInputDoc             encoder.Doc
	WHOISRequestDoc               encoder.Doc
	CODERequestDoc                encoder.Doc
	JAVASCRIPTRequestDoc          encoder.Doc
	HTTPSignatureTypeHolderDoc    encoder.Doc
	VARIABLESVariableDoc          encoder.Doc
)

func init() {
	TemplateDoc.Type = "Template"
	TemplateDoc.Comments[encoder.LineComment] = " Template is a YAML input file which defines all the requests and"
	TemplateDoc.Description = "Template is a YAML input file which defines all the requests and\n other metadata for a template."
	TemplateDoc.Fields = make([]encoder.Doc, 20)
	TemplateDoc.Fields[0].Name = "id"
	TemplateDoc.Fields[0].Type = "string"
	TemplateDoc.Fields[0].Note = ""
	TemplateDoc.Fields[0].Description = "ID is the unique id for the template.\n\n#### Good IDs\n\nA good ID uniquely identifies what the requests in the template\nare doing. Let's say you have a template that identifies a git-config\nfile on the webservers, a good name would be `git-config-exposure`. Another\nexample name is `azure-apps-nxdomain-takeover`."
	TemplateDoc.Fields[0].Comments[encoder.LineComment] = "ID is the unique id for the template."

	TemplateDoc.Fields[0].AddExample("ID Example", "CVE-2021-19520")
	TemplateDoc.Fields[1].Name = "info"
	TemplateDoc.Fields[1].Type = "model.Info"
	TemplateDoc.Fields[1].Note = ""
	TemplateDoc.Fields[1].Description = "Info contains metadata information about the template."
	TemplateDoc.Fields[1].Comments[encoder.LineComment] = "Info contains metadata information about the template."

	TemplateDoc.Fields[1].AddExample("", exampleInfoStructure)
	TemplateDoc.Fields[2].Name = "flow"
	TemplateDoc.Fields[2].Type = "string"
	TemplateDoc.Fields[2].Note = ""
	TemplateDoc.Fields[2].Description = "description: |\n   Flow contains the execution flow for the template.\n examples:\n   - flow: |\n 		for region in regions {\n		    http(0)\n		 }\n		 for vpc in vpcs {\n		    http(1)\n		 }\n"
	TemplateDoc.Fields[2].Comments[encoder.LineComment] = " description: |"
	TemplateDoc.Fields[3].Name = "requests"
	TemplateDoc.Fields[3].Type = "[]http.Request"
	TemplateDoc.Fields[3].Note = ""
	TemplateDoc.Fields[3].Description = "Requests contains the http request to make in the template.\nWARNING: 'requests' will be deprecated and will be removed in a future release. Please use 'http' instead."
	TemplateDoc.Fields[3].Comments[encoder.LineComment] = "Requests contains the http request to make in the template."

	TemplateDoc.Fields[3].AddExample("", exampleNormalHTTPRequest)
	TemplateDoc.Fields[4].Name = "http"
	TemplateDoc.Fields[4].Type = "[]http.Request"
	TemplateDoc.Fields[4].Note = ""
	TemplateDoc.Fields[4].Description = "description: |\n   HTTP contains the http request to make in the template.\n examples:\n   - value: exampleNormalHTTPRequest\n RequestsWithHTTP is placeholder(internal) only, and should not be used instead use RequestsHTTP\n Deprecated: Use RequestsHTTP instead."
	TemplateDoc.Fields[4].Comments[encoder.LineComment] = " description: |"
	TemplateDoc.Fields[5].Name = "dns"
	TemplateDoc.Fields[5].Type = "[]dns.Request"
	TemplateDoc.Fields[5].Note = ""
	TemplateDoc.Fields[5].Description = "DNS contains the dns request to make in the template"
	TemplateDoc.Fields[5].Comments[encoder.LineComment] = "DNS contains the dns request to make in the template"

	TemplateDoc.Fields[5].AddExample("", exampleNormalDNSRequest)
	TemplateDoc.Fields[6].Name = "file"
	TemplateDoc.Fields[6].Type = "[]file.Request"
	TemplateDoc.Fields[6].Note = ""
	TemplateDoc.Fields[6].Description = "File contains the file request to make in the template"
	TemplateDoc.Fields[6].Comments[encoder.LineComment] = "File contains the file request to make in the template"

	TemplateDoc.Fields[6].AddExample("", exampleNormalFileRequest)
	TemplateDoc.Fields[7].Name = "network"
	TemplateDoc.Fields[7].Type = "[]network.Request"
	TemplateDoc.Fields[7].Note = ""
	TemplateDoc.Fields[7].Description = "Network contains the network request to make in the template\nWARNING: 'network' will be deprecated and will be removed in a future release. Please use 'tcp' instead."
	TemplateDoc.Fields[7].Comments[encoder.LineComment] = "Network contains the network request to make in the template"

	TemplateDoc.Fields[7].AddExample("", exampleNormalNetworkRequest)
	TemplateDoc.Fields[8].Name = "tcp"
	TemplateDoc.Fields[8].Type = "[]network.Request"
	TemplateDoc.Fields[8].Note = ""
	TemplateDoc.Fields[8].Description = "description: |\n   TCP contains the network request to make in the template\n examples:\n   - value: exampleNormalNetworkRequest\n RequestsWithTCP is placeholder(internal) only, and should not be used instead use RequestsNetwork\n Deprecated: Use RequestsNetwork instead."
	TemplateDoc.Fields[8].Comments[encoder.LineComment] = " description: |"
	TemplateDoc.Fields[9].Name = "headless"
	TemplateDoc.Fields[9].Type = "[]headless.Request"
	TemplateDoc.Fields[9].Note = ""
	TemplateDoc.Fields[9].Description = "Headless contains the headless request to make in the template."
	TemplateDoc.Fields[9].Comments[encoder.LineComment] = "Headless contains the headless request to make in the template."
	TemplateDoc.Fields[10].Name = "ssl"
	TemplateDoc.Fields[10].Type = "[]ssl.Request"
	TemplateDoc.Fields[10].Note = ""
	TemplateDoc.Fields[10].Description = "SSL contains the SSL request to make in the template."
	TemplateDoc.Fields[10].Comments[encoder.LineComment] = "SSL contains the SSL request to make in the template."
	TemplateDoc.Fields[11].Name = "websocket"
	TemplateDoc.Fields[11].Type = "[]websocket.Request"
	TemplateDoc.Fields[11].Note = ""
	TemplateDoc.Fields[11].Description = "Websocket contains the Websocket request to make in the template."
	TemplateDoc.Fields[11].Comments[encoder.LineComment] = "Websocket contains the Websocket request to make in the template."
	TemplateDoc.Fields[12].Name = "whois"
	TemplateDoc.Fields[12].Type = "[]whois.Request"
	TemplateDoc.Fields[12].Note = ""
	TemplateDoc.Fields[12].Description = "WHOIS contains the WHOIS request to make in the template."
	TemplateDoc.Fields[12].Comments[encoder.LineComment] = "WHOIS contains the WHOIS request to make in the template."
	TemplateDoc.Fields[13].Name = "code"
	TemplateDoc.Fields[13].Type = "[]code.Request"
	TemplateDoc.Fields[13].Note = ""
	TemplateDoc.Fields[13].Description = "Code contains code snippets."
	TemplateDoc.Fields[13].Comments[encoder.LineComment] = "Code contains code snippets."
	TemplateDoc.Fields[14].Name = "javascript"
	TemplateDoc.Fields[14].Type = "[]javascript.Request"
	TemplateDoc.Fields[14].Note = ""
	TemplateDoc.Fields[14].Description = "Javascript contains the javascript request to make in the template."
	TemplateDoc.Fields[14].Comments[encoder.LineComment] = "Javascript contains the javascript request to make in the template."
	TemplateDoc.Fields[15].Name = "self-contained"
	TemplateDoc.Fields[15].Type = "bool"
	TemplateDoc.Fields[15].Note = ""
	TemplateDoc.Fields[15].Description = "Self Contained marks Requests for the template as self-contained"
	TemplateDoc.Fields[15].Comments[encoder.LineComment] = "Self Contained marks Requests for the template as self-contained"
	TemplateDoc.Fields[16].Name = "stop-at-first-match"
	TemplateDoc.Fields[16].Type = "bool"
	TemplateDoc.Fields[16].Note = ""
	TemplateDoc.Fields[16].Description = "Stop execution once first match is found"
	TemplateDoc.Fields[16].Comments[encoder.LineComment] = "Stop execution once first match is found"
	TemplateDoc.Fields[17].Name = "signature"
	TemplateDoc.Fields[17].Type = "http.SignatureTypeHolder"
	TemplateDoc.Fields[17].Note = ""
	TemplateDoc.Fields[17].Description = "Signature is the request signature method\nWARNING: 'signature' will be deprecated and will be removed in a future release. Prefer using 'code' protocol for writing cloud checks"
	TemplateDoc.Fields[17].Comments[encoder.LineComment] = "Signature is the request signature method"
	TemplateDoc.Fields[17].Values = []string{
		"AWS",
	}
	TemplateDoc.Fields[18].Name = "variables"
	TemplateDoc.Fields[18].Type = "variables.Variable"
	TemplateDoc.Fields[18].Note = ""
	TemplateDoc.Fields[18].Description = "Variables contains any variables for the current request."
	TemplateDoc.Fields[18].Comments[encoder.LineComment] = "Variables contains any variables for the current request."
	TemplateDoc.Fields[19].Name = "constants"
	TemplateDoc.Fields[19].Type = "map[string]interface{}"
	TemplateDoc.Fields[19].Note = ""
	TemplateDoc.Fields[19].Description = "Constants contains any scalar constant for the current template"
	TemplateDoc.Fields[19].Comments[encoder.LineComment] = "Constants contains any scalar constant for the current template"

	MODELInfoDoc.Type = "model.Info"
	MODELInfoDoc.Comments[encoder.LineComment] = " Info contains metadata information about a template"
	MODELInfoDoc.Description = "Info contains metadata information about a template"

	MODELInfoDoc.AddExample("", exampleInfoStructure)
	MODELInfoDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "info",
		},
	}
	MODELInfoDoc.Fields = make([]encoder.Doc, 10)
	MODELInfoDoc.Fields[0].Name = "name"
	MODELInfoDoc.Fields[0].Type = "string"
	MODELInfoDoc.Fields[0].Note = ""
	MODELInfoDoc.Fields[0].Description = "Name should be good short summary that identifies what the template does."
	MODELInfoDoc.Fields[0].Comments[encoder.LineComment] = "Name should be good short summary that identifies what the template does."

	MODELInfoDoc.Fields[0].AddExample("", "bower.json file disclosure")

	MODELInfoDoc.Fields[0].AddExample("", "Nagios Default Credentials Check")
	MODELInfoDoc.Fields[1].Name = "author"
	MODELInfoDoc.Fields[1].Type = "stringslice.StringSlice"
	MODELInfoDoc.Fields[1].Note = ""
	MODELInfoDoc.Fields[1].Description = "Author of the template.\n\nMultiple values can also be specified separated by commas."
	MODELInfoDoc.Fields[1].Comments[encoder.LineComment] = "Author of the template."

	MODELInfoDoc.Fields[1].AddExample("", "<username>")
	MODELInfoDoc.Fields[2].Name = "tags"
	MODELInfoDoc.Fields[2].Type = "stringslice.StringSlice"
	MODELInfoDoc.Fields[2].Note = ""
	MODELInfoDoc.Fields[2].Description = "Any tags for the template.\n\nMultiple values can also be specified separated by commas."
	MODELInfoDoc.Fields[2].Comments[encoder.LineComment] = "Any tags for the template."

	MODELInfoDoc.Fields[2].AddExample("Example tags", "cve,cve2019,grafana,auth-bypass,dos")
	MODELInfoDoc.Fields[3].Name = "description"
	MODELInfoDoc.Fields[3].Type = "string"
	MODELInfoDoc.Fields[3].Note = ""
	MODELInfoDoc.Fields[3].Description = "Description of the template.\n\nYou can go in-depth here on what the template actually does."
	MODELInfoDoc.Fields[3].Comments[encoder.LineComment] = "Description of the template."

	MODELInfoDoc.Fields[3].AddExample("", "Bower is a package manager which stores package information in the bower.json file")

	MODELInfoDoc.Fields[3].AddExample("", "Subversion ALM for the enterprise before 8.8.2 allows reflected XSS at multiple locations")
	MODELInfoDoc.Fields[4].Name = "impact"
	MODELInfoDoc.Fields[4].Type = "string"
	MODELInfoDoc.Fields[4].Note = ""
	MODELInfoDoc.Fields[4].Description = "Impact of the template.\n\nYou can go in-depth here on impact of the template."
	MODELInfoDoc.Fields[4].Comments[encoder.LineComment] = "Impact of the template."

	MODELInfoDoc.Fields[4].AddExample("", "Successful exploitation of this vulnerability could allow an attacker to execute arbitrary SQL queries, potentially leading to unauthorized access, data leakage, or data manipulation.")

	MODELInfoDoc.Fields[4].AddExample("", "Successful exploitation of this vulnerability could allow an attacker to execute arbitrary script code in the context of the victim's browser, potentially leading to session hijacking, defacement, or theft of sensitive information.")
	MODELInfoDoc.Fields[5].Name = "reference"
	MODELInfoDoc.Fields[5].Type = "stringslice.RawStringSlice"
	MODELInfoDoc.Fields[5].Note = ""
	MODELInfoDoc.Fields[5].Description = "References for the template.\n\nThis should contain links relevant to the template."
	MODELInfoDoc.Fields[5].Comments[encoder.LineComment] = "References for the template."

	MODELInfoDoc.Fields[5].AddExample("", []string{"https://github.com/strapi/strapi", "https://github.com/getgrav/grav"})
	MODELInfoDoc.Fields[6].Name = "severity"
	MODELInfoDoc.Fields[6].Type = "severity.Holder"
	MODELInfoDoc.Fields[6].Note = ""
	MODELInfoDoc.Fields[6].Description = "Severity of the template."
	MODELInfoDoc.Fields[6].Comments[encoder.LineComment] = "Severity of the template."
	MODELInfoDoc.Fields[7].Name = "metadata"
	MODELInfoDoc.Fields[7].Type = "map[string]interface{}"
	MODELInfoDoc.Fields[7].Note = ""
	MODELInfoDoc.Fields[7].Description = "Metadata of the template."
	MODELInfoDoc.Fields[7].Comments[encoder.LineComment] = "Metadata of the template."

	MODELInfoDoc.Fields[7].AddExample("", map[string]string{"customField1": "customValue1"})
	MODELInfoDoc.Fields[8].Name = "classification"
	MODELInfoDoc.Fields[8].Type = "model.Classification"
	MODELInfoDoc.Fields[8].Note = ""
	MODELInfoDoc.Fields[8].Description = "Classification contains classification information about the template."
	MODELInfoDoc.Fields[8].Comments[encoder.LineComment] = "Classification contains classification information about the template."
	MODELInfoDoc.Fields[9].Name = "remediation"
	MODELInfoDoc.Fields[9].Type = "string"
	MODELInfoDoc.Fields[9].Note = ""
	MODELInfoDoc.Fields[9].Description = "Remediation steps for the template.\n\nYou can go in-depth here on how to mitigate the problem found by this template."
	MODELInfoDoc.Fields[9].Comments[encoder.LineComment] = "Remediation steps for the template."

	MODELInfoDoc.Fields[9].AddExample("", "Change the default administrative username and password of Apache ActiveMQ by editing the file jetty-realm.properties")

	STRINGSLICEStringSliceDoc.Type = "stringslice.StringSlice"
	STRINGSLICEStringSliceDoc.Comments[encoder.LineComment] = " StringSlice represents a single (in-lined) or multiple string value(s)."
	STRINGSLICEStringSliceDoc.Description = "StringSlice represents a single (in-lined) or multiple string value(s).\n The unmarshaller does not automatically convert in-lined strings to []string, hence the interface{} type is required."

	STRINGSLICEStringSliceDoc.AddExample("", "<username>")

	STRINGSLICEStringSliceDoc.AddExample("Example tags", "cve,cve2019,grafana,auth-bypass,dos")

	STRINGSLICEStringSliceDoc.AddExample("", "CVE-2020-14420")

	STRINGSLICEStringSliceDoc.AddExample("", "CWE-22")
	STRINGSLICEStringSliceDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "model.Info",
			FieldName: "author",
		},
		{
			TypeName:  "model.Info",
			FieldName: "tags",
		},
		{
			TypeName:  "model.Classification",
			FieldName: "cve-id",
		},
		{
			TypeName:  "model.Classification",
			FieldName: "cwe-id",
		},
	}
	STRINGSLICEStringSliceDoc.Fields = make([]encoder.Doc, 0)

	STRINGSLICERawStringSliceDoc.Type = "stringslice.RawStringSlice"
	STRINGSLICERawStringSliceDoc.Comments[encoder.LineComment] = ""
	STRINGSLICERawStringSliceDoc.Description = ""

	STRINGSLICERawStringSliceDoc.AddExample("", []string{"https://github.com/strapi/strapi", "https://github.com/getgrav/grav"})
	STRINGSLICERawStringSliceDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "model.Info",
			FieldName: "reference",
		},
	}
	STRINGSLICERawStringSliceDoc.Fields = make([]encoder.Doc, 0)

	SEVERITYHolderDoc.Type = "severity.Holder"
	SEVERITYHolderDoc.Comments[encoder.LineComment] = " Holder holds a Severity type. Required for un/marshalling purposes"
	SEVERITYHolderDoc.Description = "Holder holds a Severity type. Required for un/marshalling purposes"
	SEVERITYHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "model.Info",
			FieldName: "severity",
		},
	}
	SEVERITYHolderDoc.Fields = make([]encoder.Doc, 1)
	SEVERITYHolderDoc.Fields[0].Name = ""
	SEVERITYHolderDoc.Fields[0].Type = "Severity"
	SEVERITYHolderDoc.Fields[0].Note = ""
	SEVERITYHolderDoc.Fields[0].Description = ""
	SEVERITYHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	SEVERITYHolderDoc.Fields[0].EnumFields = []string{
		"undefined",
		"info",
		"low",
		"medium",
		"high",
		"critical",
		"unknown",
	}

	MODELClassificationDoc.Type = "model.Classification"
	MODELClassificationDoc.Comments[encoder.LineComment] = ""
	MODELClassificationDoc.Description = ""
	MODELClassificationDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "model.Info",
			FieldName: "classification",
		},
	}
	MODELClassificationDoc.Fields = make([]encoder.Doc, 7)
	MODELClassificationDoc.Fields[0].Name = "cve-id"
	MODELClassificationDoc.Fields[0].Type = "stringslice.StringSlice"
	MODELClassificationDoc.Fields[0].Note = ""
	MODELClassificationDoc.Fields[0].Description = "CVE ID for the template"
	MODELClassificationDoc.Fields[0].Comments[encoder.LineComment] = "CVE ID for the template"

	MODELClassificationDoc.Fields[0].AddExample("", "CVE-2020-14420")
	MODELClassificationDoc.Fields[1].Name = "cwe-id"
	MODELClassificationDoc.Fields[1].Type = "stringslice.StringSlice"
	MODELClassificationDoc.Fields[1].Note = ""
	MODELClassificationDoc.Fields[1].Description = "CWE ID for the template."
	MODELClassificationDoc.Fields[1].Comments[encoder.LineComment] = "CWE ID for the template."

	MODELClassificationDoc.Fields[1].AddExample("", "CWE-22")
	MODELClassificationDoc.Fields[2].Name = "cvss-metrics"
	MODELClassificationDoc.Fields[2].Type = "string"
	MODELClassificationDoc.Fields[2].Note = ""
	MODELClassificationDoc.Fields[2].Description = "CVSS Metrics for the template."
	MODELClassificationDoc.Fields[2].Comments[encoder.LineComment] = "CVSS Metrics for the template."

	MODELClassificationDoc.Fields[2].AddExample("", "3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H")
	MODELClassificationDoc.Fields[3].Name = "cvss-score"
	MODELClassificationDoc.Fields[3].Type = "float64"
	MODELClassificationDoc.Fields[3].Note = ""
	MODELClassificationDoc.Fields[3].Description = "CVSS Score for the template."
	MODELClassificationDoc.Fields[3].Comments[encoder.LineComment] = "CVSS Score for the template."

	MODELClassificationDoc.Fields[3].AddExample("", "9.8")
	MODELClassificationDoc.Fields[4].Name = "epss-score"
	MODELClassificationDoc.Fields[4].Type = "float64"
	MODELClassificationDoc.Fields[4].Note = ""
	MODELClassificationDoc.Fields[4].Description = "EPSS Score for the template."
	MODELClassificationDoc.Fields[4].Comments[encoder.LineComment] = "EPSS Score for the template."

	MODELClassificationDoc.Fields[4].AddExample("", "0.42509")
	MODELClassificationDoc.Fields[5].Name = "epss-percentile"
	MODELClassificationDoc.Fields[5].Type = "float64"
	MODELClassificationDoc.Fields[5].Note = ""
	MODELClassificationDoc.Fields[5].Description = "EPSS Percentile for the template."
	MODELClassificationDoc.Fields[5].Comments[encoder.LineComment] = "EPSS Percentile for the template."

	MODELClassificationDoc.Fields[5].AddExample("", "0.42509")
	MODELClassificationDoc.Fields[6].Name = "cpe"
	MODELClassificationDoc.Fields[6].Type = "string"
	MODELClassificationDoc.Fields[6].Note = ""
	MODELClassificationDoc.Fields[6].Description = "CPE for the template."
	MODELClassificationDoc.Fields[6].Comments[encoder.LineComment] = "CPE for the template."

	MODELClassificationDoc.Fields[6].AddExample("", "cpe:/a:vendor:product:version")

	HTTPRequestDoc.Type = "http.Request"
	HTTPRequestDoc.Comments[encoder.LineComment] = " Request contains a http request to be made from a template"
	HTTPRequestDoc.Description = "Request contains a http request to be made from a template"

	HTTPRequestDoc.AddExample("", exampleNormalHTTPRequest)
	HTTPRequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "requests",
		},
		{
			TypeName:  "Template",
			FieldName: "http",
		},
	}
	HTTPRequestDoc.PartDefinitions = []encoder.KeyValue{
		{
			Key:   "template-id",
			Value: "ID of the template executed",
		},
		{
			Key:   "template-info",
			Value: "Info Block of the template executed",
		},
		{
			Key:   "template-path",
			Value: "Path of the template executed",
		},
		{
			Key:   "host",
			Value: "Host is the input to the template",
		},
		{
			Key:   "matched",
			Value: "Matched is the input which was matched upon",
		},
		{
			Key:   "type",
			Value: "Type is the type of request made",
		},
		{
			Key:   "request",
			Value: "HTTP request made from the client",
		},
		{
			Key:   "response",
			Value: "HTTP response received from server",
		},
		{
			Key:   "status_code",
			Value: "Status Code received from the Server",
		},
		{
			Key:   "body",
			Value: "HTTP response body received from server (default)",
		},
		{
			Key:   "content_length",
			Value: "HTTP Response content length",
		},
		{
			Key:   "header,all_headers",
			Value: "HTTP response headers",
		},
		{
			Key:   "duration",
			Value: "HTTP request time duration",
		},
		{
			Key:   "all",
			Value: "HTTP response body + headers",
		},
		{
			Key:   "cookies_from_response",
			Value: "HTTP response cookies in name:value format",
		},
		{
			Key:   "headers_from_response",
			Value: "HTTP response headers in name:value format",
		},
	}
	HTTPRequestDoc.Fields = make([]encoder.Doc, 37)
	HTTPRequestDoc.Fields[0].Name = "path"
	HTTPRequestDoc.Fields[0].Type = "[]string"
	HTTPRequestDoc.Fields[0].Note = ""
	HTTPRequestDoc.Fields[0].Description = "Path contains the path/s for the HTTP requests. It supports variables\nas placeholders."
	HTTPRequestDoc.Fields[0].Comments[encoder.LineComment] = "Path contains the path/s for the HTTP requests. It supports variables"

	HTTPRequestDoc.Fields[0].AddExample("Some example path values", []string{"{{BaseURL}}", "{{BaseURL}}/+CSCOU+/../+CSCOE+/files/file_list.json?path=/sessions"})
	HTTPRequestDoc.Fields[1].Name = "raw"
	HTTPRequestDoc.Fields[1].Type = "[]string"
	HTTPRequestDoc.Fields[1].Note = ""
	HTTPRequestDoc.Fields[1].Description = "Raw contains HTTP Requests in Raw format."
	HTTPRequestDoc.Fields[1].Comments[encoder.LineComment] = "Raw contains HTTP Requests in Raw format."

	HTTPRequestDoc.Fields[1].AddExample("Some example raw requests", []string{"GET /etc/passwd HTTP/1.1\nHost:\nContent-Length: 4", "POST /.%0d./.%0d./.%0d./.%0d./bin/sh HTTP/1.1\nHost: {{Hostname}}\nUser-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0\nContent-Length: 1\nConnection: close\n\necho\necho\ncat /etc/passwd 2>&1"})
	HTTPRequestDoc.Fields[2].Name = "id"
	HTTPRequestDoc.Fields[2].Type = "string"
	HTTPRequestDoc.Fields[2].Note = ""
	HTTPRequestDoc.Fields[2].Description = "ID is the optional id of the request"
	HTTPRequestDoc.Fields[2].Comments[encoder.LineComment] = " ID is the optional id of the request"
	HTTPRequestDoc.Fields[3].Name = "name"
	HTTPRequestDoc.Fields[3].Type = "string"
	HTTPRequestDoc.Fields[3].Note = ""
	HTTPRequestDoc.Fields[3].Description = "Name is the optional name of the request.\n\nIf a name is specified, all the named request in a template can be matched upon\nin a combined manner allowing multi-request based matchers."
	HTTPRequestDoc.Fields[3].Comments[encoder.LineComment] = "Name is the optional name of the request."
	HTTPRequestDoc.Fields[4].Name = "attack"
	HTTPRequestDoc.Fields[4].Type = "generators.AttackTypeHolder"
	HTTPRequestDoc.Fields[4].Note = ""
	HTTPRequestDoc.Fields[4].Description = "Attack is the type of payload combinations to perform.\n\nbatteringram is inserts the same payload into all defined payload positions at once, pitchfork combines multiple payload sets and clusterbomb generates\npermutations and combinations for all payloads."
	HTTPRequestDoc.Fields[4].Comments[encoder.LineComment] = "Attack is the type of payload combinations to perform."
	HTTPRequestDoc.Fields[4].Values = []string{
		"batteringram",
		"pitchfork",
		"clusterbomb",
	}
	HTTPRequestDoc.Fields[5].Name = "method"
	HTTPRequestDoc.Fields[5].Type = "HTTPMethodTypeHolder"
	HTTPRequestDoc.Fields[5].Note = ""
	HTTPRequestDoc.Fields[5].Description = "Method is the HTTP Request Method."
	HTTPRequestDoc.Fields[5].Comments[encoder.LineComment] = "Method is the HTTP Request Method."
	HTTPRequestDoc.Fields[6].Name = "body"
	HTTPRequestDoc.Fields[6].Type = "string"
	HTTPRequestDoc.Fields[6].Note = ""
	HTTPRequestDoc.Fields[6].Description = "Body is an optional parameter which contains HTTP Request body."
	HTTPRequestDoc.Fields[6].Comments[encoder.LineComment] = "Body is an optional parameter which contains HTTP Request body."

	HTTPRequestDoc.Fields[6].AddExample("Same Body for a Login POST request", "username=test&password=test")
	HTTPRequestDoc.Fields[7].Name = "payloads"
	HTTPRequestDoc.Fields[7].Type = "map[string]interface{}"
	HTTPRequestDoc.Fields[7].Note = ""
	HTTPRequestDoc.Fields[7].Description = "Payloads contains any payloads for the current request.\n\nPayloads support both key-values combinations where a list\nof payloads is provided, or optionally a single file can also\nbe provided as payload which will be read on run-time."
	HTTPRequestDoc.Fields[7].Comments[encoder.LineComment] = "Payloads contains any payloads for the current request."
	HTTPRequestDoc.Fields[8].Name = "headers"
	HTTPRequestDoc.Fields[8].Type = "map[string]string"
	HTTPRequestDoc.Fields[8].Note = ""
	HTTPRequestDoc.Fields[8].Description = "Headers contains HTTP Headers to send with the request."
	HTTPRequestDoc.Fields[8].Comments[encoder.LineComment] = "Headers contains HTTP Headers to send with the request."

	HTTPRequestDoc.Fields[8].AddExample("", map[string]string{"Content-Type": "application/x-www-form-urlencoded", "Content-Length": "1", "Any-Header": "Any-Value"})
	HTTPRequestDoc.Fields[9].Name = "race_count"
	HTTPRequestDoc.Fields[9].Type = "int"
	HTTPRequestDoc.Fields[9].Note = ""
	HTTPRequestDoc.Fields[9].Description = "RaceCount is the number of times to send a request in Race Condition Attack."
	HTTPRequestDoc.Fields[9].Comments[encoder.LineComment] = "RaceCount is the number of times to send a request in Race Condition Attack."

	HTTPRequestDoc.Fields[9].AddExample("Send a request 5 times", 5)
	HTTPRequestDoc.Fields[10].Name = "max-redirects"
	HTTPRequestDoc.Fields[10].Type = "int"
	HTTPRequestDoc.Fields[10].Note = ""
	HTTPRequestDoc.Fields[10].Description = "MaxRedirects is the maximum number of redirects that should be followed."
	HTTPRequestDoc.Fields[10].Comments[encoder.LineComment] = "MaxRedirects is the maximum number of redirects that should be followed."

	HTTPRequestDoc.Fields[10].AddExample("Follow up to 5 redirects", 5)
	HTTPRequestDoc.Fields[11].Name = "pipeline-concurrent-connections"
	HTTPRequestDoc.Fields[11].Type = "int"
	HTTPRequestDoc.Fields[11].Note = ""
	HTTPRequestDoc.Fields[11].Description = "PipelineConcurrentConnections is number of connections to create during pipelining."
	HTTPRequestDoc.Fields[11].Comments[encoder.LineComment] = "PipelineConcurrentConnections is number of connections to create during pipelining."

	HTTPRequestDoc.Fields[11].AddExample("Create 40 concurrent connections", 40)
	HTTPRequestDoc.Fields[12].Name = "pipeline-requests-per-connection"
	HTTPRequestDoc.Fields[12].Type = "int"
	HTTPRequestDoc.Fields[12].Note = ""
	HTTPRequestDoc.Fields[12].Description = "PipelineRequestsPerConnection is number of requests to send per connection when pipelining."
	HTTPRequestDoc.Fields[12].Comments[encoder.LineComment] = "PipelineRequestsPerConnection is number of requests to send per connection when pipelining."

	HTTPRequestDoc.Fields[12].AddExample("Send 100 requests per pipeline connection", 100)
	HTTPRequestDoc.Fields[13].Name = "threads"
	HTTPRequestDoc.Fields[13].Type = "int"
	HTTPRequestDoc.Fields[13].Note = ""
	HTTPRequestDoc.Fields[13].Description = "Threads specifies number of threads to use sending requests. This enables Connection Pooling.\n\nConnection: Close attribute must not be used in request while using threads flag, otherwise\npooling will fail and engine will continue to close connections after requests."
	HTTPRequestDoc.Fields[13].Comments[encoder.LineComment] = "Threads specifies number of threads to use sending requests. This enables Connection Pooling."

	HTTPRequestDoc.Fields[13].AddExample("Send requests using 10 concurrent threads", 10)
	HTTPRequestDoc.Fields[14].Name = "max-size"
	HTTPRequestDoc.Fields[14].Type = "int"
	HTTPRequestDoc.Fields[14].Note = ""
	HTTPRequestDoc.Fields[14].Description = "MaxSize is the maximum size of http response body to read in bytes."
	HTTPRequestDoc.Fields[14].Comments[encoder.LineComment] = "MaxSize is the maximum size of http response body to read in bytes."

	HTTPRequestDoc.Fields[14].AddExample("Read max 2048 bytes of the response", 2048)
	HTTPRequestDoc.Fields[15].Name = "fuzzing"
	HTTPRequestDoc.Fields[15].Type = "[]fuzz.Rule"
	HTTPRequestDoc.Fields[15].Note = ""
	HTTPRequestDoc.Fields[15].Description = "Fuzzing describes schema to fuzz http requests"
	HTTPRequestDoc.Fields[15].Comments[encoder.LineComment] = " Fuzzing describes schema to fuzz http requests"
	HTTPRequestDoc.Fields[16].Name = "self-contained"
	HTTPRequestDoc.Fields[16].Type = "bool"
	HTTPRequestDoc.Fields[16].Note = ""
	HTTPRequestDoc.Fields[16].Description = "SelfContained specifies if the request is self-contained."
	HTTPRequestDoc.Fields[16].Comments[encoder.LineComment] = "SelfContained specifies if the request is self-contained."
	HTTPRequestDoc.Fields[17].Name = "signature"
	HTTPRequestDoc.Fields[17].Type = "SignatureTypeHolder"
	HTTPRequestDoc.Fields[17].Note = ""
	HTTPRequestDoc.Fields[17].Description = "Signature is the request signature method"
	HTTPRequestDoc.Fields[17].Comments[encoder.LineComment] = "Signature is the request signature method"
	HTTPRequestDoc.Fields[17].Values = []string{
		"AWS",
	}
	HTTPRequestDoc.Fields[18].Name = "skip-secret-file"
	HTTPRequestDoc.Fields[18].Type = "bool"
	HTTPRequestDoc.Fields[18].Note = ""
	HTTPRequestDoc.Fields[18].Description = "SkipSecretFile skips the authentication or authorization configured in the secret file."
	HTTPRequestDoc.Fields[18].Comments[encoder.LineComment] = "SkipSecretFile skips the authentication or authorization configured in the secret file."
	HTTPRequestDoc.Fields[19].Name = "cookie-reuse"
	HTTPRequestDoc.Fields[19].Type = "bool"
	HTTPRequestDoc.Fields[19].Note = ""
	HTTPRequestDoc.Fields[19].Description = "CookieReuse is an optional setting that enables cookie reuse for\nall requests defined in raw section."
	HTTPRequestDoc.Fields[19].Comments[encoder.LineComment] = "CookieReuse is an optional setting that enables cookie reuse for"
	HTTPRequestDoc.Fields[20].Name = "disable-cookie"
	HTTPRequestDoc.Fields[20].Type = "bool"
	HTTPRequestDoc.Fields[20].Note = ""
	HTTPRequestDoc.Fields[20].Description = "DisableCookie is an optional setting that disables cookie reuse"
	HTTPRequestDoc.Fields[20].Comments[encoder.LineComment] = "DisableCookie is an optional setting that disables cookie reuse"
	HTTPRequestDoc.Fields[21].Name = "read-all"
	HTTPRequestDoc.Fields[21].Type = "bool"
	HTTPRequestDoc.Fields[21].Note = ""
	HTTPRequestDoc.Fields[21].Description = "Enables force reading of the entire raw unsafe request body ignoring\nany specified content length headers."
	HTTPRequestDoc.Fields[21].Comments[encoder.LineComment] = "Enables force reading of the entire raw unsafe request body ignoring"
	HTTPRequestDoc.Fields[22].Name = "redirects"
	HTTPRequestDoc.Fields[22].Type = "bool"
	HTTPRequestDoc.Fields[22].Note = ""
	HTTPRequestDoc.Fields[22].Description = "Redirects specifies whether redirects should be followed by the HTTP Client.\n\nThis can be used in conjunction with `max-redirects` to control the HTTP request redirects."
	HTTPRequestDoc.Fields[22].Comments[encoder.LineComment] = "Redirects specifies whether redirects should be followed by the HTTP Client."
	HTTPRequestDoc.Fields[23].Name = "host-redirects"
	HTTPRequestDoc.Fields[23].Type = "bool"
	HTTPRequestDoc.Fields[23].Note = ""
	HTTPRequestDoc.Fields[23].Description = "Redirects specifies whether only redirects to the same host should be followed by the HTTP Client.\n\nThis can be used in conjunction with `max-redirects` to control the HTTP request redirects."
	HTTPRequestDoc.Fields[23].Comments[encoder.LineComment] = "Redirects specifies whether only redirects to the same host should be followed by the HTTP Client."
	HTTPRequestDoc.Fields[24].Name = "pipeline"
	HTTPRequestDoc.Fields[24].Type = "bool"
	HTTPRequestDoc.Fields[24].Note = ""
	HTTPRequestDoc.Fields[24].Description = "Pipeline defines if the attack should be performed with HTTP 1.1 Pipelining\n\nAll requests must be idempotent (GET/POST). This can be used for race conditions/billions requests."
	HTTPRequestDoc.Fields[24].Comments[encoder.LineComment] = "Pipeline defines if the attack should be performed with HTTP 1.1 Pipelining"
	HTTPRequestDoc.Fields[25].Name = "unsafe"
	HTTPRequestDoc.Fields[25].Type = "bool"
	HTTPRequestDoc.Fields[25].Note = ""
	HTTPRequestDoc.Fields[25].Description = "Unsafe specifies whether to use rawhttp engine for sending Non RFC-Compliant requests.\n\nThis uses the [rawhttp](https://github.com/projectdiscovery/rawhttp) engine to achieve complete\ncontrol over the request, with no normalization performed by the client."
	HTTPRequestDoc.Fields[25].Comments[encoder.LineComment] = "Unsafe specifies whether to use rawhttp engine for sending Non RFC-Compliant requests."
	HTTPRequestDoc.Fields[26].Name = "race"
	HTTPRequestDoc.Fields[26].Type = "bool"
	HTTPRequestDoc.Fields[26].Note = ""
	HTTPRequestDoc.Fields[26].Description = "Race determines if all the request have to be attempted at the same time (Race Condition)\n\nThe actual number of requests that will be sent is determined by the `race_count`  field."
	HTTPRequestDoc.Fields[26].Comments[encoder.LineComment] = "Race determines if all the request have to be attempted at the same time (Race Condition)"
	HTTPRequestDoc.Fields[27].Name = "req-condition"
	HTTPRequestDoc.Fields[27].Type = "bool"
	HTTPRequestDoc.Fields[27].Note = ""
	HTTPRequestDoc.Fields[27].Description = "ReqCondition automatically assigns numbers to requests and preserves their history.\n\nThis allows matching on them later for multi-request conditions."
	HTTPRequestDoc.Fields[27].Comments[encoder.LineComment] = "ReqCondition automatically assigns numbers to requests and preserves their history."
	HTTPRequestDoc.Fields[28].Name = "stop-at-first-match"
	HTTPRequestDoc.Fields[28].Type = "bool"
	HTTPRequestDoc.Fields[28].Note = ""
	HTTPRequestDoc.Fields[28].Description = "StopAtFirstMatch stops the execution of the requests and template as soon as a match is found."
	HTTPRequestDoc.Fields[28].Comments[encoder.LineComment] = "StopAtFirstMatch stops the execution of the requests and template as soon as a match is found."
	HTTPRequestDoc.Fields[29].Name = "skip-variables-check"
	HTTPRequestDoc.Fields[29].Type = "bool"
	HTTPRequestDoc.Fields[29].Note = ""
	HTTPRequestDoc.Fields[29].Description = "SkipVariablesCheck skips the check for unresolved variables in request"
	HTTPRequestDoc.Fields[29].Comments[encoder.LineComment] = "SkipVariablesCheck skips the check for unresolved variables in request"
	HTTPRequestDoc.Fields[30].Name = "iterate-all"
	HTTPRequestDoc.Fields[30].Type = "bool"
	HTTPRequestDoc.Fields[30].Note = ""
	HTTPRequestDoc.Fields[30].Description = "IterateAll iterates all the values extracted from internal extractors"
	HTTPRequestDoc.Fields[30].Comments[encoder.LineComment] = "IterateAll iterates all the values extracted from internal extractors"
	HTTPRequestDoc.Fields[31].Name = "digest-username"
	HTTPRequestDoc.Fields[31].Type = "string"
	HTTPRequestDoc.Fields[31].Note = ""
	HTTPRequestDoc.Fields[31].Description = "DigestAuthUsername specifies the username for digest authentication"
	HTTPRequestDoc.Fields[31].Comments[encoder.LineComment] = "DigestAuthUsername specifies the username for digest authentication"
	HTTPRequestDoc.Fields[32].Name = "digest-password"
	HTTPRequestDoc.Fields[32].Type = "string"
	HTTPRequestDoc.Fields[32].Note = ""
	HTTPRequestDoc.Fields[32].Description = "DigestAuthPassword specifies the password for digest authentication"
	HTTPRequestDoc.Fields[32].Comments[encoder.LineComment] = "DigestAuthPassword specifies the password for digest authentication"
	HTTPRequestDoc.Fields[33].Name = "disable-path-automerge"
	HTTPRequestDoc.Fields[33].Type = "bool"
	HTTPRequestDoc.Fields[33].Note = ""
	HTTPRequestDoc.Fields[33].Description = "DisablePathAutomerge disables merging target url path with raw request path"
	HTTPRequestDoc.Fields[33].Comments[encoder.LineComment] = "DisablePathAutomerge disables merging target url path with raw request path"
	HTTPRequestDoc.Fields[34].Name = "pre-condition"
	HTTPRequestDoc.Fields[34].Type = "[]matchers.Matcher"
	HTTPRequestDoc.Fields[34].Note = ""
	HTTPRequestDoc.Fields[34].Description = "Fuzz PreCondition is matcher-like field to check if fuzzing should be performed on this request or not"
	HTTPRequestDoc.Fields[34].Comments[encoder.LineComment] = "Fuzz PreCondition is matcher-like field to check if fuzzing should be performed on this request or not"
	HTTPRequestDoc.Fields[35].Name = "pre-condition-operator"
	HTTPRequestDoc.Fields[35].Type = "string"
	HTTPRequestDoc.Fields[35].Note = ""
	HTTPRequestDoc.Fields[35].Description = "FuzzPreConditionOperator is the operator between multiple PreConditions for fuzzing Default is OR"
	HTTPRequestDoc.Fields[35].Comments[encoder.LineComment] = "FuzzPreConditionOperator is the operator between multiple PreConditions for fuzzing Default is OR"
	HTTPRequestDoc.Fields[36].Name = "global-matchers"
	HTTPRequestDoc.Fields[36].Type = "bool"
	HTTPRequestDoc.Fields[36].Note = ""
	HTTPRequestDoc.Fields[36].Description = "GlobalMatchers marks matchers as static and applies globally to all result events from other templates"
	HTTPRequestDoc.Fields[36].Comments[encoder.LineComment] = "GlobalMatchers marks matchers as static and applies globally to all result events from other templates"

	GENERATORSAttackTypeHolderDoc.Type = "generators.AttackTypeHolder"
	GENERATORSAttackTypeHolderDoc.Comments[encoder.LineComment] = " AttackTypeHolder is used to hold internal type of the protocol"
	GENERATORSAttackTypeHolderDoc.Description = "AttackTypeHolder is used to hold internal type of the protocol"
	GENERATORSAttackTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "http.Request",
			FieldName: "attack",
		},
		{
			TypeName:  "dns.Request",
			FieldName: "attack",
		},
		{
			TypeName:  "network.Request",
			FieldName: "attack",
		},
		{
			TypeName:  "headless.Request",
			FieldName: "attack",
		},
		{
			TypeName:  "websocket.Request",
			FieldName: "attack",
		},
		{
			TypeName:  "javascript.Request",
			FieldName: "attack",
		},
	}
	GENERATORSAttackTypeHolderDoc.Fields = make([]encoder.Doc, 1)
	GENERATORSAttackTypeHolderDoc.Fields[0].Name = ""
	GENERATORSAttackTypeHolderDoc.Fields[0].Type = "AttackType"
	GENERATORSAttackTypeHolderDoc.Fields[0].Note = ""
	GENERATORSAttackTypeHolderDoc.Fields[0].Description = ""
	GENERATORSAttackTypeHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	GENERATORSAttackTypeHolderDoc.Fields[0].EnumFields = []string{
		"batteringram",
		"pitchfork",
		"clusterbomb",
	}

	HTTPMethodTypeHolderDoc.Type = "HTTPMethodTypeHolder"
	HTTPMethodTypeHolderDoc.Comments[encoder.LineComment] = " HTTPMethodTypeHolder is used to hold internal type of the HTTP Method"
	HTTPMethodTypeHolderDoc.Description = "HTTPMethodTypeHolder is used to hold internal type of the HTTP Method"
	HTTPMethodTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "http.Request",
			FieldName: "method",
		},
	}
	HTTPMethodTypeHolderDoc.Fields = make([]encoder.Doc, 1)
	HTTPMethodTypeHolderDoc.Fields[0].Name = ""
	HTTPMethodTypeHolderDoc.Fields[0].Type = "HTTPMethodType"
	HTTPMethodTypeHolderDoc.Fields[0].Note = ""
	HTTPMethodTypeHolderDoc.Fields[0].Description = ""
	HTTPMethodTypeHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	HTTPMethodTypeHolderDoc.Fields[0].EnumFields = []string{
		"GET",
		"HEAD",
		"POST",
		"PUT",
		"DELETE",
		"CONNECT",
		"OPTIONS",
		"TRACE",
		"PATCH",
		"PURGE",
		"Debug",
	}

	FUZZRuleDoc.Type = "fuzz.Rule"
	FUZZRuleDoc.Comments[encoder.LineComment] = " Rule is a single rule which describes how to fuzz the request"
	FUZZRuleDoc.Description = "Rule is a single rule which describes how to fuzz the request"
	FUZZRuleDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "http.Request",
			FieldName: "fuzzing",
		},
		{
			TypeName:  "headless.Request",
			FieldName: "fuzzing",
		},
	}
	FUZZRuleDoc.Fields = make([]encoder.Doc, 9)
	FUZZRuleDoc.Fields[0].Name = "type"
	FUZZRuleDoc.Fields[0].Type = "string"
	FUZZRuleDoc.Fields[0].Note = ""
	FUZZRuleDoc.Fields[0].Description = "Type is the type of fuzzing rule to perform.\n\nreplace replaces the values entirely. prefix prefixes the value. postfix postfixes the value\nand infix places between the values."
	FUZZRuleDoc.Fields[0].Comments[encoder.LineComment] = "Type is the type of fuzzing rule to perform."
	FUZZRuleDoc.Fields[0].Values = []string{
		"replace",
		"prefix",
		"postfix",
		"infix",
	}
	FUZZRuleDoc.Fields[1].Name = "part"
	FUZZRuleDoc.Fields[1].Type = "string"
	FUZZRuleDoc.Fields[1].Note = ""
	FUZZRuleDoc.Fields[1].Description = "Part is the part of request to fuzz."
	FUZZRuleDoc.Fields[1].Comments[encoder.LineComment] = "Part is the part of request to fuzz."
	FUZZRuleDoc.Fields[1].Values = []string{
		"query",
		"header",
		"path",
		"body",
		"cookie",
		"request",
	}
	FUZZRuleDoc.Fields[2].Name = "parts"
	FUZZRuleDoc.Fields[2].Type = "[]string"
	FUZZRuleDoc.Fields[2].Note = ""
	FUZZRuleDoc.Fields[2].Description = "Parts is the list of parts to fuzz. If multiple parts need to be\ndefined while excluding some, this should be used instead of singular part."
	FUZZRuleDoc.Fields[2].Comments[encoder.LineComment] = "Parts is the list of parts to fuzz. If multiple parts need to be"
	FUZZRuleDoc.Fields[2].Values = []string{
		"query",
		"header",
		"path",
		"body",
		"cookie",
		"request",
	}
	FUZZRuleDoc.Fields[3].Name = "mode"
	FUZZRuleDoc.Fields[3].Type = "string"
	FUZZRuleDoc.Fields[3].Note = ""
	FUZZRuleDoc.Fields[3].Description = "Mode is the mode of fuzzing to perform.\n\nsingle fuzzes one value at a time. multiple fuzzes all values at same time."
	FUZZRuleDoc.Fields[3].Comments[encoder.LineComment] = "Mode is the mode of fuzzing to perform."
	FUZZRuleDoc.Fields[3].Values = []string{
		"single",
		"multiple",
	}
	FUZZRuleDoc.Fields[4].Name = "keys"
	FUZZRuleDoc.Fields[4].Type = "[]string"
	FUZZRuleDoc.Fields[4].Note = ""
	FUZZRuleDoc.Fields[4].Description = "Keys is the optional list of key named parameters to fuzz."
	FUZZRuleDoc.Fields[4].Comments[encoder.LineComment] = "Keys is the optional list of key named parameters to fuzz."

	FUZZRuleDoc.Fields[4].AddExample("Examples of keys", []string{"url", "file", "host"})
	FUZZRuleDoc.Fields[5].Name = "keys-regex"
	FUZZRuleDoc.Fields[5].Type = "[]string"
	FUZZRuleDoc.Fields[5].Note = ""
	FUZZRuleDoc.Fields[5].Description = "KeysRegex is the optional list of regex key parameters to fuzz."
	FUZZRuleDoc.Fields[5].Comments[encoder.LineComment] = "KeysRegex is the optional list of regex key parameters to fuzz."

	FUZZRuleDoc.Fields[5].AddExample("Examples of key regex", []string{"url.*"})
	FUZZRuleDoc.Fields[6].Name = "values"
	FUZZRuleDoc.Fields[6].Type = "[]string"
	FUZZRuleDoc.Fields[6].Note = ""
	FUZZRuleDoc.Fields[6].Description = "Values is the optional list of regex value parameters to fuzz."
	FUZZRuleDoc.Fields[6].Comments[encoder.LineComment] = "Values is the optional list of regex value parameters to fuzz."

	FUZZRuleDoc.Fields[6].AddExample("Examples of value regex", []string{"https?://.*"})
	FUZZRuleDoc.Fields[7].Name = "fuzz"
	FUZZRuleDoc.Fields[7].Type = "SliceOrMapSlice"
	FUZZRuleDoc.Fields[7].Note = ""
	FUZZRuleDoc.Fields[7].Description = "description: |\n   Fuzz is the list of payloads to perform substitutions with.\n examples:\n   - name: Examples of fuzz\n     value: >\n       []string{\"{{ssrf}}\", \"{{interactsh-url}}\", \"example-value\"}\n      or\n       x-header: 1\n       x-header: 2"
	FUZZRuleDoc.Fields[7].Comments[encoder.LineComment] = " description: |"
	FUZZRuleDoc.Fields[8].Name = "replace-regex"
	FUZZRuleDoc.Fields[8].Type = "string"
	FUZZRuleDoc.Fields[8].Note = ""
	FUZZRuleDoc.Fields[8].Description = "replace-regex is regex for regex-replace rule type\nit is only required for replace-regex rule type"
	FUZZRuleDoc.Fields[8].Comments[encoder.LineComment] = "replace-regex is regex for regex-replace rule type"

	SliceOrMapSliceDoc.Type = "SliceOrMapSlice"
	SliceOrMapSliceDoc.Comments[encoder.LineComment] = ""
	SliceOrMapSliceDoc.Description = ""
	SliceOrMapSliceDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "fuzz.Rule",
			FieldName: "fuzz",
		},
	}
	SliceOrMapSliceDoc.Fields = make([]encoder.Doc, 0)

	SignatureTypeHolderDoc.Type = "SignatureTypeHolder"
	SignatureTypeHolderDoc.Comments[encoder.LineComment] = " SignatureTypeHolder is used to hold internal type of the signature"
	SignatureTypeHolderDoc.Description = "SignatureTypeHolder is used to hold internal type of the signature"
	SignatureTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "http.Request",
			FieldName: "signature",
		},
	}
	SignatureTypeHolderDoc.Fields = make([]encoder.Doc, 0)

	MATCHERSMatcherDoc.Type = "matchers.Matcher"
	MATCHERSMatcherDoc.Comments[encoder.LineComment] = " Matcher is used to match a part in the output from a protocol."
	MATCHERSMatcherDoc.Description = "Matcher is used to match a part in the output from a protocol."
	MATCHERSMatcherDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "http.Request",
			FieldName: "pre-condition",
		},
	}
	MATCHERSMatcherDoc.Fields = make([]encoder.Doc, 16)
	MATCHERSMatcherDoc.Fields[0].Name = "type"
	MATCHERSMatcherDoc.Fields[0].Type = "MatcherTypeHolder"
	MATCHERSMatcherDoc.Fields[0].Note = ""
	MATCHERSMatcherDoc.Fields[0].Description = "Type is the type of the matcher."
	MATCHERSMatcherDoc.Fields[0].Comments[encoder.LineComment] = "Type is the type of the matcher."
	MATCHERSMatcherDoc.Fields[1].Name = "condition"
	MATCHERSMatcherDoc.Fields[1].Type = "string"
	MATCHERSMatcherDoc.Fields[1].Note = ""
	MATCHERSMatcherDoc.Fields[1].Description = "Condition is the optional condition between two matcher variables. By default,\nthe condition is assumed to be OR."
	MATCHERSMatcherDoc.Fields[1].Comments[encoder.LineComment] = "Condition is the optional condition between two matcher variables. By default,"
	MATCHERSMatcherDoc.Fields[1].Values = []string{
		"and",
		"or",
	}
	MATCHERSMatcherDoc.Fields[2].Name = "part"
	MATCHERSMatcherDoc.Fields[2].Type = "string"
	MATCHERSMatcherDoc.Fields[2].Note = ""
	MATCHERSMatcherDoc.Fields[2].Description = "Part is the part of the request response to match data from.\n\nEach protocol exposes a lot of different parts which are well\ndocumented in docs for each request type."
	MATCHERSMatcherDoc.Fields[2].Comments[encoder.LineComment] = "Part is the part of the request response to match data from."

	MATCHERSMatcherDoc.Fields[2].AddExample("", "body")

	MATCHERSMatcherDoc.Fields[2].AddExample("", "raw")
	MATCHERSMatcherDoc.Fields[3].Name = "negative"
	MATCHERSMatcherDoc.Fields[3].Type = "bool"
	MATCHERSMatcherDoc.Fields[3].Note = ""
	MATCHERSMatcherDoc.Fields[3].Description = "Negative specifies if the match should be reversed\nIt will only match if the condition is not true."
	MATCHERSMatcherDoc.Fields[3].Comments[encoder.LineComment] = "Negative specifies if the match should be reversed"
	MATCHERSMatcherDoc.Fields[4].Name = "name"
	MATCHERSMatcherDoc.Fields[4].Type = "string"
	MATCHERSMatcherDoc.Fields[4].Note = ""
	MATCHERSMatcherDoc.Fields[4].Description = "Name of the matcher. Name should be lowercase and must not contain\nspaces or underscores (_)."
	MATCHERSMatcherDoc.Fields[4].Comments[encoder.LineComment] = "Name of the matcher. Name should be lowercase and must not contain"

	MATCHERSMatcherDoc.Fields[4].AddExample("", "cookie-matcher")
	MATCHERSMatcherDoc.Fields[5].Name = "status"
	MATCHERSMatcherDoc.Fields[5].Type = "[]int"
	MATCHERSMatcherDoc.Fields[5].Note = ""
	MATCHERSMatcherDoc.Fields[5].Description = "Status are the acceptable status codes for the response."
	MATCHERSMatcherDoc.Fields[5].Comments[encoder.LineComment] = "Status are the acceptable status codes for the response."

	MATCHERSMatcherDoc.Fields[5].AddExample("", []int{200, 302})
	MATCHERSMatcherDoc.Fields[6].Name = "size"
	MATCHERSMatcherDoc.Fields[6].Type = "[]int"
	MATCHERSMatcherDoc.Fields[6].Note = ""
	MATCHERSMatcherDoc.Fields[6].Description = "Size is the acceptable size for the response"
	MATCHERSMatcherDoc.Fields[6].Comments[encoder.LineComment] = "Size is the acceptable size for the response"

	MATCHERSMatcherDoc.Fields[6].AddExample("", []int{3029, 2042})
	MATCHERSMatcherDoc.Fields[7].Name = "words"
	MATCHERSMatcherDoc.Fields[7].Type = "[]string"
	MATCHERSMatcherDoc.Fields[7].Note = ""
	MATCHERSMatcherDoc.Fields[7].Description = "Words contains word patterns required to be present in the response part."
	MATCHERSMatcherDoc.Fields[7].Comments[encoder.LineComment] = "Words contains word patterns required to be present in the response part."

	MATCHERSMatcherDoc.Fields[7].AddExample("Match for Outlook mail protection domain", []string{"mail.protection.outlook.com"})

	MATCHERSMatcherDoc.Fields[7].AddExample("Match for application/json in response headers", []string{"application/json"})
	MATCHERSMatcherDoc.Fields[8].Name = "regex"
	MATCHERSMatcherDoc.Fields[8].Type = "[]string"
	MATCHERSMatcherDoc.Fields[8].Note = ""
	MATCHERSMatcherDoc.Fields[8].Description = "Regex contains Regular Expression patterns required to be present in the response part."
	MATCHERSMatcherDoc.Fields[8].Comments[encoder.LineComment] = "Regex contains Regular Expression patterns required to be present in the response part."

	MATCHERSMatcherDoc.Fields[8].AddExample("Match for Linkerd Service via Regex", []string{`(?mi)^Via\\s*?:.*?linkerd.*$`})

	MATCHERSMatcherDoc.Fields[8].AddExample("Match for Open Redirect via Location header", []string{`(?m)^(?:Location\\s*?:\\s*?)(?:https?://|//)?(?:[a-zA-Z0-9\\-_\\.@]*)example\\.com.*$`})
	MATCHERSMatcherDoc.Fields[9].Name = "binary"
	MATCHERSMatcherDoc.Fields[9].Type = "[]string"
	MATCHERSMatcherDoc.Fields[9].Note = ""
	MATCHERSMatcherDoc.Fields[9].Description = "Binary are the binary patterns required to be present in the response part."
	MATCHERSMatcherDoc.Fields[9].Comments[encoder.LineComment] = "Binary are the binary patterns required to be present in the response part."

	MATCHERSMatcherDoc.Fields[9].AddExample("Match for Springboot Heapdump Actuator \"JAVA PROFILE\", \"HPROF\", \"Gunzip magic byte\"", []string{"4a4156412050524f46494c45", "4850524f46", "1f8b080000000000"})

	MATCHERSMatcherDoc.Fields[9].AddExample("Match for 7zip files", []string{"377ABCAF271C"})
	MATCHERSMatcherDoc.Fields[10].Name = "dsl"
	MATCHERSMatcherDoc.Fields[10].Type = "[]string"
	MATCHERSMatcherDoc.Fields[10].Note = ""
	MATCHERSMatcherDoc.Fields[10].Description = "DSL are the dsl expressions that will be evaluated as part of nuclei matching rules.\nA list of these helper functions are available [here](https://nuclei.projectdiscovery.io/templating-guide/helper-functions/)."
	MATCHERSMatcherDoc.Fields[10].Comments[encoder.LineComment] = "DSL are the dsl expressions that will be evaluated as part of nuclei matching rules."

	MATCHERSMatcherDoc.Fields[10].AddExample("DSL Matcher for package.json file", []string{"contains(body, 'packages') && contains(tolower(all_headers), 'application/octet-stream') && status_code == 200"})

	MATCHERSMatcherDoc.Fields[10].AddExample("DSL Matcher for missing strict transport security header", []string{"!contains(tolower(all_headers), ''strict-transport-security'')"})
	MATCHERSMatcherDoc.Fields[11].Name = "xpath"
	MATCHERSMatcherDoc.Fields[11].Type = "[]string"
	MATCHERSMatcherDoc.Fields[11].Note = ""
	MATCHERSMatcherDoc.Fields[11].Description = "XPath are the xpath queries expressions that will be evaluated against the response part."
	MATCHERSMatcherDoc.Fields[11].Comments[encoder.LineComment] = "XPath are the xpath queries expressions that will be evaluated against the response part."

	MATCHERSMatcherDoc.Fields[11].AddExample("XPath Matcher to check a title", []string{"/html/head/title[contains(text(), 'How to Find XPath')]"})

	MATCHERSMatcherDoc.Fields[11].AddExample("XPath Matcher for finding links with target=\"_blank\"", []string{"//a[@target=\"_blank\"]"})
	MATCHERSMatcherDoc.Fields[12].Name = "encoding"
	MATCHERSMatcherDoc.Fields[12].Type = "string"
	MATCHERSMatcherDoc.Fields[12].Note = ""
	MATCHERSMatcherDoc.Fields[12].Description = "Encoding specifies the encoding for the words field if any."
	MATCHERSMatcherDoc.Fields[12].Comments[encoder.LineComment] = "Encoding specifies the encoding for the words field if any."
	MATCHERSMatcherDoc.Fields[12].Values = []string{
		"hex",
	}
	MATCHERSMatcherDoc.Fields[13].Name = "case-insensitive"
	MATCHERSMatcherDoc.Fields[13].Type = "bool"
	MATCHERSMatcherDoc.Fields[13].Note = ""
	MATCHERSMatcherDoc.Fields[13].Description = "CaseInsensitive enables case-insensitive matches. Default is false."
	MATCHERSMatcherDoc.Fields[13].Comments[encoder.LineComment] = "CaseInsensitive enables case-insensitive matches. Default is false."
	MATCHERSMatcherDoc.Fields[13].Values = []string{
		"false",
		"true",
	}
	MATCHERSMatcherDoc.Fields[14].Name = "match-all"
	MATCHERSMatcherDoc.Fields[14].Type = "bool"
	MATCHERSMatcherDoc.Fields[14].Note = ""
	MATCHERSMatcherDoc.Fields[14].Description = "MatchAll enables matching for all matcher values. Default is false."
	MATCHERSMatcherDoc.Fields[14].Comments[encoder.LineComment] = "MatchAll enables matching for all matcher values. Default is false."
	MATCHERSMatcherDoc.Fields[14].Values = []string{
		"false",
		"true",
	}
	MATCHERSMatcherDoc.Fields[15].Name = "internal"
	MATCHERSMatcherDoc.Fields[15].Type = "bool"
	MATCHERSMatcherDoc.Fields[15].Note = ""
	MATCHERSMatcherDoc.Fields[15].Description = "description: |\n  Internal when true hides the matcher from output. Default is false.\n It is meant to be used in multiprotocol / flow templates to create internal matcher condition without printing it in output.\n or other similar use cases.\n values:\n   - false\n   - true"
	MATCHERSMatcherDoc.Fields[15].Comments[encoder.LineComment] = " description: |"

	MatcherTypeHolderDoc.Type = "MatcherTypeHolder"
	MatcherTypeHolderDoc.Comments[encoder.LineComment] = " MatcherTypeHolder is used to hold internal type of the matcher"
	MatcherTypeHolderDoc.Description = "MatcherTypeHolder is used to hold internal type of the matcher"
	MatcherTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "matchers.Matcher",
			FieldName: "type",
		},
	}
	MatcherTypeHolderDoc.Fields = make([]encoder.Doc, 1)
	MatcherTypeHolderDoc.Fields[0].Name = ""
	MatcherTypeHolderDoc.Fields[0].Type = "MatcherType"
	MatcherTypeHolderDoc.Fields[0].Note = ""
	MatcherTypeHolderDoc.Fields[0].Description = ""
	MatcherTypeHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	MatcherTypeHolderDoc.Fields[0].EnumFields = []string{
		"word",
		"regex",
		"binary",
		"status",
		"size",
		"dsl",
		"xpath",
	}

	DNSRequestDoc.Type = "dns.Request"
	DNSRequestDoc.Comments[encoder.LineComment] = " Request contains a DNS protocol request to be made from a template"
	DNSRequestDoc.Description = "Request contains a DNS protocol request to be made from a template"

	DNSRequestDoc.AddExample("", exampleNormalDNSRequest)
	DNSRequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "dns",
		},
	}
	DNSRequestDoc.PartDefinitions = []encoder.KeyValue{
		{
			Key:   "template-id",
			Value: "ID of the template executed",
		},
		{
			Key:   "template-info",
			Value: "Info Block of the template executed",
		},
		{
			Key:   "template-path",
			Value: "Path of the template executed",
		},
		{
			Key:   "host",
			Value: "Host is the input to the template",
		},
		{
			Key:   "matched",
			Value: "Matched is the input which was matched upon",
		},
		{
			Key:   "request",
			Value: "Request contains the DNS request in text format",
		},
		{
			Key:   "type",
			Value: "Type is the type of request made",
		},
		{
			Key:   "rcode",
			Value: "Rcode field returned for the DNS request",
		},
		{
			Key:   "question",
			Value: "Question contains the DNS question field",
		},
		{
			Key:   "extra",
			Value: "Extra contains the DNS response extra field",
		},
		{
			Key:   "answer",
			Value: "Answer contains the DNS response answer field",
		},
		{
			Key:   "ns",
			Value: "NS contains the DNS response NS field",
		},
		{
			Key:   "raw,body,all",
			Value: "Raw contains the raw DNS response (default)",
		},
		{
			Key:   "trace",
			Value: "Trace contains trace data for DNS request if enabled",
		},
	}
	DNSRequestDoc.Fields = make([]encoder.Doc, 12)
	DNSRequestDoc.Fields[0].Name = "id"
	DNSRequestDoc.Fields[0].Type = "string"
	DNSRequestDoc.Fields[0].Note = ""
	DNSRequestDoc.Fields[0].Description = "ID is the optional id of the request"
	DNSRequestDoc.Fields[0].Comments[encoder.LineComment] = " ID is the optional id of the request"
	DNSRequestDoc.Fields[1].Name = "name"
	DNSRequestDoc.Fields[1].Type = "string"
	DNSRequestDoc.Fields[1].Note = ""
	DNSRequestDoc.Fields[1].Description = "Name is the Hostname to make DNS request for.\n\nGenerally, it is set to {{FQDN}} which is the domain we get from input."
	DNSRequestDoc.Fields[1].Comments[encoder.LineComment] = "Name is the Hostname to make DNS request for."

	DNSRequestDoc.Fields[1].AddExample("", "{{FQDN}}")
	DNSRequestDoc.Fields[2].Name = "type"
	DNSRequestDoc.Fields[2].Type = "DNSRequestTypeHolder"
	DNSRequestDoc.Fields[2].Note = ""
	DNSRequestDoc.Fields[2].Description = "RequestType is the type of DNS request to make."
	DNSRequestDoc.Fields[2].Comments[encoder.LineComment] = "RequestType is the type of DNS request to make."
	DNSRequestDoc.Fields[3].Name = "class"
	DNSRequestDoc.Fields[3].Type = "string"
	DNSRequestDoc.Fields[3].Note = ""
	DNSRequestDoc.Fields[3].Description = "Class is the class of the DNS request.\n\nUsually it's enough to just leave it as INET."
	DNSRequestDoc.Fields[3].Comments[encoder.LineComment] = "Class is the class of the DNS request."
	DNSRequestDoc.Fields[3].Values = []string{
		"inet",
		"csnet",
		"chaos",
		"hesiod",
		"none",
		"any",
	}
	DNSRequestDoc.Fields[4].Name = "retries"
	DNSRequestDoc.Fields[4].Type = "int"
	DNSRequestDoc.Fields[4].Note = ""
	DNSRequestDoc.Fields[4].Description = "Retries is the number of retries for the DNS request"
	DNSRequestDoc.Fields[4].Comments[encoder.LineComment] = "Retries is the number of retries for the DNS request"

	DNSRequestDoc.Fields[4].AddExample("Use a retry of 3 to 5 generally", 5)
	DNSRequestDoc.Fields[5].Name = "trace"
	DNSRequestDoc.Fields[5].Type = "bool"
	DNSRequestDoc.Fields[5].Note = ""
	DNSRequestDoc.Fields[5].Description = "Trace performs a trace operation for the target."
	DNSRequestDoc.Fields[5].Comments[encoder.LineComment] = "Trace performs a trace operation for the target."
	DNSRequestDoc.Fields[6].Name = "trace-max-recursion"
	DNSRequestDoc.Fields[6].Type = "int"
	DNSRequestDoc.Fields[6].Note = ""
	DNSRequestDoc.Fields[6].Description = "TraceMaxRecursion is the number of max recursion allowed for trace operations"
	DNSRequestDoc.Fields[6].Comments[encoder.LineComment] = "TraceMaxRecursion is the number of max recursion allowed for trace operations"

	DNSRequestDoc.Fields[6].AddExample("Use a retry of 100 to 150 generally", 100)
	DNSRequestDoc.Fields[7].Name = "attack"
	DNSRequestDoc.Fields[7].Type = "generators.AttackTypeHolder"
	DNSRequestDoc.Fields[7].Note = ""
	DNSRequestDoc.Fields[7].Description = "Attack is the type of payload combinations to perform.\n\nBatteringram is inserts the same payload into all defined payload positions at once, pitchfork combines multiple payload sets and clusterbomb generates\npermutations and combinations for all payloads."
	DNSRequestDoc.Fields[7].Comments[encoder.LineComment] = "Attack is the type of payload combinations to perform."
	DNSRequestDoc.Fields[8].Name = "payloads"
	DNSRequestDoc.Fields[8].Type = "map[string]interface{}"
	DNSRequestDoc.Fields[8].Note = ""
	DNSRequestDoc.Fields[8].Description = "Payloads contains any payloads for the current request.\n\nPayloads support both key-values combinations where a list\nof payloads is provided, or optionally a single file can also\nbe provided as payload which will be read on run-time."
	DNSRequestDoc.Fields[8].Comments[encoder.LineComment] = "Payloads contains any payloads for the current request."
	DNSRequestDoc.Fields[9].Name = "threads"
	DNSRequestDoc.Fields[9].Type = "int"
	DNSRequestDoc.Fields[9].Note = ""
	DNSRequestDoc.Fields[9].Description = "Threads to use when sending iterating over payloads"
	DNSRequestDoc.Fields[9].Comments[encoder.LineComment] = "Threads to use when sending iterating over payloads"

	DNSRequestDoc.Fields[9].AddExample("Send requests using 10 concurrent threads", 10)
	DNSRequestDoc.Fields[10].Name = "recursion"
	DNSRequestDoc.Fields[10].Type = "dns.bool"
	DNSRequestDoc.Fields[10].Note = ""
	DNSRequestDoc.Fields[10].Description = "Recursion determines if resolver should recurse all records to get fresh results."
	DNSRequestDoc.Fields[10].Comments[encoder.LineComment] = "Recursion determines if resolver should recurse all records to get fresh results."
	DNSRequestDoc.Fields[11].Name = "resolvers"
	DNSRequestDoc.Fields[11].Type = "[]string"
	DNSRequestDoc.Fields[11].Note = ""
	DNSRequestDoc.Fields[11].Description = "Resolvers to use for the dns requests"
	DNSRequestDoc.Fields[11].Comments[encoder.LineComment] = " Resolvers to use for the dns requests"

	DNSRequestTypeHolderDoc.Type = "DNSRequestTypeHolder"
	DNSRequestTypeHolderDoc.Comments[encoder.LineComment] = " DNSRequestTypeHolder is used to hold internal type of the DNS type"
	DNSRequestTypeHolderDoc.Description = "DNSRequestTypeHolder is used to hold internal type of the DNS type"
	DNSRequestTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "dns.Request",
			FieldName: "type",
		},
	}
	DNSRequestTypeHolderDoc.Fields = make([]encoder.Doc, 1)
	DNSRequestTypeHolderDoc.Fields[0].Name = ""
	DNSRequestTypeHolderDoc.Fields[0].Type = "DNSRequestType"
	DNSRequestTypeHolderDoc.Fields[0].Note = ""
	DNSRequestTypeHolderDoc.Fields[0].Description = ""
	DNSRequestTypeHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	DNSRequestTypeHolderDoc.Fields[0].EnumFields = []string{
		"A",
		"NS",
		"DS",
		"CNAME",
		"SOA",
		"PTR",
		"MX",
		"TXT",
		"AAAA",
		"CAA",
		"TLSA",
		"ANY",
		"SRV",
	}

	FILERequestDoc.Type = "file.Request"
	FILERequestDoc.Comments[encoder.LineComment] = " Request contains a File matching mechanism for local disk operations."
	FILERequestDoc.Description = "Request contains a File matching mechanism for local disk operations."

	FILERequestDoc.AddExample("", exampleNormalFileRequest)
	FILERequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "file",
		},
	}
	FILERequestDoc.PartDefinitions = []encoder.KeyValue{
		{
			Key:   "template-id",
			Value: "ID of the template executed",
		},
		{
			Key:   "template-info",
			Value: "Info Block of the template executed",
		},
		{
			Key:   "template-path",
			Value: "Path of the template executed",
		},
		{
			Key:   "matched",
			Value: "Matched is the input which was matched upon",
		},
		{
			Key:   "path",
			Value: "Path is the path of file on local filesystem",
		},
		{
			Key:   "type",
			Value: "Type is the type of request made",
		},
		{
			Key:   "raw,body,all,data",
			Value: "Raw contains the raw file contents",
		},
	}
	FILERequestDoc.Fields = make([]encoder.Doc, 7)
	FILERequestDoc.Fields[0].Name = "extensions"
	FILERequestDoc.Fields[0].Type = "[]string"
	FILERequestDoc.Fields[0].Note = ""
	FILERequestDoc.Fields[0].Description = "Extensions is the list of extensions or mime types to perform matching on."
	FILERequestDoc.Fields[0].Comments[encoder.LineComment] = "Extensions is the list of extensions or mime types to perform matching on."

	FILERequestDoc.Fields[0].AddExample("", []string{".txt", ".go", ".json"})
	FILERequestDoc.Fields[1].Name = "denylist"
	FILERequestDoc.Fields[1].Type = "[]string"
	FILERequestDoc.Fields[1].Note = ""
	FILERequestDoc.Fields[1].Description = "DenyList is the list of file, directories, mime types or extensions to deny during matching.\n\nBy default, it contains some non-interesting extensions that are hardcoded\nin nuclei."
	FILERequestDoc.Fields[1].Comments[encoder.LineComment] = "DenyList is the list of file, directories, mime types or extensions to deny during matching."

	FILERequestDoc.Fields[1].AddExample("", []string{".avi", ".mov", ".mp3"})
	FILERequestDoc.Fields[2].Name = "id"
	FILERequestDoc.Fields[2].Type = "string"
	FILERequestDoc.Fields[2].Note = ""
	FILERequestDoc.Fields[2].Description = "ID is the optional id of the request"
	FILERequestDoc.Fields[2].Comments[encoder.LineComment] = " ID is the optional id of the request"
	FILERequestDoc.Fields[3].Name = "max-size"
	FILERequestDoc.Fields[3].Type = "string"
	FILERequestDoc.Fields[3].Note = ""
	FILERequestDoc.Fields[3].Description = "MaxSize is the maximum size of the file to run request on.\n\nBy default, nuclei will process 1 GB of content and not go more than that.\nIt can be set to much lower or higher depending on use.\nIf set to \"no\" then all content will be processed"
	FILERequestDoc.Fields[3].Comments[encoder.LineComment] = "MaxSize is the maximum size of the file to run request on."

	FILERequestDoc.Fields[3].AddExample("", "5Mb")
	FILERequestDoc.Fields[4].Name = "archive"
	FILERequestDoc.Fields[4].Type = "bool"
	FILERequestDoc.Fields[4].Note = ""
	FILERequestDoc.Fields[4].Description = "elaborates archives"
	FILERequestDoc.Fields[4].Comments[encoder.LineComment] = "elaborates archives"
	FILERequestDoc.Fields[5].Name = "mime-type"
	FILERequestDoc.Fields[5].Type = "bool"
	FILERequestDoc.Fields[5].Note = ""
	FILERequestDoc.Fields[5].Description = "enables mime types check"
	FILERequestDoc.Fields[5].Comments[encoder.LineComment] = "enables mime types check"
	FILERequestDoc.Fields[6].Name = "no-recursive"
	FILERequestDoc.Fields[6].Type = "bool"
	FILERequestDoc.Fields[6].Note = ""
	FILERequestDoc.Fields[6].Description = "NoRecursive specifies whether to not do recursive checks if folders are provided."
	FILERequestDoc.Fields[6].Comments[encoder.LineComment] = "NoRecursive specifies whether to not do recursive checks if folders are provided."

	NETWORKRequestDoc.Type = "network.Request"
	NETWORKRequestDoc.Comments[encoder.LineComment] = " Request contains a Network protocol request to be made from a template"
	NETWORKRequestDoc.Description = "Request contains a Network protocol request to be made from a template"

	NETWORKRequestDoc.AddExample("", exampleNormalNetworkRequest)
	NETWORKRequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "network",
		},
		{
			TypeName:  "Template",
			FieldName: "tcp",
		},
	}
	NETWORKRequestDoc.PartDefinitions = []encoder.KeyValue{
		{
			Key:   "template-id",
			Value: "ID of the template executed",
		},
		{
			Key:   "template-info",
			Value: "Info Block of the template executed",
		},
		{
			Key:   "template-path",
			Value: "Path of the template executed",
		},
		{
			Key:   "host",
			Value: "Host is the input to the template",
		},
		{
			Key:   "matched",
			Value: "Matched is the input which was matched upon",
		},
		{
			Key:   "type",
			Value: "Type is the type of request made",
		},
		{
			Key:   "request",
			Value: "Network request made from the client",
		},
		{
			Key:   "body,all,data",
			Value: "Network response received from server (default)",
		},
		{
			Key:   "raw",
			Value: "Full Network protocol data",
		},
	}
	NETWORKRequestDoc.Fields = make([]encoder.Doc, 11)
	NETWORKRequestDoc.Fields[0].Name = "id"
	NETWORKRequestDoc.Fields[0].Type = "string"
	NETWORKRequestDoc.Fields[0].Note = ""
	NETWORKRequestDoc.Fields[0].Description = "ID is the optional id of the request"
	NETWORKRequestDoc.Fields[0].Comments[encoder.LineComment] = " ID is the optional id of the request"
	NETWORKRequestDoc.Fields[1].Name = "host"
	NETWORKRequestDoc.Fields[1].Type = "[]string"
	NETWORKRequestDoc.Fields[1].Note = ""
	NETWORKRequestDoc.Fields[1].Description = "Host to send network requests to.\n\nUsually it's set to `{{Hostname}}`. If you want to enable TLS for\nTCP Connection, you can use `tls://{{Hostname}}`."
	NETWORKRequestDoc.Fields[1].Comments[encoder.LineComment] = "Host to send network requests to."

	NETWORKRequestDoc.Fields[1].AddExample("", []string{"{{Hostname}}"})
	NETWORKRequestDoc.Fields[2].Name = "attack"
	NETWORKRequestDoc.Fields[2].Type = "generators.AttackTypeHolder"
	NETWORKRequestDoc.Fields[2].Note = ""
	NETWORKRequestDoc.Fields[2].Description = "Attack is the type of payload combinations to perform.\n\nBatteringram is inserts the same payload into all defined payload positions at once, pitchfork combines multiple payload sets and clusterbomb generates\npermutations and combinations for all payloads."
	NETWORKRequestDoc.Fields[2].Comments[encoder.LineComment] = "Attack is the type of payload combinations to perform."
	NETWORKRequestDoc.Fields[3].Name = "payloads"
	NETWORKRequestDoc.Fields[3].Type = "map[string]interface{}"
	NETWORKRequestDoc.Fields[3].Note = ""
	NETWORKRequestDoc.Fields[3].Description = "Payloads contains any payloads for the current request.\n\nPayloads support both key-values combinations where a list\nof payloads is provided, or optionally a single file can also\nbe provided as payload which will be read on run-time."
	NETWORKRequestDoc.Fields[3].Comments[encoder.LineComment] = "Payloads contains any payloads for the current request."
	NETWORKRequestDoc.Fields[4].Name = "threads"
	NETWORKRequestDoc.Fields[4].Type = "int"
	NETWORKRequestDoc.Fields[4].Note = ""
	NETWORKRequestDoc.Fields[4].Description = "Threads specifies number of threads to use sending requests. This enables Connection Pooling.\n\nConnection: Close attribute must not be used in request while using threads flag, otherwise\npooling will fail and engine will continue to close connections after requests."
	NETWORKRequestDoc.Fields[4].Comments[encoder.LineComment] = "Threads specifies number of threads to use sending requests. This enables Connection Pooling."

	NETWORKRequestDoc.Fields[4].AddExample("Send requests using 10 concurrent threads", 10)
	NETWORKRequestDoc.Fields[5].Name = "inputs"
	NETWORKRequestDoc.Fields[5].Type = "[]network.Input"
	NETWORKRequestDoc.Fields[5].Note = ""
	NETWORKRequestDoc.Fields[5].Description = "Inputs contains inputs for the network socket"
	NETWORKRequestDoc.Fields[5].Comments[encoder.LineComment] = "Inputs contains inputs for the network socket"
	NETWORKRequestDoc.Fields[6].Name = "port"
	NETWORKRequestDoc.Fields[6].Type = "string"
	NETWORKRequestDoc.Fields[6].Note = ""
	NETWORKRequestDoc.Fields[6].Description = "description: |\n   Port is the port to send network requests to. this acts as default port but is overriden if target/input contains\n non-http(s) ports like 80,8080,8081 etc"
	NETWORKRequestDoc.Fields[6].Comments[encoder.LineComment] = " description: |"
	NETWORKRequestDoc.Fields[7].Name = "exclude-ports"
	NETWORKRequestDoc.Fields[7].Type = "string"
	NETWORKRequestDoc.Fields[7].Note = ""
	NETWORKRequestDoc.Fields[7].Description = "description:	|\n	ExcludePorts is the list of ports to exclude from being scanned . It is intended to be used with `Port` field and contains a list of ports which are ignored/skipped"
	NETWORKRequestDoc.Fields[7].Comments[encoder.LineComment] = " description:	|"
	NETWORKRequestDoc.Fields[8].Name = "read-size"
	NETWORKRequestDoc.Fields[8].Type = "int"
	NETWORKRequestDoc.Fields[8].Note = ""
	NETWORKRequestDoc.Fields[8].Description = "ReadSize is the size of response to read at the end\n\nDefault value for read-size is 1024."
	NETWORKRequestDoc.Fields[8].Comments[encoder.LineComment] = "ReadSize is the size of response to read at the end"

	NETWORKRequestDoc.Fields[8].AddExample("", 2048)
	NETWORKRequestDoc.Fields[9].Name = "read-all"
	NETWORKRequestDoc.Fields[9].Type = "bool"
	NETWORKRequestDoc.Fields[9].Note = ""
	NETWORKRequestDoc.Fields[9].Description = "ReadAll determines if the data stream should be read till the end regardless of the size\n\nDefault value for read-all is false."
	NETWORKRequestDoc.Fields[9].Comments[encoder.LineComment] = "ReadAll determines if the data stream should be read till the end regardless of the size"

	NETWORKRequestDoc.Fields[9].AddExample("", false)
	NETWORKRequestDoc.Fields[10].Name = "stop-at-first-match"
	NETWORKRequestDoc.Fields[10].Type = "bool"
	NETWORKRequestDoc.Fields[10].Note = ""
	NETWORKRequestDoc.Fields[10].Description = "StopAtFirstMatch stops the execution of the requests and template as soon as a match is found."
	NETWORKRequestDoc.Fields[10].Comments[encoder.LineComment] = "StopAtFirstMatch stops the execution of the requests and template as soon as a match is found."

	NETWORKInputDoc.Type = "network.Input"
	NETWORKInputDoc.Comments[encoder.LineComment] = ""
	NETWORKInputDoc.Description = ""
	NETWORKInputDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "network.Request",
			FieldName: "inputs",
		},
	}
	NETWORKInputDoc.Fields = make([]encoder.Doc, 4)
	NETWORKInputDoc.Fields[0].Name = "data"
	NETWORKInputDoc.Fields[0].Type = "string"
	NETWORKInputDoc.Fields[0].Note = ""
	NETWORKInputDoc.Fields[0].Description = "Data is the data to send as the input.\n\nIt supports DSL Helper Functions as well as normal expressions."
	NETWORKInputDoc.Fields[0].Comments[encoder.LineComment] = "Data is the data to send as the input."

	NETWORKInputDoc.Fields[0].AddExample("", "TEST")

	NETWORKInputDoc.Fields[0].AddExample("", "hex_decode('50494e47')")
	NETWORKInputDoc.Fields[1].Name = "type"
	NETWORKInputDoc.Fields[1].Type = "NetworkInputTypeHolder"
	NETWORKInputDoc.Fields[1].Note = ""
	NETWORKInputDoc.Fields[1].Description = "Type is the type of input specified in `data` field.\n\nDefault value is text, but hex can be used for hex formatted data."
	NETWORKInputDoc.Fields[1].Comments[encoder.LineComment] = "Type is the type of input specified in `data` field."
	NETWORKInputDoc.Fields[1].Values = []string{
		"hex",
		"text",
	}
	NETWORKInputDoc.Fields[2].Name = "read"
	NETWORKInputDoc.Fields[2].Type = "int"
	NETWORKInputDoc.Fields[2].Note = ""
	NETWORKInputDoc.Fields[2].Description = "Read is the number of bytes to read from socket.\n\nThis can be used for protocols which expect an immediate response. You can\nread and write responses one after another and eventually perform matching\non every data captured with `name` attribute.\n\nThe [network docs](https://nuclei.projectdiscovery.io/templating-guide/protocols/network/) highlight more on how to do this."
	NETWORKInputDoc.Fields[2].Comments[encoder.LineComment] = "Read is the number of bytes to read from socket."

	NETWORKInputDoc.Fields[2].AddExample("", 1024)
	NETWORKInputDoc.Fields[3].Name = "name"
	NETWORKInputDoc.Fields[3].Type = "string"
	NETWORKInputDoc.Fields[3].Note = ""
	NETWORKInputDoc.Fields[3].Description = "Name is the optional name of the data read to provide matching on."
	NETWORKInputDoc.Fields[3].Comments[encoder.LineComment] = "Name is the optional name of the data read to provide matching on."

	NETWORKInputDoc.Fields[3].AddExample("", "prefix")

	NetworkInputTypeHolderDoc.Type = "NetworkInputTypeHolder"
	NetworkInputTypeHolderDoc.Comments[encoder.LineComment] = " NetworkInputTypeHolder is used to hold internal type of the Network type"
	NetworkInputTypeHolderDoc.Description = "NetworkInputTypeHolder is used to hold internal type of the Network type"
	NetworkInputTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "network.Input",
			FieldName: "type",
		},
	}
	NetworkInputTypeHolderDoc.Fields = make([]encoder.Doc, 1)
	NetworkInputTypeHolderDoc.Fields[0].Name = ""
	NetworkInputTypeHolderDoc.Fields[0].Type = "NetworkInputType"
	NetworkInputTypeHolderDoc.Fields[0].Note = ""
	NetworkInputTypeHolderDoc.Fields[0].Description = ""
	NetworkInputTypeHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	NetworkInputTypeHolderDoc.Fields[0].EnumFields = []string{
		"hex",
		"text",
	}

	HEADLESSRequestDoc.Type = "headless.Request"
	HEADLESSRequestDoc.Comments[encoder.LineComment] = " Request contains a Headless protocol request to be made from a template"
	HEADLESSRequestDoc.Description = "Request contains a Headless protocol request to be made from a template"
	HEADLESSRequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "headless",
		},
	}
	HEADLESSRequestDoc.PartDefinitions = []encoder.KeyValue{
		{
			Key:   "template-id",
			Value: "ID of the template executed",
		},
		{
			Key:   "template-info",
			Value: "Info Block of the template executed",
		},
		{
			Key:   "template-path",
			Value: "Path of the template executed",
		},
		{
			Key:   "host",
			Value: "Host is the input to the template",
		},
		{
			Key:   "matched",
			Value: "Matched is the input which was matched upon",
		},
		{
			Key:   "type",
			Value: "Type is the type of request made",
		},
		{
			Key:   "req",
			Value: "Headless request made from the client",
		},
		{
			Key:   "resp,body,data",
			Value: "Headless response received from client (default)",
		},
	}
	HEADLESSRequestDoc.Fields = make([]encoder.Doc, 10)
	HEADLESSRequestDoc.Fields[0].Name = "id"
	HEADLESSRequestDoc.Fields[0].Type = "string"
	HEADLESSRequestDoc.Fields[0].Note = ""
	HEADLESSRequestDoc.Fields[0].Description = "ID is the optional id of the request"
	HEADLESSRequestDoc.Fields[0].Comments[encoder.LineComment] = " ID is the optional id of the request"
	HEADLESSRequestDoc.Fields[1].Name = "attack"
	HEADLESSRequestDoc.Fields[1].Type = "generators.AttackTypeHolder"
	HEADLESSRequestDoc.Fields[1].Note = ""
	HEADLESSRequestDoc.Fields[1].Description = "Attack is the type of payload combinations to perform.\n\nBatteringram is inserts the same payload into all defined payload positions at once, pitchfork combines multiple payload sets and clusterbomb generates\npermutations and combinations for all payloads."
	HEADLESSRequestDoc.Fields[1].Comments[encoder.LineComment] = "Attack is the type of payload combinations to perform."
	HEADLESSRequestDoc.Fields[2].Name = "payloads"
	HEADLESSRequestDoc.Fields[2].Type = "map[string]interface{}"
	HEADLESSRequestDoc.Fields[2].Note = ""
	HEADLESSRequestDoc.Fields[2].Description = "Payloads contains any payloads for the current request.\n\nPayloads support both key-values combinations where a list\nof payloads is provided, or optionally a single file can also\nbe provided as payload which will be read on run-time."
	HEADLESSRequestDoc.Fields[2].Comments[encoder.LineComment] = "Payloads contains any payloads for the current request."
	HEADLESSRequestDoc.Fields[3].Name = "steps"
	HEADLESSRequestDoc.Fields[3].Type = "[]engine.Action"
	HEADLESSRequestDoc.Fields[3].Note = ""
	HEADLESSRequestDoc.Fields[3].Description = "Steps is the list of actions to run for headless request"
	HEADLESSRequestDoc.Fields[3].Comments[encoder.LineComment] = "Steps is the list of actions to run for headless request"
	HEADLESSRequestDoc.Fields[4].Name = "user_agent"
	HEADLESSRequestDoc.Fields[4].Type = "userAgent.UserAgentHolder"
	HEADLESSRequestDoc.Fields[4].Note = ""
	HEADLESSRequestDoc.Fields[4].Description = "descriptions: |\n 	 User-Agent is the type of user-agent to use for the request."
	HEADLESSRequestDoc.Fields[4].Comments[encoder.LineComment] = " descriptions: |"
	HEADLESSRequestDoc.Fields[5].Name = "custom_user_agent"
	HEADLESSRequestDoc.Fields[5].Type = "string"
	HEADLESSRequestDoc.Fields[5].Note = ""
	HEADLESSRequestDoc.Fields[5].Description = "description: |\n 	 If UserAgent is set to custom, customUserAgent is the custom user-agent to use for the request."
	HEADLESSRequestDoc.Fields[5].Comments[encoder.LineComment] = " description: |"
	HEADLESSRequestDoc.Fields[6].Name = "stop-at-first-match"
	HEADLESSRequestDoc.Fields[6].Type = "bool"
	HEADLESSRequestDoc.Fields[6].Note = ""
	HEADLESSRequestDoc.Fields[6].Description = "StopAtFirstMatch stops the execution of the requests and template as soon as a match is found."
	HEADLESSRequestDoc.Fields[6].Comments[encoder.LineComment] = "StopAtFirstMatch stops the execution of the requests and template as soon as a match is found."
	HEADLESSRequestDoc.Fields[7].Name = "fuzzing"
	HEADLESSRequestDoc.Fields[7].Type = "[]fuzz.Rule"
	HEADLESSRequestDoc.Fields[7].Note = ""
	HEADLESSRequestDoc.Fields[7].Description = "Fuzzing describes schema to fuzz headless requests"
	HEADLESSRequestDoc.Fields[7].Comments[encoder.LineComment] = " Fuzzing describes schema to fuzz headless requests"
	HEADLESSRequestDoc.Fields[8].Name = "cookie-reuse"
	HEADLESSRequestDoc.Fields[8].Type = "bool"
	HEADLESSRequestDoc.Fields[8].Note = ""
	HEADLESSRequestDoc.Fields[8].Description = "CookieReuse is an optional setting that enables cookie reuse"
	HEADLESSRequestDoc.Fields[8].Comments[encoder.LineComment] = "CookieReuse is an optional setting that enables cookie reuse"
	HEADLESSRequestDoc.Fields[9].Name = "disable-cookie"
	HEADLESSRequestDoc.Fields[9].Type = "bool"
	HEADLESSRequestDoc.Fields[9].Note = ""
	HEADLESSRequestDoc.Fields[9].Description = "DisableCookie is an optional setting that disables cookie reuse"
	HEADLESSRequestDoc.Fields[9].Comments[encoder.LineComment] = "DisableCookie is an optional setting that disables cookie reuse"

	ENGINEActionDoc.Type = "engine.Action"
	ENGINEActionDoc.Comments[encoder.LineComment] = " Action is an action taken by the browser to reach a navigation"
	ENGINEActionDoc.Description = "Action is an action taken by the browser to reach a navigation\n\n Each step that the browser executes is an action. Most navigations\n usually start from the ActionLoadURL event, and further navigations\n are discovered on the found page. We also keep track and only\n scrape new navigation from pages we haven't crawled yet."
	ENGINEActionDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "headless.Request",
			FieldName: "steps",
		},
	}
	ENGINEActionDoc.Fields = make([]encoder.Doc, 4)
	ENGINEActionDoc.Fields[0].Name = "args"
	ENGINEActionDoc.Fields[0].Type = "map[string]string"
	ENGINEActionDoc.Fields[0].Note = ""
	ENGINEActionDoc.Fields[0].Description = "Args contain arguments for the headless action.\nPer action arguments are described in detail [here](https://nuclei.projectdiscovery.io/templating-guide/protocols/headless/)."
	ENGINEActionDoc.Fields[0].Comments[encoder.LineComment] = "Args contain arguments for the headless action."
	ENGINEActionDoc.Fields[1].Name = "name"
	ENGINEActionDoc.Fields[1].Type = "string"
	ENGINEActionDoc.Fields[1].Note = ""
	ENGINEActionDoc.Fields[1].Description = "Name is the name assigned to the headless action.\n\nThis can be used to execute code, for instance in browser\nDOM using script action, and get the result in a variable\nwhich can be matched upon by nuclei. An Example template [here](https://github.com/projectdiscovery/nuclei-templates/blob/main/headless/prototype-pollution-check.yaml)."
	ENGINEActionDoc.Fields[1].Comments[encoder.LineComment] = "Name is the name assigned to the headless action."
	ENGINEActionDoc.Fields[2].Name = "description"
	ENGINEActionDoc.Fields[2].Type = "string"
	ENGINEActionDoc.Fields[2].Note = ""
	ENGINEActionDoc.Fields[2].Description = "Description is the optional description of the headless action"
	ENGINEActionDoc.Fields[2].Comments[encoder.LineComment] = "Description is the optional description of the headless action"
	ENGINEActionDoc.Fields[3].Name = "action"
	ENGINEActionDoc.Fields[3].Type = "ActionTypeHolder"
	ENGINEActionDoc.Fields[3].Note = ""
	ENGINEActionDoc.Fields[3].Description = "Action is the type of the action to perform."
	ENGINEActionDoc.Fields[3].Comments[encoder.LineComment] = "Action is the type of the action to perform."

	ActionTypeHolderDoc.Type = "ActionTypeHolder"
	ActionTypeHolderDoc.Comments[encoder.LineComment] = " ActionTypeHolder is used to hold internal type of the action"
	ActionTypeHolderDoc.Description = "ActionTypeHolder is used to hold internal type of the action"
	ActionTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "engine.Action",
			FieldName: "action",
		},
	}
	ActionTypeHolderDoc.Fields = make([]encoder.Doc, 1)
	ActionTypeHolderDoc.Fields[0].Name = ""
	ActionTypeHolderDoc.Fields[0].Type = "ActionType"
	ActionTypeHolderDoc.Fields[0].Note = ""
	ActionTypeHolderDoc.Fields[0].Description = ""
	ActionTypeHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	ActionTypeHolderDoc.Fields[0].EnumFields = []string{
		"navigate",
		"script",
		"click",
		"rightclick",
		"text",
		"screenshot",
		"time",
		"select",
		"files",
		"waitdom",
		"waitfcp",
		"waitfmp",
		"waitidle",
		"waitload",
		"waitstable",
		"getresource",
		"extract",
		"setmethod",
		"addheader",
		"setheader",
		"deleteheader",
		"setbody",
		"waitevent",
		"dialog",
		"keyboard",
		"debug",
		"sleep",
		"waitvisible",
	}

	USERAGENTUserAgentHolderDoc.Type = "userAgent.UserAgentHolder"
	USERAGENTUserAgentHolderDoc.Comments[encoder.LineComment] = " UserAgentHolder holds a UserAgent type. Required for un/marshalling purposes"
	USERAGENTUserAgentHolderDoc.Description = "UserAgentHolder holds a UserAgent type. Required for un/marshalling purposes"
	USERAGENTUserAgentHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "headless.Request",
			FieldName: "user_agent",
		},
	}
	USERAGENTUserAgentHolderDoc.Fields = make([]encoder.Doc, 1)
	USERAGENTUserAgentHolderDoc.Fields[0].Name = ""
	USERAGENTUserAgentHolderDoc.Fields[0].Type = "UserAgent"
	USERAGENTUserAgentHolderDoc.Fields[0].Note = ""
	USERAGENTUserAgentHolderDoc.Fields[0].Description = ""
	USERAGENTUserAgentHolderDoc.Fields[0].Comments[encoder.LineComment] = ""
	USERAGENTUserAgentHolderDoc.Fields[0].EnumFields = []string{
		"random",
		"off",
		"default",
		"custom",
	}

	SSLRequestDoc.Type = "ssl.Request"
	SSLRequestDoc.Comments[encoder.LineComment] = " Request is a request for the SSL protocol"
	SSLRequestDoc.Description = "Request is a request for the SSL protocol"
	SSLRequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "ssl",
		},
	}
	SSLRequestDoc.PartDefinitions = []encoder.KeyValue{
		{
			Key:   "template-id",
			Value: "ID of the template executed",
		},
		{
			Key:   "template-info",
			Value: "Info Block of the template executed",
		},
		{
			Key:   "template-path",
			Value: "Path of the template executed",
		},
		{
			Key:   "host",
			Value: "Host is the input to the template",
		},
		{
			Key:   "port",
			Value: "Port is the port of the host",
		},
		{
			Key:   "matched",
			Value: "Matched is the input which was matched upon",
		},
		{
			Key:   "type",
			Value: "Type is the type of request made",
		},
		{
			Key:   "timestamp",
			Value: "Timestamp is the time when the request was made",
		},
		{
			Key:   "response",
			Value: "JSON SSL protocol handshake details",
		},
		{
			Key:   "cipher",
			Value: "Cipher is the encryption algorithm used",
		},
		{
			Key:   "domains",
			Value: "Domains are the list of domain names in the certificate",
		},
		{
			Key:   "fingerprint_hash",
			Value: "Fingerprint hash is the unique identifier of the certificate",
		},
		{
			Key:   "ip",
			Value: "IP is the IP address of the server",
		},
		{
			Key:   "issuer_cn",
			Value: "Issuer CN is the common name of the certificate issuer",
		},
		{
			Key:   "issuer_dn",
			Value: "Issuer DN is the distinguished name of the certificate issuer",
		},
		{
			Key:   "issuer_org",
			Value: "Issuer organization is the organization of the certificate issuer",
		},
		{
			Key:   "not_after",
			Value: "Timestamp after which the remote cert expires",
		},
		{
			Key:   "not_before",
			Value: "Timestamp before which the certificate is not valid",
		},
		{
			Key:   "probe_status",
			Value: "Probe status indicates if the probe was successful",
		},
		{
			Key:   "serial",
			Value: "Serial is the serial number of the certificate",
		},
		{
			Key:   "sni",
			Value: "SNI is the server name indication used in the handshake",
		},
		{
			Key:   "subject_an",
			Value: "Subject AN is the list of subject alternative names",
		},
		{
			Key:   "subject_cn",
			Value: "Subject CN is the common name of the certificate subject",
		},
		{
			Key:   "subject_dn",
			Value: "Subject DN is the distinguished name of the certificate subject",
		},
		{
			Key:   "subject_org",
			Value: "Subject organization is the organization of the certificate subject",
		},
		{
			Key:   "tls_connection",
			Value: "TLS connection is the type of TLS connection used",
		},
		{
			Key:   "tls_version",
			Value: "TLS version is the version of the TLS protocol used",
		},
	}
	SSLRequestDoc.Fields = make([]encoder.Doc, 9)
	SSLRequestDoc.Fields[0].Name = "id"
	SSLRequestDoc.Fields[0].Type = "string"
	SSLRequestDoc.Fields[0].Note = ""
	SSLRequestDoc.Fields[0].Description = "ID is the optional id of the request"
	SSLRequestDoc.Fields[0].Comments[encoder.LineComment] = " ID is the optional id of the request"
	SSLRequestDoc.Fields[1].Name = "address"
	SSLRequestDoc.Fields[1].Type = "string"
	SSLRequestDoc.Fields[1].Note = ""
	SSLRequestDoc.Fields[1].Description = "Address contains address for the request"
	SSLRequestDoc.Fields[1].Comments[encoder.LineComment] = "Address contains address for the request"
	SSLRequestDoc.Fields[2].Name = "min_version"
	SSLRequestDoc.Fields[2].Type = "string"
	SSLRequestDoc.Fields[2].Note = ""
	SSLRequestDoc.Fields[2].Description = "Minimum tls version - auto if not specified."
	SSLRequestDoc.Fields[2].Comments[encoder.LineComment] = "Minimum tls version - auto if not specified."
	SSLRequestDoc.Fields[2].Values = []string{
		"sslv3",
		"tls10",
		"tls11",
		"tls12",
		"tls13",
	}
	SSLRequestDoc.Fields[3].Name = "max_version"
	SSLRequestDoc.Fields[3].Type = "string"
	SSLRequestDoc.Fields[3].Note = ""
	SSLRequestDoc.Fields[3].Description = "Max tls version - auto if not specified."
	SSLRequestDoc.Fields[3].Comments[encoder.LineComment] = "Max tls version - auto if not specified."
	SSLRequestDoc.Fields[3].Values = []string{
		"sslv3",
		"tls10",
		"tls11",
		"tls12",
		"tls13",
	}
	SSLRequestDoc.Fields[4].Name = "cipher_suites"
	SSLRequestDoc.Fields[4].Type = "[]string"
	SSLRequestDoc.Fields[4].Note = ""
	SSLRequestDoc.Fields[4].Description = "Client Cipher Suites  - auto if not specified."
	SSLRequestDoc.Fields[4].Comments[encoder.LineComment] = "Client Cipher Suites  - auto if not specified."
	SSLRequestDoc.Fields[5].Name = "scan_mode"
	SSLRequestDoc.Fields[5].Type = "string"
	SSLRequestDoc.Fields[5].Note = ""
	SSLRequestDoc.Fields[5].Description = "description: |\n   Tls Scan Mode - auto if not specified\n values:\n   - \"ctls\"\n   - \"ztls\"\n   - \"auto\"\n	 - \"openssl\" # reverts to \"auto\" is openssl is not installed"
	SSLRequestDoc.Fields[5].Comments[encoder.LineComment] = " description: |"
	SSLRequestDoc.Fields[6].Name = "tls_version_enum"
	SSLRequestDoc.Fields[6].Type = "bool"
	SSLRequestDoc.Fields[6].Note = ""
	SSLRequestDoc.Fields[6].Description = "TLS Versions Enum - false if not specified\nEnumerates supported TLS versions"
	SSLRequestDoc.Fields[6].Comments[encoder.LineComment] = "TLS Versions Enum - false if not specified"
	SSLRequestDoc.Fields[7].Name = "tls_cipher_enum"
	SSLRequestDoc.Fields[7].Type = "bool"
	SSLRequestDoc.Fields[7].Note = ""
	SSLRequestDoc.Fields[7].Description = "TLS Ciphers Enum - false if not specified\nEnumerates supported TLS ciphers"
	SSLRequestDoc.Fields[7].Comments[encoder.LineComment] = "TLS Ciphers Enum - false if not specified"
	SSLRequestDoc.Fields[8].Name = "tls_cipher_types"
	SSLRequestDoc.Fields[8].Type = "[]string"
	SSLRequestDoc.Fields[8].Note = ""
	SSLRequestDoc.Fields[8].Description = "description: |\n  TLS Cipher types to enumerate\n values:\n   - \"insecure\" (default)\n   - \"weak\"\n   - \"secure\"\n   - \"all\""
	SSLRequestDoc.Fields[8].Comments[encoder.LineComment] = " description: |"

	WEBSOCKETRequestDoc.Type = "websocket.Request"
	WEBSOCKETRequestDoc.Comments[encoder.LineComment] = " Request is a request for the Websocket protocol"
	WEBSOCKETRequestDoc.Description = "Request is a request for the Websocket protocol"
	WEBSOCKETRequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "websocket",
		},
	}
	WEBSOCKETRequestDoc.PartDefinitions = []encoder.KeyValue{
		{
			Key:   "type",
			Value: "Type is the type of request made",
		},
		{
			Key:   "success",
			Value: "Success specifies whether websocket connection was successful",
		},
		{
			Key:   "request",
			Value: "Websocket request made to the server",
		},
		{
			Key:   "response",
			Value: "Websocket response received from the server",
		},
		{
			Key:   "host",
			Value: "Host is the input to the template",
		},
		{
			Key:   "matched",
			Value: "Matched is the input which was matched upon",
		},
	}
	WEBSOCKETRequestDoc.Fields = make([]encoder.Doc, 6)
	WEBSOCKETRequestDoc.Fields[0].Name = "id"
	WEBSOCKETRequestDoc.Fields[0].Type = "string"
	WEBSOCKETRequestDoc.Fields[0].Note = ""
	WEBSOCKETRequestDoc.Fields[0].Description = "ID is the optional id of the request"
	WEBSOCKETRequestDoc.Fields[0].Comments[encoder.LineComment] = " ID is the optional id of the request"
	WEBSOCKETRequestDoc.Fields[1].Name = "address"
	WEBSOCKETRequestDoc.Fields[1].Type = "string"
	WEBSOCKETRequestDoc.Fields[1].Note = ""
	WEBSOCKETRequestDoc.Fields[1].Description = "Address contains address for the request"
	WEBSOCKETRequestDoc.Fields[1].Comments[encoder.LineComment] = "Address contains address for the request"
	WEBSOCKETRequestDoc.Fields[2].Name = "inputs"
	WEBSOCKETRequestDoc.Fields[2].Type = "[]websocket.Input"
	WEBSOCKETRequestDoc.Fields[2].Note = ""
	WEBSOCKETRequestDoc.Fields[2].Description = "Inputs contains inputs for the websocket protocol"
	WEBSOCKETRequestDoc.Fields[2].Comments[encoder.LineComment] = "Inputs contains inputs for the websocket protocol"
	WEBSOCKETRequestDoc.Fields[3].Name = "headers"
	WEBSOCKETRequestDoc.Fields[3].Type = "map[string]string"
	WEBSOCKETRequestDoc.Fields[3].Note = ""
	WEBSOCKETRequestDoc.Fields[3].Description = "Headers contains headers for the request."
	WEBSOCKETRequestDoc.Fields[3].Comments[encoder.LineComment] = "Headers contains headers for the request."
	WEBSOCKETRequestDoc.Fields[4].Name = "attack"
	WEBSOCKETRequestDoc.Fields[4].Type = "generators.AttackTypeHolder"
	WEBSOCKETRequestDoc.Fields[4].Note = ""
	WEBSOCKETRequestDoc.Fields[4].Description = "Attack is the type of payload combinations to perform.\n\nSniper is each payload once, pitchfork combines multiple payload sets and clusterbomb generates\npermutations and combinations for all payloads."
	WEBSOCKETRequestDoc.Fields[4].Comments[encoder.LineComment] = "Attack is the type of payload combinations to perform."
	WEBSOCKETRequestDoc.Fields[5].Name = "payloads"
	WEBSOCKETRequestDoc.Fields[5].Type = "map[string]interface{}"
	WEBSOCKETRequestDoc.Fields[5].Note = ""
	WEBSOCKETRequestDoc.Fields[5].Description = "Payloads contains any payloads for the current request.\n\nPayloads support both key-values combinations where a list\nof payloads is provided, or optionally a single file can also\nbe provided as payload which will be read on run-time."
	WEBSOCKETRequestDoc.Fields[5].Comments[encoder.LineComment] = "Payloads contains any payloads for the current request."

	WEBSOCKETInputDoc.Type = "websocket.Input"
	WEBSOCKETInputDoc.Comments[encoder.LineComment] = ""
	WEBSOCKETInputDoc.Description = ""
	WEBSOCKETInputDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "websocket.Request",
			FieldName: "inputs",
		},
	}
	WEBSOCKETInputDoc.Fields = make([]encoder.Doc, 2)
	WEBSOCKETInputDoc.Fields[0].Name = "data"
	WEBSOCKETInputDoc.Fields[0].Type = "string"
	WEBSOCKETInputDoc.Fields[0].Note = ""
	WEBSOCKETInputDoc.Fields[0].Description = "Data is the data to send as the input.\n\nIt supports DSL Helper Functions as well as normal expressions."
	WEBSOCKETInputDoc.Fields[0].Comments[encoder.LineComment] = "Data is the data to send as the input."

	WEBSOCKETInputDoc.Fields[0].AddExample("", "TEST")

	WEBSOCKETInputDoc.Fields[0].AddExample("", "hex_decode('50494e47')")
	WEBSOCKETInputDoc.Fields[1].Name = "name"
	WEBSOCKETInputDoc.Fields[1].Type = "string"
	WEBSOCKETInputDoc.Fields[1].Note = ""
	WEBSOCKETInputDoc.Fields[1].Description = "Name is the optional name of the data read to provide matching on."
	WEBSOCKETInputDoc.Fields[1].Comments[encoder.LineComment] = "Name is the optional name of the data read to provide matching on."

	WEBSOCKETInputDoc.Fields[1].AddExample("", "prefix")

	WHOISRequestDoc.Type = "whois.Request"
	WHOISRequestDoc.Comments[encoder.LineComment] = " Request is a request for the WHOIS protocol"
	WHOISRequestDoc.Description = "Request is a request for the WHOIS protocol"
	WHOISRequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "whois",
		},
	}
	WHOISRequestDoc.Fields = make([]encoder.Doc, 3)
	WHOISRequestDoc.Fields[0].Name = "id"
	WHOISRequestDoc.Fields[0].Type = "string"
	WHOISRequestDoc.Fields[0].Note = ""
	WHOISRequestDoc.Fields[0].Description = "ID is the optional id of the request"
	WHOISRequestDoc.Fields[0].Comments[encoder.LineComment] = " ID is the optional id of the request"
	WHOISRequestDoc.Fields[1].Name = "query"
	WHOISRequestDoc.Fields[1].Type = "string"
	WHOISRequestDoc.Fields[1].Note = ""
	WHOISRequestDoc.Fields[1].Description = "Query contains query for the request"
	WHOISRequestDoc.Fields[1].Comments[encoder.LineComment] = "Query contains query for the request"
	WHOISRequestDoc.Fields[2].Name = "server"
	WHOISRequestDoc.Fields[2].Type = "string"
	WHOISRequestDoc.Fields[2].Note = ""
	WHOISRequestDoc.Fields[2].Description = "description: |\n 	 Optional WHOIS server URL.\n\n 	 If present, specifies the WHOIS server to execute the Request on.\n   Otherwise, nil enables bootstrapping"
	WHOISRequestDoc.Fields[2].Comments[encoder.LineComment] = " description: |"

	CODERequestDoc.Type = "code.Request"
	CODERequestDoc.Comments[encoder.LineComment] = " Request is a request for the SSL protocol"
	CODERequestDoc.Description = "Request is a request for the SSL protocol"
	CODERequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "code",
		},
	}
	CODERequestDoc.PartDefinitions = []encoder.KeyValue{
		{
			Key:   "type",
			Value: "Type is the type of request made",
		},
		{
			Key:   "host",
			Value: "Host is the input to the template",
		},
		{
			Key:   "matched",
			Value: "Matched is the input which was matched upon",
		},
	}
	CODERequestDoc.Fields = make([]encoder.Doc, 6)
	CODERequestDoc.Fields[0].Name = "id"
	CODERequestDoc.Fields[0].Type = "string"
	CODERequestDoc.Fields[0].Note = ""
	CODERequestDoc.Fields[0].Description = "ID is the optional id of the request"
	CODERequestDoc.Fields[0].Comments[encoder.LineComment] = " ID is the optional id of the request"
	CODERequestDoc.Fields[1].Name = "engine"
	CODERequestDoc.Fields[1].Type = "[]string"
	CODERequestDoc.Fields[1].Note = ""
	CODERequestDoc.Fields[1].Description = "Engine type"
	CODERequestDoc.Fields[1].Comments[encoder.LineComment] = "Engine type"
	CODERequestDoc.Fields[2].Name = "pre-condition"
	CODERequestDoc.Fields[2].Type = "string"
	CODERequestDoc.Fields[2].Note = ""
	CODERequestDoc.Fields[2].Description = "PreCondition is a condition which is evaluated before sending the request."
	CODERequestDoc.Fields[2].Comments[encoder.LineComment] = "PreCondition is a condition which is evaluated before sending the request."
	CODERequestDoc.Fields[3].Name = "args"
	CODERequestDoc.Fields[3].Type = "[]string"
	CODERequestDoc.Fields[3].Note = ""
	CODERequestDoc.Fields[3].Description = "Engine Arguments"
	CODERequestDoc.Fields[3].Comments[encoder.LineComment] = "Engine Arguments"
	CODERequestDoc.Fields[4].Name = "pattern"
	CODERequestDoc.Fields[4].Type = "string"
	CODERequestDoc.Fields[4].Note = ""
	CODERequestDoc.Fields[4].Description = "Pattern preferred for file name"
	CODERequestDoc.Fields[4].Comments[encoder.LineComment] = "Pattern preferred for file name"
	CODERequestDoc.Fields[5].Name = "source"
	CODERequestDoc.Fields[5].Type = "string"
	CODERequestDoc.Fields[5].Note = ""
	CODERequestDoc.Fields[5].Description = "Source File/Snippet"
	CODERequestDoc.Fields[5].Comments[encoder.LineComment] = "Source File/Snippet"

	JAVASCRIPTRequestDoc.Type = "javascript.Request"
	JAVASCRIPTRequestDoc.Comments[encoder.LineComment] = " Request is a request for the javascript protocol"
	JAVASCRIPTRequestDoc.Description = "Request is a request for the javascript protocol"
	JAVASCRIPTRequestDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "javascript",
		},
	}
	JAVASCRIPTRequestDoc.PartDefinitions = []encoder.KeyValue{
		{
			Key:   "type",
			Value: "Type is the type of request made",
		},
		{
			Key:   "response",
			Value: "Javascript protocol result response",
		},
		{
			Key:   "host",
			Value: "Host is the input to the template",
		},
		{
			Key:   "matched",
			Value: "Matched is the input which was matched upon",
		},
	}
	JAVASCRIPTRequestDoc.Fields = make([]encoder.Doc, 9)
	JAVASCRIPTRequestDoc.Fields[0].Name = "id"
	JAVASCRIPTRequestDoc.Fields[0].Type = "string"
	JAVASCRIPTRequestDoc.Fields[0].Note = ""
	JAVASCRIPTRequestDoc.Fields[0].Description = "description: |\n ID is request id in that protocol"
	JAVASCRIPTRequestDoc.Fields[0].Comments[encoder.LineComment] = " description: |"
	JAVASCRIPTRequestDoc.Fields[1].Name = "init"
	JAVASCRIPTRequestDoc.Fields[1].Type = "string"
	JAVASCRIPTRequestDoc.Fields[1].Note = ""
	JAVASCRIPTRequestDoc.Fields[1].Description = "Init is javascript code to execute after compiling template and before executing it on any target\nThis is helpful for preparing payloads or other setup that maybe required for exploits"
	JAVASCRIPTRequestDoc.Fields[1].Comments[encoder.LineComment] = "Init is javascript code to execute after compiling template and before executing it on any target"
	JAVASCRIPTRequestDoc.Fields[2].Name = "pre-condition"
	JAVASCRIPTRequestDoc.Fields[2].Type = "string"
	JAVASCRIPTRequestDoc.Fields[2].Note = ""
	JAVASCRIPTRequestDoc.Fields[2].Description = "PreCondition is a condition which is evaluated before sending the request."
	JAVASCRIPTRequestDoc.Fields[2].Comments[encoder.LineComment] = "PreCondition is a condition which is evaluated before sending the request."
	JAVASCRIPTRequestDoc.Fields[3].Name = "args"
	JAVASCRIPTRequestDoc.Fields[3].Type = "map[string]interface{}"
	JAVASCRIPTRequestDoc.Fields[3].Note = ""
	JAVASCRIPTRequestDoc.Fields[3].Description = "Args contains the arguments to pass to the javascript code."
	JAVASCRIPTRequestDoc.Fields[3].Comments[encoder.LineComment] = "Args contains the arguments to pass to the javascript code."
	JAVASCRIPTRequestDoc.Fields[4].Name = "code"
	JAVASCRIPTRequestDoc.Fields[4].Type = "string"
	JAVASCRIPTRequestDoc.Fields[4].Note = ""
	JAVASCRIPTRequestDoc.Fields[4].Description = "Code contains code to execute for the javascript request."
	JAVASCRIPTRequestDoc.Fields[4].Comments[encoder.LineComment] = "Code contains code to execute for the javascript request."
	JAVASCRIPTRequestDoc.Fields[5].Name = "stop-at-first-match"
	JAVASCRIPTRequestDoc.Fields[5].Type = "bool"
	JAVASCRIPTRequestDoc.Fields[5].Note = ""
	JAVASCRIPTRequestDoc.Fields[5].Description = "StopAtFirstMatch stops processing the request at first match."
	JAVASCRIPTRequestDoc.Fields[5].Comments[encoder.LineComment] = "StopAtFirstMatch stops processing the request at first match."
	JAVASCRIPTRequestDoc.Fields[6].Name = "attack"
	JAVASCRIPTRequestDoc.Fields[6].Type = "generators.AttackTypeHolder"
	JAVASCRIPTRequestDoc.Fields[6].Note = ""
	JAVASCRIPTRequestDoc.Fields[6].Description = "Attack is the type of payload combinations to perform.\n\nSniper is each payload once, pitchfork combines multiple payload sets and clusterbomb generates\npermutations and combinations for all payloads."
	JAVASCRIPTRequestDoc.Fields[6].Comments[encoder.LineComment] = "Attack is the type of payload combinations to perform."
	JAVASCRIPTRequestDoc.Fields[7].Name = "threads"
	JAVASCRIPTRequestDoc.Fields[7].Type = "int"
	JAVASCRIPTRequestDoc.Fields[7].Note = ""
	JAVASCRIPTRequestDoc.Fields[7].Description = "Payload concurreny i.e threads for sending requests."
	JAVASCRIPTRequestDoc.Fields[7].Comments[encoder.LineComment] = "Payload concurreny i.e threads for sending requests."

	JAVASCRIPTRequestDoc.Fields[7].AddExample("Send requests using 10 concurrent threads", 10)
	JAVASCRIPTRequestDoc.Fields[8].Name = "payloads"
	JAVASCRIPTRequestDoc.Fields[8].Type = "map[string]interface{}"
	JAVASCRIPTRequestDoc.Fields[8].Note = ""
	JAVASCRIPTRequestDoc.Fields[8].Description = "Payloads contains any payloads for the current request.\n\nPayloads support both key-values combinations where a list\nof payloads is provided, or optionally a single file can also\nbe provided as payload which will be read on run-time."
	JAVASCRIPTRequestDoc.Fields[8].Comments[encoder.LineComment] = "Payloads contains any payloads for the current request."

	HTTPSignatureTypeHolderDoc.Type = "http.SignatureTypeHolder"
	HTTPSignatureTypeHolderDoc.Comments[encoder.LineComment] = " SignatureTypeHolder is used to hold internal type of the signature"
	HTTPSignatureTypeHolderDoc.Description = "SignatureTypeHolder is used to hold internal type of the signature"
	HTTPSignatureTypeHolderDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "signature",
		},
	}
	HTTPSignatureTypeHolderDoc.Fields = make([]encoder.Doc, 0)

	VARIABLESVariableDoc.Type = "variables.Variable"
	VARIABLESVariableDoc.Comments[encoder.LineComment] = " Variable is a key-value pair of strings that can be used"
	VARIABLESVariableDoc.Description = "Variable is a key-value pair of strings that can be used\n throughout template."
	VARIABLESVariableDoc.AppearsIn = []encoder.Appearance{
		{
			TypeName:  "Template",
			FieldName: "variables",
		},
	}
	VARIABLESVariableDoc.Fields = make([]encoder.Doc, 0)
}

// GetTemplateDoc returns documentation for the file templates_doc.go.
func GetTemplateDoc() *encoder.FileDoc {
	return &encoder.FileDoc{
		Name:        "Template",
		Description: "",
		Structs: []*encoder.Doc{
			&TemplateDoc,
			&MODELInfoDoc,
			&STRINGSLICEStringSliceDoc,
			&STRINGSLICERawStringSliceDoc,
			&SEVERITYHolderDoc,
			&MODELClassificationDoc,
			&HTTPRequestDoc,
			&GENERATORSAttackTypeHolderDoc,
			&HTTPMethodTypeHolderDoc,
			&FUZZRuleDoc,
			&SliceOrMapSliceDoc,
			&SignatureTypeHolderDoc,
			&MATCHERSMatcherDoc,
			&MatcherTypeHolderDoc,
			&DNSRequestDoc,
			&DNSRequestTypeHolderDoc,
			&FILERequestDoc,
			&NETWORKRequestDoc,
			&NETWORKInputDoc,
			&NetworkInputTypeHolderDoc,
			&HEADLESSRequestDoc,
			&ENGINEActionDoc,
			&ActionTypeHolderDoc,
			&USERAGENTUserAgentHolderDoc,
			&SSLRequestDoc,
			&WEBSOCKETRequestDoc,
			&WEBSOCKETInputDoc,
			&WHOISRequestDoc,
			&CODERequestDoc,
			&JAVASCRIPTRequestDoc,
			&HTTPSignatureTypeHolderDoc,
			&VARIABLESVariableDoc,
		},
	}
}
