## Termbox
Termbox is a library that provides a minimalistic API which allows the programmer to write text-based user interfaces. The library is crossplatform and has both terminal-based implementations on *nix operating systems and a winapi console based implementation for windows operating systems. The basic idea is an abstraction of the greatest common subset of features available on all major terminals and other terminal-like APIs in a minimalistic fashion. Small API means it is easy to implement, test, maintain and learn it, that's what makes the termbox a distinct library in its area.

### Installation
Install and update this go package with `go get -u github.com/nsf/termbox-go`

### Examples
For examples of what can be done take a look at demos in the _demos directory. You can try them with go run: `go run _demos/keyboard.go`

There are also some interesting projects using termbox-go:
 - [godit](https://github.com/nsf/godit) is an emacsish lightweight text editor written using termbox.
 - [gomatrix](https://github.com/GeertJohan/gomatrix) connects to The Matrix and displays its data streams in your terminal.
 - [gotetris](https://github.com/jjinux/gotetris) is an implementation of Tetris.
 - [sokoban-go](https://github.com/rn2dy/sokoban-go) is an implementation of sokoban game.
 - [hecate](https://github.com/evanmiller/hecate) is a hex editor designed by Satan.
 - [httopd](https://github.com/verdverm/httopd) is top for httpd logs.
 - [mop](https://github.com/michaeldv/mop) is stock market tracker for hackers.
 - [termui](https://github.com/gizak/termui) is a terminal dashboard.
 - [termloop](https://github.com/JoelOtter/termloop) is a terminal game engine.
 - [xterm-color-chart](https://github.com/kutuluk/xterm-color-chart) is a XTerm 256 color chart.
 - [gocui](https://github.com/jroimartin/gocui) is a minimalist Go library aimed at creating console user interfaces.
 - [dry](https://github.com/moncho/dry) is an interactive cli to manage Docker containers.

### API reference
[godoc.org/github.com/nsf/termbox-go](http://godoc.org/github.com/nsf/termbox-go)
