# ndiag architecture

![view](view-overview.svg)

This document explains how ndiag generates the architecture documentation when you actually run the following commands.

#### Sample Architecture

WIP

[3-Tier Architecture](/example/3-tier/output/README.md)

![3tier](/example/3-tier/output/view-overview.svg)

``` console
$ ndiag doc -c example/3-tier/input/ndiag.yml -n example/3-tier/input/nodes.yml --rm-dist
```

### Documentation cycle

WIP

#### Input

WIP

#### Output (architecture document)

WIP

### Node

node id = `[node name]`

### Layer

layer id = `[layer name]`

### Cluster

cluster id = `[layer name]:[cluster name]`

### Component

**global component:**

component id = `[component name]`

**cluster component:**

component id = `[layer name]:[cluster name]:[component name]`

**node component:**

component id = `[node name]:[component name]`


<p align="right">
  [ <a href="../ndiag.descriptions/_index.md">:pencil2: Edit description</a> ]
</p>


## Views

| Name | Description |
| --- | --- |
| [overview](view-overview.md) | <a href="../ndiag.descriptions/_view-overview.md">:pencil2:</a> |
| [input](view-input.md) | <a href="../ndiag.descriptions/_view-input.md">:pencil2:</a> |
| [output](view-output.md) | <a href="../ndiag.descriptions/_view-output.md">:pencil2:</a> |

## Components

| Name | Description |
| --- | --- |
| [input files](node-input_files.md) | <a href="../ndiag.descriptions/_node-input_files.md">:pencil2:</a> |
| [ndiag](node-ndiag.md) | `ndiag doc` command |
| [documents](node-documents.md) | <a href="../ndiag.descriptions/_node-documents.md">:pencil2:</a> |



---

> Generated by [ndiag](https://github.com/k1LoW/ndiag)
