# Create JSON Array (`ja`)

> A sophisticated yet simply way to build a JSON array

## Description

Murex has a pretty sophisticated builtin for generating JSON arrays.
It works a little bit like Bash's `{1..9}` syntax but includes a few
additional nifty features.

**Please note that while this builtin is not marked for deprecation, it has
been superseded by the `%[]` tokens.** ([read more](../parser/create-array.md))

## Usage

```
ja [start..end] -> <stdout>
ja [start..end.base] -> <stdout>
ja [start..end,start..end] -> <stdout>
ja [start..end][start..end] -> <stdout>
```

## Examples

```
» ja [1..5]
[
    "1",
    "2",
    "3",
    "4",
    "5"
]
```

```
» ja [Monday..Sunday]
[
    "Monday",
    "Tuesday",
    "Wednesday",
    "Thursday",
    "Friday",
    "Saturday",
    "Sunday"
]
```

Please note that as per the first example, all arrays generated by `ja` are
arrays of strings - even if you're command is ranging over integers.

## Detail

Please read the documentation on `a` for a more detailed breakdown on of
`ja`'s supported features.

## See Also

* [Count (`count`)](../commands/count.md):
  Count items in a map, list or array
* [Create New Array (`ta`)](../commands/ta.md):
  A sophisticated yet simple way to build an array of a user defined data-type
* [Filter By Range `[ ..Range ]`](../parser/range.md):
  Outputs a ranged subset of data from stdin
* [Get Item (`[ Index ]`)](../parser/item-index.md):
  Outputs an element from an array, map or table
* [Get Nested Element (`[[ Element ]]`)](../parser/element.md):
  Outputs an element from a nested structure
* [Reverse Array (`mtac`)](../commands/mtac.md):
  Reverse the order of an array
* [Stream New List (`a`)](../commands/a.md):
  A sophisticated yet simple way to stream an array or list (mkarray)
* [`%[]` Array Builder](../parser/create-array.md):
  Quickly generate arrays
* [`json`](../types/json.md):
  JavaScript Object Notation (JSON)

<hr/>

This document was generated from [builtins/core/mkarray/array_doc.yaml](https://github.com/lmorg/murex/blob/master/builtins/core/mkarray/array_doc.yaml).