# v6.4

This change brings a number of ergonomic improvements to job control, `datetime` and working with structures.

## Deprecation Warnings

Please read out [compatibility commitment](https://murex.rocks/compatibility.html) to understand how features are deprecated.

* the `?` pipe will be deprecated to make way for a the ternary operator. You can achieve the same result with `<err> <!out>`, eg `command <err> <!out> parameters... | next-command ...`
  
* the `=` and `let` builtins are now officially deprecated. They've been marked as deprecated in the documentation for a couple of years but you'll now receive a deprecation warning when using them. This warning will not impact any functions that call them (they bypass the stdout and stderr pipes and write directly to your TTY) but it is still recommended that you update any existing code not to use it. The change is very simple, Murex supported expressions as first class primitives, so you can simply drop the `=` and `let` command names from your expressions

* `tread` has been deprecated for a while due to `read` supporting all `tread`'s use cases. `tread` will officially be removed in the next release

* `@[]` syntax for ranging has been deprecated for a while. It will be officially removed in the next release in favour of `[]`

* backtick strings (````) has been an undocumented hack for several years. This release officially sees that hack as deprecated and will be removed in the next release

* `die` has been deprecated because it just adds a feature for no purpose. It was original borrowed from Perl but realistically you can do the same with `exit 1` so this removal is to bring the language complexity down.

## Breaking Changes

None

## Features

* IO redirection: smarter file pipes which solve the race condition seen in traditional shells where you try to write to the same file you're reading from (EXPERIMENTAL) ([issue #851](https://github.com/lmorg/murex/issues/851))

* private functions: these can now be undefined ([issue #429](https://github.com/lmorg/murex/issues/429))
  
* core: `(expressions)` are supported in dot notation. eg:
  ```
  » bob = %[foo bar baz]
  » out $bob.(1+1)
  baz
  ```

* elements: negative values are supported for counting backwards. eg:
  ```
  » bob = %[foo bar baz]
  » out $(bob.-1)
  baz
  ```

* core: support added for Bash-like job IDs (`%n`) in job control ([issue #889](https://github.com/lmorg/murex/issues/889))

* `bg` / `fg`: support for command line parameters, as well as Bash-like job IDs ([issue #889](https://github.com/lmorg/murex/issues/889))

* function: support for optional parameters when using named parameters ([issue #888](https://github.com/lmorg/murex/issues/888))

* autocomplete: improved autocompletion for `kill` ([issue #867](https://github.com/lmorg/murex/issues/867))

* `datetime`: numerous ergonomic improvements ([read more](https://murex.rocks/commands/datetime.html), [commit](https://github.com/lmorg/murex/pull/887/commits/ffc38623f07c6331a0113913c81e83fe85792d22))

* readline: `MaxTabCompleterRows` is now more granular ([commit](https://github.com/lmorg/murex/pull/887/commits/9ab0803731ca4c02d524cbe2fa002dee658c3a1e))

* mxtty: updated `csv` support ([commit](https://github.com/lmorg/murex/pull/887/commits/9fb0ab53f7c32556fc54f66b977048d2f1563b64), [read more](https://github.com/lmorg/mxtty)) 

## Bug Fixes

* private functions: mutex added to mitigate a potential race condition ([issue #883](https://github.com/lmorg/murex/issues/883))

* core: line numbering bugfix ([commit](https://github.com/lmorg/murex/pull/887/commits/615f76dd891a23fe93b4d8aa5a999cc22bcd1908))

* readline: when in Vim mode, `a` and `A` should move the cursor right ([commit](https://github.com/lmorg/murex/pull/887/commits/4fb351c9841dc78997c56aca19232e5a94ab9ec6))

* index: support for null values ([commit](https://github.com/lmorg/murex/pull/887/commits/e11da27775127ef60063f4d2f76fd3a698a52f9a))
  
* core: improvements with how raw command line parameters are passed to internal routines, which fixes a number of reporting bugs in process management tools

## Special Thanks

Thank yous for this release goes to [tiymat](https://github.com/tiymat), [atagen](https://github.com/atagen) for your testing and feedback.

Also thank you to everyone in the [discussions group](https://github.com/lmorg/murex/discussions) and all who raise bug reports.

You rock!

<hr>

Published: 22.11.2024 at 21:32

## See Also

* [Background Process (`bg`)](../commands/bg.md):
  Run processes in the background
* [Date And Time Conversion (`datetime`)](../commands/datetime.md):
  A date and/or time conversion tool (like `printf` but for date and time values)
* [Foreground Process (`fg`)](../commands/fg.md):
  Sends a background process into the foreground
* [Get Nested Element (`[[ Element ]]`)](../parser/element.md):
  Outputs an element from a nested structure
* [How To Contribute](../Murex/CONTRIBUTING.md):
  Murex is community project. We gratefully accept contributions
* [index](../parser/item-index.md):
  Outputs an element from an array, map or table

<hr/>

This document was generated from [gen/changelog/v6.4_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/changelog/v6.4_doc.yaml).