# v6.1

This release sees a massive jump in event-driven capabilities as well as several new features and bug fixes.

## Breaking Changes

* core: FID output refactored in `runtime` and `debug`. However the output of these builtins shouldn't be depended on as a stable API. They exist for manual inspection and debugging
  
* `runtime`: `--flush-cache` flag has been renamed to `--clear-cache`

* events: key names for namespaced events switched from **interrupt_name** to **name.interrupt**. The only event impacted by this change is `onPrompt` and even there, the only time this change should be noticeable is when manually removing an event [read more](/docs/events/onprompt.md#namespacing)

* ANSI Constants: `{F1}`, `{F2}`, `{F3}`, `{F4}` now produce the same escape sequences as `{F1-VT100}` (...and so on). This is to bring F1 to F4 keys inline with xterm, and thus all other compatible terminal emulators. You can still use the previous escape codes via `{F1-VT220}` (...and so on). `{F5}` and above are unchanged ([read more](/docs/user-guide/ansi.md))

## Deprecation Warnings

Please read out [compatibility commitment](/./compatibility.md) to understand how features are deprecated.

* the `?` pipe will be deprecated to make way for a the ternary operator. You can achieve the same result with `<err> <!out>`, eg `command <err> <!out> parameters... | next-command ...`
  
* the `=` and `let` builtins are now officially deprecated. They've been marked as deprecated in the documentation for a couple of years but you'll now receive a deprecation warning when using them. This warning will not impact any functions that call them (they bypass the stdout and stderr pipes and write directly to your TTY) but it is still recommended that you update any existing code not to use it. The change is very simple, Murex supported expressions as first class primitives, so you can simply drop the `=` and `let` command names from your expressions

## Features

Features marked as **EXPERIMENTAL** are provided without assurances of future breaking changes. All other features are considered stable as part of Murex's [compatibility commitment](/./compatibility.md).

* preview: support added for ChatGPT. This feature is disabled by default. ([read more](/docs/integrations/chatgpt.md)) **EXPERIMENTAL**

* preview: [support added](/docs/integrations/make.md) for `Makefile`s

* new event: `onPreview` ([read more](/docs/events/onpreview.md)) **EXPERIMENTAL**
  
* `onKeyPress`: event completely redesigned ([read more](/docs/events/onkeypress.md)) **EXPERIMENTAL**

* new builtin: `key-code`. This builtin allows for easy inspection of what control sequences your terminal emulator is sending to the shell ([read more](/docs/commands/key-code.md)) **EXPERIMENTAL**
  
* events: support added for return values -- allowing events to modify state safely (used in [onPreview](/docs/events/onpreview.md) & [onKeyPress](/docs/events/onkeypress.md))
  
* events: smarter error handling
 
* `runtime`: new flags: `--integrations`, `--event-types`, `--cache-db-enabled`, `--cache-db-path`, `--cache-namespaces` ([read more](/docs/commands/runtime.md))

* core: map added for default mimes per Murex data type ([read more](/docs/commands/get.md#as-a-method))
 
* `get`: support added to default a `Content-Type` header based on stdin data type ([read more](/docs/commands/get.md#as-a-method))

* `post`: support added to default a `Content-Type` header based on stdin data type ([read more](/docs/commands/post.md#as-a-method))
  
* readline: `home` and `end` hotkeys added to preview for quick navigation ([read more](/docs/user-guide/terminal-keys.md#autocomplete-preview))
  
* `man-summary` now returns a non-zero exit number if no man page is found ([read more](/docs/commands/man-summary.md#detail))
  
* `datetime`: improved error messages ([read more](/docs/commands/datetime.md))

* hint text: improved status message for `cd` ([PR #806](https://github.com/lmorg/murex/pull/806))

* autocomplete: improved autocomplete for `go` ([integrations/go_any.mx](https://github.com/lmorg/murex/blob/ab3010a0818977cc6cdeb23d5df9dbf937b33961/integrations/go_any.mx))

* optimization: removed various nil checks and pipe dependent checks from release builds (improves performance slightly, albeit in the realm of micro-optimisations)

* core: new flag: `--quiet` ([issue #797](https://github.com/lmorg/murex/issues/797))

* core: env pipes without `=` will now pass the local variable of the same name

* core: crash handling added. While the shell rarely panics these days, such incidents are not caught. This was intentional so that a stack trace could be produced for debugging. However we are now at the point where catching panics is more valuable than a full stack trace

* dev tooling: new `debug` flag, `panic`, raises an exception to test crashing the shell ([read more](/docs/commands/debug.md#generating-a-panic))
  
* dev tooling: added tracing tools for debugging Murex's source code ([commit 0a158b0](https://github.com/lmorg/murex/pull/794/commits/0a158b079a1b5953f60f36c62b6d9fc604d6ecb6) & [commit 6454955](https://github.com/lmorg/murex/pull/794/commits/6454955e9641748ea7fd0a95ed2f9a5ef2ca472f))

* documentation: lots of new docs written!

* dev tooling: CI/CD support for latest Go versions

* dev tooling: new functions added to `docgen`

## Bug Fixes

* caching: `cache.db` is now opened on demand. This should allow for better support accessing the cache from multiple Murex sessions in parallel

* csv: missing flush from CSV marshaller ([issue #801](https://github.com/lmorg/murex/issues/801))

* readline: missing whitespace trimming from recall word ([issue #808](https://github.com/lmorg/murex/issues/808))

* readline: unicode support added for preview -- thus fixing some rendering glitches with non-ASCII characters

* core: improved garbage collection for forks

* readline: improved garbage collection for preview

* readline: include errors in preview

* profile: `openagent` for `image` data type wasn't passing path to image correctly

* profile: `openagent` for `image` data type wasn't autodetecting shell correctly
  
* profile: `openagent` default profile included references to deprecated maths lib

* safe-commands: `td` should have been `tr`
  
* safe-commands: `let` removed due to deprecation of maths lib
  
* core: 'executing' state was defined too early. Now happens at last moment before process executes

* readline: check a builtin is compiled before defaulting to builtin docs in preview
  
* readline: pane shouldn't jump to top when loading multiple previews
  
* `get`: fix bug in generated docs
  
* `get`: remove unused parameter from dial timeout
  
* core: JSON profiles sometimes weren't getting closed properly ([PR #800](https://github.com/lmorg/murex/pull/800))
  
* readline: preview now reports if there is nothing to preview
  
* readline: out-of-bounds error fixed in preview
  
* readline: allow slimmer terminal widths in preview ([issue #805](https://github.com/lmorg/murex/issues/805))

* readline: override `MaxTabCompleterRows` on short terminals ([issue #804](https://github.com/lmorg/murex/issues/804))

* readline: incorrect clear line ANSI escape sequences

* core: multiline comments parsed incorrectly inside code blocks

* core: fixed out-of-range crash when handling specially named scalers

* autocomplete: incorrectly name scaler for `yarn` completion was causing it to fail
  
## Special Thanks

Thank yous for this release goes to everyone in the [discussions group](https://github.com/lmorg/murex/discussions) for raising bug reports and their design discussions.

Plus an extra special thank you to this releases contributors: [tiymat](https://github.com/lmorg/murex/pulls?q=author%3Atiymat), [testwill](https://github.com/lmorg/murex/pulls?q=author%3Atestwill) and [u9g](https://github.com/lmorg/murex/pulls?q=author%3Au9g), plus everyone who has helped peer review and test.

You rock!

<hr>

Published: 17.06.2024 at 22:54

## See Also

* [ANSI Constants](../user-guide/ansi.md):
  Infixed constants that return ANSI escape sequences
* [ChatGPT](../integrations/chatgpt.md):
  How to enable ChatGPT hints
* [Contributing](../Murex/CONTRIBUTING.md):
  Guide to contributing to Murex
* [Interactive Shell](../user-guide/interactive-shell.md):
  What's different about Murex's interactive shell?
* [Terminal Hotkeys](../user-guide/terminal-keys.md):
  A list of all the terminal hotkeys and their uses
* [`autocomplete`](../commands/autocomplete.md):
  Set definitions for tab-completion in the command line
* [`datetime`](../commands/datetime.md):
  A date and/or time conversion tool (like `printf` but for date and time values)
* [`debug`](../commands/debug.md):
  Debugging information
* [`event`](../commands/event.md):
  Event driven programming for shell scripts
* [`get`](../commands/get.md):
  Makes a standard HTTP request and returns the result as a JSON object
* [`key-code`](../commands/key-code.md):
  Returns character sequences for any key pressed (ie sent from the terminal)
* [`man-summary`](../commands/man-summary.md):
  Outputs a man page summary of a command
* [`onKeyPress`](../events/onkeypress.md):
  Custom definable key bindings and macros
* [`onPreview`](../events/onpreview.md):
  Full screen previews for files and command documentation
* [`onPrompt`](../events/onprompt.md):
  Events triggered by changes in state of the interactive shell
* [`openagent`](../commands/openagent.md):
  Creates a handler function for `open`
* [`post`](../commands/post.md):
  HTTP POST request with a JSON-parsable return
* [`runtime`](../commands/runtime.md):
  Returns runtime information on the internal state of Murex

<hr/>

This document was generated from [gen/changelog/v6.1_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/changelog/v6.1_doc.yaml).