package docs

// This file was autogenerated by `docgen`
// Do NOT manually edit it. Any changes will be overwritten

func init() {
	Summary = map[string]string{

		"not-func":              "Reads the stdin and exit number from previous process and not's it's condition",
		"2darray":               "Create a 2D JSON array from multiple input sources",
		"namedpipe":             "Reads from a Murex named pipe",
		"stdin":                 "Read the stdin belonging to the parent code block",
		"autoglob":              "Command prefix to expand globbing (deprecated)",
		"a":                     "A sophisticated yet simple way to build an array or list",
		"addheading":            "Adds headings to a table",
		"alias":                 "Create an alias for a command",
		"alter":                 "Change a value within a structured data-type and pass that change along the pipeline without altering the original source input",
		"and":                   "Returns `true` or `false` depending on whether multiple conditions are met",
		"append":                "Add data to the end of an array",
		"args":                  "Command line flag parser for Murex shell scripting",
		"autocomplete":          "Set definitions for tab-completion in the command line",
		"bexists":               "Check which builtins exist",
		"bg":                    "Run processes in the background",
		"break":                 "Terminate execution of a block within your processes scope",
		"cast":                  "Alters the data-type of the previous function without altering its output",
		"catch":                 "Handles the exception code raised by `try` or `trypipe`",
		"cd":                    "Change (working) directory",
		"config":                "Query or define Murex runtime settings",
		"continue":              "Terminate process of a block within a caller function",
		"count":                 "Count items in a map, list or array",
		"cpuarch":               "Output the hosts CPU architecture",
		"cpucount":              "Output the number of CPU cores available on your host",
		"datetime":              "A date and/or time conversion tool (like `printf` but for date and time values)",
		"debug":                 "Debugging information",
		"die":                   "Terminate murex with an exit number of 1",
		"err":                   "Print a line to the stderr",
		"escape":                "Escape or unescape input",
		"esccli":                "Escapes an array so output is valid shell code",
		"eschtml":               "Encode or decodes text for HTML",
		"escurl":                "Encode or decodes text for the URL",
		"event":                 "Event driven programming for shell scripts",
		"exec":                  "Runs an executable",
		"exit":                  "Exit murex",
		"exitnum":               "Output the exit number of the previous process",
		"export":                "Define an environmental variable and set it's value",
		"expr":                  "Expressions: mathematical, string comparisons, logical operators",
		"f":                     "Lists or filters file system objects (eg files)",
		"false":                 "Returns a `false` value",
		"fexec":                 "Execute a command or function, bypassing the usual order of precedence.",
		"fg":                    "Sends a background process into the foreground",
		"fid-kill":              "Terminate a running Murex function",
		"fid-killall":           "Terminate _all_ running Murex functions",
		"fid-list":              "Lists all running functions within the current Murex session",
		"for":                   "A more familiar iteration loop to existing developers",
		"foreach":               "Iterate through an array",
		"formap":                "Iterate through a map or other collection of data",
		"format":                "Reformat one data-type into another data-type",
		"function":              "Define a function block",
		"g":                     "Glob pattern matching for file system objects (eg `*.txt`)",
		"get-type":              "Returns the data-type of a variable or pipe",
		"get":                   "Makes a standard HTTP request and returns the result as a JSON object",
		"getfile":               "Makes a standard HTTP request and return the contents as Murex-aware data type for passing along Murex pipelines.",
		"global":                "Define a global variable and set it's value",
		"history":               "Outputs murex's command history",
		"if":                    "Conditional statement to execute different blocks of code depending on the result of the condition",
		"is-null":               "Checks if a variable is null or undefined",
		"ja":                    "A sophisticated yet simply way to build a JSON array",
		"jsplit":                "Splits stdin into a JSON array based on a regex parameter",
		"key-code":              "Returns character sequences for any key pressed (ie sent from the terminal)",
		"left":                  "Left substring every item in a list",
		"let":                   "Evaluate a mathematical function and assign to variable (deprecated)",
		"lockfile":              "Create and manage lock files",
		"man-get-flags":         "Parses man page files for command line flags",
		"man-summary":           "Outputs a man page summary of a command",
		"map":                   "Creates a map from two data sources",
		"match":                 "Match an exact value in an array",
		"method":                "Define a methods supported data-types",
		"msort":                 "Sorts an array - data type agnostic",
		"mtac":                  "Reverse the order of an array",
		"murex-docs":            "Displays the man pages for Murex builtins",
		"murex-package":         "Murex's package manager",
		"murex-parser":          "Runs the Murex parser against a block of code",
		"murex-update-exe-list": "Forces Murex to rescan $PATH looking for executables",
		"devnull":               "null function. Similar to /dev/null",
		"open-image":            "Renders bitmap image data on your terminal",
		"open":                  "Open a file with a preferred handler",
		"openagent":             "Creates a handler function for `open`",
		"or":                    "Returns `true` or `false` depending on whether one code-block out of multiple ones supplied is successful or unsuccessful.",
		"os":                    "Output the auto-detected OS name",
		"out":                   "Print a string to the stdout with a trailing new line character",
		"pipe":                  "Manage Murex named pipes",
		"post":                  "HTTP POST request with a JSON-parsable return",
		"prefix":                "Prefix a string to every item in a list",
		"prepend":               "Add data to the start of an array",
		"pretty":                "Prettifies JSON to make it human readable",
		"private":               "Define a private function block",
		"pt":                    "Pipe telemetry. Writes data-types and bytes written",
		"rand":                  "Random field generator",
		"read":                  "`read` a line of input from the user and store as a variable",
		"regexp":                "Regexp tools for arrays / lists of strings",
		"return":                "Exits current function scope",
		"right":                 "Right substring every item in a list",
		"round":                 "Round a number by a user defined precision",
		"runmode":               "Alter the scheduler's behaviour at higher scoping level",
		"runtime":               "Returns runtime information on the internal state of Murex",
		"rx":                    "Regexp pattern matching for file system objects (eg `.*\\\\.txt`)",
		"set":                   "Define a local variable and set it's value",
		"signal":                "Sends a signal RPC",
		"source":                "Import Murex code from another file of code block",
		"struct-keys":           "Outputs all the keys in a structure as a file path",
		"suffix":                "Prefix a string to every item in a list",
		"summary":               "Defines a summary help text for a command",
		"switch":                "Blocks of cascading conditionals",
		"ta":                    "A sophisticated yet simple way to build an array of a user defined data-type",
		"tabulate":              "Table transformation tools",
		"test":                  "Murex's test framework - define tests, run tests and debug shell scripts",
		"time":                  "Returns the execution run time of a command or block",
		"tmp":                   "Create a temporary file and write to it",
		"tout":                  "Print a string to the stdout and set it's data-type",
		"tread":                 "`read` a line of input from the user and store as a user defined *typed* variable (deprecated)",
		"true":                  "Returns a `true` value",
		"try":                   "Handles non-zero exits inside a block of code",
		"tryerr":                "Handles errors inside a block of code",
		"trypipe":               "Checks for non-zero exits of each function in a pipeline",
		"trypipeerr":            "Checks state of each function in a pipeline and exits block on error",
		"type":                  "Command type (function, builtin, alias, etc)",
		"unsafe":                "Execute a block of code, always returning a zero exit number",
		"version":               "Get Murex version",
		"which":                 "Locate command origin",
		"while":                 "Loop until condition false",

		"bz2":    "Decompress a bz2 file",
		"base64": "Encode or decode a base64 string",
		"gz":     "Compress or decompress a gzip file",
		"qr":     "Creates a QR code from stdin",
		"select": "Inlining SQL into shell pipelines",
		"sleep":  "Suspends the shell for a number of seconds",

		"commands/not-func":               "Reads the stdin and exit number from previous process and not's it's condition",
		"commands/2darray":                "Create a 2D JSON array from multiple input sources",
		"commands/namedpipe":              "Reads from a Murex named pipe",
		"commands/stdin":                  "Read the stdin belonging to the parent code block",
		"commands/autoglob":               "Command prefix to expand globbing (deprecated)",
		"commands/a":                      "A sophisticated yet simple way to build an array or list",
		"commands/addheading":             "Adds headings to a table",
		"commands/alias":                  "Create an alias for a command",
		"commands/alter":                  "Change a value within a structured data-type and pass that change along the pipeline without altering the original source input",
		"commands/and":                    "Returns `true` or `false` depending on whether multiple conditions are met",
		"commands/append":                 "Add data to the end of an array",
		"commands/args":                   "Command line flag parser for Murex shell scripting",
		"commands/autocomplete":           "Set definitions for tab-completion in the command line",
		"commands/bexists":                "Check which builtins exist",
		"commands/bg":                     "Run processes in the background",
		"commands/break":                  "Terminate execution of a block within your processes scope",
		"commands/cast":                   "Alters the data-type of the previous function without altering its output",
		"commands/catch":                  "Handles the exception code raised by `try` or `trypipe`",
		"commands/cd":                     "Change (working) directory",
		"commands/config":                 "Query or define Murex runtime settings",
		"commands/continue":               "Terminate process of a block within a caller function",
		"commands/count":                  "Count items in a map, list or array",
		"commands/cpuarch":                "Output the hosts CPU architecture",
		"commands/cpucount":               "Output the number of CPU cores available on your host",
		"commands/datetime":               "A date and/or time conversion tool (like `printf` but for date and time values)",
		"commands/debug":                  "Debugging information",
		"commands/die":                    "Terminate murex with an exit number of 1",
		"commands/err":                    "Print a line to the stderr",
		"commands/escape":                 "Escape or unescape input",
		"commands/esccli":                 "Escapes an array so output is valid shell code",
		"commands/eschtml":                "Encode or decodes text for HTML",
		"commands/escurl":                 "Encode or decodes text for the URL",
		"commands/event":                  "Event driven programming for shell scripts",
		"commands/exec":                   "Runs an executable",
		"commands/exit":                   "Exit murex",
		"commands/exitnum":                "Output the exit number of the previous process",
		"commands/export":                 "Define an environmental variable and set it's value",
		"commands/expr":                   "Expressions: mathematical, string comparisons, logical operators",
		"commands/f":                      "Lists or filters file system objects (eg files)",
		"commands/false":                  "Returns a `false` value",
		"commands/fexec":                  "Execute a command or function, bypassing the usual order of precedence.",
		"commands/fg":                     "Sends a background process into the foreground",
		"commands/fid-kill":               "Terminate a running Murex function",
		"commands/fid-killall":            "Terminate _all_ running Murex functions",
		"commands/fid-list":               "Lists all running functions within the current Murex session",
		"commands/for":                    "A more familiar iteration loop to existing developers",
		"commands/foreach":                "Iterate through an array",
		"commands/formap":                 "Iterate through a map or other collection of data",
		"commands/format":                 "Reformat one data-type into another data-type",
		"commands/function":               "Define a function block",
		"commands/g":                      "Glob pattern matching for file system objects (eg `*.txt`)",
		"commands/get-type":               "Returns the data-type of a variable or pipe",
		"commands/get":                    "Makes a standard HTTP request and returns the result as a JSON object",
		"commands/getfile":                "Makes a standard HTTP request and return the contents as Murex-aware data type for passing along Murex pipelines.",
		"commands/global":                 "Define a global variable and set it's value",
		"commands/history":                "Outputs murex's command history",
		"commands/if":                     "Conditional statement to execute different blocks of code depending on the result of the condition",
		"commands/is-null":                "Checks if a variable is null or undefined",
		"commands/ja":                     "A sophisticated yet simply way to build a JSON array",
		"commands/jsplit":                 "Splits stdin into a JSON array based on a regex parameter",
		"commands/key-code":               "Returns character sequences for any key pressed (ie sent from the terminal)",
		"commands/left":                   "Left substring every item in a list",
		"commands/let":                    "Evaluate a mathematical function and assign to variable (deprecated)",
		"commands/lockfile":               "Create and manage lock files",
		"commands/man-get-flags":          "Parses man page files for command line flags",
		"commands/man-summary":            "Outputs a man page summary of a command",
		"commands/map":                    "Creates a map from two data sources",
		"commands/match":                  "Match an exact value in an array",
		"commands/method":                 "Define a methods supported data-types",
		"commands/msort":                  "Sorts an array - data type agnostic",
		"commands/mtac":                   "Reverse the order of an array",
		"commands/murex-docs":             "Displays the man pages for Murex builtins",
		"commands/murex-package":          "Murex's package manager",
		"commands/murex-parser":           "Runs the Murex parser against a block of code",
		"commands/murex-update-exe-list":  "Forces Murex to rescan $PATH looking for executables",
		"commands/devnull":                "null function. Similar to /dev/null",
		"commands/open-image":             "Renders bitmap image data on your terminal",
		"commands/open":                   "Open a file with a preferred handler",
		"commands/openagent":              "Creates a handler function for `open`",
		"commands/or":                     "Returns `true` or `false` depending on whether one code-block out of multiple ones supplied is successful or unsuccessful.",
		"commands/os":                     "Output the auto-detected OS name",
		"commands/out":                    "Print a string to the stdout with a trailing new line character",
		"commands/pipe":                   "Manage Murex named pipes",
		"commands/post":                   "HTTP POST request with a JSON-parsable return",
		"commands/prefix":                 "Prefix a string to every item in a list",
		"commands/prepend":                "Add data to the start of an array",
		"commands/pretty":                 "Prettifies JSON to make it human readable",
		"commands/private":                "Define a private function block",
		"commands/pt":                     "Pipe telemetry. Writes data-types and bytes written",
		"commands/rand":                   "Random field generator",
		"commands/read":                   "`read` a line of input from the user and store as a variable",
		"commands/regexp":                 "Regexp tools for arrays / lists of strings",
		"commands/return":                 "Exits current function scope",
		"commands/right":                  "Right substring every item in a list",
		"commands/round":                  "Round a number by a user defined precision",
		"commands/runmode":                "Alter the scheduler's behaviour at higher scoping level",
		"commands/runtime":                "Returns runtime information on the internal state of Murex",
		"commands/rx":                     "Regexp pattern matching for file system objects (eg `.*\\\\.txt`)",
		"commands/set":                    "Define a local variable and set it's value",
		"commands/signal":                 "Sends a signal RPC",
		"commands/source":                 "Import Murex code from another file of code block",
		"commands/struct-keys":            "Outputs all the keys in a structure as a file path",
		"commands/suffix":                 "Prefix a string to every item in a list",
		"commands/summary":                "Defines a summary help text for a command",
		"commands/switch":                 "Blocks of cascading conditionals",
		"commands/ta":                     "A sophisticated yet simple way to build an array of a user defined data-type",
		"commands/tabulate":               "Table transformation tools",
		"commands/test":                   "Murex's test framework - define tests, run tests and debug shell scripts",
		"commands/time":                   "Returns the execution run time of a command or block",
		"commands/tmp":                    "Create a temporary file and write to it",
		"commands/tout":                   "Print a string to the stdout and set it's data-type",
		"commands/tread":                  "`read` a line of input from the user and store as a user defined *typed* variable (deprecated)",
		"commands/true":                   "Returns a `true` value",
		"commands/try":                    "Handles non-zero exits inside a block of code",
		"commands/tryerr":                 "Handles errors inside a block of code",
		"commands/trypipe":                "Checks for non-zero exits of each function in a pipeline",
		"commands/trypipeerr":             "Checks state of each function in a pipeline and exits block on error",
		"commands/type":                   "Command type (function, builtin, alias, etc)",
		"commands/unsafe":                 "Execute a block of code, always returning a zero exit number",
		"commands/version":                "Get Murex version",
		"commands/which":                  "Locate command origin",
		"commands/while":                  "Loop until condition false",
		"mkarray/date":                    "Create arrays of dates",
		"mkarray/character":               "Making character arrays (a to z)",
		"mkarray/decimal":                 "Create arrays of decimal integers",
		"mkarray/non-decimal":             "Create arrays of integers from non-decimal number bases",
		"mkarray/special":                 "Create arrays from ranges of dictionary terms (eg weekdays, months, seasons, etc)",
		"optional/bz2":                    "Decompress a bz2 file",
		"optional/base64":                 "Encode or decode a base64 string",
		"optional/gz":                     "Compress or decompress a gzip file",
		"optional/qr":                     "Creates a QR code from stdin",
		"optional/select":                 "Inlining SQL into shell pipelines",
		"optional/sleep":                  "Suspends the shell for a number of seconds",
		"parser/expr-inlined":             "Inline expressions",
		"parser/c-style-fun":              "Inlined commands for expressions and statements",
		"parser/double-quote":             "Initiates or terminates a string (variables expanded)",
		"parser/scalar":                   "Expand values as a scalar",
		"parser/brace-quote":              "Initiates or terminates a string (variables expanded)",
		"parser/create-array":             "Quickly generate arrays",
		"parser/create-object":            "Quickly generate objects (dictionaries / maps)",
		"parser/logical-and":              "Continues next operation if previous operation passes",
		"parser/single-quote":             "Initiates or terminates a string (variables not expanded)",
		"parser/brace-quote-func":         "Write a string to the stdout without new line (deprecated)",
		"parser/multiply-by":              "Multiplies a variable by the right hand value (expression)",
		"parser/multiplication":           "Multiplies one numeric value with another (expression)",
		"parser/add-with":                 "Adds the right hand value to a variable (expression)",
		"parser/addition":                 "Adds two numeric values together (expression)",
		"parser/subtract-by":              "Subtracts a variable by the right hand value (expression)",
		"parser/pipe-arrow":               "Pipes stdout from the left hand command to stdin of the right hand command",
		"parser/subtraction":              "Subtracts one numeric value from another (expression)",
		"parser/divide-by":                "Divides a variable by the right hand value (expression)",
		"parser/division":                 "Divides one numeric value from another (expression)",
		"parser/assign-or-merge":          "Merges the right hand value to a variable on the left hand side (expression)",
		"parser/pipe-generic":             "Pipes a reformatted stdout stream from the left hand command to stdin of the right hand command",
		"parser/equ":                      "Evaluate a mathematical function (deprecated)",
		"parser/file-append":              "Writes stdin to disk - appending contents if file already exists",
		"parser/elvis":                    "Returns the right operand if the left operand is falsy (expression)",
		"parser/null-coalescing":          "Returns the right operand if the left operand is empty / undefined (expression)",
		"parser/pipe-err":                 "Pipes stderr from the left hand command to stdin of the right hand command (DEPRECATED)",
		"parser/array":                    "Expand values as an array",
		"parser/range":                    "Outputs a ranged subset of data from stdin",
		"parser/item-index":               "Outputs an element from an array, map or table",
		"parser/element":                  "Outputs an element from a nested structure",
		"parser/lambda":                   "Iterate through structured data",
		"parser/curly-brace":              "Initiates or terminates a code block",
		"parser/file-truncate":            "Writes stdin to disk - overwriting contents if file already exists",
		"parser/pipe-posix":               "Pipes stdout from the left hand command to stdin of the right hand command",
		"parser/logical-or":               "Continues next operation only if previous operation fails",
		"parser/tilde":                    "Home directory path variable",
		"events/oncommandcompletion":      "Trigger an event upon a command's completion",
		"events/onfilesystemchange":       "Add a filesystem watch",
		"events/onkeypress":               "Custom definable key bindings and macros",
		"events/onpreview":                "Full screen previews for files and command documentation",
		"events/onprompt":                 "Events triggered by changes in state of the interactive shell",
		"events/onsecondselapsed":         "Events triggered by time intervals",
		"events/onsignalreceived":         "Trap OS signals",
		"types/generic":                   "generic (primitive)",
		"types/bool":                      "Boolean (primitive)",
		"types/commonlog":                 "Apache httpd \"common\" log format",
		"types/csv":                       "CSV files (and other character delimited tables)",
		"types/float":                     "Floating point number (primitive)",
		"types/hcl":                       "HashiCorp Configuration Language (HCL)",
		"types/int":                       "Whole number (primitive)",
		"types/json":                      "JavaScript Object Notation (JSON)",
		"types/jsonc":                     "Concatenated JSON",
		"types/jsonl":                     "JSON Lines",
		"types/num":                       "Floating point number (primitive)",
		"types/path":                      "Structured object for working with file and directory paths",
		"types/paths":                     "Structured array for working with `$PATH` style data",
		"types/str":                       "string (primitive)",
		"types/toml":                      "Tom's Obvious, Minimal Language (TOML)",
		"types/yaml":                      "YAML Ain't Markup Language (YAML)",
		"types/mxjson":                    "Murex-flavoured JSON (deprecated)",
		"variables/numeric":               "Variables who's name is a positive integer, eg `0`, `1`, `2`, `3` and above",
		"variables/meta-values":           "State information for iteration blocks",
		"variables/argv":                  "Array of the command name and parameters within a given scope",
		"variables/columns":               "Character width of terminal",
		"variables/event_return":          "Return values for events",
		"variables/hostname":              "Hostname of the current machine",
		"variables/murex_argv":            "Array of the command name and parameters passed to the current shell",
		"variables/murex_exe":             "Absolute path to running shell",
		"variables/params":                "Array of the parameters within a given scope",
		"variables/pwdhist":               "History of each change to the sessions working directory",
		"variables/pwd":                   "Current working directory",
		"variables/self":                  "Meta information about the running scope.",
		"variables/shell":                 "Path of current shell",
		"apis/Marshal":                    "Converts structured memory into a structured file format (eg for stdio)",
		"apis/ReadArray":                  "Read from a data type one array element at a time",
		"apis/ReadArrayWithType":          "Read from a data type one array element at a time and return the elements contents and data type",
		"apis/ReadIndex":                  "Data type handler for the index, `[`, builtin",
		"apis/ReadMap":                    "Treat data type as a key/value structure and read its contents",
		"apis/ReadNotIndex":               "Data type handler for the bang-prefixed index, `![`, builtin",
		"apis/Unmarshal":                  "Converts a structured file format into structured memory",
		"apis/WriteArray":                 "Write a data type, one array element at a time",
		"apis/lang.ArrayTemplate":         "Unmarshals a data type into a Go struct and returns the results as an array",
		"apis/lang.ArrayWithTypeTemplate": "Unmarshals a data type into a Go struct and returns the results as an array with data type included",
		"apis/lang.IndexTemplateObject":   "Returns element(s) from a data structure",
		"apis/lang.IndexTemplateTable":    "Returns element(s) from a table",
		"apis/lang.MarshalData":           "Converts structured memory into a Murex data-type (eg for stdio)",
		"apis/lang.UnmarshalData":         "Converts a Murex data-type into structured memory",
		"user-guide/ansi":                 "Infixed constants that return ANSI escape sequences",
		"user-guide/bang-prefix":          "Bang prefixing to reverse default actions",
		"user-guide/code-block":           "Overview of how code blocks are parsed",
		"user-guide/fileref":              "How to track what code was loaded and from where",
		"user-guide/hint-text":            "A status bar for your shell",
		"user-guide/integrations":         "Default integrations shipped with Murex",
		"user-guide/interactive-shell":    "What's different about Murex's interactive shell?",
		"user-guide/job-control":          "How to manage jobs with Murex",
		"user-guide/modules":              "An introduction to Murex modules and packages",
		"user-guide/namedpipes":           "A detailed breakdown of named pipes in Murex",
		"user-guide/operators-and-tokens": "A table of all supported operators and tokens",
		"user-guide/pipeline":             "Overview of what a \"pipeline\" is",
		"user-guide/profile":              "A breakdown of the different files loaded on start up",
		"user-guide/reserved-vars":        "Special variables reserved by Murex",
		"user-guide/rosetta-stone":        "A tabulated list of Bashism's and their equivalent Murex syntax",
		"user-guide/schedulers":           "Overview of the different schedulers (or 'run modes') in Murex",
		"user-guide/strict-types":         "Expressions can auto-convert types or strictly honour data types",
		"user-guide/terminal-keys":        "A list of all the terminal hotkeys and their uses",
		"user-guide/scoping":              "How scoping works within Murex",
		"integrations/chatgpt":            "How to enable ChatGPT hints",
		"integrations/cheatsh":            "Cheatsheets provided by cheat.sh",
		"integrations/kitty":              "Get more out of Kitty terminal emulator",
		"integrations/make":               "`make` integrations",
		"integrations/man-pages":          "Linux/UNIX `man` page integrations",
		"integrations/spellcheck":         "How to enable inline spellchecking",
		"integrations/terminology":        "Get more out of Terminology terminal emulator",
		"integrations/direnv":             "Directory specific environmental variables",
		"integrations/yarn":               "Working with `yarn` and `package.json`",
		"integrations/iterm2":             "Get more out of iTerm2 terminal emulator",
		"changelog/v2.0":                  "This release comes with spellchecking, inlined images, smarter syntax completion and more",
		"changelog/v2.1":                  "This release comes with support for inlining SQL and some major bug fixes plus a breaking change for `config`. Please read for details.",
		"changelog/v2.10":                 "This release brings a few minor improvements and bug fixes rather than big new headline features.",
		"changelog/v2.11":                 "This release mainly focuses on refinements in performance and usability, rather than introducing new features",
		"changelog/v2.2":                  "This is mainly a bug fix release but it does include one breaking change for `config`. Please read for details.",
		"changelog/v2.3":                  "This release includes significant changes to the interactive terminal",
		"changelog/v2.4":                  "This release introduces a strict mode for variables, new builtin, performance improvements, and better error messages; plus a potential breaking change",
		"changelog/v2.5":                  "This release introduces a number of new builtins, fixes some regression bugs and supercharges the `select` optional builtin (which I plan to include into the core builtins for non-Windows users in the next release).",
		"changelog/v2.6":                  "This update has introduced a potential breaking change: variables now need to be defined before usage otherwise the commandline will fail. Read notes to learn how to disable this feature where needed. Also included in this release is the `select` command as part of the standard build.",
		"changelog/v2.7":                  "This update has introduced another potential breaking change for your safety: zero length arrays now fail by default. Also errors inside subshells will cause the parent command to fail if ran inside a `try` or `trypipe` block.",
		"changelog/v2.8":                  "This release comes with a number of experimental but stable features that might eventually become standard practice. The features are there to use if you with but adjacent from the older code so there is zero risk in updating to this version.",
		"changelog/v2.9":                  "This release focuses on testing and REPL usability improvements but also includes updates several new run modes to make error handling easier in larger scripts.",
		"changelog/v3.0":                  "This is a major release that brings a significant number of changes and improvements, including a complete overhaul of the parser. Backwards compatibility is a high priority however these new features bring greater readability and consistency to shell scripting. So while the older syntax remains for compatibility, it is worth migrating over to the newer syntax for all new code being written",
		"changelog/v3.1":                  "This release includes mostly bug fixes and new experimental features which are opt into. To enable all experimental features, set the environmental variable `MUREX_EXPERIMENTAL` to any value. Or you can enable specific features individually via `config`",
		"changelog/v4.0":                  "This release sees significant improvements for use with non-latin characters in both the interactive prompt and shell scripting. It introduces new syntax to make working with structured data even easier than before. As well as new data types and smoother user experience.",
		"changelog/v4.1":                  "The previous releases have brought significant advancements to Murex's syntax but at the cost of longer gaps between releases. So the 4.1.x versions will be shorter releases but focusing on bug fixes. The 4.1.x release notes will be appended to [murex.rocks changelog](https://murex.rocks/docs/changelog/v4.1.html) and available on [Github releases](https://github.com/lmorg/murex/releases) too",
		"changelog/v4.2":                  "Murex usage has raised considerably in recent weeks. This release addresses a number of feature requests and bugs raised on Github.",
		"changelog/v4.3":                  "This brings improved support on Windows plus one breaking change from the previous release (v4.2)",
		"changelog/v4.4":                  "v4.4 features two new builtins, improvements in testing, and automatic generation of autocompletion suggestions backed by man page parsing. Plus there has been a lot of focus on improving _readline_ responsiveness",
		"changelog/v5.0":                  "v5.0 is a massive release. It brings along changes to syntax, new operators as well as new builtins, reserved variables and a new event",
		"changelog/v5.1":                  "This release brings new operators and a builtin, all for managing null types. There is also a substantial revamp to readline's responsiveness.",
		"changelog/v5.2":                  "The v5.2 release introduces significant new features and improvements for those using Murex as their interactive shell. Many of these features are unique to Murex.",
		"changelog/v5.3":                  "Caching has been vastly improved in this release due to a new sqlite3-backed persistent `cache.db`. There have also been some improvements to `[f1]` help pages",
		"changelog/v6.0":                  "Despite this being a new major version release, it is a vary minor update. Aside from a handful of bugfixes, the most significant change is notice of deprecation for `=`, `let`, and `?`.",
		"changelog/v6.1":                  "This release sees a massive jump in event-driven capabilities as well as several new features and bug fixes.",
		"changelog/v6.2":                  "Bug fix release",
	}

	Synonym = map[string]string{

		"!":                     "not-func",
		"not":                   "not-func",
		"2darray":               "2darray",
		"(murex named pipe)":    "namedpipe",
		"<>":                    "namedpipe",
		"read-named-pipe":       "namedpipe",
		"<stdin>":               "stdin",
		"autoglob":              "autoglob",
		"a":                     "a",
		"addheading":            "addheading",
		"alias":                 "alias",
		"!alias":                "alias",
		"alter":                 "alter",
		"and":                   "and",
		"!and":                  "and",
		"append":                "append",
		"list.append":           "append",
		"args":                  "args",
		"autocomplete":          "autocomplete",
		"bexists":               "bexists",
		"bg":                    "bg",
		"break":                 "break",
		"cast":                  "cast",
		"catch":                 "catch",
		"!catch":                "catch",
		"cd":                    "cd",
		"config":                "config",
		"!config":               "config",
		"continue":              "continue",
		"count":                 "count",
		"len":                   "count",
		"cpuarch":               "cpuarch",
		"cpucount":              "cpucount",
		"datetime":              "datetime",
		"debug":                 "debug",
		"die":                   "die",
		"err":                   "err",
		"escape":                "escape",
		"!escape":               "escape",
		"esccli":                "esccli",
		"eschtml":               "eschtml",
		"!eschtml":              "eschtml",
		"escurl":                "escurl",
		"!escurl":               "escurl",
		"event":                 "event",
		"!event":                "event",
		"exec":                  "exec",
		"command":               "exec",
		"exit":                  "exit",
		"exitnum":               "exitnum",
		"export":                "export",
		"!export":               "export",
		"unset":                 "export",
		"expr":                  "expr",
		"f":                     "f",
		"false":                 "false",
		"fexec":                 "fexec",
		"builtin":               "fexec",
		"fg":                    "fg",
		"fid-kill":              "fid-kill",
		"fid-killall":           "fid-killall",
		"fid-list":              "fid-list",
		"jobs":                  "fid-list",
		"for":                   "for",
		"foreach":               "foreach",
		"formap":                "formap",
		"format":                "format",
		"function":              "function",
		"!function":             "function",
		"g":                     "g",
		"!g":                    "g",
		"get-type":              "get-type",
		"get":                   "get",
		"getfile":               "getfile",
		"global":                "global",
		"!global":               "global",
		"history":               "history",
		"if":                    "if",
		"!if":                   "if",
		"is-null":               "is-null",
		"ja":                    "ja",
		"jsplit":                "jsplit",
		"list.split":            "jsplit",
		"key-code":              "key-code",
		"left":                  "left",
		"list.left":             "left",
		"let":                   "let",
		"lockfile":              "lockfile",
		"man-get-flags":         "man-get-flags",
		"man-summary":           "man-summary",
		"map":                   "map",
		"match":                 "match",
		"!match":                "match",
		"list.string":           "match",
		"method":                "method",
		"msort":                 "msort",
		"list.sort":             "msort",
		"mtac":                  "mtac",
		"list.reverse":          "mtac",
		"murex-docs":            "murex-docs",
		"help":                  "murex-docs",
		"murex-package":         "murex-package",
		"murex-parser":          "murex-parser",
		"murex-update-exe-list": "murex-update-exe-list",
		"null":                  "devnull",
		"open-image":            "open-image",
		"open":                  "open",
		"openagent":             "openagent",
		"!openagent":            "openagent",
		"or":                    "or",
		"!or":                   "or",
		"os":                    "os",
		"out":                   "out",
		"echo":                  "out",
		"pipe":                  "pipe",
		"!pipe":                 "pipe",
		"post":                  "post",
		"prefix":                "prefix",
		"list.prefix":           "prefix",
		"prepend":               "prepend",
		"list.prepend":          "prepend",
		"pretty":                "pretty",
		"private":               "private",
		"pt":                    "pt",
		"rand":                  "rand",
		"read":                  "read",
		"regexp":                "regexp",
		"!regexp":               "regexp",
		"list.regex":            "regexp",
		"return":                "return",
		"right":                 "right",
		"list.right":            "right",
		"round":                 "round",
		"runmode":               "runmode",
		"runtime":               "runtime",
		"builtins":              "runtime",
		"rx":                    "rx",
		"!rx":                   "rx",
		"set":                   "set",
		"!set":                  "set",
		"signal":                "signal",
		"source":                "source",
		".":                     "source",
		"struct-keys":           "struct-keys",
		"suffix":                "suffix",
		"list.suffix":           "suffix",
		"summary":               "summary",
		"!summary":              "summary",
		"switch":                "switch",
		"ta":                    "ta",
		"tabulate":              "tabulate",
		"test":                  "test",
		"!test":                 "test",
		"time":                  "time",
		"tmp":                   "tmp",
		"tout":                  "tout",
		"tread":                 "tread",
		"true":                  "true",
		"try":                   "try",
		"tryerr":                "tryerr",
		"trypipe":               "trypipe",
		"trypipeerr":            "trypipeerr",
		"type":                  "type",
		"unsafe":                "unsafe",
		"version":               "version",
		"which":                 "which",
		"while":                 "while",
		"!while":                "while",

		"!bz2":    "optional/bz2",
		"base64":  "optional/base64",
		"!base64": "optional/base64",
		"gz":      "optional/gz",
		"!gz":     "optional/gz",
		"qr":      "optional/qr",
		"select":  "optional/select",
		"sleep":   "optional/sleep",

		"expr-inlined":    "parser/expr-inlined",
		"c-style-fun":     "parser/c-style-fun",
		"double-quote":    "parser/double-quote",
		"scalar":          "parser/scalar",
		"brace-quote":     "parser/brace-quote",
		"create-array":    "parser/create-array",
		"create-object":   "parser/create-object",
		"logical-and":     "parser/logical-and",
		"single-quote":    "parser/single-quote",
		"(":               "parser/brace-quote-func",
		"multiply-by":     "parser/multiply-by",
		"multiplication":  "parser/multiplication",
		"add-with":        "parser/add-with",
		"addition":        "parser/addition",
		"subtract-by":     "parser/subtract-by",
		"pipe-arrow":      "parser/pipe-arrow",
		"subtraction":     "parser/subtraction",
		"divide-by":       "parser/divide-by",
		"division":        "parser/division",
		"assign-or-merge": "parser/assign-or-merge",
		"pipe-generic":    "parser/pipe-generic",
		"=":               "parser/equ",
		">>":              "parser/file-append",
		"fappend":         "parser/file-append",
		"elvis":           "parser/elvis",
		"null-coalescing": "parser/null-coalescing",
		"pipe-err":        "parser/pipe-err",
		"array":           "parser/array",
		"@[":              "parser/range",
		"[":               "parser/item-index",
		"![":              "parser/item-index",
		"item-index":      "parser/item-index",
		"index":           "parser/item-index",
		"[[":              "parser/element",
		"element":         "parser/element",
		"lambda":          "parser/lambda",
		"curly-brace":     "parser/curly-brace",
		"|>":              "parser/file-truncate",
		">":               "parser/file-truncate",
		"fwrite":          "parser/file-truncate",
		"pipe-posix":      "parser/pipe-posix",
		"logical-or":      "parser/logical-or",
		"tilde":           "parser/tilde",

		"commands/!":                      "commands/not-func",
		"commands/not":                    "commands/not-func",
		"commands/2darray":                "commands/2darray",
		"commands/(murex named pipe)":     "commands/namedpipe",
		"commands/<>":                     "commands/namedpipe",
		"commands/read-named-pipe":        "commands/namedpipe",
		"commands/<stdin>":                "commands/stdin",
		"commands/autoglob":               "commands/autoglob",
		"commands/a":                      "commands/a",
		"commands/addheading":             "commands/addheading",
		"commands/alias":                  "commands/alias",
		"commands/!alias":                 "commands/alias",
		"commands/alter":                  "commands/alter",
		"commands/and":                    "commands/and",
		"commands/!and":                   "commands/and",
		"commands/append":                 "commands/append",
		"commands/list.append":            "commands/append",
		"commands/args":                   "commands/args",
		"commands/autocomplete":           "commands/autocomplete",
		"commands/bexists":                "commands/bexists",
		"commands/bg":                     "commands/bg",
		"commands/break":                  "commands/break",
		"commands/cast":                   "commands/cast",
		"commands/catch":                  "commands/catch",
		"commands/!catch":                 "commands/catch",
		"commands/cd":                     "commands/cd",
		"commands/config":                 "commands/config",
		"commands/!config":                "commands/config",
		"commands/continue":               "commands/continue",
		"commands/count":                  "commands/count",
		"commands/len":                    "commands/count",
		"commands/cpuarch":                "commands/cpuarch",
		"commands/cpucount":               "commands/cpucount",
		"commands/datetime":               "commands/datetime",
		"commands/debug":                  "commands/debug",
		"commands/die":                    "commands/die",
		"commands/err":                    "commands/err",
		"commands/escape":                 "commands/escape",
		"commands/!escape":                "commands/escape",
		"commands/esccli":                 "commands/esccli",
		"commands/eschtml":                "commands/eschtml",
		"commands/!eschtml":               "commands/eschtml",
		"commands/escurl":                 "commands/escurl",
		"commands/!escurl":                "commands/escurl",
		"commands/event":                  "commands/event",
		"commands/!event":                 "commands/event",
		"commands/exec":                   "commands/exec",
		"commands/command":                "commands/exec",
		"commands/exit":                   "commands/exit",
		"commands/exitnum":                "commands/exitnum",
		"commands/export":                 "commands/export",
		"commands/!export":                "commands/export",
		"commands/unset":                  "commands/export",
		"commands/expr":                   "commands/expr",
		"commands/f":                      "commands/f",
		"commands/false":                  "commands/false",
		"commands/fexec":                  "commands/fexec",
		"commands/builtin":                "commands/fexec",
		"commands/fg":                     "commands/fg",
		"commands/fid-kill":               "commands/fid-kill",
		"commands/fid-killall":            "commands/fid-killall",
		"commands/fid-list":               "commands/fid-list",
		"commands/jobs":                   "commands/fid-list",
		"commands/for":                    "commands/for",
		"commands/foreach":                "commands/foreach",
		"commands/formap":                 "commands/formap",
		"commands/format":                 "commands/format",
		"commands/function":               "commands/function",
		"commands/!function":              "commands/function",
		"commands/g":                      "commands/g",
		"commands/!g":                     "commands/g",
		"commands/get-type":               "commands/get-type",
		"commands/get":                    "commands/get",
		"commands/getfile":                "commands/getfile",
		"commands/global":                 "commands/global",
		"commands/!global":                "commands/global",
		"commands/history":                "commands/history",
		"commands/if":                     "commands/if",
		"commands/!if":                    "commands/if",
		"commands/is-null":                "commands/is-null",
		"commands/ja":                     "commands/ja",
		"commands/jsplit":                 "commands/jsplit",
		"commands/list.split":             "commands/jsplit",
		"commands/key-code":               "commands/key-code",
		"commands/left":                   "commands/left",
		"commands/list.left":              "commands/left",
		"commands/let":                    "commands/let",
		"commands/lockfile":               "commands/lockfile",
		"commands/man-get-flags":          "commands/man-get-flags",
		"commands/man-summary":            "commands/man-summary",
		"commands/map":                    "commands/map",
		"commands/match":                  "commands/match",
		"commands/!match":                 "commands/match",
		"commands/list.string":            "commands/match",
		"commands/method":                 "commands/method",
		"commands/msort":                  "commands/msort",
		"commands/list.sort":              "commands/msort",
		"commands/mtac":                   "commands/mtac",
		"commands/list.reverse":           "commands/mtac",
		"commands/murex-docs":             "commands/murex-docs",
		"commands/help":                   "commands/murex-docs",
		"commands/murex-package":          "commands/murex-package",
		"commands/murex-parser":           "commands/murex-parser",
		"commands/murex-update-exe-list":  "commands/murex-update-exe-list",
		"commands/null":                   "commands/devnull",
		"commands/open-image":             "commands/open-image",
		"commands/open":                   "commands/open",
		"commands/openagent":              "commands/openagent",
		"commands/!openagent":             "commands/openagent",
		"commands/or":                     "commands/or",
		"commands/!or":                    "commands/or",
		"commands/os":                     "commands/os",
		"commands/out":                    "commands/out",
		"commands/echo":                   "commands/out",
		"commands/pipe":                   "commands/pipe",
		"commands/!pipe":                  "commands/pipe",
		"commands/post":                   "commands/post",
		"commands/prefix":                 "commands/prefix",
		"commands/list.prefix":            "commands/prefix",
		"commands/prepend":                "commands/prepend",
		"commands/list.prepend":           "commands/prepend",
		"commands/pretty":                 "commands/pretty",
		"commands/private":                "commands/private",
		"commands/pt":                     "commands/pt",
		"commands/rand":                   "commands/rand",
		"commands/read":                   "commands/read",
		"commands/regexp":                 "commands/regexp",
		"commands/!regexp":                "commands/regexp",
		"commands/list.regex":             "commands/regexp",
		"commands/return":                 "commands/return",
		"commands/right":                  "commands/right",
		"commands/list.right":             "commands/right",
		"commands/round":                  "commands/round",
		"commands/runmode":                "commands/runmode",
		"commands/runtime":                "commands/runtime",
		"commands/builtins":               "commands/runtime",
		"commands/rx":                     "commands/rx",
		"commands/!rx":                    "commands/rx",
		"commands/set":                    "commands/set",
		"commands/!set":                   "commands/set",
		"commands/signal":                 "commands/signal",
		"commands/source":                 "commands/source",
		"commands/.":                      "commands/source",
		"commands/struct-keys":            "commands/struct-keys",
		"commands/suffix":                 "commands/suffix",
		"commands/list.suffix":            "commands/suffix",
		"commands/summary":                "commands/summary",
		"commands/!summary":               "commands/summary",
		"commands/switch":                 "commands/switch",
		"commands/ta":                     "commands/ta",
		"commands/tabulate":               "commands/tabulate",
		"commands/test":                   "commands/test",
		"commands/!test":                  "commands/test",
		"commands/time":                   "commands/time",
		"commands/tmp":                    "commands/tmp",
		"commands/tout":                   "commands/tout",
		"commands/tread":                  "commands/tread",
		"commands/true":                   "commands/true",
		"commands/try":                    "commands/try",
		"commands/tryerr":                 "commands/tryerr",
		"commands/trypipe":                "commands/trypipe",
		"commands/trypipeerr":             "commands/trypipeerr",
		"commands/type":                   "commands/type",
		"commands/unsafe":                 "commands/unsafe",
		"commands/version":                "commands/version",
		"commands/which":                  "commands/which",
		"commands/while":                  "commands/while",
		"commands/!while":                 "commands/while",
		"mkarray/date":                    "mkarray/date",
		"mkarray/character":               "mkarray/character",
		"mkarray/decimal":                 "mkarray/decimal",
		"mkarray/non-decimal":             "mkarray/non-decimal",
		"mkarray/special":                 "mkarray/special",
		"optional/!bz2":                   "optional/bz2",
		"optional/base64":                 "optional/base64",
		"optional/!base64":                "optional/base64",
		"optional/gz":                     "optional/gz",
		"optional/!gz":                    "optional/gz",
		"optional/qr":                     "optional/qr",
		"optional/select":                 "optional/select",
		"optional/sleep":                  "optional/sleep",
		"parser/expr-inlined":             "parser/expr-inlined",
		"parser/c-style-fun":              "parser/c-style-fun",
		"parser/double-quote":             "parser/double-quote",
		"parser/scalar":                   "parser/scalar",
		"parser/brace-quote":              "parser/brace-quote",
		"parser/create-array":             "parser/create-array",
		"parser/create-object":            "parser/create-object",
		"parser/logical-and":              "parser/logical-and",
		"parser/single-quote":             "parser/single-quote",
		"parser/(":                        "parser/brace-quote-func",
		"parser/multiply-by":              "parser/multiply-by",
		"parser/multiplication":           "parser/multiplication",
		"parser/add-with":                 "parser/add-with",
		"parser/addition":                 "parser/addition",
		"parser/subtract-by":              "parser/subtract-by",
		"parser/pipe-arrow":               "parser/pipe-arrow",
		"parser/subtraction":              "parser/subtraction",
		"parser/divide-by":                "parser/divide-by",
		"parser/division":                 "parser/division",
		"parser/assign-or-merge":          "parser/assign-or-merge",
		"parser/pipe-generic":             "parser/pipe-generic",
		"parser/=":                        "parser/equ",
		"parser/>>":                       "parser/file-append",
		"parser/fappend":                  "parser/file-append",
		"parser/elvis":                    "parser/elvis",
		"parser/null-coalescing":          "parser/null-coalescing",
		"parser/pipe-err":                 "parser/pipe-err",
		"parser/array":                    "parser/array",
		"parser/@[":                       "parser/range",
		"parser/[":                        "parser/item-index",
		"parser/![":                       "parser/item-index",
		"parser/item-index":               "parser/item-index",
		"parser/index":                    "parser/item-index",
		"parser/[[":                       "parser/element",
		"parser/element":                  "parser/element",
		"parser/lambda":                   "parser/lambda",
		"parser/curly-brace":              "parser/curly-brace",
		"parser/|>":                       "parser/file-truncate",
		"parser/>":                        "parser/file-truncate",
		"parser/fwrite":                   "parser/file-truncate",
		"parser/pipe-posix":               "parser/pipe-posix",
		"parser/logical-or":               "parser/logical-or",
		"parser/tilde":                    "parser/tilde",
		"events/oncommandcompletion":      "events/oncommandcompletion",
		"events/onCommandCompletion":      "events/oncommandcompletion",
		"events/onfilesystemchange":       "events/onfilesystemchange",
		"events/onFileSystemChange":       "events/onfilesystemchange",
		"events/onkeypress":               "events/onkeypress",
		"events/onKeyPress":               "events/onkeypress",
		"events/onpreview":                "events/onpreview",
		"events/onPreview":                "events/onpreview",
		"events/onprompt":                 "events/onprompt",
		"events/onPrompt":                 "events/onprompt",
		"events/onsecondselapsed":         "events/onsecondselapsed",
		"events/onSecondsElapsed":         "events/onsecondselapsed",
		"events/onsignalreceived":         "events/onsignalreceived",
		"events/onSignalReceived":         "events/onsignalreceived",
		"types/generic":                   "types/generic",
		"types/*":                         "types/generic",
		"types/bool":                      "types/bool",
		"types/commonlog":                 "types/commonlog",
		"types/csv":                       "types/csv",
		"types/float":                     "types/float",
		"types/hcl":                       "types/hcl",
		"types/int":                       "types/int",
		"types/json":                      "types/json",
		"types/jsonc":                     "types/jsonc",
		"types/jsonl":                     "types/jsonl",
		"types/num":                       "types/num",
		"types/path":                      "types/path",
		"types/paths":                     "types/paths",
		"types/str":                       "types/str",
		"types/string":                    "types/str",
		"types/toml":                      "types/toml",
		"types/yaml":                      "types/yaml",
		"types/mxjson":                    "types/mxjson",
		"variables/numeric":               "variables/numeric",
		"variables/meta-values":           "variables/meta-values",
		"variables/$.":                    "variables/meta-values",
		"variables/argv":                  "variables/argv",
		"variables/ARGV":                  "variables/argv",
		"variables/ARGS":                  "variables/argv",
		"variables/columns":               "variables/columns",
		"variables/COLUMNS":               "variables/columns",
		"variables/event_return":          "variables/event_return",
		"variables/EVENT_RETURN":          "variables/event_return",
		"variables/hostname":              "variables/hostname",
		"variables/HOSTNAME":              "variables/hostname",
		"variables/murex_argv":            "variables/murex_argv",
		"variables/MUREX_ARGV":            "variables/murex_argv",
		"variables/MUREX_ARGS":            "variables/murex_argv",
		"variables/murex_exe":             "variables/murex_exe",
		"variables/MUREX_EXE":             "variables/murex_exe",
		"variables/params":                "variables/params",
		"variables/PARAMS":                "variables/params",
		"variables/pwdhist":               "variables/pwdhist",
		"variables/PWDHIST":               "variables/pwdhist",
		"variables/pwd":                   "variables/pwd",
		"variables/PWD":                   "variables/pwd",
		"variables/self":                  "variables/self",
		"variables/SELF":                  "variables/self",
		"variables/shell":                 "variables/shell",
		"variables/SHELL":                 "variables/shell",
		"apis/Marshal":                    "apis/Marshal",
		"apis/ReadArray":                  "apis/ReadArray",
		"apis/ReadArrayWithType":          "apis/ReadArrayWithType",
		"apis/ReadIndex":                  "apis/ReadIndex",
		"apis/ReadMap":                    "apis/ReadMap",
		"apis/ReadNotIndex":               "apis/ReadNotIndex",
		"apis/Unmarshal":                  "apis/Unmarshal",
		"apis/WriteArray":                 "apis/WriteArray",
		"apis/lang.ArrayTemplate":         "apis/lang.ArrayTemplate",
		"apis/lang.ArrayWithTypeTemplate": "apis/lang.ArrayWithTypeTemplate",
		"apis/lang.IndexTemplateObject":   "apis/lang.IndexTemplateObject",
		"apis/lang.IndexTemplateTable":    "apis/lang.IndexTemplateTable",
		"apis/lang.MarshalData":           "apis/lang.MarshalData",
		"apis/lang.UnmarshalData":         "apis/lang.UnmarshalData",
		"user-guide/ansi":                 "user-guide/ansi",
		"user-guide/bang-prefix":          "user-guide/bang-prefix",
		"user-guide/bang":                 "user-guide/bang-prefix",
		"user-guide/code-block":           "user-guide/code-block",
		"user-guide/fileref":              "user-guide/fileref",
		"user-guide/FileRef":              "user-guide/fileref",
		"user-guide/hint-text":            "user-guide/hint-text",
		"user-guide/integrations":         "user-guide/integrations",
		"user-guide/interactive-shell":    "user-guide/interactive-shell",
		"user-guide/repl":                 "user-guide/interactive-shell",
		"user-guide/readline":             "user-guide/interactive-shell",
		"user-guide/job-control":          "user-guide/job-control",
		"user-guide/module":               "user-guide/modules",
		"user-guide/modules":              "user-guide/modules",
		"user-guide/package":              "user-guide/modules",
		"user-guide/packages":             "user-guide/modules",
		"user-guide/namedpipes":           "user-guide/namedpipes",
		"user-guide/operators-and-tokens": "user-guide/operators-and-tokens",
		"user-guide/pipeline":             "user-guide/pipeline",
		"user-guide/profile":              "user-guide/profile",
		"user-guide/.murex_profile":       "user-guide/profile",
		"user-guide/murex_profile":        "user-guide/profile",
		"user-guide/.murex_preload":       "user-guide/profile",
		"user-guide/murex_preload":        "user-guide/profile",
		"user-guide/reserved-vars":        "user-guide/reserved-vars",
		"user-guide/reserved":             "user-guide/reserved-vars",
		"user-guide/reserved-variables":   "user-guide/reserved-vars",
		"user-guide/special-vars":         "user-guide/reserved-vars",
		"user-guide/special-variables":    "user-guide/reserved-vars",
		"user-guide/rosetta-stone":        "user-guide/rosetta-stone",
		"user-guide/schedulers":           "user-guide/schedulers",
		"user-guide/strict-types":         "user-guide/strict-types",
		"user-guide/hotkeys":              "user-guide/terminal-keys",
		"user-guide/scoping":              "user-guide/scoping",
		"integrations/chatgpt":            "integrations/chatgpt",
		"integrations/ChatGPT":            "integrations/chatgpt",
		"integrations/cheatsh":            "integrations/cheatsh",
		"integrations/cheat.sh":           "integrations/cheatsh",
		"integrations/kitty":              "integrations/kitty",
		"integrations/make":               "integrations/make",
		"integrations/Makefile":           "integrations/make",
		"integrations/man-pages":          "integrations/man-pages",
		"integrations/spellcheck":         "integrations/spellcheck",
		"integrations/terminology":        "integrations/terminology",
		"integrations/direnv":             "integrations/direnv",
		"integrations/yarn":               "integrations/yarn",
		"integrations/package.json":       "integrations/yarn",
		"integrations/iterm2":             "integrations/iterm2",
		"changelog/v2.0":                  "changelog/v2.0",
		"changelog/v2.1":                  "changelog/v2.1",
		"changelog/v2.10":                 "changelog/v2.10",
		"changelog/v2.11":                 "changelog/v2.11",
		"changelog/v2.2":                  "changelog/v2.2",
		"changelog/v2.3":                  "changelog/v2.3",
		"changelog/v2.4":                  "changelog/v2.4",
		"changelog/v2.5":                  "changelog/v2.5",
		"changelog/v2.6":                  "changelog/v2.6",
		"changelog/v2.7":                  "changelog/v2.7",
		"changelog/v2.8":                  "changelog/v2.8",
		"changelog/v2.9":                  "changelog/v2.9",
		"changelog/v3.0":                  "changelog/v3.0",
		"changelog/v3.1":                  "changelog/v3.1",
		"changelog/v4.0":                  "changelog/v4.0",
		"changelog/v4.1":                  "changelog/v4.1",
		"changelog/v4.2":                  "changelog/v4.2",
		"changelog/v4.3":                  "changelog/v4.3",
		"changelog/v4.4":                  "changelog/v4.4",
		"changelog/v5.0":                  "changelog/v5.0",
		"changelog/v5.1":                  "changelog/v5.1",
		"changelog/v5.2":                  "changelog/v5.2",
		"changelog/v5.3":                  "changelog/v5.3",
		"changelog/v6.0":                  "changelog/v6.0",
		"changelog/v6.1":                  "changelog/v6.1",
		"changelog/v6.2":                  "changelog/v6.2",
	}
}
