## Breaking Changes

None

## Deprecation Warnings

Please read out {{link "compatibility commitment" "compatibility"}} to understand how features are deprecated.

* the `?` pipe is deprecated to make way for a the ternary operator. You can achieve the same result with `<err> <!out>`, eg `command <err> <!out> parameters... | next-command ...`. It will be officially removed in v7.0
  
* the `=` and `let` builtins are deprecated and will be removed in v7.0. They've been marked as deprecated in the documentation for several versions but you'll now receive a deprecation warning when using them. This warning will not impact any functions that call them (they bypass the STDOUT and STDERR pipes and write directly to your TTY). The change is very simple, Murex supported expressions as first class primitives, so you can simply drop the `=` and `let` command names from your expressions

* automatic conversion of backtick `` ` `` to single quote `'` has been deprecated and will be removed in v7.0. The only reason this ever existed was a hack to enable quotes in `=`. Worse still, this behaviour wasn't documented anywhere

## Features

Features marked as **EXPERIMENTAL** are provided without assurances of future breaking changes. All other features are considered stable as part of Murex's {{link "compatibility commitment" "compatibility"}}.

* preview: progress bar to show how far through the preview document

* docs: more improvements to documentation

## Bug Fixes

* caching: suppress cache.db connect message when in debug mode ([issue #825](https://github.com/lmorg/murex/issues/825))

* `murex-package`: package errors should be ignored in `murex-package list` ([issue #826](https://github.com/lmorg/murex/issues/826) {{link "docs" "murex-package"}})

* `export`: exporting a non-existing variable would cause a crash ([issue #824](https://github.com/lmorg/murex/issues/824))

* `murex-docs`: integrations docs were missing from compiled executable ({{link "read more" "murex-docs"}})

* integrations: ChatGPT preview instructions were incorrect ({{link "read more" "chatgpt"}})

* core: crash handler was always disabled due to incorrectly flipping a boolean

* `expr`: re-write of `==` and `!=` operators to fix comparison bugs ([issue #831](https://github.com/lmorg/murex/issues/831) {{link "docs" "expr"}})

* `expr`: when run as a statement, only the first parameter was used ([issue #827](https://github.com/lmorg/murex/issues/827) {{link "docs" "expr"}})

* `expr`: panic when converting arrays and objects to a numeric scala ([issue #829](https://github.com/lmorg/murex/issues/829) {{link "docs" "expr"}})

* `expr`: `:` was treated as `<` in expressions ([issue #832](https://github.com/lmorg/murex/issues/832) {{link "docs" "expr"}})

* `expr`: empty arrays return `null` ({{link "docs" "expr"}}))

* core: `go test` compilation errors on Windows fixed

* readline: in preview, backspace characters where not pushing character positions (this bug only appeared in previewing UNIX man pages)

* readline: final character in preview checked to see if it is a wide character

* readline: tab widths in preview off by one

## Special Thanks

Thank yous for this release goes to everyone in the [discussions group](https://github.com/lmorg/murex/discussions) plus all who raise bug reports.

You rock!
