# v5.2

The v5.2 release introduces significant new features and improvements for those using Murex as their interactive shell. Many of these features are unique to Murex.

## Breaking Changes

* Change to experimental feature: all lambda variables now follow the `$.k` and `$.v` convention ([read more](https://murex.rocks/parser/lambda.html))

* Murex now requires Go compiler version 1.20 or above, however a C compiler is no longer required (though still supported)

* expressions that return a boolean will no longer write `true` nor `false` to stdout if it is followed by a boolean operator (`&&` or `||`). This is marked as a breaking change because some of Murex's tests had to be updated to reflect this update, however this change actually fixes a number of bugs around expectations for how boolean expressions should work

## Deprecation Warnings

Please read out [compatibility commitment](https://murex.rocks/compatibility.html) to understand how features are deprecated.

* the `?` pipe will be deprecated to make way for a the ternary operator. You can achieve the same result with `<err> <!out>`, eg `command <err> <!out> parameters... | next-command ...`
  
* experimental TTY buffer was removed. This was disabled by default, would create a slight slow down to rendering when enabled, created a few rendering glitches when enabled, added to the overall code complexity, and the primary use case for this no longer requires buffering anyway

## Features

Features marked as **EXPERIMENTAL** are provided without assurances of future breaking changes. All other features are considered stable as part of Murex's [compatibility commitment](https://murex.rocks/compatibility.html).

* `debug` builtin now supports `{ ... }` blocks ([read more](https://murex.rocks/commands/debug.html))

* new flags for `count`: `--sum` / `-s` and `--sum-strict`

* Lambda support for arrays and objects re-written and now considered stable ([read more](https://murex.rocks/parser/lambda.html))

* `f9` command line preview added -- this feature allows you to quickly build and test pipelines that might otherwise require iterating on trial and error to get right

* `f1` autocomplete preview is no longer considered experimental. Several bug fixes included

* new pipe: `pty`. This behaves similarly to a regular pipe except it creates a pseudo-TTY

* `f1` preview now includes cheat sheets from https://cheat.sh/

* job control: builtins can now be stopped via `^z` ([issue #716](https://github.com/lmorg/murex/issues/716))

* `docgen` has seen several new features added to improve the ease of writing documentation for Murex

## Bug Fixes

* readline: fixed regression bug introduced in preview release where vim keys wouldn't write their updated state to the terminal

* `f1` preview now resets the cursor position correctly when closed

* `f1` preview has had autocomplete parameters rewritten to jump to the right `man` page flag more precisely

* `f1` preview scrolling had an off-by-one error resulting in the last line sometimes getting cropped

* shebang (`#!/path/to/murex`) scripts should be loaded into a module namespace. This fixes module scoped config ([read more](https://github.com/lmorg/murex/discussions/756))

* command lines passed via `-c` flag (eg `murex -c "out hello world"`) are also loaded into a module namespace

* readline: trim whitespace before walking history
  
* recommended optional builtins are now opt-out -- this is to make it easier to work with 3rd party package maintainers

* job control: bug fixes around when to show and hide the interactive prompt ([issue #716](https://github.com/lmorg/murex/issues/716))

* job control: processes invoked via `bg {...}` now support being brought to the foreground via `fg` (this could be argued as a new feature) ([issue #716](https://github.com/lmorg/murex/issues/716))

* error handling added to `get-type` ([read more](https://murex.rocks/commands/get-type.html))

* boolean expressions, eg `2+3==5` now work with boolean operators (`&&`, `||`). eg `$USER == "bob" && out "Hello Bob"`.
  
## Special Thanks

Special thank yous for this release goes to [tiymat](https://github.com/tiymat) for their bug fixes and everyone in the discussions group for raising bug reports and design discussions.

You rock!

<hr>

Published: 18.11.2023 at 20:59

## See Also

* [Contributing](../Murex/CONTRIBUTING.md):
  Guide to contributing to Murex
* [Install](../Murex/INSTALL.md):
  Installation instructions
* [Job Control](../user-guide/job-control.md):
  How to manage jobs with Murex
* [Terminal Hotkeys](../user-guide/terminal-keys.md):
  A list of all the terminal hotkeys and their uses
* [`[{ Lambda }]`](../parser/lambda.md):
  Iterate through structured data
* [`bg`](../commands/bg.md):
  Run processes in the background
* [`count`](../commands/count.md):
  Count items in a map, list or array
* [`debug`](../commands/debug.md):
  Debugging information
* [`fg`](../commands/fg.md):
  Sends a background process into the foreground

<hr/>

This document was generated from [gen/changelog/v5.2_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/changelog/v5.2_doc.yaml).